/*
 * Copyright The async-profiler authors
 * SPDX-License-Identifier: Apache-2.0
 */

package test.api;

import one.profiler.test.Output;
import one.profiler.test.Test;
import one.profiler.test.TestProcess;

public class ApiTests {

    @Test(mainClass = DumpCollapsed.class, output = true)
    public void flat(TestProcess p) throws Exception {
        Output out = p.waitForExit(TestProcess.STDOUT);
        assert out.contains("BusyLoops.method1;");
        assert out.contains("BusyLoops.method2;");
        assert out.contains("BusyLoops.method3;");
    }

    @Test(mainClass = DumpOtlp.class)
    public void otlp(TestProcess p) throws Exception {
        p.waitForExit();
        assert p.exitCode() == 0;
    }

    @Test(mainClass = StopResume.class, output = true)
    public void stopResume(TestProcess p) throws Exception {
        Output out = p.waitForExit(TestProcess.STDOUT);
        assert !out.contains("BusyLoops.method1");
        assert out.contains("BusyLoops.method2");
        assert !out.contains("BusyLoops.method3");
    }

    @Test(mainClass = MetricsTest.class)
    public void metrics(TestProcess p) throws Exception {
        p.waitForExit();
        assert p.exitCode() == 0;
    }

    @Test(
        mainClass = JavaAgent.class,
        output = true,
        jvmArgs = "-javaagent:build/jar/async-profiler.jar=start,event=cpu,interval=1ms,file=%f.collapsed"
    )
    public void javaAgent(TestProcess p) throws Exception {
        Output out = p.waitForExit(TestProcess.STDOUT);
        assert p.exitCode() == 0;
        assert out.contains("async-profiler version: \\d+");
        Output profile = p.readFile("%f");
        assert profile.contains("BusyLoops.method1;");
        assert profile.contains("BusyLoops.method2;");
        assert profile.contains("BusyLoops.method3;");
    }
}
