// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by the FlatBuffers compiler. DO NOT EDIT.

package flatbuf

import "strconv"

/// ----------------------------------------------------------------------
/// The root Message type
/// This union enables us to easily send different message types without
/// redundant storage, and in the future we can easily add new message types.
///
/// Arrow implementations do not need to implement all of the message types,
/// which may include experimental metadata types. For maximum compatibility,
/// it is best to send data using RecordBatch
type MessageHeader byte

const (
	MessageHeaderNONE            MessageHeader = 0
	MessageHeaderSchema          MessageHeader = 1
	MessageHeaderDictionaryBatch MessageHeader = 2
	MessageHeaderRecordBatch     MessageHeader = 3
	MessageHeaderTensor          MessageHeader = 4
	MessageHeaderSparseTensor    MessageHeader = 5
)

var EnumNamesMessageHeader = map[MessageHeader]string{
	MessageHeaderNONE:            "NONE",
	MessageHeaderSchema:          "Schema",
	MessageHeaderDictionaryBatch: "DictionaryBatch",
	MessageHeaderRecordBatch:     "RecordBatch",
	MessageHeaderTensor:          "Tensor",
	MessageHeaderSparseTensor:    "SparseTensor",
}

var EnumValuesMessageHeader = map[string]MessageHeader{
	"NONE":            MessageHeaderNONE,
	"Schema":          MessageHeaderSchema,
	"DictionaryBatch": MessageHeaderDictionaryBatch,
	"RecordBatch":     MessageHeaderRecordBatch,
	"Tensor":          MessageHeaderTensor,
	"SparseTensor":    MessageHeaderSparseTensor,
}

func (v MessageHeader) String() string {
	if s, ok := EnumNamesMessageHeader[v]; ok {
		return s
	}
	return "MessageHeader(" + strconv.FormatInt(int64(v), 10) + ")"
}
