/*===- TableGen'erated file -------------------------------------*- C++ -*-===*\
|*                                                                            *|
|* Global Instruction Selector for the RISCV target                           *|
|*                                                                            *|
|* Automatically generated file, do not edit!                                 *|
|*                                                                            *|
\*===----------------------------------------------------------------------===*/

#ifdef GET_GLOBALISEL_PREDICATE_BITSET
const unsigned MAX_SUBTARGET_PREDICATES = 35;
using PredicateBitset = llvm::PredicateBitsetImpl<MAX_SUBTARGET_PREDICATES>;
#endif // ifdef GET_GLOBALISEL_PREDICATE_BITSET

#ifdef GET_GLOBALISEL_TEMPORARIES_DECL
  mutable MatcherState State;
  typedef ComplexRendererFns(RISCVInstructionSelector::*ComplexMatcherMemFn)(MachineOperand &) const;
  typedef void(RISCVInstructionSelector::*CustomRendererFn)(MachineInstrBuilder &, const MachineInstr &, int) const;
  const ISelInfoTy<PredicateBitset, ComplexMatcherMemFn, CustomRendererFn> ISelInfo;
  static RISCVInstructionSelector::ComplexMatcherMemFn ComplexPredicateFns[];
  static RISCVInstructionSelector::CustomRendererFn CustomRenderers[];
  bool testImmPredicate_I64(unsigned PredicateID, int64_t Imm) const override;
  bool testImmPredicate_APInt(unsigned PredicateID, const APInt &Imm) const override;
  bool testImmPredicate_APFloat(unsigned PredicateID, const APFloat &Imm) const override;
  const int64_t *getMatchTable() const override;
  bool testMIPredicate_MI(unsigned PredicateID, const MachineInstr &MI, const std::array<const MachineOperand *, 3> &Operands) const override;
#endif // ifdef GET_GLOBALISEL_TEMPORARIES_DECL

#ifdef GET_GLOBALISEL_TEMPORARIES_INIT
, State(0),
ISelInfo(TypeObjects, NumTypeObjects, FeatureBitsets, ComplexPredicateFns, CustomRenderers)
#endif // ifdef GET_GLOBALISEL_TEMPORARIES_INIT

#ifdef GET_GLOBALISEL_IMPL
// Bits for subtarget features that participate in instruction matching.
enum SubtargetFeatureBits : uint8_t {
  Feature_HasStdExtMBit = 13,
  Feature_HasStdExtMOrZmmulBit = 12,
  Feature_HasStdExtABit = 15,
  Feature_HasStdExtFBit = 4,
  Feature_HasStdExtDBit = 5,
  Feature_HasStdExtZfhminBit = 17,
  Feature_HasStdExtZfhBit = 7,
  Feature_NoStdExtZfhBit = 18,
  Feature_HasStdExtZfhOrZfhminBit = 16,
  Feature_HasStdExtCBit = 9,
  Feature_HasStdExtZbaBit = 25,
  Feature_NotHasStdExtZbaBit = 11,
  Feature_HasStdExtZbbBit = 23,
  Feature_HasStdExtZbcBit = 27,
  Feature_HasStdExtZbsBit = 22,
  Feature_HasStdExtZbkbBit = 24,
  Feature_HasStdExtZbkxBit = 28,
  Feature_HasStdExtZbbOrZbkbBit = 21,
  Feature_HasStdExtZbcOrZbkcBit = 26,
  Feature_HasStdExtZkndBit = 29,
  Feature_HasStdExtZkneBit = 31,
  Feature_HasStdExtZkndOrZkneBit = 30,
  Feature_HasStdExtZknhBit = 32,
  Feature_HasStdExtZksedBit = 33,
  Feature_HasStdExtZkshBit = 34,
  Feature_HasVInstructionsBit = 6,
  Feature_HasVInstructionsAnyFBit = 8,
  Feature_HasVendorXVentanaCondOpsBit = 19,
  Feature_HasVendorXTHeadVdotBit = 20,
  Feature_IsRV64Bit = 3,
  Feature_IsRV32Bit = 2,
  Feature_HasShortForwardBranchOptBit = 0,
  Feature_NoShortForwardBranchOptBit = 1,
  Feature_HasAtomicLdStBit = 14,
  Feature_OptForMinSizeBit = 10,
};

PredicateBitset RISCVInstructionSelector::
computeAvailableModuleFeatures(const RISCVSubtarget *Subtarget) const {
  PredicateBitset Features;
  if (Subtarget->hasStdExtM())
    Features.set(Feature_HasStdExtMBit);
  if (Subtarget->hasStdExtM() || Subtarget->hasStdExtZmmul())
    Features.set(Feature_HasStdExtMOrZmmulBit);
  if (Subtarget->hasStdExtA())
    Features.set(Feature_HasStdExtABit);
  if (Subtarget->hasStdExtF())
    Features.set(Feature_HasStdExtFBit);
  if (Subtarget->hasStdExtD())
    Features.set(Feature_HasStdExtDBit);
  if (Subtarget->hasStdExtZfhmin())
    Features.set(Feature_HasStdExtZfhminBit);
  if (Subtarget->hasStdExtZfh())
    Features.set(Feature_HasStdExtZfhBit);
  if (!Subtarget->hasStdExtZfh())
    Features.set(Feature_NoStdExtZfhBit);
  if (Subtarget->hasStdExtZfh() || Subtarget->hasStdExtZfhmin())
    Features.set(Feature_HasStdExtZfhOrZfhminBit);
  if (Subtarget->hasStdExtC())
    Features.set(Feature_HasStdExtCBit);
  if (Subtarget->hasStdExtZba())
    Features.set(Feature_HasStdExtZbaBit);
  if (!Subtarget->hasStdExtZba())
    Features.set(Feature_NotHasStdExtZbaBit);
  if (Subtarget->hasStdExtZbb())
    Features.set(Feature_HasStdExtZbbBit);
  if (Subtarget->hasStdExtZbc())
    Features.set(Feature_HasStdExtZbcBit);
  if (Subtarget->hasStdExtZbs())
    Features.set(Feature_HasStdExtZbsBit);
  if (Subtarget->hasStdExtZbkb())
    Features.set(Feature_HasStdExtZbkbBit);
  if (Subtarget->hasStdExtZbkx())
    Features.set(Feature_HasStdExtZbkxBit);
  if (Subtarget->hasStdExtZbb() || Subtarget->hasStdExtZbkb())
    Features.set(Feature_HasStdExtZbbOrZbkbBit);
  if (Subtarget->hasStdExtZbc() || Subtarget->hasStdExtZbkc())
    Features.set(Feature_HasStdExtZbcOrZbkcBit);
  if (Subtarget->hasStdExtZknd())
    Features.set(Feature_HasStdExtZkndBit);
  if (Subtarget->hasStdExtZkne())
    Features.set(Feature_HasStdExtZkneBit);
  if (Subtarget->hasStdExtZknd() || Subtarget->hasStdExtZkne())
    Features.set(Feature_HasStdExtZkndOrZkneBit);
  if (Subtarget->hasStdExtZknh())
    Features.set(Feature_HasStdExtZknhBit);
  if (Subtarget->hasStdExtZksed())
    Features.set(Feature_HasStdExtZksedBit);
  if (Subtarget->hasStdExtZksh())
    Features.set(Feature_HasStdExtZkshBit);
  if (Subtarget->hasVInstructions())
    Features.set(Feature_HasVInstructionsBit);
  if (Subtarget->hasVInstructionsAnyF())
    Features.set(Feature_HasVInstructionsAnyFBit);
  if (Subtarget->hasVendorXVentanaCondOps())
    Features.set(Feature_HasVendorXVentanaCondOpsBit);
  if (Subtarget->hasVendorXTHeadVdot())
    Features.set(Feature_HasVendorXTHeadVdotBit);
  if (Subtarget->is64Bit())
    Features.set(Feature_IsRV64Bit);
  if (!Subtarget->is64Bit())
    Features.set(Feature_IsRV32Bit);
  if (Subtarget->hasShortForwardBranchOpt())
    Features.set(Feature_HasShortForwardBranchOptBit);
  if (!Subtarget->hasShortForwardBranchOpt())
    Features.set(Feature_NoShortForwardBranchOptBit);
  if (Subtarget->hasStdExtA() || Subtarget->hasForcedAtomics())
    Features.set(Feature_HasAtomicLdStBit);
  if (MF ? MF->getFunction().hasMinSize() : false)
    Features.set(Feature_OptForMinSizeBit);
  return Features;
}

void RISCVInstructionSelector::setupGeneratedPerFunctionState(MachineFunction &MF) {
  AvailableFunctionFeatures = computeAvailableFunctionFeatures((const RISCVSubtarget *)&MF.getSubtarget(), &MF);
}
PredicateBitset RISCVInstructionSelector::
computeAvailableFunctionFeatures(const RISCVSubtarget *Subtarget, const MachineFunction *MF) const {
  PredicateBitset Features;
  return Features;
}

// LLT Objects.
enum {
  GILLT_s16,
  GILLT_s32,
  GILLT_s64,
  GILLT_nxv1s1,
  GILLT_nxv1s8,
  GILLT_nxv1s16,
  GILLT_nxv1s32,
  GILLT_nxv1s64,
  GILLT_nxv2s1,
  GILLT_nxv2s8,
  GILLT_nxv2s16,
  GILLT_nxv2s32,
  GILLT_nxv2s64,
  GILLT_nxv4s1,
  GILLT_nxv4s8,
  GILLT_nxv4s16,
  GILLT_nxv4s32,
  GILLT_nxv4s64,
  GILLT_nxv8s1,
  GILLT_nxv8s8,
  GILLT_nxv8s16,
  GILLT_nxv8s32,
  GILLT_nxv8s64,
  GILLT_nxv16s1,
  GILLT_nxv16s8,
  GILLT_nxv16s16,
  GILLT_nxv16s32,
  GILLT_nxv32s1,
  GILLT_nxv32s8,
  GILLT_nxv32s16,
  GILLT_nxv64s1,
  GILLT_nxv64s8,
};
const static size_t NumTypeObjects = 32;
const static LLT TypeObjects[] = {
  LLT::scalar(16),
  LLT::scalar(32),
  LLT::scalar(64),
  LLT::vector(ElementCount::getScalable(1), 1),
  LLT::vector(ElementCount::getScalable(1), 8),
  LLT::vector(ElementCount::getScalable(1), 16),
  LLT::vector(ElementCount::getScalable(1), 32),
  LLT::vector(ElementCount::getScalable(1), 64),
  LLT::vector(ElementCount::getScalable(2), 1),
  LLT::vector(ElementCount::getScalable(2), 8),
  LLT::vector(ElementCount::getScalable(2), 16),
  LLT::vector(ElementCount::getScalable(2), 32),
  LLT::vector(ElementCount::getScalable(2), 64),
  LLT::vector(ElementCount::getScalable(4), 1),
  LLT::vector(ElementCount::getScalable(4), 8),
  LLT::vector(ElementCount::getScalable(4), 16),
  LLT::vector(ElementCount::getScalable(4), 32),
  LLT::vector(ElementCount::getScalable(4), 64),
  LLT::vector(ElementCount::getScalable(8), 1),
  LLT::vector(ElementCount::getScalable(8), 8),
  LLT::vector(ElementCount::getScalable(8), 16),
  LLT::vector(ElementCount::getScalable(8), 32),
  LLT::vector(ElementCount::getScalable(8), 64),
  LLT::vector(ElementCount::getScalable(16), 1),
  LLT::vector(ElementCount::getScalable(16), 8),
  LLT::vector(ElementCount::getScalable(16), 16),
  LLT::vector(ElementCount::getScalable(16), 32),
  LLT::vector(ElementCount::getScalable(32), 1),
  LLT::vector(ElementCount::getScalable(32), 8),
  LLT::vector(ElementCount::getScalable(32), 16),
  LLT::vector(ElementCount::getScalable(64), 1),
  LLT::vector(ElementCount::getScalable(64), 8),
};

// Feature bitsets.
enum {
  GIFBS_Invalid,
  GIFBS_HasStdExtA,
  GIFBS_HasStdExtD,
  GIFBS_HasStdExtF,
  GIFBS_HasStdExtM,
  GIFBS_HasStdExtMOrZmmul,
  GIFBS_HasStdExtZbb,
  GIFBS_HasStdExtZbbOrZbkb,
  GIFBS_HasStdExtZbc,
  GIFBS_HasStdExtZbcOrZbkc,
  GIFBS_HasStdExtZbkx,
  GIFBS_HasStdExtZbs,
  GIFBS_HasStdExtZfh,
  GIFBS_HasStdExtZfhOrZfhmin,
  GIFBS_HasStdExtZknh,
  GIFBS_HasStdExtZksed,
  GIFBS_HasStdExtZksh,
  GIFBS_HasVInstructions,
  GIFBS_HasVInstructionsAnyF,
  GIFBS_IsRV64,
  GIFBS_HasStdExtA_IsRV64,
  GIFBS_HasStdExtD_HasStdExtZfhOrZfhmin,
  GIFBS_HasStdExtD_IsRV32,
  GIFBS_HasStdExtD_IsRV64,
  GIFBS_HasStdExtF_IsRV32,
  GIFBS_HasStdExtZba_IsRV64,
  GIFBS_HasStdExtZbb_IsRV32,
  GIFBS_HasStdExtZbb_IsRV64,
  GIFBS_HasStdExtZbbOrZbkb_IsRV32,
  GIFBS_HasStdExtZbbOrZbkb_IsRV64,
  GIFBS_HasStdExtZknd_IsRV32,
  GIFBS_HasStdExtZknd_IsRV64,
  GIFBS_HasStdExtZkndOrZkne_IsRV64,
  GIFBS_HasStdExtZkne_IsRV32,
  GIFBS_HasStdExtZkne_IsRV64,
  GIFBS_HasStdExtZknh_IsRV32,
  GIFBS_HasStdExtZknh_IsRV64,
  GIFBS_HasVendorXVentanaCondOps_IsRV64,
  GIFBS_IsRV64_NotHasStdExtZba,
  GIFBS_HasStdExtMOrZmmul_IsRV64_NotHasStdExtZba,
};
const static PredicateBitset FeatureBitsets[] {
  {}, // GIFBS_Invalid
  {Feature_HasStdExtABit, },
  {Feature_HasStdExtDBit, },
  {Feature_HasStdExtFBit, },
  {Feature_HasStdExtMBit, },
  {Feature_HasStdExtMOrZmmulBit, },
  {Feature_HasStdExtZbbBit, },
  {Feature_HasStdExtZbbOrZbkbBit, },
  {Feature_HasStdExtZbcBit, },
  {Feature_HasStdExtZbcOrZbkcBit, },
  {Feature_HasStdExtZbkxBit, },
  {Feature_HasStdExtZbsBit, },
  {Feature_HasStdExtZfhBit, },
  {Feature_HasStdExtZfhOrZfhminBit, },
  {Feature_HasStdExtZknhBit, },
  {Feature_HasStdExtZksedBit, },
  {Feature_HasStdExtZkshBit, },
  {Feature_HasVInstructionsBit, },
  {Feature_HasVInstructionsAnyFBit, },
  {Feature_IsRV64Bit, },
  {Feature_HasStdExtABit, Feature_IsRV64Bit, },
  {Feature_HasStdExtDBit, Feature_HasStdExtZfhOrZfhminBit, },
  {Feature_HasStdExtDBit, Feature_IsRV32Bit, },
  {Feature_HasStdExtDBit, Feature_IsRV64Bit, },
  {Feature_HasStdExtFBit, Feature_IsRV32Bit, },
  {Feature_HasStdExtZbaBit, Feature_IsRV64Bit, },
  {Feature_HasStdExtZbbBit, Feature_IsRV32Bit, },
  {Feature_HasStdExtZbbBit, Feature_IsRV64Bit, },
  {Feature_HasStdExtZbbOrZbkbBit, Feature_IsRV32Bit, },
  {Feature_HasStdExtZbbOrZbkbBit, Feature_IsRV64Bit, },
  {Feature_HasStdExtZkndBit, Feature_IsRV32Bit, },
  {Feature_HasStdExtZkndBit, Feature_IsRV64Bit, },
  {Feature_HasStdExtZkndOrZkneBit, Feature_IsRV64Bit, },
  {Feature_HasStdExtZkneBit, Feature_IsRV32Bit, },
  {Feature_HasStdExtZkneBit, Feature_IsRV64Bit, },
  {Feature_HasStdExtZknhBit, Feature_IsRV32Bit, },
  {Feature_HasStdExtZknhBit, Feature_IsRV64Bit, },
  {Feature_HasVendorXVentanaCondOpsBit, Feature_IsRV64Bit, },
  {Feature_IsRV64Bit, Feature_NotHasStdExtZbaBit, },
  {Feature_HasStdExtMOrZmmulBit, Feature_IsRV64Bit, Feature_NotHasStdExtZbaBit, },
};

// ComplexPattern predicates.
enum {
  GICP_Invalid,
};
// See constructor for table contents

// PatFrag predicates.
enum {
  GIPFP_I64_Predicate_BCLRMask = GIPFP_I64_Invalid + 1,
  GIPFP_I64_Predicate_SingleBitSetMask,
  GIPFP_I64_Predicate_byteselect,
  GIPFP_I64_Predicate_c_lui_imm,
  GIPFP_I64_Predicate_immzero,
  GIPFP_I64_Predicate_rnum,
  GIPFP_I64_Predicate_shfl_uimm,
  GIPFP_I64_Predicate_simm10_lsb0000nonzero,
  GIPFP_I64_Predicate_simm12,
  GIPFP_I64_Predicate_simm12_lsb0,
  GIPFP_I64_Predicate_simm12_lsb00000,
  GIPFP_I64_Predicate_simm12_no6,
  GIPFP_I64_Predicate_simm12_plus1,
  GIPFP_I64_Predicate_simm5,
  GIPFP_I64_Predicate_simm5_plus1,
  GIPFP_I64_Predicate_simm5_plus1_nonzero,
  GIPFP_I64_Predicate_simm6,
  GIPFP_I64_Predicate_simm6nonzero,
  GIPFP_I64_Predicate_simm9_lsb0,
  GIPFP_I64_Predicate_u32simm12,
  GIPFP_I64_Predicate_uimm10_lsb00nonzero,
  GIPFP_I64_Predicate_uimm5,
  GIPFP_I64_Predicate_uimm6gt32,
  GIPFP_I64_Predicate_uimm7_lsb00,
  GIPFP_I64_Predicate_uimm8_lsb00,
  GIPFP_I64_Predicate_uimm8_lsb000,
  GIPFP_I64_Predicate_uimm9_lsb000,
  GIPFP_I64_Predicate_uimmlog2xlen,
  GIPFP_I64_Predicate_uimmlog2xlennonzero,
};
bool RISCVInstructionSelector::testImmPredicate_I64(unsigned PredicateID, int64_t Imm) const {
  switch (PredicateID) {
  case GIPFP_I64_Predicate_BCLRMask: {
    
  if (Subtarget->is64Bit())
    return !isInt<12>(Imm) && isPowerOf2_64(~Imm);
  return !isInt<12>(Imm) && isPowerOf2_32(~Imm);

    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_SingleBitSetMask: {
    
  if (Subtarget->is64Bit())
    return !isInt<12>(Imm) && isPowerOf2_64(Imm);
  return !isInt<12>(Imm) && isPowerOf2_32(Imm);

    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_byteselect: {
    return isUInt<2>(Imm);
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_c_lui_imm: {
    return (Imm != 0) &&
                                 (isUInt<5>(Imm) ||
                                  (Imm >= 0xfffe0 && Imm <= 0xfffff));
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_immzero: {
    return (Imm == 0);
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_rnum: {
    return (Imm >= 0 && Imm <= 10);
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_shfl_uimm: {
    
  if (Subtarget->is64Bit())
    return isUInt<5>(Imm);
  return isUInt<4>(Imm);

    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_simm10_lsb0000nonzero: {
    return (Imm != 0) && isShiftedInt<6, 4>(Imm);
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_simm12: {
    return isInt<12>(Imm);
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_simm12_lsb0: {
    return isShiftedInt<11, 1>(Imm);
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_simm12_lsb00000: {
    return isShiftedInt<7, 5>(Imm);
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_simm12_no6: {
    
  return isInt<12>(Imm) && !isInt<6>(Imm) && isInt<12>(-Imm);
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_simm12_plus1: {
    return (isInt<12>(Imm) && Imm != -2048) || Imm == 2048;
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_simm5: {
    return isInt<5>(Imm);
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_simm5_plus1: {
    return (isInt<5>(Imm) && Imm != -16) || Imm == 16;
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_simm5_plus1_nonzero: {
    return Imm != 0 && ((isInt<5>(Imm) && Imm != -16) || Imm == 16);
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_simm6: {
    return isInt<6>(Imm);
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_simm6nonzero: {
    return (Imm != 0) && isInt<6>(Imm);
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_simm9_lsb0: {
    return isShiftedInt<8, 1>(Imm);
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_u32simm12: {
    
  return isUInt<32>(Imm) && isInt<12>(SignExtend64<32>(Imm));

    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_uimm10_lsb00nonzero: {
    return isShiftedUInt<8, 2>(Imm) && (Imm != 0);
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_uimm5: {
    return isUInt<5>(Imm);
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_uimm6gt32: {
    
  return isUInt<6>(Imm) && Imm > 32;

    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_uimm7_lsb00: {
    return isShiftedUInt<5, 2>(Imm);
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_uimm8_lsb00: {
    return isShiftedUInt<6, 2>(Imm);
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_uimm8_lsb000: {
    return isShiftedUInt<5, 3>(Imm);
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_uimm9_lsb000: {
    return isShiftedUInt<6, 3>(Imm);
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_uimmlog2xlen: {
    
  if (Subtarget->is64Bit())
    return isUInt<6>(Imm);
  return isUInt<5>(Imm);

    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_uimmlog2xlennonzero: {
    
  if (Subtarget->is64Bit())
    return isUInt<6>(Imm) && (Imm != 0);
  return isUInt<5>(Imm) && (Imm != 0);

    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  }
  llvm_unreachable("Unknown predicate");
  return false;
}
bool RISCVInstructionSelector::testImmPredicate_APFloat(unsigned PredicateID, const APFloat & Imm) const {
  llvm_unreachable("Unknown predicate");
  return false;
}
bool RISCVInstructionSelector::testImmPredicate_APInt(unsigned PredicateID, const APInt & Imm) const {
  llvm_unreachable("Unknown predicate");
  return false;
}
bool RISCVInstructionSelector::testMIPredicate_MI(unsigned PredicateID, const MachineInstr & MI, const std::array<const MachineOperand *, 3> &Operands) const {
  const MachineFunction &MF = *MI.getParent()->getParent();
  const MachineRegisterInfo &MRI = MF.getRegInfo();
  (void)MRI;
  llvm_unreachable("Unknown predicate");
  return false;
}

RISCVInstructionSelector::ComplexMatcherMemFn
RISCVInstructionSelector::ComplexPredicateFns[] = {
  nullptr, // GICP_Invalid
};

// Custom renderers.
enum {
  GICR_Invalid,
};
RISCVInstructionSelector::CustomRendererFn
RISCVInstructionSelector::CustomRenderers[] = {
  nullptr, // GICR_Invalid
};

bool RISCVInstructionSelector::selectImpl(MachineInstr &I, CodeGenCoverage &CoverageInfo) const {
  MachineFunction &MF = *I.getParent()->getParent();
  MachineRegisterInfo &MRI = MF.getRegInfo();
  const PredicateBitset AvailableFeatures = getAvailableFeatures();
  NewMIVector OutMIs;
  State.MIs.clear();
  State.MIs.push_back(&I);

  if (executeMatchTable(*this, OutMIs, State, ISelInfo, getMatchTable(), TII, MRI, TRI, RBI, AvailableFeatures, CoverageInfo)) {
    return true;
  }

  return false;
}

const int64_t *RISCVInstructionSelector::getMatchTable() const {
  constexpr static int64_t MatchTable0[] = {
    GIM_SwitchOpcode, /*MI*/0, /*[*/46, 227, /*)*//*default:*//*Label 73*/ 151124,
    /*TargetOpcode::G_ADD*//*Label 0*/ 186,
    /*TargetOpcode::G_SUB*//*Label 1*/ 2204,
    /*TargetOpcode::G_MUL*//*Label 2*/ 4150,
    /*TargetOpcode::G_SDIV*//*Label 3*/ 6215,
    /*TargetOpcode::G_UDIV*//*Label 4*/ 8165,
    /*TargetOpcode::G_SREM*//*Label 5*/ 10115,
    /*TargetOpcode::G_UREM*//*Label 6*/ 12065, 0, 0,
    /*TargetOpcode::G_AND*//*Label 7*/ 14015,
    /*TargetOpcode::G_OR*//*Label 8*/ 17311,
    /*TargetOpcode::G_XOR*//*Label 9*/ 20137, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    /*TargetOpcode::G_BITCAST*//*Label 10*/ 23069, 0, 0, 0, 0, 0, 0,
    /*TargetOpcode::G_READCYCLECOUNTER*//*Label 11*/ 23170,
    /*TargetOpcode::G_LOAD*//*Label 12*/ 23202, 0, 0, 0, 0, 0,
    /*TargetOpcode::G_STORE*//*Label 13*/ 25953, 0, 0,
    /*TargetOpcode::G_ATOMIC_CMPXCHG*//*Label 14*/ 28588,
    /*TargetOpcode::G_ATOMICRMW_XCHG*//*Label 15*/ 30001,
    /*TargetOpcode::G_ATOMICRMW_ADD*//*Label 16*/ 30706,
    /*TargetOpcode::G_ATOMICRMW_SUB*//*Label 17*/ 31411,
    /*TargetOpcode::G_ATOMICRMW_AND*//*Label 18*/ 32485,
    /*TargetOpcode::G_ATOMICRMW_NAND*//*Label 19*/ 33190,
    /*TargetOpcode::G_ATOMICRMW_OR*//*Label 20*/ 34114,
    /*TargetOpcode::G_ATOMICRMW_XOR*//*Label 21*/ 34819,
    /*TargetOpcode::G_ATOMICRMW_MAX*//*Label 22*/ 35524,
    /*TargetOpcode::G_ATOMICRMW_MIN*//*Label 23*/ 36229,
    /*TargetOpcode::G_ATOMICRMW_UMAX*//*Label 24*/ 36934,
    /*TargetOpcode::G_ATOMICRMW_UMIN*//*Label 25*/ 37639, 0, 0, 0, 0, 0, 0,
    /*TargetOpcode::G_FENCE*//*Label 26*/ 38344, 0, 0, 0,
    /*TargetOpcode::G_INTRINSIC*//*Label 27*/ 38527,
    /*TargetOpcode::G_INTRINSIC_W_SIDE_EFFECTS*//*Label 28*/ 40810,
    /*TargetOpcode::G_ANYEXT*//*Label 29*/ 42545, 0, 0, 0, 0, 0,
    /*TargetOpcode::G_SEXT*//*Label 30*/ 44666, 0,
    /*TargetOpcode::G_ZEXT*//*Label 31*/ 46787,
    /*TargetOpcode::G_SHL*//*Label 32*/ 48908,
    /*TargetOpcode::G_LSHR*//*Label 33*/ 50957,
    /*TargetOpcode::G_ASHR*//*Label 34*/ 53006, 0, 0,
    /*TargetOpcode::G_ROTR*//*Label 35*/ 54992, 0,
    /*TargetOpcode::G_ICMP*//*Label 36*/ 55105,
    /*TargetOpcode::G_FCMP*//*Label 37*/ 79640,
    /*TargetOpcode::G_SELECT*//*Label 38*/ 86077, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    /*TargetOpcode::G_UMULH*//*Label 39*/ 87691,
    /*TargetOpcode::G_SMULH*//*Label 40*/ 89641,
    /*TargetOpcode::G_UADDSAT*//*Label 41*/ 91591,
    /*TargetOpcode::G_SADDSAT*//*Label 42*/ 93474,
    /*TargetOpcode::G_USUBSAT*//*Label 43*/ 95357,
    /*TargetOpcode::G_SSUBSAT*//*Label 44*/ 97240, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    /*TargetOpcode::G_FADD*//*Label 45*/ 99123,
    /*TargetOpcode::G_FSUB*//*Label 46*/ 100415,
    /*TargetOpcode::G_FMUL*//*Label 47*/ 101707,
    /*TargetOpcode::G_FMA*//*Label 48*/ 102999, 0,
    /*TargetOpcode::G_FDIV*//*Label 49*/ 117622, 0, 0, 0, 0, 0, 0, 0, 0,
    /*TargetOpcode::G_FNEG*//*Label 50*/ 118914,
    /*TargetOpcode::G_FPEXT*//*Label 51*/ 120086,
    /*TargetOpcode::G_FPTRUNC*//*Label 52*/ 120166,
    /*TargetOpcode::G_FPTOSI*//*Label 53*/ 121014,
    /*TargetOpcode::G_FPTOUI*//*Label 54*/ 124044,
    /*TargetOpcode::G_SITOFP*//*Label 55*/ 127074,
    /*TargetOpcode::G_UITOFP*//*Label 56*/ 130147,
    /*TargetOpcode::G_FABS*//*Label 57*/ 133220,
    /*TargetOpcode::G_FCOPYSIGN*//*Label 58*/ 134392, 0, 0,
    /*TargetOpcode::G_FMINNUM*//*Label 59*/ 137154,
    /*TargetOpcode::G_FMAXNUM*//*Label 60*/ 138446, 0, 0, 0, 0, 0, 0,
    /*TargetOpcode::G_SMIN*//*Label 61*/ 139738,
    /*TargetOpcode::G_SMAX*//*Label 62*/ 141688,
    /*TargetOpcode::G_UMIN*//*Label 63*/ 143638,
    /*TargetOpcode::G_UMAX*//*Label 64*/ 145588, 0, 0, 0,
    /*TargetOpcode::G_BR*//*Label 65*/ 147538, 0, 0, 0, 0,
    /*TargetOpcode::G_CTTZ*//*Label 66*/ 147551, 0,
    /*TargetOpcode::G_CTLZ*//*Label 67*/ 147608, 0,
    /*TargetOpcode::G_CTPOP*//*Label 68*/ 147665,
    /*TargetOpcode::G_BSWAP*//*Label 69*/ 147722, 0, 0, 0, 0,
    /*TargetOpcode::G_FSQRT*//*Label 70*/ 147779, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    /*TargetOpcode::G_STRICT_FMA*//*Label 71*/ 149022,
    /*TargetOpcode::G_STRICT_FSQRT*//*Label 72*/ 150928,
    // Label 0: @186
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/1, 32, /*)*//*default:*//*Label 98*/ 2203,
    /*GILLT_s32*//*Label 74*/ 223,
    /*GILLT_s64*//*Label 75*/ 289, 0,
    /*GILLT_nxv1s8*//*Label 76*/ 355,
    /*GILLT_nxv1s16*//*Label 77*/ 439,
    /*GILLT_nxv1s32*//*Label 78*/ 523,
    /*GILLT_nxv1s64*//*Label 79*/ 607, 0,
    /*GILLT_nxv2s8*//*Label 80*/ 691,
    /*GILLT_nxv2s16*//*Label 81*/ 775,
    /*GILLT_nxv2s32*//*Label 82*/ 859,
    /*GILLT_nxv2s64*//*Label 83*/ 943, 0,
    /*GILLT_nxv4s8*//*Label 84*/ 1027,
    /*GILLT_nxv4s16*//*Label 85*/ 1111,
    /*GILLT_nxv4s32*//*Label 86*/ 1195,
    /*GILLT_nxv4s64*//*Label 87*/ 1279, 0,
    /*GILLT_nxv8s8*//*Label 88*/ 1363,
    /*GILLT_nxv8s16*//*Label 89*/ 1447,
    /*GILLT_nxv8s32*//*Label 90*/ 1531,
    /*GILLT_nxv8s64*//*Label 91*/ 1615, 0,
    /*GILLT_nxv16s8*//*Label 92*/ 1699,
    /*GILLT_nxv16s16*//*Label 93*/ 1783,
    /*GILLT_nxv16s32*//*Label 94*/ 1867, 0,
    /*GILLT_nxv32s8*//*Label 95*/ 1951,
    /*GILLT_nxv32s16*//*Label 96*/ 2035, 0,
    /*GILLT_nxv64s8*//*Label 97*/ 2119,
    // Label 74: @223
    GIM_Try, /*On fail goto*//*Label 99*/ 288,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
      GIM_Try, /*On fail goto*//*Label 100*/ 274, // Rule ID 59830 //
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIPFP_I64_Predicate_simm12,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[i32] } GPR:{ *:[i32] }:$rs1, (imm:{ *:[i32] })<<P:Predicate_simm12>>:$imm)  =>  (ADDI:{ *:[i32] } GPR:{ *:[i32] }:$rs1, (imm:{ *:[i32] })<<P:Predicate_simm12>>:$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::ADDI,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // imm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 59830,
        GIR_Done,
      // Label 100: @274
      GIM_Try, /*On fail goto*//*Label 101*/ 287, // Rule ID 59808 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (add:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)  =>  (ADD:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::ADD,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 59808,
        GIR_Done,
      // Label 101: @287
      GIM_Reject,
    // Label 99: @288
    GIM_Reject,
    // Label 75: @289
    GIM_Try, /*On fail goto*//*Label 102*/ 354,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
      GIM_Try, /*On fail goto*//*Label 103*/ 340, // Rule ID 59829 //
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIPFP_I64_Predicate_simm12,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[i64] } GPR:{ *:[i64] }:$rs1, (imm:{ *:[i64] })<<P:Predicate_simm12>>:$imm)  =>  (ADDI:{ *:[i64] } GPR:{ *:[i64] }:$rs1, (imm:{ *:[i64] })<<P:Predicate_simm12>>:$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::ADDI,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // imm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 59829,
        GIR_Done,
      // Label 103: @340
      GIM_Try, /*On fail goto*//*Label 104*/ 353, // Rule ID 59807 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (add:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)  =>  (ADD:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::ADD,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 59807,
        GIR_Done,
      // Label 104: @353
      GIM_Reject,
    // Label 102: @354
    GIM_Reject,
    // Label 76: @355
    GIM_Try, /*On fail goto*//*Label 105*/ 438,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv1s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv1s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 106*/ 407, // Rule ID 54937 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (add:{ *:[nxv1i8] } VR:{ *:[nxv1i8] }:$rs1, VR:{ *:[nxv1i8] }:$rs2)  =>  (PseudoVADD_VV_MF8:{ *:[nxv1i8] } VR:{ *:[nxv1i8] }:$rs1, VR:{ *:[nxv1i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVADD_VV_MF8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 54937,
        GIR_Done,
      // Label 106: @407
      GIM_Try, /*On fail goto*//*Label 107*/ 437, // Rule ID 54938 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (add:{ *:[nxv1i8] } VR:{ *:[nxv1i8] }:$rs1, VR:{ *:[nxv1i8] }:$rs2)  =>  (PseudoVADD_VV_MF8:{ *:[nxv1i8] } VR:{ *:[nxv1i8] }:$rs1, VR:{ *:[nxv1i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVADD_VV_MF8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 54938,
        GIR_Done,
      // Label 107: @437
      GIM_Reject,
    // Label 105: @438
    GIM_Reject,
    // Label 77: @439
    GIM_Try, /*On fail goto*//*Label 108*/ 522,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv1s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv1s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 109*/ 491, // Rule ID 55217 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (add:{ *:[nxv1i16] } VR:{ *:[nxv1i16] }:$rs1, VR:{ *:[nxv1i16] }:$rs2)  =>  (PseudoVADD_VV_MF4:{ *:[nxv1i16] } VR:{ *:[nxv1i16] }:$rs1, VR:{ *:[nxv1i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVADD_VV_MF4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 55217,
        GIR_Done,
      // Label 109: @491
      GIM_Try, /*On fail goto*//*Label 110*/ 521, // Rule ID 55218 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (add:{ *:[nxv1i16] } VR:{ *:[nxv1i16] }:$rs1, VR:{ *:[nxv1i16] }:$rs2)  =>  (PseudoVADD_VV_MF4:{ *:[nxv1i16] } VR:{ *:[nxv1i16] }:$rs1, VR:{ *:[nxv1i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVADD_VV_MF4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 55218,
        GIR_Done,
      // Label 110: @521
      GIM_Reject,
    // Label 108: @522
    GIM_Reject,
    // Label 78: @523
    GIM_Try, /*On fail goto*//*Label 111*/ 606,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv1s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv1s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 112*/ 575, // Rule ID 55225 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (add:{ *:[nxv1i32] } VR:{ *:[nxv1i32] }:$rs1, VR:{ *:[nxv1i32] }:$rs2)  =>  (PseudoVADD_VV_MF2:{ *:[nxv1i32] } VR:{ *:[nxv1i32] }:$rs1, VR:{ *:[nxv1i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVADD_VV_MF2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 55225,
        GIR_Done,
      // Label 112: @575
      GIM_Try, /*On fail goto*//*Label 113*/ 605, // Rule ID 55226 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (add:{ *:[nxv1i32] } VR:{ *:[nxv1i32] }:$rs1, VR:{ *:[nxv1i32] }:$rs2)  =>  (PseudoVADD_VV_MF2:{ *:[nxv1i32] } VR:{ *:[nxv1i32] }:$rs1, VR:{ *:[nxv1i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVADD_VV_MF2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 55226,
        GIR_Done,
      // Label 113: @605
      GIM_Reject,
    // Label 111: @606
    GIM_Reject,
    // Label 79: @607
    GIM_Try, /*On fail goto*//*Label 114*/ 690,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv1s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv1s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 115*/ 659, // Rule ID 55241 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (add:{ *:[nxv1i64] } VR:{ *:[nxv1i64] }:$rs1, VR:{ *:[nxv1i64] }:$rs2)  =>  (PseudoVADD_VV_M1:{ *:[nxv1i64] } VR:{ *:[nxv1i64] }:$rs1, VR:{ *:[nxv1i64] }:$rs2, -1:{ *:[i64] }, 6:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVADD_VV_M1,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 55241,
        GIR_Done,
      // Label 115: @659
      GIM_Try, /*On fail goto*//*Label 116*/ 689, // Rule ID 55242 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (add:{ *:[nxv1i64] } VR:{ *:[nxv1i64] }:$rs1, VR:{ *:[nxv1i64] }:$rs2)  =>  (PseudoVADD_VV_M1:{ *:[nxv1i64] } VR:{ *:[nxv1i64] }:$rs1, VR:{ *:[nxv1i64] }:$rs2, -1:{ *:[i32] }, 6:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVADD_VV_M1,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 55242,
        GIR_Done,
      // Label 116: @689
      GIM_Reject,
    // Label 114: @690
    GIM_Reject,
    // Label 80: @691
    GIM_Try, /*On fail goto*//*Label 117*/ 774,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv2s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv2s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 118*/ 743, // Rule ID 55209 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (add:{ *:[nxv2i8] } VR:{ *:[nxv2i8] }:$rs1, VR:{ *:[nxv2i8] }:$rs2)  =>  (PseudoVADD_VV_MF4:{ *:[nxv2i8] } VR:{ *:[nxv2i8] }:$rs1, VR:{ *:[nxv2i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVADD_VV_MF4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 55209,
        GIR_Done,
      // Label 118: @743
      GIM_Try, /*On fail goto*//*Label 119*/ 773, // Rule ID 55210 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (add:{ *:[nxv2i8] } VR:{ *:[nxv2i8] }:$rs1, VR:{ *:[nxv2i8] }:$rs2)  =>  (PseudoVADD_VV_MF4:{ *:[nxv2i8] } VR:{ *:[nxv2i8] }:$rs1, VR:{ *:[nxv2i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVADD_VV_MF4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 55210,
        GIR_Done,
      // Label 119: @773
      GIM_Reject,
    // Label 117: @774
    GIM_Reject,
    // Label 81: @775
    GIM_Try, /*On fail goto*//*Label 120*/ 858,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv2s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv2s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 121*/ 827, // Rule ID 55221 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (add:{ *:[nxv2i16] } VR:{ *:[nxv2i16] }:$rs1, VR:{ *:[nxv2i16] }:$rs2)  =>  (PseudoVADD_VV_MF2:{ *:[nxv2i16] } VR:{ *:[nxv2i16] }:$rs1, VR:{ *:[nxv2i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVADD_VV_MF2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 55221,
        GIR_Done,
      // Label 121: @827
      GIM_Try, /*On fail goto*//*Label 122*/ 857, // Rule ID 55222 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (add:{ *:[nxv2i16] } VR:{ *:[nxv2i16] }:$rs1, VR:{ *:[nxv2i16] }:$rs2)  =>  (PseudoVADD_VV_MF2:{ *:[nxv2i16] } VR:{ *:[nxv2i16] }:$rs1, VR:{ *:[nxv2i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVADD_VV_MF2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 55222,
        GIR_Done,
      // Label 122: @857
      GIM_Reject,
    // Label 120: @858
    GIM_Reject,
    // Label 82: @859
    GIM_Try, /*On fail goto*//*Label 123*/ 942,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv2s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv2s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 124*/ 911, // Rule ID 55237 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (add:{ *:[nxv2i32] } VR:{ *:[nxv2i32] }:$rs1, VR:{ *:[nxv2i32] }:$rs2)  =>  (PseudoVADD_VV_M1:{ *:[nxv2i32] } VR:{ *:[nxv2i32] }:$rs1, VR:{ *:[nxv2i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVADD_VV_M1,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 55237,
        GIR_Done,
      // Label 124: @911
      GIM_Try, /*On fail goto*//*Label 125*/ 941, // Rule ID 55238 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (add:{ *:[nxv2i32] } VR:{ *:[nxv2i32] }:$rs1, VR:{ *:[nxv2i32] }:$rs2)  =>  (PseudoVADD_VV_M1:{ *:[nxv2i32] } VR:{ *:[nxv2i32] }:$rs1, VR:{ *:[nxv2i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVADD_VV_M1,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 55238,
        GIR_Done,
      // Label 125: @941
      GIM_Reject,
    // Label 123: @942
    GIM_Reject,
    // Label 83: @943
    GIM_Try, /*On fail goto*//*Label 126*/ 1026,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv2s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM2RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM2RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM2RegClassID,
      GIM_Try, /*On fail goto*//*Label 127*/ 995, // Rule ID 55281 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (add:{ *:[nxv2i64] } VRM2:{ *:[nxv2i64] }:$rs1, VRM2:{ *:[nxv2i64] }:$rs2)  =>  (PseudoVADD_VV_M2:{ *:[nxv2i64] } VRM2:{ *:[nxv2i64] }:$rs1, VRM2:{ *:[nxv2i64] }:$rs2, -1:{ *:[i64] }, 6:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVADD_VV_M2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 55281,
        GIR_Done,
      // Label 127: @995
      GIM_Try, /*On fail goto*//*Label 128*/ 1025, // Rule ID 55282 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (add:{ *:[nxv2i64] } VRM2:{ *:[nxv2i64] }:$rs1, VRM2:{ *:[nxv2i64] }:$rs2)  =>  (PseudoVADD_VV_M2:{ *:[nxv2i64] } VRM2:{ *:[nxv2i64] }:$rs1, VRM2:{ *:[nxv2i64] }:$rs2, -1:{ *:[i32] }, 6:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVADD_VV_M2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 55282,
        GIR_Done,
      // Label 128: @1025
      GIM_Reject,
    // Label 126: @1026
    GIM_Reject,
    // Label 84: @1027
    GIM_Try, /*On fail goto*//*Label 129*/ 1110,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv4s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv4s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 130*/ 1079, // Rule ID 55213 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (add:{ *:[nxv4i8] } VR:{ *:[nxv4i8] }:$rs1, VR:{ *:[nxv4i8] }:$rs2)  =>  (PseudoVADD_VV_MF2:{ *:[nxv4i8] } VR:{ *:[nxv4i8] }:$rs1, VR:{ *:[nxv4i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVADD_VV_MF2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 55213,
        GIR_Done,
      // Label 130: @1079
      GIM_Try, /*On fail goto*//*Label 131*/ 1109, // Rule ID 55214 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (add:{ *:[nxv4i8] } VR:{ *:[nxv4i8] }:$rs1, VR:{ *:[nxv4i8] }:$rs2)  =>  (PseudoVADD_VV_MF2:{ *:[nxv4i8] } VR:{ *:[nxv4i8] }:$rs1, VR:{ *:[nxv4i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVADD_VV_MF2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 55214,
        GIR_Done,
      // Label 131: @1109
      GIM_Reject,
    // Label 129: @1110
    GIM_Reject,
    // Label 85: @1111
    GIM_Try, /*On fail goto*//*Label 132*/ 1194,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv4s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv4s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 133*/ 1163, // Rule ID 55233 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (add:{ *:[nxv4i16] } VR:{ *:[nxv4i16] }:$rs1, VR:{ *:[nxv4i16] }:$rs2)  =>  (PseudoVADD_VV_M1:{ *:[nxv4i16] } VR:{ *:[nxv4i16] }:$rs1, VR:{ *:[nxv4i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVADD_VV_M1,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 55233,
        GIR_Done,
      // Label 133: @1163
      GIM_Try, /*On fail goto*//*Label 134*/ 1193, // Rule ID 55234 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (add:{ *:[nxv4i16] } VR:{ *:[nxv4i16] }:$rs1, VR:{ *:[nxv4i16] }:$rs2)  =>  (PseudoVADD_VV_M1:{ *:[nxv4i16] } VR:{ *:[nxv4i16] }:$rs1, VR:{ *:[nxv4i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVADD_VV_M1,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 55234,
        GIR_Done,
      // Label 134: @1193
      GIM_Reject,
    // Label 132: @1194
    GIM_Reject,
    // Label 86: @1195
    GIM_Try, /*On fail goto*//*Label 135*/ 1278,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv4s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM2RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM2RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM2RegClassID,
      GIM_Try, /*On fail goto*//*Label 136*/ 1247, // Rule ID 55269 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (add:{ *:[nxv4i32] } VRM2:{ *:[nxv4i32] }:$rs1, VRM2:{ *:[nxv4i32] }:$rs2)  =>  (PseudoVADD_VV_M2:{ *:[nxv4i32] } VRM2:{ *:[nxv4i32] }:$rs1, VRM2:{ *:[nxv4i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVADD_VV_M2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 55269,
        GIR_Done,
      // Label 136: @1247
      GIM_Try, /*On fail goto*//*Label 137*/ 1277, // Rule ID 55270 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (add:{ *:[nxv4i32] } VRM2:{ *:[nxv4i32] }:$rs1, VRM2:{ *:[nxv4i32] }:$rs2)  =>  (PseudoVADD_VV_M2:{ *:[nxv4i32] } VRM2:{ *:[nxv4i32] }:$rs1, VRM2:{ *:[nxv4i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVADD_VV_M2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 55270,
        GIR_Done,
      // Label 137: @1277
      GIM_Reject,
    // Label 135: @1278
    GIM_Reject,
    // Label 87: @1279
    GIM_Try, /*On fail goto*//*Label 138*/ 1362,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv4s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv4s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM4RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM4RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM4RegClassID,
      GIM_Try, /*On fail goto*//*Label 139*/ 1331, // Rule ID 55285 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (add:{ *:[nxv4i64] } VRM4:{ *:[nxv4i64] }:$rs1, VRM4:{ *:[nxv4i64] }:$rs2)  =>  (PseudoVADD_VV_M4:{ *:[nxv4i64] } VRM4:{ *:[nxv4i64] }:$rs1, VRM4:{ *:[nxv4i64] }:$rs2, -1:{ *:[i64] }, 6:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVADD_VV_M4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 55285,
        GIR_Done,
      // Label 139: @1331
      GIM_Try, /*On fail goto*//*Label 140*/ 1361, // Rule ID 55286 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (add:{ *:[nxv4i64] } VRM4:{ *:[nxv4i64] }:$rs1, VRM4:{ *:[nxv4i64] }:$rs2)  =>  (PseudoVADD_VV_M4:{ *:[nxv4i64] } VRM4:{ *:[nxv4i64] }:$rs1, VRM4:{ *:[nxv4i64] }:$rs2, -1:{ *:[i32] }, 6:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVADD_VV_M4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 55286,
        GIR_Done,
      // Label 140: @1361
      GIM_Reject,
    // Label 138: @1362
    GIM_Reject,
    // Label 88: @1363
    GIM_Try, /*On fail goto*//*Label 141*/ 1446,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv8s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv8s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 142*/ 1415, // Rule ID 55229 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (add:{ *:[nxv8i8] } VR:{ *:[nxv8i8] }:$rs1, VR:{ *:[nxv8i8] }:$rs2)  =>  (PseudoVADD_VV_M1:{ *:[nxv8i8] } VR:{ *:[nxv8i8] }:$rs1, VR:{ *:[nxv8i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVADD_VV_M1,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 55229,
        GIR_Done,
      // Label 142: @1415
      GIM_Try, /*On fail goto*//*Label 143*/ 1445, // Rule ID 55230 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (add:{ *:[nxv8i8] } VR:{ *:[nxv8i8] }:$rs1, VR:{ *:[nxv8i8] }:$rs2)  =>  (PseudoVADD_VV_M1:{ *:[nxv8i8] } VR:{ *:[nxv8i8] }:$rs1, VR:{ *:[nxv8i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVADD_VV_M1,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 55230,
        GIR_Done,
      // Label 143: @1445
      GIM_Reject,
    // Label 141: @1446
    GIM_Reject,
    // Label 89: @1447
    GIM_Try, /*On fail goto*//*Label 144*/ 1530,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv8s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM2RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM2RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM2RegClassID,
      GIM_Try, /*On fail goto*//*Label 145*/ 1499, // Rule ID 55257 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (add:{ *:[nxv8i16] } VRM2:{ *:[nxv8i16] }:$rs1, VRM2:{ *:[nxv8i16] }:$rs2)  =>  (PseudoVADD_VV_M2:{ *:[nxv8i16] } VRM2:{ *:[nxv8i16] }:$rs1, VRM2:{ *:[nxv8i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVADD_VV_M2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 55257,
        GIR_Done,
      // Label 145: @1499
      GIM_Try, /*On fail goto*//*Label 146*/ 1529, // Rule ID 55258 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (add:{ *:[nxv8i16] } VRM2:{ *:[nxv8i16] }:$rs1, VRM2:{ *:[nxv8i16] }:$rs2)  =>  (PseudoVADD_VV_M2:{ *:[nxv8i16] } VRM2:{ *:[nxv8i16] }:$rs1, VRM2:{ *:[nxv8i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVADD_VV_M2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 55258,
        GIR_Done,
      // Label 146: @1529
      GIM_Reject,
    // Label 144: @1530
    GIM_Reject,
    // Label 90: @1531
    GIM_Try, /*On fail goto*//*Label 147*/ 1614,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv8s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv8s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM4RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM4RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM4RegClassID,
      GIM_Try, /*On fail goto*//*Label 148*/ 1583, // Rule ID 55273 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (add:{ *:[nxv8i32] } VRM4:{ *:[nxv8i32] }:$rs1, VRM4:{ *:[nxv8i32] }:$rs2)  =>  (PseudoVADD_VV_M4:{ *:[nxv8i32] } VRM4:{ *:[nxv8i32] }:$rs1, VRM4:{ *:[nxv8i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVADD_VV_M4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 55273,
        GIR_Done,
      // Label 148: @1583
      GIM_Try, /*On fail goto*//*Label 149*/ 1613, // Rule ID 55274 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (add:{ *:[nxv8i32] } VRM4:{ *:[nxv8i32] }:$rs1, VRM4:{ *:[nxv8i32] }:$rs2)  =>  (PseudoVADD_VV_M4:{ *:[nxv8i32] } VRM4:{ *:[nxv8i32] }:$rs1, VRM4:{ *:[nxv8i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVADD_VV_M4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 55274,
        GIR_Done,
      // Label 149: @1613
      GIM_Reject,
    // Label 147: @1614
    GIM_Reject,
    // Label 91: @1615
    GIM_Try, /*On fail goto*//*Label 150*/ 1698,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv8s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv8s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM8RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM8RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM8RegClassID,
      GIM_Try, /*On fail goto*//*Label 151*/ 1667, // Rule ID 55289 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (add:{ *:[nxv8i64] } VRM8:{ *:[nxv8i64] }:$rs1, VRM8:{ *:[nxv8i64] }:$rs2)  =>  (PseudoVADD_VV_M8:{ *:[nxv8i64] } VRM8:{ *:[nxv8i64] }:$rs1, VRM8:{ *:[nxv8i64] }:$rs2, -1:{ *:[i64] }, 6:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVADD_VV_M8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 55289,
        GIR_Done,
      // Label 151: @1667
      GIM_Try, /*On fail goto*//*Label 152*/ 1697, // Rule ID 55290 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (add:{ *:[nxv8i64] } VRM8:{ *:[nxv8i64] }:$rs1, VRM8:{ *:[nxv8i64] }:$rs2)  =>  (PseudoVADD_VV_M8:{ *:[nxv8i64] } VRM8:{ *:[nxv8i64] }:$rs1, VRM8:{ *:[nxv8i64] }:$rs2, -1:{ *:[i32] }, 6:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVADD_VV_M8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 55290,
        GIR_Done,
      // Label 152: @1697
      GIM_Reject,
    // Label 150: @1698
    GIM_Reject,
    // Label 92: @1699
    GIM_Try, /*On fail goto*//*Label 153*/ 1782,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv16s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv16s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM2RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM2RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM2RegClassID,
      GIM_Try, /*On fail goto*//*Label 154*/ 1751, // Rule ID 55245 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (add:{ *:[nxv16i8] } VRM2:{ *:[nxv16i8] }:$rs1, VRM2:{ *:[nxv16i8] }:$rs2)  =>  (PseudoVADD_VV_M2:{ *:[nxv16i8] } VRM2:{ *:[nxv16i8] }:$rs1, VRM2:{ *:[nxv16i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVADD_VV_M2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 55245,
        GIR_Done,
      // Label 154: @1751
      GIM_Try, /*On fail goto*//*Label 155*/ 1781, // Rule ID 55246 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (add:{ *:[nxv16i8] } VRM2:{ *:[nxv16i8] }:$rs1, VRM2:{ *:[nxv16i8] }:$rs2)  =>  (PseudoVADD_VV_M2:{ *:[nxv16i8] } VRM2:{ *:[nxv16i8] }:$rs1, VRM2:{ *:[nxv16i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVADD_VV_M2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 55246,
        GIR_Done,
      // Label 155: @1781
      GIM_Reject,
    // Label 153: @1782
    GIM_Reject,
    // Label 93: @1783
    GIM_Try, /*On fail goto*//*Label 156*/ 1866,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv16s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv16s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM4RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM4RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM4RegClassID,
      GIM_Try, /*On fail goto*//*Label 157*/ 1835, // Rule ID 55261 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (add:{ *:[nxv16i16] } VRM4:{ *:[nxv16i16] }:$rs1, VRM4:{ *:[nxv16i16] }:$rs2)  =>  (PseudoVADD_VV_M4:{ *:[nxv16i16] } VRM4:{ *:[nxv16i16] }:$rs1, VRM4:{ *:[nxv16i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVADD_VV_M4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 55261,
        GIR_Done,
      // Label 157: @1835
      GIM_Try, /*On fail goto*//*Label 158*/ 1865, // Rule ID 55262 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (add:{ *:[nxv16i16] } VRM4:{ *:[nxv16i16] }:$rs1, VRM4:{ *:[nxv16i16] }:$rs2)  =>  (PseudoVADD_VV_M4:{ *:[nxv16i16] } VRM4:{ *:[nxv16i16] }:$rs1, VRM4:{ *:[nxv16i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVADD_VV_M4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 55262,
        GIR_Done,
      // Label 158: @1865
      GIM_Reject,
    // Label 156: @1866
    GIM_Reject,
    // Label 94: @1867
    GIM_Try, /*On fail goto*//*Label 159*/ 1950,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv16s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv16s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM8RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM8RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM8RegClassID,
      GIM_Try, /*On fail goto*//*Label 160*/ 1919, // Rule ID 55277 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (add:{ *:[nxv16i32] } VRM8:{ *:[nxv16i32] }:$rs1, VRM8:{ *:[nxv16i32] }:$rs2)  =>  (PseudoVADD_VV_M8:{ *:[nxv16i32] } VRM8:{ *:[nxv16i32] }:$rs1, VRM8:{ *:[nxv16i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVADD_VV_M8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 55277,
        GIR_Done,
      // Label 160: @1919
      GIM_Try, /*On fail goto*//*Label 161*/ 1949, // Rule ID 55278 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (add:{ *:[nxv16i32] } VRM8:{ *:[nxv16i32] }:$rs1, VRM8:{ *:[nxv16i32] }:$rs2)  =>  (PseudoVADD_VV_M8:{ *:[nxv16i32] } VRM8:{ *:[nxv16i32] }:$rs1, VRM8:{ *:[nxv16i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVADD_VV_M8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 55278,
        GIR_Done,
      // Label 161: @1949
      GIM_Reject,
    // Label 159: @1950
    GIM_Reject,
    // Label 95: @1951
    GIM_Try, /*On fail goto*//*Label 162*/ 2034,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv32s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv32s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM4RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM4RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM4RegClassID,
      GIM_Try, /*On fail goto*//*Label 163*/ 2003, // Rule ID 55249 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (add:{ *:[nxv32i8] } VRM4:{ *:[nxv32i8] }:$rs1, VRM4:{ *:[nxv32i8] }:$rs2)  =>  (PseudoVADD_VV_M4:{ *:[nxv32i8] } VRM4:{ *:[nxv32i8] }:$rs1, VRM4:{ *:[nxv32i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVADD_VV_M4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 55249,
        GIR_Done,
      // Label 163: @2003
      GIM_Try, /*On fail goto*//*Label 164*/ 2033, // Rule ID 55250 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (add:{ *:[nxv32i8] } VRM4:{ *:[nxv32i8] }:$rs1, VRM4:{ *:[nxv32i8] }:$rs2)  =>  (PseudoVADD_VV_M4:{ *:[nxv32i8] } VRM4:{ *:[nxv32i8] }:$rs1, VRM4:{ *:[nxv32i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVADD_VV_M4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 55250,
        GIR_Done,
      // Label 164: @2033
      GIM_Reject,
    // Label 162: @2034
    GIM_Reject,
    // Label 96: @2035
    GIM_Try, /*On fail goto*//*Label 165*/ 2118,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv32s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv32s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM8RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM8RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM8RegClassID,
      GIM_Try, /*On fail goto*//*Label 166*/ 2087, // Rule ID 55265 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (add:{ *:[nxv32i16] } VRM8:{ *:[nxv32i16] }:$rs1, VRM8:{ *:[nxv32i16] }:$rs2)  =>  (PseudoVADD_VV_M8:{ *:[nxv32i16] } VRM8:{ *:[nxv32i16] }:$rs1, VRM8:{ *:[nxv32i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVADD_VV_M8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 55265,
        GIR_Done,
      // Label 166: @2087
      GIM_Try, /*On fail goto*//*Label 167*/ 2117, // Rule ID 55266 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (add:{ *:[nxv32i16] } VRM8:{ *:[nxv32i16] }:$rs1, VRM8:{ *:[nxv32i16] }:$rs2)  =>  (PseudoVADD_VV_M8:{ *:[nxv32i16] } VRM8:{ *:[nxv32i16] }:$rs1, VRM8:{ *:[nxv32i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVADD_VV_M8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 55266,
        GIR_Done,
      // Label 167: @2117
      GIM_Reject,
    // Label 165: @2118
    GIM_Reject,
    // Label 97: @2119
    GIM_Try, /*On fail goto*//*Label 168*/ 2202,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv64s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv64s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM8RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM8RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM8RegClassID,
      GIM_Try, /*On fail goto*//*Label 169*/ 2171, // Rule ID 55253 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (add:{ *:[nxv64i8] } VRM8:{ *:[nxv64i8] }:$rs1, VRM8:{ *:[nxv64i8] }:$rs2)  =>  (PseudoVADD_VV_M8:{ *:[nxv64i8] } VRM8:{ *:[nxv64i8] }:$rs1, VRM8:{ *:[nxv64i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVADD_VV_M8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 55253,
        GIR_Done,
      // Label 169: @2171
      GIM_Try, /*On fail goto*//*Label 170*/ 2201, // Rule ID 55254 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (add:{ *:[nxv64i8] } VRM8:{ *:[nxv64i8] }:$rs1, VRM8:{ *:[nxv64i8] }:$rs2)  =>  (PseudoVADD_VV_M8:{ *:[nxv64i8] } VRM8:{ *:[nxv64i8] }:$rs1, VRM8:{ *:[nxv64i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVADD_VV_M8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 55254,
        GIR_Done,
      // Label 170: @2201
      GIM_Reject,
    // Label 168: @2202
    GIM_Reject,
    // Label 98: @2203
    GIM_Reject,
    // Label 1: @2204
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/1, 32, /*)*//*default:*//*Label 195*/ 4149,
    /*GILLT_s32*//*Label 171*/ 2241,
    /*GILLT_s64*//*Label 172*/ 2271, 0,
    /*GILLT_nxv1s8*//*Label 173*/ 2301,
    /*GILLT_nxv1s16*//*Label 174*/ 2385,
    /*GILLT_nxv1s32*//*Label 175*/ 2469,
    /*GILLT_nxv1s64*//*Label 176*/ 2553, 0,
    /*GILLT_nxv2s8*//*Label 177*/ 2637,
    /*GILLT_nxv2s16*//*Label 178*/ 2721,
    /*GILLT_nxv2s32*//*Label 179*/ 2805,
    /*GILLT_nxv2s64*//*Label 180*/ 2889, 0,
    /*GILLT_nxv4s8*//*Label 181*/ 2973,
    /*GILLT_nxv4s16*//*Label 182*/ 3057,
    /*GILLT_nxv4s32*//*Label 183*/ 3141,
    /*GILLT_nxv4s64*//*Label 184*/ 3225, 0,
    /*GILLT_nxv8s8*//*Label 185*/ 3309,
    /*GILLT_nxv8s16*//*Label 186*/ 3393,
    /*GILLT_nxv8s32*//*Label 187*/ 3477,
    /*GILLT_nxv8s64*//*Label 188*/ 3561, 0,
    /*GILLT_nxv16s8*//*Label 189*/ 3645,
    /*GILLT_nxv16s16*//*Label 190*/ 3729,
    /*GILLT_nxv16s32*//*Label 191*/ 3813, 0,
    /*GILLT_nxv32s8*//*Label 192*/ 3897,
    /*GILLT_nxv32s16*//*Label 193*/ 3981, 0,
    /*GILLT_nxv64s8*//*Label 194*/ 4065,
    // Label 171: @2241
    GIM_Try, /*On fail goto*//*Label 196*/ 2270, // Rule ID 59852 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
      // (sub:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)  =>  (SUB:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::SUB,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 59852,
      GIR_Done,
    // Label 196: @2270
    GIM_Reject,
    // Label 172: @2271
    GIM_Try, /*On fail goto*//*Label 197*/ 2300, // Rule ID 59851 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
      // (sub:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)  =>  (SUB:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::SUB,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 59851,
      GIR_Done,
    // Label 197: @2300
    GIM_Reject,
    // Label 173: @2301
    GIM_Try, /*On fail goto*//*Label 198*/ 2384,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv1s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv1s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 199*/ 2353, // Rule ID 55335 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (sub:{ *:[nxv1i8] } VR:{ *:[nxv1i8] }:$rs1, VR:{ *:[nxv1i8] }:$rs2)  =>  (PseudoVSUB_VV_MF8:{ *:[nxv1i8] } VR:{ *:[nxv1i8] }:$rs1, VR:{ *:[nxv1i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVSUB_VV_MF8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 55335,
        GIR_Done,
      // Label 199: @2353
      GIM_Try, /*On fail goto*//*Label 200*/ 2383, // Rule ID 55336 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (sub:{ *:[nxv1i8] } VR:{ *:[nxv1i8] }:$rs1, VR:{ *:[nxv1i8] }:$rs2)  =>  (PseudoVSUB_VV_MF8:{ *:[nxv1i8] } VR:{ *:[nxv1i8] }:$rs1, VR:{ *:[nxv1i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVSUB_VV_MF8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 55336,
        GIR_Done,
      // Label 200: @2383
      GIM_Reject,
    // Label 198: @2384
    GIM_Reject,
    // Label 174: @2385
    GIM_Try, /*On fail goto*//*Label 201*/ 2468,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv1s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv1s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 202*/ 2437, // Rule ID 55347 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (sub:{ *:[nxv1i16] } VR:{ *:[nxv1i16] }:$rs1, VR:{ *:[nxv1i16] }:$rs2)  =>  (PseudoVSUB_VV_MF4:{ *:[nxv1i16] } VR:{ *:[nxv1i16] }:$rs1, VR:{ *:[nxv1i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVSUB_VV_MF4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 55347,
        GIR_Done,
      // Label 202: @2437
      GIM_Try, /*On fail goto*//*Label 203*/ 2467, // Rule ID 55348 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (sub:{ *:[nxv1i16] } VR:{ *:[nxv1i16] }:$rs1, VR:{ *:[nxv1i16] }:$rs2)  =>  (PseudoVSUB_VV_MF4:{ *:[nxv1i16] } VR:{ *:[nxv1i16] }:$rs1, VR:{ *:[nxv1i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVSUB_VV_MF4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 55348,
        GIR_Done,
      // Label 203: @2467
      GIM_Reject,
    // Label 201: @2468
    GIM_Reject,
    // Label 175: @2469
    GIM_Try, /*On fail goto*//*Label 204*/ 2552,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv1s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv1s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 205*/ 2521, // Rule ID 55355 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (sub:{ *:[nxv1i32] } VR:{ *:[nxv1i32] }:$rs1, VR:{ *:[nxv1i32] }:$rs2)  =>  (PseudoVSUB_VV_MF2:{ *:[nxv1i32] } VR:{ *:[nxv1i32] }:$rs1, VR:{ *:[nxv1i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVSUB_VV_MF2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 55355,
        GIR_Done,
      // Label 205: @2521
      GIM_Try, /*On fail goto*//*Label 206*/ 2551, // Rule ID 55356 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (sub:{ *:[nxv1i32] } VR:{ *:[nxv1i32] }:$rs1, VR:{ *:[nxv1i32] }:$rs2)  =>  (PseudoVSUB_VV_MF2:{ *:[nxv1i32] } VR:{ *:[nxv1i32] }:$rs1, VR:{ *:[nxv1i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVSUB_VV_MF2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 55356,
        GIR_Done,
      // Label 206: @2551
      GIM_Reject,
    // Label 204: @2552
    GIM_Reject,
    // Label 176: @2553
    GIM_Try, /*On fail goto*//*Label 207*/ 2636,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv1s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv1s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 208*/ 2605, // Rule ID 55371 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (sub:{ *:[nxv1i64] } VR:{ *:[nxv1i64] }:$rs1, VR:{ *:[nxv1i64] }:$rs2)  =>  (PseudoVSUB_VV_M1:{ *:[nxv1i64] } VR:{ *:[nxv1i64] }:$rs1, VR:{ *:[nxv1i64] }:$rs2, -1:{ *:[i64] }, 6:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVSUB_VV_M1,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 55371,
        GIR_Done,
      // Label 208: @2605
      GIM_Try, /*On fail goto*//*Label 209*/ 2635, // Rule ID 55372 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (sub:{ *:[nxv1i64] } VR:{ *:[nxv1i64] }:$rs1, VR:{ *:[nxv1i64] }:$rs2)  =>  (PseudoVSUB_VV_M1:{ *:[nxv1i64] } VR:{ *:[nxv1i64] }:$rs1, VR:{ *:[nxv1i64] }:$rs2, -1:{ *:[i32] }, 6:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVSUB_VV_M1,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 55372,
        GIR_Done,
      // Label 209: @2635
      GIM_Reject,
    // Label 207: @2636
    GIM_Reject,
    // Label 177: @2637
    GIM_Try, /*On fail goto*//*Label 210*/ 2720,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv2s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv2s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 211*/ 2689, // Rule ID 55339 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (sub:{ *:[nxv2i8] } VR:{ *:[nxv2i8] }:$rs1, VR:{ *:[nxv2i8] }:$rs2)  =>  (PseudoVSUB_VV_MF4:{ *:[nxv2i8] } VR:{ *:[nxv2i8] }:$rs1, VR:{ *:[nxv2i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVSUB_VV_MF4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 55339,
        GIR_Done,
      // Label 211: @2689
      GIM_Try, /*On fail goto*//*Label 212*/ 2719, // Rule ID 55340 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (sub:{ *:[nxv2i8] } VR:{ *:[nxv2i8] }:$rs1, VR:{ *:[nxv2i8] }:$rs2)  =>  (PseudoVSUB_VV_MF4:{ *:[nxv2i8] } VR:{ *:[nxv2i8] }:$rs1, VR:{ *:[nxv2i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVSUB_VV_MF4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 55340,
        GIR_Done,
      // Label 212: @2719
      GIM_Reject,
    // Label 210: @2720
    GIM_Reject,
    // Label 178: @2721
    GIM_Try, /*On fail goto*//*Label 213*/ 2804,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv2s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv2s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 214*/ 2773, // Rule ID 55351 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (sub:{ *:[nxv2i16] } VR:{ *:[nxv2i16] }:$rs1, VR:{ *:[nxv2i16] }:$rs2)  =>  (PseudoVSUB_VV_MF2:{ *:[nxv2i16] } VR:{ *:[nxv2i16] }:$rs1, VR:{ *:[nxv2i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVSUB_VV_MF2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 55351,
        GIR_Done,
      // Label 214: @2773
      GIM_Try, /*On fail goto*//*Label 215*/ 2803, // Rule ID 55352 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (sub:{ *:[nxv2i16] } VR:{ *:[nxv2i16] }:$rs1, VR:{ *:[nxv2i16] }:$rs2)  =>  (PseudoVSUB_VV_MF2:{ *:[nxv2i16] } VR:{ *:[nxv2i16] }:$rs1, VR:{ *:[nxv2i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVSUB_VV_MF2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 55352,
        GIR_Done,
      // Label 215: @2803
      GIM_Reject,
    // Label 213: @2804
    GIM_Reject,
    // Label 179: @2805
    GIM_Try, /*On fail goto*//*Label 216*/ 2888,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv2s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv2s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 217*/ 2857, // Rule ID 55367 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (sub:{ *:[nxv2i32] } VR:{ *:[nxv2i32] }:$rs1, VR:{ *:[nxv2i32] }:$rs2)  =>  (PseudoVSUB_VV_M1:{ *:[nxv2i32] } VR:{ *:[nxv2i32] }:$rs1, VR:{ *:[nxv2i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVSUB_VV_M1,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 55367,
        GIR_Done,
      // Label 217: @2857
      GIM_Try, /*On fail goto*//*Label 218*/ 2887, // Rule ID 55368 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (sub:{ *:[nxv2i32] } VR:{ *:[nxv2i32] }:$rs1, VR:{ *:[nxv2i32] }:$rs2)  =>  (PseudoVSUB_VV_M1:{ *:[nxv2i32] } VR:{ *:[nxv2i32] }:$rs1, VR:{ *:[nxv2i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVSUB_VV_M1,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 55368,
        GIR_Done,
      // Label 218: @2887
      GIM_Reject,
    // Label 216: @2888
    GIM_Reject,
    // Label 180: @2889
    GIM_Try, /*On fail goto*//*Label 219*/ 2972,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv2s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM2RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM2RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM2RegClassID,
      GIM_Try, /*On fail goto*//*Label 220*/ 2941, // Rule ID 55411 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (sub:{ *:[nxv2i64] } VRM2:{ *:[nxv2i64] }:$rs1, VRM2:{ *:[nxv2i64] }:$rs2)  =>  (PseudoVSUB_VV_M2:{ *:[nxv2i64] } VRM2:{ *:[nxv2i64] }:$rs1, VRM2:{ *:[nxv2i64] }:$rs2, -1:{ *:[i64] }, 6:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVSUB_VV_M2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 55411,
        GIR_Done,
      // Label 220: @2941
      GIM_Try, /*On fail goto*//*Label 221*/ 2971, // Rule ID 55412 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (sub:{ *:[nxv2i64] } VRM2:{ *:[nxv2i64] }:$rs1, VRM2:{ *:[nxv2i64] }:$rs2)  =>  (PseudoVSUB_VV_M2:{ *:[nxv2i64] } VRM2:{ *:[nxv2i64] }:$rs1, VRM2:{ *:[nxv2i64] }:$rs2, -1:{ *:[i32] }, 6:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVSUB_VV_M2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 55412,
        GIR_Done,
      // Label 221: @2971
      GIM_Reject,
    // Label 219: @2972
    GIM_Reject,
    // Label 181: @2973
    GIM_Try, /*On fail goto*//*Label 222*/ 3056,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv4s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv4s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 223*/ 3025, // Rule ID 55343 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (sub:{ *:[nxv4i8] } VR:{ *:[nxv4i8] }:$rs1, VR:{ *:[nxv4i8] }:$rs2)  =>  (PseudoVSUB_VV_MF2:{ *:[nxv4i8] } VR:{ *:[nxv4i8] }:$rs1, VR:{ *:[nxv4i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVSUB_VV_MF2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 55343,
        GIR_Done,
      // Label 223: @3025
      GIM_Try, /*On fail goto*//*Label 224*/ 3055, // Rule ID 55344 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (sub:{ *:[nxv4i8] } VR:{ *:[nxv4i8] }:$rs1, VR:{ *:[nxv4i8] }:$rs2)  =>  (PseudoVSUB_VV_MF2:{ *:[nxv4i8] } VR:{ *:[nxv4i8] }:$rs1, VR:{ *:[nxv4i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVSUB_VV_MF2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 55344,
        GIR_Done,
      // Label 224: @3055
      GIM_Reject,
    // Label 222: @3056
    GIM_Reject,
    // Label 182: @3057
    GIM_Try, /*On fail goto*//*Label 225*/ 3140,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv4s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv4s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 226*/ 3109, // Rule ID 55363 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (sub:{ *:[nxv4i16] } VR:{ *:[nxv4i16] }:$rs1, VR:{ *:[nxv4i16] }:$rs2)  =>  (PseudoVSUB_VV_M1:{ *:[nxv4i16] } VR:{ *:[nxv4i16] }:$rs1, VR:{ *:[nxv4i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVSUB_VV_M1,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 55363,
        GIR_Done,
      // Label 226: @3109
      GIM_Try, /*On fail goto*//*Label 227*/ 3139, // Rule ID 55364 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (sub:{ *:[nxv4i16] } VR:{ *:[nxv4i16] }:$rs1, VR:{ *:[nxv4i16] }:$rs2)  =>  (PseudoVSUB_VV_M1:{ *:[nxv4i16] } VR:{ *:[nxv4i16] }:$rs1, VR:{ *:[nxv4i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVSUB_VV_M1,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 55364,
        GIR_Done,
      // Label 227: @3139
      GIM_Reject,
    // Label 225: @3140
    GIM_Reject,
    // Label 183: @3141
    GIM_Try, /*On fail goto*//*Label 228*/ 3224,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv4s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM2RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM2RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM2RegClassID,
      GIM_Try, /*On fail goto*//*Label 229*/ 3193, // Rule ID 55399 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (sub:{ *:[nxv4i32] } VRM2:{ *:[nxv4i32] }:$rs1, VRM2:{ *:[nxv4i32] }:$rs2)  =>  (PseudoVSUB_VV_M2:{ *:[nxv4i32] } VRM2:{ *:[nxv4i32] }:$rs1, VRM2:{ *:[nxv4i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVSUB_VV_M2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 55399,
        GIR_Done,
      // Label 229: @3193
      GIM_Try, /*On fail goto*//*Label 230*/ 3223, // Rule ID 55400 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (sub:{ *:[nxv4i32] } VRM2:{ *:[nxv4i32] }:$rs1, VRM2:{ *:[nxv4i32] }:$rs2)  =>  (PseudoVSUB_VV_M2:{ *:[nxv4i32] } VRM2:{ *:[nxv4i32] }:$rs1, VRM2:{ *:[nxv4i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVSUB_VV_M2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 55400,
        GIR_Done,
      // Label 230: @3223
      GIM_Reject,
    // Label 228: @3224
    GIM_Reject,
    // Label 184: @3225
    GIM_Try, /*On fail goto*//*Label 231*/ 3308,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv4s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv4s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM4RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM4RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM4RegClassID,
      GIM_Try, /*On fail goto*//*Label 232*/ 3277, // Rule ID 55415 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (sub:{ *:[nxv4i64] } VRM4:{ *:[nxv4i64] }:$rs1, VRM4:{ *:[nxv4i64] }:$rs2)  =>  (PseudoVSUB_VV_M4:{ *:[nxv4i64] } VRM4:{ *:[nxv4i64] }:$rs1, VRM4:{ *:[nxv4i64] }:$rs2, -1:{ *:[i64] }, 6:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVSUB_VV_M4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 55415,
        GIR_Done,
      // Label 232: @3277
      GIM_Try, /*On fail goto*//*Label 233*/ 3307, // Rule ID 55416 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (sub:{ *:[nxv4i64] } VRM4:{ *:[nxv4i64] }:$rs1, VRM4:{ *:[nxv4i64] }:$rs2)  =>  (PseudoVSUB_VV_M4:{ *:[nxv4i64] } VRM4:{ *:[nxv4i64] }:$rs1, VRM4:{ *:[nxv4i64] }:$rs2, -1:{ *:[i32] }, 6:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVSUB_VV_M4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 55416,
        GIR_Done,
      // Label 233: @3307
      GIM_Reject,
    // Label 231: @3308
    GIM_Reject,
    // Label 185: @3309
    GIM_Try, /*On fail goto*//*Label 234*/ 3392,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv8s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv8s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 235*/ 3361, // Rule ID 55359 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (sub:{ *:[nxv8i8] } VR:{ *:[nxv8i8] }:$rs1, VR:{ *:[nxv8i8] }:$rs2)  =>  (PseudoVSUB_VV_M1:{ *:[nxv8i8] } VR:{ *:[nxv8i8] }:$rs1, VR:{ *:[nxv8i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVSUB_VV_M1,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 55359,
        GIR_Done,
      // Label 235: @3361
      GIM_Try, /*On fail goto*//*Label 236*/ 3391, // Rule ID 55360 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (sub:{ *:[nxv8i8] } VR:{ *:[nxv8i8] }:$rs1, VR:{ *:[nxv8i8] }:$rs2)  =>  (PseudoVSUB_VV_M1:{ *:[nxv8i8] } VR:{ *:[nxv8i8] }:$rs1, VR:{ *:[nxv8i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVSUB_VV_M1,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 55360,
        GIR_Done,
      // Label 236: @3391
      GIM_Reject,
    // Label 234: @3392
    GIM_Reject,
    // Label 186: @3393
    GIM_Try, /*On fail goto*//*Label 237*/ 3476,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv8s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM2RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM2RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM2RegClassID,
      GIM_Try, /*On fail goto*//*Label 238*/ 3445, // Rule ID 55387 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (sub:{ *:[nxv8i16] } VRM2:{ *:[nxv8i16] }:$rs1, VRM2:{ *:[nxv8i16] }:$rs2)  =>  (PseudoVSUB_VV_M2:{ *:[nxv8i16] } VRM2:{ *:[nxv8i16] }:$rs1, VRM2:{ *:[nxv8i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVSUB_VV_M2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 55387,
        GIR_Done,
      // Label 238: @3445
      GIM_Try, /*On fail goto*//*Label 239*/ 3475, // Rule ID 55388 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (sub:{ *:[nxv8i16] } VRM2:{ *:[nxv8i16] }:$rs1, VRM2:{ *:[nxv8i16] }:$rs2)  =>  (PseudoVSUB_VV_M2:{ *:[nxv8i16] } VRM2:{ *:[nxv8i16] }:$rs1, VRM2:{ *:[nxv8i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVSUB_VV_M2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 55388,
        GIR_Done,
      // Label 239: @3475
      GIM_Reject,
    // Label 237: @3476
    GIM_Reject,
    // Label 187: @3477
    GIM_Try, /*On fail goto*//*Label 240*/ 3560,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv8s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv8s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM4RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM4RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM4RegClassID,
      GIM_Try, /*On fail goto*//*Label 241*/ 3529, // Rule ID 55403 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (sub:{ *:[nxv8i32] } VRM4:{ *:[nxv8i32] }:$rs1, VRM4:{ *:[nxv8i32] }:$rs2)  =>  (PseudoVSUB_VV_M4:{ *:[nxv8i32] } VRM4:{ *:[nxv8i32] }:$rs1, VRM4:{ *:[nxv8i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVSUB_VV_M4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 55403,
        GIR_Done,
      // Label 241: @3529
      GIM_Try, /*On fail goto*//*Label 242*/ 3559, // Rule ID 55404 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (sub:{ *:[nxv8i32] } VRM4:{ *:[nxv8i32] }:$rs1, VRM4:{ *:[nxv8i32] }:$rs2)  =>  (PseudoVSUB_VV_M4:{ *:[nxv8i32] } VRM4:{ *:[nxv8i32] }:$rs1, VRM4:{ *:[nxv8i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVSUB_VV_M4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 55404,
        GIR_Done,
      // Label 242: @3559
      GIM_Reject,
    // Label 240: @3560
    GIM_Reject,
    // Label 188: @3561
    GIM_Try, /*On fail goto*//*Label 243*/ 3644,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv8s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv8s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM8RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM8RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM8RegClassID,
      GIM_Try, /*On fail goto*//*Label 244*/ 3613, // Rule ID 55419 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (sub:{ *:[nxv8i64] } VRM8:{ *:[nxv8i64] }:$rs1, VRM8:{ *:[nxv8i64] }:$rs2)  =>  (PseudoVSUB_VV_M8:{ *:[nxv8i64] } VRM8:{ *:[nxv8i64] }:$rs1, VRM8:{ *:[nxv8i64] }:$rs2, -1:{ *:[i64] }, 6:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVSUB_VV_M8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 55419,
        GIR_Done,
      // Label 244: @3613
      GIM_Try, /*On fail goto*//*Label 245*/ 3643, // Rule ID 55420 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (sub:{ *:[nxv8i64] } VRM8:{ *:[nxv8i64] }:$rs1, VRM8:{ *:[nxv8i64] }:$rs2)  =>  (PseudoVSUB_VV_M8:{ *:[nxv8i64] } VRM8:{ *:[nxv8i64] }:$rs1, VRM8:{ *:[nxv8i64] }:$rs2, -1:{ *:[i32] }, 6:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVSUB_VV_M8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 55420,
        GIR_Done,
      // Label 245: @3643
      GIM_Reject,
    // Label 243: @3644
    GIM_Reject,
    // Label 189: @3645
    GIM_Try, /*On fail goto*//*Label 246*/ 3728,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv16s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv16s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM2RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM2RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM2RegClassID,
      GIM_Try, /*On fail goto*//*Label 247*/ 3697, // Rule ID 55375 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (sub:{ *:[nxv16i8] } VRM2:{ *:[nxv16i8] }:$rs1, VRM2:{ *:[nxv16i8] }:$rs2)  =>  (PseudoVSUB_VV_M2:{ *:[nxv16i8] } VRM2:{ *:[nxv16i8] }:$rs1, VRM2:{ *:[nxv16i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVSUB_VV_M2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 55375,
        GIR_Done,
      // Label 247: @3697
      GIM_Try, /*On fail goto*//*Label 248*/ 3727, // Rule ID 55376 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (sub:{ *:[nxv16i8] } VRM2:{ *:[nxv16i8] }:$rs1, VRM2:{ *:[nxv16i8] }:$rs2)  =>  (PseudoVSUB_VV_M2:{ *:[nxv16i8] } VRM2:{ *:[nxv16i8] }:$rs1, VRM2:{ *:[nxv16i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVSUB_VV_M2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 55376,
        GIR_Done,
      // Label 248: @3727
      GIM_Reject,
    // Label 246: @3728
    GIM_Reject,
    // Label 190: @3729
    GIM_Try, /*On fail goto*//*Label 249*/ 3812,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv16s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv16s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM4RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM4RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM4RegClassID,
      GIM_Try, /*On fail goto*//*Label 250*/ 3781, // Rule ID 55391 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (sub:{ *:[nxv16i16] } VRM4:{ *:[nxv16i16] }:$rs1, VRM4:{ *:[nxv16i16] }:$rs2)  =>  (PseudoVSUB_VV_M4:{ *:[nxv16i16] } VRM4:{ *:[nxv16i16] }:$rs1, VRM4:{ *:[nxv16i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVSUB_VV_M4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 55391,
        GIR_Done,
      // Label 250: @3781
      GIM_Try, /*On fail goto*//*Label 251*/ 3811, // Rule ID 55392 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (sub:{ *:[nxv16i16] } VRM4:{ *:[nxv16i16] }:$rs1, VRM4:{ *:[nxv16i16] }:$rs2)  =>  (PseudoVSUB_VV_M4:{ *:[nxv16i16] } VRM4:{ *:[nxv16i16] }:$rs1, VRM4:{ *:[nxv16i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVSUB_VV_M4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 55392,
        GIR_Done,
      // Label 251: @3811
      GIM_Reject,
    // Label 249: @3812
    GIM_Reject,
    // Label 191: @3813
    GIM_Try, /*On fail goto*//*Label 252*/ 3896,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv16s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv16s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM8RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM8RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM8RegClassID,
      GIM_Try, /*On fail goto*//*Label 253*/ 3865, // Rule ID 55407 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (sub:{ *:[nxv16i32] } VRM8:{ *:[nxv16i32] }:$rs1, VRM8:{ *:[nxv16i32] }:$rs2)  =>  (PseudoVSUB_VV_M8:{ *:[nxv16i32] } VRM8:{ *:[nxv16i32] }:$rs1, VRM8:{ *:[nxv16i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVSUB_VV_M8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 55407,
        GIR_Done,
      // Label 253: @3865
      GIM_Try, /*On fail goto*//*Label 254*/ 3895, // Rule ID 55408 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (sub:{ *:[nxv16i32] } VRM8:{ *:[nxv16i32] }:$rs1, VRM8:{ *:[nxv16i32] }:$rs2)  =>  (PseudoVSUB_VV_M8:{ *:[nxv16i32] } VRM8:{ *:[nxv16i32] }:$rs1, VRM8:{ *:[nxv16i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVSUB_VV_M8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 55408,
        GIR_Done,
      // Label 254: @3895
      GIM_Reject,
    // Label 252: @3896
    GIM_Reject,
    // Label 192: @3897
    GIM_Try, /*On fail goto*//*Label 255*/ 3980,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv32s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv32s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM4RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM4RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM4RegClassID,
      GIM_Try, /*On fail goto*//*Label 256*/ 3949, // Rule ID 55379 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (sub:{ *:[nxv32i8] } VRM4:{ *:[nxv32i8] }:$rs1, VRM4:{ *:[nxv32i8] }:$rs2)  =>  (PseudoVSUB_VV_M4:{ *:[nxv32i8] } VRM4:{ *:[nxv32i8] }:$rs1, VRM4:{ *:[nxv32i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVSUB_VV_M4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 55379,
        GIR_Done,
      // Label 256: @3949
      GIM_Try, /*On fail goto*//*Label 257*/ 3979, // Rule ID 55380 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (sub:{ *:[nxv32i8] } VRM4:{ *:[nxv32i8] }:$rs1, VRM4:{ *:[nxv32i8] }:$rs2)  =>  (PseudoVSUB_VV_M4:{ *:[nxv32i8] } VRM4:{ *:[nxv32i8] }:$rs1, VRM4:{ *:[nxv32i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVSUB_VV_M4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 55380,
        GIR_Done,
      // Label 257: @3979
      GIM_Reject,
    // Label 255: @3980
    GIM_Reject,
    // Label 193: @3981
    GIM_Try, /*On fail goto*//*Label 258*/ 4064,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv32s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv32s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM8RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM8RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM8RegClassID,
      GIM_Try, /*On fail goto*//*Label 259*/ 4033, // Rule ID 55395 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (sub:{ *:[nxv32i16] } VRM8:{ *:[nxv32i16] }:$rs1, VRM8:{ *:[nxv32i16] }:$rs2)  =>  (PseudoVSUB_VV_M8:{ *:[nxv32i16] } VRM8:{ *:[nxv32i16] }:$rs1, VRM8:{ *:[nxv32i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVSUB_VV_M8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 55395,
        GIR_Done,
      // Label 259: @4033
      GIM_Try, /*On fail goto*//*Label 260*/ 4063, // Rule ID 55396 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (sub:{ *:[nxv32i16] } VRM8:{ *:[nxv32i16] }:$rs1, VRM8:{ *:[nxv32i16] }:$rs2)  =>  (PseudoVSUB_VV_M8:{ *:[nxv32i16] } VRM8:{ *:[nxv32i16] }:$rs1, VRM8:{ *:[nxv32i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVSUB_VV_M8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 55396,
        GIR_Done,
      // Label 260: @4063
      GIM_Reject,
    // Label 258: @4064
    GIM_Reject,
    // Label 194: @4065
    GIM_Try, /*On fail goto*//*Label 261*/ 4148,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv64s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv64s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM8RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM8RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM8RegClassID,
      GIM_Try, /*On fail goto*//*Label 262*/ 4117, // Rule ID 55383 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (sub:{ *:[nxv64i8] } VRM8:{ *:[nxv64i8] }:$rs1, VRM8:{ *:[nxv64i8] }:$rs2)  =>  (PseudoVSUB_VV_M8:{ *:[nxv64i8] } VRM8:{ *:[nxv64i8] }:$rs1, VRM8:{ *:[nxv64i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVSUB_VV_M8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 55383,
        GIR_Done,
      // Label 262: @4117
      GIM_Try, /*On fail goto*//*Label 263*/ 4147, // Rule ID 55384 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (sub:{ *:[nxv64i8] } VRM8:{ *:[nxv64i8] }:$rs1, VRM8:{ *:[nxv64i8] }:$rs2)  =>  (PseudoVSUB_VV_M8:{ *:[nxv64i8] } VRM8:{ *:[nxv64i8] }:$rs1, VRM8:{ *:[nxv64i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVSUB_VV_M8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 55384,
        GIR_Done,
      // Label 263: @4147
      GIM_Reject,
    // Label 261: @4148
    GIM_Reject,
    // Label 195: @4149
    GIM_Reject,
    // Label 2: @4150
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/1, 32, /*)*//*default:*//*Label 288*/ 6214,
    /*GILLT_s32*//*Label 264*/ 4187,
    /*GILLT_s64*//*Label 265*/ 4219, 0,
    /*GILLT_nxv1s8*//*Label 266*/ 4366,
    /*GILLT_nxv1s16*//*Label 267*/ 4450,
    /*GILLT_nxv1s32*//*Label 268*/ 4534,
    /*GILLT_nxv1s64*//*Label 269*/ 4618, 0,
    /*GILLT_nxv2s8*//*Label 270*/ 4702,
    /*GILLT_nxv2s16*//*Label 271*/ 4786,
    /*GILLT_nxv2s32*//*Label 272*/ 4870,
    /*GILLT_nxv2s64*//*Label 273*/ 4954, 0,
    /*GILLT_nxv4s8*//*Label 274*/ 5038,
    /*GILLT_nxv4s16*//*Label 275*/ 5122,
    /*GILLT_nxv4s32*//*Label 276*/ 5206,
    /*GILLT_nxv4s64*//*Label 277*/ 5290, 0,
    /*GILLT_nxv8s8*//*Label 278*/ 5374,
    /*GILLT_nxv8s16*//*Label 279*/ 5458,
    /*GILLT_nxv8s32*//*Label 280*/ 5542,
    /*GILLT_nxv8s64*//*Label 281*/ 5626, 0,
    /*GILLT_nxv16s8*//*Label 282*/ 5710,
    /*GILLT_nxv16s16*//*Label 283*/ 5794,
    /*GILLT_nxv16s32*//*Label 284*/ 5878, 0,
    /*GILLT_nxv32s8*//*Label 285*/ 5962,
    /*GILLT_nxv32s16*//*Label 286*/ 6046, 0,
    /*GILLT_nxv64s8*//*Label 287*/ 6130,
    // Label 264: @4187
    GIM_Try, /*On fail goto*//*Label 289*/ 4218, // Rule ID 63267 //
      GIM_CheckFeatures, GIFBS_HasStdExtMOrZmmul,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
      // (mul:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)  =>  (MUL:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::MUL,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 63267,
      GIR_Done,
    // Label 289: @4218
    GIM_Reject,
    // Label 265: @4219
    GIM_Try, /*On fail goto*//*Label 290*/ 4365,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
      GIM_Try, /*On fail goto*//*Label 291*/ 4345, // Rule ID 63601 //
        GIM_CheckFeatures, GIFBS_HasStdExtMOrZmmul_IsRV64_NotHasStdExtZba,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, 4294967295,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckConstantInt, /*MI*/2, /*Op*/2, 4294967295,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (mul:{ *:[i64] } (and:{ *:[i64] } GPR:{ *:[i64] }:$rs1, 4294967295:{ *:[i64] }), (and:{ *:[i64] } GPR:{ *:[i64] }:$rs2, 4294967295:{ *:[i64] }))  =>  (MULHU:{ *:[i64] } (SLLI:{ *:[i64] } GPR:{ *:[i64] }:$rs1, 32:{ *:[i64] }), (SLLI:{ *:[i64] } GPR:{ *:[i64] }:$rs2, 32:{ *:[i64] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s64,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/RISCV::SLLI,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/2, /*OpIdx*/1, // rs2
        GIR_AddImm, /*InsnID*/2, /*Imm*/32,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/RISCV::SLLI,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/1, // rs1
        GIR_AddImm, /*InsnID*/1, /*Imm*/32,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::MULHU,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/1, /*TempRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 63601,
        GIR_Done,
      // Label 291: @4345
      GIM_Try, /*On fail goto*//*Label 292*/ 4364, // Rule ID 63266 //
        GIM_CheckFeatures, GIFBS_HasStdExtMOrZmmul,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (mul:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)  =>  (MUL:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::MUL,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 63266,
        GIR_Done,
      // Label 292: @4364
      GIM_Reject,
    // Label 290: @4365
    GIM_Reject,
    // Label 266: @4366
    GIM_Try, /*On fail goto*//*Label 293*/ 4449,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv1s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv1s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 294*/ 4418, // Rule ID 59501 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (mul:{ *:[nxv1i8] } VR:{ *:[nxv1i8] }:$rs1, VR:{ *:[nxv1i8] }:$rs2)  =>  (PseudoVMUL_VV_MF8:{ *:[nxv1i8] } VR:{ *:[nxv1i8] }:$rs1, VR:{ *:[nxv1i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMUL_VV_MF8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 59501,
        GIR_Done,
      // Label 294: @4418
      GIM_Try, /*On fail goto*//*Label 295*/ 4448, // Rule ID 59502 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (mul:{ *:[nxv1i8] } VR:{ *:[nxv1i8] }:$rs1, VR:{ *:[nxv1i8] }:$rs2)  =>  (PseudoVMUL_VV_MF8:{ *:[nxv1i8] } VR:{ *:[nxv1i8] }:$rs1, VR:{ *:[nxv1i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMUL_VV_MF8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 59502,
        GIR_Done,
      // Label 295: @4448
      GIM_Reject,
    // Label 293: @4449
    GIM_Reject,
    // Label 267: @4450
    GIM_Try, /*On fail goto*//*Label 296*/ 4533,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv1s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv1s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 297*/ 4502, // Rule ID 59513 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (mul:{ *:[nxv1i16] } VR:{ *:[nxv1i16] }:$rs1, VR:{ *:[nxv1i16] }:$rs2)  =>  (PseudoVMUL_VV_MF4:{ *:[nxv1i16] } VR:{ *:[nxv1i16] }:$rs1, VR:{ *:[nxv1i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMUL_VV_MF4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 59513,
        GIR_Done,
      // Label 297: @4502
      GIM_Try, /*On fail goto*//*Label 298*/ 4532, // Rule ID 59514 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (mul:{ *:[nxv1i16] } VR:{ *:[nxv1i16] }:$rs1, VR:{ *:[nxv1i16] }:$rs2)  =>  (PseudoVMUL_VV_MF4:{ *:[nxv1i16] } VR:{ *:[nxv1i16] }:$rs1, VR:{ *:[nxv1i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMUL_VV_MF4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 59514,
        GIR_Done,
      // Label 298: @4532
      GIM_Reject,
    // Label 296: @4533
    GIM_Reject,
    // Label 268: @4534
    GIM_Try, /*On fail goto*//*Label 299*/ 4617,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv1s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv1s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 300*/ 4586, // Rule ID 59521 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (mul:{ *:[nxv1i32] } VR:{ *:[nxv1i32] }:$rs1, VR:{ *:[nxv1i32] }:$rs2)  =>  (PseudoVMUL_VV_MF2:{ *:[nxv1i32] } VR:{ *:[nxv1i32] }:$rs1, VR:{ *:[nxv1i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMUL_VV_MF2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 59521,
        GIR_Done,
      // Label 300: @4586
      GIM_Try, /*On fail goto*//*Label 301*/ 4616, // Rule ID 59522 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (mul:{ *:[nxv1i32] } VR:{ *:[nxv1i32] }:$rs1, VR:{ *:[nxv1i32] }:$rs2)  =>  (PseudoVMUL_VV_MF2:{ *:[nxv1i32] } VR:{ *:[nxv1i32] }:$rs1, VR:{ *:[nxv1i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMUL_VV_MF2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 59522,
        GIR_Done,
      // Label 301: @4616
      GIM_Reject,
    // Label 299: @4617
    GIM_Reject,
    // Label 269: @4618
    GIM_Try, /*On fail goto*//*Label 302*/ 4701,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv1s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv1s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 303*/ 4670, // Rule ID 59537 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (mul:{ *:[nxv1i64] } VR:{ *:[nxv1i64] }:$rs1, VR:{ *:[nxv1i64] }:$rs2)  =>  (PseudoVMUL_VV_M1:{ *:[nxv1i64] } VR:{ *:[nxv1i64] }:$rs1, VR:{ *:[nxv1i64] }:$rs2, -1:{ *:[i64] }, 6:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMUL_VV_M1,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 59537,
        GIR_Done,
      // Label 303: @4670
      GIM_Try, /*On fail goto*//*Label 304*/ 4700, // Rule ID 59538 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (mul:{ *:[nxv1i64] } VR:{ *:[nxv1i64] }:$rs1, VR:{ *:[nxv1i64] }:$rs2)  =>  (PseudoVMUL_VV_M1:{ *:[nxv1i64] } VR:{ *:[nxv1i64] }:$rs1, VR:{ *:[nxv1i64] }:$rs2, -1:{ *:[i32] }, 6:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMUL_VV_M1,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 59538,
        GIR_Done,
      // Label 304: @4700
      GIM_Reject,
    // Label 302: @4701
    GIM_Reject,
    // Label 270: @4702
    GIM_Try, /*On fail goto*//*Label 305*/ 4785,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv2s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv2s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 306*/ 4754, // Rule ID 59505 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (mul:{ *:[nxv2i8] } VR:{ *:[nxv2i8] }:$rs1, VR:{ *:[nxv2i8] }:$rs2)  =>  (PseudoVMUL_VV_MF4:{ *:[nxv2i8] } VR:{ *:[nxv2i8] }:$rs1, VR:{ *:[nxv2i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMUL_VV_MF4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 59505,
        GIR_Done,
      // Label 306: @4754
      GIM_Try, /*On fail goto*//*Label 307*/ 4784, // Rule ID 59506 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (mul:{ *:[nxv2i8] } VR:{ *:[nxv2i8] }:$rs1, VR:{ *:[nxv2i8] }:$rs2)  =>  (PseudoVMUL_VV_MF4:{ *:[nxv2i8] } VR:{ *:[nxv2i8] }:$rs1, VR:{ *:[nxv2i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMUL_VV_MF4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 59506,
        GIR_Done,
      // Label 307: @4784
      GIM_Reject,
    // Label 305: @4785
    GIM_Reject,
    // Label 271: @4786
    GIM_Try, /*On fail goto*//*Label 308*/ 4869,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv2s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv2s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 309*/ 4838, // Rule ID 59517 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (mul:{ *:[nxv2i16] } VR:{ *:[nxv2i16] }:$rs1, VR:{ *:[nxv2i16] }:$rs2)  =>  (PseudoVMUL_VV_MF2:{ *:[nxv2i16] } VR:{ *:[nxv2i16] }:$rs1, VR:{ *:[nxv2i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMUL_VV_MF2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 59517,
        GIR_Done,
      // Label 309: @4838
      GIM_Try, /*On fail goto*//*Label 310*/ 4868, // Rule ID 59518 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (mul:{ *:[nxv2i16] } VR:{ *:[nxv2i16] }:$rs1, VR:{ *:[nxv2i16] }:$rs2)  =>  (PseudoVMUL_VV_MF2:{ *:[nxv2i16] } VR:{ *:[nxv2i16] }:$rs1, VR:{ *:[nxv2i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMUL_VV_MF2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 59518,
        GIR_Done,
      // Label 310: @4868
      GIM_Reject,
    // Label 308: @4869
    GIM_Reject,
    // Label 272: @4870
    GIM_Try, /*On fail goto*//*Label 311*/ 4953,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv2s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv2s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 312*/ 4922, // Rule ID 59533 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (mul:{ *:[nxv2i32] } VR:{ *:[nxv2i32] }:$rs1, VR:{ *:[nxv2i32] }:$rs2)  =>  (PseudoVMUL_VV_M1:{ *:[nxv2i32] } VR:{ *:[nxv2i32] }:$rs1, VR:{ *:[nxv2i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMUL_VV_M1,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 59533,
        GIR_Done,
      // Label 312: @4922
      GIM_Try, /*On fail goto*//*Label 313*/ 4952, // Rule ID 59534 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (mul:{ *:[nxv2i32] } VR:{ *:[nxv2i32] }:$rs1, VR:{ *:[nxv2i32] }:$rs2)  =>  (PseudoVMUL_VV_M1:{ *:[nxv2i32] } VR:{ *:[nxv2i32] }:$rs1, VR:{ *:[nxv2i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMUL_VV_M1,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 59534,
        GIR_Done,
      // Label 313: @4952
      GIM_Reject,
    // Label 311: @4953
    GIM_Reject,
    // Label 273: @4954
    GIM_Try, /*On fail goto*//*Label 314*/ 5037,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv2s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM2RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM2RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM2RegClassID,
      GIM_Try, /*On fail goto*//*Label 315*/ 5006, // Rule ID 59577 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (mul:{ *:[nxv2i64] } VRM2:{ *:[nxv2i64] }:$rs1, VRM2:{ *:[nxv2i64] }:$rs2)  =>  (PseudoVMUL_VV_M2:{ *:[nxv2i64] } VRM2:{ *:[nxv2i64] }:$rs1, VRM2:{ *:[nxv2i64] }:$rs2, -1:{ *:[i64] }, 6:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMUL_VV_M2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 59577,
        GIR_Done,
      // Label 315: @5006
      GIM_Try, /*On fail goto*//*Label 316*/ 5036, // Rule ID 59578 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (mul:{ *:[nxv2i64] } VRM2:{ *:[nxv2i64] }:$rs1, VRM2:{ *:[nxv2i64] }:$rs2)  =>  (PseudoVMUL_VV_M2:{ *:[nxv2i64] } VRM2:{ *:[nxv2i64] }:$rs1, VRM2:{ *:[nxv2i64] }:$rs2, -1:{ *:[i32] }, 6:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMUL_VV_M2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 59578,
        GIR_Done,
      // Label 316: @5036
      GIM_Reject,
    // Label 314: @5037
    GIM_Reject,
    // Label 274: @5038
    GIM_Try, /*On fail goto*//*Label 317*/ 5121,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv4s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv4s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 318*/ 5090, // Rule ID 59509 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (mul:{ *:[nxv4i8] } VR:{ *:[nxv4i8] }:$rs1, VR:{ *:[nxv4i8] }:$rs2)  =>  (PseudoVMUL_VV_MF2:{ *:[nxv4i8] } VR:{ *:[nxv4i8] }:$rs1, VR:{ *:[nxv4i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMUL_VV_MF2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 59509,
        GIR_Done,
      // Label 318: @5090
      GIM_Try, /*On fail goto*//*Label 319*/ 5120, // Rule ID 59510 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (mul:{ *:[nxv4i8] } VR:{ *:[nxv4i8] }:$rs1, VR:{ *:[nxv4i8] }:$rs2)  =>  (PseudoVMUL_VV_MF2:{ *:[nxv4i8] } VR:{ *:[nxv4i8] }:$rs1, VR:{ *:[nxv4i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMUL_VV_MF2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 59510,
        GIR_Done,
      // Label 319: @5120
      GIM_Reject,
    // Label 317: @5121
    GIM_Reject,
    // Label 275: @5122
    GIM_Try, /*On fail goto*//*Label 320*/ 5205,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv4s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv4s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 321*/ 5174, // Rule ID 59529 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (mul:{ *:[nxv4i16] } VR:{ *:[nxv4i16] }:$rs1, VR:{ *:[nxv4i16] }:$rs2)  =>  (PseudoVMUL_VV_M1:{ *:[nxv4i16] } VR:{ *:[nxv4i16] }:$rs1, VR:{ *:[nxv4i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMUL_VV_M1,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 59529,
        GIR_Done,
      // Label 321: @5174
      GIM_Try, /*On fail goto*//*Label 322*/ 5204, // Rule ID 59530 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (mul:{ *:[nxv4i16] } VR:{ *:[nxv4i16] }:$rs1, VR:{ *:[nxv4i16] }:$rs2)  =>  (PseudoVMUL_VV_M1:{ *:[nxv4i16] } VR:{ *:[nxv4i16] }:$rs1, VR:{ *:[nxv4i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMUL_VV_M1,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 59530,
        GIR_Done,
      // Label 322: @5204
      GIM_Reject,
    // Label 320: @5205
    GIM_Reject,
    // Label 276: @5206
    GIM_Try, /*On fail goto*//*Label 323*/ 5289,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv4s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM2RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM2RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM2RegClassID,
      GIM_Try, /*On fail goto*//*Label 324*/ 5258, // Rule ID 59565 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (mul:{ *:[nxv4i32] } VRM2:{ *:[nxv4i32] }:$rs1, VRM2:{ *:[nxv4i32] }:$rs2)  =>  (PseudoVMUL_VV_M2:{ *:[nxv4i32] } VRM2:{ *:[nxv4i32] }:$rs1, VRM2:{ *:[nxv4i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMUL_VV_M2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 59565,
        GIR_Done,
      // Label 324: @5258
      GIM_Try, /*On fail goto*//*Label 325*/ 5288, // Rule ID 59566 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (mul:{ *:[nxv4i32] } VRM2:{ *:[nxv4i32] }:$rs1, VRM2:{ *:[nxv4i32] }:$rs2)  =>  (PseudoVMUL_VV_M2:{ *:[nxv4i32] } VRM2:{ *:[nxv4i32] }:$rs1, VRM2:{ *:[nxv4i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMUL_VV_M2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 59566,
        GIR_Done,
      // Label 325: @5288
      GIM_Reject,
    // Label 323: @5289
    GIM_Reject,
    // Label 277: @5290
    GIM_Try, /*On fail goto*//*Label 326*/ 5373,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv4s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv4s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM4RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM4RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM4RegClassID,
      GIM_Try, /*On fail goto*//*Label 327*/ 5342, // Rule ID 59581 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (mul:{ *:[nxv4i64] } VRM4:{ *:[nxv4i64] }:$rs1, VRM4:{ *:[nxv4i64] }:$rs2)  =>  (PseudoVMUL_VV_M4:{ *:[nxv4i64] } VRM4:{ *:[nxv4i64] }:$rs1, VRM4:{ *:[nxv4i64] }:$rs2, -1:{ *:[i64] }, 6:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMUL_VV_M4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 59581,
        GIR_Done,
      // Label 327: @5342
      GIM_Try, /*On fail goto*//*Label 328*/ 5372, // Rule ID 59582 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (mul:{ *:[nxv4i64] } VRM4:{ *:[nxv4i64] }:$rs1, VRM4:{ *:[nxv4i64] }:$rs2)  =>  (PseudoVMUL_VV_M4:{ *:[nxv4i64] } VRM4:{ *:[nxv4i64] }:$rs1, VRM4:{ *:[nxv4i64] }:$rs2, -1:{ *:[i32] }, 6:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMUL_VV_M4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 59582,
        GIR_Done,
      // Label 328: @5372
      GIM_Reject,
    // Label 326: @5373
    GIM_Reject,
    // Label 278: @5374
    GIM_Try, /*On fail goto*//*Label 329*/ 5457,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv8s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv8s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 330*/ 5426, // Rule ID 59525 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (mul:{ *:[nxv8i8] } VR:{ *:[nxv8i8] }:$rs1, VR:{ *:[nxv8i8] }:$rs2)  =>  (PseudoVMUL_VV_M1:{ *:[nxv8i8] } VR:{ *:[nxv8i8] }:$rs1, VR:{ *:[nxv8i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMUL_VV_M1,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 59525,
        GIR_Done,
      // Label 330: @5426
      GIM_Try, /*On fail goto*//*Label 331*/ 5456, // Rule ID 59526 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (mul:{ *:[nxv8i8] } VR:{ *:[nxv8i8] }:$rs1, VR:{ *:[nxv8i8] }:$rs2)  =>  (PseudoVMUL_VV_M1:{ *:[nxv8i8] } VR:{ *:[nxv8i8] }:$rs1, VR:{ *:[nxv8i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMUL_VV_M1,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 59526,
        GIR_Done,
      // Label 331: @5456
      GIM_Reject,
    // Label 329: @5457
    GIM_Reject,
    // Label 279: @5458
    GIM_Try, /*On fail goto*//*Label 332*/ 5541,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv8s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM2RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM2RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM2RegClassID,
      GIM_Try, /*On fail goto*//*Label 333*/ 5510, // Rule ID 59553 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (mul:{ *:[nxv8i16] } VRM2:{ *:[nxv8i16] }:$rs1, VRM2:{ *:[nxv8i16] }:$rs2)  =>  (PseudoVMUL_VV_M2:{ *:[nxv8i16] } VRM2:{ *:[nxv8i16] }:$rs1, VRM2:{ *:[nxv8i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMUL_VV_M2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 59553,
        GIR_Done,
      // Label 333: @5510
      GIM_Try, /*On fail goto*//*Label 334*/ 5540, // Rule ID 59554 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (mul:{ *:[nxv8i16] } VRM2:{ *:[nxv8i16] }:$rs1, VRM2:{ *:[nxv8i16] }:$rs2)  =>  (PseudoVMUL_VV_M2:{ *:[nxv8i16] } VRM2:{ *:[nxv8i16] }:$rs1, VRM2:{ *:[nxv8i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMUL_VV_M2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 59554,
        GIR_Done,
      // Label 334: @5540
      GIM_Reject,
    // Label 332: @5541
    GIM_Reject,
    // Label 280: @5542
    GIM_Try, /*On fail goto*//*Label 335*/ 5625,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv8s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv8s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM4RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM4RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM4RegClassID,
      GIM_Try, /*On fail goto*//*Label 336*/ 5594, // Rule ID 59569 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (mul:{ *:[nxv8i32] } VRM4:{ *:[nxv8i32] }:$rs1, VRM4:{ *:[nxv8i32] }:$rs2)  =>  (PseudoVMUL_VV_M4:{ *:[nxv8i32] } VRM4:{ *:[nxv8i32] }:$rs1, VRM4:{ *:[nxv8i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMUL_VV_M4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 59569,
        GIR_Done,
      // Label 336: @5594
      GIM_Try, /*On fail goto*//*Label 337*/ 5624, // Rule ID 59570 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (mul:{ *:[nxv8i32] } VRM4:{ *:[nxv8i32] }:$rs1, VRM4:{ *:[nxv8i32] }:$rs2)  =>  (PseudoVMUL_VV_M4:{ *:[nxv8i32] } VRM4:{ *:[nxv8i32] }:$rs1, VRM4:{ *:[nxv8i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMUL_VV_M4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 59570,
        GIR_Done,
      // Label 337: @5624
      GIM_Reject,
    // Label 335: @5625
    GIM_Reject,
    // Label 281: @5626
    GIM_Try, /*On fail goto*//*Label 338*/ 5709,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv8s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv8s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM8RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM8RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM8RegClassID,
      GIM_Try, /*On fail goto*//*Label 339*/ 5678, // Rule ID 59585 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (mul:{ *:[nxv8i64] } VRM8:{ *:[nxv8i64] }:$rs1, VRM8:{ *:[nxv8i64] }:$rs2)  =>  (PseudoVMUL_VV_M8:{ *:[nxv8i64] } VRM8:{ *:[nxv8i64] }:$rs1, VRM8:{ *:[nxv8i64] }:$rs2, -1:{ *:[i64] }, 6:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMUL_VV_M8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 59585,
        GIR_Done,
      // Label 339: @5678
      GIM_Try, /*On fail goto*//*Label 340*/ 5708, // Rule ID 59586 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (mul:{ *:[nxv8i64] } VRM8:{ *:[nxv8i64] }:$rs1, VRM8:{ *:[nxv8i64] }:$rs2)  =>  (PseudoVMUL_VV_M8:{ *:[nxv8i64] } VRM8:{ *:[nxv8i64] }:$rs1, VRM8:{ *:[nxv8i64] }:$rs2, -1:{ *:[i32] }, 6:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMUL_VV_M8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 59586,
        GIR_Done,
      // Label 340: @5708
      GIM_Reject,
    // Label 338: @5709
    GIM_Reject,
    // Label 282: @5710
    GIM_Try, /*On fail goto*//*Label 341*/ 5793,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv16s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv16s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM2RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM2RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM2RegClassID,
      GIM_Try, /*On fail goto*//*Label 342*/ 5762, // Rule ID 59541 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (mul:{ *:[nxv16i8] } VRM2:{ *:[nxv16i8] }:$rs1, VRM2:{ *:[nxv16i8] }:$rs2)  =>  (PseudoVMUL_VV_M2:{ *:[nxv16i8] } VRM2:{ *:[nxv16i8] }:$rs1, VRM2:{ *:[nxv16i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMUL_VV_M2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 59541,
        GIR_Done,
      // Label 342: @5762
      GIM_Try, /*On fail goto*//*Label 343*/ 5792, // Rule ID 59542 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (mul:{ *:[nxv16i8] } VRM2:{ *:[nxv16i8] }:$rs1, VRM2:{ *:[nxv16i8] }:$rs2)  =>  (PseudoVMUL_VV_M2:{ *:[nxv16i8] } VRM2:{ *:[nxv16i8] }:$rs1, VRM2:{ *:[nxv16i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMUL_VV_M2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 59542,
        GIR_Done,
      // Label 343: @5792
      GIM_Reject,
    // Label 341: @5793
    GIM_Reject,
    // Label 283: @5794
    GIM_Try, /*On fail goto*//*Label 344*/ 5877,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv16s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv16s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM4RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM4RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM4RegClassID,
      GIM_Try, /*On fail goto*//*Label 345*/ 5846, // Rule ID 59557 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (mul:{ *:[nxv16i16] } VRM4:{ *:[nxv16i16] }:$rs1, VRM4:{ *:[nxv16i16] }:$rs2)  =>  (PseudoVMUL_VV_M4:{ *:[nxv16i16] } VRM4:{ *:[nxv16i16] }:$rs1, VRM4:{ *:[nxv16i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMUL_VV_M4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 59557,
        GIR_Done,
      // Label 345: @5846
      GIM_Try, /*On fail goto*//*Label 346*/ 5876, // Rule ID 59558 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (mul:{ *:[nxv16i16] } VRM4:{ *:[nxv16i16] }:$rs1, VRM4:{ *:[nxv16i16] }:$rs2)  =>  (PseudoVMUL_VV_M4:{ *:[nxv16i16] } VRM4:{ *:[nxv16i16] }:$rs1, VRM4:{ *:[nxv16i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMUL_VV_M4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 59558,
        GIR_Done,
      // Label 346: @5876
      GIM_Reject,
    // Label 344: @5877
    GIM_Reject,
    // Label 284: @5878
    GIM_Try, /*On fail goto*//*Label 347*/ 5961,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv16s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv16s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM8RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM8RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM8RegClassID,
      GIM_Try, /*On fail goto*//*Label 348*/ 5930, // Rule ID 59573 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (mul:{ *:[nxv16i32] } VRM8:{ *:[nxv16i32] }:$rs1, VRM8:{ *:[nxv16i32] }:$rs2)  =>  (PseudoVMUL_VV_M8:{ *:[nxv16i32] } VRM8:{ *:[nxv16i32] }:$rs1, VRM8:{ *:[nxv16i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMUL_VV_M8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 59573,
        GIR_Done,
      // Label 348: @5930
      GIM_Try, /*On fail goto*//*Label 349*/ 5960, // Rule ID 59574 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (mul:{ *:[nxv16i32] } VRM8:{ *:[nxv16i32] }:$rs1, VRM8:{ *:[nxv16i32] }:$rs2)  =>  (PseudoVMUL_VV_M8:{ *:[nxv16i32] } VRM8:{ *:[nxv16i32] }:$rs1, VRM8:{ *:[nxv16i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMUL_VV_M8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 59574,
        GIR_Done,
      // Label 349: @5960
      GIM_Reject,
    // Label 347: @5961
    GIM_Reject,
    // Label 285: @5962
    GIM_Try, /*On fail goto*//*Label 350*/ 6045,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv32s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv32s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM4RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM4RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM4RegClassID,
      GIM_Try, /*On fail goto*//*Label 351*/ 6014, // Rule ID 59545 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (mul:{ *:[nxv32i8] } VRM4:{ *:[nxv32i8] }:$rs1, VRM4:{ *:[nxv32i8] }:$rs2)  =>  (PseudoVMUL_VV_M4:{ *:[nxv32i8] } VRM4:{ *:[nxv32i8] }:$rs1, VRM4:{ *:[nxv32i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMUL_VV_M4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 59545,
        GIR_Done,
      // Label 351: @6014
      GIM_Try, /*On fail goto*//*Label 352*/ 6044, // Rule ID 59546 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (mul:{ *:[nxv32i8] } VRM4:{ *:[nxv32i8] }:$rs1, VRM4:{ *:[nxv32i8] }:$rs2)  =>  (PseudoVMUL_VV_M4:{ *:[nxv32i8] } VRM4:{ *:[nxv32i8] }:$rs1, VRM4:{ *:[nxv32i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMUL_VV_M4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 59546,
        GIR_Done,
      // Label 352: @6044
      GIM_Reject,
    // Label 350: @6045
    GIM_Reject,
    // Label 286: @6046
    GIM_Try, /*On fail goto*//*Label 353*/ 6129,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv32s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv32s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM8RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM8RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM8RegClassID,
      GIM_Try, /*On fail goto*//*Label 354*/ 6098, // Rule ID 59561 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (mul:{ *:[nxv32i16] } VRM8:{ *:[nxv32i16] }:$rs1, VRM8:{ *:[nxv32i16] }:$rs2)  =>  (PseudoVMUL_VV_M8:{ *:[nxv32i16] } VRM8:{ *:[nxv32i16] }:$rs1, VRM8:{ *:[nxv32i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMUL_VV_M8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 59561,
        GIR_Done,
      // Label 354: @6098
      GIM_Try, /*On fail goto*//*Label 355*/ 6128, // Rule ID 59562 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (mul:{ *:[nxv32i16] } VRM8:{ *:[nxv32i16] }:$rs1, VRM8:{ *:[nxv32i16] }:$rs2)  =>  (PseudoVMUL_VV_M8:{ *:[nxv32i16] } VRM8:{ *:[nxv32i16] }:$rs1, VRM8:{ *:[nxv32i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMUL_VV_M8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 59562,
        GIR_Done,
      // Label 355: @6128
      GIM_Reject,
    // Label 353: @6129
    GIM_Reject,
    // Label 287: @6130
    GIM_Try, /*On fail goto*//*Label 356*/ 6213,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv64s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv64s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM8RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM8RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM8RegClassID,
      GIM_Try, /*On fail goto*//*Label 357*/ 6182, // Rule ID 59549 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (mul:{ *:[nxv64i8] } VRM8:{ *:[nxv64i8] }:$rs1, VRM8:{ *:[nxv64i8] }:$rs2)  =>  (PseudoVMUL_VV_M8:{ *:[nxv64i8] } VRM8:{ *:[nxv64i8] }:$rs1, VRM8:{ *:[nxv64i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMUL_VV_M8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 59549,
        GIR_Done,
      // Label 357: @6182
      GIM_Try, /*On fail goto*//*Label 358*/ 6212, // Rule ID 59550 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (mul:{ *:[nxv64i8] } VRM8:{ *:[nxv64i8] }:$rs1, VRM8:{ *:[nxv64i8] }:$rs2)  =>  (PseudoVMUL_VV_M8:{ *:[nxv64i8] } VRM8:{ *:[nxv64i8] }:$rs1, VRM8:{ *:[nxv64i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMUL_VV_M8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 59550,
        GIR_Done,
      // Label 358: @6212
      GIM_Reject,
    // Label 356: @6213
    GIM_Reject,
    // Label 288: @6214
    GIM_Reject,
    // Label 3: @6215
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/1, 32, /*)*//*default:*//*Label 383*/ 8164,
    /*GILLT_s32*//*Label 359*/ 6252,
    /*GILLT_s64*//*Label 360*/ 6284, 0,
    /*GILLT_nxv1s8*//*Label 361*/ 6316,
    /*GILLT_nxv1s16*//*Label 362*/ 6400,
    /*GILLT_nxv1s32*//*Label 363*/ 6484,
    /*GILLT_nxv1s64*//*Label 364*/ 6568, 0,
    /*GILLT_nxv2s8*//*Label 365*/ 6652,
    /*GILLT_nxv2s16*//*Label 366*/ 6736,
    /*GILLT_nxv2s32*//*Label 367*/ 6820,
    /*GILLT_nxv2s64*//*Label 368*/ 6904, 0,
    /*GILLT_nxv4s8*//*Label 369*/ 6988,
    /*GILLT_nxv4s16*//*Label 370*/ 7072,
    /*GILLT_nxv4s32*//*Label 371*/ 7156,
    /*GILLT_nxv4s64*//*Label 372*/ 7240, 0,
    /*GILLT_nxv8s8*//*Label 373*/ 7324,
    /*GILLT_nxv8s16*//*Label 374*/ 7408,
    /*GILLT_nxv8s32*//*Label 375*/ 7492,
    /*GILLT_nxv8s64*//*Label 376*/ 7576, 0,
    /*GILLT_nxv16s8*//*Label 377*/ 7660,
    /*GILLT_nxv16s16*//*Label 378*/ 7744,
    /*GILLT_nxv16s32*//*Label 379*/ 7828, 0,
    /*GILLT_nxv32s8*//*Label 380*/ 7912,
    /*GILLT_nxv32s16*//*Label 381*/ 7996, 0,
    /*GILLT_nxv64s8*//*Label 382*/ 8080,
    // Label 359: @6252
    GIM_Try, /*On fail goto*//*Label 384*/ 6283, // Rule ID 63353 //
      GIM_CheckFeatures, GIFBS_HasStdExtM,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
      // (sdiv:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)  =>  (DIV:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::DIV,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 63353,
      GIR_Done,
    // Label 384: @6283
    GIM_Reject,
    // Label 360: @6284
    GIM_Try, /*On fail goto*//*Label 385*/ 6315, // Rule ID 63352 //
      GIM_CheckFeatures, GIFBS_HasStdExtM,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
      // (sdiv:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)  =>  (DIV:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::DIV,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 63352,
      GIR_Done,
    // Label 385: @6315
    GIM_Reject,
    // Label 361: @6316
    GIM_Try, /*On fail goto*//*Label 386*/ 6399,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv1s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv1s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 387*/ 6368, // Rule ID 59859 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (sdiv:{ *:[nxv1i8] } VR:{ *:[nxv1i8] }:$rs1, VR:{ *:[nxv1i8] }:$rs2)  =>  (PseudoVDIV_VV_MF8:{ *:[nxv1i8] } VR:{ *:[nxv1i8] }:$rs1, VR:{ *:[nxv1i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIV_VV_MF8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 59859,
        GIR_Done,
      // Label 387: @6368
      GIM_Try, /*On fail goto*//*Label 388*/ 6398, // Rule ID 59860 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (sdiv:{ *:[nxv1i8] } VR:{ *:[nxv1i8] }:$rs1, VR:{ *:[nxv1i8] }:$rs2)  =>  (PseudoVDIV_VV_MF8:{ *:[nxv1i8] } VR:{ *:[nxv1i8] }:$rs1, VR:{ *:[nxv1i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIV_VV_MF8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 59860,
        GIR_Done,
      // Label 388: @6398
      GIM_Reject,
    // Label 386: @6399
    GIM_Reject,
    // Label 362: @6400
    GIM_Try, /*On fail goto*//*Label 389*/ 6483,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv1s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv1s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 390*/ 6452, // Rule ID 59873 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (sdiv:{ *:[nxv1i16] } VR:{ *:[nxv1i16] }:$rs1, VR:{ *:[nxv1i16] }:$rs2)  =>  (PseudoVDIV_VV_MF4:{ *:[nxv1i16] } VR:{ *:[nxv1i16] }:$rs1, VR:{ *:[nxv1i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIV_VV_MF4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 59873,
        GIR_Done,
      // Label 390: @6452
      GIM_Try, /*On fail goto*//*Label 391*/ 6482, // Rule ID 59874 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (sdiv:{ *:[nxv1i16] } VR:{ *:[nxv1i16] }:$rs1, VR:{ *:[nxv1i16] }:$rs2)  =>  (PseudoVDIV_VV_MF4:{ *:[nxv1i16] } VR:{ *:[nxv1i16] }:$rs1, VR:{ *:[nxv1i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIV_VV_MF4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 59874,
        GIR_Done,
      // Label 391: @6482
      GIM_Reject,
    // Label 389: @6483
    GIM_Reject,
    // Label 363: @6484
    GIM_Try, /*On fail goto*//*Label 392*/ 6567,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv1s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv1s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 393*/ 6536, // Rule ID 59881 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (sdiv:{ *:[nxv1i32] } VR:{ *:[nxv1i32] }:$rs1, VR:{ *:[nxv1i32] }:$rs2)  =>  (PseudoVDIV_VV_MF2:{ *:[nxv1i32] } VR:{ *:[nxv1i32] }:$rs1, VR:{ *:[nxv1i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIV_VV_MF2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 59881,
        GIR_Done,
      // Label 393: @6536
      GIM_Try, /*On fail goto*//*Label 394*/ 6566, // Rule ID 59882 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (sdiv:{ *:[nxv1i32] } VR:{ *:[nxv1i32] }:$rs1, VR:{ *:[nxv1i32] }:$rs2)  =>  (PseudoVDIV_VV_MF2:{ *:[nxv1i32] } VR:{ *:[nxv1i32] }:$rs1, VR:{ *:[nxv1i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIV_VV_MF2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 59882,
        GIR_Done,
      // Label 394: @6566
      GIM_Reject,
    // Label 392: @6567
    GIM_Reject,
    // Label 364: @6568
    GIM_Try, /*On fail goto*//*Label 395*/ 6651,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv1s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv1s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 396*/ 6620, // Rule ID 59899 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (sdiv:{ *:[nxv1i64] } VR:{ *:[nxv1i64] }:$rs1, VR:{ *:[nxv1i64] }:$rs2)  =>  (PseudoVDIV_VV_M1:{ *:[nxv1i64] } VR:{ *:[nxv1i64] }:$rs1, VR:{ *:[nxv1i64] }:$rs2, -1:{ *:[i64] }, 6:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIV_VV_M1,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 59899,
        GIR_Done,
      // Label 396: @6620
      GIM_Try, /*On fail goto*//*Label 397*/ 6650, // Rule ID 59900 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (sdiv:{ *:[nxv1i64] } VR:{ *:[nxv1i64] }:$rs1, VR:{ *:[nxv1i64] }:$rs2)  =>  (PseudoVDIV_VV_M1:{ *:[nxv1i64] } VR:{ *:[nxv1i64] }:$rs1, VR:{ *:[nxv1i64] }:$rs2, -1:{ *:[i32] }, 6:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIV_VV_M1,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 59900,
        GIR_Done,
      // Label 397: @6650
      GIM_Reject,
    // Label 395: @6651
    GIM_Reject,
    // Label 365: @6652
    GIM_Try, /*On fail goto*//*Label 398*/ 6735,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv2s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv2s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 399*/ 6704, // Rule ID 59863 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (sdiv:{ *:[nxv2i8] } VR:{ *:[nxv2i8] }:$rs1, VR:{ *:[nxv2i8] }:$rs2)  =>  (PseudoVDIV_VV_MF4:{ *:[nxv2i8] } VR:{ *:[nxv2i8] }:$rs1, VR:{ *:[nxv2i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIV_VV_MF4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 59863,
        GIR_Done,
      // Label 399: @6704
      GIM_Try, /*On fail goto*//*Label 400*/ 6734, // Rule ID 59864 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (sdiv:{ *:[nxv2i8] } VR:{ *:[nxv2i8] }:$rs1, VR:{ *:[nxv2i8] }:$rs2)  =>  (PseudoVDIV_VV_MF4:{ *:[nxv2i8] } VR:{ *:[nxv2i8] }:$rs1, VR:{ *:[nxv2i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIV_VV_MF4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 59864,
        GIR_Done,
      // Label 400: @6734
      GIM_Reject,
    // Label 398: @6735
    GIM_Reject,
    // Label 366: @6736
    GIM_Try, /*On fail goto*//*Label 401*/ 6819,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv2s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv2s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 402*/ 6788, // Rule ID 59877 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (sdiv:{ *:[nxv2i16] } VR:{ *:[nxv2i16] }:$rs1, VR:{ *:[nxv2i16] }:$rs2)  =>  (PseudoVDIV_VV_MF2:{ *:[nxv2i16] } VR:{ *:[nxv2i16] }:$rs1, VR:{ *:[nxv2i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIV_VV_MF2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 59877,
        GIR_Done,
      // Label 402: @6788
      GIM_Try, /*On fail goto*//*Label 403*/ 6818, // Rule ID 59878 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (sdiv:{ *:[nxv2i16] } VR:{ *:[nxv2i16] }:$rs1, VR:{ *:[nxv2i16] }:$rs2)  =>  (PseudoVDIV_VV_MF2:{ *:[nxv2i16] } VR:{ *:[nxv2i16] }:$rs1, VR:{ *:[nxv2i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIV_VV_MF2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 59878,
        GIR_Done,
      // Label 403: @6818
      GIM_Reject,
    // Label 401: @6819
    GIM_Reject,
    // Label 367: @6820
    GIM_Try, /*On fail goto*//*Label 404*/ 6903,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv2s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv2s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 405*/ 6872, // Rule ID 59895 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (sdiv:{ *:[nxv2i32] } VR:{ *:[nxv2i32] }:$rs1, VR:{ *:[nxv2i32] }:$rs2)  =>  (PseudoVDIV_VV_M1:{ *:[nxv2i32] } VR:{ *:[nxv2i32] }:$rs1, VR:{ *:[nxv2i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIV_VV_M1,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 59895,
        GIR_Done,
      // Label 405: @6872
      GIM_Try, /*On fail goto*//*Label 406*/ 6902, // Rule ID 59896 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (sdiv:{ *:[nxv2i32] } VR:{ *:[nxv2i32] }:$rs1, VR:{ *:[nxv2i32] }:$rs2)  =>  (PseudoVDIV_VV_M1:{ *:[nxv2i32] } VR:{ *:[nxv2i32] }:$rs1, VR:{ *:[nxv2i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIV_VV_M1,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 59896,
        GIR_Done,
      // Label 406: @6902
      GIM_Reject,
    // Label 404: @6903
    GIM_Reject,
    // Label 368: @6904
    GIM_Try, /*On fail goto*//*Label 407*/ 6987,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv2s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM2RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM2RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM2RegClassID,
      GIM_Try, /*On fail goto*//*Label 408*/ 6956, // Rule ID 59943 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (sdiv:{ *:[nxv2i64] } VRM2:{ *:[nxv2i64] }:$rs1, VRM2:{ *:[nxv2i64] }:$rs2)  =>  (PseudoVDIV_VV_M2:{ *:[nxv2i64] } VRM2:{ *:[nxv2i64] }:$rs1, VRM2:{ *:[nxv2i64] }:$rs2, -1:{ *:[i64] }, 6:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIV_VV_M2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 59943,
        GIR_Done,
      // Label 408: @6956
      GIM_Try, /*On fail goto*//*Label 409*/ 6986, // Rule ID 59944 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (sdiv:{ *:[nxv2i64] } VRM2:{ *:[nxv2i64] }:$rs1, VRM2:{ *:[nxv2i64] }:$rs2)  =>  (PseudoVDIV_VV_M2:{ *:[nxv2i64] } VRM2:{ *:[nxv2i64] }:$rs1, VRM2:{ *:[nxv2i64] }:$rs2, -1:{ *:[i32] }, 6:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIV_VV_M2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 59944,
        GIR_Done,
      // Label 409: @6986
      GIM_Reject,
    // Label 407: @6987
    GIM_Reject,
    // Label 369: @6988
    GIM_Try, /*On fail goto*//*Label 410*/ 7071,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv4s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv4s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 411*/ 7040, // Rule ID 59867 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (sdiv:{ *:[nxv4i8] } VR:{ *:[nxv4i8] }:$rs1, VR:{ *:[nxv4i8] }:$rs2)  =>  (PseudoVDIV_VV_MF2:{ *:[nxv4i8] } VR:{ *:[nxv4i8] }:$rs1, VR:{ *:[nxv4i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIV_VV_MF2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 59867,
        GIR_Done,
      // Label 411: @7040
      GIM_Try, /*On fail goto*//*Label 412*/ 7070, // Rule ID 59868 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (sdiv:{ *:[nxv4i8] } VR:{ *:[nxv4i8] }:$rs1, VR:{ *:[nxv4i8] }:$rs2)  =>  (PseudoVDIV_VV_MF2:{ *:[nxv4i8] } VR:{ *:[nxv4i8] }:$rs1, VR:{ *:[nxv4i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIV_VV_MF2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 59868,
        GIR_Done,
      // Label 412: @7070
      GIM_Reject,
    // Label 410: @7071
    GIM_Reject,
    // Label 370: @7072
    GIM_Try, /*On fail goto*//*Label 413*/ 7155,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv4s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv4s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 414*/ 7124, // Rule ID 59889 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (sdiv:{ *:[nxv4i16] } VR:{ *:[nxv4i16] }:$rs1, VR:{ *:[nxv4i16] }:$rs2)  =>  (PseudoVDIV_VV_M1:{ *:[nxv4i16] } VR:{ *:[nxv4i16] }:$rs1, VR:{ *:[nxv4i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIV_VV_M1,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 59889,
        GIR_Done,
      // Label 414: @7124
      GIM_Try, /*On fail goto*//*Label 415*/ 7154, // Rule ID 59890 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (sdiv:{ *:[nxv4i16] } VR:{ *:[nxv4i16] }:$rs1, VR:{ *:[nxv4i16] }:$rs2)  =>  (PseudoVDIV_VV_M1:{ *:[nxv4i16] } VR:{ *:[nxv4i16] }:$rs1, VR:{ *:[nxv4i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIV_VV_M1,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 59890,
        GIR_Done,
      // Label 415: @7154
      GIM_Reject,
    // Label 413: @7155
    GIM_Reject,
    // Label 371: @7156
    GIM_Try, /*On fail goto*//*Label 416*/ 7239,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv4s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM2RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM2RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM2RegClassID,
      GIM_Try, /*On fail goto*//*Label 417*/ 7208, // Rule ID 59929 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (sdiv:{ *:[nxv4i32] } VRM2:{ *:[nxv4i32] }:$rs1, VRM2:{ *:[nxv4i32] }:$rs2)  =>  (PseudoVDIV_VV_M2:{ *:[nxv4i32] } VRM2:{ *:[nxv4i32] }:$rs1, VRM2:{ *:[nxv4i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIV_VV_M2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 59929,
        GIR_Done,
      // Label 417: @7208
      GIM_Try, /*On fail goto*//*Label 418*/ 7238, // Rule ID 59930 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (sdiv:{ *:[nxv4i32] } VRM2:{ *:[nxv4i32] }:$rs1, VRM2:{ *:[nxv4i32] }:$rs2)  =>  (PseudoVDIV_VV_M2:{ *:[nxv4i32] } VRM2:{ *:[nxv4i32] }:$rs1, VRM2:{ *:[nxv4i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIV_VV_M2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 59930,
        GIR_Done,
      // Label 418: @7238
      GIM_Reject,
    // Label 416: @7239
    GIM_Reject,
    // Label 372: @7240
    GIM_Try, /*On fail goto*//*Label 419*/ 7323,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv4s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv4s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM4RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM4RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM4RegClassID,
      GIM_Try, /*On fail goto*//*Label 420*/ 7292, // Rule ID 59947 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (sdiv:{ *:[nxv4i64] } VRM4:{ *:[nxv4i64] }:$rs1, VRM4:{ *:[nxv4i64] }:$rs2)  =>  (PseudoVDIV_VV_M4:{ *:[nxv4i64] } VRM4:{ *:[nxv4i64] }:$rs1, VRM4:{ *:[nxv4i64] }:$rs2, -1:{ *:[i64] }, 6:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIV_VV_M4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 59947,
        GIR_Done,
      // Label 420: @7292
      GIM_Try, /*On fail goto*//*Label 421*/ 7322, // Rule ID 59948 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (sdiv:{ *:[nxv4i64] } VRM4:{ *:[nxv4i64] }:$rs1, VRM4:{ *:[nxv4i64] }:$rs2)  =>  (PseudoVDIV_VV_M4:{ *:[nxv4i64] } VRM4:{ *:[nxv4i64] }:$rs1, VRM4:{ *:[nxv4i64] }:$rs2, -1:{ *:[i32] }, 6:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIV_VV_M4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 59948,
        GIR_Done,
      // Label 421: @7322
      GIM_Reject,
    // Label 419: @7323
    GIM_Reject,
    // Label 373: @7324
    GIM_Try, /*On fail goto*//*Label 422*/ 7407,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv8s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv8s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 423*/ 7376, // Rule ID 59885 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (sdiv:{ *:[nxv8i8] } VR:{ *:[nxv8i8] }:$rs1, VR:{ *:[nxv8i8] }:$rs2)  =>  (PseudoVDIV_VV_M1:{ *:[nxv8i8] } VR:{ *:[nxv8i8] }:$rs1, VR:{ *:[nxv8i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIV_VV_M1,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 59885,
        GIR_Done,
      // Label 423: @7376
      GIM_Try, /*On fail goto*//*Label 424*/ 7406, // Rule ID 59886 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (sdiv:{ *:[nxv8i8] } VR:{ *:[nxv8i8] }:$rs1, VR:{ *:[nxv8i8] }:$rs2)  =>  (PseudoVDIV_VV_M1:{ *:[nxv8i8] } VR:{ *:[nxv8i8] }:$rs1, VR:{ *:[nxv8i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIV_VV_M1,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 59886,
        GIR_Done,
      // Label 424: @7406
      GIM_Reject,
    // Label 422: @7407
    GIM_Reject,
    // Label 374: @7408
    GIM_Try, /*On fail goto*//*Label 425*/ 7491,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv8s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM2RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM2RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM2RegClassID,
      GIM_Try, /*On fail goto*//*Label 426*/ 7460, // Rule ID 59917 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (sdiv:{ *:[nxv8i16] } VRM2:{ *:[nxv8i16] }:$rs1, VRM2:{ *:[nxv8i16] }:$rs2)  =>  (PseudoVDIV_VV_M2:{ *:[nxv8i16] } VRM2:{ *:[nxv8i16] }:$rs1, VRM2:{ *:[nxv8i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIV_VV_M2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 59917,
        GIR_Done,
      // Label 426: @7460
      GIM_Try, /*On fail goto*//*Label 427*/ 7490, // Rule ID 59918 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (sdiv:{ *:[nxv8i16] } VRM2:{ *:[nxv8i16] }:$rs1, VRM2:{ *:[nxv8i16] }:$rs2)  =>  (PseudoVDIV_VV_M2:{ *:[nxv8i16] } VRM2:{ *:[nxv8i16] }:$rs1, VRM2:{ *:[nxv8i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIV_VV_M2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 59918,
        GIR_Done,
      // Label 427: @7490
      GIM_Reject,
    // Label 425: @7491
    GIM_Reject,
    // Label 375: @7492
    GIM_Try, /*On fail goto*//*Label 428*/ 7575,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv8s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv8s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM4RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM4RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM4RegClassID,
      GIM_Try, /*On fail goto*//*Label 429*/ 7544, // Rule ID 59933 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (sdiv:{ *:[nxv8i32] } VRM4:{ *:[nxv8i32] }:$rs1, VRM4:{ *:[nxv8i32] }:$rs2)  =>  (PseudoVDIV_VV_M4:{ *:[nxv8i32] } VRM4:{ *:[nxv8i32] }:$rs1, VRM4:{ *:[nxv8i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIV_VV_M4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 59933,
        GIR_Done,
      // Label 429: @7544
      GIM_Try, /*On fail goto*//*Label 430*/ 7574, // Rule ID 59934 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (sdiv:{ *:[nxv8i32] } VRM4:{ *:[nxv8i32] }:$rs1, VRM4:{ *:[nxv8i32] }:$rs2)  =>  (PseudoVDIV_VV_M4:{ *:[nxv8i32] } VRM4:{ *:[nxv8i32] }:$rs1, VRM4:{ *:[nxv8i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIV_VV_M4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 59934,
        GIR_Done,
      // Label 430: @7574
      GIM_Reject,
    // Label 428: @7575
    GIM_Reject,
    // Label 376: @7576
    GIM_Try, /*On fail goto*//*Label 431*/ 7659,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv8s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv8s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM8RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM8RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM8RegClassID,
      GIM_Try, /*On fail goto*//*Label 432*/ 7628, // Rule ID 59951 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (sdiv:{ *:[nxv8i64] } VRM8:{ *:[nxv8i64] }:$rs1, VRM8:{ *:[nxv8i64] }:$rs2)  =>  (PseudoVDIV_VV_M8:{ *:[nxv8i64] } VRM8:{ *:[nxv8i64] }:$rs1, VRM8:{ *:[nxv8i64] }:$rs2, -1:{ *:[i64] }, 6:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIV_VV_M8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 59951,
        GIR_Done,
      // Label 432: @7628
      GIM_Try, /*On fail goto*//*Label 433*/ 7658, // Rule ID 59952 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (sdiv:{ *:[nxv8i64] } VRM8:{ *:[nxv8i64] }:$rs1, VRM8:{ *:[nxv8i64] }:$rs2)  =>  (PseudoVDIV_VV_M8:{ *:[nxv8i64] } VRM8:{ *:[nxv8i64] }:$rs1, VRM8:{ *:[nxv8i64] }:$rs2, -1:{ *:[i32] }, 6:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIV_VV_M8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 59952,
        GIR_Done,
      // Label 433: @7658
      GIM_Reject,
    // Label 431: @7659
    GIM_Reject,
    // Label 377: @7660
    GIM_Try, /*On fail goto*//*Label 434*/ 7743,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv16s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv16s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM2RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM2RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM2RegClassID,
      GIM_Try, /*On fail goto*//*Label 435*/ 7712, // Rule ID 59903 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (sdiv:{ *:[nxv16i8] } VRM2:{ *:[nxv16i8] }:$rs1, VRM2:{ *:[nxv16i8] }:$rs2)  =>  (PseudoVDIV_VV_M2:{ *:[nxv16i8] } VRM2:{ *:[nxv16i8] }:$rs1, VRM2:{ *:[nxv16i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIV_VV_M2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 59903,
        GIR_Done,
      // Label 435: @7712
      GIM_Try, /*On fail goto*//*Label 436*/ 7742, // Rule ID 59904 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (sdiv:{ *:[nxv16i8] } VRM2:{ *:[nxv16i8] }:$rs1, VRM2:{ *:[nxv16i8] }:$rs2)  =>  (PseudoVDIV_VV_M2:{ *:[nxv16i8] } VRM2:{ *:[nxv16i8] }:$rs1, VRM2:{ *:[nxv16i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIV_VV_M2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 59904,
        GIR_Done,
      // Label 436: @7742
      GIM_Reject,
    // Label 434: @7743
    GIM_Reject,
    // Label 378: @7744
    GIM_Try, /*On fail goto*//*Label 437*/ 7827,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv16s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv16s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM4RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM4RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM4RegClassID,
      GIM_Try, /*On fail goto*//*Label 438*/ 7796, // Rule ID 59921 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (sdiv:{ *:[nxv16i16] } VRM4:{ *:[nxv16i16] }:$rs1, VRM4:{ *:[nxv16i16] }:$rs2)  =>  (PseudoVDIV_VV_M4:{ *:[nxv16i16] } VRM4:{ *:[nxv16i16] }:$rs1, VRM4:{ *:[nxv16i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIV_VV_M4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 59921,
        GIR_Done,
      // Label 438: @7796
      GIM_Try, /*On fail goto*//*Label 439*/ 7826, // Rule ID 59922 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (sdiv:{ *:[nxv16i16] } VRM4:{ *:[nxv16i16] }:$rs1, VRM4:{ *:[nxv16i16] }:$rs2)  =>  (PseudoVDIV_VV_M4:{ *:[nxv16i16] } VRM4:{ *:[nxv16i16] }:$rs1, VRM4:{ *:[nxv16i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIV_VV_M4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 59922,
        GIR_Done,
      // Label 439: @7826
      GIM_Reject,
    // Label 437: @7827
    GIM_Reject,
    // Label 379: @7828
    GIM_Try, /*On fail goto*//*Label 440*/ 7911,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv16s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv16s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM8RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM8RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM8RegClassID,
      GIM_Try, /*On fail goto*//*Label 441*/ 7880, // Rule ID 59939 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (sdiv:{ *:[nxv16i32] } VRM8:{ *:[nxv16i32] }:$rs1, VRM8:{ *:[nxv16i32] }:$rs2)  =>  (PseudoVDIV_VV_M8:{ *:[nxv16i32] } VRM8:{ *:[nxv16i32] }:$rs1, VRM8:{ *:[nxv16i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIV_VV_M8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 59939,
        GIR_Done,
      // Label 441: @7880
      GIM_Try, /*On fail goto*//*Label 442*/ 7910, // Rule ID 59940 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (sdiv:{ *:[nxv16i32] } VRM8:{ *:[nxv16i32] }:$rs1, VRM8:{ *:[nxv16i32] }:$rs2)  =>  (PseudoVDIV_VV_M8:{ *:[nxv16i32] } VRM8:{ *:[nxv16i32] }:$rs1, VRM8:{ *:[nxv16i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIV_VV_M8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 59940,
        GIR_Done,
      // Label 442: @7910
      GIM_Reject,
    // Label 440: @7911
    GIM_Reject,
    // Label 380: @7912
    GIM_Try, /*On fail goto*//*Label 443*/ 7995,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv32s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv32s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM4RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM4RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM4RegClassID,
      GIM_Try, /*On fail goto*//*Label 444*/ 7964, // Rule ID 59907 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (sdiv:{ *:[nxv32i8] } VRM4:{ *:[nxv32i8] }:$rs1, VRM4:{ *:[nxv32i8] }:$rs2)  =>  (PseudoVDIV_VV_M4:{ *:[nxv32i8] } VRM4:{ *:[nxv32i8] }:$rs1, VRM4:{ *:[nxv32i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIV_VV_M4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 59907,
        GIR_Done,
      // Label 444: @7964
      GIM_Try, /*On fail goto*//*Label 445*/ 7994, // Rule ID 59908 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (sdiv:{ *:[nxv32i8] } VRM4:{ *:[nxv32i8] }:$rs1, VRM4:{ *:[nxv32i8] }:$rs2)  =>  (PseudoVDIV_VV_M4:{ *:[nxv32i8] } VRM4:{ *:[nxv32i8] }:$rs1, VRM4:{ *:[nxv32i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIV_VV_M4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 59908,
        GIR_Done,
      // Label 445: @7994
      GIM_Reject,
    // Label 443: @7995
    GIM_Reject,
    // Label 381: @7996
    GIM_Try, /*On fail goto*//*Label 446*/ 8079,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv32s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv32s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM8RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM8RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM8RegClassID,
      GIM_Try, /*On fail goto*//*Label 447*/ 8048, // Rule ID 59925 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (sdiv:{ *:[nxv32i16] } VRM8:{ *:[nxv32i16] }:$rs1, VRM8:{ *:[nxv32i16] }:$rs2)  =>  (PseudoVDIV_VV_M8:{ *:[nxv32i16] } VRM8:{ *:[nxv32i16] }:$rs1, VRM8:{ *:[nxv32i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIV_VV_M8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 59925,
        GIR_Done,
      // Label 447: @8048
      GIM_Try, /*On fail goto*//*Label 448*/ 8078, // Rule ID 59926 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (sdiv:{ *:[nxv32i16] } VRM8:{ *:[nxv32i16] }:$rs1, VRM8:{ *:[nxv32i16] }:$rs2)  =>  (PseudoVDIV_VV_M8:{ *:[nxv32i16] } VRM8:{ *:[nxv32i16] }:$rs1, VRM8:{ *:[nxv32i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIV_VV_M8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 59926,
        GIR_Done,
      // Label 448: @8078
      GIM_Reject,
    // Label 446: @8079
    GIM_Reject,
    // Label 382: @8080
    GIM_Try, /*On fail goto*//*Label 449*/ 8163,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv64s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv64s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM8RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM8RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM8RegClassID,
      GIM_Try, /*On fail goto*//*Label 450*/ 8132, // Rule ID 59911 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (sdiv:{ *:[nxv64i8] } VRM8:{ *:[nxv64i8] }:$rs1, VRM8:{ *:[nxv64i8] }:$rs2)  =>  (PseudoVDIV_VV_M8:{ *:[nxv64i8] } VRM8:{ *:[nxv64i8] }:$rs1, VRM8:{ *:[nxv64i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIV_VV_M8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 59911,
        GIR_Done,
      // Label 450: @8132
      GIM_Try, /*On fail goto*//*Label 451*/ 8162, // Rule ID 59912 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (sdiv:{ *:[nxv64i8] } VRM8:{ *:[nxv64i8] }:$rs1, VRM8:{ *:[nxv64i8] }:$rs2)  =>  (PseudoVDIV_VV_M8:{ *:[nxv64i8] } VRM8:{ *:[nxv64i8] }:$rs1, VRM8:{ *:[nxv64i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIV_VV_M8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 59912,
        GIR_Done,
      // Label 451: @8162
      GIM_Reject,
    // Label 449: @8163
    GIM_Reject,
    // Label 383: @8164
    GIM_Reject,
    // Label 4: @8165
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/1, 32, /*)*//*default:*//*Label 476*/ 10114,
    /*GILLT_s32*//*Label 452*/ 8202,
    /*GILLT_s64*//*Label 453*/ 8234, 0,
    /*GILLT_nxv1s8*//*Label 454*/ 8266,
    /*GILLT_nxv1s16*//*Label 455*/ 8350,
    /*GILLT_nxv1s32*//*Label 456*/ 8434,
    /*GILLT_nxv1s64*//*Label 457*/ 8518, 0,
    /*GILLT_nxv2s8*//*Label 458*/ 8602,
    /*GILLT_nxv2s16*//*Label 459*/ 8686,
    /*GILLT_nxv2s32*//*Label 460*/ 8770,
    /*GILLT_nxv2s64*//*Label 461*/ 8854, 0,
    /*GILLT_nxv4s8*//*Label 462*/ 8938,
    /*GILLT_nxv4s16*//*Label 463*/ 9022,
    /*GILLT_nxv4s32*//*Label 464*/ 9106,
    /*GILLT_nxv4s64*//*Label 465*/ 9190, 0,
    /*GILLT_nxv8s8*//*Label 466*/ 9274,
    /*GILLT_nxv8s16*//*Label 467*/ 9358,
    /*GILLT_nxv8s32*//*Label 468*/ 9442,
    /*GILLT_nxv8s64*//*Label 469*/ 9526, 0,
    /*GILLT_nxv16s8*//*Label 470*/ 9610,
    /*GILLT_nxv16s16*//*Label 471*/ 9694,
    /*GILLT_nxv16s32*//*Label 472*/ 9778, 0,
    /*GILLT_nxv32s8*//*Label 473*/ 9862,
    /*GILLT_nxv32s16*//*Label 474*/ 9946, 0,
    /*GILLT_nxv64s8*//*Label 475*/ 10030,
    // Label 452: @8202
    GIM_Try, /*On fail goto*//*Label 477*/ 8233, // Rule ID 63375 //
      GIM_CheckFeatures, GIFBS_HasStdExtM,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
      // (udiv:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)  =>  (DIVU:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::DIVU,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 63375,
      GIR_Done,
    // Label 477: @8233
    GIM_Reject,
    // Label 453: @8234
    GIM_Try, /*On fail goto*//*Label 478*/ 8265, // Rule ID 63374 //
      GIM_CheckFeatures, GIFBS_HasStdExtM,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
      // (udiv:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)  =>  (DIVU:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::DIVU,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 63374,
      GIR_Done,
    // Label 478: @8265
    GIM_Reject,
    // Label 454: @8266
    GIM_Try, /*On fail goto*//*Label 479*/ 8349,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv1s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv1s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 480*/ 8318, // Rule ID 59765 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (udiv:{ *:[nxv1i8] } VR:{ *:[nxv1i8] }:$rs1, VR:{ *:[nxv1i8] }:$rs2)  =>  (PseudoVDIVU_VV_MF8:{ *:[nxv1i8] } VR:{ *:[nxv1i8] }:$rs1, VR:{ *:[nxv1i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIVU_VV_MF8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 59765,
        GIR_Done,
      // Label 480: @8318
      GIM_Try, /*On fail goto*//*Label 481*/ 8348, // Rule ID 59766 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (udiv:{ *:[nxv1i8] } VR:{ *:[nxv1i8] }:$rs1, VR:{ *:[nxv1i8] }:$rs2)  =>  (PseudoVDIVU_VV_MF8:{ *:[nxv1i8] } VR:{ *:[nxv1i8] }:$rs1, VR:{ *:[nxv1i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIVU_VV_MF8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 59766,
        GIR_Done,
      // Label 481: @8348
      GIM_Reject,
    // Label 479: @8349
    GIM_Reject,
    // Label 455: @8350
    GIM_Try, /*On fail goto*//*Label 482*/ 8433,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv1s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv1s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 483*/ 8402, // Rule ID 59777 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (udiv:{ *:[nxv1i16] } VR:{ *:[nxv1i16] }:$rs1, VR:{ *:[nxv1i16] }:$rs2)  =>  (PseudoVDIVU_VV_MF4:{ *:[nxv1i16] } VR:{ *:[nxv1i16] }:$rs1, VR:{ *:[nxv1i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIVU_VV_MF4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 59777,
        GIR_Done,
      // Label 483: @8402
      GIM_Try, /*On fail goto*//*Label 484*/ 8432, // Rule ID 59778 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (udiv:{ *:[nxv1i16] } VR:{ *:[nxv1i16] }:$rs1, VR:{ *:[nxv1i16] }:$rs2)  =>  (PseudoVDIVU_VV_MF4:{ *:[nxv1i16] } VR:{ *:[nxv1i16] }:$rs1, VR:{ *:[nxv1i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIVU_VV_MF4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 59778,
        GIR_Done,
      // Label 484: @8432
      GIM_Reject,
    // Label 482: @8433
    GIM_Reject,
    // Label 456: @8434
    GIM_Try, /*On fail goto*//*Label 485*/ 8517,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv1s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv1s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 486*/ 8486, // Rule ID 59785 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (udiv:{ *:[nxv1i32] } VR:{ *:[nxv1i32] }:$rs1, VR:{ *:[nxv1i32] }:$rs2)  =>  (PseudoVDIVU_VV_MF2:{ *:[nxv1i32] } VR:{ *:[nxv1i32] }:$rs1, VR:{ *:[nxv1i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIVU_VV_MF2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 59785,
        GIR_Done,
      // Label 486: @8486
      GIM_Try, /*On fail goto*//*Label 487*/ 8516, // Rule ID 59786 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (udiv:{ *:[nxv1i32] } VR:{ *:[nxv1i32] }:$rs1, VR:{ *:[nxv1i32] }:$rs2)  =>  (PseudoVDIVU_VV_MF2:{ *:[nxv1i32] } VR:{ *:[nxv1i32] }:$rs1, VR:{ *:[nxv1i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIVU_VV_MF2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 59786,
        GIR_Done,
      // Label 487: @8516
      GIM_Reject,
    // Label 485: @8517
    GIM_Reject,
    // Label 457: @8518
    GIM_Try, /*On fail goto*//*Label 488*/ 8601,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv1s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv1s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 489*/ 8570, // Rule ID 59801 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (udiv:{ *:[nxv1i64] } VR:{ *:[nxv1i64] }:$rs1, VR:{ *:[nxv1i64] }:$rs2)  =>  (PseudoVDIVU_VV_M1:{ *:[nxv1i64] } VR:{ *:[nxv1i64] }:$rs1, VR:{ *:[nxv1i64] }:$rs2, -1:{ *:[i64] }, 6:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIVU_VV_M1,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 59801,
        GIR_Done,
      // Label 489: @8570
      GIM_Try, /*On fail goto*//*Label 490*/ 8600, // Rule ID 59802 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (udiv:{ *:[nxv1i64] } VR:{ *:[nxv1i64] }:$rs1, VR:{ *:[nxv1i64] }:$rs2)  =>  (PseudoVDIVU_VV_M1:{ *:[nxv1i64] } VR:{ *:[nxv1i64] }:$rs1, VR:{ *:[nxv1i64] }:$rs2, -1:{ *:[i32] }, 6:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIVU_VV_M1,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 59802,
        GIR_Done,
      // Label 490: @8600
      GIM_Reject,
    // Label 488: @8601
    GIM_Reject,
    // Label 458: @8602
    GIM_Try, /*On fail goto*//*Label 491*/ 8685,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv2s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv2s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 492*/ 8654, // Rule ID 59769 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (udiv:{ *:[nxv2i8] } VR:{ *:[nxv2i8] }:$rs1, VR:{ *:[nxv2i8] }:$rs2)  =>  (PseudoVDIVU_VV_MF4:{ *:[nxv2i8] } VR:{ *:[nxv2i8] }:$rs1, VR:{ *:[nxv2i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIVU_VV_MF4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 59769,
        GIR_Done,
      // Label 492: @8654
      GIM_Try, /*On fail goto*//*Label 493*/ 8684, // Rule ID 59770 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (udiv:{ *:[nxv2i8] } VR:{ *:[nxv2i8] }:$rs1, VR:{ *:[nxv2i8] }:$rs2)  =>  (PseudoVDIVU_VV_MF4:{ *:[nxv2i8] } VR:{ *:[nxv2i8] }:$rs1, VR:{ *:[nxv2i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIVU_VV_MF4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 59770,
        GIR_Done,
      // Label 493: @8684
      GIM_Reject,
    // Label 491: @8685
    GIM_Reject,
    // Label 459: @8686
    GIM_Try, /*On fail goto*//*Label 494*/ 8769,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv2s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv2s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 495*/ 8738, // Rule ID 59781 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (udiv:{ *:[nxv2i16] } VR:{ *:[nxv2i16] }:$rs1, VR:{ *:[nxv2i16] }:$rs2)  =>  (PseudoVDIVU_VV_MF2:{ *:[nxv2i16] } VR:{ *:[nxv2i16] }:$rs1, VR:{ *:[nxv2i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIVU_VV_MF2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 59781,
        GIR_Done,
      // Label 495: @8738
      GIM_Try, /*On fail goto*//*Label 496*/ 8768, // Rule ID 59782 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (udiv:{ *:[nxv2i16] } VR:{ *:[nxv2i16] }:$rs1, VR:{ *:[nxv2i16] }:$rs2)  =>  (PseudoVDIVU_VV_MF2:{ *:[nxv2i16] } VR:{ *:[nxv2i16] }:$rs1, VR:{ *:[nxv2i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIVU_VV_MF2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 59782,
        GIR_Done,
      // Label 496: @8768
      GIM_Reject,
    // Label 494: @8769
    GIM_Reject,
    // Label 460: @8770
    GIM_Try, /*On fail goto*//*Label 497*/ 8853,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv2s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv2s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 498*/ 8822, // Rule ID 59797 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (udiv:{ *:[nxv2i32] } VR:{ *:[nxv2i32] }:$rs1, VR:{ *:[nxv2i32] }:$rs2)  =>  (PseudoVDIVU_VV_M1:{ *:[nxv2i32] } VR:{ *:[nxv2i32] }:$rs1, VR:{ *:[nxv2i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIVU_VV_M1,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 59797,
        GIR_Done,
      // Label 498: @8822
      GIM_Try, /*On fail goto*//*Label 499*/ 8852, // Rule ID 59798 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (udiv:{ *:[nxv2i32] } VR:{ *:[nxv2i32] }:$rs1, VR:{ *:[nxv2i32] }:$rs2)  =>  (PseudoVDIVU_VV_M1:{ *:[nxv2i32] } VR:{ *:[nxv2i32] }:$rs1, VR:{ *:[nxv2i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIVU_VV_M1,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 59798,
        GIR_Done,
      // Label 499: @8852
      GIM_Reject,
    // Label 497: @8853
    GIM_Reject,
    // Label 461: @8854
    GIM_Try, /*On fail goto*//*Label 500*/ 8937,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv2s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM2RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM2RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM2RegClassID,
      GIM_Try, /*On fail goto*//*Label 501*/ 8906, // Rule ID 59845 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (udiv:{ *:[nxv2i64] } VRM2:{ *:[nxv2i64] }:$rs1, VRM2:{ *:[nxv2i64] }:$rs2)  =>  (PseudoVDIVU_VV_M2:{ *:[nxv2i64] } VRM2:{ *:[nxv2i64] }:$rs1, VRM2:{ *:[nxv2i64] }:$rs2, -1:{ *:[i64] }, 6:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIVU_VV_M2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 59845,
        GIR_Done,
      // Label 501: @8906
      GIM_Try, /*On fail goto*//*Label 502*/ 8936, // Rule ID 59846 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (udiv:{ *:[nxv2i64] } VRM2:{ *:[nxv2i64] }:$rs1, VRM2:{ *:[nxv2i64] }:$rs2)  =>  (PseudoVDIVU_VV_M2:{ *:[nxv2i64] } VRM2:{ *:[nxv2i64] }:$rs1, VRM2:{ *:[nxv2i64] }:$rs2, -1:{ *:[i32] }, 6:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIVU_VV_M2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 59846,
        GIR_Done,
      // Label 502: @8936
      GIM_Reject,
    // Label 500: @8937
    GIM_Reject,
    // Label 462: @8938
    GIM_Try, /*On fail goto*//*Label 503*/ 9021,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv4s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv4s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 504*/ 8990, // Rule ID 59773 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (udiv:{ *:[nxv4i8] } VR:{ *:[nxv4i8] }:$rs1, VR:{ *:[nxv4i8] }:$rs2)  =>  (PseudoVDIVU_VV_MF2:{ *:[nxv4i8] } VR:{ *:[nxv4i8] }:$rs1, VR:{ *:[nxv4i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIVU_VV_MF2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 59773,
        GIR_Done,
      // Label 504: @8990
      GIM_Try, /*On fail goto*//*Label 505*/ 9020, // Rule ID 59774 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (udiv:{ *:[nxv4i8] } VR:{ *:[nxv4i8] }:$rs1, VR:{ *:[nxv4i8] }:$rs2)  =>  (PseudoVDIVU_VV_MF2:{ *:[nxv4i8] } VR:{ *:[nxv4i8] }:$rs1, VR:{ *:[nxv4i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIVU_VV_MF2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 59774,
        GIR_Done,
      // Label 505: @9020
      GIM_Reject,
    // Label 503: @9021
    GIM_Reject,
    // Label 463: @9022
    GIM_Try, /*On fail goto*//*Label 506*/ 9105,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv4s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv4s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 507*/ 9074, // Rule ID 59793 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (udiv:{ *:[nxv4i16] } VR:{ *:[nxv4i16] }:$rs1, VR:{ *:[nxv4i16] }:$rs2)  =>  (PseudoVDIVU_VV_M1:{ *:[nxv4i16] } VR:{ *:[nxv4i16] }:$rs1, VR:{ *:[nxv4i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIVU_VV_M1,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 59793,
        GIR_Done,
      // Label 507: @9074
      GIM_Try, /*On fail goto*//*Label 508*/ 9104, // Rule ID 59794 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (udiv:{ *:[nxv4i16] } VR:{ *:[nxv4i16] }:$rs1, VR:{ *:[nxv4i16] }:$rs2)  =>  (PseudoVDIVU_VV_M1:{ *:[nxv4i16] } VR:{ *:[nxv4i16] }:$rs1, VR:{ *:[nxv4i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIVU_VV_M1,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 59794,
        GIR_Done,
      // Label 508: @9104
      GIM_Reject,
    // Label 506: @9105
    GIM_Reject,
    // Label 464: @9106
    GIM_Try, /*On fail goto*//*Label 509*/ 9189,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv4s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM2RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM2RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM2RegClassID,
      GIM_Try, /*On fail goto*//*Label 510*/ 9158, // Rule ID 59833 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (udiv:{ *:[nxv4i32] } VRM2:{ *:[nxv4i32] }:$rs1, VRM2:{ *:[nxv4i32] }:$rs2)  =>  (PseudoVDIVU_VV_M2:{ *:[nxv4i32] } VRM2:{ *:[nxv4i32] }:$rs1, VRM2:{ *:[nxv4i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIVU_VV_M2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 59833,
        GIR_Done,
      // Label 510: @9158
      GIM_Try, /*On fail goto*//*Label 511*/ 9188, // Rule ID 59834 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (udiv:{ *:[nxv4i32] } VRM2:{ *:[nxv4i32] }:$rs1, VRM2:{ *:[nxv4i32] }:$rs2)  =>  (PseudoVDIVU_VV_M2:{ *:[nxv4i32] } VRM2:{ *:[nxv4i32] }:$rs1, VRM2:{ *:[nxv4i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIVU_VV_M2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 59834,
        GIR_Done,
      // Label 511: @9188
      GIM_Reject,
    // Label 509: @9189
    GIM_Reject,
    // Label 465: @9190
    GIM_Try, /*On fail goto*//*Label 512*/ 9273,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv4s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv4s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM4RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM4RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM4RegClassID,
      GIM_Try, /*On fail goto*//*Label 513*/ 9242, // Rule ID 59849 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (udiv:{ *:[nxv4i64] } VRM4:{ *:[nxv4i64] }:$rs1, VRM4:{ *:[nxv4i64] }:$rs2)  =>  (PseudoVDIVU_VV_M4:{ *:[nxv4i64] } VRM4:{ *:[nxv4i64] }:$rs1, VRM4:{ *:[nxv4i64] }:$rs2, -1:{ *:[i64] }, 6:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIVU_VV_M4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 59849,
        GIR_Done,
      // Label 513: @9242
      GIM_Try, /*On fail goto*//*Label 514*/ 9272, // Rule ID 59850 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (udiv:{ *:[nxv4i64] } VRM4:{ *:[nxv4i64] }:$rs1, VRM4:{ *:[nxv4i64] }:$rs2)  =>  (PseudoVDIVU_VV_M4:{ *:[nxv4i64] } VRM4:{ *:[nxv4i64] }:$rs1, VRM4:{ *:[nxv4i64] }:$rs2, -1:{ *:[i32] }, 6:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIVU_VV_M4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 59850,
        GIR_Done,
      // Label 514: @9272
      GIM_Reject,
    // Label 512: @9273
    GIM_Reject,
    // Label 466: @9274
    GIM_Try, /*On fail goto*//*Label 515*/ 9357,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv8s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv8s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 516*/ 9326, // Rule ID 59789 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (udiv:{ *:[nxv8i8] } VR:{ *:[nxv8i8] }:$rs1, VR:{ *:[nxv8i8] }:$rs2)  =>  (PseudoVDIVU_VV_M1:{ *:[nxv8i8] } VR:{ *:[nxv8i8] }:$rs1, VR:{ *:[nxv8i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIVU_VV_M1,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 59789,
        GIR_Done,
      // Label 516: @9326
      GIM_Try, /*On fail goto*//*Label 517*/ 9356, // Rule ID 59790 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (udiv:{ *:[nxv8i8] } VR:{ *:[nxv8i8] }:$rs1, VR:{ *:[nxv8i8] }:$rs2)  =>  (PseudoVDIVU_VV_M1:{ *:[nxv8i8] } VR:{ *:[nxv8i8] }:$rs1, VR:{ *:[nxv8i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIVU_VV_M1,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 59790,
        GIR_Done,
      // Label 517: @9356
      GIM_Reject,
    // Label 515: @9357
    GIM_Reject,
    // Label 467: @9358
    GIM_Try, /*On fail goto*//*Label 518*/ 9441,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv8s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM2RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM2RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM2RegClassID,
      GIM_Try, /*On fail goto*//*Label 519*/ 9410, // Rule ID 59819 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (udiv:{ *:[nxv8i16] } VRM2:{ *:[nxv8i16] }:$rs1, VRM2:{ *:[nxv8i16] }:$rs2)  =>  (PseudoVDIVU_VV_M2:{ *:[nxv8i16] } VRM2:{ *:[nxv8i16] }:$rs1, VRM2:{ *:[nxv8i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIVU_VV_M2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 59819,
        GIR_Done,
      // Label 519: @9410
      GIM_Try, /*On fail goto*//*Label 520*/ 9440, // Rule ID 59820 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (udiv:{ *:[nxv8i16] } VRM2:{ *:[nxv8i16] }:$rs1, VRM2:{ *:[nxv8i16] }:$rs2)  =>  (PseudoVDIVU_VV_M2:{ *:[nxv8i16] } VRM2:{ *:[nxv8i16] }:$rs1, VRM2:{ *:[nxv8i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIVU_VV_M2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 59820,
        GIR_Done,
      // Label 520: @9440
      GIM_Reject,
    // Label 518: @9441
    GIM_Reject,
    // Label 468: @9442
    GIM_Try, /*On fail goto*//*Label 521*/ 9525,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv8s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv8s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM4RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM4RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM4RegClassID,
      GIM_Try, /*On fail goto*//*Label 522*/ 9494, // Rule ID 59837 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (udiv:{ *:[nxv8i32] } VRM4:{ *:[nxv8i32] }:$rs1, VRM4:{ *:[nxv8i32] }:$rs2)  =>  (PseudoVDIVU_VV_M4:{ *:[nxv8i32] } VRM4:{ *:[nxv8i32] }:$rs1, VRM4:{ *:[nxv8i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIVU_VV_M4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 59837,
        GIR_Done,
      // Label 522: @9494
      GIM_Try, /*On fail goto*//*Label 523*/ 9524, // Rule ID 59838 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (udiv:{ *:[nxv8i32] } VRM4:{ *:[nxv8i32] }:$rs1, VRM4:{ *:[nxv8i32] }:$rs2)  =>  (PseudoVDIVU_VV_M4:{ *:[nxv8i32] } VRM4:{ *:[nxv8i32] }:$rs1, VRM4:{ *:[nxv8i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIVU_VV_M4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 59838,
        GIR_Done,
      // Label 523: @9524
      GIM_Reject,
    // Label 521: @9525
    GIM_Reject,
    // Label 469: @9526
    GIM_Try, /*On fail goto*//*Label 524*/ 9609,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv8s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv8s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM8RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM8RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM8RegClassID,
      GIM_Try, /*On fail goto*//*Label 525*/ 9578, // Rule ID 59855 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (udiv:{ *:[nxv8i64] } VRM8:{ *:[nxv8i64] }:$rs1, VRM8:{ *:[nxv8i64] }:$rs2)  =>  (PseudoVDIVU_VV_M8:{ *:[nxv8i64] } VRM8:{ *:[nxv8i64] }:$rs1, VRM8:{ *:[nxv8i64] }:$rs2, -1:{ *:[i64] }, 6:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIVU_VV_M8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 59855,
        GIR_Done,
      // Label 525: @9578
      GIM_Try, /*On fail goto*//*Label 526*/ 9608, // Rule ID 59856 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (udiv:{ *:[nxv8i64] } VRM8:{ *:[nxv8i64] }:$rs1, VRM8:{ *:[nxv8i64] }:$rs2)  =>  (PseudoVDIVU_VV_M8:{ *:[nxv8i64] } VRM8:{ *:[nxv8i64] }:$rs1, VRM8:{ *:[nxv8i64] }:$rs2, -1:{ *:[i32] }, 6:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIVU_VV_M8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 59856,
        GIR_Done,
      // Label 526: @9608
      GIM_Reject,
    // Label 524: @9609
    GIM_Reject,
    // Label 470: @9610
    GIM_Try, /*On fail goto*//*Label 527*/ 9693,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv16s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv16s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM2RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM2RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM2RegClassID,
      GIM_Try, /*On fail goto*//*Label 528*/ 9662, // Rule ID 59805 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (udiv:{ *:[nxv16i8] } VRM2:{ *:[nxv16i8] }:$rs1, VRM2:{ *:[nxv16i8] }:$rs2)  =>  (PseudoVDIVU_VV_M2:{ *:[nxv16i8] } VRM2:{ *:[nxv16i8] }:$rs1, VRM2:{ *:[nxv16i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIVU_VV_M2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 59805,
        GIR_Done,
      // Label 528: @9662
      GIM_Try, /*On fail goto*//*Label 529*/ 9692, // Rule ID 59806 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (udiv:{ *:[nxv16i8] } VRM2:{ *:[nxv16i8] }:$rs1, VRM2:{ *:[nxv16i8] }:$rs2)  =>  (PseudoVDIVU_VV_M2:{ *:[nxv16i8] } VRM2:{ *:[nxv16i8] }:$rs1, VRM2:{ *:[nxv16i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIVU_VV_M2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 59806,
        GIR_Done,
      // Label 529: @9692
      GIM_Reject,
    // Label 527: @9693
    GIM_Reject,
    // Label 471: @9694
    GIM_Try, /*On fail goto*//*Label 530*/ 9777,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv16s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv16s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM4RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM4RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM4RegClassID,
      GIM_Try, /*On fail goto*//*Label 531*/ 9746, // Rule ID 59823 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (udiv:{ *:[nxv16i16] } VRM4:{ *:[nxv16i16] }:$rs1, VRM4:{ *:[nxv16i16] }:$rs2)  =>  (PseudoVDIVU_VV_M4:{ *:[nxv16i16] } VRM4:{ *:[nxv16i16] }:$rs1, VRM4:{ *:[nxv16i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIVU_VV_M4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 59823,
        GIR_Done,
      // Label 531: @9746
      GIM_Try, /*On fail goto*//*Label 532*/ 9776, // Rule ID 59824 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (udiv:{ *:[nxv16i16] } VRM4:{ *:[nxv16i16] }:$rs1, VRM4:{ *:[nxv16i16] }:$rs2)  =>  (PseudoVDIVU_VV_M4:{ *:[nxv16i16] } VRM4:{ *:[nxv16i16] }:$rs1, VRM4:{ *:[nxv16i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIVU_VV_M4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 59824,
        GIR_Done,
      // Label 532: @9776
      GIM_Reject,
    // Label 530: @9777
    GIM_Reject,
    // Label 472: @9778
    GIM_Try, /*On fail goto*//*Label 533*/ 9861,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv16s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv16s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM8RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM8RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM8RegClassID,
      GIM_Try, /*On fail goto*//*Label 534*/ 9830, // Rule ID 59841 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (udiv:{ *:[nxv16i32] } VRM8:{ *:[nxv16i32] }:$rs1, VRM8:{ *:[nxv16i32] }:$rs2)  =>  (PseudoVDIVU_VV_M8:{ *:[nxv16i32] } VRM8:{ *:[nxv16i32] }:$rs1, VRM8:{ *:[nxv16i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIVU_VV_M8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 59841,
        GIR_Done,
      // Label 534: @9830
      GIM_Try, /*On fail goto*//*Label 535*/ 9860, // Rule ID 59842 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (udiv:{ *:[nxv16i32] } VRM8:{ *:[nxv16i32] }:$rs1, VRM8:{ *:[nxv16i32] }:$rs2)  =>  (PseudoVDIVU_VV_M8:{ *:[nxv16i32] } VRM8:{ *:[nxv16i32] }:$rs1, VRM8:{ *:[nxv16i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIVU_VV_M8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 59842,
        GIR_Done,
      // Label 535: @9860
      GIM_Reject,
    // Label 533: @9861
    GIM_Reject,
    // Label 473: @9862
    GIM_Try, /*On fail goto*//*Label 536*/ 9945,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv32s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv32s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM4RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM4RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM4RegClassID,
      GIM_Try, /*On fail goto*//*Label 537*/ 9914, // Rule ID 59811 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (udiv:{ *:[nxv32i8] } VRM4:{ *:[nxv32i8] }:$rs1, VRM4:{ *:[nxv32i8] }:$rs2)  =>  (PseudoVDIVU_VV_M4:{ *:[nxv32i8] } VRM4:{ *:[nxv32i8] }:$rs1, VRM4:{ *:[nxv32i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIVU_VV_M4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 59811,
        GIR_Done,
      // Label 537: @9914
      GIM_Try, /*On fail goto*//*Label 538*/ 9944, // Rule ID 59812 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (udiv:{ *:[nxv32i8] } VRM4:{ *:[nxv32i8] }:$rs1, VRM4:{ *:[nxv32i8] }:$rs2)  =>  (PseudoVDIVU_VV_M4:{ *:[nxv32i8] } VRM4:{ *:[nxv32i8] }:$rs1, VRM4:{ *:[nxv32i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIVU_VV_M4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 59812,
        GIR_Done,
      // Label 538: @9944
      GIM_Reject,
    // Label 536: @9945
    GIM_Reject,
    // Label 474: @9946
    GIM_Try, /*On fail goto*//*Label 539*/ 10029,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv32s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv32s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM8RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM8RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM8RegClassID,
      GIM_Try, /*On fail goto*//*Label 540*/ 9998, // Rule ID 59827 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (udiv:{ *:[nxv32i16] } VRM8:{ *:[nxv32i16] }:$rs1, VRM8:{ *:[nxv32i16] }:$rs2)  =>  (PseudoVDIVU_VV_M8:{ *:[nxv32i16] } VRM8:{ *:[nxv32i16] }:$rs1, VRM8:{ *:[nxv32i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIVU_VV_M8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 59827,
        GIR_Done,
      // Label 540: @9998
      GIM_Try, /*On fail goto*//*Label 541*/ 10028, // Rule ID 59828 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (udiv:{ *:[nxv32i16] } VRM8:{ *:[nxv32i16] }:$rs1, VRM8:{ *:[nxv32i16] }:$rs2)  =>  (PseudoVDIVU_VV_M8:{ *:[nxv32i16] } VRM8:{ *:[nxv32i16] }:$rs1, VRM8:{ *:[nxv32i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIVU_VV_M8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 59828,
        GIR_Done,
      // Label 541: @10028
      GIM_Reject,
    // Label 539: @10029
    GIM_Reject,
    // Label 475: @10030
    GIM_Try, /*On fail goto*//*Label 542*/ 10113,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv64s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv64s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM8RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM8RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM8RegClassID,
      GIM_Try, /*On fail goto*//*Label 543*/ 10082, // Rule ID 59815 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (udiv:{ *:[nxv64i8] } VRM8:{ *:[nxv64i8] }:$rs1, VRM8:{ *:[nxv64i8] }:$rs2)  =>  (PseudoVDIVU_VV_M8:{ *:[nxv64i8] } VRM8:{ *:[nxv64i8] }:$rs1, VRM8:{ *:[nxv64i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIVU_VV_M8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 59815,
        GIR_Done,
      // Label 543: @10082
      GIM_Try, /*On fail goto*//*Label 544*/ 10112, // Rule ID 59816 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (udiv:{ *:[nxv64i8] } VRM8:{ *:[nxv64i8] }:$rs1, VRM8:{ *:[nxv64i8] }:$rs2)  =>  (PseudoVDIVU_VV_M8:{ *:[nxv64i8] } VRM8:{ *:[nxv64i8] }:$rs1, VRM8:{ *:[nxv64i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVDIVU_VV_M8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 59816,
        GIR_Done,
      // Label 544: @10112
      GIM_Reject,
    // Label 542: @10113
    GIM_Reject,
    // Label 476: @10114
    GIM_Reject,
    // Label 5: @10115
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/1, 32, /*)*//*default:*//*Label 569*/ 12064,
    /*GILLT_s32*//*Label 545*/ 10152,
    /*GILLT_s64*//*Label 546*/ 10184, 0,
    /*GILLT_nxv1s8*//*Label 547*/ 10216,
    /*GILLT_nxv1s16*//*Label 548*/ 10300,
    /*GILLT_nxv1s32*//*Label 549*/ 10384,
    /*GILLT_nxv1s64*//*Label 550*/ 10468, 0,
    /*GILLT_nxv2s8*//*Label 551*/ 10552,
    /*GILLT_nxv2s16*//*Label 552*/ 10636,
    /*GILLT_nxv2s32*//*Label 553*/ 10720,
    /*GILLT_nxv2s64*//*Label 554*/ 10804, 0,
    /*GILLT_nxv4s8*//*Label 555*/ 10888,
    /*GILLT_nxv4s16*//*Label 556*/ 10972,
    /*GILLT_nxv4s32*//*Label 557*/ 11056,
    /*GILLT_nxv4s64*//*Label 558*/ 11140, 0,
    /*GILLT_nxv8s8*//*Label 559*/ 11224,
    /*GILLT_nxv8s16*//*Label 560*/ 11308,
    /*GILLT_nxv8s32*//*Label 561*/ 11392,
    /*GILLT_nxv8s64*//*Label 562*/ 11476, 0,
    /*GILLT_nxv16s8*//*Label 563*/ 11560,
    /*GILLT_nxv16s16*//*Label 564*/ 11644,
    /*GILLT_nxv16s32*//*Label 565*/ 11728, 0,
    /*GILLT_nxv32s8*//*Label 566*/ 11812,
    /*GILLT_nxv32s16*//*Label 567*/ 11896, 0,
    /*GILLT_nxv64s8*//*Label 568*/ 11980,
    // Label 545: @10152
    GIM_Try, /*On fail goto*//*Label 570*/ 10183, // Rule ID 63395 //
      GIM_CheckFeatures, GIFBS_HasStdExtM,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
      // (srem:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)  =>  (REM:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::REM,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 63395,
      GIR_Done,
    // Label 570: @10183
    GIM_Reject,
    // Label 546: @10184
    GIM_Try, /*On fail goto*//*Label 571*/ 10215, // Rule ID 63394 //
      GIM_CheckFeatures, GIFBS_HasStdExtM,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
      // (srem:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)  =>  (REM:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::REM,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 63394,
      GIR_Done,
    // Label 571: @10215
    GIM_Reject,
    // Label 547: @10216
    GIM_Try, /*On fail goto*//*Label 572*/ 10299,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv1s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv1s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 573*/ 10268, // Rule ID 60053 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (srem:{ *:[nxv1i8] } VR:{ *:[nxv1i8] }:$rs1, VR:{ *:[nxv1i8] }:$rs2)  =>  (PseudoVREM_VV_MF8:{ *:[nxv1i8] } VR:{ *:[nxv1i8] }:$rs1, VR:{ *:[nxv1i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREM_VV_MF8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 60053,
        GIR_Done,
      // Label 573: @10268
      GIM_Try, /*On fail goto*//*Label 574*/ 10298, // Rule ID 60054 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (srem:{ *:[nxv1i8] } VR:{ *:[nxv1i8] }:$rs1, VR:{ *:[nxv1i8] }:$rs2)  =>  (PseudoVREM_VV_MF8:{ *:[nxv1i8] } VR:{ *:[nxv1i8] }:$rs1, VR:{ *:[nxv1i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREM_VV_MF8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 60054,
        GIR_Done,
      // Label 574: @10298
      GIM_Reject,
    // Label 572: @10299
    GIM_Reject,
    // Label 548: @10300
    GIM_Try, /*On fail goto*//*Label 575*/ 10383,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv1s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv1s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 576*/ 10352, // Rule ID 60067 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (srem:{ *:[nxv1i16] } VR:{ *:[nxv1i16] }:$rs1, VR:{ *:[nxv1i16] }:$rs2)  =>  (PseudoVREM_VV_MF4:{ *:[nxv1i16] } VR:{ *:[nxv1i16] }:$rs1, VR:{ *:[nxv1i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREM_VV_MF4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 60067,
        GIR_Done,
      // Label 576: @10352
      GIM_Try, /*On fail goto*//*Label 577*/ 10382, // Rule ID 60068 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (srem:{ *:[nxv1i16] } VR:{ *:[nxv1i16] }:$rs1, VR:{ *:[nxv1i16] }:$rs2)  =>  (PseudoVREM_VV_MF4:{ *:[nxv1i16] } VR:{ *:[nxv1i16] }:$rs1, VR:{ *:[nxv1i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREM_VV_MF4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 60068,
        GIR_Done,
      // Label 577: @10382
      GIM_Reject,
    // Label 575: @10383
    GIM_Reject,
    // Label 549: @10384
    GIM_Try, /*On fail goto*//*Label 578*/ 10467,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv1s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv1s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 579*/ 10436, // Rule ID 60075 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (srem:{ *:[nxv1i32] } VR:{ *:[nxv1i32] }:$rs1, VR:{ *:[nxv1i32] }:$rs2)  =>  (PseudoVREM_VV_MF2:{ *:[nxv1i32] } VR:{ *:[nxv1i32] }:$rs1, VR:{ *:[nxv1i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREM_VV_MF2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 60075,
        GIR_Done,
      // Label 579: @10436
      GIM_Try, /*On fail goto*//*Label 580*/ 10466, // Rule ID 60076 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (srem:{ *:[nxv1i32] } VR:{ *:[nxv1i32] }:$rs1, VR:{ *:[nxv1i32] }:$rs2)  =>  (PseudoVREM_VV_MF2:{ *:[nxv1i32] } VR:{ *:[nxv1i32] }:$rs1, VR:{ *:[nxv1i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREM_VV_MF2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 60076,
        GIR_Done,
      // Label 580: @10466
      GIM_Reject,
    // Label 578: @10467
    GIM_Reject,
    // Label 550: @10468
    GIM_Try, /*On fail goto*//*Label 581*/ 10551,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv1s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv1s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 582*/ 10520, // Rule ID 60093 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (srem:{ *:[nxv1i64] } VR:{ *:[nxv1i64] }:$rs1, VR:{ *:[nxv1i64] }:$rs2)  =>  (PseudoVREM_VV_M1:{ *:[nxv1i64] } VR:{ *:[nxv1i64] }:$rs1, VR:{ *:[nxv1i64] }:$rs2, -1:{ *:[i64] }, 6:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREM_VV_M1,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 60093,
        GIR_Done,
      // Label 582: @10520
      GIM_Try, /*On fail goto*//*Label 583*/ 10550, // Rule ID 60094 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (srem:{ *:[nxv1i64] } VR:{ *:[nxv1i64] }:$rs1, VR:{ *:[nxv1i64] }:$rs2)  =>  (PseudoVREM_VV_M1:{ *:[nxv1i64] } VR:{ *:[nxv1i64] }:$rs1, VR:{ *:[nxv1i64] }:$rs2, -1:{ *:[i32] }, 6:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREM_VV_M1,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 60094,
        GIR_Done,
      // Label 583: @10550
      GIM_Reject,
    // Label 581: @10551
    GIM_Reject,
    // Label 551: @10552
    GIM_Try, /*On fail goto*//*Label 584*/ 10635,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv2s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv2s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 585*/ 10604, // Rule ID 60057 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (srem:{ *:[nxv2i8] } VR:{ *:[nxv2i8] }:$rs1, VR:{ *:[nxv2i8] }:$rs2)  =>  (PseudoVREM_VV_MF4:{ *:[nxv2i8] } VR:{ *:[nxv2i8] }:$rs1, VR:{ *:[nxv2i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREM_VV_MF4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 60057,
        GIR_Done,
      // Label 585: @10604
      GIM_Try, /*On fail goto*//*Label 586*/ 10634, // Rule ID 60058 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (srem:{ *:[nxv2i8] } VR:{ *:[nxv2i8] }:$rs1, VR:{ *:[nxv2i8] }:$rs2)  =>  (PseudoVREM_VV_MF4:{ *:[nxv2i8] } VR:{ *:[nxv2i8] }:$rs1, VR:{ *:[nxv2i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREM_VV_MF4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 60058,
        GIR_Done,
      // Label 586: @10634
      GIM_Reject,
    // Label 584: @10635
    GIM_Reject,
    // Label 552: @10636
    GIM_Try, /*On fail goto*//*Label 587*/ 10719,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv2s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv2s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 588*/ 10688, // Rule ID 60071 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (srem:{ *:[nxv2i16] } VR:{ *:[nxv2i16] }:$rs1, VR:{ *:[nxv2i16] }:$rs2)  =>  (PseudoVREM_VV_MF2:{ *:[nxv2i16] } VR:{ *:[nxv2i16] }:$rs1, VR:{ *:[nxv2i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREM_VV_MF2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 60071,
        GIR_Done,
      // Label 588: @10688
      GIM_Try, /*On fail goto*//*Label 589*/ 10718, // Rule ID 60072 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (srem:{ *:[nxv2i16] } VR:{ *:[nxv2i16] }:$rs1, VR:{ *:[nxv2i16] }:$rs2)  =>  (PseudoVREM_VV_MF2:{ *:[nxv2i16] } VR:{ *:[nxv2i16] }:$rs1, VR:{ *:[nxv2i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREM_VV_MF2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 60072,
        GIR_Done,
      // Label 589: @10718
      GIM_Reject,
    // Label 587: @10719
    GIM_Reject,
    // Label 553: @10720
    GIM_Try, /*On fail goto*//*Label 590*/ 10803,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv2s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv2s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 591*/ 10772, // Rule ID 60089 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (srem:{ *:[nxv2i32] } VR:{ *:[nxv2i32] }:$rs1, VR:{ *:[nxv2i32] }:$rs2)  =>  (PseudoVREM_VV_M1:{ *:[nxv2i32] } VR:{ *:[nxv2i32] }:$rs1, VR:{ *:[nxv2i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREM_VV_M1,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 60089,
        GIR_Done,
      // Label 591: @10772
      GIM_Try, /*On fail goto*//*Label 592*/ 10802, // Rule ID 60090 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (srem:{ *:[nxv2i32] } VR:{ *:[nxv2i32] }:$rs1, VR:{ *:[nxv2i32] }:$rs2)  =>  (PseudoVREM_VV_M1:{ *:[nxv2i32] } VR:{ *:[nxv2i32] }:$rs1, VR:{ *:[nxv2i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREM_VV_M1,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 60090,
        GIR_Done,
      // Label 592: @10802
      GIM_Reject,
    // Label 590: @10803
    GIM_Reject,
    // Label 554: @10804
    GIM_Try, /*On fail goto*//*Label 593*/ 10887,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv2s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM2RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM2RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM2RegClassID,
      GIM_Try, /*On fail goto*//*Label 594*/ 10856, // Rule ID 60136 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (srem:{ *:[nxv2i64] } VRM2:{ *:[nxv2i64] }:$rs1, VRM2:{ *:[nxv2i64] }:$rs2)  =>  (PseudoVREM_VV_M2:{ *:[nxv2i64] } VRM2:{ *:[nxv2i64] }:$rs1, VRM2:{ *:[nxv2i64] }:$rs2, -1:{ *:[i64] }, 6:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREM_VV_M2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 60136,
        GIR_Done,
      // Label 594: @10856
      GIM_Try, /*On fail goto*//*Label 595*/ 10886, // Rule ID 60137 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (srem:{ *:[nxv2i64] } VRM2:{ *:[nxv2i64] }:$rs1, VRM2:{ *:[nxv2i64] }:$rs2)  =>  (PseudoVREM_VV_M2:{ *:[nxv2i64] } VRM2:{ *:[nxv2i64] }:$rs1, VRM2:{ *:[nxv2i64] }:$rs2, -1:{ *:[i32] }, 6:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREM_VV_M2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 60137,
        GIR_Done,
      // Label 595: @10886
      GIM_Reject,
    // Label 593: @10887
    GIM_Reject,
    // Label 555: @10888
    GIM_Try, /*On fail goto*//*Label 596*/ 10971,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv4s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv4s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 597*/ 10940, // Rule ID 60061 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (srem:{ *:[nxv4i8] } VR:{ *:[nxv4i8] }:$rs1, VR:{ *:[nxv4i8] }:$rs2)  =>  (PseudoVREM_VV_MF2:{ *:[nxv4i8] } VR:{ *:[nxv4i8] }:$rs1, VR:{ *:[nxv4i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREM_VV_MF2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 60061,
        GIR_Done,
      // Label 597: @10940
      GIM_Try, /*On fail goto*//*Label 598*/ 10970, // Rule ID 60062 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (srem:{ *:[nxv4i8] } VR:{ *:[nxv4i8] }:$rs1, VR:{ *:[nxv4i8] }:$rs2)  =>  (PseudoVREM_VV_MF2:{ *:[nxv4i8] } VR:{ *:[nxv4i8] }:$rs1, VR:{ *:[nxv4i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREM_VV_MF2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 60062,
        GIR_Done,
      // Label 598: @10970
      GIM_Reject,
    // Label 596: @10971
    GIM_Reject,
    // Label 556: @10972
    GIM_Try, /*On fail goto*//*Label 599*/ 11055,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv4s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv4s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 600*/ 11024, // Rule ID 60083 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (srem:{ *:[nxv4i16] } VR:{ *:[nxv4i16] }:$rs1, VR:{ *:[nxv4i16] }:$rs2)  =>  (PseudoVREM_VV_M1:{ *:[nxv4i16] } VR:{ *:[nxv4i16] }:$rs1, VR:{ *:[nxv4i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREM_VV_M1,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 60083,
        GIR_Done,
      // Label 600: @11024
      GIM_Try, /*On fail goto*//*Label 601*/ 11054, // Rule ID 60084 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (srem:{ *:[nxv4i16] } VR:{ *:[nxv4i16] }:$rs1, VR:{ *:[nxv4i16] }:$rs2)  =>  (PseudoVREM_VV_M1:{ *:[nxv4i16] } VR:{ *:[nxv4i16] }:$rs1, VR:{ *:[nxv4i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREM_VV_M1,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 60084,
        GIR_Done,
      // Label 601: @11054
      GIM_Reject,
    // Label 599: @11055
    GIM_Reject,
    // Label 557: @11056
    GIM_Try, /*On fail goto*//*Label 602*/ 11139,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv4s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM2RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM2RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM2RegClassID,
      GIM_Try, /*On fail goto*//*Label 603*/ 11108, // Rule ID 60122 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (srem:{ *:[nxv4i32] } VRM2:{ *:[nxv4i32] }:$rs1, VRM2:{ *:[nxv4i32] }:$rs2)  =>  (PseudoVREM_VV_M2:{ *:[nxv4i32] } VRM2:{ *:[nxv4i32] }:$rs1, VRM2:{ *:[nxv4i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREM_VV_M2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 60122,
        GIR_Done,
      // Label 603: @11108
      GIM_Try, /*On fail goto*//*Label 604*/ 11138, // Rule ID 60123 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (srem:{ *:[nxv4i32] } VRM2:{ *:[nxv4i32] }:$rs1, VRM2:{ *:[nxv4i32] }:$rs2)  =>  (PseudoVREM_VV_M2:{ *:[nxv4i32] } VRM2:{ *:[nxv4i32] }:$rs1, VRM2:{ *:[nxv4i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREM_VV_M2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 60123,
        GIR_Done,
      // Label 604: @11138
      GIM_Reject,
    // Label 602: @11139
    GIM_Reject,
    // Label 558: @11140
    GIM_Try, /*On fail goto*//*Label 605*/ 11223,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv4s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv4s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM4RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM4RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM4RegClassID,
      GIM_Try, /*On fail goto*//*Label 606*/ 11192, // Rule ID 60140 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (srem:{ *:[nxv4i64] } VRM4:{ *:[nxv4i64] }:$rs1, VRM4:{ *:[nxv4i64] }:$rs2)  =>  (PseudoVREM_VV_M4:{ *:[nxv4i64] } VRM4:{ *:[nxv4i64] }:$rs1, VRM4:{ *:[nxv4i64] }:$rs2, -1:{ *:[i64] }, 6:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREM_VV_M4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 60140,
        GIR_Done,
      // Label 606: @11192
      GIM_Try, /*On fail goto*//*Label 607*/ 11222, // Rule ID 60141 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (srem:{ *:[nxv4i64] } VRM4:{ *:[nxv4i64] }:$rs1, VRM4:{ *:[nxv4i64] }:$rs2)  =>  (PseudoVREM_VV_M4:{ *:[nxv4i64] } VRM4:{ *:[nxv4i64] }:$rs1, VRM4:{ *:[nxv4i64] }:$rs2, -1:{ *:[i32] }, 6:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREM_VV_M4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 60141,
        GIR_Done,
      // Label 607: @11222
      GIM_Reject,
    // Label 605: @11223
    GIM_Reject,
    // Label 559: @11224
    GIM_Try, /*On fail goto*//*Label 608*/ 11307,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv8s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv8s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 609*/ 11276, // Rule ID 60079 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (srem:{ *:[nxv8i8] } VR:{ *:[nxv8i8] }:$rs1, VR:{ *:[nxv8i8] }:$rs2)  =>  (PseudoVREM_VV_M1:{ *:[nxv8i8] } VR:{ *:[nxv8i8] }:$rs1, VR:{ *:[nxv8i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREM_VV_M1,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 60079,
        GIR_Done,
      // Label 609: @11276
      GIM_Try, /*On fail goto*//*Label 610*/ 11306, // Rule ID 60080 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (srem:{ *:[nxv8i8] } VR:{ *:[nxv8i8] }:$rs1, VR:{ *:[nxv8i8] }:$rs2)  =>  (PseudoVREM_VV_M1:{ *:[nxv8i8] } VR:{ *:[nxv8i8] }:$rs1, VR:{ *:[nxv8i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREM_VV_M1,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 60080,
        GIR_Done,
      // Label 610: @11306
      GIM_Reject,
    // Label 608: @11307
    GIM_Reject,
    // Label 560: @11308
    GIM_Try, /*On fail goto*//*Label 611*/ 11391,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv8s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM2RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM2RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM2RegClassID,
      GIM_Try, /*On fail goto*//*Label 612*/ 11360, // Rule ID 60110 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (srem:{ *:[nxv8i16] } VRM2:{ *:[nxv8i16] }:$rs1, VRM2:{ *:[nxv8i16] }:$rs2)  =>  (PseudoVREM_VV_M2:{ *:[nxv8i16] } VRM2:{ *:[nxv8i16] }:$rs1, VRM2:{ *:[nxv8i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREM_VV_M2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 60110,
        GIR_Done,
      // Label 612: @11360
      GIM_Try, /*On fail goto*//*Label 613*/ 11390, // Rule ID 60111 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (srem:{ *:[nxv8i16] } VRM2:{ *:[nxv8i16] }:$rs1, VRM2:{ *:[nxv8i16] }:$rs2)  =>  (PseudoVREM_VV_M2:{ *:[nxv8i16] } VRM2:{ *:[nxv8i16] }:$rs1, VRM2:{ *:[nxv8i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREM_VV_M2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 60111,
        GIR_Done,
      // Label 613: @11390
      GIM_Reject,
    // Label 611: @11391
    GIM_Reject,
    // Label 561: @11392
    GIM_Try, /*On fail goto*//*Label 614*/ 11475,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv8s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv8s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM4RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM4RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM4RegClassID,
      GIM_Try, /*On fail goto*//*Label 615*/ 11444, // Rule ID 60126 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (srem:{ *:[nxv8i32] } VRM4:{ *:[nxv8i32] }:$rs1, VRM4:{ *:[nxv8i32] }:$rs2)  =>  (PseudoVREM_VV_M4:{ *:[nxv8i32] } VRM4:{ *:[nxv8i32] }:$rs1, VRM4:{ *:[nxv8i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREM_VV_M4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 60126,
        GIR_Done,
      // Label 615: @11444
      GIM_Try, /*On fail goto*//*Label 616*/ 11474, // Rule ID 60127 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (srem:{ *:[nxv8i32] } VRM4:{ *:[nxv8i32] }:$rs1, VRM4:{ *:[nxv8i32] }:$rs2)  =>  (PseudoVREM_VV_M4:{ *:[nxv8i32] } VRM4:{ *:[nxv8i32] }:$rs1, VRM4:{ *:[nxv8i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREM_VV_M4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 60127,
        GIR_Done,
      // Label 616: @11474
      GIM_Reject,
    // Label 614: @11475
    GIM_Reject,
    // Label 562: @11476
    GIM_Try, /*On fail goto*//*Label 617*/ 11559,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv8s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv8s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM8RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM8RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM8RegClassID,
      GIM_Try, /*On fail goto*//*Label 618*/ 11528, // Rule ID 60144 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (srem:{ *:[nxv8i64] } VRM8:{ *:[nxv8i64] }:$rs1, VRM8:{ *:[nxv8i64] }:$rs2)  =>  (PseudoVREM_VV_M8:{ *:[nxv8i64] } VRM8:{ *:[nxv8i64] }:$rs1, VRM8:{ *:[nxv8i64] }:$rs2, -1:{ *:[i64] }, 6:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREM_VV_M8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 60144,
        GIR_Done,
      // Label 618: @11528
      GIM_Try, /*On fail goto*//*Label 619*/ 11558, // Rule ID 60145 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (srem:{ *:[nxv8i64] } VRM8:{ *:[nxv8i64] }:$rs1, VRM8:{ *:[nxv8i64] }:$rs2)  =>  (PseudoVREM_VV_M8:{ *:[nxv8i64] } VRM8:{ *:[nxv8i64] }:$rs1, VRM8:{ *:[nxv8i64] }:$rs2, -1:{ *:[i32] }, 6:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREM_VV_M8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 60145,
        GIR_Done,
      // Label 619: @11558
      GIM_Reject,
    // Label 617: @11559
    GIM_Reject,
    // Label 563: @11560
    GIM_Try, /*On fail goto*//*Label 620*/ 11643,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv16s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv16s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM2RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM2RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM2RegClassID,
      GIM_Try, /*On fail goto*//*Label 621*/ 11612, // Rule ID 60097 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (srem:{ *:[nxv16i8] } VRM2:{ *:[nxv16i8] }:$rs1, VRM2:{ *:[nxv16i8] }:$rs2)  =>  (PseudoVREM_VV_M2:{ *:[nxv16i8] } VRM2:{ *:[nxv16i8] }:$rs1, VRM2:{ *:[nxv16i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREM_VV_M2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 60097,
        GIR_Done,
      // Label 621: @11612
      GIM_Try, /*On fail goto*//*Label 622*/ 11642, // Rule ID 60098 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (srem:{ *:[nxv16i8] } VRM2:{ *:[nxv16i8] }:$rs1, VRM2:{ *:[nxv16i8] }:$rs2)  =>  (PseudoVREM_VV_M2:{ *:[nxv16i8] } VRM2:{ *:[nxv16i8] }:$rs1, VRM2:{ *:[nxv16i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREM_VV_M2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 60098,
        GIR_Done,
      // Label 622: @11642
      GIM_Reject,
    // Label 620: @11643
    GIM_Reject,
    // Label 564: @11644
    GIM_Try, /*On fail goto*//*Label 623*/ 11727,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv16s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv16s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM4RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM4RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM4RegClassID,
      GIM_Try, /*On fail goto*//*Label 624*/ 11696, // Rule ID 60114 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (srem:{ *:[nxv16i16] } VRM4:{ *:[nxv16i16] }:$rs1, VRM4:{ *:[nxv16i16] }:$rs2)  =>  (PseudoVREM_VV_M4:{ *:[nxv16i16] } VRM4:{ *:[nxv16i16] }:$rs1, VRM4:{ *:[nxv16i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREM_VV_M4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 60114,
        GIR_Done,
      // Label 624: @11696
      GIM_Try, /*On fail goto*//*Label 625*/ 11726, // Rule ID 60115 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (srem:{ *:[nxv16i16] } VRM4:{ *:[nxv16i16] }:$rs1, VRM4:{ *:[nxv16i16] }:$rs2)  =>  (PseudoVREM_VV_M4:{ *:[nxv16i16] } VRM4:{ *:[nxv16i16] }:$rs1, VRM4:{ *:[nxv16i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREM_VV_M4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 60115,
        GIR_Done,
      // Label 625: @11726
      GIM_Reject,
    // Label 623: @11727
    GIM_Reject,
    // Label 565: @11728
    GIM_Try, /*On fail goto*//*Label 626*/ 11811,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv16s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv16s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM8RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM8RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM8RegClassID,
      GIM_Try, /*On fail goto*//*Label 627*/ 11780, // Rule ID 60132 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (srem:{ *:[nxv16i32] } VRM8:{ *:[nxv16i32] }:$rs1, VRM8:{ *:[nxv16i32] }:$rs2)  =>  (PseudoVREM_VV_M8:{ *:[nxv16i32] } VRM8:{ *:[nxv16i32] }:$rs1, VRM8:{ *:[nxv16i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREM_VV_M8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 60132,
        GIR_Done,
      // Label 627: @11780
      GIM_Try, /*On fail goto*//*Label 628*/ 11810, // Rule ID 60133 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (srem:{ *:[nxv16i32] } VRM8:{ *:[nxv16i32] }:$rs1, VRM8:{ *:[nxv16i32] }:$rs2)  =>  (PseudoVREM_VV_M8:{ *:[nxv16i32] } VRM8:{ *:[nxv16i32] }:$rs1, VRM8:{ *:[nxv16i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREM_VV_M8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 60133,
        GIR_Done,
      // Label 628: @11810
      GIM_Reject,
    // Label 626: @11811
    GIM_Reject,
    // Label 566: @11812
    GIM_Try, /*On fail goto*//*Label 629*/ 11895,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv32s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv32s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM4RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM4RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM4RegClassID,
      GIM_Try, /*On fail goto*//*Label 630*/ 11864, // Rule ID 60101 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (srem:{ *:[nxv32i8] } VRM4:{ *:[nxv32i8] }:$rs1, VRM4:{ *:[nxv32i8] }:$rs2)  =>  (PseudoVREM_VV_M4:{ *:[nxv32i8] } VRM4:{ *:[nxv32i8] }:$rs1, VRM4:{ *:[nxv32i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREM_VV_M4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 60101,
        GIR_Done,
      // Label 630: @11864
      GIM_Try, /*On fail goto*//*Label 631*/ 11894, // Rule ID 60102 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (srem:{ *:[nxv32i8] } VRM4:{ *:[nxv32i8] }:$rs1, VRM4:{ *:[nxv32i8] }:$rs2)  =>  (PseudoVREM_VV_M4:{ *:[nxv32i8] } VRM4:{ *:[nxv32i8] }:$rs1, VRM4:{ *:[nxv32i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREM_VV_M4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 60102,
        GIR_Done,
      // Label 631: @11894
      GIM_Reject,
    // Label 629: @11895
    GIM_Reject,
    // Label 567: @11896
    GIM_Try, /*On fail goto*//*Label 632*/ 11979,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv32s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv32s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM8RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM8RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM8RegClassID,
      GIM_Try, /*On fail goto*//*Label 633*/ 11948, // Rule ID 60118 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (srem:{ *:[nxv32i16] } VRM8:{ *:[nxv32i16] }:$rs1, VRM8:{ *:[nxv32i16] }:$rs2)  =>  (PseudoVREM_VV_M8:{ *:[nxv32i16] } VRM8:{ *:[nxv32i16] }:$rs1, VRM8:{ *:[nxv32i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREM_VV_M8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 60118,
        GIR_Done,
      // Label 633: @11948
      GIM_Try, /*On fail goto*//*Label 634*/ 11978, // Rule ID 60119 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (srem:{ *:[nxv32i16] } VRM8:{ *:[nxv32i16] }:$rs1, VRM8:{ *:[nxv32i16] }:$rs2)  =>  (PseudoVREM_VV_M8:{ *:[nxv32i16] } VRM8:{ *:[nxv32i16] }:$rs1, VRM8:{ *:[nxv32i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREM_VV_M8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 60119,
        GIR_Done,
      // Label 634: @11978
      GIM_Reject,
    // Label 632: @11979
    GIM_Reject,
    // Label 568: @11980
    GIM_Try, /*On fail goto*//*Label 635*/ 12063,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv64s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv64s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM8RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM8RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM8RegClassID,
      GIM_Try, /*On fail goto*//*Label 636*/ 12032, // Rule ID 60105 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (srem:{ *:[nxv64i8] } VRM8:{ *:[nxv64i8] }:$rs1, VRM8:{ *:[nxv64i8] }:$rs2)  =>  (PseudoVREM_VV_M8:{ *:[nxv64i8] } VRM8:{ *:[nxv64i8] }:$rs1, VRM8:{ *:[nxv64i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREM_VV_M8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 60105,
        GIR_Done,
      // Label 636: @12032
      GIM_Try, /*On fail goto*//*Label 637*/ 12062, // Rule ID 60106 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (srem:{ *:[nxv64i8] } VRM8:{ *:[nxv64i8] }:$rs1, VRM8:{ *:[nxv64i8] }:$rs2)  =>  (PseudoVREM_VV_M8:{ *:[nxv64i8] } VRM8:{ *:[nxv64i8] }:$rs1, VRM8:{ *:[nxv64i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREM_VV_M8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 60106,
        GIR_Done,
      // Label 637: @12062
      GIM_Reject,
    // Label 635: @12063
    GIM_Reject,
    // Label 569: @12064
    GIM_Reject,
    // Label 6: @12065
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/1, 32, /*)*//*default:*//*Label 662*/ 14014,
    /*GILLT_s32*//*Label 638*/ 12102,
    /*GILLT_s64*//*Label 639*/ 12134, 0,
    /*GILLT_nxv1s8*//*Label 640*/ 12166,
    /*GILLT_nxv1s16*//*Label 641*/ 12250,
    /*GILLT_nxv1s32*//*Label 642*/ 12334,
    /*GILLT_nxv1s64*//*Label 643*/ 12418, 0,
    /*GILLT_nxv2s8*//*Label 644*/ 12502,
    /*GILLT_nxv2s16*//*Label 645*/ 12586,
    /*GILLT_nxv2s32*//*Label 646*/ 12670,
    /*GILLT_nxv2s64*//*Label 647*/ 12754, 0,
    /*GILLT_nxv4s8*//*Label 648*/ 12838,
    /*GILLT_nxv4s16*//*Label 649*/ 12922,
    /*GILLT_nxv4s32*//*Label 650*/ 13006,
    /*GILLT_nxv4s64*//*Label 651*/ 13090, 0,
    /*GILLT_nxv8s8*//*Label 652*/ 13174,
    /*GILLT_nxv8s16*//*Label 653*/ 13258,
    /*GILLT_nxv8s32*//*Label 654*/ 13342,
    /*GILLT_nxv8s64*//*Label 655*/ 13426, 0,
    /*GILLT_nxv16s8*//*Label 656*/ 13510,
    /*GILLT_nxv16s16*//*Label 657*/ 13594,
    /*GILLT_nxv16s32*//*Label 658*/ 13678, 0,
    /*GILLT_nxv32s8*//*Label 659*/ 13762,
    /*GILLT_nxv32s16*//*Label 660*/ 13846, 0,
    /*GILLT_nxv64s8*//*Label 661*/ 13930,
    // Label 638: @12102
    GIM_Try, /*On fail goto*//*Label 663*/ 12133, // Rule ID 63417 //
      GIM_CheckFeatures, GIFBS_HasStdExtM,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
      // (urem:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)  =>  (REMU:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::REMU,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 63417,
      GIR_Done,
    // Label 663: @12133
    GIM_Reject,
    // Label 639: @12134
    GIM_Try, /*On fail goto*//*Label 664*/ 12165, // Rule ID 63416 //
      GIM_CheckFeatures, GIFBS_HasStdExtM,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
      // (urem:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)  =>  (REMU:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::REMU,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 63416,
      GIR_Done,
    // Label 664: @12165
    GIM_Reject,
    // Label 640: @12166
    GIM_Try, /*On fail goto*//*Label 665*/ 12249,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv1s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv1s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 666*/ 12218, // Rule ID 59955 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (urem:{ *:[nxv1i8] } VR:{ *:[nxv1i8] }:$rs1, VR:{ *:[nxv1i8] }:$rs2)  =>  (PseudoVREMU_VV_MF8:{ *:[nxv1i8] } VR:{ *:[nxv1i8] }:$rs1, VR:{ *:[nxv1i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREMU_VV_MF8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 59955,
        GIR_Done,
      // Label 666: @12218
      GIM_Try, /*On fail goto*//*Label 667*/ 12248, // Rule ID 59956 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (urem:{ *:[nxv1i8] } VR:{ *:[nxv1i8] }:$rs1, VR:{ *:[nxv1i8] }:$rs2)  =>  (PseudoVREMU_VV_MF8:{ *:[nxv1i8] } VR:{ *:[nxv1i8] }:$rs1, VR:{ *:[nxv1i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREMU_VV_MF8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 59956,
        GIR_Done,
      // Label 667: @12248
      GIM_Reject,
    // Label 665: @12249
    GIM_Reject,
    // Label 641: @12250
    GIM_Try, /*On fail goto*//*Label 668*/ 12333,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv1s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv1s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 669*/ 12302, // Rule ID 59969 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (urem:{ *:[nxv1i16] } VR:{ *:[nxv1i16] }:$rs1, VR:{ *:[nxv1i16] }:$rs2)  =>  (PseudoVREMU_VV_MF4:{ *:[nxv1i16] } VR:{ *:[nxv1i16] }:$rs1, VR:{ *:[nxv1i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREMU_VV_MF4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 59969,
        GIR_Done,
      // Label 669: @12302
      GIM_Try, /*On fail goto*//*Label 670*/ 12332, // Rule ID 59970 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (urem:{ *:[nxv1i16] } VR:{ *:[nxv1i16] }:$rs1, VR:{ *:[nxv1i16] }:$rs2)  =>  (PseudoVREMU_VV_MF4:{ *:[nxv1i16] } VR:{ *:[nxv1i16] }:$rs1, VR:{ *:[nxv1i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREMU_VV_MF4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 59970,
        GIR_Done,
      // Label 670: @12332
      GIM_Reject,
    // Label 668: @12333
    GIM_Reject,
    // Label 642: @12334
    GIM_Try, /*On fail goto*//*Label 671*/ 12417,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv1s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv1s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 672*/ 12386, // Rule ID 59977 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (urem:{ *:[nxv1i32] } VR:{ *:[nxv1i32] }:$rs1, VR:{ *:[nxv1i32] }:$rs2)  =>  (PseudoVREMU_VV_MF2:{ *:[nxv1i32] } VR:{ *:[nxv1i32] }:$rs1, VR:{ *:[nxv1i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREMU_VV_MF2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 59977,
        GIR_Done,
      // Label 672: @12386
      GIM_Try, /*On fail goto*//*Label 673*/ 12416, // Rule ID 59978 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (urem:{ *:[nxv1i32] } VR:{ *:[nxv1i32] }:$rs1, VR:{ *:[nxv1i32] }:$rs2)  =>  (PseudoVREMU_VV_MF2:{ *:[nxv1i32] } VR:{ *:[nxv1i32] }:$rs1, VR:{ *:[nxv1i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREMU_VV_MF2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 59978,
        GIR_Done,
      // Label 673: @12416
      GIM_Reject,
    // Label 671: @12417
    GIM_Reject,
    // Label 643: @12418
    GIM_Try, /*On fail goto*//*Label 674*/ 12501,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv1s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv1s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 675*/ 12470, // Rule ID 59995 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (urem:{ *:[nxv1i64] } VR:{ *:[nxv1i64] }:$rs1, VR:{ *:[nxv1i64] }:$rs2)  =>  (PseudoVREMU_VV_M1:{ *:[nxv1i64] } VR:{ *:[nxv1i64] }:$rs1, VR:{ *:[nxv1i64] }:$rs2, -1:{ *:[i64] }, 6:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREMU_VV_M1,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 59995,
        GIR_Done,
      // Label 675: @12470
      GIM_Try, /*On fail goto*//*Label 676*/ 12500, // Rule ID 59996 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (urem:{ *:[nxv1i64] } VR:{ *:[nxv1i64] }:$rs1, VR:{ *:[nxv1i64] }:$rs2)  =>  (PseudoVREMU_VV_M1:{ *:[nxv1i64] } VR:{ *:[nxv1i64] }:$rs1, VR:{ *:[nxv1i64] }:$rs2, -1:{ *:[i32] }, 6:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREMU_VV_M1,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 59996,
        GIR_Done,
      // Label 676: @12500
      GIM_Reject,
    // Label 674: @12501
    GIM_Reject,
    // Label 644: @12502
    GIM_Try, /*On fail goto*//*Label 677*/ 12585,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv2s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv2s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 678*/ 12554, // Rule ID 59961 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (urem:{ *:[nxv2i8] } VR:{ *:[nxv2i8] }:$rs1, VR:{ *:[nxv2i8] }:$rs2)  =>  (PseudoVREMU_VV_MF4:{ *:[nxv2i8] } VR:{ *:[nxv2i8] }:$rs1, VR:{ *:[nxv2i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREMU_VV_MF4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 59961,
        GIR_Done,
      // Label 678: @12554
      GIM_Try, /*On fail goto*//*Label 679*/ 12584, // Rule ID 59962 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (urem:{ *:[nxv2i8] } VR:{ *:[nxv2i8] }:$rs1, VR:{ *:[nxv2i8] }:$rs2)  =>  (PseudoVREMU_VV_MF4:{ *:[nxv2i8] } VR:{ *:[nxv2i8] }:$rs1, VR:{ *:[nxv2i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREMU_VV_MF4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 59962,
        GIR_Done,
      // Label 679: @12584
      GIM_Reject,
    // Label 677: @12585
    GIM_Reject,
    // Label 645: @12586
    GIM_Try, /*On fail goto*//*Label 680*/ 12669,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv2s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv2s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 681*/ 12638, // Rule ID 59973 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (urem:{ *:[nxv2i16] } VR:{ *:[nxv2i16] }:$rs1, VR:{ *:[nxv2i16] }:$rs2)  =>  (PseudoVREMU_VV_MF2:{ *:[nxv2i16] } VR:{ *:[nxv2i16] }:$rs1, VR:{ *:[nxv2i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREMU_VV_MF2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 59973,
        GIR_Done,
      // Label 681: @12638
      GIM_Try, /*On fail goto*//*Label 682*/ 12668, // Rule ID 59974 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (urem:{ *:[nxv2i16] } VR:{ *:[nxv2i16] }:$rs1, VR:{ *:[nxv2i16] }:$rs2)  =>  (PseudoVREMU_VV_MF2:{ *:[nxv2i16] } VR:{ *:[nxv2i16] }:$rs1, VR:{ *:[nxv2i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREMU_VV_MF2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 59974,
        GIR_Done,
      // Label 682: @12668
      GIM_Reject,
    // Label 680: @12669
    GIM_Reject,
    // Label 646: @12670
    GIM_Try, /*On fail goto*//*Label 683*/ 12753,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv2s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv2s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 684*/ 12722, // Rule ID 59991 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (urem:{ *:[nxv2i32] } VR:{ *:[nxv2i32] }:$rs1, VR:{ *:[nxv2i32] }:$rs2)  =>  (PseudoVREMU_VV_M1:{ *:[nxv2i32] } VR:{ *:[nxv2i32] }:$rs1, VR:{ *:[nxv2i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREMU_VV_M1,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 59991,
        GIR_Done,
      // Label 684: @12722
      GIM_Try, /*On fail goto*//*Label 685*/ 12752, // Rule ID 59992 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (urem:{ *:[nxv2i32] } VR:{ *:[nxv2i32] }:$rs1, VR:{ *:[nxv2i32] }:$rs2)  =>  (PseudoVREMU_VV_M1:{ *:[nxv2i32] } VR:{ *:[nxv2i32] }:$rs1, VR:{ *:[nxv2i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREMU_VV_M1,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 59992,
        GIR_Done,
      // Label 685: @12752
      GIM_Reject,
    // Label 683: @12753
    GIM_Reject,
    // Label 647: @12754
    GIM_Try, /*On fail goto*//*Label 686*/ 12837,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv2s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM2RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM2RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM2RegClassID,
      GIM_Try, /*On fail goto*//*Label 687*/ 12806, // Rule ID 60039 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (urem:{ *:[nxv2i64] } VRM2:{ *:[nxv2i64] }:$rs1, VRM2:{ *:[nxv2i64] }:$rs2)  =>  (PseudoVREMU_VV_M2:{ *:[nxv2i64] } VRM2:{ *:[nxv2i64] }:$rs1, VRM2:{ *:[nxv2i64] }:$rs2, -1:{ *:[i64] }, 6:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREMU_VV_M2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 60039,
        GIR_Done,
      // Label 687: @12806
      GIM_Try, /*On fail goto*//*Label 688*/ 12836, // Rule ID 60040 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (urem:{ *:[nxv2i64] } VRM2:{ *:[nxv2i64] }:$rs1, VRM2:{ *:[nxv2i64] }:$rs2)  =>  (PseudoVREMU_VV_M2:{ *:[nxv2i64] } VRM2:{ *:[nxv2i64] }:$rs1, VRM2:{ *:[nxv2i64] }:$rs2, -1:{ *:[i32] }, 6:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREMU_VV_M2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 60040,
        GIR_Done,
      // Label 688: @12836
      GIM_Reject,
    // Label 686: @12837
    GIM_Reject,
    // Label 648: @12838
    GIM_Try, /*On fail goto*//*Label 689*/ 12921,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv4s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv4s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 690*/ 12890, // Rule ID 59965 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (urem:{ *:[nxv4i8] } VR:{ *:[nxv4i8] }:$rs1, VR:{ *:[nxv4i8] }:$rs2)  =>  (PseudoVREMU_VV_MF2:{ *:[nxv4i8] } VR:{ *:[nxv4i8] }:$rs1, VR:{ *:[nxv4i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREMU_VV_MF2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 59965,
        GIR_Done,
      // Label 690: @12890
      GIM_Try, /*On fail goto*//*Label 691*/ 12920, // Rule ID 59966 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (urem:{ *:[nxv4i8] } VR:{ *:[nxv4i8] }:$rs1, VR:{ *:[nxv4i8] }:$rs2)  =>  (PseudoVREMU_VV_MF2:{ *:[nxv4i8] } VR:{ *:[nxv4i8] }:$rs1, VR:{ *:[nxv4i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREMU_VV_MF2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 59966,
        GIR_Done,
      // Label 691: @12920
      GIM_Reject,
    // Label 689: @12921
    GIM_Reject,
    // Label 649: @12922
    GIM_Try, /*On fail goto*//*Label 692*/ 13005,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv4s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv4s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 693*/ 12974, // Rule ID 59987 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (urem:{ *:[nxv4i16] } VR:{ *:[nxv4i16] }:$rs1, VR:{ *:[nxv4i16] }:$rs2)  =>  (PseudoVREMU_VV_M1:{ *:[nxv4i16] } VR:{ *:[nxv4i16] }:$rs1, VR:{ *:[nxv4i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREMU_VV_M1,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 59987,
        GIR_Done,
      // Label 693: @12974
      GIM_Try, /*On fail goto*//*Label 694*/ 13004, // Rule ID 59988 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (urem:{ *:[nxv4i16] } VR:{ *:[nxv4i16] }:$rs1, VR:{ *:[nxv4i16] }:$rs2)  =>  (PseudoVREMU_VV_M1:{ *:[nxv4i16] } VR:{ *:[nxv4i16] }:$rs1, VR:{ *:[nxv4i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREMU_VV_M1,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 59988,
        GIR_Done,
      // Label 694: @13004
      GIM_Reject,
    // Label 692: @13005
    GIM_Reject,
    // Label 650: @13006
    GIM_Try, /*On fail goto*//*Label 695*/ 13089,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv4s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM2RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM2RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM2RegClassID,
      GIM_Try, /*On fail goto*//*Label 696*/ 13058, // Rule ID 60027 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (urem:{ *:[nxv4i32] } VRM2:{ *:[nxv4i32] }:$rs1, VRM2:{ *:[nxv4i32] }:$rs2)  =>  (PseudoVREMU_VV_M2:{ *:[nxv4i32] } VRM2:{ *:[nxv4i32] }:$rs1, VRM2:{ *:[nxv4i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREMU_VV_M2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 60027,
        GIR_Done,
      // Label 696: @13058
      GIM_Try, /*On fail goto*//*Label 697*/ 13088, // Rule ID 60028 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (urem:{ *:[nxv4i32] } VRM2:{ *:[nxv4i32] }:$rs1, VRM2:{ *:[nxv4i32] }:$rs2)  =>  (PseudoVREMU_VV_M2:{ *:[nxv4i32] } VRM2:{ *:[nxv4i32] }:$rs1, VRM2:{ *:[nxv4i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREMU_VV_M2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 60028,
        GIR_Done,
      // Label 697: @13088
      GIM_Reject,
    // Label 695: @13089
    GIM_Reject,
    // Label 651: @13090
    GIM_Try, /*On fail goto*//*Label 698*/ 13173,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv4s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv4s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM4RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM4RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM4RegClassID,
      GIM_Try, /*On fail goto*//*Label 699*/ 13142, // Rule ID 60043 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (urem:{ *:[nxv4i64] } VRM4:{ *:[nxv4i64] }:$rs1, VRM4:{ *:[nxv4i64] }:$rs2)  =>  (PseudoVREMU_VV_M4:{ *:[nxv4i64] } VRM4:{ *:[nxv4i64] }:$rs1, VRM4:{ *:[nxv4i64] }:$rs2, -1:{ *:[i64] }, 6:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREMU_VV_M4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 60043,
        GIR_Done,
      // Label 699: @13142
      GIM_Try, /*On fail goto*//*Label 700*/ 13172, // Rule ID 60044 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (urem:{ *:[nxv4i64] } VRM4:{ *:[nxv4i64] }:$rs1, VRM4:{ *:[nxv4i64] }:$rs2)  =>  (PseudoVREMU_VV_M4:{ *:[nxv4i64] } VRM4:{ *:[nxv4i64] }:$rs1, VRM4:{ *:[nxv4i64] }:$rs2, -1:{ *:[i32] }, 6:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREMU_VV_M4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 60044,
        GIR_Done,
      // Label 700: @13172
      GIM_Reject,
    // Label 698: @13173
    GIM_Reject,
    // Label 652: @13174
    GIM_Try, /*On fail goto*//*Label 701*/ 13257,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv8s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv8s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 702*/ 13226, // Rule ID 59983 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (urem:{ *:[nxv8i8] } VR:{ *:[nxv8i8] }:$rs1, VR:{ *:[nxv8i8] }:$rs2)  =>  (PseudoVREMU_VV_M1:{ *:[nxv8i8] } VR:{ *:[nxv8i8] }:$rs1, VR:{ *:[nxv8i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREMU_VV_M1,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 59983,
        GIR_Done,
      // Label 702: @13226
      GIM_Try, /*On fail goto*//*Label 703*/ 13256, // Rule ID 59984 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (urem:{ *:[nxv8i8] } VR:{ *:[nxv8i8] }:$rs1, VR:{ *:[nxv8i8] }:$rs2)  =>  (PseudoVREMU_VV_M1:{ *:[nxv8i8] } VR:{ *:[nxv8i8] }:$rs1, VR:{ *:[nxv8i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREMU_VV_M1,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 59984,
        GIR_Done,
      // Label 703: @13256
      GIM_Reject,
    // Label 701: @13257
    GIM_Reject,
    // Label 653: @13258
    GIM_Try, /*On fail goto*//*Label 704*/ 13341,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv8s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM2RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM2RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM2RegClassID,
      GIM_Try, /*On fail goto*//*Label 705*/ 13310, // Rule ID 60013 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (urem:{ *:[nxv8i16] } VRM2:{ *:[nxv8i16] }:$rs1, VRM2:{ *:[nxv8i16] }:$rs2)  =>  (PseudoVREMU_VV_M2:{ *:[nxv8i16] } VRM2:{ *:[nxv8i16] }:$rs1, VRM2:{ *:[nxv8i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREMU_VV_M2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 60013,
        GIR_Done,
      // Label 705: @13310
      GIM_Try, /*On fail goto*//*Label 706*/ 13340, // Rule ID 60014 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (urem:{ *:[nxv8i16] } VRM2:{ *:[nxv8i16] }:$rs1, VRM2:{ *:[nxv8i16] }:$rs2)  =>  (PseudoVREMU_VV_M2:{ *:[nxv8i16] } VRM2:{ *:[nxv8i16] }:$rs1, VRM2:{ *:[nxv8i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREMU_VV_M2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 60014,
        GIR_Done,
      // Label 706: @13340
      GIM_Reject,
    // Label 704: @13341
    GIM_Reject,
    // Label 654: @13342
    GIM_Try, /*On fail goto*//*Label 707*/ 13425,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv8s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv8s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM4RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM4RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM4RegClassID,
      GIM_Try, /*On fail goto*//*Label 708*/ 13394, // Rule ID 60031 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (urem:{ *:[nxv8i32] } VRM4:{ *:[nxv8i32] }:$rs1, VRM4:{ *:[nxv8i32] }:$rs2)  =>  (PseudoVREMU_VV_M4:{ *:[nxv8i32] } VRM4:{ *:[nxv8i32] }:$rs1, VRM4:{ *:[nxv8i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREMU_VV_M4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 60031,
        GIR_Done,
      // Label 708: @13394
      GIM_Try, /*On fail goto*//*Label 709*/ 13424, // Rule ID 60032 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (urem:{ *:[nxv8i32] } VRM4:{ *:[nxv8i32] }:$rs1, VRM4:{ *:[nxv8i32] }:$rs2)  =>  (PseudoVREMU_VV_M4:{ *:[nxv8i32] } VRM4:{ *:[nxv8i32] }:$rs1, VRM4:{ *:[nxv8i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREMU_VV_M4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 60032,
        GIR_Done,
      // Label 709: @13424
      GIM_Reject,
    // Label 707: @13425
    GIM_Reject,
    // Label 655: @13426
    GIM_Try, /*On fail goto*//*Label 710*/ 13509,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv8s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv8s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM8RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM8RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM8RegClassID,
      GIM_Try, /*On fail goto*//*Label 711*/ 13478, // Rule ID 60049 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (urem:{ *:[nxv8i64] } VRM8:{ *:[nxv8i64] }:$rs1, VRM8:{ *:[nxv8i64] }:$rs2)  =>  (PseudoVREMU_VV_M8:{ *:[nxv8i64] } VRM8:{ *:[nxv8i64] }:$rs1, VRM8:{ *:[nxv8i64] }:$rs2, -1:{ *:[i64] }, 6:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREMU_VV_M8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 60049,
        GIR_Done,
      // Label 711: @13478
      GIM_Try, /*On fail goto*//*Label 712*/ 13508, // Rule ID 60050 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (urem:{ *:[nxv8i64] } VRM8:{ *:[nxv8i64] }:$rs1, VRM8:{ *:[nxv8i64] }:$rs2)  =>  (PseudoVREMU_VV_M8:{ *:[nxv8i64] } VRM8:{ *:[nxv8i64] }:$rs1, VRM8:{ *:[nxv8i64] }:$rs2, -1:{ *:[i32] }, 6:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREMU_VV_M8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 60050,
        GIR_Done,
      // Label 712: @13508
      GIM_Reject,
    // Label 710: @13509
    GIM_Reject,
    // Label 656: @13510
    GIM_Try, /*On fail goto*//*Label 713*/ 13593,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv16s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv16s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM2RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM2RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM2RegClassID,
      GIM_Try, /*On fail goto*//*Label 714*/ 13562, // Rule ID 59999 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (urem:{ *:[nxv16i8] } VRM2:{ *:[nxv16i8] }:$rs1, VRM2:{ *:[nxv16i8] }:$rs2)  =>  (PseudoVREMU_VV_M2:{ *:[nxv16i8] } VRM2:{ *:[nxv16i8] }:$rs1, VRM2:{ *:[nxv16i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREMU_VV_M2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 59999,
        GIR_Done,
      // Label 714: @13562
      GIM_Try, /*On fail goto*//*Label 715*/ 13592, // Rule ID 60000 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (urem:{ *:[nxv16i8] } VRM2:{ *:[nxv16i8] }:$rs1, VRM2:{ *:[nxv16i8] }:$rs2)  =>  (PseudoVREMU_VV_M2:{ *:[nxv16i8] } VRM2:{ *:[nxv16i8] }:$rs1, VRM2:{ *:[nxv16i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREMU_VV_M2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 60000,
        GIR_Done,
      // Label 715: @13592
      GIM_Reject,
    // Label 713: @13593
    GIM_Reject,
    // Label 657: @13594
    GIM_Try, /*On fail goto*//*Label 716*/ 13677,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv16s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv16s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM4RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM4RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM4RegClassID,
      GIM_Try, /*On fail goto*//*Label 717*/ 13646, // Rule ID 60017 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (urem:{ *:[nxv16i16] } VRM4:{ *:[nxv16i16] }:$rs1, VRM4:{ *:[nxv16i16] }:$rs2)  =>  (PseudoVREMU_VV_M4:{ *:[nxv16i16] } VRM4:{ *:[nxv16i16] }:$rs1, VRM4:{ *:[nxv16i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREMU_VV_M4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 60017,
        GIR_Done,
      // Label 717: @13646
      GIM_Try, /*On fail goto*//*Label 718*/ 13676, // Rule ID 60018 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (urem:{ *:[nxv16i16] } VRM4:{ *:[nxv16i16] }:$rs1, VRM4:{ *:[nxv16i16] }:$rs2)  =>  (PseudoVREMU_VV_M4:{ *:[nxv16i16] } VRM4:{ *:[nxv16i16] }:$rs1, VRM4:{ *:[nxv16i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREMU_VV_M4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 60018,
        GIR_Done,
      // Label 718: @13676
      GIM_Reject,
    // Label 716: @13677
    GIM_Reject,
    // Label 658: @13678
    GIM_Try, /*On fail goto*//*Label 719*/ 13761,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv16s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv16s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM8RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM8RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM8RegClassID,
      GIM_Try, /*On fail goto*//*Label 720*/ 13730, // Rule ID 60035 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (urem:{ *:[nxv16i32] } VRM8:{ *:[nxv16i32] }:$rs1, VRM8:{ *:[nxv16i32] }:$rs2)  =>  (PseudoVREMU_VV_M8:{ *:[nxv16i32] } VRM8:{ *:[nxv16i32] }:$rs1, VRM8:{ *:[nxv16i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREMU_VV_M8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 60035,
        GIR_Done,
      // Label 720: @13730
      GIM_Try, /*On fail goto*//*Label 721*/ 13760, // Rule ID 60036 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (urem:{ *:[nxv16i32] } VRM8:{ *:[nxv16i32] }:$rs1, VRM8:{ *:[nxv16i32] }:$rs2)  =>  (PseudoVREMU_VV_M8:{ *:[nxv16i32] } VRM8:{ *:[nxv16i32] }:$rs1, VRM8:{ *:[nxv16i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREMU_VV_M8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 60036,
        GIR_Done,
      // Label 721: @13760
      GIM_Reject,
    // Label 719: @13761
    GIM_Reject,
    // Label 659: @13762
    GIM_Try, /*On fail goto*//*Label 722*/ 13845,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv32s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv32s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM4RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM4RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM4RegClassID,
      GIM_Try, /*On fail goto*//*Label 723*/ 13814, // Rule ID 60005 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (urem:{ *:[nxv32i8] } VRM4:{ *:[nxv32i8] }:$rs1, VRM4:{ *:[nxv32i8] }:$rs2)  =>  (PseudoVREMU_VV_M4:{ *:[nxv32i8] } VRM4:{ *:[nxv32i8] }:$rs1, VRM4:{ *:[nxv32i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREMU_VV_M4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 60005,
        GIR_Done,
      // Label 723: @13814
      GIM_Try, /*On fail goto*//*Label 724*/ 13844, // Rule ID 60006 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (urem:{ *:[nxv32i8] } VRM4:{ *:[nxv32i8] }:$rs1, VRM4:{ *:[nxv32i8] }:$rs2)  =>  (PseudoVREMU_VV_M4:{ *:[nxv32i8] } VRM4:{ *:[nxv32i8] }:$rs1, VRM4:{ *:[nxv32i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREMU_VV_M4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 60006,
        GIR_Done,
      // Label 724: @13844
      GIM_Reject,
    // Label 722: @13845
    GIM_Reject,
    // Label 660: @13846
    GIM_Try, /*On fail goto*//*Label 725*/ 13929,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv32s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv32s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM8RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM8RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM8RegClassID,
      GIM_Try, /*On fail goto*//*Label 726*/ 13898, // Rule ID 60021 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (urem:{ *:[nxv32i16] } VRM8:{ *:[nxv32i16] }:$rs1, VRM8:{ *:[nxv32i16] }:$rs2)  =>  (PseudoVREMU_VV_M8:{ *:[nxv32i16] } VRM8:{ *:[nxv32i16] }:$rs1, VRM8:{ *:[nxv32i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREMU_VV_M8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 60021,
        GIR_Done,
      // Label 726: @13898
      GIM_Try, /*On fail goto*//*Label 727*/ 13928, // Rule ID 60022 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (urem:{ *:[nxv32i16] } VRM8:{ *:[nxv32i16] }:$rs1, VRM8:{ *:[nxv32i16] }:$rs2)  =>  (PseudoVREMU_VV_M8:{ *:[nxv32i16] } VRM8:{ *:[nxv32i16] }:$rs1, VRM8:{ *:[nxv32i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREMU_VV_M8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 60022,
        GIR_Done,
      // Label 727: @13928
      GIM_Reject,
    // Label 725: @13929
    GIM_Reject,
    // Label 661: @13930
    GIM_Try, /*On fail goto*//*Label 728*/ 14013,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv64s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv64s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM8RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM8RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM8RegClassID,
      GIM_Try, /*On fail goto*//*Label 729*/ 13982, // Rule ID 60009 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (urem:{ *:[nxv64i8] } VRM8:{ *:[nxv64i8] }:$rs1, VRM8:{ *:[nxv64i8] }:$rs2)  =>  (PseudoVREMU_VV_M8:{ *:[nxv64i8] } VRM8:{ *:[nxv64i8] }:$rs1, VRM8:{ *:[nxv64i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREMU_VV_M8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 60009,
        GIR_Done,
      // Label 729: @13982
      GIM_Try, /*On fail goto*//*Label 730*/ 14012, // Rule ID 60010 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (urem:{ *:[nxv64i8] } VRM8:{ *:[nxv64i8] }:$rs1, VRM8:{ *:[nxv64i8] }:$rs2)  =>  (PseudoVREMU_VV_M8:{ *:[nxv64i8] } VRM8:{ *:[nxv64i8] }:$rs1, VRM8:{ *:[nxv64i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVREMU_VV_M8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 60010,
        GIR_Done,
      // Label 730: @14012
      GIM_Reject,
    // Label 728: @14013
    GIM_Reject,
    // Label 662: @14014
    GIM_Reject,
    // Label 7: @14015
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/1, 32, /*)*//*default:*//*Label 762*/ 17310,
    /*GILLT_s32*//*Label 731*/ 14052,
    /*GILLT_s64*//*Label 732*/ 14422,
    /*GILLT_nxv1s1*//*Label 733*/ 14874,
    /*GILLT_nxv1s8*//*Label 734*/ 14958,
    /*GILLT_nxv1s16*//*Label 735*/ 15042,
    /*GILLT_nxv1s32*//*Label 736*/ 15126,
    /*GILLT_nxv1s64*//*Label 737*/ 15210,
    /*GILLT_nxv2s1*//*Label 738*/ 15294,
    /*GILLT_nxv2s8*//*Label 739*/ 15378,
    /*GILLT_nxv2s16*//*Label 740*/ 15462,
    /*GILLT_nxv2s32*//*Label 741*/ 15546,
    /*GILLT_nxv2s64*//*Label 742*/ 15630,
    /*GILLT_nxv4s1*//*Label 743*/ 15714,
    /*GILLT_nxv4s8*//*Label 744*/ 15798,
    /*GILLT_nxv4s16*//*Label 745*/ 15882,
    /*GILLT_nxv4s32*//*Label 746*/ 15966,
    /*GILLT_nxv4s64*//*Label 747*/ 16050,
    /*GILLT_nxv8s1*//*Label 748*/ 16134,
    /*GILLT_nxv8s8*//*Label 749*/ 16218,
    /*GILLT_nxv8s16*//*Label 750*/ 16302,
    /*GILLT_nxv8s32*//*Label 751*/ 16386,
    /*GILLT_nxv8s64*//*Label 752*/ 16470,
    /*GILLT_nxv16s1*//*Label 753*/ 16554,
    /*GILLT_nxv16s8*//*Label 754*/ 16638,
    /*GILLT_nxv16s16*//*Label 755*/ 16722,
    /*GILLT_nxv16s32*//*Label 756*/ 16806,
    /*GILLT_nxv32s1*//*Label 757*/ 16890,
    /*GILLT_nxv32s8*//*Label 758*/ 16974,
    /*GILLT_nxv32s16*//*Label 759*/ 17058,
    /*GILLT_nxv64s1*//*Label 760*/ 17142,
    /*GILLT_nxv64s8*//*Label 761*/ 17226,
    // Label 731: @14052
    GIM_Try, /*On fail goto*//*Label 763*/ 14421,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
      GIM_Try, /*On fail goto*//*Label 764*/ 14126, // Rule ID 65470 //
        GIM_CheckFeatures, GIFBS_HasStdExtZbs,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_LSHR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIPFP_I64_Predicate_uimmlog2xlen,
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, 1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (and:{ *:[i32] } (srl:{ *:[i32] } GPR:{ *:[i32] }:$rs1, (imm:{ *:[i32] })<<P:Predicate_uimmlog2xlen>>:$shamt), 1:{ *:[i32] })  =>  (BEXTI:{ *:[i32] } GPR:{ *:[i32] }:$rs1, (imm:{ *:[i32] })<<P:Predicate_uimmlog2xlen>>:$shamt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::BEXTI,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // shamt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 65470,
        GIR_Done,
      // Label 764: @14126
      GIM_Try, /*On fail goto*//*Label 765*/ 14179, // Rule ID 65454 //
        GIM_CheckFeatures, GIFBS_HasStdExtZbs,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ROTL,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/1, -2,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (and:{ *:[i32] } (rotl:{ *:[i32] } -2:{ *:[i32] }, GPR:{ *:[i32] }:$rs2), GPR:{ *:[i32] }:$rs1)  =>  (BCLR:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::BCLR,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rs2
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 65454,
        GIR_Done,
      // Label 765: @14179
      GIM_Try, /*On fail goto*//*Label 766*/ 14232, // Rule ID 72085 //
        GIM_CheckFeatures, GIFBS_HasStdExtZbbOrZbkb,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, -1,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (and:{ *:[i32] } (xor:{ *:[i32] } GPR:{ *:[i32] }:$rs2, -1:{ *:[i32] }), GPR:{ *:[i32] }:$rs1)  =>  (ANDN:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::ANDN,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs2
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 72085,
        GIR_Done,
      // Label 766: @14232
      GIM_Try, /*On fail goto*//*Label 767*/ 14285, // Rule ID 72095 //
        GIM_CheckFeatures, GIFBS_HasStdExtZbs,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ROTL,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/1, -2,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (and:{ *:[i32] } GPR:{ *:[i32] }:$rs1, (rotl:{ *:[i32] } -2:{ *:[i32] }, GPR:{ *:[i32] }:$rs2))  =>  (BCLR:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::BCLR,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rs2
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 72095,
        GIR_Done,
      // Label 767: @14285
      GIM_Try, /*On fail goto*//*Label 768*/ 14338, // Rule ID 65434 //
        GIM_CheckFeatures, GIFBS_HasStdExtZbbOrZbkb,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, -1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (and:{ *:[i32] } GPR:{ *:[i32] }:$rs1, (xor:{ *:[i32] } GPR:{ *:[i32] }:$rs2, -1:{ *:[i32] }))  =>  (ANDN:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::ANDN,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs2
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 65434,
        GIR_Done,
      // Label 768: @14338
      GIM_Try, /*On fail goto*//*Label 769*/ 14366, // Rule ID 65525 //
        GIM_CheckFeatures, GIFBS_HasStdExtZbb_IsRV32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, 65535,
        // (and:{ *:[i32] } GPR:{ *:[i32] }:$rs, 65535:{ *:[i32] })  =>  (ZEXT_H_RV32:{ *:[i32] } GPR:{ *:[i32] }:$rs)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::ZEXT_H_RV32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 65525,
        GIR_Done,
      // Label 769: @14366
      GIM_Try, /*On fail goto*//*Label 770*/ 14403, // Rule ID 59938 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIPFP_I64_Predicate_simm12,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (and:{ *:[i32] } GPR:{ *:[i32] }:$rs1, (imm:{ *:[i32] })<<P:Predicate_simm12>>:$imm)  =>  (ANDI:{ *:[i32] } GPR:{ *:[i32] }:$rs1, (imm:{ *:[i32] })<<P:Predicate_simm12>>:$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::ANDI,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // imm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 59938,
        GIR_Done,
      // Label 770: @14403
      GIM_Try, /*On fail goto*//*Label 771*/ 14420, // Rule ID 59916 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (and:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)  =>  (AND:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::AND,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 59916,
        GIR_Done,
      // Label 771: @14420
      GIM_Reject,
    // Label 763: @14421
    GIM_Reject,
    // Label 732: @14422
    GIM_Try, /*On fail goto*//*Label 772*/ 14873,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
      GIM_Try, /*On fail goto*//*Label 773*/ 14496, // Rule ID 65469 //
        GIM_CheckFeatures, GIFBS_HasStdExtZbs,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_LSHR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIPFP_I64_Predicate_uimmlog2xlen,
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, 1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (and:{ *:[i64] } (srl:{ *:[i64] } GPR:{ *:[i64] }:$rs1, (imm:{ *:[i64] })<<P:Predicate_uimmlog2xlen>>:$shamt), 1:{ *:[i64] })  =>  (BEXTI:{ *:[i64] } GPR:{ *:[i64] }:$rs1, (imm:{ *:[i64] })<<P:Predicate_uimmlog2xlen>>:$shamt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::BEXTI,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // shamt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 65469,
        GIR_Done,
      // Label 773: @14496
      GIM_Try, /*On fail goto*//*Label 774*/ 14549, // Rule ID 65453 //
        GIM_CheckFeatures, GIFBS_HasStdExtZbs,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ROTL,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/1, -2,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (and:{ *:[i64] } (rotl:{ *:[i64] } -2:{ *:[i64] }, GPR:{ *:[i64] }:$rs2), GPR:{ *:[i64] }:$rs1)  =>  (BCLR:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::BCLR,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rs2
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 65453,
        GIR_Done,
      // Label 774: @14549
      GIM_Try, /*On fail goto*//*Label 775*/ 14602, // Rule ID 72084 //
        GIM_CheckFeatures, GIFBS_HasStdExtZbbOrZbkb,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, -1,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (and:{ *:[i64] } (xor:{ *:[i64] } GPR:{ *:[i64] }:$rs2, -1:{ *:[i64] }), GPR:{ *:[i64] }:$rs1)  =>  (ANDN:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::ANDN,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs2
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 72084,
        GIR_Done,
      // Label 775: @14602
      GIM_Try, /*On fail goto*//*Label 776*/ 14655, // Rule ID 72094 //
        GIM_CheckFeatures, GIFBS_HasStdExtZbs,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ROTL,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/1, -2,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (and:{ *:[i64] } GPR:{ *:[i64] }:$rs1, (rotl:{ *:[i64] } -2:{ *:[i64] }, GPR:{ *:[i64] }:$rs2))  =>  (BCLR:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::BCLR,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rs2
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 72094,
        GIR_Done,
      // Label 776: @14655
      GIM_Try, /*On fail goto*//*Label 777*/ 14708, // Rule ID 65433 //
        GIM_CheckFeatures, GIFBS_HasStdExtZbbOrZbkb,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, -1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (and:{ *:[i64] } GPR:{ *:[i64] }:$rs1, (xor:{ *:[i64] } GPR:{ *:[i64] }:$rs2, -1:{ *:[i64] }))  =>  (ANDN:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::ANDN,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs2
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 65433,
        GIR_Done,
      // Label 777: @14708
      GIM_Try, /*On fail goto*//*Label 778*/ 14758, // Rule ID 62198 //
        GIM_CheckFeatures, GIFBS_IsRV64_NotHasStdExtZba,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, 4294967295,
        // (and:{ *:[i64] } GPR:{ *:[i64] }:$rs1, 4294967295:{ *:[i64] })  =>  (SRLI:{ *:[i64] } (SLLI:{ *:[i64] } GPR:{ *:[i64] }:$rs1, 32:{ *:[i64] }), 32:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/RISCV::SLLI,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_AddImm, /*InsnID*/1, /*Imm*/32,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::SRLI,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_AddImm, /*InsnID*/0, /*Imm*/32,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 62198,
        GIR_Done,
      // Label 778: @14758
      GIM_Try, /*On fail goto*//*Label 779*/ 14786, // Rule ID 65526 //
        GIM_CheckFeatures, GIFBS_HasStdExtZbb_IsRV64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, 65535,
        // (and:{ *:[i64] } GPR:{ *:[i64] }:$rs, 65535:{ *:[i64] })  =>  (ZEXT_H_RV64:{ *:[i64] } GPR:{ *:[i64] }:$rs)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::ZEXT_H_RV64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 65526,
        GIR_Done,
      // Label 779: @14786
      GIM_Try, /*On fail goto*//*Label 780*/ 14818, // Rule ID 65592 //
        GIM_CheckFeatures, GIFBS_HasStdExtZba_IsRV64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, 4294967295,
        // (and:{ *:[i64] } GPR:{ *:[i64] }:$rs, 4294967295:{ *:[i64] })  =>  (ADD_UW:{ *:[i64] } GPR:{ *:[i64] }:$rs, X0:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::ADD_UW,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs
        GIR_AddRegister, /*InsnID*/0, RISCV::X0, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 65592,
        GIR_Done,
      // Label 780: @14818
      GIM_Try, /*On fail goto*//*Label 781*/ 14855, // Rule ID 59937 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIPFP_I64_Predicate_simm12,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (and:{ *:[i64] } GPR:{ *:[i64] }:$rs1, (imm:{ *:[i64] })<<P:Predicate_simm12>>:$imm)  =>  (ANDI:{ *:[i64] } GPR:{ *:[i64] }:$rs1, (imm:{ *:[i64] })<<P:Predicate_simm12>>:$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::ANDI,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // imm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 59937,
        GIR_Done,
      // Label 781: @14855
      GIM_Try, /*On fail goto*//*Label 782*/ 14872, // Rule ID 59915 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (and:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)  =>  (AND:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::AND,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 59915,
        GIR_Done,
      // Label 782: @14872
      GIM_Reject,
    // Label 772: @14873
    GIM_Reject,
    // Label 733: @14874
    GIM_Try, /*On fail goto*//*Label 783*/ 14957,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv1s1,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv1s1,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 784*/ 14926, // Rule ID 61576 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (and:{ *:[nxv1i1] } VR:{ *:[nxv1i1] }:$rs1, VR:{ *:[nxv1i1] }:$rs2)  =>  (PseudoVMAND_MM_MF8:{ *:[nxv1i1] } VR:{ *:[nxv1i1] }:$rs1, VR:{ *:[nxv1i1] }:$rs2, -1:{ *:[i64] }, 0:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMAND_MM_MF8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 61576,
        GIR_Done,
      // Label 784: @14926
      GIM_Try, /*On fail goto*//*Label 785*/ 14956, // Rule ID 61577 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (and:{ *:[nxv1i1] } VR:{ *:[nxv1i1] }:$rs1, VR:{ *:[nxv1i1] }:$rs2)  =>  (PseudoVMAND_MM_MF8:{ *:[nxv1i1] } VR:{ *:[nxv1i1] }:$rs1, VR:{ *:[nxv1i1] }:$rs2, -1:{ *:[i32] }, 0:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMAND_MM_MF8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 61577,
        GIR_Done,
      // Label 785: @14956
      GIM_Reject,
    // Label 783: @14957
    GIM_Reject,
    // Label 734: @14958
    GIM_Try, /*On fail goto*//*Label 786*/ 15041,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv1s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv1s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 787*/ 15010, // Rule ID 56389 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (and:{ *:[nxv1i8] } VR:{ *:[nxv1i8] }:$rs1, VR:{ *:[nxv1i8] }:$rs2)  =>  (PseudoVAND_VV_MF8:{ *:[nxv1i8] } VR:{ *:[nxv1i8] }:$rs1, VR:{ *:[nxv1i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVAND_VV_MF8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 56389,
        GIR_Done,
      // Label 787: @15010
      GIM_Try, /*On fail goto*//*Label 788*/ 15040, // Rule ID 56390 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (and:{ *:[nxv1i8] } VR:{ *:[nxv1i8] }:$rs1, VR:{ *:[nxv1i8] }:$rs2)  =>  (PseudoVAND_VV_MF8:{ *:[nxv1i8] } VR:{ *:[nxv1i8] }:$rs1, VR:{ *:[nxv1i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVAND_VV_MF8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 56390,
        GIR_Done,
      // Label 788: @15040
      GIM_Reject,
    // Label 786: @15041
    GIM_Reject,
    // Label 735: @15042
    GIM_Try, /*On fail goto*//*Label 789*/ 15125,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv1s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv1s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 790*/ 15094, // Rule ID 56401 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (and:{ *:[nxv1i16] } VR:{ *:[nxv1i16] }:$rs1, VR:{ *:[nxv1i16] }:$rs2)  =>  (PseudoVAND_VV_MF4:{ *:[nxv1i16] } VR:{ *:[nxv1i16] }:$rs1, VR:{ *:[nxv1i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVAND_VV_MF4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 56401,
        GIR_Done,
      // Label 790: @15094
      GIM_Try, /*On fail goto*//*Label 791*/ 15124, // Rule ID 56402 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (and:{ *:[nxv1i16] } VR:{ *:[nxv1i16] }:$rs1, VR:{ *:[nxv1i16] }:$rs2)  =>  (PseudoVAND_VV_MF4:{ *:[nxv1i16] } VR:{ *:[nxv1i16] }:$rs1, VR:{ *:[nxv1i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVAND_VV_MF4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 56402,
        GIR_Done,
      // Label 791: @15124
      GIM_Reject,
    // Label 789: @15125
    GIM_Reject,
    // Label 736: @15126
    GIM_Try, /*On fail goto*//*Label 792*/ 15209,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv1s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv1s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 793*/ 15178, // Rule ID 56409 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (and:{ *:[nxv1i32] } VR:{ *:[nxv1i32] }:$rs1, VR:{ *:[nxv1i32] }:$rs2)  =>  (PseudoVAND_VV_MF2:{ *:[nxv1i32] } VR:{ *:[nxv1i32] }:$rs1, VR:{ *:[nxv1i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVAND_VV_MF2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 56409,
        GIR_Done,
      // Label 793: @15178
      GIM_Try, /*On fail goto*//*Label 794*/ 15208, // Rule ID 56410 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (and:{ *:[nxv1i32] } VR:{ *:[nxv1i32] }:$rs1, VR:{ *:[nxv1i32] }:$rs2)  =>  (PseudoVAND_VV_MF2:{ *:[nxv1i32] } VR:{ *:[nxv1i32] }:$rs1, VR:{ *:[nxv1i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVAND_VV_MF2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 56410,
        GIR_Done,
      // Label 794: @15208
      GIM_Reject,
    // Label 792: @15209
    GIM_Reject,
    // Label 737: @15210
    GIM_Try, /*On fail goto*//*Label 795*/ 15293,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv1s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv1s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 796*/ 15262, // Rule ID 56425 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (and:{ *:[nxv1i64] } VR:{ *:[nxv1i64] }:$rs1, VR:{ *:[nxv1i64] }:$rs2)  =>  (PseudoVAND_VV_M1:{ *:[nxv1i64] } VR:{ *:[nxv1i64] }:$rs1, VR:{ *:[nxv1i64] }:$rs2, -1:{ *:[i64] }, 6:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVAND_VV_M1,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 56425,
        GIR_Done,
      // Label 796: @15262
      GIM_Try, /*On fail goto*//*Label 797*/ 15292, // Rule ID 56426 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (and:{ *:[nxv1i64] } VR:{ *:[nxv1i64] }:$rs1, VR:{ *:[nxv1i64] }:$rs2)  =>  (PseudoVAND_VV_M1:{ *:[nxv1i64] } VR:{ *:[nxv1i64] }:$rs1, VR:{ *:[nxv1i64] }:$rs2, -1:{ *:[i32] }, 6:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVAND_VV_M1,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 56426,
        GIR_Done,
      // Label 797: @15292
      GIM_Reject,
    // Label 795: @15293
    GIM_Reject,
    // Label 738: @15294
    GIM_Try, /*On fail goto*//*Label 798*/ 15377,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv2s1,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv2s1,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 799*/ 15346, // Rule ID 61596 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (and:{ *:[nxv2i1] } VR:{ *:[nxv2i1] }:$rs1, VR:{ *:[nxv2i1] }:$rs2)  =>  (PseudoVMAND_MM_MF4:{ *:[nxv2i1] } VR:{ *:[nxv2i1] }:$rs1, VR:{ *:[nxv2i1] }:$rs2, -1:{ *:[i64] }, 0:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMAND_MM_MF4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 61596,
        GIR_Done,
      // Label 799: @15346
      GIM_Try, /*On fail goto*//*Label 800*/ 15376, // Rule ID 61597 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (and:{ *:[nxv2i1] } VR:{ *:[nxv2i1] }:$rs1, VR:{ *:[nxv2i1] }:$rs2)  =>  (PseudoVMAND_MM_MF4:{ *:[nxv2i1] } VR:{ *:[nxv2i1] }:$rs1, VR:{ *:[nxv2i1] }:$rs2, -1:{ *:[i32] }, 0:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMAND_MM_MF4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 61597,
        GIR_Done,
      // Label 800: @15376
      GIM_Reject,
    // Label 798: @15377
    GIM_Reject,
    // Label 739: @15378
    GIM_Try, /*On fail goto*//*Label 801*/ 15461,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv2s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv2s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 802*/ 15430, // Rule ID 56393 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (and:{ *:[nxv2i8] } VR:{ *:[nxv2i8] }:$rs1, VR:{ *:[nxv2i8] }:$rs2)  =>  (PseudoVAND_VV_MF4:{ *:[nxv2i8] } VR:{ *:[nxv2i8] }:$rs1, VR:{ *:[nxv2i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVAND_VV_MF4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 56393,
        GIR_Done,
      // Label 802: @15430
      GIM_Try, /*On fail goto*//*Label 803*/ 15460, // Rule ID 56394 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (and:{ *:[nxv2i8] } VR:{ *:[nxv2i8] }:$rs1, VR:{ *:[nxv2i8] }:$rs2)  =>  (PseudoVAND_VV_MF4:{ *:[nxv2i8] } VR:{ *:[nxv2i8] }:$rs1, VR:{ *:[nxv2i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVAND_VV_MF4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 56394,
        GIR_Done,
      // Label 803: @15460
      GIM_Reject,
    // Label 801: @15461
    GIM_Reject,
    // Label 740: @15462
    GIM_Try, /*On fail goto*//*Label 804*/ 15545,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv2s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv2s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 805*/ 15514, // Rule ID 56405 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (and:{ *:[nxv2i16] } VR:{ *:[nxv2i16] }:$rs1, VR:{ *:[nxv2i16] }:$rs2)  =>  (PseudoVAND_VV_MF2:{ *:[nxv2i16] } VR:{ *:[nxv2i16] }:$rs1, VR:{ *:[nxv2i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVAND_VV_MF2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 56405,
        GIR_Done,
      // Label 805: @15514
      GIM_Try, /*On fail goto*//*Label 806*/ 15544, // Rule ID 56406 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (and:{ *:[nxv2i16] } VR:{ *:[nxv2i16] }:$rs1, VR:{ *:[nxv2i16] }:$rs2)  =>  (PseudoVAND_VV_MF2:{ *:[nxv2i16] } VR:{ *:[nxv2i16] }:$rs1, VR:{ *:[nxv2i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVAND_VV_MF2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 56406,
        GIR_Done,
      // Label 806: @15544
      GIM_Reject,
    // Label 804: @15545
    GIM_Reject,
    // Label 741: @15546
    GIM_Try, /*On fail goto*//*Label 807*/ 15629,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv2s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv2s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 808*/ 15598, // Rule ID 56421 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (and:{ *:[nxv2i32] } VR:{ *:[nxv2i32] }:$rs1, VR:{ *:[nxv2i32] }:$rs2)  =>  (PseudoVAND_VV_M1:{ *:[nxv2i32] } VR:{ *:[nxv2i32] }:$rs1, VR:{ *:[nxv2i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVAND_VV_M1,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 56421,
        GIR_Done,
      // Label 808: @15598
      GIM_Try, /*On fail goto*//*Label 809*/ 15628, // Rule ID 56422 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (and:{ *:[nxv2i32] } VR:{ *:[nxv2i32] }:$rs1, VR:{ *:[nxv2i32] }:$rs2)  =>  (PseudoVAND_VV_M1:{ *:[nxv2i32] } VR:{ *:[nxv2i32] }:$rs1, VR:{ *:[nxv2i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVAND_VV_M1,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 56422,
        GIR_Done,
      // Label 809: @15628
      GIM_Reject,
    // Label 807: @15629
    GIM_Reject,
    // Label 742: @15630
    GIM_Try, /*On fail goto*//*Label 810*/ 15713,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv2s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM2RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM2RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM2RegClassID,
      GIM_Try, /*On fail goto*//*Label 811*/ 15682, // Rule ID 56465 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (and:{ *:[nxv2i64] } VRM2:{ *:[nxv2i64] }:$rs1, VRM2:{ *:[nxv2i64] }:$rs2)  =>  (PseudoVAND_VV_M2:{ *:[nxv2i64] } VRM2:{ *:[nxv2i64] }:$rs1, VRM2:{ *:[nxv2i64] }:$rs2, -1:{ *:[i64] }, 6:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVAND_VV_M2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 56465,
        GIR_Done,
      // Label 811: @15682
      GIM_Try, /*On fail goto*//*Label 812*/ 15712, // Rule ID 56466 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (and:{ *:[nxv2i64] } VRM2:{ *:[nxv2i64] }:$rs1, VRM2:{ *:[nxv2i64] }:$rs2)  =>  (PseudoVAND_VV_M2:{ *:[nxv2i64] } VRM2:{ *:[nxv2i64] }:$rs1, VRM2:{ *:[nxv2i64] }:$rs2, -1:{ *:[i32] }, 6:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVAND_VV_M2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 56466,
        GIR_Done,
      // Label 812: @15712
      GIM_Reject,
    // Label 810: @15713
    GIM_Reject,
    // Label 743: @15714
    GIM_Try, /*On fail goto*//*Label 813*/ 15797,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv4s1,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv4s1,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 814*/ 15766, // Rule ID 61616 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (and:{ *:[nxv4i1] } VR:{ *:[nxv4i1] }:$rs1, VR:{ *:[nxv4i1] }:$rs2)  =>  (PseudoVMAND_MM_MF2:{ *:[nxv4i1] } VR:{ *:[nxv4i1] }:$rs1, VR:{ *:[nxv4i1] }:$rs2, -1:{ *:[i64] }, 0:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMAND_MM_MF2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 61616,
        GIR_Done,
      // Label 814: @15766
      GIM_Try, /*On fail goto*//*Label 815*/ 15796, // Rule ID 61617 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (and:{ *:[nxv4i1] } VR:{ *:[nxv4i1] }:$rs1, VR:{ *:[nxv4i1] }:$rs2)  =>  (PseudoVMAND_MM_MF2:{ *:[nxv4i1] } VR:{ *:[nxv4i1] }:$rs1, VR:{ *:[nxv4i1] }:$rs2, -1:{ *:[i32] }, 0:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMAND_MM_MF2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 61617,
        GIR_Done,
      // Label 815: @15796
      GIM_Reject,
    // Label 813: @15797
    GIM_Reject,
    // Label 744: @15798
    GIM_Try, /*On fail goto*//*Label 816*/ 15881,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv4s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv4s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 817*/ 15850, // Rule ID 56397 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (and:{ *:[nxv4i8] } VR:{ *:[nxv4i8] }:$rs1, VR:{ *:[nxv4i8] }:$rs2)  =>  (PseudoVAND_VV_MF2:{ *:[nxv4i8] } VR:{ *:[nxv4i8] }:$rs1, VR:{ *:[nxv4i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVAND_VV_MF2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 56397,
        GIR_Done,
      // Label 817: @15850
      GIM_Try, /*On fail goto*//*Label 818*/ 15880, // Rule ID 56398 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (and:{ *:[nxv4i8] } VR:{ *:[nxv4i8] }:$rs1, VR:{ *:[nxv4i8] }:$rs2)  =>  (PseudoVAND_VV_MF2:{ *:[nxv4i8] } VR:{ *:[nxv4i8] }:$rs1, VR:{ *:[nxv4i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVAND_VV_MF2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 56398,
        GIR_Done,
      // Label 818: @15880
      GIM_Reject,
    // Label 816: @15881
    GIM_Reject,
    // Label 745: @15882
    GIM_Try, /*On fail goto*//*Label 819*/ 15965,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv4s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv4s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 820*/ 15934, // Rule ID 56417 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (and:{ *:[nxv4i16] } VR:{ *:[nxv4i16] }:$rs1, VR:{ *:[nxv4i16] }:$rs2)  =>  (PseudoVAND_VV_M1:{ *:[nxv4i16] } VR:{ *:[nxv4i16] }:$rs1, VR:{ *:[nxv4i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVAND_VV_M1,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 56417,
        GIR_Done,
      // Label 820: @15934
      GIM_Try, /*On fail goto*//*Label 821*/ 15964, // Rule ID 56418 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (and:{ *:[nxv4i16] } VR:{ *:[nxv4i16] }:$rs1, VR:{ *:[nxv4i16] }:$rs2)  =>  (PseudoVAND_VV_M1:{ *:[nxv4i16] } VR:{ *:[nxv4i16] }:$rs1, VR:{ *:[nxv4i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVAND_VV_M1,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 56418,
        GIR_Done,
      // Label 821: @15964
      GIM_Reject,
    // Label 819: @15965
    GIM_Reject,
    // Label 746: @15966
    GIM_Try, /*On fail goto*//*Label 822*/ 16049,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv4s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM2RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM2RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM2RegClassID,
      GIM_Try, /*On fail goto*//*Label 823*/ 16018, // Rule ID 56453 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (and:{ *:[nxv4i32] } VRM2:{ *:[nxv4i32] }:$rs1, VRM2:{ *:[nxv4i32] }:$rs2)  =>  (PseudoVAND_VV_M2:{ *:[nxv4i32] } VRM2:{ *:[nxv4i32] }:$rs1, VRM2:{ *:[nxv4i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVAND_VV_M2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 56453,
        GIR_Done,
      // Label 823: @16018
      GIM_Try, /*On fail goto*//*Label 824*/ 16048, // Rule ID 56454 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (and:{ *:[nxv4i32] } VRM2:{ *:[nxv4i32] }:$rs1, VRM2:{ *:[nxv4i32] }:$rs2)  =>  (PseudoVAND_VV_M2:{ *:[nxv4i32] } VRM2:{ *:[nxv4i32] }:$rs1, VRM2:{ *:[nxv4i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVAND_VV_M2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 56454,
        GIR_Done,
      // Label 824: @16048
      GIM_Reject,
    // Label 822: @16049
    GIM_Reject,
    // Label 747: @16050
    GIM_Try, /*On fail goto*//*Label 825*/ 16133,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv4s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv4s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM4RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM4RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM4RegClassID,
      GIM_Try, /*On fail goto*//*Label 826*/ 16102, // Rule ID 56469 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (and:{ *:[nxv4i64] } VRM4:{ *:[nxv4i64] }:$rs1, VRM4:{ *:[nxv4i64] }:$rs2)  =>  (PseudoVAND_VV_M4:{ *:[nxv4i64] } VRM4:{ *:[nxv4i64] }:$rs1, VRM4:{ *:[nxv4i64] }:$rs2, -1:{ *:[i64] }, 6:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVAND_VV_M4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 56469,
        GIR_Done,
      // Label 826: @16102
      GIM_Try, /*On fail goto*//*Label 827*/ 16132, // Rule ID 56470 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (and:{ *:[nxv4i64] } VRM4:{ *:[nxv4i64] }:$rs1, VRM4:{ *:[nxv4i64] }:$rs2)  =>  (PseudoVAND_VV_M4:{ *:[nxv4i64] } VRM4:{ *:[nxv4i64] }:$rs1, VRM4:{ *:[nxv4i64] }:$rs2, -1:{ *:[i32] }, 6:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVAND_VV_M4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 56470,
        GIR_Done,
      // Label 827: @16132
      GIM_Reject,
    // Label 825: @16133
    GIM_Reject,
    // Label 748: @16134
    GIM_Try, /*On fail goto*//*Label 828*/ 16217,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv8s1,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv8s1,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 829*/ 16186, // Rule ID 61634 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (and:{ *:[nxv8i1] } VR:{ *:[nxv8i1] }:$rs1, VR:{ *:[nxv8i1] }:$rs2)  =>  (PseudoVMAND_MM_M1:{ *:[nxv8i1] } VR:{ *:[nxv8i1] }:$rs1, VR:{ *:[nxv8i1] }:$rs2, -1:{ *:[i64] }, 0:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMAND_MM_M1,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 61634,
        GIR_Done,
      // Label 829: @16186
      GIM_Try, /*On fail goto*//*Label 830*/ 16216, // Rule ID 61635 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (and:{ *:[nxv8i1] } VR:{ *:[nxv8i1] }:$rs1, VR:{ *:[nxv8i1] }:$rs2)  =>  (PseudoVMAND_MM_M1:{ *:[nxv8i1] } VR:{ *:[nxv8i1] }:$rs1, VR:{ *:[nxv8i1] }:$rs2, -1:{ *:[i32] }, 0:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMAND_MM_M1,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 61635,
        GIR_Done,
      // Label 830: @16216
      GIM_Reject,
    // Label 828: @16217
    GIM_Reject,
    // Label 749: @16218
    GIM_Try, /*On fail goto*//*Label 831*/ 16301,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv8s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv8s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 832*/ 16270, // Rule ID 56413 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (and:{ *:[nxv8i8] } VR:{ *:[nxv8i8] }:$rs1, VR:{ *:[nxv8i8] }:$rs2)  =>  (PseudoVAND_VV_M1:{ *:[nxv8i8] } VR:{ *:[nxv8i8] }:$rs1, VR:{ *:[nxv8i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVAND_VV_M1,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 56413,
        GIR_Done,
      // Label 832: @16270
      GIM_Try, /*On fail goto*//*Label 833*/ 16300, // Rule ID 56414 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (and:{ *:[nxv8i8] } VR:{ *:[nxv8i8] }:$rs1, VR:{ *:[nxv8i8] }:$rs2)  =>  (PseudoVAND_VV_M1:{ *:[nxv8i8] } VR:{ *:[nxv8i8] }:$rs1, VR:{ *:[nxv8i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVAND_VV_M1,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 56414,
        GIR_Done,
      // Label 833: @16300
      GIM_Reject,
    // Label 831: @16301
    GIM_Reject,
    // Label 750: @16302
    GIM_Try, /*On fail goto*//*Label 834*/ 16385,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv8s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM2RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM2RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM2RegClassID,
      GIM_Try, /*On fail goto*//*Label 835*/ 16354, // Rule ID 56441 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (and:{ *:[nxv8i16] } VRM2:{ *:[nxv8i16] }:$rs1, VRM2:{ *:[nxv8i16] }:$rs2)  =>  (PseudoVAND_VV_M2:{ *:[nxv8i16] } VRM2:{ *:[nxv8i16] }:$rs1, VRM2:{ *:[nxv8i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVAND_VV_M2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 56441,
        GIR_Done,
      // Label 835: @16354
      GIM_Try, /*On fail goto*//*Label 836*/ 16384, // Rule ID 56442 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (and:{ *:[nxv8i16] } VRM2:{ *:[nxv8i16] }:$rs1, VRM2:{ *:[nxv8i16] }:$rs2)  =>  (PseudoVAND_VV_M2:{ *:[nxv8i16] } VRM2:{ *:[nxv8i16] }:$rs1, VRM2:{ *:[nxv8i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVAND_VV_M2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 56442,
        GIR_Done,
      // Label 836: @16384
      GIM_Reject,
    // Label 834: @16385
    GIM_Reject,
    // Label 751: @16386
    GIM_Try, /*On fail goto*//*Label 837*/ 16469,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv8s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv8s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM4RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM4RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM4RegClassID,
      GIM_Try, /*On fail goto*//*Label 838*/ 16438, // Rule ID 56457 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (and:{ *:[nxv8i32] } VRM4:{ *:[nxv8i32] }:$rs1, VRM4:{ *:[nxv8i32] }:$rs2)  =>  (PseudoVAND_VV_M4:{ *:[nxv8i32] } VRM4:{ *:[nxv8i32] }:$rs1, VRM4:{ *:[nxv8i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVAND_VV_M4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 56457,
        GIR_Done,
      // Label 838: @16438
      GIM_Try, /*On fail goto*//*Label 839*/ 16468, // Rule ID 56458 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (and:{ *:[nxv8i32] } VRM4:{ *:[nxv8i32] }:$rs1, VRM4:{ *:[nxv8i32] }:$rs2)  =>  (PseudoVAND_VV_M4:{ *:[nxv8i32] } VRM4:{ *:[nxv8i32] }:$rs1, VRM4:{ *:[nxv8i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVAND_VV_M4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 56458,
        GIR_Done,
      // Label 839: @16468
      GIM_Reject,
    // Label 837: @16469
    GIM_Reject,
    // Label 752: @16470
    GIM_Try, /*On fail goto*//*Label 840*/ 16553,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv8s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv8s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM8RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM8RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM8RegClassID,
      GIM_Try, /*On fail goto*//*Label 841*/ 16522, // Rule ID 56473 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (and:{ *:[nxv8i64] } VRM8:{ *:[nxv8i64] }:$rs1, VRM8:{ *:[nxv8i64] }:$rs2)  =>  (PseudoVAND_VV_M8:{ *:[nxv8i64] } VRM8:{ *:[nxv8i64] }:$rs1, VRM8:{ *:[nxv8i64] }:$rs2, -1:{ *:[i64] }, 6:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVAND_VV_M8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 56473,
        GIR_Done,
      // Label 841: @16522
      GIM_Try, /*On fail goto*//*Label 842*/ 16552, // Rule ID 56474 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (and:{ *:[nxv8i64] } VRM8:{ *:[nxv8i64] }:$rs1, VRM8:{ *:[nxv8i64] }:$rs2)  =>  (PseudoVAND_VV_M8:{ *:[nxv8i64] } VRM8:{ *:[nxv8i64] }:$rs1, VRM8:{ *:[nxv8i64] }:$rs2, -1:{ *:[i32] }, 6:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVAND_VV_M8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 56474,
        GIR_Done,
      // Label 842: @16552
      GIM_Reject,
    // Label 840: @16553
    GIM_Reject,
    // Label 753: @16554
    GIM_Try, /*On fail goto*//*Label 843*/ 16637,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv16s1,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv16s1,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 844*/ 16606, // Rule ID 61654 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (and:{ *:[nxv16i1] } VR:{ *:[nxv16i1] }:$rs1, VR:{ *:[nxv16i1] }:$rs2)  =>  (PseudoVMAND_MM_M2:{ *:[nxv16i1] } VR:{ *:[nxv16i1] }:$rs1, VR:{ *:[nxv16i1] }:$rs2, -1:{ *:[i64] }, 0:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMAND_MM_M2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 61654,
        GIR_Done,
      // Label 844: @16606
      GIM_Try, /*On fail goto*//*Label 845*/ 16636, // Rule ID 61655 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (and:{ *:[nxv16i1] } VR:{ *:[nxv16i1] }:$rs1, VR:{ *:[nxv16i1] }:$rs2)  =>  (PseudoVMAND_MM_M2:{ *:[nxv16i1] } VR:{ *:[nxv16i1] }:$rs1, VR:{ *:[nxv16i1] }:$rs2, -1:{ *:[i32] }, 0:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMAND_MM_M2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 61655,
        GIR_Done,
      // Label 845: @16636
      GIM_Reject,
    // Label 843: @16637
    GIM_Reject,
    // Label 754: @16638
    GIM_Try, /*On fail goto*//*Label 846*/ 16721,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv16s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv16s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM2RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM2RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM2RegClassID,
      GIM_Try, /*On fail goto*//*Label 847*/ 16690, // Rule ID 56429 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (and:{ *:[nxv16i8] } VRM2:{ *:[nxv16i8] }:$rs1, VRM2:{ *:[nxv16i8] }:$rs2)  =>  (PseudoVAND_VV_M2:{ *:[nxv16i8] } VRM2:{ *:[nxv16i8] }:$rs1, VRM2:{ *:[nxv16i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVAND_VV_M2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 56429,
        GIR_Done,
      // Label 847: @16690
      GIM_Try, /*On fail goto*//*Label 848*/ 16720, // Rule ID 56430 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (and:{ *:[nxv16i8] } VRM2:{ *:[nxv16i8] }:$rs1, VRM2:{ *:[nxv16i8] }:$rs2)  =>  (PseudoVAND_VV_M2:{ *:[nxv16i8] } VRM2:{ *:[nxv16i8] }:$rs1, VRM2:{ *:[nxv16i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVAND_VV_M2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 56430,
        GIR_Done,
      // Label 848: @16720
      GIM_Reject,
    // Label 846: @16721
    GIM_Reject,
    // Label 755: @16722
    GIM_Try, /*On fail goto*//*Label 849*/ 16805,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv16s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv16s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM4RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM4RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM4RegClassID,
      GIM_Try, /*On fail goto*//*Label 850*/ 16774, // Rule ID 56445 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (and:{ *:[nxv16i16] } VRM4:{ *:[nxv16i16] }:$rs1, VRM4:{ *:[nxv16i16] }:$rs2)  =>  (PseudoVAND_VV_M4:{ *:[nxv16i16] } VRM4:{ *:[nxv16i16] }:$rs1, VRM4:{ *:[nxv16i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVAND_VV_M4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 56445,
        GIR_Done,
      // Label 850: @16774
      GIM_Try, /*On fail goto*//*Label 851*/ 16804, // Rule ID 56446 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (and:{ *:[nxv16i16] } VRM4:{ *:[nxv16i16] }:$rs1, VRM4:{ *:[nxv16i16] }:$rs2)  =>  (PseudoVAND_VV_M4:{ *:[nxv16i16] } VRM4:{ *:[nxv16i16] }:$rs1, VRM4:{ *:[nxv16i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVAND_VV_M4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 56446,
        GIR_Done,
      // Label 851: @16804
      GIM_Reject,
    // Label 849: @16805
    GIM_Reject,
    // Label 756: @16806
    GIM_Try, /*On fail goto*//*Label 852*/ 16889,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv16s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv16s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM8RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM8RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM8RegClassID,
      GIM_Try, /*On fail goto*//*Label 853*/ 16858, // Rule ID 56461 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (and:{ *:[nxv16i32] } VRM8:{ *:[nxv16i32] }:$rs1, VRM8:{ *:[nxv16i32] }:$rs2)  =>  (PseudoVAND_VV_M8:{ *:[nxv16i32] } VRM8:{ *:[nxv16i32] }:$rs1, VRM8:{ *:[nxv16i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVAND_VV_M8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 56461,
        GIR_Done,
      // Label 853: @16858
      GIM_Try, /*On fail goto*//*Label 854*/ 16888, // Rule ID 56462 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (and:{ *:[nxv16i32] } VRM8:{ *:[nxv16i32] }:$rs1, VRM8:{ *:[nxv16i32] }:$rs2)  =>  (PseudoVAND_VV_M8:{ *:[nxv16i32] } VRM8:{ *:[nxv16i32] }:$rs1, VRM8:{ *:[nxv16i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVAND_VV_M8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 56462,
        GIR_Done,
      // Label 854: @16888
      GIM_Reject,
    // Label 852: @16889
    GIM_Reject,
    // Label 757: @16890
    GIM_Try, /*On fail goto*//*Label 855*/ 16973,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv32s1,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv32s1,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 856*/ 16942, // Rule ID 61672 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (and:{ *:[nxv32i1] } VR:{ *:[nxv32i1] }:$rs1, VR:{ *:[nxv32i1] }:$rs2)  =>  (PseudoVMAND_MM_M4:{ *:[nxv32i1] } VR:{ *:[nxv32i1] }:$rs1, VR:{ *:[nxv32i1] }:$rs2, -1:{ *:[i64] }, 0:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMAND_MM_M4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 61672,
        GIR_Done,
      // Label 856: @16942
      GIM_Try, /*On fail goto*//*Label 857*/ 16972, // Rule ID 61673 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (and:{ *:[nxv32i1] } VR:{ *:[nxv32i1] }:$rs1, VR:{ *:[nxv32i1] }:$rs2)  =>  (PseudoVMAND_MM_M4:{ *:[nxv32i1] } VR:{ *:[nxv32i1] }:$rs1, VR:{ *:[nxv32i1] }:$rs2, -1:{ *:[i32] }, 0:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMAND_MM_M4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 61673,
        GIR_Done,
      // Label 857: @16972
      GIM_Reject,
    // Label 855: @16973
    GIM_Reject,
    // Label 758: @16974
    GIM_Try, /*On fail goto*//*Label 858*/ 17057,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv32s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv32s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM4RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM4RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM4RegClassID,
      GIM_Try, /*On fail goto*//*Label 859*/ 17026, // Rule ID 56433 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (and:{ *:[nxv32i8] } VRM4:{ *:[nxv32i8] }:$rs1, VRM4:{ *:[nxv32i8] }:$rs2)  =>  (PseudoVAND_VV_M4:{ *:[nxv32i8] } VRM4:{ *:[nxv32i8] }:$rs1, VRM4:{ *:[nxv32i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVAND_VV_M4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 56433,
        GIR_Done,
      // Label 859: @17026
      GIM_Try, /*On fail goto*//*Label 860*/ 17056, // Rule ID 56434 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (and:{ *:[nxv32i8] } VRM4:{ *:[nxv32i8] }:$rs1, VRM4:{ *:[nxv32i8] }:$rs2)  =>  (PseudoVAND_VV_M4:{ *:[nxv32i8] } VRM4:{ *:[nxv32i8] }:$rs1, VRM4:{ *:[nxv32i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVAND_VV_M4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 56434,
        GIR_Done,
      // Label 860: @17056
      GIM_Reject,
    // Label 858: @17057
    GIM_Reject,
    // Label 759: @17058
    GIM_Try, /*On fail goto*//*Label 861*/ 17141,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv32s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv32s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM8RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM8RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM8RegClassID,
      GIM_Try, /*On fail goto*//*Label 862*/ 17110, // Rule ID 56449 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (and:{ *:[nxv32i16] } VRM8:{ *:[nxv32i16] }:$rs1, VRM8:{ *:[nxv32i16] }:$rs2)  =>  (PseudoVAND_VV_M8:{ *:[nxv32i16] } VRM8:{ *:[nxv32i16] }:$rs1, VRM8:{ *:[nxv32i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVAND_VV_M8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 56449,
        GIR_Done,
      // Label 862: @17110
      GIM_Try, /*On fail goto*//*Label 863*/ 17140, // Rule ID 56450 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (and:{ *:[nxv32i16] } VRM8:{ *:[nxv32i16] }:$rs1, VRM8:{ *:[nxv32i16] }:$rs2)  =>  (PseudoVAND_VV_M8:{ *:[nxv32i16] } VRM8:{ *:[nxv32i16] }:$rs1, VRM8:{ *:[nxv32i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVAND_VV_M8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 56450,
        GIR_Done,
      // Label 863: @17140
      GIM_Reject,
    // Label 861: @17141
    GIM_Reject,
    // Label 760: @17142
    GIM_Try, /*On fail goto*//*Label 864*/ 17225,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv64s1,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv64s1,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 865*/ 17194, // Rule ID 61690 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (and:{ *:[nxv64i1] } VR:{ *:[nxv64i1] }:$rs1, VR:{ *:[nxv64i1] }:$rs2)  =>  (PseudoVMAND_MM_M8:{ *:[nxv64i1] } VR:{ *:[nxv64i1] }:$rs1, VR:{ *:[nxv64i1] }:$rs2, -1:{ *:[i64] }, 0:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMAND_MM_M8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 61690,
        GIR_Done,
      // Label 865: @17194
      GIM_Try, /*On fail goto*//*Label 866*/ 17224, // Rule ID 61691 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (and:{ *:[nxv64i1] } VR:{ *:[nxv64i1] }:$rs1, VR:{ *:[nxv64i1] }:$rs2)  =>  (PseudoVMAND_MM_M8:{ *:[nxv64i1] } VR:{ *:[nxv64i1] }:$rs1, VR:{ *:[nxv64i1] }:$rs2, -1:{ *:[i32] }, 0:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMAND_MM_M8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 61691,
        GIR_Done,
      // Label 866: @17224
      GIM_Reject,
    // Label 864: @17225
    GIM_Reject,
    // Label 761: @17226
    GIM_Try, /*On fail goto*//*Label 867*/ 17309,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv64s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv64s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM8RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM8RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM8RegClassID,
      GIM_Try, /*On fail goto*//*Label 868*/ 17278, // Rule ID 56437 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (and:{ *:[nxv64i8] } VRM8:{ *:[nxv64i8] }:$rs1, VRM8:{ *:[nxv64i8] }:$rs2)  =>  (PseudoVAND_VV_M8:{ *:[nxv64i8] } VRM8:{ *:[nxv64i8] }:$rs1, VRM8:{ *:[nxv64i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVAND_VV_M8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 56437,
        GIR_Done,
      // Label 868: @17278
      GIM_Try, /*On fail goto*//*Label 869*/ 17308, // Rule ID 56438 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (and:{ *:[nxv64i8] } VRM8:{ *:[nxv64i8] }:$rs1, VRM8:{ *:[nxv64i8] }:$rs2)  =>  (PseudoVAND_VV_M8:{ *:[nxv64i8] } VRM8:{ *:[nxv64i8] }:$rs1, VRM8:{ *:[nxv64i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVAND_VV_M8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 56438,
        GIR_Done,
      // Label 869: @17308
      GIM_Reject,
    // Label 867: @17309
    GIM_Reject,
    // Label 762: @17310
    GIM_Reject,
    // Label 8: @17311
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/1, 32, /*)*//*default:*//*Label 901*/ 20136,
    /*GILLT_s32*//*Label 870*/ 17348,
    /*GILLT_s64*//*Label 871*/ 17524,
    /*GILLT_nxv1s1*//*Label 872*/ 17700,
    /*GILLT_nxv1s8*//*Label 873*/ 17784,
    /*GILLT_nxv1s16*//*Label 874*/ 17868,
    /*GILLT_nxv1s32*//*Label 875*/ 17952,
    /*GILLT_nxv1s64*//*Label 876*/ 18036,
    /*GILLT_nxv2s1*//*Label 877*/ 18120,
    /*GILLT_nxv2s8*//*Label 878*/ 18204,
    /*GILLT_nxv2s16*//*Label 879*/ 18288,
    /*GILLT_nxv2s32*//*Label 880*/ 18372,
    /*GILLT_nxv2s64*//*Label 881*/ 18456,
    /*GILLT_nxv4s1*//*Label 882*/ 18540,
    /*GILLT_nxv4s8*//*Label 883*/ 18624,
    /*GILLT_nxv4s16*//*Label 884*/ 18708,
    /*GILLT_nxv4s32*//*Label 885*/ 18792,
    /*GILLT_nxv4s64*//*Label 886*/ 18876,
    /*GILLT_nxv8s1*//*Label 887*/ 18960,
    /*GILLT_nxv8s8*//*Label 888*/ 19044,
    /*GILLT_nxv8s16*//*Label 889*/ 19128,
    /*GILLT_nxv8s32*//*Label 890*/ 19212,
    /*GILLT_nxv8s64*//*Label 891*/ 19296,
    /*GILLT_nxv16s1*//*Label 892*/ 19380,
    /*GILLT_nxv16s8*//*Label 893*/ 19464,
    /*GILLT_nxv16s16*//*Label 894*/ 19548,
    /*GILLT_nxv16s32*//*Label 895*/ 19632,
    /*GILLT_nxv32s1*//*Label 896*/ 19716,
    /*GILLT_nxv32s8*//*Label 897*/ 19800,
    /*GILLT_nxv32s16*//*Label 898*/ 19884,
    /*GILLT_nxv64s1*//*Label 899*/ 19968,
    /*GILLT_nxv64s8*//*Label 900*/ 20052,
    // Label 870: @17348
    GIM_Try, /*On fail goto*//*Label 902*/ 17523,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
      GIM_Try, /*On fail goto*//*Label 903*/ 17415, // Rule ID 72087 //
        GIM_CheckFeatures, GIFBS_HasStdExtZbbOrZbkb,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, -1,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (or:{ *:[i32] } (xor:{ *:[i32] } GPR:{ *:[i32] }:$rs2, -1:{ *:[i32] }), GPR:{ *:[i32] }:$rs1)  =>  (ORN:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::ORN,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs2
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 72087,
        GIR_Done,
      // Label 903: @17415
      GIM_Try, /*On fail goto*//*Label 904*/ 17468, // Rule ID 65436 //
        GIM_CheckFeatures, GIFBS_HasStdExtZbbOrZbkb,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, -1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (or:{ *:[i32] } GPR:{ *:[i32] }:$rs1, (xor:{ *:[i32] } GPR:{ *:[i32] }:$rs2, -1:{ *:[i32] }))  =>  (ORN:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::ORN,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs2
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 65436,
        GIR_Done,
      // Label 904: @17468
      GIM_Try, /*On fail goto*//*Label 905*/ 17505, // Rule ID 59894 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIPFP_I64_Predicate_simm12,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (or:{ *:[i32] } GPR:{ *:[i32] }:$rs1, (imm:{ *:[i32] })<<P:Predicate_simm12>>:$imm)  =>  (ORI:{ *:[i32] } GPR:{ *:[i32] }:$rs1, (imm:{ *:[i32] })<<P:Predicate_simm12>>:$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::ORI,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // imm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 59894,
        GIR_Done,
      // Label 905: @17505
      GIM_Try, /*On fail goto*//*Label 906*/ 17522, // Rule ID 59872 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (or:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)  =>  (OR:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::OR,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 59872,
        GIR_Done,
      // Label 906: @17522
      GIM_Reject,
    // Label 902: @17523
    GIM_Reject,
    // Label 871: @17524
    GIM_Try, /*On fail goto*//*Label 907*/ 17699,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
      GIM_Try, /*On fail goto*//*Label 908*/ 17591, // Rule ID 72086 //
        GIM_CheckFeatures, GIFBS_HasStdExtZbbOrZbkb,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, -1,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (or:{ *:[i64] } (xor:{ *:[i64] } GPR:{ *:[i64] }:$rs2, -1:{ *:[i64] }), GPR:{ *:[i64] }:$rs1)  =>  (ORN:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::ORN,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs2
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 72086,
        GIR_Done,
      // Label 908: @17591
      GIM_Try, /*On fail goto*//*Label 909*/ 17644, // Rule ID 65435 //
        GIM_CheckFeatures, GIFBS_HasStdExtZbbOrZbkb,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, -1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (or:{ *:[i64] } GPR:{ *:[i64] }:$rs1, (xor:{ *:[i64] } GPR:{ *:[i64] }:$rs2, -1:{ *:[i64] }))  =>  (ORN:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::ORN,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs2
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 65435,
        GIR_Done,
      // Label 909: @17644
      GIM_Try, /*On fail goto*//*Label 910*/ 17681, // Rule ID 59893 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIPFP_I64_Predicate_simm12,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (or:{ *:[i64] } GPR:{ *:[i64] }:$rs1, (imm:{ *:[i64] })<<P:Predicate_simm12>>:$imm)  =>  (ORI:{ *:[i64] } GPR:{ *:[i64] }:$rs1, (imm:{ *:[i64] })<<P:Predicate_simm12>>:$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::ORI,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // imm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 59893,
        GIR_Done,
      // Label 910: @17681
      GIM_Try, /*On fail goto*//*Label 911*/ 17698, // Rule ID 59871 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (or:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)  =>  (OR:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::OR,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 59871,
        GIR_Done,
      // Label 911: @17698
      GIM_Reject,
    // Label 907: @17699
    GIM_Reject,
    // Label 872: @17700
    GIM_Try, /*On fail goto*//*Label 912*/ 17783,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv1s1,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv1s1,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 913*/ 17752, // Rule ID 61578 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (or:{ *:[nxv1i1] } VR:{ *:[nxv1i1] }:$rs1, VR:{ *:[nxv1i1] }:$rs2)  =>  (PseudoVMOR_MM_MF8:{ *:[nxv1i1] } VR:{ *:[nxv1i1] }:$rs1, VR:{ *:[nxv1i1] }:$rs2, -1:{ *:[i64] }, 0:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMOR_MM_MF8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 61578,
        GIR_Done,
      // Label 913: @17752
      GIM_Try, /*On fail goto*//*Label 914*/ 17782, // Rule ID 61579 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (or:{ *:[nxv1i1] } VR:{ *:[nxv1i1] }:$rs1, VR:{ *:[nxv1i1] }:$rs2)  =>  (PseudoVMOR_MM_MF8:{ *:[nxv1i1] } VR:{ *:[nxv1i1] }:$rs1, VR:{ *:[nxv1i1] }:$rs2, -1:{ *:[i32] }, 0:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMOR_MM_MF8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 61579,
        GIR_Done,
      // Label 914: @17782
      GIM_Reject,
    // Label 912: @17783
    GIM_Reject,
    // Label 873: @17784
    GIM_Try, /*On fail goto*//*Label 915*/ 17867,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv1s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv1s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 916*/ 17836, // Rule ID 56521 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (or:{ *:[nxv1i8] } VR:{ *:[nxv1i8] }:$rs1, VR:{ *:[nxv1i8] }:$rs2)  =>  (PseudoVOR_VV_MF8:{ *:[nxv1i8] } VR:{ *:[nxv1i8] }:$rs1, VR:{ *:[nxv1i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVOR_VV_MF8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 56521,
        GIR_Done,
      // Label 916: @17836
      GIM_Try, /*On fail goto*//*Label 917*/ 17866, // Rule ID 56522 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (or:{ *:[nxv1i8] } VR:{ *:[nxv1i8] }:$rs1, VR:{ *:[nxv1i8] }:$rs2)  =>  (PseudoVOR_VV_MF8:{ *:[nxv1i8] } VR:{ *:[nxv1i8] }:$rs1, VR:{ *:[nxv1i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVOR_VV_MF8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 56522,
        GIR_Done,
      // Label 917: @17866
      GIM_Reject,
    // Label 915: @17867
    GIM_Reject,
    // Label 874: @17868
    GIM_Try, /*On fail goto*//*Label 918*/ 17951,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv1s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv1s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 919*/ 17920, // Rule ID 56533 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (or:{ *:[nxv1i16] } VR:{ *:[nxv1i16] }:$rs1, VR:{ *:[nxv1i16] }:$rs2)  =>  (PseudoVOR_VV_MF4:{ *:[nxv1i16] } VR:{ *:[nxv1i16] }:$rs1, VR:{ *:[nxv1i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVOR_VV_MF4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 56533,
        GIR_Done,
      // Label 919: @17920
      GIM_Try, /*On fail goto*//*Label 920*/ 17950, // Rule ID 56534 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (or:{ *:[nxv1i16] } VR:{ *:[nxv1i16] }:$rs1, VR:{ *:[nxv1i16] }:$rs2)  =>  (PseudoVOR_VV_MF4:{ *:[nxv1i16] } VR:{ *:[nxv1i16] }:$rs1, VR:{ *:[nxv1i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVOR_VV_MF4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 56534,
        GIR_Done,
      // Label 920: @17950
      GIM_Reject,
    // Label 918: @17951
    GIM_Reject,
    // Label 875: @17952
    GIM_Try, /*On fail goto*//*Label 921*/ 18035,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv1s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv1s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 922*/ 18004, // Rule ID 56541 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (or:{ *:[nxv1i32] } VR:{ *:[nxv1i32] }:$rs1, VR:{ *:[nxv1i32] }:$rs2)  =>  (PseudoVOR_VV_MF2:{ *:[nxv1i32] } VR:{ *:[nxv1i32] }:$rs1, VR:{ *:[nxv1i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVOR_VV_MF2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 56541,
        GIR_Done,
      // Label 922: @18004
      GIM_Try, /*On fail goto*//*Label 923*/ 18034, // Rule ID 56542 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (or:{ *:[nxv1i32] } VR:{ *:[nxv1i32] }:$rs1, VR:{ *:[nxv1i32] }:$rs2)  =>  (PseudoVOR_VV_MF2:{ *:[nxv1i32] } VR:{ *:[nxv1i32] }:$rs1, VR:{ *:[nxv1i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVOR_VV_MF2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 56542,
        GIR_Done,
      // Label 923: @18034
      GIM_Reject,
    // Label 921: @18035
    GIM_Reject,
    // Label 876: @18036
    GIM_Try, /*On fail goto*//*Label 924*/ 18119,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv1s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv1s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 925*/ 18088, // Rule ID 56557 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (or:{ *:[nxv1i64] } VR:{ *:[nxv1i64] }:$rs1, VR:{ *:[nxv1i64] }:$rs2)  =>  (PseudoVOR_VV_M1:{ *:[nxv1i64] } VR:{ *:[nxv1i64] }:$rs1, VR:{ *:[nxv1i64] }:$rs2, -1:{ *:[i64] }, 6:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVOR_VV_M1,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 56557,
        GIR_Done,
      // Label 925: @18088
      GIM_Try, /*On fail goto*//*Label 926*/ 18118, // Rule ID 56558 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (or:{ *:[nxv1i64] } VR:{ *:[nxv1i64] }:$rs1, VR:{ *:[nxv1i64] }:$rs2)  =>  (PseudoVOR_VV_M1:{ *:[nxv1i64] } VR:{ *:[nxv1i64] }:$rs1, VR:{ *:[nxv1i64] }:$rs2, -1:{ *:[i32] }, 6:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVOR_VV_M1,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 56558,
        GIR_Done,
      // Label 926: @18118
      GIM_Reject,
    // Label 924: @18119
    GIM_Reject,
    // Label 877: @18120
    GIM_Try, /*On fail goto*//*Label 927*/ 18203,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv2s1,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv2s1,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 928*/ 18172, // Rule ID 61598 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (or:{ *:[nxv2i1] } VR:{ *:[nxv2i1] }:$rs1, VR:{ *:[nxv2i1] }:$rs2)  =>  (PseudoVMOR_MM_MF4:{ *:[nxv2i1] } VR:{ *:[nxv2i1] }:$rs1, VR:{ *:[nxv2i1] }:$rs2, -1:{ *:[i64] }, 0:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMOR_MM_MF4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 61598,
        GIR_Done,
      // Label 928: @18172
      GIM_Try, /*On fail goto*//*Label 929*/ 18202, // Rule ID 61599 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (or:{ *:[nxv2i1] } VR:{ *:[nxv2i1] }:$rs1, VR:{ *:[nxv2i1] }:$rs2)  =>  (PseudoVMOR_MM_MF4:{ *:[nxv2i1] } VR:{ *:[nxv2i1] }:$rs1, VR:{ *:[nxv2i1] }:$rs2, -1:{ *:[i32] }, 0:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMOR_MM_MF4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 61599,
        GIR_Done,
      // Label 929: @18202
      GIM_Reject,
    // Label 927: @18203
    GIM_Reject,
    // Label 878: @18204
    GIM_Try, /*On fail goto*//*Label 930*/ 18287,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv2s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv2s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 931*/ 18256, // Rule ID 56525 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (or:{ *:[nxv2i8] } VR:{ *:[nxv2i8] }:$rs1, VR:{ *:[nxv2i8] }:$rs2)  =>  (PseudoVOR_VV_MF4:{ *:[nxv2i8] } VR:{ *:[nxv2i8] }:$rs1, VR:{ *:[nxv2i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVOR_VV_MF4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 56525,
        GIR_Done,
      // Label 931: @18256
      GIM_Try, /*On fail goto*//*Label 932*/ 18286, // Rule ID 56526 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (or:{ *:[nxv2i8] } VR:{ *:[nxv2i8] }:$rs1, VR:{ *:[nxv2i8] }:$rs2)  =>  (PseudoVOR_VV_MF4:{ *:[nxv2i8] } VR:{ *:[nxv2i8] }:$rs1, VR:{ *:[nxv2i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVOR_VV_MF4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 56526,
        GIR_Done,
      // Label 932: @18286
      GIM_Reject,
    // Label 930: @18287
    GIM_Reject,
    // Label 879: @18288
    GIM_Try, /*On fail goto*//*Label 933*/ 18371,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv2s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv2s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 934*/ 18340, // Rule ID 56537 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (or:{ *:[nxv2i16] } VR:{ *:[nxv2i16] }:$rs1, VR:{ *:[nxv2i16] }:$rs2)  =>  (PseudoVOR_VV_MF2:{ *:[nxv2i16] } VR:{ *:[nxv2i16] }:$rs1, VR:{ *:[nxv2i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVOR_VV_MF2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 56537,
        GIR_Done,
      // Label 934: @18340
      GIM_Try, /*On fail goto*//*Label 935*/ 18370, // Rule ID 56538 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (or:{ *:[nxv2i16] } VR:{ *:[nxv2i16] }:$rs1, VR:{ *:[nxv2i16] }:$rs2)  =>  (PseudoVOR_VV_MF2:{ *:[nxv2i16] } VR:{ *:[nxv2i16] }:$rs1, VR:{ *:[nxv2i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVOR_VV_MF2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 56538,
        GIR_Done,
      // Label 935: @18370
      GIM_Reject,
    // Label 933: @18371
    GIM_Reject,
    // Label 880: @18372
    GIM_Try, /*On fail goto*//*Label 936*/ 18455,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv2s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv2s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 937*/ 18424, // Rule ID 56553 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (or:{ *:[nxv2i32] } VR:{ *:[nxv2i32] }:$rs1, VR:{ *:[nxv2i32] }:$rs2)  =>  (PseudoVOR_VV_M1:{ *:[nxv2i32] } VR:{ *:[nxv2i32] }:$rs1, VR:{ *:[nxv2i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVOR_VV_M1,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 56553,
        GIR_Done,
      // Label 937: @18424
      GIM_Try, /*On fail goto*//*Label 938*/ 18454, // Rule ID 56554 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (or:{ *:[nxv2i32] } VR:{ *:[nxv2i32] }:$rs1, VR:{ *:[nxv2i32] }:$rs2)  =>  (PseudoVOR_VV_M1:{ *:[nxv2i32] } VR:{ *:[nxv2i32] }:$rs1, VR:{ *:[nxv2i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVOR_VV_M1,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 56554,
        GIR_Done,
      // Label 938: @18454
      GIM_Reject,
    // Label 936: @18455
    GIM_Reject,
    // Label 881: @18456
    GIM_Try, /*On fail goto*//*Label 939*/ 18539,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv2s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM2RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM2RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM2RegClassID,
      GIM_Try, /*On fail goto*//*Label 940*/ 18508, // Rule ID 56597 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (or:{ *:[nxv2i64] } VRM2:{ *:[nxv2i64] }:$rs1, VRM2:{ *:[nxv2i64] }:$rs2)  =>  (PseudoVOR_VV_M2:{ *:[nxv2i64] } VRM2:{ *:[nxv2i64] }:$rs1, VRM2:{ *:[nxv2i64] }:$rs2, -1:{ *:[i64] }, 6:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVOR_VV_M2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 56597,
        GIR_Done,
      // Label 940: @18508
      GIM_Try, /*On fail goto*//*Label 941*/ 18538, // Rule ID 56598 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (or:{ *:[nxv2i64] } VRM2:{ *:[nxv2i64] }:$rs1, VRM2:{ *:[nxv2i64] }:$rs2)  =>  (PseudoVOR_VV_M2:{ *:[nxv2i64] } VRM2:{ *:[nxv2i64] }:$rs1, VRM2:{ *:[nxv2i64] }:$rs2, -1:{ *:[i32] }, 6:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVOR_VV_M2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 56598,
        GIR_Done,
      // Label 941: @18538
      GIM_Reject,
    // Label 939: @18539
    GIM_Reject,
    // Label 882: @18540
    GIM_Try, /*On fail goto*//*Label 942*/ 18623,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv4s1,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv4s1,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 943*/ 18592, // Rule ID 61618 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (or:{ *:[nxv4i1] } VR:{ *:[nxv4i1] }:$rs1, VR:{ *:[nxv4i1] }:$rs2)  =>  (PseudoVMOR_MM_MF2:{ *:[nxv4i1] } VR:{ *:[nxv4i1] }:$rs1, VR:{ *:[nxv4i1] }:$rs2, -1:{ *:[i64] }, 0:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMOR_MM_MF2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 61618,
        GIR_Done,
      // Label 943: @18592
      GIM_Try, /*On fail goto*//*Label 944*/ 18622, // Rule ID 61619 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (or:{ *:[nxv4i1] } VR:{ *:[nxv4i1] }:$rs1, VR:{ *:[nxv4i1] }:$rs2)  =>  (PseudoVMOR_MM_MF2:{ *:[nxv4i1] } VR:{ *:[nxv4i1] }:$rs1, VR:{ *:[nxv4i1] }:$rs2, -1:{ *:[i32] }, 0:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMOR_MM_MF2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 61619,
        GIR_Done,
      // Label 944: @18622
      GIM_Reject,
    // Label 942: @18623
    GIM_Reject,
    // Label 883: @18624
    GIM_Try, /*On fail goto*//*Label 945*/ 18707,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv4s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv4s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 946*/ 18676, // Rule ID 56529 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (or:{ *:[nxv4i8] } VR:{ *:[nxv4i8] }:$rs1, VR:{ *:[nxv4i8] }:$rs2)  =>  (PseudoVOR_VV_MF2:{ *:[nxv4i8] } VR:{ *:[nxv4i8] }:$rs1, VR:{ *:[nxv4i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVOR_VV_MF2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 56529,
        GIR_Done,
      // Label 946: @18676
      GIM_Try, /*On fail goto*//*Label 947*/ 18706, // Rule ID 56530 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (or:{ *:[nxv4i8] } VR:{ *:[nxv4i8] }:$rs1, VR:{ *:[nxv4i8] }:$rs2)  =>  (PseudoVOR_VV_MF2:{ *:[nxv4i8] } VR:{ *:[nxv4i8] }:$rs1, VR:{ *:[nxv4i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVOR_VV_MF2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 56530,
        GIR_Done,
      // Label 947: @18706
      GIM_Reject,
    // Label 945: @18707
    GIM_Reject,
    // Label 884: @18708
    GIM_Try, /*On fail goto*//*Label 948*/ 18791,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv4s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv4s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 949*/ 18760, // Rule ID 56549 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (or:{ *:[nxv4i16] } VR:{ *:[nxv4i16] }:$rs1, VR:{ *:[nxv4i16] }:$rs2)  =>  (PseudoVOR_VV_M1:{ *:[nxv4i16] } VR:{ *:[nxv4i16] }:$rs1, VR:{ *:[nxv4i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVOR_VV_M1,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 56549,
        GIR_Done,
      // Label 949: @18760
      GIM_Try, /*On fail goto*//*Label 950*/ 18790, // Rule ID 56550 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (or:{ *:[nxv4i16] } VR:{ *:[nxv4i16] }:$rs1, VR:{ *:[nxv4i16] }:$rs2)  =>  (PseudoVOR_VV_M1:{ *:[nxv4i16] } VR:{ *:[nxv4i16] }:$rs1, VR:{ *:[nxv4i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVOR_VV_M1,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 56550,
        GIR_Done,
      // Label 950: @18790
      GIM_Reject,
    // Label 948: @18791
    GIM_Reject,
    // Label 885: @18792
    GIM_Try, /*On fail goto*//*Label 951*/ 18875,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv4s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM2RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM2RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM2RegClassID,
      GIM_Try, /*On fail goto*//*Label 952*/ 18844, // Rule ID 56585 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (or:{ *:[nxv4i32] } VRM2:{ *:[nxv4i32] }:$rs1, VRM2:{ *:[nxv4i32] }:$rs2)  =>  (PseudoVOR_VV_M2:{ *:[nxv4i32] } VRM2:{ *:[nxv4i32] }:$rs1, VRM2:{ *:[nxv4i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVOR_VV_M2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 56585,
        GIR_Done,
      // Label 952: @18844
      GIM_Try, /*On fail goto*//*Label 953*/ 18874, // Rule ID 56586 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (or:{ *:[nxv4i32] } VRM2:{ *:[nxv4i32] }:$rs1, VRM2:{ *:[nxv4i32] }:$rs2)  =>  (PseudoVOR_VV_M2:{ *:[nxv4i32] } VRM2:{ *:[nxv4i32] }:$rs1, VRM2:{ *:[nxv4i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVOR_VV_M2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 56586,
        GIR_Done,
      // Label 953: @18874
      GIM_Reject,
    // Label 951: @18875
    GIM_Reject,
    // Label 886: @18876
    GIM_Try, /*On fail goto*//*Label 954*/ 18959,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv4s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv4s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM4RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM4RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM4RegClassID,
      GIM_Try, /*On fail goto*//*Label 955*/ 18928, // Rule ID 56601 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (or:{ *:[nxv4i64] } VRM4:{ *:[nxv4i64] }:$rs1, VRM4:{ *:[nxv4i64] }:$rs2)  =>  (PseudoVOR_VV_M4:{ *:[nxv4i64] } VRM4:{ *:[nxv4i64] }:$rs1, VRM4:{ *:[nxv4i64] }:$rs2, -1:{ *:[i64] }, 6:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVOR_VV_M4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 56601,
        GIR_Done,
      // Label 955: @18928
      GIM_Try, /*On fail goto*//*Label 956*/ 18958, // Rule ID 56602 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (or:{ *:[nxv4i64] } VRM4:{ *:[nxv4i64] }:$rs1, VRM4:{ *:[nxv4i64] }:$rs2)  =>  (PseudoVOR_VV_M4:{ *:[nxv4i64] } VRM4:{ *:[nxv4i64] }:$rs1, VRM4:{ *:[nxv4i64] }:$rs2, -1:{ *:[i32] }, 6:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVOR_VV_M4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 56602,
        GIR_Done,
      // Label 956: @18958
      GIM_Reject,
    // Label 954: @18959
    GIM_Reject,
    // Label 887: @18960
    GIM_Try, /*On fail goto*//*Label 957*/ 19043,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv8s1,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv8s1,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 958*/ 19012, // Rule ID 61638 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (or:{ *:[nxv8i1] } VR:{ *:[nxv8i1] }:$rs1, VR:{ *:[nxv8i1] }:$rs2)  =>  (PseudoVMOR_MM_M1:{ *:[nxv8i1] } VR:{ *:[nxv8i1] }:$rs1, VR:{ *:[nxv8i1] }:$rs2, -1:{ *:[i64] }, 0:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMOR_MM_M1,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 61638,
        GIR_Done,
      // Label 958: @19012
      GIM_Try, /*On fail goto*//*Label 959*/ 19042, // Rule ID 61639 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (or:{ *:[nxv8i1] } VR:{ *:[nxv8i1] }:$rs1, VR:{ *:[nxv8i1] }:$rs2)  =>  (PseudoVMOR_MM_M1:{ *:[nxv8i1] } VR:{ *:[nxv8i1] }:$rs1, VR:{ *:[nxv8i1] }:$rs2, -1:{ *:[i32] }, 0:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMOR_MM_M1,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 61639,
        GIR_Done,
      // Label 959: @19042
      GIM_Reject,
    // Label 957: @19043
    GIM_Reject,
    // Label 888: @19044
    GIM_Try, /*On fail goto*//*Label 960*/ 19127,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv8s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv8s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 961*/ 19096, // Rule ID 56545 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (or:{ *:[nxv8i8] } VR:{ *:[nxv8i8] }:$rs1, VR:{ *:[nxv8i8] }:$rs2)  =>  (PseudoVOR_VV_M1:{ *:[nxv8i8] } VR:{ *:[nxv8i8] }:$rs1, VR:{ *:[nxv8i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVOR_VV_M1,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 56545,
        GIR_Done,
      // Label 961: @19096
      GIM_Try, /*On fail goto*//*Label 962*/ 19126, // Rule ID 56546 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (or:{ *:[nxv8i8] } VR:{ *:[nxv8i8] }:$rs1, VR:{ *:[nxv8i8] }:$rs2)  =>  (PseudoVOR_VV_M1:{ *:[nxv8i8] } VR:{ *:[nxv8i8] }:$rs1, VR:{ *:[nxv8i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVOR_VV_M1,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 56546,
        GIR_Done,
      // Label 962: @19126
      GIM_Reject,
    // Label 960: @19127
    GIM_Reject,
    // Label 889: @19128
    GIM_Try, /*On fail goto*//*Label 963*/ 19211,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv8s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM2RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM2RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM2RegClassID,
      GIM_Try, /*On fail goto*//*Label 964*/ 19180, // Rule ID 56573 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (or:{ *:[nxv8i16] } VRM2:{ *:[nxv8i16] }:$rs1, VRM2:{ *:[nxv8i16] }:$rs2)  =>  (PseudoVOR_VV_M2:{ *:[nxv8i16] } VRM2:{ *:[nxv8i16] }:$rs1, VRM2:{ *:[nxv8i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVOR_VV_M2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 56573,
        GIR_Done,
      // Label 964: @19180
      GIM_Try, /*On fail goto*//*Label 965*/ 19210, // Rule ID 56574 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (or:{ *:[nxv8i16] } VRM2:{ *:[nxv8i16] }:$rs1, VRM2:{ *:[nxv8i16] }:$rs2)  =>  (PseudoVOR_VV_M2:{ *:[nxv8i16] } VRM2:{ *:[nxv8i16] }:$rs1, VRM2:{ *:[nxv8i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVOR_VV_M2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 56574,
        GIR_Done,
      // Label 965: @19210
      GIM_Reject,
    // Label 963: @19211
    GIM_Reject,
    // Label 890: @19212
    GIM_Try, /*On fail goto*//*Label 966*/ 19295,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv8s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv8s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM4RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM4RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM4RegClassID,
      GIM_Try, /*On fail goto*//*Label 967*/ 19264, // Rule ID 56589 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (or:{ *:[nxv8i32] } VRM4:{ *:[nxv8i32] }:$rs1, VRM4:{ *:[nxv8i32] }:$rs2)  =>  (PseudoVOR_VV_M4:{ *:[nxv8i32] } VRM4:{ *:[nxv8i32] }:$rs1, VRM4:{ *:[nxv8i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVOR_VV_M4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 56589,
        GIR_Done,
      // Label 967: @19264
      GIM_Try, /*On fail goto*//*Label 968*/ 19294, // Rule ID 56590 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (or:{ *:[nxv8i32] } VRM4:{ *:[nxv8i32] }:$rs1, VRM4:{ *:[nxv8i32] }:$rs2)  =>  (PseudoVOR_VV_M4:{ *:[nxv8i32] } VRM4:{ *:[nxv8i32] }:$rs1, VRM4:{ *:[nxv8i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVOR_VV_M4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 56590,
        GIR_Done,
      // Label 968: @19294
      GIM_Reject,
    // Label 966: @19295
    GIM_Reject,
    // Label 891: @19296
    GIM_Try, /*On fail goto*//*Label 969*/ 19379,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv8s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv8s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM8RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM8RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM8RegClassID,
      GIM_Try, /*On fail goto*//*Label 970*/ 19348, // Rule ID 56605 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (or:{ *:[nxv8i64] } VRM8:{ *:[nxv8i64] }:$rs1, VRM8:{ *:[nxv8i64] }:$rs2)  =>  (PseudoVOR_VV_M8:{ *:[nxv8i64] } VRM8:{ *:[nxv8i64] }:$rs1, VRM8:{ *:[nxv8i64] }:$rs2, -1:{ *:[i64] }, 6:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVOR_VV_M8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 56605,
        GIR_Done,
      // Label 970: @19348
      GIM_Try, /*On fail goto*//*Label 971*/ 19378, // Rule ID 56606 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (or:{ *:[nxv8i64] } VRM8:{ *:[nxv8i64] }:$rs1, VRM8:{ *:[nxv8i64] }:$rs2)  =>  (PseudoVOR_VV_M8:{ *:[nxv8i64] } VRM8:{ *:[nxv8i64] }:$rs1, VRM8:{ *:[nxv8i64] }:$rs2, -1:{ *:[i32] }, 6:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVOR_VV_M8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 56606,
        GIR_Done,
      // Label 971: @19378
      GIM_Reject,
    // Label 969: @19379
    GIM_Reject,
    // Label 892: @19380
    GIM_Try, /*On fail goto*//*Label 972*/ 19463,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv16s1,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv16s1,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 973*/ 19432, // Rule ID 61656 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (or:{ *:[nxv16i1] } VR:{ *:[nxv16i1] }:$rs1, VR:{ *:[nxv16i1] }:$rs2)  =>  (PseudoVMOR_MM_M2:{ *:[nxv16i1] } VR:{ *:[nxv16i1] }:$rs1, VR:{ *:[nxv16i1] }:$rs2, -1:{ *:[i64] }, 0:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMOR_MM_M2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 61656,
        GIR_Done,
      // Label 973: @19432
      GIM_Try, /*On fail goto*//*Label 974*/ 19462, // Rule ID 61657 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (or:{ *:[nxv16i1] } VR:{ *:[nxv16i1] }:$rs1, VR:{ *:[nxv16i1] }:$rs2)  =>  (PseudoVMOR_MM_M2:{ *:[nxv16i1] } VR:{ *:[nxv16i1] }:$rs1, VR:{ *:[nxv16i1] }:$rs2, -1:{ *:[i32] }, 0:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMOR_MM_M2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 61657,
        GIR_Done,
      // Label 974: @19462
      GIM_Reject,
    // Label 972: @19463
    GIM_Reject,
    // Label 893: @19464
    GIM_Try, /*On fail goto*//*Label 975*/ 19547,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv16s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv16s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM2RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM2RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM2RegClassID,
      GIM_Try, /*On fail goto*//*Label 976*/ 19516, // Rule ID 56561 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (or:{ *:[nxv16i8] } VRM2:{ *:[nxv16i8] }:$rs1, VRM2:{ *:[nxv16i8] }:$rs2)  =>  (PseudoVOR_VV_M2:{ *:[nxv16i8] } VRM2:{ *:[nxv16i8] }:$rs1, VRM2:{ *:[nxv16i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVOR_VV_M2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 56561,
        GIR_Done,
      // Label 976: @19516
      GIM_Try, /*On fail goto*//*Label 977*/ 19546, // Rule ID 56562 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (or:{ *:[nxv16i8] } VRM2:{ *:[nxv16i8] }:$rs1, VRM2:{ *:[nxv16i8] }:$rs2)  =>  (PseudoVOR_VV_M2:{ *:[nxv16i8] } VRM2:{ *:[nxv16i8] }:$rs1, VRM2:{ *:[nxv16i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVOR_VV_M2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 56562,
        GIR_Done,
      // Label 977: @19546
      GIM_Reject,
    // Label 975: @19547
    GIM_Reject,
    // Label 894: @19548
    GIM_Try, /*On fail goto*//*Label 978*/ 19631,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv16s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv16s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM4RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM4RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM4RegClassID,
      GIM_Try, /*On fail goto*//*Label 979*/ 19600, // Rule ID 56577 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (or:{ *:[nxv16i16] } VRM4:{ *:[nxv16i16] }:$rs1, VRM4:{ *:[nxv16i16] }:$rs2)  =>  (PseudoVOR_VV_M4:{ *:[nxv16i16] } VRM4:{ *:[nxv16i16] }:$rs1, VRM4:{ *:[nxv16i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVOR_VV_M4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 56577,
        GIR_Done,
      // Label 979: @19600
      GIM_Try, /*On fail goto*//*Label 980*/ 19630, // Rule ID 56578 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (or:{ *:[nxv16i16] } VRM4:{ *:[nxv16i16] }:$rs1, VRM4:{ *:[nxv16i16] }:$rs2)  =>  (PseudoVOR_VV_M4:{ *:[nxv16i16] } VRM4:{ *:[nxv16i16] }:$rs1, VRM4:{ *:[nxv16i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVOR_VV_M4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 56578,
        GIR_Done,
      // Label 980: @19630
      GIM_Reject,
    // Label 978: @19631
    GIM_Reject,
    // Label 895: @19632
    GIM_Try, /*On fail goto*//*Label 981*/ 19715,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv16s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv16s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM8RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM8RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM8RegClassID,
      GIM_Try, /*On fail goto*//*Label 982*/ 19684, // Rule ID 56593 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (or:{ *:[nxv16i32] } VRM8:{ *:[nxv16i32] }:$rs1, VRM8:{ *:[nxv16i32] }:$rs2)  =>  (PseudoVOR_VV_M8:{ *:[nxv16i32] } VRM8:{ *:[nxv16i32] }:$rs1, VRM8:{ *:[nxv16i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVOR_VV_M8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 56593,
        GIR_Done,
      // Label 982: @19684
      GIM_Try, /*On fail goto*//*Label 983*/ 19714, // Rule ID 56594 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (or:{ *:[nxv16i32] } VRM8:{ *:[nxv16i32] }:$rs1, VRM8:{ *:[nxv16i32] }:$rs2)  =>  (PseudoVOR_VV_M8:{ *:[nxv16i32] } VRM8:{ *:[nxv16i32] }:$rs1, VRM8:{ *:[nxv16i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVOR_VV_M8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 56594,
        GIR_Done,
      // Label 983: @19714
      GIM_Reject,
    // Label 981: @19715
    GIM_Reject,
    // Label 896: @19716
    GIM_Try, /*On fail goto*//*Label 984*/ 19799,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv32s1,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv32s1,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 985*/ 19768, // Rule ID 61674 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (or:{ *:[nxv32i1] } VR:{ *:[nxv32i1] }:$rs1, VR:{ *:[nxv32i1] }:$rs2)  =>  (PseudoVMOR_MM_M4:{ *:[nxv32i1] } VR:{ *:[nxv32i1] }:$rs1, VR:{ *:[nxv32i1] }:$rs2, -1:{ *:[i64] }, 0:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMOR_MM_M4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 61674,
        GIR_Done,
      // Label 985: @19768
      GIM_Try, /*On fail goto*//*Label 986*/ 19798, // Rule ID 61675 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (or:{ *:[nxv32i1] } VR:{ *:[nxv32i1] }:$rs1, VR:{ *:[nxv32i1] }:$rs2)  =>  (PseudoVMOR_MM_M4:{ *:[nxv32i1] } VR:{ *:[nxv32i1] }:$rs1, VR:{ *:[nxv32i1] }:$rs2, -1:{ *:[i32] }, 0:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMOR_MM_M4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 61675,
        GIR_Done,
      // Label 986: @19798
      GIM_Reject,
    // Label 984: @19799
    GIM_Reject,
    // Label 897: @19800
    GIM_Try, /*On fail goto*//*Label 987*/ 19883,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv32s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv32s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM4RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM4RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM4RegClassID,
      GIM_Try, /*On fail goto*//*Label 988*/ 19852, // Rule ID 56565 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (or:{ *:[nxv32i8] } VRM4:{ *:[nxv32i8] }:$rs1, VRM4:{ *:[nxv32i8] }:$rs2)  =>  (PseudoVOR_VV_M4:{ *:[nxv32i8] } VRM4:{ *:[nxv32i8] }:$rs1, VRM4:{ *:[nxv32i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVOR_VV_M4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 56565,
        GIR_Done,
      // Label 988: @19852
      GIM_Try, /*On fail goto*//*Label 989*/ 19882, // Rule ID 56566 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (or:{ *:[nxv32i8] } VRM4:{ *:[nxv32i8] }:$rs1, VRM4:{ *:[nxv32i8] }:$rs2)  =>  (PseudoVOR_VV_M4:{ *:[nxv32i8] } VRM4:{ *:[nxv32i8] }:$rs1, VRM4:{ *:[nxv32i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVOR_VV_M4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 56566,
        GIR_Done,
      // Label 989: @19882
      GIM_Reject,
    // Label 987: @19883
    GIM_Reject,
    // Label 898: @19884
    GIM_Try, /*On fail goto*//*Label 990*/ 19967,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv32s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv32s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM8RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM8RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM8RegClassID,
      GIM_Try, /*On fail goto*//*Label 991*/ 19936, // Rule ID 56581 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (or:{ *:[nxv32i16] } VRM8:{ *:[nxv32i16] }:$rs1, VRM8:{ *:[nxv32i16] }:$rs2)  =>  (PseudoVOR_VV_M8:{ *:[nxv32i16] } VRM8:{ *:[nxv32i16] }:$rs1, VRM8:{ *:[nxv32i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVOR_VV_M8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 56581,
        GIR_Done,
      // Label 991: @19936
      GIM_Try, /*On fail goto*//*Label 992*/ 19966, // Rule ID 56582 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (or:{ *:[nxv32i16] } VRM8:{ *:[nxv32i16] }:$rs1, VRM8:{ *:[nxv32i16] }:$rs2)  =>  (PseudoVOR_VV_M8:{ *:[nxv32i16] } VRM8:{ *:[nxv32i16] }:$rs1, VRM8:{ *:[nxv32i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVOR_VV_M8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 56582,
        GIR_Done,
      // Label 992: @19966
      GIM_Reject,
    // Label 990: @19967
    GIM_Reject,
    // Label 899: @19968
    GIM_Try, /*On fail goto*//*Label 993*/ 20051,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv64s1,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv64s1,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 994*/ 20020, // Rule ID 61692 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (or:{ *:[nxv64i1] } VR:{ *:[nxv64i1] }:$rs1, VR:{ *:[nxv64i1] }:$rs2)  =>  (PseudoVMOR_MM_M8:{ *:[nxv64i1] } VR:{ *:[nxv64i1] }:$rs1, VR:{ *:[nxv64i1] }:$rs2, -1:{ *:[i64] }, 0:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMOR_MM_M8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 61692,
        GIR_Done,
      // Label 994: @20020
      GIM_Try, /*On fail goto*//*Label 995*/ 20050, // Rule ID 61693 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (or:{ *:[nxv64i1] } VR:{ *:[nxv64i1] }:$rs1, VR:{ *:[nxv64i1] }:$rs2)  =>  (PseudoVMOR_MM_M8:{ *:[nxv64i1] } VR:{ *:[nxv64i1] }:$rs1, VR:{ *:[nxv64i1] }:$rs2, -1:{ *:[i32] }, 0:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMOR_MM_M8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 61693,
        GIR_Done,
      // Label 995: @20050
      GIM_Reject,
    // Label 993: @20051
    GIM_Reject,
    // Label 900: @20052
    GIM_Try, /*On fail goto*//*Label 996*/ 20135,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv64s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv64s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM8RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM8RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM8RegClassID,
      GIM_Try, /*On fail goto*//*Label 997*/ 20104, // Rule ID 56569 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (or:{ *:[nxv64i8] } VRM8:{ *:[nxv64i8] }:$rs1, VRM8:{ *:[nxv64i8] }:$rs2)  =>  (PseudoVOR_VV_M8:{ *:[nxv64i8] } VRM8:{ *:[nxv64i8] }:$rs1, VRM8:{ *:[nxv64i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVOR_VV_M8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 56569,
        GIR_Done,
      // Label 997: @20104
      GIM_Try, /*On fail goto*//*Label 998*/ 20134, // Rule ID 56570 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (or:{ *:[nxv64i8] } VRM8:{ *:[nxv64i8] }:$rs1, VRM8:{ *:[nxv64i8] }:$rs2)  =>  (PseudoVOR_VV_M8:{ *:[nxv64i8] } VRM8:{ *:[nxv64i8] }:$rs1, VRM8:{ *:[nxv64i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVOR_VV_M8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 56570,
        GIR_Done,
      // Label 998: @20134
      GIM_Reject,
    // Label 996: @20135
    GIM_Reject,
    // Label 901: @20136
    GIM_Reject,
    // Label 9: @20137
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/1, 32, /*)*//*default:*//*Label 1030*/ 23068,
    /*GILLT_s32*//*Label 999*/ 20174,
    /*GILLT_s64*//*Label 1000*/ 20403,
    /*GILLT_nxv1s1*//*Label 1001*/ 20632,
    /*GILLT_nxv1s8*//*Label 1002*/ 20716,
    /*GILLT_nxv1s16*//*Label 1003*/ 20800,
    /*GILLT_nxv1s32*//*Label 1004*/ 20884,
    /*GILLT_nxv1s64*//*Label 1005*/ 20968,
    /*GILLT_nxv2s1*//*Label 1006*/ 21052,
    /*GILLT_nxv2s8*//*Label 1007*/ 21136,
    /*GILLT_nxv2s16*//*Label 1008*/ 21220,
    /*GILLT_nxv2s32*//*Label 1009*/ 21304,
    /*GILLT_nxv2s64*//*Label 1010*/ 21388,
    /*GILLT_nxv4s1*//*Label 1011*/ 21472,
    /*GILLT_nxv4s8*//*Label 1012*/ 21556,
    /*GILLT_nxv4s16*//*Label 1013*/ 21640,
    /*GILLT_nxv4s32*//*Label 1014*/ 21724,
    /*GILLT_nxv4s64*//*Label 1015*/ 21808,
    /*GILLT_nxv8s1*//*Label 1016*/ 21892,
    /*GILLT_nxv8s8*//*Label 1017*/ 21976,
    /*GILLT_nxv8s16*//*Label 1018*/ 22060,
    /*GILLT_nxv8s32*//*Label 1019*/ 22144,
    /*GILLT_nxv8s64*//*Label 1020*/ 22228,
    /*GILLT_nxv16s1*//*Label 1021*/ 22312,
    /*GILLT_nxv16s8*//*Label 1022*/ 22396,
    /*GILLT_nxv16s16*//*Label 1023*/ 22480,
    /*GILLT_nxv16s32*//*Label 1024*/ 22564,
    /*GILLT_nxv32s1*//*Label 1025*/ 22648,
    /*GILLT_nxv32s8*//*Label 1026*/ 22732,
    /*GILLT_nxv32s16*//*Label 1027*/ 22816,
    /*GILLT_nxv64s1*//*Label 1028*/ 22900,
    /*GILLT_nxv64s8*//*Label 1029*/ 22984,
    // Label 999: @20174
    GIM_Try, /*On fail goto*//*Label 1031*/ 20402,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
      GIM_Try, /*On fail goto*//*Label 1032*/ 20241, // Rule ID 72091 //
        GIM_CheckFeatures, GIFBS_HasStdExtZbbOrZbkb,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, -1,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (xor:{ *:[i32] } (xor:{ *:[i32] } GPR:{ *:[i32] }:$rs1, -1:{ *:[i32] }), GPR:{ *:[i32] }:$rs2)  =>  (XNOR:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::XNOR,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 72091,
        GIR_Done,
      // Label 1032: @20241
      GIM_Try, /*On fail goto*//*Label 1033*/ 20294, // Rule ID 72089 //
        GIM_CheckFeatures, GIFBS_HasStdExtZbbOrZbkb,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, -1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (xor:{ *:[i32] } (xor:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2), -1:{ *:[i32] })  =>  (XNOR:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::XNOR,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rs2
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 72089,
        GIR_Done,
      // Label 1033: @20294
      GIM_Try, /*On fail goto*//*Label 1034*/ 20347, // Rule ID 65438 //
        GIM_CheckFeatures, GIFBS_HasStdExtZbbOrZbkb,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, -1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (xor:{ *:[i32] } GPR:{ *:[i32] }:$rs1, (xor:{ *:[i32] } GPR:{ *:[i32] }:$rs2, -1:{ *:[i32] }))  =>  (XNOR:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::XNOR,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs2
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 65438,
        GIR_Done,
      // Label 1034: @20347
      GIM_Try, /*On fail goto*//*Label 1035*/ 20384, // Rule ID 59980 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIPFP_I64_Predicate_simm12,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (xor:{ *:[i32] } GPR:{ *:[i32] }:$rs1, (imm:{ *:[i32] })<<P:Predicate_simm12>>:$imm)  =>  (XORI:{ *:[i32] } GPR:{ *:[i32] }:$rs1, (imm:{ *:[i32] })<<P:Predicate_simm12>>:$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::XORI,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // imm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 59980,
        GIR_Done,
      // Label 1035: @20384
      GIM_Try, /*On fail goto*//*Label 1036*/ 20401, // Rule ID 59958 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (xor:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)  =>  (XOR:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::XOR,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 59958,
        GIR_Done,
      // Label 1036: @20401
      GIM_Reject,
    // Label 1031: @20402
    GIM_Reject,
    // Label 1000: @20403
    GIM_Try, /*On fail goto*//*Label 1037*/ 20631,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
      GIM_Try, /*On fail goto*//*Label 1038*/ 20470, // Rule ID 72090 //
        GIM_CheckFeatures, GIFBS_HasStdExtZbbOrZbkb,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, -1,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (xor:{ *:[i64] } (xor:{ *:[i64] } GPR:{ *:[i64] }:$rs1, -1:{ *:[i64] }), GPR:{ *:[i64] }:$rs2)  =>  (XNOR:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::XNOR,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 72090,
        GIR_Done,
      // Label 1038: @20470
      GIM_Try, /*On fail goto*//*Label 1039*/ 20523, // Rule ID 72088 //
        GIM_CheckFeatures, GIFBS_HasStdExtZbbOrZbkb,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, -1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (xor:{ *:[i64] } (xor:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2), -1:{ *:[i64] })  =>  (XNOR:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::XNOR,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rs2
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 72088,
        GIR_Done,
      // Label 1039: @20523
      GIM_Try, /*On fail goto*//*Label 1040*/ 20576, // Rule ID 65437 //
        GIM_CheckFeatures, GIFBS_HasStdExtZbbOrZbkb,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, -1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (xor:{ *:[i64] } GPR:{ *:[i64] }:$rs1, (xor:{ *:[i64] } GPR:{ *:[i64] }:$rs2, -1:{ *:[i64] }))  =>  (XNOR:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::XNOR,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs2
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 65437,
        GIR_Done,
      // Label 1040: @20576
      GIM_Try, /*On fail goto*//*Label 1041*/ 20613, // Rule ID 59979 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIPFP_I64_Predicate_simm12,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (xor:{ *:[i64] } GPR:{ *:[i64] }:$rs1, (imm:{ *:[i64] })<<P:Predicate_simm12>>:$imm)  =>  (XORI:{ *:[i64] } GPR:{ *:[i64] }:$rs1, (imm:{ *:[i64] })<<P:Predicate_simm12>>:$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::XORI,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // imm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 59979,
        GIR_Done,
      // Label 1041: @20613
      GIM_Try, /*On fail goto*//*Label 1042*/ 20630, // Rule ID 59957 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (xor:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)  =>  (XOR:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::XOR,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 59957,
        GIR_Done,
      // Label 1042: @20630
      GIM_Reject,
    // Label 1037: @20631
    GIM_Reject,
    // Label 1001: @20632
    GIM_Try, /*On fail goto*//*Label 1043*/ 20715,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv1s1,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv1s1,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 1044*/ 20684, // Rule ID 61580 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (xor:{ *:[nxv1i1] } VR:{ *:[nxv1i1] }:$rs1, VR:{ *:[nxv1i1] }:$rs2)  =>  (PseudoVMXOR_MM_MF8:{ *:[nxv1i1] } VR:{ *:[nxv1i1] }:$rs1, VR:{ *:[nxv1i1] }:$rs2, -1:{ *:[i64] }, 0:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMXOR_MM_MF8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 61580,
        GIR_Done,
      // Label 1044: @20684
      GIM_Try, /*On fail goto*//*Label 1045*/ 20714, // Rule ID 61581 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (xor:{ *:[nxv1i1] } VR:{ *:[nxv1i1] }:$rs1, VR:{ *:[nxv1i1] }:$rs2)  =>  (PseudoVMXOR_MM_MF8:{ *:[nxv1i1] } VR:{ *:[nxv1i1] }:$rs1, VR:{ *:[nxv1i1] }:$rs2, -1:{ *:[i32] }, 0:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMXOR_MM_MF8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 61581,
        GIR_Done,
      // Label 1045: @20714
      GIM_Reject,
    // Label 1043: @20715
    GIM_Reject,
    // Label 1002: @20716
    GIM_Try, /*On fail goto*//*Label 1046*/ 20799,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv1s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv1s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 1047*/ 20768, // Rule ID 56653 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (xor:{ *:[nxv1i8] } VR:{ *:[nxv1i8] }:$rs1, VR:{ *:[nxv1i8] }:$rs2)  =>  (PseudoVXOR_VV_MF8:{ *:[nxv1i8] } VR:{ *:[nxv1i8] }:$rs1, VR:{ *:[nxv1i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVXOR_VV_MF8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 56653,
        GIR_Done,
      // Label 1047: @20768
      GIM_Try, /*On fail goto*//*Label 1048*/ 20798, // Rule ID 56654 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (xor:{ *:[nxv1i8] } VR:{ *:[nxv1i8] }:$rs1, VR:{ *:[nxv1i8] }:$rs2)  =>  (PseudoVXOR_VV_MF8:{ *:[nxv1i8] } VR:{ *:[nxv1i8] }:$rs1, VR:{ *:[nxv1i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVXOR_VV_MF8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 56654,
        GIR_Done,
      // Label 1048: @20798
      GIM_Reject,
    // Label 1046: @20799
    GIM_Reject,
    // Label 1003: @20800
    GIM_Try, /*On fail goto*//*Label 1049*/ 20883,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv1s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv1s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 1050*/ 20852, // Rule ID 56665 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (xor:{ *:[nxv1i16] } VR:{ *:[nxv1i16] }:$rs1, VR:{ *:[nxv1i16] }:$rs2)  =>  (PseudoVXOR_VV_MF4:{ *:[nxv1i16] } VR:{ *:[nxv1i16] }:$rs1, VR:{ *:[nxv1i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVXOR_VV_MF4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 56665,
        GIR_Done,
      // Label 1050: @20852
      GIM_Try, /*On fail goto*//*Label 1051*/ 20882, // Rule ID 56666 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (xor:{ *:[nxv1i16] } VR:{ *:[nxv1i16] }:$rs1, VR:{ *:[nxv1i16] }:$rs2)  =>  (PseudoVXOR_VV_MF4:{ *:[nxv1i16] } VR:{ *:[nxv1i16] }:$rs1, VR:{ *:[nxv1i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVXOR_VV_MF4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 56666,
        GIR_Done,
      // Label 1051: @20882
      GIM_Reject,
    // Label 1049: @20883
    GIM_Reject,
    // Label 1004: @20884
    GIM_Try, /*On fail goto*//*Label 1052*/ 20967,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv1s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv1s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 1053*/ 20936, // Rule ID 56673 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (xor:{ *:[nxv1i32] } VR:{ *:[nxv1i32] }:$rs1, VR:{ *:[nxv1i32] }:$rs2)  =>  (PseudoVXOR_VV_MF2:{ *:[nxv1i32] } VR:{ *:[nxv1i32] }:$rs1, VR:{ *:[nxv1i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVXOR_VV_MF2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 56673,
        GIR_Done,
      // Label 1053: @20936
      GIM_Try, /*On fail goto*//*Label 1054*/ 20966, // Rule ID 56674 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (xor:{ *:[nxv1i32] } VR:{ *:[nxv1i32] }:$rs1, VR:{ *:[nxv1i32] }:$rs2)  =>  (PseudoVXOR_VV_MF2:{ *:[nxv1i32] } VR:{ *:[nxv1i32] }:$rs1, VR:{ *:[nxv1i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVXOR_VV_MF2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 56674,
        GIR_Done,
      // Label 1054: @20966
      GIM_Reject,
    // Label 1052: @20967
    GIM_Reject,
    // Label 1005: @20968
    GIM_Try, /*On fail goto*//*Label 1055*/ 21051,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv1s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv1s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 1056*/ 21020, // Rule ID 56689 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (xor:{ *:[nxv1i64] } VR:{ *:[nxv1i64] }:$rs1, VR:{ *:[nxv1i64] }:$rs2)  =>  (PseudoVXOR_VV_M1:{ *:[nxv1i64] } VR:{ *:[nxv1i64] }:$rs1, VR:{ *:[nxv1i64] }:$rs2, -1:{ *:[i64] }, 6:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVXOR_VV_M1,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 56689,
        GIR_Done,
      // Label 1056: @21020
      GIM_Try, /*On fail goto*//*Label 1057*/ 21050, // Rule ID 56690 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (xor:{ *:[nxv1i64] } VR:{ *:[nxv1i64] }:$rs1, VR:{ *:[nxv1i64] }:$rs2)  =>  (PseudoVXOR_VV_M1:{ *:[nxv1i64] } VR:{ *:[nxv1i64] }:$rs1, VR:{ *:[nxv1i64] }:$rs2, -1:{ *:[i32] }, 6:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVXOR_VV_M1,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 56690,
        GIR_Done,
      // Label 1057: @21050
      GIM_Reject,
    // Label 1055: @21051
    GIM_Reject,
    // Label 1006: @21052
    GIM_Try, /*On fail goto*//*Label 1058*/ 21135,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv2s1,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv2s1,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 1059*/ 21104, // Rule ID 61600 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (xor:{ *:[nxv2i1] } VR:{ *:[nxv2i1] }:$rs1, VR:{ *:[nxv2i1] }:$rs2)  =>  (PseudoVMXOR_MM_MF4:{ *:[nxv2i1] } VR:{ *:[nxv2i1] }:$rs1, VR:{ *:[nxv2i1] }:$rs2, -1:{ *:[i64] }, 0:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMXOR_MM_MF4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 61600,
        GIR_Done,
      // Label 1059: @21104
      GIM_Try, /*On fail goto*//*Label 1060*/ 21134, // Rule ID 61601 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (xor:{ *:[nxv2i1] } VR:{ *:[nxv2i1] }:$rs1, VR:{ *:[nxv2i1] }:$rs2)  =>  (PseudoVMXOR_MM_MF4:{ *:[nxv2i1] } VR:{ *:[nxv2i1] }:$rs1, VR:{ *:[nxv2i1] }:$rs2, -1:{ *:[i32] }, 0:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMXOR_MM_MF4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 61601,
        GIR_Done,
      // Label 1060: @21134
      GIM_Reject,
    // Label 1058: @21135
    GIM_Reject,
    // Label 1007: @21136
    GIM_Try, /*On fail goto*//*Label 1061*/ 21219,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv2s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv2s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 1062*/ 21188, // Rule ID 56657 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (xor:{ *:[nxv2i8] } VR:{ *:[nxv2i8] }:$rs1, VR:{ *:[nxv2i8] }:$rs2)  =>  (PseudoVXOR_VV_MF4:{ *:[nxv2i8] } VR:{ *:[nxv2i8] }:$rs1, VR:{ *:[nxv2i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVXOR_VV_MF4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 56657,
        GIR_Done,
      // Label 1062: @21188
      GIM_Try, /*On fail goto*//*Label 1063*/ 21218, // Rule ID 56658 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (xor:{ *:[nxv2i8] } VR:{ *:[nxv2i8] }:$rs1, VR:{ *:[nxv2i8] }:$rs2)  =>  (PseudoVXOR_VV_MF4:{ *:[nxv2i8] } VR:{ *:[nxv2i8] }:$rs1, VR:{ *:[nxv2i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVXOR_VV_MF4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 56658,
        GIR_Done,
      // Label 1063: @21218
      GIM_Reject,
    // Label 1061: @21219
    GIM_Reject,
    // Label 1008: @21220
    GIM_Try, /*On fail goto*//*Label 1064*/ 21303,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv2s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv2s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 1065*/ 21272, // Rule ID 56669 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (xor:{ *:[nxv2i16] } VR:{ *:[nxv2i16] }:$rs1, VR:{ *:[nxv2i16] }:$rs2)  =>  (PseudoVXOR_VV_MF2:{ *:[nxv2i16] } VR:{ *:[nxv2i16] }:$rs1, VR:{ *:[nxv2i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVXOR_VV_MF2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 56669,
        GIR_Done,
      // Label 1065: @21272
      GIM_Try, /*On fail goto*//*Label 1066*/ 21302, // Rule ID 56670 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (xor:{ *:[nxv2i16] } VR:{ *:[nxv2i16] }:$rs1, VR:{ *:[nxv2i16] }:$rs2)  =>  (PseudoVXOR_VV_MF2:{ *:[nxv2i16] } VR:{ *:[nxv2i16] }:$rs1, VR:{ *:[nxv2i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVXOR_VV_MF2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 56670,
        GIR_Done,
      // Label 1066: @21302
      GIM_Reject,
    // Label 1064: @21303
    GIM_Reject,
    // Label 1009: @21304
    GIM_Try, /*On fail goto*//*Label 1067*/ 21387,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv2s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv2s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 1068*/ 21356, // Rule ID 56685 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (xor:{ *:[nxv2i32] } VR:{ *:[nxv2i32] }:$rs1, VR:{ *:[nxv2i32] }:$rs2)  =>  (PseudoVXOR_VV_M1:{ *:[nxv2i32] } VR:{ *:[nxv2i32] }:$rs1, VR:{ *:[nxv2i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVXOR_VV_M1,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 56685,
        GIR_Done,
      // Label 1068: @21356
      GIM_Try, /*On fail goto*//*Label 1069*/ 21386, // Rule ID 56686 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (xor:{ *:[nxv2i32] } VR:{ *:[nxv2i32] }:$rs1, VR:{ *:[nxv2i32] }:$rs2)  =>  (PseudoVXOR_VV_M1:{ *:[nxv2i32] } VR:{ *:[nxv2i32] }:$rs1, VR:{ *:[nxv2i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVXOR_VV_M1,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 56686,
        GIR_Done,
      // Label 1069: @21386
      GIM_Reject,
    // Label 1067: @21387
    GIM_Reject,
    // Label 1010: @21388
    GIM_Try, /*On fail goto*//*Label 1070*/ 21471,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv2s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM2RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM2RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM2RegClassID,
      GIM_Try, /*On fail goto*//*Label 1071*/ 21440, // Rule ID 56729 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (xor:{ *:[nxv2i64] } VRM2:{ *:[nxv2i64] }:$rs1, VRM2:{ *:[nxv2i64] }:$rs2)  =>  (PseudoVXOR_VV_M2:{ *:[nxv2i64] } VRM2:{ *:[nxv2i64] }:$rs1, VRM2:{ *:[nxv2i64] }:$rs2, -1:{ *:[i64] }, 6:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVXOR_VV_M2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 56729,
        GIR_Done,
      // Label 1071: @21440
      GIM_Try, /*On fail goto*//*Label 1072*/ 21470, // Rule ID 56730 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (xor:{ *:[nxv2i64] } VRM2:{ *:[nxv2i64] }:$rs1, VRM2:{ *:[nxv2i64] }:$rs2)  =>  (PseudoVXOR_VV_M2:{ *:[nxv2i64] } VRM2:{ *:[nxv2i64] }:$rs1, VRM2:{ *:[nxv2i64] }:$rs2, -1:{ *:[i32] }, 6:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVXOR_VV_M2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 56730,
        GIR_Done,
      // Label 1072: @21470
      GIM_Reject,
    // Label 1070: @21471
    GIM_Reject,
    // Label 1011: @21472
    GIM_Try, /*On fail goto*//*Label 1073*/ 21555,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv4s1,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv4s1,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 1074*/ 21524, // Rule ID 61620 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (xor:{ *:[nxv4i1] } VR:{ *:[nxv4i1] }:$rs1, VR:{ *:[nxv4i1] }:$rs2)  =>  (PseudoVMXOR_MM_MF2:{ *:[nxv4i1] } VR:{ *:[nxv4i1] }:$rs1, VR:{ *:[nxv4i1] }:$rs2, -1:{ *:[i64] }, 0:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMXOR_MM_MF2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 61620,
        GIR_Done,
      // Label 1074: @21524
      GIM_Try, /*On fail goto*//*Label 1075*/ 21554, // Rule ID 61621 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (xor:{ *:[nxv4i1] } VR:{ *:[nxv4i1] }:$rs1, VR:{ *:[nxv4i1] }:$rs2)  =>  (PseudoVMXOR_MM_MF2:{ *:[nxv4i1] } VR:{ *:[nxv4i1] }:$rs1, VR:{ *:[nxv4i1] }:$rs2, -1:{ *:[i32] }, 0:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMXOR_MM_MF2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 61621,
        GIR_Done,
      // Label 1075: @21554
      GIM_Reject,
    // Label 1073: @21555
    GIM_Reject,
    // Label 1012: @21556
    GIM_Try, /*On fail goto*//*Label 1076*/ 21639,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv4s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv4s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 1077*/ 21608, // Rule ID 56661 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (xor:{ *:[nxv4i8] } VR:{ *:[nxv4i8] }:$rs1, VR:{ *:[nxv4i8] }:$rs2)  =>  (PseudoVXOR_VV_MF2:{ *:[nxv4i8] } VR:{ *:[nxv4i8] }:$rs1, VR:{ *:[nxv4i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVXOR_VV_MF2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 56661,
        GIR_Done,
      // Label 1077: @21608
      GIM_Try, /*On fail goto*//*Label 1078*/ 21638, // Rule ID 56662 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (xor:{ *:[nxv4i8] } VR:{ *:[nxv4i8] }:$rs1, VR:{ *:[nxv4i8] }:$rs2)  =>  (PseudoVXOR_VV_MF2:{ *:[nxv4i8] } VR:{ *:[nxv4i8] }:$rs1, VR:{ *:[nxv4i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVXOR_VV_MF2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 56662,
        GIR_Done,
      // Label 1078: @21638
      GIM_Reject,
    // Label 1076: @21639
    GIM_Reject,
    // Label 1013: @21640
    GIM_Try, /*On fail goto*//*Label 1079*/ 21723,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv4s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv4s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 1080*/ 21692, // Rule ID 56681 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (xor:{ *:[nxv4i16] } VR:{ *:[nxv4i16] }:$rs1, VR:{ *:[nxv4i16] }:$rs2)  =>  (PseudoVXOR_VV_M1:{ *:[nxv4i16] } VR:{ *:[nxv4i16] }:$rs1, VR:{ *:[nxv4i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVXOR_VV_M1,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 56681,
        GIR_Done,
      // Label 1080: @21692
      GIM_Try, /*On fail goto*//*Label 1081*/ 21722, // Rule ID 56682 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (xor:{ *:[nxv4i16] } VR:{ *:[nxv4i16] }:$rs1, VR:{ *:[nxv4i16] }:$rs2)  =>  (PseudoVXOR_VV_M1:{ *:[nxv4i16] } VR:{ *:[nxv4i16] }:$rs1, VR:{ *:[nxv4i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVXOR_VV_M1,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 56682,
        GIR_Done,
      // Label 1081: @21722
      GIM_Reject,
    // Label 1079: @21723
    GIM_Reject,
    // Label 1014: @21724
    GIM_Try, /*On fail goto*//*Label 1082*/ 21807,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv4s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM2RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM2RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM2RegClassID,
      GIM_Try, /*On fail goto*//*Label 1083*/ 21776, // Rule ID 56717 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (xor:{ *:[nxv4i32] } VRM2:{ *:[nxv4i32] }:$rs1, VRM2:{ *:[nxv4i32] }:$rs2)  =>  (PseudoVXOR_VV_M2:{ *:[nxv4i32] } VRM2:{ *:[nxv4i32] }:$rs1, VRM2:{ *:[nxv4i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVXOR_VV_M2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 56717,
        GIR_Done,
      // Label 1083: @21776
      GIM_Try, /*On fail goto*//*Label 1084*/ 21806, // Rule ID 56718 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (xor:{ *:[nxv4i32] } VRM2:{ *:[nxv4i32] }:$rs1, VRM2:{ *:[nxv4i32] }:$rs2)  =>  (PseudoVXOR_VV_M2:{ *:[nxv4i32] } VRM2:{ *:[nxv4i32] }:$rs1, VRM2:{ *:[nxv4i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVXOR_VV_M2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 56718,
        GIR_Done,
      // Label 1084: @21806
      GIM_Reject,
    // Label 1082: @21807
    GIM_Reject,
    // Label 1015: @21808
    GIM_Try, /*On fail goto*//*Label 1085*/ 21891,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv4s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv4s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM4RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM4RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM4RegClassID,
      GIM_Try, /*On fail goto*//*Label 1086*/ 21860, // Rule ID 56733 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (xor:{ *:[nxv4i64] } VRM4:{ *:[nxv4i64] }:$rs1, VRM4:{ *:[nxv4i64] }:$rs2)  =>  (PseudoVXOR_VV_M4:{ *:[nxv4i64] } VRM4:{ *:[nxv4i64] }:$rs1, VRM4:{ *:[nxv4i64] }:$rs2, -1:{ *:[i64] }, 6:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVXOR_VV_M4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 56733,
        GIR_Done,
      // Label 1086: @21860
      GIM_Try, /*On fail goto*//*Label 1087*/ 21890, // Rule ID 56734 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (xor:{ *:[nxv4i64] } VRM4:{ *:[nxv4i64] }:$rs1, VRM4:{ *:[nxv4i64] }:$rs2)  =>  (PseudoVXOR_VV_M4:{ *:[nxv4i64] } VRM4:{ *:[nxv4i64] }:$rs1, VRM4:{ *:[nxv4i64] }:$rs2, -1:{ *:[i32] }, 6:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVXOR_VV_M4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 56734,
        GIR_Done,
      // Label 1087: @21890
      GIM_Reject,
    // Label 1085: @21891
    GIM_Reject,
    // Label 1016: @21892
    GIM_Try, /*On fail goto*//*Label 1088*/ 21975,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv8s1,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv8s1,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 1089*/ 21944, // Rule ID 61640 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (xor:{ *:[nxv8i1] } VR:{ *:[nxv8i1] }:$rs1, VR:{ *:[nxv8i1] }:$rs2)  =>  (PseudoVMXOR_MM_M1:{ *:[nxv8i1] } VR:{ *:[nxv8i1] }:$rs1, VR:{ *:[nxv8i1] }:$rs2, -1:{ *:[i64] }, 0:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMXOR_MM_M1,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 61640,
        GIR_Done,
      // Label 1089: @21944
      GIM_Try, /*On fail goto*//*Label 1090*/ 21974, // Rule ID 61641 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (xor:{ *:[nxv8i1] } VR:{ *:[nxv8i1] }:$rs1, VR:{ *:[nxv8i1] }:$rs2)  =>  (PseudoVMXOR_MM_M1:{ *:[nxv8i1] } VR:{ *:[nxv8i1] }:$rs1, VR:{ *:[nxv8i1] }:$rs2, -1:{ *:[i32] }, 0:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMXOR_MM_M1,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 61641,
        GIR_Done,
      // Label 1090: @21974
      GIM_Reject,
    // Label 1088: @21975
    GIM_Reject,
    // Label 1017: @21976
    GIM_Try, /*On fail goto*//*Label 1091*/ 22059,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv8s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv8s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 1092*/ 22028, // Rule ID 56677 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (xor:{ *:[nxv8i8] } VR:{ *:[nxv8i8] }:$rs1, VR:{ *:[nxv8i8] }:$rs2)  =>  (PseudoVXOR_VV_M1:{ *:[nxv8i8] } VR:{ *:[nxv8i8] }:$rs1, VR:{ *:[nxv8i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVXOR_VV_M1,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 56677,
        GIR_Done,
      // Label 1092: @22028
      GIM_Try, /*On fail goto*//*Label 1093*/ 22058, // Rule ID 56678 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (xor:{ *:[nxv8i8] } VR:{ *:[nxv8i8] }:$rs1, VR:{ *:[nxv8i8] }:$rs2)  =>  (PseudoVXOR_VV_M1:{ *:[nxv8i8] } VR:{ *:[nxv8i8] }:$rs1, VR:{ *:[nxv8i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVXOR_VV_M1,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 56678,
        GIR_Done,
      // Label 1093: @22058
      GIM_Reject,
    // Label 1091: @22059
    GIM_Reject,
    // Label 1018: @22060
    GIM_Try, /*On fail goto*//*Label 1094*/ 22143,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv8s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM2RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM2RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM2RegClassID,
      GIM_Try, /*On fail goto*//*Label 1095*/ 22112, // Rule ID 56705 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (xor:{ *:[nxv8i16] } VRM2:{ *:[nxv8i16] }:$rs1, VRM2:{ *:[nxv8i16] }:$rs2)  =>  (PseudoVXOR_VV_M2:{ *:[nxv8i16] } VRM2:{ *:[nxv8i16] }:$rs1, VRM2:{ *:[nxv8i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVXOR_VV_M2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 56705,
        GIR_Done,
      // Label 1095: @22112
      GIM_Try, /*On fail goto*//*Label 1096*/ 22142, // Rule ID 56706 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (xor:{ *:[nxv8i16] } VRM2:{ *:[nxv8i16] }:$rs1, VRM2:{ *:[nxv8i16] }:$rs2)  =>  (PseudoVXOR_VV_M2:{ *:[nxv8i16] } VRM2:{ *:[nxv8i16] }:$rs1, VRM2:{ *:[nxv8i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVXOR_VV_M2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 56706,
        GIR_Done,
      // Label 1096: @22142
      GIM_Reject,
    // Label 1094: @22143
    GIM_Reject,
    // Label 1019: @22144
    GIM_Try, /*On fail goto*//*Label 1097*/ 22227,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv8s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv8s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM4RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM4RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM4RegClassID,
      GIM_Try, /*On fail goto*//*Label 1098*/ 22196, // Rule ID 56721 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (xor:{ *:[nxv8i32] } VRM4:{ *:[nxv8i32] }:$rs1, VRM4:{ *:[nxv8i32] }:$rs2)  =>  (PseudoVXOR_VV_M4:{ *:[nxv8i32] } VRM4:{ *:[nxv8i32] }:$rs1, VRM4:{ *:[nxv8i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVXOR_VV_M4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 56721,
        GIR_Done,
      // Label 1098: @22196
      GIM_Try, /*On fail goto*//*Label 1099*/ 22226, // Rule ID 56722 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (xor:{ *:[nxv8i32] } VRM4:{ *:[nxv8i32] }:$rs1, VRM4:{ *:[nxv8i32] }:$rs2)  =>  (PseudoVXOR_VV_M4:{ *:[nxv8i32] } VRM4:{ *:[nxv8i32] }:$rs1, VRM4:{ *:[nxv8i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVXOR_VV_M4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 56722,
        GIR_Done,
      // Label 1099: @22226
      GIM_Reject,
    // Label 1097: @22227
    GIM_Reject,
    // Label 1020: @22228
    GIM_Try, /*On fail goto*//*Label 1100*/ 22311,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv8s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv8s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM8RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM8RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM8RegClassID,
      GIM_Try, /*On fail goto*//*Label 1101*/ 22280, // Rule ID 56737 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (xor:{ *:[nxv8i64] } VRM8:{ *:[nxv8i64] }:$rs1, VRM8:{ *:[nxv8i64] }:$rs2)  =>  (PseudoVXOR_VV_M8:{ *:[nxv8i64] } VRM8:{ *:[nxv8i64] }:$rs1, VRM8:{ *:[nxv8i64] }:$rs2, -1:{ *:[i64] }, 6:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVXOR_VV_M8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 56737,
        GIR_Done,
      // Label 1101: @22280
      GIM_Try, /*On fail goto*//*Label 1102*/ 22310, // Rule ID 56738 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (xor:{ *:[nxv8i64] } VRM8:{ *:[nxv8i64] }:$rs1, VRM8:{ *:[nxv8i64] }:$rs2)  =>  (PseudoVXOR_VV_M8:{ *:[nxv8i64] } VRM8:{ *:[nxv8i64] }:$rs1, VRM8:{ *:[nxv8i64] }:$rs2, -1:{ *:[i32] }, 6:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVXOR_VV_M8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 56738,
        GIR_Done,
      // Label 1102: @22310
      GIM_Reject,
    // Label 1100: @22311
    GIM_Reject,
    // Label 1021: @22312
    GIM_Try, /*On fail goto*//*Label 1103*/ 22395,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv16s1,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv16s1,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 1104*/ 22364, // Rule ID 61658 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (xor:{ *:[nxv16i1] } VR:{ *:[nxv16i1] }:$rs1, VR:{ *:[nxv16i1] }:$rs2)  =>  (PseudoVMXOR_MM_M2:{ *:[nxv16i1] } VR:{ *:[nxv16i1] }:$rs1, VR:{ *:[nxv16i1] }:$rs2, -1:{ *:[i64] }, 0:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMXOR_MM_M2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 61658,
        GIR_Done,
      // Label 1104: @22364
      GIM_Try, /*On fail goto*//*Label 1105*/ 22394, // Rule ID 61659 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (xor:{ *:[nxv16i1] } VR:{ *:[nxv16i1] }:$rs1, VR:{ *:[nxv16i1] }:$rs2)  =>  (PseudoVMXOR_MM_M2:{ *:[nxv16i1] } VR:{ *:[nxv16i1] }:$rs1, VR:{ *:[nxv16i1] }:$rs2, -1:{ *:[i32] }, 0:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMXOR_MM_M2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 61659,
        GIR_Done,
      // Label 1105: @22394
      GIM_Reject,
    // Label 1103: @22395
    GIM_Reject,
    // Label 1022: @22396
    GIM_Try, /*On fail goto*//*Label 1106*/ 22479,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv16s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv16s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM2RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM2RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM2RegClassID,
      GIM_Try, /*On fail goto*//*Label 1107*/ 22448, // Rule ID 56693 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (xor:{ *:[nxv16i8] } VRM2:{ *:[nxv16i8] }:$rs1, VRM2:{ *:[nxv16i8] }:$rs2)  =>  (PseudoVXOR_VV_M2:{ *:[nxv16i8] } VRM2:{ *:[nxv16i8] }:$rs1, VRM2:{ *:[nxv16i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVXOR_VV_M2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 56693,
        GIR_Done,
      // Label 1107: @22448
      GIM_Try, /*On fail goto*//*Label 1108*/ 22478, // Rule ID 56694 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (xor:{ *:[nxv16i8] } VRM2:{ *:[nxv16i8] }:$rs1, VRM2:{ *:[nxv16i8] }:$rs2)  =>  (PseudoVXOR_VV_M2:{ *:[nxv16i8] } VRM2:{ *:[nxv16i8] }:$rs1, VRM2:{ *:[nxv16i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVXOR_VV_M2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 56694,
        GIR_Done,
      // Label 1108: @22478
      GIM_Reject,
    // Label 1106: @22479
    GIM_Reject,
    // Label 1023: @22480
    GIM_Try, /*On fail goto*//*Label 1109*/ 22563,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv16s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv16s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM4RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM4RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM4RegClassID,
      GIM_Try, /*On fail goto*//*Label 1110*/ 22532, // Rule ID 56709 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (xor:{ *:[nxv16i16] } VRM4:{ *:[nxv16i16] }:$rs1, VRM4:{ *:[nxv16i16] }:$rs2)  =>  (PseudoVXOR_VV_M4:{ *:[nxv16i16] } VRM4:{ *:[nxv16i16] }:$rs1, VRM4:{ *:[nxv16i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVXOR_VV_M4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 56709,
        GIR_Done,
      // Label 1110: @22532
      GIM_Try, /*On fail goto*//*Label 1111*/ 22562, // Rule ID 56710 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (xor:{ *:[nxv16i16] } VRM4:{ *:[nxv16i16] }:$rs1, VRM4:{ *:[nxv16i16] }:$rs2)  =>  (PseudoVXOR_VV_M4:{ *:[nxv16i16] } VRM4:{ *:[nxv16i16] }:$rs1, VRM4:{ *:[nxv16i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVXOR_VV_M4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 56710,
        GIR_Done,
      // Label 1111: @22562
      GIM_Reject,
    // Label 1109: @22563
    GIM_Reject,
    // Label 1024: @22564
    GIM_Try, /*On fail goto*//*Label 1112*/ 22647,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv16s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv16s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM8RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM8RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM8RegClassID,
      GIM_Try, /*On fail goto*//*Label 1113*/ 22616, // Rule ID 56725 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (xor:{ *:[nxv16i32] } VRM8:{ *:[nxv16i32] }:$rs1, VRM8:{ *:[nxv16i32] }:$rs2)  =>  (PseudoVXOR_VV_M8:{ *:[nxv16i32] } VRM8:{ *:[nxv16i32] }:$rs1, VRM8:{ *:[nxv16i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVXOR_VV_M8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 56725,
        GIR_Done,
      // Label 1113: @22616
      GIM_Try, /*On fail goto*//*Label 1114*/ 22646, // Rule ID 56726 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (xor:{ *:[nxv16i32] } VRM8:{ *:[nxv16i32] }:$rs1, VRM8:{ *:[nxv16i32] }:$rs2)  =>  (PseudoVXOR_VV_M8:{ *:[nxv16i32] } VRM8:{ *:[nxv16i32] }:$rs1, VRM8:{ *:[nxv16i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVXOR_VV_M8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 56726,
        GIR_Done,
      // Label 1114: @22646
      GIM_Reject,
    // Label 1112: @22647
    GIM_Reject,
    // Label 1025: @22648
    GIM_Try, /*On fail goto*//*Label 1115*/ 22731,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv32s1,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv32s1,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 1116*/ 22700, // Rule ID 61676 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (xor:{ *:[nxv32i1] } VR:{ *:[nxv32i1] }:$rs1, VR:{ *:[nxv32i1] }:$rs2)  =>  (PseudoVMXOR_MM_M4:{ *:[nxv32i1] } VR:{ *:[nxv32i1] }:$rs1, VR:{ *:[nxv32i1] }:$rs2, -1:{ *:[i64] }, 0:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMXOR_MM_M4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 61676,
        GIR_Done,
      // Label 1116: @22700
      GIM_Try, /*On fail goto*//*Label 1117*/ 22730, // Rule ID 61677 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (xor:{ *:[nxv32i1] } VR:{ *:[nxv32i1] }:$rs1, VR:{ *:[nxv32i1] }:$rs2)  =>  (PseudoVMXOR_MM_M4:{ *:[nxv32i1] } VR:{ *:[nxv32i1] }:$rs1, VR:{ *:[nxv32i1] }:$rs2, -1:{ *:[i32] }, 0:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMXOR_MM_M4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 61677,
        GIR_Done,
      // Label 1117: @22730
      GIM_Reject,
    // Label 1115: @22731
    GIM_Reject,
    // Label 1026: @22732
    GIM_Try, /*On fail goto*//*Label 1118*/ 22815,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv32s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv32s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM4RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM4RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM4RegClassID,
      GIM_Try, /*On fail goto*//*Label 1119*/ 22784, // Rule ID 56697 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (xor:{ *:[nxv32i8] } VRM4:{ *:[nxv32i8] }:$rs1, VRM4:{ *:[nxv32i8] }:$rs2)  =>  (PseudoVXOR_VV_M4:{ *:[nxv32i8] } VRM4:{ *:[nxv32i8] }:$rs1, VRM4:{ *:[nxv32i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVXOR_VV_M4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 56697,
        GIR_Done,
      // Label 1119: @22784
      GIM_Try, /*On fail goto*//*Label 1120*/ 22814, // Rule ID 56698 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (xor:{ *:[nxv32i8] } VRM4:{ *:[nxv32i8] }:$rs1, VRM4:{ *:[nxv32i8] }:$rs2)  =>  (PseudoVXOR_VV_M4:{ *:[nxv32i8] } VRM4:{ *:[nxv32i8] }:$rs1, VRM4:{ *:[nxv32i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVXOR_VV_M4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 56698,
        GIR_Done,
      // Label 1120: @22814
      GIM_Reject,
    // Label 1118: @22815
    GIM_Reject,
    // Label 1027: @22816
    GIM_Try, /*On fail goto*//*Label 1121*/ 22899,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv32s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv32s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM8RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM8RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM8RegClassID,
      GIM_Try, /*On fail goto*//*Label 1122*/ 22868, // Rule ID 56713 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (xor:{ *:[nxv32i16] } VRM8:{ *:[nxv32i16] }:$rs1, VRM8:{ *:[nxv32i16] }:$rs2)  =>  (PseudoVXOR_VV_M8:{ *:[nxv32i16] } VRM8:{ *:[nxv32i16] }:$rs1, VRM8:{ *:[nxv32i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVXOR_VV_M8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 56713,
        GIR_Done,
      // Label 1122: @22868
      GIM_Try, /*On fail goto*//*Label 1123*/ 22898, // Rule ID 56714 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (xor:{ *:[nxv32i16] } VRM8:{ *:[nxv32i16] }:$rs1, VRM8:{ *:[nxv32i16] }:$rs2)  =>  (PseudoVXOR_VV_M8:{ *:[nxv32i16] } VRM8:{ *:[nxv32i16] }:$rs1, VRM8:{ *:[nxv32i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVXOR_VV_M8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 56714,
        GIR_Done,
      // Label 1123: @22898
      GIM_Reject,
    // Label 1121: @22899
    GIM_Reject,
    // Label 1028: @22900
    GIM_Try, /*On fail goto*//*Label 1124*/ 22983,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv64s1,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv64s1,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 1125*/ 22952, // Rule ID 61694 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (xor:{ *:[nxv64i1] } VR:{ *:[nxv64i1] }:$rs1, VR:{ *:[nxv64i1] }:$rs2)  =>  (PseudoVMXOR_MM_M8:{ *:[nxv64i1] } VR:{ *:[nxv64i1] }:$rs1, VR:{ *:[nxv64i1] }:$rs2, -1:{ *:[i64] }, 0:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMXOR_MM_M8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 61694,
        GIR_Done,
      // Label 1125: @22952
      GIM_Try, /*On fail goto*//*Label 1126*/ 22982, // Rule ID 61695 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (xor:{ *:[nxv64i1] } VR:{ *:[nxv64i1] }:$rs1, VR:{ *:[nxv64i1] }:$rs2)  =>  (PseudoVMXOR_MM_M8:{ *:[nxv64i1] } VR:{ *:[nxv64i1] }:$rs1, VR:{ *:[nxv64i1] }:$rs2, -1:{ *:[i32] }, 0:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVMXOR_MM_M8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 61695,
        GIR_Done,
      // Label 1126: @22982
      GIM_Reject,
    // Label 1124: @22983
    GIM_Reject,
    // Label 1029: @22984
    GIM_Try, /*On fail goto*//*Label 1127*/ 23067,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv64s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv64s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM8RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::VRM8RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::VRM8RegClassID,
      GIM_Try, /*On fail goto*//*Label 1128*/ 23036, // Rule ID 56701 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (xor:{ *:[nxv64i8] } VRM8:{ *:[nxv64i8] }:$rs1, VRM8:{ *:[nxv64i8] }:$rs2)  =>  (PseudoVXOR_VV_M8:{ *:[nxv64i8] } VRM8:{ *:[nxv64i8] }:$rs1, VRM8:{ *:[nxv64i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVXOR_VV_M8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 56701,
        GIR_Done,
      // Label 1128: @23036
      GIM_Try, /*On fail goto*//*Label 1129*/ 23066, // Rule ID 56702 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // (xor:{ *:[nxv64i8] } VRM8:{ *:[nxv64i8] }:$rs1, VRM8:{ *:[nxv64i8] }:$rs2)  =>  (PseudoVXOR_VV_M8:{ *:[nxv64i8] } VRM8:{ *:[nxv64i8] }:$rs1, VRM8:{ *:[nxv64i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVXOR_VV_M8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 56702,
        GIR_Done,
      // Label 1129: @23066
      GIM_Reject,
    // Label 1127: @23067
    GIM_Reject,
    // Label 1030: @23068
    GIM_Reject,
    // Label 10: @23069
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/1, 3, /*)*//*default:*//*Label 1132*/ 23169,
    /*GILLT_s32*//*Label 1130*/ 23077,
    /*GILLT_s64*//*Label 1131*/ 23123,
    // Label 1130: @23077
    GIM_Try, /*On fail goto*//*Label 1133*/ 23122,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_Try, /*On fail goto*//*Label 1134*/ 23102, // Rule ID 65241 //
        GIM_CheckFeatures, GIFBS_HasStdExtF_IsRV32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::FPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (bitconvert:{ *:[f32] } GPR:{ *:[i32] }:$rs1)  =>  (FMV_W_X:{ *:[f32] } GPR:{ *:[i32] }:$rs1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::FMV_W_X,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 65241,
        GIR_Done,
      // Label 1134: @23102
      GIM_Try, /*On fail goto*//*Label 1135*/ 23121, // Rule ID 65242 //
        GIM_CheckFeatures, GIFBS_HasStdExtF_IsRV32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::FPR32RegClassID,
        // (bitconvert:{ *:[i32] } FPR32:{ *:[f32] }:$rs1)  =>  (FMV_X_W:{ *:[i32] } FPR32:{ *:[f32] }:$rs1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::FMV_X_W,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 65242,
        GIR_Done,
      // Label 1135: @23121
      GIM_Reject,
    // Label 1133: @23122
    GIM_Reject,
    // Label 1131: @23123
    GIM_Try, /*On fail goto*//*Label 1136*/ 23168,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_Try, /*On fail goto*//*Label 1137*/ 23148, // Rule ID 65405 //
        GIM_CheckFeatures, GIFBS_HasStdExtD_IsRV64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (bitconvert:{ *:[f64] } GPR:{ *:[i64] }:$rs1)  =>  (FMV_D_X:{ *:[f64] } GPR:{ *:[i64] }:$rs1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::FMV_D_X,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 65405,
        GIR_Done,
      // Label 1137: @23148
      GIM_Try, /*On fail goto*//*Label 1138*/ 23167, // Rule ID 65406 //
        GIM_CheckFeatures, GIFBS_HasStdExtD_IsRV64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::FPR64RegClassID,
        // (bitconvert:{ *:[i64] } FPR64:{ *:[f64] }:$rs1)  =>  (FMV_X_D:{ *:[i64] } FPR64:{ *:[f64] }:$rs1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::FMV_X_D,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 65406,
        GIR_Done,
      // Label 1138: @23167
      GIM_Reject,
    // Label 1136: @23168
    GIM_Reject,
    // Label 1132: @23169
    GIM_Reject,
    // Label 11: @23170
    GIM_Try, /*On fail goto*//*Label 1139*/ 23201, // Rule ID 63162 //
      GIM_CheckFeatures, GIFBS_IsRV64,
      GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
      // (readcyclecounter:{ *:[i64] })  =>  (CSRRS:{ *:[i64] } 3072:{ *:[i64] }, X0:{ *:[i64] })
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::CSRRS,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
      GIR_AddImm, /*InsnID*/0, /*Imm*/3072,
      GIR_AddRegister, /*InsnID*/0, RISCV::X0, /*AddRegisterRegFlags*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 63162,
      GIR_Done,
    // Label 1139: @23201
    GIM_Reject,
    // Label 12: @23202
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/3, 32, /*)*//*default:*//*Label 1169*/ 25952,
    /*GILLT_nxv1s1*//*Label 1140*/ 23237,
    /*GILLT_nxv1s8*//*Label 1141*/ 23328,
    /*GILLT_nxv1s16*//*Label 1142*/ 23419,
    /*GILLT_nxv1s32*//*Label 1143*/ 23586,
    /*GILLT_nxv1s64*//*Label 1144*/ 23753,
    /*GILLT_nxv2s1*//*Label 1145*/ 23844,
    /*GILLT_nxv2s8*//*Label 1146*/ 23935,
    /*GILLT_nxv2s16*//*Label 1147*/ 24026,
    /*GILLT_nxv2s32*//*Label 1148*/ 24193,
    /*GILLT_nxv2s64*//*Label 1149*/ 24284,
    /*GILLT_nxv4s1*//*Label 1150*/ 24375,
    /*GILLT_nxv4s8*//*Label 1151*/ 24466,
    /*GILLT_nxv4s16*//*Label 1152*/ 24557,
    /*GILLT_nxv4s32*//*Label 1153*/ 24648,
    /*GILLT_nxv4s64*//*Label 1154*/ 24739,
    /*GILLT_nxv8s1*//*Label 1155*/ 24830,
    /*GILLT_nxv8s8*//*Label 1156*/ 24921,
    /*GILLT_nxv8s16*//*Label 1157*/ 24974,
    /*GILLT_nxv8s32*//*Label 1158*/ 25065,
    /*GILLT_nxv8s64*//*Label 1159*/ 25156,
    /*GILLT_nxv16s1*//*Label 1160*/ 25247,
    /*GILLT_nxv16s8*//*Label 1161*/ 25338,
    /*GILLT_nxv16s16*//*Label 1162*/ 25391,
    /*GILLT_nxv16s32*//*Label 1163*/ 25482,
    /*GILLT_nxv32s1*//*Label 1164*/ 25573,
    /*GILLT_nxv32s8*//*Label 1165*/ 25664,
    /*GILLT_nxv32s16*//*Label 1166*/ 25717,
    /*GILLT_nxv64s1*//*Label 1167*/ 25808,
    /*GILLT_nxv64s8*//*Label 1168*/ 25899,
    // Label 1140: @23237
    GIM_Try, /*On fail goto*//*Label 1170*/ 23327,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 1171*/ 23288, // Rule ID 54933 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (ld:{ *:[nxv1i1] } GPR:{ *:[i64] }:$rs1)<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (PseudoVLM_V_B1:{ *:[nxv1i1] } GPR:{ *:[i64] }:$rs1, -1:{ *:[i64] }, 0:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVLM_V_B1,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 54933,
        GIR_Done,
      // Label 1171: @23288
      GIM_Try, /*On fail goto*//*Label 1172*/ 23326, // Rule ID 54934 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (ld:{ *:[nxv1i1] } GPR:{ *:[i32] }:$rs1)<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (PseudoVLM_V_B1:{ *:[nxv1i1] } GPR:{ *:[i32] }:$rs1, -1:{ *:[i32] }, 0:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVLM_V_B1,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 54934,
        GIR_Done,
      // Label 1172: @23326
      GIM_Reject,
    // Label 1170: @23327
    GIM_Reject,
    // Label 1141: @23328
    GIM_Try, /*On fail goto*//*Label 1173*/ 23418,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 1174*/ 23379, // Rule ID 54925 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (ld:{ *:[nxv1i8] } GPR:{ *:[i64] }:$rs1)<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (PseudoVLE8_V_MF8:{ *:[nxv1i8] } GPR:{ *:[i64] }:$rs1, -1:{ *:[i64] }, 3:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVLE8_V_MF8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 54925,
        GIR_Done,
      // Label 1174: @23379
      GIM_Try, /*On fail goto*//*Label 1175*/ 23417, // Rule ID 54926 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (ld:{ *:[nxv1i8] } GPR:{ *:[i32] }:$rs1)<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (PseudoVLE8_V_MF8:{ *:[nxv1i8] } GPR:{ *:[i32] }:$rs1, -1:{ *:[i32] }, 3:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVLE8_V_MF8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 54926,
        GIR_Done,
      // Label 1175: @23417
      GIM_Reject,
    // Label 1173: @23418
    GIM_Reject,
    // Label 1142: @23419
    GIM_Try, /*On fail goto*//*Label 1176*/ 23585,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 1177*/ 23470, // Rule ID 55053 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (ld:{ *:[nxv1i16] } GPR:{ *:[i64] }:$rs1)<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (PseudoVLE16_V_MF4:{ *:[nxv1i16] } GPR:{ *:[i64] }:$rs1, -1:{ *:[i64] }, 4:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVLE16_V_MF4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 55053,
        GIR_Done,
      // Label 1177: @23470
      GIM_Try, /*On fail goto*//*Label 1178*/ 23508, // Rule ID 55054 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (ld:{ *:[nxv1i16] } GPR:{ *:[i32] }:$rs1)<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (PseudoVLE16_V_MF4:{ *:[nxv1i16] } GPR:{ *:[i32] }:$rs1, -1:{ *:[i32] }, 4:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVLE16_V_MF4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 55054,
        GIR_Done,
      // Label 1178: @23508
      GIM_Try, /*On fail goto*//*Label 1179*/ 23546, // Rule ID 55065 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (ld:{ *:[nxv1f16] } GPR:{ *:[i64] }:$rs1)<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (PseudoVLE16_V_MF4:{ *:[nxv1f16] } GPR:{ *:[i64] }:$rs1, -1:{ *:[i64] }, 4:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVLE16_V_MF4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 55065,
        GIR_Done,
      // Label 1179: @23546
      GIM_Try, /*On fail goto*//*Label 1180*/ 23584, // Rule ID 55066 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (ld:{ *:[nxv1f16] } GPR:{ *:[i32] }:$rs1)<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (PseudoVLE16_V_MF4:{ *:[nxv1f16] } GPR:{ *:[i32] }:$rs1, -1:{ *:[i32] }, 4:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVLE16_V_MF4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 55066,
        GIR_Done,
      // Label 1180: @23584
      GIM_Reject,
    // Label 1176: @23585
    GIM_Reject,
    // Label 1143: @23586
    GIM_Try, /*On fail goto*//*Label 1181*/ 23752,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 1182*/ 23637, // Rule ID 55061 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (ld:{ *:[nxv1i32] } GPR:{ *:[i64] }:$rs1)<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (PseudoVLE32_V_MF2:{ *:[nxv1i32] } GPR:{ *:[i64] }:$rs1, -1:{ *:[i64] }, 5:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVLE32_V_MF2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 55061,
        GIR_Done,
      // Label 1182: @23637
      GIM_Try, /*On fail goto*//*Label 1183*/ 23675, // Rule ID 55062 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (ld:{ *:[nxv1i32] } GPR:{ *:[i32] }:$rs1)<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (PseudoVLE32_V_MF2:{ *:[nxv1i32] } GPR:{ *:[i32] }:$rs1, -1:{ *:[i32] }, 5:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVLE32_V_MF2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 55062,
        GIR_Done,
      // Label 1183: @23675
      GIM_Try, /*On fail goto*//*Label 1184*/ 23713, // Rule ID 55073 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (ld:{ *:[nxv1f32] } GPR:{ *:[i64] }:$rs1)<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (PseudoVLE32_V_MF2:{ *:[nxv1f32] } GPR:{ *:[i64] }:$rs1, -1:{ *:[i64] }, 5:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVLE32_V_MF2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 55073,
        GIR_Done,
      // Label 1184: @23713
      GIM_Try, /*On fail goto*//*Label 1185*/ 23751, // Rule ID 55074 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (ld:{ *:[nxv1f32] } GPR:{ *:[i32] }:$rs1)<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (PseudoVLE32_V_MF2:{ *:[nxv1f32] } GPR:{ *:[i32] }:$rs1, -1:{ *:[i32] }, 5:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVLE32_V_MF2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 55074,
        GIR_Done,
      // Label 1185: @23751
      GIM_Reject,
    // Label 1181: @23752
    GIM_Reject,
    // Label 1144: @23753
    GIM_Try, /*On fail goto*//*Label 1186*/ 23843,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 1187*/ 23785, // Rule ID 55085 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (ld:{ *:[nxv1i64] } GPR:{ *:[i64] }:$rs1)<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (VL1RE64_V:{ *:[nxv1i64] } GPR:{ *:[i64] }:$rs1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::VL1RE64_V,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 55085,
        GIR_Done,
      // Label 1187: @23785
      GIM_Try, /*On fail goto*//*Label 1188*/ 23804, // Rule ID 55086 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (ld:{ *:[nxv1i64] } GPR:{ *:[i32] }:$rs1)<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (VL1RE64_V:{ *:[nxv1i64] } GPR:{ *:[i32] }:$rs1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::VL1RE64_V,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 55086,
        GIR_Done,
      // Label 1188: @23804
      GIM_Try, /*On fail goto*//*Label 1189*/ 23823, // Rule ID 55097 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (ld:{ *:[nxv1f64] } GPR:{ *:[i64] }:$rs1)<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (VL1RE64_V:{ *:[nxv1f64] } GPR:{ *:[i64] }:$rs1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::VL1RE64_V,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 55097,
        GIR_Done,
      // Label 1189: @23823
      GIM_Try, /*On fail goto*//*Label 1190*/ 23842, // Rule ID 55098 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (ld:{ *:[nxv1f64] } GPR:{ *:[i32] }:$rs1)<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (VL1RE64_V:{ *:[nxv1f64] } GPR:{ *:[i32] }:$rs1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::VL1RE64_V,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 55098,
        GIR_Done,
      // Label 1190: @23842
      GIM_Reject,
    // Label 1186: @23843
    GIM_Reject,
    // Label 1145: @23844
    GIM_Try, /*On fail goto*//*Label 1191*/ 23934,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 1192*/ 23895, // Rule ID 55185 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (ld:{ *:[nxv2i1] } GPR:{ *:[i64] }:$rs1)<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (PseudoVLM_V_B2:{ *:[nxv2i1] } GPR:{ *:[i64] }:$rs1, -1:{ *:[i64] }, 0:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVLM_V_B2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 55185,
        GIR_Done,
      // Label 1192: @23895
      GIM_Try, /*On fail goto*//*Label 1193*/ 23933, // Rule ID 55186 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (ld:{ *:[nxv2i1] } GPR:{ *:[i32] }:$rs1)<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (PseudoVLM_V_B2:{ *:[nxv2i1] } GPR:{ *:[i32] }:$rs1, -1:{ *:[i32] }, 0:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVLM_V_B2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 55186,
        GIR_Done,
      // Label 1193: @23933
      GIM_Reject,
    // Label 1191: @23934
    GIM_Reject,
    // Label 1146: @23935
    GIM_Try, /*On fail goto*//*Label 1194*/ 24025,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 1195*/ 23986, // Rule ID 55045 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (ld:{ *:[nxv2i8] } GPR:{ *:[i64] }:$rs1)<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (PseudoVLE8_V_MF4:{ *:[nxv2i8] } GPR:{ *:[i64] }:$rs1, -1:{ *:[i64] }, 3:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVLE8_V_MF4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 55045,
        GIR_Done,
      // Label 1195: @23986
      GIM_Try, /*On fail goto*//*Label 1196*/ 24024, // Rule ID 55046 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (ld:{ *:[nxv2i8] } GPR:{ *:[i32] }:$rs1)<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (PseudoVLE8_V_MF4:{ *:[nxv2i8] } GPR:{ *:[i32] }:$rs1, -1:{ *:[i32] }, 3:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVLE8_V_MF4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 55046,
        GIR_Done,
      // Label 1196: @24024
      GIM_Reject,
    // Label 1194: @24025
    GIM_Reject,
    // Label 1147: @24026
    GIM_Try, /*On fail goto*//*Label 1197*/ 24192,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 1198*/ 24077, // Rule ID 55057 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (ld:{ *:[nxv2i16] } GPR:{ *:[i64] }:$rs1)<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (PseudoVLE16_V_MF2:{ *:[nxv2i16] } GPR:{ *:[i64] }:$rs1, -1:{ *:[i64] }, 4:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVLE16_V_MF2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 55057,
        GIR_Done,
      // Label 1198: @24077
      GIM_Try, /*On fail goto*//*Label 1199*/ 24115, // Rule ID 55058 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (ld:{ *:[nxv2i16] } GPR:{ *:[i32] }:$rs1)<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (PseudoVLE16_V_MF2:{ *:[nxv2i16] } GPR:{ *:[i32] }:$rs1, -1:{ *:[i32] }, 4:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVLE16_V_MF2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 55058,
        GIR_Done,
      // Label 1199: @24115
      GIM_Try, /*On fail goto*//*Label 1200*/ 24153, // Rule ID 55069 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (ld:{ *:[nxv2f16] } GPR:{ *:[i64] }:$rs1)<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (PseudoVLE16_V_MF2:{ *:[nxv2f16] } GPR:{ *:[i64] }:$rs1, -1:{ *:[i64] }, 4:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVLE16_V_MF2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 55069,
        GIR_Done,
      // Label 1200: @24153
      GIM_Try, /*On fail goto*//*Label 1201*/ 24191, // Rule ID 55070 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (ld:{ *:[nxv2f16] } GPR:{ *:[i32] }:$rs1)<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (PseudoVLE16_V_MF2:{ *:[nxv2f16] } GPR:{ *:[i32] }:$rs1, -1:{ *:[i32] }, 4:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVLE16_V_MF2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 55070,
        GIR_Done,
      // Label 1201: @24191
      GIM_Reject,
    // Label 1197: @24192
    GIM_Reject,
    // Label 1148: @24193
    GIM_Try, /*On fail goto*//*Label 1202*/ 24283,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 1203*/ 24225, // Rule ID 55081 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (ld:{ *:[nxv2i32] } GPR:{ *:[i64] }:$rs1)<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (VL1RE32_V:{ *:[nxv2i32] } GPR:{ *:[i64] }:$rs1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::VL1RE32_V,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 55081,
        GIR_Done,
      // Label 1203: @24225
      GIM_Try, /*On fail goto*//*Label 1204*/ 24244, // Rule ID 55082 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (ld:{ *:[nxv2i32] } GPR:{ *:[i32] }:$rs1)<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (VL1RE32_V:{ *:[nxv2i32] } GPR:{ *:[i32] }:$rs1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::VL1RE32_V,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 55082,
        GIR_Done,
      // Label 1204: @24244
      GIM_Try, /*On fail goto*//*Label 1205*/ 24263, // Rule ID 55093 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (ld:{ *:[nxv2f32] } GPR:{ *:[i64] }:$rs1)<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (VL1RE32_V:{ *:[nxv2f32] } GPR:{ *:[i64] }:$rs1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::VL1RE32_V,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 55093,
        GIR_Done,
      // Label 1205: @24263
      GIM_Try, /*On fail goto*//*Label 1206*/ 24282, // Rule ID 55094 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (ld:{ *:[nxv2f32] } GPR:{ *:[i32] }:$rs1)<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (VL1RE32_V:{ *:[nxv2f32] } GPR:{ *:[i32] }:$rs1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::VL1RE32_V,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 55094,
        GIR_Done,
      // Label 1206: @24282
      GIM_Reject,
    // Label 1202: @24283
    GIM_Reject,
    // Label 1149: @24284
    GIM_Try, /*On fail goto*//*Label 1207*/ 24374,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM2RegClassID,
      GIM_Try, /*On fail goto*//*Label 1208*/ 24316, // Rule ID 55137 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (ld:{ *:[nxv2i64] } GPR:{ *:[i64] }:$rs1)<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (VL2RE64_V:{ *:[nxv2i64] } GPR:{ *:[i64] }:$rs1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::VL2RE64_V,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 55137,
        GIR_Done,
      // Label 1208: @24316
      GIM_Try, /*On fail goto*//*Label 1209*/ 24335, // Rule ID 55138 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (ld:{ *:[nxv2i64] } GPR:{ *:[i32] }:$rs1)<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (VL2RE64_V:{ *:[nxv2i64] } GPR:{ *:[i32] }:$rs1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::VL2RE64_V,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 55138,
        GIR_Done,
      // Label 1209: @24335
      GIM_Try, /*On fail goto*//*Label 1210*/ 24354, // Rule ID 55173 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (ld:{ *:[nxv2f64] } GPR:{ *:[i64] }:$rs1)<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (VL2RE64_V:{ *:[nxv2f64] } GPR:{ *:[i64] }:$rs1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::VL2RE64_V,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 55173,
        GIR_Done,
      // Label 1210: @24354
      GIM_Try, /*On fail goto*//*Label 1211*/ 24373, // Rule ID 55174 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (ld:{ *:[nxv2f64] } GPR:{ *:[i32] }:$rs1)<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (VL2RE64_V:{ *:[nxv2f64] } GPR:{ *:[i32] }:$rs1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::VL2RE64_V,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 55174,
        GIR_Done,
      // Label 1211: @24373
      GIM_Reject,
    // Label 1207: @24374
    GIM_Reject,
    // Label 1150: @24375
    GIM_Try, /*On fail goto*//*Label 1212*/ 24465,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 1213*/ 24426, // Rule ID 55189 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (ld:{ *:[nxv4i1] } GPR:{ *:[i64] }:$rs1)<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (PseudoVLM_V_B4:{ *:[nxv4i1] } GPR:{ *:[i64] }:$rs1, -1:{ *:[i64] }, 0:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVLM_V_B4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 55189,
        GIR_Done,
      // Label 1213: @24426
      GIM_Try, /*On fail goto*//*Label 1214*/ 24464, // Rule ID 55190 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (ld:{ *:[nxv4i1] } GPR:{ *:[i32] }:$rs1)<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (PseudoVLM_V_B4:{ *:[nxv4i1] } GPR:{ *:[i32] }:$rs1, -1:{ *:[i32] }, 0:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVLM_V_B4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 55190,
        GIR_Done,
      // Label 1214: @24464
      GIM_Reject,
    // Label 1212: @24465
    GIM_Reject,
    // Label 1151: @24466
    GIM_Try, /*On fail goto*//*Label 1215*/ 24556,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 1216*/ 24517, // Rule ID 55049 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (ld:{ *:[nxv4i8] } GPR:{ *:[i64] }:$rs1)<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (PseudoVLE8_V_MF2:{ *:[nxv4i8] } GPR:{ *:[i64] }:$rs1, -1:{ *:[i64] }, 3:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVLE8_V_MF2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 55049,
        GIR_Done,
      // Label 1216: @24517
      GIM_Try, /*On fail goto*//*Label 1217*/ 24555, // Rule ID 55050 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (ld:{ *:[nxv4i8] } GPR:{ *:[i32] }:$rs1)<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (PseudoVLE8_V_MF2:{ *:[nxv4i8] } GPR:{ *:[i32] }:$rs1, -1:{ *:[i32] }, 3:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVLE8_V_MF2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 55050,
        GIR_Done,
      // Label 1217: @24555
      GIM_Reject,
    // Label 1215: @24556
    GIM_Reject,
    // Label 1152: @24557
    GIM_Try, /*On fail goto*//*Label 1218*/ 24647,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 1219*/ 24589, // Rule ID 55077 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (ld:{ *:[nxv4i16] } GPR:{ *:[i64] }:$rs1)<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (VL1RE16_V:{ *:[nxv4i16] } GPR:{ *:[i64] }:$rs1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::VL1RE16_V,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 55077,
        GIR_Done,
      // Label 1219: @24589
      GIM_Try, /*On fail goto*//*Label 1220*/ 24608, // Rule ID 55078 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (ld:{ *:[nxv4i16] } GPR:{ *:[i32] }:$rs1)<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (VL1RE16_V:{ *:[nxv4i16] } GPR:{ *:[i32] }:$rs1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::VL1RE16_V,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 55078,
        GIR_Done,
      // Label 1220: @24608
      GIM_Try, /*On fail goto*//*Label 1221*/ 24627, // Rule ID 55089 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (ld:{ *:[nxv4f16] } GPR:{ *:[i64] }:$rs1)<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (VL1RE16_V:{ *:[nxv4f16] } GPR:{ *:[i64] }:$rs1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::VL1RE16_V,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 55089,
        GIR_Done,
      // Label 1221: @24627
      GIM_Try, /*On fail goto*//*Label 1222*/ 24646, // Rule ID 55090 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (ld:{ *:[nxv4f16] } GPR:{ *:[i32] }:$rs1)<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (VL1RE16_V:{ *:[nxv4f16] } GPR:{ *:[i32] }:$rs1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::VL1RE16_V,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 55090,
        GIR_Done,
      // Label 1222: @24646
      GIM_Reject,
    // Label 1218: @24647
    GIM_Reject,
    // Label 1153: @24648
    GIM_Try, /*On fail goto*//*Label 1223*/ 24738,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM2RegClassID,
      GIM_Try, /*On fail goto*//*Label 1224*/ 24680, // Rule ID 55125 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (ld:{ *:[nxv4i32] } GPR:{ *:[i64] }:$rs1)<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (VL2RE32_V:{ *:[nxv4i32] } GPR:{ *:[i64] }:$rs1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::VL2RE32_V,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 55125,
        GIR_Done,
      // Label 1224: @24680
      GIM_Try, /*On fail goto*//*Label 1225*/ 24699, // Rule ID 55126 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (ld:{ *:[nxv4i32] } GPR:{ *:[i32] }:$rs1)<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (VL2RE32_V:{ *:[nxv4i32] } GPR:{ *:[i32] }:$rs1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::VL2RE32_V,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 55126,
        GIR_Done,
      // Label 1225: @24699
      GIM_Try, /*On fail goto*//*Label 1226*/ 24718, // Rule ID 55161 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (ld:{ *:[nxv4f32] } GPR:{ *:[i64] }:$rs1)<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (VL2RE32_V:{ *:[nxv4f32] } GPR:{ *:[i64] }:$rs1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::VL2RE32_V,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 55161,
        GIR_Done,
      // Label 1226: @24718
      GIM_Try, /*On fail goto*//*Label 1227*/ 24737, // Rule ID 55162 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (ld:{ *:[nxv4f32] } GPR:{ *:[i32] }:$rs1)<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (VL2RE32_V:{ *:[nxv4f32] } GPR:{ *:[i32] }:$rs1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::VL2RE32_V,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 55162,
        GIR_Done,
      // Label 1227: @24737
      GIM_Reject,
    // Label 1223: @24738
    GIM_Reject,
    // Label 1154: @24739
    GIM_Try, /*On fail goto*//*Label 1228*/ 24829,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM4RegClassID,
      GIM_Try, /*On fail goto*//*Label 1229*/ 24771, // Rule ID 55141 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (ld:{ *:[nxv4i64] } GPR:{ *:[i64] }:$rs1)<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (VL4RE64_V:{ *:[nxv4i64] } GPR:{ *:[i64] }:$rs1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::VL4RE64_V,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 55141,
        GIR_Done,
      // Label 1229: @24771
      GIM_Try, /*On fail goto*//*Label 1230*/ 24790, // Rule ID 55142 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (ld:{ *:[nxv4i64] } GPR:{ *:[i32] }:$rs1)<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (VL4RE64_V:{ *:[nxv4i64] } GPR:{ *:[i32] }:$rs1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::VL4RE64_V,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 55142,
        GIR_Done,
      // Label 1230: @24790
      GIM_Try, /*On fail goto*//*Label 1231*/ 24809, // Rule ID 55177 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (ld:{ *:[nxv4f64] } GPR:{ *:[i64] }:$rs1)<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (VL4RE64_V:{ *:[nxv4f64] } GPR:{ *:[i64] }:$rs1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::VL4RE64_V,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 55177,
        GIR_Done,
      // Label 1231: @24809
      GIM_Try, /*On fail goto*//*Label 1232*/ 24828, // Rule ID 55178 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (ld:{ *:[nxv4f64] } GPR:{ *:[i32] }:$rs1)<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (VL4RE64_V:{ *:[nxv4f64] } GPR:{ *:[i32] }:$rs1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::VL4RE64_V,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 55178,
        GIR_Done,
      // Label 1232: @24828
      GIM_Reject,
    // Label 1228: @24829
    GIM_Reject,
    // Label 1155: @24830
    GIM_Try, /*On fail goto*//*Label 1233*/ 24920,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 1234*/ 24881, // Rule ID 55193 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (ld:{ *:[nxv8i1] } GPR:{ *:[i64] }:$rs1)<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (PseudoVLM_V_B8:{ *:[nxv8i1] } GPR:{ *:[i64] }:$rs1, -1:{ *:[i64] }, 0:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVLM_V_B8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 55193,
        GIR_Done,
      // Label 1234: @24881
      GIM_Try, /*On fail goto*//*Label 1235*/ 24919, // Rule ID 55194 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (ld:{ *:[nxv8i1] } GPR:{ *:[i32] }:$rs1)<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (PseudoVLM_V_B8:{ *:[nxv8i1] } GPR:{ *:[i32] }:$rs1, -1:{ *:[i32] }, 0:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVLM_V_B8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 55194,
        GIR_Done,
      // Label 1235: @24919
      GIM_Reject,
    // Label 1233: @24920
    GIM_Reject,
    // Label 1156: @24921
    GIM_Try, /*On fail goto*//*Label 1236*/ 24973,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 1237*/ 24953, // Rule ID 54929 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (ld:{ *:[nxv8i8] } GPR:{ *:[i64] }:$rs1)<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (VL1RE8_V:{ *:[nxv8i8] } GPR:{ *:[i64] }:$rs1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::VL1RE8_V,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 54929,
        GIR_Done,
      // Label 1237: @24953
      GIM_Try, /*On fail goto*//*Label 1238*/ 24972, // Rule ID 54930 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (ld:{ *:[nxv8i8] } GPR:{ *:[i32] }:$rs1)<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (VL1RE8_V:{ *:[nxv8i8] } GPR:{ *:[i32] }:$rs1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::VL1RE8_V,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 54930,
        GIR_Done,
      // Label 1238: @24972
      GIM_Reject,
    // Label 1236: @24973
    GIM_Reject,
    // Label 1157: @24974
    GIM_Try, /*On fail goto*//*Label 1239*/ 25064,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM2RegClassID,
      GIM_Try, /*On fail goto*//*Label 1240*/ 25006, // Rule ID 55113 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (ld:{ *:[nxv8i16] } GPR:{ *:[i64] }:$rs1)<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (VL2RE16_V:{ *:[nxv8i16] } GPR:{ *:[i64] }:$rs1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::VL2RE16_V,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 55113,
        GIR_Done,
      // Label 1240: @25006
      GIM_Try, /*On fail goto*//*Label 1241*/ 25025, // Rule ID 55114 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (ld:{ *:[nxv8i16] } GPR:{ *:[i32] }:$rs1)<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (VL2RE16_V:{ *:[nxv8i16] } GPR:{ *:[i32] }:$rs1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::VL2RE16_V,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 55114,
        GIR_Done,
      // Label 1241: @25025
      GIM_Try, /*On fail goto*//*Label 1242*/ 25044, // Rule ID 55149 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (ld:{ *:[nxv8f16] } GPR:{ *:[i64] }:$rs1)<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (VL2RE16_V:{ *:[nxv8f16] } GPR:{ *:[i64] }:$rs1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::VL2RE16_V,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 55149,
        GIR_Done,
      // Label 1242: @25044
      GIM_Try, /*On fail goto*//*Label 1243*/ 25063, // Rule ID 55150 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (ld:{ *:[nxv8f16] } GPR:{ *:[i32] }:$rs1)<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (VL2RE16_V:{ *:[nxv8f16] } GPR:{ *:[i32] }:$rs1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::VL2RE16_V,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 55150,
        GIR_Done,
      // Label 1243: @25063
      GIM_Reject,
    // Label 1239: @25064
    GIM_Reject,
    // Label 1158: @25065
    GIM_Try, /*On fail goto*//*Label 1244*/ 25155,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM4RegClassID,
      GIM_Try, /*On fail goto*//*Label 1245*/ 25097, // Rule ID 55129 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (ld:{ *:[nxv8i32] } GPR:{ *:[i64] }:$rs1)<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (VL4RE32_V:{ *:[nxv8i32] } GPR:{ *:[i64] }:$rs1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::VL4RE32_V,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 55129,
        GIR_Done,
      // Label 1245: @25097
      GIM_Try, /*On fail goto*//*Label 1246*/ 25116, // Rule ID 55130 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (ld:{ *:[nxv8i32] } GPR:{ *:[i32] }:$rs1)<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (VL4RE32_V:{ *:[nxv8i32] } GPR:{ *:[i32] }:$rs1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::VL4RE32_V,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 55130,
        GIR_Done,
      // Label 1246: @25116
      GIM_Try, /*On fail goto*//*Label 1247*/ 25135, // Rule ID 55165 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (ld:{ *:[nxv8f32] } GPR:{ *:[i64] }:$rs1)<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (VL4RE32_V:{ *:[nxv8f32] } GPR:{ *:[i64] }:$rs1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::VL4RE32_V,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 55165,
        GIR_Done,
      // Label 1247: @25135
      GIM_Try, /*On fail goto*//*Label 1248*/ 25154, // Rule ID 55166 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (ld:{ *:[nxv8f32] } GPR:{ *:[i32] }:$rs1)<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (VL4RE32_V:{ *:[nxv8f32] } GPR:{ *:[i32] }:$rs1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::VL4RE32_V,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 55166,
        GIR_Done,
      // Label 1248: @25154
      GIM_Reject,
    // Label 1244: @25155
    GIM_Reject,
    // Label 1159: @25156
    GIM_Try, /*On fail goto*//*Label 1249*/ 25246,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM8RegClassID,
      GIM_Try, /*On fail goto*//*Label 1250*/ 25188, // Rule ID 55145 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (ld:{ *:[nxv8i64] } GPR:{ *:[i64] }:$rs1)<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (VL8RE64_V:{ *:[nxv8i64] } GPR:{ *:[i64] }:$rs1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::VL8RE64_V,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 55145,
        GIR_Done,
      // Label 1250: @25188
      GIM_Try, /*On fail goto*//*Label 1251*/ 25207, // Rule ID 55146 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (ld:{ *:[nxv8i64] } GPR:{ *:[i32] }:$rs1)<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (VL8RE64_V:{ *:[nxv8i64] } GPR:{ *:[i32] }:$rs1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::VL8RE64_V,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 55146,
        GIR_Done,
      // Label 1251: @25207
      GIM_Try, /*On fail goto*//*Label 1252*/ 25226, // Rule ID 55181 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (ld:{ *:[nxv8f64] } GPR:{ *:[i64] }:$rs1)<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (VL8RE64_V:{ *:[nxv8f64] } GPR:{ *:[i64] }:$rs1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::VL8RE64_V,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 55181,
        GIR_Done,
      // Label 1252: @25226
      GIM_Try, /*On fail goto*//*Label 1253*/ 25245, // Rule ID 55182 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (ld:{ *:[nxv8f64] } GPR:{ *:[i32] }:$rs1)<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (VL8RE64_V:{ *:[nxv8f64] } GPR:{ *:[i32] }:$rs1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::VL8RE64_V,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 55182,
        GIR_Done,
      // Label 1253: @25245
      GIM_Reject,
    // Label 1249: @25246
    GIM_Reject,
    // Label 1160: @25247
    GIM_Try, /*On fail goto*//*Label 1254*/ 25337,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 1255*/ 25298, // Rule ID 55197 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (ld:{ *:[nxv16i1] } GPR:{ *:[i64] }:$rs1)<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (PseudoVLM_V_B16:{ *:[nxv16i1] } GPR:{ *:[i64] }:$rs1, -1:{ *:[i64] }, 0:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVLM_V_B16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 55197,
        GIR_Done,
      // Label 1255: @25298
      GIM_Try, /*On fail goto*//*Label 1256*/ 25336, // Rule ID 55198 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (ld:{ *:[nxv16i1] } GPR:{ *:[i32] }:$rs1)<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (PseudoVLM_V_B16:{ *:[nxv16i1] } GPR:{ *:[i32] }:$rs1, -1:{ *:[i32] }, 0:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVLM_V_B16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 55198,
        GIR_Done,
      // Label 1256: @25336
      GIM_Reject,
    // Label 1254: @25337
    GIM_Reject,
    // Label 1161: @25338
    GIM_Try, /*On fail goto*//*Label 1257*/ 25390,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM2RegClassID,
      GIM_Try, /*On fail goto*//*Label 1258*/ 25370, // Rule ID 55101 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (ld:{ *:[nxv16i8] } GPR:{ *:[i64] }:$rs1)<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (VL2RE8_V:{ *:[nxv16i8] } GPR:{ *:[i64] }:$rs1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::VL2RE8_V,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 55101,
        GIR_Done,
      // Label 1258: @25370
      GIM_Try, /*On fail goto*//*Label 1259*/ 25389, // Rule ID 55102 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (ld:{ *:[nxv16i8] } GPR:{ *:[i32] }:$rs1)<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (VL2RE8_V:{ *:[nxv16i8] } GPR:{ *:[i32] }:$rs1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::VL2RE8_V,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 55102,
        GIR_Done,
      // Label 1259: @25389
      GIM_Reject,
    // Label 1257: @25390
    GIM_Reject,
    // Label 1162: @25391
    GIM_Try, /*On fail goto*//*Label 1260*/ 25481,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM4RegClassID,
      GIM_Try, /*On fail goto*//*Label 1261*/ 25423, // Rule ID 55117 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (ld:{ *:[nxv16i16] } GPR:{ *:[i64] }:$rs1)<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (VL4RE16_V:{ *:[nxv16i16] } GPR:{ *:[i64] }:$rs1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::VL4RE16_V,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 55117,
        GIR_Done,
      // Label 1261: @25423
      GIM_Try, /*On fail goto*//*Label 1262*/ 25442, // Rule ID 55118 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (ld:{ *:[nxv16i16] } GPR:{ *:[i32] }:$rs1)<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (VL4RE16_V:{ *:[nxv16i16] } GPR:{ *:[i32] }:$rs1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::VL4RE16_V,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 55118,
        GIR_Done,
      // Label 1262: @25442
      GIM_Try, /*On fail goto*//*Label 1263*/ 25461, // Rule ID 55153 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (ld:{ *:[nxv16f16] } GPR:{ *:[i64] }:$rs1)<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (VL4RE16_V:{ *:[nxv16f16] } GPR:{ *:[i64] }:$rs1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::VL4RE16_V,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 55153,
        GIR_Done,
      // Label 1263: @25461
      GIM_Try, /*On fail goto*//*Label 1264*/ 25480, // Rule ID 55154 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (ld:{ *:[nxv16f16] } GPR:{ *:[i32] }:$rs1)<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (VL4RE16_V:{ *:[nxv16f16] } GPR:{ *:[i32] }:$rs1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::VL4RE16_V,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 55154,
        GIR_Done,
      // Label 1264: @25480
      GIM_Reject,
    // Label 1260: @25481
    GIM_Reject,
    // Label 1163: @25482
    GIM_Try, /*On fail goto*//*Label 1265*/ 25572,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM8RegClassID,
      GIM_Try, /*On fail goto*//*Label 1266*/ 25514, // Rule ID 55133 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (ld:{ *:[nxv16i32] } GPR:{ *:[i64] }:$rs1)<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (VL8RE32_V:{ *:[nxv16i32] } GPR:{ *:[i64] }:$rs1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::VL8RE32_V,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 55133,
        GIR_Done,
      // Label 1266: @25514
      GIM_Try, /*On fail goto*//*Label 1267*/ 25533, // Rule ID 55134 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (ld:{ *:[nxv16i32] } GPR:{ *:[i32] }:$rs1)<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (VL8RE32_V:{ *:[nxv16i32] } GPR:{ *:[i32] }:$rs1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::VL8RE32_V,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 55134,
        GIR_Done,
      // Label 1267: @25533
      GIM_Try, /*On fail goto*//*Label 1268*/ 25552, // Rule ID 55169 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (ld:{ *:[nxv16f32] } GPR:{ *:[i64] }:$rs1)<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (VL8RE32_V:{ *:[nxv16f32] } GPR:{ *:[i64] }:$rs1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::VL8RE32_V,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 55169,
        GIR_Done,
      // Label 1268: @25552
      GIM_Try, /*On fail goto*//*Label 1269*/ 25571, // Rule ID 55170 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (ld:{ *:[nxv16f32] } GPR:{ *:[i32] }:$rs1)<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (VL8RE32_V:{ *:[nxv16f32] } GPR:{ *:[i32] }:$rs1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::VL8RE32_V,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 55170,
        GIR_Done,
      // Label 1269: @25571
      GIM_Reject,
    // Label 1265: @25572
    GIM_Reject,
    // Label 1164: @25573
    GIM_Try, /*On fail goto*//*Label 1270*/ 25663,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 1271*/ 25624, // Rule ID 55201 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (ld:{ *:[nxv32i1] } GPR:{ *:[i64] }:$rs1)<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (PseudoVLM_V_B32:{ *:[nxv32i1] } GPR:{ *:[i64] }:$rs1, -1:{ *:[i64] }, 0:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVLM_V_B32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 55201,
        GIR_Done,
      // Label 1271: @25624
      GIM_Try, /*On fail goto*//*Label 1272*/ 25662, // Rule ID 55202 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (ld:{ *:[nxv32i1] } GPR:{ *:[i32] }:$rs1)<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (PseudoVLM_V_B32:{ *:[nxv32i1] } GPR:{ *:[i32] }:$rs1, -1:{ *:[i32] }, 0:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVLM_V_B32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 55202,
        GIR_Done,
      // Label 1272: @25662
      GIM_Reject,
    // Label 1270: @25663
    GIM_Reject,
    // Label 1165: @25664
    GIM_Try, /*On fail goto*//*Label 1273*/ 25716,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM4RegClassID,
      GIM_Try, /*On fail goto*//*Label 1274*/ 25696, // Rule ID 55105 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (ld:{ *:[nxv32i8] } GPR:{ *:[i64] }:$rs1)<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (VL4RE8_V:{ *:[nxv32i8] } GPR:{ *:[i64] }:$rs1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::VL4RE8_V,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 55105,
        GIR_Done,
      // Label 1274: @25696
      GIM_Try, /*On fail goto*//*Label 1275*/ 25715, // Rule ID 55106 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (ld:{ *:[nxv32i8] } GPR:{ *:[i32] }:$rs1)<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (VL4RE8_V:{ *:[nxv32i8] } GPR:{ *:[i32] }:$rs1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::VL4RE8_V,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 55106,
        GIR_Done,
      // Label 1275: @25715
      GIM_Reject,
    // Label 1273: @25716
    GIM_Reject,
    // Label 1166: @25717
    GIM_Try, /*On fail goto*//*Label 1276*/ 25807,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM8RegClassID,
      GIM_Try, /*On fail goto*//*Label 1277*/ 25749, // Rule ID 55121 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (ld:{ *:[nxv32i16] } GPR:{ *:[i64] }:$rs1)<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (VL8RE16_V:{ *:[nxv32i16] } GPR:{ *:[i64] }:$rs1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::VL8RE16_V,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 55121,
        GIR_Done,
      // Label 1277: @25749
      GIM_Try, /*On fail goto*//*Label 1278*/ 25768, // Rule ID 55122 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (ld:{ *:[nxv32i16] } GPR:{ *:[i32] }:$rs1)<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (VL8RE16_V:{ *:[nxv32i16] } GPR:{ *:[i32] }:$rs1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::VL8RE16_V,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 55122,
        GIR_Done,
      // Label 1278: @25768
      GIM_Try, /*On fail goto*//*Label 1279*/ 25787, // Rule ID 55157 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (ld:{ *:[nxv32f16] } GPR:{ *:[i64] }:$rs1)<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (VL8RE16_V:{ *:[nxv32f16] } GPR:{ *:[i64] }:$rs1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::VL8RE16_V,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 55157,
        GIR_Done,
      // Label 1279: @25787
      GIM_Try, /*On fail goto*//*Label 1280*/ 25806, // Rule ID 55158 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (ld:{ *:[nxv32f16] } GPR:{ *:[i32] }:$rs1)<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (VL8RE16_V:{ *:[nxv32f16] } GPR:{ *:[i32] }:$rs1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::VL8RE16_V,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 55158,
        GIR_Done,
      // Label 1280: @25806
      GIM_Reject,
    // Label 1276: @25807
    GIM_Reject,
    // Label 1167: @25808
    GIM_Try, /*On fail goto*//*Label 1281*/ 25898,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRRegClassID,
      GIM_Try, /*On fail goto*//*Label 1282*/ 25859, // Rule ID 55205 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (ld:{ *:[nxv64i1] } GPR:{ *:[i64] }:$rs1)<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (PseudoVLM_V_B64:{ *:[nxv64i1] } GPR:{ *:[i64] }:$rs1, -1:{ *:[i64] }, 0:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVLM_V_B64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 55205,
        GIR_Done,
      // Label 1282: @25859
      GIM_Try, /*On fail goto*//*Label 1283*/ 25897, // Rule ID 55206 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (ld:{ *:[nxv64i1] } GPR:{ *:[i32] }:$rs1)<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (PseudoVLM_V_B64:{ *:[nxv64i1] } GPR:{ *:[i32] }:$rs1, -1:{ *:[i32] }, 0:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVLM_V_B64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 55206,
        GIR_Done,
      // Label 1283: @25897
      GIM_Reject,
    // Label 1281: @25898
    GIM_Reject,
    // Label 1168: @25899
    GIM_Try, /*On fail goto*//*Label 1284*/ 25951,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::VRM8RegClassID,
      GIM_Try, /*On fail goto*//*Label 1285*/ 25931, // Rule ID 55109 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (ld:{ *:[nxv64i8] } GPR:{ *:[i64] }:$rs1)<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (VL8RE8_V:{ *:[nxv64i8] } GPR:{ *:[i64] }:$rs1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::VL8RE8_V,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 55109,
        GIR_Done,
      // Label 1285: @25931
      GIM_Try, /*On fail goto*//*Label 1286*/ 25950, // Rule ID 55110 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (ld:{ *:[nxv64i8] } GPR:{ *:[i32] }:$rs1)<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (VL8RE8_V:{ *:[nxv64i8] } GPR:{ *:[i32] }:$rs1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::VL8RE8_V,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 55110,
        GIR_Done,
      // Label 1286: @25950
      GIM_Reject,
    // Label 1284: @25951
    GIM_Reject,
    // Label 1169: @25952
    GIM_Reject,
    // Label 13: @25953
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/3, 32, /*)*//*default:*//*Label 1316*/ 28587,
    /*GILLT_nxv1s1*//*Label 1287*/ 25988,
    /*GILLT_nxv1s8*//*Label 1288*/ 26075,
    /*GILLT_nxv1s16*//*Label 1289*/ 26162,
    /*GILLT_nxv1s32*//*Label 1290*/ 26325,
    /*GILLT_nxv1s64*//*Label 1291*/ 26488,
    /*GILLT_nxv2s1*//*Label 1292*/ 26575,
    /*GILLT_nxv2s8*//*Label 1293*/ 26662,
    /*GILLT_nxv2s16*//*Label 1294*/ 26749,
    /*GILLT_nxv2s32*//*Label 1295*/ 26912,
    /*GILLT_nxv2s64*//*Label 1296*/ 26999,
    /*GILLT_nxv4s1*//*Label 1297*/ 27086,
    /*GILLT_nxv4s8*//*Label 1298*/ 27173,
    /*GILLT_nxv4s16*//*Label 1299*/ 27260,
    /*GILLT_nxv4s32*//*Label 1300*/ 27347,
    /*GILLT_nxv4s64*//*Label 1301*/ 27434,
    /*GILLT_nxv8s1*//*Label 1302*/ 27521,
    /*GILLT_nxv8s8*//*Label 1303*/ 27608,
    /*GILLT_nxv8s16*//*Label 1304*/ 27657,
    /*GILLT_nxv8s32*//*Label 1305*/ 27744,
    /*GILLT_nxv8s64*//*Label 1306*/ 27831,
    /*GILLT_nxv16s1*//*Label 1307*/ 27918,
    /*GILLT_nxv16s8*//*Label 1308*/ 28005,
    /*GILLT_nxv16s16*//*Label 1309*/ 28054,
    /*GILLT_nxv16s32*//*Label 1310*/ 28141,
    /*GILLT_nxv32s1*//*Label 1311*/ 28228,
    /*GILLT_nxv32s8*//*Label 1312*/ 28315,
    /*GILLT_nxv32s16*//*Label 1313*/ 28364,
    /*GILLT_nxv64s1*//*Label 1314*/ 28451,
    /*GILLT_nxv64s8*//*Label 1315*/ 28538,
    // Label 1287: @25988
    GIM_Try, /*On fail goto*//*Label 1317*/ 26074,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_Try, /*On fail goto*//*Label 1318*/ 26035, // Rule ID 54935 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (st nxv1i1:{ *:[nxv1i1] }:$rs2, GPR:{ *:[i64] }:$rs1)<<P:Predicate_unindexedstore>><<P:Predicate_store>>  =>  (PseudoVSM_V_B1 VR:{ *:[nxv1i1] }:$rs2, GPR:{ *:[i64] }:$rs1, -1:{ *:[i64] }, 0:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVSM_V_B1,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rs2
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 54935,
        GIR_Done,
      // Label 1318: @26035
      GIM_Try, /*On fail goto*//*Label 1319*/ 26073, // Rule ID 54936 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (st nxv1i1:{ *:[nxv1i1] }:$rs2, GPR:{ *:[i32] }:$rs1)<<P:Predicate_unindexedstore>><<P:Predicate_store>>  =>  (PseudoVSM_V_B1 VR:{ *:[nxv1i1] }:$rs2, GPR:{ *:[i32] }:$rs1, -1:{ *:[i32] }, 0:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVSM_V_B1,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rs2
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 54936,
        GIR_Done,
      // Label 1319: @26073
      GIM_Reject,
    // Label 1317: @26074
    GIM_Reject,
    // Label 1288: @26075
    GIM_Try, /*On fail goto*//*Label 1320*/ 26161,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_Try, /*On fail goto*//*Label 1321*/ 26122, // Rule ID 54927 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (st nxv1i8:{ *:[nxv1i8] }:$rs2, GPR:{ *:[i64] }:$rs1)<<P:Predicate_unindexedstore>><<P:Predicate_store>>  =>  (PseudoVSE8_V_MF8 VR:{ *:[nxv1i8] }:$rs2, GPR:{ *:[i64] }:$rs1, -1:{ *:[i64] }, 3:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVSE8_V_MF8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rs2
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 54927,
        GIR_Done,
      // Label 1321: @26122
      GIM_Try, /*On fail goto*//*Label 1322*/ 26160, // Rule ID 54928 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (st nxv1i8:{ *:[nxv1i8] }:$rs2, GPR:{ *:[i32] }:$rs1)<<P:Predicate_unindexedstore>><<P:Predicate_store>>  =>  (PseudoVSE8_V_MF8 VR:{ *:[nxv1i8] }:$rs2, GPR:{ *:[i32] }:$rs1, -1:{ *:[i32] }, 3:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVSE8_V_MF8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rs2
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 54928,
        GIR_Done,
      // Label 1322: @26160
      GIM_Reject,
    // Label 1320: @26161
    GIM_Reject,
    // Label 1289: @26162
    GIM_Try, /*On fail goto*//*Label 1323*/ 26324,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_Try, /*On fail goto*//*Label 1324*/ 26209, // Rule ID 55055 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (st nxv1i16:{ *:[nxv1i16] }:$rs2, GPR:{ *:[i64] }:$rs1)<<P:Predicate_unindexedstore>><<P:Predicate_store>>  =>  (PseudoVSE16_V_MF4 VR:{ *:[nxv1i16] }:$rs2, GPR:{ *:[i64] }:$rs1, -1:{ *:[i64] }, 4:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVSE16_V_MF4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rs2
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 55055,
        GIR_Done,
      // Label 1324: @26209
      GIM_Try, /*On fail goto*//*Label 1325*/ 26247, // Rule ID 55056 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (st nxv1i16:{ *:[nxv1i16] }:$rs2, GPR:{ *:[i32] }:$rs1)<<P:Predicate_unindexedstore>><<P:Predicate_store>>  =>  (PseudoVSE16_V_MF4 VR:{ *:[nxv1i16] }:$rs2, GPR:{ *:[i32] }:$rs1, -1:{ *:[i32] }, 4:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVSE16_V_MF4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rs2
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 55056,
        GIR_Done,
      // Label 1325: @26247
      GIM_Try, /*On fail goto*//*Label 1326*/ 26285, // Rule ID 55067 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (st nxv1f16:{ *:[nxv1f16] }:$rs2, GPR:{ *:[i64] }:$rs1)<<P:Predicate_unindexedstore>><<P:Predicate_store>>  =>  (PseudoVSE16_V_MF4 VR:{ *:[nxv1f16] }:$rs2, GPR:{ *:[i64] }:$rs1, -1:{ *:[i64] }, 4:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVSE16_V_MF4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rs2
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 55067,
        GIR_Done,
      // Label 1326: @26285
      GIM_Try, /*On fail goto*//*Label 1327*/ 26323, // Rule ID 55068 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (st nxv1f16:{ *:[nxv1f16] }:$rs2, GPR:{ *:[i32] }:$rs1)<<P:Predicate_unindexedstore>><<P:Predicate_store>>  =>  (PseudoVSE16_V_MF4 VR:{ *:[nxv1f16] }:$rs2, GPR:{ *:[i32] }:$rs1, -1:{ *:[i32] }, 4:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVSE16_V_MF4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rs2
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 55068,
        GIR_Done,
      // Label 1327: @26323
      GIM_Reject,
    // Label 1323: @26324
    GIM_Reject,
    // Label 1290: @26325
    GIM_Try, /*On fail goto*//*Label 1328*/ 26487,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_Try, /*On fail goto*//*Label 1329*/ 26372, // Rule ID 55063 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (st nxv1i32:{ *:[nxv1i32] }:$rs2, GPR:{ *:[i64] }:$rs1)<<P:Predicate_unindexedstore>><<P:Predicate_store>>  =>  (PseudoVSE32_V_MF2 VR:{ *:[nxv1i32] }:$rs2, GPR:{ *:[i64] }:$rs1, -1:{ *:[i64] }, 5:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVSE32_V_MF2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rs2
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 55063,
        GIR_Done,
      // Label 1329: @26372
      GIM_Try, /*On fail goto*//*Label 1330*/ 26410, // Rule ID 55064 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (st nxv1i32:{ *:[nxv1i32] }:$rs2, GPR:{ *:[i32] }:$rs1)<<P:Predicate_unindexedstore>><<P:Predicate_store>>  =>  (PseudoVSE32_V_MF2 VR:{ *:[nxv1i32] }:$rs2, GPR:{ *:[i32] }:$rs1, -1:{ *:[i32] }, 5:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVSE32_V_MF2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rs2
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 55064,
        GIR_Done,
      // Label 1330: @26410
      GIM_Try, /*On fail goto*//*Label 1331*/ 26448, // Rule ID 55075 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (st nxv1f32:{ *:[nxv1f32] }:$rs2, GPR:{ *:[i64] }:$rs1)<<P:Predicate_unindexedstore>><<P:Predicate_store>>  =>  (PseudoVSE32_V_MF2 VR:{ *:[nxv1f32] }:$rs2, GPR:{ *:[i64] }:$rs1, -1:{ *:[i64] }, 5:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVSE32_V_MF2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rs2
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 55075,
        GIR_Done,
      // Label 1331: @26448
      GIM_Try, /*On fail goto*//*Label 1332*/ 26486, // Rule ID 55076 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (st nxv1f32:{ *:[nxv1f32] }:$rs2, GPR:{ *:[i32] }:$rs1)<<P:Predicate_unindexedstore>><<P:Predicate_store>>  =>  (PseudoVSE32_V_MF2 VR:{ *:[nxv1f32] }:$rs2, GPR:{ *:[i32] }:$rs1, -1:{ *:[i32] }, 5:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVSE32_V_MF2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rs2
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 55076,
        GIR_Done,
      // Label 1332: @26486
      GIM_Reject,
    // Label 1328: @26487
    GIM_Reject,
    // Label 1291: @26488
    GIM_Try, /*On fail goto*//*Label 1333*/ 26574,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_Try, /*On fail goto*//*Label 1334*/ 26516, // Rule ID 55087 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (st nxv1i64:{ *:[nxv1i64] }:$rs2, GPR:{ *:[i64] }:$rs1)<<P:Predicate_unindexedstore>><<P:Predicate_store>>  =>  (VS1R_V VR:{ *:[nxv1i64] }:$rs2, GPR:{ *:[i64] }:$rs1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::VS1R_V,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 55087,
        GIR_Done,
      // Label 1334: @26516
      GIM_Try, /*On fail goto*//*Label 1335*/ 26535, // Rule ID 55088 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (st nxv1i64:{ *:[nxv1i64] }:$rs2, GPR:{ *:[i32] }:$rs1)<<P:Predicate_unindexedstore>><<P:Predicate_store>>  =>  (VS1R_V VR:{ *:[nxv1i64] }:$rs2, GPR:{ *:[i32] }:$rs1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::VS1R_V,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 55088,
        GIR_Done,
      // Label 1335: @26535
      GIM_Try, /*On fail goto*//*Label 1336*/ 26554, // Rule ID 55099 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (st nxv1f64:{ *:[nxv1f64] }:$rs2, GPR:{ *:[i64] }:$rs1)<<P:Predicate_unindexedstore>><<P:Predicate_store>>  =>  (VS1R_V VR:{ *:[nxv1f64] }:$rs2, GPR:{ *:[i64] }:$rs1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::VS1R_V,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 55099,
        GIR_Done,
      // Label 1336: @26554
      GIM_Try, /*On fail goto*//*Label 1337*/ 26573, // Rule ID 55100 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (st nxv1f64:{ *:[nxv1f64] }:$rs2, GPR:{ *:[i32] }:$rs1)<<P:Predicate_unindexedstore>><<P:Predicate_store>>  =>  (VS1R_V VR:{ *:[nxv1f64] }:$rs2, GPR:{ *:[i32] }:$rs1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::VS1R_V,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 55100,
        GIR_Done,
      // Label 1337: @26573
      GIM_Reject,
    // Label 1333: @26574
    GIM_Reject,
    // Label 1292: @26575
    GIM_Try, /*On fail goto*//*Label 1338*/ 26661,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_Try, /*On fail goto*//*Label 1339*/ 26622, // Rule ID 55187 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (st nxv2i1:{ *:[nxv2i1] }:$rs2, GPR:{ *:[i64] }:$rs1)<<P:Predicate_unindexedstore>><<P:Predicate_store>>  =>  (PseudoVSM_V_B2 VR:{ *:[nxv2i1] }:$rs2, GPR:{ *:[i64] }:$rs1, -1:{ *:[i64] }, 0:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVSM_V_B2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rs2
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 55187,
        GIR_Done,
      // Label 1339: @26622
      GIM_Try, /*On fail goto*//*Label 1340*/ 26660, // Rule ID 55188 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (st nxv2i1:{ *:[nxv2i1] }:$rs2, GPR:{ *:[i32] }:$rs1)<<P:Predicate_unindexedstore>><<P:Predicate_store>>  =>  (PseudoVSM_V_B2 VR:{ *:[nxv2i1] }:$rs2, GPR:{ *:[i32] }:$rs1, -1:{ *:[i32] }, 0:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVSM_V_B2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rs2
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 55188,
        GIR_Done,
      // Label 1340: @26660
      GIM_Reject,
    // Label 1338: @26661
    GIM_Reject,
    // Label 1293: @26662
    GIM_Try, /*On fail goto*//*Label 1341*/ 26748,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_Try, /*On fail goto*//*Label 1342*/ 26709, // Rule ID 55047 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (st nxv2i8:{ *:[nxv2i8] }:$rs2, GPR:{ *:[i64] }:$rs1)<<P:Predicate_unindexedstore>><<P:Predicate_store>>  =>  (PseudoVSE8_V_MF4 VR:{ *:[nxv2i8] }:$rs2, GPR:{ *:[i64] }:$rs1, -1:{ *:[i64] }, 3:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVSE8_V_MF4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rs2
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 55047,
        GIR_Done,
      // Label 1342: @26709
      GIM_Try, /*On fail goto*//*Label 1343*/ 26747, // Rule ID 55048 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (st nxv2i8:{ *:[nxv2i8] }:$rs2, GPR:{ *:[i32] }:$rs1)<<P:Predicate_unindexedstore>><<P:Predicate_store>>  =>  (PseudoVSE8_V_MF4 VR:{ *:[nxv2i8] }:$rs2, GPR:{ *:[i32] }:$rs1, -1:{ *:[i32] }, 3:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVSE8_V_MF4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rs2
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 55048,
        GIR_Done,
      // Label 1343: @26747
      GIM_Reject,
    // Label 1341: @26748
    GIM_Reject,
    // Label 1294: @26749
    GIM_Try, /*On fail goto*//*Label 1344*/ 26911,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_Try, /*On fail goto*//*Label 1345*/ 26796, // Rule ID 55059 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (st nxv2i16:{ *:[nxv2i16] }:$rs2, GPR:{ *:[i64] }:$rs1)<<P:Predicate_unindexedstore>><<P:Predicate_store>>  =>  (PseudoVSE16_V_MF2 VR:{ *:[nxv2i16] }:$rs2, GPR:{ *:[i64] }:$rs1, -1:{ *:[i64] }, 4:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVSE16_V_MF2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rs2
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 55059,
        GIR_Done,
      // Label 1345: @26796
      GIM_Try, /*On fail goto*//*Label 1346*/ 26834, // Rule ID 55060 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (st nxv2i16:{ *:[nxv2i16] }:$rs2, GPR:{ *:[i32] }:$rs1)<<P:Predicate_unindexedstore>><<P:Predicate_store>>  =>  (PseudoVSE16_V_MF2 VR:{ *:[nxv2i16] }:$rs2, GPR:{ *:[i32] }:$rs1, -1:{ *:[i32] }, 4:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVSE16_V_MF2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rs2
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 55060,
        GIR_Done,
      // Label 1346: @26834
      GIM_Try, /*On fail goto*//*Label 1347*/ 26872, // Rule ID 55071 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (st nxv2f16:{ *:[nxv2f16] }:$rs2, GPR:{ *:[i64] }:$rs1)<<P:Predicate_unindexedstore>><<P:Predicate_store>>  =>  (PseudoVSE16_V_MF2 VR:{ *:[nxv2f16] }:$rs2, GPR:{ *:[i64] }:$rs1, -1:{ *:[i64] }, 4:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVSE16_V_MF2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rs2
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 55071,
        GIR_Done,
      // Label 1347: @26872
      GIM_Try, /*On fail goto*//*Label 1348*/ 26910, // Rule ID 55072 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (st nxv2f16:{ *:[nxv2f16] }:$rs2, GPR:{ *:[i32] }:$rs1)<<P:Predicate_unindexedstore>><<P:Predicate_store>>  =>  (PseudoVSE16_V_MF2 VR:{ *:[nxv2f16] }:$rs2, GPR:{ *:[i32] }:$rs1, -1:{ *:[i32] }, 4:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVSE16_V_MF2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rs2
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 55072,
        GIR_Done,
      // Label 1348: @26910
      GIM_Reject,
    // Label 1344: @26911
    GIM_Reject,
    // Label 1295: @26912
    GIM_Try, /*On fail goto*//*Label 1349*/ 26998,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_Try, /*On fail goto*//*Label 1350*/ 26940, // Rule ID 55083 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (st nxv2i32:{ *:[nxv2i32] }:$rs2, GPR:{ *:[i64] }:$rs1)<<P:Predicate_unindexedstore>><<P:Predicate_store>>  =>  (VS1R_V VR:{ *:[nxv2i32] }:$rs2, GPR:{ *:[i64] }:$rs1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::VS1R_V,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 55083,
        GIR_Done,
      // Label 1350: @26940
      GIM_Try, /*On fail goto*//*Label 1351*/ 26959, // Rule ID 55084 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (st nxv2i32:{ *:[nxv2i32] }:$rs2, GPR:{ *:[i32] }:$rs1)<<P:Predicate_unindexedstore>><<P:Predicate_store>>  =>  (VS1R_V VR:{ *:[nxv2i32] }:$rs2, GPR:{ *:[i32] }:$rs1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::VS1R_V,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 55084,
        GIR_Done,
      // Label 1351: @26959
      GIM_Try, /*On fail goto*//*Label 1352*/ 26978, // Rule ID 55095 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (st nxv2f32:{ *:[nxv2f32] }:$rs2, GPR:{ *:[i64] }:$rs1)<<P:Predicate_unindexedstore>><<P:Predicate_store>>  =>  (VS1R_V VR:{ *:[nxv2f32] }:$rs2, GPR:{ *:[i64] }:$rs1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::VS1R_V,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 55095,
        GIR_Done,
      // Label 1352: @26978
      GIM_Try, /*On fail goto*//*Label 1353*/ 26997, // Rule ID 55096 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (st nxv2f32:{ *:[nxv2f32] }:$rs2, GPR:{ *:[i32] }:$rs1)<<P:Predicate_unindexedstore>><<P:Predicate_store>>  =>  (VS1R_V VR:{ *:[nxv2f32] }:$rs2, GPR:{ *:[i32] }:$rs1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::VS1R_V,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 55096,
        GIR_Done,
      // Label 1353: @26997
      GIM_Reject,
    // Label 1349: @26998
    GIM_Reject,
    // Label 1296: @26999
    GIM_Try, /*On fail goto*//*Label 1354*/ 27085,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_Try, /*On fail goto*//*Label 1355*/ 27027, // Rule ID 55139 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (st nxv2i64:{ *:[nxv2i64] }:$rs2, GPR:{ *:[i64] }:$rs1)<<P:Predicate_unindexedstore>><<P:Predicate_store>>  =>  (VS2R_V VRM2:{ *:[nxv2i64] }:$rs2, GPR:{ *:[i64] }:$rs1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::VS2R_V,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 55139,
        GIR_Done,
      // Label 1355: @27027
      GIM_Try, /*On fail goto*//*Label 1356*/ 27046, // Rule ID 55140 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (st nxv2i64:{ *:[nxv2i64] }:$rs2, GPR:{ *:[i32] }:$rs1)<<P:Predicate_unindexedstore>><<P:Predicate_store>>  =>  (VS2R_V VRM2:{ *:[nxv2i64] }:$rs2, GPR:{ *:[i32] }:$rs1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::VS2R_V,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 55140,
        GIR_Done,
      // Label 1356: @27046
      GIM_Try, /*On fail goto*//*Label 1357*/ 27065, // Rule ID 55175 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (st nxv2f64:{ *:[nxv2f64] }:$rs2, GPR:{ *:[i64] }:$rs1)<<P:Predicate_unindexedstore>><<P:Predicate_store>>  =>  (VS2R_V VRM2:{ *:[nxv2f64] }:$rs2, GPR:{ *:[i64] }:$rs1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::VS2R_V,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 55175,
        GIR_Done,
      // Label 1357: @27065
      GIM_Try, /*On fail goto*//*Label 1358*/ 27084, // Rule ID 55176 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (st nxv2f64:{ *:[nxv2f64] }:$rs2, GPR:{ *:[i32] }:$rs1)<<P:Predicate_unindexedstore>><<P:Predicate_store>>  =>  (VS2R_V VRM2:{ *:[nxv2f64] }:$rs2, GPR:{ *:[i32] }:$rs1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::VS2R_V,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 55176,
        GIR_Done,
      // Label 1358: @27084
      GIM_Reject,
    // Label 1354: @27085
    GIM_Reject,
    // Label 1297: @27086
    GIM_Try, /*On fail goto*//*Label 1359*/ 27172,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_Try, /*On fail goto*//*Label 1360*/ 27133, // Rule ID 55191 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (st nxv4i1:{ *:[nxv4i1] }:$rs2, GPR:{ *:[i64] }:$rs1)<<P:Predicate_unindexedstore>><<P:Predicate_store>>  =>  (PseudoVSM_V_B4 VR:{ *:[nxv4i1] }:$rs2, GPR:{ *:[i64] }:$rs1, -1:{ *:[i64] }, 0:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVSM_V_B4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rs2
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 55191,
        GIR_Done,
      // Label 1360: @27133
      GIM_Try, /*On fail goto*//*Label 1361*/ 27171, // Rule ID 55192 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (st nxv4i1:{ *:[nxv4i1] }:$rs2, GPR:{ *:[i32] }:$rs1)<<P:Predicate_unindexedstore>><<P:Predicate_store>>  =>  (PseudoVSM_V_B4 VR:{ *:[nxv4i1] }:$rs2, GPR:{ *:[i32] }:$rs1, -1:{ *:[i32] }, 0:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVSM_V_B4,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rs2
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 55192,
        GIR_Done,
      // Label 1361: @27171
      GIM_Reject,
    // Label 1359: @27172
    GIM_Reject,
    // Label 1298: @27173
    GIM_Try, /*On fail goto*//*Label 1362*/ 27259,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_Try, /*On fail goto*//*Label 1363*/ 27220, // Rule ID 55051 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (st nxv4i8:{ *:[nxv4i8] }:$rs2, GPR:{ *:[i64] }:$rs1)<<P:Predicate_unindexedstore>><<P:Predicate_store>>  =>  (PseudoVSE8_V_MF2 VR:{ *:[nxv4i8] }:$rs2, GPR:{ *:[i64] }:$rs1, -1:{ *:[i64] }, 3:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVSE8_V_MF2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rs2
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 55051,
        GIR_Done,
      // Label 1363: @27220
      GIM_Try, /*On fail goto*//*Label 1364*/ 27258, // Rule ID 55052 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (st nxv4i8:{ *:[nxv4i8] }:$rs2, GPR:{ *:[i32] }:$rs1)<<P:Predicate_unindexedstore>><<P:Predicate_store>>  =>  (PseudoVSE8_V_MF2 VR:{ *:[nxv4i8] }:$rs2, GPR:{ *:[i32] }:$rs1, -1:{ *:[i32] }, 3:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVSE8_V_MF2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rs2
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/3,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 55052,
        GIR_Done,
      // Label 1364: @27258
      GIM_Reject,
    // Label 1362: @27259
    GIM_Reject,
    // Label 1299: @27260
    GIM_Try, /*On fail goto*//*Label 1365*/ 27346,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_Try, /*On fail goto*//*Label 1366*/ 27288, // Rule ID 55079 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (st nxv4i16:{ *:[nxv4i16] }:$rs2, GPR:{ *:[i64] }:$rs1)<<P:Predicate_unindexedstore>><<P:Predicate_store>>  =>  (VS1R_V VR:{ *:[nxv4i16] }:$rs2, GPR:{ *:[i64] }:$rs1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::VS1R_V,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 55079,
        GIR_Done,
      // Label 1366: @27288
      GIM_Try, /*On fail goto*//*Label 1367*/ 27307, // Rule ID 55080 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (st nxv4i16:{ *:[nxv4i16] }:$rs2, GPR:{ *:[i32] }:$rs1)<<P:Predicate_unindexedstore>><<P:Predicate_store>>  =>  (VS1R_V VR:{ *:[nxv4i16] }:$rs2, GPR:{ *:[i32] }:$rs1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::VS1R_V,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 55080,
        GIR_Done,
      // Label 1367: @27307
      GIM_Try, /*On fail goto*//*Label 1368*/ 27326, // Rule ID 55091 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (st nxv4f16:{ *:[nxv4f16] }:$rs2, GPR:{ *:[i64] }:$rs1)<<P:Predicate_unindexedstore>><<P:Predicate_store>>  =>  (VS1R_V VR:{ *:[nxv4f16] }:$rs2, GPR:{ *:[i64] }:$rs1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::VS1R_V,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 55091,
        GIR_Done,
      // Label 1368: @27326
      GIM_Try, /*On fail goto*//*Label 1369*/ 27345, // Rule ID 55092 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (st nxv4f16:{ *:[nxv4f16] }:$rs2, GPR:{ *:[i32] }:$rs1)<<P:Predicate_unindexedstore>><<P:Predicate_store>>  =>  (VS1R_V VR:{ *:[nxv4f16] }:$rs2, GPR:{ *:[i32] }:$rs1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::VS1R_V,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 55092,
        GIR_Done,
      // Label 1369: @27345
      GIM_Reject,
    // Label 1365: @27346
    GIM_Reject,
    // Label 1300: @27347
    GIM_Try, /*On fail goto*//*Label 1370*/ 27433,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_Try, /*On fail goto*//*Label 1371*/ 27375, // Rule ID 55127 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (st nxv4i32:{ *:[nxv4i32] }:$rs2, GPR:{ *:[i64] }:$rs1)<<P:Predicate_unindexedstore>><<P:Predicate_store>>  =>  (VS2R_V VRM2:{ *:[nxv4i32] }:$rs2, GPR:{ *:[i64] }:$rs1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::VS2R_V,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 55127,
        GIR_Done,
      // Label 1371: @27375
      GIM_Try, /*On fail goto*//*Label 1372*/ 27394, // Rule ID 55128 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (st nxv4i32:{ *:[nxv4i32] }:$rs2, GPR:{ *:[i32] }:$rs1)<<P:Predicate_unindexedstore>><<P:Predicate_store>>  =>  (VS2R_V VRM2:{ *:[nxv4i32] }:$rs2, GPR:{ *:[i32] }:$rs1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::VS2R_V,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 55128,
        GIR_Done,
      // Label 1372: @27394
      GIM_Try, /*On fail goto*//*Label 1373*/ 27413, // Rule ID 55163 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (st nxv4f32:{ *:[nxv4f32] }:$rs2, GPR:{ *:[i64] }:$rs1)<<P:Predicate_unindexedstore>><<P:Predicate_store>>  =>  (VS2R_V VRM2:{ *:[nxv4f32] }:$rs2, GPR:{ *:[i64] }:$rs1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::VS2R_V,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 55163,
        GIR_Done,
      // Label 1373: @27413
      GIM_Try, /*On fail goto*//*Label 1374*/ 27432, // Rule ID 55164 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (st nxv4f32:{ *:[nxv4f32] }:$rs2, GPR:{ *:[i32] }:$rs1)<<P:Predicate_unindexedstore>><<P:Predicate_store>>  =>  (VS2R_V VRM2:{ *:[nxv4f32] }:$rs2, GPR:{ *:[i32] }:$rs1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::VS2R_V,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 55164,
        GIR_Done,
      // Label 1374: @27432
      GIM_Reject,
    // Label 1370: @27433
    GIM_Reject,
    // Label 1301: @27434
    GIM_Try, /*On fail goto*//*Label 1375*/ 27520,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_Try, /*On fail goto*//*Label 1376*/ 27462, // Rule ID 55143 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (st nxv4i64:{ *:[nxv4i64] }:$rs2, GPR:{ *:[i64] }:$rs1)<<P:Predicate_unindexedstore>><<P:Predicate_store>>  =>  (VS4R_V VRM4:{ *:[nxv4i64] }:$rs2, GPR:{ *:[i64] }:$rs1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::VS4R_V,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 55143,
        GIR_Done,
      // Label 1376: @27462
      GIM_Try, /*On fail goto*//*Label 1377*/ 27481, // Rule ID 55144 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (st nxv4i64:{ *:[nxv4i64] }:$rs2, GPR:{ *:[i32] }:$rs1)<<P:Predicate_unindexedstore>><<P:Predicate_store>>  =>  (VS4R_V VRM4:{ *:[nxv4i64] }:$rs2, GPR:{ *:[i32] }:$rs1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::VS4R_V,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 55144,
        GIR_Done,
      // Label 1377: @27481
      GIM_Try, /*On fail goto*//*Label 1378*/ 27500, // Rule ID 55179 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (st nxv4f64:{ *:[nxv4f64] }:$rs2, GPR:{ *:[i64] }:$rs1)<<P:Predicate_unindexedstore>><<P:Predicate_store>>  =>  (VS4R_V VRM4:{ *:[nxv4f64] }:$rs2, GPR:{ *:[i64] }:$rs1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::VS4R_V,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 55179,
        GIR_Done,
      // Label 1378: @27500
      GIM_Try, /*On fail goto*//*Label 1379*/ 27519, // Rule ID 55180 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (st nxv4f64:{ *:[nxv4f64] }:$rs2, GPR:{ *:[i32] }:$rs1)<<P:Predicate_unindexedstore>><<P:Predicate_store>>  =>  (VS4R_V VRM4:{ *:[nxv4f64] }:$rs2, GPR:{ *:[i32] }:$rs1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::VS4R_V,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 55180,
        GIR_Done,
      // Label 1379: @27519
      GIM_Reject,
    // Label 1375: @27520
    GIM_Reject,
    // Label 1302: @27521
    GIM_Try, /*On fail goto*//*Label 1380*/ 27607,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_Try, /*On fail goto*//*Label 1381*/ 27568, // Rule ID 55195 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (st nxv8i1:{ *:[nxv8i1] }:$rs2, GPR:{ *:[i64] }:$rs1)<<P:Predicate_unindexedstore>><<P:Predicate_store>>  =>  (PseudoVSM_V_B8 VR:{ *:[nxv8i1] }:$rs2, GPR:{ *:[i64] }:$rs1, -1:{ *:[i64] }, 0:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVSM_V_B8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rs2
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 55195,
        GIR_Done,
      // Label 1381: @27568
      GIM_Try, /*On fail goto*//*Label 1382*/ 27606, // Rule ID 55196 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (st nxv8i1:{ *:[nxv8i1] }:$rs2, GPR:{ *:[i32] }:$rs1)<<P:Predicate_unindexedstore>><<P:Predicate_store>>  =>  (PseudoVSM_V_B8 VR:{ *:[nxv8i1] }:$rs2, GPR:{ *:[i32] }:$rs1, -1:{ *:[i32] }, 0:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVSM_V_B8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rs2
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 55196,
        GIR_Done,
      // Label 1382: @27606
      GIM_Reject,
    // Label 1380: @27607
    GIM_Reject,
    // Label 1303: @27608
    GIM_Try, /*On fail goto*//*Label 1383*/ 27656,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_Try, /*On fail goto*//*Label 1384*/ 27636, // Rule ID 54931 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (st nxv8i8:{ *:[nxv8i8] }:$rs2, GPR:{ *:[i64] }:$rs1)<<P:Predicate_unindexedstore>><<P:Predicate_store>>  =>  (VS1R_V VR:{ *:[nxv8i8] }:$rs2, GPR:{ *:[i64] }:$rs1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::VS1R_V,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 54931,
        GIR_Done,
      // Label 1384: @27636
      GIM_Try, /*On fail goto*//*Label 1385*/ 27655, // Rule ID 54932 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (st nxv8i8:{ *:[nxv8i8] }:$rs2, GPR:{ *:[i32] }:$rs1)<<P:Predicate_unindexedstore>><<P:Predicate_store>>  =>  (VS1R_V VR:{ *:[nxv8i8] }:$rs2, GPR:{ *:[i32] }:$rs1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::VS1R_V,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 54932,
        GIR_Done,
      // Label 1385: @27655
      GIM_Reject,
    // Label 1383: @27656
    GIM_Reject,
    // Label 1304: @27657
    GIM_Try, /*On fail goto*//*Label 1386*/ 27743,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_Try, /*On fail goto*//*Label 1387*/ 27685, // Rule ID 55115 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (st nxv8i16:{ *:[nxv8i16] }:$rs2, GPR:{ *:[i64] }:$rs1)<<P:Predicate_unindexedstore>><<P:Predicate_store>>  =>  (VS2R_V VRM2:{ *:[nxv8i16] }:$rs2, GPR:{ *:[i64] }:$rs1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::VS2R_V,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 55115,
        GIR_Done,
      // Label 1387: @27685
      GIM_Try, /*On fail goto*//*Label 1388*/ 27704, // Rule ID 55116 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (st nxv8i16:{ *:[nxv8i16] }:$rs2, GPR:{ *:[i32] }:$rs1)<<P:Predicate_unindexedstore>><<P:Predicate_store>>  =>  (VS2R_V VRM2:{ *:[nxv8i16] }:$rs2, GPR:{ *:[i32] }:$rs1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::VS2R_V,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 55116,
        GIR_Done,
      // Label 1388: @27704
      GIM_Try, /*On fail goto*//*Label 1389*/ 27723, // Rule ID 55151 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (st nxv8f16:{ *:[nxv8f16] }:$rs2, GPR:{ *:[i64] }:$rs1)<<P:Predicate_unindexedstore>><<P:Predicate_store>>  =>  (VS2R_V VRM2:{ *:[nxv8f16] }:$rs2, GPR:{ *:[i64] }:$rs1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::VS2R_V,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 55151,
        GIR_Done,
      // Label 1389: @27723
      GIM_Try, /*On fail goto*//*Label 1390*/ 27742, // Rule ID 55152 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (st nxv8f16:{ *:[nxv8f16] }:$rs2, GPR:{ *:[i32] }:$rs1)<<P:Predicate_unindexedstore>><<P:Predicate_store>>  =>  (VS2R_V VRM2:{ *:[nxv8f16] }:$rs2, GPR:{ *:[i32] }:$rs1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::VS2R_V,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 55152,
        GIR_Done,
      // Label 1390: @27742
      GIM_Reject,
    // Label 1386: @27743
    GIM_Reject,
    // Label 1305: @27744
    GIM_Try, /*On fail goto*//*Label 1391*/ 27830,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_Try, /*On fail goto*//*Label 1392*/ 27772, // Rule ID 55131 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (st nxv8i32:{ *:[nxv8i32] }:$rs2, GPR:{ *:[i64] }:$rs1)<<P:Predicate_unindexedstore>><<P:Predicate_store>>  =>  (VS4R_V VRM4:{ *:[nxv8i32] }:$rs2, GPR:{ *:[i64] }:$rs1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::VS4R_V,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 55131,
        GIR_Done,
      // Label 1392: @27772
      GIM_Try, /*On fail goto*//*Label 1393*/ 27791, // Rule ID 55132 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (st nxv8i32:{ *:[nxv8i32] }:$rs2, GPR:{ *:[i32] }:$rs1)<<P:Predicate_unindexedstore>><<P:Predicate_store>>  =>  (VS4R_V VRM4:{ *:[nxv8i32] }:$rs2, GPR:{ *:[i32] }:$rs1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::VS4R_V,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 55132,
        GIR_Done,
      // Label 1393: @27791
      GIM_Try, /*On fail goto*//*Label 1394*/ 27810, // Rule ID 55167 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (st nxv8f32:{ *:[nxv8f32] }:$rs2, GPR:{ *:[i64] }:$rs1)<<P:Predicate_unindexedstore>><<P:Predicate_store>>  =>  (VS4R_V VRM4:{ *:[nxv8f32] }:$rs2, GPR:{ *:[i64] }:$rs1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::VS4R_V,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 55167,
        GIR_Done,
      // Label 1394: @27810
      GIM_Try, /*On fail goto*//*Label 1395*/ 27829, // Rule ID 55168 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (st nxv8f32:{ *:[nxv8f32] }:$rs2, GPR:{ *:[i32] }:$rs1)<<P:Predicate_unindexedstore>><<P:Predicate_store>>  =>  (VS4R_V VRM4:{ *:[nxv8f32] }:$rs2, GPR:{ *:[i32] }:$rs1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::VS4R_V,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 55168,
        GIR_Done,
      // Label 1395: @27829
      GIM_Reject,
    // Label 1391: @27830
    GIM_Reject,
    // Label 1306: @27831
    GIM_Try, /*On fail goto*//*Label 1396*/ 27917,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_Try, /*On fail goto*//*Label 1397*/ 27859, // Rule ID 55147 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (st nxv8i64:{ *:[nxv8i64] }:$rs2, GPR:{ *:[i64] }:$rs1)<<P:Predicate_unindexedstore>><<P:Predicate_store>>  =>  (VS8R_V VRM8:{ *:[nxv8i64] }:$rs2, GPR:{ *:[i64] }:$rs1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::VS8R_V,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 55147,
        GIR_Done,
      // Label 1397: @27859
      GIM_Try, /*On fail goto*//*Label 1398*/ 27878, // Rule ID 55148 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (st nxv8i64:{ *:[nxv8i64] }:$rs2, GPR:{ *:[i32] }:$rs1)<<P:Predicate_unindexedstore>><<P:Predicate_store>>  =>  (VS8R_V VRM8:{ *:[nxv8i64] }:$rs2, GPR:{ *:[i32] }:$rs1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::VS8R_V,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 55148,
        GIR_Done,
      // Label 1398: @27878
      GIM_Try, /*On fail goto*//*Label 1399*/ 27897, // Rule ID 55183 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (st nxv8f64:{ *:[nxv8f64] }:$rs2, GPR:{ *:[i64] }:$rs1)<<P:Predicate_unindexedstore>><<P:Predicate_store>>  =>  (VS8R_V VRM8:{ *:[nxv8f64] }:$rs2, GPR:{ *:[i64] }:$rs1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::VS8R_V,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 55183,
        GIR_Done,
      // Label 1399: @27897
      GIM_Try, /*On fail goto*//*Label 1400*/ 27916, // Rule ID 55184 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (st nxv8f64:{ *:[nxv8f64] }:$rs2, GPR:{ *:[i32] }:$rs1)<<P:Predicate_unindexedstore>><<P:Predicate_store>>  =>  (VS8R_V VRM8:{ *:[nxv8f64] }:$rs2, GPR:{ *:[i32] }:$rs1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::VS8R_V,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 55184,
        GIR_Done,
      // Label 1400: @27916
      GIM_Reject,
    // Label 1396: @27917
    GIM_Reject,
    // Label 1307: @27918
    GIM_Try, /*On fail goto*//*Label 1401*/ 28004,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_Try, /*On fail goto*//*Label 1402*/ 27965, // Rule ID 55199 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (st nxv16i1:{ *:[nxv16i1] }:$rs2, GPR:{ *:[i64] }:$rs1)<<P:Predicate_unindexedstore>><<P:Predicate_store>>  =>  (PseudoVSM_V_B16 VR:{ *:[nxv16i1] }:$rs2, GPR:{ *:[i64] }:$rs1, -1:{ *:[i64] }, 0:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVSM_V_B16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rs2
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 55199,
        GIR_Done,
      // Label 1402: @27965
      GIM_Try, /*On fail goto*//*Label 1403*/ 28003, // Rule ID 55200 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (st nxv16i1:{ *:[nxv16i1] }:$rs2, GPR:{ *:[i32] }:$rs1)<<P:Predicate_unindexedstore>><<P:Predicate_store>>  =>  (PseudoVSM_V_B16 VR:{ *:[nxv16i1] }:$rs2, GPR:{ *:[i32] }:$rs1, -1:{ *:[i32] }, 0:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVSM_V_B16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rs2
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 55200,
        GIR_Done,
      // Label 1403: @28003
      GIM_Reject,
    // Label 1401: @28004
    GIM_Reject,
    // Label 1308: @28005
    GIM_Try, /*On fail goto*//*Label 1404*/ 28053,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_Try, /*On fail goto*//*Label 1405*/ 28033, // Rule ID 55103 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (st nxv16i8:{ *:[nxv16i8] }:$rs2, GPR:{ *:[i64] }:$rs1)<<P:Predicate_unindexedstore>><<P:Predicate_store>>  =>  (VS2R_V VRM2:{ *:[nxv16i8] }:$rs2, GPR:{ *:[i64] }:$rs1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::VS2R_V,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 55103,
        GIR_Done,
      // Label 1405: @28033
      GIM_Try, /*On fail goto*//*Label 1406*/ 28052, // Rule ID 55104 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (st nxv16i8:{ *:[nxv16i8] }:$rs2, GPR:{ *:[i32] }:$rs1)<<P:Predicate_unindexedstore>><<P:Predicate_store>>  =>  (VS2R_V VRM2:{ *:[nxv16i8] }:$rs2, GPR:{ *:[i32] }:$rs1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::VS2R_V,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 55104,
        GIR_Done,
      // Label 1406: @28052
      GIM_Reject,
    // Label 1404: @28053
    GIM_Reject,
    // Label 1309: @28054
    GIM_Try, /*On fail goto*//*Label 1407*/ 28140,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_Try, /*On fail goto*//*Label 1408*/ 28082, // Rule ID 55119 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (st nxv16i16:{ *:[nxv16i16] }:$rs2, GPR:{ *:[i64] }:$rs1)<<P:Predicate_unindexedstore>><<P:Predicate_store>>  =>  (VS4R_V VRM4:{ *:[nxv16i16] }:$rs2, GPR:{ *:[i64] }:$rs1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::VS4R_V,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 55119,
        GIR_Done,
      // Label 1408: @28082
      GIM_Try, /*On fail goto*//*Label 1409*/ 28101, // Rule ID 55120 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (st nxv16i16:{ *:[nxv16i16] }:$rs2, GPR:{ *:[i32] }:$rs1)<<P:Predicate_unindexedstore>><<P:Predicate_store>>  =>  (VS4R_V VRM4:{ *:[nxv16i16] }:$rs2, GPR:{ *:[i32] }:$rs1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::VS4R_V,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 55120,
        GIR_Done,
      // Label 1409: @28101
      GIM_Try, /*On fail goto*//*Label 1410*/ 28120, // Rule ID 55155 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (st nxv16f16:{ *:[nxv16f16] }:$rs2, GPR:{ *:[i64] }:$rs1)<<P:Predicate_unindexedstore>><<P:Predicate_store>>  =>  (VS4R_V VRM4:{ *:[nxv16f16] }:$rs2, GPR:{ *:[i64] }:$rs1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::VS4R_V,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 55155,
        GIR_Done,
      // Label 1410: @28120
      GIM_Try, /*On fail goto*//*Label 1411*/ 28139, // Rule ID 55156 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (st nxv16f16:{ *:[nxv16f16] }:$rs2, GPR:{ *:[i32] }:$rs1)<<P:Predicate_unindexedstore>><<P:Predicate_store>>  =>  (VS4R_V VRM4:{ *:[nxv16f16] }:$rs2, GPR:{ *:[i32] }:$rs1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::VS4R_V,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 55156,
        GIR_Done,
      // Label 1411: @28139
      GIM_Reject,
    // Label 1407: @28140
    GIM_Reject,
    // Label 1310: @28141
    GIM_Try, /*On fail goto*//*Label 1412*/ 28227,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_Try, /*On fail goto*//*Label 1413*/ 28169, // Rule ID 55135 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (st nxv16i32:{ *:[nxv16i32] }:$rs2, GPR:{ *:[i64] }:$rs1)<<P:Predicate_unindexedstore>><<P:Predicate_store>>  =>  (VS8R_V VRM8:{ *:[nxv16i32] }:$rs2, GPR:{ *:[i64] }:$rs1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::VS8R_V,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 55135,
        GIR_Done,
      // Label 1413: @28169
      GIM_Try, /*On fail goto*//*Label 1414*/ 28188, // Rule ID 55136 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (st nxv16i32:{ *:[nxv16i32] }:$rs2, GPR:{ *:[i32] }:$rs1)<<P:Predicate_unindexedstore>><<P:Predicate_store>>  =>  (VS8R_V VRM8:{ *:[nxv16i32] }:$rs2, GPR:{ *:[i32] }:$rs1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::VS8R_V,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 55136,
        GIR_Done,
      // Label 1414: @28188
      GIM_Try, /*On fail goto*//*Label 1415*/ 28207, // Rule ID 55171 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (st nxv16f32:{ *:[nxv16f32] }:$rs2, GPR:{ *:[i64] }:$rs1)<<P:Predicate_unindexedstore>><<P:Predicate_store>>  =>  (VS8R_V VRM8:{ *:[nxv16f32] }:$rs2, GPR:{ *:[i64] }:$rs1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::VS8R_V,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 55171,
        GIR_Done,
      // Label 1415: @28207
      GIM_Try, /*On fail goto*//*Label 1416*/ 28226, // Rule ID 55172 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (st nxv16f32:{ *:[nxv16f32] }:$rs2, GPR:{ *:[i32] }:$rs1)<<P:Predicate_unindexedstore>><<P:Predicate_store>>  =>  (VS8R_V VRM8:{ *:[nxv16f32] }:$rs2, GPR:{ *:[i32] }:$rs1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::VS8R_V,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 55172,
        GIR_Done,
      // Label 1416: @28226
      GIM_Reject,
    // Label 1412: @28227
    GIM_Reject,
    // Label 1311: @28228
    GIM_Try, /*On fail goto*//*Label 1417*/ 28314,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_Try, /*On fail goto*//*Label 1418*/ 28275, // Rule ID 55203 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (st nxv32i1:{ *:[nxv32i1] }:$rs2, GPR:{ *:[i64] }:$rs1)<<P:Predicate_unindexedstore>><<P:Predicate_store>>  =>  (PseudoVSM_V_B32 VR:{ *:[nxv32i1] }:$rs2, GPR:{ *:[i64] }:$rs1, -1:{ *:[i64] }, 0:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVSM_V_B32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rs2
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 55203,
        GIR_Done,
      // Label 1418: @28275
      GIM_Try, /*On fail goto*//*Label 1419*/ 28313, // Rule ID 55204 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (st nxv32i1:{ *:[nxv32i1] }:$rs2, GPR:{ *:[i32] }:$rs1)<<P:Predicate_unindexedstore>><<P:Predicate_store>>  =>  (PseudoVSM_V_B32 VR:{ *:[nxv32i1] }:$rs2, GPR:{ *:[i32] }:$rs1, -1:{ *:[i32] }, 0:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVSM_V_B32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rs2
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 55204,
        GIR_Done,
      // Label 1419: @28313
      GIM_Reject,
    // Label 1417: @28314
    GIM_Reject,
    // Label 1312: @28315
    GIM_Try, /*On fail goto*//*Label 1420*/ 28363,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_Try, /*On fail goto*//*Label 1421*/ 28343, // Rule ID 55107 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (st nxv32i8:{ *:[nxv32i8] }:$rs2, GPR:{ *:[i64] }:$rs1)<<P:Predicate_unindexedstore>><<P:Predicate_store>>  =>  (VS4R_V VRM4:{ *:[nxv32i8] }:$rs2, GPR:{ *:[i64] }:$rs1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::VS4R_V,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 55107,
        GIR_Done,
      // Label 1421: @28343
      GIM_Try, /*On fail goto*//*Label 1422*/ 28362, // Rule ID 55108 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (st nxv32i8:{ *:[nxv32i8] }:$rs2, GPR:{ *:[i32] }:$rs1)<<P:Predicate_unindexedstore>><<P:Predicate_store>>  =>  (VS4R_V VRM4:{ *:[nxv32i8] }:$rs2, GPR:{ *:[i32] }:$rs1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::VS4R_V,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 55108,
        GIR_Done,
      // Label 1422: @28362
      GIM_Reject,
    // Label 1420: @28363
    GIM_Reject,
    // Label 1313: @28364
    GIM_Try, /*On fail goto*//*Label 1423*/ 28450,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_Try, /*On fail goto*//*Label 1424*/ 28392, // Rule ID 55123 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (st nxv32i16:{ *:[nxv32i16] }:$rs2, GPR:{ *:[i64] }:$rs1)<<P:Predicate_unindexedstore>><<P:Predicate_store>>  =>  (VS8R_V VRM8:{ *:[nxv32i16] }:$rs2, GPR:{ *:[i64] }:$rs1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::VS8R_V,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 55123,
        GIR_Done,
      // Label 1424: @28392
      GIM_Try, /*On fail goto*//*Label 1425*/ 28411, // Rule ID 55124 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (st nxv32i16:{ *:[nxv32i16] }:$rs2, GPR:{ *:[i32] }:$rs1)<<P:Predicate_unindexedstore>><<P:Predicate_store>>  =>  (VS8R_V VRM8:{ *:[nxv32i16] }:$rs2, GPR:{ *:[i32] }:$rs1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::VS8R_V,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 55124,
        GIR_Done,
      // Label 1425: @28411
      GIM_Try, /*On fail goto*//*Label 1426*/ 28430, // Rule ID 55159 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (st nxv32f16:{ *:[nxv32f16] }:$rs2, GPR:{ *:[i64] }:$rs1)<<P:Predicate_unindexedstore>><<P:Predicate_store>>  =>  (VS8R_V VRM8:{ *:[nxv32f16] }:$rs2, GPR:{ *:[i64] }:$rs1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::VS8R_V,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 55159,
        GIR_Done,
      // Label 1426: @28430
      GIM_Try, /*On fail goto*//*Label 1427*/ 28449, // Rule ID 55160 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (st nxv32f16:{ *:[nxv32f16] }:$rs2, GPR:{ *:[i32] }:$rs1)<<P:Predicate_unindexedstore>><<P:Predicate_store>>  =>  (VS8R_V VRM8:{ *:[nxv32f16] }:$rs2, GPR:{ *:[i32] }:$rs1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::VS8R_V,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 55160,
        GIR_Done,
      // Label 1427: @28449
      GIM_Reject,
    // Label 1423: @28450
    GIM_Reject,
    // Label 1314: @28451
    GIM_Try, /*On fail goto*//*Label 1428*/ 28537,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_Try, /*On fail goto*//*Label 1429*/ 28498, // Rule ID 55207 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (st nxv64i1:{ *:[nxv64i1] }:$rs2, GPR:{ *:[i64] }:$rs1)<<P:Predicate_unindexedstore>><<P:Predicate_store>>  =>  (PseudoVSM_V_B64 VR:{ *:[nxv64i1] }:$rs2, GPR:{ *:[i64] }:$rs1, -1:{ *:[i64] }, 0:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVSM_V_B64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rs2
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 55207,
        GIR_Done,
      // Label 1429: @28498
      GIM_Try, /*On fail goto*//*Label 1430*/ 28536, // Rule ID 55208 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (st nxv64i1:{ *:[nxv64i1] }:$rs2, GPR:{ *:[i32] }:$rs1)<<P:Predicate_unindexedstore>><<P:Predicate_store>>  =>  (PseudoVSM_V_B64 VR:{ *:[nxv64i1] }:$rs2, GPR:{ *:[i32] }:$rs1, -1:{ *:[i32] }, 0:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoVSM_V_B64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rs2
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 55208,
        GIR_Done,
      // Label 1430: @28536
      GIM_Reject,
    // Label 1428: @28537
    GIM_Reject,
    // Label 1315: @28538
    GIM_Try, /*On fail goto*//*Label 1431*/ 28586,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_Try, /*On fail goto*//*Label 1432*/ 28566, // Rule ID 55111 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (st nxv64i8:{ *:[nxv64i8] }:$rs2, GPR:{ *:[i64] }:$rs1)<<P:Predicate_unindexedstore>><<P:Predicate_store>>  =>  (VS8R_V VRM8:{ *:[nxv64i8] }:$rs2, GPR:{ *:[i64] }:$rs1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::VS8R_V,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 55111,
        GIR_Done,
      // Label 1432: @28566
      GIM_Try, /*On fail goto*//*Label 1433*/ 28585, // Rule ID 55112 //
        GIM_CheckFeatures, GIFBS_HasVInstructions,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        // (st nxv64i8:{ *:[nxv64i8] }:$rs2, GPR:{ *:[i32] }:$rs1)<<P:Predicate_unindexedstore>><<P:Predicate_store>>  =>  (VS8R_V VRM8:{ *:[nxv64i8] }:$rs2, GPR:{ *:[i32] }:$rs1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::VS8R_V,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 55112,
        GIR_Done,
      // Label 1433: @28585
      GIM_Reject,
    // Label 1431: @28586
    GIM_Reject,
    // Label 1316: @28587
    GIM_Reject,
    // Label 14: @28588
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/1, 3, /*)*//*default:*//*Label 1436*/ 30000,
    /*GILLT_s32*//*Label 1434*/ 28596,
    /*GILLT_s64*//*Label 1435*/ 29298,
    // Label 1434: @28596
    GIM_Try, /*On fail goto*//*Label 1437*/ 29297,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
      GIM_Try, /*On fail goto*//*Label 1438*/ 28675, // Rule ID 65016 //
        GIM_CheckFeatures, GIFBS_HasStdExtA,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/4,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Monotonic,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] addr
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/RISCV::GPRRegClassID,
        // (atomic_cmp_swap:{ *:[i32] } GPR:{ *:[i32] }:$addr, GPR:{ *:[i32] }:$cmp, GPR:{ *:[i32] }:$new)<<P:Predicate_atomic_cmp_swap_32>><<P:Predicate_atomic_cmp_swap_32_monotonic>>  =>  (PseudoCmpXchg32:{ *:[i32] }:{ *:[i32] } GPR:{ *:[i32] }:$addr, GPR:{ *:[i32] }:$cmp, GPR:{ *:[i32] }:$new, 2:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoCmpXchg32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // res
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/RegState::Define|RegState::Dead,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // addr
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // cmp
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // new
        GIR_AddImm, /*InsnID*/0, /*Imm*/2,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 65016,
        GIR_Done,
      // Label 1438: @28675
      GIM_Try, /*On fail goto*//*Label 1439*/ 28744, // Rule ID 65018 //
        GIM_CheckFeatures, GIFBS_HasStdExtA,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/4,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Acquire,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] addr
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/RISCV::GPRRegClassID,
        // (atomic_cmp_swap:{ *:[i32] } GPR:{ *:[i32] }:$addr, GPR:{ *:[i32] }:$cmp, GPR:{ *:[i32] }:$new)<<P:Predicate_atomic_cmp_swap_32>><<P:Predicate_atomic_cmp_swap_32_acquire>>  =>  (PseudoCmpXchg32:{ *:[i32] }:{ *:[i32] } GPR:{ *:[i32] }:$addr, GPR:{ *:[i32] }:$cmp, GPR:{ *:[i32] }:$new, 4:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoCmpXchg32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // res
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/RegState::Define|RegState::Dead,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // addr
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // cmp
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // new
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 65018,
        GIR_Done,
      // Label 1439: @28744
      GIM_Try, /*On fail goto*//*Label 1440*/ 28813, // Rule ID 65020 //
        GIM_CheckFeatures, GIFBS_HasStdExtA,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/4,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Release,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] addr
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/RISCV::GPRRegClassID,
        // (atomic_cmp_swap:{ *:[i32] } GPR:{ *:[i32] }:$addr, GPR:{ *:[i32] }:$cmp, GPR:{ *:[i32] }:$new)<<P:Predicate_atomic_cmp_swap_32>><<P:Predicate_atomic_cmp_swap_32_release>>  =>  (PseudoCmpXchg32:{ *:[i32] }:{ *:[i32] } GPR:{ *:[i32] }:$addr, GPR:{ *:[i32] }:$cmp, GPR:{ *:[i32] }:$new, 5:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoCmpXchg32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // res
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/RegState::Define|RegState::Dead,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // addr
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // cmp
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // new
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 65020,
        GIR_Done,
      // Label 1440: @28813
      GIM_Try, /*On fail goto*//*Label 1441*/ 28882, // Rule ID 65022 //
        GIM_CheckFeatures, GIFBS_HasStdExtA,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/4,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::AcquireRelease,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] addr
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/RISCV::GPRRegClassID,
        // (atomic_cmp_swap:{ *:[i32] } GPR:{ *:[i32] }:$addr, GPR:{ *:[i32] }:$cmp, GPR:{ *:[i32] }:$new)<<P:Predicate_atomic_cmp_swap_32>><<P:Predicate_atomic_cmp_swap_32_acq_rel>>  =>  (PseudoCmpXchg32:{ *:[i32] }:{ *:[i32] } GPR:{ *:[i32] }:$addr, GPR:{ *:[i32] }:$cmp, GPR:{ *:[i32] }:$new, 6:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoCmpXchg32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // res
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/RegState::Define|RegState::Dead,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // addr
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // cmp
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // new
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 65022,
        GIR_Done,
      // Label 1441: @28882
      GIM_Try, /*On fail goto*//*Label 1442*/ 28951, // Rule ID 65024 //
        GIM_CheckFeatures, GIFBS_HasStdExtA,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/4,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::SequentiallyConsistent,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] addr
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/RISCV::GPRRegClassID,
        // (atomic_cmp_swap:{ *:[i32] } GPR:{ *:[i32] }:$addr, GPR:{ *:[i32] }:$cmp, GPR:{ *:[i32] }:$new)<<P:Predicate_atomic_cmp_swap_32>><<P:Predicate_atomic_cmp_swap_32_seq_cst>>  =>  (PseudoCmpXchg32:{ *:[i32] }:{ *:[i32] } GPR:{ *:[i32] }:$addr, GPR:{ *:[i32] }:$cmp, GPR:{ *:[i32] }:$new, 7:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoCmpXchg32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // res
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/RegState::Define|RegState::Dead,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // addr
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // cmp
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // new
        GIR_AddImm, /*InsnID*/0, /*Imm*/7,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 65024,
        GIR_Done,
      // Label 1442: @28951
      GIM_Try, /*On fail goto*//*Label 1443*/ 29020, // Rule ID 65135 //
        GIM_CheckFeatures, GIFBS_HasStdExtA_IsRV64,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/8,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Monotonic,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] addr
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/RISCV::GPRRegClassID,
        // (atomic_cmp_swap:{ *:[i32] } GPR:{ *:[i32] }:$addr, GPR:{ *:[i32] }:$cmp, GPR:{ *:[i32] }:$new)<<P:Predicate_atomic_cmp_swap_64>><<P:Predicate_atomic_cmp_swap_64_monotonic>>  =>  (PseudoCmpXchg64:{ *:[i32] }:{ *:[i32] } GPR:{ *:[i32] }:$addr, GPR:{ *:[i32] }:$cmp, GPR:{ *:[i32] }:$new, 2:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoCmpXchg64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // res
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/RegState::Define|RegState::Dead,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // addr
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // cmp
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // new
        GIR_AddImm, /*InsnID*/0, /*Imm*/2,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 65135,
        GIR_Done,
      // Label 1443: @29020
      GIM_Try, /*On fail goto*//*Label 1444*/ 29089, // Rule ID 65137 //
        GIM_CheckFeatures, GIFBS_HasStdExtA_IsRV64,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/8,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Acquire,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] addr
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/RISCV::GPRRegClassID,
        // (atomic_cmp_swap:{ *:[i32] } GPR:{ *:[i32] }:$addr, GPR:{ *:[i32] }:$cmp, GPR:{ *:[i32] }:$new)<<P:Predicate_atomic_cmp_swap_64>><<P:Predicate_atomic_cmp_swap_64_acquire>>  =>  (PseudoCmpXchg64:{ *:[i32] }:{ *:[i32] } GPR:{ *:[i32] }:$addr, GPR:{ *:[i32] }:$cmp, GPR:{ *:[i32] }:$new, 4:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoCmpXchg64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // res
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/RegState::Define|RegState::Dead,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // addr
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // cmp
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // new
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 65137,
        GIR_Done,
      // Label 1444: @29089
      GIM_Try, /*On fail goto*//*Label 1445*/ 29158, // Rule ID 65139 //
        GIM_CheckFeatures, GIFBS_HasStdExtA_IsRV64,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/8,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Release,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] addr
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/RISCV::GPRRegClassID,
        // (atomic_cmp_swap:{ *:[i32] } GPR:{ *:[i32] }:$addr, GPR:{ *:[i32] }:$cmp, GPR:{ *:[i32] }:$new)<<P:Predicate_atomic_cmp_swap_64>><<P:Predicate_atomic_cmp_swap_64_release>>  =>  (PseudoCmpXchg64:{ *:[i32] }:{ *:[i32] } GPR:{ *:[i32] }:$addr, GPR:{ *:[i32] }:$cmp, GPR:{ *:[i32] }:$new, 5:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoCmpXchg64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // res
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/RegState::Define|RegState::Dead,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // addr
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // cmp
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // new
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 65139,
        GIR_Done,
      // Label 1445: @29158
      GIM_Try, /*On fail goto*//*Label 1446*/ 29227, // Rule ID 65141 //
        GIM_CheckFeatures, GIFBS_HasStdExtA_IsRV64,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/8,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::AcquireRelease,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] addr
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/RISCV::GPRRegClassID,
        // (atomic_cmp_swap:{ *:[i32] } GPR:{ *:[i32] }:$addr, GPR:{ *:[i32] }:$cmp, GPR:{ *:[i32] }:$new)<<P:Predicate_atomic_cmp_swap_64>><<P:Predicate_atomic_cmp_swap_64_acq_rel>>  =>  (PseudoCmpXchg64:{ *:[i32] }:{ *:[i32] } GPR:{ *:[i32] }:$addr, GPR:{ *:[i32] }:$cmp, GPR:{ *:[i32] }:$new, 6:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoCmpXchg64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // res
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/RegState::Define|RegState::Dead,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // addr
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // cmp
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // new
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 65141,
        GIR_Done,
      // Label 1446: @29227
      GIM_Try, /*On fail goto*//*Label 1447*/ 29296, // Rule ID 65143 //
        GIM_CheckFeatures, GIFBS_HasStdExtA_IsRV64,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/8,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::SequentiallyConsistent,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] addr
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/RISCV::GPRRegClassID,
        // (atomic_cmp_swap:{ *:[i32] } GPR:{ *:[i32] }:$addr, GPR:{ *:[i32] }:$cmp, GPR:{ *:[i32] }:$new)<<P:Predicate_atomic_cmp_swap_64>><<P:Predicate_atomic_cmp_swap_64_seq_cst>>  =>  (PseudoCmpXchg64:{ *:[i32] }:{ *:[i32] } GPR:{ *:[i32] }:$addr, GPR:{ *:[i32] }:$cmp, GPR:{ *:[i32] }:$new, 7:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoCmpXchg64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // res
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/RegState::Define|RegState::Dead,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // addr
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // cmp
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // new
        GIR_AddImm, /*InsnID*/0, /*Imm*/7,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 65143,
        GIR_Done,
      // Label 1447: @29296
      GIM_Reject,
    // Label 1437: @29297
    GIM_Reject,
    // Label 1435: @29298
    GIM_Try, /*On fail goto*//*Label 1448*/ 29999,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
      GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s64,
      GIM_Try, /*On fail goto*//*Label 1449*/ 29377, // Rule ID 65015 //
        GIM_CheckFeatures, GIFBS_HasStdExtA,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/4,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Monotonic,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] addr
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/RISCV::GPRRegClassID,
        // (atomic_cmp_swap:{ *:[i64] } GPR:{ *:[i64] }:$addr, GPR:{ *:[i64] }:$cmp, GPR:{ *:[i64] }:$new)<<P:Predicate_atomic_cmp_swap_32>><<P:Predicate_atomic_cmp_swap_32_monotonic>>  =>  (PseudoCmpXchg32:{ *:[i64] }:{ *:[i64] } GPR:{ *:[i64] }:$addr, GPR:{ *:[i64] }:$cmp, GPR:{ *:[i64] }:$new, 2:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoCmpXchg32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // res
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/RegState::Define|RegState::Dead,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // addr
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // cmp
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // new
        GIR_AddImm, /*InsnID*/0, /*Imm*/2,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 65015,
        GIR_Done,
      // Label 1449: @29377
      GIM_Try, /*On fail goto*//*Label 1450*/ 29446, // Rule ID 65017 //
        GIM_CheckFeatures, GIFBS_HasStdExtA,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/4,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Acquire,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] addr
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/RISCV::GPRRegClassID,
        // (atomic_cmp_swap:{ *:[i64] } GPR:{ *:[i64] }:$addr, GPR:{ *:[i64] }:$cmp, GPR:{ *:[i64] }:$new)<<P:Predicate_atomic_cmp_swap_32>><<P:Predicate_atomic_cmp_swap_32_acquire>>  =>  (PseudoCmpXchg32:{ *:[i64] }:{ *:[i64] } GPR:{ *:[i64] }:$addr, GPR:{ *:[i64] }:$cmp, GPR:{ *:[i64] }:$new, 4:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoCmpXchg32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // res
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/RegState::Define|RegState::Dead,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // addr
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // cmp
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // new
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 65017,
        GIR_Done,
      // Label 1450: @29446
      GIM_Try, /*On fail goto*//*Label 1451*/ 29515, // Rule ID 65019 //
        GIM_CheckFeatures, GIFBS_HasStdExtA,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/4,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Release,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] addr
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/RISCV::GPRRegClassID,
        // (atomic_cmp_swap:{ *:[i64] } GPR:{ *:[i64] }:$addr, GPR:{ *:[i64] }:$cmp, GPR:{ *:[i64] }:$new)<<P:Predicate_atomic_cmp_swap_32>><<P:Predicate_atomic_cmp_swap_32_release>>  =>  (PseudoCmpXchg32:{ *:[i64] }:{ *:[i64] } GPR:{ *:[i64] }:$addr, GPR:{ *:[i64] }:$cmp, GPR:{ *:[i64] }:$new, 5:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoCmpXchg32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // res
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/RegState::Define|RegState::Dead,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // addr
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // cmp
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // new
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 65019,
        GIR_Done,
      // Label 1451: @29515
      GIM_Try, /*On fail goto*//*Label 1452*/ 29584, // Rule ID 65021 //
        GIM_CheckFeatures, GIFBS_HasStdExtA,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/4,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::AcquireRelease,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] addr
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/RISCV::GPRRegClassID,
        // (atomic_cmp_swap:{ *:[i64] } GPR:{ *:[i64] }:$addr, GPR:{ *:[i64] }:$cmp, GPR:{ *:[i64] }:$new)<<P:Predicate_atomic_cmp_swap_32>><<P:Predicate_atomic_cmp_swap_32_acq_rel>>  =>  (PseudoCmpXchg32:{ *:[i64] }:{ *:[i64] } GPR:{ *:[i64] }:$addr, GPR:{ *:[i64] }:$cmp, GPR:{ *:[i64] }:$new, 6:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoCmpXchg32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // res
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/RegState::Define|RegState::Dead,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // addr
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // cmp
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // new
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 65021,
        GIR_Done,
      // Label 1452: @29584
      GIM_Try, /*On fail goto*//*Label 1453*/ 29653, // Rule ID 65023 //
        GIM_CheckFeatures, GIFBS_HasStdExtA,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/4,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::SequentiallyConsistent,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] addr
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/RISCV::GPRRegClassID,
        // (atomic_cmp_swap:{ *:[i64] } GPR:{ *:[i64] }:$addr, GPR:{ *:[i64] }:$cmp, GPR:{ *:[i64] }:$new)<<P:Predicate_atomic_cmp_swap_32>><<P:Predicate_atomic_cmp_swap_32_seq_cst>>  =>  (PseudoCmpXchg32:{ *:[i64] }:{ *:[i64] } GPR:{ *:[i64] }:$addr, GPR:{ *:[i64] }:$cmp, GPR:{ *:[i64] }:$new, 7:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoCmpXchg32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // res
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/RegState::Define|RegState::Dead,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // addr
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // cmp
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // new
        GIR_AddImm, /*InsnID*/0, /*Imm*/7,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 65023,
        GIR_Done,
      // Label 1453: @29653
      GIM_Try, /*On fail goto*//*Label 1454*/ 29722, // Rule ID 65134 //
        GIM_CheckFeatures, GIFBS_HasStdExtA_IsRV64,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/8,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Monotonic,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] addr
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/RISCV::GPRRegClassID,
        // (atomic_cmp_swap:{ *:[i64] } GPR:{ *:[i64] }:$addr, GPR:{ *:[i64] }:$cmp, GPR:{ *:[i64] }:$new)<<P:Predicate_atomic_cmp_swap_64>><<P:Predicate_atomic_cmp_swap_64_monotonic>>  =>  (PseudoCmpXchg64:{ *:[i64] }:{ *:[i64] } GPR:{ *:[i64] }:$addr, GPR:{ *:[i64] }:$cmp, GPR:{ *:[i64] }:$new, 2:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoCmpXchg64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // res
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/RegState::Define|RegState::Dead,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // addr
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // cmp
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // new
        GIR_AddImm, /*InsnID*/0, /*Imm*/2,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 65134,
        GIR_Done,
      // Label 1454: @29722
      GIM_Try, /*On fail goto*//*Label 1455*/ 29791, // Rule ID 65136 //
        GIM_CheckFeatures, GIFBS_HasStdExtA_IsRV64,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/8,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Acquire,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] addr
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/RISCV::GPRRegClassID,
        // (atomic_cmp_swap:{ *:[i64] } GPR:{ *:[i64] }:$addr, GPR:{ *:[i64] }:$cmp, GPR:{ *:[i64] }:$new)<<P:Predicate_atomic_cmp_swap_64>><<P:Predicate_atomic_cmp_swap_64_acquire>>  =>  (PseudoCmpXchg64:{ *:[i64] }:{ *:[i64] } GPR:{ *:[i64] }:$addr, GPR:{ *:[i64] }:$cmp, GPR:{ *:[i64] }:$new, 4:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoCmpXchg64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // res
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/RegState::Define|RegState::Dead,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // addr
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // cmp
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // new
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 65136,
        GIR_Done,
      // Label 1455: @29791
      GIM_Try, /*On fail goto*//*Label 1456*/ 29860, // Rule ID 65138 //
        GIM_CheckFeatures, GIFBS_HasStdExtA_IsRV64,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/8,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Release,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] addr
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/RISCV::GPRRegClassID,
        // (atomic_cmp_swap:{ *:[i64] } GPR:{ *:[i64] }:$addr, GPR:{ *:[i64] }:$cmp, GPR:{ *:[i64] }:$new)<<P:Predicate_atomic_cmp_swap_64>><<P:Predicate_atomic_cmp_swap_64_release>>  =>  (PseudoCmpXchg64:{ *:[i64] }:{ *:[i64] } GPR:{ *:[i64] }:$addr, GPR:{ *:[i64] }:$cmp, GPR:{ *:[i64] }:$new, 5:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoCmpXchg64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // res
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/RegState::Define|RegState::Dead,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // addr
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // cmp
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // new
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 65138,
        GIR_Done,
      // Label 1456: @29860
      GIM_Try, /*On fail goto*//*Label 1457*/ 29929, // Rule ID 65140 //
        GIM_CheckFeatures, GIFBS_HasStdExtA_IsRV64,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/8,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::AcquireRelease,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] addr
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/RISCV::GPRRegClassID,
        // (atomic_cmp_swap:{ *:[i64] } GPR:{ *:[i64] }:$addr, GPR:{ *:[i64] }:$cmp, GPR:{ *:[i64] }:$new)<<P:Predicate_atomic_cmp_swap_64>><<P:Predicate_atomic_cmp_swap_64_acq_rel>>  =>  (PseudoCmpXchg64:{ *:[i64] }:{ *:[i64] } GPR:{ *:[i64] }:$addr, GPR:{ *:[i64] }:$cmp, GPR:{ *:[i64] }:$new, 6:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoCmpXchg64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // res
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/RegState::Define|RegState::Dead,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // addr
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // cmp
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // new
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 65140,
        GIR_Done,
      // Label 1457: @29929
      GIM_Try, /*On fail goto*//*Label 1458*/ 29998, // Rule ID 65142 //
        GIM_CheckFeatures, GIFBS_HasStdExtA_IsRV64,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/8,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::SequentiallyConsistent,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] addr
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/RISCV::GPRRegClassID,
        // (atomic_cmp_swap:{ *:[i64] } GPR:{ *:[i64] }:$addr, GPR:{ *:[i64] }:$cmp, GPR:{ *:[i64] }:$new)<<P:Predicate_atomic_cmp_swap_64>><<P:Predicate_atomic_cmp_swap_64_seq_cst>>  =>  (PseudoCmpXchg64:{ *:[i64] }:{ *:[i64] } GPR:{ *:[i64] }:$addr, GPR:{ *:[i64] }:$cmp, GPR:{ *:[i64] }:$new, 7:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoCmpXchg64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // res
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/RegState::Define|RegState::Dead,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // addr
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // cmp
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // new
        GIR_AddImm, /*InsnID*/0, /*Imm*/7,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 65142,
        GIR_Done,
      // Label 1458: @29998
      GIM_Reject,
    // Label 1448: @29999
    GIM_Reject,
    // Label 1436: @30000
    GIM_Reject,
    // Label 15: @30001
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/1, 3, /*)*//*default:*//*Label 1461*/ 30705,
    /*GILLT_s32*//*Label 1459*/ 30009,
    /*GILLT_s64*//*Label 1460*/ 30357,
    // Label 1459: @30009
    GIM_Try, /*On fail goto*//*Label 1462*/ 30356,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
      GIM_Try, /*On fail goto*//*Label 1463*/ 30049, // Rule ID 63951 //
        GIM_CheckFeatures, GIFBS_HasStdExtA,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/4,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Monotonic,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_swap:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)<<P:Predicate_atomic_swap_32>><<P:Predicate_atomic_swap_32_monotonic>>  =>  (AMOSWAP_W:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::AMOSWAP_W,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 63951,
        GIR_Done,
      // Label 1463: @30049
      GIM_Try, /*On fail goto*//*Label 1464*/ 30083, // Rule ID 63971 //
        GIM_CheckFeatures, GIFBS_HasStdExtA,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/4,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Acquire,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_swap:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)<<P:Predicate_atomic_swap_32>><<P:Predicate_atomic_swap_32_acquire>>  =>  (AMOSWAP_W_AQ:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::AMOSWAP_W_AQ,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 63971,
        GIR_Done,
      // Label 1464: @30083
      GIM_Try, /*On fail goto*//*Label 1465*/ 30117, // Rule ID 63993 //
        GIM_CheckFeatures, GIFBS_HasStdExtA,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/4,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Release,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_swap:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)<<P:Predicate_atomic_swap_32>><<P:Predicate_atomic_swap_32_release>>  =>  (AMOSWAP_W_RL:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::AMOSWAP_W_RL,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 63993,
        GIR_Done,
      // Label 1465: @30117
      GIM_Try, /*On fail goto*//*Label 1466*/ 30151, // Rule ID 64015 //
        GIM_CheckFeatures, GIFBS_HasStdExtA,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/4,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::AcquireRelease,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_swap:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)<<P:Predicate_atomic_swap_32>><<P:Predicate_atomic_swap_32_acq_rel>>  =>  (AMOSWAP_W_AQ_RL:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::AMOSWAP_W_AQ_RL,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 64015,
        GIR_Done,
      // Label 1466: @30151
      GIM_Try, /*On fail goto*//*Label 1467*/ 30185, // Rule ID 64037 //
        GIM_CheckFeatures, GIFBS_HasStdExtA,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/4,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::SequentiallyConsistent,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_swap:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)<<P:Predicate_atomic_swap_32>><<P:Predicate_atomic_swap_32_seq_cst>>  =>  (AMOSWAP_W_AQ_RL:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::AMOSWAP_W_AQ_RL,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 64037,
        GIR_Done,
      // Label 1467: @30185
      GIM_Try, /*On fail goto*//*Label 1468*/ 30219, // Rule ID 65027 //
        GIM_CheckFeatures, GIFBS_HasStdExtA_IsRV64,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/8,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Monotonic,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_swap:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)<<P:Predicate_atomic_swap_64>><<P:Predicate_atomic_swap_64_monotonic>>  =>  (AMOSWAP_D:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::AMOSWAP_D,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 65027,
        GIR_Done,
      // Label 1468: @30219
      GIM_Try, /*On fail goto*//*Label 1469*/ 30253, // Rule ID 65029 //
        GIM_CheckFeatures, GIFBS_HasStdExtA_IsRV64,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/8,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Acquire,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_swap:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)<<P:Predicate_atomic_swap_64>><<P:Predicate_atomic_swap_64_acquire>>  =>  (AMOSWAP_D_AQ:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::AMOSWAP_D_AQ,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 65029,
        GIR_Done,
      // Label 1469: @30253
      GIM_Try, /*On fail goto*//*Label 1470*/ 30287, // Rule ID 65031 //
        GIM_CheckFeatures, GIFBS_HasStdExtA_IsRV64,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/8,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Release,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_swap:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)<<P:Predicate_atomic_swap_64>><<P:Predicate_atomic_swap_64_release>>  =>  (AMOSWAP_D_RL:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::AMOSWAP_D_RL,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 65031,
        GIR_Done,
      // Label 1470: @30287
      GIM_Try, /*On fail goto*//*Label 1471*/ 30321, // Rule ID 65033 //
        GIM_CheckFeatures, GIFBS_HasStdExtA_IsRV64,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/8,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::AcquireRelease,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_swap:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)<<P:Predicate_atomic_swap_64>><<P:Predicate_atomic_swap_64_acq_rel>>  =>  (AMOSWAP_D_AQ_RL:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::AMOSWAP_D_AQ_RL,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 65033,
        GIR_Done,
      // Label 1471: @30321
      GIM_Try, /*On fail goto*//*Label 1472*/ 30355, // Rule ID 65035 //
        GIM_CheckFeatures, GIFBS_HasStdExtA_IsRV64,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/8,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::SequentiallyConsistent,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_swap:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)<<P:Predicate_atomic_swap_64>><<P:Predicate_atomic_swap_64_seq_cst>>  =>  (AMOSWAP_D_AQ_RL:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::AMOSWAP_D_AQ_RL,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 65035,
        GIR_Done,
      // Label 1472: @30355
      GIM_Reject,
    // Label 1462: @30356
    GIM_Reject,
    // Label 1460: @30357
    GIM_Try, /*On fail goto*//*Label 1473*/ 30704,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
      GIM_Try, /*On fail goto*//*Label 1474*/ 30397, // Rule ID 63950 //
        GIM_CheckFeatures, GIFBS_HasStdExtA,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/4,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Monotonic,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_swap:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)<<P:Predicate_atomic_swap_32>><<P:Predicate_atomic_swap_32_monotonic>>  =>  (AMOSWAP_W:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::AMOSWAP_W,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 63950,
        GIR_Done,
      // Label 1474: @30397
      GIM_Try, /*On fail goto*//*Label 1475*/ 30431, // Rule ID 63970 //
        GIM_CheckFeatures, GIFBS_HasStdExtA,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/4,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Acquire,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_swap:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)<<P:Predicate_atomic_swap_32>><<P:Predicate_atomic_swap_32_acquire>>  =>  (AMOSWAP_W_AQ:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::AMOSWAP_W_AQ,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 63970,
        GIR_Done,
      // Label 1475: @30431
      GIM_Try, /*On fail goto*//*Label 1476*/ 30465, // Rule ID 63992 //
        GIM_CheckFeatures, GIFBS_HasStdExtA,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/4,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Release,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_swap:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)<<P:Predicate_atomic_swap_32>><<P:Predicate_atomic_swap_32_release>>  =>  (AMOSWAP_W_RL:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::AMOSWAP_W_RL,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 63992,
        GIR_Done,
      // Label 1476: @30465
      GIM_Try, /*On fail goto*//*Label 1477*/ 30499, // Rule ID 64014 //
        GIM_CheckFeatures, GIFBS_HasStdExtA,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/4,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::AcquireRelease,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_swap:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)<<P:Predicate_atomic_swap_32>><<P:Predicate_atomic_swap_32_acq_rel>>  =>  (AMOSWAP_W_AQ_RL:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::AMOSWAP_W_AQ_RL,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 64014,
        GIR_Done,
      // Label 1477: @30499
      GIM_Try, /*On fail goto*//*Label 1478*/ 30533, // Rule ID 64036 //
        GIM_CheckFeatures, GIFBS_HasStdExtA,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/4,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::SequentiallyConsistent,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_swap:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)<<P:Predicate_atomic_swap_32>><<P:Predicate_atomic_swap_32_seq_cst>>  =>  (AMOSWAP_W_AQ_RL:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::AMOSWAP_W_AQ_RL,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 64036,
        GIR_Done,
      // Label 1478: @30533
      GIM_Try, /*On fail goto*//*Label 1479*/ 30567, // Rule ID 65026 //
        GIM_CheckFeatures, GIFBS_HasStdExtA_IsRV64,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/8,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Monotonic,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_swap:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)<<P:Predicate_atomic_swap_64>><<P:Predicate_atomic_swap_64_monotonic>>  =>  (AMOSWAP_D:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::AMOSWAP_D,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 65026,
        GIR_Done,
      // Label 1479: @30567
      GIM_Try, /*On fail goto*//*Label 1480*/ 30601, // Rule ID 65028 //
        GIM_CheckFeatures, GIFBS_HasStdExtA_IsRV64,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/8,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Acquire,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_swap:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)<<P:Predicate_atomic_swap_64>><<P:Predicate_atomic_swap_64_acquire>>  =>  (AMOSWAP_D_AQ:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::AMOSWAP_D_AQ,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 65028,
        GIR_Done,
      // Label 1480: @30601
      GIM_Try, /*On fail goto*//*Label 1481*/ 30635, // Rule ID 65030 //
        GIM_CheckFeatures, GIFBS_HasStdExtA_IsRV64,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/8,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Release,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_swap:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)<<P:Predicate_atomic_swap_64>><<P:Predicate_atomic_swap_64_release>>  =>  (AMOSWAP_D_RL:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::AMOSWAP_D_RL,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 65030,
        GIR_Done,
      // Label 1481: @30635
      GIM_Try, /*On fail goto*//*Label 1482*/ 30669, // Rule ID 65032 //
        GIM_CheckFeatures, GIFBS_HasStdExtA_IsRV64,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/8,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::AcquireRelease,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_swap:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)<<P:Predicate_atomic_swap_64>><<P:Predicate_atomic_swap_64_acq_rel>>  =>  (AMOSWAP_D_AQ_RL:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::AMOSWAP_D_AQ_RL,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 65032,
        GIR_Done,
      // Label 1482: @30669
      GIM_Try, /*On fail goto*//*Label 1483*/ 30703, // Rule ID 65034 //
        GIM_CheckFeatures, GIFBS_HasStdExtA_IsRV64,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/8,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::SequentiallyConsistent,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_swap:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)<<P:Predicate_atomic_swap_64>><<P:Predicate_atomic_swap_64_seq_cst>>  =>  (AMOSWAP_D_AQ_RL:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::AMOSWAP_D_AQ_RL,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 65034,
        GIR_Done,
      // Label 1483: @30703
      GIM_Reject,
    // Label 1473: @30704
    GIM_Reject,
    // Label 1461: @30705
    GIM_Reject,
    // Label 16: @30706
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/1, 3, /*)*//*default:*//*Label 1486*/ 31410,
    /*GILLT_s32*//*Label 1484*/ 30714,
    /*GILLT_s64*//*Label 1485*/ 31062,
    // Label 1484: @30714
    GIM_Try, /*On fail goto*//*Label 1487*/ 31061,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
      GIM_Try, /*On fail goto*//*Label 1488*/ 30754, // Rule ID 64099 //
        GIM_CheckFeatures, GIFBS_HasStdExtA,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/4,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Monotonic,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_load_add:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)<<P:Predicate_atomic_load_add_32>><<P:Predicate_atomic_load_add_32_monotonic>>  =>  (AMOADD_W:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::AMOADD_W,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 64099,
        GIR_Done,
      // Label 1488: @30754
      GIM_Try, /*On fail goto*//*Label 1489*/ 30788, // Rule ID 64121 //
        GIM_CheckFeatures, GIFBS_HasStdExtA,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/4,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Acquire,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_load_add:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)<<P:Predicate_atomic_load_add_32>><<P:Predicate_atomic_load_add_32_acquire>>  =>  (AMOADD_W_AQ:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::AMOADD_W_AQ,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 64121,
        GIR_Done,
      // Label 1489: @30788
      GIM_Try, /*On fail goto*//*Label 1490*/ 30822, // Rule ID 64143 //
        GIM_CheckFeatures, GIFBS_HasStdExtA,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/4,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Release,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_load_add:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)<<P:Predicate_atomic_load_add_32>><<P:Predicate_atomic_load_add_32_release>>  =>  (AMOADD_W_RL:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::AMOADD_W_RL,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 64143,
        GIR_Done,
      // Label 1490: @30822
      GIM_Try, /*On fail goto*//*Label 1491*/ 30856, // Rule ID 64163 //
        GIM_CheckFeatures, GIFBS_HasStdExtA,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/4,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::AcquireRelease,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_load_add:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)<<P:Predicate_atomic_load_add_32>><<P:Predicate_atomic_load_add_32_acq_rel>>  =>  (AMOADD_W_AQ_RL:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::AMOADD_W_AQ_RL,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 64163,
        GIR_Done,
      // Label 1491: @30856
      GIM_Try, /*On fail goto*//*Label 1492*/ 30890, // Rule ID 64183 //
        GIM_CheckFeatures, GIFBS_HasStdExtA,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/4,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::SequentiallyConsistent,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_load_add:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)<<P:Predicate_atomic_load_add_32>><<P:Predicate_atomic_load_add_32_seq_cst>>  =>  (AMOADD_W_AQ_RL:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::AMOADD_W_AQ_RL,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 64183,
        GIR_Done,
      // Label 1492: @30890
      GIM_Try, /*On fail goto*//*Label 1493*/ 30924, // Rule ID 65037 //
        GIM_CheckFeatures, GIFBS_HasStdExtA_IsRV64,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/8,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Monotonic,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_load_add:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)<<P:Predicate_atomic_load_add_64>><<P:Predicate_atomic_load_add_64_monotonic>>  =>  (AMOADD_D:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::AMOADD_D,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 65037,
        GIR_Done,
      // Label 1493: @30924
      GIM_Try, /*On fail goto*//*Label 1494*/ 30958, // Rule ID 65039 //
        GIM_CheckFeatures, GIFBS_HasStdExtA_IsRV64,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/8,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Acquire,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_load_add:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)<<P:Predicate_atomic_load_add_64>><<P:Predicate_atomic_load_add_64_acquire>>  =>  (AMOADD_D_AQ:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::AMOADD_D_AQ,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 65039,
        GIR_Done,
      // Label 1494: @30958
      GIM_Try, /*On fail goto*//*Label 1495*/ 30992, // Rule ID 65041 //
        GIM_CheckFeatures, GIFBS_HasStdExtA_IsRV64,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/8,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Release,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_load_add:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)<<P:Predicate_atomic_load_add_64>><<P:Predicate_atomic_load_add_64_release>>  =>  (AMOADD_D_RL:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::AMOADD_D_RL,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 65041,
        GIR_Done,
      // Label 1495: @30992
      GIM_Try, /*On fail goto*//*Label 1496*/ 31026, // Rule ID 65043 //
        GIM_CheckFeatures, GIFBS_HasStdExtA_IsRV64,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/8,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::AcquireRelease,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_load_add:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)<<P:Predicate_atomic_load_add_64>><<P:Predicate_atomic_load_add_64_acq_rel>>  =>  (AMOADD_D_AQ_RL:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::AMOADD_D_AQ_RL,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 65043,
        GIR_Done,
      // Label 1496: @31026
      GIM_Try, /*On fail goto*//*Label 1497*/ 31060, // Rule ID 65045 //
        GIM_CheckFeatures, GIFBS_HasStdExtA_IsRV64,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/8,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::SequentiallyConsistent,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_load_add:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)<<P:Predicate_atomic_load_add_64>><<P:Predicate_atomic_load_add_64_seq_cst>>  =>  (AMOADD_D_AQ_RL:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::AMOADD_D_AQ_RL,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 65045,
        GIR_Done,
      // Label 1497: @31060
      GIM_Reject,
    // Label 1487: @31061
    GIM_Reject,
    // Label 1485: @31062
    GIM_Try, /*On fail goto*//*Label 1498*/ 31409,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
      GIM_Try, /*On fail goto*//*Label 1499*/ 31102, // Rule ID 64098 //
        GIM_CheckFeatures, GIFBS_HasStdExtA,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/4,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Monotonic,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_load_add:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)<<P:Predicate_atomic_load_add_32>><<P:Predicate_atomic_load_add_32_monotonic>>  =>  (AMOADD_W:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::AMOADD_W,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 64098,
        GIR_Done,
      // Label 1499: @31102
      GIM_Try, /*On fail goto*//*Label 1500*/ 31136, // Rule ID 64120 //
        GIM_CheckFeatures, GIFBS_HasStdExtA,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/4,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Acquire,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_load_add:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)<<P:Predicate_atomic_load_add_32>><<P:Predicate_atomic_load_add_32_acquire>>  =>  (AMOADD_W_AQ:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::AMOADD_W_AQ,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 64120,
        GIR_Done,
      // Label 1500: @31136
      GIM_Try, /*On fail goto*//*Label 1501*/ 31170, // Rule ID 64142 //
        GIM_CheckFeatures, GIFBS_HasStdExtA,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/4,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Release,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_load_add:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)<<P:Predicate_atomic_load_add_32>><<P:Predicate_atomic_load_add_32_release>>  =>  (AMOADD_W_RL:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::AMOADD_W_RL,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 64142,
        GIR_Done,
      // Label 1501: @31170
      GIM_Try, /*On fail goto*//*Label 1502*/ 31204, // Rule ID 64162 //
        GIM_CheckFeatures, GIFBS_HasStdExtA,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/4,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::AcquireRelease,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_load_add:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)<<P:Predicate_atomic_load_add_32>><<P:Predicate_atomic_load_add_32_acq_rel>>  =>  (AMOADD_W_AQ_RL:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::AMOADD_W_AQ_RL,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 64162,
        GIR_Done,
      // Label 1502: @31204
      GIM_Try, /*On fail goto*//*Label 1503*/ 31238, // Rule ID 64182 //
        GIM_CheckFeatures, GIFBS_HasStdExtA,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/4,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::SequentiallyConsistent,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_load_add:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)<<P:Predicate_atomic_load_add_32>><<P:Predicate_atomic_load_add_32_seq_cst>>  =>  (AMOADD_W_AQ_RL:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::AMOADD_W_AQ_RL,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 64182,
        GIR_Done,
      // Label 1503: @31238
      GIM_Try, /*On fail goto*//*Label 1504*/ 31272, // Rule ID 65036 //
        GIM_CheckFeatures, GIFBS_HasStdExtA_IsRV64,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/8,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Monotonic,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_load_add:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)<<P:Predicate_atomic_load_add_64>><<P:Predicate_atomic_load_add_64_monotonic>>  =>  (AMOADD_D:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::AMOADD_D,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 65036,
        GIR_Done,
      // Label 1504: @31272
      GIM_Try, /*On fail goto*//*Label 1505*/ 31306, // Rule ID 65038 //
        GIM_CheckFeatures, GIFBS_HasStdExtA_IsRV64,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/8,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Acquire,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_load_add:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)<<P:Predicate_atomic_load_add_64>><<P:Predicate_atomic_load_add_64_acquire>>  =>  (AMOADD_D_AQ:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::AMOADD_D_AQ,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 65038,
        GIR_Done,
      // Label 1505: @31306
      GIM_Try, /*On fail goto*//*Label 1506*/ 31340, // Rule ID 65040 //
        GIM_CheckFeatures, GIFBS_HasStdExtA_IsRV64,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/8,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Release,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_load_add:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)<<P:Predicate_atomic_load_add_64>><<P:Predicate_atomic_load_add_64_release>>  =>  (AMOADD_D_RL:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::AMOADD_D_RL,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 65040,
        GIR_Done,
      // Label 1506: @31340
      GIM_Try, /*On fail goto*//*Label 1507*/ 31374, // Rule ID 65042 //
        GIM_CheckFeatures, GIFBS_HasStdExtA_IsRV64,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/8,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::AcquireRelease,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_load_add:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)<<P:Predicate_atomic_load_add_64>><<P:Predicate_atomic_load_add_64_acq_rel>>  =>  (AMOADD_D_AQ_RL:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::AMOADD_D_AQ_RL,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 65042,
        GIR_Done,
      // Label 1507: @31374
      GIM_Try, /*On fail goto*//*Label 1508*/ 31408, // Rule ID 65044 //
        GIM_CheckFeatures, GIFBS_HasStdExtA_IsRV64,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/8,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::SequentiallyConsistent,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_load_add:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)<<P:Predicate_atomic_load_add_64>><<P:Predicate_atomic_load_add_64_seq_cst>>  =>  (AMOADD_D_AQ_RL:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::AMOADD_D_AQ_RL,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 65044,
        GIR_Done,
      // Label 1508: @31408
      GIM_Reject,
    // Label 1498: @31409
    GIM_Reject,
    // Label 1486: @31410
    GIM_Reject,
    // Label 17: @31411
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/1, 3, /*)*//*default:*//*Label 1511*/ 32484,
    /*GILLT_s32*//*Label 1509*/ 31419,
    /*GILLT_s64*//*Label 1510*/ 31766,
    // Label 1509: @31419
    GIM_Try, /*On fail goto*//*Label 1512*/ 31765,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
      GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/4,
      GIM_Try, /*On fail goto*//*Label 1513*/ 31496, // Rule ID 64848 //
        GIM_CheckFeatures, GIFBS_HasStdExtA,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Monotonic,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] addr
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_load_sub:{ *:[i32] } GPR:{ *:[i32] }:$addr, GPR:{ *:[i32] }:$incr)<<P:Predicate_atomic_load_sub_32>><<P:Predicate_atomic_load_sub_32_monotonic>>  =>  (AMOADD_W:{ *:[i32] } GPR:{ *:[i32] }:$addr, (SUB:{ *:[i32] } X0:{ *:[i32] }, GPR:{ *:[i32] }:$incr))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/RISCV::SUB,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_AddRegister, /*InsnID*/1, RISCV::X0, /*AddRegisterRegFlags*/0,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/2, // incr
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::AMOADD_W,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // addr
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 64848,
        GIR_Done,
      // Label 1513: @31496
      GIM_Try, /*On fail goto*//*Label 1514*/ 31563, // Rule ID 64850 //
        GIM_CheckFeatures, GIFBS_HasStdExtA,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Acquire,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] addr
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_load_sub:{ *:[i32] } GPR:{ *:[i32] }:$addr, GPR:{ *:[i32] }:$incr)<<P:Predicate_atomic_load_sub_32>><<P:Predicate_atomic_load_sub_32_acquire>>  =>  (AMOADD_W_AQ:{ *:[i32] } GPR:{ *:[i32] }:$addr, (SUB:{ *:[i32] } X0:{ *:[i32] }, GPR:{ *:[i32] }:$incr))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/RISCV::SUB,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_AddRegister, /*InsnID*/1, RISCV::X0, /*AddRegisterRegFlags*/0,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/2, // incr
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::AMOADD_W_AQ,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // addr
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 64850,
        GIR_Done,
      // Label 1514: @31563
      GIM_Try, /*On fail goto*//*Label 1515*/ 31630, // Rule ID 64852 //
        GIM_CheckFeatures, GIFBS_HasStdExtA,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Release,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] addr
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_load_sub:{ *:[i32] } GPR:{ *:[i32] }:$addr, GPR:{ *:[i32] }:$incr)<<P:Predicate_atomic_load_sub_32>><<P:Predicate_atomic_load_sub_32_release>>  =>  (AMOADD_W_RL:{ *:[i32] } GPR:{ *:[i32] }:$addr, (SUB:{ *:[i32] } X0:{ *:[i32] }, GPR:{ *:[i32] }:$incr))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/RISCV::SUB,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_AddRegister, /*InsnID*/1, RISCV::X0, /*AddRegisterRegFlags*/0,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/2, // incr
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::AMOADD_W_RL,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // addr
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 64852,
        GIR_Done,
      // Label 1515: @31630
      GIM_Try, /*On fail goto*//*Label 1516*/ 31697, // Rule ID 64854 //
        GIM_CheckFeatures, GIFBS_HasStdExtA,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::AcquireRelease,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] addr
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_load_sub:{ *:[i32] } GPR:{ *:[i32] }:$addr, GPR:{ *:[i32] }:$incr)<<P:Predicate_atomic_load_sub_32>><<P:Predicate_atomic_load_sub_32_acq_rel>>  =>  (AMOADD_W_AQ_RL:{ *:[i32] } GPR:{ *:[i32] }:$addr, (SUB:{ *:[i32] } X0:{ *:[i32] }, GPR:{ *:[i32] }:$incr))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/RISCV::SUB,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_AddRegister, /*InsnID*/1, RISCV::X0, /*AddRegisterRegFlags*/0,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/2, // incr
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::AMOADD_W_AQ_RL,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // addr
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 64854,
        GIR_Done,
      // Label 1516: @31697
      GIM_Try, /*On fail goto*//*Label 1517*/ 31764, // Rule ID 64874 //
        GIM_CheckFeatures, GIFBS_HasStdExtA,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::SequentiallyConsistent,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] addr
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_load_sub:{ *:[i32] } GPR:{ *:[i32] }:$addr, GPR:{ *:[i32] }:$incr)<<P:Predicate_atomic_load_sub_32>><<P:Predicate_atomic_load_sub_32_seq_cst>>  =>  (AMOADD_W_AQ_RL:{ *:[i32] } GPR:{ *:[i32] }:$addr, (SUB:{ *:[i32] } X0:{ *:[i32] }, GPR:{ *:[i32] }:$incr))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/RISCV::SUB,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_AddRegister, /*InsnID*/1, RISCV::X0, /*AddRegisterRegFlags*/0,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/2, // incr
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::AMOADD_W_AQ_RL,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // addr
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 64874,
        GIR_Done,
      // Label 1517: @31764
      GIM_Reject,
    // Label 1512: @31765
    GIM_Reject,
    // Label 1510: @31766
    GIM_Try, /*On fail goto*//*Label 1518*/ 32483,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
      GIM_Try, /*On fail goto*//*Label 1519*/ 31843, // Rule ID 64847 //
        GIM_CheckFeatures, GIFBS_HasStdExtA,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/4,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Monotonic,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] addr
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_load_sub:{ *:[i64] } GPR:{ *:[i64] }:$addr, GPR:{ *:[i64] }:$incr)<<P:Predicate_atomic_load_sub_32>><<P:Predicate_atomic_load_sub_32_monotonic>>  =>  (AMOADD_W:{ *:[i64] } GPR:{ *:[i64] }:$addr, (SUB:{ *:[i64] } X0:{ *:[i64] }, GPR:{ *:[i64] }:$incr))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/RISCV::SUB,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_AddRegister, /*InsnID*/1, RISCV::X0, /*AddRegisterRegFlags*/0,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/2, // incr
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::AMOADD_W,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // addr
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 64847,
        GIR_Done,
      // Label 1519: @31843
      GIM_Try, /*On fail goto*//*Label 1520*/ 31914, // Rule ID 64849 //
        GIM_CheckFeatures, GIFBS_HasStdExtA,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/4,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Acquire,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] addr
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_load_sub:{ *:[i64] } GPR:{ *:[i64] }:$addr, GPR:{ *:[i64] }:$incr)<<P:Predicate_atomic_load_sub_32>><<P:Predicate_atomic_load_sub_32_acquire>>  =>  (AMOADD_W_AQ:{ *:[i64] } GPR:{ *:[i64] }:$addr, (SUB:{ *:[i64] } X0:{ *:[i64] }, GPR:{ *:[i64] }:$incr))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/RISCV::SUB,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_AddRegister, /*InsnID*/1, RISCV::X0, /*AddRegisterRegFlags*/0,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/2, // incr
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::AMOADD_W_AQ,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // addr
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 64849,
        GIR_Done,
      // Label 1520: @31914
      GIM_Try, /*On fail goto*//*Label 1521*/ 31985, // Rule ID 64851 //
        GIM_CheckFeatures, GIFBS_HasStdExtA,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/4,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Release,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] addr
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_load_sub:{ *:[i64] } GPR:{ *:[i64] }:$addr, GPR:{ *:[i64] }:$incr)<<P:Predicate_atomic_load_sub_32>><<P:Predicate_atomic_load_sub_32_release>>  =>  (AMOADD_W_RL:{ *:[i64] } GPR:{ *:[i64] }:$addr, (SUB:{ *:[i64] } X0:{ *:[i64] }, GPR:{ *:[i64] }:$incr))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/RISCV::SUB,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_AddRegister, /*InsnID*/1, RISCV::X0, /*AddRegisterRegFlags*/0,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/2, // incr
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::AMOADD_W_RL,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // addr
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 64851,
        GIR_Done,
      // Label 1521: @31985
      GIM_Try, /*On fail goto*//*Label 1522*/ 32056, // Rule ID 64853 //
        GIM_CheckFeatures, GIFBS_HasStdExtA,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/4,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::AcquireRelease,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] addr
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_load_sub:{ *:[i64] } GPR:{ *:[i64] }:$addr, GPR:{ *:[i64] }:$incr)<<P:Predicate_atomic_load_sub_32>><<P:Predicate_atomic_load_sub_32_acq_rel>>  =>  (AMOADD_W_AQ_RL:{ *:[i64] } GPR:{ *:[i64] }:$addr, (SUB:{ *:[i64] } X0:{ *:[i64] }, GPR:{ *:[i64] }:$incr))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/RISCV::SUB,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_AddRegister, /*InsnID*/1, RISCV::X0, /*AddRegisterRegFlags*/0,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/2, // incr
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::AMOADD_W_AQ_RL,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // addr
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 64853,
        GIR_Done,
      // Label 1522: @32056
      GIM_Try, /*On fail goto*//*Label 1523*/ 32127, // Rule ID 64873 //
        GIM_CheckFeatures, GIFBS_HasStdExtA,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/4,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::SequentiallyConsistent,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] addr
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_load_sub:{ *:[i64] } GPR:{ *:[i64] }:$addr, GPR:{ *:[i64] }:$incr)<<P:Predicate_atomic_load_sub_32>><<P:Predicate_atomic_load_sub_32_seq_cst>>  =>  (AMOADD_W_AQ_RL:{ *:[i64] } GPR:{ *:[i64] }:$addr, (SUB:{ *:[i64] } X0:{ *:[i64] }, GPR:{ *:[i64] }:$incr))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/RISCV::SUB,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_AddRegister, /*InsnID*/1, RISCV::X0, /*AddRegisterRegFlags*/0,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/2, // incr
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::AMOADD_W_AQ_RL,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // addr
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 64873,
        GIR_Done,
      // Label 1523: @32127
      GIM_Try, /*On fail goto*//*Label 1524*/ 32198, // Rule ID 65116 //
        GIM_CheckFeatures, GIFBS_HasStdExtA_IsRV64,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/8,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Monotonic,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] addr
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_load_sub:{ *:[i64] } GPR:{ *:[i64] }:$addr, GPR:{ *:[i64] }:$incr)<<P:Predicate_atomic_load_sub_64>><<P:Predicate_atomic_load_sub_64_monotonic>>  =>  (AMOADD_D:{ *:[i64] } GPR:{ *:[i64] }:$addr, (SUB:{ *:[i64] } X0:{ *:[i64] }, GPR:{ *:[i64] }:$incr))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/RISCV::SUB,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_AddRegister, /*InsnID*/1, RISCV::X0, /*AddRegisterRegFlags*/0,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/2, // incr
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::AMOADD_D,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // addr
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 65116,
        GIR_Done,
      // Label 1524: @32198
      GIM_Try, /*On fail goto*//*Label 1525*/ 32269, // Rule ID 65117 //
        GIM_CheckFeatures, GIFBS_HasStdExtA_IsRV64,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/8,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Acquire,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] addr
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_load_sub:{ *:[i64] } GPR:{ *:[i64] }:$addr, GPR:{ *:[i64] }:$incr)<<P:Predicate_atomic_load_sub_64>><<P:Predicate_atomic_load_sub_64_acquire>>  =>  (AMOADD_D_AQ:{ *:[i64] } GPR:{ *:[i64] }:$addr, (SUB:{ *:[i64] } X0:{ *:[i64] }, GPR:{ *:[i64] }:$incr))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/RISCV::SUB,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_AddRegister, /*InsnID*/1, RISCV::X0, /*AddRegisterRegFlags*/0,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/2, // incr
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::AMOADD_D_AQ,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // addr
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 65117,
        GIR_Done,
      // Label 1525: @32269
      GIM_Try, /*On fail goto*//*Label 1526*/ 32340, // Rule ID 65118 //
        GIM_CheckFeatures, GIFBS_HasStdExtA_IsRV64,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/8,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Release,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] addr
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_load_sub:{ *:[i64] } GPR:{ *:[i64] }:$addr, GPR:{ *:[i64] }:$incr)<<P:Predicate_atomic_load_sub_64>><<P:Predicate_atomic_load_sub_64_release>>  =>  (AMOADD_D_RL:{ *:[i64] } GPR:{ *:[i64] }:$addr, (SUB:{ *:[i64] } X0:{ *:[i64] }, GPR:{ *:[i64] }:$incr))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/RISCV::SUB,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_AddRegister, /*InsnID*/1, RISCV::X0, /*AddRegisterRegFlags*/0,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/2, // incr
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::AMOADD_D_RL,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // addr
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 65118,
        GIR_Done,
      // Label 1526: @32340
      GIM_Try, /*On fail goto*//*Label 1527*/ 32411, // Rule ID 65119 //
        GIM_CheckFeatures, GIFBS_HasStdExtA_IsRV64,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/8,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::AcquireRelease,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] addr
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_load_sub:{ *:[i64] } GPR:{ *:[i64] }:$addr, GPR:{ *:[i64] }:$incr)<<P:Predicate_atomic_load_sub_64>><<P:Predicate_atomic_load_sub_64_acq_rel>>  =>  (AMOADD_D_AQ_RL:{ *:[i64] } GPR:{ *:[i64] }:$addr, (SUB:{ *:[i64] } X0:{ *:[i64] }, GPR:{ *:[i64] }:$incr))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/RISCV::SUB,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_AddRegister, /*InsnID*/1, RISCV::X0, /*AddRegisterRegFlags*/0,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/2, // incr
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::AMOADD_D_AQ_RL,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // addr
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 65119,
        GIR_Done,
      // Label 1527: @32411
      GIM_Try, /*On fail goto*//*Label 1528*/ 32482, // Rule ID 65120 //
        GIM_CheckFeatures, GIFBS_HasStdExtA_IsRV64,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/8,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::SequentiallyConsistent,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] addr
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_load_sub:{ *:[i64] } GPR:{ *:[i64] }:$addr, GPR:{ *:[i64] }:$incr)<<P:Predicate_atomic_load_sub_64>><<P:Predicate_atomic_load_sub_64_seq_cst>>  =>  (AMOADD_D_AQ_RL:{ *:[i64] } GPR:{ *:[i64] }:$addr, (SUB:{ *:[i64] } X0:{ *:[i64] }, GPR:{ *:[i64] }:$incr))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/RISCV::SUB,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_AddRegister, /*InsnID*/1, RISCV::X0, /*AddRegisterRegFlags*/0,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/2, // incr
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::AMOADD_D_AQ_RL,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // addr
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 65120,
        GIR_Done,
      // Label 1528: @32482
      GIM_Reject,
    // Label 1518: @32483
    GIM_Reject,
    // Label 1511: @32484
    GIM_Reject,
    // Label 18: @32485
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/1, 3, /*)*//*default:*//*Label 1531*/ 33189,
    /*GILLT_s32*//*Label 1529*/ 32493,
    /*GILLT_s64*//*Label 1530*/ 32841,
    // Label 1529: @32493
    GIM_Try, /*On fail goto*//*Label 1532*/ 32840,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
      GIM_Try, /*On fail goto*//*Label 1533*/ 32533, // Rule ID 64223 //
        GIM_CheckFeatures, GIFBS_HasStdExtA,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/4,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Monotonic,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_load_and:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)<<P:Predicate_atomic_load_and_32>><<P:Predicate_atomic_load_and_32_monotonic>>  =>  (AMOAND_W:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::AMOAND_W,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 64223,
        GIR_Done,
      // Label 1533: @32533
      GIM_Try, /*On fail goto*//*Label 1534*/ 32567, // Rule ID 64243 //
        GIM_CheckFeatures, GIFBS_HasStdExtA,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/4,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Acquire,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_load_and:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)<<P:Predicate_atomic_load_and_32>><<P:Predicate_atomic_load_and_32_acquire>>  =>  (AMOAND_W_AQ:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::AMOAND_W_AQ,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 64243,
        GIR_Done,
      // Label 1534: @32567
      GIM_Try, /*On fail goto*//*Label 1535*/ 32601, // Rule ID 64265 //
        GIM_CheckFeatures, GIFBS_HasStdExtA,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/4,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Release,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_load_and:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)<<P:Predicate_atomic_load_and_32>><<P:Predicate_atomic_load_and_32_release>>  =>  (AMOAND_W_RL:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::AMOAND_W_RL,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 64265,
        GIR_Done,
      // Label 1535: @32601
      GIM_Try, /*On fail goto*//*Label 1536*/ 32635, // Rule ID 64285 //
        GIM_CheckFeatures, GIFBS_HasStdExtA,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/4,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::AcquireRelease,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_load_and:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)<<P:Predicate_atomic_load_and_32>><<P:Predicate_atomic_load_and_32_acq_rel>>  =>  (AMOAND_W_AQ_RL:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::AMOAND_W_AQ_RL,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 64285,
        GIR_Done,
      // Label 1536: @32635
      GIM_Try, /*On fail goto*//*Label 1537*/ 32669, // Rule ID 64305 //
        GIM_CheckFeatures, GIFBS_HasStdExtA,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/4,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::SequentiallyConsistent,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_load_and:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)<<P:Predicate_atomic_load_and_32>><<P:Predicate_atomic_load_and_32_seq_cst>>  =>  (AMOAND_W_AQ_RL:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::AMOAND_W_AQ_RL,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 64305,
        GIR_Done,
      // Label 1537: @32669
      GIM_Try, /*On fail goto*//*Label 1538*/ 32703, // Rule ID 65047 //
        GIM_CheckFeatures, GIFBS_HasStdExtA_IsRV64,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/8,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Monotonic,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_load_and:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)<<P:Predicate_atomic_load_and_64>><<P:Predicate_atomic_load_and_64_monotonic>>  =>  (AMOAND_D:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::AMOAND_D,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 65047,
        GIR_Done,
      // Label 1538: @32703
      GIM_Try, /*On fail goto*//*Label 1539*/ 32737, // Rule ID 65049 //
        GIM_CheckFeatures, GIFBS_HasStdExtA_IsRV64,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/8,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Acquire,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_load_and:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)<<P:Predicate_atomic_load_and_64>><<P:Predicate_atomic_load_and_64_acquire>>  =>  (AMOAND_D_AQ:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::AMOAND_D_AQ,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 65049,
        GIR_Done,
      // Label 1539: @32737
      GIM_Try, /*On fail goto*//*Label 1540*/ 32771, // Rule ID 65051 //
        GIM_CheckFeatures, GIFBS_HasStdExtA_IsRV64,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/8,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Release,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_load_and:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)<<P:Predicate_atomic_load_and_64>><<P:Predicate_atomic_load_and_64_release>>  =>  (AMOAND_D_RL:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::AMOAND_D_RL,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 65051,
        GIR_Done,
      // Label 1540: @32771
      GIM_Try, /*On fail goto*//*Label 1541*/ 32805, // Rule ID 65053 //
        GIM_CheckFeatures, GIFBS_HasStdExtA_IsRV64,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/8,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::AcquireRelease,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_load_and:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)<<P:Predicate_atomic_load_and_64>><<P:Predicate_atomic_load_and_64_acq_rel>>  =>  (AMOAND_D_AQ_RL:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::AMOAND_D_AQ_RL,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 65053,
        GIR_Done,
      // Label 1541: @32805
      GIM_Try, /*On fail goto*//*Label 1542*/ 32839, // Rule ID 65055 //
        GIM_CheckFeatures, GIFBS_HasStdExtA_IsRV64,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/8,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::SequentiallyConsistent,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_load_and:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)<<P:Predicate_atomic_load_and_64>><<P:Predicate_atomic_load_and_64_seq_cst>>  =>  (AMOAND_D_AQ_RL:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::AMOAND_D_AQ_RL,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 65055,
        GIR_Done,
      // Label 1542: @32839
      GIM_Reject,
    // Label 1532: @32840
    GIM_Reject,
    // Label 1530: @32841
    GIM_Try, /*On fail goto*//*Label 1543*/ 33188,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
      GIM_Try, /*On fail goto*//*Label 1544*/ 32881, // Rule ID 64222 //
        GIM_CheckFeatures, GIFBS_HasStdExtA,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/4,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Monotonic,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_load_and:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)<<P:Predicate_atomic_load_and_32>><<P:Predicate_atomic_load_and_32_monotonic>>  =>  (AMOAND_W:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::AMOAND_W,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 64222,
        GIR_Done,
      // Label 1544: @32881
      GIM_Try, /*On fail goto*//*Label 1545*/ 32915, // Rule ID 64242 //
        GIM_CheckFeatures, GIFBS_HasStdExtA,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/4,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Acquire,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_load_and:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)<<P:Predicate_atomic_load_and_32>><<P:Predicate_atomic_load_and_32_acquire>>  =>  (AMOAND_W_AQ:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::AMOAND_W_AQ,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 64242,
        GIR_Done,
      // Label 1545: @32915
      GIM_Try, /*On fail goto*//*Label 1546*/ 32949, // Rule ID 64264 //
        GIM_CheckFeatures, GIFBS_HasStdExtA,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/4,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Release,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_load_and:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)<<P:Predicate_atomic_load_and_32>><<P:Predicate_atomic_load_and_32_release>>  =>  (AMOAND_W_RL:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::AMOAND_W_RL,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 64264,
        GIR_Done,
      // Label 1546: @32949
      GIM_Try, /*On fail goto*//*Label 1547*/ 32983, // Rule ID 64284 //
        GIM_CheckFeatures, GIFBS_HasStdExtA,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/4,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::AcquireRelease,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_load_and:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)<<P:Predicate_atomic_load_and_32>><<P:Predicate_atomic_load_and_32_acq_rel>>  =>  (AMOAND_W_AQ_RL:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::AMOAND_W_AQ_RL,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 64284,
        GIR_Done,
      // Label 1547: @32983
      GIM_Try, /*On fail goto*//*Label 1548*/ 33017, // Rule ID 64304 //
        GIM_CheckFeatures, GIFBS_HasStdExtA,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/4,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::SequentiallyConsistent,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_load_and:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)<<P:Predicate_atomic_load_and_32>><<P:Predicate_atomic_load_and_32_seq_cst>>  =>  (AMOAND_W_AQ_RL:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::AMOAND_W_AQ_RL,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 64304,
        GIR_Done,
      // Label 1548: @33017
      GIM_Try, /*On fail goto*//*Label 1549*/ 33051, // Rule ID 65046 //
        GIM_CheckFeatures, GIFBS_HasStdExtA_IsRV64,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/8,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Monotonic,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_load_and:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)<<P:Predicate_atomic_load_and_64>><<P:Predicate_atomic_load_and_64_monotonic>>  =>  (AMOAND_D:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::AMOAND_D,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 65046,
        GIR_Done,
      // Label 1549: @33051
      GIM_Try, /*On fail goto*//*Label 1550*/ 33085, // Rule ID 65048 //
        GIM_CheckFeatures, GIFBS_HasStdExtA_IsRV64,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/8,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Acquire,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_load_and:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)<<P:Predicate_atomic_load_and_64>><<P:Predicate_atomic_load_and_64_acquire>>  =>  (AMOAND_D_AQ:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::AMOAND_D_AQ,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 65048,
        GIR_Done,
      // Label 1550: @33085
      GIM_Try, /*On fail goto*//*Label 1551*/ 33119, // Rule ID 65050 //
        GIM_CheckFeatures, GIFBS_HasStdExtA_IsRV64,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/8,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Release,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_load_and:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)<<P:Predicate_atomic_load_and_64>><<P:Predicate_atomic_load_and_64_release>>  =>  (AMOAND_D_RL:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::AMOAND_D_RL,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 65050,
        GIR_Done,
      // Label 1551: @33119
      GIM_Try, /*On fail goto*//*Label 1552*/ 33153, // Rule ID 65052 //
        GIM_CheckFeatures, GIFBS_HasStdExtA_IsRV64,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/8,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::AcquireRelease,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_load_and:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)<<P:Predicate_atomic_load_and_64>><<P:Predicate_atomic_load_and_64_acq_rel>>  =>  (AMOAND_D_AQ_RL:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::AMOAND_D_AQ_RL,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 65052,
        GIR_Done,
      // Label 1552: @33153
      GIM_Try, /*On fail goto*//*Label 1553*/ 33187, // Rule ID 65054 //
        GIM_CheckFeatures, GIFBS_HasStdExtA_IsRV64,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/8,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::SequentiallyConsistent,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_load_and:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)<<P:Predicate_atomic_load_and_64>><<P:Predicate_atomic_load_and_64_seq_cst>>  =>  (AMOAND_D_AQ_RL:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::AMOAND_D_AQ_RL,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 65054,
        GIR_Done,
      // Label 1553: @33187
      GIM_Reject,
    // Label 1543: @33188
    GIM_Reject,
    // Label 1531: @33189
    GIM_Reject,
    // Label 19: @33190
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/1, 3, /*)*//*default:*//*Label 1556*/ 34113,
    /*GILLT_s32*//*Label 1554*/ 33198,
    /*GILLT_s64*//*Label 1555*/ 33495,
    // Label 1554: @33198
    GIM_Try, /*On fail goto*//*Label 1557*/ 33494,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
      GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/4,
      GIM_Try, /*On fail goto*//*Label 1558*/ 33265, // Rule ID 64896 //
        GIM_CheckFeatures, GIFBS_HasStdExtA,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Monotonic,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] addr
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_load_nand:{ *:[i32] } GPR:{ *:[i32] }:$addr, GPR:{ *:[i32] }:$incr)<<P:Predicate_atomic_load_nand_32>><<P:Predicate_atomic_load_nand_32_monotonic>>  =>  (PseudoAtomicLoadNand32:{ *:[i32] }:{ *:[i32] } GPR:{ *:[i32] }:$addr, GPR:{ *:[i32] }:$incr, 2:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoAtomicLoadNand32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // res
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/RegState::Define|RegState::Dead,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // addr
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // incr
        GIR_AddImm, /*InsnID*/0, /*Imm*/2,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 64896,
        GIR_Done,
      // Label 1558: @33265
      GIM_Try, /*On fail goto*//*Label 1559*/ 33322, // Rule ID 64916 //
        GIM_CheckFeatures, GIFBS_HasStdExtA,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Acquire,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] addr
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_load_nand:{ *:[i32] } GPR:{ *:[i32] }:$addr, GPR:{ *:[i32] }:$incr)<<P:Predicate_atomic_load_nand_32>><<P:Predicate_atomic_load_nand_32_acquire>>  =>  (PseudoAtomicLoadNand32:{ *:[i32] }:{ *:[i32] } GPR:{ *:[i32] }:$addr, GPR:{ *:[i32] }:$incr, 4:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoAtomicLoadNand32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // res
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/RegState::Define|RegState::Dead,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // addr
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // incr
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 64916,
        GIR_Done,
      // Label 1559: @33322
      GIM_Try, /*On fail goto*//*Label 1560*/ 33379, // Rule ID 64938 //
        GIM_CheckFeatures, GIFBS_HasStdExtA,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Release,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] addr
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_load_nand:{ *:[i32] } GPR:{ *:[i32] }:$addr, GPR:{ *:[i32] }:$incr)<<P:Predicate_atomic_load_nand_32>><<P:Predicate_atomic_load_nand_32_release>>  =>  (PseudoAtomicLoadNand32:{ *:[i32] }:{ *:[i32] } GPR:{ *:[i32] }:$addr, GPR:{ *:[i32] }:$incr, 5:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoAtomicLoadNand32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // res
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/RegState::Define|RegState::Dead,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // addr
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // incr
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 64938,
        GIR_Done,
      // Label 1560: @33379
      GIM_Try, /*On fail goto*//*Label 1561*/ 33436, // Rule ID 64958 //
        GIM_CheckFeatures, GIFBS_HasStdExtA,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::AcquireRelease,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] addr
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_load_nand:{ *:[i32] } GPR:{ *:[i32] }:$addr, GPR:{ *:[i32] }:$incr)<<P:Predicate_atomic_load_nand_32>><<P:Predicate_atomic_load_nand_32_acq_rel>>  =>  (PseudoAtomicLoadNand32:{ *:[i32] }:{ *:[i32] } GPR:{ *:[i32] }:$addr, GPR:{ *:[i32] }:$incr, 6:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoAtomicLoadNand32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // res
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/RegState::Define|RegState::Dead,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // addr
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // incr
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 64958,
        GIR_Done,
      // Label 1561: @33436
      GIM_Try, /*On fail goto*//*Label 1562*/ 33493, // Rule ID 64980 //
        GIM_CheckFeatures, GIFBS_HasStdExtA,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::SequentiallyConsistent,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] addr
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_load_nand:{ *:[i32] } GPR:{ *:[i32] }:$addr, GPR:{ *:[i32] }:$incr)<<P:Predicate_atomic_load_nand_32>><<P:Predicate_atomic_load_nand_32_seq_cst>>  =>  (PseudoAtomicLoadNand32:{ *:[i32] }:{ *:[i32] } GPR:{ *:[i32] }:$addr, GPR:{ *:[i32] }:$incr, 7:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoAtomicLoadNand32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // res
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/RegState::Define|RegState::Dead,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // addr
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // incr
        GIR_AddImm, /*InsnID*/0, /*Imm*/7,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 64980,
        GIR_Done,
      // Label 1562: @33493
      GIM_Reject,
    // Label 1557: @33494
    GIM_Reject,
    // Label 1555: @33495
    GIM_Try, /*On fail goto*//*Label 1563*/ 34112,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
      GIM_Try, /*On fail goto*//*Label 1564*/ 33562, // Rule ID 64895 //
        GIM_CheckFeatures, GIFBS_HasStdExtA,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/4,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Monotonic,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] addr
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_load_nand:{ *:[i64] } GPR:{ *:[i64] }:$addr, GPR:{ *:[i64] }:$incr)<<P:Predicate_atomic_load_nand_32>><<P:Predicate_atomic_load_nand_32_monotonic>>  =>  (PseudoAtomicLoadNand32:{ *:[i64] }:{ *:[i64] } GPR:{ *:[i64] }:$addr, GPR:{ *:[i64] }:$incr, 2:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoAtomicLoadNand32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // res
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/RegState::Define|RegState::Dead,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // addr
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // incr
        GIR_AddImm, /*InsnID*/0, /*Imm*/2,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 64895,
        GIR_Done,
      // Label 1564: @33562
      GIM_Try, /*On fail goto*//*Label 1565*/ 33623, // Rule ID 64915 //
        GIM_CheckFeatures, GIFBS_HasStdExtA,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/4,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Acquire,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] addr
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_load_nand:{ *:[i64] } GPR:{ *:[i64] }:$addr, GPR:{ *:[i64] }:$incr)<<P:Predicate_atomic_load_nand_32>><<P:Predicate_atomic_load_nand_32_acquire>>  =>  (PseudoAtomicLoadNand32:{ *:[i64] }:{ *:[i64] } GPR:{ *:[i64] }:$addr, GPR:{ *:[i64] }:$incr, 4:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoAtomicLoadNand32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // res
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/RegState::Define|RegState::Dead,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // addr
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // incr
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 64915,
        GIR_Done,
      // Label 1565: @33623
      GIM_Try, /*On fail goto*//*Label 1566*/ 33684, // Rule ID 64937 //
        GIM_CheckFeatures, GIFBS_HasStdExtA,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/4,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Release,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] addr
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_load_nand:{ *:[i64] } GPR:{ *:[i64] }:$addr, GPR:{ *:[i64] }:$incr)<<P:Predicate_atomic_load_nand_32>><<P:Predicate_atomic_load_nand_32_release>>  =>  (PseudoAtomicLoadNand32:{ *:[i64] }:{ *:[i64] } GPR:{ *:[i64] }:$addr, GPR:{ *:[i64] }:$incr, 5:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoAtomicLoadNand32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // res
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/RegState::Define|RegState::Dead,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // addr
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // incr
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 64937,
        GIR_Done,
      // Label 1566: @33684
      GIM_Try, /*On fail goto*//*Label 1567*/ 33745, // Rule ID 64957 //
        GIM_CheckFeatures, GIFBS_HasStdExtA,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/4,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::AcquireRelease,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] addr
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_load_nand:{ *:[i64] } GPR:{ *:[i64] }:$addr, GPR:{ *:[i64] }:$incr)<<P:Predicate_atomic_load_nand_32>><<P:Predicate_atomic_load_nand_32_acq_rel>>  =>  (PseudoAtomicLoadNand32:{ *:[i64] }:{ *:[i64] } GPR:{ *:[i64] }:$addr, GPR:{ *:[i64] }:$incr, 6:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoAtomicLoadNand32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // res
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/RegState::Define|RegState::Dead,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // addr
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // incr
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 64957,
        GIR_Done,
      // Label 1567: @33745
      GIM_Try, /*On fail goto*//*Label 1568*/ 33806, // Rule ID 64979 //
        GIM_CheckFeatures, GIFBS_HasStdExtA,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/4,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::SequentiallyConsistent,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] addr
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_load_nand:{ *:[i64] } GPR:{ *:[i64] }:$addr, GPR:{ *:[i64] }:$incr)<<P:Predicate_atomic_load_nand_32>><<P:Predicate_atomic_load_nand_32_seq_cst>>  =>  (PseudoAtomicLoadNand32:{ *:[i64] }:{ *:[i64] } GPR:{ *:[i64] }:$addr, GPR:{ *:[i64] }:$incr, 7:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoAtomicLoadNand32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // res
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/RegState::Define|RegState::Dead,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // addr
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // incr
        GIR_AddImm, /*InsnID*/0, /*Imm*/7,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 64979,
        GIR_Done,
      // Label 1568: @33806
      GIM_Try, /*On fail goto*//*Label 1569*/ 33867, // Rule ID 65121 //
        GIM_CheckFeatures, GIFBS_HasStdExtA_IsRV64,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/8,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Monotonic,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] addr
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_load_nand:{ *:[i64] } GPR:{ *:[i64] }:$addr, GPR:{ *:[i64] }:$incr)<<P:Predicate_atomic_load_nand_64>><<P:Predicate_atomic_load_nand_64_monotonic>>  =>  (PseudoAtomicLoadNand64:{ *:[i64] }:{ *:[i64] } GPR:{ *:[i64] }:$addr, GPR:{ *:[i64] }:$incr, 2:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoAtomicLoadNand64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // res
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/RegState::Define|RegState::Dead,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // addr
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // incr
        GIR_AddImm, /*InsnID*/0, /*Imm*/2,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 65121,
        GIR_Done,
      // Label 1569: @33867
      GIM_Try, /*On fail goto*//*Label 1570*/ 33928, // Rule ID 65122 //
        GIM_CheckFeatures, GIFBS_HasStdExtA_IsRV64,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/8,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Acquire,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] addr
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_load_nand:{ *:[i64] } GPR:{ *:[i64] }:$addr, GPR:{ *:[i64] }:$incr)<<P:Predicate_atomic_load_nand_64>><<P:Predicate_atomic_load_nand_64_acquire>>  =>  (PseudoAtomicLoadNand64:{ *:[i64] }:{ *:[i64] } GPR:{ *:[i64] }:$addr, GPR:{ *:[i64] }:$incr, 4:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoAtomicLoadNand64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // res
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/RegState::Define|RegState::Dead,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // addr
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // incr
        GIR_AddImm, /*InsnID*/0, /*Imm*/4,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 65122,
        GIR_Done,
      // Label 1570: @33928
      GIM_Try, /*On fail goto*//*Label 1571*/ 33989, // Rule ID 65123 //
        GIM_CheckFeatures, GIFBS_HasStdExtA_IsRV64,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/8,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Release,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] addr
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_load_nand:{ *:[i64] } GPR:{ *:[i64] }:$addr, GPR:{ *:[i64] }:$incr)<<P:Predicate_atomic_load_nand_64>><<P:Predicate_atomic_load_nand_64_release>>  =>  (PseudoAtomicLoadNand64:{ *:[i64] }:{ *:[i64] } GPR:{ *:[i64] }:$addr, GPR:{ *:[i64] }:$incr, 5:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoAtomicLoadNand64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // res
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/RegState::Define|RegState::Dead,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // addr
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // incr
        GIR_AddImm, /*InsnID*/0, /*Imm*/5,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 65123,
        GIR_Done,
      // Label 1571: @33989
      GIM_Try, /*On fail goto*//*Label 1572*/ 34050, // Rule ID 65124 //
        GIM_CheckFeatures, GIFBS_HasStdExtA_IsRV64,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/8,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::AcquireRelease,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] addr
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_load_nand:{ *:[i64] } GPR:{ *:[i64] }:$addr, GPR:{ *:[i64] }:$incr)<<P:Predicate_atomic_load_nand_64>><<P:Predicate_atomic_load_nand_64_acq_rel>>  =>  (PseudoAtomicLoadNand64:{ *:[i64] }:{ *:[i64] } GPR:{ *:[i64] }:$addr, GPR:{ *:[i64] }:$incr, 6:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoAtomicLoadNand64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // res
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/RegState::Define|RegState::Dead,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // addr
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // incr
        GIR_AddImm, /*InsnID*/0, /*Imm*/6,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 65124,
        GIR_Done,
      // Label 1572: @34050
      GIM_Try, /*On fail goto*//*Label 1573*/ 34111, // Rule ID 65125 //
        GIM_CheckFeatures, GIFBS_HasStdExtA_IsRV64,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/8,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::SequentiallyConsistent,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] addr
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_load_nand:{ *:[i64] } GPR:{ *:[i64] }:$addr, GPR:{ *:[i64] }:$incr)<<P:Predicate_atomic_load_nand_64>><<P:Predicate_atomic_load_nand_64_seq_cst>>  =>  (PseudoAtomicLoadNand64:{ *:[i64] }:{ *:[i64] } GPR:{ *:[i64] }:$addr, GPR:{ *:[i64] }:$incr, 7:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/RISCV::PseudoAtomicLoadNand64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // res
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/RegState::Define|RegState::Dead,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // addr
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // incr
        GIR_AddImm, /*InsnID*/0, /*Imm*/7,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 65125,
        GIR_Done,
      // Label 1573: @34111
      GIM_Reject,
    // Label 1563: @34112
    GIM_Reject,
    // Label 1556: @34113
    GIM_Reject,
    // Label 20: @34114
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/1, 3, /*)*//*default:*//*Label 1576*/ 34818,
    /*GILLT_s32*//*Label 1574*/ 34122,
    /*GILLT_s64*//*Label 1575*/ 34470,
    // Label 1574: @34122
    GIM_Try, /*On fail goto*//*Label 1577*/ 34469,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
      GIM_Try, /*On fail goto*//*Label 1578*/ 34162, // Rule ID 64343 //
        GIM_CheckFeatures, GIFBS_HasStdExtA,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/4,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Monotonic,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_load_or:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)<<P:Predicate_atomic_load_or_32>><<P:Predicate_atomic_load_or_32_monotonic>>  =>  (AMOOR_W:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::AMOOR_W,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 64343,
        GIR_Done,
      // Label 1578: @34162
      GIM_Try, /*On fail goto*//*Label 1579*/ 34196, // Rule ID 64365 //
        GIM_CheckFeatures, GIFBS_HasStdExtA,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/4,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Acquire,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_load_or:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)<<P:Predicate_atomic_load_or_32>><<P:Predicate_atomic_load_or_32_acquire>>  =>  (AMOOR_W_AQ:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::AMOOR_W_AQ,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 64365,
        GIR_Done,
      // Label 1579: @34196
      GIM_Try, /*On fail goto*//*Label 1580*/ 34230, // Rule ID 64385 //
        GIM_CheckFeatures, GIFBS_HasStdExtA,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/4,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Release,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_load_or:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)<<P:Predicate_atomic_load_or_32>><<P:Predicate_atomic_load_or_32_release>>  =>  (AMOOR_W_RL:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::AMOOR_W_RL,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 64385,
        GIR_Done,
      // Label 1580: @34230
      GIM_Try, /*On fail goto*//*Label 1581*/ 34264, // Rule ID 64405 //
        GIM_CheckFeatures, GIFBS_HasStdExtA,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/4,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::AcquireRelease,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_load_or:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)<<P:Predicate_atomic_load_or_32>><<P:Predicate_atomic_load_or_32_acq_rel>>  =>  (AMOOR_W_AQ_RL:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::AMOOR_W_AQ_RL,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 64405,
        GIR_Done,
      // Label 1581: @34264
      GIM_Try, /*On fail goto*//*Label 1582*/ 34298, // Rule ID 64427 //
        GIM_CheckFeatures, GIFBS_HasStdExtA,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/4,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::SequentiallyConsistent,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_load_or:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)<<P:Predicate_atomic_load_or_32>><<P:Predicate_atomic_load_or_32_seq_cst>>  =>  (AMOOR_W_AQ_RL:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::AMOOR_W_AQ_RL,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 64427,
        GIR_Done,
      // Label 1582: @34298
      GIM_Try, /*On fail goto*//*Label 1583*/ 34332, // Rule ID 65057 //
        GIM_CheckFeatures, GIFBS_HasStdExtA_IsRV64,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/8,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Monotonic,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_load_or:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)<<P:Predicate_atomic_load_or_64>><<P:Predicate_atomic_load_or_64_monotonic>>  =>  (AMOOR_D:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::AMOOR_D,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 65057,
        GIR_Done,
      // Label 1583: @34332
      GIM_Try, /*On fail goto*//*Label 1584*/ 34366, // Rule ID 65059 //
        GIM_CheckFeatures, GIFBS_HasStdExtA_IsRV64,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/8,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Acquire,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_load_or:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)<<P:Predicate_atomic_load_or_64>><<P:Predicate_atomic_load_or_64_acquire>>  =>  (AMOOR_D_AQ:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::AMOOR_D_AQ,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 65059,
        GIR_Done,
      // Label 1584: @34366
      GIM_Try, /*On fail goto*//*Label 1585*/ 34400, // Rule ID 65061 //
        GIM_CheckFeatures, GIFBS_HasStdExtA_IsRV64,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/8,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Release,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_load_or:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)<<P:Predicate_atomic_load_or_64>><<P:Predicate_atomic_load_or_64_release>>  =>  (AMOOR_D_RL:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::AMOOR_D_RL,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 65061,
        GIR_Done,
      // Label 1585: @34400
      GIM_Try, /*On fail goto*//*Label 1586*/ 34434, // Rule ID 65063 //
        GIM_CheckFeatures, GIFBS_HasStdExtA_IsRV64,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/8,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::AcquireRelease,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_load_or:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)<<P:Predicate_atomic_load_or_64>><<P:Predicate_atomic_load_or_64_acq_rel>>  =>  (AMOOR_D_AQ_RL:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::AMOOR_D_AQ_RL,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 65063,
        GIR_Done,
      // Label 1586: @34434
      GIM_Try, /*On fail goto*//*Label 1587*/ 34468, // Rule ID 65065 //
        GIM_CheckFeatures, GIFBS_HasStdExtA_IsRV64,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/8,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::SequentiallyConsistent,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_load_or:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)<<P:Predicate_atomic_load_or_64>><<P:Predicate_atomic_load_or_64_seq_cst>>  =>  (AMOOR_D_AQ_RL:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::AMOOR_D_AQ_RL,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 65065,
        GIR_Done,
      // Label 1587: @34468
      GIM_Reject,
    // Label 1577: @34469
    GIM_Reject,
    // Label 1575: @34470
    GIM_Try, /*On fail goto*//*Label 1588*/ 34817,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
      GIM_Try, /*On fail goto*//*Label 1589*/ 34510, // Rule ID 64342 //
        GIM_CheckFeatures, GIFBS_HasStdExtA,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/4,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Monotonic,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_load_or:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)<<P:Predicate_atomic_load_or_32>><<P:Predicate_atomic_load_or_32_monotonic>>  =>  (AMOOR_W:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::AMOOR_W,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 64342,
        GIR_Done,
      // Label 1589: @34510
      GIM_Try, /*On fail goto*//*Label 1590*/ 34544, // Rule ID 64364 //
        GIM_CheckFeatures, GIFBS_HasStdExtA,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/4,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Acquire,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_load_or:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)<<P:Predicate_atomic_load_or_32>><<P:Predicate_atomic_load_or_32_acquire>>  =>  (AMOOR_W_AQ:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::AMOOR_W_AQ,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 64364,
        GIR_Done,
      // Label 1590: @34544
      GIM_Try, /*On fail goto*//*Label 1591*/ 34578, // Rule ID 64384 //
        GIM_CheckFeatures, GIFBS_HasStdExtA,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/4,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Release,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_load_or:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)<<P:Predicate_atomic_load_or_32>><<P:Predicate_atomic_load_or_32_release>>  =>  (AMOOR_W_RL:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::AMOOR_W_RL,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 64384,
        GIR_Done,
      // Label 1591: @34578
      GIM_Try, /*On fail goto*//*Label 1592*/ 34612, // Rule ID 64404 //
        GIM_CheckFeatures, GIFBS_HasStdExtA,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/4,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::AcquireRelease,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_load_or:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)<<P:Predicate_atomic_load_or_32>><<P:Predicate_atomic_load_or_32_acq_rel>>  =>  (AMOOR_W_AQ_RL:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::AMOOR_W_AQ_RL,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 64404,
        GIR_Done,
      // Label 1592: @34612
      GIM_Try, /*On fail goto*//*Label 1593*/ 34646, // Rule ID 64426 //
        GIM_CheckFeatures, GIFBS_HasStdExtA,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/4,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::SequentiallyConsistent,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_load_or:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)<<P:Predicate_atomic_load_or_32>><<P:Predicate_atomic_load_or_32_seq_cst>>  =>  (AMOOR_W_AQ_RL:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::AMOOR_W_AQ_RL,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 64426,
        GIR_Done,
      // Label 1593: @34646
      GIM_Try, /*On fail goto*//*Label 1594*/ 34680, // Rule ID 65056 //
        GIM_CheckFeatures, GIFBS_HasStdExtA_IsRV64,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/8,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Monotonic,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_load_or:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)<<P:Predicate_atomic_load_or_64>><<P:Predicate_atomic_load_or_64_monotonic>>  =>  (AMOOR_D:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::AMOOR_D,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 65056,
        GIR_Done,
      // Label 1594: @34680
      GIM_Try, /*On fail goto*//*Label 1595*/ 34714, // Rule ID 65058 //
        GIM_CheckFeatures, GIFBS_HasStdExtA_IsRV64,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/8,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Acquire,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_load_or:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)<<P:Predicate_atomic_load_or_64>><<P:Predicate_atomic_load_or_64_acquire>>  =>  (AMOOR_D_AQ:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::AMOOR_D_AQ,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 65058,
        GIR_Done,
      // Label 1595: @34714
      GIM_Try, /*On fail goto*//*Label 1596*/ 34748, // Rule ID 65060 //
        GIM_CheckFeatures, GIFBS_HasStdExtA_IsRV64,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/8,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Release,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_load_or:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)<<P:Predicate_atomic_load_or_64>><<P:Predicate_atomic_load_or_64_release>>  =>  (AMOOR_D_RL:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::AMOOR_D_RL,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 65060,
        GIR_Done,
      // Label 1596: @34748
      GIM_Try, /*On fail goto*//*Label 1597*/ 34782, // Rule ID 65062 //
        GIM_CheckFeatures, GIFBS_HasStdExtA_IsRV64,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/8,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::AcquireRelease,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_load_or:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)<<P:Predicate_atomic_load_or_64>><<P:Predicate_atomic_load_or_64_acq_rel>>  =>  (AMOOR_D_AQ_RL:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::AMOOR_D_AQ_RL,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 65062,
        GIR_Done,
      // Label 1597: @34782
      GIM_Try, /*On fail goto*//*Label 1598*/ 34816, // Rule ID 65064 //
        GIM_CheckFeatures, GIFBS_HasStdExtA_IsRV64,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/8,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::SequentiallyConsistent,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_load_or:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)<<P:Predicate_atomic_load_or_64>><<P:Predicate_atomic_load_or_64_seq_cst>>  =>  (AMOOR_D_AQ_RL:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::AMOOR_D_AQ_RL,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 65064,
        GIR_Done,
      // Label 1598: @34816
      GIM_Reject,
    // Label 1588: @34817
    GIM_Reject,
    // Label 1576: @34818
    GIM_Reject,
    // Label 21: @34819
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/1, 3, /*)*//*default:*//*Label 1601*/ 35523,
    /*GILLT_s32*//*Label 1599*/ 34827,
    /*GILLT_s64*//*Label 1600*/ 35175,
    // Label 1599: @34827
    GIM_Try, /*On fail goto*//*Label 1602*/ 35174,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
      GIM_Try, /*On fail goto*//*Label 1603*/ 34867, // Rule ID 64465 //
        GIM_CheckFeatures, GIFBS_HasStdExtA,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/4,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Monotonic,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_load_xor:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)<<P:Predicate_atomic_load_xor_32>><<P:Predicate_atomic_load_xor_32_monotonic>>  =>  (AMOXOR_W:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::AMOXOR_W,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 64465,
        GIR_Done,
      // Label 1603: @34867
      GIM_Try, /*On fail goto*//*Label 1604*/ 34901, // Rule ID 64487 //
        GIM_CheckFeatures, GIFBS_HasStdExtA,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/4,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Acquire,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_load_xor:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)<<P:Predicate_atomic_load_xor_32>><<P:Predicate_atomic_load_xor_32_acquire>>  =>  (AMOXOR_W_AQ:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::AMOXOR_W_AQ,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 64487,
        GIR_Done,
      // Label 1604: @34901
      GIM_Try, /*On fail goto*//*Label 1605*/ 34935, // Rule ID 64509 //
        GIM_CheckFeatures, GIFBS_HasStdExtA,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/4,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Release,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_load_xor:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)<<P:Predicate_atomic_load_xor_32>><<P:Predicate_atomic_load_xor_32_release>>  =>  (AMOXOR_W_RL:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::AMOXOR_W_RL,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 64509,
        GIR_Done,
      // Label 1605: @34935
      GIM_Try, /*On fail goto*//*Label 1606*/ 34969, // Rule ID 64531 //
        GIM_CheckFeatures, GIFBS_HasStdExtA,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/4,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::AcquireRelease,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_load_xor:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)<<P:Predicate_atomic_load_xor_32>><<P:Predicate_atomic_load_xor_32_acq_rel>>  =>  (AMOXOR_W_AQ_RL:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::AMOXOR_W_AQ_RL,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 64531,
        GIR_Done,
      // Label 1606: @34969
      GIM_Try, /*On fail goto*//*Label 1607*/ 35003, // Rule ID 64553 //
        GIM_CheckFeatures, GIFBS_HasStdExtA,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/4,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::SequentiallyConsistent,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_load_xor:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)<<P:Predicate_atomic_load_xor_32>><<P:Predicate_atomic_load_xor_32_seq_cst>>  =>  (AMOXOR_W_AQ_RL:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::AMOXOR_W_AQ_RL,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 64553,
        GIR_Done,
      // Label 1607: @35003
      GIM_Try, /*On fail goto*//*Label 1608*/ 35037, // Rule ID 65067 //
        GIM_CheckFeatures, GIFBS_HasStdExtA_IsRV64,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/8,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Monotonic,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_load_xor:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)<<P:Predicate_atomic_load_xor_64>><<P:Predicate_atomic_load_xor_64_monotonic>>  =>  (AMOXOR_D:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::AMOXOR_D,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 65067,
        GIR_Done,
      // Label 1608: @35037
      GIM_Try, /*On fail goto*//*Label 1609*/ 35071, // Rule ID 65069 //
        GIM_CheckFeatures, GIFBS_HasStdExtA_IsRV64,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/8,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Acquire,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_load_xor:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)<<P:Predicate_atomic_load_xor_64>><<P:Predicate_atomic_load_xor_64_acquire>>  =>  (AMOXOR_D_AQ:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::AMOXOR_D_AQ,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 65069,
        GIR_Done,
      // Label 1609: @35071
      GIM_Try, /*On fail goto*//*Label 1610*/ 35105, // Rule ID 65071 //
        GIM_CheckFeatures, GIFBS_HasStdExtA_IsRV64,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/8,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Release,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_load_xor:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)<<P:Predicate_atomic_load_xor_64>><<P:Predicate_atomic_load_xor_64_release>>  =>  (AMOXOR_D_RL:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::AMOXOR_D_RL,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 65071,
        GIR_Done,
      // Label 1610: @35105
      GIM_Try, /*On fail goto*//*Label 1611*/ 35139, // Rule ID 65073 //
        GIM_CheckFeatures, GIFBS_HasStdExtA_IsRV64,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/8,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::AcquireRelease,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_load_xor:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)<<P:Predicate_atomic_load_xor_64>><<P:Predicate_atomic_load_xor_64_acq_rel>>  =>  (AMOXOR_D_AQ_RL:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::AMOXOR_D_AQ_RL,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 65073,
        GIR_Done,
      // Label 1611: @35139
      GIM_Try, /*On fail goto*//*Label 1612*/ 35173, // Rule ID 65075 //
        GIM_CheckFeatures, GIFBS_HasStdExtA_IsRV64,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/8,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::SequentiallyConsistent,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_load_xor:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)<<P:Predicate_atomic_load_xor_64>><<P:Predicate_atomic_load_xor_64_seq_cst>>  =>  (AMOXOR_D_AQ_RL:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::AMOXOR_D_AQ_RL,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 65075,
        GIR_Done,
      // Label 1612: @35173
      GIM_Reject,
    // Label 1602: @35174
    GIM_Reject,
    // Label 1600: @35175
    GIM_Try, /*On fail goto*//*Label 1613*/ 35522,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
      GIM_Try, /*On fail goto*//*Label 1614*/ 35215, // Rule ID 64464 //
        GIM_CheckFeatures, GIFBS_HasStdExtA,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/4,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Monotonic,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_load_xor:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)<<P:Predicate_atomic_load_xor_32>><<P:Predicate_atomic_load_xor_32_monotonic>>  =>  (AMOXOR_W:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::AMOXOR_W,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 64464,
        GIR_Done,
      // Label 1614: @35215
      GIM_Try, /*On fail goto*//*Label 1615*/ 35249, // Rule ID 64486 //
        GIM_CheckFeatures, GIFBS_HasStdExtA,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/4,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Acquire,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_load_xor:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)<<P:Predicate_atomic_load_xor_32>><<P:Predicate_atomic_load_xor_32_acquire>>  =>  (AMOXOR_W_AQ:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::AMOXOR_W_AQ,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 64486,
        GIR_Done,
      // Label 1615: @35249
      GIM_Try, /*On fail goto*//*Label 1616*/ 35283, // Rule ID 64508 //
        GIM_CheckFeatures, GIFBS_HasStdExtA,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/4,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Release,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_load_xor:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)<<P:Predicate_atomic_load_xor_32>><<P:Predicate_atomic_load_xor_32_release>>  =>  (AMOXOR_W_RL:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::AMOXOR_W_RL,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 64508,
        GIR_Done,
      // Label 1616: @35283
      GIM_Try, /*On fail goto*//*Label 1617*/ 35317, // Rule ID 64530 //
        GIM_CheckFeatures, GIFBS_HasStdExtA,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/4,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::AcquireRelease,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_load_xor:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)<<P:Predicate_atomic_load_xor_32>><<P:Predicate_atomic_load_xor_32_acq_rel>>  =>  (AMOXOR_W_AQ_RL:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::AMOXOR_W_AQ_RL,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 64530,
        GIR_Done,
      // Label 1617: @35317
      GIM_Try, /*On fail goto*//*Label 1618*/ 35351, // Rule ID 64552 //
        GIM_CheckFeatures, GIFBS_HasStdExtA,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/4,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::SequentiallyConsistent,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_load_xor:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)<<P:Predicate_atomic_load_xor_32>><<P:Predicate_atomic_load_xor_32_seq_cst>>  =>  (AMOXOR_W_AQ_RL:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::AMOXOR_W_AQ_RL,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 64552,
        GIR_Done,
      // Label 1618: @35351
      GIM_Try, /*On fail goto*//*Label 1619*/ 35385, // Rule ID 65066 //
        GIM_CheckFeatures, GIFBS_HasStdExtA_IsRV64,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/8,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Monotonic,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_load_xor:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)<<P:Predicate_atomic_load_xor_64>><<P:Predicate_atomic_load_xor_64_monotonic>>  =>  (AMOXOR_D:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::AMOXOR_D,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 65066,
        GIR_Done,
      // Label 1619: @35385
      GIM_Try, /*On fail goto*//*Label 1620*/ 35419, // Rule ID 65068 //
        GIM_CheckFeatures, GIFBS_HasStdExtA_IsRV64,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/8,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Acquire,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_load_xor:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)<<P:Predicate_atomic_load_xor_64>><<P:Predicate_atomic_load_xor_64_acquire>>  =>  (AMOXOR_D_AQ:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::AMOXOR_D_AQ,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 65068,
        GIR_Done,
      // Label 1620: @35419
      GIM_Try, /*On fail goto*//*Label 1621*/ 35453, // Rule ID 65070 //
        GIM_CheckFeatures, GIFBS_HasStdExtA_IsRV64,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/8,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Release,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_load_xor:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)<<P:Predicate_atomic_load_xor_64>><<P:Predicate_atomic_load_xor_64_release>>  =>  (AMOXOR_D_RL:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::AMOXOR_D_RL,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 65070,
        GIR_Done,
      // Label 1621: @35453
      GIM_Try, /*On fail goto*//*Label 1622*/ 35487, // Rule ID 65072 //
        GIM_CheckFeatures, GIFBS_HasStdExtA_IsRV64,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/8,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::AcquireRelease,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_load_xor:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)<<P:Predicate_atomic_load_xor_64>><<P:Predicate_atomic_load_xor_64_acq_rel>>  =>  (AMOXOR_D_AQ_RL:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::AMOXOR_D_AQ_RL,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 65072,
        GIR_Done,
      // Label 1622: @35487
      GIM_Try, /*On fail goto*//*Label 1623*/ 35521, // Rule ID 65074 //
        GIM_CheckFeatures, GIFBS_HasStdExtA_IsRV64,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/8,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::SequentiallyConsistent,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/RISCV::GPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/RISCV::GPRRegClassID,
        // (atomic_load_xor:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)<<P:Predicate_atomic_load_xor_64>><<P:Predicate_atomic_load_xor_64_seq_cst>>  =>  (AMOXOR_D_AQ_RL:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/RISCV::AMOXOR_D_AQ_RL,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 65074,
        GIR_Done,
      // Label 1623: @35521
      GIM_Reject,
    // Label 1613: @35522
    GIM_Reject,
    // Label 1601: @35523
    GIM_Reject,
    // Label 22: @35524
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/1, 3, /*)*//*default:*//*Label 1626*/ 36228,
    /*GILLT_s32*//*Label 1624*/ 35532,
    /*GILLT_s64*//*Label 1625*/ 35880,
    // Label 1624: @35532
    GIM_Try, /*On fail goto*//*Label 1627*/ 35879,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
      GIM_Try, /*On fail goto*//*Label 1628*/ 35572, // Rule ID 64589 //
        GIM_CheckFeatures, GIFBS_HasStdExtA,
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/4,
        GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Monotonic,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/RISCV::GPRRegClassID,
        // MIs[0] rs1
        GIM_CheckPointerToAny, /