# ANGLE Supported Extensions

This is a list of all extensions currently supported by ANGLE's front-end, and
support listed for some of the tested targets for ANGLE's Vulkan back-end. To
produce a list of all supported extensions in the Vulkan back-end, run
`angle_end2end_tests` with `--gtest_filter EGLPrintEGLinfoTest.PrintGLInfo/ES*_Vulkan`.

Specifications for GLES extensions can be found in the [Khronos OpenGL ES API
Registry](http://www.khronos.org/registry/gles/)

Specifications for EGL extensions can be found in the [Khronos EGL API
Registry](http://www.khronos.org/registry/egl/)

Specifications for ANGLE-specific extensions can be found in the [ANGLE
extension registry](../extensions)

This list is automatically generated by [`gen_extensions.py`](../src/libANGLE/gen_extensions.py)
using data from registry_xml.py and gl.xml.

## GLES 2.0, 3.0, 3.1 and 3.2 extension support

*Note: some data is sampled from older drivers, so might not represent the latest driver support.*

| Extension Name | NVIDIA 1660 Win10 | Intel 630 Win10 | NVIDIA 1660 Linux | Intel 630 Linux | SwiftShader Win10 | Pixel 4 Android 11 | Pixel 6 Android 13 |
| -------------- | :---------------: | :-------------: | :---------------: | :-------------: | :---------------: | :----------------: | :----------------: |
| [GL_EXT_base_instance](https://khronos.org/registry/OpenGL/extensions/EXT/EXT_base_instance.txt) | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; |
| [GL_KHR_blend_equation_advanced](https://khronos.org/registry/OpenGL/extensions/KHR/KHR_blend_equation_advanced.txt) | &#x2714; |  | &#x2714; |  | &#x2714; | &#x2714; | &#x2714; |
| [GL_KHR_blend_equation_advanced_coherent](https://khronos.org/registry/OpenGL/extensions/KHR/KHR_blend_equation_advanced_coherent.txt) |  |  |  |  |  |  |  |
| [GL_EXT_blend_func_extended](https://khronos.org/registry/OpenGL/extensions/EXT/EXT_blend_func_extended.txt) | &#x2714; | &#x2714; | &#x2714; | &#x2714; |  | &#x2714; |  |
| [GL_EXT_blend_minmax](https://khronos.org/registry/OpenGL/extensions/EXT/EXT_blend_minmax.txt) | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; |
| [GL_EXT_buffer_storage](https://khronos.org/registry/OpenGL/extensions/EXT/EXT_buffer_storage.txt) | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; |
| [GL_EXT_clear_texture](https://khronos.org/registry/OpenGL/extensions/EXT/EXT_clear_texture.txt) |  |  |  |  |  |  |  |
| [GL_EXT_clip_control](https://khronos.org/registry/OpenGL/extensions/EXT/EXT_clip_control.txt) | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; |
| [GL_EXT_clip_cull_distance](https://khronos.org/registry/OpenGL/extensions/EXT/EXT_clip_cull_distance.txt) | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; |  |
| [GL_APPLE_clip_distance](https://khronos.org/registry/OpenGL/extensions/APPLE/APPLE_clip_distance.txt) | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; |  |
| [GL_EXT_color_buffer_float](https://khronos.org/registry/OpenGL/extensions/EXT/EXT_color_buffer_float.txt) | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; |
| [GL_EXT_color_buffer_half_float](https://khronos.org/registry/OpenGL/extensions/EXT/EXT_color_buffer_half_float.txt) | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; |
| [GL_OES_compressed_EAC_R11_signed_texture](https://khronos.org/registry/OpenGL/extensions/OES/OES_compressed_EAC_R11_signed_texture.txt) | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; |
| [GL_OES_compressed_EAC_R11_unsigned_texture](https://khronos.org/registry/OpenGL/extensions/OES/OES_compressed_EAC_R11_unsigned_texture.txt) | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; |
| [GL_OES_compressed_EAC_RG11_signed_texture](https://khronos.org/registry/OpenGL/extensions/OES/OES_compressed_EAC_RG11_signed_texture.txt) | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; |
| [GL_OES_compressed_EAC_RG11_unsigned_texture](https://khronos.org/registry/OpenGL/extensions/OES/OES_compressed_EAC_RG11_unsigned_texture.txt) | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; |
| [GL_EXT_compressed_ETC1_RGB8_sub_texture](https://khronos.org/registry/OpenGL/extensions/EXT/EXT_compressed_ETC1_RGB8_sub_texture.txt) | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; |
| [GL_OES_compressed_ETC1_RGB8_texture](https://khronos.org/registry/OpenGL/extensions/OES/OES_compressed_ETC1_RGB8_texture.txt) | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; |
| [GL_OES_compressed_ETC2_punchthroughA_RGBA8_texture](https://khronos.org/registry/OpenGL/extensions/OES/OES_compressed_ETC2_punchthroughA_RGBA8_texture.txt) | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; |
| [GL_OES_compressed_ETC2_punchthroughA_sRGB8_alpha_texture](https://khronos.org/registry/OpenGL/extensions/OES/OES_compressed_ETC2_punchthroughA_sRGB8_alpha_texture.txt) | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; |
| [GL_OES_compressed_ETC2_RGB8_texture](https://khronos.org/registry/OpenGL/extensions/OES/OES_compressed_ETC2_RGB8_texture.txt) | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; |
| [GL_OES_compressed_ETC2_RGBA8_texture](https://khronos.org/registry/OpenGL/extensions/OES/OES_compressed_ETC2_RGBA8_texture.txt) | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; |
| [GL_OES_compressed_ETC2_sRGB8_alpha8_texture](https://khronos.org/registry/OpenGL/extensions/OES/OES_compressed_ETC2_sRGB8_alpha8_texture.txt) | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; |
| [GL_OES_compressed_ETC2_sRGB8_texture](https://khronos.org/registry/OpenGL/extensions/OES/OES_compressed_ETC2_sRGB8_texture.txt) | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; |
| [GL_OES_compressed_paletted_texture](https://khronos.org/registry/OpenGL/extensions/OES/OES_compressed_paletted_texture.txt) |  |  |  |  |  |  |  |
| [GL_EXT_conservative_depth](https://khronos.org/registry/OpenGL/extensions/EXT/EXT_conservative_depth.txt) |  |  |  |  |  |  |  |
| [GL_EXT_copy_image](https://khronos.org/registry/OpenGL/extensions/EXT/EXT_copy_image.txt) | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; |
| [GL_OES_copy_image](https://khronos.org/registry/OpenGL/extensions/OES/OES_copy_image.txt) |  |  |  |  |  |  |  |
| [GL_KHR_debug](https://khronos.org/registry/OpenGL/extensions/KHR/KHR_debug.txt) | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; |
| [GL_EXT_debug_label](https://khronos.org/registry/OpenGL/extensions/EXT/EXT_debug_label.txt) | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; |
| [GL_EXT_debug_marker](https://khronos.org/registry/OpenGL/extensions/EXT/EXT_debug_marker.txt) | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; |
| [GL_OES_depth24](https://khronos.org/registry/OpenGL/extensions/OES/OES_depth24.txt) | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; |
| [GL_OES_depth32](https://khronos.org/registry/OpenGL/extensions/OES/OES_depth32.txt) | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; |
| [GL_NV_depth_buffer_float2](https://khronos.org/registry/OpenGL/extensions/NV/NV_depth_buffer_float2.txt) | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; |
| [GL_EXT_depth_clamp](https://khronos.org/registry/OpenGL/extensions/EXT/EXT_depth_clamp.txt) |  |  |  |  |  |  |  |
| [GL_ANGLE_depth_texture](https://khronos.org/registry/OpenGL/extensions/ANGLE/ANGLE_depth_texture.txt) | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; |
| [GL_OES_depth_texture](https://khronos.org/registry/OpenGL/extensions/OES/OES_depth_texture.txt) | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; |
| [GL_OES_depth_texture_cube_map](https://khronos.org/registry/OpenGL/extensions/OES/OES_depth_texture_cube_map.txt) | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; |
| [GL_EXT_discard_framebuffer](https://khronos.org/registry/OpenGL/extensions/EXT/EXT_discard_framebuffer.txt) | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; |
| [GL_EXT_disjoint_timer_query](https://khronos.org/registry/OpenGL/extensions/EXT/EXT_disjoint_timer_query.txt) | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; |
| [GL_EXT_draw_buffers](https://khronos.org/registry/OpenGL/extensions/EXT/EXT_draw_buffers.txt) | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; |
| [GL_EXT_draw_buffers_indexed](https://khronos.org/registry/OpenGL/extensions/EXT/EXT_draw_buffers_indexed.txt) | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; |
| [GL_OES_draw_buffers_indexed](https://khronos.org/registry/OpenGL/extensions/OES/OES_draw_buffers_indexed.txt) | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; |
| [GL_EXT_draw_elements_base_vertex](https://khronos.org/registry/OpenGL/extensions/EXT/EXT_draw_elements_base_vertex.txt) | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; |
| [GL_OES_draw_elements_base_vertex](https://khronos.org/registry/OpenGL/extensions/OES/OES_draw_elements_base_vertex.txt) | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; |
| [GL_EXT_draw_instanced](https://khronos.org/registry/OpenGL/extensions/EXT/EXT_draw_instanced.txt) |  |  |  |  |  |  |  |
| [GL_OES_EGL_image](https://khronos.org/registry/OpenGL/extensions/OES/OES_EGL_image.txt) | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; |
| [GL_EXT_EGL_image_array](https://khronos.org/registry/OpenGL/extensions/EXT/EXT_EGL_image_array.txt) | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; |
| [GL_OES_EGL_image_external](https://khronos.org/registry/OpenGL/extensions/OES/OES_EGL_image_external.txt) | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; |
| [GL_OES_EGL_image_external_essl3](https://khronos.org/registry/OpenGL/extensions/OES/OES_EGL_image_external_essl3.txt) | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; |
| [GL_EXT_EGL_image_external_wrap_modes](https://khronos.org/registry/OpenGL/extensions/EXT/EXT_EGL_image_external_wrap_modes.txt) | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; |
| [GL_EXT_EGL_image_storage](https://khronos.org/registry/OpenGL/extensions/EXT/EXT_EGL_image_storage.txt) | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; |
| [GL_EXT_EGL_image_storage_compression](https://khronos.org/registry/OpenGL/extensions/EXT/EXT_EGL_image_storage_compression.txt) |  |  |  |  |  |  |  |
| [GL_NV_EGL_stream_consumer_external](https://khronos.org/registry/OpenGL/extensions/NV/NV_EGL_stream_consumer_external.txt) |  |  |  |  |  |  |  |
| [GL_OES_EGL_sync](https://khronos.org/registry/OpenGL/extensions/OES/OES_EGL_sync.txt) | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; |
| [GL_OES_element_index_uint](https://khronos.org/registry/OpenGL/extensions/OES/OES_element_index_uint.txt) | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; |
| [GL_ANDROID_extension_pack_es31a](https://khronos.org/registry/OpenGL/extensions/ANDROID/ANDROID_extension_pack_es31a.txt) | &#x2714; |  |  |  |  |  | &#x2714; |
| [GL_EXT_external_buffer](https://khronos.org/registry/OpenGL/extensions/EXT/EXT_external_buffer.txt) |  |  |  |  |  | &#x2714; | &#x2714; |
| [GL_OES_fbo_render_mipmap](https://khronos.org/registry/OpenGL/extensions/OES/OES_fbo_render_mipmap.txt) | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; |
| [GL_NV_fence](https://khronos.org/registry/OpenGL/extensions/NV/NV_fence.txt) | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; |
| [GL_EXT_float_blend](https://khronos.org/registry/OpenGL/extensions/EXT/EXT_float_blend.txt) | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; |  |
| [GL_EXT_frag_depth](https://khronos.org/registry/OpenGL/extensions/EXT/EXT_frag_depth.txt) | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; |
| [GL_EXT_fragment_shading_rate](https://khronos.org/registry/OpenGL/extensions/EXT/EXT_fragment_shading_rate.txt) |  |  |  |  |  |  |  |
| [GL_EXT_fragment_shading_rate_attachment](https://khronos.org/registry/OpenGL/extensions/EXT/EXT_fragment_shading_rate_attachment.txt) |  |  |  |  |  |  |  |
| [GL_EXT_fragment_shading_rate_primitive](https://khronos.org/registry/OpenGL/extensions/EXT/EXT_fragment_shading_rate_primitive.txt) |  |  |  |  |  |  |  |
| [GL_ANGLE_framebuffer_blit](https://khronos.org/registry/OpenGL/extensions/ANGLE/ANGLE_framebuffer_blit.txt) | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; |
| [GL_NV_framebuffer_blit](https://khronos.org/registry/OpenGL/extensions/NV/NV_framebuffer_blit.txt) | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; |
| [GL_MESA_framebuffer_flip_y](https://khronos.org/registry/OpenGL/extensions/MESA/MESA_framebuffer_flip_y.txt) |  |  |  |  |  |  |  |
| [GL_QCOM_framebuffer_foveated](https://khronos.org/registry/OpenGL/extensions/QCOM/QCOM_framebuffer_foveated.txt) |  |  |  |  |  |  |  |
| [GL_EXT_geometry_shader](https://khronos.org/registry/OpenGL/extensions/EXT/EXT_geometry_shader.txt) | &#x2714; | &#x2714; | &#x2714; | &#x2714; |  |  | &#x2714; |
| [GL_OES_geometry_shader](https://khronos.org/registry/OpenGL/extensions/OES/OES_geometry_shader.txt) | &#x2714; | &#x2714; | &#x2714; | &#x2714; |  |  | &#x2714; |
| [GL_OES_get_program_binary](https://khronos.org/registry/OpenGL/extensions/OES/OES_get_program_binary.txt) | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; |
| [GL_EXT_gpu_shader5](https://khronos.org/registry/OpenGL/extensions/EXT/EXT_gpu_shader5.txt) | &#x2714; | &#x2714; | &#x2714; | &#x2714; |  | &#x2714; | &#x2714; |
| [GL_OES_gpu_shader5](https://khronos.org/registry/OpenGL/extensions/OES/OES_gpu_shader5.txt) |  |  |  |  |  |  |  |
| [GL_ANGLE_instanced_arrays](https://khronos.org/registry/OpenGL/extensions/ANGLE/ANGLE_instanced_arrays.txt) | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; |
| [GL_EXT_instanced_arrays](https://khronos.org/registry/OpenGL/extensions/EXT/EXT_instanced_arrays.txt) | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; |
| [GL_OES_mapbuffer](https://khronos.org/registry/OpenGL/extensions/OES/OES_mapbuffer.txt) | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; |
| [GL_EXT_map_buffer_range](https://khronos.org/registry/OpenGL/extensions/EXT/EXT_map_buffer_range.txt) | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; |
| [GL_EXT_memory_object](https://khronos.org/registry/OpenGL/extensions/EXT/EXT_memory_object.txt) | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; |
| [GL_EXT_memory_object_fd](https://khronos.org/registry/OpenGL/extensions/EXT/EXT_external_objects_fd.txt) |  |  | &#x2714; | &#x2714; |  | &#x2714; | &#x2714; |
| [GL_EXT_multi_draw_arrays](https://khronos.org/registry/OpenGL/extensions/EXT/EXT_multi_draw_arrays.txt) |  |  |  |  |  |  |  |
| [GL_EXT_multi_draw_indirect](https://khronos.org/registry/OpenGL/extensions/EXT/EXT_multi_draw_indirect.txt) | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; |
| [GL_EXT_multisample_compatibility](https://khronos.org/registry/OpenGL/extensions/EXT/EXT_multisample_compatibility.txt) | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; |
| [GL_EXT_multisampled_render_to_texture](https://khronos.org/registry/OpenGL/extensions/EXT/EXT_multisampled_render_to_texture.txt) |  |  |  |  |  |  |  |
| [GL_EXT_multisampled_render_to_texture2](https://khronos.org/registry/OpenGL/extensions/EXT/EXT_multisampled_render_to_texture2.txt) |  |  |  |  |  |  |  |
| [GL_OVR_multiview](https://khronos.org/registry/OpenGL/extensions/OVR/OVR_multiview.txt) | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; |
| [GL_OVR_multiview2](https://khronos.org/registry/OpenGL/extensions/OVR/OVR_multiview2.txt) | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; |
| [GL_OVR_multiview_multisampled_render_to_texture](https://khronos.org/registry/OpenGL/extensions/OVR/OVR_multiview_multisampled_render_to_texture.txt) |  |  |  |  |  |  |  |
| [GL_KHR_no_error](https://khronos.org/registry/OpenGL/extensions/KHR/KHR_no_error.txt) |  |  |  |  |  |  |  |
| [GL_EXT_occlusion_query_boolean](https://khronos.org/registry/OpenGL/extensions/EXT/EXT_occlusion_query_boolean.txt) | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; |
| [GL_OES_packed_depth_stencil](https://khronos.org/registry/OpenGL/extensions/OES/OES_packed_depth_stencil.txt) | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; |
| [GL_ANGLE_pack_reverse_row_order](https://khronos.org/registry/OpenGL/extensions/ANGLE/ANGLE_pack_reverse_row_order.txt) |  |  |  |  |  |  |  |
| [GL_NV_pack_subimage](https://khronos.org/registry/OpenGL/extensions/NV/NV_pack_subimage.txt) | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; |
| [GL_KHR_parallel_shader_compile](https://khronos.org/registry/OpenGL/extensions/KHR/KHR_parallel_shader_compile.txt) |  |  |  |  |  |  |  |
| [GL_AMD_performance_monitor](https://khronos.org/registry/OpenGL/extensions/AMD/AMD_performance_monitor.txt) | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; |
| [GL_NV_pixel_buffer_object](https://khronos.org/registry/OpenGL/extensions/NV/NV_pixel_buffer_object.txt) | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; |
| [GL_NV_polygon_mode](https://khronos.org/registry/OpenGL/extensions/NV/NV_polygon_mode.txt) |  |  |  |  |  |  |  |
| [GL_EXT_polygon_offset_clamp](https://khronos.org/registry/OpenGL/extensions/EXT/EXT_polygon_offset_clamp.txt) | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; |
| [GL_EXT_primitive_bounding_box](https://khronos.org/registry/OpenGL/extensions/EXT/EXT_primitive_bounding_box.txt) | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; |
| [GL_OES_primitive_bounding_box](https://khronos.org/registry/OpenGL/extensions/OES/OES_primitive_bounding_box.txt) | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; |
| [GL_EXT_protected_textures](https://khronos.org/registry/OpenGL/extensions/EXT/EXT_protected_textures.txt) |  |  |  |  |  | &#x2714; |  |
| [GL_EXT_pvrtc_sRGB](https://khronos.org/registry/OpenGL/extensions/EXT/EXT_pvrtc_sRGB.txt) |  |  |  |  |  |  |  |
| [GL_NV_read_depth](https://khronos.org/registry/OpenGL/extensions/NV/NV_read_depth.txt) | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; |
| [GL_NV_read_depth_stencil](https://khronos.org/registry/OpenGL/extensions/NV/NV_read_depth_stencil.txt) | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; |
| [GL_EXT_read_format_bgra](https://khronos.org/registry/OpenGL/extensions/EXT/EXT_read_format_bgra.txt) | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; |
| [GL_NV_read_stencil](https://khronos.org/registry/OpenGL/extensions/NV/NV_read_stencil.txt) | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; |
| [GL_QCOM_render_shared_exponent](https://khronos.org/registry/OpenGL/extensions/QCOM/QCOM_render_shared_exponent.txt) |  |  |  |  |  |  |  |
| [GL_EXT_render_snorm](https://khronos.org/registry/OpenGL/extensions/EXT/EXT_render_snorm.txt) |  |  |  |  |  |  |  |
| [GL_OES_required_internalformat](https://khronos.org/registry/OpenGL/extensions/OES/OES_required_internalformat.txt) |  |  |  |  |  |  |  |
| [GL_OES_rgb8_rgba8](https://khronos.org/registry/OpenGL/extensions/OES/OES_rgb8_rgba8.txt) | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; |
| [GL_ARM_rgba8](https://khronos.org/registry/OpenGL/extensions/ARM/ARM_rgba8.txt) |  |  |  |  |  |  |  |
| [GL_KHR_robust_buffer_access_behavior](https://khronos.org/registry/OpenGL/extensions/KHR/KHR_robust_buffer_access_behavior.txt) |  |  |  |  |  |  |  |
| [GL_EXT_robustness](https://khronos.org/registry/OpenGL/extensions/EXT/EXT_robustness.txt) | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; |
| [GL_KHR_robustness](https://khronos.org/registry/OpenGL/extensions/KHR/KHR_robustness.txt) |  |  |  |  |  |  |  |
| [GL_NV_robustness_video_memory_purge](https://khronos.org/registry/OpenGL/extensions/NV/NV_robustness_video_memory_purge.txt) |  |  |  |  |  |  |  |
| [GL_OES_sample_shading](https://khronos.org/registry/OpenGL/extensions/OES/OES_sample_shading.txt) | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; |
| [GL_OES_sample_variables](https://khronos.org/registry/OpenGL/extensions/OES/OES_sample_variables.txt) | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; |
| [GL_EXT_semaphore](https://khronos.org/registry/OpenGL/extensions/EXT/EXT_semaphore.txt) | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; |
| [GL_EXT_semaphore_fd](https://khronos.org/registry/OpenGL/extensions/EXT/EXT_external_objects_fd.txt) |  |  | &#x2714; | &#x2714; |  | &#x2714; | &#x2714; |
| [GL_EXT_separate_depth_stencil](https://khronos.org/registry/OpenGL/extensions/EXT/EXT_separate_depth_stencil.txt) |  |  |  |  |  |  |  |
| [GL_EXT_separate_shader_objects](https://khronos.org/registry/OpenGL/extensions/EXT/EXT_separate_shader_objects.txt) | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; |
| [GL_ARM_shader_framebuffer_fetch](https://khronos.org/registry/OpenGL/extensions/ARM/ARM_shader_framebuffer_fetch.txt) |  |  |  |  | &#x2714; |  | &#x2714; |
| [GL_EXT_shader_framebuffer_fetch](https://khronos.org/registry/OpenGL/extensions/EXT/EXT_shader_framebuffer_fetch.txt) |  |  |  |  | &#x2714; |  | &#x2714; |
| [GL_ARM_shader_framebuffer_fetch_depth_stencil](https://khronos.org/registry/OpenGL/extensions/ARM/ARM_shader_framebuffer_fetch_depth_stencil.txt) |  |  |  |  |  |  |  |
| [GL_EXT_shader_framebuffer_fetch_non_coherent](https://khronos.org/registry/OpenGL/extensions/EXT/EXT_shader_framebuffer_fetch_non_coherent.txt) |  |  |  |  | &#x2714; |  |  |
| [GL_OES_shader_image_atomic](https://khronos.org/registry/OpenGL/extensions/OES/OES_shader_image_atomic.txt) | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; |
| [GL_EXT_shader_io_blocks](https://khronos.org/registry/OpenGL/extensions/EXT/EXT_shader_io_blocks.txt) | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; |
| [GL_OES_shader_io_blocks](https://khronos.org/registry/OpenGL/extensions/OES/OES_shader_io_blocks.txt) | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; |
| [GL_OES_shader_multisample_interpolation](https://khronos.org/registry/OpenGL/extensions/OES/OES_shader_multisample_interpolation.txt) | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; |
| [GL_EXT_shader_non_constant_global_initializers](https://khronos.org/registry/OpenGL/extensions/EXT/EXT_shader_non_constant_global_initializers.txt) | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; |
| [GL_NV_shader_noperspective_interpolation](https://khronos.org/registry/OpenGL/extensions/NV/NV_shader_noperspective_interpolation.txt) | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; |
| [GL_EXT_shader_texture_lod](https://khronos.org/registry/OpenGL/extensions/EXT/EXT_shader_texture_lod.txt) | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; |
| [GL_QCOM_shading_rate](https://khronos.org/registry/OpenGL/extensions/QCOM/QCOM_shading_rate.txt) |  |  |  |  |  |  |  |
| [GL_EXT_shadow_samplers](https://khronos.org/registry/OpenGL/extensions/EXT/EXT_shadow_samplers.txt) | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; |
| [GL_EXT_sRGB](https://khronos.org/registry/OpenGL/extensions/EXT/EXT_sRGB.txt) | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; |
| [GL_EXT_sRGB_write_control](https://khronos.org/registry/OpenGL/extensions/EXT/EXT_sRGB_write_control.txt) | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; |
| [GL_OES_standard_derivatives](https://khronos.org/registry/OpenGL/extensions/OES/OES_standard_derivatives.txt) | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; |
| [GL_OES_surfaceless_context](https://khronos.org/registry/OpenGL/extensions/OES/OES_surfaceless_context.txt) | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; |
| [GL_EXT_tessellation_shader](https://khronos.org/registry/OpenGL/extensions/EXT/EXT_tessellation_shader.txt) | &#x2714; | &#x2714; | &#x2714; | &#x2714; |  |  | &#x2714; |
| [GL_OES_tessellation_shader](https://khronos.org/registry/OpenGL/extensions/OES/OES_tessellation_shader.txt) |  |  |  |  |  |  |  |
| [GL_OES_texture_3D](https://khronos.org/registry/OpenGL/extensions/OES/OES_texture_3D.txt) | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; |
| [GL_EXT_texture_border_clamp](https://khronos.org/registry/OpenGL/extensions/EXT/EXT_texture_border_clamp.txt) | &#x2714; | &#x2714; |  |  | &#x2714; |  | &#x2714; |
| [GL_OES_texture_border_clamp](https://khronos.org/registry/OpenGL/extensions/OES/OES_texture_border_clamp.txt) | &#x2714; | &#x2714; |  |  | &#x2714; |  | &#x2714; |
| [GL_EXT_texture_buffer](https://khronos.org/registry/OpenGL/extensions/EXT/EXT_texture_buffer.txt) | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; |
| [GL_OES_texture_buffer](https://khronos.org/registry/OpenGL/extensions/OES/OES_texture_buffer.txt) | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; |
| [GL_OES_texture_compression_astc](https://khronos.org/registry/OpenGL/extensions/OES/OES_texture_compression_astc.txt) |  |  |  |  |  |  |  |
| [GL_EXT_texture_compression_astc_decode_mode](https://khronos.org/registry/OpenGL/extensions/EXT/EXT_texture_compression_astc_decode_mode.txt) |  |  |  |  |  |  |  |
| [GL_EXT_texture_compression_astc_decode_mode_rgb9e5](https://khronos.org/registry/OpenGL/extensions/EXT/EXT_texture_compression_astc_decode_mode_rgb9e5.txt) |  |  |  |  |  |  |  |
| [GL_KHR_texture_compression_astc_hdr](https://khronos.org/registry/OpenGL/extensions/KHR/KHR_texture_compression_astc_hdr.txt) |  |  |  |  |  |  |  |
| [GL_KHR_texture_compression_astc_ldr](https://khronos.org/registry/OpenGL/extensions/KHR/KHR_texture_compression_astc_ldr.txt) | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; |
| [GL_KHR_texture_compression_astc_sliced_3d](https://khronos.org/registry/OpenGL/extensions/KHR/KHR_texture_compression_astc_sliced_3d.txt) |  |  |  |  |  |  |  |
| [GL_EXT_texture_compression_bptc](https://khronos.org/registry/OpenGL/extensions/EXT/EXT_texture_compression_bptc.txt) | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; |  |  |
| [GL_EXT_texture_compression_dxt1](https://khronos.org/registry/OpenGL/extensions/EXT/EXT_texture_compression_dxt1.txt) | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; |  |  |
| [GL_IMG_texture_compression_pvrtc](https://khronos.org/registry/OpenGL/extensions/IMG/IMG_texture_compression_pvrtc.txt) |  |  |  |  |  |  |  |
| [GL_IMG_texture_compression_pvrtc2](https://khronos.org/registry/OpenGL/extensions/IMG/IMG_texture_compression_pvrtc2.txt) |  |  |  |  |  |  |  |
| [GL_EXT_texture_compression_rgtc](https://khronos.org/registry/OpenGL/extensions/EXT/EXT_texture_compression_rgtc.txt) | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; |  |  |
| [GL_EXT_texture_compression_s3tc](https://khronos.org/registry/OpenGL/extensions/EXT/EXT_texture_compression_s3tc.txt) |  |  |  |  |  |  |  |
| [GL_EXT_texture_compression_s3tc_srgb](https://khronos.org/registry/OpenGL/extensions/EXT/EXT_texture_compression_s3tc_srgb.txt) | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; |  |  |
| [GL_EXT_texture_cube_map_array](https://khronos.org/registry/OpenGL/extensions/EXT/EXT_texture_cube_map_array.txt) | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; |
| [GL_OES_texture_cube_map_array](https://khronos.org/registry/OpenGL/extensions/OES/OES_texture_cube_map_array.txt) | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; |
| [GL_EXT_texture_filter_anisotropic](https://khronos.org/registry/OpenGL/extensions/EXT/EXT_texture_filter_anisotropic.txt) | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; |
| [GL_EXT_texture_filter_minmax](https://khronos.org/registry/OpenGL/extensions/EXT/EXT_texture_filter_minmax.txt) |  |  |  |  |  |  |  |
| [GL_OES_texture_float](https://khronos.org/registry/OpenGL/extensions/OES/OES_texture_float.txt) | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; |
| [GL_OES_texture_float_linear](https://khronos.org/registry/OpenGL/extensions/OES/OES_texture_float_linear.txt) | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; |  | &#x2714; |
| [GL_EXT_texture_format_BGRA8888](https://khronos.org/registry/OpenGL/extensions/EXT/EXT_texture_format_BGRA8888.txt) | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; |
| [GL_EXT_texture_format_sRGB_override](https://khronos.org/registry/OpenGL/extensions/EXT/EXT_texture_format_sRGB_override.txt) |  | &#x2714; |  |  |  |  |  |
| [GL_QCOM_texture_foveated](https://khronos.org/registry/OpenGL/extensions/QCOM/QCOM_texture_foveated.txt) |  |  |  |  |  |  |  |
| [GL_OES_texture_half_float](https://khronos.org/registry/OpenGL/extensions/OES/OES_texture_half_float.txt) | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; |
| [GL_OES_texture_half_float_linear](https://khronos.org/registry/OpenGL/extensions/OES/OES_texture_half_float_linear.txt) | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; |
| [GL_EXT_texture_mirror_clamp_to_edge](https://khronos.org/registry/OpenGL/extensions/EXT/EXT_texture_mirror_clamp_to_edge.txt) |  |  |  |  |  |  |  |
| [GL_EXT_texture_norm16](https://khronos.org/registry/OpenGL/extensions/EXT/EXT_texture_norm16.txt) |  | &#x2714; |  | &#x2714; |  |  |  |
| [GL_OES_texture_npot](https://khronos.org/registry/OpenGL/extensions/OES/OES_texture_npot.txt) | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; |
| [GL_EXT_texture_query_lod](https://khronos.org/registry/OpenGL/extensions/EXT/EXT_texture_query_lod.txt) |  |  |  |  |  |  |  |
| [GL_EXT_texture_rg](https://khronos.org/registry/OpenGL/extensions/EXT/EXT_texture_rg.txt) | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; |
| [GL_EXT_texture_shadow_lod](https://khronos.org/registry/OpenGL/extensions/EXT/EXT_texture_shadow_lod.txt) |  |  |  |  |  |  |  |
| [GL_EXT_texture_sRGB_decode](https://khronos.org/registry/OpenGL/extensions/EXT/EXT_texture_sRGB_decode.txt) | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; |
| [GL_EXT_texture_sRGB_R8](https://khronos.org/registry/OpenGL/extensions/EXT/EXT_texture_sRGB_R8.txt) | &#x2714; |  | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; |
| [GL_EXT_texture_sRGB_RG8](https://khronos.org/registry/OpenGL/extensions/EXT/EXT_texture_sRGB_RG8.txt) |  |  |  |  | &#x2714; | &#x2714; | &#x2714; |
| [GL_OES_texture_stencil8](https://khronos.org/registry/OpenGL/extensions/OES/OES_texture_stencil8.txt) | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; |
| [GL_EXT_texture_storage](https://khronos.org/registry/OpenGL/extensions/EXT/EXT_texture_storage.txt) | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; |
| [GL_EXT_texture_storage_compression](https://khronos.org/registry/OpenGL/extensions/EXT/EXT_texture_storage_compression.txt) |  |  |  |  |  |  |  |
| [GL_OES_texture_storage_multisample_2d_array](https://khronos.org/registry/OpenGL/extensions/OES/OES_texture_storage_multisample_2d_array.txt) | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; |
| [GL_EXT_texture_type_2_10_10_10_REV](https://khronos.org/registry/OpenGL/extensions/EXT/EXT_texture_type_2_10_10_10_REV.txt) | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; |
| [GL_ARM_texture_unnormalized_coordinates](https://khronos.org/registry/OpenGL/extensions/ARM/ARM_texture_unnormalized_coordinates.txt) |  |  |  |  |  |  |  |
| [GL_ANGLE_texture_usage](https://khronos.org/registry/OpenGL/extensions/ANGLE/ANGLE_texture_usage.txt) | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; |
| [GL_QCOM_tiled_rendering](https://khronos.org/registry/OpenGL/extensions/QCOM/QCOM_tiled_rendering.txt) |  |  |  |  |  |  |  |
| [GL_ANGLE_translated_shader_source](https://khronos.org/registry/OpenGL/extensions/ANGLE/ANGLE_translated_shader_source.txt) |  |  |  |  |  |  |  |
| [GL_EXT_unpack_subimage](https://khronos.org/registry/OpenGL/extensions/EXT/EXT_unpack_subimage.txt) | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; |
| [GL_OES_vertex_array_object](https://khronos.org/registry/OpenGL/extensions/OES/OES_vertex_array_object.txt) | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; |
| [GL_OES_vertex_half_float](https://khronos.org/registry/OpenGL/extensions/OES/OES_vertex_half_float.txt) | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; |
| [GL_OES_vertex_type_10_10_10_2](https://khronos.org/registry/OpenGL/extensions/OES/OES_vertex_type_10_10_10_2.txt) | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; |
| [GL_WEBGL_video_texture](https://khronos.org/registry/OpenGL/extensions/WEBGL/WEBGL_video_texture.txt) |  |  |  |  |  |  |  |
| [GL_EXT_YUV_target](https://khronos.org/registry/OpenGL/extensions/EXT/EXT_YUV_target.txt) |  |  |  |  |  |  |  |

## ANGLE unofficial extension support

*Note: some ANGLE extensions are currently missing specifications.*

| Extension Name | NVIDIA 1660 Win10 | Intel 630 Win10 | NVIDIA 1660 Linux | Intel 630 Linux | SwiftShader Win10 | Pixel 4 Android 11 | Pixel 6 Android 13 |
| -------------- | :---------------: | :-------------: | :---------------: | :-------------: | :---------------: | :----------------: | :----------------: |
| [GL_ANGLE_base_vertex_base_instance](https://chromium.googlesource.com/angle/angle/+/refs/heads/main/extensions/ANGLE_base_vertex_base_instance.txt) | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; |
| [GL_ANGLE_base_vertex_base_instance_shader_builtin](https://chromium.googlesource.com/angle/angle/+/refs/heads/main/extensions/ANGLE_base_vertex_base_instance_shader_builtin.txt) | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; |
| [GL_CHROMIUM_bind_generates_resource](https://chromium.googlesource.com/angle/angle/+/refs/heads/main/extensions/CHROMIUM_bind_generates_resource.txt) | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; |
| [GL_CHROMIUM_bind_uniform_location](https://chromium.googlesource.com/angle/angle/+/refs/heads/main/extensions/CHROMIUM_bind_uniform_location.txt) | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; |
| [GL_ANGLE_blob_cache](https://chromium.googlesource.com/angle/angle/+/refs/heads/main/extensions/ANGLE_blob_cache.txt) |  |  |  |  |  |  |  |
| [GL_ANGLE_client_arrays](https://chromium.googlesource.com/angle/angle/+/refs/heads/main/extensions/ANGLE_client_arrays.txt) | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; |
| [GL_ANGLE_clip_cull_distance](https://chromium.googlesource.com/angle/angle/+/refs/heads/main/extensions/ANGLE_clip_cull_distance.txt) | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; |  |
| [GL_CHROMIUM_color_buffer_float_rgb](https://chromium.googlesource.com/angle/angle/+/refs/heads/main/extensions/CHROMIUM_color_buffer_float_rgb.txt) |  |  |  |  |  |  |  |
| [GL_CHROMIUM_color_buffer_float_rgba](https://chromium.googlesource.com/angle/angle/+/refs/heads/main/extensions/CHROMIUM_color_buffer_float_rgba.txt) |  |  |  |  |  |  |  |
| [GL_ANGLE_compressed_texture_etc](https://chromium.googlesource.com/angle/angle/+/refs/heads/main/extensions/ANGLE_compressed_texture_etc.txt) |  | &#x2714; |  | &#x2714; | &#x2714; | &#x2714; | &#x2714; |
| [GL_CHROMIUM_copy_compressed_texture](https://chromium.googlesource.com/angle/angle/+/refs/heads/main/extensions/CHROMIUM_copy_compressed_texture.txt) | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; |
| [GL_CHROMIUM_copy_texture](https://chromium.googlesource.com/angle/angle/+/refs/heads/main/extensions/CHROMIUM_copy_texture.txt) | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; |
| [GL_ANGLE_copy_texture_3d](https://chromium.googlesource.com/angle/angle/+/refs/heads/main/extensions/ANGLE_copy_texture_3d.txt) | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; |
| [GL_CHROMIUM_framebuffer_mixed_samples](https://chromium.googlesource.com/angle/angle/+/refs/heads/main/extensions/CHROMIUM_framebuffer_mixed_samples.txt) |  |  |  |  |  |  |  |
| [GL_ANGLE_framebuffer_multisample](https://chromium.googlesource.com/angle/angle/+/refs/heads/main/extensions/ANGLE_framebuffer_multisample.txt) | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; |
| [GL_ANGLE_get_image](https://chromium.googlesource.com/angle/angle/+/refs/heads/main/extensions/ANGLE_get_image.txt) | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; |
| [GL_ANGLE_get_serialized_context_string](https://chromium.googlesource.com/angle/angle/+/refs/heads/main/extensions/ANGLE_get_serialized_context_string.txt) | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; |
| [GL_ANGLE_get_tex_level_parameter](https://chromium.googlesource.com/angle/angle/+/refs/heads/main/extensions/ANGLE_get_tex_level_parameter.txt) | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; |
| [GL_ANGLE_logic_op](https://chromium.googlesource.com/angle/angle/+/refs/heads/main/extensions/ANGLE_logic_op.txt) | &#x2714; | &#x2714; | &#x2714; | &#x2714; |  |  |  |
| [GL_CHROMIUM_lose_context](https://chromium.googlesource.com/angle/angle/+/refs/heads/main/extensions/CHROMIUM_lose_context.txt) | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; |
| [GL_ANGLE_lossy_etc_decode](https://chromium.googlesource.com/angle/angle/+/refs/heads/main/extensions/ANGLE_lossy_etc_decode.txt) |  |  |  |  |  |  |  |
| [GL_ANGLE_memory_object_flags](https://chromium.googlesource.com/angle/angle/+/refs/heads/main/extensions/ANGLE_memory_object_flags.txt) | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; |
| [GL_ANGLE_memory_object_fuchsia](https://chromium.googlesource.com/angle/angle/+/refs/heads/main/extensions/ANGLE_memory_object_fuchsia.txt) |  |  |  |  |  |  |  |
| [GL_ANGLE_memory_size](https://chromium.googlesource.com/angle/angle/+/refs/heads/main/extensions/ANGLE_memory_size.txt) | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; |
| [GL_ANGLE_multi_draw](https://chromium.googlesource.com/angle/angle/+/refs/heads/main/extensions/ANGLE_multi_draw.txt) | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; |
| [GL_ANGLE_multiview_multisample](https://chromium.googlesource.com/angle/angle/+/refs/heads/main/extensions/ANGLE_multiview_multisample.txt) |  |  |  |  |  |  |  |
| [GL_ANGLE_polygon_mode](https://chromium.googlesource.com/angle/angle/+/refs/heads/main/extensions/ANGLE_polygon_mode.txt) |  |  |  |  |  |  |  |
| [GL_ANGLE_program_binary](https://chromium.googlesource.com/angle/angle/+/refs/heads/main/extensions/ANGLE_program_binary.txt) |  |  |  |  |  |  |  |
| [GL_ANGLE_program_binary_readiness_query](https://chromium.googlesource.com/angle/angle/+/refs/heads/main/extensions/ANGLE_program_binary_readiness_query.txt) |  |  |  |  |  |  |  |
| [GL_ANGLE_program_cache_control](https://chromium.googlesource.com/angle/angle/+/refs/heads/main/extensions/ANGLE_program_cache_control.txt) | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; |
| [GL_ANGLE_provoking_vertex](https://chromium.googlesource.com/angle/angle/+/refs/heads/main/extensions/ANGLE_provoking_vertex.txt) |  |  |  |  |  |  |  |
| [GL_ANGLE_read_only_depth_stencil_feedback_loops](https://chromium.googlesource.com/angle/angle/+/refs/heads/main/extensions/ANGLE_read_only_depth_stencil_feedback_loops.txt) | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; |
| [GL_ANGLE_relaxed_vertex_attribute_type](https://chromium.googlesource.com/angle/angle/+/refs/heads/main/extensions/ANGLE_relaxed_vertex_attribute_type.txt) | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; |
| [GL_ANGLE_renderability_validation](https://chromium.googlesource.com/angle/angle/+/refs/heads/main/extensions/ANGLE_renderability_validation.txt) |  |  |  |  |  |  |  |
| [GL_ANGLE_request_extension](https://chromium.googlesource.com/angle/angle/+/refs/heads/main/extensions/ANGLE_request_extension.txt) | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; |
| [GL_ANGLE_rgbx_internal_format](https://chromium.googlesource.com/angle/angle/+/refs/heads/main/extensions/ANGLE_rgbx_internal_format.txt) | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; |
| [GL_ANGLE_robust_client_memory](https://chromium.googlesource.com/angle/angle/+/refs/heads/main/extensions/ANGLE_robust_client_memory.txt) | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; |
| [GL_ANGLE_robust_fragment_shader_output](https://chromium.googlesource.com/angle/angle/+/refs/heads/main/extensions/ANGLE_robust_fragment_shader_output.txt) | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; |
| [GL_ANGLE_robust_resource_initialization](https://chromium.googlesource.com/angle/angle/+/refs/heads/main/extensions/ANGLE_robust_resource_initialization.txt) |  |  |  |  |  |  |  |
| [GL_ANGLE_semaphore_fuchsia](https://chromium.googlesource.com/angle/angle/+/refs/heads/main/extensions/ANGLE_semaphore_fuchsia.txt) |  |  |  |  |  |  |  |
| [GL_ANGLE_shader_binary](https://chromium.googlesource.com/angle/angle/+/refs/heads/main/extensions/ANGLE_shader_binary.txt) |  |  |  |  |  |  |  |
| [GL_ANGLE_shader_pixel_local_storage](https://chromium.googlesource.com/angle/angle/+/refs/heads/main/extensions/ANGLE_shader_pixel_local_storage.txt) |  |  |  |  |  |  |  |
| [GL_ANGLE_shader_pixel_local_storage_coherent](https://chromium.googlesource.com/angle/angle/+/refs/heads/main/extensions/ANGLE_shader_pixel_local_storage.txt) |  |  |  |  |  |  |  |
| [GL_ANGLE_stencil_texturing](https://chromium.googlesource.com/angle/angle/+/refs/heads/main/extensions/ANGLE_stencil_texturing.txt) |  |  |  |  |  |  |  |
| [GL_ANGLE_texture_compression_dxt3](https://chromium.googlesource.com/angle/angle/+/refs/heads/main/extensions/ANGLE_texture_compression_dxt3.txt) | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; |  |  |
| [GL_ANGLE_texture_compression_dxt5](https://chromium.googlesource.com/angle/angle/+/refs/heads/main/extensions/ANGLE_texture_compression_dxt5.txt) | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; |  |  |
| [GL_ANGLE_texture_external_update](https://chromium.googlesource.com/angle/angle/+/refs/heads/main/extensions/ANGLE_texture_external_update.txt) |  |  |  |  |  |  |  |
| [GL_ANGLE_texture_multisample](https://chromium.googlesource.com/angle/angle/+/refs/heads/main/extensions/ANGLE_texture_multisample.txt) | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; |
| [GL_ANGLE_texture_rectangle](https://chromium.googlesource.com/angle/angle/+/refs/heads/main/extensions/ANGLE_texture_rectangle.txt) |  |  |  |  |  |  |  |
| [GL_ANGLE_vulkan_image](https://chromium.googlesource.com/angle/angle/+/refs/heads/main/extensions/ANGLE_vulkan_image.txt) | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; |
| [GL_ANGLE_webgl_compatibility](https://chromium.googlesource.com/angle/angle/+/refs/heads/main/extensions/ANGLE_webgl_compatibility.txt) |  |  |  |  |  |  |  |
| [GL_ANGLE_yuv_internal_format](https://chromium.googlesource.com/angle/angle/+/refs/heads/main/extensions/ANGLE_yuv_internal_format.txt) | &#x2714; |  | &#x2714; | &#x2714; | &#x2714; | &#x2714; | &#x2714; |

## GLES 1.0 and 1.1 extension support

| Extension Name | SwiftShader Win10 |
| -------------- | :---------------: |
| [GL_OES_blend_subtract](https://khronos.org/registry/OpenGL/extensions/OES/OES_blend_subtract.txt) |  |
| [GL_OES_draw_texture](https://khronos.org/registry/OpenGL/extensions/OES/OES_draw_texture.txt) | &#x2714; |
| [GL_OES_framebuffer_object](https://khronos.org/registry/OpenGL/extensions/OES/OES_framebuffer_object.txt) | &#x2714; |
| [GL_OES_matrix_palette](https://khronos.org/registry/OpenGL/extensions/OES/OES_matrix_palette.txt) |  |
| [GL_OES_point_size_array](https://khronos.org/registry/OpenGL/extensions/OES/OES_point_size_array.txt) | &#x2714; |
| [GL_OES_point_sprite](https://khronos.org/registry/OpenGL/extensions/OES/OES_point_sprite.txt) | &#x2714; |
| [GL_OES_query_matrix](https://khronos.org/registry/OpenGL/extensions/OES/OES_query_matrix.txt) |  |
| [GL_OES_texture_cube_map](https://khronos.org/registry/OpenGL/extensions/OES/OES_texture_cube_map.txt) | &#x2714; |
| [GL_OES_texture_mirrored_repeat](https://khronos.org/registry/OpenGL/extensions/OES/OES_texture_mirrored_repeat.txt) |  |

## EGL extension support

Currently EGL extensions are not automatically tracked by our scripting. For a
list of supported EGL extensions in ANGLE's front-end see
[`src/libANGLE/Caps.h`](../src/libANGLE/Caps.h).

## Configuration information

NVIDIA 1660 Win10:

 * `GL_RENDERER` is `ANGLE (NVIDIA, Vulkan 1.2.142 (NVIDIA GeForce GTX 1660 (0x00002184)), NVIDIA-456.38.0.0)`
 * `GL_VENDOR` is `Google Inc. (NVIDIA)`
 * `GL_VERSION` is `OpenGL ES 3.2.0 (ANGLE 2.1.20572 git hash: 75901296a09f)`
 * Data updated February 22, 2023

Intel 630 Win10:

 * `GL_RENDERER` is `ANGLE (Intel, Vulkan 1.3.215 (Intel(R) UHD Graphics 630 (0x00009BC5)), Intel Corporation-101.101.)`
 * `GL_VENDOR` is `Google Inc. (Intel)`
 * `GL_VERSION` is `OpenGL ES 3.2.0 (ANGLE 2.1.20572 git hash: 75901296a09f)`
 * Data updated February 22, 2023

NVIDIA 1660 Linux:

 * `GL_RENDERER` is `ANGLE (NVIDIA, Vulkan 1.1.119 (NVIDIA GeForce GTX 1660 (0x00002184)), NVIDIA-440.100.0.0)`
 * `GL_VENDOR` is `Google Inc. (NVIDIA)`
 * `GL_VERSION` is `OpenGL ES 3.2.0 (ANGLE 2.1.20572 git hash: 75901296a09f)`
 * Data updated February 22, 2023

Intel 630 Linux:

 * `GL_RENDERER` is `ANGLE (Intel, Vulkan 1.2.131 (Intel(R) UHD Graphics 630 (CML GT2) (0x00009BC5)), Intel open-source Mesa driver-20.0.8)`
 * `GL_VENDOR` is `Google Inc. (Intel)`
 * `GL_VERSION` is `OpenGL ES 3.2.0 (ANGLE 2.1.20572 git hash: 75901296a09f)`
 * Data updated February 22, 2023

SwiftShader Win10:

 * `GL_RENDERER` is `ANGLE (Google, Vulkan 1.3.0 (SwiftShader Device (Subzero) (0x0000C0DE)), SwiftShader driver-5.0.0)`
 * `GL_VENDOR` is `Google Inc. (Google)`
 * `GL_VERSION` is `OpenGL ES 3.1.0 (ANGLE 2.1.20572 git hash: 75901296a09f)`
 * Data updated February 22, 2023

Pixel 4 Android 11:

 * `GL_RENDERER` is `ANGLE (Qualcomm, Vulkan 1.1.128 (Adreno (TM) 640 (0x06040001)), Qualcomm Technologies Inc. Adreno Vulkan Driver-512.490.0)`
 * `GL_VENDOR` is `Google Inc. (Qualcomm)`
 * `GL_VERSION` is `OpenGL ES 3.2.0 (ANGLE 2.1.20572 git hash: 75901296a09f)`
 * Data updated February 22, 2023

Pixel 6 Android 13:

 * `GL_RENDERER` is `ANGLE (ARM, Vulkan 1.1.201 (Mali-G78 (0x92020010)), Mali-G78-36.0.0)`
 * `GL_VENDOR` is `Google Inc. (ARM)`
 * `GL_VERSION` is `OpenGL ES 3.2.0 (ANGLE 2.1.20572 git hash: 75901296a09f)`
 * Data updated February 22, 2023

## How to update supported extension data

Supported extension data is stored in the ANGLE repo as JSON files in
[`scripts/extension_data`](../scripts/extension_data). The JSON data is
sourced from public ANGLE test runs. Look for `angle_end2end_tests` in a bot
run: [example link](https://ci.chromium.org/ui/p/angle/builders/ci/win-test/520/overview).
Search for "`angle_end2end_tests`", then click on the "cas output" and find
`GLinfo_ES3_2_Vulkan.json` or `GLinfo_ES3_1_Vulkan_SwiftShader.json` for
SwiftShader.

All data except for GLES 1 is automatically updated using
the [`update_extension_data.py`](../scripts/update_extension_data.py) script.
To use it first authenticate to the `bb` and `luci-go` tools by running `bb
auth-login` and `./tools/luci-go/swarming login`. Then run the script and
re-run [code generation][CodeGen].

The GLES 1 data is currently manually updated. Find the relevant
file from the task output (see above) and overwrite the correspoding file.
Re-run [code generation][CodeGen] and create a CL as per our normal process.

To add a new configuration, first retrieve the JSON data, modify
[`gen_extensions.py`](../src/libANGLE/gen_extensions.py) as necessary, then
run [`scripts/run_code_generation.py`][CodeGen] to refresh generated files.
Also update `update_extension_data.py` as necessary.

[CodeGen]: ../scripts/run_code_generation.py
