// GENERATED FILE - DO NOT EDIT.
// Generated by generate_entry_points.py using data from gl.xml and gl_angle_ext.xml.
//
// Copyright 2020 The ANGLE Project Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
//
// entry_points_gles_ext_autogen.cpp:
//   Defines the GLES extension entry points.

#include "libGLESv2/entry_points_gles_ext_autogen.h"

#include "common/entry_points_enum_autogen.h"
#include "common/gl_enum_utils.h"
#include "libANGLE/Context.h"
#include "libANGLE/Context.inl.h"
#include "libANGLE/capture/capture_gles_ext_autogen.h"
#include "libANGLE/context_private_call.inl.h"
#include "libANGLE/context_private_call_autogen.h"
#include "libANGLE/entry_points_utils.h"
#include "libANGLE/validationESEXT.h"
#include "libGLESv2/global_state.h"

using namespace gl;

#include "libANGLE/capture/capture_gles_1_0_autogen.h"
#include "libANGLE/capture/capture_gles_2_0_autogen.h"
#include "libANGLE/capture/capture_gles_3_0_autogen.h"
#include "libANGLE/capture/capture_gles_3_1_autogen.h"
#include "libANGLE/capture/capture_gles_3_2_autogen.h"
#include "libANGLE/validationES1.h"
#include "libANGLE/validationES2.h"
#include "libANGLE/validationES3.h"
#include "libANGLE/validationES31.h"
#include "libANGLE/validationES32.h"

using namespace gl;

extern "C" {

// GL_AMD_performance_monitor
void GL_APIENTRY GL_BeginPerfMonitorAMD(GLuint monitor)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLBeginPerfMonitorAMD, "context = %d, monitor = %u", CID(context), monitor);

    if (ANGLE_LIKELY(context != nullptr))
    {
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().performanceMonitorAMD))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateBeginPerfMonitorAMD(
                    context, angle::EntryPoint::GLBeginPerfMonitorAMD, monitor);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context, angle::EntryPoint::GLBeginPerfMonitorAMD);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->beginPerfMonitor(monitor);
        }
        ANGLE_CAPTURE_GL(BeginPerfMonitorAMD, isCallValid, context, monitor);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLBeginPerfMonitorAMD);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_DeletePerfMonitorsAMD(GLsizei n, GLuint *monitors)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLDeletePerfMonitorsAMD, "context = %d, n = %d, monitors = 0x%016" PRIxPTR "",
          CID(context), n, (uintptr_t)monitors);

    if (ANGLE_LIKELY(context != nullptr))
    {
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().performanceMonitorAMD))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateDeletePerfMonitorsAMD(
                    context, angle::EntryPoint::GLDeletePerfMonitorsAMD, n, monitors);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context, angle::EntryPoint::GLDeletePerfMonitorsAMD);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->deletePerfMonitors(n, monitors);
        }
        ANGLE_CAPTURE_GL(DeletePerfMonitorsAMD, isCallValid, context, n, monitors);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLDeletePerfMonitorsAMD);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_EndPerfMonitorAMD(GLuint monitor)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLEndPerfMonitorAMD, "context = %d, monitor = %u", CID(context), monitor);

    if (ANGLE_LIKELY(context != nullptr))
    {
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().performanceMonitorAMD))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateEndPerfMonitorAMD(
                    context, angle::EntryPoint::GLEndPerfMonitorAMD, monitor);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context, angle::EntryPoint::GLEndPerfMonitorAMD);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->endPerfMonitor(monitor);
        }
        ANGLE_CAPTURE_GL(EndPerfMonitorAMD, isCallValid, context, monitor);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLEndPerfMonitorAMD);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_GenPerfMonitorsAMD(GLsizei n, GLuint *monitors)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLGenPerfMonitorsAMD, "context = %d, n = %d, monitors = 0x%016" PRIxPTR "",
          CID(context), n, (uintptr_t)monitors);

    if (ANGLE_LIKELY(context != nullptr))
    {
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().performanceMonitorAMD))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateGenPerfMonitorsAMD(
                    context, angle::EntryPoint::GLGenPerfMonitorsAMD, n, monitors);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context, angle::EntryPoint::GLGenPerfMonitorsAMD);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->genPerfMonitors(n, monitors);
        }
        ANGLE_CAPTURE_GL(GenPerfMonitorsAMD, isCallValid, context, n, monitors);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLGenPerfMonitorsAMD);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_GetPerfMonitorCounterDataAMD(GLuint monitor,
                                                 GLenum pname,
                                                 GLsizei dataSize,
                                                 GLuint *data,
                                                 GLint *bytesWritten)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLGetPerfMonitorCounterDataAMD,
          "context = %d, monitor = %u, pname = %s, dataSize = %d, data = 0x%016" PRIxPTR
          ", bytesWritten = 0x%016" PRIxPTR "",
          CID(context), monitor, GLenumToString(GLESEnum::AllEnums, pname), dataSize,
          (uintptr_t)data, (uintptr_t)bytesWritten);

    if (ANGLE_LIKELY(context != nullptr))
    {
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().performanceMonitorAMD))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateGetPerfMonitorCounterDataAMD(
                    context, angle::EntryPoint::GLGetPerfMonitorCounterDataAMD, monitor, pname,
                    dataSize, data, bytesWritten);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context, angle::EntryPoint::GLGetPerfMonitorCounterDataAMD);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->getPerfMonitorCounterData(monitor, pname, dataSize, data, bytesWritten);
        }
        ANGLE_CAPTURE_GL(GetPerfMonitorCounterDataAMD, isCallValid, context, monitor, pname,
                         dataSize, data, bytesWritten);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(
            angle::EntryPoint::GLGetPerfMonitorCounterDataAMD);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_GetPerfMonitorCounterInfoAMD(GLuint group,
                                                 GLuint counter,
                                                 GLenum pname,
                                                 void *data)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLGetPerfMonitorCounterInfoAMD,
          "context = %d, group = %u, counter = %u, pname = %s, data = 0x%016" PRIxPTR "",
          CID(context), group, counter, GLenumToString(GLESEnum::AllEnums, pname), (uintptr_t)data);

    if (ANGLE_LIKELY(context != nullptr))
    {
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().performanceMonitorAMD))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateGetPerfMonitorCounterInfoAMD(
                    context, angle::EntryPoint::GLGetPerfMonitorCounterInfoAMD, group, counter,
                    pname, data);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context, angle::EntryPoint::GLGetPerfMonitorCounterInfoAMD);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->getPerfMonitorCounterInfo(group, counter, pname, data);
        }
        ANGLE_CAPTURE_GL(GetPerfMonitorCounterInfoAMD, isCallValid, context, group, counter, pname,
                         data);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(
            angle::EntryPoint::GLGetPerfMonitorCounterInfoAMD);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_GetPerfMonitorCounterStringAMD(GLuint group,
                                                   GLuint counter,
                                                   GLsizei bufSize,
                                                   GLsizei *length,
                                                   GLchar *counterString)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLGetPerfMonitorCounterStringAMD,
          "context = %d, group = %u, counter = %u, bufSize = %d, length = 0x%016" PRIxPTR
          ", counterString = 0x%016" PRIxPTR "",
          CID(context), group, counter, bufSize, (uintptr_t)length, (uintptr_t)counterString);

    if (ANGLE_LIKELY(context != nullptr))
    {
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().performanceMonitorAMD))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateGetPerfMonitorCounterStringAMD(
                    context, angle::EntryPoint::GLGetPerfMonitorCounterStringAMD, group, counter,
                    bufSize, length, counterString);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context,
                                        angle::EntryPoint::GLGetPerfMonitorCounterStringAMD);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->getPerfMonitorCounterString(group, counter, bufSize, length, counterString);
        }
        ANGLE_CAPTURE_GL(GetPerfMonitorCounterStringAMD, isCallValid, context, group, counter,
                         bufSize, length, counterString);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(
            angle::EntryPoint::GLGetPerfMonitorCounterStringAMD);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_GetPerfMonitorCountersAMD(GLuint group,
                                              GLint *numCounters,
                                              GLint *maxActiveCounters,
                                              GLsizei counterSize,
                                              GLuint *counters)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLGetPerfMonitorCountersAMD,
          "context = %d, group = %u, numCounters = 0x%016" PRIxPTR
          ", maxActiveCounters = 0x%016" PRIxPTR ", counterSize = %d, counters = 0x%016" PRIxPTR "",
          CID(context), group, (uintptr_t)numCounters, (uintptr_t)maxActiveCounters, counterSize,
          (uintptr_t)counters);

    if (ANGLE_LIKELY(context != nullptr))
    {
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().performanceMonitorAMD))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateGetPerfMonitorCountersAMD(
                    context, angle::EntryPoint::GLGetPerfMonitorCountersAMD, group, numCounters,
                    maxActiveCounters, counterSize, counters);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context, angle::EntryPoint::GLGetPerfMonitorCountersAMD);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->getPerfMonitorCounters(group, numCounters, maxActiveCounters, counterSize,
                                            counters);
        }
        ANGLE_CAPTURE_GL(GetPerfMonitorCountersAMD, isCallValid, context, group, numCounters,
                         maxActiveCounters, counterSize, counters);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(
            angle::EntryPoint::GLGetPerfMonitorCountersAMD);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_GetPerfMonitorGroupStringAMD(GLuint group,
                                                 GLsizei bufSize,
                                                 GLsizei *length,
                                                 GLchar *groupString)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLGetPerfMonitorGroupStringAMD,
          "context = %d, group = %u, bufSize = %d, length = 0x%016" PRIxPTR
          ", groupString = 0x%016" PRIxPTR "",
          CID(context), group, bufSize, (uintptr_t)length, (uintptr_t)groupString);

    if (ANGLE_LIKELY(context != nullptr))
    {
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().performanceMonitorAMD))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateGetPerfMonitorGroupStringAMD(
                    context, angle::EntryPoint::GLGetPerfMonitorGroupStringAMD, group, bufSize,
                    length, groupString);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context, angle::EntryPoint::GLGetPerfMonitorGroupStringAMD);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->getPerfMonitorGroupString(group, bufSize, length, groupString);
        }
        ANGLE_CAPTURE_GL(GetPerfMonitorGroupStringAMD, isCallValid, context, group, bufSize, length,
                         groupString);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(
            angle::EntryPoint::GLGetPerfMonitorGroupStringAMD);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_GetPerfMonitorGroupsAMD(GLint *numGroups, GLsizei groupsSize, GLuint *groups)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLGetPerfMonitorGroupsAMD,
          "context = %d, numGroups = 0x%016" PRIxPTR ", groupsSize = %d, groups = 0x%016" PRIxPTR
          "",
          CID(context), (uintptr_t)numGroups, groupsSize, (uintptr_t)groups);

    if (ANGLE_LIKELY(context != nullptr))
    {
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().performanceMonitorAMD))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateGetPerfMonitorGroupsAMD(
                    context, angle::EntryPoint::GLGetPerfMonitorGroupsAMD, numGroups, groupsSize,
                    groups);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context, angle::EntryPoint::GLGetPerfMonitorGroupsAMD);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->getPerfMonitorGroups(numGroups, groupsSize, groups);
        }
        ANGLE_CAPTURE_GL(GetPerfMonitorGroupsAMD, isCallValid, context, numGroups, groupsSize,
                         groups);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(
            angle::EntryPoint::GLGetPerfMonitorGroupsAMD);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_SelectPerfMonitorCountersAMD(GLuint monitor,
                                                 GLboolean enable,
                                                 GLuint group,
                                                 GLint numCounters,
                                                 GLuint *counterList)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLSelectPerfMonitorCountersAMD,
          "context = %d, monitor = %u, enable = %s, group = %u, numCounters = %d, counterList = "
          "0x%016" PRIxPTR "",
          CID(context), monitor, GLbooleanToString(enable), group, numCounters,
          (uintptr_t)counterList);

    if (ANGLE_LIKELY(context != nullptr))
    {
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().performanceMonitorAMD))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateSelectPerfMonitorCountersAMD(
                    context, angle::EntryPoint::GLSelectPerfMonitorCountersAMD, monitor, enable,
                    group, numCounters, counterList);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context, angle::EntryPoint::GLSelectPerfMonitorCountersAMD);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->selectPerfMonitorCounters(monitor, enable, group, numCounters, counterList);
        }
        ANGLE_CAPTURE_GL(SelectPerfMonitorCountersAMD, isCallValid, context, monitor, enable, group,
                         numCounters, counterList);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(
            angle::EntryPoint::GLSelectPerfMonitorCountersAMD);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

// GL_ANDROID_extension_pack_es31a

// GL_ANGLE_base_vertex_base_instance
void GL_APIENTRY GL_DrawArraysInstancedBaseInstanceANGLE(GLenum mode,
                                                         GLint first,
                                                         GLsizei count,
                                                         GLsizei instanceCount,
                                                         GLuint baseInstance)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLDrawArraysInstancedBaseInstanceANGLE,
          "context = %d, mode = %s, first = %d, count = %d, instanceCount = %d, baseInstance = %u",
          CID(context), GLenumToString(GLESEnum::PrimitiveType, mode), first, count, instanceCount,
          baseInstance);

    if (ANGLE_LIKELY(context != nullptr))
    {
        PrimitiveMode modePacked = PackParam<PrimitiveMode>(mode);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().baseVertexBaseInstanceANGLE))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateDrawArraysInstancedBaseInstanceANGLE(
                    context, angle::EntryPoint::GLDrawArraysInstancedBaseInstanceANGLE, modePacked,
                    first, count, instanceCount, baseInstance);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context,
                                        angle::EntryPoint::GLDrawArraysInstancedBaseInstanceANGLE);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->drawArraysInstancedBaseInstanceANGLE(modePacked, first, count, instanceCount,
                                                          baseInstance);
        }
        ANGLE_CAPTURE_GL(DrawArraysInstancedBaseInstanceANGLE, isCallValid, context, modePacked,
                         first, count, instanceCount, baseInstance);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(
            angle::EntryPoint::GLDrawArraysInstancedBaseInstanceANGLE);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_DrawElementsInstancedBaseVertexBaseInstanceANGLE(GLenum mode,
                                                                     GLsizei count,
                                                                     GLenum type,
                                                                     const void *indices,
                                                                     GLsizei instanceCount,
                                                                     GLint baseVertex,
                                                                     GLuint baseInstance)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLDrawElementsInstancedBaseVertexBaseInstanceANGLE,
          "context = %d, mode = %s, count = %d, type = %s, indices = 0x%016" PRIxPTR
          ", instanceCount = %d, baseVertex = %d, baseInstance = %u",
          CID(context), GLenumToString(GLESEnum::PrimitiveType, mode), count,
          GLenumToString(GLESEnum::DrawElementsType, type), (uintptr_t)indices, instanceCount,
          baseVertex, baseInstance);

    if (ANGLE_LIKELY(context != nullptr))
    {
        PrimitiveMode modePacked    = PackParam<PrimitiveMode>(mode);
        DrawElementsType typePacked = PackParam<DrawElementsType>(type);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().baseVertexBaseInstanceANGLE))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateDrawElementsInstancedBaseVertexBaseInstanceANGLE(
                    context, angle::EntryPoint::GLDrawElementsInstancedBaseVertexBaseInstanceANGLE,
                    modePacked, count, typePacked, indices, instanceCount, baseVertex,
                    baseInstance);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(
                    context, angle::EntryPoint::GLDrawElementsInstancedBaseVertexBaseInstanceANGLE);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->drawElementsInstancedBaseVertexBaseInstanceANGLE(
                modePacked, count, typePacked, indices, instanceCount, baseVertex, baseInstance);
        }
        ANGLE_CAPTURE_GL(DrawElementsInstancedBaseVertexBaseInstanceANGLE, isCallValid, context,
                         modePacked, count, typePacked, indices, instanceCount, baseVertex,
                         baseInstance);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(
            angle::EntryPoint::GLDrawElementsInstancedBaseVertexBaseInstanceANGLE);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_MultiDrawArraysInstancedBaseInstanceANGLE(GLenum mode,
                                                              const GLint *firsts,
                                                              const GLsizei *counts,
                                                              const GLsizei *instanceCounts,
                                                              const GLuint *baseInstances,
                                                              GLsizei drawcount)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLMultiDrawArraysInstancedBaseInstanceANGLE,
          "context = %d, mode = %s, firsts = 0x%016" PRIxPTR ", counts = 0x%016" PRIxPTR
          ", instanceCounts = 0x%016" PRIxPTR ", baseInstances = 0x%016" PRIxPTR ", drawcount = %d",
          CID(context), GLenumToString(GLESEnum::PrimitiveType, mode), (uintptr_t)firsts,
          (uintptr_t)counts, (uintptr_t)instanceCounts, (uintptr_t)baseInstances, drawcount);

    if (ANGLE_LIKELY(context != nullptr))
    {
        PrimitiveMode modePacked = PackParam<PrimitiveMode>(mode);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().baseVertexBaseInstanceANGLE))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateMultiDrawArraysInstancedBaseInstanceANGLE(
                    context, angle::EntryPoint::GLMultiDrawArraysInstancedBaseInstanceANGLE,
                    modePacked, firsts, counts, instanceCounts, baseInstances, drawcount);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(
                    context, angle::EntryPoint::GLMultiDrawArraysInstancedBaseInstanceANGLE);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->multiDrawArraysInstancedBaseInstance(modePacked, firsts, counts,
                                                          instanceCounts, baseInstances, drawcount);
        }
        ANGLE_CAPTURE_GL(MultiDrawArraysInstancedBaseInstanceANGLE, isCallValid, context,
                         modePacked, firsts, counts, instanceCounts, baseInstances, drawcount);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(
            angle::EntryPoint::GLMultiDrawArraysInstancedBaseInstanceANGLE);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY
GL_MultiDrawElementsInstancedBaseVertexBaseInstanceANGLE(GLenum mode,
                                                         const GLsizei *counts,
                                                         GLenum type,
                                                         const void *const *indices,
                                                         const GLsizei *instanceCounts,
                                                         const GLint *baseVertices,
                                                         const GLuint *baseInstances,
                                                         GLsizei drawcount)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLMultiDrawElementsInstancedBaseVertexBaseInstanceANGLE,
          "context = %d, mode = %s, counts = 0x%016" PRIxPTR ", type = %s, indices = 0x%016" PRIxPTR
          ", instanceCounts = 0x%016" PRIxPTR ", baseVertices = 0x%016" PRIxPTR
          ", baseInstances = 0x%016" PRIxPTR ", drawcount = %d",
          CID(context), GLenumToString(GLESEnum::PrimitiveType, mode), (uintptr_t)counts,
          GLenumToString(GLESEnum::DrawElementsType, type), (uintptr_t)indices,
          (uintptr_t)instanceCounts, (uintptr_t)baseVertices, (uintptr_t)baseInstances, drawcount);

    if (ANGLE_LIKELY(context != nullptr))
    {
        PrimitiveMode modePacked    = PackParam<PrimitiveMode>(mode);
        DrawElementsType typePacked = PackParam<DrawElementsType>(type);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().baseVertexBaseInstanceANGLE))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateMultiDrawElementsInstancedBaseVertexBaseInstanceANGLE(
                    context,
                    angle::EntryPoint::GLMultiDrawElementsInstancedBaseVertexBaseInstanceANGLE,
                    modePacked, counts, typePacked, indices, instanceCounts, baseVertices,
                    baseInstances, drawcount);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(
                    context,
                    angle::EntryPoint::GLMultiDrawElementsInstancedBaseVertexBaseInstanceANGLE);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->multiDrawElementsInstancedBaseVertexBaseInstance(
                modePacked, counts, typePacked, indices, instanceCounts, baseVertices,
                baseInstances, drawcount);
        }
        ANGLE_CAPTURE_GL(MultiDrawElementsInstancedBaseVertexBaseInstanceANGLE, isCallValid,
                         context, modePacked, counts, typePacked, indices, instanceCounts,
                         baseVertices, baseInstances, drawcount);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(
            angle::EntryPoint::GLMultiDrawElementsInstancedBaseVertexBaseInstanceANGLE);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

// GL_ANGLE_blob_cache
void GL_APIENTRY GL_BlobCacheCallbacksANGLE(GLSETBLOBPROCANGLE set,
                                            GLGETBLOBPROCANGLE get,
                                            const void *userParam)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLBlobCacheCallbacksANGLE,
          "context = %d, set = 0x%016" PRIxPTR ", get = 0x%016" PRIxPTR
          ", userParam = 0x%016" PRIxPTR "",
          CID(context), (uintptr_t)set, (uintptr_t)get, (uintptr_t)userParam);

    if (ANGLE_LIKELY(context != nullptr))
    {
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().blobCacheANGLE))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateBlobCacheCallbacksANGLE(
                    context, angle::EntryPoint::GLBlobCacheCallbacksANGLE, set, get, userParam);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context, angle::EntryPoint::GLBlobCacheCallbacksANGLE);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->blobCacheCallbacks(set, get, userParam);
        }
        ANGLE_CAPTURE_GL(BlobCacheCallbacksANGLE, isCallValid, context, set, get, userParam);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(
            angle::EntryPoint::GLBlobCacheCallbacksANGLE);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_GetPointervANGLE(GLenum pname, void **params)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLGetPointervANGLE, "context = %d, pname = %s, params = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLESEnum::AllEnums, pname), (uintptr_t)params);

    if (ANGLE_LIKELY(context != nullptr))
    {
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().blobCacheANGLE))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateGetPointervANGLE(
                    context, angle::EntryPoint::GLGetPointervANGLE, pname, params);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context, angle::EntryPoint::GLGetPointervANGLE);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->getPointerv(pname, params);
        }
        ANGLE_CAPTURE_GL(GetPointervANGLE, isCallValid, context, pname, params);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLGetPointervANGLE);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

// GL_ANGLE_client_arrays

// GL_ANGLE_clip_cull_distance

// GL_ANGLE_copy_texture_3d
void GL_APIENTRY GL_CopyTexture3DANGLE(GLuint sourceId,
                                       GLint sourceLevel,
                                       GLenum destTarget,
                                       GLuint destId,
                                       GLint destLevel,
                                       GLint internalFormat,
                                       GLenum destType,
                                       GLboolean unpackFlipY,
                                       GLboolean unpackPremultiplyAlpha,
                                       GLboolean unpackUnmultiplyAlpha)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLCopyTexture3DANGLE,
          "context = %d, sourceId = %u, sourceLevel = %d, destTarget = %s, destId = %u, destLevel "
          "= %d, internalFormat = %d, destType = %s, unpackFlipY = %s, unpackPremultiplyAlpha = "
          "%s, unpackUnmultiplyAlpha = %s",
          CID(context), sourceId, sourceLevel, GLenumToString(GLESEnum::AllEnums, destTarget),
          destId, destLevel, internalFormat, GLenumToString(GLESEnum::AllEnums, destType),
          GLbooleanToString(unpackFlipY), GLbooleanToString(unpackPremultiplyAlpha),
          GLbooleanToString(unpackUnmultiplyAlpha));

    if (ANGLE_LIKELY(context != nullptr))
    {
        TextureID sourceIdPacked       = PackParam<TextureID>(sourceId);
        TextureTarget destTargetPacked = PackParam<TextureTarget>(destTarget);
        TextureID destIdPacked         = PackParam<TextureID>(destId);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().copyTexture3dANGLE))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateCopyTexture3DANGLE(
                    context, angle::EntryPoint::GLCopyTexture3DANGLE, sourceIdPacked, sourceLevel,
                    destTargetPacked, destIdPacked, destLevel, internalFormat, destType,
                    unpackFlipY, unpackPremultiplyAlpha, unpackUnmultiplyAlpha);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context, angle::EntryPoint::GLCopyTexture3DANGLE);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->copyTexture3D(sourceIdPacked, sourceLevel, destTargetPacked, destIdPacked,
                                   destLevel, internalFormat, destType, unpackFlipY,
                                   unpackPremultiplyAlpha, unpackUnmultiplyAlpha);
        }
        ANGLE_CAPTURE_GL(CopyTexture3DANGLE, isCallValid, context, sourceIdPacked, sourceLevel,
                         destTargetPacked, destIdPacked, destLevel, internalFormat, destType,
                         unpackFlipY, unpackPremultiplyAlpha, unpackUnmultiplyAlpha);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLCopyTexture3DANGLE);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_CopySubTexture3DANGLE(GLuint sourceId,
                                          GLint sourceLevel,
                                          GLenum destTarget,
                                          GLuint destId,
                                          GLint destLevel,
                                          GLint xoffset,
                                          GLint yoffset,
                                          GLint zoffset,
                                          GLint x,
                                          GLint y,
                                          GLint z,
                                          GLint width,
                                          GLint height,
                                          GLint depth,
                                          GLboolean unpackFlipY,
                                          GLboolean unpackPremultiplyAlpha,
                                          GLboolean unpackUnmultiplyAlpha)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLCopySubTexture3DANGLE,
          "context = %d, sourceId = %u, sourceLevel = %d, destTarget = %s, destId = %u, destLevel "
          "= %d, xoffset = %d, yoffset = %d, zoffset = %d, x = %d, y = %d, z = %d, width = %d, "
          "height = %d, depth = %d, unpackFlipY = %s, unpackPremultiplyAlpha = %s, "
          "unpackUnmultiplyAlpha = %s",
          CID(context), sourceId, sourceLevel, GLenumToString(GLESEnum::AllEnums, destTarget),
          destId, destLevel, xoffset, yoffset, zoffset, x, y, z, width, height, depth,
          GLbooleanToString(unpackFlipY), GLbooleanToString(unpackPremultiplyAlpha),
          GLbooleanToString(unpackUnmultiplyAlpha));

    if (ANGLE_LIKELY(context != nullptr))
    {
        TextureID sourceIdPacked       = PackParam<TextureID>(sourceId);
        TextureTarget destTargetPacked = PackParam<TextureTarget>(destTarget);
        TextureID destIdPacked         = PackParam<TextureID>(destId);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().copyTexture3dANGLE))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateCopySubTexture3DANGLE(
                    context, angle::EntryPoint::GLCopySubTexture3DANGLE, sourceIdPacked,
                    sourceLevel, destTargetPacked, destIdPacked, destLevel, xoffset, yoffset,
                    zoffset, x, y, z, width, height, depth, unpackFlipY, unpackPremultiplyAlpha,
                    unpackUnmultiplyAlpha);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context, angle::EntryPoint::GLCopySubTexture3DANGLE);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->copySubTexture3D(sourceIdPacked, sourceLevel, destTargetPacked, destIdPacked,
                                      destLevel, xoffset, yoffset, zoffset, x, y, z, width, height,
                                      depth, unpackFlipY, unpackPremultiplyAlpha,
                                      unpackUnmultiplyAlpha);
        }
        ANGLE_CAPTURE_GL(CopySubTexture3DANGLE, isCallValid, context, sourceIdPacked, sourceLevel,
                         destTargetPacked, destIdPacked, destLevel, xoffset, yoffset, zoffset, x, y,
                         z, width, height, depth, unpackFlipY, unpackPremultiplyAlpha,
                         unpackUnmultiplyAlpha);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLCopySubTexture3DANGLE);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

// GL_ANGLE_depth_texture

// GL_ANGLE_framebuffer_blit
void GL_APIENTRY GL_BlitFramebufferANGLE(GLint srcX0,
                                         GLint srcY0,
                                         GLint srcX1,
                                         GLint srcY1,
                                         GLint dstX0,
                                         GLint dstY0,
                                         GLint dstX1,
                                         GLint dstY1,
                                         GLbitfield mask,
                                         GLenum filter)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLBlitFramebufferANGLE,
          "context = %d, srcX0 = %d, srcY0 = %d, srcX1 = %d, srcY1 = %d, dstX0 = %d, dstY0 = %d, "
          "dstX1 = %d, dstY1 = %d, mask = %s, filter = %s",
          CID(context), srcX0, srcY0, srcX1, srcY1, dstX0, dstY0, dstX1, dstY1,
          GLbitfieldToString(GLESEnum::ClearBufferMask, mask).c_str(),
          GLenumToString(GLESEnum::BlitFramebufferFilter, filter));

    if (ANGLE_LIKELY(context != nullptr))
    {
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().framebufferBlitANGLE))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateBlitFramebufferANGLE(
                    context, angle::EntryPoint::GLBlitFramebufferANGLE, srcX0, srcY0, srcX1, srcY1,
                    dstX0, dstY0, dstX1, dstY1, mask, filter);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context, angle::EntryPoint::GLBlitFramebufferANGLE);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->blitFramebuffer(srcX0, srcY0, srcX1, srcY1, dstX0, dstY0, dstX1, dstY1, mask,
                                     filter);
        }
        ANGLE_CAPTURE_GL(BlitFramebufferANGLE, isCallValid, context, srcX0, srcY0, srcX1, srcY1,
                         dstX0, dstY0, dstX1, dstY1, mask, filter);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLBlitFramebufferANGLE);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

// GL_ANGLE_framebuffer_multisample
void GL_APIENTRY GL_RenderbufferStorageMultisampleANGLE(GLenum target,
                                                        GLsizei samples,
                                                        GLenum internalformat,
                                                        GLsizei width,
                                                        GLsizei height)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLRenderbufferStorageMultisampleANGLE,
          "context = %d, target = %s, samples = %d, internalformat = %s, width = %d, height = %d",
          CID(context), GLenumToString(GLESEnum::RenderbufferTarget, target), samples,
          GLenumToString(GLESEnum::InternalFormat, internalformat), width, height);

    if (ANGLE_LIKELY(context != nullptr))
    {
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().framebufferMultisampleANGLE))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateRenderbufferStorageMultisampleANGLE(
                    context, angle::EntryPoint::GLRenderbufferStorageMultisampleANGLE, target,
                    samples, internalformat, width, height);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context,
                                        angle::EntryPoint::GLRenderbufferStorageMultisampleANGLE);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->renderbufferStorageMultisample(target, samples, internalformat, width, height);
        }
        ANGLE_CAPTURE_GL(RenderbufferStorageMultisampleANGLE, isCallValid, context, target, samples,
                         internalformat, width, height);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(
            angle::EntryPoint::GLRenderbufferStorageMultisampleANGLE);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

// GL_ANGLE_get_image
void GL_APIENTRY
GL_GetTexImageANGLE(GLenum target, GLint level, GLenum format, GLenum type, void *pixels)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLGetTexImageANGLE,
          "context = %d, target = %s, level = %d, format = %s, type = %s, pixels = 0x%016" PRIxPTR
          "",
          CID(context), GLenumToString(GLESEnum::TextureTarget, target), level,
          GLenumToString(GLESEnum::PixelFormat, format), GLenumToString(GLESEnum::PixelType, type),
          (uintptr_t)pixels);

    if (ANGLE_LIKELY(context != nullptr))
    {
        TextureTarget targetPacked = PackParam<TextureTarget>(target);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().getImageANGLE))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid =
                    ValidateGetTexImageANGLE(context, angle::EntryPoint::GLGetTexImageANGLE,
                                             targetPacked, level, format, type, pixels);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context, angle::EntryPoint::GLGetTexImageANGLE);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->getTexImage(targetPacked, level, format, type, pixels);
        }
        ANGLE_CAPTURE_GL(GetTexImageANGLE, isCallValid, context, targetPacked, level, format, type,
                         pixels);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLGetTexImageANGLE);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_GetCompressedTexImageANGLE(GLenum target, GLint level, void *pixels)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLGetCompressedTexImageANGLE,
          "context = %d, target = %s, level = %d, pixels = 0x%016" PRIxPTR "", CID(context),
          GLenumToString(GLESEnum::TextureTarget, target), level, (uintptr_t)pixels);

    if (ANGLE_LIKELY(context != nullptr))
    {
        TextureTarget targetPacked = PackParam<TextureTarget>(target);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().getImageANGLE))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateGetCompressedTexImageANGLE(
                    context, angle::EntryPoint::GLGetCompressedTexImageANGLE, targetPacked, level,
                    pixels);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context, angle::EntryPoint::GLGetCompressedTexImageANGLE);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->getCompressedTexImage(targetPacked, level, pixels);
        }
        ANGLE_CAPTURE_GL(GetCompressedTexImageANGLE, isCallValid, context, targetPacked, level,
                         pixels);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(
            angle::EntryPoint::GLGetCompressedTexImageANGLE);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_GetRenderbufferImageANGLE(GLenum target,
                                              GLenum format,
                                              GLenum type,
                                              void *pixels)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLGetRenderbufferImageANGLE,
          "context = %d, target = %s, format = %s, type = %s, pixels = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLESEnum::RenderbufferTarget, target),
          GLenumToString(GLESEnum::PixelFormat, format), GLenumToString(GLESEnum::PixelType, type),
          (uintptr_t)pixels);

    if (ANGLE_LIKELY(context != nullptr))
    {
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().getImageANGLE))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateGetRenderbufferImageANGLE(
                    context, angle::EntryPoint::GLGetRenderbufferImageANGLE, target, format, type,
                    pixels);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context, angle::EntryPoint::GLGetRenderbufferImageANGLE);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->getRenderbufferImage(target, format, type, pixels);
        }
        ANGLE_CAPTURE_GL(GetRenderbufferImageANGLE, isCallValid, context, target, format, type,
                         pixels);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(
            angle::EntryPoint::GLGetRenderbufferImageANGLE);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

// GL_ANGLE_get_serialized_context_string

// GL_ANGLE_get_tex_level_parameter
void GL_APIENTRY GL_GetTexLevelParameterivANGLE(GLenum target,
                                                GLint level,
                                                GLenum pname,
                                                GLint *params)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLGetTexLevelParameterivANGLE,
          "context = %d, target = %s, level = %d, pname = %s, params = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLESEnum::TextureTarget, target), level,
          GLenumToString(GLESEnum::GetTextureParameter, pname), (uintptr_t)params);

    if (ANGLE_LIKELY(context != nullptr))
    {
        TextureTarget targetPacked = PackParam<TextureTarget>(target);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().getTexLevelParameterANGLE))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateGetTexLevelParameterivANGLE(
                    context, angle::EntryPoint::GLGetTexLevelParameterivANGLE, targetPacked, level,
                    pname, params);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context, angle::EntryPoint::GLGetTexLevelParameterivANGLE);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->getTexLevelParameteriv(targetPacked, level, pname, params);
        }
        ANGLE_CAPTURE_GL(GetTexLevelParameterivANGLE, isCallValid, context, targetPacked, level,
                         pname, params);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(
            angle::EntryPoint::GLGetTexLevelParameterivANGLE);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_GetTexLevelParameterfvANGLE(GLenum target,
                                                GLint level,
                                                GLenum pname,
                                                GLfloat *params)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLGetTexLevelParameterfvANGLE,
          "context = %d, target = %s, level = %d, pname = %s, params = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLESEnum::AllEnums, target), level,
          GLenumToString(GLESEnum::AllEnums, pname), (uintptr_t)params);

    if (ANGLE_LIKELY(context != nullptr))
    {
        TextureTarget targetPacked = PackParam<TextureTarget>(target);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().getTexLevelParameterANGLE))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateGetTexLevelParameterfvANGLE(
                    context, angle::EntryPoint::GLGetTexLevelParameterfvANGLE, targetPacked, level,
                    pname, params);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context, angle::EntryPoint::GLGetTexLevelParameterfvANGLE);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->getTexLevelParameterfv(targetPacked, level, pname, params);
        }
        ANGLE_CAPTURE_GL(GetTexLevelParameterfvANGLE, isCallValid, context, targetPacked, level,
                         pname, params);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(
            angle::EntryPoint::GLGetTexLevelParameterfvANGLE);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

// GL_ANGLE_instanced_arrays
void GL_APIENTRY GL_DrawArraysInstancedANGLE(GLenum mode,
                                             GLint first,
                                             GLsizei count,
                                             GLsizei primcount)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLDrawArraysInstancedANGLE,
          "context = %d, mode = %s, first = %d, count = %d, primcount = %d", CID(context),
          GLenumToString(GLESEnum::PrimitiveType, mode), first, count, primcount);

    if (ANGLE_LIKELY(context != nullptr))
    {
        PrimitiveMode modePacked = PackParam<PrimitiveMode>(mode);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().instancedArraysANGLE))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateDrawArraysInstancedANGLE(
                    context, angle::EntryPoint::GLDrawArraysInstancedANGLE, modePacked, first,
                    count, primcount);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context, angle::EntryPoint::GLDrawArraysInstancedANGLE);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->drawArraysInstanced(modePacked, first, count, primcount);
        }
        ANGLE_CAPTURE_GL(DrawArraysInstancedANGLE, isCallValid, context, modePacked, first, count,
                         primcount);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(
            angle::EntryPoint::GLDrawArraysInstancedANGLE);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_DrawElementsInstancedANGLE(GLenum mode,
                                               GLsizei count,
                                               GLenum type,
                                               const void *indices,
                                               GLsizei primcount)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLDrawElementsInstancedANGLE,
          "context = %d, mode = %s, count = %d, type = %s, indices = 0x%016" PRIxPTR
          ", primcount = %d",
          CID(context), GLenumToString(GLESEnum::PrimitiveType, mode), count,
          GLenumToString(GLESEnum::DrawElementsType, type), (uintptr_t)indices, primcount);

    if (ANGLE_LIKELY(context != nullptr))
    {
        PrimitiveMode modePacked    = PackParam<PrimitiveMode>(mode);
        DrawElementsType typePacked = PackParam<DrawElementsType>(type);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().instancedArraysANGLE))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateDrawElementsInstancedANGLE(
                    context, angle::EntryPoint::GLDrawElementsInstancedANGLE, modePacked, count,
                    typePacked, indices, primcount);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context, angle::EntryPoint::GLDrawElementsInstancedANGLE);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->drawElementsInstanced(modePacked, count, typePacked, indices, primcount);
        }
        ANGLE_CAPTURE_GL(DrawElementsInstancedANGLE, isCallValid, context, modePacked, count,
                         typePacked, indices, primcount);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(
            angle::EntryPoint::GLDrawElementsInstancedANGLE);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_VertexAttribDivisorANGLE(GLuint index, GLuint divisor)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLVertexAttribDivisorANGLE, "context = %d, index = %u, divisor = %u",
          CID(context), index, divisor);

    if (ANGLE_LIKELY(context != nullptr))
    {
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().instancedArraysANGLE))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateVertexAttribDivisorANGLE(
                    context->getPrivateState(), context->getMutableErrorSetForValidation(),
                    angle::EntryPoint::GLVertexAttribDivisorANGLE, index, divisor);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(isCallValid || context->getPushedErrorCount() != errorCount);
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context, angle::EntryPoint::GLVertexAttribDivisorANGLE);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            ContextPrivateVertexAttribDivisor(context->getMutablePrivateState(),
                                              context->getMutablePrivateStateCache(), index,
                                              divisor);
        }
        ANGLE_CAPTURE_GL(VertexAttribDivisorANGLE, isCallValid, context, index, divisor);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(
            angle::EntryPoint::GLVertexAttribDivisorANGLE);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

// GL_ANGLE_logic_op
void GL_APIENTRY GL_LogicOpANGLE(GLenum opcode)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLLogicOpANGLE, "context = %d, opcode = %s", CID(context),
          GLenumToString(GLESEnum::LogicOp, opcode));

    if (ANGLE_LIKELY(context != nullptr))
    {
        LogicalOperation opcodePacked = PackParam<LogicalOperation>(opcode);
        bool isCallValid              = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().logicOpANGLE))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateLogicOpANGLE(context->getPrivateState(),
                                                   context->getMutableErrorSetForValidation(),
                                                   angle::EntryPoint::GLLogicOpANGLE, opcodePacked);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(isCallValid || context->getPushedErrorCount() != errorCount);
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context, angle::EntryPoint::GLLogicOpANGLE);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            ContextPrivateLogicOpANGLE(context->getMutablePrivateState(),
                                       context->getMutablePrivateStateCache(), opcodePacked);
        }
        ANGLE_CAPTURE_GL(LogicOpANGLE, isCallValid, context, opcodePacked);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLLogicOpANGLE);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

// GL_ANGLE_lossy_etc_decode

// GL_ANGLE_memory_object_flags
void GL_APIENTRY GL_TexStorageMemFlags2DANGLE(GLenum target,
                                              GLsizei levels,
                                              GLenum internalFormat,
                                              GLsizei width,
                                              GLsizei height,
                                              GLuint memory,
                                              GLuint64 offset,
                                              GLbitfield createFlags,
                                              GLbitfield usageFlags,
                                              const void *imageCreateInfoPNext)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLTexStorageMemFlags2DANGLE,
          "context = %d, target = %s, levels = %d, internalFormat = %s, width = %d, height = %d, "
          "memory = %u, offset = %llu, createFlags = %s, usageFlags = %s, imageCreateInfoPNext = "
          "0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLESEnum::TextureTarget, target), levels,
          GLenumToString(GLESEnum::AllEnums, internalFormat), width, height, memory,
          static_cast<unsigned long long>(offset),
          GLbitfieldToString(GLESEnum::AllEnums, createFlags).c_str(),
          GLbitfieldToString(GLESEnum::AllEnums, usageFlags).c_str(),
          (uintptr_t)imageCreateInfoPNext);

    if (ANGLE_LIKELY(context != nullptr))
    {
        TextureType targetPacked    = PackParam<TextureType>(target);
        MemoryObjectID memoryPacked = PackParam<MemoryObjectID>(memory);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().memoryObjectFlagsANGLE))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateTexStorageMemFlags2DANGLE(
                    context, angle::EntryPoint::GLTexStorageMemFlags2DANGLE, targetPacked, levels,
                    internalFormat, width, height, memoryPacked, offset, createFlags, usageFlags,
                    imageCreateInfoPNext);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context, angle::EntryPoint::GLTexStorageMemFlags2DANGLE);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->texStorageMemFlags2D(targetPacked, levels, internalFormat, width, height,
                                          memoryPacked, offset, createFlags, usageFlags,
                                          imageCreateInfoPNext);
        }
        ANGLE_CAPTURE_GL(TexStorageMemFlags2DANGLE, isCallValid, context, targetPacked, levels,
                         internalFormat, width, height, memoryPacked, offset, createFlags,
                         usageFlags, imageCreateInfoPNext);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(
            angle::EntryPoint::GLTexStorageMemFlags2DANGLE);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_TexStorageMemFlags2DMultisampleANGLE(GLenum target,
                                                         GLsizei samples,
                                                         GLenum internalFormat,
                                                         GLsizei width,
                                                         GLsizei height,
                                                         GLboolean fixedSampleLocations,
                                                         GLuint memory,
                                                         GLuint64 offset,
                                                         GLbitfield createFlags,
                                                         GLbitfield usageFlags,
                                                         const void *imageCreateInfoPNext)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLTexStorageMemFlags2DMultisampleANGLE,
          "context = %d, target = %s, samples = %d, internalFormat = %s, width = %d, height = %d, "
          "fixedSampleLocations = %s, memory = %u, offset = %llu, createFlags = %s, usageFlags = "
          "%s, imageCreateInfoPNext = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLESEnum::TextureTarget, target), samples,
          GLenumToString(GLESEnum::AllEnums, internalFormat), width, height,
          GLbooleanToString(fixedSampleLocations), memory, static_cast<unsigned long long>(offset),
          GLbitfieldToString(GLESEnum::AllEnums, createFlags).c_str(),
          GLbitfieldToString(GLESEnum::AllEnums, usageFlags).c_str(),
          (uintptr_t)imageCreateInfoPNext);

    if (ANGLE_LIKELY(context != nullptr))
    {
        TextureType targetPacked    = PackParam<TextureType>(target);
        MemoryObjectID memoryPacked = PackParam<MemoryObjectID>(memory);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().memoryObjectFlagsANGLE))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateTexStorageMemFlags2DMultisampleANGLE(
                    context, angle::EntryPoint::GLTexStorageMemFlags2DMultisampleANGLE,
                    targetPacked, samples, internalFormat, width, height, fixedSampleLocations,
                    memoryPacked, offset, createFlags, usageFlags, imageCreateInfoPNext);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context,
                                        angle::EntryPoint::GLTexStorageMemFlags2DMultisampleANGLE);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->texStorageMemFlags2DMultisample(
                targetPacked, samples, internalFormat, width, height, fixedSampleLocations,
                memoryPacked, offset, createFlags, usageFlags, imageCreateInfoPNext);
        }
        ANGLE_CAPTURE_GL(TexStorageMemFlags2DMultisampleANGLE, isCallValid, context, targetPacked,
                         samples, internalFormat, width, height, fixedSampleLocations, memoryPacked,
                         offset, createFlags, usageFlags, imageCreateInfoPNext);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(
            angle::EntryPoint::GLTexStorageMemFlags2DMultisampleANGLE);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_TexStorageMemFlags3DANGLE(GLenum target,
                                              GLsizei levels,
                                              GLenum internalFormat,
                                              GLsizei width,
                                              GLsizei height,
                                              GLsizei depth,
                                              GLuint memory,
                                              GLuint64 offset,
                                              GLbitfield createFlags,
                                              GLbitfield usageFlags,
                                              const void *imageCreateInfoPNext)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLTexStorageMemFlags3DANGLE,
          "context = %d, target = %s, levels = %d, internalFormat = %s, width = %d, height = %d, "
          "depth = %d, memory = %u, offset = %llu, createFlags = %s, usageFlags = %s, "
          "imageCreateInfoPNext = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLESEnum::TextureTarget, target), levels,
          GLenumToString(GLESEnum::AllEnums, internalFormat), width, height, depth, memory,
          static_cast<unsigned long long>(offset),
          GLbitfieldToString(GLESEnum::AllEnums, createFlags).c_str(),
          GLbitfieldToString(GLESEnum::AllEnums, usageFlags).c_str(),
          (uintptr_t)imageCreateInfoPNext);

    if (ANGLE_LIKELY(context != nullptr))
    {
        TextureType targetPacked    = PackParam<TextureType>(target);
        MemoryObjectID memoryPacked = PackParam<MemoryObjectID>(memory);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().memoryObjectFlagsANGLE))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateTexStorageMemFlags3DANGLE(
                    context, angle::EntryPoint::GLTexStorageMemFlags3DANGLE, targetPacked, levels,
                    internalFormat, width, height, depth, memoryPacked, offset, createFlags,
                    usageFlags, imageCreateInfoPNext);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context, angle::EntryPoint::GLTexStorageMemFlags3DANGLE);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->texStorageMemFlags3D(targetPacked, levels, internalFormat, width, height,
                                          depth, memoryPacked, offset, createFlags, usageFlags,
                                          imageCreateInfoPNext);
        }
        ANGLE_CAPTURE_GL(TexStorageMemFlags3DANGLE, isCallValid, context, targetPacked, levels,
                         internalFormat, width, height, depth, memoryPacked, offset, createFlags,
                         usageFlags, imageCreateInfoPNext);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(
            angle::EntryPoint::GLTexStorageMemFlags3DANGLE);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_TexStorageMemFlags3DMultisampleANGLE(GLenum target,
                                                         GLsizei samples,
                                                         GLenum internalFormat,
                                                         GLsizei width,
                                                         GLsizei height,
                                                         GLsizei depth,
                                                         GLboolean fixedSampleLocations,
                                                         GLuint memory,
                                                         GLuint64 offset,
                                                         GLbitfield createFlags,
                                                         GLbitfield usageFlags,
                                                         const void *imageCreateInfoPNext)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLTexStorageMemFlags3DMultisampleANGLE,
          "context = %d, target = %s, samples = %d, internalFormat = %s, width = %d, height = %d, "
          "depth = %d, fixedSampleLocations = %s, memory = %u, offset = %llu, createFlags = %s, "
          "usageFlags = %s, imageCreateInfoPNext = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLESEnum::TextureTarget, target), samples,
          GLenumToString(GLESEnum::AllEnums, internalFormat), width, height, depth,
          GLbooleanToString(fixedSampleLocations), memory, static_cast<unsigned long long>(offset),
          GLbitfieldToString(GLESEnum::AllEnums, createFlags).c_str(),
          GLbitfieldToString(GLESEnum::AllEnums, usageFlags).c_str(),
          (uintptr_t)imageCreateInfoPNext);

    if (ANGLE_LIKELY(context != nullptr))
    {
        TextureType targetPacked    = PackParam<TextureType>(target);
        MemoryObjectID memoryPacked = PackParam<MemoryObjectID>(memory);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().memoryObjectFlagsANGLE))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateTexStorageMemFlags3DMultisampleANGLE(
                    context, angle::EntryPoint::GLTexStorageMemFlags3DMultisampleANGLE,
                    targetPacked, samples, internalFormat, width, height, depth,
                    fixedSampleLocations, memoryPacked, offset, createFlags, usageFlags,
                    imageCreateInfoPNext);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context,
                                        angle::EntryPoint::GLTexStorageMemFlags3DMultisampleANGLE);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->texStorageMemFlags3DMultisample(
                targetPacked, samples, internalFormat, width, height, depth, fixedSampleLocations,
                memoryPacked, offset, createFlags, usageFlags, imageCreateInfoPNext);
        }
        ANGLE_CAPTURE_GL(TexStorageMemFlags3DMultisampleANGLE, isCallValid, context, targetPacked,
                         samples, internalFormat, width, height, depth, fixedSampleLocations,
                         memoryPacked, offset, createFlags, usageFlags, imageCreateInfoPNext);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(
            angle::EntryPoint::GLTexStorageMemFlags3DMultisampleANGLE);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

// GL_ANGLE_memory_object_fuchsia
void GL_APIENTRY GL_ImportMemoryZirconHandleANGLE(GLuint memory,
                                                  GLuint64 size,
                                                  GLenum handleType,
                                                  GLuint handle)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLImportMemoryZirconHandleANGLE,
          "context = %d, memory = %u, size = %llu, handleType = %s, handle = %u", CID(context),
          memory, static_cast<unsigned long long>(size),
          GLenumToString(GLESEnum::ExternalHandleType, handleType), handle);

    if (ANGLE_LIKELY(context != nullptr))
    {
        MemoryObjectID memoryPacked = PackParam<MemoryObjectID>(memory);
        HandleType handleTypePacked = PackParam<HandleType>(handleType);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().memoryObjectFuchsiaANGLE))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateImportMemoryZirconHandleANGLE(
                    context, angle::EntryPoint::GLImportMemoryZirconHandleANGLE, memoryPacked, size,
                    handleTypePacked, handle);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context,
                                        angle::EntryPoint::GLImportMemoryZirconHandleANGLE);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->importMemoryZirconHandle(memoryPacked, size, handleTypePacked, handle);
        }
        ANGLE_CAPTURE_GL(ImportMemoryZirconHandleANGLE, isCallValid, context, memoryPacked, size,
                         handleTypePacked, handle);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(
            angle::EntryPoint::GLImportMemoryZirconHandleANGLE);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

// GL_ANGLE_memory_size

// GL_ANGLE_multi_draw
void GL_APIENTRY GL_MultiDrawArraysANGLE(GLenum mode,
                                         const GLint *firsts,
                                         const GLsizei *counts,
                                         GLsizei drawcount)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLMultiDrawArraysANGLE,
          "context = %d, mode = %s, firsts = 0x%016" PRIxPTR ", counts = 0x%016" PRIxPTR
          ", drawcount = %d",
          CID(context), GLenumToString(GLESEnum::PrimitiveType, mode), (uintptr_t)firsts,
          (uintptr_t)counts, drawcount);

    if (ANGLE_LIKELY(context != nullptr))
    {
        PrimitiveMode modePacked = PackParam<PrimitiveMode>(mode);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().multiDrawANGLE))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid =
                    ValidateMultiDrawArraysANGLE(context, angle::EntryPoint::GLMultiDrawArraysANGLE,
                                                 modePacked, firsts, counts, drawcount);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context, angle::EntryPoint::GLMultiDrawArraysANGLE);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->multiDrawArrays(modePacked, firsts, counts, drawcount);
        }
        ANGLE_CAPTURE_GL(MultiDrawArraysANGLE, isCallValid, context, modePacked, firsts, counts,
                         drawcount);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLMultiDrawArraysANGLE);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_MultiDrawArraysInstancedANGLE(GLenum mode,
                                                  const GLint *firsts,
                                                  const GLsizei *counts,
                                                  const GLsizei *instanceCounts,
                                                  GLsizei drawcount)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLMultiDrawArraysInstancedANGLE,
          "context = %d, mode = %s, firsts = 0x%016" PRIxPTR ", counts = 0x%016" PRIxPTR
          ", instanceCounts = 0x%016" PRIxPTR ", drawcount = %d",
          CID(context), GLenumToString(GLESEnum::PrimitiveType, mode), (uintptr_t)firsts,
          (uintptr_t)counts, (uintptr_t)instanceCounts, drawcount);

    if (ANGLE_LIKELY(context != nullptr))
    {
        PrimitiveMode modePacked = PackParam<PrimitiveMode>(mode);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().multiDrawANGLE))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateMultiDrawArraysInstancedANGLE(
                    context, angle::EntryPoint::GLMultiDrawArraysInstancedANGLE, modePacked, firsts,
                    counts, instanceCounts, drawcount);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context,
                                        angle::EntryPoint::GLMultiDrawArraysInstancedANGLE);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->multiDrawArraysInstanced(modePacked, firsts, counts, instanceCounts,
                                              drawcount);
        }
        ANGLE_CAPTURE_GL(MultiDrawArraysInstancedANGLE, isCallValid, context, modePacked, firsts,
                         counts, instanceCounts, drawcount);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(
            angle::EntryPoint::GLMultiDrawArraysInstancedANGLE);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_MultiDrawElementsANGLE(GLenum mode,
                                           const GLsizei *counts,
                                           GLenum type,
                                           const void *const *indices,
                                           GLsizei drawcount)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLMultiDrawElementsANGLE,
          "context = %d, mode = %s, counts = 0x%016" PRIxPTR ", type = %s, indices = 0x%016" PRIxPTR
          ", drawcount = %d",
          CID(context), GLenumToString(GLESEnum::PrimitiveType, mode), (uintptr_t)counts,
          GLenumToString(GLESEnum::DrawElementsType, type), (uintptr_t)indices, drawcount);

    if (ANGLE_LIKELY(context != nullptr))
    {
        PrimitiveMode modePacked    = PackParam<PrimitiveMode>(mode);
        DrawElementsType typePacked = PackParam<DrawElementsType>(type);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().multiDrawANGLE))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateMultiDrawElementsANGLE(
                    context, angle::EntryPoint::GLMultiDrawElementsANGLE, modePacked, counts,
                    typePacked, indices, drawcount);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context, angle::EntryPoint::GLMultiDrawElementsANGLE);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->multiDrawElements(modePacked, counts, typePacked, indices, drawcount);
        }
        ANGLE_CAPTURE_GL(MultiDrawElementsANGLE, isCallValid, context, modePacked, counts,
                         typePacked, indices, drawcount);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLMultiDrawElementsANGLE);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_MultiDrawElementsInstancedANGLE(GLenum mode,
                                                    const GLsizei *counts,
                                                    GLenum type,
                                                    const void *const *indices,
                                                    const GLsizei *instanceCounts,
                                                    GLsizei drawcount)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLMultiDrawElementsInstancedANGLE,
          "context = %d, mode = %s, counts = 0x%016" PRIxPTR ", type = %s, indices = 0x%016" PRIxPTR
          ", instanceCounts = 0x%016" PRIxPTR ", drawcount = %d",
          CID(context), GLenumToString(GLESEnum::PrimitiveType, mode), (uintptr_t)counts,
          GLenumToString(GLESEnum::DrawElementsType, type), (uintptr_t)indices,
          (uintptr_t)instanceCounts, drawcount);

    if (ANGLE_LIKELY(context != nullptr))
    {
        PrimitiveMode modePacked    = PackParam<PrimitiveMode>(mode);
        DrawElementsType typePacked = PackParam<DrawElementsType>(type);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().multiDrawANGLE))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateMultiDrawElementsInstancedANGLE(
                    context, angle::EntryPoint::GLMultiDrawElementsInstancedANGLE, modePacked,
                    counts, typePacked, indices, instanceCounts, drawcount);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context,
                                        angle::EntryPoint::GLMultiDrawElementsInstancedANGLE);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->multiDrawElementsInstanced(modePacked, counts, typePacked, indices,
                                                instanceCounts, drawcount);
        }
        ANGLE_CAPTURE_GL(MultiDrawElementsInstancedANGLE, isCallValid, context, modePacked, counts,
                         typePacked, indices, instanceCounts, drawcount);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(
            angle::EntryPoint::GLMultiDrawElementsInstancedANGLE);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

// GL_ANGLE_pack_reverse_row_order

// GL_ANGLE_polygon_mode
void GL_APIENTRY GL_PolygonModeANGLE(GLenum face, GLenum mode)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLPolygonModeANGLE, "context = %d, face = %s, mode = %s", CID(context),
          GLenumToString(GLESEnum::TriangleFace, face),
          GLenumToString(GLESEnum::PolygonMode, mode));

    if (ANGLE_LIKELY(context != nullptr))
    {
        PolygonMode modePacked = PackParam<PolygonMode>(mode);
        bool isCallValid       = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().polygonModeANGLE))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidatePolygonModeANGLE(
                    context->getPrivateState(), context->getMutableErrorSetForValidation(),
                    angle::EntryPoint::GLPolygonModeANGLE, face, modePacked);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(isCallValid || context->getPushedErrorCount() != errorCount);
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context, angle::EntryPoint::GLPolygonModeANGLE);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            ContextPrivatePolygonMode(context->getMutablePrivateState(),
                                      context->getMutablePrivateStateCache(), face, modePacked);
        }
        ANGLE_CAPTURE_GL(PolygonModeANGLE, isCallValid, context, face, modePacked);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLPolygonModeANGLE);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

// GL_ANGLE_program_binary

// GL_ANGLE_program_binary_readiness_query

// GL_ANGLE_program_cache_control

// GL_ANGLE_provoking_vertex
void GL_APIENTRY GL_ProvokingVertexANGLE(GLenum provokeMode)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLProvokingVertexANGLE, "context = %d, provokeMode = %s", CID(context),
          GLenumToString(GLESEnum::VertexProvokingMode, provokeMode));

    if (ANGLE_LIKELY(context != nullptr))
    {
        ProvokingVertexConvention provokeModePacked =
            PackParam<ProvokingVertexConvention>(provokeMode);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().provokingVertexANGLE))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateProvokingVertexANGLE(
                    context->getPrivateState(), context->getMutableErrorSetForValidation(),
                    angle::EntryPoint::GLProvokingVertexANGLE, provokeModePacked);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(isCallValid || context->getPushedErrorCount() != errorCount);
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context, angle::EntryPoint::GLProvokingVertexANGLE);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            ContextPrivateProvokingVertex(context->getMutablePrivateState(),
                                          context->getMutablePrivateStateCache(),
                                          provokeModePacked);
        }
        ANGLE_CAPTURE_GL(ProvokingVertexANGLE, isCallValid, context, provokeModePacked);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLProvokingVertexANGLE);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

// GL_ANGLE_renderability_validation

// GL_ANGLE_request_extension
void GL_APIENTRY GL_RequestExtensionANGLE(const GLchar *name)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLRequestExtensionANGLE, "context = %d, name = 0x%016" PRIxPTR "", CID(context),
          (uintptr_t)name);

    if (ANGLE_LIKELY(context != nullptr))
    {
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().requestExtensionANGLE))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateRequestExtensionANGLE(
                    context, angle::EntryPoint::GLRequestExtensionANGLE, name);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context, angle::EntryPoint::GLRequestExtensionANGLE);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->requestExtension(name);
        }
        ANGLE_CAPTURE_GL(RequestExtensionANGLE, isCallValid, context, name);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLRequestExtensionANGLE);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_DisableExtensionANGLE(const GLchar *name)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLDisableExtensionANGLE, "context = %d, name = 0x%016" PRIxPTR "", CID(context),
          (uintptr_t)name);

    if (ANGLE_LIKELY(context != nullptr))
    {
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().requestExtensionANGLE))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateDisableExtensionANGLE(
                    context, angle::EntryPoint::GLDisableExtensionANGLE, name);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context, angle::EntryPoint::GLDisableExtensionANGLE);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->disableExtension(name);
        }
        ANGLE_CAPTURE_GL(DisableExtensionANGLE, isCallValid, context, name);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLDisableExtensionANGLE);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

// GL_ANGLE_rgbx_internal_format

// GL_ANGLE_robust_client_memory
void GL_APIENTRY GL_GetBooleanvRobustANGLE(GLenum pname,
                                           GLsizei bufSize,
                                           GLsizei *length,
                                           GLboolean *params)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLGetBooleanvRobustANGLE,
          "context = %d, pname = %s, bufSize = %d, length = 0x%016" PRIxPTR
          ", params = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLESEnum::AllEnums, pname), bufSize, (uintptr_t)length,
          (uintptr_t)params);

    if (ANGLE_LIKELY(context != nullptr))
    {
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().robustClientMemoryANGLE))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateGetBooleanvRobustANGLE(
                    context, angle::EntryPoint::GLGetBooleanvRobustANGLE, pname, bufSize, length,
                    params);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context, angle::EntryPoint::GLGetBooleanvRobustANGLE);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->getBooleanvRobust(pname, bufSize, length, params);
        }
        ANGLE_CAPTURE_GL(GetBooleanvRobustANGLE, isCallValid, context, pname, bufSize, length,
                         params);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLGetBooleanvRobustANGLE);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_GetBufferParameterivRobustANGLE(GLenum target,
                                                    GLenum pname,
                                                    GLsizei bufSize,
                                                    GLsizei *length,
                                                    GLint *params)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLGetBufferParameterivRobustANGLE,
          "context = %d, target = %s, pname = %s, bufSize = %d, length = 0x%016" PRIxPTR
          ", params = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLESEnum::AllEnums, target),
          GLenumToString(GLESEnum::AllEnums, pname), bufSize, (uintptr_t)length, (uintptr_t)params);

    if (ANGLE_LIKELY(context != nullptr))
    {
        BufferBinding targetPacked = PackParam<BufferBinding>(target);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().robustClientMemoryANGLE))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateGetBufferParameterivRobustANGLE(
                    context, angle::EntryPoint::GLGetBufferParameterivRobustANGLE, targetPacked,
                    pname, bufSize, length, params);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context,
                                        angle::EntryPoint::GLGetBufferParameterivRobustANGLE);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->getBufferParameterivRobust(targetPacked, pname, bufSize, length, params);
        }
        ANGLE_CAPTURE_GL(GetBufferParameterivRobustANGLE, isCallValid, context, targetPacked, pname,
                         bufSize, length, params);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(
            angle::EntryPoint::GLGetBufferParameterivRobustANGLE);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_GetFloatvRobustANGLE(GLenum pname,
                                         GLsizei bufSize,
                                         GLsizei *length,
                                         GLfloat *params)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLGetFloatvRobustANGLE,
          "context = %d, pname = %s, bufSize = %d, length = 0x%016" PRIxPTR
          ", params = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLESEnum::AllEnums, pname), bufSize, (uintptr_t)length,
          (uintptr_t)params);

    if (ANGLE_LIKELY(context != nullptr))
    {
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().robustClientMemoryANGLE))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid =
                    ValidateGetFloatvRobustANGLE(context, angle::EntryPoint::GLGetFloatvRobustANGLE,
                                                 pname, bufSize, length, params);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context, angle::EntryPoint::GLGetFloatvRobustANGLE);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->getFloatvRobust(pname, bufSize, length, params);
        }
        ANGLE_CAPTURE_GL(GetFloatvRobustANGLE, isCallValid, context, pname, bufSize, length,
                         params);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLGetFloatvRobustANGLE);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_GetFramebufferAttachmentParameterivRobustANGLE(GLenum target,
                                                                   GLenum attachment,
                                                                   GLenum pname,
                                                                   GLsizei bufSize,
                                                                   GLsizei *length,
                                                                   GLint *params)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLGetFramebufferAttachmentParameterivRobustANGLE,
          "context = %d, target = %s, attachment = %s, pname = %s, bufSize = %d, length = "
          "0x%016" PRIxPTR ", params = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLESEnum::AllEnums, target),
          GLenumToString(GLESEnum::AllEnums, attachment), GLenumToString(GLESEnum::AllEnums, pname),
          bufSize, (uintptr_t)length, (uintptr_t)params);

    if (ANGLE_LIKELY(context != nullptr))
    {
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().robustClientMemoryANGLE))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateGetFramebufferAttachmentParameterivRobustANGLE(
                    context, angle::EntryPoint::GLGetFramebufferAttachmentParameterivRobustANGLE,
                    target, attachment, pname, bufSize, length, params);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(
                    context, angle::EntryPoint::GLGetFramebufferAttachmentParameterivRobustANGLE);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->getFramebufferAttachmentParameterivRobust(target, attachment, pname, bufSize,
                                                               length, params);
        }
        ANGLE_CAPTURE_GL(GetFramebufferAttachmentParameterivRobustANGLE, isCallValid, context,
                         target, attachment, pname, bufSize, length, params);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(
            angle::EntryPoint::GLGetFramebufferAttachmentParameterivRobustANGLE);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_GetIntegervRobustANGLE(GLenum pname,
                                           GLsizei bufSize,
                                           GLsizei *length,
                                           GLint *data)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLGetIntegervRobustANGLE,
          "context = %d, pname = %s, bufSize = %d, length = 0x%016" PRIxPTR
          ", data = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLESEnum::AllEnums, pname), bufSize, (uintptr_t)length,
          (uintptr_t)data);

    if (ANGLE_LIKELY(context != nullptr))
    {
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().robustClientMemoryANGLE))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateGetIntegervRobustANGLE(
                    context, angle::EntryPoint::GLGetIntegervRobustANGLE, pname, bufSize, length,
                    data);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context, angle::EntryPoint::GLGetIntegervRobustANGLE);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->getIntegervRobust(pname, bufSize, length, data);
        }
        ANGLE_CAPTURE_GL(GetIntegervRobustANGLE, isCallValid, context, pname, bufSize, length,
                         data);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLGetIntegervRobustANGLE);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_GetProgramivRobustANGLE(GLuint program,
                                            GLenum pname,
                                            GLsizei bufSize,
                                            GLsizei *length,
                                            GLint *params)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetGlobalContext();
    EVENT(context, GLGetProgramivRobustANGLE,
          "context = %d, program = %u, pname = %s, bufSize = %d, length = 0x%016" PRIxPTR
          ", params = 0x%016" PRIxPTR "",
          CID(context), program, GLenumToString(GLESEnum::AllEnums, pname), bufSize,
          (uintptr_t)length, (uintptr_t)params);

    if (ANGLE_LIKELY(context != nullptr))
    {
        ShaderProgramID programPacked = PackParam<ShaderProgramID>(program);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().robustClientMemoryANGLE))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateGetProgramivRobustANGLE(
                    context, angle::EntryPoint::GLGetProgramivRobustANGLE, programPacked, pname,
                    bufSize, length, params);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context, angle::EntryPoint::GLGetProgramivRobustANGLE);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->getProgramivRobust(programPacked, pname, bufSize, length, params);
        }
        ANGLE_CAPTURE_GL(GetProgramivRobustANGLE, isCallValid, context, programPacked, pname,
                         bufSize, length, params);
    }
    else
    {
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_GetRenderbufferParameterivRobustANGLE(GLenum target,
                                                          GLenum pname,
                                                          GLsizei bufSize,
                                                          GLsizei *length,
                                                          GLint *params)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLGetRenderbufferParameterivRobustANGLE,
          "context = %d, target = %s, pname = %s, bufSize = %d, length = 0x%016" PRIxPTR
          ", params = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLESEnum::AllEnums, target),
          GLenumToString(GLESEnum::AllEnums, pname), bufSize, (uintptr_t)length, (uintptr_t)params);

    if (ANGLE_LIKELY(context != nullptr))
    {
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().robustClientMemoryANGLE))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateGetRenderbufferParameterivRobustANGLE(
                    context, angle::EntryPoint::GLGetRenderbufferParameterivRobustANGLE, target,
                    pname, bufSize, length, params);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context,
                                        angle::EntryPoint::GLGetRenderbufferParameterivRobustANGLE);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->getRenderbufferParameterivRobust(target, pname, bufSize, length, params);
        }
        ANGLE_CAPTURE_GL(GetRenderbufferParameterivRobustANGLE, isCallValid, context, target, pname,
                         bufSize, length, params);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(
            angle::EntryPoint::GLGetRenderbufferParameterivRobustANGLE);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_GetShaderivRobustANGLE(GLuint shader,
                                           GLenum pname,
                                           GLsizei bufSize,
                                           GLsizei *length,
                                           GLint *params)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetGlobalContext();
    EVENT(context, GLGetShaderivRobustANGLE,
          "context = %d, shader = %u, pname = %s, bufSize = %d, length = 0x%016" PRIxPTR
          ", params = 0x%016" PRIxPTR "",
          CID(context), shader, GLenumToString(GLESEnum::AllEnums, pname), bufSize,
          (uintptr_t)length, (uintptr_t)params);

    if (ANGLE_LIKELY(context != nullptr))
    {
        ShaderProgramID shaderPacked = PackParam<ShaderProgramID>(shader);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().robustClientMemoryANGLE))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateGetShaderivRobustANGLE(
                    context, angle::EntryPoint::GLGetShaderivRobustANGLE, shaderPacked, pname,
                    bufSize, length, params);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context, angle::EntryPoint::GLGetShaderivRobustANGLE);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->getShaderivRobust(shaderPacked, pname, bufSize, length, params);
        }
        ANGLE_CAPTURE_GL(GetShaderivRobustANGLE, isCallValid, context, shaderPacked, pname, bufSize,
                         length, params);
    }
    else
    {
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_GetTexParameterfvRobustANGLE(GLenum target,
                                                 GLenum pname,
                                                 GLsizei bufSize,
                                                 GLsizei *length,
                                                 GLfloat *params)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLGetTexParameterfvRobustANGLE,
          "context = %d, target = %s, pname = %s, bufSize = %d, length = 0x%016" PRIxPTR
          ", params = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLESEnum::AllEnums, target),
          GLenumToString(GLESEnum::AllEnums, pname), bufSize, (uintptr_t)length, (uintptr_t)params);

    if (ANGLE_LIKELY(context != nullptr))
    {
        TextureType targetPacked = PackParam<TextureType>(target);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().robustClientMemoryANGLE))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateGetTexParameterfvRobustANGLE(
                    context, angle::EntryPoint::GLGetTexParameterfvRobustANGLE, targetPacked, pname,
                    bufSize, length, params);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context, angle::EntryPoint::GLGetTexParameterfvRobustANGLE);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->getTexParameterfvRobust(targetPacked, pname, bufSize, length, params);
        }
        ANGLE_CAPTURE_GL(GetTexParameterfvRobustANGLE, isCallValid, context, targetPacked, pname,
                         bufSize, length, params);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(
            angle::EntryPoint::GLGetTexParameterfvRobustANGLE);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_GetTexParameterivRobustANGLE(GLenum target,
                                                 GLenum pname,
                                                 GLsizei bufSize,
                                                 GLsizei *length,
                                                 GLint *params)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLGetTexParameterivRobustANGLE,
          "context = %d, target = %s, pname = %s, bufSize = %d, length = 0x%016" PRIxPTR
          ", params = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLESEnum::AllEnums, target),
          GLenumToString(GLESEnum::AllEnums, pname), bufSize, (uintptr_t)length, (uintptr_t)params);

    if (ANGLE_LIKELY(context != nullptr))
    {
        TextureType targetPacked = PackParam<TextureType>(target);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().robustClientMemoryANGLE))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateGetTexParameterivRobustANGLE(
                    context, angle::EntryPoint::GLGetTexParameterivRobustANGLE, targetPacked, pname,
                    bufSize, length, params);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context, angle::EntryPoint::GLGetTexParameterivRobustANGLE);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->getTexParameterivRobust(targetPacked, pname, bufSize, length, params);
        }
        ANGLE_CAPTURE_GL(GetTexParameterivRobustANGLE, isCallValid, context, targetPacked, pname,
                         bufSize, length, params);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(
            angle::EntryPoint::GLGetTexParameterivRobustANGLE);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_GetUniformfvRobustANGLE(GLuint program,
                                            GLint location,
                                            GLsizei bufSize,
                                            GLsizei *length,
                                            GLfloat *params)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLGetUniformfvRobustANGLE,
          "context = %d, program = %u, location = %d, bufSize = %d, length = 0x%016" PRIxPTR
          ", params = 0x%016" PRIxPTR "",
          CID(context), program, location, bufSize, (uintptr_t)length, (uintptr_t)params);

    if (ANGLE_LIKELY(context != nullptr))
    {
        ShaderProgramID programPacked  = PackParam<ShaderProgramID>(program);
        UniformLocation locationPacked = PackParam<UniformLocation>(location);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().robustClientMemoryANGLE))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateGetUniformfvRobustANGLE(
                    context, angle::EntryPoint::GLGetUniformfvRobustANGLE, programPacked,
                    locationPacked, bufSize, length, params);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context, angle::EntryPoint::GLGetUniformfvRobustANGLE);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->getUniformfvRobust(programPacked, locationPacked, bufSize, length, params);
        }
        ANGLE_CAPTURE_GL(GetUniformfvRobustANGLE, isCallValid, context, programPacked,
                         locationPacked, bufSize, length, params);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(
            angle::EntryPoint::GLGetUniformfvRobustANGLE);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_GetUniformivRobustANGLE(GLuint program,
                                            GLint location,
                                            GLsizei bufSize,
                                            GLsizei *length,
                                            GLint *params)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLGetUniformivRobustANGLE,
          "context = %d, program = %u, location = %d, bufSize = %d, length = 0x%016" PRIxPTR
          ", params = 0x%016" PRIxPTR "",
          CID(context), program, location, bufSize, (uintptr_t)length, (uintptr_t)params);

    if (ANGLE_LIKELY(context != nullptr))
    {
        ShaderProgramID programPacked  = PackParam<ShaderProgramID>(program);
        UniformLocation locationPacked = PackParam<UniformLocation>(location);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().robustClientMemoryANGLE))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateGetUniformivRobustANGLE(
                    context, angle::EntryPoint::GLGetUniformivRobustANGLE, programPacked,
                    locationPacked, bufSize, length, params);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context, angle::EntryPoint::GLGetUniformivRobustANGLE);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->getUniformivRobust(programPacked, locationPacked, bufSize, length, params);
        }
        ANGLE_CAPTURE_GL(GetUniformivRobustANGLE, isCallValid, context, programPacked,
                         locationPacked, bufSize, length, params);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(
            angle::EntryPoint::GLGetUniformivRobustANGLE);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_GetVertexAttribfvRobustANGLE(GLuint index,
                                                 GLenum pname,
                                                 GLsizei bufSize,
                                                 GLsizei *length,
                                                 GLfloat *params)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLGetVertexAttribfvRobustANGLE,
          "context = %d, index = %u, pname = %s, bufSize = %d, length = 0x%016" PRIxPTR
          ", params = 0x%016" PRIxPTR "",
          CID(context), index, GLenumToString(GLESEnum::AllEnums, pname), bufSize,
          (uintptr_t)length, (uintptr_t)params);

    if (ANGLE_LIKELY(context != nullptr))
    {
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().robustClientMemoryANGLE))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateGetVertexAttribfvRobustANGLE(
                    context, angle::EntryPoint::GLGetVertexAttribfvRobustANGLE, index, pname,
                    bufSize, length, params);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context, angle::EntryPoint::GLGetVertexAttribfvRobustANGLE);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->getVertexAttribfvRobust(index, pname, bufSize, length, params);
        }
        ANGLE_CAPTURE_GL(GetVertexAttribfvRobustANGLE, isCallValid, context, index, pname, bufSize,
                         length, params);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(
            angle::EntryPoint::GLGetVertexAttribfvRobustANGLE);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_GetVertexAttribivRobustANGLE(GLuint index,
                                                 GLenum pname,
                                                 GLsizei bufSize,
                                                 GLsizei *length,
                                                 GLint *params)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLGetVertexAttribivRobustANGLE,
          "context = %d, index = %u, pname = %s, bufSize = %d, length = 0x%016" PRIxPTR
          ", params = 0x%016" PRIxPTR "",
          CID(context), index, GLenumToString(GLESEnum::AllEnums, pname), bufSize,
          (uintptr_t)length, (uintptr_t)params);

    if (ANGLE_LIKELY(context != nullptr))
    {
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().robustClientMemoryANGLE))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateGetVertexAttribivRobustANGLE(
                    context, angle::EntryPoint::GLGetVertexAttribivRobustANGLE, index, pname,
                    bufSize, length, params);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context, angle::EntryPoint::GLGetVertexAttribivRobustANGLE);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->getVertexAttribivRobust(index, pname, bufSize, length, params);
        }
        ANGLE_CAPTURE_GL(GetVertexAttribivRobustANGLE, isCallValid, context, index, pname, bufSize,
                         length, params);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(
            angle::EntryPoint::GLGetVertexAttribivRobustANGLE);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_GetVertexAttribPointervRobustANGLE(GLuint index,
                                                       GLenum pname,
                                                       GLsizei bufSize,
                                                       GLsizei *length,
                                                       void **pointer)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLGetVertexAttribPointervRobustANGLE,
          "context = %d, index = %u, pname = %s, bufSize = %d, length = 0x%016" PRIxPTR
          ", pointer = 0x%016" PRIxPTR "",
          CID(context), index, GLenumToString(GLESEnum::AllEnums, pname), bufSize,
          (uintptr_t)length, (uintptr_t)pointer);

    if (ANGLE_LIKELY(context != nullptr))
    {
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().robustClientMemoryANGLE))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateGetVertexAttribPointervRobustANGLE(
                    context, angle::EntryPoint::GLGetVertexAttribPointervRobustANGLE, index, pname,
                    bufSize, length, pointer);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context,
                                        angle::EntryPoint::GLGetVertexAttribPointervRobustANGLE);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->getVertexAttribPointervRobust(index, pname, bufSize, length, pointer);
        }
        ANGLE_CAPTURE_GL(GetVertexAttribPointervRobustANGLE, isCallValid, context, index, pname,
                         bufSize, length, pointer);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(
            angle::EntryPoint::GLGetVertexAttribPointervRobustANGLE);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_ReadPixelsRobustANGLE(GLint x,
                                          GLint y,
                                          GLsizei width,
                                          GLsizei height,
                                          GLenum format,
                                          GLenum type,
                                          GLsizei bufSize,
                                          GLsizei *length,
                                          GLsizei *columns,
                                          GLsizei *rows,
                                          void *pixels)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLReadPixelsRobustANGLE,
          "context = %d, x = %d, y = %d, width = %d, height = %d, format = %s, type = %s, bufSize "
          "= %d, length = 0x%016" PRIxPTR ", columns = 0x%016" PRIxPTR ", rows = 0x%016" PRIxPTR
          ", pixels = 0x%016" PRIxPTR "",
          CID(context), x, y, width, height, GLenumToString(GLESEnum::AllEnums, format),
          GLenumToString(GLESEnum::AllEnums, type), bufSize, (uintptr_t)length, (uintptr_t)columns,
          (uintptr_t)rows, (uintptr_t)pixels);

    if (ANGLE_LIKELY(context != nullptr))
    {
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().robustClientMemoryANGLE))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateReadPixelsRobustANGLE(
                    context, angle::EntryPoint::GLReadPixelsRobustANGLE, x, y, width, height,
                    format, type, bufSize, length, columns, rows, pixels);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context, angle::EntryPoint::GLReadPixelsRobustANGLE);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->readPixelsRobust(x, y, width, height, format, type, bufSize, length, columns,
                                      rows, pixels);
        }
        ANGLE_CAPTURE_GL(ReadPixelsRobustANGLE, isCallValid, context, x, y, width, height, format,
                         type, bufSize, length, columns, rows, pixels);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLReadPixelsRobustANGLE);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_TexImage2DRobustANGLE(GLenum target,
                                          GLint level,
                                          GLint internalformat,
                                          GLsizei width,
                                          GLsizei height,
                                          GLint border,
                                          GLenum format,
                                          GLenum type,
                                          GLsizei bufSize,
                                          const void *pixels)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLTexImage2DRobustANGLE,
          "context = %d, target = %s, level = %d, internalformat = %d, width = %d, height = %d, "
          "border = %d, format = %s, type = %s, bufSize = %d, pixels = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLESEnum::AllEnums, target), level, internalformat, width,
          height, border, GLenumToString(GLESEnum::AllEnums, format),
          GLenumToString(GLESEnum::AllEnums, type), bufSize, (uintptr_t)pixels);

    if (ANGLE_LIKELY(context != nullptr))
    {
        TextureTarget targetPacked = PackParam<TextureTarget>(target);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().robustClientMemoryANGLE))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateTexImage2DRobustANGLE(
                    context, angle::EntryPoint::GLTexImage2DRobustANGLE, targetPacked, level,
                    internalformat, width, height, border, format, type, bufSize, pixels);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context, angle::EntryPoint::GLTexImage2DRobustANGLE);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->texImage2DRobust(targetPacked, level, internalformat, width, height, border,
                                      format, type, bufSize, pixels);
        }
        ANGLE_CAPTURE_GL(TexImage2DRobustANGLE, isCallValid, context, targetPacked, level,
                         internalformat, width, height, border, format, type, bufSize, pixels);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLTexImage2DRobustANGLE);
    }
    egl::Display::GetCurrentThreadUnlockedTailCall()->run(nullptr);
}

void GL_APIENTRY GL_TexParameterfvRobustANGLE(GLenum target,
                                              GLenum pname,
                                              GLsizei bufSize,
                                              const GLfloat *params)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLTexParameterfvRobustANGLE,
          "context = %d, target = %s, pname = %s, bufSize = %d, params = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLESEnum::AllEnums, target),
          GLenumToString(GLESEnum::AllEnums, pname), bufSize, (uintptr_t)params);

    if (ANGLE_LIKELY(context != nullptr))
    {
        TextureType targetPacked = PackParam<TextureType>(target);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().robustClientMemoryANGLE))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateTexParameterfvRobustANGLE(
                    context, angle::EntryPoint::GLTexParameterfvRobustANGLE, targetPacked, pname,
                    bufSize, params);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context, angle::EntryPoint::GLTexParameterfvRobustANGLE);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->texParameterfvRobust(targetPacked, pname, bufSize, params);
        }
        ANGLE_CAPTURE_GL(TexParameterfvRobustANGLE, isCallValid, context, targetPacked, pname,
                         bufSize, params);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(
            angle::EntryPoint::GLTexParameterfvRobustANGLE);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_TexParameterivRobustANGLE(GLenum target,
                                              GLenum pname,
                                              GLsizei bufSize,
                                              const GLint *params)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLTexParameterivRobustANGLE,
          "context = %d, target = %s, pname = %s, bufSize = %d, params = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLESEnum::AllEnums, target),
          GLenumToString(GLESEnum::AllEnums, pname), bufSize, (uintptr_t)params);

    if (ANGLE_LIKELY(context != nullptr))
    {
        TextureType targetPacked = PackParam<TextureType>(target);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().robustClientMemoryANGLE))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateTexParameterivRobustANGLE(
                    context, angle::EntryPoint::GLTexParameterivRobustANGLE, targetPacked, pname,
                    bufSize, params);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context, angle::EntryPoint::GLTexParameterivRobustANGLE);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->texParameterivRobust(targetPacked, pname, bufSize, params);
        }
        ANGLE_CAPTURE_GL(TexParameterivRobustANGLE, isCallValid, context, targetPacked, pname,
                         bufSize, params);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(
            angle::EntryPoint::GLTexParameterivRobustANGLE);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_TexSubImage2DRobustANGLE(GLenum target,
                                             GLint level,
                                             GLint xoffset,
                                             GLint yoffset,
                                             GLsizei width,
                                             GLsizei height,
                                             GLenum format,
                                             GLenum type,
                                             GLsizei bufSize,
                                             const void *pixels)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLTexSubImage2DRobustANGLE,
          "context = %d, target = %s, level = %d, xoffset = %d, yoffset = %d, width = %d, height = "
          "%d, format = %s, type = %s, bufSize = %d, pixels = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLESEnum::AllEnums, target), level, xoffset, yoffset, width,
          height, GLenumToString(GLESEnum::AllEnums, format),
          GLenumToString(GLESEnum::AllEnums, type), bufSize, (uintptr_t)pixels);

    if (ANGLE_LIKELY(context != nullptr))
    {
        TextureTarget targetPacked = PackParam<TextureTarget>(target);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().robustClientMemoryANGLE))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateTexSubImage2DRobustANGLE(
                    context, angle::EntryPoint::GLTexSubImage2DRobustANGLE, targetPacked, level,
                    xoffset, yoffset, width, height, format, type, bufSize, pixels);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context, angle::EntryPoint::GLTexSubImage2DRobustANGLE);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->texSubImage2DRobust(targetPacked, level, xoffset, yoffset, width, height,
                                         format, type, bufSize, pixels);
        }
        ANGLE_CAPTURE_GL(TexSubImage2DRobustANGLE, isCallValid, context, targetPacked, level,
                         xoffset, yoffset, width, height, format, type, bufSize, pixels);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(
            angle::EntryPoint::GLTexSubImage2DRobustANGLE);
    }
    egl::Display::GetCurrentThreadUnlockedTailCall()->run(nullptr);
}

void GL_APIENTRY GL_TexImage3DRobustANGLE(GLenum target,
                                          GLint level,
                                          GLint internalformat,
                                          GLsizei width,
                                          GLsizei height,
                                          GLsizei depth,
                                          GLint border,
                                          GLenum format,
                                          GLenum type,
                                          GLsizei bufSize,
                                          const void *pixels)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLTexImage3DRobustANGLE,
          "context = %d, target = %s, level = %d, internalformat = %d, width = %d, height = %d, "
          "depth = %d, border = %d, format = %s, type = %s, bufSize = %d, pixels = 0x%016" PRIxPTR
          "",
          CID(context), GLenumToString(GLESEnum::AllEnums, target), level, internalformat, width,
          height, depth, border, GLenumToString(GLESEnum::AllEnums, format),
          GLenumToString(GLESEnum::AllEnums, type), bufSize, (uintptr_t)pixels);

    if (ANGLE_LIKELY(context != nullptr))
    {
        TextureTarget targetPacked = PackParam<TextureTarget>(target);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().robustClientMemoryANGLE))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateTexImage3DRobustANGLE(
                    context, angle::EntryPoint::GLTexImage3DRobustANGLE, targetPacked, level,
                    internalformat, width, height, depth, border, format, type, bufSize, pixels);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context, angle::EntryPoint::GLTexImage3DRobustANGLE);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->texImage3DRobust(targetPacked, level, internalformat, width, height, depth,
                                      border, format, type, bufSize, pixels);
        }
        ANGLE_CAPTURE_GL(TexImage3DRobustANGLE, isCallValid, context, targetPacked, level,
                         internalformat, width, height, depth, border, format, type, bufSize,
                         pixels);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLTexImage3DRobustANGLE);
    }
    egl::Display::GetCurrentThreadUnlockedTailCall()->run(nullptr);
}

void GL_APIENTRY GL_TexSubImage3DRobustANGLE(GLenum target,
                                             GLint level,
                                             GLint xoffset,
                                             GLint yoffset,
                                             GLint zoffset,
                                             GLsizei width,
                                             GLsizei height,
                                             GLsizei depth,
                                             GLenum format,
                                             GLenum type,
                                             GLsizei bufSize,
                                             const void *pixels)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(
        context, GLTexSubImage3DRobustANGLE,
        "context = %d, target = %s, level = %d, xoffset = %d, yoffset = %d, zoffset = %d, width = "
        "%d, height = %d, depth = %d, format = %s, type = %s, bufSize = %d, pixels = 0x%016" PRIxPTR
        "",
        CID(context), GLenumToString(GLESEnum::AllEnums, target), level, xoffset, yoffset, zoffset,
        width, height, depth, GLenumToString(GLESEnum::AllEnums, format),
        GLenumToString(GLESEnum::AllEnums, type), bufSize, (uintptr_t)pixels);

    if (ANGLE_LIKELY(context != nullptr))
    {
        TextureTarget targetPacked = PackParam<TextureTarget>(target);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().robustClientMemoryANGLE))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateTexSubImage3DRobustANGLE(
                    context, angle::EntryPoint::GLTexSubImage3DRobustANGLE, targetPacked, level,
                    xoffset, yoffset, zoffset, width, height, depth, format, type, bufSize, pixels);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context, angle::EntryPoint::GLTexSubImage3DRobustANGLE);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->texSubImage3DRobust(targetPacked, level, xoffset, yoffset, zoffset, width,
                                         height, depth, format, type, bufSize, pixels);
        }
        ANGLE_CAPTURE_GL(TexSubImage3DRobustANGLE, isCallValid, context, targetPacked, level,
                         xoffset, yoffset, zoffset, width, height, depth, format, type, bufSize,
                         pixels);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(
            angle::EntryPoint::GLTexSubImage3DRobustANGLE);
    }
    egl::Display::GetCurrentThreadUnlockedTailCall()->run(nullptr);
}

void GL_APIENTRY GL_CompressedTexImage2DRobustANGLE(GLenum target,
                                                    GLint level,
                                                    GLenum internalformat,
                                                    GLsizei width,
                                                    GLsizei height,
                                                    GLint border,
                                                    GLsizei imageSize,
                                                    GLsizei dataSize,
                                                    const void *data)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLCompressedTexImage2DRobustANGLE,
          "context = %d, target = %s, level = %d, internalformat = %s, width = %d, height = %d, "
          "border = %d, imageSize = %d, dataSize = %d, data = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLESEnum::AllEnums, target), level,
          GLenumToString(GLESEnum::AllEnums, internalformat), width, height, border, imageSize,
          dataSize, (uintptr_t)data);

    if (ANGLE_LIKELY(context != nullptr))
    {
        TextureTarget targetPacked = PackParam<TextureTarget>(target);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().robustClientMemoryANGLE))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateCompressedTexImage2DRobustANGLE(
                    context, angle::EntryPoint::GLCompressedTexImage2DRobustANGLE, targetPacked,
                    level, internalformat, width, height, border, imageSize, dataSize, data);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context,
                                        angle::EntryPoint::GLCompressedTexImage2DRobustANGLE);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->compressedTexImage2DRobust(targetPacked, level, internalformat, width, height,
                                                border, imageSize, dataSize, data);
        }
        ANGLE_CAPTURE_GL(CompressedTexImage2DRobustANGLE, isCallValid, context, targetPacked, level,
                         internalformat, width, height, border, imageSize, dataSize, data);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(
            angle::EntryPoint::GLCompressedTexImage2DRobustANGLE);
    }
    egl::Display::GetCurrentThreadUnlockedTailCall()->run(nullptr);
}

void GL_APIENTRY GL_CompressedTexSubImage2DRobustANGLE(GLenum target,
                                                       GLint level,
                                                       GLsizei xoffset,
                                                       GLsizei yoffset,
                                                       GLsizei width,
                                                       GLsizei height,
                                                       GLenum format,
                                                       GLsizei imageSize,
                                                       GLsizei dataSize,
                                                       const void *data)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLCompressedTexSubImage2DRobustANGLE,
          "context = %d, target = %s, level = %d, xoffset = %d, yoffset = %d, width = %d, height = "
          "%d, format = %s, imageSize = %d, dataSize = %d, data = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLESEnum::AllEnums, target), level, xoffset, yoffset, width,
          height, GLenumToString(GLESEnum::AllEnums, format), imageSize, dataSize, (uintptr_t)data);

    if (ANGLE_LIKELY(context != nullptr))
    {
        TextureTarget targetPacked = PackParam<TextureTarget>(target);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().robustClientMemoryANGLE))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateCompressedTexSubImage2DRobustANGLE(
                    context, angle::EntryPoint::GLCompressedTexSubImage2DRobustANGLE, targetPacked,
                    level, xoffset, yoffset, width, height, format, imageSize, dataSize, data);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context,
                                        angle::EntryPoint::GLCompressedTexSubImage2DRobustANGLE);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->compressedTexSubImage2DRobust(targetPacked, level, xoffset, yoffset, width,
                                                   height, format, imageSize, dataSize, data);
        }
        ANGLE_CAPTURE_GL(CompressedTexSubImage2DRobustANGLE, isCallValid, context, targetPacked,
                         level, xoffset, yoffset, width, height, format, imageSize, dataSize, data);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(
            angle::EntryPoint::GLCompressedTexSubImage2DRobustANGLE);
    }
    egl::Display::GetCurrentThreadUnlockedTailCall()->run(nullptr);
}

void GL_APIENTRY GL_CompressedTexImage3DRobustANGLE(GLenum target,
                                                    GLint level,
                                                    GLenum internalformat,
                                                    GLsizei width,
                                                    GLsizei height,
                                                    GLsizei depth,
                                                    GLint border,
                                                    GLsizei imageSize,
                                                    GLsizei dataSize,
                                                    const void *data)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLCompressedTexImage3DRobustANGLE,
          "context = %d, target = %s, level = %d, internalformat = %s, width = %d, height = %d, "
          "depth = %d, border = %d, imageSize = %d, dataSize = %d, data = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLESEnum::AllEnums, target), level,
          GLenumToString(GLESEnum::AllEnums, internalformat), width, height, depth, border,
          imageSize, dataSize, (uintptr_t)data);

    if (ANGLE_LIKELY(context != nullptr))
    {
        TextureTarget targetPacked = PackParam<TextureTarget>(target);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().robustClientMemoryANGLE))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateCompressedTexImage3DRobustANGLE(
                    context, angle::EntryPoint::GLCompressedTexImage3DRobustANGLE, targetPacked,
                    level, internalformat, width, height, depth, border, imageSize, dataSize, data);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context,
                                        angle::EntryPoint::GLCompressedTexImage3DRobustANGLE);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->compressedTexImage3DRobust(targetPacked, level, internalformat, width, height,
                                                depth, border, imageSize, dataSize, data);
        }
        ANGLE_CAPTURE_GL(CompressedTexImage3DRobustANGLE, isCallValid, context, targetPacked, level,
                         internalformat, width, height, depth, border, imageSize, dataSize, data);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(
            angle::EntryPoint::GLCompressedTexImage3DRobustANGLE);
    }
    egl::Display::GetCurrentThreadUnlockedTailCall()->run(nullptr);
}

void GL_APIENTRY GL_CompressedTexSubImage3DRobustANGLE(GLenum target,
                                                       GLint level,
                                                       GLint xoffset,
                                                       GLint yoffset,
                                                       GLint zoffset,
                                                       GLsizei width,
                                                       GLsizei height,
                                                       GLsizei depth,
                                                       GLenum format,
                                                       GLsizei imageSize,
                                                       GLsizei dataSize,
                                                       const void *data)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLCompressedTexSubImage3DRobustANGLE,
          "context = %d, target = %s, level = %d, xoffset = %d, yoffset = %d, zoffset = %d, width "
          "= %d, height = %d, depth = %d, format = %s, imageSize = %d, dataSize = %d, data = "
          "0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLESEnum::AllEnums, target), level, xoffset, yoffset,
          zoffset, width, height, depth, GLenumToString(GLESEnum::AllEnums, format), imageSize,
          dataSize, (uintptr_t)data);

    if (ANGLE_LIKELY(context != nullptr))
    {
        TextureTarget targetPacked = PackParam<TextureTarget>(target);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().robustClientMemoryANGLE))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateCompressedTexSubImage3DRobustANGLE(
                    context, angle::EntryPoint::GLCompressedTexSubImage3DRobustANGLE, targetPacked,
                    level, xoffset, yoffset, zoffset, width, height, depth, format, imageSize,
                    dataSize, data);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context,
                                        angle::EntryPoint::GLCompressedTexSubImage3DRobustANGLE);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->compressedTexSubImage3DRobust(targetPacked, level, xoffset, yoffset, zoffset,
                                                   width, height, depth, format, imageSize,
                                                   dataSize, data);
        }
        ANGLE_CAPTURE_GL(CompressedTexSubImage3DRobustANGLE, isCallValid, context, targetPacked,
                         level, xoffset, yoffset, zoffset, width, height, depth, format, imageSize,
                         dataSize, data);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(
            angle::EntryPoint::GLCompressedTexSubImage3DRobustANGLE);
    }
    egl::Display::GetCurrentThreadUnlockedTailCall()->run(nullptr);
}

void GL_APIENTRY GL_GetQueryivRobustANGLE(GLenum target,
                                          GLenum pname,
                                          GLsizei bufSize,
                                          GLsizei *length,
                                          GLint *params)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLGetQueryivRobustANGLE,
          "context = %d, target = %s, pname = %s, bufSize = %d, length = 0x%016" PRIxPTR
          ", params = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLESEnum::AllEnums, target),
          GLenumToString(GLESEnum::AllEnums, pname), bufSize, (uintptr_t)length, (uintptr_t)params);

    if (ANGLE_LIKELY(context != nullptr))
    {
        QueryType targetPacked = PackParam<QueryType>(target);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().robustClientMemoryANGLE))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateGetQueryivRobustANGLE(
                    context, angle::EntryPoint::GLGetQueryivRobustANGLE, targetPacked, pname,
                    bufSize, length, params);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context, angle::EntryPoint::GLGetQueryivRobustANGLE);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->getQueryivRobust(targetPacked, pname, bufSize, length, params);
        }
        ANGLE_CAPTURE_GL(GetQueryivRobustANGLE, isCallValid, context, targetPacked, pname, bufSize,
                         length, params);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLGetQueryivRobustANGLE);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_GetQueryObjectuivRobustANGLE(GLuint id,
                                                 GLenum pname,
                                                 GLsizei bufSize,
                                                 GLsizei *length,
                                                 GLuint *params)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetGlobalContext();
    EVENT(context, GLGetQueryObjectuivRobustANGLE,
          "context = %d, id = %u, pname = %s, bufSize = %d, length = 0x%016" PRIxPTR
          ", params = 0x%016" PRIxPTR "",
          CID(context), id, GLenumToString(GLESEnum::AllEnums, pname), bufSize, (uintptr_t)length,
          (uintptr_t)params);

    if (ANGLE_LIKELY(context != nullptr))
    {
        QueryID idPacked = PackParam<QueryID>(id);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().robustClientMemoryANGLE))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateGetQueryObjectuivRobustANGLE(
                    context, angle::EntryPoint::GLGetQueryObjectuivRobustANGLE, idPacked, pname,
                    bufSize, length, params);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context, angle::EntryPoint::GLGetQueryObjectuivRobustANGLE);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->getQueryObjectuivRobust(idPacked, pname, bufSize, length, params);
        }
        ANGLE_CAPTURE_GL(GetQueryObjectuivRobustANGLE, isCallValid, context, idPacked, pname,
                         bufSize, length, params);
    }
    else
    {
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_GetBufferPointervRobustANGLE(GLenum target,
                                                 GLenum pname,
                                                 GLsizei bufSize,
                                                 GLsizei *length,
                                                 void **params)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLGetBufferPointervRobustANGLE,
          "context = %d, target = %s, pname = %s, bufSize = %d, length = 0x%016" PRIxPTR
          ", params = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLESEnum::AllEnums, target),
          GLenumToString(GLESEnum::AllEnums, pname), bufSize, (uintptr_t)length, (uintptr_t)params);

    if (ANGLE_LIKELY(context != nullptr))
    {
        BufferBinding targetPacked = PackParam<BufferBinding>(target);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().robustClientMemoryANGLE))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateGetBufferPointervRobustANGLE(
                    context, angle::EntryPoint::GLGetBufferPointervRobustANGLE, targetPacked, pname,
                    bufSize, length, params);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context, angle::EntryPoint::GLGetBufferPointervRobustANGLE);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->getBufferPointervRobust(targetPacked, pname, bufSize, length, params);
        }
        ANGLE_CAPTURE_GL(GetBufferPointervRobustANGLE, isCallValid, context, targetPacked, pname,
                         bufSize, length, params);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(
            angle::EntryPoint::GLGetBufferPointervRobustANGLE);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_GetIntegeri_vRobustANGLE(GLenum target,
                                             GLuint index,
                                             GLsizei bufSize,
                                             GLsizei *length,
                                             GLint *data)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLGetIntegeri_vRobustANGLE,
          "context = %d, target = %s, index = %u, bufSize = %d, length = 0x%016" PRIxPTR
          ", data = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLESEnum::AllEnums, target), index, bufSize,
          (uintptr_t)length, (uintptr_t)data);

    if (ANGLE_LIKELY(context != nullptr))
    {
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().robustClientMemoryANGLE))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateGetIntegeri_vRobustANGLE(
                    context, angle::EntryPoint::GLGetIntegeri_vRobustANGLE, target, index, bufSize,
                    length, data);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context, angle::EntryPoint::GLGetIntegeri_vRobustANGLE);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->getIntegeri_vRobust(target, index, bufSize, length, data);
        }
        ANGLE_CAPTURE_GL(GetIntegeri_vRobustANGLE, isCallValid, context, target, index, bufSize,
                         length, data);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(
            angle::EntryPoint::GLGetIntegeri_vRobustANGLE);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_GetInternalformativRobustANGLE(GLenum target,
                                                   GLenum internalformat,
                                                   GLenum pname,
                                                   GLsizei bufSize,
                                                   GLsizei *length,
                                                   GLint *params)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLGetInternalformativRobustANGLE,
          "context = %d, target = %s, internalformat = %s, pname = %s, bufSize = %d, length = "
          "0x%016" PRIxPTR ", params = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLESEnum::AllEnums, target),
          GLenumToString(GLESEnum::AllEnums, internalformat),
          GLenumToString(GLESEnum::AllEnums, pname), bufSize, (uintptr_t)length, (uintptr_t)params);

    if (ANGLE_LIKELY(context != nullptr))
    {
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().robustClientMemoryANGLE))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateGetInternalformativRobustANGLE(
                    context, angle::EntryPoint::GLGetInternalformativRobustANGLE, target,
                    internalformat, pname, bufSize, length, params);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context,
                                        angle::EntryPoint::GLGetInternalformativRobustANGLE);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->getInternalformativRobust(target, internalformat, pname, bufSize, length,
                                               params);
        }
        ANGLE_CAPTURE_GL(GetInternalformativRobustANGLE, isCallValid, context, target,
                         internalformat, pname, bufSize, length, params);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(
            angle::EntryPoint::GLGetInternalformativRobustANGLE);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_GetVertexAttribIivRobustANGLE(GLuint index,
                                                  GLenum pname,
                                                  GLsizei bufSize,
                                                  GLsizei *length,
                                                  GLint *params)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLGetVertexAttribIivRobustANGLE,
          "context = %d, index = %u, pname = %s, bufSize = %d, length = 0x%016" PRIxPTR
          ", params = 0x%016" PRIxPTR "",
          CID(context), index, GLenumToString(GLESEnum::AllEnums, pname), bufSize,
          (uintptr_t)length, (uintptr_t)params);

    if (ANGLE_LIKELY(context != nullptr))
    {
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().robustClientMemoryANGLE))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateGetVertexAttribIivRobustANGLE(
                    context, angle::EntryPoint::GLGetVertexAttribIivRobustANGLE, index, pname,
                    bufSize, length, params);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context,
                                        angle::EntryPoint::GLGetVertexAttribIivRobustANGLE);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->getVertexAttribIivRobust(index, pname, bufSize, length, params);
        }
        ANGLE_CAPTURE_GL(GetVertexAttribIivRobustANGLE, isCallValid, context, index, pname, bufSize,
                         length, params);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(
            angle::EntryPoint::GLGetVertexAttribIivRobustANGLE);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_GetVertexAttribIuivRobustANGLE(GLuint index,
                                                   GLenum pname,
                                                   GLsizei bufSize,
                                                   GLsizei *length,
                                                   GLuint *params)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLGetVertexAttribIuivRobustANGLE,
          "context = %d, index = %u, pname = %s, bufSize = %d, length = 0x%016" PRIxPTR
          ", params = 0x%016" PRIxPTR "",
          CID(context), index, GLenumToString(GLESEnum::AllEnums, pname), bufSize,
          (uintptr_t)length, (uintptr_t)params);

    if (ANGLE_LIKELY(context != nullptr))
    {
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().robustClientMemoryANGLE))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateGetVertexAttribIuivRobustANGLE(
                    context, angle::EntryPoint::GLGetVertexAttribIuivRobustANGLE, index, pname,
                    bufSize, length, params);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context,
                                        angle::EntryPoint::GLGetVertexAttribIuivRobustANGLE);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->getVertexAttribIuivRobust(index, pname, bufSize, length, params);
        }
        ANGLE_CAPTURE_GL(GetVertexAttribIuivRobustANGLE, isCallValid, context, index, pname,
                         bufSize, length, params);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(
            angle::EntryPoint::GLGetVertexAttribIuivRobustANGLE);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_GetUniformuivRobustANGLE(GLuint program,
                                             GLint location,
                                             GLsizei bufSize,
                                             GLsizei *length,
                                             GLuint *params)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLGetUniformuivRobustANGLE,
          "context = %d, program = %u, location = %d, bufSize = %d, length = 0x%016" PRIxPTR
          ", params = 0x%016" PRIxPTR "",
          CID(context), program, location, bufSize, (uintptr_t)length, (uintptr_t)params);

    if (ANGLE_LIKELY(context != nullptr))
    {
        ShaderProgramID programPacked  = PackParam<ShaderProgramID>(program);
        UniformLocation locationPacked = PackParam<UniformLocation>(location);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().robustClientMemoryANGLE))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateGetUniformuivRobustANGLE(
                    context, angle::EntryPoint::GLGetUniformuivRobustANGLE, programPacked,
                    locationPacked, bufSize, length, params);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context, angle::EntryPoint::GLGetUniformuivRobustANGLE);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->getUniformuivRobust(programPacked, locationPacked, bufSize, length, params);
        }
        ANGLE_CAPTURE_GL(GetUniformuivRobustANGLE, isCallValid, context, programPacked,
                         locationPacked, bufSize, length, params);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(
            angle::EntryPoint::GLGetUniformuivRobustANGLE);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_GetActiveUniformBlockivRobustANGLE(GLuint program,
                                                       GLuint uniformBlockIndex,
                                                       GLenum pname,
                                                       GLsizei bufSize,
                                                       GLsizei *length,
                                                       GLint *params)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLGetActiveUniformBlockivRobustANGLE,
          "context = %d, program = %u, uniformBlockIndex = %u, pname = %s, bufSize = %d, length = "
          "0x%016" PRIxPTR ", params = 0x%016" PRIxPTR "",
          CID(context), program, uniformBlockIndex, GLenumToString(GLESEnum::AllEnums, pname),
          bufSize, (uintptr_t)length, (uintptr_t)params);

    if (ANGLE_LIKELY(context != nullptr))
    {
        ShaderProgramID programPacked             = PackParam<ShaderProgramID>(program);
        UniformBlockIndex uniformBlockIndexPacked = PackParam<UniformBlockIndex>(uniformBlockIndex);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().robustClientMemoryANGLE))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateGetActiveUniformBlockivRobustANGLE(
                    context, angle::EntryPoint::GLGetActiveUniformBlockivRobustANGLE, programPacked,
                    uniformBlockIndexPacked, pname, bufSize, length, params);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context,
                                        angle::EntryPoint::GLGetActiveUniformBlockivRobustANGLE);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->getActiveUniformBlockivRobust(programPacked, uniformBlockIndexPacked, pname,
                                                   bufSize, length, params);
        }
        ANGLE_CAPTURE_GL(GetActiveUniformBlockivRobustANGLE, isCallValid, context, programPacked,
                         uniformBlockIndexPacked, pname, bufSize, length, params);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(
            angle::EntryPoint::GLGetActiveUniformBlockivRobustANGLE);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_GetInteger64vRobustANGLE(GLenum pname,
                                             GLsizei bufSize,
                                             GLsizei *length,
                                             GLint64 *data)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLGetInteger64vRobustANGLE,
          "context = %d, pname = %s, bufSize = %d, length = 0x%016" PRIxPTR
          ", data = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLESEnum::AllEnums, pname), bufSize, (uintptr_t)length,
          (uintptr_t)data);

    if (ANGLE_LIKELY(context != nullptr))
    {
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().robustClientMemoryANGLE))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateGetInteger64vRobustANGLE(
                    context, angle::EntryPoint::GLGetInteger64vRobustANGLE, pname, bufSize, length,
                    data);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context, angle::EntryPoint::GLGetInteger64vRobustANGLE);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->getInteger64vRobust(pname, bufSize, length, data);
        }
        ANGLE_CAPTURE_GL(GetInteger64vRobustANGLE, isCallValid, context, pname, bufSize, length,
                         data);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(
            angle::EntryPoint::GLGetInteger64vRobustANGLE);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_GetInteger64i_vRobustANGLE(GLenum target,
                                               GLuint index,
                                               GLsizei bufSize,
                                               GLsizei *length,
                                               GLint64 *data)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLGetInteger64i_vRobustANGLE,
          "context = %d, target = %s, index = %u, bufSize = %d, length = 0x%016" PRIxPTR
          ", data = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLESEnum::AllEnums, target), index, bufSize,
          (uintptr_t)length, (uintptr_t)data);

    if (ANGLE_LIKELY(context != nullptr))
    {
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().robustClientMemoryANGLE))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateGetInteger64i_vRobustANGLE(
                    context, angle::EntryPoint::GLGetInteger64i_vRobustANGLE, target, index,
                    bufSize, length, data);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context, angle::EntryPoint::GLGetInteger64i_vRobustANGLE);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->getInteger64i_vRobust(target, index, bufSize, length, data);
        }
        ANGLE_CAPTURE_GL(GetInteger64i_vRobustANGLE, isCallValid, context, target, index, bufSize,
                         length, data);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(
            angle::EntryPoint::GLGetInteger64i_vRobustANGLE);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_GetBufferParameteri64vRobustANGLE(GLenum target,
                                                      GLenum pname,
                                                      GLsizei bufSize,
                                                      GLsizei *length,
                                                      GLint64 *params)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLGetBufferParameteri64vRobustANGLE,
          "context = %d, target = %s, pname = %s, bufSize = %d, length = 0x%016" PRIxPTR
          ", params = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLESEnum::AllEnums, target),
          GLenumToString(GLESEnum::AllEnums, pname), bufSize, (uintptr_t)length, (uintptr_t)params);

    if (ANGLE_LIKELY(context != nullptr))
    {
        BufferBinding targetPacked = PackParam<BufferBinding>(target);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().robustClientMemoryANGLE))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateGetBufferParameteri64vRobustANGLE(
                    context, angle::EntryPoint::GLGetBufferParameteri64vRobustANGLE, targetPacked,
                    pname, bufSize, length, params);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context,
                                        angle::EntryPoint::GLGetBufferParameteri64vRobustANGLE);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->getBufferParameteri64vRobust(targetPacked, pname, bufSize, length, params);
        }
        ANGLE_CAPTURE_GL(GetBufferParameteri64vRobustANGLE, isCallValid, context, targetPacked,
                         pname, bufSize, length, params);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(
            angle::EntryPoint::GLGetBufferParameteri64vRobustANGLE);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_SamplerParameterivRobustANGLE(GLuint sampler,
                                                  GLuint pname,
                                                  GLsizei bufSize,
                                                  const GLint *param)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLSamplerParameterivRobustANGLE,
          "context = %d, sampler = %u, pname = %u, bufSize = %d, param = 0x%016" PRIxPTR "",
          CID(context), sampler, pname, bufSize, (uintptr_t)param);

    if (ANGLE_LIKELY(context != nullptr))
    {
        SamplerID samplerPacked = PackParam<SamplerID>(sampler);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().robustClientMemoryANGLE))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateSamplerParameterivRobustANGLE(
                    context, angle::EntryPoint::GLSamplerParameterivRobustANGLE, samplerPacked,
                    pname, bufSize, param);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context,
                                        angle::EntryPoint::GLSamplerParameterivRobustANGLE);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->samplerParameterivRobust(samplerPacked, pname, bufSize, param);
        }
        ANGLE_CAPTURE_GL(SamplerParameterivRobustANGLE, isCallValid, context, samplerPacked, pname,
                         bufSize, param);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(
            angle::EntryPoint::GLSamplerParameterivRobustANGLE);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_SamplerParameterfvRobustANGLE(GLuint sampler,
                                                  GLenum pname,
                                                  GLsizei bufSize,
                                                  const GLfloat *param)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLSamplerParameterfvRobustANGLE,
          "context = %d, sampler = %u, pname = %s, bufSize = %d, param = 0x%016" PRIxPTR "",
          CID(context), sampler, GLenumToString(GLESEnum::AllEnums, pname), bufSize,
          (uintptr_t)param);

    if (ANGLE_LIKELY(context != nullptr))
    {
        SamplerID samplerPacked = PackParam<SamplerID>(sampler);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().robustClientMemoryANGLE))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateSamplerParameterfvRobustANGLE(
                    context, angle::EntryPoint::GLSamplerParameterfvRobustANGLE, samplerPacked,
                    pname, bufSize, param);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context,
                                        angle::EntryPoint::GLSamplerParameterfvRobustANGLE);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->samplerParameterfvRobust(samplerPacked, pname, bufSize, param);
        }
        ANGLE_CAPTURE_GL(SamplerParameterfvRobustANGLE, isCallValid, context, samplerPacked, pname,
                         bufSize, param);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(
            angle::EntryPoint::GLSamplerParameterfvRobustANGLE);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_GetSamplerParameterivRobustANGLE(GLuint sampler,
                                                     GLenum pname,
                                                     GLsizei bufSize,
                                                     GLsizei *length,
                                                     GLint *params)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLGetSamplerParameterivRobustANGLE,
          "context = %d, sampler = %u, pname = %s, bufSize = %d, length = 0x%016" PRIxPTR
          ", params = 0x%016" PRIxPTR "",
          CID(context), sampler, GLenumToString(GLESEnum::AllEnums, pname), bufSize,
          (uintptr_t)length, (uintptr_t)params);

    if (ANGLE_LIKELY(context != nullptr))
    {
        SamplerID samplerPacked = PackParam<SamplerID>(sampler);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().robustClientMemoryANGLE))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateGetSamplerParameterivRobustANGLE(
                    context, angle::EntryPoint::GLGetSamplerParameterivRobustANGLE, samplerPacked,
                    pname, bufSize, length, params);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context,
                                        angle::EntryPoint::GLGetSamplerParameterivRobustANGLE);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->getSamplerParameterivRobust(samplerPacked, pname, bufSize, length, params);
        }
        ANGLE_CAPTURE_GL(GetSamplerParameterivRobustANGLE, isCallValid, context, samplerPacked,
                         pname, bufSize, length, params);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(
            angle::EntryPoint::GLGetSamplerParameterivRobustANGLE);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_GetSamplerParameterfvRobustANGLE(GLuint sampler,
                                                     GLenum pname,
                                                     GLsizei bufSize,
                                                     GLsizei *length,
                                                     GLfloat *params)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLGetSamplerParameterfvRobustANGLE,
          "context = %d, sampler = %u, pname = %s, bufSize = %d, length = 0x%016" PRIxPTR
          ", params = 0x%016" PRIxPTR "",
          CID(context), sampler, GLenumToString(GLESEnum::AllEnums, pname), bufSize,
          (uintptr_t)length, (uintptr_t)params);

    if (ANGLE_LIKELY(context != nullptr))
    {
        SamplerID samplerPacked = PackParam<SamplerID>(sampler);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().robustClientMemoryANGLE))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateGetSamplerParameterfvRobustANGLE(
                    context, angle::EntryPoint::GLGetSamplerParameterfvRobustANGLE, samplerPacked,
                    pname, bufSize, length, params);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context,
                                        angle::EntryPoint::GLGetSamplerParameterfvRobustANGLE);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->getSamplerParameterfvRobust(samplerPacked, pname, bufSize, length, params);
        }
        ANGLE_CAPTURE_GL(GetSamplerParameterfvRobustANGLE, isCallValid, context, samplerPacked,
                         pname, bufSize, length, params);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(
            angle::EntryPoint::GLGetSamplerParameterfvRobustANGLE);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_GetFramebufferParameterivRobustANGLE(GLenum target,
                                                         GLenum pname,
                                                         GLsizei bufSize,
                                                         GLsizei *length,
                                                         GLint *params)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLGetFramebufferParameterivRobustANGLE,
          "context = %d, target = %s, pname = %s, bufSize = %d, length = 0x%016" PRIxPTR
          ", params = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLESEnum::AllEnums, target),
          GLenumToString(GLESEnum::AllEnums, pname), bufSize, (uintptr_t)length, (uintptr_t)params);

    if (ANGLE_LIKELY(context != nullptr))
    {
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().robustClientMemoryANGLE))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateGetFramebufferParameterivRobustANGLE(
                    context, angle::EntryPoint::GLGetFramebufferParameterivRobustANGLE, target,
                    pname, bufSize, length, params);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context,
                                        angle::EntryPoint::GLGetFramebufferParameterivRobustANGLE);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->getFramebufferParameterivRobust(target, pname, bufSize, length, params);
        }
        ANGLE_CAPTURE_GL(GetFramebufferParameterivRobustANGLE, isCallValid, context, target, pname,
                         bufSize, length, params);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(
            angle::EntryPoint::GLGetFramebufferParameterivRobustANGLE);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_GetProgramInterfaceivRobustANGLE(GLuint program,
                                                     GLenum programInterface,
                                                     GLenum pname,
                                                     GLsizei bufSize,
                                                     GLsizei *length,
                                                     GLint *params)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLGetProgramInterfaceivRobustANGLE,
          "context = %d, program = %u, programInterface = %s, pname = %s, bufSize = %d, length = "
          "0x%016" PRIxPTR ", params = 0x%016" PRIxPTR "",
          CID(context), program, GLenumToString(GLESEnum::AllEnums, programInterface),
          GLenumToString(GLESEnum::AllEnums, pname), bufSize, (uintptr_t)length, (uintptr_t)params);

    if (ANGLE_LIKELY(context != nullptr))
    {
        ShaderProgramID programPacked = PackParam<ShaderProgramID>(program);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().robustClientMemoryANGLE))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateGetProgramInterfaceivRobustANGLE(
                    context, angle::EntryPoint::GLGetProgramInterfaceivRobustANGLE, programPacked,
                    programInterface, pname, bufSize, length, params);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context,
                                        angle::EntryPoint::GLGetProgramInterfaceivRobustANGLE);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->getProgramInterfaceivRobust(programPacked, programInterface, pname, bufSize,
                                                 length, params);
        }
        ANGLE_CAPTURE_GL(GetProgramInterfaceivRobustANGLE, isCallValid, context, programPacked,
                         programInterface, pname, bufSize, length, params);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(
            angle::EntryPoint::GLGetProgramInterfaceivRobustANGLE);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_GetBooleani_vRobustANGLE(GLenum target,
                                             GLuint index,
                                             GLsizei bufSize,
                                             GLsizei *length,
                                             GLboolean *data)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLGetBooleani_vRobustANGLE,
          "context = %d, target = %s, index = %u, bufSize = %d, length = 0x%016" PRIxPTR
          ", data = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLESEnum::AllEnums, target), index, bufSize,
          (uintptr_t)length, (uintptr_t)data);

    if (ANGLE_LIKELY(context != nullptr))
    {
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().robustClientMemoryANGLE))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateGetBooleani_vRobustANGLE(
                    context, angle::EntryPoint::GLGetBooleani_vRobustANGLE, target, index, bufSize,
                    length, data);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context, angle::EntryPoint::GLGetBooleani_vRobustANGLE);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->getBooleani_vRobust(target, index, bufSize, length, data);
        }
        ANGLE_CAPTURE_GL(GetBooleani_vRobustANGLE, isCallValid, context, target, index, bufSize,
                         length, data);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(
            angle::EntryPoint::GLGetBooleani_vRobustANGLE);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_GetMultisamplefvRobustANGLE(GLenum pname,
                                                GLuint index,
                                                GLsizei bufSize,
                                                GLsizei *length,
                                                GLfloat *val)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLGetMultisamplefvRobustANGLE,
          "context = %d, pname = %s, index = %u, bufSize = %d, length = 0x%016" PRIxPTR
          ", val = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLESEnum::AllEnums, pname), index, bufSize,
          (uintptr_t)length, (uintptr_t)val);

    if (ANGLE_LIKELY(context != nullptr))
    {
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().robustClientMemoryANGLE))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateGetMultisamplefvRobustANGLE(
                    context, angle::EntryPoint::GLGetMultisamplefvRobustANGLE, pname, index,
                    bufSize, length, val);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context, angle::EntryPoint::GLGetMultisamplefvRobustANGLE);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->getMultisamplefvRobust(pname, index, bufSize, length, val);
        }
        ANGLE_CAPTURE_GL(GetMultisamplefvRobustANGLE, isCallValid, context, pname, index, bufSize,
                         length, val);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(
            angle::EntryPoint::GLGetMultisamplefvRobustANGLE);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_GetTexLevelParameterivRobustANGLE(GLenum target,
                                                      GLint level,
                                                      GLenum pname,
                                                      GLsizei bufSize,
                                                      GLsizei *length,
                                                      GLint *params)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLGetTexLevelParameterivRobustANGLE,
          "context = %d, target = %s, level = %d, pname = %s, bufSize = %d, length = 0x%016" PRIxPTR
          ", params = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLESEnum::AllEnums, target), level,
          GLenumToString(GLESEnum::AllEnums, pname), bufSize, (uintptr_t)length, (uintptr_t)params);

    if (ANGLE_LIKELY(context != nullptr))
    {
        TextureTarget targetPacked = PackParam<TextureTarget>(target);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().robustClientMemoryANGLE))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateGetTexLevelParameterivRobustANGLE(
                    context, angle::EntryPoint::GLGetTexLevelParameterivRobustANGLE, targetPacked,
                    level, pname, bufSize, length, params);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context,
                                        angle::EntryPoint::GLGetTexLevelParameterivRobustANGLE);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->getTexLevelParameterivRobust(targetPacked, level, pname, bufSize, length,
                                                  params);
        }
        ANGLE_CAPTURE_GL(GetTexLevelParameterivRobustANGLE, isCallValid, context, targetPacked,
                         level, pname, bufSize, length, params);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(
            angle::EntryPoint::GLGetTexLevelParameterivRobustANGLE);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_GetTexLevelParameterfvRobustANGLE(GLenum target,
                                                      GLint level,
                                                      GLenum pname,
                                                      GLsizei bufSize,
                                                      GLsizei *length,
                                                      GLfloat *params)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLGetTexLevelParameterfvRobustANGLE,
          "context = %d, target = %s, level = %d, pname = %s, bufSize = %d, length = 0x%016" PRIxPTR
          ", params = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLESEnum::AllEnums, target), level,
          GLenumToString(GLESEnum::AllEnums, pname), bufSize, (uintptr_t)length, (uintptr_t)params);

    if (ANGLE_LIKELY(context != nullptr))
    {
        TextureTarget targetPacked = PackParam<TextureTarget>(target);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().robustClientMemoryANGLE))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateGetTexLevelParameterfvRobustANGLE(
                    context, angle::EntryPoint::GLGetTexLevelParameterfvRobustANGLE, targetPacked,
                    level, pname, bufSize, length, params);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context,
                                        angle::EntryPoint::GLGetTexLevelParameterfvRobustANGLE);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->getTexLevelParameterfvRobust(targetPacked, level, pname, bufSize, length,
                                                  params);
        }
        ANGLE_CAPTURE_GL(GetTexLevelParameterfvRobustANGLE, isCallValid, context, targetPacked,
                         level, pname, bufSize, length, params);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(
            angle::EntryPoint::GLGetTexLevelParameterfvRobustANGLE);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_GetPointervRobustANGLERobustANGLE(GLenum pname,
                                                      GLsizei bufSize,
                                                      GLsizei *length,
                                                      void **params)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLGetPointervRobustANGLERobustANGLE,
          "context = %d, pname = %s, bufSize = %d, length = 0x%016" PRIxPTR
          ", params = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLESEnum::AllEnums, pname), bufSize, (uintptr_t)length,
          (uintptr_t)params);

    if (ANGLE_LIKELY(context != nullptr))
    {
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().robustClientMemoryANGLE))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateGetPointervRobustANGLERobustANGLE(
                    context, angle::EntryPoint::GLGetPointervRobustANGLERobustANGLE, pname, bufSize,
                    length, params);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context,
                                        angle::EntryPoint::GLGetPointervRobustANGLERobustANGLE);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->getPointervRobustANGLERobust(pname, bufSize, length, params);
        }
        ANGLE_CAPTURE_GL(GetPointervRobustANGLERobustANGLE, isCallValid, context, pname, bufSize,
                         length, params);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(
            angle::EntryPoint::GLGetPointervRobustANGLERobustANGLE);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_ReadnPixelsRobustANGLE(GLint x,
                                           GLint y,
                                           GLsizei width,
                                           GLsizei height,
                                           GLenum format,
                                           GLenum type,
                                           GLsizei bufSize,
                                           GLsizei *length,
                                           GLsizei *columns,
                                           GLsizei *rows,
                                           void *data)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLReadnPixelsRobustANGLE,
          "context = %d, x = %d, y = %d, width = %d, height = %d, format = %s, type = %s, bufSize "
          "= %d, length = 0x%016" PRIxPTR ", columns = 0x%016" PRIxPTR ", rows = 0x%016" PRIxPTR
          ", data = 0x%016" PRIxPTR "",
          CID(context), x, y, width, height, GLenumToString(GLESEnum::AllEnums, format),
          GLenumToString(GLESEnum::AllEnums, type), bufSize, (uintptr_t)length, (uintptr_t)columns,
          (uintptr_t)rows, (uintptr_t)data);

    if (ANGLE_LIKELY(context != nullptr))
    {
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().robustClientMemoryANGLE))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateReadnPixelsRobustANGLE(
                    context, angle::EntryPoint::GLReadnPixelsRobustANGLE, x, y, width, height,
                    format, type, bufSize, length, columns, rows, data);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context, angle::EntryPoint::GLReadnPixelsRobustANGLE);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->readnPixelsRobust(x, y, width, height, format, type, bufSize, length, columns,
                                       rows, data);
        }
        ANGLE_CAPTURE_GL(ReadnPixelsRobustANGLE, isCallValid, context, x, y, width, height, format,
                         type, bufSize, length, columns, rows, data);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLReadnPixelsRobustANGLE);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_GetnUniformfvRobustANGLE(GLuint program,
                                             GLint location,
                                             GLsizei bufSize,
                                             GLsizei *length,
                                             GLfloat *params)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLGetnUniformfvRobustANGLE,
          "context = %d, program = %u, location = %d, bufSize = %d, length = 0x%016" PRIxPTR
          ", params = 0x%016" PRIxPTR "",
          CID(context), program, location, bufSize, (uintptr_t)length, (uintptr_t)params);

    if (ANGLE_LIKELY(context != nullptr))
    {
        ShaderProgramID programPacked  = PackParam<ShaderProgramID>(program);
        UniformLocation locationPacked = PackParam<UniformLocation>(location);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().robustClientMemoryANGLE))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateGetnUniformfvRobustANGLE(
                    context, angle::EntryPoint::GLGetnUniformfvRobustANGLE, programPacked,
                    locationPacked, bufSize, length, params);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context, angle::EntryPoint::GLGetnUniformfvRobustANGLE);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->getnUniformfvRobust(programPacked, locationPacked, bufSize, length, params);
        }
        ANGLE_CAPTURE_GL(GetnUniformfvRobustANGLE, isCallValid, context, programPacked,
                         locationPacked, bufSize, length, params);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(
            angle::EntryPoint::GLGetnUniformfvRobustANGLE);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_GetnUniformivRobustANGLE(GLuint program,
                                             GLint location,
                                             GLsizei bufSize,
                                             GLsizei *length,
                                             GLint *params)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLGetnUniformivRobustANGLE,
          "context = %d, program = %u, location = %d, bufSize = %d, length = 0x%016" PRIxPTR
          ", params = 0x%016" PRIxPTR "",
          CID(context), program, location, bufSize, (uintptr_t)length, (uintptr_t)params);

    if (ANGLE_LIKELY(context != nullptr))
    {
        ShaderProgramID programPacked  = PackParam<ShaderProgramID>(program);
        UniformLocation locationPacked = PackParam<UniformLocation>(location);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().robustClientMemoryANGLE))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateGetnUniformivRobustANGLE(
                    context, angle::EntryPoint::GLGetnUniformivRobustANGLE, programPacked,
                    locationPacked, bufSize, length, params);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context, angle::EntryPoint::GLGetnUniformivRobustANGLE);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->getnUniformivRobust(programPacked, locationPacked, bufSize, length, params);
        }
        ANGLE_CAPTURE_GL(GetnUniformivRobustANGLE, isCallValid, context, programPacked,
                         locationPacked, bufSize, length, params);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(
            angle::EntryPoint::GLGetnUniformivRobustANGLE);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_GetnUniformuivRobustANGLE(GLuint program,
                                              GLint location,
                                              GLsizei bufSize,
                                              GLsizei *length,
                                              GLuint *params)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLGetnUniformuivRobustANGLE,
          "context = %d, program = %u, location = %d, bufSize = %d, length = 0x%016" PRIxPTR
          ", params = 0x%016" PRIxPTR "",
          CID(context), program, location, bufSize, (uintptr_t)length, (uintptr_t)params);

    if (ANGLE_LIKELY(context != nullptr))
    {
        ShaderProgramID programPacked  = PackParam<ShaderProgramID>(program);
        UniformLocation locationPacked = PackParam<UniformLocation>(location);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().robustClientMemoryANGLE))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateGetnUniformuivRobustANGLE(
                    context, angle::EntryPoint::GLGetnUniformuivRobustANGLE, programPacked,
                    locationPacked, bufSize, length, params);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context, angle::EntryPoint::GLGetnUniformuivRobustANGLE);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->getnUniformuivRobust(programPacked, locationPacked, bufSize, length, params);
        }
        ANGLE_CAPTURE_GL(GetnUniformuivRobustANGLE, isCallValid, context, programPacked,
                         locationPacked, bufSize, length, params);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(
            angle::EntryPoint::GLGetnUniformuivRobustANGLE);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_TexParameterIivRobustANGLE(GLenum target,
                                               GLenum pname,
                                               GLsizei bufSize,
                                               const GLint *params)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLTexParameterIivRobustANGLE,
          "context = %d, target = %s, pname = %s, bufSize = %d, params = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLESEnum::AllEnums, target),
          GLenumToString(GLESEnum::AllEnums, pname), bufSize, (uintptr_t)params);

    if (ANGLE_LIKELY(context != nullptr))
    {
        TextureType targetPacked = PackParam<TextureType>(target);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().robustClientMemoryANGLE))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateTexParameterIivRobustANGLE(
                    context, angle::EntryPoint::GLTexParameterIivRobustANGLE, targetPacked, pname,
                    bufSize, params);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context, angle::EntryPoint::GLTexParameterIivRobustANGLE);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->texParameterIivRobust(targetPacked, pname, bufSize, params);
        }
        ANGLE_CAPTURE_GL(TexParameterIivRobustANGLE, isCallValid, context, targetPacked, pname,
                         bufSize, params);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(
            angle::EntryPoint::GLTexParameterIivRobustANGLE);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_TexParameterIuivRobustANGLE(GLenum target,
                                                GLenum pname,
                                                GLsizei bufSize,
                                                const GLuint *params)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLTexParameterIuivRobustANGLE,
          "context = %d, target = %s, pname = %s, bufSize = %d, params = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLESEnum::AllEnums, target),
          GLenumToString(GLESEnum::AllEnums, pname), bufSize, (uintptr_t)params);

    if (ANGLE_LIKELY(context != nullptr))
    {
        TextureType targetPacked = PackParam<TextureType>(target);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().robustClientMemoryANGLE))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateTexParameterIuivRobustANGLE(
                    context, angle::EntryPoint::GLTexParameterIuivRobustANGLE, targetPacked, pname,
                    bufSize, params);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context, angle::EntryPoint::GLTexParameterIuivRobustANGLE);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->texParameterIuivRobust(targetPacked, pname, bufSize, params);
        }
        ANGLE_CAPTURE_GL(TexParameterIuivRobustANGLE, isCallValid, context, targetPacked, pname,
                         bufSize, params);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(
            angle::EntryPoint::GLTexParameterIuivRobustANGLE);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_GetTexParameterIivRobustANGLE(GLenum target,
                                                  GLenum pname,
                                                  GLsizei bufSize,
                                                  GLsizei *length,
                                                  GLint *params)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLGetTexParameterIivRobustANGLE,
          "context = %d, target = %s, pname = %s, bufSize = %d, length = 0x%016" PRIxPTR
          ", params = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLESEnum::AllEnums, target),
          GLenumToString(GLESEnum::AllEnums, pname), bufSize, (uintptr_t)length, (uintptr_t)params);

    if (ANGLE_LIKELY(context != nullptr))
    {
        TextureType targetPacked = PackParam<TextureType>(target);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().robustClientMemoryANGLE))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateGetTexParameterIivRobustANGLE(
                    context, angle::EntryPoint::GLGetTexParameterIivRobustANGLE, targetPacked,
                    pname, bufSize, length, params);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context,
                                        angle::EntryPoint::GLGetTexParameterIivRobustANGLE);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->getTexParameterIivRobust(targetPacked, pname, bufSize, length, params);
        }
        ANGLE_CAPTURE_GL(GetTexParameterIivRobustANGLE, isCallValid, context, targetPacked, pname,
                         bufSize, length, params);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(
            angle::EntryPoint::GLGetTexParameterIivRobustANGLE);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_GetTexParameterIuivRobustANGLE(GLenum target,
                                                   GLenum pname,
                                                   GLsizei bufSize,
                                                   GLsizei *length,
                                                   GLuint *params)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLGetTexParameterIuivRobustANGLE,
          "context = %d, target = %s, pname = %s, bufSize = %d, length = 0x%016" PRIxPTR
          ", params = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLESEnum::AllEnums, target),
          GLenumToString(GLESEnum::AllEnums, pname), bufSize, (uintptr_t)length, (uintptr_t)params);

    if (ANGLE_LIKELY(context != nullptr))
    {
        TextureType targetPacked = PackParam<TextureType>(target);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().robustClientMemoryANGLE))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateGetTexParameterIuivRobustANGLE(
                    context, angle::EntryPoint::GLGetTexParameterIuivRobustANGLE, targetPacked,
                    pname, bufSize, length, params);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context,
                                        angle::EntryPoint::GLGetTexParameterIuivRobustANGLE);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->getTexParameterIuivRobust(targetPacked, pname, bufSize, length, params);
        }
        ANGLE_CAPTURE_GL(GetTexParameterIuivRobustANGLE, isCallValid, context, targetPacked, pname,
                         bufSize, length, params);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(
            angle::EntryPoint::GLGetTexParameterIuivRobustANGLE);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_SamplerParameterIivRobustANGLE(GLuint sampler,
                                                   GLenum pname,
                                                   GLsizei bufSize,
                                                   const GLint *param)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLSamplerParameterIivRobustANGLE,
          "context = %d, sampler = %u, pname = %s, bufSize = %d, param = 0x%016" PRIxPTR "",
          CID(context), sampler, GLenumToString(GLESEnum::AllEnums, pname), bufSize,
          (uintptr_t)param);

    if (ANGLE_LIKELY(context != nullptr))
    {
        SamplerID samplerPacked = PackParam<SamplerID>(sampler);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().robustClientMemoryANGLE))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateSamplerParameterIivRobustANGLE(
                    context, angle::EntryPoint::GLSamplerParameterIivRobustANGLE, samplerPacked,
                    pname, bufSize, param);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context,
                                        angle::EntryPoint::GLSamplerParameterIivRobustANGLE);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->samplerParameterIivRobust(samplerPacked, pname, bufSize, param);
        }
        ANGLE_CAPTURE_GL(SamplerParameterIivRobustANGLE, isCallValid, context, samplerPacked, pname,
                         bufSize, param);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(
            angle::EntryPoint::GLSamplerParameterIivRobustANGLE);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_SamplerParameterIuivRobustANGLE(GLuint sampler,
                                                    GLenum pname,
                                                    GLsizei bufSize,
                                                    const GLuint *param)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLSamplerParameterIuivRobustANGLE,
          "context = %d, sampler = %u, pname = %s, bufSize = %d, param = 0x%016" PRIxPTR "",
          CID(context), sampler, GLenumToString(GLESEnum::AllEnums, pname), bufSize,
          (uintptr_t)param);

    if (ANGLE_LIKELY(context != nullptr))
    {
        SamplerID samplerPacked = PackParam<SamplerID>(sampler);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().robustClientMemoryANGLE))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateSamplerParameterIuivRobustANGLE(
                    context, angle::EntryPoint::GLSamplerParameterIuivRobustANGLE, samplerPacked,
                    pname, bufSize, param);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context,
                                        angle::EntryPoint::GLSamplerParameterIuivRobustANGLE);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->samplerParameterIuivRobust(samplerPacked, pname, bufSize, param);
        }
        ANGLE_CAPTURE_GL(SamplerParameterIuivRobustANGLE, isCallValid, context, samplerPacked,
                         pname, bufSize, param);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(
            angle::EntryPoint::GLSamplerParameterIuivRobustANGLE);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_GetSamplerParameterIivRobustANGLE(GLuint sampler,
                                                      GLenum pname,
                                                      GLsizei bufSize,
                                                      GLsizei *length,
                                                      GLint *params)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLGetSamplerParameterIivRobustANGLE,
          "context = %d, sampler = %u, pname = %s, bufSize = %d, length = 0x%016" PRIxPTR
          ", params = 0x%016" PRIxPTR "",
          CID(context), sampler, GLenumToString(GLESEnum::AllEnums, pname), bufSize,
          (uintptr_t)length, (uintptr_t)params);

    if (ANGLE_LIKELY(context != nullptr))
    {
        SamplerID samplerPacked = PackParam<SamplerID>(sampler);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().robustClientMemoryANGLE))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateGetSamplerParameterIivRobustANGLE(
                    context, angle::EntryPoint::GLGetSamplerParameterIivRobustANGLE, samplerPacked,
                    pname, bufSize, length, params);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context,
                                        angle::EntryPoint::GLGetSamplerParameterIivRobustANGLE);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->getSamplerParameterIivRobust(samplerPacked, pname, bufSize, length, params);
        }
        ANGLE_CAPTURE_GL(GetSamplerParameterIivRobustANGLE, isCallValid, context, samplerPacked,
                         pname, bufSize, length, params);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(
            angle::EntryPoint::GLGetSamplerParameterIivRobustANGLE);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_GetSamplerParameterIuivRobustANGLE(GLuint sampler,
                                                       GLenum pname,
                                                       GLsizei bufSize,
                                                       GLsizei *length,
                                                       GLuint *params)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLGetSamplerParameterIuivRobustANGLE,
          "context = %d, sampler = %u, pname = %s, bufSize = %d, length = 0x%016" PRIxPTR
          ", params = 0x%016" PRIxPTR "",
          CID(context), sampler, GLenumToString(GLESEnum::AllEnums, pname), bufSize,
          (uintptr_t)length, (uintptr_t)params);

    if (ANGLE_LIKELY(context != nullptr))
    {
        SamplerID samplerPacked = PackParam<SamplerID>(sampler);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().robustClientMemoryANGLE))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateGetSamplerParameterIuivRobustANGLE(
                    context, angle::EntryPoint::GLGetSamplerParameterIuivRobustANGLE, samplerPacked,
                    pname, bufSize, length, params);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context,
                                        angle::EntryPoint::GLGetSamplerParameterIuivRobustANGLE);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->getSamplerParameterIuivRobust(samplerPacked, pname, bufSize, length, params);
        }
        ANGLE_CAPTURE_GL(GetSamplerParameterIuivRobustANGLE, isCallValid, context, samplerPacked,
                         pname, bufSize, length, params);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(
            angle::EntryPoint::GLGetSamplerParameterIuivRobustANGLE);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_GetQueryObjectivRobustANGLE(GLuint id,
                                                GLenum pname,
                                                GLsizei bufSize,
                                                GLsizei *length,
                                                GLint *params)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetGlobalContext();
    EVENT(context, GLGetQueryObjectivRobustANGLE,
          "context = %d, id = %u, pname = %s, bufSize = %d, length = 0x%016" PRIxPTR
          ", params = 0x%016" PRIxPTR "",
          CID(context), id, GLenumToString(GLESEnum::AllEnums, pname), bufSize, (uintptr_t)length,
          (uintptr_t)params);

    if (ANGLE_LIKELY(context != nullptr))
    {
        QueryID idPacked = PackParam<QueryID>(id);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().robustClientMemoryANGLE))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateGetQueryObjectivRobustANGLE(
                    context, angle::EntryPoint::GLGetQueryObjectivRobustANGLE, idPacked, pname,
                    bufSize, length, params);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context, angle::EntryPoint::GLGetQueryObjectivRobustANGLE);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->getQueryObjectivRobust(idPacked, pname, bufSize, length, params);
        }
        ANGLE_CAPTURE_GL(GetQueryObjectivRobustANGLE, isCallValid, context, idPacked, pname,
                         bufSize, length, params);
    }
    else
    {
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_GetQueryObjecti64vRobustANGLE(GLuint id,
                                                  GLenum pname,
                                                  GLsizei bufSize,
                                                  GLsizei *length,
                                                  GLint64 *params)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetGlobalContext();
    EVENT(context, GLGetQueryObjecti64vRobustANGLE,
          "context = %d, id = %u, pname = %s, bufSize = %d, length = 0x%016" PRIxPTR
          ", params = 0x%016" PRIxPTR "",
          CID(context), id, GLenumToString(GLESEnum::AllEnums, pname), bufSize, (uintptr_t)length,
          (uintptr_t)params);

    if (ANGLE_LIKELY(context != nullptr))
    {
        QueryID idPacked = PackParam<QueryID>(id);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().robustClientMemoryANGLE))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateGetQueryObjecti64vRobustANGLE(
                    context, angle::EntryPoint::GLGetQueryObjecti64vRobustANGLE, idPacked, pname,
                    bufSize, length, params);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context,
                                        angle::EntryPoint::GLGetQueryObjecti64vRobustANGLE);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->getQueryObjecti64vRobust(idPacked, pname, bufSize, length, params);
        }
        ANGLE_CAPTURE_GL(GetQueryObjecti64vRobustANGLE, isCallValid, context, idPacked, pname,
                         bufSize, length, params);
    }
    else
    {
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_GetQueryObjectui64vRobustANGLE(GLuint id,
                                                   GLenum pname,
                                                   GLsizei bufSize,
                                                   GLsizei *length,
                                                   GLuint64 *params)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetGlobalContext();
    EVENT(context, GLGetQueryObjectui64vRobustANGLE,
          "context = %d, id = %u, pname = %s, bufSize = %d, length = 0x%016" PRIxPTR
          ", params = 0x%016" PRIxPTR "",
          CID(context), id, GLenumToString(GLESEnum::AllEnums, pname), bufSize, (uintptr_t)length,
          (uintptr_t)params);

    if (ANGLE_LIKELY(context != nullptr))
    {
        QueryID idPacked = PackParam<QueryID>(id);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().robustClientMemoryANGLE))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateGetQueryObjectui64vRobustANGLE(
                    context, angle::EntryPoint::GLGetQueryObjectui64vRobustANGLE, idPacked, pname,
                    bufSize, length, params);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context,
                                        angle::EntryPoint::GLGetQueryObjectui64vRobustANGLE);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->getQueryObjectui64vRobust(idPacked, pname, bufSize, length, params);
        }
        ANGLE_CAPTURE_GL(GetQueryObjectui64vRobustANGLE, isCallValid, context, idPacked, pname,
                         bufSize, length, params);
    }
    else
    {
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_GetFramebufferPixelLocalStorageParameterfvRobustANGLE(GLint plane,
                                                                          GLenum pname,
                                                                          GLsizei bufSize,
                                                                          GLsizei *length,
                                                                          GLfloat *params)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLGetFramebufferPixelLocalStorageParameterfvRobustANGLE,
          "context = %d, plane = %d, pname = %s, bufSize = %d, length = 0x%016" PRIxPTR
          ", params = 0x%016" PRIxPTR "",
          CID(context), plane, GLenumToString(GLESEnum::PLSQueryFloat, pname), bufSize,
          (uintptr_t)length, (uintptr_t)params);

    if (ANGLE_LIKELY(context != nullptr))
    {
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().robustClientMemoryANGLE))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateGetFramebufferPixelLocalStorageParameterfvRobustANGLE(
                    context,
                    angle::EntryPoint::GLGetFramebufferPixelLocalStorageParameterfvRobustANGLE,
                    plane, pname, bufSize, length, params);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(
                    context,
                    angle::EntryPoint::GLGetFramebufferPixelLocalStorageParameterfvRobustANGLE);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->getFramebufferPixelLocalStorageParameterfvRobust(plane, pname, bufSize, length,
                                                                      params);
        }
        ANGLE_CAPTURE_GL(GetFramebufferPixelLocalStorageParameterfvRobustANGLE, isCallValid,
                         context, plane, pname, bufSize, length, params);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(
            angle::EntryPoint::GLGetFramebufferPixelLocalStorageParameterfvRobustANGLE);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_GetFramebufferPixelLocalStorageParameterivRobustANGLE(GLint plane,
                                                                          GLenum pname,
                                                                          GLsizei bufSize,
                                                                          GLsizei *length,
                                                                          GLint *params)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLGetFramebufferPixelLocalStorageParameterivRobustANGLE,
          "context = %d, plane = %d, pname = %s, bufSize = %d, length = 0x%016" PRIxPTR
          ", params = 0x%016" PRIxPTR "",
          CID(context), plane, GLenumToString(GLESEnum::PLSQueryInt, pname), bufSize,
          (uintptr_t)length, (uintptr_t)params);

    if (ANGLE_LIKELY(context != nullptr))
    {
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().robustClientMemoryANGLE))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateGetFramebufferPixelLocalStorageParameterivRobustANGLE(
                    context,
                    angle::EntryPoint::GLGetFramebufferPixelLocalStorageParameterivRobustANGLE,
                    plane, pname, bufSize, length, params);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(
                    context,
                    angle::EntryPoint::GLGetFramebufferPixelLocalStorageParameterivRobustANGLE);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->getFramebufferPixelLocalStorageParameterivRobust(plane, pname, bufSize, length,
                                                                      params);
        }
        ANGLE_CAPTURE_GL(GetFramebufferPixelLocalStorageParameterivRobustANGLE, isCallValid,
                         context, plane, pname, bufSize, length, params);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(
            angle::EntryPoint::GLGetFramebufferPixelLocalStorageParameterivRobustANGLE);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

// GL_ANGLE_robust_fragment_shader_output

// GL_ANGLE_robust_resource_initialization

// GL_ANGLE_semaphore_fuchsia
void GL_APIENTRY GL_ImportSemaphoreZirconHandleANGLE(GLuint semaphore,
                                                     GLenum handleType,
                                                     GLuint handle)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLImportSemaphoreZirconHandleANGLE,
          "context = %d, semaphore = %u, handleType = %s, handle = %u", CID(context), semaphore,
          GLenumToString(GLESEnum::ExternalHandleType, handleType), handle);

    if (ANGLE_LIKELY(context != nullptr))
    {
        SemaphoreID semaphorePacked = PackParam<SemaphoreID>(semaphore);
        HandleType handleTypePacked = PackParam<HandleType>(handleType);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().semaphoreFuchsiaANGLE))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateImportSemaphoreZirconHandleANGLE(
                    context, angle::EntryPoint::GLImportSemaphoreZirconHandleANGLE, semaphorePacked,
                    handleTypePacked, handle);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context,
                                        angle::EntryPoint::GLImportSemaphoreZirconHandleANGLE);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->importSemaphoreZirconHandle(semaphorePacked, handleTypePacked, handle);
        }
        ANGLE_CAPTURE_GL(ImportSemaphoreZirconHandleANGLE, isCallValid, context, semaphorePacked,
                         handleTypePacked, handle);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(
            angle::EntryPoint::GLImportSemaphoreZirconHandleANGLE);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

// GL_ANGLE_shader_binary

// GL_ANGLE_shader_pixel_local_storage
void GL_APIENTRY GL_FramebufferMemorylessPixelLocalStorageANGLE(GLint plane, GLenum internalformat)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLFramebufferMemorylessPixelLocalStorageANGLE,
          "context = %d, plane = %d, internalformat = %s", CID(context), plane,
          GLenumToString(GLESEnum::AllEnums, internalformat));

    if (ANGLE_LIKELY(context != nullptr))
    {
        SCOPED_SHARE_CONTEXT_LOCK(context);
        if (context->getState().getPixelLocalStorageActivePlanes() != 0)
        {
            context->endPixelLocalStorageImplicit();
        }
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().shaderPixelLocalStorageANGLE))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateFramebufferMemorylessPixelLocalStorageANGLE(
                    context, angle::EntryPoint::GLFramebufferMemorylessPixelLocalStorageANGLE,
                    plane, internalformat);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(
                    context, angle::EntryPoint::GLFramebufferMemorylessPixelLocalStorageANGLE);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->framebufferMemorylessPixelLocalStorage(plane, internalformat);
        }
        ANGLE_CAPTURE_GL(FramebufferMemorylessPixelLocalStorageANGLE, isCallValid, context, plane,
                         internalformat);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(
            angle::EntryPoint::GLFramebufferMemorylessPixelLocalStorageANGLE);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_FramebufferTexturePixelLocalStorageANGLE(GLint plane,
                                                             GLuint backingtexture,
                                                             GLint level,
                                                             GLint layer)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLFramebufferTexturePixelLocalStorageANGLE,
          "context = %d, plane = %d, backingtexture = %u, level = %d, layer = %d", CID(context),
          plane, backingtexture, level, layer);

    if (ANGLE_LIKELY(context != nullptr))
    {
        TextureID backingtexturePacked = PackParam<TextureID>(backingtexture);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        if (context->getState().getPixelLocalStorageActivePlanes() != 0)
        {
            context->endPixelLocalStorageImplicit();
        }
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().shaderPixelLocalStorageANGLE))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateFramebufferTexturePixelLocalStorageANGLE(
                    context, angle::EntryPoint::GLFramebufferTexturePixelLocalStorageANGLE, plane,
                    backingtexturePacked, level, layer);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(
                    context, angle::EntryPoint::GLFramebufferTexturePixelLocalStorageANGLE);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->framebufferTexturePixelLocalStorage(plane, backingtexturePacked, level, layer);
        }
        ANGLE_CAPTURE_GL(FramebufferTexturePixelLocalStorageANGLE, isCallValid, context, plane,
                         backingtexturePacked, level, layer);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(
            angle::EntryPoint::GLFramebufferTexturePixelLocalStorageANGLE);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_FramebufferPixelLocalClearValuefvANGLE(GLint plane, const GLfloat *value)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLFramebufferPixelLocalClearValuefvANGLE,
          "context = %d, plane = %d, value = 0x%016" PRIxPTR "", CID(context), plane,
          (uintptr_t)value);

    if (ANGLE_LIKELY(context != nullptr))
    {
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().shaderPixelLocalStorageANGLE))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateFramebufferPixelLocalClearValuefvANGLE(
                    context, angle::EntryPoint::GLFramebufferPixelLocalClearValuefvANGLE, plane,
                    value);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(
                    context, angle::EntryPoint::GLFramebufferPixelLocalClearValuefvANGLE);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->framebufferPixelLocalClearValuefv(plane, value);
        }
        ANGLE_CAPTURE_GL(FramebufferPixelLocalClearValuefvANGLE, isCallValid, context, plane,
                         value);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(
            angle::EntryPoint::GLFramebufferPixelLocalClearValuefvANGLE);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_FramebufferPixelLocalClearValueivANGLE(GLint plane, const GLint *value)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLFramebufferPixelLocalClearValueivANGLE,
          "context = %d, plane = %d, value = 0x%016" PRIxPTR "", CID(context), plane,
          (uintptr_t)value);

    if (ANGLE_LIKELY(context != nullptr))
    {
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().shaderPixelLocalStorageANGLE))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateFramebufferPixelLocalClearValueivANGLE(
                    context, angle::EntryPoint::GLFramebufferPixelLocalClearValueivANGLE, plane,
                    value);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(
                    context, angle::EntryPoint::GLFramebufferPixelLocalClearValueivANGLE);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->framebufferPixelLocalClearValueiv(plane, value);
        }
        ANGLE_CAPTURE_GL(FramebufferPixelLocalClearValueivANGLE, isCallValid, context, plane,
                         value);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(
            angle::EntryPoint::GLFramebufferPixelLocalClearValueivANGLE);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_FramebufferPixelLocalClearValueuivANGLE(GLint plane, const GLuint *value)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLFramebufferPixelLocalClearValueuivANGLE,
          "context = %d, plane = %d, value = 0x%016" PRIxPTR "", CID(context), plane,
          (uintptr_t)value);

    if (ANGLE_LIKELY(context != nullptr))
    {
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().shaderPixelLocalStorageANGLE))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateFramebufferPixelLocalClearValueuivANGLE(
                    context, angle::EntryPoint::GLFramebufferPixelLocalClearValueuivANGLE, plane,
                    value);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(
                    context, angle::EntryPoint::GLFramebufferPixelLocalClearValueuivANGLE);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->framebufferPixelLocalClearValueuiv(plane, value);
        }
        ANGLE_CAPTURE_GL(FramebufferPixelLocalClearValueuivANGLE, isCallValid, context, plane,
                         value);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(
            angle::EntryPoint::GLFramebufferPixelLocalClearValueuivANGLE);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_BeginPixelLocalStorageANGLE(GLsizei n, const GLenum *loadops)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLBeginPixelLocalStorageANGLE,
          "context = %d, n = %d, loadops = 0x%016" PRIxPTR "", CID(context), n, (uintptr_t)loadops);

    if (ANGLE_LIKELY(context != nullptr))
    {
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().shaderPixelLocalStorageANGLE))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateBeginPixelLocalStorageANGLE(
                    context, angle::EntryPoint::GLBeginPixelLocalStorageANGLE, n, loadops);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context, angle::EntryPoint::GLBeginPixelLocalStorageANGLE);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->beginPixelLocalStorage(n, loadops);
        }
        ANGLE_CAPTURE_GL(BeginPixelLocalStorageANGLE, isCallValid, context, n, loadops);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(
            angle::EntryPoint::GLBeginPixelLocalStorageANGLE);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_EndPixelLocalStorageANGLE(GLsizei n, const GLenum *storeops)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLEndPixelLocalStorageANGLE,
          "context = %d, n = %d, storeops = 0x%016" PRIxPTR "", CID(context), n,
          (uintptr_t)storeops);

    if (ANGLE_LIKELY(context != nullptr))
    {
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().shaderPixelLocalStorageANGLE))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateEndPixelLocalStorageANGLE(
                    context, angle::EntryPoint::GLEndPixelLocalStorageANGLE, n, storeops);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context, angle::EntryPoint::GLEndPixelLocalStorageANGLE);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->endPixelLocalStorage(n, storeops);
        }
        ANGLE_CAPTURE_GL(EndPixelLocalStorageANGLE, isCallValid, context, n, storeops);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(
            angle::EntryPoint::GLEndPixelLocalStorageANGLE);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_PixelLocalStorageBarrierANGLE()
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLPixelLocalStorageBarrierANGLE, "context = %d", CID(context));

    if (ANGLE_LIKELY(context != nullptr))
    {
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().shaderPixelLocalStorageANGLE))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidatePixelLocalStorageBarrierANGLE(
                    context, angle::EntryPoint::GLPixelLocalStorageBarrierANGLE);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context,
                                        angle::EntryPoint::GLPixelLocalStorageBarrierANGLE);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->pixelLocalStorageBarrier();
        }
        ANGLE_CAPTURE_GL(PixelLocalStorageBarrierANGLE, isCallValid, context);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(
            angle::EntryPoint::GLPixelLocalStorageBarrierANGLE);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_FramebufferPixelLocalStorageInterruptANGLE()
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLFramebufferPixelLocalStorageInterruptANGLE, "context = %d", CID(context));

    if (ANGLE_LIKELY(context != nullptr))
    {
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().shaderPixelLocalStorageANGLE))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateFramebufferPixelLocalStorageInterruptANGLE(
                    context, angle::EntryPoint::GLFramebufferPixelLocalStorageInterruptANGLE);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(
                    context, angle::EntryPoint::GLFramebufferPixelLocalStorageInterruptANGLE);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->framebufferPixelLocalStorageInterrupt();
        }
        ANGLE_CAPTURE_GL(FramebufferPixelLocalStorageInterruptANGLE, isCallValid, context);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(
            angle::EntryPoint::GLFramebufferPixelLocalStorageInterruptANGLE);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_FramebufferPixelLocalStorageRestoreANGLE()
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLFramebufferPixelLocalStorageRestoreANGLE, "context = %d", CID(context));

    if (ANGLE_LIKELY(context != nullptr))
    {
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().shaderPixelLocalStorageANGLE))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateFramebufferPixelLocalStorageRestoreANGLE(
                    context, angle::EntryPoint::GLFramebufferPixelLocalStorageRestoreANGLE);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(
                    context, angle::EntryPoint::GLFramebufferPixelLocalStorageRestoreANGLE);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->framebufferPixelLocalStorageRestore();
        }
        ANGLE_CAPTURE_GL(FramebufferPixelLocalStorageRestoreANGLE, isCallValid, context);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(
            angle::EntryPoint::GLFramebufferPixelLocalStorageRestoreANGLE);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_GetFramebufferPixelLocalStorageParameterfvANGLE(GLint plane,
                                                                    GLenum pname,
                                                                    GLfloat *params)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLGetFramebufferPixelLocalStorageParameterfvANGLE,
          "context = %d, plane = %d, pname = %s, params = 0x%016" PRIxPTR "", CID(context), plane,
          GLenumToString(GLESEnum::PLSQueryFloat, pname), (uintptr_t)params);

    if (ANGLE_LIKELY(context != nullptr))
    {
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().shaderPixelLocalStorageANGLE))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateGetFramebufferPixelLocalStorageParameterfvANGLE(
                    context, angle::EntryPoint::GLGetFramebufferPixelLocalStorageParameterfvANGLE,
                    plane, pname, params);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(
                    context, angle::EntryPoint::GLGetFramebufferPixelLocalStorageParameterfvANGLE);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->getFramebufferPixelLocalStorageParameterfv(plane, pname, params);
        }
        ANGLE_CAPTURE_GL(GetFramebufferPixelLocalStorageParameterfvANGLE, isCallValid, context,
                         plane, pname, params);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(
            angle::EntryPoint::GLGetFramebufferPixelLocalStorageParameterfvANGLE);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_GetFramebufferPixelLocalStorageParameterivANGLE(GLint plane,
                                                                    GLenum pname,
                                                                    GLint *params)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLGetFramebufferPixelLocalStorageParameterivANGLE,
          "context = %d, plane = %d, pname = %s, params = 0x%016" PRIxPTR "", CID(context), plane,
          GLenumToString(GLESEnum::PLSQueryInt, pname), (uintptr_t)params);

    if (ANGLE_LIKELY(context != nullptr))
    {
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().shaderPixelLocalStorageANGLE))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateGetFramebufferPixelLocalStorageParameterivANGLE(
                    context, angle::EntryPoint::GLGetFramebufferPixelLocalStorageParameterivANGLE,
                    plane, pname, params);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(
                    context, angle::EntryPoint::GLGetFramebufferPixelLocalStorageParameterivANGLE);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->getFramebufferPixelLocalStorageParameteriv(plane, pname, params);
        }
        ANGLE_CAPTURE_GL(GetFramebufferPixelLocalStorageParameterivANGLE, isCallValid, context,
                         plane, pname, params);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(
            angle::EntryPoint::GLGetFramebufferPixelLocalStorageParameterivANGLE);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}


// GL_ANGLE_stencil_texturing

// GL_ANGLE_texture_compression_dxt3

// GL_ANGLE_texture_compression_dxt5

// GL_ANGLE_texture_external_update
void GL_APIENTRY GL_TexImage2DExternalANGLE(GLenum target,
                                            GLint level,
                                            GLint internalformat,
                                            GLsizei width,
                                            GLsizei height,
                                            GLint border,
                                            GLenum format,
                                            GLenum type)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLTexImage2DExternalANGLE,
          "context = %d, target = %s, level = %d, internalformat = %d, width = %d, height = %d, "
          "border = %d, format = %s, type = %s",
          CID(context), GLenumToString(GLESEnum::TextureTarget, target), level, internalformat,
          width, height, border, GLenumToString(GLESEnum::PixelFormat, format),
          GLenumToString(GLESEnum::PixelType, type));

    if (ANGLE_LIKELY(context != nullptr))
    {
        TextureTarget targetPacked = PackParam<TextureTarget>(target);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().textureExternalUpdateANGLE))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateTexImage2DExternalANGLE(
                    context, angle::EntryPoint::GLTexImage2DExternalANGLE, targetPacked, level,
                    internalformat, width, height, border, format, type);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context, angle::EntryPoint::GLTexImage2DExternalANGLE);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->texImage2DExternal(targetPacked, level, internalformat, width, height, border,
                                        format, type);
        }
        ANGLE_CAPTURE_GL(TexImage2DExternalANGLE, isCallValid, context, targetPacked, level,
                         internalformat, width, height, border, format, type);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(
            angle::EntryPoint::GLTexImage2DExternalANGLE);
    }
    egl::Display::GetCurrentThreadUnlockedTailCall()->run(nullptr);
}

void GL_APIENTRY GL_InvalidateTextureANGLE(GLenum target)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLInvalidateTextureANGLE, "context = %d, target = %s", CID(context),
          GLenumToString(GLESEnum::TextureTarget, target));

    if (ANGLE_LIKELY(context != nullptr))
    {
        TextureType targetPacked = PackParam<TextureType>(target);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().textureExternalUpdateANGLE))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateInvalidateTextureANGLE(
                    context, angle::EntryPoint::GLInvalidateTextureANGLE, targetPacked);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context, angle::EntryPoint::GLInvalidateTextureANGLE);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->invalidateTexture(targetPacked);
        }
        ANGLE_CAPTURE_GL(InvalidateTextureANGLE, isCallValid, context, targetPacked);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLInvalidateTextureANGLE);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

// GL_ANGLE_texture_multisample
void GL_APIENTRY GL_TexStorage2DMultisampleANGLE(GLenum target,
                                                 GLsizei samples,
                                                 GLenum internalformat,
                                                 GLsizei width,
                                                 GLsizei height,
                                                 GLboolean fixedsamplelocations)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLTexStorage2DMultisampleANGLE,
          "context = %d, target = %s, samples = %d, internalformat = %s, width = %d, height = %d, "
          "fixedsamplelocations = %s",
          CID(context), GLenumToString(GLESEnum::AllEnums, target), samples,
          GLenumToString(GLESEnum::AllEnums, internalformat), width, height,
          GLbooleanToString(fixedsamplelocations));

    if (ANGLE_LIKELY(context != nullptr))
    {
        TextureType targetPacked = PackParam<TextureType>(target);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().textureMultisampleANGLE))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateTexStorage2DMultisampleANGLE(
                    context, angle::EntryPoint::GLTexStorage2DMultisampleANGLE, targetPacked,
                    samples, internalformat, width, height, fixedsamplelocations);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context, angle::EntryPoint::GLTexStorage2DMultisampleANGLE);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->texStorage2DMultisample(targetPacked, samples, internalformat, width, height,
                                             fixedsamplelocations);
        }
        ANGLE_CAPTURE_GL(TexStorage2DMultisampleANGLE, isCallValid, context, targetPacked, samples,
                         internalformat, width, height, fixedsamplelocations);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(
            angle::EntryPoint::GLTexStorage2DMultisampleANGLE);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_GetMultisamplefvANGLE(GLenum pname, GLuint index, GLfloat *val)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLGetMultisamplefvANGLE,
          "context = %d, pname = %s, index = %u, val = 0x%016" PRIxPTR "", CID(context),
          GLenumToString(GLESEnum::AllEnums, pname), index, (uintptr_t)val);

    if (ANGLE_LIKELY(context != nullptr))
    {
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().textureMultisampleANGLE))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateGetMultisamplefvANGLE(
                    context, angle::EntryPoint::GLGetMultisamplefvANGLE, pname, index, val);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context, angle::EntryPoint::GLGetMultisamplefvANGLE);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->getMultisamplefv(pname, index, val);
        }
        ANGLE_CAPTURE_GL(GetMultisamplefvANGLE, isCallValid, context, pname, index, val);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLGetMultisamplefvANGLE);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_SampleMaskiANGLE(GLuint maskNumber, GLbitfield mask)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLSampleMaskiANGLE, "context = %d, maskNumber = %u, mask = %s", CID(context),
          maskNumber, GLbitfieldToString(GLESEnum::AllEnums, mask).c_str());

    if (ANGLE_LIKELY(context != nullptr))
    {
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().textureMultisampleANGLE))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateSampleMaskiANGLE(
                    context->getPrivateState(), context->getMutableErrorSetForValidation(),
                    angle::EntryPoint::GLSampleMaskiANGLE, maskNumber, mask);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(isCallValid || context->getPushedErrorCount() != errorCount);
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context, angle::EntryPoint::GLSampleMaskiANGLE);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            ContextPrivateSampleMaski(context->getMutablePrivateState(),
                                      context->getMutablePrivateStateCache(), maskNumber, mask);
        }
        ANGLE_CAPTURE_GL(SampleMaskiANGLE, isCallValid, context, maskNumber, mask);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLSampleMaskiANGLE);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}


// GL_ANGLE_texture_usage

// GL_ANGLE_translated_shader_source
void GL_APIENTRY GL_GetTranslatedShaderSourceANGLE(GLuint shader,
                                                   GLsizei bufSize,
                                                   GLsizei *length,
                                                   GLchar *source)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLGetTranslatedShaderSourceANGLE,
          "context = %d, shader = %u, bufSize = %d, length = 0x%016" PRIxPTR
          ", source = 0x%016" PRIxPTR "",
          CID(context), shader, bufSize, (uintptr_t)length, (uintptr_t)source);

    if (ANGLE_LIKELY(context != nullptr))
    {
        ShaderProgramID shaderPacked = PackParam<ShaderProgramID>(shader);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().translatedShaderSourceANGLE))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateGetTranslatedShaderSourceANGLE(
                    context, angle::EntryPoint::GLGetTranslatedShaderSourceANGLE, shaderPacked,
                    bufSize, length, source);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context,
                                        angle::EntryPoint::GLGetTranslatedShaderSourceANGLE);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->getTranslatedShaderSource(shaderPacked, bufSize, length, source);
        }
        ANGLE_CAPTURE_GL(GetTranslatedShaderSourceANGLE, isCallValid, context, shaderPacked,
                         bufSize, length, source);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(
            angle::EntryPoint::GLGetTranslatedShaderSourceANGLE);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

// GL_ANGLE_vulkan_image
void GL_APIENTRY GL_AcquireTexturesANGLE(GLuint numTextures,
                                         const GLuint *textures,
                                         const GLenum *layouts)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLAcquireTexturesANGLE,
          "context = %d, numTextures = %u, textures = 0x%016" PRIxPTR ", layouts = 0x%016" PRIxPTR
          "",
          CID(context), numTextures, (uintptr_t)textures, (uintptr_t)layouts);

    if (ANGLE_LIKELY(context != nullptr))
    {
        const TextureID *texturesPacked = PackParam<const TextureID *>(textures);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().vulkanImageANGLE))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid =
                    ValidateAcquireTexturesANGLE(context, angle::EntryPoint::GLAcquireTexturesANGLE,
                                                 numTextures, texturesPacked, layouts);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context, angle::EntryPoint::GLAcquireTexturesANGLE);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->acquireTextures(numTextures, texturesPacked, layouts);
        }
        ANGLE_CAPTURE_GL(AcquireTexturesANGLE, isCallValid, context, numTextures, texturesPacked,
                         layouts);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLAcquireTexturesANGLE);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_ReleaseTexturesANGLE(GLuint numTextures,
                                         const GLuint *textures,
                                         GLenum *layouts)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLReleaseTexturesANGLE,
          "context = %d, numTextures = %u, textures = 0x%016" PRIxPTR ", layouts = 0x%016" PRIxPTR
          "",
          CID(context), numTextures, (uintptr_t)textures, (uintptr_t)layouts);

    if (ANGLE_LIKELY(context != nullptr))
    {
        const TextureID *texturesPacked = PackParam<const TextureID *>(textures);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().vulkanImageANGLE))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid =
                    ValidateReleaseTexturesANGLE(context, angle::EntryPoint::GLReleaseTexturesANGLE,
                                                 numTextures, texturesPacked, layouts);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context, angle::EntryPoint::GLReleaseTexturesANGLE);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->releaseTextures(numTextures, texturesPacked, layouts);
        }
        ANGLE_CAPTURE_GL(ReleaseTexturesANGLE, isCallValid, context, numTextures, texturesPacked,
                         layouts);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLReleaseTexturesANGLE);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

// GL_ANGLE_yuv_internal_format

// GL_APPLE_clip_distance

// GL_ARM_rgba8

// GL_ARM_shader_framebuffer_fetch

// GL_ARM_shader_framebuffer_fetch_depth_stencil

// GL_ARM_texture_unnormalized_coordinates

// GL_CHROMIUM_bind_uniform_location
void GL_APIENTRY GL_BindUniformLocationCHROMIUM(GLuint program, GLint location, const GLchar *name)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLBindUniformLocationCHROMIUM,
          "context = %d, program = %u, location = %d, name = 0x%016" PRIxPTR "", CID(context),
          program, location, (uintptr_t)name);

    if (ANGLE_LIKELY(context != nullptr))
    {
        ShaderProgramID programPacked  = PackParam<ShaderProgramID>(program);
        UniformLocation locationPacked = PackParam<UniformLocation>(location);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().bindUniformLocationCHROMIUM))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateBindUniformLocationCHROMIUM(
                    context, angle::EntryPoint::GLBindUniformLocationCHROMIUM, programPacked,
                    locationPacked, name);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context, angle::EntryPoint::GLBindUniformLocationCHROMIUM);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->bindUniformLocation(programPacked, locationPacked, name);
        }
        ANGLE_CAPTURE_GL(BindUniformLocationCHROMIUM, isCallValid, context, programPacked,
                         locationPacked, name);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(
            angle::EntryPoint::GLBindUniformLocationCHROMIUM);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

// GL_CHROMIUM_copy_compressed_texture
void GL_APIENTRY GL_CompressedCopyTextureCHROMIUM(GLuint sourceId, GLuint destId)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLCompressedCopyTextureCHROMIUM, "context = %d, sourceId = %u, destId = %u",
          CID(context), sourceId, destId);

    if (ANGLE_LIKELY(context != nullptr))
    {
        TextureID sourceIdPacked = PackParam<TextureID>(sourceId);
        TextureID destIdPacked   = PackParam<TextureID>(destId);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().copyCompressedTextureCHROMIUM))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateCompressedCopyTextureCHROMIUM(
                    context, angle::EntryPoint::GLCompressedCopyTextureCHROMIUM, sourceIdPacked,
                    destIdPacked);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context,
                                        angle::EntryPoint::GLCompressedCopyTextureCHROMIUM);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->compressedCopyTexture(sourceIdPacked, destIdPacked);
        }
        ANGLE_CAPTURE_GL(CompressedCopyTextureCHROMIUM, isCallValid, context, sourceIdPacked,
                         destIdPacked);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(
            angle::EntryPoint::GLCompressedCopyTextureCHROMIUM);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

// GL_CHROMIUM_copy_texture
void GL_APIENTRY GL_CopyTextureCHROMIUM(GLuint sourceId,
                                        GLint sourceLevel,
                                        GLenum destTarget,
                                        GLuint destId,
                                        GLint destLevel,
                                        GLint internalFormat,
                                        GLenum destType,
                                        GLboolean unpackFlipY,
                                        GLboolean unpackPremultiplyAlpha,
                                        GLboolean unpackUnmultiplyAlpha)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLCopyTextureCHROMIUM,
          "context = %d, sourceId = %u, sourceLevel = %d, destTarget = %s, destId = %u, destLevel "
          "= %d, internalFormat = %d, destType = %s, unpackFlipY = %s, unpackPremultiplyAlpha = "
          "%s, unpackUnmultiplyAlpha = %s",
          CID(context), sourceId, sourceLevel, GLenumToString(GLESEnum::AllEnums, destTarget),
          destId, destLevel, internalFormat, GLenumToString(GLESEnum::AllEnums, destType),
          GLbooleanToString(unpackFlipY), GLbooleanToString(unpackPremultiplyAlpha),
          GLbooleanToString(unpackUnmultiplyAlpha));

    if (ANGLE_LIKELY(context != nullptr))
    {
        TextureID sourceIdPacked       = PackParam<TextureID>(sourceId);
        TextureTarget destTargetPacked = PackParam<TextureTarget>(destTarget);
        TextureID destIdPacked         = PackParam<TextureID>(destId);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().copyTextureCHROMIUM))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateCopyTextureCHROMIUM(
                    context, angle::EntryPoint::GLCopyTextureCHROMIUM, sourceIdPacked, sourceLevel,
                    destTargetPacked, destIdPacked, destLevel, internalFormat, destType,
                    unpackFlipY, unpackPremultiplyAlpha, unpackUnmultiplyAlpha);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context, angle::EntryPoint::GLCopyTextureCHROMIUM);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->copyTexture(sourceIdPacked, sourceLevel, destTargetPacked, destIdPacked,
                                 destLevel, internalFormat, destType, unpackFlipY,
                                 unpackPremultiplyAlpha, unpackUnmultiplyAlpha);
        }
        ANGLE_CAPTURE_GL(CopyTextureCHROMIUM, isCallValid, context, sourceIdPacked, sourceLevel,
                         destTargetPacked, destIdPacked, destLevel, internalFormat, destType,
                         unpackFlipY, unpackPremultiplyAlpha, unpackUnmultiplyAlpha);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLCopyTextureCHROMIUM);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_CopySubTextureCHROMIUM(GLuint sourceId,
                                           GLint sourceLevel,
                                           GLenum destTarget,
                                           GLuint destId,
                                           GLint destLevel,
                                           GLint xoffset,
                                           GLint yoffset,
                                           GLint x,
                                           GLint y,
                                           GLint width,
                                           GLint height,
                                           GLboolean unpackFlipY,
                                           GLboolean unpackPremultiplyAlpha,
                                           GLboolean unpackUnmultiplyAlpha)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLCopySubTextureCHROMIUM,
          "context = %d, sourceId = %u, sourceLevel = %d, destTarget = %s, destId = %u, destLevel "
          "= %d, xoffset = %d, yoffset = %d, x = %d, y = %d, width = %d, height = %d, unpackFlipY "
          "= %s, unpackPremultiplyAlpha = %s, unpackUnmultiplyAlpha = %s",
          CID(context), sourceId, sourceLevel, GLenumToString(GLESEnum::AllEnums, destTarget),
          destId, destLevel, xoffset, yoffset, x, y, width, height, GLbooleanToString(unpackFlipY),
          GLbooleanToString(unpackPremultiplyAlpha), GLbooleanToString(unpackUnmultiplyAlpha));

    if (ANGLE_LIKELY(context != nullptr))
    {
        TextureID sourceIdPacked       = PackParam<TextureID>(sourceId);
        TextureTarget destTargetPacked = PackParam<TextureTarget>(destTarget);
        TextureID destIdPacked         = PackParam<TextureID>(destId);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().copyTextureCHROMIUM))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateCopySubTextureCHROMIUM(
                    context, angle::EntryPoint::GLCopySubTextureCHROMIUM, sourceIdPacked,
                    sourceLevel, destTargetPacked, destIdPacked, destLevel, xoffset, yoffset, x, y,
                    width, height, unpackFlipY, unpackPremultiplyAlpha, unpackUnmultiplyAlpha);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context, angle::EntryPoint::GLCopySubTextureCHROMIUM);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->copySubTexture(sourceIdPacked, sourceLevel, destTargetPacked, destIdPacked,
                                    destLevel, xoffset, yoffset, x, y, width, height, unpackFlipY,
                                    unpackPremultiplyAlpha, unpackUnmultiplyAlpha);
        }
        ANGLE_CAPTURE_GL(CopySubTextureCHROMIUM, isCallValid, context, sourceIdPacked, sourceLevel,
                         destTargetPacked, destIdPacked, destLevel, xoffset, yoffset, x, y, width,
                         height, unpackFlipY, unpackPremultiplyAlpha, unpackUnmultiplyAlpha);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLCopySubTextureCHROMIUM);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

// GL_CHROMIUM_framebuffer_mixed_samples
void GL_APIENTRY GL_CoverageModulationCHROMIUM(GLenum components)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLCoverageModulationCHROMIUM, "context = %d, components = %s", CID(context),
          GLenumToString(GLESEnum::AllEnums, components));

    if (ANGLE_LIKELY(context != nullptr))
    {
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().framebufferMixedSamplesCHROMIUM))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateCoverageModulationCHROMIUM(
                    context->getPrivateState(), context->getMutableErrorSetForValidation(),
                    angle::EntryPoint::GLCoverageModulationCHROMIUM, components);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(isCallValid || context->getPushedErrorCount() != errorCount);
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context, angle::EntryPoint::GLCoverageModulationCHROMIUM);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            ContextPrivateCoverageModulation(context->getMutablePrivateState(),
                                             context->getMutablePrivateStateCache(), components);
        }
        ANGLE_CAPTURE_GL(CoverageModulationCHROMIUM, isCallValid, context, components);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(
            angle::EntryPoint::GLCoverageModulationCHROMIUM);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

// GL_CHROMIUM_lose_context
void GL_APIENTRY GL_LoseContextCHROMIUM(GLenum current, GLenum other)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLLoseContextCHROMIUM, "context = %d, current = %s, other = %s", CID(context),
          GLenumToString(GLESEnum::GraphicsResetStatus, current),
          GLenumToString(GLESEnum::GraphicsResetStatus, other));

    if (ANGLE_LIKELY(context != nullptr))
    {
        GraphicsResetStatus currentPacked = PackParam<GraphicsResetStatus>(current);
        GraphicsResetStatus otherPacked   = PackParam<GraphicsResetStatus>(other);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().loseContextCHROMIUM))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateLoseContextCHROMIUM(
                    context, angle::EntryPoint::GLLoseContextCHROMIUM, currentPacked, otherPacked);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context, angle::EntryPoint::GLLoseContextCHROMIUM);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->loseContext(currentPacked, otherPacked);
        }
        ANGLE_CAPTURE_GL(LoseContextCHROMIUM, isCallValid, context, currentPacked, otherPacked);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLLoseContextCHROMIUM);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

// GL_EXT_EGL_image_array

// GL_EXT_EGL_image_storage
void GL_APIENTRY GL_EGLImageTargetTexStorageEXT(GLenum target,
                                                GLeglImageOES image,
                                                const GLint *attrib_list)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLEGLImageTargetTexStorageEXT,
          "context = %d, target = %s, image = 0x%016" PRIxPTR ", attrib_list = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLESEnum::AllEnums, target), (uintptr_t)image,
          (uintptr_t)attrib_list);

    if (ANGLE_LIKELY(context != nullptr))
    {
        egl::ImageID imagePacked = PackParam<egl::ImageID>(image);
        SCOPED_EGL_IMAGE_SHARE_CONTEXT_LOCK(context, imagePacked);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().EGLImageStorageEXT))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateEGLImageTargetTexStorageEXT(
                    context, angle::EntryPoint::GLEGLImageTargetTexStorageEXT, target, imagePacked,
                    attrib_list);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context, angle::EntryPoint::GLEGLImageTargetTexStorageEXT);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->eGLImageTargetTexStorage(target, imagePacked, attrib_list);
        }
        ANGLE_CAPTURE_GL(EGLImageTargetTexStorageEXT, isCallValid, context, target, imagePacked,
                         attrib_list);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(
            angle::EntryPoint::GLEGLImageTargetTexStorageEXT);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}


// GL_EXT_EGL_image_storage_compression

// GL_EXT_YUV_target

// GL_EXT_base_instance
void GL_APIENTRY GL_DrawArraysInstancedBaseInstanceEXT(GLenum mode,
                                                       GLint first,
                                                       GLsizei count,
                                                       GLsizei instancecount,
                                                       GLuint baseinstance)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLDrawArraysInstancedBaseInstanceEXT,
          "context = %d, mode = %s, first = %d, count = %d, instancecount = %d, baseinstance = %u",
          CID(context), GLenumToString(GLESEnum::PrimitiveType, mode), first, count, instancecount,
          baseinstance);

    if (ANGLE_LIKELY(context != nullptr))
    {
        PrimitiveMode modePacked = PackParam<PrimitiveMode>(mode);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().baseInstanceEXT))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateDrawArraysInstancedBaseInstanceEXT(
                    context, angle::EntryPoint::GLDrawArraysInstancedBaseInstanceEXT, modePacked,
                    first, count, instancecount, baseinstance);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context,
                                        angle::EntryPoint::GLDrawArraysInstancedBaseInstanceEXT);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->drawArraysInstancedBaseInstance(modePacked, first, count, instancecount,
                                                     baseinstance);
        }
        ANGLE_CAPTURE_GL(DrawArraysInstancedBaseInstanceEXT, isCallValid, context, modePacked,
                         first, count, instancecount, baseinstance);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(
            angle::EntryPoint::GLDrawArraysInstancedBaseInstanceEXT);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_DrawElementsInstancedBaseInstanceEXT(GLenum mode,
                                                         GLsizei count,
                                                         GLenum type,
                                                         const void *indices,
                                                         GLsizei instancecount,
                                                         GLuint baseinstance)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLDrawElementsInstancedBaseInstanceEXT,
          "context = %d, mode = %s, count = %d, type = %s, indices = 0x%016" PRIxPTR
          ", instancecount = %d, baseinstance = %u",
          CID(context), GLenumToString(GLESEnum::PrimitiveType, mode), count,
          GLenumToString(GLESEnum::DrawElementsType, type), (uintptr_t)indices, instancecount,
          baseinstance);

    if (ANGLE_LIKELY(context != nullptr))
    {
        PrimitiveMode modePacked    = PackParam<PrimitiveMode>(mode);
        DrawElementsType typePacked = PackParam<DrawElementsType>(type);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().baseInstanceEXT))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateDrawElementsInstancedBaseInstanceEXT(
                    context, angle::EntryPoint::GLDrawElementsInstancedBaseInstanceEXT, modePacked,
                    count, typePacked, indices, instancecount, baseinstance);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context,
                                        angle::EntryPoint::GLDrawElementsInstancedBaseInstanceEXT);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->drawElementsInstancedBaseInstance(modePacked, count, typePacked, indices,
                                                       instancecount, baseinstance);
        }
        ANGLE_CAPTURE_GL(DrawElementsInstancedBaseInstanceEXT, isCallValid, context, modePacked,
                         count, typePacked, indices, instancecount, baseinstance);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(
            angle::EntryPoint::GLDrawElementsInstancedBaseInstanceEXT);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_DrawElementsInstancedBaseVertexBaseInstanceEXT(GLenum mode,
                                                                   GLsizei count,
                                                                   GLenum type,
                                                                   const void *indices,
                                                                   GLsizei instancecount,
                                                                   GLint basevertex,
                                                                   GLuint baseinstance)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLDrawElementsInstancedBaseVertexBaseInstanceEXT,
          "context = %d, mode = %s, count = %d, type = %s, indices = 0x%016" PRIxPTR
          ", instancecount = %d, basevertex = %d, baseinstance = %u",
          CID(context), GLenumToString(GLESEnum::PrimitiveType, mode), count,
          GLenumToString(GLESEnum::DrawElementsType, type), (uintptr_t)indices, instancecount,
          basevertex, baseinstance);

    if (ANGLE_LIKELY(context != nullptr))
    {
        PrimitiveMode modePacked    = PackParam<PrimitiveMode>(mode);
        DrawElementsType typePacked = PackParam<DrawElementsType>(type);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().baseInstanceEXT))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateDrawElementsInstancedBaseVertexBaseInstanceEXT(
                    context, angle::EntryPoint::GLDrawElementsInstancedBaseVertexBaseInstanceEXT,
                    modePacked, count, typePacked, indices, instancecount, basevertex,
                    baseinstance);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(
                    context, angle::EntryPoint::GLDrawElementsInstancedBaseVertexBaseInstanceEXT);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->drawElementsInstancedBaseVertexBaseInstance(
                modePacked, count, typePacked, indices, instancecount, basevertex, baseinstance);
        }
        ANGLE_CAPTURE_GL(DrawElementsInstancedBaseVertexBaseInstanceEXT, isCallValid, context,
                         modePacked, count, typePacked, indices, instancecount, basevertex,
                         baseinstance);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(
            angle::EntryPoint::GLDrawElementsInstancedBaseVertexBaseInstanceEXT);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

// GL_EXT_blend_func_extended
void GL_APIENTRY GL_BindFragDataLocationEXT(GLuint program, GLuint color, const GLchar *name)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLBindFragDataLocationEXT,
          "context = %d, program = %u, color = %u, name = 0x%016" PRIxPTR "", CID(context), program,
          color, (uintptr_t)name);

    if (ANGLE_LIKELY(context != nullptr))
    {
        ShaderProgramID programPacked = PackParam<ShaderProgramID>(program);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().blendFuncExtendedEXT))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateBindFragDataLocationEXT(
                    context, angle::EntryPoint::GLBindFragDataLocationEXT, programPacked, color,
                    name);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context, angle::EntryPoint::GLBindFragDataLocationEXT);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->bindFragDataLocation(programPacked, color, name);
        }
        ANGLE_CAPTURE_GL(BindFragDataLocationEXT, isCallValid, context, programPacked, color, name);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(
            angle::EntryPoint::GLBindFragDataLocationEXT);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_BindFragDataLocationIndexedEXT(GLuint program,
                                                   GLuint colorNumber,
                                                   GLuint index,
                                                   const GLchar *name)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLBindFragDataLocationIndexedEXT,
          "context = %d, program = %u, colorNumber = %u, index = %u, name = 0x%016" PRIxPTR "",
          CID(context), program, colorNumber, index, (uintptr_t)name);

    if (ANGLE_LIKELY(context != nullptr))
    {
        ShaderProgramID programPacked = PackParam<ShaderProgramID>(program);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().blendFuncExtendedEXT))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateBindFragDataLocationIndexedEXT(
                    context, angle::EntryPoint::GLBindFragDataLocationIndexedEXT, programPacked,
                    colorNumber, index, name);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context,
                                        angle::EntryPoint::GLBindFragDataLocationIndexedEXT);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->bindFragDataLocationIndexed(programPacked, colorNumber, index, name);
        }
        ANGLE_CAPTURE_GL(BindFragDataLocationIndexedEXT, isCallValid, context, programPacked,
                         colorNumber, index, name);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(
            angle::EntryPoint::GLBindFragDataLocationIndexedEXT);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

GLint GL_APIENTRY GL_GetFragDataIndexEXT(GLuint program, const GLchar *name)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLGetFragDataIndexEXT, "context = %d, program = %u, name = 0x%016" PRIxPTR "",
          CID(context), program, (uintptr_t)name);

    GLint returnValue;
    if (ANGLE_LIKELY(context != nullptr))
    {
        ShaderProgramID programPacked = PackParam<ShaderProgramID>(program);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().blendFuncExtendedEXT))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateGetFragDataIndexEXT(
                    context, angle::EntryPoint::GLGetFragDataIndexEXT, programPacked, name);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context, angle::EntryPoint::GLGetFragDataIndexEXT);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            returnValue = context->getFragDataIndex(programPacked, name);
        }
        else
        {
            returnValue = GetDefaultReturnValue<angle::EntryPoint::GLGetFragDataIndexEXT, GLint>();
        }
        ANGLE_CAPTURE_GL(GetFragDataIndexEXT, isCallValid, context, programPacked, name,
                         returnValue);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLGetFragDataIndexEXT);
        returnValue = GetDefaultReturnValue<angle::EntryPoint::GLGetFragDataIndexEXT, GLint>();
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    return returnValue;
}

GLint GL_APIENTRY GL_GetProgramResourceLocationIndexEXT(GLuint program,
                                                        GLenum programInterface,
                                                        const GLchar *name)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLGetProgramResourceLocationIndexEXT,
          "context = %d, program = %u, programInterface = %s, name = 0x%016" PRIxPTR "",
          CID(context), program, GLenumToString(GLESEnum::ProgramInterface, programInterface),
          (uintptr_t)name);

    GLint returnValue;
    if (ANGLE_LIKELY(context != nullptr))
    {
        ShaderProgramID programPacked = PackParam<ShaderProgramID>(program);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().blendFuncExtendedEXT))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateGetProgramResourceLocationIndexEXT(
                    context, angle::EntryPoint::GLGetProgramResourceLocationIndexEXT, programPacked,
                    programInterface, name);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context,
                                        angle::EntryPoint::GLGetProgramResourceLocationIndexEXT);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            returnValue =
                context->getProgramResourceLocationIndex(programPacked, programInterface, name);
        }
        else
        {
            returnValue =
                GetDefaultReturnValue<angle::EntryPoint::GLGetProgramResourceLocationIndexEXT,
                                      GLint>();
        }
        ANGLE_CAPTURE_GL(GetProgramResourceLocationIndexEXT, isCallValid, context, programPacked,
                         programInterface, name, returnValue);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(
            angle::EntryPoint::GLGetProgramResourceLocationIndexEXT);
        returnValue =
            GetDefaultReturnValue<angle::EntryPoint::GLGetProgramResourceLocationIndexEXT, GLint>();
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    return returnValue;
}

// GL_EXT_blend_minmax

// GL_EXT_buffer_storage
void GL_APIENTRY GL_BufferStorageEXT(GLenum target,
                                     GLsizeiptr size,
                                     const void *data,
                                     GLbitfield flags)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLBufferStorageEXT,
          "context = %d, target = %s, size = %llu, data = 0x%016" PRIxPTR ", flags = %s",
          CID(context), GLenumToString(GLESEnum::BufferStorageTarget, target),
          static_cast<unsigned long long>(size), (uintptr_t)data,
          GLbitfieldToString(GLESEnum::BufferStorageMask, flags).c_str());

    if (ANGLE_LIKELY(context != nullptr))
    {
        BufferBinding targetPacked = PackParam<BufferBinding>(target);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().bufferStorageEXT))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid =
                    ValidateBufferStorageEXT(context, angle::EntryPoint::GLBufferStorageEXT,
                                             targetPacked, size, data, flags);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context, angle::EntryPoint::GLBufferStorageEXT);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->bufferStorage(targetPacked, size, data, flags);
        }
        ANGLE_CAPTURE_GL(BufferStorageEXT, isCallValid, context, targetPacked, size, data, flags);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLBufferStorageEXT);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

// GL_EXT_clear_texture
void GL_APIENTRY
GL_ClearTexImageEXT(GLuint texture, GLint level, GLenum format, GLenum type, const void *data)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLClearTexImageEXT,
          "context = %d, texture = %u, level = %d, format = %s, type = %s, data = 0x%016" PRIxPTR
          "",
          CID(context), texture, level, GLenumToString(GLESEnum::PixelFormat, format),
          GLenumToString(GLESEnum::PixelType, type), (uintptr_t)data);

    if (ANGLE_LIKELY(context != nullptr))
    {
        TextureID texturePacked = PackParam<TextureID>(texture);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().clearTextureEXT))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid =
                    ValidateClearTexImageEXT(context, angle::EntryPoint::GLClearTexImageEXT,
                                             texturePacked, level, format, type, data);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context, angle::EntryPoint::GLClearTexImageEXT);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->clearTexImage(texturePacked, level, format, type, data);
        }
        ANGLE_CAPTURE_GL(ClearTexImageEXT, isCallValid, context, texturePacked, level, format, type,
                         data);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLClearTexImageEXT);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_ClearTexSubImageEXT(GLuint texture,
                                        GLint level,
                                        GLint xoffset,
                                        GLint yoffset,
                                        GLint zoffset,
                                        GLsizei width,
                                        GLsizei height,
                                        GLsizei depth,
                                        GLenum format,
                                        GLenum type,
                                        const void *data)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLClearTexSubImageEXT,
          "context = %d, texture = %u, level = %d, xoffset = %d, yoffset = %d, zoffset = %d, width "
          "= %d, height = %d, depth = %d, format = %s, type = %s, data = 0x%016" PRIxPTR "",
          CID(context), texture, level, xoffset, yoffset, zoffset, width, height, depth,
          GLenumToString(GLESEnum::PixelFormat, format), GLenumToString(GLESEnum::PixelType, type),
          (uintptr_t)data);

    if (ANGLE_LIKELY(context != nullptr))
    {
        TextureID texturePacked = PackParam<TextureID>(texture);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().clearTextureEXT))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateClearTexSubImageEXT(
                    context, angle::EntryPoint::GLClearTexSubImageEXT, texturePacked, level,
                    xoffset, yoffset, zoffset, width, height, depth, format, type, data);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context, angle::EntryPoint::GLClearTexSubImageEXT);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->clearTexSubImage(texturePacked, level, xoffset, yoffset, zoffset, width,
                                      height, depth, format, type, data);
        }
        ANGLE_CAPTURE_GL(ClearTexSubImageEXT, isCallValid, context, texturePacked, level, xoffset,
                         yoffset, zoffset, width, height, depth, format, type, data);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLClearTexSubImageEXT);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

// GL_EXT_clip_control
void GL_APIENTRY GL_ClipControlEXT(GLenum origin, GLenum depth)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLClipControlEXT, "context = %d, origin = %s, depth = %s", CID(context),
          GLenumToString(GLESEnum::AllEnums, origin), GLenumToString(GLESEnum::AllEnums, depth));

    if (ANGLE_LIKELY(context != nullptr))
    {
        ClipOrigin originPacked   = PackParam<ClipOrigin>(origin);
        ClipDepthMode depthPacked = PackParam<ClipDepthMode>(depth);
        bool isCallValid          = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().clipControlEXT))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateClipControlEXT(
                    context->getPrivateState(), context->getMutableErrorSetForValidation(),
                    angle::EntryPoint::GLClipControlEXT, originPacked, depthPacked);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(isCallValid || context->getPushedErrorCount() != errorCount);
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context, angle::EntryPoint::GLClipControlEXT);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            ContextPrivateClipControl(context->getMutablePrivateState(),
                                      context->getMutablePrivateStateCache(), originPacked,
                                      depthPacked);
        }
        ANGLE_CAPTURE_GL(ClipControlEXT, isCallValid, context, originPacked, depthPacked);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLClipControlEXT);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

// GL_EXT_clip_cull_distance

// GL_EXT_color_buffer_float

// GL_EXT_color_buffer_half_float

// GL_EXT_conservative_depth

// GL_EXT_copy_image
void GL_APIENTRY GL_CopyImageSubDataEXT(GLuint srcName,
                                        GLenum srcTarget,
                                        GLint srcLevel,
                                        GLint srcX,
                                        GLint srcY,
                                        GLint srcZ,
                                        GLuint dstName,
                                        GLenum dstTarget,
                                        GLint dstLevel,
                                        GLint dstX,
                                        GLint dstY,
                                        GLint dstZ,
                                        GLsizei srcWidth,
                                        GLsizei srcHeight,
                                        GLsizei srcDepth)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLCopyImageSubDataEXT,
          "context = %d, srcName = %u, srcTarget = %s, srcLevel = %d, srcX = %d, srcY = %d, srcZ = "
          "%d, dstName = %u, dstTarget = %s, dstLevel = %d, dstX = %d, dstY = %d, dstZ = %d, "
          "srcWidth = %d, srcHeight = %d, srcDepth = %d",
          CID(context), srcName, GLenumToString(GLESEnum::CopyBufferSubDataTarget, srcTarget),
          srcLevel, srcX, srcY, srcZ, dstName,
          GLenumToString(GLESEnum::CopyBufferSubDataTarget, dstTarget), dstLevel, dstX, dstY, dstZ,
          srcWidth, srcHeight, srcDepth);

    if (ANGLE_LIKELY(context != nullptr))
    {
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().copyImageEXT))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateCopyImageSubDataEXT(
                    context, angle::EntryPoint::GLCopyImageSubDataEXT, srcName, srcTarget, srcLevel,
                    srcX, srcY, srcZ, dstName, dstTarget, dstLevel, dstX, dstY, dstZ, srcWidth,
                    srcHeight, srcDepth);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context, angle::EntryPoint::GLCopyImageSubDataEXT);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->copyImageSubData(srcName, srcTarget, srcLevel, srcX, srcY, srcZ, dstName,
                                      dstTarget, dstLevel, dstX, dstY, dstZ, srcWidth, srcHeight,
                                      srcDepth);
        }
        ANGLE_CAPTURE_GL(CopyImageSubDataEXT, isCallValid, context, srcName, srcTarget, srcLevel,
                         srcX, srcY, srcZ, dstName, dstTarget, dstLevel, dstX, dstY, dstZ, srcWidth,
                         srcHeight, srcDepth);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLCopyImageSubDataEXT);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

// GL_EXT_debug_label
void GL_APIENTRY
GL_GetObjectLabelEXT(GLenum type, GLuint object, GLsizei bufSize, GLsizei *length, GLchar *label)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLGetObjectLabelEXT,
          "context = %d, type = %s, object = %u, bufSize = %d, length = 0x%016" PRIxPTR
          ", label = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLESEnum::AllEnums, type), object, bufSize,
          (uintptr_t)length, (uintptr_t)label);

    if (ANGLE_LIKELY(context != nullptr))
    {
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().debugLabelEXT))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid =
                    ValidateGetObjectLabelEXT(context, angle::EntryPoint::GLGetObjectLabelEXT, type,
                                              object, bufSize, length, label);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context, angle::EntryPoint::GLGetObjectLabelEXT);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->getObjectLabel(type, object, bufSize, length, label);
        }
        ANGLE_CAPTURE_GL(GetObjectLabelEXT, isCallValid, context, type, object, bufSize, length,
                         label);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLGetObjectLabelEXT);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_LabelObjectEXT(GLenum type, GLuint object, GLsizei length, const GLchar *label)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLLabelObjectEXT,
          "context = %d, type = %s, object = %u, length = %d, label = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLESEnum::AllEnums, type), object, length, (uintptr_t)label);

    if (ANGLE_LIKELY(context != nullptr))
    {
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().debugLabelEXT))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateLabelObjectEXT(context, angle::EntryPoint::GLLabelObjectEXT,
                                                     type, object, length, label);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context, angle::EntryPoint::GLLabelObjectEXT);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->labelObject(type, object, length, label);
        }
        ANGLE_CAPTURE_GL(LabelObjectEXT, isCallValid, context, type, object, length, label);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLLabelObjectEXT);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

// GL_EXT_debug_marker
void GL_APIENTRY GL_InsertEventMarkerEXT(GLsizei length, const GLchar *marker)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    // Don't run the EVENT() macro on the EXT_debug_marker entry points.
    // It can interfere with the debug events being set by the caller.
    // EVENT(context, GLInsertEventMarkerEXT, "context = %d, length = %d, marker = 0x%016" PRIxPTR
    // "", CID(context), length, (uintptr_t)marker);

    if (ANGLE_LIKELY(context != nullptr))
    {
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().debugMarkerEXT))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateInsertEventMarkerEXT(
                    context, angle::EntryPoint::GLInsertEventMarkerEXT, length, marker);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context, angle::EntryPoint::GLInsertEventMarkerEXT);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->insertEventMarker(length, marker);
        }
        ANGLE_CAPTURE_GL(InsertEventMarkerEXT, isCallValid, context, length, marker);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLInsertEventMarkerEXT);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_PopGroupMarkerEXT()
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    // Don't run the EVENT() macro on the EXT_debug_marker entry points.
    // It can interfere with the debug events being set by the caller.
    // EVENT(context, GLPopGroupMarkerEXT, "context = %d", CID(context));

    if (ANGLE_LIKELY(context != nullptr))
    {
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().debugMarkerEXT))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid =
                    ValidatePopGroupMarkerEXT(context, angle::EntryPoint::GLPopGroupMarkerEXT);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context, angle::EntryPoint::GLPopGroupMarkerEXT);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->popGroupMarker();
        }
        ANGLE_CAPTURE_GL(PopGroupMarkerEXT, isCallValid, context);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLPopGroupMarkerEXT);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_PushGroupMarkerEXT(GLsizei length, const GLchar *marker)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    // Don't run the EVENT() macro on the EXT_debug_marker entry points.
    // It can interfere with the debug events being set by the caller.
    // EVENT(context, GLPushGroupMarkerEXT, "context = %d, length = %d, marker = 0x%016" PRIxPTR "",
    // CID(context), length, (uintptr_t)marker);

    if (ANGLE_LIKELY(context != nullptr))
    {
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().debugMarkerEXT))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidatePushGroupMarkerEXT(
                    context, angle::EntryPoint::GLPushGroupMarkerEXT, length, marker);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context, angle::EntryPoint::GLPushGroupMarkerEXT);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->pushGroupMarker(length, marker);
        }
        ANGLE_CAPTURE_GL(PushGroupMarkerEXT, isCallValid, context, length, marker);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLPushGroupMarkerEXT);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

// GL_EXT_depth_clamp

// GL_EXT_discard_framebuffer
void GL_APIENTRY GL_DiscardFramebufferEXT(GLenum target,
                                          GLsizei numAttachments,
                                          const GLenum *attachments)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLDiscardFramebufferEXT,
          "context = %d, target = %s, numAttachments = %d, attachments = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLESEnum::FramebufferTarget, target), numAttachments,
          (uintptr_t)attachments);

    if (ANGLE_LIKELY(context != nullptr))
    {
        SCOPED_SHARE_CONTEXT_LOCK(context);
        if (context->getState().getPixelLocalStorageActivePlanes() != 0)
        {
            context->endPixelLocalStorageImplicit();
        }
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().discardFramebufferEXT))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateDiscardFramebufferEXT(
                    context, angle::EntryPoint::GLDiscardFramebufferEXT, target, numAttachments,
                    attachments);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context, angle::EntryPoint::GLDiscardFramebufferEXT);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->discardFramebuffer(target, numAttachments, attachments);
        }
        ANGLE_CAPTURE_GL(DiscardFramebufferEXT, isCallValid, context, target, numAttachments,
                         attachments);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLDiscardFramebufferEXT);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

// GL_EXT_disjoint_timer_query
void GL_APIENTRY GL_BeginQueryEXT(GLenum target, GLuint id)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLBeginQueryEXT, "context = %d, target = %s, id = %u", CID(context),
          GLenumToString(GLESEnum::QueryTarget, target), id);

    if (ANGLE_LIKELY(context != nullptr))
    {
        QueryType targetPacked = PackParam<QueryType>(target);
        QueryID idPacked       = PackParam<QueryID>(id);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().disjointTimerQueryEXT ||
                             context->getExtensions().occlusionQueryBooleanEXT))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateBeginQueryEXT(context, angle::EntryPoint::GLBeginQueryEXT,
                                                    targetPacked, idPacked);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context, angle::EntryPoint::GLBeginQueryEXT);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->beginQuery(targetPacked, idPacked);
        }
        ANGLE_CAPTURE_GL(BeginQueryEXT, isCallValid, context, targetPacked, idPacked);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLBeginQueryEXT);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_DeleteQueriesEXT(GLsizei n, const GLuint *ids)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLDeleteQueriesEXT, "context = %d, n = %d, ids = 0x%016" PRIxPTR "",
          CID(context), n, (uintptr_t)ids);

    if (ANGLE_LIKELY(context != nullptr))
    {
        const QueryID *idsPacked = PackParam<const QueryID *>(ids);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().disjointTimerQueryEXT ||
                             context->getExtensions().occlusionQueryBooleanEXT))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateDeleteQueriesEXT(
                    context, angle::EntryPoint::GLDeleteQueriesEXT, n, idsPacked);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context, angle::EntryPoint::GLDeleteQueriesEXT);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->deleteQueries(n, idsPacked);
        }
        ANGLE_CAPTURE_GL(DeleteQueriesEXT, isCallValid, context, n, idsPacked);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLDeleteQueriesEXT);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_EndQueryEXT(GLenum target)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLEndQueryEXT, "context = %d, target = %s", CID(context),
          GLenumToString(GLESEnum::QueryTarget, target));

    if (ANGLE_LIKELY(context != nullptr))
    {
        QueryType targetPacked = PackParam<QueryType>(target);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().disjointTimerQueryEXT ||
                             context->getExtensions().occlusionQueryBooleanEXT))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid =
                    ValidateEndQueryEXT(context, angle::EntryPoint::GLEndQueryEXT, targetPacked);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context, angle::EntryPoint::GLEndQueryEXT);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->endQuery(targetPacked);
        }
        ANGLE_CAPTURE_GL(EndQueryEXT, isCallValid, context, targetPacked);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLEndQueryEXT);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_GenQueriesEXT(GLsizei n, GLuint *ids)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLGenQueriesEXT, "context = %d, n = %d, ids = 0x%016" PRIxPTR "", CID(context),
          n, (uintptr_t)ids);

    if (ANGLE_LIKELY(context != nullptr))
    {
        QueryID *idsPacked = PackParam<QueryID *>(ids);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().disjointTimerQueryEXT ||
                             context->getExtensions().occlusionQueryBooleanEXT))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateGenQueriesEXT(context, angle::EntryPoint::GLGenQueriesEXT, n,
                                                    idsPacked);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context, angle::EntryPoint::GLGenQueriesEXT);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->genQueries(n, idsPacked);
        }
        ANGLE_CAPTURE_GL(GenQueriesEXT, isCallValid, context, n, idsPacked);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLGenQueriesEXT);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_GetInteger64vEXT(GLenum pname, GLint64 *data)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLGetInteger64vEXT, "context = %d, pname = %s, data = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLESEnum::GetPName, pname), (uintptr_t)data);

    if (ANGLE_LIKELY(context != nullptr))
    {
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().disjointTimerQueryEXT))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateGetInteger64vEXT(
                    context, angle::EntryPoint::GLGetInteger64vEXT, pname, data);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context, angle::EntryPoint::GLGetInteger64vEXT);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->getInteger64v(pname, data);
        }
        ANGLE_CAPTURE_GL(GetInteger64vEXT, isCallValid, context, pname, data);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLGetInteger64vEXT);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_GetQueryObjecti64vEXT(GLuint id, GLenum pname, GLint64 *params)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetGlobalContext();
    EVENT(context, GLGetQueryObjecti64vEXT,
          "context = %d, id = %u, pname = %s, params = 0x%016" PRIxPTR "", CID(context), id,
          GLenumToString(GLESEnum::QueryObjectParameterName, pname), (uintptr_t)params);

    if (ANGLE_LIKELY(context != nullptr))
    {
        QueryID idPacked = PackParam<QueryID>(id);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().disjointTimerQueryEXT))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateGetQueryObjecti64vEXT(
                    context, angle::EntryPoint::GLGetQueryObjecti64vEXT, idPacked, pname, params);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context, angle::EntryPoint::GLGetQueryObjecti64vEXT);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->getQueryObjecti64v(idPacked, pname, params);
        }
        ANGLE_CAPTURE_GL(GetQueryObjecti64vEXT, isCallValid, context, idPacked, pname, params);
    }
    else
    {
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_GetQueryObjectivEXT(GLuint id, GLenum pname, GLint *params)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetGlobalContext();
    EVENT(context, GLGetQueryObjectivEXT,
          "context = %d, id = %u, pname = %s, params = 0x%016" PRIxPTR "", CID(context), id,
          GLenumToString(GLESEnum::QueryObjectParameterName, pname), (uintptr_t)params);

    if (ANGLE_LIKELY(context != nullptr))
    {
        QueryID idPacked = PackParam<QueryID>(id);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().disjointTimerQueryEXT))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateGetQueryObjectivEXT(
                    context, angle::EntryPoint::GLGetQueryObjectivEXT, idPacked, pname, params);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context, angle::EntryPoint::GLGetQueryObjectivEXT);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->getQueryObjectiv(idPacked, pname, params);
        }
        ANGLE_CAPTURE_GL(GetQueryObjectivEXT, isCallValid, context, idPacked, pname, params);
    }
    else
    {
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_GetQueryObjectui64vEXT(GLuint id, GLenum pname, GLuint64 *params)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetGlobalContext();
    EVENT(context, GLGetQueryObjectui64vEXT,
          "context = %d, id = %u, pname = %s, params = 0x%016" PRIxPTR "", CID(context), id,
          GLenumToString(GLESEnum::QueryObjectParameterName, pname), (uintptr_t)params);

    if (ANGLE_LIKELY(context != nullptr))
    {
        QueryID idPacked = PackParam<QueryID>(id);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().disjointTimerQueryEXT))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateGetQueryObjectui64vEXT(
                    context, angle::EntryPoint::GLGetQueryObjectui64vEXT, idPacked, pname, params);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context, angle::EntryPoint::GLGetQueryObjectui64vEXT);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->getQueryObjectui64v(idPacked, pname, params);
        }
        ANGLE_CAPTURE_GL(GetQueryObjectui64vEXT, isCallValid, context, idPacked, pname, params);
    }
    else
    {
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_GetQueryObjectuivEXT(GLuint id, GLenum pname, GLuint *params)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetGlobalContext();
    EVENT(context, GLGetQueryObjectuivEXT,
          "context = %d, id = %u, pname = %s, params = 0x%016" PRIxPTR "", CID(context), id,
          GLenumToString(GLESEnum::QueryObjectParameterName, pname), (uintptr_t)params);

    if (ANGLE_LIKELY(context != nullptr))
    {
        QueryID idPacked = PackParam<QueryID>(id);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().disjointTimerQueryEXT ||
                             context->getExtensions().occlusionQueryBooleanEXT))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateGetQueryObjectuivEXT(
                    context, angle::EntryPoint::GLGetQueryObjectuivEXT, idPacked, pname, params);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context, angle::EntryPoint::GLGetQueryObjectuivEXT);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->getQueryObjectuiv(idPacked, pname, params);
        }
        ANGLE_CAPTURE_GL(GetQueryObjectuivEXT, isCallValid, context, idPacked, pname, params);
    }
    else
    {
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_GetQueryivEXT(GLenum target, GLenum pname, GLint *params)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLGetQueryivEXT,
          "context = %d, target = %s, pname = %s, params = 0x%016" PRIxPTR "", CID(context),
          GLenumToString(GLESEnum::QueryTarget, target),
          GLenumToString(GLESEnum::QueryParameterName, pname), (uintptr_t)params);

    if (ANGLE_LIKELY(context != nullptr))
    {
        QueryType targetPacked = PackParam<QueryType>(target);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().disjointTimerQueryEXT ||
                             context->getExtensions().occlusionQueryBooleanEXT))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateGetQueryivEXT(context, angle::EntryPoint::GLGetQueryivEXT,
                                                    targetPacked, pname, params);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context, angle::EntryPoint::GLGetQueryivEXT);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->getQueryiv(targetPacked, pname, params);
        }
        ANGLE_CAPTURE_GL(GetQueryivEXT, isCallValid, context, targetPacked, pname, params);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLGetQueryivEXT);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

GLboolean GL_APIENTRY GL_IsQueryEXT(GLuint id)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLIsQueryEXT, "context = %d, id = %u", CID(context), id);

    GLboolean returnValue;
    if (ANGLE_LIKELY(context != nullptr))
    {
        QueryID idPacked = PackParam<QueryID>(id);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().disjointTimerQueryEXT ||
                             context->getExtensions().occlusionQueryBooleanEXT))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid =
                    ValidateIsQueryEXT(context, angle::EntryPoint::GLIsQueryEXT, idPacked);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context, angle::EntryPoint::GLIsQueryEXT);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            returnValue = context->isQuery(idPacked);
        }
        else
        {
            returnValue = GetDefaultReturnValue<angle::EntryPoint::GLIsQueryEXT, GLboolean>();
        }
        ANGLE_CAPTURE_GL(IsQueryEXT, isCallValid, context, idPacked, returnValue);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLIsQueryEXT);
        returnValue = GetDefaultReturnValue<angle::EntryPoint::GLIsQueryEXT, GLboolean>();
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    return returnValue;
}

void GL_APIENTRY GL_QueryCounterEXT(GLuint id, GLenum target)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLQueryCounterEXT, "context = %d, id = %u, target = %s", CID(context), id,
          GLenumToString(GLESEnum::QueryCounterTarget, target));

    if (ANGLE_LIKELY(context != nullptr))
    {
        QueryID idPacked       = PackParam<QueryID>(id);
        QueryType targetPacked = PackParam<QueryType>(target);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().disjointTimerQueryEXT))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateQueryCounterEXT(context, angle::EntryPoint::GLQueryCounterEXT,
                                                      idPacked, targetPacked);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context, angle::EntryPoint::GLQueryCounterEXT);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->queryCounter(idPacked, targetPacked);
        }
        ANGLE_CAPTURE_GL(QueryCounterEXT, isCallValid, context, idPacked, targetPacked);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLQueryCounterEXT);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

// GL_EXT_draw_buffers
void GL_APIENTRY GL_DrawBuffersEXT(GLsizei n, const GLenum *bufs)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLDrawBuffersEXT, "context = %d, n = %d, bufs = 0x%016" PRIxPTR "", CID(context),
          n, (uintptr_t)bufs);

    if (ANGLE_LIKELY(context != nullptr))
    {
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().drawBuffersEXT))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid =
                    ValidateDrawBuffersEXT(context, angle::EntryPoint::GLDrawBuffersEXT, n, bufs);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context, angle::EntryPoint::GLDrawBuffersEXT);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->drawBuffers(n, bufs);
        }
        ANGLE_CAPTURE_GL(DrawBuffersEXT, isCallValid, context, n, bufs);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLDrawBuffersEXT);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

// GL_EXT_draw_buffers_indexed
void GL_APIENTRY GL_BlendEquationSeparateiEXT(GLuint buf, GLenum modeRGB, GLenum modeAlpha)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLBlendEquationSeparateiEXT,
          "context = %d, buf = %u, modeRGB = %s, modeAlpha = %s", CID(context), buf,
          GLenumToString(GLESEnum::BlendEquationModeEXT, modeRGB),
          GLenumToString(GLESEnum::BlendEquationModeEXT, modeAlpha));

    if (ANGLE_LIKELY(context != nullptr))
    {
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().drawBuffersIndexedEXT))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateBlendEquationSeparateiEXT(
                    context->getPrivateState(), context->getMutableErrorSetForValidation(),
                    angle::EntryPoint::GLBlendEquationSeparateiEXT, buf, modeRGB, modeAlpha);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(isCallValid || context->getPushedErrorCount() != errorCount);
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context, angle::EntryPoint::GLBlendEquationSeparateiEXT);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            ContextPrivateBlendEquationSeparatei(context->getMutablePrivateState(),
                                                 context->getMutablePrivateStateCache(), buf,
                                                 modeRGB, modeAlpha);
        }
        ANGLE_CAPTURE_GL(BlendEquationSeparateiEXT, isCallValid, context, buf, modeRGB, modeAlpha);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(
            angle::EntryPoint::GLBlendEquationSeparateiEXT);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_BlendEquationiEXT(GLuint buf, GLenum mode)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLBlendEquationiEXT, "context = %d, buf = %u, mode = %s", CID(context), buf,
          GLenumToString(GLESEnum::BlendEquationModeEXT, mode));

    if (ANGLE_LIKELY(context != nullptr))
    {
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().drawBuffersIndexedEXT))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateBlendEquationiEXT(
                    context->getPrivateState(), context->getMutableErrorSetForValidation(),
                    angle::EntryPoint::GLBlendEquationiEXT, buf, mode);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(isCallValid || context->getPushedErrorCount() != errorCount);
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context, angle::EntryPoint::GLBlendEquationiEXT);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            ContextPrivateBlendEquationi(context->getMutablePrivateState(),
                                         context->getMutablePrivateStateCache(), buf, mode);
        }
        ANGLE_CAPTURE_GL(BlendEquationiEXT, isCallValid, context, buf, mode);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLBlendEquationiEXT);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY
GL_BlendFuncSeparateiEXT(GLuint buf, GLenum srcRGB, GLenum dstRGB, GLenum srcAlpha, GLenum dstAlpha)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLBlendFuncSeparateiEXT,
          "context = %d, buf = %u, srcRGB = %s, dstRGB = %s, srcAlpha = %s, dstAlpha = %s",
          CID(context), buf, GLenumToString(GLESEnum::BlendingFactor, srcRGB),
          GLenumToString(GLESEnum::BlendingFactor, dstRGB),
          GLenumToString(GLESEnum::BlendingFactor, srcAlpha),
          GLenumToString(GLESEnum::BlendingFactor, dstAlpha));

    if (ANGLE_LIKELY(context != nullptr))
    {
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().drawBuffersIndexedEXT))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateBlendFuncSeparateiEXT(
                    context->getPrivateState(), context->getMutableErrorSetForValidation(),
                    angle::EntryPoint::GLBlendFuncSeparateiEXT, buf, srcRGB, dstRGB, srcAlpha,
                    dstAlpha);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(isCallValid || context->getPushedErrorCount() != errorCount);
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context, angle::EntryPoint::GLBlendFuncSeparateiEXT);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            ContextPrivateBlendFuncSeparatei(context->getMutablePrivateState(),
                                             context->getMutablePrivateStateCache(), buf, srcRGB,
                                             dstRGB, srcAlpha, dstAlpha);
        }
        ANGLE_CAPTURE_GL(BlendFuncSeparateiEXT, isCallValid, context, buf, srcRGB, dstRGB, srcAlpha,
                         dstAlpha);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLBlendFuncSeparateiEXT);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_BlendFunciEXT(GLuint buf, GLenum src, GLenum dst)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLBlendFunciEXT, "context = %d, buf = %u, src = %s, dst = %s", CID(context), buf,
          GLenumToString(GLESEnum::BlendingFactor, src),
          GLenumToString(GLESEnum::BlendingFactor, dst));

    if (ANGLE_LIKELY(context != nullptr))
    {
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().drawBuffersIndexedEXT))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateBlendFunciEXT(
                    context->getPrivateState(), context->getMutableErrorSetForValidation(),
                    angle::EntryPoint::GLBlendFunciEXT, buf, src, dst);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(isCallValid || context->getPushedErrorCount() != errorCount);
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context, angle::EntryPoint::GLBlendFunciEXT);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            ContextPrivateBlendFunci(context->getMutablePrivateState(),
                                     context->getMutablePrivateStateCache(), buf, src, dst);
        }
        ANGLE_CAPTURE_GL(BlendFunciEXT, isCallValid, context, buf, src, dst);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLBlendFunciEXT);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_ColorMaskiEXT(GLuint index, GLboolean r, GLboolean g, GLboolean b, GLboolean a)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLColorMaskiEXT, "context = %d, index = %u, r = %s, g = %s, b = %s, a = %s",
          CID(context), index, GLbooleanToString(r), GLbooleanToString(g), GLbooleanToString(b),
          GLbooleanToString(a));

    if (ANGLE_LIKELY(context != nullptr))
    {
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().drawBuffersIndexedEXT))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateColorMaskiEXT(
                    context->getPrivateState(), context->getMutableErrorSetForValidation(),
                    angle::EntryPoint::GLColorMaskiEXT, index, r, g, b, a);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(isCallValid || context->getPushedErrorCount() != errorCount);
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context, angle::EntryPoint::GLColorMaskiEXT);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            ContextPrivateColorMaski(context->getMutablePrivateState(),
                                     context->getMutablePrivateStateCache(), index, r, g, b, a);
        }
        ANGLE_CAPTURE_GL(ColorMaskiEXT, isCallValid, context, index, r, g, b, a);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLColorMaskiEXT);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_DisableiEXT(GLenum target, GLuint index)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLDisableiEXT, "context = %d, target = %s, index = %u", CID(context),
          GLenumToString(GLESEnum::EnableCap, target), index);

    if (ANGLE_LIKELY(context != nullptr))
    {
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().drawBuffersIndexedEXT))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateDisableiEXT(context->getPrivateState(),
                                                  context->getMutableErrorSetForValidation(),
                                                  angle::EntryPoint::GLDisableiEXT, target, index);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(isCallValid || context->getPushedErrorCount() != errorCount);
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context, angle::EntryPoint::GLDisableiEXT);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            ContextPrivateDisablei(context->getMutablePrivateState(),
                                   context->getMutablePrivateStateCache(), target, index);
        }
        ANGLE_CAPTURE_GL(DisableiEXT, isCallValid, context, target, index);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLDisableiEXT);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_EnableiEXT(GLenum target, GLuint index)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLEnableiEXT, "context = %d, target = %s, index = %u", CID(context),
          GLenumToString(GLESEnum::EnableCap, target), index);

    if (ANGLE_LIKELY(context != nullptr))
    {
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().drawBuffersIndexedEXT))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateEnableiEXT(context->getPrivateState(),
                                                 context->getMutableErrorSetForValidation(),
                                                 angle::EntryPoint::GLEnableiEXT, target, index);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(isCallValid || context->getPushedErrorCount() != errorCount);
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context, angle::EntryPoint::GLEnableiEXT);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            ContextPrivateEnablei(context->getMutablePrivateState(),
                                  context->getMutablePrivateStateCache(), target, index);
        }
        ANGLE_CAPTURE_GL(EnableiEXT, isCallValid, context, target, index);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLEnableiEXT);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

GLboolean GL_APIENTRY GL_IsEnablediEXT(GLenum target, GLuint index)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLIsEnablediEXT, "context = %d, target = %s, index = %u", CID(context),
          GLenumToString(GLESEnum::EnableCap, target), index);

    GLboolean returnValue;
    if (ANGLE_LIKELY(context != nullptr))
    {
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().drawBuffersIndexedEXT))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateIsEnablediEXT(
                    context->getPrivateState(), context->getMutableErrorSetForValidation(),
                    angle::EntryPoint::GLIsEnablediEXT, target, index);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(isCallValid || context->getPushedErrorCount() != errorCount);
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context, angle::EntryPoint::GLIsEnablediEXT);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            returnValue =
                ContextPrivateIsEnabledi(context->getMutablePrivateState(),
                                         context->getMutablePrivateStateCache(), target, index);
        }
        else
        {
            returnValue = GetDefaultReturnValue<angle::EntryPoint::GLIsEnablediEXT, GLboolean>();
        }
        ANGLE_CAPTURE_GL(IsEnablediEXT, isCallValid, context, target, index, returnValue);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLIsEnablediEXT);
        returnValue = GetDefaultReturnValue<angle::EntryPoint::GLIsEnablediEXT, GLboolean>();
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    return returnValue;
}

// GL_EXT_draw_elements_base_vertex
void GL_APIENTRY GL_DrawElementsBaseVertexEXT(GLenum mode,
                                              GLsizei count,
                                              GLenum type,
                                              const void *indices,
                                              GLint basevertex)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLDrawElementsBaseVertexEXT,
          "context = %d, mode = %s, count = %d, type = %s, indices = 0x%016" PRIxPTR
          ", basevertex = %d",
          CID(context), GLenumToString(GLESEnum::PrimitiveType, mode), count,
          GLenumToString(GLESEnum::DrawElementsType, type), (uintptr_t)indices, basevertex);

    if (ANGLE_LIKELY(context != nullptr))
    {
        PrimitiveMode modePacked    = PackParam<PrimitiveMode>(mode);
        DrawElementsType typePacked = PackParam<DrawElementsType>(type);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().drawElementsBaseVertexEXT))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateDrawElementsBaseVertexEXT(
                    context, angle::EntryPoint::GLDrawElementsBaseVertexEXT, modePacked, count,
                    typePacked, indices, basevertex);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context, angle::EntryPoint::GLDrawElementsBaseVertexEXT);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->drawElementsBaseVertex(modePacked, count, typePacked, indices, basevertex);
        }
        ANGLE_CAPTURE_GL(DrawElementsBaseVertexEXT, isCallValid, context, modePacked, count,
                         typePacked, indices, basevertex);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(
            angle::EntryPoint::GLDrawElementsBaseVertexEXT);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_DrawElementsInstancedBaseVertexEXT(GLenum mode,
                                                       GLsizei count,
                                                       GLenum type,
                                                       const void *indices,
                                                       GLsizei instancecount,
                                                       GLint basevertex)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLDrawElementsInstancedBaseVertexEXT,
          "context = %d, mode = %s, count = %d, type = %s, indices = 0x%016" PRIxPTR
          ", instancecount = %d, basevertex = %d",
          CID(context), GLenumToString(GLESEnum::PrimitiveType, mode), count,
          GLenumToString(GLESEnum::DrawElementsType, type), (uintptr_t)indices, instancecount,
          basevertex);

    if (ANGLE_LIKELY(context != nullptr))
    {
        PrimitiveMode modePacked    = PackParam<PrimitiveMode>(mode);
        DrawElementsType typePacked = PackParam<DrawElementsType>(type);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().drawElementsBaseVertexEXT))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateDrawElementsInstancedBaseVertexEXT(
                    context, angle::EntryPoint::GLDrawElementsInstancedBaseVertexEXT, modePacked,
                    count, typePacked, indices, instancecount, basevertex);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context,
                                        angle::EntryPoint::GLDrawElementsInstancedBaseVertexEXT);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->drawElementsInstancedBaseVertex(modePacked, count, typePacked, indices,
                                                     instancecount, basevertex);
        }
        ANGLE_CAPTURE_GL(DrawElementsInstancedBaseVertexEXT, isCallValid, context, modePacked,
                         count, typePacked, indices, instancecount, basevertex);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(
            angle::EntryPoint::GLDrawElementsInstancedBaseVertexEXT);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_DrawRangeElementsBaseVertexEXT(GLenum mode,
                                                   GLuint start,
                                                   GLuint end,
                                                   GLsizei count,
                                                   GLenum type,
                                                   const void *indices,
                                                   GLint basevertex)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLDrawRangeElementsBaseVertexEXT,
          "context = %d, mode = %s, start = %u, end = %u, count = %d, type = %s, indices = "
          "0x%016" PRIxPTR ", basevertex = %d",
          CID(context), GLenumToString(GLESEnum::PrimitiveType, mode), start, end, count,
          GLenumToString(GLESEnum::DrawElementsType, type), (uintptr_t)indices, basevertex);

    if (ANGLE_LIKELY(context != nullptr))
    {
        PrimitiveMode modePacked    = PackParam<PrimitiveMode>(mode);
        DrawElementsType typePacked = PackParam<DrawElementsType>(type);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().drawElementsBaseVertexEXT))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateDrawRangeElementsBaseVertexEXT(
                    context, angle::EntryPoint::GLDrawRangeElementsBaseVertexEXT, modePacked, start,
                    end, count, typePacked, indices, basevertex);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context,
                                        angle::EntryPoint::GLDrawRangeElementsBaseVertexEXT);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->drawRangeElementsBaseVertex(modePacked, start, end, count, typePacked, indices,
                                                 basevertex);
        }
        ANGLE_CAPTURE_GL(DrawRangeElementsBaseVertexEXT, isCallValid, context, modePacked, start,
                         end, count, typePacked, indices, basevertex);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(
            angle::EntryPoint::GLDrawRangeElementsBaseVertexEXT);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_MultiDrawElementsBaseVertexEXT(GLenum mode,
                                                   const GLsizei *count,
                                                   GLenum type,
                                                   const void *const *indices,
                                                   GLsizei drawcount,
                                                   const GLint *basevertex)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLMultiDrawElementsBaseVertexEXT,
          "context = %d, mode = %s, count = 0x%016" PRIxPTR ", type = %s, indices = 0x%016" PRIxPTR
          ", drawcount = %d, basevertex = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLESEnum::PrimitiveType, mode), (uintptr_t)count,
          GLenumToString(GLESEnum::DrawElementsType, type), (uintptr_t)indices, drawcount,
          (uintptr_t)basevertex);

    if (ANGLE_LIKELY(context != nullptr))
    {
        PrimitiveMode modePacked    = PackParam<PrimitiveMode>(mode);
        DrawElementsType typePacked = PackParam<DrawElementsType>(type);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().drawElementsBaseVertexEXT ||
                             context->getExtensions().drawElementsBaseVertexOES))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateMultiDrawElementsBaseVertexEXT(
                    context, angle::EntryPoint::GLMultiDrawElementsBaseVertexEXT, modePacked, count,
                    typePacked, indices, drawcount, basevertex);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context,
                                        angle::EntryPoint::GLMultiDrawElementsBaseVertexEXT);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->multiDrawElementsBaseVertex(modePacked, count, typePacked, indices, drawcount,
                                                 basevertex);
        }
        ANGLE_CAPTURE_GL(MultiDrawElementsBaseVertexEXT, isCallValid, context, modePacked, count,
                         typePacked, indices, drawcount, basevertex);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(
            angle::EntryPoint::GLMultiDrawElementsBaseVertexEXT);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

// GL_EXT_draw_instanced
void GL_APIENTRY GL_DrawArraysInstancedEXT(GLenum mode,
                                           GLint start,
                                           GLsizei count,
                                           GLsizei primcount)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLDrawArraysInstancedEXT,
          "context = %d, mode = %s, start = %d, count = %d, primcount = %d", CID(context),
          GLenumToString(GLESEnum::PrimitiveType, mode), start, count, primcount);

    if (ANGLE_LIKELY(context != nullptr))
    {
        PrimitiveMode modePacked = PackParam<PrimitiveMode>(mode);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().drawInstancedEXT ||
                             context->getExtensions().instancedArraysEXT))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateDrawArraysInstancedEXT(
                    context, angle::EntryPoint::GLDrawArraysInstancedEXT, modePacked, start, count,
                    primcount);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context, angle::EntryPoint::GLDrawArraysInstancedEXT);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->drawArraysInstanced(modePacked, start, count, primcount);
        }
        ANGLE_CAPTURE_GL(DrawArraysInstancedEXT, isCallValid, context, modePacked, start, count,
                         primcount);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLDrawArraysInstancedEXT);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_DrawElementsInstancedEXT(GLenum mode,
                                             GLsizei count,
                                             GLenum type,
                                             const void *indices,
                                             GLsizei primcount)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLDrawElementsInstancedEXT,
          "context = %d, mode = %s, count = %d, type = %s, indices = 0x%016" PRIxPTR
          ", primcount = %d",
          CID(context), GLenumToString(GLESEnum::PrimitiveType, mode), count,
          GLenumToString(GLESEnum::DrawElementsType, type), (uintptr_t)indices, primcount);

    if (ANGLE_LIKELY(context != nullptr))
    {
        PrimitiveMode modePacked    = PackParam<PrimitiveMode>(mode);
        DrawElementsType typePacked = PackParam<DrawElementsType>(type);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().drawInstancedEXT ||
                             context->getExtensions().instancedArraysEXT))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateDrawElementsInstancedEXT(
                    context, angle::EntryPoint::GLDrawElementsInstancedEXT, modePacked, count,
                    typePacked, indices, primcount);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context, angle::EntryPoint::GLDrawElementsInstancedEXT);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->drawElementsInstanced(modePacked, count, typePacked, indices, primcount);
        }
        ANGLE_CAPTURE_GL(DrawElementsInstancedEXT, isCallValid, context, modePacked, count,
                         typePacked, indices, primcount);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(
            angle::EntryPoint::GLDrawElementsInstancedEXT);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

// GL_EXT_external_buffer
void GL_APIENTRY GL_BufferStorageExternalEXT(GLenum target,
                                             GLintptr offset,
                                             GLsizeiptr size,
                                             GLeglClientBufferEXT clientBuffer,
                                             GLbitfield flags)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLBufferStorageExternalEXT,
          "context = %d, target = %s, offset = %llu, size = %llu, clientBuffer = 0x%016" PRIxPTR
          ", flags = %s",
          CID(context), GLenumToString(GLESEnum::AllEnums, target),
          static_cast<unsigned long long>(offset), static_cast<unsigned long long>(size),
          (uintptr_t)clientBuffer, GLbitfieldToString(GLESEnum::BufferStorageMask, flags).c_str());

    if (ANGLE_LIKELY(context != nullptr))
    {
        BufferBinding targetPacked = PackParam<BufferBinding>(target);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().externalBufferEXT))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateBufferStorageExternalEXT(
                    context, angle::EntryPoint::GLBufferStorageExternalEXT, targetPacked, offset,
                    size, clientBuffer, flags);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context, angle::EntryPoint::GLBufferStorageExternalEXT);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->bufferStorageExternal(targetPacked, offset, size, clientBuffer, flags);
        }
        ANGLE_CAPTURE_GL(BufferStorageExternalEXT, isCallValid, context, targetPacked, offset, size,
                         clientBuffer, flags);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(
            angle::EntryPoint::GLBufferStorageExternalEXT);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

// GL_EXT_float_blend

// GL_EXT_fragment_shading_rate
void GL_APIENTRY GL_FramebufferShadingRateEXT(GLenum target,
                                              GLenum attachment,
                                              GLuint texture,
                                              GLint baseLayer,
                                              GLsizei numLayers,
                                              GLsizei texelWidth,
                                              GLsizei texelHeight)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLFramebufferShadingRateEXT,
          "context = %d, target = %s, attachment = %s, texture = %u, baseLayer = %d, numLayers = "
          "%d, texelWidth = %d, texelHeight = %d",
          CID(context), GLenumToString(GLESEnum::FramebufferTarget, target),
          GLenumToString(GLESEnum::FramebufferAttachment, attachment), texture, baseLayer,
          numLayers, texelWidth, texelHeight);

    if (ANGLE_LIKELY(context != nullptr))
    {
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().fragmentShadingRateEXT))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateFramebufferShadingRateEXT(
                    context, angle::EntryPoint::GLFramebufferShadingRateEXT, target, attachment,
                    texture, baseLayer, numLayers, texelWidth, texelHeight);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context, angle::EntryPoint::GLFramebufferShadingRateEXT);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->framebufferShadingRate(target, attachment, texture, baseLayer, numLayers,
                                            texelWidth, texelHeight);
        }
        ANGLE_CAPTURE_GL(FramebufferShadingRateEXT, isCallValid, context, target, attachment,
                         texture, baseLayer, numLayers, texelWidth, texelHeight);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(
            angle::EntryPoint::GLFramebufferShadingRateEXT);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_GetFragmentShadingRatesEXT(GLsizei samples,
                                               GLsizei maxCount,
                                               GLsizei *count,
                                               GLenum *shadingRates)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLGetFragmentShadingRatesEXT,
          "context = %d, samples = %d, maxCount = %d, count = 0x%016" PRIxPTR
          ", shadingRates = 0x%016" PRIxPTR "",
          CID(context), samples, maxCount, (uintptr_t)count, (uintptr_t)shadingRates);

    if (ANGLE_LIKELY(context != nullptr))
    {
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().fragmentShadingRateEXT))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateGetFragmentShadingRatesEXT(
                    context, angle::EntryPoint::GLGetFragmentShadingRatesEXT, samples, maxCount,
                    count, shadingRates);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context, angle::EntryPoint::GLGetFragmentShadingRatesEXT);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->getFragmentShadingRates(samples, maxCount, count, shadingRates);
        }
        ANGLE_CAPTURE_GL(GetFragmentShadingRatesEXT, isCallValid, context, samples, maxCount, count,
                         shadingRates);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(
            angle::EntryPoint::GLGetFragmentShadingRatesEXT);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_ShadingRateEXT(GLenum rate)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLShadingRateEXT, "context = %d, rate = %s", CID(context),
          GLenumToString(GLESEnum::ShadingRate, rate));

    if (ANGLE_LIKELY(context != nullptr))
    {
        ShadingRate ratePacked = PackParam<ShadingRate>(rate);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().fragmentShadingRateEXT))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateShadingRateEXT(
                    context->getPrivateState(), context->getMutableErrorSetForValidation(),
                    angle::EntryPoint::GLShadingRateEXT, ratePacked);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(isCallValid || context->getPushedErrorCount() != errorCount);
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context, angle::EntryPoint::GLShadingRateEXT);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            ContextPrivateShadingRateEXT(context->getMutablePrivateState(),
                                         context->getMutablePrivateStateCache(), ratePacked);
        }
        ANGLE_CAPTURE_GL(ShadingRateEXT, isCallValid, context, ratePacked);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLShadingRateEXT);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_ShadingRateCombinerOpsEXT(GLenum combinerOp0, GLenum combinerOp1)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLShadingRateCombinerOpsEXT, "context = %d, combinerOp0 = %s, combinerOp1 = %s",
          CID(context), GLenumToString(GLESEnum::ShadingRateCombinerOp, combinerOp0),
          GLenumToString(GLESEnum::ShadingRateCombinerOp, combinerOp1));

    if (ANGLE_LIKELY(context != nullptr))
    {
        CombinerOp combinerOp0Packed = PackParam<CombinerOp>(combinerOp0);
        CombinerOp combinerOp1Packed = PackParam<CombinerOp>(combinerOp1);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().fragmentShadingRateEXT))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateShadingRateCombinerOpsEXT(
                    context->getPrivateState(), context->getMutableErrorSetForValidation(),
                    angle::EntryPoint::GLShadingRateCombinerOpsEXT, combinerOp0Packed,
                    combinerOp1Packed);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(isCallValid || context->getPushedErrorCount() != errorCount);
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context, angle::EntryPoint::GLShadingRateCombinerOpsEXT);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            ContextPrivateShadingRateCombinerOps(context->getMutablePrivateState(),
                                                 context->getMutablePrivateStateCache(),
                                                 combinerOp0Packed, combinerOp1Packed);
        }
        ANGLE_CAPTURE_GL(ShadingRateCombinerOpsEXT, isCallValid, context, combinerOp0Packed,
                         combinerOp1Packed);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(
            angle::EntryPoint::GLShadingRateCombinerOpsEXT);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

// GL_EXT_geometry_shader
void GL_APIENTRY GL_FramebufferTextureEXT(GLenum target,
                                          GLenum attachment,
                                          GLuint texture,
                                          GLint level)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLFramebufferTextureEXT,
          "context = %d, target = %s, attachment = %s, texture = %u, level = %d", CID(context),
          GLenumToString(GLESEnum::FramebufferTarget, target),
          GLenumToString(GLESEnum::FramebufferAttachment, attachment), texture, level);

    if (ANGLE_LIKELY(context != nullptr))
    {
        TextureID texturePacked = PackParam<TextureID>(texture);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        if (context->getState().getPixelLocalStorageActivePlanes() != 0)
        {
            context->endPixelLocalStorageImplicit();
        }
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().geometryShaderEXT))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateFramebufferTextureEXT(
                    context, angle::EntryPoint::GLFramebufferTextureEXT, target, attachment,
                    texturePacked, level);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context, angle::EntryPoint::GLFramebufferTextureEXT);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->framebufferTexture(target, attachment, texturePacked, level);
        }
        ANGLE_CAPTURE_GL(FramebufferTextureEXT, isCallValid, context, target, attachment,
                         texturePacked, level);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLFramebufferTextureEXT);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

// GL_EXT_gpu_shader5

// GL_EXT_instanced_arrays
void GL_APIENTRY GL_VertexAttribDivisorEXT(GLuint index, GLuint divisor)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLVertexAttribDivisorEXT, "context = %d, index = %u, divisor = %u", CID(context),
          index, divisor);

    if (ANGLE_LIKELY(context != nullptr))
    {
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().instancedArraysEXT))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateVertexAttribDivisorEXT(
                    context->getPrivateState(), context->getMutableErrorSetForValidation(),
                    angle::EntryPoint::GLVertexAttribDivisorEXT, index, divisor);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(isCallValid || context->getPushedErrorCount() != errorCount);
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context, angle::EntryPoint::GLVertexAttribDivisorEXT);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            ContextPrivateVertexAttribDivisor(context->getMutablePrivateState(),
                                              context->getMutablePrivateStateCache(), index,
                                              divisor);
        }
        ANGLE_CAPTURE_GL(VertexAttribDivisorEXT, isCallValid, context, index, divisor);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLVertexAttribDivisorEXT);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

// DrawArraysInstancedEXT is already defined.

// DrawElementsInstancedEXT is already defined.

// GL_EXT_map_buffer_range
void GL_APIENTRY GL_FlushMappedBufferRangeEXT(GLenum target, GLintptr offset, GLsizeiptr length)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLFlushMappedBufferRangeEXT,
          "context = %d, target = %s, offset = %llu, length = %llu", CID(context),
          GLenumToString(GLESEnum::BufferTargetARB, target),
          static_cast<unsigned long long>(offset), static_cast<unsigned long long>(length));

    if (ANGLE_LIKELY(context != nullptr))
    {
        BufferBinding targetPacked = PackParam<BufferBinding>(target);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().mapBufferRangeEXT))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateFlushMappedBufferRangeEXT(
                    context, angle::EntryPoint::GLFlushMappedBufferRangeEXT, targetPacked, offset,
                    length);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context, angle::EntryPoint::GLFlushMappedBufferRangeEXT);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->flushMappedBufferRange(targetPacked, offset, length);
        }
        ANGLE_CAPTURE_GL(FlushMappedBufferRangeEXT, isCallValid, context, targetPacked, offset,
                         length);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(
            angle::EntryPoint::GLFlushMappedBufferRangeEXT);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void *GL_APIENTRY GL_MapBufferRangeEXT(GLenum target,
                                       GLintptr offset,
                                       GLsizeiptr length,
                                       GLbitfield access)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLMapBufferRangeEXT,
          "context = %d, target = %s, offset = %llu, length = %llu, access = %s", CID(context),
          GLenumToString(GLESEnum::BufferTargetARB, target),
          static_cast<unsigned long long>(offset), static_cast<unsigned long long>(length),
          GLbitfieldToString(GLESEnum::MapBufferAccessMask, access).c_str());

    void *returnValue;
    if (ANGLE_LIKELY(context != nullptr))
    {
        BufferBinding targetPacked = PackParam<BufferBinding>(target);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().mapBufferRangeEXT))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid =
                    ValidateMapBufferRangeEXT(context, angle::EntryPoint::GLMapBufferRangeEXT,
                                              targetPacked, offset, length, access);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context, angle::EntryPoint::GLMapBufferRangeEXT);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            returnValue = context->mapBufferRange(targetPacked, offset, length, access);
        }
        else
        {
            returnValue = GetDefaultReturnValue<angle::EntryPoint::GLMapBufferRangeEXT, void *>();
        }
        ANGLE_CAPTURE_GL(MapBufferRangeEXT, isCallValid, context, targetPacked, offset, length,
                         access, returnValue);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLMapBufferRangeEXT);
        returnValue = GetDefaultReturnValue<angle::EntryPoint::GLMapBufferRangeEXT, void *>();
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    return returnValue;
}

// GL_EXT_memory_object
void GL_APIENTRY GL_BufferStorageMemEXT(GLenum target,
                                        GLsizeiptr size,
                                        GLuint memory,
                                        GLuint64 offset)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLBufferStorageMemEXT,
          "context = %d, target = %s, size = %llu, memory = %u, offset = %llu", CID(context),
          GLenumToString(GLESEnum::BufferTargetARB, target), static_cast<unsigned long long>(size),
          memory, static_cast<unsigned long long>(offset));

    if (ANGLE_LIKELY(context != nullptr))
    {
        TextureType targetPacked    = PackParam<TextureType>(target);
        MemoryObjectID memoryPacked = PackParam<MemoryObjectID>(memory);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().memoryObjectEXT))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid =
                    ValidateBufferStorageMemEXT(context, angle::EntryPoint::GLBufferStorageMemEXT,
                                                targetPacked, size, memoryPacked, offset);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context, angle::EntryPoint::GLBufferStorageMemEXT);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->bufferStorageMem(targetPacked, size, memoryPacked, offset);
        }
        ANGLE_CAPTURE_GL(BufferStorageMemEXT, isCallValid, context, targetPacked, size,
                         memoryPacked, offset);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLBufferStorageMemEXT);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_CreateMemoryObjectsEXT(GLsizei n, GLuint *memoryObjects)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLCreateMemoryObjectsEXT,
          "context = %d, n = %d, memoryObjects = 0x%016" PRIxPTR "", CID(context), n,
          (uintptr_t)memoryObjects);

    if (ANGLE_LIKELY(context != nullptr))
    {
        MemoryObjectID *memoryObjectsPacked = PackParam<MemoryObjectID *>(memoryObjects);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().memoryObjectEXT))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateCreateMemoryObjectsEXT(
                    context, angle::EntryPoint::GLCreateMemoryObjectsEXT, n, memoryObjectsPacked);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context, angle::EntryPoint::GLCreateMemoryObjectsEXT);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->createMemoryObjects(n, memoryObjectsPacked);
        }
        ANGLE_CAPTURE_GL(CreateMemoryObjectsEXT, isCallValid, context, n, memoryObjectsPacked);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLCreateMemoryObjectsEXT);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_DeleteMemoryObjectsEXT(GLsizei n, const GLuint *memoryObjects)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLDeleteMemoryObjectsEXT,
          "context = %d, n = %d, memoryObjects = 0x%016" PRIxPTR "", CID(context), n,
          (uintptr_t)memoryObjects);

    if (ANGLE_LIKELY(context != nullptr))
    {
        const MemoryObjectID *memoryObjectsPacked =
            PackParam<const MemoryObjectID *>(memoryObjects);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().memoryObjectEXT))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateDeleteMemoryObjectsEXT(
                    context, angle::EntryPoint::GLDeleteMemoryObjectsEXT, n, memoryObjectsPacked);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context, angle::EntryPoint::GLDeleteMemoryObjectsEXT);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->deleteMemoryObjects(n, memoryObjectsPacked);
        }
        ANGLE_CAPTURE_GL(DeleteMemoryObjectsEXT, isCallValid, context, n, memoryObjectsPacked);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLDeleteMemoryObjectsEXT);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_GetMemoryObjectParameterivEXT(GLuint memoryObject, GLenum pname, GLint *params)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLGetMemoryObjectParameterivEXT,
          "context = %d, memoryObject = %u, pname = %s, params = 0x%016" PRIxPTR "", CID(context),
          memoryObject, GLenumToString(GLESEnum::MemoryObjectParameterName, pname),
          (uintptr_t)params);

    if (ANGLE_LIKELY(context != nullptr))
    {
        MemoryObjectID memoryObjectPacked = PackParam<MemoryObjectID>(memoryObject);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().memoryObjectEXT))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateGetMemoryObjectParameterivEXT(
                    context, angle::EntryPoint::GLGetMemoryObjectParameterivEXT, memoryObjectPacked,
                    pname, params);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context,
                                        angle::EntryPoint::GLGetMemoryObjectParameterivEXT);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->getMemoryObjectParameteriv(memoryObjectPacked, pname, params);
        }
        ANGLE_CAPTURE_GL(GetMemoryObjectParameterivEXT, isCallValid, context, memoryObjectPacked,
                         pname, params);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(
            angle::EntryPoint::GLGetMemoryObjectParameterivEXT);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_GetUnsignedBytevEXT(GLenum pname, GLubyte *data)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLGetUnsignedBytevEXT, "context = %d, pname = %s, data = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLESEnum::GetPName, pname), (uintptr_t)data);

    if (ANGLE_LIKELY(context != nullptr))
    {
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().memoryObjectEXT ||
                             context->getExtensions().semaphoreEXT))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateGetUnsignedBytevEXT(
                    context, angle::EntryPoint::GLGetUnsignedBytevEXT, pname, data);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context, angle::EntryPoint::GLGetUnsignedBytevEXT);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->getUnsignedBytev(pname, data);
        }
        ANGLE_CAPTURE_GL(GetUnsignedBytevEXT, isCallValid, context, pname, data);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLGetUnsignedBytevEXT);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_GetUnsignedBytei_vEXT(GLenum target, GLuint index, GLubyte *data)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLGetUnsignedBytei_vEXT,
          "context = %d, target = %s, index = %u, data = 0x%016" PRIxPTR "", CID(context),
          GLenumToString(GLESEnum::AllEnums, target), index, (uintptr_t)data);

    if (ANGLE_LIKELY(context != nullptr))
    {
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().memoryObjectEXT ||
                             context->getExtensions().semaphoreEXT))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateGetUnsignedBytei_vEXT(
                    context, angle::EntryPoint::GLGetUnsignedBytei_vEXT, target, index, data);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context, angle::EntryPoint::GLGetUnsignedBytei_vEXT);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->getUnsignedBytei_v(target, index, data);
        }
        ANGLE_CAPTURE_GL(GetUnsignedBytei_vEXT, isCallValid, context, target, index, data);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLGetUnsignedBytei_vEXT);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

GLboolean GL_APIENTRY GL_IsMemoryObjectEXT(GLuint memoryObject)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLIsMemoryObjectEXT, "context = %d, memoryObject = %u", CID(context),
          memoryObject);

    GLboolean returnValue;
    if (ANGLE_LIKELY(context != nullptr))
    {
        MemoryObjectID memoryObjectPacked = PackParam<MemoryObjectID>(memoryObject);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().memoryObjectEXT))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateIsMemoryObjectEXT(
                    context, angle::EntryPoint::GLIsMemoryObjectEXT, memoryObjectPacked);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context, angle::EntryPoint::GLIsMemoryObjectEXT);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            returnValue = context->isMemoryObject(memoryObjectPacked);
        }
        else
        {
            returnValue =
                GetDefaultReturnValue<angle::EntryPoint::GLIsMemoryObjectEXT, GLboolean>();
        }
        ANGLE_CAPTURE_GL(IsMemoryObjectEXT, isCallValid, context, memoryObjectPacked, returnValue);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLIsMemoryObjectEXT);
        returnValue = GetDefaultReturnValue<angle::EntryPoint::GLIsMemoryObjectEXT, GLboolean>();
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    return returnValue;
}

void GL_APIENTRY GL_MemoryObjectParameterivEXT(GLuint memoryObject,
                                               GLenum pname,
                                               const GLint *params)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLMemoryObjectParameterivEXT,
          "context = %d, memoryObject = %u, pname = %s, params = 0x%016" PRIxPTR "", CID(context),
          memoryObject, GLenumToString(GLESEnum::MemoryObjectParameterName, pname),
          (uintptr_t)params);

    if (ANGLE_LIKELY(context != nullptr))
    {
        MemoryObjectID memoryObjectPacked = PackParam<MemoryObjectID>(memoryObject);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().memoryObjectEXT))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateMemoryObjectParameterivEXT(
                    context, angle::EntryPoint::GLMemoryObjectParameterivEXT, memoryObjectPacked,
                    pname, params);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context, angle::EntryPoint::GLMemoryObjectParameterivEXT);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->memoryObjectParameteriv(memoryObjectPacked, pname, params);
        }
        ANGLE_CAPTURE_GL(MemoryObjectParameterivEXT, isCallValid, context, memoryObjectPacked,
                         pname, params);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(
            angle::EntryPoint::GLMemoryObjectParameterivEXT);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_TexStorageMem2DEXT(GLenum target,
                                       GLsizei levels,
                                       GLenum internalFormat,
                                       GLsizei width,
                                       GLsizei height,
                                       GLuint memory,
                                       GLuint64 offset)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLTexStorageMem2DEXT,
          "context = %d, target = %s, levels = %d, internalFormat = %s, width = %d, height = %d, "
          "memory = %u, offset = %llu",
          CID(context), GLenumToString(GLESEnum::TextureTarget, target), levels,
          GLenumToString(GLESEnum::SizedInternalFormat, internalFormat), width, height, memory,
          static_cast<unsigned long long>(offset));

    if (ANGLE_LIKELY(context != nullptr))
    {
        TextureType targetPacked    = PackParam<TextureType>(target);
        MemoryObjectID memoryPacked = PackParam<MemoryObjectID>(memory);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().memoryObjectEXT))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateTexStorageMem2DEXT(
                    context, angle::EntryPoint::GLTexStorageMem2DEXT, targetPacked, levels,
                    internalFormat, width, height, memoryPacked, offset);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context, angle::EntryPoint::GLTexStorageMem2DEXT);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->texStorageMem2D(targetPacked, levels, internalFormat, width, height,
                                     memoryPacked, offset);
        }
        ANGLE_CAPTURE_GL(TexStorageMem2DEXT, isCallValid, context, targetPacked, levels,
                         internalFormat, width, height, memoryPacked, offset);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLTexStorageMem2DEXT);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_TexStorageMem2DMultisampleEXT(GLenum target,
                                                  GLsizei samples,
                                                  GLenum internalFormat,
                                                  GLsizei width,
                                                  GLsizei height,
                                                  GLboolean fixedSampleLocations,
                                                  GLuint memory,
                                                  GLuint64 offset)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLTexStorageMem2DMultisampleEXT,
          "context = %d, target = %s, samples = %d, internalFormat = %s, width = %d, height = %d, "
          "fixedSampleLocations = %s, memory = %u, offset = %llu",
          CID(context), GLenumToString(GLESEnum::TextureTarget, target), samples,
          GLenumToString(GLESEnum::SizedInternalFormat, internalFormat), width, height,
          GLbooleanToString(fixedSampleLocations), memory, static_cast<unsigned long long>(offset));

    if (ANGLE_LIKELY(context != nullptr))
    {
        TextureType targetPacked    = PackParam<TextureType>(target);
        MemoryObjectID memoryPacked = PackParam<MemoryObjectID>(memory);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().memoryObjectEXT))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateTexStorageMem2DMultisampleEXT(
                    context, angle::EntryPoint::GLTexStorageMem2DMultisampleEXT, targetPacked,
                    samples, internalFormat, width, height, fixedSampleLocations, memoryPacked,
                    offset);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context,
                                        angle::EntryPoint::GLTexStorageMem2DMultisampleEXT);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->texStorageMem2DMultisample(targetPacked, samples, internalFormat, width,
                                                height, fixedSampleLocations, memoryPacked, offset);
        }
        ANGLE_CAPTURE_GL(TexStorageMem2DMultisampleEXT, isCallValid, context, targetPacked, samples,
                         internalFormat, width, height, fixedSampleLocations, memoryPacked, offset);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(
            angle::EntryPoint::GLTexStorageMem2DMultisampleEXT);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_TexStorageMem3DEXT(GLenum target,
                                       GLsizei levels,
                                       GLenum internalFormat,
                                       GLsizei width,
                                       GLsizei height,
                                       GLsizei depth,
                                       GLuint memory,
                                       GLuint64 offset)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLTexStorageMem3DEXT,
          "context = %d, target = %s, levels = %d, internalFormat = %s, width = %d, height = %d, "
          "depth = %d, memory = %u, offset = %llu",
          CID(context), GLenumToString(GLESEnum::TextureTarget, target), levels,
          GLenumToString(GLESEnum::SizedInternalFormat, internalFormat), width, height, depth,
          memory, static_cast<unsigned long long>(offset));

    if (ANGLE_LIKELY(context != nullptr))
    {
        TextureType targetPacked    = PackParam<TextureType>(target);
        MemoryObjectID memoryPacked = PackParam<MemoryObjectID>(memory);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().memoryObjectEXT))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateTexStorageMem3DEXT(
                    context, angle::EntryPoint::GLTexStorageMem3DEXT, targetPacked, levels,
                    internalFormat, width, height, depth, memoryPacked, offset);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context, angle::EntryPoint::GLTexStorageMem3DEXT);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->texStorageMem3D(targetPacked, levels, internalFormat, width, height, depth,
                                     memoryPacked, offset);
        }
        ANGLE_CAPTURE_GL(TexStorageMem3DEXT, isCallValid, context, targetPacked, levels,
                         internalFormat, width, height, depth, memoryPacked, offset);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLTexStorageMem3DEXT);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_TexStorageMem3DMultisampleEXT(GLenum target,
                                                  GLsizei samples,
                                                  GLenum internalFormat,
                                                  GLsizei width,
                                                  GLsizei height,
                                                  GLsizei depth,
                                                  GLboolean fixedSampleLocations,
                                                  GLuint memory,
                                                  GLuint64 offset)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLTexStorageMem3DMultisampleEXT,
          "context = %d, target = %s, samples = %d, internalFormat = %s, width = %d, height = %d, "
          "depth = %d, fixedSampleLocations = %s, memory = %u, offset = %llu",
          CID(context), GLenumToString(GLESEnum::TextureTarget, target), samples,
          GLenumToString(GLESEnum::SizedInternalFormat, internalFormat), width, height, depth,
          GLbooleanToString(fixedSampleLocations), memory, static_cast<unsigned long long>(offset));

    if (ANGLE_LIKELY(context != nullptr))
    {
        TextureType targetPacked    = PackParam<TextureType>(target);
        MemoryObjectID memoryPacked = PackParam<MemoryObjectID>(memory);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().memoryObjectEXT))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateTexStorageMem3DMultisampleEXT(
                    context, angle::EntryPoint::GLTexStorageMem3DMultisampleEXT, targetPacked,
                    samples, internalFormat, width, height, depth, fixedSampleLocations,
                    memoryPacked, offset);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context,
                                        angle::EntryPoint::GLTexStorageMem3DMultisampleEXT);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->texStorageMem3DMultisample(targetPacked, samples, internalFormat, width,
                                                height, depth, fixedSampleLocations, memoryPacked,
                                                offset);
        }
        ANGLE_CAPTURE_GL(TexStorageMem3DMultisampleEXT, isCallValid, context, targetPacked, samples,
                         internalFormat, width, height, depth, fixedSampleLocations, memoryPacked,
                         offset);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(
            angle::EntryPoint::GLTexStorageMem3DMultisampleEXT);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

// GL_EXT_memory_object_fd
void GL_APIENTRY GL_ImportMemoryFdEXT(GLuint memory, GLuint64 size, GLenum handleType, GLint fd)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLImportMemoryFdEXT,
          "context = %d, memory = %u, size = %llu, handleType = %s, fd = %d", CID(context), memory,
          static_cast<unsigned long long>(size),
          GLenumToString(GLESEnum::ExternalHandleType, handleType), fd);

    if (ANGLE_LIKELY(context != nullptr))
    {
        MemoryObjectID memoryPacked = PackParam<MemoryObjectID>(memory);
        HandleType handleTypePacked = PackParam<HandleType>(handleType);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().memoryObjectFdEXT))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid =
                    ValidateImportMemoryFdEXT(context, angle::EntryPoint::GLImportMemoryFdEXT,
                                              memoryPacked, size, handleTypePacked, fd);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context, angle::EntryPoint::GLImportMemoryFdEXT);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->importMemoryFd(memoryPacked, size, handleTypePacked, fd);
        }
        ANGLE_CAPTURE_GL(ImportMemoryFdEXT, isCallValid, context, memoryPacked, size,
                         handleTypePacked, fd);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLImportMemoryFdEXT);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

// GL_EXT_multi_draw_arrays
void GL_APIENTRY GL_MultiDrawArraysEXT(GLenum mode,
                                       const GLint *first,
                                       const GLsizei *count,
                                       GLsizei primcount)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLMultiDrawArraysEXT,
          "context = %d, mode = %s, first = 0x%016" PRIxPTR ", count = 0x%016" PRIxPTR
          ", primcount = %d",
          CID(context), GLenumToString(GLESEnum::PrimitiveType, mode), (uintptr_t)first,
          (uintptr_t)count, primcount);

    if (ANGLE_LIKELY(context != nullptr))
    {
        PrimitiveMode modePacked = PackParam<PrimitiveMode>(mode);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().multiDrawArraysEXT))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid =
                    ValidateMultiDrawArraysEXT(context, angle::EntryPoint::GLMultiDrawArraysEXT,
                                               modePacked, first, count, primcount);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context, angle::EntryPoint::GLMultiDrawArraysEXT);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->multiDrawArrays(modePacked, first, count, primcount);
        }
        ANGLE_CAPTURE_GL(MultiDrawArraysEXT, isCallValid, context, modePacked, first, count,
                         primcount);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLMultiDrawArraysEXT);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_MultiDrawElementsEXT(GLenum mode,
                                         const GLsizei *count,
                                         GLenum type,
                                         const void *const *indices,
                                         GLsizei primcount)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLMultiDrawElementsEXT,
          "context = %d, mode = %s, count = 0x%016" PRIxPTR ", type = %s, indices = 0x%016" PRIxPTR
          ", primcount = %d",
          CID(context), GLenumToString(GLESEnum::PrimitiveType, mode), (uintptr_t)count,
          GLenumToString(GLESEnum::DrawElementsType, type), (uintptr_t)indices, primcount);

    if (ANGLE_LIKELY(context != nullptr))
    {
        PrimitiveMode modePacked    = PackParam<PrimitiveMode>(mode);
        DrawElementsType typePacked = PackParam<DrawElementsType>(type);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().multiDrawArraysEXT))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid =
                    ValidateMultiDrawElementsEXT(context, angle::EntryPoint::GLMultiDrawElementsEXT,
                                                 modePacked, count, typePacked, indices, primcount);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context, angle::EntryPoint::GLMultiDrawElementsEXT);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->multiDrawElements(modePacked, count, typePacked, indices, primcount);
        }
        ANGLE_CAPTURE_GL(MultiDrawElementsEXT, isCallValid, context, modePacked, count, typePacked,
                         indices, primcount);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLMultiDrawElementsEXT);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

// GL_EXT_multi_draw_indirect
void GL_APIENTRY GL_MultiDrawArraysIndirectEXT(GLenum mode,
                                               const void *indirect,
                                               GLsizei drawcount,
                                               GLsizei stride)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLMultiDrawArraysIndirectEXT,
          "context = %d, mode = %s, indirect = 0x%016" PRIxPTR ", drawcount = %d, stride = %d",
          CID(context), GLenumToString(GLESEnum::PrimitiveType, mode), (uintptr_t)indirect,
          drawcount, stride);

    if (ANGLE_LIKELY(context != nullptr))
    {
        PrimitiveMode modePacked = PackParam<PrimitiveMode>(mode);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().multiDrawIndirectEXT))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateMultiDrawArraysIndirectEXT(
                    context, angle::EntryPoint::GLMultiDrawArraysIndirectEXT, modePacked, indirect,
                    drawcount, stride);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context, angle::EntryPoint::GLMultiDrawArraysIndirectEXT);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->multiDrawArraysIndirect(modePacked, indirect, drawcount, stride);
        }
        ANGLE_CAPTURE_GL(MultiDrawArraysIndirectEXT, isCallValid, context, modePacked, indirect,
                         drawcount, stride);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(
            angle::EntryPoint::GLMultiDrawArraysIndirectEXT);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_MultiDrawElementsIndirectEXT(GLenum mode,
                                                 GLenum type,
                                                 const void *indirect,
                                                 GLsizei drawcount,
                                                 GLsizei stride)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLMultiDrawElementsIndirectEXT,
          "context = %d, mode = %s, type = %s, indirect = 0x%016" PRIxPTR
          ", drawcount = %d, stride = %d",
          CID(context), GLenumToString(GLESEnum::PrimitiveType, mode),
          GLenumToString(GLESEnum::DrawElementsType, type), (uintptr_t)indirect, drawcount, stride);

    if (ANGLE_LIKELY(context != nullptr))
    {
        PrimitiveMode modePacked    = PackParam<PrimitiveMode>(mode);
        DrawElementsType typePacked = PackParam<DrawElementsType>(type);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().multiDrawIndirectEXT))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateMultiDrawElementsIndirectEXT(
                    context, angle::EntryPoint::GLMultiDrawElementsIndirectEXT, modePacked,
                    typePacked, indirect, drawcount, stride);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context, angle::EntryPoint::GLMultiDrawElementsIndirectEXT);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->multiDrawElementsIndirect(modePacked, typePacked, indirect, drawcount, stride);
        }
        ANGLE_CAPTURE_GL(MultiDrawElementsIndirectEXT, isCallValid, context, modePacked, typePacked,
                         indirect, drawcount, stride);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(
            angle::EntryPoint::GLMultiDrawElementsIndirectEXT);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

// GL_EXT_multisampled_render_to_texture
void GL_APIENTRY GL_FramebufferTexture2DMultisampleEXT(GLenum target,
                                                       GLenum attachment,
                                                       GLenum textarget,
                                                       GLuint texture,
                                                       GLint level,
                                                       GLsizei samples)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLFramebufferTexture2DMultisampleEXT,
          "context = %d, target = %s, attachment = %s, textarget = %s, texture = %u, level = %d, "
          "samples = %d",
          CID(context), GLenumToString(GLESEnum::FramebufferTarget, target),
          GLenumToString(GLESEnum::FramebufferAttachment, attachment),
          GLenumToString(GLESEnum::TextureTarget, textarget), texture, level, samples);

    if (ANGLE_LIKELY(context != nullptr))
    {
        TextureTarget textargetPacked = PackParam<TextureTarget>(textarget);
        TextureID texturePacked       = PackParam<TextureID>(texture);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        if (context->getState().getPixelLocalStorageActivePlanes() != 0)
        {
            context->endPixelLocalStorageImplicit();
        }
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().multisampledRenderToTextureEXT))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateFramebufferTexture2DMultisampleEXT(
                    context, angle::EntryPoint::GLFramebufferTexture2DMultisampleEXT, target,
                    attachment, textargetPacked, texturePacked, level, samples);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context,
                                        angle::EntryPoint::GLFramebufferTexture2DMultisampleEXT);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->framebufferTexture2DMultisample(target, attachment, textargetPacked,
                                                     texturePacked, level, samples);
        }
        ANGLE_CAPTURE_GL(FramebufferTexture2DMultisampleEXT, isCallValid, context, target,
                         attachment, textargetPacked, texturePacked, level, samples);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(
            angle::EntryPoint::GLFramebufferTexture2DMultisampleEXT);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_RenderbufferStorageMultisampleEXT(GLenum target,
                                                      GLsizei samples,
                                                      GLenum internalformat,
                                                      GLsizei width,
                                                      GLsizei height)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLRenderbufferStorageMultisampleEXT,
          "context = %d, target = %s, samples = %d, internalformat = %s, width = %d, height = %d",
          CID(context), GLenumToString(GLESEnum::RenderbufferTarget, target), samples,
          GLenumToString(GLESEnum::InternalFormat, internalformat), width, height);

    if (ANGLE_LIKELY(context != nullptr))
    {
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().multisampledRenderToTextureEXT))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateRenderbufferStorageMultisampleEXT(
                    context, angle::EntryPoint::GLRenderbufferStorageMultisampleEXT, target,
                    samples, internalformat, width, height);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context,
                                        angle::EntryPoint::GLRenderbufferStorageMultisampleEXT);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->renderbufferStorageMultisampleEXT(target, samples, internalformat, width,
                                                       height);
        }
        ANGLE_CAPTURE_GL(RenderbufferStorageMultisampleEXT, isCallValid, context, target, samples,
                         internalformat, width, height);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(
            angle::EntryPoint::GLRenderbufferStorageMultisampleEXT);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

// GL_EXT_multisampled_render_to_texture2

// GL_EXT_occlusion_query_boolean
// BeginQueryEXT is already defined.

// DeleteQueriesEXT is already defined.

// EndQueryEXT is already defined.

// GenQueriesEXT is already defined.

// GetQueryObjectuivEXT is already defined.

// GetQueryivEXT is already defined.

// IsQueryEXT is already defined.

// GL_EXT_polygon_offset_clamp
void GL_APIENTRY GL_PolygonOffsetClampEXT(GLfloat factor, GLfloat units, GLfloat clamp)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLPolygonOffsetClampEXT, "context = %d, factor = %f, units = %f, clamp = %f",
          CID(context), factor, units, clamp);

    if (ANGLE_LIKELY(context != nullptr))
    {
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().polygonOffsetClampEXT))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidatePolygonOffsetClampEXT(
                    context->getPrivateState(), context->getMutableErrorSetForValidation(),
                    angle::EntryPoint::GLPolygonOffsetClampEXT, factor, units, clamp);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(isCallValid || context->getPushedErrorCount() != errorCount);
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context, angle::EntryPoint::GLPolygonOffsetClampEXT);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            ContextPrivatePolygonOffsetClamp(context->getMutablePrivateState(),
                                             context->getMutablePrivateStateCache(), factor, units,
                                             clamp);
        }
        ANGLE_CAPTURE_GL(PolygonOffsetClampEXT, isCallValid, context, factor, units, clamp);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLPolygonOffsetClampEXT);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

// GL_EXT_primitive_bounding_box
void GL_APIENTRY GL_PrimitiveBoundingBoxEXT(GLfloat minX,
                                            GLfloat minY,
                                            GLfloat minZ,
                                            GLfloat minW,
                                            GLfloat maxX,
                                            GLfloat maxY,
                                            GLfloat maxZ,
                                            GLfloat maxW)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLPrimitiveBoundingBoxEXT,
          "context = %d, minX = %f, minY = %f, minZ = %f, minW = %f, maxX = %f, maxY = %f, maxZ = "
          "%f, maxW = %f",
          CID(context), minX, minY, minZ, minW, maxX, maxY, maxZ, maxW);

    if (ANGLE_LIKELY(context != nullptr))
    {
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().primitiveBoundingBoxEXT))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidatePrimitiveBoundingBoxEXT(
                    context->getPrivateState(), context->getMutableErrorSetForValidation(),
                    angle::EntryPoint::GLPrimitiveBoundingBoxEXT, minX, minY, minZ, minW, maxX,
                    maxY, maxZ, maxW);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(isCallValid || context->getPushedErrorCount() != errorCount);
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context, angle::EntryPoint::GLPrimitiveBoundingBoxEXT);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            ContextPrivatePrimitiveBoundingBox(context->getMutablePrivateState(),
                                               context->getMutablePrivateStateCache(), minX, minY,
                                               minZ, minW, maxX, maxY, maxZ, maxW);
        }
        ANGLE_CAPTURE_GL(PrimitiveBoundingBoxEXT, isCallValid, context, minX, minY, minZ, minW,
                         maxX, maxY, maxZ, maxW);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(
            angle::EntryPoint::GLPrimitiveBoundingBoxEXT);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

// GL_EXT_protected_textures

// GL_EXT_pvrtc_sRGB

// GL_EXT_read_format_bgra

// GL_EXT_render_snorm

// GL_EXT_robustness
GLenum GL_APIENTRY GL_GetGraphicsResetStatusEXT()
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetGlobalContext();
    EVENT(context, GLGetGraphicsResetStatusEXT, "context = %d", CID(context));

    GLenum returnValue;
    if (ANGLE_LIKELY(context != nullptr))
    {
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().robustnessEXT))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateGetGraphicsResetStatusEXT(
                    context, angle::EntryPoint::GLGetGraphicsResetStatusEXT);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context, angle::EntryPoint::GLGetGraphicsResetStatusEXT);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            returnValue = context->getGraphicsResetStatus();
        }
        else
        {
            returnValue =
                GetDefaultReturnValue<angle::EntryPoint::GLGetGraphicsResetStatusEXT, GLenum>();
        }
        ANGLE_CAPTURE_GL(GetGraphicsResetStatusEXT, isCallValid, context, returnValue);
    }
    else
    {

        returnValue =
            GetDefaultReturnValue<angle::EntryPoint::GLGetGraphicsResetStatusEXT, GLenum>();
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    return returnValue;
}

void GL_APIENTRY GL_GetnUniformfvEXT(GLuint program,
                                     GLint location,
                                     GLsizei bufSize,
                                     GLfloat *params)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLGetnUniformfvEXT,
          "context = %d, program = %u, location = %d, bufSize = %d, params = 0x%016" PRIxPTR "",
          CID(context), program, location, bufSize, (uintptr_t)params);

    if (ANGLE_LIKELY(context != nullptr))
    {
        ShaderProgramID programPacked  = PackParam<ShaderProgramID>(program);
        UniformLocation locationPacked = PackParam<UniformLocation>(location);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().robustnessEXT))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid =
                    ValidateGetnUniformfvEXT(context, angle::EntryPoint::GLGetnUniformfvEXT,
                                             programPacked, locationPacked, bufSize, params);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context, angle::EntryPoint::GLGetnUniformfvEXT);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->getnUniformfv(programPacked, locationPacked, bufSize, params);
        }
        ANGLE_CAPTURE_GL(GetnUniformfvEXT, isCallValid, context, programPacked, locationPacked,
                         bufSize, params);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLGetnUniformfvEXT);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_GetnUniformivEXT(GLuint program, GLint location, GLsizei bufSize, GLint *params)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLGetnUniformivEXT,
          "context = %d, program = %u, location = %d, bufSize = %d, params = 0x%016" PRIxPTR "",
          CID(context), program, location, bufSize, (uintptr_t)params);

    if (ANGLE_LIKELY(context != nullptr))
    {
        ShaderProgramID programPacked  = PackParam<ShaderProgramID>(program);
        UniformLocation locationPacked = PackParam<UniformLocation>(location);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().robustnessEXT))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid =
                    ValidateGetnUniformivEXT(context, angle::EntryPoint::GLGetnUniformivEXT,
                                             programPacked, locationPacked, bufSize, params);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context, angle::EntryPoint::GLGetnUniformivEXT);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->getnUniformiv(programPacked, locationPacked, bufSize, params);
        }
        ANGLE_CAPTURE_GL(GetnUniformivEXT, isCallValid, context, programPacked, locationPacked,
                         bufSize, params);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLGetnUniformivEXT);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_ReadnPixelsEXT(GLint x,
                                   GLint y,
                                   GLsizei width,
                                   GLsizei height,
                                   GLenum format,
                                   GLenum type,
                                   GLsizei bufSize,
                                   void *data)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLReadnPixelsEXT,
          "context = %d, x = %d, y = %d, width = %d, height = %d, format = %s, type = %s, bufSize "
          "= %d, data = 0x%016" PRIxPTR "",
          CID(context), x, y, width, height, GLenumToString(GLESEnum::PixelFormat, format),
          GLenumToString(GLESEnum::PixelType, type), bufSize, (uintptr_t)data);

    if (ANGLE_LIKELY(context != nullptr))
    {
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().robustnessEXT))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid =
                    ValidateReadnPixelsEXT(context, angle::EntryPoint::GLReadnPixelsEXT, x, y,
                                           width, height, format, type, bufSize, data);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context, angle::EntryPoint::GLReadnPixelsEXT);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->readnPixels(x, y, width, height, format, type, bufSize, data);
        }
        ANGLE_CAPTURE_GL(ReadnPixelsEXT, isCallValid, context, x, y, width, height, format, type,
                         bufSize, data);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLReadnPixelsEXT);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

// GL_EXT_sRGB

// GL_EXT_sRGB_write_control

// GL_EXT_semaphore
void GL_APIENTRY GL_DeleteSemaphoresEXT(GLsizei n, const GLuint *semaphores)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLDeleteSemaphoresEXT, "context = %d, n = %d, semaphores = 0x%016" PRIxPTR "",
          CID(context), n, (uintptr_t)semaphores);

    if (ANGLE_LIKELY(context != nullptr))
    {
        const SemaphoreID *semaphoresPacked = PackParam<const SemaphoreID *>(semaphores);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().semaphoreEXT))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateDeleteSemaphoresEXT(
                    context, angle::EntryPoint::GLDeleteSemaphoresEXT, n, semaphoresPacked);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context, angle::EntryPoint::GLDeleteSemaphoresEXT);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->deleteSemaphores(n, semaphoresPacked);
        }
        ANGLE_CAPTURE_GL(DeleteSemaphoresEXT, isCallValid, context, n, semaphoresPacked);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLDeleteSemaphoresEXT);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_GenSemaphoresEXT(GLsizei n, GLuint *semaphores)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLGenSemaphoresEXT, "context = %d, n = %d, semaphores = 0x%016" PRIxPTR "",
          CID(context), n, (uintptr_t)semaphores);

    if (ANGLE_LIKELY(context != nullptr))
    {
        SemaphoreID *semaphoresPacked = PackParam<SemaphoreID *>(semaphores);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().semaphoreEXT))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateGenSemaphoresEXT(
                    context, angle::EntryPoint::GLGenSemaphoresEXT, n, semaphoresPacked);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context, angle::EntryPoint::GLGenSemaphoresEXT);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->genSemaphores(n, semaphoresPacked);
        }
        ANGLE_CAPTURE_GL(GenSemaphoresEXT, isCallValid, context, n, semaphoresPacked);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLGenSemaphoresEXT);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_GetSemaphoreParameterui64vEXT(GLuint semaphore, GLenum pname, GLuint64 *params)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLGetSemaphoreParameterui64vEXT,
          "context = %d, semaphore = %u, pname = %s, params = 0x%016" PRIxPTR "", CID(context),
          semaphore, GLenumToString(GLESEnum::SemaphoreParameterName, pname), (uintptr_t)params);

    if (ANGLE_LIKELY(context != nullptr))
    {
        SemaphoreID semaphorePacked = PackParam<SemaphoreID>(semaphore);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().semaphoreEXT))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateGetSemaphoreParameterui64vEXT(
                    context, angle::EntryPoint::GLGetSemaphoreParameterui64vEXT, semaphorePacked,
                    pname, params);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context,
                                        angle::EntryPoint::GLGetSemaphoreParameterui64vEXT);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->getSemaphoreParameterui64v(semaphorePacked, pname, params);
        }
        ANGLE_CAPTURE_GL(GetSemaphoreParameterui64vEXT, isCallValid, context, semaphorePacked,
                         pname, params);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(
            angle::EntryPoint::GLGetSemaphoreParameterui64vEXT);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

GLboolean GL_APIENTRY GL_IsSemaphoreEXT(GLuint semaphore)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLIsSemaphoreEXT, "context = %d, semaphore = %u", CID(context), semaphore);

    GLboolean returnValue;
    if (ANGLE_LIKELY(context != nullptr))
    {
        SemaphoreID semaphorePacked = PackParam<SemaphoreID>(semaphore);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().semaphoreEXT))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateIsSemaphoreEXT(context, angle::EntryPoint::GLIsSemaphoreEXT,
                                                     semaphorePacked);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context, angle::EntryPoint::GLIsSemaphoreEXT);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            returnValue = context->isSemaphore(semaphorePacked);
        }
        else
        {
            returnValue = GetDefaultReturnValue<angle::EntryPoint::GLIsSemaphoreEXT, GLboolean>();
        }
        ANGLE_CAPTURE_GL(IsSemaphoreEXT, isCallValid, context, semaphorePacked, returnValue);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLIsSemaphoreEXT);
        returnValue = GetDefaultReturnValue<angle::EntryPoint::GLIsSemaphoreEXT, GLboolean>();
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    return returnValue;
}

void GL_APIENTRY GL_SemaphoreParameterui64vEXT(GLuint semaphore,
                                               GLenum pname,
                                               const GLuint64 *params)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLSemaphoreParameterui64vEXT,
          "context = %d, semaphore = %u, pname = %s, params = 0x%016" PRIxPTR "", CID(context),
          semaphore, GLenumToString(GLESEnum::SemaphoreParameterName, pname), (uintptr_t)params);

    if (ANGLE_LIKELY(context != nullptr))
    {
        SemaphoreID semaphorePacked = PackParam<SemaphoreID>(semaphore);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().semaphoreEXT))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateSemaphoreParameterui64vEXT(
                    context, angle::EntryPoint::GLSemaphoreParameterui64vEXT, semaphorePacked,
                    pname, params);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context, angle::EntryPoint::GLSemaphoreParameterui64vEXT);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->semaphoreParameterui64v(semaphorePacked, pname, params);
        }
        ANGLE_CAPTURE_GL(SemaphoreParameterui64vEXT, isCallValid, context, semaphorePacked, pname,
                         params);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(
            angle::EntryPoint::GLSemaphoreParameterui64vEXT);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_SignalSemaphoreEXT(GLuint semaphore,
                                       GLuint numBufferBarriers,
                                       const GLuint *buffers,
                                       GLuint numTextureBarriers,
                                       const GLuint *textures,
                                       const GLenum *dstLayouts)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLSignalSemaphoreEXT,
          "context = %d, semaphore = %u, numBufferBarriers = %u, buffers = 0x%016" PRIxPTR
          ", numTextureBarriers = %u, textures = 0x%016" PRIxPTR ", dstLayouts = 0x%016" PRIxPTR "",
          CID(context), semaphore, numBufferBarriers, (uintptr_t)buffers, numTextureBarriers,
          (uintptr_t)textures, (uintptr_t)dstLayouts);

    if (ANGLE_LIKELY(context != nullptr))
    {
        SemaphoreID semaphorePacked     = PackParam<SemaphoreID>(semaphore);
        const BufferID *buffersPacked   = PackParam<const BufferID *>(buffers);
        const TextureID *texturesPacked = PackParam<const TextureID *>(textures);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().semaphoreEXT))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid =
                    ValidateSignalSemaphoreEXT(context, angle::EntryPoint::GLSignalSemaphoreEXT,
                                               semaphorePacked, numBufferBarriers, buffersPacked,
                                               numTextureBarriers, texturesPacked, dstLayouts);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context, angle::EntryPoint::GLSignalSemaphoreEXT);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->signalSemaphore(semaphorePacked, numBufferBarriers, buffersPacked,
                                     numTextureBarriers, texturesPacked, dstLayouts);
        }
        ANGLE_CAPTURE_GL(SignalSemaphoreEXT, isCallValid, context, semaphorePacked,
                         numBufferBarriers, buffersPacked, numTextureBarriers, texturesPacked,
                         dstLayouts);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLSignalSemaphoreEXT);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_WaitSemaphoreEXT(GLuint semaphore,
                                     GLuint numBufferBarriers,
                                     const GLuint *buffers,
                                     GLuint numTextureBarriers,
                                     const GLuint *textures,
                                     const GLenum *srcLayouts)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLWaitSemaphoreEXT,
          "context = %d, semaphore = %u, numBufferBarriers = %u, buffers = 0x%016" PRIxPTR
          ", numTextureBarriers = %u, textures = 0x%016" PRIxPTR ", srcLayouts = 0x%016" PRIxPTR "",
          CID(context), semaphore, numBufferBarriers, (uintptr_t)buffers, numTextureBarriers,
          (uintptr_t)textures, (uintptr_t)srcLayouts);

    if (ANGLE_LIKELY(context != nullptr))
    {
        SemaphoreID semaphorePacked     = PackParam<SemaphoreID>(semaphore);
        const BufferID *buffersPacked   = PackParam<const BufferID *>(buffers);
        const TextureID *texturesPacked = PackParam<const TextureID *>(textures);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().semaphoreEXT))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid =
                    ValidateWaitSemaphoreEXT(context, angle::EntryPoint::GLWaitSemaphoreEXT,
                                             semaphorePacked, numBufferBarriers, buffersPacked,
                                             numTextureBarriers, texturesPacked, srcLayouts);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context, angle::EntryPoint::GLWaitSemaphoreEXT);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->waitSemaphore(semaphorePacked, numBufferBarriers, buffersPacked,
                                   numTextureBarriers, texturesPacked, srcLayouts);
        }
        ANGLE_CAPTURE_GL(WaitSemaphoreEXT, isCallValid, context, semaphorePacked, numBufferBarriers,
                         buffersPacked, numTextureBarriers, texturesPacked, srcLayouts);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLWaitSemaphoreEXT);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

// GetUnsignedBytei_vEXT is already defined.

// GetUnsignedBytevEXT is already defined.

// GL_EXT_semaphore_fd
void GL_APIENTRY GL_ImportSemaphoreFdEXT(GLuint semaphore, GLenum handleType, GLint fd)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLImportSemaphoreFdEXT, "context = %d, semaphore = %u, handleType = %s, fd = %d",
          CID(context), semaphore, GLenumToString(GLESEnum::ExternalHandleType, handleType), fd);

    if (ANGLE_LIKELY(context != nullptr))
    {
        SemaphoreID semaphorePacked = PackParam<SemaphoreID>(semaphore);
        HandleType handleTypePacked = PackParam<HandleType>(handleType);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().semaphoreFdEXT))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid =
                    ValidateImportSemaphoreFdEXT(context, angle::EntryPoint::GLImportSemaphoreFdEXT,
                                                 semaphorePacked, handleTypePacked, fd);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context, angle::EntryPoint::GLImportSemaphoreFdEXT);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->importSemaphoreFd(semaphorePacked, handleTypePacked, fd);
        }
        ANGLE_CAPTURE_GL(ImportSemaphoreFdEXT, isCallValid, context, semaphorePacked,
                         handleTypePacked, fd);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLImportSemaphoreFdEXT);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

// GL_EXT_separate_depth_stencil

// GL_EXT_separate_shader_objects
void GL_APIENTRY GL_ActiveShaderProgramEXT(GLuint pipeline, GLuint program)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLActiveShaderProgramEXT, "context = %d, pipeline = %u, program = %u",
          CID(context), pipeline, program);

    if (ANGLE_LIKELY(context != nullptr))
    {
        ProgramPipelineID pipelinePacked = PackParam<ProgramPipelineID>(pipeline);
        ShaderProgramID programPacked    = PackParam<ShaderProgramID>(program);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().separateShaderObjectsEXT))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateActiveShaderProgramEXT(
                    context, angle::EntryPoint::GLActiveShaderProgramEXT, pipelinePacked,
                    programPacked);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context, angle::EntryPoint::GLActiveShaderProgramEXT);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->activeShaderProgram(pipelinePacked, programPacked);
        }
        ANGLE_CAPTURE_GL(ActiveShaderProgramEXT, isCallValid, context, pipelinePacked,
                         programPacked);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLActiveShaderProgramEXT);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_BindProgramPipelineEXT(GLuint pipeline)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLBindProgramPipelineEXT, "context = %d, pipeline = %u", CID(context), pipeline);

    if (ANGLE_LIKELY(context != nullptr))
    {
        ProgramPipelineID pipelinePacked = PackParam<ProgramPipelineID>(pipeline);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().separateShaderObjectsEXT))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateBindProgramPipelineEXT(
                    context, angle::EntryPoint::GLBindProgramPipelineEXT, pipelinePacked);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context, angle::EntryPoint::GLBindProgramPipelineEXT);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->bindProgramPipeline(pipelinePacked);
        }
        ANGLE_CAPTURE_GL(BindProgramPipelineEXT, isCallValid, context, pipelinePacked);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLBindProgramPipelineEXT);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

GLuint GL_APIENTRY GL_CreateShaderProgramvEXT(GLenum type,
                                              GLsizei count,
                                              const GLchar *const *strings)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLCreateShaderProgramvEXT,
          "context = %d, type = %s, count = %d, strings = 0x%016" PRIxPTR "", CID(context),
          GLenumToString(GLESEnum::ShaderType, type), count, (uintptr_t)strings);

    GLuint returnValue;
    if (ANGLE_LIKELY(context != nullptr))
    {
        ShaderType typePacked = PackParam<ShaderType>(type);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().separateShaderObjectsEXT))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateCreateShaderProgramvEXT(
                    context, angle::EntryPoint::GLCreateShaderProgramvEXT, typePacked, count,
                    strings);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context, angle::EntryPoint::GLCreateShaderProgramvEXT);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            returnValue = context->createShaderProgramv(typePacked, count, strings);
        }
        else
        {
            returnValue =
                GetDefaultReturnValue<angle::EntryPoint::GLCreateShaderProgramvEXT, GLuint>();
        }
        ANGLE_CAPTURE_GL(CreateShaderProgramvEXT, isCallValid, context, typePacked, count, strings,
                         returnValue);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(
            angle::EntryPoint::GLCreateShaderProgramvEXT);
        returnValue = GetDefaultReturnValue<angle::EntryPoint::GLCreateShaderProgramvEXT, GLuint>();
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    return returnValue;
}

void GL_APIENTRY GL_DeleteProgramPipelinesEXT(GLsizei n, const GLuint *pipelines)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLDeleteProgramPipelinesEXT,
          "context = %d, n = %d, pipelines = 0x%016" PRIxPTR "", CID(context), n,
          (uintptr_t)pipelines);

    if (ANGLE_LIKELY(context != nullptr))
    {
        const ProgramPipelineID *pipelinesPacked = PackParam<const ProgramPipelineID *>(pipelines);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().separateShaderObjectsEXT))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateDeleteProgramPipelinesEXT(
                    context, angle::EntryPoint::GLDeleteProgramPipelinesEXT, n, pipelinesPacked);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context, angle::EntryPoint::GLDeleteProgramPipelinesEXT);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->deleteProgramPipelines(n, pipelinesPacked);
        }
        ANGLE_CAPTURE_GL(DeleteProgramPipelinesEXT, isCallValid, context, n, pipelinesPacked);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(
            angle::EntryPoint::GLDeleteProgramPipelinesEXT);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_GenProgramPipelinesEXT(GLsizei n, GLuint *pipelines)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLGenProgramPipelinesEXT, "context = %d, n = %d, pipelines = 0x%016" PRIxPTR "",
          CID(context), n, (uintptr_t)pipelines);

    if (ANGLE_LIKELY(context != nullptr))
    {
        ProgramPipelineID *pipelinesPacked = PackParam<ProgramPipelineID *>(pipelines);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().separateShaderObjectsEXT))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateGenProgramPipelinesEXT(
                    context, angle::EntryPoint::GLGenProgramPipelinesEXT, n, pipelinesPacked);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context, angle::EntryPoint::GLGenProgramPipelinesEXT);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->genProgramPipelines(n, pipelinesPacked);
        }
        ANGLE_CAPTURE_GL(GenProgramPipelinesEXT, isCallValid, context, n, pipelinesPacked);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLGenProgramPipelinesEXT);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_GetProgramPipelineInfoLogEXT(GLuint pipeline,
                                                 GLsizei bufSize,
                                                 GLsizei *length,
                                                 GLchar *infoLog)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLGetProgramPipelineInfoLogEXT,
          "context = %d, pipeline = %u, bufSize = %d, length = 0x%016" PRIxPTR
          ", infoLog = 0x%016" PRIxPTR "",
          CID(context), pipeline, bufSize, (uintptr_t)length, (uintptr_t)infoLog);

    if (ANGLE_LIKELY(context != nullptr))
    {
        ProgramPipelineID pipelinePacked = PackParam<ProgramPipelineID>(pipeline);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().separateShaderObjectsEXT))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateGetProgramPipelineInfoLogEXT(
                    context, angle::EntryPoint::GLGetProgramPipelineInfoLogEXT, pipelinePacked,
                    bufSize, length, infoLog);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context, angle::EntryPoint::GLGetProgramPipelineInfoLogEXT);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->getProgramPipelineInfoLog(pipelinePacked, bufSize, length, infoLog);
        }
        ANGLE_CAPTURE_GL(GetProgramPipelineInfoLogEXT, isCallValid, context, pipelinePacked,
                         bufSize, length, infoLog);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(
            angle::EntryPoint::GLGetProgramPipelineInfoLogEXT);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_GetProgramPipelineivEXT(GLuint pipeline, GLenum pname, GLint *params)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLGetProgramPipelineivEXT,
          "context = %d, pipeline = %u, pname = %s, params = 0x%016" PRIxPTR "", CID(context),
          pipeline, GLenumToString(GLESEnum::PipelineParameterName, pname), (uintptr_t)params);

    if (ANGLE_LIKELY(context != nullptr))
    {
        ProgramPipelineID pipelinePacked = PackParam<ProgramPipelineID>(pipeline);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().separateShaderObjectsEXT))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateGetProgramPipelineivEXT(
                    context, angle::EntryPoint::GLGetProgramPipelineivEXT, pipelinePacked, pname,
                    params);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context, angle::EntryPoint::GLGetProgramPipelineivEXT);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->getProgramPipelineiv(pipelinePacked, pname, params);
        }
        ANGLE_CAPTURE_GL(GetProgramPipelineivEXT, isCallValid, context, pipelinePacked, pname,
                         params);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(
            angle::EntryPoint::GLGetProgramPipelineivEXT);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

GLboolean GL_APIENTRY GL_IsProgramPipelineEXT(GLuint pipeline)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLIsProgramPipelineEXT, "context = %d, pipeline = %u", CID(context), pipeline);

    GLboolean returnValue;
    if (ANGLE_LIKELY(context != nullptr))
    {
        ProgramPipelineID pipelinePacked = PackParam<ProgramPipelineID>(pipeline);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().separateShaderObjectsEXT))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateIsProgramPipelineEXT(
                    context, angle::EntryPoint::GLIsProgramPipelineEXT, pipelinePacked);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context, angle::EntryPoint::GLIsProgramPipelineEXT);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            returnValue = context->isProgramPipeline(pipelinePacked);
        }
        else
        {
            returnValue =
                GetDefaultReturnValue<angle::EntryPoint::GLIsProgramPipelineEXT, GLboolean>();
        }
        ANGLE_CAPTURE_GL(IsProgramPipelineEXT, isCallValid, context, pipelinePacked, returnValue);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLIsProgramPipelineEXT);
        returnValue = GetDefaultReturnValue<angle::EntryPoint::GLIsProgramPipelineEXT, GLboolean>();
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    return returnValue;
}

void GL_APIENTRY GL_ProgramParameteriEXT(GLuint program, GLenum pname, GLint value)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLProgramParameteriEXT, "context = %d, program = %u, pname = %s, value = %d",
          CID(context), program, GLenumToString(GLESEnum::ProgramParameterPName, pname), value);

    if (ANGLE_LIKELY(context != nullptr))
    {
        ShaderProgramID programPacked = PackParam<ShaderProgramID>(program);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().separateShaderObjectsEXT))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid =
                    ValidateProgramParameteriEXT(context, angle::EntryPoint::GLProgramParameteriEXT,
                                                 programPacked, pname, value);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context, angle::EntryPoint::GLProgramParameteriEXT);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->programParameteri(programPacked, pname, value);
        }
        ANGLE_CAPTURE_GL(ProgramParameteriEXT, isCallValid, context, programPacked, pname, value);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLProgramParameteriEXT);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_ProgramUniform1fEXT(GLuint program, GLint location, GLfloat v0)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLProgramUniform1fEXT, "context = %d, program = %u, location = %d, v0 = %f",
          CID(context), program, location, v0);

    if (ANGLE_LIKELY(context != nullptr))
    {
        ShaderProgramID programPacked  = PackParam<ShaderProgramID>(program);
        UniformLocation locationPacked = PackParam<UniformLocation>(location);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().separateShaderObjectsEXT))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid =
                    ValidateProgramUniform1fEXT(context, angle::EntryPoint::GLProgramUniform1fEXT,
                                                programPacked, locationPacked, v0);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context, angle::EntryPoint::GLProgramUniform1fEXT);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->programUniform1f(programPacked, locationPacked, v0);
        }
        ANGLE_CAPTURE_GL(ProgramUniform1fEXT, isCallValid, context, programPacked, locationPacked,
                         v0);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLProgramUniform1fEXT);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_ProgramUniform1fvEXT(GLuint program,
                                         GLint location,
                                         GLsizei count,
                                         const GLfloat *value)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLProgramUniform1fvEXT,
          "context = %d, program = %u, location = %d, count = %d, value = 0x%016" PRIxPTR "",
          CID(context), program, location, count, (uintptr_t)value);

    if (ANGLE_LIKELY(context != nullptr))
    {
        ShaderProgramID programPacked  = PackParam<ShaderProgramID>(program);
        UniformLocation locationPacked = PackParam<UniformLocation>(location);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().separateShaderObjectsEXT))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid =
                    ValidateProgramUniform1fvEXT(context, angle::EntryPoint::GLProgramUniform1fvEXT,
                                                 programPacked, locationPacked, count, value);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context, angle::EntryPoint::GLProgramUniform1fvEXT);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->programUniform1fv(programPacked, locationPacked, count, value);
        }
        ANGLE_CAPTURE_GL(ProgramUniform1fvEXT, isCallValid, context, programPacked, locationPacked,
                         count, value);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLProgramUniform1fvEXT);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_ProgramUniform1iEXT(GLuint program, GLint location, GLint v0)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLProgramUniform1iEXT, "context = %d, program = %u, location = %d, v0 = %d",
          CID(context), program, location, v0);

    if (ANGLE_LIKELY(context != nullptr))
    {
        ShaderProgramID programPacked  = PackParam<ShaderProgramID>(program);
        UniformLocation locationPacked = PackParam<UniformLocation>(location);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().separateShaderObjectsEXT))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid =
                    ValidateProgramUniform1iEXT(context, angle::EntryPoint::GLProgramUniform1iEXT,
                                                programPacked, locationPacked, v0);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context, angle::EntryPoint::GLProgramUniform1iEXT);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->programUniform1i(programPacked, locationPacked, v0);
        }
        ANGLE_CAPTURE_GL(ProgramUniform1iEXT, isCallValid, context, programPacked, locationPacked,
                         v0);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLProgramUniform1iEXT);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_ProgramUniform1ivEXT(GLuint program,
                                         GLint location,
                                         GLsizei count,
                                         const GLint *value)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLProgramUniform1ivEXT,
          "context = %d, program = %u, location = %d, count = %d, value = 0x%016" PRIxPTR "",
          CID(context), program, location, count, (uintptr_t)value);

    if (ANGLE_LIKELY(context != nullptr))
    {
        ShaderProgramID programPacked  = PackParam<ShaderProgramID>(program);
        UniformLocation locationPacked = PackParam<UniformLocation>(location);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().separateShaderObjectsEXT))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid =
                    ValidateProgramUniform1ivEXT(context, angle::EntryPoint::GLProgramUniform1ivEXT,
                                                 programPacked, locationPacked, count, value);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context, angle::EntryPoint::GLProgramUniform1ivEXT);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->programUniform1iv(programPacked, locationPacked, count, value);
        }
        ANGLE_CAPTURE_GL(ProgramUniform1ivEXT, isCallValid, context, programPacked, locationPacked,
                         count, value);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLProgramUniform1ivEXT);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_ProgramUniform1uiEXT(GLuint program, GLint location, GLuint v0)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLProgramUniform1uiEXT, "context = %d, program = %u, location = %d, v0 = %u",
          CID(context), program, location, v0);

    if (ANGLE_LIKELY(context != nullptr))
    {
        ShaderProgramID programPacked  = PackParam<ShaderProgramID>(program);
        UniformLocation locationPacked = PackParam<UniformLocation>(location);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().separateShaderObjectsEXT))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid =
                    ValidateProgramUniform1uiEXT(context, angle::EntryPoint::GLProgramUniform1uiEXT,
                                                 programPacked, locationPacked, v0);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context, angle::EntryPoint::GLProgramUniform1uiEXT);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->programUniform1ui(programPacked, locationPacked, v0);
        }
        ANGLE_CAPTURE_GL(ProgramUniform1uiEXT, isCallValid, context, programPacked, locationPacked,
                         v0);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLProgramUniform1uiEXT);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_ProgramUniform1uivEXT(GLuint program,
                                          GLint location,
                                          GLsizei count,
                                          const GLuint *value)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLProgramUniform1uivEXT,
          "context = %d, program = %u, location = %d, count = %d, value = 0x%016" PRIxPTR "",
          CID(context), program, location, count, (uintptr_t)value);

    if (ANGLE_LIKELY(context != nullptr))
    {
        ShaderProgramID programPacked  = PackParam<ShaderProgramID>(program);
        UniformLocation locationPacked = PackParam<UniformLocation>(location);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().separateShaderObjectsEXT))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateProgramUniform1uivEXT(
                    context, angle::EntryPoint::GLProgramUniform1uivEXT, programPacked,
                    locationPacked, count, value);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context, angle::EntryPoint::GLProgramUniform1uivEXT);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->programUniform1uiv(programPacked, locationPacked, count, value);
        }
        ANGLE_CAPTURE_GL(ProgramUniform1uivEXT, isCallValid, context, programPacked, locationPacked,
                         count, value);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLProgramUniform1uivEXT);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_ProgramUniform2fEXT(GLuint program, GLint location, GLfloat v0, GLfloat v1)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLProgramUniform2fEXT,
          "context = %d, program = %u, location = %d, v0 = %f, v1 = %f", CID(context), program,
          location, v0, v1);

    if (ANGLE_LIKELY(context != nullptr))
    {
        ShaderProgramID programPacked  = PackParam<ShaderProgramID>(program);
        UniformLocation locationPacked = PackParam<UniformLocation>(location);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().separateShaderObjectsEXT))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid =
                    ValidateProgramUniform2fEXT(context, angle::EntryPoint::GLProgramUniform2fEXT,
                                                programPacked, locationPacked, v0, v1);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context, angle::EntryPoint::GLProgramUniform2fEXT);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->programUniform2f(programPacked, locationPacked, v0, v1);
        }
        ANGLE_CAPTURE_GL(ProgramUniform2fEXT, isCallValid, context, programPacked, locationPacked,
                         v0, v1);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLProgramUniform2fEXT);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_ProgramUniform2fvEXT(GLuint program,
                                         GLint location,
                                         GLsizei count,
                                         const GLfloat *value)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLProgramUniform2fvEXT,
          "context = %d, program = %u, location = %d, count = %d, value = 0x%016" PRIxPTR "",
          CID(context), program, location, count, (uintptr_t)value);

    if (ANGLE_LIKELY(context != nullptr))
    {
        ShaderProgramID programPacked  = PackParam<ShaderProgramID>(program);
        UniformLocation locationPacked = PackParam<UniformLocation>(location);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().separateShaderObjectsEXT))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid =
                    ValidateProgramUniform2fvEXT(context, angle::EntryPoint::GLProgramUniform2fvEXT,
                                                 programPacked, locationPacked, count, value);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context, angle::EntryPoint::GLProgramUniform2fvEXT);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->programUniform2fv(programPacked, locationPacked, count, value);
        }
        ANGLE_CAPTURE_GL(ProgramUniform2fvEXT, isCallValid, context, programPacked, locationPacked,
                         count, value);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLProgramUniform2fvEXT);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_ProgramUniform2iEXT(GLuint program, GLint location, GLint v0, GLint v1)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLProgramUniform2iEXT,
          "context = %d, program = %u, location = %d, v0 = %d, v1 = %d", CID(context), program,
          location, v0, v1);

    if (ANGLE_LIKELY(context != nullptr))
    {
        ShaderProgramID programPacked  = PackParam<ShaderProgramID>(program);
        UniformLocation locationPacked = PackParam<UniformLocation>(location);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().separateShaderObjectsEXT))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid =
                    ValidateProgramUniform2iEXT(context, angle::EntryPoint::GLProgramUniform2iEXT,
                                                programPacked, locationPacked, v0, v1);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context, angle::EntryPoint::GLProgramUniform2iEXT);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->programUniform2i(programPacked, locationPacked, v0, v1);
        }
        ANGLE_CAPTURE_GL(ProgramUniform2iEXT, isCallValid, context, programPacked, locationPacked,
                         v0, v1);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLProgramUniform2iEXT);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_ProgramUniform2ivEXT(GLuint program,
                                         GLint location,
                                         GLsizei count,
                                         const GLint *value)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLProgramUniform2ivEXT,
          "context = %d, program = %u, location = %d, count = %d, value = 0x%016" PRIxPTR "",
          CID(context), program, location, count, (uintptr_t)value);

    if (ANGLE_LIKELY(context != nullptr))
    {
        ShaderProgramID programPacked  = PackParam<ShaderProgramID>(program);
        UniformLocation locationPacked = PackParam<UniformLocation>(location);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().separateShaderObjectsEXT))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid =
                    ValidateProgramUniform2ivEXT(context, angle::EntryPoint::GLProgramUniform2ivEXT,
                                                 programPacked, locationPacked, count, value);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context, angle::EntryPoint::GLProgramUniform2ivEXT);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->programUniform2iv(programPacked, locationPacked, count, value);
        }
        ANGLE_CAPTURE_GL(ProgramUniform2ivEXT, isCallValid, context, programPacked, locationPacked,
                         count, value);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLProgramUniform2ivEXT);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_ProgramUniform2uiEXT(GLuint program, GLint location, GLuint v0, GLuint v1)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLProgramUniform2uiEXT,
          "context = %d, program = %u, location = %d, v0 = %u, v1 = %u", CID(context), program,
          location, v0, v1);

    if (ANGLE_LIKELY(context != nullptr))
    {
        ShaderProgramID programPacked  = PackParam<ShaderProgramID>(program);
        UniformLocation locationPacked = PackParam<UniformLocation>(location);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().separateShaderObjectsEXT))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid =
                    ValidateProgramUniform2uiEXT(context, angle::EntryPoint::GLProgramUniform2uiEXT,
                                                 programPacked, locationPacked, v0, v1);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context, angle::EntryPoint::GLProgramUniform2uiEXT);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->programUniform2ui(programPacked, locationPacked, v0, v1);
        }
        ANGLE_CAPTURE_GL(ProgramUniform2uiEXT, isCallValid, context, programPacked, locationPacked,
                         v0, v1);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLProgramUniform2uiEXT);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_ProgramUniform2uivEXT(GLuint program,
                                          GLint location,
                                          GLsizei count,
                                          const GLuint *value)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLProgramUniform2uivEXT,
          "context = %d, program = %u, location = %d, count = %d, value = 0x%016" PRIxPTR "",
          CID(context), program, location, count, (uintptr_t)value);

    if (ANGLE_LIKELY(context != nullptr))
    {
        ShaderProgramID programPacked  = PackParam<ShaderProgramID>(program);
        UniformLocation locationPacked = PackParam<UniformLocation>(location);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().separateShaderObjectsEXT))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateProgramUniform2uivEXT(
                    context, angle::EntryPoint::GLProgramUniform2uivEXT, programPacked,
                    locationPacked, count, value);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context, angle::EntryPoint::GLProgramUniform2uivEXT);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->programUniform2uiv(programPacked, locationPacked, count, value);
        }
        ANGLE_CAPTURE_GL(ProgramUniform2uivEXT, isCallValid, context, programPacked, locationPacked,
                         count, value);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLProgramUniform2uivEXT);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY
GL_ProgramUniform3fEXT(GLuint program, GLint location, GLfloat v0, GLfloat v1, GLfloat v2)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLProgramUniform3fEXT,
          "context = %d, program = %u, location = %d, v0 = %f, v1 = %f, v2 = %f", CID(context),
          program, location, v0, v1, v2);

    if (ANGLE_LIKELY(context != nullptr))
    {
        ShaderProgramID programPacked  = PackParam<ShaderProgramID>(program);
        UniformLocation locationPacked = PackParam<UniformLocation>(location);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().separateShaderObjectsEXT))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid =
                    ValidateProgramUniform3fEXT(context, angle::EntryPoint::GLProgramUniform3fEXT,
                                                programPacked, locationPacked, v0, v1, v2);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context, angle::EntryPoint::GLProgramUniform3fEXT);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->programUniform3f(programPacked, locationPacked, v0, v1, v2);
        }
        ANGLE_CAPTURE_GL(ProgramUniform3fEXT, isCallValid, context, programPacked, locationPacked,
                         v0, v1, v2);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLProgramUniform3fEXT);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_ProgramUniform3fvEXT(GLuint program,
                                         GLint location,
                                         GLsizei count,
                                         const GLfloat *value)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLProgramUniform3fvEXT,
          "context = %d, program = %u, location = %d, count = %d, value = 0x%016" PRIxPTR "",
          CID(context), program, location, count, (uintptr_t)value);

    if (ANGLE_LIKELY(context != nullptr))
    {
        ShaderProgramID programPacked  = PackParam<ShaderProgramID>(program);
        UniformLocation locationPacked = PackParam<UniformLocation>(location);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().separateShaderObjectsEXT))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid =
                    ValidateProgramUniform3fvEXT(context, angle::EntryPoint::GLProgramUniform3fvEXT,
                                                 programPacked, locationPacked, count, value);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context, angle::EntryPoint::GLProgramUniform3fvEXT);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->programUniform3fv(programPacked, locationPacked, count, value);
        }
        ANGLE_CAPTURE_GL(ProgramUniform3fvEXT, isCallValid, context, programPacked, locationPacked,
                         count, value);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLProgramUniform3fvEXT);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY
GL_ProgramUniform3iEXT(GLuint program, GLint location, GLint v0, GLint v1, GLint v2)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLProgramUniform3iEXT,
          "context = %d, program = %u, location = %d, v0 = %d, v1 = %d, v2 = %d", CID(context),
          program, location, v0, v1, v2);

    if (ANGLE_LIKELY(context != nullptr))
    {
        ShaderProgramID programPacked  = PackParam<ShaderProgramID>(program);
        UniformLocation locationPacked = PackParam<UniformLocation>(location);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().separateShaderObjectsEXT))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid =
                    ValidateProgramUniform3iEXT(context, angle::EntryPoint::GLProgramUniform3iEXT,
                                                programPacked, locationPacked, v0, v1, v2);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context, angle::EntryPoint::GLProgramUniform3iEXT);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->programUniform3i(programPacked, locationPacked, v0, v1, v2);
        }
        ANGLE_CAPTURE_GL(ProgramUniform3iEXT, isCallValid, context, programPacked, locationPacked,
                         v0, v1, v2);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLProgramUniform3iEXT);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_ProgramUniform3ivEXT(GLuint program,
                                         GLint location,
                                         GLsizei count,
                                         const GLint *value)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLProgramUniform3ivEXT,
          "context = %d, program = %u, location = %d, count = %d, value = 0x%016" PRIxPTR "",
          CID(context), program, location, count, (uintptr_t)value);

    if (ANGLE_LIKELY(context != nullptr))
    {
        ShaderProgramID programPacked  = PackParam<ShaderProgramID>(program);
        UniformLocation locationPacked = PackParam<UniformLocation>(location);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().separateShaderObjectsEXT))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid =
                    ValidateProgramUniform3ivEXT(context, angle::EntryPoint::GLProgramUniform3ivEXT,
                                                 programPacked, locationPacked, count, value);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context, angle::EntryPoint::GLProgramUniform3ivEXT);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->programUniform3iv(programPacked, locationPacked, count, value);
        }
        ANGLE_CAPTURE_GL(ProgramUniform3ivEXT, isCallValid, context, programPacked, locationPacked,
                         count, value);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLProgramUniform3ivEXT);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY
GL_ProgramUniform3uiEXT(GLuint program, GLint location, GLuint v0, GLuint v1, GLuint v2)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLProgramUniform3uiEXT,
          "context = %d, program = %u, location = %d, v0 = %u, v1 = %u, v2 = %u", CID(context),
          program, location, v0, v1, v2);

    if (ANGLE_LIKELY(context != nullptr))
    {
        ShaderProgramID programPacked  = PackParam<ShaderProgramID>(program);
        UniformLocation locationPacked = PackParam<UniformLocation>(location);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().separateShaderObjectsEXT))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid =
                    ValidateProgramUniform3uiEXT(context, angle::EntryPoint::GLProgramUniform3uiEXT,
                                                 programPacked, locationPacked, v0, v1, v2);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context, angle::EntryPoint::GLProgramUniform3uiEXT);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->programUniform3ui(programPacked, locationPacked, v0, v1, v2);
        }
        ANGLE_CAPTURE_GL(ProgramUniform3uiEXT, isCallValid, context, programPacked, locationPacked,
                         v0, v1, v2);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLProgramUniform3uiEXT);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_ProgramUniform3uivEXT(GLuint program,
                                          GLint location,
                                          GLsizei count,
                                          const GLuint *value)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLProgramUniform3uivEXT,
          "context = %d, program = %u, location = %d, count = %d, value = 0x%016" PRIxPTR "",
          CID(context), program, location, count, (uintptr_t)value);

    if (ANGLE_LIKELY(context != nullptr))
    {
        ShaderProgramID programPacked  = PackParam<ShaderProgramID>(program);
        UniformLocation locationPacked = PackParam<UniformLocation>(location);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().separateShaderObjectsEXT))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateProgramUniform3uivEXT(
                    context, angle::EntryPoint::GLProgramUniform3uivEXT, programPacked,
                    locationPacked, count, value);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context, angle::EntryPoint::GLProgramUniform3uivEXT);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->programUniform3uiv(programPacked, locationPacked, count, value);
        }
        ANGLE_CAPTURE_GL(ProgramUniform3uivEXT, isCallValid, context, programPacked, locationPacked,
                         count, value);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLProgramUniform3uivEXT);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_ProgramUniform4fEXT(GLuint program,
                                        GLint location,
                                        GLfloat v0,
                                        GLfloat v1,
                                        GLfloat v2,
                                        GLfloat v3)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLProgramUniform4fEXT,
          "context = %d, program = %u, location = %d, v0 = %f, v1 = %f, v2 = %f, v3 = %f",
          CID(context), program, location, v0, v1, v2, v3);

    if (ANGLE_LIKELY(context != nullptr))
    {
        ShaderProgramID programPacked  = PackParam<ShaderProgramID>(program);
        UniformLocation locationPacked = PackParam<UniformLocation>(location);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().separateShaderObjectsEXT))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid =
                    ValidateProgramUniform4fEXT(context, angle::EntryPoint::GLProgramUniform4fEXT,
                                                programPacked, locationPacked, v0, v1, v2, v3);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context, angle::EntryPoint::GLProgramUniform4fEXT);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->programUniform4f(programPacked, locationPacked, v0, v1, v2, v3);
        }
        ANGLE_CAPTURE_GL(ProgramUniform4fEXT, isCallValid, context, programPacked, locationPacked,
                         v0, v1, v2, v3);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLProgramUniform4fEXT);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_ProgramUniform4fvEXT(GLuint program,
                                         GLint location,
                                         GLsizei count,
                                         const GLfloat *value)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLProgramUniform4fvEXT,
          "context = %d, program = %u, location = %d, count = %d, value = 0x%016" PRIxPTR "",
          CID(context), program, location, count, (uintptr_t)value);

    if (ANGLE_LIKELY(context != nullptr))
    {
        ShaderProgramID programPacked  = PackParam<ShaderProgramID>(program);
        UniformLocation locationPacked = PackParam<UniformLocation>(location);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().separateShaderObjectsEXT))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid =
                    ValidateProgramUniform4fvEXT(context, angle::EntryPoint::GLProgramUniform4fvEXT,
                                                 programPacked, locationPacked, count, value);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context, angle::EntryPoint::GLProgramUniform4fvEXT);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->programUniform4fv(programPacked, locationPacked, count, value);
        }
        ANGLE_CAPTURE_GL(ProgramUniform4fvEXT, isCallValid, context, programPacked, locationPacked,
                         count, value);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLProgramUniform4fvEXT);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY
GL_ProgramUniform4iEXT(GLuint program, GLint location, GLint v0, GLint v1, GLint v2, GLint v3)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLProgramUniform4iEXT,
          "context = %d, program = %u, location = %d, v0 = %d, v1 = %d, v2 = %d, v3 = %d",
          CID(context), program, location, v0, v1, v2, v3);

    if (ANGLE_LIKELY(context != nullptr))
    {
        ShaderProgramID programPacked  = PackParam<ShaderProgramID>(program);
        UniformLocation locationPacked = PackParam<UniformLocation>(location);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().separateShaderObjectsEXT))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid =
                    ValidateProgramUniform4iEXT(context, angle::EntryPoint::GLProgramUniform4iEXT,
                                                programPacked, locationPacked, v0, v1, v2, v3);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context, angle::EntryPoint::GLProgramUniform4iEXT);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->programUniform4i(programPacked, locationPacked, v0, v1, v2, v3);
        }
        ANGLE_CAPTURE_GL(ProgramUniform4iEXT, isCallValid, context, programPacked, locationPacked,
                         v0, v1, v2, v3);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLProgramUniform4iEXT);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_ProgramUniform4ivEXT(GLuint program,
                                         GLint location,
                                         GLsizei count,
                                         const GLint *value)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLProgramUniform4ivEXT,
          "context = %d, program = %u, location = %d, count = %d, value = 0x%016" PRIxPTR "",
          CID(context), program, location, count, (uintptr_t)value);

    if (ANGLE_LIKELY(context != nullptr))
    {
        ShaderProgramID programPacked  = PackParam<ShaderProgramID>(program);
        UniformLocation locationPacked = PackParam<UniformLocation>(location);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().separateShaderObjectsEXT))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid =
                    ValidateProgramUniform4ivEXT(context, angle::EntryPoint::GLProgramUniform4ivEXT,
                                                 programPacked, locationPacked, count, value);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context, angle::EntryPoint::GLProgramUniform4ivEXT);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->programUniform4iv(programPacked, locationPacked, count, value);
        }
        ANGLE_CAPTURE_GL(ProgramUniform4ivEXT, isCallValid, context, programPacked, locationPacked,
                         count, value);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLProgramUniform4ivEXT);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY
GL_ProgramUniform4uiEXT(GLuint program, GLint location, GLuint v0, GLuint v1, GLuint v2, GLuint v3)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLProgramUniform4uiEXT,
          "context = %d, program = %u, location = %d, v0 = %u, v1 = %u, v2 = %u, v3 = %u",
          CID(context), program, location, v0, v1, v2, v3);

    if (ANGLE_LIKELY(context != nullptr))
    {
        ShaderProgramID programPacked  = PackParam<ShaderProgramID>(program);
        UniformLocation locationPacked = PackParam<UniformLocation>(location);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().separateShaderObjectsEXT))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid =
                    ValidateProgramUniform4uiEXT(context, angle::EntryPoint::GLProgramUniform4uiEXT,
                                                 programPacked, locationPacked, v0, v1, v2, v3);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context, angle::EntryPoint::GLProgramUniform4uiEXT);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->programUniform4ui(programPacked, locationPacked, v0, v1, v2, v3);
        }
        ANGLE_CAPTURE_GL(ProgramUniform4uiEXT, isCallValid, context, programPacked, locationPacked,
                         v0, v1, v2, v3);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLProgramUniform4uiEXT);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_ProgramUniform4uivEXT(GLuint program,
                                          GLint location,
                                          GLsizei count,
                                          const GLuint *value)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLProgramUniform4uivEXT,
          "context = %d, program = %u, location = %d, count = %d, value = 0x%016" PRIxPTR "",
          CID(context), program, location, count, (uintptr_t)value);

    if (ANGLE_LIKELY(context != nullptr))
    {
        ShaderProgramID programPacked  = PackParam<ShaderProgramID>(program);
        UniformLocation locationPacked = PackParam<UniformLocation>(location);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().separateShaderObjectsEXT))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateProgramUniform4uivEXT(
                    context, angle::EntryPoint::GLProgramUniform4uivEXT, programPacked,
                    locationPacked, count, value);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context, angle::EntryPoint::GLProgramUniform4uivEXT);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->programUniform4uiv(programPacked, locationPacked, count, value);
        }
        ANGLE_CAPTURE_GL(ProgramUniform4uivEXT, isCallValid, context, programPacked, locationPacked,
                         count, value);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLProgramUniform4uivEXT);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_ProgramUniformMatrix2fvEXT(GLuint program,
                                               GLint location,
                                               GLsizei count,
                                               GLboolean transpose,
                                               const GLfloat *value)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLProgramUniformMatrix2fvEXT,
          "context = %d, program = %u, location = %d, count = %d, transpose = %s, value = "
          "0x%016" PRIxPTR "",
          CID(context), program, location, count, GLbooleanToString(transpose), (uintptr_t)value);

    if (ANGLE_LIKELY(context != nullptr))
    {
        ShaderProgramID programPacked  = PackParam<ShaderProgramID>(program);
        UniformLocation locationPacked = PackParam<UniformLocation>(location);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().separateShaderObjectsEXT))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateProgramUniformMatrix2fvEXT(
                    context, angle::EntryPoint::GLProgramUniformMatrix2fvEXT, programPacked,
                    locationPacked, count, transpose, value);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context, angle::EntryPoint::GLProgramUniformMatrix2fvEXT);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->programUniformMatrix2fv(programPacked, locationPacked, count, transpose,
                                             value);
        }
        ANGLE_CAPTURE_GL(ProgramUniformMatrix2fvEXT, isCallValid, context, programPacked,
                         locationPacked, count, transpose, value);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(
            angle::EntryPoint::GLProgramUniformMatrix2fvEXT);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_ProgramUniformMatrix2x3fvEXT(GLuint program,
                                                 GLint location,
                                                 GLsizei count,
                                                 GLboolean transpose,
                                                 const GLfloat *value)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLProgramUniformMatrix2x3fvEXT,
          "context = %d, program = %u, location = %d, count = %d, transpose = %s, value = "
          "0x%016" PRIxPTR "",
          CID(context), program, location, count, GLbooleanToString(transpose), (uintptr_t)value);

    if (ANGLE_LIKELY(context != nullptr))
    {
        ShaderProgramID programPacked  = PackParam<ShaderProgramID>(program);
        UniformLocation locationPacked = PackParam<UniformLocation>(location);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().separateShaderObjectsEXT))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateProgramUniformMatrix2x3fvEXT(
                    context, angle::EntryPoint::GLProgramUniformMatrix2x3fvEXT, programPacked,
                    locationPacked, count, transpose, value);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context, angle::EntryPoint::GLProgramUniformMatrix2x3fvEXT);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->programUniformMatrix2x3fv(programPacked, locationPacked, count, transpose,
                                               value);
        }
        ANGLE_CAPTURE_GL(ProgramUniformMatrix2x3fvEXT, isCallValid, context, programPacked,
                         locationPacked, count, transpose, value);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(
            angle::EntryPoint::GLProgramUniformMatrix2x3fvEXT);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_ProgramUniformMatrix2x4fvEXT(GLuint program,
                                                 GLint location,
                                                 GLsizei count,
                                                 GLboolean transpose,
                                                 const GLfloat *value)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLProgramUniformMatrix2x4fvEXT,
          "context = %d, program = %u, location = %d, count = %d, transpose = %s, value = "
          "0x%016" PRIxPTR "",
          CID(context), program, location, count, GLbooleanToString(transpose), (uintptr_t)value);

    if (ANGLE_LIKELY(context != nullptr))
    {
        ShaderProgramID programPacked  = PackParam<ShaderProgramID>(program);
        UniformLocation locationPacked = PackParam<UniformLocation>(location);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().separateShaderObjectsEXT))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateProgramUniformMatrix2x4fvEXT(
                    context, angle::EntryPoint::GLProgramUniformMatrix2x4fvEXT, programPacked,
                    locationPacked, count, transpose, value);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context, angle::EntryPoint::GLProgramUniformMatrix2x4fvEXT);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->programUniformMatrix2x4fv(programPacked, locationPacked, count, transpose,
                                               value);
        }
        ANGLE_CAPTURE_GL(ProgramUniformMatrix2x4fvEXT, isCallValid, context, programPacked,
                         locationPacked, count, transpose, value);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(
            angle::EntryPoint::GLProgramUniformMatrix2x4fvEXT);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_ProgramUniformMatrix3fvEXT(GLuint program,
                                               GLint location,
                                               GLsizei count,
                                               GLboolean transpose,
                                               const GLfloat *value)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLProgramUniformMatrix3fvEXT,
          "context = %d, program = %u, location = %d, count = %d, transpose = %s, value = "
          "0x%016" PRIxPTR "",
          CID(context), program, location, count, GLbooleanToString(transpose), (uintptr_t)value);

    if (ANGLE_LIKELY(context != nullptr))
    {
        ShaderProgramID programPacked  = PackParam<ShaderProgramID>(program);
        UniformLocation locationPacked = PackParam<UniformLocation>(location);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().separateShaderObjectsEXT))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateProgramUniformMatrix3fvEXT(
                    context, angle::EntryPoint::GLProgramUniformMatrix3fvEXT, programPacked,
                    locationPacked, count, transpose, value);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context, angle::EntryPoint::GLProgramUniformMatrix3fvEXT);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->programUniformMatrix3fv(programPacked, locationPacked, count, transpose,
                                             value);
        }
        ANGLE_CAPTURE_GL(ProgramUniformMatrix3fvEXT, isCallValid, context, programPacked,
                         locationPacked, count, transpose, value);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(
            angle::EntryPoint::GLProgramUniformMatrix3fvEXT);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_ProgramUniformMatrix3x2fvEXT(GLuint program,
                                                 GLint location,
                                                 GLsizei count,
                                                 GLboolean transpose,
                                                 const GLfloat *value)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLProgramUniformMatrix3x2fvEXT,
          "context = %d, program = %u, location = %d, count = %d, transpose = %s, value = "
          "0x%016" PRIxPTR "",
          CID(context), program, location, count, GLbooleanToString(transpose), (uintptr_t)value);

    if (ANGLE_LIKELY(context != nullptr))
    {
        ShaderProgramID programPacked  = PackParam<ShaderProgramID>(program);
        UniformLocation locationPacked = PackParam<UniformLocation>(location);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().separateShaderObjectsEXT))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateProgramUniformMatrix3x2fvEXT(
                    context, angle::EntryPoint::GLProgramUniformMatrix3x2fvEXT, programPacked,
                    locationPacked, count, transpose, value);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context, angle::EntryPoint::GLProgramUniformMatrix3x2fvEXT);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->programUniformMatrix3x2fv(programPacked, locationPacked, count, transpose,
                                               value);
        }
        ANGLE_CAPTURE_GL(ProgramUniformMatrix3x2fvEXT, isCallValid, context, programPacked,
                         locationPacked, count, transpose, value);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(
            angle::EntryPoint::GLProgramUniformMatrix3x2fvEXT);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_ProgramUniformMatrix3x4fvEXT(GLuint program,
                                                 GLint location,
                                                 GLsizei count,
                                                 GLboolean transpose,
                                                 const GLfloat *value)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLProgramUniformMatrix3x4fvEXT,
          "context = %d, program = %u, location = %d, count = %d, transpose = %s, value = "
          "0x%016" PRIxPTR "",
          CID(context), program, location, count, GLbooleanToString(transpose), (uintptr_t)value);

    if (ANGLE_LIKELY(context != nullptr))
    {
        ShaderProgramID programPacked  = PackParam<ShaderProgramID>(program);
        UniformLocation locationPacked = PackParam<UniformLocation>(location);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().separateShaderObjectsEXT))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateProgramUniformMatrix3x4fvEXT(
                    context, angle::EntryPoint::GLProgramUniformMatrix3x4fvEXT, programPacked,
                    locationPacked, count, transpose, value);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context, angle::EntryPoint::GLProgramUniformMatrix3x4fvEXT);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->programUniformMatrix3x4fv(programPacked, locationPacked, count, transpose,
                                               value);
        }
        ANGLE_CAPTURE_GL(ProgramUniformMatrix3x4fvEXT, isCallValid, context, programPacked,
                         locationPacked, count, transpose, value);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(
            angle::EntryPoint::GLProgramUniformMatrix3x4fvEXT);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_ProgramUniformMatrix4fvEXT(GLuint program,
                                               GLint location,
                                               GLsizei count,
                                               GLboolean transpose,
                                               const GLfloat *value)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLProgramUniformMatrix4fvEXT,
          "context = %d, program = %u, location = %d, count = %d, transpose = %s, value = "
          "0x%016" PRIxPTR "",
          CID(context), program, location, count, GLbooleanToString(transpose), (uintptr_t)value);

    if (ANGLE_LIKELY(context != nullptr))
    {
        ShaderProgramID programPacked  = PackParam<ShaderProgramID>(program);
        UniformLocation locationPacked = PackParam<UniformLocation>(location);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().separateShaderObjectsEXT))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateProgramUniformMatrix4fvEXT(
                    context, angle::EntryPoint::GLProgramUniformMatrix4fvEXT, programPacked,
                    locationPacked, count, transpose, value);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context, angle::EntryPoint::GLProgramUniformMatrix4fvEXT);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->programUniformMatrix4fv(programPacked, locationPacked, count, transpose,
                                             value);
        }
        ANGLE_CAPTURE_GL(ProgramUniformMatrix4fvEXT, isCallValid, context, programPacked,
                         locationPacked, count, transpose, value);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(
            angle::EntryPoint::GLProgramUniformMatrix4fvEXT);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_ProgramUniformMatrix4x2fvEXT(GLuint program,
                                                 GLint location,
                                                 GLsizei count,
                                                 GLboolean transpose,
                                                 const GLfloat *value)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLProgramUniformMatrix4x2fvEXT,
          "context = %d, program = %u, location = %d, count = %d, transpose = %s, value = "
          "0x%016" PRIxPTR "",
          CID(context), program, location, count, GLbooleanToString(transpose), (uintptr_t)value);

    if (ANGLE_LIKELY(context != nullptr))
    {
        ShaderProgramID programPacked  = PackParam<ShaderProgramID>(program);
        UniformLocation locationPacked = PackParam<UniformLocation>(location);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().separateShaderObjectsEXT))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateProgramUniformMatrix4x2fvEXT(
                    context, angle::EntryPoint::GLProgramUniformMatrix4x2fvEXT, programPacked,
                    locationPacked, count, transpose, value);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context, angle::EntryPoint::GLProgramUniformMatrix4x2fvEXT);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->programUniformMatrix4x2fv(programPacked, locationPacked, count, transpose,
                                               value);
        }
        ANGLE_CAPTURE_GL(ProgramUniformMatrix4x2fvEXT, isCallValid, context, programPacked,
                         locationPacked, count, transpose, value);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(
            angle::EntryPoint::GLProgramUniformMatrix4x2fvEXT);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_ProgramUniformMatrix4x3fvEXT(GLuint program,
                                                 GLint location,
                                                 GLsizei count,
                                                 GLboolean transpose,
                                                 const GLfloat *value)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLProgramUniformMatrix4x3fvEXT,
          "context = %d, program = %u, location = %d, count = %d, transpose = %s, value = "
          "0x%016" PRIxPTR "",
          CID(context), program, location, count, GLbooleanToString(transpose), (uintptr_t)value);

    if (ANGLE_LIKELY(context != nullptr))
    {
        ShaderProgramID programPacked  = PackParam<ShaderProgramID>(program);
        UniformLocation locationPacked = PackParam<UniformLocation>(location);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().separateShaderObjectsEXT))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateProgramUniformMatrix4x3fvEXT(
                    context, angle::EntryPoint::GLProgramUniformMatrix4x3fvEXT, programPacked,
                    locationPacked, count, transpose, value);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context, angle::EntryPoint::GLProgramUniformMatrix4x3fvEXT);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->programUniformMatrix4x3fv(programPacked, locationPacked, count, transpose,
                                               value);
        }
        ANGLE_CAPTURE_GL(ProgramUniformMatrix4x3fvEXT, isCallValid, context, programPacked,
                         locationPacked, count, transpose, value);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(
            angle::EntryPoint::GLProgramUniformMatrix4x3fvEXT);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_UseProgramStagesEXT(GLuint pipeline, GLbitfield stages, GLuint program)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLUseProgramStagesEXT, "context = %d, pipeline = %u, stages = %s, program = %u",
          CID(context), pipeline, GLbitfieldToString(GLESEnum::UseProgramStageMask, stages).c_str(),
          program);

    if (ANGLE_LIKELY(context != nullptr))
    {
        ProgramPipelineID pipelinePacked = PackParam<ProgramPipelineID>(pipeline);
        ShaderProgramID programPacked    = PackParam<ShaderProgramID>(program);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().separateShaderObjectsEXT))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid =
                    ValidateUseProgramStagesEXT(context, angle::EntryPoint::GLUseProgramStagesEXT,
                                                pipelinePacked, stages, programPacked);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context, angle::EntryPoint::GLUseProgramStagesEXT);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->useProgramStages(pipelinePacked, stages, programPacked);
        }
        ANGLE_CAPTURE_GL(UseProgramStagesEXT, isCallValid, context, pipelinePacked, stages,
                         programPacked);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLUseProgramStagesEXT);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_ValidateProgramPipelineEXT(GLuint pipeline)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLValidateProgramPipelineEXT, "context = %d, pipeline = %u", CID(context),
          pipeline);

    if (ANGLE_LIKELY(context != nullptr))
    {
        ProgramPipelineID pipelinePacked = PackParam<ProgramPipelineID>(pipeline);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().separateShaderObjectsEXT))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateValidateProgramPipelineEXT(
                    context, angle::EntryPoint::GLValidateProgramPipelineEXT, pipelinePacked);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context, angle::EntryPoint::GLValidateProgramPipelineEXT);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->validateProgramPipeline(pipelinePacked);
        }
        ANGLE_CAPTURE_GL(ValidateProgramPipelineEXT, isCallValid, context, pipelinePacked);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(
            angle::EntryPoint::GLValidateProgramPipelineEXT);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

// GL_EXT_shader_framebuffer_fetch

// GL_EXT_shader_framebuffer_fetch_non_coherent
void GL_APIENTRY GL_FramebufferFetchBarrierEXT()
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLFramebufferFetchBarrierEXT, "context = %d", CID(context));

    if (ANGLE_LIKELY(context != nullptr))
    {
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().shaderFramebufferFetchNonCoherentEXT))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateFramebufferFetchBarrierEXT(
                    context, angle::EntryPoint::GLFramebufferFetchBarrierEXT);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context, angle::EntryPoint::GLFramebufferFetchBarrierEXT);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->framebufferFetchBarrier();
        }
        ANGLE_CAPTURE_GL(FramebufferFetchBarrierEXT, isCallValid, context);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(
            angle::EntryPoint::GLFramebufferFetchBarrierEXT);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

// GL_EXT_shader_io_blocks

// GL_EXT_shader_non_constant_global_initializers

// GL_EXT_shader_texture_lod

// GL_EXT_shader_texture_samples

// GL_EXT_shadow_samplers

// GL_EXT_tessellation_shader
void GL_APIENTRY GL_PatchParameteriEXT(GLenum pname, GLint value)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLPatchParameteriEXT, "context = %d, pname = %s, value = %d", CID(context),
          GLenumToString(GLESEnum::PatchParameterName, pname), value);

    if (ANGLE_LIKELY(context != nullptr))
    {
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().tessellationShaderEXT))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidatePatchParameteriEXT(
                    context->getPrivateState(), context->getMutableErrorSetForValidation(),
                    angle::EntryPoint::GLPatchParameteriEXT, pname, value);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(isCallValid || context->getPushedErrorCount() != errorCount);
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context, angle::EntryPoint::GLPatchParameteriEXT);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            ContextPrivatePatchParameteri(context->getMutablePrivateState(),
                                          context->getMutablePrivateStateCache(), pname, value);
        }
        ANGLE_CAPTURE_GL(PatchParameteriEXT, isCallValid, context, pname, value);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLPatchParameteriEXT);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

// GL_EXT_texture_border_clamp
void GL_APIENTRY GL_GetSamplerParameterIivEXT(GLuint sampler, GLenum pname, GLint *params)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLGetSamplerParameterIivEXT,
          "context = %d, sampler = %u, pname = %s, params = 0x%016" PRIxPTR "", CID(context),
          sampler, GLenumToString(GLESEnum::SamplerParameterI, pname), (uintptr_t)params);

    if (ANGLE_LIKELY(context != nullptr))
    {
        SamplerID samplerPacked = PackParam<SamplerID>(sampler);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().textureBorderClampEXT))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateGetSamplerParameterIivEXT(
                    context, angle::EntryPoint::GLGetSamplerParameterIivEXT, samplerPacked, pname,
                    params);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context, angle::EntryPoint::GLGetSamplerParameterIivEXT);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->getSamplerParameterIiv(samplerPacked, pname, params);
        }
        ANGLE_CAPTURE_GL(GetSamplerParameterIivEXT, isCallValid, context, samplerPacked, pname,
                         params);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(
            angle::EntryPoint::GLGetSamplerParameterIivEXT);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_GetSamplerParameterIuivEXT(GLuint sampler, GLenum pname, GLuint *params)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLGetSamplerParameterIuivEXT,
          "context = %d, sampler = %u, pname = %s, params = 0x%016" PRIxPTR "", CID(context),
          sampler, GLenumToString(GLESEnum::SamplerParameterI, pname), (uintptr_t)params);

    if (ANGLE_LIKELY(context != nullptr))
    {
        SamplerID samplerPacked = PackParam<SamplerID>(sampler);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().textureBorderClampEXT))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateGetSamplerParameterIuivEXT(
                    context, angle::EntryPoint::GLGetSamplerParameterIuivEXT, samplerPacked, pname,
                    params);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context, angle::EntryPoint::GLGetSamplerParameterIuivEXT);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->getSamplerParameterIuiv(samplerPacked, pname, params);
        }
        ANGLE_CAPTURE_GL(GetSamplerParameterIuivEXT, isCallValid, context, samplerPacked, pname,
                         params);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(
            angle::EntryPoint::GLGetSamplerParameterIuivEXT);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_GetTexParameterIivEXT(GLenum target, GLenum pname, GLint *params)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLGetTexParameterIivEXT,
          "context = %d, target = %s, pname = %s, params = 0x%016" PRIxPTR "", CID(context),
          GLenumToString(GLESEnum::TextureTarget, target),
          GLenumToString(GLESEnum::GetTextureParameter, pname), (uintptr_t)params);

    if (ANGLE_LIKELY(context != nullptr))
    {
        TextureType targetPacked = PackParam<TextureType>(target);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().textureBorderClampEXT))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateGetTexParameterIivEXT(
                    context, angle::EntryPoint::GLGetTexParameterIivEXT, targetPacked, pname,
                    params);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context, angle::EntryPoint::GLGetTexParameterIivEXT);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->getTexParameterIiv(targetPacked, pname, params);
        }
        ANGLE_CAPTURE_GL(GetTexParameterIivEXT, isCallValid, context, targetPacked, pname, params);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLGetTexParameterIivEXT);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_GetTexParameterIuivEXT(GLenum target, GLenum pname, GLuint *params)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLGetTexParameterIuivEXT,
          "context = %d, target = %s, pname = %s, params = 0x%016" PRIxPTR "", CID(context),
          GLenumToString(GLESEnum::TextureTarget, target),
          GLenumToString(GLESEnum::GetTextureParameter, pname), (uintptr_t)params);

    if (ANGLE_LIKELY(context != nullptr))
    {
        TextureType targetPacked = PackParam<TextureType>(target);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().textureBorderClampEXT))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateGetTexParameterIuivEXT(
                    context, angle::EntryPoint::GLGetTexParameterIuivEXT, targetPacked, pname,
                    params);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context, angle::EntryPoint::GLGetTexParameterIuivEXT);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->getTexParameterIuiv(targetPacked, pname, params);
        }
        ANGLE_CAPTURE_GL(GetTexParameterIuivEXT, isCallValid, context, targetPacked, pname, params);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLGetTexParameterIuivEXT);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_SamplerParameterIivEXT(GLuint sampler, GLenum pname, const GLint *param)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLSamplerParameterIivEXT,
          "context = %d, sampler = %u, pname = %s, param = 0x%016" PRIxPTR "", CID(context),
          sampler, GLenumToString(GLESEnum::SamplerParameterI, pname), (uintptr_t)param);

    if (ANGLE_LIKELY(context != nullptr))
    {
        SamplerID samplerPacked = PackParam<SamplerID>(sampler);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().textureBorderClampEXT))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateSamplerParameterIivEXT(
                    context, angle::EntryPoint::GLSamplerParameterIivEXT, samplerPacked, pname,
                    param);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context, angle::EntryPoint::GLSamplerParameterIivEXT);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->samplerParameterIiv(samplerPacked, pname, param);
        }
        ANGLE_CAPTURE_GL(SamplerParameterIivEXT, isCallValid, context, samplerPacked, pname, param);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLSamplerParameterIivEXT);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_SamplerParameterIuivEXT(GLuint sampler, GLenum pname, const GLuint *param)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLSamplerParameterIuivEXT,
          "context = %d, sampler = %u, pname = %s, param = 0x%016" PRIxPTR "", CID(context),
          sampler, GLenumToString(GLESEnum::SamplerParameterI, pname), (uintptr_t)param);

    if (ANGLE_LIKELY(context != nullptr))
    {
        SamplerID samplerPacked = PackParam<SamplerID>(sampler);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().textureBorderClampEXT))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateSamplerParameterIuivEXT(
                    context, angle::EntryPoint::GLSamplerParameterIuivEXT, samplerPacked, pname,
                    param);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context, angle::EntryPoint::GLSamplerParameterIuivEXT);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->samplerParameterIuiv(samplerPacked, pname, param);
        }
        ANGLE_CAPTURE_GL(SamplerParameterIuivEXT, isCallValid, context, samplerPacked, pname,
                         param);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(
            angle::EntryPoint::GLSamplerParameterIuivEXT);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_TexParameterIivEXT(GLenum target, GLenum pname, const GLint *params)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLTexParameterIivEXT,
          "context = %d, target = %s, pname = %s, params = 0x%016" PRIxPTR "", CID(context),
          GLenumToString(GLESEnum::TextureTarget, target),
          GLenumToString(GLESEnum::TextureParameterName, pname), (uintptr_t)params);

    if (ANGLE_LIKELY(context != nullptr))
    {
        TextureType targetPacked = PackParam<TextureType>(target);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().textureBorderClampEXT))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateTexParameterIivEXT(
                    context, angle::EntryPoint::GLTexParameterIivEXT, targetPacked, pname, params);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context, angle::EntryPoint::GLTexParameterIivEXT);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->texParameterIiv(targetPacked, pname, params);
        }
        ANGLE_CAPTURE_GL(TexParameterIivEXT, isCallValid, context, targetPacked, pname, params);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLTexParameterIivEXT);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_TexParameterIuivEXT(GLenum target, GLenum pname, const GLuint *params)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLTexParameterIuivEXT,
          "context = %d, target = %s, pname = %s, params = 0x%016" PRIxPTR "", CID(context),
          GLenumToString(GLESEnum::TextureTarget, target),
          GLenumToString(GLESEnum::TextureParameterName, pname), (uintptr_t)params);

    if (ANGLE_LIKELY(context != nullptr))
    {
        TextureType targetPacked = PackParam<TextureType>(target);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().textureBorderClampEXT))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateTexParameterIuivEXT(
                    context, angle::EntryPoint::GLTexParameterIuivEXT, targetPacked, pname, params);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context, angle::EntryPoint::GLTexParameterIuivEXT);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->texParameterIuiv(targetPacked, pname, params);
        }
        ANGLE_CAPTURE_GL(TexParameterIuivEXT, isCallValid, context, targetPacked, pname, params);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLTexParameterIuivEXT);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

// GL_EXT_texture_buffer
void GL_APIENTRY GL_TexBufferEXT(GLenum target, GLenum internalformat, GLuint buffer)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLTexBufferEXT, "context = %d, target = %s, internalformat = %s, buffer = %u",
          CID(context), GLenumToString(GLESEnum::TextureTarget, target),
          GLenumToString(GLESEnum::SizedInternalFormat, internalformat), buffer);

    if (ANGLE_LIKELY(context != nullptr))
    {
        TextureType targetPacked = PackParam<TextureType>(target);
        BufferID bufferPacked    = PackParam<BufferID>(buffer);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().textureBufferEXT))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateTexBufferEXT(context, angle::EntryPoint::GLTexBufferEXT,
                                                   targetPacked, internalformat, bufferPacked);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context, angle::EntryPoint::GLTexBufferEXT);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->texBuffer(targetPacked, internalformat, bufferPacked);
        }
        ANGLE_CAPTURE_GL(TexBufferEXT, isCallValid, context, targetPacked, internalformat,
                         bufferPacked);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLTexBufferEXT);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_TexBufferRangeEXT(GLenum target,
                                      GLenum internalformat,
                                      GLuint buffer,
                                      GLintptr offset,
                                      GLsizeiptr size)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLTexBufferRangeEXT,
          "context = %d, target = %s, internalformat = %s, buffer = %u, offset = %llu, size = %llu",
          CID(context), GLenumToString(GLESEnum::TextureTarget, target),
          GLenumToString(GLESEnum::SizedInternalFormat, internalformat), buffer,
          static_cast<unsigned long long>(offset), static_cast<unsigned long long>(size));

    if (ANGLE_LIKELY(context != nullptr))
    {
        TextureType targetPacked = PackParam<TextureType>(target);
        BufferID bufferPacked    = PackParam<BufferID>(buffer);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().textureBufferEXT))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateTexBufferRangeEXT(
                    context, angle::EntryPoint::GLTexBufferRangeEXT, targetPacked, internalformat,
                    bufferPacked, offset, size);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context, angle::EntryPoint::GLTexBufferRangeEXT);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->texBufferRange(targetPacked, internalformat, bufferPacked, offset, size);
        }
        ANGLE_CAPTURE_GL(TexBufferRangeEXT, isCallValid, context, targetPacked, internalformat,
                         bufferPacked, offset, size);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLTexBufferRangeEXT);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

// GL_EXT_texture_compression_astc_decode_mode

// GL_EXT_texture_compression_bptc

// GL_EXT_texture_compression_dxt1

// GL_EXT_texture_compression_rgtc

// GL_EXT_texture_compression_s3tc

// GL_EXT_texture_compression_s3tc_srgb

// GL_EXT_texture_cube_map_array

// GL_EXT_texture_filter_anisotropic

// GL_EXT_texture_filter_minmax

// GL_EXT_texture_format_BGRA8888

// GL_EXT_texture_format_sRGB_override

// GL_EXT_texture_mirror_clamp_to_edge

// GL_EXT_texture_norm16

// GL_EXT_texture_query_lod

// GL_EXT_texture_rg

// GL_EXT_texture_sRGB_R8

// GL_EXT_texture_sRGB_RG8

// GL_EXT_texture_sRGB_decode

// GL_EXT_texture_shadow_lod

// GL_EXT_texture_storage
void GL_APIENTRY GL_TexStorage2DEXT(GLenum target,
                                    GLsizei levels,
                                    GLenum internalformat,
                                    GLsizei width,
                                    GLsizei height)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLTexStorage2DEXT,
          "context = %d, target = %s, levels = %d, internalformat = %s, width = %d, height = %d",
          CID(context), GLenumToString(GLESEnum::TextureTarget, target), levels,
          GLenumToString(GLESEnum::SizedInternalFormat, internalformat), width, height);

    if (ANGLE_LIKELY(context != nullptr))
    {
        TextureType targetPacked = PackParam<TextureType>(target);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().textureStorageEXT))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid =
                    ValidateTexStorage2DEXT(context, angle::EntryPoint::GLTexStorage2DEXT,
                                            targetPacked, levels, internalformat, width, height);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context, angle::EntryPoint::GLTexStorage2DEXT);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->texStorage2D(targetPacked, levels, internalformat, width, height);
        }
        ANGLE_CAPTURE_GL(TexStorage2DEXT, isCallValid, context, targetPacked, levels,
                         internalformat, width, height);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLTexStorage2DEXT);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_TexStorage3DEXT(GLenum target,
                                    GLsizei levels,
                                    GLenum internalformat,
                                    GLsizei width,
                                    GLsizei height,
                                    GLsizei depth)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLTexStorage3DEXT,
          "context = %d, target = %s, levels = %d, internalformat = %s, width = %d, height = %d, "
          "depth = %d",
          CID(context), GLenumToString(GLESEnum::TextureTarget, target), levels,
          GLenumToString(GLESEnum::SizedInternalFormat, internalformat), width, height, depth);

    if (ANGLE_LIKELY(context != nullptr))
    {
        TextureType targetPacked = PackParam<TextureType>(target);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().textureStorageEXT))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateTexStorage3DEXT(context, angle::EntryPoint::GLTexStorage3DEXT,
                                                      targetPacked, levels, internalformat, width,
                                                      height, depth);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context, angle::EntryPoint::GLTexStorage3DEXT);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->texStorage3D(targetPacked, levels, internalformat, width, height, depth);
        }
        ANGLE_CAPTURE_GL(TexStorage3DEXT, isCallValid, context, targetPacked, levels,
                         internalformat, width, height, depth);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLTexStorage3DEXT);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

// GL_EXT_texture_storage_compression
void GL_APIENTRY GL_TexStorageAttribs2DEXT(GLenum target,
                                           GLsizei levels,
                                           GLenum internalformat,
                                           GLsizei width,
                                           GLsizei height,
                                           const GLint *attrib_list)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLTexStorageAttribs2DEXT,
          "context = %d, target = %s, levels = %d, internalformat = %s, width = %d, height = %d, "
          "attrib_list = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLESEnum::TextureTarget, target), levels,
          GLenumToString(GLESEnum::SizedInternalFormat, internalformat), width, height,
          (uintptr_t)attrib_list);

    if (ANGLE_LIKELY(context != nullptr))
    {
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().textureStorageCompressionEXT))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateTexStorageAttribs2DEXT(
                    context, angle::EntryPoint::GLTexStorageAttribs2DEXT, target, levels,
                    internalformat, width, height, attrib_list);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context, angle::EntryPoint::GLTexStorageAttribs2DEXT);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->texStorageAttribs2D(target, levels, internalformat, width, height,
                                         attrib_list);
        }
        ANGLE_CAPTURE_GL(TexStorageAttribs2DEXT, isCallValid, context, target, levels,
                         internalformat, width, height, attrib_list);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLTexStorageAttribs2DEXT);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_TexStorageAttribs3DEXT(GLenum target,
                                           GLsizei levels,
                                           GLenum internalformat,
                                           GLsizei width,
                                           GLsizei height,
                                           GLsizei depth,
                                           const GLint *attrib_list)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLTexStorageAttribs3DEXT,
          "context = %d, target = %s, levels = %d, internalformat = %s, width = %d, height = %d, "
          "depth = %d, attrib_list = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLESEnum::TextureTarget, target), levels,
          GLenumToString(GLESEnum::SizedInternalFormat, internalformat), width, height, depth,
          (uintptr_t)attrib_list);

    if (ANGLE_LIKELY(context != nullptr))
    {
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().textureStorageCompressionEXT))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateTexStorageAttribs3DEXT(
                    context, angle::EntryPoint::GLTexStorageAttribs3DEXT, target, levels,
                    internalformat, width, height, depth, attrib_list);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context, angle::EntryPoint::GLTexStorageAttribs3DEXT);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->texStorageAttribs3D(target, levels, internalformat, width, height, depth,
                                         attrib_list);
        }
        ANGLE_CAPTURE_GL(TexStorageAttribs3DEXT, isCallValid, context, target, levels,
                         internalformat, width, height, depth, attrib_list);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLTexStorageAttribs3DEXT);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

// GL_EXT_texture_type_2_10_10_10_REV

// GL_EXT_unpack_subimage

// GL_IMG_texture_compression_pvrtc

// GL_IMG_texture_compression_pvrtc2

// GL_KHR_blend_equation_advanced
void GL_APIENTRY GL_BlendBarrierKHR()
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLBlendBarrierKHR, "context = %d", CID(context));

    if (ANGLE_LIKELY(context != nullptr))
    {
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().blendEquationAdvancedKHR))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid =
                    ValidateBlendBarrierKHR(context, angle::EntryPoint::GLBlendBarrierKHR);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context, angle::EntryPoint::GLBlendBarrierKHR);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->blendBarrier();
        }
        ANGLE_CAPTURE_GL(BlendBarrierKHR, isCallValid, context);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLBlendBarrierKHR);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

// GL_KHR_blend_equation_advanced_coherent

// GL_KHR_debug
void GL_APIENTRY GL_DebugMessageCallbackKHR(GLDEBUGPROCKHR callback, const void *userParam)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLDebugMessageCallbackKHR,
          "context = %d, callback = 0x%016" PRIxPTR ", userParam = 0x%016" PRIxPTR "", CID(context),
          (uintptr_t)callback, (uintptr_t)userParam);

    if (ANGLE_LIKELY(context != nullptr))
    {
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().debugKHR))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateDebugMessageCallbackKHR(
                    context, angle::EntryPoint::GLDebugMessageCallbackKHR, callback, userParam);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context, angle::EntryPoint::GLDebugMessageCallbackKHR);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->debugMessageCallback(callback, userParam);
        }
        ANGLE_CAPTURE_GL(DebugMessageCallbackKHR, isCallValid, context, callback, userParam);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(
            angle::EntryPoint::GLDebugMessageCallbackKHR);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_DebugMessageControlKHR(GLenum source,
                                           GLenum type,
                                           GLenum severity,
                                           GLsizei count,
                                           const GLuint *ids,
                                           GLboolean enabled)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLDebugMessageControlKHR,
          "context = %d, source = %s, type = %s, severity = %s, count = %d, ids = 0x%016" PRIxPTR
          ", enabled = %s",
          CID(context), GLenumToString(GLESEnum::DebugSource, source),
          GLenumToString(GLESEnum::DebugType, type),
          GLenumToString(GLESEnum::DebugSeverity, severity), count, (uintptr_t)ids,
          GLbooleanToString(enabled));

    if (ANGLE_LIKELY(context != nullptr))
    {
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().debugKHR))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateDebugMessageControlKHR(
                    context, angle::EntryPoint::GLDebugMessageControlKHR, source, type, severity,
                    count, ids, enabled);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context, angle::EntryPoint::GLDebugMessageControlKHR);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->debugMessageControl(source, type, severity, count, ids, enabled);
        }
        ANGLE_CAPTURE_GL(DebugMessageControlKHR, isCallValid, context, source, type, severity,
                         count, ids, enabled);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLDebugMessageControlKHR);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_DebugMessageInsertKHR(GLenum source,
                                          GLenum type,
                                          GLuint id,
                                          GLenum severity,
                                          GLsizei length,
                                          const GLchar *buf)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLDebugMessageInsertKHR,
          "context = %d, source = %s, type = %s, id = %u, severity = %s, length = %d, buf = "
          "0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLESEnum::DebugSource, source),
          GLenumToString(GLESEnum::DebugType, type), id,
          GLenumToString(GLESEnum::DebugSeverity, severity), length, (uintptr_t)buf);

    if (ANGLE_LIKELY(context != nullptr))
    {
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().debugKHR))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateDebugMessageInsertKHR(
                    context, angle::EntryPoint::GLDebugMessageInsertKHR, source, type, id, severity,
                    length, buf);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context, angle::EntryPoint::GLDebugMessageInsertKHR);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->debugMessageInsert(source, type, id, severity, length, buf);
        }
        ANGLE_CAPTURE_GL(DebugMessageInsertKHR, isCallValid, context, source, type, id, severity,
                         length, buf);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLDebugMessageInsertKHR);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

GLuint GL_APIENTRY GL_GetDebugMessageLogKHR(GLuint count,
                                            GLsizei bufSize,
                                            GLenum *sources,
                                            GLenum *types,
                                            GLuint *ids,
                                            GLenum *severities,
                                            GLsizei *lengths,
                                            GLchar *messageLog)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLGetDebugMessageLogKHR,
          "context = %d, count = %u, bufSize = %d, sources = 0x%016" PRIxPTR
          ", types = 0x%016" PRIxPTR ", ids = 0x%016" PRIxPTR ", severities = 0x%016" PRIxPTR
          ", lengths = 0x%016" PRIxPTR ", messageLog = 0x%016" PRIxPTR "",
          CID(context), count, bufSize, (uintptr_t)sources, (uintptr_t)types, (uintptr_t)ids,
          (uintptr_t)severities, (uintptr_t)lengths, (uintptr_t)messageLog);

    GLuint returnValue;
    if (ANGLE_LIKELY(context != nullptr))
    {
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().debugKHR))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateGetDebugMessageLogKHR(
                    context, angle::EntryPoint::GLGetDebugMessageLogKHR, count, bufSize, sources,
                    types, ids, severities, lengths, messageLog);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context, angle::EntryPoint::GLGetDebugMessageLogKHR);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            returnValue = context->getDebugMessageLog(count, bufSize, sources, types, ids,
                                                      severities, lengths, messageLog);
        }
        else
        {
            returnValue =
                GetDefaultReturnValue<angle::EntryPoint::GLGetDebugMessageLogKHR, GLuint>();
        }
        ANGLE_CAPTURE_GL(GetDebugMessageLogKHR, isCallValid, context, count, bufSize, sources,
                         types, ids, severities, lengths, messageLog, returnValue);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLGetDebugMessageLogKHR);
        returnValue = GetDefaultReturnValue<angle::EntryPoint::GLGetDebugMessageLogKHR, GLuint>();
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    return returnValue;
}

void GL_APIENTRY GL_GetObjectLabelKHR(GLenum identifier,
                                      GLuint name,
                                      GLsizei bufSize,
                                      GLsizei *length,
                                      GLchar *label)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLGetObjectLabelKHR,
          "context = %d, identifier = %s, name = %u, bufSize = %d, length = 0x%016" PRIxPTR
          ", label = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLESEnum::AllEnums, identifier), name, bufSize,
          (uintptr_t)length, (uintptr_t)label);

    if (ANGLE_LIKELY(context != nullptr))
    {
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().debugKHR))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid =
                    ValidateGetObjectLabelKHR(context, angle::EntryPoint::GLGetObjectLabelKHR,
                                              identifier, name, bufSize, length, label);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context, angle::EntryPoint::GLGetObjectLabelKHR);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->getObjectLabel(identifier, name, bufSize, length, label);
        }
        ANGLE_CAPTURE_GL(GetObjectLabelKHR, isCallValid, context, identifier, name, bufSize, length,
                         label);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLGetObjectLabelKHR);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_GetObjectPtrLabelKHR(const void *ptr,
                                         GLsizei bufSize,
                                         GLsizei *length,
                                         GLchar *label)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLGetObjectPtrLabelKHR,
          "context = %d, ptr = 0x%016" PRIxPTR ", bufSize = %d, length = 0x%016" PRIxPTR
          ", label = 0x%016" PRIxPTR "",
          CID(context), (uintptr_t)ptr, bufSize, (uintptr_t)length, (uintptr_t)label);

    if (ANGLE_LIKELY(context != nullptr))
    {
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().debugKHR))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid =
                    ValidateGetObjectPtrLabelKHR(context, angle::EntryPoint::GLGetObjectPtrLabelKHR,
                                                 ptr, bufSize, length, label);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context, angle::EntryPoint::GLGetObjectPtrLabelKHR);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->getObjectPtrLabel(ptr, bufSize, length, label);
        }
        ANGLE_CAPTURE_GL(GetObjectPtrLabelKHR, isCallValid, context, ptr, bufSize, length, label);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLGetObjectPtrLabelKHR);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_GetPointervKHR(GLenum pname, void **params)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLGetPointervKHR, "context = %d, pname = %s, params = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLESEnum::AllEnums, pname), (uintptr_t)params);

    if (ANGLE_LIKELY(context != nullptr))
    {
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().debugKHR))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateGetPointervKHR(context, angle::EntryPoint::GLGetPointervKHR,
                                                     pname, params);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context, angle::EntryPoint::GLGetPointervKHR);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->getPointerv(pname, params);
        }
        ANGLE_CAPTURE_GL(GetPointervKHR, isCallValid, context, pname, params);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLGetPointervKHR);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_ObjectLabelKHR(GLenum identifier,
                                   GLuint name,
                                   GLsizei length,
                                   const GLchar *label)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLObjectLabelKHR,
          "context = %d, identifier = %s, name = %u, length = %d, label = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLESEnum::ObjectIdentifier, identifier), name, length,
          (uintptr_t)label);

    if (ANGLE_LIKELY(context != nullptr))
    {
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().debugKHR))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateObjectLabelKHR(context, angle::EntryPoint::GLObjectLabelKHR,
                                                     identifier, name, length, label);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context, angle::EntryPoint::GLObjectLabelKHR);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->objectLabel(identifier, name, length, label);
        }
        ANGLE_CAPTURE_GL(ObjectLabelKHR, isCallValid, context, identifier, name, length, label);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLObjectLabelKHR);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_ObjectPtrLabelKHR(const void *ptr, GLsizei length, const GLchar *label)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLObjectPtrLabelKHR,
          "context = %d, ptr = 0x%016" PRIxPTR ", length = %d, label = 0x%016" PRIxPTR "",
          CID(context), (uintptr_t)ptr, length, (uintptr_t)label);

    if (ANGLE_LIKELY(context != nullptr))
    {
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().debugKHR))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateObjectPtrLabelKHR(
                    context, angle::EntryPoint::GLObjectPtrLabelKHR, ptr, length, label);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context, angle::EntryPoint::GLObjectPtrLabelKHR);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->objectPtrLabel(ptr, length, label);
        }
        ANGLE_CAPTURE_GL(ObjectPtrLabelKHR, isCallValid, context, ptr, length, label);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLObjectPtrLabelKHR);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_PopDebugGroupKHR()
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLPopDebugGroupKHR, "context = %d", CID(context));

    if (ANGLE_LIKELY(context != nullptr))
    {
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().debugKHR))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid =
                    ValidatePopDebugGroupKHR(context, angle::EntryPoint::GLPopDebugGroupKHR);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context, angle::EntryPoint::GLPopDebugGroupKHR);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->popDebugGroup();
        }
        ANGLE_CAPTURE_GL(PopDebugGroupKHR, isCallValid, context);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLPopDebugGroupKHR);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_PushDebugGroupKHR(GLenum source,
                                      GLuint id,
                                      GLsizei length,
                                      const GLchar *message)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLPushDebugGroupKHR,
          "context = %d, source = %s, id = %u, length = %d, message = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLESEnum::DebugSource, source), id, length,
          (uintptr_t)message);

    if (ANGLE_LIKELY(context != nullptr))
    {
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().debugKHR))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidatePushDebugGroupKHR(
                    context, angle::EntryPoint::GLPushDebugGroupKHR, source, id, length, message);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context, angle::EntryPoint::GLPushDebugGroupKHR);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->pushDebugGroup(source, id, length, message);
        }
        ANGLE_CAPTURE_GL(PushDebugGroupKHR, isCallValid, context, source, id, length, message);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLPushDebugGroupKHR);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

// GL_KHR_no_error

// GL_KHR_parallel_shader_compile
void GL_APIENTRY GL_MaxShaderCompilerThreadsKHR(GLuint count)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLMaxShaderCompilerThreadsKHR, "context = %d, count = %u", CID(context), count);

    if (ANGLE_LIKELY(context != nullptr))
    {
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().parallelShaderCompileKHR))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateMaxShaderCompilerThreadsKHR(
                    context, angle::EntryPoint::GLMaxShaderCompilerThreadsKHR, count);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context, angle::EntryPoint::GLMaxShaderCompilerThreadsKHR);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->maxShaderCompilerThreads(count);
        }
        ANGLE_CAPTURE_GL(MaxShaderCompilerThreadsKHR, isCallValid, context, count);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(
            angle::EntryPoint::GLMaxShaderCompilerThreadsKHR);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

// GL_KHR_robust_buffer_access_behavior

// GL_KHR_robustness
GLenum GL_APIENTRY GL_GetGraphicsResetStatusKHR()
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetGlobalContext();
    EVENT(context, GLGetGraphicsResetStatusKHR, "context = %d", CID(context));

    GLenum returnValue;
    if (ANGLE_LIKELY(context != nullptr))
    {
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().robustnessKHR))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateGetGraphicsResetStatusKHR(
                    context, angle::EntryPoint::GLGetGraphicsResetStatusKHR);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context, angle::EntryPoint::GLGetGraphicsResetStatusKHR);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            returnValue = context->getGraphicsResetStatus();
        }
        else
        {
            returnValue =
                GetDefaultReturnValue<angle::EntryPoint::GLGetGraphicsResetStatusKHR, GLenum>();
        }
        ANGLE_CAPTURE_GL(GetGraphicsResetStatusKHR, isCallValid, context, returnValue);
    }
    else
    {

        returnValue =
            GetDefaultReturnValue<angle::EntryPoint::GLGetGraphicsResetStatusKHR, GLenum>();
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    return returnValue;
}

void GL_APIENTRY GL_GetnUniformfvKHR(GLuint program,
                                     GLint location,
                                     GLsizei bufSize,
                                     GLfloat *params)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLGetnUniformfvKHR,
          "context = %d, program = %u, location = %d, bufSize = %d, params = 0x%016" PRIxPTR "",
          CID(context), program, location, bufSize, (uintptr_t)params);

    if (ANGLE_LIKELY(context != nullptr))
    {
        ShaderProgramID programPacked  = PackParam<ShaderProgramID>(program);
        UniformLocation locationPacked = PackParam<UniformLocation>(location);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().robustnessKHR))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid =
                    ValidateGetnUniformfvKHR(context, angle::EntryPoint::GLGetnUniformfvKHR,
                                             programPacked, locationPacked, bufSize, params);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context, angle::EntryPoint::GLGetnUniformfvKHR);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->getnUniformfv(programPacked, locationPacked, bufSize, params);
        }
        ANGLE_CAPTURE_GL(GetnUniformfvKHR, isCallValid, context, programPacked, locationPacked,
                         bufSize, params);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLGetnUniformfvKHR);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_GetnUniformivKHR(GLuint program, GLint location, GLsizei bufSize, GLint *params)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLGetnUniformivKHR,
          "context = %d, program = %u, location = %d, bufSize = %d, params = 0x%016" PRIxPTR "",
          CID(context), program, location, bufSize, (uintptr_t)params);

    if (ANGLE_LIKELY(context != nullptr))
    {
        ShaderProgramID programPacked  = PackParam<ShaderProgramID>(program);
        UniformLocation locationPacked = PackParam<UniformLocation>(location);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().robustnessKHR))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid =
                    ValidateGetnUniformivKHR(context, angle::EntryPoint::GLGetnUniformivKHR,
                                             programPacked, locationPacked, bufSize, params);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context, angle::EntryPoint::GLGetnUniformivKHR);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->getnUniformiv(programPacked, locationPacked, bufSize, params);
        }
        ANGLE_CAPTURE_GL(GetnUniformivKHR, isCallValid, context, programPacked, locationPacked,
                         bufSize, params);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLGetnUniformivKHR);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_GetnUniformuivKHR(GLuint program,
                                      GLint location,
                                      GLsizei bufSize,
                                      GLuint *params)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLGetnUniformuivKHR,
          "context = %d, program = %u, location = %d, bufSize = %d, params = 0x%016" PRIxPTR "",
          CID(context), program, location, bufSize, (uintptr_t)params);

    if (ANGLE_LIKELY(context != nullptr))
    {
        ShaderProgramID programPacked  = PackParam<ShaderProgramID>(program);
        UniformLocation locationPacked = PackParam<UniformLocation>(location);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().robustnessKHR))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid =
                    ValidateGetnUniformuivKHR(context, angle::EntryPoint::GLGetnUniformuivKHR,
                                              programPacked, locationPacked, bufSize, params);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context, angle::EntryPoint::GLGetnUniformuivKHR);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->getnUniformuiv(programPacked, locationPacked, bufSize, params);
        }
        ANGLE_CAPTURE_GL(GetnUniformuivKHR, isCallValid, context, programPacked, locationPacked,
                         bufSize, params);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLGetnUniformuivKHR);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_ReadnPixelsKHR(GLint x,
                                   GLint y,
                                   GLsizei width,
                                   GLsizei height,
                                   GLenum format,
                                   GLenum type,
                                   GLsizei bufSize,
                                   void *data)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLReadnPixelsKHR,
          "context = %d, x = %d, y = %d, width = %d, height = %d, format = %s, type = %s, bufSize "
          "= %d, data = 0x%016" PRIxPTR "",
          CID(context), x, y, width, height, GLenumToString(GLESEnum::PixelFormat, format),
          GLenumToString(GLESEnum::PixelType, type), bufSize, (uintptr_t)data);

    if (ANGLE_LIKELY(context != nullptr))
    {
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().robustnessKHR))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid =
                    ValidateReadnPixelsKHR(context, angle::EntryPoint::GLReadnPixelsKHR, x, y,
                                           width, height, format, type, bufSize, data);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context, angle::EntryPoint::GLReadnPixelsKHR);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->readnPixels(x, y, width, height, format, type, bufSize, data);
        }
        ANGLE_CAPTURE_GL(ReadnPixelsKHR, isCallValid, context, x, y, width, height, format, type,
                         bufSize, data);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLReadnPixelsKHR);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

// GL_KHR_texture_compression_astc_hdr

// GL_KHR_texture_compression_astc_ldr

// GL_KHR_texture_compression_astc_sliced_3d

// GL_MESA_framebuffer_flip_y
void GL_APIENTRY GL_FramebufferParameteriMESA(GLenum target, GLenum pname, GLint param)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLFramebufferParameteriMESA, "context = %d, target = %s, pname = %s, param = %d",
          CID(context), GLenumToString(GLESEnum::FramebufferTarget, target),
          GLenumToString(GLESEnum::FramebufferParameterName, pname), param);

    if (ANGLE_LIKELY(context != nullptr))
    {
        SCOPED_SHARE_CONTEXT_LOCK(context);
        if (context->getState().getPixelLocalStorageActivePlanes() != 0)
        {
            context->endPixelLocalStorageImplicit();
        }
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().framebufferFlipYMESA))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateFramebufferParameteriMESA(
                    context, angle::EntryPoint::GLFramebufferParameteriMESA, target, pname, param);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context, angle::EntryPoint::GLFramebufferParameteriMESA);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->framebufferParameteriMESA(target, pname, param);
        }
        ANGLE_CAPTURE_GL(FramebufferParameteriMESA, isCallValid, context, target, pname, param);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(
            angle::EntryPoint::GLFramebufferParameteriMESA);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_GetFramebufferParameterivMESA(GLenum target, GLenum pname, GLint *params)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLGetFramebufferParameterivMESA,
          "context = %d, target = %s, pname = %s, params = 0x%016" PRIxPTR "", CID(context),
          GLenumToString(GLESEnum::FramebufferTarget, target),
          GLenumToString(GLESEnum::FramebufferAttachmentParameterName, pname), (uintptr_t)params);

    if (ANGLE_LIKELY(context != nullptr))
    {
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().framebufferFlipYMESA))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateGetFramebufferParameterivMESA(
                    context, angle::EntryPoint::GLGetFramebufferParameterivMESA, target, pname,
                    params);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context,
                                        angle::EntryPoint::GLGetFramebufferParameterivMESA);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->getFramebufferParameterivMESA(target, pname, params);
        }
        ANGLE_CAPTURE_GL(GetFramebufferParameterivMESA, isCallValid, context, target, pname,
                         params);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(
            angle::EntryPoint::GLGetFramebufferParameterivMESA);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

// GL_NV_fence
void GL_APIENTRY GL_DeleteFencesNV(GLsizei n, const GLuint *fences)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLDeleteFencesNV, "context = %d, n = %d, fences = 0x%016" PRIxPTR "",
          CID(context), n, (uintptr_t)fences);

    if (ANGLE_LIKELY(context != nullptr))
    {
        const FenceNVID *fencesPacked = PackParam<const FenceNVID *>(fences);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().fenceNV))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateDeleteFencesNV(context, angle::EntryPoint::GLDeleteFencesNV,
                                                     n, fencesPacked);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context, angle::EntryPoint::GLDeleteFencesNV);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->deleteFencesNV(n, fencesPacked);
        }
        ANGLE_CAPTURE_GL(DeleteFencesNV, isCallValid, context, n, fencesPacked);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLDeleteFencesNV);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_FinishFenceNV(GLuint fence)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLFinishFenceNV, "context = %d, fence = %u", CID(context), fence);

    if (ANGLE_LIKELY(context != nullptr))
    {
        FenceNVID fencePacked = PackParam<FenceNVID>(fence);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().fenceNV))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid =
                    ValidateFinishFenceNV(context, angle::EntryPoint::GLFinishFenceNV, fencePacked);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context, angle::EntryPoint::GLFinishFenceNV);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->finishFenceNV(fencePacked);
        }
        ANGLE_CAPTURE_GL(FinishFenceNV, isCallValid, context, fencePacked);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLFinishFenceNV);
    }
    egl::Display::GetCurrentThreadUnlockedTailCall()->run(nullptr);
}

void GL_APIENTRY GL_GenFencesNV(GLsizei n, GLuint *fences)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLGenFencesNV, "context = %d, n = %d, fences = 0x%016" PRIxPTR "", CID(context),
          n, (uintptr_t)fences);

    if (ANGLE_LIKELY(context != nullptr))
    {
        FenceNVID *fencesPacked = PackParam<FenceNVID *>(fences);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().fenceNV))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid =
                    ValidateGenFencesNV(context, angle::EntryPoint::GLGenFencesNV, n, fencesPacked);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context, angle::EntryPoint::GLGenFencesNV);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->genFencesNV(n, fencesPacked);
        }
        ANGLE_CAPTURE_GL(GenFencesNV, isCallValid, context, n, fencesPacked);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLGenFencesNV);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_GetFenceivNV(GLuint fence, GLenum pname, GLint *params)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLGetFenceivNV,
          "context = %d, fence = %u, pname = %s, params = 0x%016" PRIxPTR "", CID(context), fence,
          GLenumToString(GLESEnum::AllEnums, pname), (uintptr_t)params);

    if (ANGLE_LIKELY(context != nullptr))
    {
        FenceNVID fencePacked = PackParam<FenceNVID>(fence);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().fenceNV))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateGetFenceivNV(context, angle::EntryPoint::GLGetFenceivNV,
                                                   fencePacked, pname, params);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context, angle::EntryPoint::GLGetFenceivNV);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->getFenceivNV(fencePacked, pname, params);
        }
        ANGLE_CAPTURE_GL(GetFenceivNV, isCallValid, context, fencePacked, pname, params);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLGetFenceivNV);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

GLboolean GL_APIENTRY GL_IsFenceNV(GLuint fence)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLIsFenceNV, "context = %d, fence = %u", CID(context), fence);

    GLboolean returnValue;
    if (ANGLE_LIKELY(context != nullptr))
    {
        FenceNVID fencePacked = PackParam<FenceNVID>(fence);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().fenceNV))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid =
                    ValidateIsFenceNV(context, angle::EntryPoint::GLIsFenceNV, fencePacked);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context, angle::EntryPoint::GLIsFenceNV);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            returnValue = context->isFenceNV(fencePacked);
        }
        else
        {
            returnValue = GetDefaultReturnValue<angle::EntryPoint::GLIsFenceNV, GLboolean>();
        }
        ANGLE_CAPTURE_GL(IsFenceNV, isCallValid, context, fencePacked, returnValue);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLIsFenceNV);
        returnValue = GetDefaultReturnValue<angle::EntryPoint::GLIsFenceNV, GLboolean>();
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    return returnValue;
}

void GL_APIENTRY GL_SetFenceNV(GLuint fence, GLenum condition)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLSetFenceNV, "context = %d, fence = %u, condition = %s", CID(context), fence,
          GLenumToString(GLESEnum::AllEnums, condition));

    if (ANGLE_LIKELY(context != nullptr))
    {
        FenceNVID fencePacked = PackParam<FenceNVID>(fence);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().fenceNV))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateSetFenceNV(context, angle::EntryPoint::GLSetFenceNV,
                                                 fencePacked, condition);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context, angle::EntryPoint::GLSetFenceNV);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->setFenceNV(fencePacked, condition);
        }
        ANGLE_CAPTURE_GL(SetFenceNV, isCallValid, context, fencePacked, condition);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLSetFenceNV);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

GLboolean GL_APIENTRY GL_TestFenceNV(GLuint fence)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLTestFenceNV, "context = %d, fence = %u", CID(context), fence);

    GLboolean returnValue;
    if (ANGLE_LIKELY(context != nullptr))
    {
        FenceNVID fencePacked = PackParam<FenceNVID>(fence);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().fenceNV))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid =
                    ValidateTestFenceNV(context, angle::EntryPoint::GLTestFenceNV, fencePacked);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context, angle::EntryPoint::GLTestFenceNV);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            returnValue = context->testFenceNV(fencePacked);
        }
        else
        {
            returnValue = GetDefaultReturnValue<angle::EntryPoint::GLTestFenceNV, GLboolean>();
        }
        ANGLE_CAPTURE_GL(TestFenceNV, isCallValid, context, fencePacked, returnValue);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLTestFenceNV);
        returnValue = GetDefaultReturnValue<angle::EntryPoint::GLTestFenceNV, GLboolean>();
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    return returnValue;
}

// GL_NV_framebuffer_blit
void GL_APIENTRY GL_BlitFramebufferNV(GLint srcX0,
                                      GLint srcY0,
                                      GLint srcX1,
                                      GLint srcY1,
                                      GLint dstX0,
                                      GLint dstY0,
                                      GLint dstX1,
                                      GLint dstY1,
                                      GLbitfield mask,
                                      GLenum filter)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLBlitFramebufferNV,
          "context = %d, srcX0 = %d, srcY0 = %d, srcX1 = %d, srcY1 = %d, dstX0 = %d, dstY0 = %d, "
          "dstX1 = %d, dstY1 = %d, mask = %s, filter = %s",
          CID(context), srcX0, srcY0, srcX1, srcY1, dstX0, dstY0, dstX1, dstY1,
          GLbitfieldToString(GLESEnum::ClearBufferMask, mask).c_str(),
          GLenumToString(GLESEnum::BlitFramebufferFilter, filter));

    if (ANGLE_LIKELY(context != nullptr))
    {
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().framebufferBlitNV))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateBlitFramebufferNV(
                    context, angle::EntryPoint::GLBlitFramebufferNV, srcX0, srcY0, srcX1, srcY1,
                    dstX0, dstY0, dstX1, dstY1, mask, filter);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context, angle::EntryPoint::GLBlitFramebufferNV);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->blitFramebufferNV(srcX0, srcY0, srcX1, srcY1, dstX0, dstY0, dstX1, dstY1, mask,
                                       filter);
        }
        ANGLE_CAPTURE_GL(BlitFramebufferNV, isCallValid, context, srcX0, srcY0, srcX1, srcY1, dstX0,
                         dstY0, dstX1, dstY1, mask, filter);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLBlitFramebufferNV);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

// GL_NV_pack_subimage

// GL_NV_pixel_buffer_object

// GL_NV_polygon_mode
void GL_APIENTRY GL_PolygonModeNV(GLenum face, GLenum mode)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLPolygonModeNV, "context = %d, face = %s, mode = %s", CID(context),
          GLenumToString(GLESEnum::TriangleFace, face),
          GLenumToString(GLESEnum::PolygonMode, mode));

    if (ANGLE_LIKELY(context != nullptr))
    {
        PolygonMode modePacked = PackParam<PolygonMode>(mode);
        bool isCallValid       = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().polygonModeNV))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidatePolygonModeNV(
                    context->getPrivateState(), context->getMutableErrorSetForValidation(),
                    angle::EntryPoint::GLPolygonModeNV, face, modePacked);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(isCallValid || context->getPushedErrorCount() != errorCount);
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context, angle::EntryPoint::GLPolygonModeNV);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            ContextPrivatePolygonModeNV(context->getMutablePrivateState(),
                                        context->getMutablePrivateStateCache(), face, modePacked);
        }
        ANGLE_CAPTURE_GL(PolygonModeNV, isCallValid, context, face, modePacked);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLPolygonModeNV);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

// GL_NV_read_depth

// GL_NV_read_depth_stencil

// GL_NV_read_stencil

// GL_NV_robustness_video_memory_purge

// GL_NV_shader_noperspective_interpolation

// GL_OES_EGL_image
void GL_APIENTRY GL_EGLImageTargetRenderbufferStorageOES(GLenum target, GLeglImageOES image)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLEGLImageTargetRenderbufferStorageOES,
          "context = %d, target = %s, image = 0x%016" PRIxPTR "", CID(context),
          GLenumToString(GLESEnum::AllEnums, target), (uintptr_t)image);

    if (ANGLE_LIKELY(context != nullptr))
    {
        egl::ImageID imagePacked = PackParam<egl::ImageID>(image);
        SCOPED_EGL_IMAGE_SHARE_CONTEXT_LOCK(context, imagePacked);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().EGLImageOES))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateEGLImageTargetRenderbufferStorageOES(
                    context, angle::EntryPoint::GLEGLImageTargetRenderbufferStorageOES, target,
                    imagePacked);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context,
                                        angle::EntryPoint::GLEGLImageTargetRenderbufferStorageOES);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->eGLImageTargetRenderbufferStorage(target, imagePacked);
        }
        ANGLE_CAPTURE_GL(EGLImageTargetRenderbufferStorageOES, isCallValid, context, target,
                         imagePacked);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(
            angle::EntryPoint::GLEGLImageTargetRenderbufferStorageOES);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_EGLImageTargetTexture2DOES(GLenum target, GLeglImageOES image)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLEGLImageTargetTexture2DOES,
          "context = %d, target = %s, image = 0x%016" PRIxPTR "", CID(context),
          GLenumToString(GLESEnum::AllEnums, target), (uintptr_t)image);

    if (ANGLE_LIKELY(context != nullptr))
    {
        TextureType targetPacked = PackParam<TextureType>(target);
        egl::ImageID imagePacked = PackParam<egl::ImageID>(image);
        SCOPED_EGL_IMAGE_SHARE_CONTEXT_LOCK(context, imagePacked);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().EGLImageExternalOES ||
                             context->getExtensions().EGLImageOES))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateEGLImageTargetTexture2DOES(
                    context, angle::EntryPoint::GLEGLImageTargetTexture2DOES, targetPacked,
                    imagePacked);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context, angle::EntryPoint::GLEGLImageTargetTexture2DOES);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->eGLImageTargetTexture2D(targetPacked, imagePacked);
        }
        ANGLE_CAPTURE_GL(EGLImageTargetTexture2DOES, isCallValid, context, targetPacked,
                         imagePacked);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(
            angle::EntryPoint::GLEGLImageTargetTexture2DOES);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

// GL_OES_EGL_image_external
// EGLImageTargetTexture2DOES is already defined.

// GL_OES_EGL_image_external_essl3

// GL_OES_blend_subtract
void GL_APIENTRY GL_BlendEquationOES(GLenum mode)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLBlendEquationOES, "context = %d, mode = %s", CID(context),
          GLenumToString(GLESEnum::BlendEquationModeEXT, mode));

    if (ANGLE_LIKELY(context != nullptr))
    {
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().blendSubtractOES))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateBlendEquationOES(context->getPrivateState(),
                                                       context->getMutableErrorSetForValidation(),
                                                       angle::EntryPoint::GLBlendEquationOES, mode);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(isCallValid || context->getPushedErrorCount() != errorCount);
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context, angle::EntryPoint::GLBlendEquationOES);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            ContextPrivateBlendEquation(context->getMutablePrivateState(),
                                        context->getMutablePrivateStateCache(), mode);
        }
        ANGLE_CAPTURE_GL(BlendEquationOES, isCallValid, context, mode);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLBlendEquationOES);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

// GL_OES_compressed_ETC1_RGB8_texture

// GL_OES_compressed_paletted_texture

// GL_OES_copy_image
void GL_APIENTRY GL_CopyImageSubDataOES(GLuint srcName,
                                        GLenum srcTarget,
                                        GLint srcLevel,
                                        GLint srcX,
                                        GLint srcY,
                                        GLint srcZ,
                                        GLuint dstName,
                                        GLenum dstTarget,
                                        GLint dstLevel,
                                        GLint dstX,
                                        GLint dstY,
                                        GLint dstZ,
                                        GLsizei srcWidth,
                                        GLsizei srcHeight,
                                        GLsizei srcDepth)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLCopyImageSubDataOES,
          "context = %d, srcName = %u, srcTarget = %s, srcLevel = %d, srcX = %d, srcY = %d, srcZ = "
          "%d, dstName = %u, dstTarget = %s, dstLevel = %d, dstX = %d, dstY = %d, dstZ = %d, "
          "srcWidth = %d, srcHeight = %d, srcDepth = %d",
          CID(context), srcName, GLenumToString(GLESEnum::CopyBufferSubDataTarget, srcTarget),
          srcLevel, srcX, srcY, srcZ, dstName,
          GLenumToString(GLESEnum::CopyBufferSubDataTarget, dstTarget), dstLevel, dstX, dstY, dstZ,
          srcWidth, srcHeight, srcDepth);

    if (ANGLE_LIKELY(context != nullptr))
    {
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().copyImageOES))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateCopyImageSubDataOES(
                    context, angle::EntryPoint::GLCopyImageSubDataOES, srcName, srcTarget, srcLevel,
                    srcX, srcY, srcZ, dstName, dstTarget, dstLevel, dstX, dstY, dstZ, srcWidth,
                    srcHeight, srcDepth);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context, angle::EntryPoint::GLCopyImageSubDataOES);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->copyImageSubData(srcName, srcTarget, srcLevel, srcX, srcY, srcZ, dstName,
                                      dstTarget, dstLevel, dstX, dstY, dstZ, srcWidth, srcHeight,
                                      srcDepth);
        }
        ANGLE_CAPTURE_GL(CopyImageSubDataOES, isCallValid, context, srcName, srcTarget, srcLevel,
                         srcX, srcY, srcZ, dstName, dstTarget, dstLevel, dstX, dstY, dstZ, srcWidth,
                         srcHeight, srcDepth);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLCopyImageSubDataOES);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

// GL_OES_depth24

// GL_OES_depth32

// GL_OES_depth_texture

// GL_OES_draw_buffers_indexed
void GL_APIENTRY GL_BlendEquationSeparateiOES(GLuint buf, GLenum modeRGB, GLenum modeAlpha)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLBlendEquationSeparateiOES,
          "context = %d, buf = %u, modeRGB = %s, modeAlpha = %s", CID(context), buf,
          GLenumToString(GLESEnum::BlendEquationModeEXT, modeRGB),
          GLenumToString(GLESEnum::BlendEquationModeEXT, modeAlpha));

    if (ANGLE_LIKELY(context != nullptr))
    {
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().drawBuffersIndexedOES))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateBlendEquationSeparateiOES(
                    context->getPrivateState(), context->getMutableErrorSetForValidation(),
                    angle::EntryPoint::GLBlendEquationSeparateiOES, buf, modeRGB, modeAlpha);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(isCallValid || context->getPushedErrorCount() != errorCount);
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context, angle::EntryPoint::GLBlendEquationSeparateiOES);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            ContextPrivateBlendEquationSeparatei(context->getMutablePrivateState(),
                                                 context->getMutablePrivateStateCache(), buf,
                                                 modeRGB, modeAlpha);
        }
        ANGLE_CAPTURE_GL(BlendEquationSeparateiOES, isCallValid, context, buf, modeRGB, modeAlpha);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(
            angle::EntryPoint::GLBlendEquationSeparateiOES);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_BlendEquationiOES(GLuint buf, GLenum mode)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLBlendEquationiOES, "context = %d, buf = %u, mode = %s", CID(context), buf,
          GLenumToString(GLESEnum::BlendEquationModeEXT, mode));

    if (ANGLE_LIKELY(context != nullptr))
    {
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().drawBuffersIndexedOES))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateBlendEquationiOES(
                    context->getPrivateState(), context->getMutableErrorSetForValidation(),
                    angle::EntryPoint::GLBlendEquationiOES, buf, mode);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(isCallValid || context->getPushedErrorCount() != errorCount);
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context, angle::EntryPoint::GLBlendEquationiOES);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            ContextPrivateBlendEquationi(context->getMutablePrivateState(),
                                         context->getMutablePrivateStateCache(), buf, mode);
        }
        ANGLE_CAPTURE_GL(BlendEquationiOES, isCallValid, context, buf, mode);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLBlendEquationiOES);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY
GL_BlendFuncSeparateiOES(GLuint buf, GLenum srcRGB, GLenum dstRGB, GLenum srcAlpha, GLenum dstAlpha)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLBlendFuncSeparateiOES,
          "context = %d, buf = %u, srcRGB = %s, dstRGB = %s, srcAlpha = %s, dstAlpha = %s",
          CID(context), buf, GLenumToString(GLESEnum::BlendingFactor, srcRGB),
          GLenumToString(GLESEnum::BlendingFactor, dstRGB),
          GLenumToString(GLESEnum::BlendingFactor, srcAlpha),
          GLenumToString(GLESEnum::BlendingFactor, dstAlpha));

    if (ANGLE_LIKELY(context != nullptr))
    {
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().drawBuffersIndexedOES))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateBlendFuncSeparateiOES(
                    context->getPrivateState(), context->getMutableErrorSetForValidation(),
                    angle::EntryPoint::GLBlendFuncSeparateiOES, buf, srcRGB, dstRGB, srcAlpha,
                    dstAlpha);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(isCallValid || context->getPushedErrorCount() != errorCount);
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context, angle::EntryPoint::GLBlendFuncSeparateiOES);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            ContextPrivateBlendFuncSeparatei(context->getMutablePrivateState(),
                                             context->getMutablePrivateStateCache(), buf, srcRGB,
                                             dstRGB, srcAlpha, dstAlpha);
        }
        ANGLE_CAPTURE_GL(BlendFuncSeparateiOES, isCallValid, context, buf, srcRGB, dstRGB, srcAlpha,
                         dstAlpha);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLBlendFuncSeparateiOES);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_BlendFunciOES(GLuint buf, GLenum src, GLenum dst)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLBlendFunciOES, "context = %d, buf = %u, src = %s, dst = %s", CID(context), buf,
          GLenumToString(GLESEnum::BlendingFactor, src),
          GLenumToString(GLESEnum::BlendingFactor, dst));

    if (ANGLE_LIKELY(context != nullptr))
    {
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().drawBuffersIndexedOES))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateBlendFunciOES(
                    context->getPrivateState(), context->getMutableErrorSetForValidation(),
                    angle::EntryPoint::GLBlendFunciOES, buf, src, dst);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(isCallValid || context->getPushedErrorCount() != errorCount);
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context, angle::EntryPoint::GLBlendFunciOES);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            ContextPrivateBlendFunci(context->getMutablePrivateState(),
                                     context->getMutablePrivateStateCache(), buf, src, dst);
        }
        ANGLE_CAPTURE_GL(BlendFunciOES, isCallValid, context, buf, src, dst);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLBlendFunciOES);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_ColorMaskiOES(GLuint index, GLboolean r, GLboolean g, GLboolean b, GLboolean a)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLColorMaskiOES, "context = %d, index = %u, r = %s, g = %s, b = %s, a = %s",
          CID(context), index, GLbooleanToString(r), GLbooleanToString(g), GLbooleanToString(b),
          GLbooleanToString(a));

    if (ANGLE_LIKELY(context != nullptr))
    {
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().drawBuffersIndexedOES))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateColorMaskiOES(
                    context->getPrivateState(), context->getMutableErrorSetForValidation(),
                    angle::EntryPoint::GLColorMaskiOES, index, r, g, b, a);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(isCallValid || context->getPushedErrorCount() != errorCount);
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context, angle::EntryPoint::GLColorMaskiOES);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            ContextPrivateColorMaski(context->getMutablePrivateState(),
                                     context->getMutablePrivateStateCache(), index, r, g, b, a);
        }
        ANGLE_CAPTURE_GL(ColorMaskiOES, isCallValid, context, index, r, g, b, a);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLColorMaskiOES);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_DisableiOES(GLenum target, GLuint index)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLDisableiOES, "context = %d, target = %s, index = %u", CID(context),
          GLenumToString(GLESEnum::EnableCap, target), index);

    if (ANGLE_LIKELY(context != nullptr))
    {
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().drawBuffersIndexedOES))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateDisableiOES(context->getPrivateState(),
                                                  context->getMutableErrorSetForValidation(),
                                                  angle::EntryPoint::GLDisableiOES, target, index);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(isCallValid || context->getPushedErrorCount() != errorCount);
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context, angle::EntryPoint::GLDisableiOES);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            ContextPrivateDisablei(context->getMutablePrivateState(),
                                   context->getMutablePrivateStateCache(), target, index);
        }
        ANGLE_CAPTURE_GL(DisableiOES, isCallValid, context, target, index);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLDisableiOES);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_EnableiOES(GLenum target, GLuint index)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLEnableiOES, "context = %d, target = %s, index = %u", CID(context),
          GLenumToString(GLESEnum::EnableCap, target), index);

    if (ANGLE_LIKELY(context != nullptr))
    {
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().drawBuffersIndexedOES))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateEnableiOES(context->getPrivateState(),
                                                 context->getMutableErrorSetForValidation(),
                                                 angle::EntryPoint::GLEnableiOES, target, index);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(isCallValid || context->getPushedErrorCount() != errorCount);
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context, angle::EntryPoint::GLEnableiOES);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            ContextPrivateEnablei(context->getMutablePrivateState(),
                                  context->getMutablePrivateStateCache(), target, index);
        }
        ANGLE_CAPTURE_GL(EnableiOES, isCallValid, context, target, index);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLEnableiOES);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

GLboolean GL_APIENTRY GL_IsEnablediOES(GLenum target, GLuint index)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLIsEnablediOES, "context = %d, target = %s, index = %u", CID(context),
          GLenumToString(GLESEnum::EnableCap, target), index);

    GLboolean returnValue;
    if (ANGLE_LIKELY(context != nullptr))
    {
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().drawBuffersIndexedOES))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateIsEnablediOES(
                    context->getPrivateState(), context->getMutableErrorSetForValidation(),
                    angle::EntryPoint::GLIsEnablediOES, target, index);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(isCallValid || context->getPushedErrorCount() != errorCount);
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context, angle::EntryPoint::GLIsEnablediOES);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            returnValue =
                ContextPrivateIsEnabledi(context->getMutablePrivateState(),
                                         context->getMutablePrivateStateCache(), target, index);
        }
        else
        {
            returnValue = GetDefaultReturnValue<angle::EntryPoint::GLIsEnablediOES, GLboolean>();
        }
        ANGLE_CAPTURE_GL(IsEnablediOES, isCallValid, context, target, index, returnValue);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLIsEnablediOES);
        returnValue = GetDefaultReturnValue<angle::EntryPoint::GLIsEnablediOES, GLboolean>();
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    return returnValue;
}

// GL_OES_draw_elements_base_vertex
void GL_APIENTRY GL_DrawElementsBaseVertexOES(GLenum mode,
                                              GLsizei count,
                                              GLenum type,
                                              const void *indices,
                                              GLint basevertex)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLDrawElementsBaseVertexOES,
          "context = %d, mode = %s, count = %d, type = %s, indices = 0x%016" PRIxPTR
          ", basevertex = %d",
          CID(context), GLenumToString(GLESEnum::PrimitiveType, mode), count,
          GLenumToString(GLESEnum::DrawElementsType, type), (uintptr_t)indices, basevertex);

    if (ANGLE_LIKELY(context != nullptr))
    {
        PrimitiveMode modePacked    = PackParam<PrimitiveMode>(mode);
        DrawElementsType typePacked = PackParam<DrawElementsType>(type);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().drawElementsBaseVertexOES))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateDrawElementsBaseVertexOES(
                    context, angle::EntryPoint::GLDrawElementsBaseVertexOES, modePacked, count,
                    typePacked, indices, basevertex);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context, angle::EntryPoint::GLDrawElementsBaseVertexOES);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->drawElementsBaseVertex(modePacked, count, typePacked, indices, basevertex);
        }
        ANGLE_CAPTURE_GL(DrawElementsBaseVertexOES, isCallValid, context, modePacked, count,
                         typePacked, indices, basevertex);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(
            angle::EntryPoint::GLDrawElementsBaseVertexOES);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_DrawElementsInstancedBaseVertexOES(GLenum mode,
                                                       GLsizei count,
                                                       GLenum type,
                                                       const void *indices,
                                                       GLsizei instancecount,
                                                       GLint basevertex)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLDrawElementsInstancedBaseVertexOES,
          "context = %d, mode = %s, count = %d, type = %s, indices = 0x%016" PRIxPTR
          ", instancecount = %d, basevertex = %d",
          CID(context), GLenumToString(GLESEnum::PrimitiveType, mode), count,
          GLenumToString(GLESEnum::DrawElementsType, type), (uintptr_t)indices, instancecount,
          basevertex);

    if (ANGLE_LIKELY(context != nullptr))
    {
        PrimitiveMode modePacked    = PackParam<PrimitiveMode>(mode);
        DrawElementsType typePacked = PackParam<DrawElementsType>(type);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().drawElementsBaseVertexOES))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateDrawElementsInstancedBaseVertexOES(
                    context, angle::EntryPoint::GLDrawElementsInstancedBaseVertexOES, modePacked,
                    count, typePacked, indices, instancecount, basevertex);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context,
                                        angle::EntryPoint::GLDrawElementsInstancedBaseVertexOES);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->drawElementsInstancedBaseVertex(modePacked, count, typePacked, indices,
                                                     instancecount, basevertex);
        }
        ANGLE_CAPTURE_GL(DrawElementsInstancedBaseVertexOES, isCallValid, context, modePacked,
                         count, typePacked, indices, instancecount, basevertex);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(
            angle::EntryPoint::GLDrawElementsInstancedBaseVertexOES);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_DrawRangeElementsBaseVertexOES(GLenum mode,
                                                   GLuint start,
                                                   GLuint end,
                                                   GLsizei count,
                                                   GLenum type,
                                                   const void *indices,
                                                   GLint basevertex)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLDrawRangeElementsBaseVertexOES,
          "context = %d, mode = %s, start = %u, end = %u, count = %d, type = %s, indices = "
          "0x%016" PRIxPTR ", basevertex = %d",
          CID(context), GLenumToString(GLESEnum::PrimitiveType, mode), start, end, count,
          GLenumToString(GLESEnum::DrawElementsType, type), (uintptr_t)indices, basevertex);

    if (ANGLE_LIKELY(context != nullptr))
    {
        PrimitiveMode modePacked    = PackParam<PrimitiveMode>(mode);
        DrawElementsType typePacked = PackParam<DrawElementsType>(type);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().drawElementsBaseVertexOES))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateDrawRangeElementsBaseVertexOES(
                    context, angle::EntryPoint::GLDrawRangeElementsBaseVertexOES, modePacked, start,
                    end, count, typePacked, indices, basevertex);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context,
                                        angle::EntryPoint::GLDrawRangeElementsBaseVertexOES);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->drawRangeElementsBaseVertex(modePacked, start, end, count, typePacked, indices,
                                                 basevertex);
        }
        ANGLE_CAPTURE_GL(DrawRangeElementsBaseVertexOES, isCallValid, context, modePacked, start,
                         end, count, typePacked, indices, basevertex);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(
            angle::EntryPoint::GLDrawRangeElementsBaseVertexOES);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

// MultiDrawElementsBaseVertexEXT is already defined.

// GL_OES_draw_texture
void GL_APIENTRY GL_DrawTexfOES(GLfloat x, GLfloat y, GLfloat z, GLfloat width, GLfloat height)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLDrawTexfOES, "context = %d, x = %f, y = %f, z = %f, width = %f, height = %f",
          CID(context), x, y, z, width, height);

    if (ANGLE_LIKELY(context != nullptr))
    {
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().drawTextureOES))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateDrawTexfOES(context, angle::EntryPoint::GLDrawTexfOES, x, y,
                                                  z, width, height);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context, angle::EntryPoint::GLDrawTexfOES);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->drawTexf(x, y, z, width, height);
        }
        ANGLE_CAPTURE_GL(DrawTexfOES, isCallValid, context, x, y, z, width, height);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLDrawTexfOES);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_DrawTexfvOES(const GLfloat *coords)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLDrawTexfvOES, "context = %d, coords = 0x%016" PRIxPTR "", CID(context),
          (uintptr_t)coords);

    if (ANGLE_LIKELY(context != nullptr))
    {
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().drawTextureOES))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid =
                    ValidateDrawTexfvOES(context, angle::EntryPoint::GLDrawTexfvOES, coords);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context, angle::EntryPoint::GLDrawTexfvOES);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->drawTexfv(coords);
        }
        ANGLE_CAPTURE_GL(DrawTexfvOES, isCallValid, context, coords);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLDrawTexfvOES);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_DrawTexiOES(GLint x, GLint y, GLint z, GLint width, GLint height)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLDrawTexiOES, "context = %d, x = %d, y = %d, z = %d, width = %d, height = %d",
          CID(context), x, y, z, width, height);

    if (ANGLE_LIKELY(context != nullptr))
    {
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().drawTextureOES))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateDrawTexiOES(context, angle::EntryPoint::GLDrawTexiOES, x, y,
                                                  z, width, height);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context, angle::EntryPoint::GLDrawTexiOES);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->drawTexi(x, y, z, width, height);
        }
        ANGLE_CAPTURE_GL(DrawTexiOES, isCallValid, context, x, y, z, width, height);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLDrawTexiOES);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_DrawTexivOES(const GLint *coords)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLDrawTexivOES, "context = %d, coords = 0x%016" PRIxPTR "", CID(context),
          (uintptr_t)coords);

    if (ANGLE_LIKELY(context != nullptr))
    {
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().drawTextureOES))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid =
                    ValidateDrawTexivOES(context, angle::EntryPoint::GLDrawTexivOES, coords);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context, angle::EntryPoint::GLDrawTexivOES);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->drawTexiv(coords);
        }
        ANGLE_CAPTURE_GL(DrawTexivOES, isCallValid, context, coords);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLDrawTexivOES);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_DrawTexsOES(GLshort x, GLshort y, GLshort z, GLshort width, GLshort height)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLDrawTexsOES, "context = %d, x = %d, y = %d, z = %d, width = %d, height = %d",
          CID(context), x, y, z, width, height);

    if (ANGLE_LIKELY(context != nullptr))
    {
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().drawTextureOES))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateDrawTexsOES(context, angle::EntryPoint::GLDrawTexsOES, x, y,
                                                  z, width, height);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context, angle::EntryPoint::GLDrawTexsOES);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->drawTexs(x, y, z, width, height);
        }
        ANGLE_CAPTURE_GL(DrawTexsOES, isCallValid, context, x, y, z, width, height);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLDrawTexsOES);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_DrawTexsvOES(const GLshort *coords)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLDrawTexsvOES, "context = %d, coords = 0x%016" PRIxPTR "", CID(context),
          (uintptr_t)coords);

    if (ANGLE_LIKELY(context != nullptr))
    {
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().drawTextureOES))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid =
                    ValidateDrawTexsvOES(context, angle::EntryPoint::GLDrawTexsvOES, coords);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context, angle::EntryPoint::GLDrawTexsvOES);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->drawTexsv(coords);
        }
        ANGLE_CAPTURE_GL(DrawTexsvOES, isCallValid, context, coords);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLDrawTexsvOES);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_DrawTexxOES(GLfixed x, GLfixed y, GLfixed z, GLfixed width, GLfixed height)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLDrawTexxOES,
          "context = %d, x = 0x%X, y = 0x%X, z = 0x%X, width = 0x%X, height = 0x%X", CID(context),
          x, y, z, width, height);

    if (ANGLE_LIKELY(context != nullptr))
    {
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().drawTextureOES))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateDrawTexxOES(context, angle::EntryPoint::GLDrawTexxOES, x, y,
                                                  z, width, height);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context, angle::EntryPoint::GLDrawTexxOES);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->drawTexx(x, y, z, width, height);
        }
        ANGLE_CAPTURE_GL(DrawTexxOES, isCallValid, context, x, y, z, width, height);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLDrawTexxOES);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_DrawTexxvOES(const GLfixed *coords)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLDrawTexxvOES, "context = %d, coords = 0x%016" PRIxPTR "", CID(context),
          (uintptr_t)coords);

    if (ANGLE_LIKELY(context != nullptr))
    {
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().drawTextureOES))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid =
                    ValidateDrawTexxvOES(context, angle::EntryPoint::GLDrawTexxvOES, coords);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context, angle::EntryPoint::GLDrawTexxvOES);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->drawTexxv(coords);
        }
        ANGLE_CAPTURE_GL(DrawTexxvOES, isCallValid, context, coords);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLDrawTexxvOES);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

// GL_OES_element_index_uint

// GL_OES_fbo_render_mipmap

// GL_OES_framebuffer_object
void GL_APIENTRY GL_BindFramebufferOES(GLenum target, GLuint framebuffer)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLBindFramebufferOES, "context = %d, target = %s, framebuffer = %u",
          CID(context), GLenumToString(GLESEnum::FramebufferTarget, target), framebuffer);

    if (ANGLE_LIKELY(context != nullptr))
    {
        FramebufferID framebufferPacked = PackParam<FramebufferID>(framebuffer);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().framebufferObjectOES))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateBindFramebufferOES(
                    context, angle::EntryPoint::GLBindFramebufferOES, target, framebufferPacked);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context, angle::EntryPoint::GLBindFramebufferOES);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->bindFramebuffer(target, framebufferPacked);
        }
        ANGLE_CAPTURE_GL(BindFramebufferOES, isCallValid, context, target, framebufferPacked);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLBindFramebufferOES);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_BindRenderbufferOES(GLenum target, GLuint renderbuffer)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLBindRenderbufferOES, "context = %d, target = %s, renderbuffer = %u",
          CID(context), GLenumToString(GLESEnum::RenderbufferTarget, target), renderbuffer);

    if (ANGLE_LIKELY(context != nullptr))
    {
        RenderbufferID renderbufferPacked = PackParam<RenderbufferID>(renderbuffer);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().framebufferObjectOES))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateBindRenderbufferOES(
                    context, angle::EntryPoint::GLBindRenderbufferOES, target, renderbufferPacked);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context, angle::EntryPoint::GLBindRenderbufferOES);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->bindRenderbuffer(target, renderbufferPacked);
        }
        ANGLE_CAPTURE_GL(BindRenderbufferOES, isCallValid, context, target, renderbufferPacked);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLBindRenderbufferOES);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

GLenum GL_APIENTRY GL_CheckFramebufferStatusOES(GLenum target)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLCheckFramebufferStatusOES, "context = %d, target = %s", CID(context),
          GLenumToString(GLESEnum::FramebufferTarget, target));

    GLenum returnValue;
    if (ANGLE_LIKELY(context != nullptr))
    {
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().framebufferObjectOES))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateCheckFramebufferStatusOES(
                    context, angle::EntryPoint::GLCheckFramebufferStatusOES, target);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context, angle::EntryPoint::GLCheckFramebufferStatusOES);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            returnValue = context->checkFramebufferStatus(target);
        }
        else
        {
            returnValue =
                GetDefaultReturnValue<angle::EntryPoint::GLCheckFramebufferStatusOES, GLenum>();
        }
        ANGLE_CAPTURE_GL(CheckFramebufferStatusOES, isCallValid, context, target, returnValue);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(
            angle::EntryPoint::GLCheckFramebufferStatusOES);
        returnValue =
            GetDefaultReturnValue<angle::EntryPoint::GLCheckFramebufferStatusOES, GLenum>();
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    return returnValue;
}

void GL_APIENTRY GL_DeleteFramebuffersOES(GLsizei n, const GLuint *framebuffers)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLDeleteFramebuffersOES,
          "context = %d, n = %d, framebuffers = 0x%016" PRIxPTR "", CID(context), n,
          (uintptr_t)framebuffers);

    if (ANGLE_LIKELY(context != nullptr))
    {
        const FramebufferID *framebuffersPacked = PackParam<const FramebufferID *>(framebuffers);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().framebufferObjectOES))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateDeleteFramebuffersOES(
                    context, angle::EntryPoint::GLDeleteFramebuffersOES, n, framebuffersPacked);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context, angle::EntryPoint::GLDeleteFramebuffersOES);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->deleteFramebuffers(n, framebuffersPacked);
        }
        ANGLE_CAPTURE_GL(DeleteFramebuffersOES, isCallValid, context, n, framebuffersPacked);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLDeleteFramebuffersOES);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_DeleteRenderbuffersOES(GLsizei n, const GLuint *renderbuffers)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLDeleteRenderbuffersOES,
          "context = %d, n = %d, renderbuffers = 0x%016" PRIxPTR "", CID(context), n,
          (uintptr_t)renderbuffers);

    if (ANGLE_LIKELY(context != nullptr))
    {
        const RenderbufferID *renderbuffersPacked =
            PackParam<const RenderbufferID *>(renderbuffers);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().framebufferObjectOES))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateDeleteRenderbuffersOES(
                    context, angle::EntryPoint::GLDeleteRenderbuffersOES, n, renderbuffersPacked);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context, angle::EntryPoint::GLDeleteRenderbuffersOES);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->deleteRenderbuffers(n, renderbuffersPacked);
        }
        ANGLE_CAPTURE_GL(DeleteRenderbuffersOES, isCallValid, context, n, renderbuffersPacked);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLDeleteRenderbuffersOES);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_FramebufferRenderbufferOES(GLenum target,
                                               GLenum attachment,
                                               GLenum renderbuffertarget,
                                               GLuint renderbuffer)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLFramebufferRenderbufferOES,
          "context = %d, target = %s, attachment = %s, renderbuffertarget = %s, renderbuffer = %u",
          CID(context), GLenumToString(GLESEnum::FramebufferTarget, target),
          GLenumToString(GLESEnum::FramebufferAttachment, attachment),
          GLenumToString(GLESEnum::RenderbufferTarget, renderbuffertarget), renderbuffer);

    if (ANGLE_LIKELY(context != nullptr))
    {
        RenderbufferID renderbufferPacked = PackParam<RenderbufferID>(renderbuffer);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().framebufferObjectOES))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateFramebufferRenderbufferOES(
                    context, angle::EntryPoint::GLFramebufferRenderbufferOES, target, attachment,
                    renderbuffertarget, renderbufferPacked);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context, angle::EntryPoint::GLFramebufferRenderbufferOES);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->framebufferRenderbuffer(target, attachment, renderbuffertarget,
                                             renderbufferPacked);
        }
        ANGLE_CAPTURE_GL(FramebufferRenderbufferOES, isCallValid, context, target, attachment,
                         renderbuffertarget, renderbufferPacked);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(
            angle::EntryPoint::GLFramebufferRenderbufferOES);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_FramebufferTexture2DOES(GLenum target,
                                            GLenum attachment,
                                            GLenum textarget,
                                            GLuint texture,
                                            GLint level)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLFramebufferTexture2DOES,
          "context = %d, target = %s, attachment = %s, textarget = %s, texture = %u, level = %d",
          CID(context), GLenumToString(GLESEnum::FramebufferTarget, target),
          GLenumToString(GLESEnum::FramebufferAttachment, attachment),
          GLenumToString(GLESEnum::TextureTarget, textarget), texture, level);

    if (ANGLE_LIKELY(context != nullptr))
    {
        TextureTarget textargetPacked = PackParam<TextureTarget>(textarget);
        TextureID texturePacked       = PackParam<TextureID>(texture);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        if (context->getState().getPixelLocalStorageActivePlanes() != 0)
        {
            context->endPixelLocalStorageImplicit();
        }
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().framebufferObjectOES))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateFramebufferTexture2DOES(
                    context, angle::EntryPoint::GLFramebufferTexture2DOES, target, attachment,
                    textargetPacked, texturePacked, level);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context, angle::EntryPoint::GLFramebufferTexture2DOES);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->framebufferTexture2D(target, attachment, textargetPacked, texturePacked,
                                          level);
        }
        ANGLE_CAPTURE_GL(FramebufferTexture2DOES, isCallValid, context, target, attachment,
                         textargetPacked, texturePacked, level);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(
            angle::EntryPoint::GLFramebufferTexture2DOES);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_GenFramebuffersOES(GLsizei n, GLuint *framebuffers)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLGenFramebuffersOES, "context = %d, n = %d, framebuffers = 0x%016" PRIxPTR "",
          CID(context), n, (uintptr_t)framebuffers);

    if (ANGLE_LIKELY(context != nullptr))
    {
        FramebufferID *framebuffersPacked = PackParam<FramebufferID *>(framebuffers);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().framebufferObjectOES))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateGenFramebuffersOES(
                    context, angle::EntryPoint::GLGenFramebuffersOES, n, framebuffersPacked);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context, angle::EntryPoint::GLGenFramebuffersOES);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->genFramebuffers(n, framebuffersPacked);
        }
        ANGLE_CAPTURE_GL(GenFramebuffersOES, isCallValid, context, n, framebuffersPacked);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLGenFramebuffersOES);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_GenRenderbuffersOES(GLsizei n, GLuint *renderbuffers)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLGenRenderbuffersOES, "context = %d, n = %d, renderbuffers = 0x%016" PRIxPTR "",
          CID(context), n, (uintptr_t)renderbuffers);

    if (ANGLE_LIKELY(context != nullptr))
    {
        RenderbufferID *renderbuffersPacked = PackParam<RenderbufferID *>(renderbuffers);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().framebufferObjectOES))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateGenRenderbuffersOES(
                    context, angle::EntryPoint::GLGenRenderbuffersOES, n, renderbuffersPacked);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context, angle::EntryPoint::GLGenRenderbuffersOES);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->genRenderbuffers(n, renderbuffersPacked);
        }
        ANGLE_CAPTURE_GL(GenRenderbuffersOES, isCallValid, context, n, renderbuffersPacked);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLGenRenderbuffersOES);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_GenerateMipmapOES(GLenum target)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLGenerateMipmapOES, "context = %d, target = %s", CID(context),
          GLenumToString(GLESEnum::TextureTarget, target));

    if (ANGLE_LIKELY(context != nullptr))
    {
        TextureType targetPacked = PackParam<TextureType>(target);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().framebufferObjectOES))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateGenerateMipmapOES(
                    context, angle::EntryPoint::GLGenerateMipmapOES, targetPacked);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context, angle::EntryPoint::GLGenerateMipmapOES);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->generateMipmap(targetPacked);
        }
        ANGLE_CAPTURE_GL(GenerateMipmapOES, isCallValid, context, targetPacked);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLGenerateMipmapOES);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_GetFramebufferAttachmentParameterivOES(GLenum target,
                                                           GLenum attachment,
                                                           GLenum pname,
                                                           GLint *params)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLGetFramebufferAttachmentParameterivOES,
          "context = %d, target = %s, attachment = %s, pname = %s, params = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLESEnum::FramebufferTarget, target),
          GLenumToString(GLESEnum::FramebufferAttachment, attachment),
          GLenumToString(GLESEnum::FramebufferAttachmentParameterName, pname), (uintptr_t)params);

    if (ANGLE_LIKELY(context != nullptr))
    {
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().framebufferObjectOES))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateGetFramebufferAttachmentParameterivOES(
                    context, angle::EntryPoint::GLGetFramebufferAttachmentParameterivOES, target,
                    attachment, pname, params);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(
                    context, angle::EntryPoint::GLGetFramebufferAttachmentParameterivOES);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->getFramebufferAttachmentParameteriv(target, attachment, pname, params);
        }
        ANGLE_CAPTURE_GL(GetFramebufferAttachmentParameterivOES, isCallValid, context, target,
                         attachment, pname, params);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(
            angle::EntryPoint::GLGetFramebufferAttachmentParameterivOES);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_GetRenderbufferParameterivOES(GLenum target, GLenum pname, GLint *params)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLGetRenderbufferParameterivOES,
          "context = %d, target = %s, pname = %s, params = 0x%016" PRIxPTR "", CID(context),
          GLenumToString(GLESEnum::RenderbufferTarget, target),
          GLenumToString(GLESEnum::RenderbufferParameterName, pname), (uintptr_t)params);

    if (ANGLE_LIKELY(context != nullptr))
    {
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().framebufferObjectOES))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateGetRenderbufferParameterivOES(
                    context, angle::EntryPoint::GLGetRenderbufferParameterivOES, target, pname,
                    params);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context,
                                        angle::EntryPoint::GLGetRenderbufferParameterivOES);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->getRenderbufferParameteriv(target, pname, params);
        }
        ANGLE_CAPTURE_GL(GetRenderbufferParameterivOES, isCallValid, context, target, pname,
                         params);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(
            angle::EntryPoint::GLGetRenderbufferParameterivOES);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

GLboolean GL_APIENTRY GL_IsFramebufferOES(GLuint framebuffer)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLIsFramebufferOES, "context = %d, framebuffer = %u", CID(context), framebuffer);

    GLboolean returnValue;
    if (ANGLE_LIKELY(context != nullptr))
    {
        FramebufferID framebufferPacked = PackParam<FramebufferID>(framebuffer);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().framebufferObjectOES))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateIsFramebufferOES(
                    context, angle::EntryPoint::GLIsFramebufferOES, framebufferPacked);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context, angle::EntryPoint::GLIsFramebufferOES);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            returnValue = context->isFramebuffer(framebufferPacked);
        }
        else
        {
            returnValue = GetDefaultReturnValue<angle::EntryPoint::GLIsFramebufferOES, GLboolean>();
        }
        ANGLE_CAPTURE_GL(IsFramebufferOES, isCallValid, context, framebufferPacked, returnValue);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLIsFramebufferOES);
        returnValue = GetDefaultReturnValue<angle::EntryPoint::GLIsFramebufferOES, GLboolean>();
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    return returnValue;
}

GLboolean GL_APIENTRY GL_IsRenderbufferOES(GLuint renderbuffer)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLIsRenderbufferOES, "context = %d, renderbuffer = %u", CID(context),
          renderbuffer);

    GLboolean returnValue;
    if (ANGLE_LIKELY(context != nullptr))
    {
        RenderbufferID renderbufferPacked = PackParam<RenderbufferID>(renderbuffer);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().framebufferObjectOES))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateIsRenderbufferOES(
                    context, angle::EntryPoint::GLIsRenderbufferOES, renderbufferPacked);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context, angle::EntryPoint::GLIsRenderbufferOES);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            returnValue = context->isRenderbuffer(renderbufferPacked);
        }
        else
        {
            returnValue =
                GetDefaultReturnValue<angle::EntryPoint::GLIsRenderbufferOES, GLboolean>();
        }
        ANGLE_CAPTURE_GL(IsRenderbufferOES, isCallValid, context, renderbufferPacked, returnValue);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLIsRenderbufferOES);
        returnValue = GetDefaultReturnValue<angle::EntryPoint::GLIsRenderbufferOES, GLboolean>();
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    return returnValue;
}

void GL_APIENTRY GL_RenderbufferStorageOES(GLenum target,
                                           GLenum internalformat,
                                           GLsizei width,
                                           GLsizei height)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLRenderbufferStorageOES,
          "context = %d, target = %s, internalformat = %s, width = %d, height = %d", CID(context),
          GLenumToString(GLESEnum::RenderbufferTarget, target),
          GLenumToString(GLESEnum::InternalFormat, internalformat), width, height);

    if (ANGLE_LIKELY(context != nullptr))
    {
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().framebufferObjectOES))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateRenderbufferStorageOES(
                    context, angle::EntryPoint::GLRenderbufferStorageOES, target, internalformat,
                    width, height);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context, angle::EntryPoint::GLRenderbufferStorageOES);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->renderbufferStorage(target, internalformat, width, height);
        }
        ANGLE_CAPTURE_GL(RenderbufferStorageOES, isCallValid, context, target, internalformat,
                         width, height);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLRenderbufferStorageOES);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

// GL_OES_geometry_shader
void GL_APIENTRY GL_FramebufferTextureOES(GLenum target,
                                          GLenum attachment,
                                          GLuint texture,
                                          GLint level)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLFramebufferTextureOES,
          "context = %d, target = %s, attachment = %s, texture = %u, level = %d", CID(context),
          GLenumToString(GLESEnum::FramebufferTarget, target),
          GLenumToString(GLESEnum::FramebufferAttachment, attachment), texture, level);

    if (ANGLE_LIKELY(context != nullptr))
    {
        TextureID texturePacked = PackParam<TextureID>(texture);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        if (context->getState().getPixelLocalStorageActivePlanes() != 0)
        {
            context->endPixelLocalStorageImplicit();
        }
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().geometryShaderOES))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateFramebufferTextureOES(
                    context, angle::EntryPoint::GLFramebufferTextureOES, target, attachment,
                    texturePacked, level);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context, angle::EntryPoint::GLFramebufferTextureOES);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->framebufferTexture(target, attachment, texturePacked, level);
        }
        ANGLE_CAPTURE_GL(FramebufferTextureOES, isCallValid, context, target, attachment,
                         texturePacked, level);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLFramebufferTextureOES);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

// GL_OES_get_program_binary
void GL_APIENTRY GL_GetProgramBinaryOES(GLuint program,
                                        GLsizei bufSize,
                                        GLsizei *length,
                                        GLenum *binaryFormat,
                                        void *binary)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLGetProgramBinaryOES,
          "context = %d, program = %u, bufSize = %d, length = 0x%016" PRIxPTR
          ", binaryFormat = 0x%016" PRIxPTR ", binary = 0x%016" PRIxPTR "",
          CID(context), program, bufSize, (uintptr_t)length, (uintptr_t)binaryFormat,
          (uintptr_t)binary);

    if (ANGLE_LIKELY(context != nullptr))
    {
        ShaderProgramID programPacked = PackParam<ShaderProgramID>(program);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().getProgramBinaryOES))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateGetProgramBinaryOES(
                    context, angle::EntryPoint::GLGetProgramBinaryOES, programPacked, bufSize,
                    length, binaryFormat, binary);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context, angle::EntryPoint::GLGetProgramBinaryOES);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->getProgramBinary(programPacked, bufSize, length, binaryFormat, binary);
        }
        ANGLE_CAPTURE_GL(GetProgramBinaryOES, isCallValid, context, programPacked, bufSize, length,
                         binaryFormat, binary);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLGetProgramBinaryOES);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_ProgramBinaryOES(GLuint program,
                                     GLenum binaryFormat,
                                     const void *binary,
                                     GLint length)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLProgramBinaryOES,
          "context = %d, program = %u, binaryFormat = %s, binary = 0x%016" PRIxPTR ", length = %d",
          CID(context), program, GLenumToString(GLESEnum::AllEnums, binaryFormat),
          (uintptr_t)binary, length);

    if (ANGLE_LIKELY(context != nullptr))
    {
        ShaderProgramID programPacked = PackParam<ShaderProgramID>(program);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().getProgramBinaryOES))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid =
                    ValidateProgramBinaryOES(context, angle::EntryPoint::GLProgramBinaryOES,
                                             programPacked, binaryFormat, binary, length);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context, angle::EntryPoint::GLProgramBinaryOES);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->programBinary(programPacked, binaryFormat, binary, length);
        }
        ANGLE_CAPTURE_GL(ProgramBinaryOES, isCallValid, context, programPacked, binaryFormat,
                         binary, length);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLProgramBinaryOES);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

// GL_OES_gpu_shader5

// GL_OES_mapbuffer
void GL_APIENTRY GL_GetBufferPointervOES(GLenum target, GLenum pname, void **params)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLGetBufferPointervOES,
          "context = %d, target = %s, pname = %s, params = 0x%016" PRIxPTR "", CID(context),
          GLenumToString(GLESEnum::BufferTargetARB, target),
          GLenumToString(GLESEnum::AllEnums, pname), (uintptr_t)params);

    if (ANGLE_LIKELY(context != nullptr))
    {
        BufferBinding targetPacked = PackParam<BufferBinding>(target);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().mapbufferOES))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid =
                    ValidateGetBufferPointervOES(context, angle::EntryPoint::GLGetBufferPointervOES,
                                                 targetPacked, pname, params);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context, angle::EntryPoint::GLGetBufferPointervOES);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->getBufferPointerv(targetPacked, pname, params);
        }
        ANGLE_CAPTURE_GL(GetBufferPointervOES, isCallValid, context, targetPacked, pname, params);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLGetBufferPointervOES);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void *GL_APIENTRY GL_MapBufferOES(GLenum target, GLenum access)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLMapBufferOES, "context = %d, target = %s, access = %s", CID(context),
          GLenumToString(GLESEnum::BufferTargetARB, target),
          GLenumToString(GLESEnum::BufferAccessARB, access));

    void *returnValue;
    if (ANGLE_LIKELY(context != nullptr))
    {
        BufferBinding targetPacked = PackParam<BufferBinding>(target);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().mapbufferOES))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateMapBufferOES(context, angle::EntryPoint::GLMapBufferOES,
                                                   targetPacked, access);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context, angle::EntryPoint::GLMapBufferOES);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            returnValue = context->mapBuffer(targetPacked, access);
        }
        else
        {
            returnValue = GetDefaultReturnValue<angle::EntryPoint::GLMapBufferOES, void *>();
        }
        ANGLE_CAPTURE_GL(MapBufferOES, isCallValid, context, targetPacked, access, returnValue);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLMapBufferOES);
        returnValue = GetDefaultReturnValue<angle::EntryPoint::GLMapBufferOES, void *>();
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    return returnValue;
}

GLboolean GL_APIENTRY GL_UnmapBufferOES(GLenum target)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLUnmapBufferOES, "context = %d, target = %s", CID(context),
          GLenumToString(GLESEnum::AllEnums, target));

    GLboolean returnValue;
    if (ANGLE_LIKELY(context != nullptr))
    {
        BufferBinding targetPacked = PackParam<BufferBinding>(target);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().mapbufferOES))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateUnmapBufferOES(context, angle::EntryPoint::GLUnmapBufferOES,
                                                     targetPacked);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context, angle::EntryPoint::GLUnmapBufferOES);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            returnValue = context->unmapBuffer(targetPacked);
        }
        else
        {
            returnValue = GetDefaultReturnValue<angle::EntryPoint::GLUnmapBufferOES, GLboolean>();
        }
        ANGLE_CAPTURE_GL(UnmapBufferOES, isCallValid, context, targetPacked, returnValue);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLUnmapBufferOES);
        returnValue = GetDefaultReturnValue<angle::EntryPoint::GLUnmapBufferOES, GLboolean>();
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    return returnValue;
}

// GL_OES_matrix_palette
void GL_APIENTRY GL_CurrentPaletteMatrixOES(GLuint matrixpaletteindex)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLCurrentPaletteMatrixOES, "context = %d, matrixpaletteindex = %u", CID(context),
          matrixpaletteindex);

    if (ANGLE_LIKELY(context != nullptr))
    {
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().matrixPaletteOES))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateCurrentPaletteMatrixOES(
                    context, angle::EntryPoint::GLCurrentPaletteMatrixOES, matrixpaletteindex);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context, angle::EntryPoint::GLCurrentPaletteMatrixOES);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->currentPaletteMatrix(matrixpaletteindex);
        }
        ANGLE_CAPTURE_GL(CurrentPaletteMatrixOES, isCallValid, context, matrixpaletteindex);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(
            angle::EntryPoint::GLCurrentPaletteMatrixOES);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_LoadPaletteFromModelViewMatrixOES()
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLLoadPaletteFromModelViewMatrixOES, "context = %d", CID(context));

    if (ANGLE_LIKELY(context != nullptr))
    {
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().matrixPaletteOES))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateLoadPaletteFromModelViewMatrixOES(
                    context, angle::EntryPoint::GLLoadPaletteFromModelViewMatrixOES);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context,
                                        angle::EntryPoint::GLLoadPaletteFromModelViewMatrixOES);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->loadPaletteFromModelViewMatrix();
        }
        ANGLE_CAPTURE_GL(LoadPaletteFromModelViewMatrixOES, isCallValid, context);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(
            angle::EntryPoint::GLLoadPaletteFromModelViewMatrixOES);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_MatrixIndexPointerOES(GLint size,
                                          GLenum type,
                                          GLsizei stride,
                                          const void *pointer)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLMatrixIndexPointerOES,
          "context = %d, size = %d, type = %s, stride = %d, pointer = 0x%016" PRIxPTR "",
          CID(context), size, GLenumToString(GLESEnum::AllEnums, type), stride, (uintptr_t)pointer);

    if (ANGLE_LIKELY(context != nullptr))
    {
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().matrixPaletteOES))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateMatrixIndexPointerOES(
                    context, angle::EntryPoint::GLMatrixIndexPointerOES, size, type, stride,
                    pointer);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context, angle::EntryPoint::GLMatrixIndexPointerOES);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->matrixIndexPointer(size, type, stride, pointer);
        }
        ANGLE_CAPTURE_GL(MatrixIndexPointerOES, isCallValid, context, size, type, stride, pointer);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLMatrixIndexPointerOES);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_WeightPointerOES(GLint size, GLenum type, GLsizei stride, const void *pointer)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLWeightPointerOES,
          "context = %d, size = %d, type = %s, stride = %d, pointer = 0x%016" PRIxPTR "",
          CID(context), size, GLenumToString(GLESEnum::AllEnums, type), stride, (uintptr_t)pointer);

    if (ANGLE_LIKELY(context != nullptr))
    {
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().matrixPaletteOES))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateWeightPointerOES(
                    context, angle::EntryPoint::GLWeightPointerOES, size, type, stride, pointer);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context, angle::EntryPoint::GLWeightPointerOES);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->weightPointer(size, type, stride, pointer);
        }
        ANGLE_CAPTURE_GL(WeightPointerOES, isCallValid, context, size, type, stride, pointer);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLWeightPointerOES);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

// GL_OES_packed_depth_stencil

// GL_OES_point_size_array
void GL_APIENTRY GL_PointSizePointerOES(GLenum type, GLsizei stride, const void *pointer)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLPointSizePointerOES,
          "context = %d, type = %s, stride = %d, pointer = 0x%016" PRIxPTR "", CID(context),
          GLenumToString(GLESEnum::AllEnums, type), stride, (uintptr_t)pointer);

    if (ANGLE_LIKELY(context != nullptr))
    {
        VertexAttribType typePacked = PackParam<VertexAttribType>(type);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().pointSizeArrayOES))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidatePointSizePointerOES(
                    context, angle::EntryPoint::GLPointSizePointerOES, typePacked, stride, pointer);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context, angle::EntryPoint::GLPointSizePointerOES);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->pointSizePointer(typePacked, stride, pointer);
        }
        ANGLE_CAPTURE_GL(PointSizePointerOES, isCallValid, context, typePacked, stride, pointer);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLPointSizePointerOES);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

// GL_OES_point_sprite

// GL_OES_primitive_bounding_box
void GL_APIENTRY GL_PrimitiveBoundingBoxOES(GLfloat minX,
                                            GLfloat minY,
                                            GLfloat minZ,
                                            GLfloat minW,
                                            GLfloat maxX,
                                            GLfloat maxY,
                                            GLfloat maxZ,
                                            GLfloat maxW)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLPrimitiveBoundingBoxOES,
          "context = %d, minX = %f, minY = %f, minZ = %f, minW = %f, maxX = %f, maxY = %f, maxZ = "
          "%f, maxW = %f",
          CID(context), minX, minY, minZ, minW, maxX, maxY, maxZ, maxW);

    if (ANGLE_LIKELY(context != nullptr))
    {
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().primitiveBoundingBoxOES))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidatePrimitiveBoundingBoxOES(
                    context->getPrivateState(), context->getMutableErrorSetForValidation(),
                    angle::EntryPoint::GLPrimitiveBoundingBoxOES, minX, minY, minZ, minW, maxX,
                    maxY, maxZ, maxW);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(isCallValid || context->getPushedErrorCount() != errorCount);
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context, angle::EntryPoint::GLPrimitiveBoundingBoxOES);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            ContextPrivatePrimitiveBoundingBox(context->getMutablePrivateState(),
                                               context->getMutablePrivateStateCache(), minX, minY,
                                               minZ, minW, maxX, maxY, maxZ, maxW);
        }
        ANGLE_CAPTURE_GL(PrimitiveBoundingBoxOES, isCallValid, context, minX, minY, minZ, minW,
                         maxX, maxY, maxZ, maxW);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(
            angle::EntryPoint::GLPrimitiveBoundingBoxOES);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

// GL_OES_query_matrix
GLbitfield GL_APIENTRY GL_QueryMatrixxOES(GLfixed *mantissa, GLint *exponent)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLQueryMatrixxOES,
          "context = %d, mantissa = 0x%016" PRIxPTR ", exponent = 0x%016" PRIxPTR "", CID(context),
          (uintptr_t)mantissa, (uintptr_t)exponent);

    GLbitfield returnValue;
    if (ANGLE_LIKELY(context != nullptr))
    {
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().queryMatrixOES))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateQueryMatrixxOES(context, angle::EntryPoint::GLQueryMatrixxOES,
                                                      mantissa, exponent);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context, angle::EntryPoint::GLQueryMatrixxOES);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            returnValue = context->queryMatrixx(mantissa, exponent);
        }
        else
        {
            returnValue = GetDefaultReturnValue<angle::EntryPoint::GLQueryMatrixxOES, GLbitfield>();
        }
        ANGLE_CAPTURE_GL(QueryMatrixxOES, isCallValid, context, mantissa, exponent, returnValue);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLQueryMatrixxOES);
        returnValue = GetDefaultReturnValue<angle::EntryPoint::GLQueryMatrixxOES, GLbitfield>();
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    return returnValue;
}

// GL_OES_required_internalformat

// GL_OES_rgb8_rgba8

// GL_OES_sample_shading
void GL_APIENTRY GL_MinSampleShadingOES(GLfloat value)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLMinSampleShadingOES, "context = %d, value = %f", CID(context), value);

    if (ANGLE_LIKELY(context != nullptr))
    {
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().sampleShadingOES))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateMinSampleShadingOES(
                    context->getPrivateState(), context->getMutableErrorSetForValidation(),
                    angle::EntryPoint::GLMinSampleShadingOES, value);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(isCallValid || context->getPushedErrorCount() != errorCount);
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context, angle::EntryPoint::GLMinSampleShadingOES);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            ContextPrivateMinSampleShading(context->getMutablePrivateState(),
                                           context->getMutablePrivateStateCache(), value);
        }
        ANGLE_CAPTURE_GL(MinSampleShadingOES, isCallValid, context, value);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLMinSampleShadingOES);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

// GL_OES_sample_variables

// GL_OES_shader_image_atomic

// GL_OES_shader_io_blocks

// GL_OES_shader_multisample_interpolation

// GL_OES_standard_derivatives

// GL_OES_surfaceless_context

// GL_OES_tessellation_shader
void GL_APIENTRY GL_PatchParameteriOES(GLenum pname, GLint value)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLPatchParameteriOES, "context = %d, pname = %s, value = %d", CID(context),
          GLenumToString(GLESEnum::PatchParameterName, pname), value);

    if (ANGLE_LIKELY(context != nullptr))
    {
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().tessellationShaderOES))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidatePatchParameteriOES(
                    context->getPrivateState(), context->getMutableErrorSetForValidation(),
                    angle::EntryPoint::GLPatchParameteriOES, pname, value);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(isCallValid || context->getPushedErrorCount() != errorCount);
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context, angle::EntryPoint::GLPatchParameteriOES);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            ContextPrivatePatchParameteri(context->getMutablePrivateState(),
                                          context->getMutablePrivateStateCache(), pname, value);
        }
        ANGLE_CAPTURE_GL(PatchParameteriOES, isCallValid, context, pname, value);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLPatchParameteriOES);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

// GL_OES_texture_3D
void GL_APIENTRY GL_CompressedTexImage3DOES(GLenum target,
                                            GLint level,
                                            GLenum internalformat,
                                            GLsizei width,
                                            GLsizei height,
                                            GLsizei depth,
                                            GLint border,
                                            GLsizei imageSize,
                                            const void *data)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLCompressedTexImage3DOES,
          "context = %d, target = %s, level = %d, internalformat = %s, width = %d, height = %d, "
          "depth = %d, border = %d, imageSize = %d, data = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLESEnum::TextureTarget, target), level,
          GLenumToString(GLESEnum::InternalFormat, internalformat), width, height, depth, border,
          imageSize, (uintptr_t)data);

    if (ANGLE_LIKELY(context != nullptr))
    {
        TextureTarget targetPacked = PackParam<TextureTarget>(target);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().texture3DOES))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateCompressedTexImage3DOES(
                    context, angle::EntryPoint::GLCompressedTexImage3DOES, targetPacked, level,
                    internalformat, width, height, depth, border, imageSize, data);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context, angle::EntryPoint::GLCompressedTexImage3DOES);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->compressedTexImage3D(targetPacked, level, internalformat, width, height, depth,
                                          border, imageSize, data);
        }
        ANGLE_CAPTURE_GL(CompressedTexImage3DOES, isCallValid, context, targetPacked, level,
                         internalformat, width, height, depth, border, imageSize, data);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(
            angle::EntryPoint::GLCompressedTexImage3DOES);
    }
    egl::Display::GetCurrentThreadUnlockedTailCall()->run(nullptr);
}

void GL_APIENTRY GL_CompressedTexSubImage3DOES(GLenum target,
                                               GLint level,
                                               GLint xoffset,
                                               GLint yoffset,
                                               GLint zoffset,
                                               GLsizei width,
                                               GLsizei height,
                                               GLsizei depth,
                                               GLenum format,
                                               GLsizei imageSize,
                                               const void *data)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLCompressedTexSubImage3DOES,
          "context = %d, target = %s, level = %d, xoffset = %d, yoffset = %d, zoffset = %d, width "
          "= %d, height = %d, depth = %d, format = %s, imageSize = %d, data = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLESEnum::TextureTarget, target), level, xoffset, yoffset,
          zoffset, width, height, depth, GLenumToString(GLESEnum::InternalFormat, format),
          imageSize, (uintptr_t)data);

    if (ANGLE_LIKELY(context != nullptr))
    {
        TextureTarget targetPacked = PackParam<TextureTarget>(target);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().texture3DOES))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateCompressedTexSubImage3DOES(
                    context, angle::EntryPoint::GLCompressedTexSubImage3DOES, targetPacked, level,
                    xoffset, yoffset, zoffset, width, height, depth, format, imageSize, data);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context, angle::EntryPoint::GLCompressedTexSubImage3DOES);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->compressedTexSubImage3D(targetPacked, level, xoffset, yoffset, zoffset, width,
                                             height, depth, format, imageSize, data);
        }
        ANGLE_CAPTURE_GL(CompressedTexSubImage3DOES, isCallValid, context, targetPacked, level,
                         xoffset, yoffset, zoffset, width, height, depth, format, imageSize, data);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(
            angle::EntryPoint::GLCompressedTexSubImage3DOES);
    }
    egl::Display::GetCurrentThreadUnlockedTailCall()->run(nullptr);
}

void GL_APIENTRY GL_CopyTexSubImage3DOES(GLenum target,
                                         GLint level,
                                         GLint xoffset,
                                         GLint yoffset,
                                         GLint zoffset,
                                         GLint x,
                                         GLint y,
                                         GLsizei width,
                                         GLsizei height)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLCopyTexSubImage3DOES,
          "context = %d, target = %s, level = %d, xoffset = %d, yoffset = %d, zoffset = %d, x = "
          "%d, y = %d, width = %d, height = %d",
          CID(context), GLenumToString(GLESEnum::AllEnums, target), level, xoffset, yoffset,
          zoffset, x, y, width, height);

    if (ANGLE_LIKELY(context != nullptr))
    {
        TextureTarget targetPacked = PackParam<TextureTarget>(target);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        if (context->getState().getPixelLocalStorageActivePlanes() != 0)
        {
            context->endPixelLocalStorageImplicit();
        }
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().texture3DOES))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateCopyTexSubImage3DOES(
                    context, angle::EntryPoint::GLCopyTexSubImage3DOES, targetPacked, level,
                    xoffset, yoffset, zoffset, x, y, width, height);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context, angle::EntryPoint::GLCopyTexSubImage3DOES);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->copyTexSubImage3D(targetPacked, level, xoffset, yoffset, zoffset, x, y, width,
                                       height);
        }
        ANGLE_CAPTURE_GL(CopyTexSubImage3DOES, isCallValid, context, targetPacked, level, xoffset,
                         yoffset, zoffset, x, y, width, height);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLCopyTexSubImage3DOES);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_FramebufferTexture3DOES(GLenum target,
                                            GLenum attachment,
                                            GLenum textarget,
                                            GLuint texture,
                                            GLint level,
                                            GLint zoffset)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLFramebufferTexture3DOES,
          "context = %d, target = %s, attachment = %s, textarget = %s, texture = %u, level = %d, "
          "zoffset = %d",
          CID(context), GLenumToString(GLESEnum::FramebufferTarget, target),
          GLenumToString(GLESEnum::FramebufferAttachment, attachment),
          GLenumToString(GLESEnum::TextureTarget, textarget), texture, level, zoffset);

    if (ANGLE_LIKELY(context != nullptr))
    {
        TextureTarget textargetPacked = PackParam<TextureTarget>(textarget);
        TextureID texturePacked       = PackParam<TextureID>(texture);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        if (context->getState().getPixelLocalStorageActivePlanes() != 0)
        {
            context->endPixelLocalStorageImplicit();
        }
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().texture3DOES))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateFramebufferTexture3DOES(
                    context, angle::EntryPoint::GLFramebufferTexture3DOES, target, attachment,
                    textargetPacked, texturePacked, level, zoffset);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context, angle::EntryPoint::GLFramebufferTexture3DOES);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->framebufferTexture3D(target, attachment, textargetPacked, texturePacked, level,
                                          zoffset);
        }
        ANGLE_CAPTURE_GL(FramebufferTexture3DOES, isCallValid, context, target, attachment,
                         textargetPacked, texturePacked, level, zoffset);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(
            angle::EntryPoint::GLFramebufferTexture3DOES);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_TexImage3DOES(GLenum target,
                                  GLint level,
                                  GLenum internalformat,
                                  GLsizei width,
                                  GLsizei height,
                                  GLsizei depth,
                                  GLint border,
                                  GLenum format,
                                  GLenum type,
                                  const void *pixels)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLTexImage3DOES,
          "context = %d, target = %s, level = %d, internalformat = %s, width = %d, height = %d, "
          "depth = %d, border = %d, format = %s, type = %s, pixels = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLESEnum::TextureTarget, target), level,
          GLenumToString(GLESEnum::InternalFormat, internalformat), width, height, depth, border,
          GLenumToString(GLESEnum::PixelFormat, format), GLenumToString(GLESEnum::PixelType, type),
          (uintptr_t)pixels);

    if (ANGLE_LIKELY(context != nullptr))
    {
        TextureTarget targetPacked = PackParam<TextureTarget>(target);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().texture3DOES))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateTexImage3DOES(context, angle::EntryPoint::GLTexImage3DOES,
                                                    targetPacked, level, internalformat, width,
                                                    height, depth, border, format, type, pixels);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context, angle::EntryPoint::GLTexImage3DOES);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->texImage3D(targetPacked, level, internalformat, width, height, depth, border,
                                format, type, pixels);
        }
        ANGLE_CAPTURE_GL(TexImage3DOES, isCallValid, context, targetPacked, level, internalformat,
                         width, height, depth, border, format, type, pixels);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLTexImage3DOES);
    }
    egl::Display::GetCurrentThreadUnlockedTailCall()->run(nullptr);
}

void GL_APIENTRY GL_TexSubImage3DOES(GLenum target,
                                     GLint level,
                                     GLint xoffset,
                                     GLint yoffset,
                                     GLint zoffset,
                                     GLsizei width,
                                     GLsizei height,
                                     GLsizei depth,
                                     GLenum format,
                                     GLenum type,
                                     const void *pixels)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLTexSubImage3DOES,
          "context = %d, target = %s, level = %d, xoffset = %d, yoffset = %d, zoffset = %d, width "
          "= %d, height = %d, depth = %d, format = %s, type = %s, pixels = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLESEnum::TextureTarget, target), level, xoffset, yoffset,
          zoffset, width, height, depth, GLenumToString(GLESEnum::PixelFormat, format),
          GLenumToString(GLESEnum::PixelType, type), (uintptr_t)pixels);

    if (ANGLE_LIKELY(context != nullptr))
    {
        TextureTarget targetPacked = PackParam<TextureTarget>(target);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().texture3DOES))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateTexSubImage3DOES(
                    context, angle::EntryPoint::GLTexSubImage3DOES, targetPacked, level, xoffset,
                    yoffset, zoffset, width, height, depth, format, type, pixels);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context, angle::EntryPoint::GLTexSubImage3DOES);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->texSubImage3D(targetPacked, level, xoffset, yoffset, zoffset, width, height,
                                   depth, format, type, pixels);
        }
        ANGLE_CAPTURE_GL(TexSubImage3DOES, isCallValid, context, targetPacked, level, xoffset,
                         yoffset, zoffset, width, height, depth, format, type, pixels);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLTexSubImage3DOES);
    }
    egl::Display::GetCurrentThreadUnlockedTailCall()->run(nullptr);
}

// GL_OES_texture_border_clamp
void GL_APIENTRY GL_GetSamplerParameterIivOES(GLuint sampler, GLenum pname, GLint *params)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLGetSamplerParameterIivOES,
          "context = %d, sampler = %u, pname = %s, params = 0x%016" PRIxPTR "", CID(context),
          sampler, GLenumToString(GLESEnum::SamplerParameterI, pname), (uintptr_t)params);

    if (ANGLE_LIKELY(context != nullptr))
    {
        SamplerID samplerPacked = PackParam<SamplerID>(sampler);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().textureBorderClampOES))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateGetSamplerParameterIivOES(
                    context, angle::EntryPoint::GLGetSamplerParameterIivOES, samplerPacked, pname,
                    params);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context, angle::EntryPoint::GLGetSamplerParameterIivOES);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->getSamplerParameterIiv(samplerPacked, pname, params);
        }
        ANGLE_CAPTURE_GL(GetSamplerParameterIivOES, isCallValid, context, samplerPacked, pname,
                         params);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(
            angle::EntryPoint::GLGetSamplerParameterIivOES);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_GetSamplerParameterIuivOES(GLuint sampler, GLenum pname, GLuint *params)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLGetSamplerParameterIuivOES,
          "context = %d, sampler = %u, pname = %s, params = 0x%016" PRIxPTR "", CID(context),
          sampler, GLenumToString(GLESEnum::SamplerParameterI, pname), (uintptr_t)params);

    if (ANGLE_LIKELY(context != nullptr))
    {
        SamplerID samplerPacked = PackParam<SamplerID>(sampler);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().textureBorderClampOES))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateGetSamplerParameterIuivOES(
                    context, angle::EntryPoint::GLGetSamplerParameterIuivOES, samplerPacked, pname,
                    params);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context, angle::EntryPoint::GLGetSamplerParameterIuivOES);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->getSamplerParameterIuiv(samplerPacked, pname, params);
        }
        ANGLE_CAPTURE_GL(GetSamplerParameterIuivOES, isCallValid, context, samplerPacked, pname,
                         params);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(
            angle::EntryPoint::GLGetSamplerParameterIuivOES);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_GetTexParameterIivOES(GLenum target, GLenum pname, GLint *params)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLGetTexParameterIivOES,
          "context = %d, target = %s, pname = %s, params = 0x%016" PRIxPTR "", CID(context),
          GLenumToString(GLESEnum::TextureTarget, target),
          GLenumToString(GLESEnum::GetTextureParameter, pname), (uintptr_t)params);

    if (ANGLE_LIKELY(context != nullptr))
    {
        TextureType targetPacked = PackParam<TextureType>(target);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().textureBorderClampOES))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateGetTexParameterIivOES(
                    context, angle::EntryPoint::GLGetTexParameterIivOES, targetPacked, pname,
                    params);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context, angle::EntryPoint::GLGetTexParameterIivOES);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->getTexParameterIiv(targetPacked, pname, params);
        }
        ANGLE_CAPTURE_GL(GetTexParameterIivOES, isCallValid, context, targetPacked, pname, params);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLGetTexParameterIivOES);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_GetTexParameterIuivOES(GLenum target, GLenum pname, GLuint *params)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLGetTexParameterIuivOES,
          "context = %d, target = %s, pname = %s, params = 0x%016" PRIxPTR "", CID(context),
          GLenumToString(GLESEnum::TextureTarget, target),
          GLenumToString(GLESEnum::GetTextureParameter, pname), (uintptr_t)params);

    if (ANGLE_LIKELY(context != nullptr))
    {
        TextureType targetPacked = PackParam<TextureType>(target);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().textureBorderClampOES))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateGetTexParameterIuivOES(
                    context, angle::EntryPoint::GLGetTexParameterIuivOES, targetPacked, pname,
                    params);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context, angle::EntryPoint::GLGetTexParameterIuivOES);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->getTexParameterIuiv(targetPacked, pname, params);
        }
        ANGLE_CAPTURE_GL(GetTexParameterIuivOES, isCallValid, context, targetPacked, pname, params);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLGetTexParameterIuivOES);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_SamplerParameterIivOES(GLuint sampler, GLenum pname, const GLint *param)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLSamplerParameterIivOES,
          "context = %d, sampler = %u, pname = %s, param = 0x%016" PRIxPTR "", CID(context),
          sampler, GLenumToString(GLESEnum::SamplerParameterI, pname), (uintptr_t)param);

    if (ANGLE_LIKELY(context != nullptr))
    {
        SamplerID samplerPacked = PackParam<SamplerID>(sampler);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().textureBorderClampOES))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateSamplerParameterIivOES(
                    context, angle::EntryPoint::GLSamplerParameterIivOES, samplerPacked, pname,
                    param);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context, angle::EntryPoint::GLSamplerParameterIivOES);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->samplerParameterIiv(samplerPacked, pname, param);
        }
        ANGLE_CAPTURE_GL(SamplerParameterIivOES, isCallValid, context, samplerPacked, pname, param);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLSamplerParameterIivOES);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_SamplerParameterIuivOES(GLuint sampler, GLenum pname, const GLuint *param)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLSamplerParameterIuivOES,
          "context = %d, sampler = %u, pname = %s, param = 0x%016" PRIxPTR "", CID(context),
          sampler, GLenumToString(GLESEnum::SamplerParameterI, pname), (uintptr_t)param);

    if (ANGLE_LIKELY(context != nullptr))
    {
        SamplerID samplerPacked = PackParam<SamplerID>(sampler);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().textureBorderClampOES))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateSamplerParameterIuivOES(
                    context, angle::EntryPoint::GLSamplerParameterIuivOES, samplerPacked, pname,
                    param);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context, angle::EntryPoint::GLSamplerParameterIuivOES);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->samplerParameterIuiv(samplerPacked, pname, param);
        }
        ANGLE_CAPTURE_GL(SamplerParameterIuivOES, isCallValid, context, samplerPacked, pname,
                         param);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(
            angle::EntryPoint::GLSamplerParameterIuivOES);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_TexParameterIivOES(GLenum target, GLenum pname, const GLint *params)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLTexParameterIivOES,
          "context = %d, target = %s, pname = %s, params = 0x%016" PRIxPTR "", CID(context),
          GLenumToString(GLESEnum::TextureTarget, target),
          GLenumToString(GLESEnum::TextureParameterName, pname), (uintptr_t)params);

    if (ANGLE_LIKELY(context != nullptr))
    {
        TextureType targetPacked = PackParam<TextureType>(target);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().textureBorderClampOES))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateTexParameterIivOES(
                    context, angle::EntryPoint::GLTexParameterIivOES, targetPacked, pname, params);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context, angle::EntryPoint::GLTexParameterIivOES);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->texParameterIiv(targetPacked, pname, params);
        }
        ANGLE_CAPTURE_GL(TexParameterIivOES, isCallValid, context, targetPacked, pname, params);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLTexParameterIivOES);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_TexParameterIuivOES(GLenum target, GLenum pname, const GLuint *params)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLTexParameterIuivOES,
          "context = %d, target = %s, pname = %s, params = 0x%016" PRIxPTR "", CID(context),
          GLenumToString(GLESEnum::TextureTarget, target),
          GLenumToString(GLESEnum::TextureParameterName, pname), (uintptr_t)params);

    if (ANGLE_LIKELY(context != nullptr))
    {
        TextureType targetPacked = PackParam<TextureType>(target);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().textureBorderClampOES))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateTexParameterIuivOES(
                    context, angle::EntryPoint::GLTexParameterIuivOES, targetPacked, pname, params);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context, angle::EntryPoint::GLTexParameterIuivOES);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->texParameterIuiv(targetPacked, pname, params);
        }
        ANGLE_CAPTURE_GL(TexParameterIuivOES, isCallValid, context, targetPacked, pname, params);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLTexParameterIuivOES);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

// GL_OES_texture_buffer
void GL_APIENTRY GL_TexBufferOES(GLenum target, GLenum internalformat, GLuint buffer)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLTexBufferOES, "context = %d, target = %s, internalformat = %s, buffer = %u",
          CID(context), GLenumToString(GLESEnum::TextureTarget, target),
          GLenumToString(GLESEnum::SizedInternalFormat, internalformat), buffer);

    if (ANGLE_LIKELY(context != nullptr))
    {
        TextureType targetPacked = PackParam<TextureType>(target);
        BufferID bufferPacked    = PackParam<BufferID>(buffer);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().textureBufferOES))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateTexBufferOES(context, angle::EntryPoint::GLTexBufferOES,
                                                   targetPacked, internalformat, bufferPacked);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context, angle::EntryPoint::GLTexBufferOES);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->texBuffer(targetPacked, internalformat, bufferPacked);
        }
        ANGLE_CAPTURE_GL(TexBufferOES, isCallValid, context, targetPacked, internalformat,
                         bufferPacked);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLTexBufferOES);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_TexBufferRangeOES(GLenum target,
                                      GLenum internalformat,
                                      GLuint buffer,
                                      GLintptr offset,
                                      GLsizeiptr size)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLTexBufferRangeOES,
          "context = %d, target = %s, internalformat = %s, buffer = %u, offset = %llu, size = %llu",
          CID(context), GLenumToString(GLESEnum::TextureTarget, target),
          GLenumToString(GLESEnum::SizedInternalFormat, internalformat), buffer,
          static_cast<unsigned long long>(offset), static_cast<unsigned long long>(size));

    if (ANGLE_LIKELY(context != nullptr))
    {
        TextureType targetPacked = PackParam<TextureType>(target);
        BufferID bufferPacked    = PackParam<BufferID>(buffer);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().textureBufferOES))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateTexBufferRangeOES(
                    context, angle::EntryPoint::GLTexBufferRangeOES, targetPacked, internalformat,
                    bufferPacked, offset, size);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context, angle::EntryPoint::GLTexBufferRangeOES);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->texBufferRange(targetPacked, internalformat, bufferPacked, offset, size);
        }
        ANGLE_CAPTURE_GL(TexBufferRangeOES, isCallValid, context, targetPacked, internalformat,
                         bufferPacked, offset, size);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLTexBufferRangeOES);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

// GL_OES_texture_compression_astc

// GL_OES_texture_cube_map
void GL_APIENTRY GL_GetTexGenfvOES(GLenum coord, GLenum pname, GLfloat *params)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLGetTexGenfvOES,
          "context = %d, coord = %s, pname = %s, params = 0x%016" PRIxPTR "", CID(context),
          GLenumToString(GLESEnum::TextureCoordName, coord),
          GLenumToString(GLESEnum::TextureGenParameter, pname), (uintptr_t)params);

    if (ANGLE_LIKELY(context != nullptr))
    {
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().textureCubeMapOES))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateGetTexGenfvOES(context, angle::EntryPoint::GLGetTexGenfvOES,
                                                     coord, pname, params);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context, angle::EntryPoint::GLGetTexGenfvOES);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->getTexGenfv(coord, pname, params);
        }
        ANGLE_CAPTURE_GL(GetTexGenfvOES, isCallValid, context, coord, pname, params);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLGetTexGenfvOES);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_GetTexGenivOES(GLenum coord, GLenum pname, GLint *params)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLGetTexGenivOES,
          "context = %d, coord = %s, pname = %s, params = 0x%016" PRIxPTR "", CID(context),
          GLenumToString(GLESEnum::TextureCoordName, coord),
          GLenumToString(GLESEnum::TextureGenParameter, pname), (uintptr_t)params);

    if (ANGLE_LIKELY(context != nullptr))
    {
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().textureCubeMapOES))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateGetTexGenivOES(context, angle::EntryPoint::GLGetTexGenivOES,
                                                     coord, pname, params);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context, angle::EntryPoint::GLGetTexGenivOES);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->getTexGeniv(coord, pname, params);
        }
        ANGLE_CAPTURE_GL(GetTexGenivOES, isCallValid, context, coord, pname, params);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLGetTexGenivOES);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_GetTexGenxvOES(GLenum coord, GLenum pname, GLfixed *params)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLGetTexGenxvOES,
          "context = %d, coord = %s, pname = %s, params = 0x%016" PRIxPTR "", CID(context),
          GLenumToString(GLESEnum::TextureCoordName, coord),
          GLenumToString(GLESEnum::TextureGenParameter, pname), (uintptr_t)params);

    if (ANGLE_LIKELY(context != nullptr))
    {
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().textureCubeMapOES))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateGetTexGenxvOES(context, angle::EntryPoint::GLGetTexGenxvOES,
                                                     coord, pname, params);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context, angle::EntryPoint::GLGetTexGenxvOES);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->getTexGenxv(coord, pname, params);
        }
        ANGLE_CAPTURE_GL(GetTexGenxvOES, isCallValid, context, coord, pname, params);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLGetTexGenxvOES);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_TexGenfOES(GLenum coord, GLenum pname, GLfloat param)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLTexGenfOES, "context = %d, coord = %s, pname = %s, param = %f", CID(context),
          GLenumToString(GLESEnum::TextureCoordName, coord),
          GLenumToString(GLESEnum::TextureGenParameter, pname), param);

    if (ANGLE_LIKELY(context != nullptr))
    {
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().textureCubeMapOES))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateTexGenfOES(context, angle::EntryPoint::GLTexGenfOES, coord,
                                                 pname, param);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context, angle::EntryPoint::GLTexGenfOES);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->texGenf(coord, pname, param);
        }
        ANGLE_CAPTURE_GL(TexGenfOES, isCallValid, context, coord, pname, param);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLTexGenfOES);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_TexGenfvOES(GLenum coord, GLenum pname, const GLfloat *params)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLTexGenfvOES,
          "context = %d, coord = %s, pname = %s, params = 0x%016" PRIxPTR "", CID(context),
          GLenumToString(GLESEnum::TextureCoordName, coord),
          GLenumToString(GLESEnum::TextureGenParameter, pname), (uintptr_t)params);

    if (ANGLE_LIKELY(context != nullptr))
    {
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().textureCubeMapOES))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateTexGenfvOES(context, angle::EntryPoint::GLTexGenfvOES, coord,
                                                  pname, params);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context, angle::EntryPoint::GLTexGenfvOES);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->texGenfv(coord, pname, params);
        }
        ANGLE_CAPTURE_GL(TexGenfvOES, isCallValid, context, coord, pname, params);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLTexGenfvOES);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_TexGeniOES(GLenum coord, GLenum pname, GLint param)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLTexGeniOES, "context = %d, coord = %s, pname = %s, param = %d", CID(context),
          GLenumToString(GLESEnum::TextureCoordName, coord),
          GLenumToString(GLESEnum::TextureGenParameter, pname), param);

    if (ANGLE_LIKELY(context != nullptr))
    {
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().textureCubeMapOES))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateTexGeniOES(context, angle::EntryPoint::GLTexGeniOES, coord,
                                                 pname, param);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context, angle::EntryPoint::GLTexGeniOES);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->texGeni(coord, pname, param);
        }
        ANGLE_CAPTURE_GL(TexGeniOES, isCallValid, context, coord, pname, param);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLTexGeniOES);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_TexGenivOES(GLenum coord, GLenum pname, const GLint *params)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLTexGenivOES,
          "context = %d, coord = %s, pname = %s, params = 0x%016" PRIxPTR "", CID(context),
          GLenumToString(GLESEnum::TextureCoordName, coord),
          GLenumToString(GLESEnum::TextureGenParameter, pname), (uintptr_t)params);

    if (ANGLE_LIKELY(context != nullptr))
    {
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().textureCubeMapOES))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateTexGenivOES(context, angle::EntryPoint::GLTexGenivOES, coord,
                                                  pname, params);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context, angle::EntryPoint::GLTexGenivOES);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->texGeniv(coord, pname, params);
        }
        ANGLE_CAPTURE_GL(TexGenivOES, isCallValid, context, coord, pname, params);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLTexGenivOES);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_TexGenxOES(GLenum coord, GLenum pname, GLfixed param)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLTexGenxOES, "context = %d, coord = %s, pname = %s, param = 0x%X", CID(context),
          GLenumToString(GLESEnum::TextureCoordName, coord),
          GLenumToString(GLESEnum::TextureGenParameter, pname), param);

    if (ANGLE_LIKELY(context != nullptr))
    {
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().textureCubeMapOES))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateTexGenxOES(context, angle::EntryPoint::GLTexGenxOES, coord,
                                                 pname, param);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context, angle::EntryPoint::GLTexGenxOES);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->texGenx(coord, pname, param);
        }
        ANGLE_CAPTURE_GL(TexGenxOES, isCallValid, context, coord, pname, param);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLTexGenxOES);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_TexGenxvOES(GLenum coord, GLenum pname, const GLfixed *params)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLTexGenxvOES,
          "context = %d, coord = %s, pname = %s, params = 0x%016" PRIxPTR "", CID(context),
          GLenumToString(GLESEnum::TextureCoordName, coord),
          GLenumToString(GLESEnum::TextureGenParameter, pname), (uintptr_t)params);

    if (ANGLE_LIKELY(context != nullptr))
    {
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().textureCubeMapOES))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateTexGenxvOES(context, angle::EntryPoint::GLTexGenxvOES, coord,
                                                  pname, params);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context, angle::EntryPoint::GLTexGenxvOES);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->texGenxv(coord, pname, params);
        }
        ANGLE_CAPTURE_GL(TexGenxvOES, isCallValid, context, coord, pname, params);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLTexGenxvOES);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

// GL_OES_texture_cube_map_array

// GL_OES_texture_float

// GL_OES_texture_float_linear

// GL_OES_texture_half_float

// GL_OES_texture_half_float_linear

// GL_OES_texture_mirrored_repeat

// GL_OES_texture_npot

// GL_OES_texture_stencil8

// GL_OES_texture_storage_multisample_2d_array
void GL_APIENTRY GL_TexStorage3DMultisampleOES(GLenum target,
                                               GLsizei samples,
                                               GLenum internalformat,
                                               GLsizei width,
                                               GLsizei height,
                                               GLsizei depth,
                                               GLboolean fixedsamplelocations)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLTexStorage3DMultisampleOES,
          "context = %d, target = %s, samples = %d, internalformat = %s, width = %d, height = %d, "
          "depth = %d, fixedsamplelocations = %s",
          CID(context), GLenumToString(GLESEnum::TextureTarget, target), samples,
          GLenumToString(GLESEnum::SizedInternalFormat, internalformat), width, height, depth,
          GLbooleanToString(fixedsamplelocations));

    if (ANGLE_LIKELY(context != nullptr))
    {
        TextureType targetPacked = PackParam<TextureType>(target);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().textureStorageMultisample2dArrayOES))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateTexStorage3DMultisampleOES(
                    context, angle::EntryPoint::GLTexStorage3DMultisampleOES, targetPacked, samples,
                    internalformat, width, height, depth, fixedsamplelocations);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context, angle::EntryPoint::GLTexStorage3DMultisampleOES);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->texStorage3DMultisample(targetPacked, samples, internalformat, width, height,
                                             depth, fixedsamplelocations);
        }
        ANGLE_CAPTURE_GL(TexStorage3DMultisampleOES, isCallValid, context, targetPacked, samples,
                         internalformat, width, height, depth, fixedsamplelocations);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(
            angle::EntryPoint::GLTexStorage3DMultisampleOES);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

// GL_OES_vertex_array_object
void GL_APIENTRY GL_BindVertexArrayOES(GLuint array)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLBindVertexArrayOES, "context = %d, array = %u", CID(context), array);

    if (ANGLE_LIKELY(context != nullptr))
    {
        VertexArrayID arrayPacked = PackParam<VertexArrayID>(array);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().vertexArrayObjectOES))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateBindVertexArrayOES(
                    context, angle::EntryPoint::GLBindVertexArrayOES, arrayPacked);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context, angle::EntryPoint::GLBindVertexArrayOES);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->bindVertexArray(arrayPacked);
        }
        ANGLE_CAPTURE_GL(BindVertexArrayOES, isCallValid, context, arrayPacked);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLBindVertexArrayOES);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_DeleteVertexArraysOES(GLsizei n, const GLuint *arrays)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLDeleteVertexArraysOES, "context = %d, n = %d, arrays = 0x%016" PRIxPTR "",
          CID(context), n, (uintptr_t)arrays);

    if (ANGLE_LIKELY(context != nullptr))
    {
        const VertexArrayID *arraysPacked = PackParam<const VertexArrayID *>(arrays);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().vertexArrayObjectOES))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateDeleteVertexArraysOES(
                    context, angle::EntryPoint::GLDeleteVertexArraysOES, n, arraysPacked);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context, angle::EntryPoint::GLDeleteVertexArraysOES);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->deleteVertexArrays(n, arraysPacked);
        }
        ANGLE_CAPTURE_GL(DeleteVertexArraysOES, isCallValid, context, n, arraysPacked);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLDeleteVertexArraysOES);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_GenVertexArraysOES(GLsizei n, GLuint *arrays)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLGenVertexArraysOES, "context = %d, n = %d, arrays = 0x%016" PRIxPTR "",
          CID(context), n, (uintptr_t)arrays);

    if (ANGLE_LIKELY(context != nullptr))
    {
        VertexArrayID *arraysPacked = PackParam<VertexArrayID *>(arrays);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().vertexArrayObjectOES))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateGenVertexArraysOES(
                    context, angle::EntryPoint::GLGenVertexArraysOES, n, arraysPacked);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context, angle::EntryPoint::GLGenVertexArraysOES);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->genVertexArrays(n, arraysPacked);
        }
        ANGLE_CAPTURE_GL(GenVertexArraysOES, isCallValid, context, n, arraysPacked);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLGenVertexArraysOES);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

GLboolean GL_APIENTRY GL_IsVertexArrayOES(GLuint array)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLIsVertexArrayOES, "context = %d, array = %u", CID(context), array);

    GLboolean returnValue;
    if (ANGLE_LIKELY(context != nullptr))
    {
        VertexArrayID arrayPacked = PackParam<VertexArrayID>(array);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().vertexArrayObjectOES))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateIsVertexArrayOES(
                    context->getPrivateState(), context->getMutableErrorSetForValidation(),
                    angle::EntryPoint::GLIsVertexArrayOES, arrayPacked);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(isCallValid || context->getPushedErrorCount() != errorCount);
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context, angle::EntryPoint::GLIsVertexArrayOES);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            returnValue =
                ContextPrivateIsVertexArray(context->getMutablePrivateState(),
                                            context->getMutablePrivateStateCache(), arrayPacked);
        }
        else
        {
            returnValue = GetDefaultReturnValue<angle::EntryPoint::GLIsVertexArrayOES, GLboolean>();
        }
        ANGLE_CAPTURE_GL(IsVertexArrayOES, isCallValid, context, arrayPacked, returnValue);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLIsVertexArrayOES);
        returnValue = GetDefaultReturnValue<angle::EntryPoint::GLIsVertexArrayOES, GLboolean>();
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    return returnValue;
}

// GL_OES_vertex_half_float

// GL_OES_vertex_type_10_10_10_2

// GL_OVR_multiview
void GL_APIENTRY GL_FramebufferTextureMultiviewOVR(GLenum target,
                                                   GLenum attachment,
                                                   GLuint texture,
                                                   GLint level,
                                                   GLint baseViewIndex,
                                                   GLsizei numViews)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLFramebufferTextureMultiviewOVR,
          "context = %d, target = %s, attachment = %s, texture = %u, level = %d, baseViewIndex = "
          "%d, numViews = %d",
          CID(context), GLenumToString(GLESEnum::FramebufferTarget, target),
          GLenumToString(GLESEnum::FramebufferAttachment, attachment), texture, level,
          baseViewIndex, numViews);

    if (ANGLE_LIKELY(context != nullptr))
    {
        TextureID texturePacked = PackParam<TextureID>(texture);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        if (context->getState().getPixelLocalStorageActivePlanes() != 0)
        {
            context->endPixelLocalStorageImplicit();
        }
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().multiviewOVR))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateFramebufferTextureMultiviewOVR(
                    context, angle::EntryPoint::GLFramebufferTextureMultiviewOVR, target,
                    attachment, texturePacked, level, baseViewIndex, numViews);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context,
                                        angle::EntryPoint::GLFramebufferTextureMultiviewOVR);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->framebufferTextureMultiview(target, attachment, texturePacked, level,
                                                 baseViewIndex, numViews);
        }
        ANGLE_CAPTURE_GL(FramebufferTextureMultiviewOVR, isCallValid, context, target, attachment,
                         texturePacked, level, baseViewIndex, numViews);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(
            angle::EntryPoint::GLFramebufferTextureMultiviewOVR);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

// GL_OVR_multiview2

// GL_OVR_multiview_multisampled_render_to_texture
void GL_APIENTRY GL_FramebufferTextureMultisampleMultiviewOVR(GLenum target,
                                                              GLenum attachment,
                                                              GLuint texture,
                                                              GLint level,
                                                              GLsizei samples,
                                                              GLint baseViewIndex,
                                                              GLsizei numViews)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLFramebufferTextureMultisampleMultiviewOVR,
          "context = %d, target = %s, attachment = %s, texture = %u, level = %d, samples = %d, "
          "baseViewIndex = %d, numViews = %d",
          CID(context), GLenumToString(GLESEnum::FramebufferTarget, target),
          GLenumToString(GLESEnum::FramebufferAttachment, attachment), texture, level, samples,
          baseViewIndex, numViews);

    if (ANGLE_LIKELY(context != nullptr))
    {
        TextureID texturePacked = PackParam<TextureID>(texture);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        if (context->getState().getPixelLocalStorageActivePlanes() != 0)
        {
            context->endPixelLocalStorageImplicit();
        }
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().multiviewMultisampledRenderToTextureOVR))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateFramebufferTextureMultisampleMultiviewOVR(
                    context, angle::EntryPoint::GLFramebufferTextureMultisampleMultiviewOVR, target,
                    attachment, texturePacked, level, samples, baseViewIndex, numViews);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(
                    context, angle::EntryPoint::GLFramebufferTextureMultisampleMultiviewOVR);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->framebufferTextureMultisampleMultiview(
                target, attachment, texturePacked, level, samples, baseViewIndex, numViews);
        }
        ANGLE_CAPTURE_GL(FramebufferTextureMultisampleMultiviewOVR, isCallValid, context, target,
                         attachment, texturePacked, level, samples, baseViewIndex, numViews);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(
            angle::EntryPoint::GLFramebufferTextureMultisampleMultiviewOVR);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

// GL_QCOM_framebuffer_foveated
void GL_APIENTRY GL_FramebufferFoveationConfigQCOM(GLuint framebuffer,
                                                   GLuint numLayers,
                                                   GLuint focalPointsPerLayer,
                                                   GLuint requestedFeatures,
                                                   GLuint *providedFeatures)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLFramebufferFoveationConfigQCOM,
          "context = %d, framebuffer = %u, numLayers = %u, focalPointsPerLayer = %u, "
          "requestedFeatures = %u, providedFeatures = 0x%016" PRIxPTR "",
          CID(context), framebuffer, numLayers, focalPointsPerLayer, requestedFeatures,
          (uintptr_t)providedFeatures);

    if (ANGLE_LIKELY(context != nullptr))
    {
        FramebufferID framebufferPacked = PackParam<FramebufferID>(framebuffer);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().framebufferFoveatedQCOM))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateFramebufferFoveationConfigQCOM(
                    context, angle::EntryPoint::GLFramebufferFoveationConfigQCOM, framebufferPacked,
                    numLayers, focalPointsPerLayer, requestedFeatures, providedFeatures);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context,
                                        angle::EntryPoint::GLFramebufferFoveationConfigQCOM);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->framebufferFoveationConfig(framebufferPacked, numLayers, focalPointsPerLayer,
                                                requestedFeatures, providedFeatures);
        }
        ANGLE_CAPTURE_GL(FramebufferFoveationConfigQCOM, isCallValid, context, framebufferPacked,
                         numLayers, focalPointsPerLayer, requestedFeatures, providedFeatures);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(
            angle::EntryPoint::GLFramebufferFoveationConfigQCOM);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_FramebufferFoveationParametersQCOM(GLuint framebuffer,
                                                       GLuint layer,
                                                       GLuint focalPoint,
                                                       GLfloat focalX,
                                                       GLfloat focalY,
                                                       GLfloat gainX,
                                                       GLfloat gainY,
                                                       GLfloat foveaArea)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLFramebufferFoveationParametersQCOM,
          "context = %d, framebuffer = %u, layer = %u, focalPoint = %u, focalX = %f, focalY = %f, "
          "gainX = %f, gainY = %f, foveaArea = %f",
          CID(context), framebuffer, layer, focalPoint, focalX, focalY, gainX, gainY, foveaArea);

    if (ANGLE_LIKELY(context != nullptr))
    {
        FramebufferID framebufferPacked = PackParam<FramebufferID>(framebuffer);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().framebufferFoveatedQCOM))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateFramebufferFoveationParametersQCOM(
                    context, angle::EntryPoint::GLFramebufferFoveationParametersQCOM,
                    framebufferPacked, layer, focalPoint, focalX, focalY, gainX, gainY, foveaArea);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context,
                                        angle::EntryPoint::GLFramebufferFoveationParametersQCOM);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->framebufferFoveationParameters(framebufferPacked, layer, focalPoint, focalX,
                                                    focalY, gainX, gainY, foveaArea);
        }
        ANGLE_CAPTURE_GL(FramebufferFoveationParametersQCOM, isCallValid, context,
                         framebufferPacked, layer, focalPoint, focalX, focalY, gainX, gainY,
                         foveaArea);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(
            angle::EntryPoint::GLFramebufferFoveationParametersQCOM);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

// GL_QCOM_render_shared_exponent

// GL_QCOM_shading_rate
void GL_APIENTRY GL_ShadingRateQCOM(GLenum rate)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLShadingRateQCOM, "context = %d, rate = %s", CID(context),
          GLenumToString(GLESEnum::ShadingRateQCOM, rate));

    if (ANGLE_LIKELY(context != nullptr))
    {
        ShadingRate ratePacked = PackParam<ShadingRate>(rate);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().shadingRateQCOM))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateShadingRateQCOM(
                    context->getPrivateState(), context->getMutableErrorSetForValidation(),
                    angle::EntryPoint::GLShadingRateQCOM, ratePacked);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(isCallValid || context->getPushedErrorCount() != errorCount);
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context, angle::EntryPoint::GLShadingRateQCOM);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            ContextPrivateShadingRateQCOM(context->getMutablePrivateState(),
                                          context->getMutablePrivateStateCache(), ratePacked);
        }
        ANGLE_CAPTURE_GL(ShadingRateQCOM, isCallValid, context, ratePacked);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLShadingRateQCOM);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

// GL_QCOM_texture_foveated
void GL_APIENTRY GL_TextureFoveationParametersQCOM(GLuint texture,
                                                   GLuint layer,
                                                   GLuint focalPoint,
                                                   GLfloat focalX,
                                                   GLfloat focalY,
                                                   GLfloat gainX,
                                                   GLfloat gainY,
                                                   GLfloat foveaArea)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLTextureFoveationParametersQCOM,
          "context = %d, texture = %u, layer = %u, focalPoint = %u, focalX = %f, focalY = %f, "
          "gainX = %f, gainY = %f, foveaArea = %f",
          CID(context), texture, layer, focalPoint, focalX, focalY, gainX, gainY, foveaArea);

    if (ANGLE_LIKELY(context != nullptr))
    {
        TextureID texturePacked = PackParam<TextureID>(texture);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().textureFoveatedQCOM))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateTextureFoveationParametersQCOM(
                    context, angle::EntryPoint::GLTextureFoveationParametersQCOM, texturePacked,
                    layer, focalPoint, focalX, focalY, gainX, gainY, foveaArea);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context,
                                        angle::EntryPoint::GLTextureFoveationParametersQCOM);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->textureFoveationParameters(texturePacked, layer, focalPoint, focalX, focalY,
                                                gainX, gainY, foveaArea);
        }
        ANGLE_CAPTURE_GL(TextureFoveationParametersQCOM, isCallValid, context, texturePacked, layer,
                         focalPoint, focalX, focalY, gainX, gainY, foveaArea);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(
            angle::EntryPoint::GLTextureFoveationParametersQCOM);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

// GL_QCOM_tiled_rendering
void GL_APIENTRY GL_EndTilingQCOM(GLbitfield preserveMask)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLEndTilingQCOM, "context = %d, preserveMask = %s", CID(context),
          GLbitfieldToString(GLESEnum::BufferBitQCOM, preserveMask).c_str());

    if (ANGLE_LIKELY(context != nullptr))
    {
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().tiledRenderingQCOM))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateEndTilingQCOM(context, angle::EntryPoint::GLEndTilingQCOM,
                                                    preserveMask);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context, angle::EntryPoint::GLEndTilingQCOM);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->endTiling(preserveMask);
        }
        ANGLE_CAPTURE_GL(EndTilingQCOM, isCallValid, context, preserveMask);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLEndTilingQCOM);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY
GL_StartTilingQCOM(GLuint x, GLuint y, GLuint width, GLuint height, GLbitfield preserveMask)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    EVENT(context, GLStartTilingQCOM,
          "context = %d, x = %u, y = %u, width = %u, height = %u, preserveMask = %s", CID(context),
          x, y, width, height, GLbitfieldToString(GLESEnum::BufferBitQCOM, preserveMask).c_str());

    if (ANGLE_LIKELY(context != nullptr))
    {
        SCOPED_SHARE_CONTEXT_LOCK(context);
        if (context->getState().getPixelLocalStorageActivePlanes() != 0)
        {
            context->endPixelLocalStorageImplicit();
        }
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getExtensions().tiledRenderingQCOM))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateStartTilingQCOM(context, angle::EntryPoint::GLStartTilingQCOM,
                                                      x, y, width, height, preserveMask);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorESEXT(context, angle::EntryPoint::GLStartTilingQCOM);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->startTiling(x, y, width, height, preserveMask);
        }
        ANGLE_CAPTURE_GL(StartTilingQCOM, isCallValid, context, x, y, width, height, preserveMask);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLStartTilingQCOM);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

}  // extern "C"
