

/************************************************************************
SAA505X Teletext

Variant		Character set
5050		English
5051		German
5052		Swedish
5053		Italian
5054		Belgian
5055		US ASCII
5056		Hebrew
5057		Cyrillic

Pins
1	Vss				ground
18	Vdd				positive supply
17	NC				not connected

Data In
--------
4-10	D1 to D7	in		character data inputs

16	~TLC		out		transmitted large character

Colour Our
----------
21	Y		out		monochrome video output
22	Blue		out		blue video output
23	Green		out		green video output
24	Red		out		red video output
25	BLAN		out		blanking output

Display Control
---------------
27	PO		in		picture on in[ut
28	DE		in		display enable input

Remote Control Data Decoder and Store
-------------------------------------
2	~SI   		in/out		superimposer
3	~DATA		in		remote control data
11	DLIM		in		remote control data clock
12	~GLR		in		general line reset

Timing Generator/Flash Counter
------------------------------
13	DEW		in		data entry window
19	TR6		in		6Mhz input
20	F1		in		1Mhz input
26	LOSE		in		load output shift register enable

Character Rounding
------------------
14	CRS		in		character rounding select
15	~BCS		in		big character select




Characters are output every 1us with a pixel dot rate of 6MHz.
Each character is 6 x 10 pixels

This device was designed to work over the top of a Television picture,
so the BLAN blanking output is used to blank out the television signal under control
of the PO and DE inputs and the box control characters.

13 DEW Data Entry Window
------------------------
This input signal resets the internal ROM row address counter prior to the desplay peroid.
It is also used internally to derive the 'flash' period.

20 F1
-----
This input is a 1Mhz equal mark/space ration signal. It is used to latch the 7-bit parallel character data into the input latches.

26 LOSE Load output shift register enable
-----------------------------------------
This input resets the internal control character flip-flops prior to the start of each display line.
This signal also defails the character display period.


*/

#include "saa505x.h"


/* Normal Character Set */

static char teletext_saa5050_characters[96*60]={
  // 0x20 ' '
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0
, // 0x21 '!'
  0,0,0,0,0,0,
  0,0,0,1,0,0,
  0,0,0,1,0,0,
  0,0,0,1,0,0,
  0,0,0,1,0,0,
  0,0,0,1,0,0,
  0,0,0,0,0,0,
  0,0,0,1,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0
, // 0x22 '"'
  0,0,0,0,0,0,
  0,0,1,0,1,0,
  0,0,1,0,1,0,
  0,0,1,0,1,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0
, // 0x23 ' British Pound'
  0,0,0,0,0,0,
  0,0,0,1,1,0,
  0,0,1,0,0,1,
  0,0,1,0,0,0,
  0,1,1,1,0,0,
  0,0,1,0,0,0,
  0,0,1,0,0,0,
  0,1,1,1,1,1,
  0,0,0,0,0,0,
  0,0,0,0,0,0
, // 0x24 '$'
  0,0,0,0,0,0,
  0,0,1,1,1,0,
  0,1,0,1,0,1,
  0,1,0,1,0,0,
  0,0,1,1,1,0,
  0,0,0,1,0,1,
  0,1,0,1,0,1,
  0,0,1,1,1,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0
, // 0x25 '%'
  0,0,0,0,0,0,
  0,1,1,0,0,0,
  0,1,1,0,0,1,
  0,0,0,0,1,0,
  0,0,0,1,0,0,
  0,0,1,0,0,0,
  0,1,0,0,1,1,
  0,0,0,0,1,1,
  0,0,0,0,0,0,
  0,0,0,0,0,0
, // 0x26 '&'
  0,0,0,0,0,0,
  0,0,1,0,0,0,
  0,1,0,1,0,0,
  0,1,0,1,0,0,
  0,0,1,0,0,0,
  0,1,0,1,0,1,
  0,1,0,0,1,0,
  0,0,1,1,0,1,
  0,0,0,0,0,0,
  0,0,0,0,0,0
, // 0x27 '''
  0,0,0,0,0,0,
  0,0,0,1,0,0,
  0,0,0,1,0,0,
  0,0,0,1,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0
, // 0x28 '('
  0,0,0,0,0,0,
  0,0,0,0,1,0,
  0,0,0,1,0,0,
  0,0,1,0,0,0,
  0,0,1,0,0,0,
  0,0,1,0,0,0,
  0,0,0,1,0,0,
  0,0,0,0,1,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0
, // 0x29 ')'
  0,0,0,0,0,0,
  0,0,1,0,0,0,
  0,0,0,1,0,0,
  0,0,0,0,1,0,
  0,0,0,0,1,0,
  0,0,0,0,1,0,
  0,0,0,1,0,0,
  0,0,1,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0
, // 0x2a '*'
  0,0,0,0,0,0,
  0,0,0,1,0,0,
  0,1,0,1,0,1,
  0,0,1,1,1,0,
  0,0,0,1,0,0,
  0,0,1,1,1,0,
  0,1,0,1,0,1,
  0,0,0,1,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0
, // 0x2b '+'
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,1,0,0,
  0,0,0,1,0,0,
  0,1,1,1,1,1,
  0,0,0,1,0,0,
  0,0,0,1,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0
, // 0x2c ','
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,1,0,0,
  0,0,0,1,0,0,
  0,0,1,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0
, // 0x2d '-'
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,1,1,1,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0
, // 0x2e '.'
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,1,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0
, // 0x2f '/'
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,1,
  0,0,0,0,1,0,
  0,0,0,1,0,0,
  0,0,1,0,0,0,
  0,1,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0
, // 0x30 '0'
  0,0,0,0,0,0,
  0,0,0,1,0,0,
  0,0,1,0,1,0,
  0,1,0,0,0,1,
  0,1,0,0,0,1,
  0,1,0,0,0,1,
  0,0,1,0,1,0,
  0,0,0,1,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0
, // 0x31 '1'
  0,0,0,0,0,0,
  0,0,0,1,0,0,
  0,0,1,1,0,0,
  0,0,0,1,0,0,
  0,0,0,1,0,0,
  0,0,0,1,0,0,
  0,0,0,1,0,0,
  0,0,1,1,1,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0
, // 0x32 '2'
  0,0,0,0,0,0,
  0,0,1,1,1,0,
  0,1,0,0,0,1,
  0,0,0,0,0,1,
  0,0,0,1,1,0,
  0,0,1,0,0,0,
  0,1,0,0,0,0,
  0,1,1,1,1,1,
  0,0,0,0,0,0,
  0,0,0,0,0,0
, // 0x33 '3'
  0,0,0,0,0,0,
  0,1,1,1,1,1,
  0,0,0,0,0,1,
  0,0,0,0,1,0,
  0,0,0,1,1,0,
  0,0,0,0,0,1,
  0,1,0,0,0,1,
  0,0,1,1,1,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0
, // 0x34 '4'
  0,0,0,0,0,0,
  0,0,0,0,1,0,
  0,0,0,1,1,0,
  0,0,1,0,1,0,
  0,1,0,0,1,0,
  0,1,1,1,1,1,
  0,0,0,0,1,0,
  0,0,0,0,1,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0
, // 0x35 '5'
  0,0,0,0,0,0,
  0,1,1,1,1,1,
  0,1,0,0,0,0,
  0,1,1,1,1,0,
  0,0,0,0,0,1,
  0,0,0,0,0,1,
  0,1,0,0,0,1,
  0,0,1,1,1,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0
, // 0x36 '6'
  0,0,0,0,0,0,
  0,0,0,1,1,0,
  0,0,1,0,0,0,
  0,1,0,0,0,0,
  0,1,1,1,1,0,
  0,1,0,0,0,1,
  0,1,0,0,0,1,
  0,0,1,1,1,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0
, // 0x37 '7'
  0,0,0,0,0,0,
  0,1,1,1,1,1,
  0,0,0,0,0,1,
  0,0,0,0,1,0,
  0,0,0,1,0,0,
  0,0,1,0,0,0,
  0,0,1,0,0,0,
  0,0,1,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0
, // 0x38 '8'
  0,0,0,0,0,0,
  0,0,1,1,1,0,
  0,1,0,0,0,1,
  0,1,0,0,0,1,
  0,0,1,1,1,0,
  0,1,0,0,0,1,
  0,1,0,0,0,1,
  0,0,1,1,1,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0
, // 0x39 '9'
  0,0,0,0,0,0,
  0,0,1,1,1,0,
  0,1,0,0,0,1,
  0,1,0,0,0,1,
  0,0,1,1,1,1,
  0,0,0,0,0,1,
  0,0,0,0,1,0,
  0,0,1,1,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0
, // 0x3a ':'
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,1,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,1,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0
, // 0x3b ';'
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,1,0,0,
  0,0,0,0,0,0,
  0,0,0,1,0,0,
  0,0,0,1,0,0,
  0,0,1,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0
, // 0x3c '<'
  0,0,0,0,0,0,
  0,0,0,0,1,0,
  0,0,0,1,0,0,
  0,0,1,0,0,0,
  0,1,0,0,0,0,
  0,0,1,0,0,0,
  0,0,0,1,0,0,
  0,0,0,0,1,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0
, // 0x3d '='
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,1,1,1,1,1,
  0,0,0,0,0,0,
  0,1,1,1,1,1,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0
, // 0x3e '>'
  0,0,0,0,0,0,
  0,0,1,0,0,0,
  0,0,0,1,0,0,
  0,0,0,0,1,0,
  0,0,0,0,0,1,
  0,0,0,0,1,0,
  0,0,0,1,0,0,
  0,0,1,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0
, // 0x3f '?'
  0,0,0,0,0,0,
  0,0,1,1,1,0,
  0,1,0,0,0,1,
  0,0,0,0,1,0,
  0,0,0,1,0,0,
  0,0,0,1,0,0,
  0,0,0,0,0,0,
  0,0,0,1,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0
, // 0x40 '@'
  0,0,0,0,0,0,
  0,0,1,1,1,0,
  0,1,0,0,0,1,
  0,1,0,1,1,1,
  0,1,0,1,0,1,
  0,1,0,1,1,1,
  0,1,0,0,0,0,
  0,0,1,1,1,1,
  0,0,0,0,0,0,
  0,0,0,0,0,0
, // 0x41 'A'
  0,0,0,0,0,0,
  0,0,0,1,0,0,
  0,0,1,0,1,0,
  0,1,0,0,0,1,
  0,1,0,0,0,1,
  0,1,1,1,1,1,
  0,1,0,0,0,1,
  0,1,0,0,0,1,
  0,0,0,0,0,0,
  0,0,0,0,0,0
, // 0x42 'B'
  0,0,0,0,0,0,
  0,1,1,1,1,0,
  0,1,0,0,0,1,
  0,1,0,0,0,1,
  0,1,1,1,1,0,
  0,1,0,0,0,1,
  0,1,0,0,0,1,
  0,1,1,1,1,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0
, // 0x43 'C'
  0,0,0,0,0,0,
  0,0,1,1,1,0,
  0,1,0,0,0,1,
  0,1,0,0,0,0,
  0,1,0,0,0,0,
  0,1,0,0,0,0,
  0,1,0,0,0,1,
  0,0,1,1,1,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0
, // 0x44 'D'
  0,0,0,0,0,0,
  0,1,1,1,1,0,
  0,1,0,0,0,1,
  0,1,0,0,0,1,
  0,1,0,0,0,1,
  0,1,0,0,0,1,
  0,1,0,0,0,1,
  0,1,1,1,1,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0
, // 0x45 'E'
  0,0,0,0,0,0,
  0,1,1,1,1,1,
  0,1,0,0,0,0,
  0,1,0,0,0,0,
  0,1,1,1,1,0,
  0,1,0,0,0,0,
  0,1,0,0,0,0,
  0,1,1,1,1,1,
  0,0,0,0,0,0,
  0,0,0,0,0,0
, // 0x46 'F'
  0,0,0,0,0,0,
  0,1,1,1,1,1,
  0,1,0,0,0,0,
  0,1,0,0,0,0,
  0,1,1,1,1,0,
  0,1,0,0,0,0,
  0,1,0,0,0,0,
  0,1,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0
, // 0x47 'G'
  0,0,0,0,0,0,
  0,0,1,1,1,0,
  0,1,0,0,0,1,
  0,1,0,0,0,0,
  0,1,0,0,0,0,
  0,1,0,0,1,1,
  0,1,0,0,0,1,
  0,0,1,1,1,1,
  0,0,0,0,0,0,
  0,0,0,0,0,0
, // 0x48 'H'
  0,0,0,0,0,0,
  0,1,0,0,0,1,
  0,1,0,0,0,1,
  0,1,0,0,0,1,
  0,1,1,1,1,1,
  0,1,0,0,0,1,
  0,1,0,0,0,1,
  0,1,0,0,0,1,
  0,0,0,0,0,0,
  0,0,0,0,0,0
, // 0x49 'I'
  0,0,0,0,0,0,
  0,0,1,1,1,0,
  0,0,0,1,0,0,
  0,0,0,1,0,0,
  0,0,0,1,0,0,
  0,0,0,1,0,0,
  0,0,0,1,0,0,
  0,0,1,1,1,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0
, // 0x4a 'J'
  0,0,0,0,0,0,
  0,0,0,0,0,1,
  0,0,0,0,0,1,
  0,0,0,0,0,1,
  0,0,0,0,0,1,
  0,0,0,0,0,1,
  0,1,0,0,0,1,
  0,0,1,1,1,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0
, // 0x4b 'K'
  0,0,0,0,0,0,
  0,1,0,0,0,1,
  0,1,0,0,1,0,
  0,1,0,1,0,0,
  0,1,1,0,0,0,
  0,1,0,1,0,0,
  0,1,0,0,1,0,
  0,1,0,0,0,1,
  0,0,0,0,0,0,
  0,0,0,0,0,0
, // 0x4c 'L'
  0,0,0,0,0,0,
  0,1,0,0,0,0,
  0,1,0,0,0,0,
  0,1,0,0,0,0,
  0,1,0,0,0,0,
  0,1,0,0,0,0,
  0,1,0,0,0,0,
  0,1,1,1,1,1,
  0,0,0,0,0,0,
  0,0,0,0,0,0
, // 0x4d 'M'
  0,0,0,0,0,0,
  0,1,0,0,0,1,
  0,1,1,0,1,1,
  0,1,0,1,0,1,
  0,1,0,0,0,1,
  0,1,0,0,0,1,
  0,1,0,0,0,1,
  0,1,0,0,0,1,
  0,0,0,0,0,0,
  0,0,0,0,0,0
, // 0x4e 'N'
  0,0,0,0,0,0,
  0,1,0,0,0,1,
  0,1,0,0,0,1,
  0,1,1,0,0,1,
  0,1,0,1,0,1,
  0,1,0,0,1,1,
  0,1,0,0,0,1,
  0,1,0,0,0,1,
  0,0,0,0,0,0,
  0,0,0,0,0,0
, // 0x4f 'O'
  0,0,0,0,0,0,
  0,0,1,1,1,0,
  0,1,0,0,0,1,
  0,1,0,0,0,1,
  0,1,0,0,0,1,
  0,1,0,0,0,1,
  0,1,0,0,0,1,
  0,0,1,1,1,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0
, // 0x50 'P'
  0,0,0,0,0,0,
  0,1,1,1,1,0,
  0,1,0,0,0,1,
  0,1,0,0,0,1,
  0,1,1,1,1,0,
  0,1,0,0,0,0,
  0,1,0,0,0,0,
  0,1,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0
, // 0x51 'Q'
  0,0,0,0,0,0,
  0,0,1,1,1,0,
  0,1,0,0,0,1,
  0,1,0,0,0,1,
  0,1,0,0,0,1,
  0,1,0,1,0,1,
  0,1,0,0,1,0,
  0,0,1,1,0,1,
  0,0,0,0,0,0,
  0,0,0,0,0,0
, // 0x52 'R'
  0,0,0,0,0,0,
  0,1,1,1,1,0,
  0,1,0,0,0,1,
  0,1,0,0,0,1,
  0,1,1,1,1,0,
  0,1,0,1,0,0,
  0,1,0,0,1,0,
  0,1,0,0,0,1,
  0,0,0,0,0,0,
  0,0,0,0,0,0
, // 0x53 'S'
  0,0,0,0,0,0,
  0,0,1,1,1,0,
  0,1,0,0,0,1,
  0,1,0,0,0,0,
  0,0,1,1,1,0,
  0,0,0,0,0,1,
  0,1,0,0,0,1,
  0,0,1,1,1,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0
, // 0x54 'T'
  0,0,0,0,0,0,
  0,1,1,1,1,1,
  0,0,0,1,0,0,
  0,0,0,1,0,0,
  0,0,0,1,0,0,
  0,0,0,1,0,0,
  0,0,0,1,0,0,
  0,0,0,1,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0
, // 0x55 'U'
  0,0,0,0,0,0,
  0,1,0,0,0,1,
  0,1,0,0,0,1,
  0,1,0,0,0,1,
  0,1,0,0,0,1,
  0,1,0,0,0,1,
  0,1,0,0,0,1,
  0,0,1,1,1,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0
, // 0x56 'V'
  0,0,0,0,0,0,
  0,1,0,0,0,1,
  0,1,0,0,0,1,
  0,1,0,0,0,1,
  0,0,1,0,1,0,
  0,0,1,0,1,0,
  0,0,0,1,0,0,
  0,0,0,1,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0
, // 0x57 'W'
  0,0,0,0,0,0,
  0,1,0,0,0,1,
  0,1,0,0,0,1,
  0,1,0,0,0,1,
  0,1,0,1,0,1,
  0,1,0,1,0,1,
  0,1,0,1,0,1,
  0,0,1,0,1,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0
, // 0x58 'X'
  0,0,0,0,0,0,
  0,1,0,0,0,1,
  0,1,0,0,0,1,
  0,0,1,0,1,0,
  0,0,0,1,0,0,
  0,0,1,0,1,0,
  0,1,0,0,0,1,
  0,1,0,0,0,1,
  0,0,0,0,0,0,
  0,0,0,0,0,0
, // 0x59 'Y'
  0,0,0,0,0,0,
  0,1,0,0,0,1,
  0,1,0,0,0,1,
  0,0,1,0,1,0,
  0,0,0,1,0,0,
  0,0,0,1,0,0,
  0,0,0,1,0,0,
  0,0,0,1,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0
, // 0x5a 'Z'
  0,0,0,0,0,0,
  0,1,1,1,1,1,
  0,0,0,0,0,1,
  0,0,0,0,1,0,
  0,0,0,1,0,0,
  0,0,1,0,0,0,
  0,1,0,0,0,0,
  0,1,1,1,1,1,
  0,0,0,0,0,0,
  0,0,0,0,0,0
, // 0x5b Left Arrow
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,1,0,0,
  0,0,1,0,0,0,
  0,1,1,1,1,1,
  0,0,1,0,0,0,
  0,0,0,1,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0
, // 0x5c ' 1/2 symbol'
  0,0,0,0,0,0,
  0,1,0,0,0,0,
  0,1,0,0,0,0,
  0,1,0,0,0,0,
  0,1,0,1,1,0,
  0,0,0,0,0,1,
  0,0,0,0,1,0,
  0,0,0,1,0,0,
  0,0,0,1,1,1,
  0,0,0,0,0,0
, // 0x5d Right Arrow
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,1,0,0,
  0,0,0,0,1,0,
  0,1,1,1,1,1,
  0,0,0,0,1,0,
  0,0,0,1,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0
, // 0x5e Up Arrow
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,1,0,0,
  0,0,1,1,1,0,
  0,1,0,1,0,1,
  0,0,0,1,0,0,
  0,0,0,1,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0
, // 0x5f '#'
  0,0,0,0,0,0,
  0,0,1,0,1,0,
  0,0,1,0,1,0,
  0,1,1,1,1,1,
  0,0,1,0,1,0,
  0,1,1,1,1,1,
  0,0,1,0,1,0,
  0,0,1,0,1,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0
, // 0x60 '_'
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,1,1,1,1,1,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0
, // 0x61 'a'
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,1,1,1,0,
  0,0,0,0,0,1,
  0,0,1,1,1,1,
  0,1,0,0,0,1,
  0,0,1,1,1,1,
  0,0,0,0,0,0,
  0,0,0,0,0,0
, // 0x62 'b'
  0,0,0,0,0,0,
  0,1,0,0,0,0,
  0,1,0,0,0,0,
  0,1,1,1,1,0,
  0,1,0,0,0,1,
  0,1,0,0,0,1,
  0,1,0,0,0,1,
  0,1,1,1,1,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0
, // 0x63 'c'
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,1,1,1,1,
  0,1,0,0,0,0,
  0,1,0,0,0,0,
  0,1,0,0,0,0,
  0,0,1,1,1,1,
  0,0,0,0,0,0,
  0,0,0,0,0,0
, // 0x64 'd'
  0,0,0,0,0,0,
  0,0,0,0,0,1,
  0,0,0,0,0,1,
  0,0,1,1,1,1,
  0,1,0,0,0,1,
  0,1,0,0,0,1,
  0,1,0,0,0,1,
  0,0,1,1,1,1,
  0,0,0,0,0,0,
  0,0,0,0,0,0
, // 0x65 'e'
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,1,1,1,0,
  0,1,0,0,0,1,
  0,1,1,1,1,1,
  0,1,0,0,0,0,
  0,0,1,1,1,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0
, // 0x66 'f'
  0,0,0,0,0,0,
  0,0,0,0,1,0,
  0,0,0,1,0,0,
  0,0,0,1,0,0,
  0,0,1,1,1,0,
  0,0,0,1,0,0,
  0,0,0,1,0,0,
  0,0,0,1,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0
, // 0x67 'g'
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,1,1,1,1,
  0,1,0,0,0,1,
  0,1,0,0,0,1,
  0,1,0,0,0,1,
  0,0,1,1,1,1,
  0,0,0,0,0,1,
  0,0,1,1,1,0
, // 0x68 'h'
  0,0,0,0,0,0,
  0,1,0,0,0,0,
  0,1,0,0,0,0,
  0,1,1,1,1,0,
  0,1,0,0,0,1,
  0,1,0,0,0,1,
  0,1,0,0,0,1,
  0,1,0,0,0,1,
  0,0,0,0,0,0,
  0,0,0,0,0,0
, // 0x69 'i'
  0,0,0,0,0,0,
  0,0,0,1,0,0,
  0,0,0,0,0,0,
  0,0,1,1,0,0,
  0,0,0,1,0,0,
  0,0,0,1,0,0,
  0,0,0,1,0,0,
  0,0,1,1,1,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0
, // 0x6a 'j'
  0,0,0,0,0,0,
  0,0,0,1,0,0,
  0,0,0,0,0,0,
  0,0,0,1,0,0,
  0,0,0,1,0,0,
  0,0,0,1,0,0,
  0,0,0,1,0,0,
  0,0,0,1,0,0,
  0,0,1,0,0,0,
  0,0,0,0,0,0
, // 0x6b 'k'
  0,0,0,0,0,0,
  0,0,1,0,0,0,
  0,0,1,0,0,0,
  0,0,1,0,0,1,
  0,0,1,0,1,0,
  0,0,1,1,0,0,
  0,0,1,0,1,0,
  0,0,1,0,0,1,
  0,0,0,0,0,0,
  0,0,0,0,0,0
, // 0x6c 'l'
  0,0,0,0,0,0,
  0,0,1,1,0,0,
  0,0,0,1,0,0,
  0,0,0,1,0,0,
  0,0,0,1,0,0,
  0,0,0,1,0,0,
  0,0,0,1,0,0,
  0,0,1,1,1,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0
, // 0x6d 'm'
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,1,1,0,1,0,
  0,1,0,1,0,1,
  0,1,0,1,0,1,
  0,1,0,1,0,1,
  0,1,0,1,0,1,
  0,0,0,0,0,0,
  0,0,0,0,0,0
, // 0x6e 'n'
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,1,1,1,1,0,
  0,1,0,0,0,1,
  0,1,0,0,0,1,
  0,1,0,0,0,1,
  0,1,0,0,0,1,
  0,0,0,0,0,0,
  0,0,0,0,0,0
, // 0x6f 'o'
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,1,1,1,0,
  0,1,0,0,0,1,
  0,1,0,0,0,1,
  0,1,0,0,0,1,
  0,0,1,1,1,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0
, // 0x70 'p'
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,1,1,1,1,0,
  0,1,0,0,0,1,
  0,1,0,0,0,1,
  0,1,0,0,0,1,
  0,1,1,1,1,0,
  0,1,0,0,0,0,
  0,1,0,0,0,0
, // 0x71 'q'
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,1,1,1,1,
  0,1,0,0,0,1,
  0,1,0,0,0,1,
  0,1,0,0,0,1,
  0,0,1,1,1,1,
  0,0,0,0,0,1,
  0,0,0,0,0,1
, // 0x72 'r'
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,1,0,1,1,
  0,0,1,1,0,0,
  0,0,1,0,0,0,
  0,0,1,0,0,0,
  0,0,1,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0
, // 0x73 's'
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,1,1,1,1,
  0,1,0,0,0,0,
  0,0,1,1,1,0,
  0,0,0,0,0,1,
  0,1,1,1,1,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0
, // 0x74 't'
  0,0,0,0,0,0,
  0,0,0,1,0,0,
  0,0,0,1,0,0,
  0,0,1,1,1,0,
  0,0,0,1,0,0,
  0,0,0,1,0,0,
  0,0,0,1,0,0,
  0,0,0,0,1,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0
, // 0x75 'u'
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,1,0,0,0,1,
  0,1,0,0,0,1,
  0,1,0,0,0,1,
  0,1,0,0,0,1,
  0,0,1,1,1,1,
  0,0,0,0,0,0,
  0,0,0,0,0,0
, // 0x76 'v'
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,1,0,0,0,1,
  0,1,0,0,0,1,
  0,0,1,0,1,0,
  0,0,1,0,1,0,
  0,0,0,1,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0
, // 0x77 'w'
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,1,0,0,0,1,
  0,1,0,0,0,1,
  0,1,0,1,0,1,
  0,1,0,1,0,1,
  0,0,1,0,1,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0
, // 0x78 'x'
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,1,0,0,0,1,
  0,0,1,0,1,0,
  0,0,0,1,0,0,
  0,0,1,0,1,0,
  0,1,0,0,0,1,
  0,0,0,0,0,0,
  0,0,0,0,0,0
, // 0x79 'y'
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,1,0,0,0,1,
  0,1,0,0,0,1,
  0,1,0,0,0,1,
  0,1,0,0,0,1,
  0,0,1,1,1,1,
  0,0,0,0,0,1,
  0,0,1,1,1,0
, // 0x7a 'z'
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,1,1,1,1,1,
  0,0,0,0,1,0,
  0,0,0,1,0,0,
  0,0,1,0,0,0,
  0,1,1,1,1,1,
  0,0,0,0,0,0,
  0,0,0,0,0,0
, // 0x7b 'one fourth symbol'
  0,0,0,0,0,0,
  0,0,1,0,0,0,
  0,0,1,0,0,0,
  0,0,1,0,0,0,
  0,0,1,0,0,1,
  0,0,0,0,1,1,
  0,0,0,1,0,1,
  0,0,0,1,1,1,
  0,0,0,0,0,1,
  0,0,0,0,0,0
, // 0x7c '|'
  0,0,0,0,0,0,
  0,0,1,0,1,0,
  0,0,1,0,1,0,
  0,0,1,0,1,0,
  0,0,1,0,1,0,
  0,0,1,0,1,0,
  0,0,1,0,1,0,
  0,0,1,0,1,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0
, // 0x7d ' three fourths symbol'
  0,0,0,0,0,0,
  0,1,1,0,0,0,
  0,0,0,1,0,0,
  0,1,1,0,0,0,
  0,0,0,1,0,0,
  0,1,1,0,0,1,
  0,0,0,0,1,1,
  0,0,0,1,0,1,
  0,0,0,1,1,1,
  0,0,0,0,0,1
, // 0x7e Divide
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,1,0,0,
  0,0,0,0,0,0,
  0,1,1,1,1,1,
  0,0,0,0,0,0,
  0,0,0,1,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0
, // 0x7f Block
  0,0,0,0,0,0,
  0,1,1,1,1,1,
  0,1,1,1,1,1,
  0,1,1,1,1,1,
  0,1,1,1,1,1,
  0,1,1,1,1,1,
  0,1,1,1,1,1,
  0,1,1,1,1,1,
  0,0,0,0,0,0,
  0,0,0,0,0,0
};


/* Graphics Character Set */

static char teletext_graphics[96*60]={
  // 0x20
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0
, // 0x21
  1,1,1,0,0,0,
  1,1,1,0,0,0,
  1,1,1,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0
, // 0x22
  0,0,0,1,1,1,
  0,0,0,1,1,1,
  0,0,0,1,1,1,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0
, // 0x23
  1,1,1,1,1,1,
  1,1,1,1,1,1,
  1,1,1,1,1,1,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0
, // 0x24
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  1,1,1,0,0,0,
  1,1,1,0,0,0,
  1,1,1,0,0,0,
  1,1,1,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0
, // 0x25
  1,1,1,0,0,0,
  1,1,1,0,0,0,
  1,1,1,0,0,0,
  1,1,1,0,0,0,
  1,1,1,0,0,0,
  1,1,1,0,0,0,
  1,1,1,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0
, // 0x26
  0,0,0,1,1,1,
  0,0,0,1,1,1,
  0,0,0,1,1,1,
  1,1,1,0,0,0,
  1,1,1,0,0,0,
  1,1,1,0,0,0,
  1,1,1,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0
, // 0x27
  1,1,1,1,1,1,
  1,1,1,1,1,1,
  1,1,1,1,1,1,
  1,1,1,0,0,0,
  1,1,1,0,0,0,
  1,1,1,0,0,0,
  1,1,1,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0
, // 0x28
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,1,1,1,
  0,0,0,1,1,1,
  0,0,0,1,1,1,
  0,0,0,1,1,1,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0
, // 0x29
  1,1,1,0,0,0,
  1,1,1,0,0,0,
  1,1,1,0,0,0,
  0,0,0,1,1,1,
  0,0,0,1,1,1,
  0,0,0,1,1,1,
  0,0,0,1,1,1,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0
, // 0x2a
  0,0,0,1,1,1,
  0,0,0,1,1,1,
  0,0,0,1,1,1,
  0,0,0,1,1,1,
  0,0,0,1,1,1,
  0,0,0,1,1,1,
  0,0,0,1,1,1,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0
, // 0x2b
  1,1,1,1,1,1,
  1,1,1,1,1,1,
  1,1,1,1,1,1,
  0,0,0,1,1,1,
  0,0,0,1,1,1,
  0,0,0,1,1,1,
  0,0,0,1,1,1,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0
, // 0x2c
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  1,1,1,1,1,1,
  1,1,1,1,1,1,
  1,1,1,1,1,1,
  1,1,1,1,1,1,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0
, // 0x2d
  1,1,1,0,0,0,
  1,1,1,0,0,0,
  1,1,1,0,0,0,
  1,1,1,1,1,1,
  1,1,1,1,1,1,
  1,1,1,1,1,1,
  1,1,1,1,1,1,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0
, // 0x2e
  0,0,0,1,1,1,
  0,0,0,1,1,1,
  0,0,0,1,1,1,
  1,1,1,1,1,1,
  1,1,1,1,1,1,
  1,1,1,1,1,1,
  1,1,1,1,1,1,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0
, // 0x2f
  1,1,1,1,1,1,
  1,1,1,1,1,1,
  1,1,1,1,1,1,
  1,1,1,1,1,1,
  1,1,1,1,1,1,
  1,1,1,1,1,1,
  1,1,1,1,1,1,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0
, // 0x30
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  1,1,1,0,0,0,
  1,1,1,0,0,0,
  1,1,1,0,0,0
, // 0x31
  1,1,1,0,0,0,
  1,1,1,0,0,0,
  1,1,1,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  1,1,1,0,0,0,
  1,1,1,0,0,0,
  1,1,1,0,0,0
, // 0x32
  0,0,0,1,1,1,
  0,0,0,1,1,1,
  0,0,0,1,1,1,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  1,1,1,0,0,0,
  1,1,1,0,0,0,
  1,1,1,0,0,0
, // 0x33
  1,1,1,1,1,1,
  1,1,1,1,1,1,
  1,1,1,1,1,1,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  1,1,1,0,0,0,
  1,1,1,0,0,0,
  1,1,1,0,0,0
, // 0x34
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  1,1,1,0,0,0,
  1,1,1,0,0,0,
  1,1,1,0,0,0,
  1,1,1,0,0,0,
  1,1,1,0,0,0,
  1,1,1,0,0,0,
  1,1,1,0,0,0
, // 0x35
  1,1,1,0,0,0,
  1,1,1,0,0,0,
  1,1,1,0,0,0,
  1,1,1,0,0,0,
  1,1,1,0,0,0,
  1,1,1,0,0,0,
  1,1,1,0,0,0,
  1,1,1,0,0,0,
  1,1,1,0,0,0,
  1,1,1,0,0,0
, // 0x36
  0,0,0,1,1,1,
  0,0,0,1,1,1,
  0,0,0,1,1,1,
  1,1,1,0,0,0,
  1,1,1,0,0,0,
  1,1,1,0,0,0,
  1,1,1,0,0,0,
  1,1,1,0,0,0,
  1,1,1,0,0,0,
  1,1,1,0,0,0
, // 0x37
  1,1,1,1,1,1,
  1,1,1,1,1,1,
  1,1,1,1,1,1,
  1,1,1,0,0,0,
  1,1,1,0,0,0,
  1,1,1,0,0,0,
  1,1,1,0,0,0,
  1,1,1,0,0,0,
  1,1,1,0,0,0,
  1,1,1,0,0,0
, // 0x38
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,1,1,1,
  0,0,0,1,1,1,
  0,0,0,1,1,1,
  0,0,0,1,1,1,
  1,1,1,0,0,0,
  1,1,1,0,0,0,
  1,1,1,0,0,0
, // 0x39
  1,1,1,0,0,0,
  1,1,1,0,0,0,
  1,1,1,0,0,0,
  0,0,0,1,1,1,
  0,0,0,1,1,1,
  0,0,0,1,1,1,
  0,0,0,1,1,1,
  1,1,1,0,0,0,
  1,1,1,0,0,0,
  1,1,1,0,0,0
, // 0x3a
  0,0,0,1,1,1,
  0,0,0,1,1,1,
  0,0,0,1,1,1,
  0,0,0,1,1,1,
  0,0,0,1,1,1,
  0,0,0,1,1,1,
  0,0,0,1,1,1,
  1,1,1,0,0,0,
  1,1,1,0,0,0,
  1,1,1,0,0,0
, // 0x3b
  1,1,1,1,1,1,
  1,1,1,1,1,1,
  1,1,1,1,1,1,
  0,0,0,1,1,1,
  0,0,0,1,1,1,
  0,0,0,1,1,1,
  0,0,0,1,1,1,
  1,1,1,0,0,0,
  1,1,1,0,0,0,
  1,1,1,0,0,0
, // 0x3c
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  1,1,1,1,1,1,
  1,1,1,1,1,1,
  1,1,1,1,1,1,
  1,1,1,1,1,1,
  1,1,1,0,0,0,
  1,1,1,0,0,0,
  1,1,1,0,0,0
, // 0x3d
  1,1,1,0,0,0,
  1,1,1,0,0,0,
  1,1,1,0,0,0,
  1,1,1,1,1,1,
  1,1,1,1,1,1,
  1,1,1,1,1,1,
  1,1,1,1,1,1,
  1,1,1,0,0,0,
  1,1,1,0,0,0,
  1,1,1,0,0,0
, // 0x3e
  0,0,0,1,1,1,
  0,0,0,1,1,1,
  0,0,0,1,1,1,
  1,1,1,1,1,1,
  1,1,1,1,1,1,
  1,1,1,1,1,1,
  1,1,1,1,1,1,
  1,1,1,0,0,0,
  1,1,1,0,0,0,
  1,1,1,0,0,0
, // 0x3f
  1,1,1,1,1,1,
  1,1,1,1,1,1,
  1,1,1,1,1,1,
  1,1,1,1,1,1,
  1,1,1,1,1,1,
  1,1,1,1,1,1,
  1,1,1,1,1,1,
  1,1,1,0,0,0,
  1,1,1,0,0,0,
  1,1,1,0,0,0
, // 0x40 '@'
  0,0,0,0,0,0,
  0,0,1,1,1,0,
  0,1,0,0,0,1,
  0,1,0,1,1,1,
  0,1,0,1,0,1,
  0,1,0,1,1,1,
  0,1,0,0,0,0,
  0,0,1,1,1,1,
  0,0,0,0,0,0,
  0,0,0,0,0,0
, // 0x41 'A'
  0,0,0,0,0,0,
  0,0,0,1,0,0,
  0,0,1,0,1,0,
  0,1,0,0,0,1,
  0,1,0,0,0,1,
  0,1,1,1,1,1,
  0,1,0,0,0,1,
  0,1,0,0,0,1,
  0,0,0,0,0,0,
  0,0,0,0,0,0
, // 0x42 'B'
  0,0,0,0,0,0,
  0,1,1,1,1,0,
  0,1,0,0,0,1,
  0,1,0,0,0,1,
  0,1,1,1,1,0,
  0,1,0,0,0,1,
  0,1,0,0,0,1,
  0,1,1,1,1,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0
, // 0x43 'C'
  0,0,0,0,0,0,
  0,0,1,1,1,0,
  0,1,0,0,0,1,
  0,1,0,0,0,0,
  0,1,0,0,0,0,
  0,1,0,0,0,0,
  0,1,0,0,0,1,
  0,0,1,1,1,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0
, // 0x44 'D'
  0,0,0,0,0,0,
  0,1,1,1,1,0,
  0,1,0,0,0,1,
  0,1,0,0,0,1,
  0,1,0,0,0,1,
  0,1,0,0,0,1,
  0,1,0,0,0,1,
  0,1,1,1,1,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0
, // 0x45 'E'
  0,0,0,0,0,0,
  0,1,1,1,1,1,
  0,1,0,0,0,0,
  0,1,0,0,0,0,
  0,1,1,1,1,0,
  0,1,0,0,0,0,
  0,1,0,0,0,0,
  0,1,1,1,1,1,
  0,0,0,0,0,0,
  0,0,0,0,0,0
, // 0x46 'F'
  0,0,0,0,0,0,
  0,1,1,1,1,1,
  0,1,0,0,0,0,
  0,1,0,0,0,0,
  0,1,1,1,1,0,
  0,1,0,0,0,0,
  0,1,0,0,0,0,
  0,1,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0
, // 0x47 'G'
  0,0,0,0,0,0,
  0,0,1,1,1,0,
  0,1,0,0,0,1,
  0,1,0,0,0,0,
  0,1,0,0,0,0,
  0,1,0,0,1,1,
  0,1,0,0,0,1,
  0,0,1,1,1,1,
  0,0,0,0,0,0,
  0,0,0,0,0,0
, // 0x48 'H'
  0,0,0,0,0,0,
  0,1,0,0,0,1,
  0,1,0,0,0,1,
  0,1,0,0,0,1,
  0,1,1,1,1,1,
  0,1,0,0,0,1,
  0,1,0,0,0,1,
  0,1,0,0,0,1,
  0,0,0,0,0,0,
  0,0,0,0,0,0
, // 0x49 'I'
  0,0,0,0,0,0,
  0,0,1,1,1,0,
  0,0,0,1,0,0,
  0,0,0,1,0,0,
  0,0,0,1,0,0,
  0,0,0,1,0,0,
  0,0,0,1,0,0,
  0,0,1,1,1,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0
, // 0x4a 'J'
  0,0,0,0,0,0,
  0,0,0,0,0,1,
  0,0,0,0,0,1,
  0,0,0,0,0,1,
  0,0,0,0,0,1,
  0,0,0,0,0,1,
  0,1,0,0,0,1,
  0,0,1,1,1,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0
, // 0x4b 'K'
  0,0,0,0,0,0,
  0,1,0,0,0,1,
  0,1,0,0,1,0,
  0,1,0,1,0,0,
  0,1,1,0,0,0,
  0,1,0,1,0,0,
  0,1,0,0,1,0,
  0,1,0,0,0,1,
  0,0,0,0,0,0,
  0,0,0,0,0,0
, // 0x4c 'L'
  0,0,0,0,0,0,
  0,1,0,0,0,0,
  0,1,0,0,0,0,
  0,1,0,0,0,0,
  0,1,0,0,0,0,
  0,1,0,0,0,0,
  0,1,0,0,0,0,
  0,1,1,1,1,1,
  0,0,0,0,0,0,
  0,0,0,0,0,0
, // 0x4d 'M'
  0,0,0,0,0,0,
  0,1,0,0,0,1,
  0,1,1,0,1,1,
  0,1,0,1,0,1,
  0,1,0,0,0,1,
  0,1,0,0,0,1,
  0,1,0,0,0,1,
  0,1,0,0,0,1,
  0,0,0,0,0,0,
  0,0,0,0,0,0
, // 0x4e 'N'
  0,0,0,0,0,0,
  0,1,0,0,0,1,
  0,1,0,0,0,1,
  0,1,1,0,0,1,
  0,1,0,1,0,1,
  0,1,0,0,1,1,
  0,1,0,0,0,1,
  0,1,0,0,0,1,
  0,0,0,0,0,0,
  0,0,0,0,0,0
, // 0x4f 'O'
  0,0,0,0,0,0,
  0,0,1,1,1,0,
  0,1,0,0,0,1,
  0,1,0,0,0,1,
  0,1,0,0,0,1,
  0,1,0,0,0,1,
  0,1,0,0,0,1,
  0,0,1,1,1,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0
, // 0x50 'P'
  0,0,0,0,0,0,
  0,1,1,1,1,0,
  0,1,0,0,0,1,
  0,1,0,0,0,1,
  0,1,1,1,1,0,
  0,1,0,0,0,0,
  0,1,0,0,0,0,
  0,1,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0
, // 0x51 'Q'
  0,0,0,0,0,0,
  0,0,1,1,1,0,
  0,1,0,0,0,1,
  0,1,0,0,0,1,
  0,1,0,0,0,1,
  0,1,0,1,0,1,
  0,1,0,0,1,0,
  0,0,1,1,0,1,
  0,0,0,0,0,0,
  0,0,0,0,0,0
, // 0x52 'R'
  0,0,0,0,0,0,
  0,1,1,1,1,0,
  0,1,0,0,0,1,
  0,1,0,0,0,1,
  0,1,1,1,1,0,
  0,1,0,1,0,0,
  0,1,0,0,1,0,
  0,1,0,0,0,1,
  0,0,0,0,0,0,
  0,0,0,0,0,0
, // 0x53 'S'
  0,0,0,0,0,0,
  0,0,1,1,1,0,
  0,1,0,0,0,1,
  0,1,0,0,0,0,
  0,0,1,1,1,0,
  0,0,0,0,0,1,
  0,1,0,0,0,1,
  0,0,1,1,1,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0
, // 0x54 'T'
  0,0,0,0,0,0,
  0,1,1,1,1,1,
  0,0,0,1,0,0,
  0,0,0,1,0,0,
  0,0,0,1,0,0,
  0,0,0,1,0,0,
  0,0,0,1,0,0,
  0,0,0,1,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0
, // 0x55 'U'
  0,0,0,0,0,0,
  0,1,0,0,0,1,
  0,1,0,0,0,1,
  0,1,0,0,0,1,
  0,1,0,0,0,1,
  0,1,0,0,0,1,
  0,1,0,0,0,1,
  0,0,1,1,1,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0
, // 0x56 'V'
  0,0,0,0,0,0,
  0,1,0,0,0,1,
  0,1,0,0,0,1,
  0,1,0,0,0,1,
  0,0,1,0,1,0,
  0,0,1,0,1,0,
  0,0,0,1,0,0,
  0,0,0,1,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0
, // 0x57 'W'
  0,0,0,0,0,0,
  0,1,0,0,0,1,
  0,1,0,0,0,1,
  0,1,0,0,0,1,
  0,1,0,1,0,1,
  0,1,0,1,0,1,
  0,1,0,1,0,1,
  0,0,1,0,1,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0
, // 0x58 'X'
  0,0,0,0,0,0,
  0,1,0,0,0,1,
  0,1,0,0,0,1,
  0,0,1,0,1,0,
  0,0,0,1,0,0,
  0,0,1,0,1,0,
  0,1,0,0,0,1,
  0,1,0,0,0,1,
  0,0,0,0,0,0,
  0,0,0,0,0,0
, // 0x59 'Y'
  0,0,0,0,0,0,
  0,1,0,0,0,1,
  0,1,0,0,0,1,
  0,0,1,0,1,0,
  0,0,0,1,0,0,
  0,0,0,1,0,0,
  0,0,0,1,0,0,
  0,0,0,1,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0
, // 0x5a 'Z'
  0,0,0,0,0,0,
  0,1,1,1,1,1,
  0,0,0,0,0,1,
  0,0,0,0,1,0,
  0,0,0,1,0,0,
  0,0,1,0,0,0,
  0,1,0,0,0,0,
  0,1,1,1,1,1,
  0,0,0,0,0,0,
  0,0,0,0,0,0
, // 0x5b Left Arrow
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,1,0,0,
  0,0,1,0,0,0,
  0,1,1,1,1,1,
  0,0,1,0,0,0,
  0,0,0,1,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0
, // 0x5c ''
  0,0,0,0,0,0,
  0,1,0,0,0,0,
  0,1,0,0,0,0,
  0,1,0,0,0,0,
  0,1,0,1,1,0,
  0,0,0,0,0,1,
  0,0,0,0,1,0,
  0,0,0,1,0,0,
  0,0,0,1,1,1,
  0,0,0,0,0,0
, // 0x5d Right Arrow
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,1,0,0,
  0,0,0,0,1,0,
  0,1,1,1,1,1,
  0,0,0,0,1,0,
  0,0,0,1,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0
, // 0x5e Up Arrow
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,1,0,0,
  0,0,1,1,1,0,
  0,1,0,1,0,1,
  0,0,0,1,0,0,
  0,0,0,1,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0
, // 0x5f '#'
  0,0,0,0,0,0,
  0,0,1,0,1,0,
  0,0,1,0,1,0,
  0,1,1,1,1,1,
  0,0,1,0,1,0,
  0,1,1,1,1,1,
  0,0,1,0,1,0,
  0,0,1,0,1,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0
, // 0x60
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,1,1,1,
  0,0,0,1,1,1,
  0,0,0,1,1,1
, // 0x61
  1,1,1,0,0,0,
  1,1,1,0,0,0,
  1,1,1,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,1,1,1,
  0,0,0,1,1,1,
  0,0,0,1,1,1
, // 0x62
  0,0,0,1,1,1,
  0,0,0,1,1,1,
  0,0,0,1,1,1,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,1,1,1,
  0,0,0,1,1,1,
  0,0,0,1,1,1
, // 0x63
  1,1,1,1,1,1,
  1,1,1,1,1,1,
  1,1,1,1,1,1,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,1,1,1,
  0,0,0,1,1,1,
  0,0,0,1,1,1
, // 0x64
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  1,1,1,0,0,0,
  1,1,1,0,0,0,
  1,1,1,0,0,0,
  1,1,1,0,0,0,
  0,0,0,1,1,1,
  0,0,0,1,1,1,
  0,0,0,1,1,1
, // 0x65
  1,1,1,0,0,0,
  1,1,1,0,0,0,
  1,1,1,0,0,0,
  1,1,1,0,0,0,
  1,1,1,0,0,0,
  1,1,1,0,0,0,
  1,1,1,0,0,0,
  0,0,0,1,1,1,
  0,0,0,1,1,1,
  0,0,0,1,1,1
, // 0x66
  0,0,0,1,1,1,
  0,0,0,1,1,1,
  0,0,0,1,1,1,
  1,1,1,0,0,0,
  1,1,1,0,0,0,
  1,1,1,0,0,0,
  1,1,1,0,0,0,
  0,0,0,1,1,1,
  0,0,0,1,1,1,
  0,0,0,1,1,1
, // 0x67
  1,1,1,1,1,1,
  1,1,1,1,1,1,
  1,1,1,1,1,1,
  1,1,1,0,0,0,
  1,1,1,0,0,0,
  1,1,1,0,0,0,
  1,1,1,0,0,0,
  0,0,0,1,1,1,
  0,0,0,1,1,1,
  0,0,0,1,1,1
, // 0x68
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,1,1,1,
  0,0,0,1,1,1,
  0,0,0,1,1,1,
  0,0,0,1,1,1,
  0,0,0,1,1,1,
  0,0,0,1,1,1,
  0,0,0,1,1,1
, // 0x69
  1,1,1,0,0,0,
  1,1,1,0,0,0,
  1,1,1,0,0,0,
  0,0,0,1,1,1,
  0,0,0,1,1,1,
  0,0,0,1,1,1,
  0,0,0,1,1,1,
  0,0,0,1,1,1,
  0,0,0,1,1,1,
  0,0,0,1,1,1
, // 0x6a
  0,0,0,1,1,1,
  0,0,0,1,1,1,
  0,0,0,1,1,1,
  0,0,0,1,1,1,
  0,0,0,1,1,1,
  0,0,0,1,1,1,
  0,0,0,1,1,1,
  0,0,0,1,1,1,
  0,0,0,1,1,1,
  0,0,0,1,1,1
, // 0x6b
  1,1,1,1,1,1,
  1,1,1,1,1,1,
  1,1,1,1,1,1,
  0,0,0,1,1,1,
  0,0,0,1,1,1,
  0,0,0,1,1,1,
  0,0,0,1,1,1,
  0,0,0,1,1,1,
  0,0,0,1,1,1,
  0,0,0,1,1,1
, // 0x6c
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  1,1,1,1,1,1,
  1,1,1,1,1,1,
  1,1,1,1,1,1,
  1,1,1,1,1,1,
  0,0,0,1,1,1,
  0,0,0,1,1,1,
  0,0,0,1,1,1
, // 0x6d
  1,1,1,0,0,0,
  1,1,1,0,0,0,
  1,1,1,0,0,0,
  1,1,1,1,1,1,
  1,1,1,1,1,1,
  1,1,1,1,1,1,
  1,1,1,1,1,1,
  0,0,0,1,1,1,
  0,0,0,1,1,1,
  0,0,0,1,1,1
, // 0x6e
  0,0,0,1,1,1,
  0,0,0,1,1,1,
  0,0,0,1,1,1,
  1,1,1,1,1,1,
  1,1,1,1,1,1,
  1,1,1,1,1,1,
  1,1,1,1,1,1,
  0,0,0,1,1,1,
  0,0,0,1,1,1,
  0,0,0,1,1,1
, // 0x6f
  1,1,1,1,1,1,
  1,1,1,1,1,1,
  1,1,1,1,1,1,
  1,1,1,1,1,1,
  1,1,1,1,1,1,
  1,1,1,1,1,1,
  1,1,1,1,1,1,
  0,0,0,1,1,1,
  0,0,0,1,1,1,
  0,0,0,1,1,1
, // 0x70
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  1,1,1,1,1,1,
  1,1,1,1,1,1,
  1,1,1,1,1,1
, // 0x71
  1,1,1,0,0,0,
  1,1,1,0,0,0,
  1,1,1,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  1,1,1,1,1,1,
  1,1,1,1,1,1,
  1,1,1,1,1,1
, // 0x72
  0,0,0,1,1,1,
  0,0,0,1,1,1,
  0,0,0,1,1,1,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  1,1,1,1,1,1,
  1,1,1,1,1,1,
  1,1,1,1,1,1
, // 0x73
  1,1,1,1,1,1,
  1,1,1,1,1,1,
  1,1,1,1,1,1,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  1,1,1,1,1,1,
  1,1,1,1,1,1,
  1,1,1,1,1,1
, // 0x74
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  1,1,1,0,0,0,
  1,1,1,0,0,0,
  1,1,1,0,0,0,
  1,1,1,0,0,0,
  1,1,1,1,1,1,
  1,1,1,1,1,1,
  1,1,1,1,1,1
, // 0x75
  1,1,1,0,0,0,
  1,1,1,0,0,0,
  1,1,1,0,0,0,
  1,1,1,0,0,0,
  1,1,1,0,0,0,
  1,1,1,0,0,0,
  1,1,1,0,0,0,
  1,1,1,1,1,1,
  1,1,1,1,1,1,
  1,1,1,1,1,1
, // 0x76
  0,0,0,1,1,1,
  0,0,0,1,1,1,
  0,0,0,1,1,1,
  1,1,1,0,0,0,
  1,1,1,0,0,0,
  1,1,1,0,0,0,
  1,1,1,0,0,0,
  1,1,1,1,1,1,
  1,1,1,1,1,1,
  1,1,1,1,1,1
, // 0x77
  1,1,1,1,1,1,
  1,1,1,1,1,1,
  1,1,1,1,1,1,
  1,1,1,0,0,0,
  1,1,1,0,0,0,
  1,1,1,0,0,0,
  1,1,1,0,0,0,
  1,1,1,1,1,1,
  1,1,1,1,1,1,
  1,1,1,1,1,1
, // 0x78
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,1,1,1,
  0,0,0,1,1,1,
  0,0,0,1,1,1,
  0,0,0,1,1,1,
  1,1,1,1,1,1,
  1,1,1,1,1,1,
  1,1,1,1,1,1
, // 0x79
  1,1,1,0,0,0,
  1,1,1,0,0,0,
  1,1,1,0,0,0,
  0,0,0,1,1,1,
  0,0,0,1,1,1,
  0,0,0,1,1,1,
  0,0,0,1,1,1,
  1,1,1,1,1,1,
  1,1,1,1,1,1,
  1,1,1,1,1,1
, // 0x7a
  0,0,0,1,1,1,
  0,0,0,1,1,1,
  0,0,0,1,1,1,
  0,0,0,1,1,1,
  0,0,0,1,1,1,
  0,0,0,1,1,1,
  0,0,0,1,1,1,
  1,1,1,1,1,1,
  1,1,1,1,1,1,
  1,1,1,1,1,1
, // 0x7b
  1,1,1,1,1,1,
  1,1,1,1,1,1,
  1,1,1,1,1,1,
  0,0,0,1,1,1,
  0,0,0,1,1,1,
  0,0,0,1,1,1,
  0,0,0,1,1,1,
  1,1,1,1,1,1,
  1,1,1,1,1,1,
  1,1,1,1,1,1
, // 0x7c
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  1,1,1,1,1,1,
  1,1,1,1,1,1,
  1,1,1,1,1,1,
  1,1,1,1,1,1,
  1,1,1,1,1,1,
  1,1,1,1,1,1,
  1,1,1,1,1,1
, // 0x7d
  1,1,1,0,0,0,
  1,1,1,0,0,0,
  1,1,1,0,0,0,
  1,1,1,1,1,1,
  1,1,1,1,1,1,
  1,1,1,1,1,1,
  1,1,1,1,1,1,
  1,1,1,1,1,1,
  1,1,1,1,1,1,
  1,1,1,1,1,1
, // 0x7e
  0,0,0,1,1,1,
  0,0,0,1,1,1,
  0,0,0,1,1,1,
  1,1,1,1,1,1,
  1,1,1,1,1,1,
  1,1,1,1,1,1,
  1,1,1,1,1,1,
  1,1,1,1,1,1,
  1,1,1,1,1,1,
  1,1,1,1,1,1
, // 0x7f
  1,1,1,1,1,1,
  1,1,1,1,1,1,
  1,1,1,1,1,1,
  1,1,1,1,1,1,
  1,1,1,1,1,1,
  1,1,1,1,1,1,
  1,1,1,1,1,1,
  1,1,1,1,1,1,
  1,1,1,1,1,1,
  1,1,1,1,1,1
};

/* Separated Graphics Character Set */

static char teletext_separated_graphics[96*60]={
  // Character ' ' (32)
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0
,
  // Character '!' (33)
  1,1,0,0,0,0,
  1,1,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0
,
  // Character '"' (34)
  0,0,0,1,1,0,
  0,0,0,1,1,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0
,
  // Character '#' (35)
  1,1,0,1,1,0,
  1,1,0,1,1,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0
,
  // Character '$' (36)
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  1,1,0,0,0,0,
  1,1,0,0,0,0,
  1,1,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0
,
  // Character '%' (37)
  1,1,0,0,0,0,
  1,1,0,0,0,0,
  0,0,0,0,0,0,
  1,1,0,0,0,0,
  1,1,0,0,0,0,
  1,1,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0
,
  // Character '&' (38)
  0,0,0,1,1,0,
  0,0,0,1,1,0,
  0,0,0,0,0,0,
  1,1,0,0,0,0,
  1,1,0,0,0,0,
  1,1,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0
,
  // Character ''' (39)
  1,1,0,1,1,0,
  1,1,0,1,1,0,
  0,0,0,0,0,0,
  1,1,0,0,0,0,
  1,1,0,0,0,0,
  1,1,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0
,
  // Character '(' (40)
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,1,1,0,
  0,0,0,1,1,0,
  0,0,0,1,1,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0
,
  // Character ')' (41)
  1,1,0,0,0,0,
  1,1,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,1,1,0,
  0,0,0,1,1,0,
  0,0,0,1,1,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0
,
  // Character '*' (42)
  0,0,0,1,1,0,
  0,0,0,1,1,0,
  0,0,0,1,1,0,
  0,0,0,0,0,0,
  0,0,0,1,1,0,
  0,0,0,1,1,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0
,
  // Character '+' (43)
  1,1,0,1,1,0,
  1,1,0,1,1,0,
  0,0,0,0,0,0,
  0,0,0,1,1,0,
  0,0,0,1,1,0,
  0,0,0,1,1,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0
,
  // Character ',' (44)
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  1,1,0,1,1,0,
  1,1,0,1,1,0,
  1,1,0,1,1,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0
,
  // Character '-' (45)
  1,1,0,0,0,0,
  1,1,0,0,0,0,
  0,0,0,0,0,0,
  1,1,0,1,1,0,
  1,1,0,1,1,0,
  1,1,0,1,1,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0
,
  // Character '.' (46)
  0,0,0,1,1,0,
  0,0,0,1,1,0,
  0,0,0,0,0,0,
  1,1,0,1,1,0,
  1,1,0,1,1,0,
  1,1,0,1,1,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0
,
  // Character '/' (47)
  1,1,0,1,1,0,
  1,1,0,1,1,0,
  0,0,0,0,0,0,
  1,1,0,1,1,0,
  1,1,0,1,1,0,
  1,1,0,1,1,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0
,
  // Character '0' (48)
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  1,1,0,0,0,0,
  1,1,0,0,0,0,
  0,0,0,0,0,0
,
  // Character '1' (49)
  1,1,0,0,0,0,
  1,1,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  1,1,0,0,0,0,
  1,1,0,0,0,0,
  0,0,0,0,0,0
,
  // Character '2' (50)
  0,0,0,1,1,0,
  0,0,0,1,1,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  1,1,0,0,0,0,
  1,1,0,0,0,0,
  0,0,0,0,0,0
,
  // Character '3' (51)
  1,1,0,1,1,0,
  1,1,0,1,1,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  1,1,0,0,0,0,
  1,1,0,0,0,0,
  0,0,0,0,0,0
,
  // Character '4' (52)
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  1,1,0,0,0,0,
  1,1,0,0,0,0,
  1,1,0,0,0,0,
  0,0,0,0,0,0,
  1,1,0,0,0,0,
  1,1,0,0,0,0,
  0,0,0,0,0,0
,
  // Character '5' (53)
  1,1,0,0,0,0,
  1,1,0,0,0,0,
  0,0,0,0,0,0,
  1,1,0,0,0,0,
  1,1,0,0,0,0,
  1,1,0,0,0,0,
  0,0,0,0,0,0,
  1,1,0,0,0,0,
  1,1,0,0,0,0,
  0,0,0,0,0,0
,
  // Character '6' (54)
  0,0,0,1,1,0,
  0,0,0,1,1,0,
  0,0,0,0,0,0,
  1,1,0,0,0,0,
  1,1,0,0,0,0,
  1,1,0,0,0,0,
  0,0,0,0,0,0,
  1,1,0,0,0,0,
  1,1,0,0,0,0,
  0,0,0,0,0,0
,
  // Character '7' (55)
  1,1,0,1,1,0,
  1,1,0,1,1,0,
  0,0,0,0,0,0,
  1,1,0,0,0,0,
  1,1,0,0,0,0,
  1,1,0,0,0,0,
  0,0,0,0,0,0,
  1,1,0,0,0,0,
  1,1,0,0,0,0,
  0,0,0,0,0,0
,
  // Character '8' (56)
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,1,1,0,
  0,0,0,1,1,0,
  0,0,0,1,1,0,
  0,0,0,0,0,0,
  1,1,0,0,0,0,
  1,1,0,0,0,0,
  0,0,0,0,0,0
,
  // Character '9' (57)
  1,1,0,0,0,0,
  1,1,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,1,1,0,
  0,0,0,1,1,0,
  0,0,0,1,1,0,
  0,0,0,0,0,0,
  1,1,0,0,0,0,
  1,1,0,0,0,0,
  0,0,0,0,0,0
,
  // Character ':' (58)
  0,0,0,1,1,0,
  0,0,0,1,1,0,
  0,0,0,0,0,0,
  0,0,0,1,1,0,
  0,0,0,1,1,0,
  0,0,0,1,1,0,
  0,0,0,0,0,0,
  1,1,0,0,0,0,
  1,1,0,0,0,0,
  0,0,0,0,0,0
,
  // Character ';' (59)
  1,1,0,1,1,0,
  1,1,0,1,1,0,
  0,0,0,0,0,0,
  0,0,0,1,1,0,
  0,0,0,1,1,0,
  0,0,0,1,1,0,
  0,0,0,0,0,0,
  1,1,0,0,0,0,
  1,1,0,0,0,0,
  0,0,0,0,0,0
,
  // Character '<' (60)
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  1,1,0,1,1,0,
  1,1,0,1,1,0,
  1,1,0,1,1,0,
  0,0,0,0,0,0,
  1,1,0,0,0,0,
  1,1,0,0,0,0,
  0,0,0,0,0,0
,
  // Character '=' (61)
  1,1,0,0,0,0,
  1,1,0,0,0,0,
  0,0,0,0,0,0,
  1,1,0,1,1,0,
  1,1,0,1,1,0,
  1,1,0,1,1,0,
  0,0,0,0,0,0,
  1,1,0,0,0,0,
  1,1,0,0,0,0,
  0,0,0,0,0,0
,
  // Character '>' (62)
  0,0,0,1,1,0,
  0,0,0,1,1,0,
  0,0,0,0,0,0,
  1,1,0,1,1,0,
  1,1,0,1,1,0,
  1,1,0,1,1,0,
  0,0,0,0,0,0,
  1,1,0,0,0,0,
  1,1,0,0,0,0,
  0,0,0,0,0,0
,
  // Character '?' (63)
  1,1,0,1,1,0,
  1,1,0,1,1,0,
  0,0,0,0,0,0,
  1,1,0,1,1,0,
  1,1,0,1,1,0,
  1,1,0,1,1,0,
  0,0,0,0,0,0,
  1,1,0,0,0,0,
  1,1,0,0,0,0,
  0,0,0,0,0,0
,
  // Character '@' (64)
  0,0,0,0,0,0,
  0,0,1,1,1,0,
  0,1,0,0,0,1,
  0,1,0,1,1,1,
  0,1,0,1,0,1,
  0,1,0,1,1,1,
  0,1,0,0,0,0,
  0,0,1,1,1,1,
  0,0,0,0,0,0,
  0,0,0,0,0,0
,
  // Character 'A' (65)
  0,0,0,0,0,0,
  0,0,0,1,0,0,
  0,0,1,0,1,0,
  0,1,0,0,0,1,
  0,1,0,0,0,1,
  0,1,1,1,1,1,
  0,1,0,0,0,1,
  0,1,0,0,0,1,
  0,0,0,0,0,0,
  0,0,0,0,0,0
,
  // Character 'B' (66)
  0,0,0,0,0,0,
  0,1,1,1,1,0,
  0,1,0,0,0,1,
  0,1,0,0,0,1,
  0,1,1,1,1,0,
  0,1,0,0,0,1,
  0,1,0,0,0,1,
  0,1,1,1,1,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0
,
  // Character 'C' (67)
  0,0,0,0,0,0,
  0,0,1,1,1,0,
  0,1,0,0,0,1,
  0,1,0,0,0,0,
  0,1,0,0,0,0,
  0,1,0,0,0,0,
  0,1,0,0,0,1,
  0,0,1,1,1,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0
,
  // Character 'D' (68)
  0,0,0,0,0,0,
  0,1,1,1,1,0,
  0,1,0,0,0,1,
  0,1,0,0,0,1,
  0,1,0,0,0,1,
  0,1,0,0,0,1,
  0,1,0,0,0,1,
  0,1,1,1,1,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0
,
  // Character 'E' (69)
  0,0,0,0,0,0,
  0,1,1,1,1,1,
  0,1,0,0,0,0,
  0,1,0,0,0,0,
  0,1,1,1,1,0,
  0,1,0,0,0,0,
  0,1,0,0,0,0,
  0,1,1,1,1,1,
  0,0,0,0,0,0,
  0,0,0,0,0,0
,
  // Character 'F' (70)
  0,0,0,0,0,0,
  0,1,1,1,1,1,
  0,1,0,0,0,0,
  0,1,0,0,0,0,
  0,1,1,1,1,0,
  0,1,0,0,0,0,
  0,1,0,0,0,0,
  0,1,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0
,
  // Character 'G' (71)
  0,0,0,0,0,0,
  0,0,1,1,1,0,
  0,1,0,0,0,1,
  0,1,0,0,0,0,
  0,1,0,0,0,0,
  0,1,0,0,1,1,
  0,1,0,0,0,1,
  0,0,1,1,1,1,
  0,0,0,0,0,0,
  0,0,0,0,0,0
,
  // Character 'H' (72)
  0,0,0,0,0,0,
  0,1,0,0,0,1,
  0,1,0,0,0,1,
  0,1,0,0,0,1,
  0,1,1,1,1,1,
  0,1,0,0,0,1,
  0,1,0,0,0,1,
  0,1,0,0,0,1,
  0,0,0,0,0,0,
  0,0,0,0,0,0
,
  // Character 'I' (73)
  0,0,0,0,0,0,
  0,0,1,1,1,0,
  0,0,0,1,0,0,
  0,0,0,1,0,0,
  0,0,0,1,0,0,
  0,0,0,1,0,0,
  0,0,0,1,0,0,
  0,0,1,1,1,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0
,
  // Character 'J' (74)
  0,0,0,0,0,0,
  0,0,0,0,0,1,
  0,0,0,0,0,1,
  0,0,0,0,0,1,
  0,0,0,0,0,1,
  0,0,0,0,0,1,
  0,1,0,0,0,1,
  0,0,1,1,1,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0
,
  // Character 'K' (75)
  0,0,0,0,0,0,
  0,1,0,0,0,1,
  0,1,0,0,1,0,
  0,1,0,1,0,0,
  0,1,1,0,0,0,
  0,1,0,1,0,0,
  0,1,0,0,1,0,
  0,1,0,0,0,1,
  0,0,0,0,0,0,
  0,0,0,0,0,0
,
  // Character 'L' (76)
  0,0,0,0,0,0,
  0,1,0,0,0,0,
  0,1,0,0,0,0,
  0,1,0,0,0,0,
  0,1,0,0,0,0,
  0,1,0,0,0,0,
  0,1,0,0,0,0,
  0,1,1,1,1,1,
  0,0,0,0,0,0,
  0,0,0,0,0,0
,
  // Character 'M' (77)
  0,0,0,0,0,0,
  0,1,0,0,0,1,
  0,1,1,0,1,1,
  0,1,0,1,0,1,
  0,1,0,0,0,1,
  0,1,0,0,0,1,
  0,1,0,0,0,1,
  0,1,0,0,0,1,
  0,0,0,0,0,0,
  0,0,0,0,0,0
,
  // Character 'N' (78)
  0,0,0,0,0,0,
  0,1,0,0,0,1,
  0,1,0,0,0,1,
  0,1,1,0,0,1,
  0,1,0,1,0,1,
  0,1,0,0,1,1,
  0,1,0,0,0,1,
  0,1,0,0,0,1,
  0,0,0,0,0,0,
  0,0,0,0,0,0
,
  // Character 'O' (79)
  0,0,0,0,0,0,
  0,0,1,1,1,0,
  0,1,0,0,0,1,
  0,1,0,0,0,1,
  0,1,0,0,0,1,
  0,1,0,0,0,1,
  0,1,0,0,0,1,
  0,0,1,1,1,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0
,
  // Character 'P' (80)
  0,0,0,0,0,0,
  0,1,1,1,1,0,
  0,1,0,0,0,1,
  0,1,0,0,0,1,
  0,1,1,1,1,0,
  0,1,0,0,0,0,
  0,1,0,0,0,0,
  0,1,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0
,
  // Character 'Q' (81)
  0,0,0,0,0,0,
  0,0,1,1,1,0,
  0,1,0,0,0,1,
  0,1,0,0,0,1,
  0,1,0,0,0,1,
  0,1,0,1,0,1,
  0,1,0,0,1,0,
  0,0,1,1,0,1,
  0,0,0,0,0,0,
  0,0,0,0,0,0
,
  // Character 'R' (82)
  0,0,0,0,0,0,
  0,1,1,1,1,0,
  0,1,0,0,0,1,
  0,1,0,0,0,1,
  0,1,1,1,1,0,
  0,1,0,1,0,0,
  0,1,0,0,1,0,
  0,1,0,0,0,1,
  0,0,0,0,0,0,
  0,0,0,0,0,0
,
  // Character 'S' (83)
  0,0,0,0,0,0,
  0,0,1,1,1,0,
  0,1,0,0,0,1,
  0,1,0,0,0,0,
  0,0,1,1,1,0,
  0,0,0,0,0,1,
  0,1,0,0,0,1,
  0,0,1,1,1,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0
,
  // Character 'T' (84)
  0,0,0,0,0,0,
  0,1,1,1,1,1,
  0,0,0,1,0,0,
  0,0,0,1,0,0,
  0,0,0,1,0,0,
  0,0,0,1,0,0,
  0,0,0,1,0,0,
  0,0,0,1,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0
,
  // Character 'U' (85)
  0,0,0,0,0,0,
  0,1,0,0,0,1,
  0,1,0,0,0,1,
  0,1,0,0,0,1,
  0,1,0,0,0,1,
  0,1,0,0,0,1,
  0,1,0,0,0,1,
  0,0,1,1,1,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0
,
  // Character 'V' (86)
  0,0,0,0,0,0,
  0,1,0,0,0,1,
  0,1,0,0,0,1,
  0,1,0,0,0,1,
  0,0,1,0,1,0,
  0,0,1,0,1,0,
  0,0,0,1,0,0,
  0,0,0,1,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0
,
  // Character 'W' (87)
  0,0,0,0,0,0,
  0,1,0,0,0,1,
  0,1,0,0,0,1,
  0,1,0,0,0,1,
  0,1,0,1,0,1,
  0,1,0,1,0,1,
  0,1,0,1,0,1,
  0,0,1,0,1,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0
,
  // Character 'X' (88)
  0,0,0,0,0,0,
  0,1,0,0,0,1,
  0,1,0,0,0,1,
  0,0,1,0,1,0,
  0,0,0,1,0,0,
  0,0,1,0,1,0,
  0,1,0,0,0,1,
  0,1,0,0,0,1,
  0,0,0,0,0,0,
  0,0,0,0,0,0
,
  // Character 'Y' (89)
  0,0,0,0,0,0,
  0,1,0,0,0,1,
  0,1,0,0,0,1,
  0,0,1,0,1,0,
  0,0,0,1,0,0,
  0,0,0,1,0,0,
  0,0,0,1,0,0,
  0,0,0,1,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0
,
  // Character 'Z' (90)
  0,0,0,0,0,0,
  0,1,1,1,1,1,
  0,0,0,0,0,1,
  0,0,0,0,1,0,
  0,0,0,1,0,0,
  0,0,1,0,0,0,
  0,1,0,0,0,0,
  0,1,1,1,1,1,
  0,0,0,0,0,0,
  0,0,0,0,0,0
,
  // Character '[' (91)
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,1,0,0,
  0,0,1,0,0,0,
  0,1,1,1,1,1,
  0,0,1,0,0,0,
  0,0,0,1,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0
,
  // Character '\' (92)
  0,0,0,0,0,0,
  0,1,0,0,0,0,
  0,1,0,0,0,0,
  0,1,0,0,0,0,
  0,1,0,1,1,0,
  0,0,0,0,0,1,
  0,0,0,0,1,0,
  0,0,0,1,0,0,
  0,0,0,1,1,1,
  0,0,0,0,0,0
,
  // Character ']' (93)
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,1,0,0,
  0,0,0,0,1,0,
  0,1,1,1,1,1,
  0,0,0,0,1,0,
  0,0,0,1,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0
,
  // Character '^' (94)
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,1,0,0,
  0,0,1,1,1,0,
  0,1,0,1,0,1,
  0,0,0,1,0,0,
  0,0,0,1,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0
,
  // Character '_' (95)
  0,0,0,0,0,0,
  0,0,1,0,1,0,
  0,0,1,0,1,0,
  0,1,1,1,1,1,
  0,0,1,0,1,0,
  0,1,1,1,1,1,
  0,0,1,0,1,0,
  0,0,1,0,1,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0
,
  // Character '`' (96)
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,1,1,0,
  0,0,0,1,1,0,
  0,0,0,0,0,0
,
  // Character 'a' (97)
  1,1,0,0,0,0,
  1,1,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,1,1,0,
  0,0,0,1,1,0,
  0,0,0,0,0,0
,
  // Character 'b' (98)
  0,0,0,1,1,0,
  0,0,0,1,1,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,1,1,0,
  0,0,0,1,1,0,
  0,0,0,0,0,0
,
  // Character 'c' (99)
  1,1,0,1,1,0,
  1,1,0,1,1,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,1,1,0,
  0,0,0,1,1,0,
  0,0,0,0,0,0
,
  // Character 'd' (100)
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  1,1,0,0,0,0,
  1,1,0,0,0,0,
  1,1,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,1,1,0,
  0,0,0,1,1,0,
  0,0,0,0,0,0
,
  // Character 'e' (101)
  1,1,0,0,0,0,
  1,1,0,0,0,0,
  0,0,0,0,0,0,
  1,1,0,0,0,0,
  1,1,0,0,0,0,
  1,1,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,1,1,0,
  0,0,0,1,1,0,
  0,0,0,0,0,0
,
  // Character 'f' (102)
  0,0,0,1,1,0,
  0,0,0,1,1,0,
  0,0,0,0,0,0,
  1,1,0,0,0,0,
  1,1,0,0,0,0,
  1,1,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,1,1,0,
  0,0,0,1,1,0,
  0,0,0,0,0,0
,
  // Character 'g' (103)
  1,1,0,1,1,0,
  1,1,0,1,1,0,
  0,0,0,0,0,0,
  1,1,0,0,0,0,
  1,1,0,0,0,0,
  1,1,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,1,1,0,
  0,0,0,1,1,0,
  0,0,0,0,0,0
,
  // Character 'h' (104)
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,1,1,0,
  0,0,0,1,1,0,
  0,0,0,1,1,0,
  0,0,0,0,0,0,
  0,0,0,1,1,0,
  0,0,0,1,1,0,
  0,0,0,0,0,0
,
  // Character 'i' (105)
  1,1,0,0,0,0,
  1,1,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,1,1,0,
  0,0,0,1,1,0,
  0,0,0,1,1,0,
  0,0,0,0,0,0,
  0,0,0,1,1,0,
  0,0,0,1,1,0,
  0,0,0,0,0,0
,
  // Character 'j' (106)
  0,0,0,1,1,0,
  0,0,0,1,1,0,
  0,0,0,0,0,0,
  0,0,0,1,1,0,
  0,0,0,1,1,0,
  0,0,0,1,1,0,
  0,0,0,0,0,0,
  0,0,0,1,1,0,
  0,0,0,1,1,0,
  0,0,0,0,0,0
,
  // Character 'k' (107)
  1,1,0,1,1,0,
  1,1,0,1,1,0,
  0,0,0,0,0,0,
  0,0,0,1,1,0,
  0,0,0,1,1,0,
  0,0,0,1,1,0,
  0,0,0,0,0,0,
  0,0,0,1,1,0,
  0,0,0,1,1,0,
  0,0,0,0,0,0
,
  // Character 'l' (108)
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  1,1,0,1,1,0,
  1,1,0,1,1,0,
  1,1,0,1,1,0,
  0,0,0,0,0,0,
  0,0,0,1,1,0,
  0,0,0,1,1,0,
  0,0,0,0,0,0
,
  // Character 'm' (109)
  1,1,0,0,0,0,
  1,1,0,0,0,0,
  1,1,0,0,0,0,
  0,0,0,0,0,0,
  1,1,0,1,1,0,
  1,1,0,1,1,0,
  0,0,0,0,0,0,
  0,0,0,1,1,0,
  0,0,0,1,1,0,
  0,0,0,0,0,0
,
  // Character 'n' (110)
  0,0,0,1,1,0,
  0,0,0,1,1,0,
  0,0,0,0,0,0,
  1,1,0,1,1,0,
  1,1,0,1,1,0,
  1,1,0,1,1,0,
  0,0,0,0,0,0,
  0,0,0,1,1,0,
  0,0,0,1,1,0,
  0,0,0,0,0,0
,
  // Character 'o' (111)
  1,1,0,1,1,0,
  1,1,0,1,1,0,
  0,0,0,0,0,0,
  1,1,0,1,1,0,
  1,1,0,1,1,0,
  1,1,0,1,1,0,
  0,0,0,0,0,0,
  0,0,0,1,1,0,
  0,0,0,1,1,0,
  0,0,0,0,0,0
,
  // Character 'p' (112)
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  1,1,0,1,1,0,
  1,1,0,1,1,0,
  0,0,0,0,0,0
,
  // Character 'q' (113)
  1,1,0,0,0,0,
  1,1,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  1,1,0,1,1,0,
  1,1,0,1,1,0,
  0,0,0,0,0,0
,
  // Character 'r' (114)
  0,0,0,1,1,0,
  0,0,0,1,1,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  1,1,0,1,1,0,
  1,1,0,1,1,0,
  0,0,0,0,0,0
,
  // Character 's' (115)
  1,1,0,1,1,0,
  1,1,0,1,1,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  1,1,0,1,1,0,
  1,1,0,1,1,0,
  0,0,0,0,0,0
,
  // Character 't' (116)
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  1,1,0,0,0,0,
  1,1,0,0,0,0,
  1,1,0,0,0,0,
  0,0,0,0,0,0,
  1,1,0,1,1,0,
  1,1,0,1,1,0,
  0,0,0,0,0,0
,
  // Character 'u' (117)
  1,1,0,0,0,0,
  1,1,0,0,0,0,
  0,0,0,0,0,0,
  1,1,0,0,0,0,
  1,1,0,0,0,0,
  1,1,0,0,0,0,
  0,0,0,0,0,0,
  1,1,0,1,1,0,
  1,1,0,1,1,0,
  0,0,0,0,0,0
,
  // Character 'v' (118)
  0,0,0,1,1,0,
  0,0,0,1,1,0,
  0,0,0,0,0,0,
  1,1,0,0,0,0,
  1,1,0,0,0,0,
  1,1,0,0,0,0,
  0,0,0,0,0,0,
  1,1,0,1,1,0,
  1,1,0,1,1,0,
  0,0,0,0,0,0
,
  // Character 'w' (119)
  1,1,0,1,1,0,
  1,1,0,1,1,0,
  0,0,0,0,0,0,
  1,1,0,0,0,0,
  1,1,0,0,0,0,
  1,1,0,0,0,0,
  0,0,0,0,0,0,
  1,1,0,1,1,0,
  1,1,0,1,1,0,
  0,0,0,0,0,0
,
  // Character 'x' (120)
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,1,1,0,
  0,0,0,1,1,0,
  0,0,0,1,1,0,
  0,0,0,0,0,0,
  1,1,0,1,1,0,
  1,1,0,1,1,0,
  0,0,0,0,0,0
,
  // Character 'y' (121)
  1,1,0,0,0,0,
  1,1,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,1,1,0,
  0,0,0,1,1,0,
  0,0,0,1,1,0,
  0,0,0,0,0,0,
  1,1,1,1,1,0,
  1,1,1,1,1,0,
  0,0,0,0,0,0
,
  // Character 'z' (122)
  0,0,0,1,1,0,
  0,0,0,1,1,0,
  0,0,0,0,0,0,
  0,0,0,1,1,0,
  0,0,0,1,1,0,
  0,0,0,1,1,0,
  0,0,0,0,0,0,
  1,1,0,1,1,0,
  1,1,0,1,1,0,
  0,0,0,0,0,0
,
  // Character '{' (123)
  1,1,0,1,1,0,
  1,1,0,1,1,0,
  0,0,0,0,0,0,
  0,0,0,1,1,0,
  0,0,0,1,1,0,
  0,0,0,1,1,0,
  0,0,0,0,0,0,
  1,1,0,1,1,0,
  1,1,0,1,1,0,
  0,0,0,0,0,0
,
  // Character '|' (124)
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  0,0,0,0,0,0,
  1,1,0,1,1,0,
  1,1,0,1,1,0,
  1,1,0,1,1,0,
  0,0,0,0,0,0,
  1,1,0,1,1,0,
  1,1,0,1,1,0,
  0,0,0,0,0,0
,
  // Character '}' (125)
  1,1,0,0,0,0,
  1,1,0,0,0,0,
  0,0,0,0,0,0,
  1,1,0,1,1,0,
  1,1,0,1,1,0,
  1,1,0,1,1,0,
  0,0,0,0,0,0,
  1,1,0,1,1,0,
  1,1,0,1,1,0,
  0,0,0,0,0,0
,
  // Character '~' (126)
  0,0,0,1,1,0,
  0,0,0,1,1,0,
  0,0,0,0,0,0,
  1,1,0,1,1,0,
  1,1,0,1,1,0,
  1,1,0,1,1,0,
  0,0,0,0,0,0,
  1,1,0,1,1,0,
  1,1,0,1,1,0,
  0,0,0,0,0,0
,
  // Character '' (127)
  1,1,0,1,1,0,
  1,1,0,1,1,0,
  0,0,0,0,0,0,
  1,1,0,1,1,0,
  1,1,0,1,1,0,
  1,1,0,1,1,0,
  0,0,0,0,0,0,
  1,1,0,1,1,0,
  1,1,0,1,1,0,
  0,0,0,0,0,0
};


static int teletext_data;
static int teletext_LOSE;

static char *tt_lookup=teletext_saa5050_characters;
static char *tt_graphics=teletext_graphics;
static int tt_colour=7;
static int tt_rcolour;
static int tt_bgcolour=0;
static int tt_start_line=0;
static int tt_double_height=0;
static int tt_double_height_set=0;
static int tt_double_height_offset=0;
static int tt_linecount=0;
static int tt_flash=0;
static int tt_holdgraphics=0;
static int tt_lastcode=0;

static int tt_frame_count=0;

// local copy of the 6845 external procedure calls
static struct saa505x_interface
saa505x_calls= { 0 };


void saa505x_config(const struct saa505x_interface *intf)
{
	saa505x_calls.out_Pixel_func=*intf->out_Pixel_func;
}



void teletext_data_w(int offset, int data)
{
	teletext_data=data & 0x7f;
}

void teletext_DEW(void)
{
	tt_linecount=9;
	tt_double_height=0;
	tt_double_height_set=0;
	tt_double_height_offset=0;
	tt_frame_count=(tt_frame_count+1)%50;
}

void teletext_LOSE_w(int offset, int data)
{
	if ((data)&&(!teletext_LOSE))
	{

		tt_lookup=teletext_saa5050_characters;
		tt_colour=7;
		tt_bgcolour=0;
		tt_graphics=teletext_graphics;
		tt_linecount=(tt_linecount+1)%10;
		tt_start_line=0;
		tt_double_height=0;
		tt_flash=0;
		tt_holdgraphics=0;
		tt_lastcode=0x20;

		// only check the double height stuff if at the first row of a new line
		if (!tt_linecount)
		{
			tt_double_height_offset=((!tt_double_height_set)||tt_double_height_offset)?0:10;
			tt_double_height_set=0;
		}

	}

	teletext_LOSE=data;
}


void teletext_F1(void)
{
	int sc1;
	int code;
	code=teletext_data;

	switch (code)
	{
		// 0x00 Not used

		case 0x01: case 0x02: case 0x03: case 0x04:
		case 0x05: case 0x06: case 0x07:
			tt_lookup=teletext_saa5050_characters;
			tt_colour=code;
			break;


		case 0x08:  // Flash
			tt_flash=tt_frame_count<20?1:0;
			break;
		case 0x09:  // Steady
			tt_flash=0;
			break;

		// 0x0a		End Box    NOT USED
		// 0x0b     Start Box  NOT USED

		case 0x0c:	// Normal Height
			tt_double_height=0;
			tt_start_line=0;
			break;
		case 0x0d:	// Double Height
			tt_double_height=1;
			tt_double_height_set=1;
			tt_start_line=tt_double_height_offset;
			break;

		// 0x0e		S0         NOT USED
		// 0x0f		S1         NOT USED
		// 0x10		DLE        NOT USED

		case 0x11: case 0x12: case 0x13: case 0x14:
		case 0x15: case 0x16: case 0x17:
			tt_lookup=tt_graphics;
			tt_colour=code&0x07;
			break;

		// 0x18		Conceal Display

		case 0x19:	//  Contiguois Graphics
			tt_graphics=teletext_graphics;
			if (tt_lookup!=teletext_saa5050_characters)
				tt_lookup=tt_graphics;
			break;
		case 0x1a:	//  Separated Graphics
			tt_graphics=teletext_separated_graphics;
			if (tt_lookup!=teletext_saa5050_characters)
				tt_lookup=tt_graphics;
			break;

		// 0x1b		ESC        NOT USED

		case 0x1c:  //  Black Background
			tt_bgcolour=0;
			break;
		case 0x1d:  //  New Background
			tt_bgcolour=tt_colour;
			break;

		case 0x1e:
			tt_holdgraphics=1;
			break;

		case 0x1f:
			tt_holdgraphics=0;
			break;
	}

	if (teletext_LOSE)
	{
		tt_rcolour=tt_flash?tt_bgcolour:tt_colour;
		if (code<0x20) {
			if (tt_holdgraphics) {
				code=tt_lastcode;
			} else {
				code=0x20;
			}
		}
		tt_lastcode=code;
		code=(code-0x20)*60+(6*((tt_linecount+tt_start_line)>>tt_double_height));
		for(sc1=0;sc1<6;sc1++)
		{
			(saa505x_calls.out_Pixel_func)(0,tt_lookup[code++]?tt_rcolour:tt_bgcolour);
		}
	} else {

		(saa505x_calls.out_Pixel_func)(0,0);
		(saa505x_calls.out_Pixel_func)(0,0);
		(saa505x_calls.out_Pixel_func)(0,0);
		(saa505x_calls.out_Pixel_func)(0,0);
		(saa505x_calls.out_Pixel_func)(0,0);
		(saa505x_calls.out_Pixel_func)(0,0);
	}
}
