% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ifr-anova.R
\name{infer_oneway_anova}
\alias{infer_oneway_anova}
\title{One Way ANOVA}
\usage{
infer_oneway_anova(data, x, y, ...)
}
\arguments{
\item{data}{a \code{data.frame} or a \code{tibble}}

\item{x}{numeric; column in \code{data}}

\item{y}{factor; column in \code{data}}

\item{...}{additional arguments passed to or from other methods}
}
\value{
\code{infer_oneway_anova} returns an object of class \code{"infer_oneway_anova"}.
An object of class \code{"infer_oneway_anova"} is a list containing the
following components:

\item{adjusted_r2}{adjusted r squared value}
\item{df_btw}{between groups degress of freedom}
\item{df_within}{within groups degress of freedom}
\item{df_total}{total degress of freedom}
\item{fstat}{f value}
\item{group_stats}{group statistics}
\item{ms_btw}{between groups mean square}
\item{ms_within}{within groups mean square}
\item{obs}{number of observations}
\item{pval}{p value}
\item{r2}{r squared value}
\item{rmse}{root mean squared error}
\item{ss_between}{between group sum of squares}
\item{ss_within}{within group sum of squares}
\item{ss_total}{total sum of squares}
}
\description{
One way analysis of variance
}
\examples{
infer_oneway_anova(mtcars, mpg, cyl)
infer_oneway_anova(hsb, write, prog)
}
\references{
Kutner, M. H., Nachtsheim, C., Neter, J., & Li, W. (2005).
Applied linear statistical models. Boston: McGraw-Hill Irwin.
}
\seealso{
\code{\link[stats]{anova}}
}
