% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/excel-stat-summary-functions.R
\name{excel_stat_summary_functions}
\alias{excel_stat_summary_functions}
\alias{SUM}
\alias{AVERAGE}
\alias{MEDIAN}
\alias{MIN}
\alias{MAX}
\alias{COUNT}
\alias{COUNT_UNIQUE}
\alias{STDEV}
\alias{VAR}
\alias{COR}
\alias{COV}
\alias{FIRST}
\alias{LAST}
\alias{NTH}
\alias{CHANGE_FIRSTLAST}
\alias{PCT_CHANGE_FIRSTLAST}
\title{Excel Statistical Summary Functions}
\usage{
SUM(x)

AVERAGE(x)

MEDIAN(x)

MIN(x)

MAX(x)

COUNT(x)

COUNT_UNIQUE(x)

STDEV(x)

VAR(x)

COR(x, y)

COV(x, y)

FIRST(x)

LAST(x)

NTH(x, n = 1)

CHANGE_FIRSTLAST(x)

PCT_CHANGE_FIRSTLAST(x)
}
\arguments{
\item{x}{A vector. Most functions are designed for numeric data.
Some functions like \code{\link[=COUNT]{COUNT()}} handle multiple data types.}

\item{y}{A vector. Used in functions requiring 2 inputs.}

\item{n}{A single value used in \code{\link[=NTH]{NTH()}} to select a specific element location to return.}
}
\value{
\itemize{
\item \strong{Summary functions} return a single value
}
}
\description{
15+ common statistical functions familiar to users of Excel (e.g. \code{\link[=SUM]{SUM()}}, \code{\link[=AVERAGE]{AVERAGE()}}).
These functions return a \strong{single value} (i.e. a vector of length 1).

These functions are designed to help users coming from an \strong{Excel background}.
Most functions replicate the behavior of Excel:
\itemize{
\item Names in most cases match Excel function names
\item Functionality replicates Excel
\item By default, missing values are ignored (same as in Excel)
}
}
\details{
\strong{Summary Functions}
\itemize{
\item All functions remove missing values (\code{NA}). This is the same behavior as in Excel and most commonly what is desired.
}
}
\section{Useful functions}{


\strong{Summary Functions} - Return a single value from a vector
\itemize{
\item Sum: \code{\link[=SUM]{SUM()}}
\item Center: \code{\link[=AVERAGE]{AVERAGE()}}, \code{\link[=MEDIAN]{MEDIAN()}}
\item Spread: \code{\link[=STDEV]{STDEV()}}, \code{\link[=VAR]{VAR()}}
\item Range: \code{\link[=MIN]{MIN()}}, \code{\link[=MAX]{MAX()}}
\item Count: \code{\link[=COUNT]{COUNT()}}, \code{\link[=COUNT_UNIQUE]{COUNT_UNIQUE()}}
\item Position: \code{\link[=FIRST]{FIRST()}}, \code{\link[=LAST]{LAST()}}, \code{\link[=NTH]{NTH()}}
\item Change (Summary): \code{\link[=CHANGE_FIRSTLAST]{CHANGE_FIRSTLAST()}}, \code{\link[=PCT_CHANGE_FIRSTLAST]{PCT_CHANGE_FIRSTLAST()}}
\item Correlation: \code{\link[=COR]{COR()}}, \code{\link[=COV]{COV()}}
}
}

\examples{
\dontshow{if (rlang::is_installed("forcats")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# Libraries
library(timetk, exclude = "FANG")
library(forcats)
library(dplyr)

# --- Basic Usage ----

SUM(1:10)

PCT_CHANGE_FIRSTLAST(c(21, 24, 22, 25))

# --- Usage with tidyverse ---

# Go from daily to monthly periodicity,
# then calculate returns and growth of $1 USD
FANG \%>\%
    mutate(symbol = forcats::as_factor(symbol)) \%>\%
    group_by(symbol) \%>\%

    # Summarization - Collapse from daily to FIRST value by month
    summarise_by_time(
        .date_var  = date,
        .by        = "month",
        adjusted   = FIRST(adjusted)
    )
\dontshow{\}) # examplesIf}
}
