% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tar_older.R
\name{tar_older}
\alias{tar_older}
\title{List old targets}
\usage{
tar_older(
  time,
  names = NULL,
  inclusive = FALSE,
  store = targets::tar_config_get("store")
)
}
\arguments{
\item{time}{A \code{POSIXct} object of length 1, time threshold.
Targets older than this time stamp are returned.
For example, if \code{time = Sys.time() - as.difftime(1, units = "weeks")}
then \code{tar_older()} returns targets older than one week ago.}

\item{names}{Names of eligible targets. Targets excluded from \code{names}
will not be returned even if they are old.
The object supplied to \code{names} should be \code{NULL} or a
\code{tidyselect} expression like \code{\link[=any_of]{any_of()}} or \code{\link[=starts_with]{starts_with()}}
from \code{tidyselect} itself, or \code{\link[=tar_described_as]{tar_described_as()}} to select target names
based on their descriptions.}

\item{inclusive}{Logical of length 1, whether to include targets
completed at exactly the \code{time} given.}

\item{store}{Character of length 1, path to the
\code{targets} data store. Defaults to \code{tar_config_get("store")},
which in turn defaults to \verb{_targets/}.
When you set this argument, the value of \code{tar_config_get("store")}
is temporarily changed for the current function call.
See \code{\link[=tar_config_get]{tar_config_get()}} and \code{\link[=tar_config_set]{tar_config_set()}} for details
about how to set the data store path persistently
for a project.}
}
\value{
A character vector of names of old targets with recorded
timestamp metadata.
}
\description{
List all the targets whose last successful run occurred
before a certain point in time. Combine with \code{\link[=tar_invalidate]{tar_invalidate()}},
you can use \code{tar_older()} to automatically rerun targets at
regular intervals. See the examples for a demonstration.
}
\details{
Only applies to targets with recorded time stamps:
just non-branching targets and individual dynamic branches.
As of \code{targets} version 0.6.0, these time
stamps are available for these targets regardless of
storage format. Earlier versions of \code{targets} do not record
time stamps for remote storage such as \code{format = "url"}
or \code{repository = "aws"} in \code{\link[=tar_target]{tar_target()}}.
}
\examples{
if (identical(Sys.getenv("TAR_EXAMPLES"), "true")) { # for CRAN
tar_dir({ # tar_dir() runs code from a temp dir for CRAN.
tar_script({
  library(targets)
  library(tarchetypes)
  list(tar_target(x, seq_len(2)))
}, ask = FALSE)
tar_make()
# targets older than 1 week ago
tar_older(Sys.time() - as.difftime(1, units = "weeks"))
# targets older than 1 week from now
tar_older(Sys.time() + as.difftime(1, units = "weeks"))
# Everything is still up to date.
tar_make()
# Invalidate all targets targets older than 1 week from now
# so they run on the next tar_make().
invalidate_these <- tar_older(Sys.time() + as.difftime(1, units = "weeks"))
tar_invalidate(any_of(invalidate_these))
tar_make()
})
}
}
\seealso{
Other time: 
\code{\link{tar_newer}()},
\code{\link{tar_timestamp}()}
}
\concept{time}
