% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.sox_cv.R
\name{plot.sox_cv}
\alias{plot.sox_cv}
\title{Plots for \code{sox_cv}}
\usage{
\method{plot}{sox_cv}(x, type = "cv-curve", ...)
}
\arguments{
\item{x}{The \code{\link{sox_cv}} object.}

\item{type}{Character string, "\code{solution-path}" to generate a solution path with marks at \code{lambda.min} and \code{lambda.1se}; "\code{cv-curve}" to generate a cross-validation curve.}

\item{...}{Other graphical parameters to plot}
}
\value{
The "\code{solution-path}" plot produces a coefficient profile plot of the coefficient paths for a fitted \code{\link{sox}} model. The "\code{cv-curve}" plot is the \code{cvm} (red dot) for each lambda with its standard error (vertical bar). The two vertical dashed lines corresponds to the \code{lambda.min} and \code{lambda.1se}
}
\description{
Plot the solution path or cross-validation curves produced by \code{\link{sox_cv}()}.
}
\examples{
x <- as.matrix(sim[, c("A1","A2","C1","C2","B","A1B","A2B","C1B","C2B")])
lam.seq <- exp(seq(log(1e0), log(1e-3), length.out = 20))

overlapping.groups <- list(c(1, 2, 6, 7),
                           c(5, 6, 7, 8, 9),
                           c(6, 7),
                           c(3, 4, 8, 9),
                           c(8, 9))
                           
pars.overlapping <- overlap_structure(overlapping.groups)
              
cv.overlapping <- sox_cv(
  x = x,
  ID = sim$Id,
  time = sim$Start,
  time2 = sim$Stop,
  event = sim$Event,
  penalty = "overlapping",
  lambda = lam.seq,
  group = pars.overlapping$groups,
  group_variable = pars.overlapping$groups_var,
  penalty_weights = pars.overlapping$group_weights,
  nfolds = 5,
  tol = 1e-4,
  maxit = 1e3,
  verbose = FALSE
)

plot(cv.overlapping)
plot(cv.overlapping, type = "solution-path")

}
\seealso{
\code{\link{sox}}, \code{\link{sox_cv}}.
}
