% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pamr.confusion.R
\name{pamr.confusion}
\alias{pamr.confusion}
\title{A function giving a table of true versus predicted values, from a nearest
shrunken centroid fit.}
\usage{
pamr.confusion(fit, threshold, extra = TRUE)
}
\arguments{
\item{fit}{The result of a call to pamr.train or pamr.cv}

\item{threshold}{The desired threshold value}

\item{extra}{Should the classwise and overall error rates be returned?
Default TRUE}
}
\description{
A function giving a table of true versus predicted values, from a nearest
shrunken centroid fit.
}
\details{
\code{pamr.confusion} Gives a cross-tabulation of true versus predicted
classes for the fit returned by pamr.train or pamr.cv, at the specified
threshold.
}
\examples{

suppressWarnings(RNGversion("3.5.0"))
set.seed(120)
x <- matrix(rnorm(1000*20),ncol=20)
y <- sample(c(1:4),size=20,replace=TRUE)
mydata <- list(x=x,y=y)
mytrain <-   pamr.train(mydata)
mycv <- pamr.cv(mytrain,mydata)
pamr.confusion(mytrain,  threshold=2)
pamr.confusion(mycv,  threshold=2)
 

}
\author{
Trevor Hastie, Robert Tibshirani, Balasubramanian Narasimhan, and
Gilbert Chu
}
