% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/linshrink.R
\name{linshrink_cov}
\alias{linshrink_cov}
\title{Linear-shrinkage estimator of population covariance matrix.}
\usage{
linshrink_cov(X, k = 0)
}
\arguments{
\item{X}{A data matrix.}

\item{k}{(Optional) Non-negative integer less than \code{ncol(X)}. If \code{k
== 0} (default), \code{X} is assumed to contain 1 class, which will be
centered. If \code{k >= 1}, \code{X} is assumed to contain \code{k}
classes, each of which has already been centered.}
}
\value{
Population covariance matrix estimate. A square positive
  semi-definite matrix of dimension \code{ncol(X)}.
}
\description{
The linear shrinkage estimator of the population covariance
  matrix is computed by shrinking the sample covariance matrix towards the
  identity matrix based on a shrinkage factor. Note that the eigenvalues of
  the population covariance matrix estimate are not the same as the linear
  shrinkage estimates of population eigenvalues. Details in referenced
  publication.
}
\examples{
linshrink_cov(X = matrix(rnorm(1e4, mean = 5), nrow = 100, ncol = 100)) # 1 class; will be centered
linshrink_cov(X = matrix(rnorm(1e4), nrow = 100, ncol = 100), k = 1) # 1 class; no centering
}
\references{
\itemize{ \item Ledoit, O. and Wolf, M. (2004). A
  well-conditioned estimator for large-dimensional covariance matrices.
  Journal of Multivariate Analysis, 88(2)}
}

