% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/makeFunctionalData.R
\name{makeFunctionalData}
\alias{makeFunctionalData}
\title{Create a data.frame containing functional features from a normal data.frame.}
\usage{
makeFunctionalData(data, fd.features = NULL, exclude.cols = NULL)
}
\arguments{
\item{data}{(\link{data.frame}) \cr
A data.frame that contains the functional features as numeric columns.}

\item{fd.features}{(\link{list}) \cr
Named list containing \code{integer} column indices or \code{character} column names.
Each element defines a functional feature, in the given order of the indices or column names.
The name of the list element defines the name of the functional feature.
All selected columns have to correspond to numeric data.frame entries.
The default is \code{NULL}, which means all numeric features are considered
to be a single functional \dQuote{fd1}.}

\item{exclude.cols}{(\link{character} | \link{integer})\cr
Column names or indices to exclude from conversion to functionals, even if they
are in included in \code{fd.features}.
Default is not to exclude anything.}
}
\value{
(\link{data.frame}).
}
\description{
To work with functional features, those features need to be
stored as a \code{matrix} column in the data.frame, so \code{mlr} can automatically
recognize them as functional features.
This function allows for an easy conversion from a data.frame with numeric columns
to the required format. If the data already contains matrix columns, they are left as-is
if not specified otherwise in \code{fd.features}. See \code{Examples} for the structure
of the generated output.
}
\examples{
# data.frame where columns 1:6 and 8:10 belong to a functional feature
d1 = data.frame(matrix(rnorm(100), nrow = 10), "target" = seq_len(10))
# Transform to functional data
d2 = makeFunctionalData(d1, fd.features = list("fd1" = 1:6, "fd2" = 8:10))
# Create a regression task
makeRegrTask(data = d2, target = "target")
}
