% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/has_decv.R
\name{has_decv}
\alias{has_decv}
\title{Determine if Vector Has Decimals}
\usage{
has_decv(x, sample.after = 1000)
}
\arguments{
\item{x}{the vector to check for presence of decimals.}

\item{sample.after}{for larger (length(x)>1000) vectors,
test for decimals using a non-random sample of 1000 observations from the
vector.}
}
\value{
a 1L vector indicating whether x has decimal values.
}
\description{
\code{has_decv} determines whether a vector has decimal values, using all values
for smaller vectors and using a non-random sample of observations for larger
vectors.
}
\details{
This function is used by core labelr functions to detect vectors that are
bad candidates for one-to-one value labeling (as implemented by, e.g.,
\code{add_val_labs}).
}
\examples{
set.seed(123)
x1 <- runif(10)
x2 <- as.character(sample(c(1:20), 10, replace = TRUE))
x3 <- sample(letters, size = 10, replace = TRUE)
df <- data.frame(x1, x2, x3)
head(df, 3)
sapply(df, class)
class(df$x2)

df <- as_num(df)
head(df, 3)
sapply(df, class)

sapply(mtcars, is.double)
sapply(mtcars, is.numeric)
sapply(mtcars, is.integer)
sapply(mtcars, has_decv)
}
