% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_name_labs.R
\name{get_name_labs}
\alias{get_name_labs}
\alias{gnl}
\title{Return Look-up Table of Variable Names and Name Labels}
\usage{
get_name_labs(data, vars = NULL)

gnl(data, vars = NULL)
}
\arguments{
\item{data}{a data.frame.}

\item{vars}{a character vector with the name(s) of any specific variable(s)
(If NULL, returned data.frame will contain all variable name labels).}
}
\value{
A two-column data.frame, consisting of "var" and "lab" columns,
where each row corresponds to a unique variable (column) from the user-
supplied data.frame.
}
\description{
For a name-labeled data.frame, \code{get_name_labs} returns a derivative
data.frame that lists each variable and its variable name label.

Note: \code{gnl} is a compact alias for \code{get_name_labs}: they do the same thing,
and the former is easier to type
}
\examples{
# create a data set
df <- mtcars

# variable names and their labels
names_labs_vec <- c(
  "mpg" = "Miles/(US) gallon",
  "cyl" = "Number of cylinders",
  "disp" = "Displacement (cu.in.)",
  "hp" = "Gross horsepower",
  "drat" = "Rear axle ratio",
  "wt" = "Weight (1000 lbs)",
  "qsec" = "1/4 mile time",
  "vs" = "Engine (0 = V-shaped, 1 = straight)",
  "am" = "Transmission (0 = automatic, 1 = manual)",
  "gear" = "Number of forward gears",
  "carb" = "Number of carburetors"
)

# assign variable labels
df <- add_name_labs(df,
  vars = names(names_labs_vec),
  labs = names_labs_vec
)

# see what we have
get_name_labs(df)
}
