% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diagnostic_plots.R
\name{qq_postpred}
\alias{qq_postpred}
\title{Quantile-quantile plot from posterior predictive distribution}
\usage{
qq_postpred(ypp, y, p = NULL, add = FALSE, ...)
}
\arguments{
\item{ypp}{Either a matrix or \code{data.frame} of posterior samples, or an
output object returned from \code{jagsUI} and a supplied parameter name}

\item{y}{The associated data vector}

\item{p}{A character name, if a \code{jagsUI} object is passed to \code{ypp}}

\item{add}{Whether to add the plot to an existing plot.  Defaults to \code{FALSE}.}

\item{...}{Optional plotting arguments}
}
\value{
\code{NULL}
}
\description{
Produces a quantile-quantile plot, calculated from the quantiles of
a vector of data (most likely a time series), with respect to the matrix of associated posterior
predictive distributions.

While not an omnibus posterior predictive check, this plot can be useful
for detecting an overparameterized model, or else improper specification
of observation error.  Like a traditional Q-Q plot, a well-specified model
will have points that lie close to the x=y line.  In the case of this
function, an overparametrized model will typically produce a plot with a
much shallower slope, possibly with many associated posterior predictive quantiles close
to 0.5.

It should be noted that this function will only produce meaningful results
with a vector of data, as opposed to a single value.

The posterior predictive distribution can be specified in two possible ways:
either a single output object from \code{jagsUI} with an associated parameter
name, or as a matrix or \code{data.frame} of posterior samples.
}
\note{
This function assumes the existence of a matrix of posterior predictive
samples corresponding to a data vector, the construction of which must be
left to the user.  This can be accomplished within JAGS, or using appropriate
simulation from the posterior samples.
}
\examples{
# first, a quick look at the example data...
str(SS_data)
str(SS_out$sims.list$ypp)

# plotting the example posterior predictive distribution with the data
# points overlayed.  Note the overdispersion in the posterior predictive.
caterpillar(SS_out, p="ypp")
points(SS_data$y)

# using a jagsUI object as ypp input
qq_postpred(ypp=SS_out, p="ypp", y=SS_data$y)

# using a matrix as ypp input
qq_postpred(ypp=SS_out$sims.list$ypp, y=SS_data$y)
}
\seealso{
\link{ts_postpred}, \link{plot_postpred}, \link{check_Rhat}, \link{check_neff}, \link{traceworstRhat}, \link{plotRhats}
}
\author{
Matt Tyers
}
