% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mapping-functions.R
\name{by_ranges}
\alias{by_ranges}
\title{Map numeric ranges to cell properties}
\usage{
by_ranges(breaks, values, right = FALSE, extend = TRUE, ignore_na = TRUE)
}
\arguments{
\item{breaks}{A vector of numbers in increasing order.}

\item{values}{A vector of property values. \code{length(values)} should be one greater than
\code{length(breaks)} if \code{extend = TRUE}, or one less if \code{extend = FALSE}.}

\item{right}{If \code{TRUE}, intervals are closed on the right, i.e. if values are exactly equal to a
\code{break}, they go in the lower group. Otherwise, intervals are closed on the left, so equal
values go in the higher group. \code{FALSE} by default.}

\item{extend}{Extend \code{breaks} to \code{c(-Inf, breaks, Inf)}, i.e. include numbers below and above the
outermost breaks. \code{TRUE} by default.}

\item{ignore_na}{If \code{TRUE}, \code{NA} values in the result will be left unchanged
from their previous values. Otherwise, \code{NA}
normally resets to the default.}
}
\value{
A function for use in \verb{map_***} functions.
}
\description{
\code{by_ranges()} sets property values for cells falling within different numeric ranges.
}
\details{
Non-numeric cells return \code{NA}. The effects of this depend on \code{ignore_na}.
}
\examples{
ht <- huxtable(c(1, 3, 5))
map_background_color(ht,
      by_ranges(
        c(2, 4),
        c("red", "yellow", "blue")
      ))

map_background_color(ht,
      by_ranges(
        c(2, 4),
        "pink",
        extend = FALSE
      ))

map_background_color(ht,
      by_ranges(
        c(1, 5),
        c("red", "yellow", "green"),
        right = TRUE
      ))
map_background_color(ht,
      by_ranges(
        c(1, 5),
        c("red", "yellow", "green"),
        right = FALSE
      ))
}
\seealso{
\link{mapping-functions}

Other mapping functions: 
\code{\link{by_cases}()},
\code{\link{by_colorspace}()},
\code{\link{by_function}()},
\code{\link{by_quantiles}()},
\code{\link{by_regex}()},
\code{\link{by_rows}()},
\code{\link{by_values}()}
}
\concept{mapping functions}
