% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datasets.R
\docType{data}
\name{rx_adsl}
\alias{rx_adsl}
\title{An ADSL-flavored clinical trial toy dataset}
\format{
A tibble with 182 rows and 14 variables:
\describe{
\item{STUDYID, STUDYIDN}{The unique study identifier and its numeric
version.}
\item{USUBJID}{The unique subject identifier.}
\item{TRTA, TRTAN}{The study intervention and its numeric version, which is
either \code{"Placebo"} (\code{1}), \code{"Drug 1"} (\code{2}) or \code{NA} (\code{3}), missing for
screen failures).}
\item{ITTFL}{Intent-to-Treat (ITT) population flag, where \code{"Y"} indicates
a subject belongs to the ITT population and \code{"N"} indicates a subject is not
in the ITT population.}
\item{RANDFL}{Randomization flag, where \code{"Y"} indicates a subject was
randomized to receive either \code{"Placebo"} or \code{"Drug 1"} and \code{"N"} indicates
a subject was not randomized at all.}
\item{SCRFREAS}{The reason for screen failure. This is either missing
(\code{""}) for non-screen failure subjects or indicates the reason for screen
failure}
\item{AGE}{The age of a subject at baseline in years.}
\item{AAGEGR1}{The analysis age group, indicating if a subject was strictly
younger than 40 years at baseline or older.}
\item{SEX}{Sex of a subject. Can be either \code{"Male"}, \code{"Female"} or
\code{"Undifferentiated"}.}
\item{ETHNIC}{Ethnicity of a subject. Can be either \code{"Hispanic or Latino"},
\code{"Not Hispanic or Latino"} or missing (\code{""}).}
\item{BLBMI}{Body Mass Index (BMI) of a subject at baseline in kg/m2.}
\item{EVNTFL}{Event Flag. Indicates whether the subject experienced a
specific event during the course of the study or not. Can be either \code{"Y"} (if
if the subject had the event) or \code{"N"}.}
}
}
\usage{
rx_adsl
}
\description{
This tibble contains artificial data for 182 subjects of the \code{GT01} study.
Each row corresponds to demographic characteristics of a single trial
participant. Two out of 182 study participants were screen failures and
thus not treated, the rest of the study population was randomized with a
1:1 ratio to receive either \code{"Placebo"} (as comparator) or \code{"Drug 1"}. The
dataset entails subject level demographics such as age, age group, sex,
ethnicity, and body mass index (BMI) at baseline, as well as an event
flag, indicating whether the subject experienced a specific event
throughout the course of the study or not.

Although the data was intentionally created to mimic a typical clinical
trial dataset following the CDISC format, it might not strictly comply
with CDISC ADaM rules. The intent is to showcase the workflow for clinical
table creation rather than creating a fully CDISC-compliant ADaM dataset.
}
\section{Examples}{


Here is a glimpse at the data available in \code{rx_adsl}.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{dplyr::glimpse(rx_adsl)
#> Rows: 182
#> Columns: 14
#> $ STUDYID  <chr> "GT01", "GT01", "GT01", "GT01", "GT01", "GT01", "GT01", "GT01~
#> $ STUDYIDN <chr> "4001", "4001", "4001", "4001", "4001", "4001", "4001", "4001~
#> $ USUBJID  <chr> "GT1000", "GT1001", "GT1002", "GT1003", "GT1004", "GT1005", "~
#> $ TRTA     <fct> NA, Placebo, Placebo, Placebo, Placebo, Placebo, Placebo, Pla~
#> $ TRTAN    <dbl> 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1~
#> $ ITTFL    <chr> "N", "Y", "Y", "Y", "Y", "Y", "Y", "Y", "Y", "Y", "Y", "Y", "~
#> $ RANDFL   <chr> "N", "Y", "Y", "Y", "Y", "Y", "Y", "Y", "Y", "Y", "Y", "Y", "~
#> $ SCRFREAS <chr> "WITHDRAWAL BY SUBJECT", "", "", "", "", "", "", "", "", "", ~
#> $ AGE      <int> 37, 41, 39, 38, 45, 35, 42, 35, 42, 38, 48, 36, 46, 34, 44, 4~
#> $ AAGEGR1  <fct> <40, >=40, <40, <40, >=40, <40, >=40, <40, >=40, <40, >=40, <~
#> $ SEX      <fct> Male, Male, Female, Male, Male, Female, Female, Male, Male, F~
#> $ ETHNIC   <fct> Hispanic or Latino, Not Hispanic or Latino, Not Hispanic or L~
#> $ BLBMI    <dbl> 33.76723, 33.35073, 30.45862, 22.85986, 23.89713, 29.09856, 2~
#> $ EVNTFL   <chr> "", "Y", "Y", "N", "Y", "Y", "N", "N", "N", "N", "N", "N", "Y~
}\if{html}{\out{</div>}}
}

\section{Dataset ID and Badge}{

DATA-17

\if{html}{\out{
<div style="text-align:center;"><img src="https://raw.githubusercontent.com/rstudio/gt/master/images/dataset_rx_adsl.png" alt="This image of that of a dataset badge." style="width:50\%;padding-bottom:20px;"></div>
}}
}

\section{Dataset Introduced}{

\code{v0.9.0} (Mar 31, 2023)
}

\seealso{
Other datasets: 
\code{\link{constants}},
\code{\link{countrypops}},
\code{\link{exibble}},
\code{\link{films}},
\code{\link{gibraltar}},
\code{\link{gtcars}},
\code{\link{illness}},
\code{\link{metro}},
\code{\link{nuclides}},
\code{\link{peeps}},
\code{\link{photolysis}},
\code{\link{pizzaplace}},
\code{\link{reactions}},
\code{\link{rx_addv}},
\code{\link{sp500}},
\code{\link{sza}},
\code{\link{towny}}
}
\concept{datasets}
\keyword{datasets}
