library(tidyverse)

constants <-
  dplyr::tribble(
    ~name,                                                       ~value,                 ~uncert,              ~sf_value,  ~sf_uncert,  ~units,
    "alpha particle-electron mass ratio",                        7294.29954142,          0.00000024,           12,         2,           NA,
    "alpha particle mass",                                       6.6446573357e-27,       0.0000000020e-27,     11,         2,           "kg",
    "alpha particle mass energy equivalent",                     5.9719201914e-10,       0.0000000018e-10,     11,         2,           "J",
    "alpha particle mass energy equivalent in MeV",              3727.3794066,           0.0000011,            11,         2,           "MeV",
    "alpha particle mass in u",                                  4.001506179127,         0.000000000063,       13,         2,           "u",
    "alpha particle molar mass",                                 4.0015061777e-3,        0.0000000012e-3,      11,         2,           "kg mol^-1",
    "alpha particle-proton mass ratio",                          3.97259969009,          0.00000000022,        12,         2,           NA,
    "alpha particle relative atomic mass",                       4.001506179127,         0.000000000063,       13,         2,           NA,
    "Angstrom star",                                             1.00001495e-10,         0.00000090e-10,        9,         2,           "m",
    "atomic mass constant",                                      1.66053906660e-27,      0.00000000050e-27,    12,         2,           "kg",
    "atomic mass constant energy equivalent",                    1.49241808560e-10,      0.00000000045e-10,    12,         2,           "J",
    "atomic mass constant energy equivalent in MeV",             931.49410242,           0.00000028,           11,         2,           "MeV",
    "atomic mass unit-electron volt relationship",               9.3149410242e8,         0.0000000028e8,       11,         2,           "eV",
    "atomic mass unit-hartree relationship",                     3.4231776874e7,         0.0000000010e7,       11,         2,           "E_h",
    "atomic mass unit-hertz relationship",                       2.25234271871e23,       0.00000000068e23,     12,         2,           "Hz",
    "atomic mass unit-inverse meter relationship",               7.5130066104e14,        0.0000000023e14,      11,         2,           "m^-1",
    "atomic mass unit-joule relationship",                       1.49241808560e-10,      0.00000000045e-10,    12,         2,           "J",
    "atomic mass unit-kelvin relationship",                      1.08095401916e13,       0.00000000033e13,     12,         2,           "K",
    "atomic mass unit-kilogram relationship",                    1.66053906660e-27,      0.00000000050e-27,    12,         2,           "kg",
    "atomic unit of 1st hyperpolarizability",                    3.2063613061e-53,       0.0000000015e-53,     11,         2,           "C^3 m^3 J^-2",
    "atomic unit of 2nd hyperpolarizability",                    6.2353799905e-65,       0.0000000038e-65,     11,         2,           "C^4 m^4 J^-3",
    "atomic unit of action",                                     1.054571817e-34,        NA,                   10,         NA,          "J s",
    "atomic unit of charge",                                     1.602176634e-19,        NA,                   10,         NA,          "C",
    "atomic unit of charge density",                             1.08120238457e12,       0.00000000049e12,     12,         2,           "C m^-3",
    "atomic unit of current",                                    6.623618237510e-3,      0.000000000013e-3,    13,         2,           "A",
    "atomic unit of electric dipole mom.",                       8.4783536255e-30,       0.0000000013e-30,     11,         2,           "C m",
    "atomic unit of electric field",                             5.14220674763e11,       0.00000000078e11,     12,         2,           "V m^-1",
    "atomic unit of electric field gradient",                    9.7173624292e21,        0.0000000029e21,      11,         2,           "V m^-2",
    "atomic unit of electric polarizability",                    1.64877727436e-41,      0.00000000050e-41,    12,         2,           "C^2 m^2 J^-1",
    "atomic unit of electric potential",                         27.211386245988,        0.000000000053,       14,         2,           "V",
    "atomic unit of electric quadrupole mom.",                   4.4865515246e-40,       0.0000000014e-40,     11,         2,           "C m^2",
    "atomic unit of energy",                                     4.3597447222071e-18,    0.0000000000085e-18,  14,         2,           "J",
    "atomic unit of force",                                      8.2387234983e-8,        0.0000000012e-8,      11,         2,           "N",
    "atomic unit of length",                                     5.29177210903e-11,      0.00000000080e-11,    12,         2,           "m",
    "atomic unit of mag. dipole mom.",                           1.85480201566e-23,      0.00000000056e-23,    12,         2,           "J T^-1",
    "atomic unit of mag. flux density",                          2.35051756758e5,        0.00000000071e5,      12,         2,           "T",
    "atomic unit of magnetizability",                            7.8910366008e-29,       0.0000000048e-29,     11,         2,           "J T^-2",
    "atomic unit of mass",                                       9.1093837015e-31,       0.0000000028e-31,     11,         2,           "kg",
    "atomic unit of momentum",                                   1.99285191410e-24,      0.00000000030e-24,    12,         2,           "kg m s^-1",
    "atomic unit of permittivity",                               1.11265005545e-10,      0.00000000017e-10,    12,         2,           "F m^-1",
    "atomic unit of time",                                       2.4188843265857e-17,    0.0000000000047e-17,  14,         2,           "s",
    "atomic unit of velocity",                                   2.18769126364e6,        0.00000000033e6,      12,         2,           "m s^-1",
    "Avogadro constant",                                         6.02214076e23,          NA,                    9,         NA,          "mol^-1",
    "Bohr magneton",                                             9.2740100783e-24,       0.0000000028e-24,     11,         2,           "J T^-1",
    "Bohr magneton in eV/T",                                     5.7883818060e-5,        0.0000000017e-5,      11,         2,           "eV T^-1",
    "Bohr magneton in Hz/T",                                     1.39962449361e10,       0.00000000042e10,     12,         2,           "Hz T^-1",
    "Bohr magneton in inverse meter per tesla",                  46.686447783,           0.000000014,          11,         2,           "m^-1 T^-1",
    "Bohr magneton in K/T",                                      0.67171381563,          0.00000000020,        11,         2,           "K T^-1",
    "Bohr radius",                                               5.29177210903e-11,      0.00000000080e-11,    12,         2,           "m",
    "Boltzmann constant",                                        1.380649e-23,           NA,                    7,         NA,          "J K^-1",
    "Boltzmann constant in eV/K",                                8.617333262e-5,         NA,                   10,         NA,          "eV K^-1",
    "Boltzmann constant in Hz/K",                                2.083661912e10,         NA,                   10,         NA,          "Hz K^-1",
    "Boltzmann constant in inverse meter per kelvin",            69.50348004,            NA,                   10,         NA,          "m^-1 K^-1",
    "characteristic impedance of vacuum",                        376.730313668,          0.000000057,          12,         2,           "ohm",
    "classical electron radius",                                 2.8179403262e-15,       0.0000000013e-15,     11,         2,           "m",
    "Compton wavelength",                                        2.42631023867e-12,      0.00000000073e-12,    12,         2,           "m",
    "conductance quantum",                                       7.748091729e-5,         NA,                   10,         NA,          "S",
    "conventional value of ampere-90",                           1.00000008887,          NA,                   12,         NA,          "A",
    "conventional value of coulomb-90",                          1.00000008887,          NA,                   12,         NA,          "C",
    "conventional value of farad-90",                            0.99999998220,          NA,                   11,         NA,          "F",
    "conventional value of henry-90",                            1.00000001779,          NA,                   12,         NA,          "H",
    "conventional value of Josephson constant",                  483597.9e9,             NA,                    7,         NA,          "Hz V^-1",
    "conventional value of ohm-90",                              1.00000001779,          NA,                   12,         NA,          "ohm",
    "conventional value of volt-90",                             1.00000010666,          NA,                   12,         NA,          "V",
    "conventional value of von Klitzing constant",               25812.807,              NA,                    8,         NA,          "ohm",
    "conventional value of watt-90",                             1.00000019553,          NA,                   12,         NA,          "W",
    "Copper x unit",                                             1.00207697e-13,         0.00000028e-13,        9,         2,           "m",
    "deuteron-electron mag. mom. ratio",                         -4.664345551e-4,        0.000000012e-4,       10,         2,           NA,
    "deuteron-electron mass ratio",                              3670.48296788,          0.00000013,           12,         2,           NA,
    "deuteron g factor",                                         0.8574382338,           0.0000000022,         10,         2,           NA,
    "deuteron mag. mom.",                                        4.330735094e-27,        0.000000011e-27,      10,         2,           "J T^-1",
    "deuteron mag. mom. to Bohr magneton ratio",                 4.669754570e-4,         0.000000012e-4,       10,         2,           NA,
    "deuteron mag. mom. to nuclear magneton ratio",              0.8574382338,           0.0000000022,         10,         2,           NA,
    "deuteron mass",                                             3.3435837724e-27,       0.0000000010e-27,     11,         2,           "kg",
    "deuteron mass energy equivalent",                           3.00506323102e-10,      0.00000000091e-10,    12,         2,           "J",
    "deuteron mass energy equivalent in MeV",                    1875.61294257,          0.00000057,           12,         2,           "MeV",
    "deuteron mass in u",                                        2.013553212745,         0.000000000040,       13,         2,           "u",
    "deuteron molar mass",                                       2.01355321205e-3,       0.00000000061e-3,     12,         2,           "kg mol^-1",
    "deuteron-neutron mag. mom. ratio",                          -0.44820653,            0.00000011,            8,         2,           NA,
    "deuteron-proton mag. mom. ratio",                           0.30701220939,          0.00000000079,        11,         2,           NA,
    "deuteron-proton mass ratio",                                1.99900750139,          0.00000000011,        12,         2,           NA,
    "deuteron relative atomic mass",                             2.013553212745,         0.000000000040,       13,         2,           NA,
    "deuteron rms charge radius",                                2.12799e-15,            0.00074e-15,           6,         2,           "m",
    "electron charge to mass quotient",                          -1.75882001076e11,      0.00000000053e11,     12,         2,           "C kg^-1",
    "electron-deuteron mag. mom. ratio",                         -2143.9234915,          0.0000056,            11,         2,           NA,
    "electron-deuteron mass ratio",                              2.724437107462e-4,      0.000000000096e-4,    13,         2,           NA,
    "electron g factor",                                         -2.00231930436256,      0.00000000000035,     15,         2,           NA,
    "electron gyromag. ratio",                                   1.76085963023e11,       0.00000000053e11,     12,         2,           "s^-1 T^-1",
    "electron gyromag. ratio in MHz/T",                          28024.9514242,          0.0000085,            12,         2,           "MHz T^-1",
    "electron-helion mass ratio",                                1.819543074573e-4,      0.000000000079e-4,    13,         2,           NA,
    "electron mag. mom.",                                        -9.2847647043e-24,      0.0000000028e-24,     11,         2,           "J T^-1",
    "electron mag. mom. anomaly",                                1.15965218128e-3,       0.00000000018e-3,     12,         2,           NA,
    "electron mag. mom. to Bohr magneton ratio",                 -1.00115965218128,      0.00000000000018,     15,         2,           NA,
    "electron mag. mom. to nuclear magneton ratio",              -1838.28197188,         0.00000011,           12,         2,           NA,
    "electron mass",                                             9.1093837015e-31,       0.0000000028e-31,     11,         2,           "kg",
    "electron mass energy equivalent",                           8.1871057769e-14,       0.0000000025e-14,     11,         2,           "J",
    "electron mass energy equivalent in MeV",                    0.51099895000,          0.00000000015,        11,         2,           "MeV",
    "electron mass in u",                                        5.48579909065e-4,       0.00000000016e-4,     12,         2,           "u",
    "electron molar mass",                                       5.4857990888e-7,        0.0000000017e-7,      11,         2,           "kg mol^-1",
    "electron-muon mag. mom. ratio",                             206.7669883,            0.0000046,            10,         2,           NA,
    "electron-muon mass ratio",                                  4.83633169e-3,          0.00000011e-3,         9,         2,           NA,
    "electron-neutron mag. mom. ratio",                          960.92050,              0.00023,               8,         2,           NA,
    "electron-neutron mass ratio",                               5.4386734424e-4,        0.0000000026e-4,      11,         2,           NA,
    "electron-proton mag. mom. ratio",                           -658.21068789,          0.00000020,           11,         2,           NA,
    "electron-proton mass ratio",                                5.44617021487e-4,       0.00000000033e-4,     12,         2,           NA,
    "electron relative atomic mass",                             5.48579909065e-4,       0.00000000016e-4,     12,         2,           NA,
    "electron-tau mass ratio",                                   2.87585e-4,             0.00019e-4,            6,         2,           NA,
    "electron to alpha particle mass ratio",                     1.370933554787e-4,      0.000000000045e-4,    13,         2,           NA,
    "electron to shielded helion mag. mom. ratio",               864.058257,             0.000010,              9,         2,           NA,
    "electron to shielded proton mag. mom. ratio",               -658.2275971,           0.0000072,            10,         2,           NA,
    "electron-triton mass ratio",                                1.819200062251e-4,      0.000000000090e-4,    13,         2,           NA,
    "electron volt",                                             1.602176634e-19,        NA,                   10,         NA,          "J",
    "electron volt-atomic mass unit relationship",               1.07354410233e-9,       0.00000000032e-9,     12,         2,           "u",
    "electron volt-hartree relationship",                        3.6749322175655e-2,     0.0000000000071e-2,   14,         2,           "E_h",
    "electron volt-hertz relationship",                          2.417989242e14,         NA,                   10,         NA,          "Hz",
    "electron volt-inverse meter relationship",                  8.065543937e5,          NA,                   10,         NA,          "m^-1",
    "electron volt-joule relationship",                          1.602176634e-19,        NA,                   10,         NA,          "J",
    "electron volt-kelvin relationship",                         1.160451812e4,          NA,                   10,         NA,          "K",
    "electron volt-kilogram relationship",                       1.782661921e-36,        NA,                   10,         NA,          "kg",
    "elementary charge",                                         1.602176634e-19,        NA,                   10,         NA,          "C",
    "elementary charge over h-bar",                              1.519267447e15,         NA,                   10,         NA,          "A J^-1",
    "Faraday constant",                                          96485.33212,            NA,                   10,         NA,          "C mol^-1",
    "Fermi coupling constant",                                   1.1663787e-5,           0.0000006e-5,          8,         1,           "GeV^-2",
    "fine-structure constant",                                   7.2973525693e-3,        0.0000000011e-3,      11,         2,           NA,
    "first radiation constant",                                  3.741771852e-16,        NA,                   10,         NA,          "W m^2",
    "first radiation constant for spectral radiance",            1.191042972e-16,        NA,                   10,         NA,          "W m^2 sr^-1",
    "hartree-atomic mass unit relationship",                     2.92126232205e-8,       0.00000000088e-8,     12,         2,           "u",
    "hartree-electron volt relationship",                        27.211386245988,        0.000000000053,       14,         2,           "eV",
    "Hartree energy",                                            4.3597447222071e-18,    0.0000000000085e-18,  14,         2,           "J",
    "Hartree energy in eV",                                      27.211386245988,        0.000000000053,       14,         2,           "eV",
    "hartree-hertz relationship",                                6.579683920502e15,      0.000000000013e15,    13,         2,           "Hz",
    "hartree-inverse meter relationship",                        2.1947463136320e7,      0.0000000000043e7,    14,         2,           "m^-1",
    "hartree-joule relationship",                                4.3597447222071e-18,    0.0000000000085e-18,  14,         2,           "J",
    "hartree-kelvin relationship",                               3.1577502480407e5,      0.0000000000061e5,    14,         2,           "K",
    "hartree-kilogram relationship",                             4.8508702095432e-35,    0.0000000000094e-35,  14,         2,           "kg",
    "helion-electron mass ratio",                                5495.88528007,          0.00000024,           12,         2,           NA,
    "helion g factor",                                           -4.255250615,           0.000000050,          10,         2,           NA,
    "helion mag. mom.",                                          -1.074617532e-26,       0.000000013e-26,      10,         2,           "J T^-1",
    "helion mag. mom. to Bohr magneton ratio",                   -1.158740958e-3,        0.000000014e-3,       10,         2,           NA,
    "helion mag. mom. to nuclear magneton ratio",                -2.127625307,           0.000000025,          10,         2,           NA,
    "helion mass",                                               5.0064127796e-27,       0.0000000015e-27,     11,         2,           "kg",
    "helion mass energy equivalent",                             4.4995394125e-10,       0.0000000014e-10,     11,         2,           "J",
    "helion mass energy equivalent in MeV",                      2808.39160743,          0.00000085,           12,         2,           "MeV",
    "helion mass in u",                                          3.014932247175,         0.000000000097,       13,         2,           "u",
    "helion molar mass",                                         3.01493224613e-3,       0.00000000091e-3,     12,         2,           "kg mol^-1",
    "helion-proton mass ratio",                                  2.99315267167,          0.00000000013,        12,         2,           NA,
    "helion relative atomic mass",                               3.014932247175,         0.000000000097,       13,         2,           NA,
    "helion shielding shift",                                    5.996743e-5,            0.000010e-5,           7,         2,           NA,
    "hertz-atomic mass unit relationship",                       4.4398216652e-24,       0.0000000013e-24,     11,         2,           "u",
    "hertz-electron volt relationship",                          4.135667696e-15,        NA,                   10,         NA,          "eV",
    "hertz-hartree relationship",                                1.5198298460570e-16,    0.0000000000029e-16,  14,         2,           "E_h",
    "hertz-inverse meter relationship",                          3.335640951e-9,         NA,                   10,         NA,          "m^-1",
    "hertz-joule relationship",                                  6.62607015e-34,         NA,                    9,         NA,          "J",
    "hertz-kelvin relationship",                                 4.799243073e-11,        NA,                   10,         NA,          "K",
    "hertz-kilogram relationship",                               7.372497323e-51,        NA,                   10,         NA,          "kg",
    "hyperfine transition frequency of Cs-133",                  9192631770,             NA,                   10,         NA,          "Hz",
    "inverse fine-structure constant",                           137.035999084,          0.000000021,          12,         2,           NA,
    "inverse meter-atomic mass unit relationship",               1.33102505010e-15,      0.00000000040e-15,    12,         2,           "u",
    "inverse meter-electron volt relationship",                  1.239841984e-6,         NA,                   10,         NA,          "eV",
    "inverse meter-hartree relationship",                        4.5563352529120e-8,     0.0000000000088e-8,   14,         2,           "E_h",
    "inverse meter-hertz relationship",                          299792458,              NA,                    9,         NA,          "Hz",
    "inverse meter-joule relationship",                          1.986445857e-25,        NA,                   10,         NA,          "J",
    "inverse meter-kelvin relationship",                         1.438776877e-2,         NA,                   10,         NA,          "K",
    "inverse meter-kilogram relationship",                       2.210219094e-42,        NA,                   10,         NA,          "kg",
    "inverse of conductance quantum",                            12906.40372,            NA,                   10,         NA,          "ohm",
    "Josephson constant",                                        483597.8484e9,          NA,                   10,         NA,          "Hz V^-1",
    "joule-atomic mass unit relationship",                       6.7005352565e9,         0.0000000020e9,       11,         2,           "u",
    "joule-electron volt relationship",                          6.241509074e18,         NA,                   10,         NA,          "eV",
    "joule-hartree relationship",                                2.2937122783963e17,     0.0000000000045e17,   14,         2,           "E_h",
    "joule-hertz relationship",                                  1.509190179e33,         NA,                   10,         NA,          "Hz",
    "joule-inverse meter relationship",                          5.034116567e24,         NA,                   10,         NA,          "m^-1",
    "joule-kelvin relationship",                                 7.242970516e22,         NA,                   10,         NA,          "K",
    "joule-kilogram relationship",                               1.112650056e-17,        NA,                   10,         NA,          "kg",
    "kelvin-atomic mass unit relationship",                      9.2510873014e-14,       0.0000000028e-14,     11,         2,           "u",
    "kelvin-electron volt relationship",                         8.617333262e-5,         NA,                   10,         NA,          "eV",
    "kelvin-hartree relationship",                               3.1668115634556e-6,     0.0000000000061e-6,   14,         2,           "E_h",
    "kelvin-hertz relationship",                                 2.083661912e10,         NA,                   10,         NA,          "Hz",
    "kelvin-inverse meter relationship",                         69.50348004,            NA,                   10,         NA,          "m^-1",
    "kelvin-joule relationship",                                 1.380649e-23,           NA,                    7,         NA,          "J",
    "kelvin-kilogram relationship",                              1.536179187e-40,        NA,                   10,         NA,          "kg",
    "kilogram-atomic mass unit relationship",                    6.0221407621e26,        0.0000000018e26,      11,         2,           "u",
    "kilogram-electron volt relationship",                       5.609588603e35,         NA,                   10,         NA,          "eV",
    "kilogram-hartree relationship",                             2.0614857887409e34,     0.0000000000040e34,   14,         2,           "E_h",
    "kilogram-hertz relationship",                               1.356392489e50,         NA,                   10,         NA,          "Hz",
    "kilogram-inverse meter relationship",                       4.524438335e41,         NA,                   10,         NA,          "m^-1",
    "kilogram-joule relationship",                               8.987551787e16,         NA,                   10,         NA,          "J",
    "kilogram-kelvin relationship",                              6.509657260e39,         NA,                   10,         NA,          "K",
    "lattice parameter of silicon",                              5.431020511e-10,        0.000000089e-10,      10,         2,           "m",
    "lattice spacing of ideal Si (220)",                         1.920155716e-10,        0.000000032e-10,      10,         2,           "m",
    "Loschmidt constant (273.15 K, 100 kPa)",                    2.651645804e25,         NA,                   10,         NA,          "m^-3",
    "Loschmidt constant (273.15 K, 101.325 kPa)",                2.686780111e25,         NA,                   10,         NA,          "m^-3",
    "luminous efficacy",                                         683,                    NA,                    3,         NA,          "lm W^-1",
    "mag. flux quantum",                                         2.067833848e-15,        NA,                   10,         NA,          "Wb",
    "molar gas constant",                                        8.314462618,            NA,                   10,         NA,          "J mol^-1 K^-1",
    "molar mass constant",                                       0.99999999965e-3,       0.00000000030e-3,     11,         2,           "kg mol^-1",
    "molar mass of carbon-12",                                   11.9999999958e-3,       0.0000000036e-3,      12,         2,           "kg mol^-1",
    "molar Planck constant",                                     3.990312712e-10,        NA,                   10,         NA,          "J Hz^-1 mol^-1",
    "molar volume of ideal gas (273.15 K, 100 kPa)",             22.71095464e-3,         NA,                   10,         NA,          "m^3 mol^-1",
    "molar volume of ideal gas (273.15 K, 101.325 kPa)",         22.41396954e-3,         NA,                   10,         NA,          "m^3 mol^-1",
    "molar volume of silicon",                                   1.205883199e-5,         0.000000060e-5,       10,         2,           "m^3 mol^-1",
    "Molybdenum x unit",                                         1.00209952e-13,         0.00000053e-13,        9,         2,           "m",
    "muon Compton wavelength",                                   1.173444110e-14,        0.000000026e-14,      10,         2,           "m",
    "muon-electron mass ratio",                                  206.7682830,            0.0000046,            10,         2,           NA,
    "muon g factor",                                             -2.0023318418,          0.0000000013,         11,         2,           NA,
    "muon mag. mom.",                                            -4.49044830e-26,        0.00000010e-26,        9,         2,           "J T^-1",
    "muon mag. mom. anomaly",                                    1.16592089e-3,          0.00000063e-3,         9,         2,           NA,
    "muon mag. mom. to Bohr magneton ratio",                     -4.84197047e-3,         0.00000011e-3,         9,         2,           NA,
    "muon mag. mom. to nuclear magneton ratio",                  -8.89059703,            0.00000020,            9,         2,           NA,
    "muon mass",                                                 1.883531627e-28,        0.000000042e-28,      10,         2,           "kg",
    "muon mass energy equivalent",                               1.692833804e-11,        0.000000038e-11,      10,         2,           "J",
    "muon mass energy equivalent in MeV",                        105.6583755,            0.0000023,            10,         2,           "MeV",
    "muon mass in u",                                            0.1134289259,           0.0000000025,         10,         2,           "u",
    "muon molar mass",                                           1.134289259e-4,         0.000000025e-4,       10,         2,           "kg mol^-1",
    "muon-neutron mass ratio",                                   0.1124545170,           0.0000000025,         10,         2,           NA,
    "muon-proton mag. mom. ratio",                               -3.183345142,           0.000000071,          10,         2,           NA,
    "muon-proton mass ratio",                                    0.1126095264,           0.0000000025,         10,         2,           NA,
    "muon-tau mass ratio",                                       5.94635e-2,             0.00040e-2,            6,         2,           NA,
    "natural unit of action",                                    1.054571817e-34,        NA,                   10,         NA,          "J s",
    "natural unit of action in eV s",                            6.582119569e-16,        NA,                   10,         NA,          "eV s",
    "natural unit of energy",                                    8.1871057769e-14,       0.0000000025e-14,     11,         2,           "J",
    "natural unit of energy in MeV",                             0.51099895000,          0.00000000015,        11,         2,           "MeV",
    "natural unit of length",                                    3.8615926796e-13,       0.0000000012e-13,     11,         2,           "m",
    "natural unit of mass",                                      9.1093837015e-31,       0.0000000028e-31,     11,         2,           "kg",
    "natural unit of momentum",                                  2.73092453075e-22,      0.00000000082e-22,    12,         2,           "kg m s^-1",
    "natural unit of momentum in MeV/c",                         0.51099895000,          0.00000000015,        11,         2,           "MeV / c",
    "natural unit of time",                                      1.28808866819e-21,      0.00000000039e-21,    12,         2,           "s",
    "natural unit of velocity",                                  299792458,              NA,                    9,         NA,          "m s^-1",
    "neutron Compton wavelength",                                1.31959090581e-15,      0.00000000075e-15,    12,         2,           "m",
    "neutron-electron mag. mom. ratio",                          1.04066882e-3,          0.00000025e-3,         9,         2,           NA,
    "neutron-electron mass ratio",                               1838.68366173,          0.00000089,           12,         2,           NA,
    "neutron g factor",                                          -3.82608545,            0.00000090,            9,         2,           NA,
    "neutron gyromag. ratio",                                    1.83247171e8,           0.00000043e8,          9,         2,           "s^-1 T^-1",
    "neutron gyromag. ratio in MHz/T",                           29.1646931,             0.0000069,             9,         2,           "MHz T^-1",
    "neutron mag. mom.",                                         -9.6623651e-27,         0.0000023e-27,         8,         2,           "J T^-1",
    "neutron mag. mom. to Bohr magneton ratio",                  -1.04187563e-3,         0.00000025e-3,         9,         2,           NA,
    "neutron mag. mom. to nuclear magneton ratio",               -1.91304273,            0.00000045,            9,         2,           NA,
    "neutron mass",                                              1.67492749804e-27,      0.00000000095e-27,    12,         2,           "kg",
    "neutron mass energy equivalent",                            1.50534976287e-10,      0.00000000086e-10,    12,         2,           "J",
    "neutron mass energy equivalent in MeV",                     939.56542052,           0.00000054,           11,         2,           "MeV",
    "neutron mass in u",                                         1.00866491595,          0.00000000049,        12,         2,           "u",
    "neutron molar mass",                                        1.00866491560e-3,       0.00000000057e-3,     12,         2,           "kg mol^-1",
    "neutron-muon mass ratio",                                   8.89248406,             0.00000020,            9,         2,           NA,
    "neutron-proton mag. mom. ratio",                            -0.68497934,            0.00000016,            8,         2,           NA,
    "neutron-proton mass difference",                            2.30557435e-30,         0.00000082e-30,        9,         2,           "kg",
    "neutron-proton mass difference energy equivalent",          2.07214689e-13,         0.00000074e-13,        9,         2,           "J",
    "neutron-proton mass difference energy equivalent in MeV",   1.29333236,             0.00000046,            9,         2,           "MeV",
    "neutron-proton mass difference in u",                       1.38844933e-3,          0.00000049e-3,         9,         2,           "u",
    "neutron-proton mass ratio",                                 1.00137841931,          0.00000000049,        12,         2,           NA,
    "neutron relative atomic mass",                              1.00866491595,          0.00000000049,        12,         2,           NA,
    "neutron-tau mass ratio",                                    0.528779,               0.000036,              6,         2,           NA,
    "neutron to shielded proton mag. mom. ratio",                -0.68499694,            0.00000016,            8,         2,           NA,
    "Newtonian constant of gravitation",                         6.67430e-11,            0.00015e-11,           6,         2,           "m^3 kg^-1 s^-2",
    "Newtonian constant of gravitation over h-bar c",            6.70883e-39,            0.00015e-39,           6,         2,           "( GeV / c^2 )^-2",
    "nuclear magneton",                                          5.0507837461e-27,       0.0000000015e-27,     11,         2,           "J T^-1",
    "nuclear magneton in eV/T",                                  3.15245125844e-8,       0.00000000096e-8,     12,         2,           "eV T^-1",
    "nuclear magneton in inverse meter per tesla",               2.54262341353e-2,       0.00000000078e-2,     12,         2,           "m^-1 T^-1",
    "nuclear magneton in K/T",                                   3.6582677756e-4,        0.0000000011e-4,      11,         2,           "K T^-1",
    "nuclear magneton in MHz/T",                                 7.6225932291,           0.0000000023,         11,         2,           "MHz T^-1",
    "Planck constant",                                           6.62607015e-34,         NA,                    9,         NA,          "J Hz^-1",
    "Planck constant in eV/Hz",                                  4.135667696e-15,        NA,                   10,         NA,          "eV Hz^-1",
    "Planck length",                                             1.616255e-35,           0.000018e-35,          7,         2,           "m",
    "Planck mass",                                               2.176434e-8,            0.000024e-8,           7,         2,           "kg",
    "Planck mass energy equivalent in GeV",                      1.220890e19,            0.000014e19,           7,         2,           "GeV",
    "Planck temperature",                                        1.416784e32,            0.000016e32,           7,         2,           "K",
    "Planck time",                                               5.391247e-44,           0.000060e-44,          7,         2,           "s",
    "proton charge to mass quotient",                            9.5788331560e7,         0.0000000029e7,       11,         2,           "C kg^-1",
    "proton Compton wavelength",                                 1.32140985539e-15,      0.00000000040e-15,    12,         2,           "m",
    "proton-electron mass ratio",                                1836.15267343,          0.00000011,           12,         2,           NA,
    "proton g factor",                                           5.5856946893,           0.0000000016,         11,         2,           NA,
    "proton gyromag. ratio",                                     2.6752218744e8,         0.0000000011e8,       11,         2,           "s^-1 T^-1",
    "proton gyromag. ratio in MHz/T",                            42.577478518,           0.000000018,          11,         2,           "MHz T^-1",
    "proton mag. mom.",                                          1.41060679736e-26,      0.00000000060e-26,    12,         2,           "J T^-1",
    "proton mag. mom. to Bohr magneton ratio",                   1.52103220230e-3,       0.00000000046e-3,     12,         2,           NA,
    "proton mag. mom. to nuclear magneton ratio",                2.79284734463,          0.00000000082,        12,         2,           NA,
    "proton mag. shielding correction",                          2.5689e-5,              0.0011e-5,             5,         2,           NA,
    "proton mass",                                               1.67262192369e-27,      0.00000000051e-27,    12,         2,           "kg",
    "proton mass energy equivalent",                             1.50327761598e-10,      0.00000000046e-10,    12,         2,           "J",
    "proton mass energy equivalent in MeV",                      938.27208816,           0.00000029,           11,         2,           "MeV",
    "proton mass in u",                                          1.007276466621,         0.000000000053,       13,         2,           "u",
    "proton molar mass",                                         1.00727646627e-3,       0.00000000031e-3,     12,         2,           "kg mol^-1",
    "proton-muon mass ratio",                                    8.88024337,             0.00000020,            9,         2,           NA,
    "proton-neutron mag. mom. ratio",                            -1.45989805,            0.00000034,            9,         2,           NA,
    "proton-neutron mass ratio",                                 0.99862347812,          0.00000000049,        11,         2,           NA,
    "proton relative atomic mass",                               1.007276466621,         0.000000000053,       13,         2,           NA,
    "proton rms charge radius",                                  8.414e-16,              0.019e-16,             4,         2,           "m",
    "proton-tau mass ratio",                                     0.528051,               0.000036,              6,         2,           NA,
    "quantum of circulation",                                    3.6369475516e-4,        0.0000000011e-4,      11,         2,           "m^2 s^-1",
    "quantum of circulation times 2",                            7.2738951032e-4,        0.0000000022e-4,      11,         2,           "m^2 s^-1",
    "reduced Compton wavelength",                                3.8615926796e-13,       0.0000000012e-13,     11,         2,           "m",
    "reduced muon Compton wavelength",                           1.867594306e-15,        0.000000042e-15,      10,         2,           "m",
    "reduced neutron Compton wavelength",                        2.1001941552e-16,       0.0000000012e-16,     11,         2,           "m",
    "reduced Planck constant",                                   1.054571817e-34,        NA,                   10,         NA,          "J s",
    "reduced Planck constant in eV s",                           6.582119569e-16,        NA,                   10,         NA,          "eV s",
    "reduced Planck constant times c in MeV fm",                 197.3269804,            NA,                   10,         NA,          "MeV fm",
    "reduced proton Compton wavelength",                         2.10308910336e-16,      0.00000000064e-16,    12,         2,           "m",
    "reduced tau Compton wavelength",                            1.110538e-16,           0.000075e-16,          7,         2,           "m",
    "Rydberg constant",                                          10973731.568160,        0.000021,             14,         2,           "m^-1",
    "Rydberg constant times c in Hz",                            3.2898419602508e15,     0.0000000000064e15,   14,         2,           "Hz",
    "Rydberg constant times hc in eV",                           13.605693122994,        0.000000000026,       14,         2,           "eV",
    "Rydberg constant times hc in J",                            2.1798723611035e-18,    0.0000000000042e-18,  14,         2,           "J",
    "Sackur-Tetrode constant (1 K, 100 kPa)",                    -1.15170753706,         0.00000000045,        12,         2,           NA,
    "Sackur-Tetrode constant (1 K, 101.325 kPa)",                -1.16487052358,         0.00000000045,        12,         2,           NA,
    "second radiation constant",                                 1.438776877e-2,         NA,                   10,         NA,          "m K",
    "shielded helion gyromag. ratio",                            2.037894569e8,          0.000000024e8,        10,         2,           "s^-1 T^-1",
    "shielded helion gyromag. ratio in MHz/T",                   32.43409942,            0.00000038,           10,         2,           "MHz T^-1",
    "shielded helion mag. mom.",                                 -1.074553090e-26,       0.000000013e-26,      10,         2,           "J T^-1",
    "shielded helion mag. mom. to Bohr magneton ratio",          -1.158671471e-3,        0.000000014e-3,       10,         2,           NA,
    "shielded helion mag. mom. to nuclear magneton ratio",       -2.127497719,           0.000000025,          10,         2,           NA,
    "shielded helion to proton mag. mom. ratio",                 -0.7617665618,          0.0000000089,         10,         2,           NA,
    "shielded helion to shielded proton mag. mom. ratio",        -0.7617861313,          0.0000000033,         10,         2,           NA,
    "shielded proton gyromag. ratio",                            2.675153151e8,          0.000000029e8,        10,         2,           "s^-1 T^-1",
    "shielded proton gyromag. ratio in MHz/T",                   42.57638474,            0.00000046,           10,         2,           "MHz T^-1",
    "shielded proton mag. mom.",                                 1.410570560e-26,        0.000000015e-26,      10,         2,           "J T^-1",
    "shielded proton mag. mom. to Bohr magneton ratio",          1.520993128e-3,         0.000000017e-3,       10,         2,           NA,
    "shielded proton mag. mom. to nuclear magneton ratio",       2.792775599,            0.000000030,          10,         2,           NA,
    "shielding difference of d and p in HD",                     2.0200e-8,              0.0020e-8,             5,         2,           NA,
    "shielding difference of t and p in HT",                     2.4140e-8,              0.0020e-8,             5,         2,           NA,
    "speed of light in vacuum",                                  299792458,              NA,                    9,         NA,          "m s^-1",
    "standard acceleration of gravity",                          9.80665,                NA,                    6,         NA,          "m s^-2",
    "standard atmosphere",                                       101325,                 NA,                    6,         NA,          "Pa",
    "standard-state pressure",                                   100000,                 NA,                    6,         NA,          "Pa",
    "Stefan-Boltzmann constant",                                 5.670374419e-8,         NA,                   10,         NA,          "W m^-2 K^-4",
    "tau Compton wavelength",                                    6.97771e-16,            0.00047e-16,           6,         2,           "m",
    "tau-electron mass ratio",                                   3477.23,                0.23,                  6,         2,           NA,
    "tau energy equivalent",                                     1776.86,                0.12,                  6,         2,           "MeV",
    "tau mass",                                                  3.16754e-27,            0.00021e-27,           6,         2,           "kg",
    "tau mass energy equivalent",                                2.84684e-10,            0.00019e-10,           6,         2,           "J",
    "tau mass in u",                                             1.90754,                0.00013,               6,         2,           "u",
    "tau molar mass",                                            1.90754e-3,             0.00013e-3,            6,         2,           "kg mol^-1",
    "tau-muon mass ratio",                                       16.8170,                0.0011,                6,         2,           NA,
    "tau-neutron mass ratio",                                    1.89115,                0.00013,               6,         2,           NA,
    "tau-proton mass ratio",                                     1.89376,                0.00013,               6,         2,           NA,
    "Thomson cross section",                                     6.6524587321e-29,       0.0000000060e-29,     11,         2,           "m^2",
    "triton-electron mass ratio",                                5496.92153573,          0.00000027,           12,         2,           NA,
    "triton g factor",                                           5.957924931,            0.000000012,          10,         2,           NA,
    "triton mag. mom.",                                          1.5046095202e-26,       0.0000000030e-26,     11,         2,           "J T^-1",
    "triton mag. mom. to Bohr magneton ratio",                   1.6223936651e-3,        0.0000000032e-3,      11,         2,           NA,
    "triton mag. mom. to nuclear magneton ratio",                2.9789624656,           0.0000000059,         11,         2,           NA,
    "triton mass",                                               5.0073567446e-27,       0.0000000015e-27,     11,         2,           "kg",
    "triton mass energy equivalent",                             4.5003878060e-10,       0.0000000014e-10,     11,         2,           "J",
    "triton mass energy equivalent in MeV",                      2808.92113298,          0.00000085,           12,         2,           "MeV",
    "triton mass in u",                                          3.01550071621,          0.00000000012,        12,         2,           "u",
    "triton molar mass",                                         3.01550071517e-3,       0.00000000092e-3,     12,         2,           "kg mol^-1",
    "triton-proton mass ratio",                                  2.99371703414,          0.00000000015,        12,         2,           NA,
    "triton relative atomic mass",                               3.01550071621,          0.00000000012,        12,         2,           NA,
    "triton to proton mag. mom. ratio",                          1.0666399191,           0.0000000021,         11,         2,           NA,
    "unified atomic mass unit",                                  1.66053906660e-27,      0.00000000050e-27,    12,         2,           "kg",
    "vacuum electric permittivity",                              8.8541878128e-12,       0.0000000013e-12,     11,         2,           "F m^-1",
    "vacuum mag. permeability",                                  1.25663706212e-6,       0.00000000019e-6,     12,         2,           "N A^-2",
    "von Klitzing constant",                                     25812.80745,            NA,                   10,         NA,          "ohm",
    "weak mixing angle",                                         0.22290,                0.00030,               5,         2,           NA,
    "Wien frequency displacement law constant",                  5.878925757e10,         NA,                   10,         NA,          "Hz K^-1",
    "Wien wavelength displacement law constant",                 2.897771955e-3,         NA,                   10,         NA,          "m K",
    "W to Z mass ratio",                                         0.88153,                0.00017,               5,         2,           NA
  )
