% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fir2.R
\name{fir2}
\alias{fir2}
\title{Frequency sampling-based FIR filter design}
\usage{
fir2(n, f, m, grid_n = 512, ramp_n = NULL, window = hamming(n + 1))
}
\arguments{
\item{n}{filter order (1 less than the length of the filter).}

\item{f}{vector of frequency points in the range from 0 to 1, where 1
corresponds to the Nyquist frequency. The first point of \code{f} must be 0
and the last point must be 1. \code{f} must be sorted in increasing order.
Duplicate frequency points are allowed and are treated as steps in the
frequency response.}

\item{m}{vector of the same length as \code{f} containing the desired
magnitude response at each of the points specified in \code{f}.}

\item{grid_n}{length of ideal frequency response function. \code{grid_n}
defaults to 512, and should be a power of 2 bigger than \code{n}.}

\item{ramp_n}{transition width for jumps in filter response (defaults to
\code{grid_n / 20}). A wider ramp gives wider transitions but has better
stopband characteristics.}

\item{window}{smoothing window. The returned filter is the same shape as the
smoothing window. Default: \code{hamming(n + 1)}.}
}
\value{
The FIR filter coefficients, a vector of length \code{n + 1}, of
  class \code{Ma}.
}
\description{
Produce a FIR filter with arbitrary frequency response over frequency bands.
}
\details{
The function linearly interpolates the desired frequency response onto a
dense grid and then uses the inverse Fourier transform and a Hamming window
to obtain the filter coefficients.
}
\examples{
f <- c(0, 0.3, 0.3, 0.6, 0.6, 1)
m <- c(0, 0, 1, 1/2, 0, 0)
fh <- freqz(fir2(100, f, m))
op <- par(mfrow = c(1, 2))
plot(f, m, type = "b", ylab = "magnitude", xlab = "Frequency")
lines(fh$w / pi, abs(fh$h), col = "blue")
# plot in dB:
plot(f, 20*log10(m+1e-5), type = "b", ylab = "dB", xlab = "Frequency")
lines(fh$w / pi, 20*log10(abs(fh$h)), col = "blue")
par(op)

}
\seealso{
\code{\link{Ma}}, \code{\link{filter}}, \code{\link{fftfilt}},
  \code{\link{fir1}}
}
\author{
Paul Kienzle, \email{pkienzle@users.sf.net}.\cr
 Conversion to R Tom Short,\cr
 adapted by Geert van Boxtel, \email{G.J.M.vanBoxtel@gmail.com}.
}
