% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gpb.plot.interpretation.R
\name{gpb.plot.interpretation}
\alias{gpb.plot.interpretation}
\title{Plot feature contribution as a bar graph}
\usage{
gpb.plot.interpretation(tree_interpretation_dt, top_n = 10L, cols = 1L,
  left_margin = 10L, cex = NULL)
}
\arguments{
\item{tree_interpretation_dt}{a \code{data.table} returned by \code{\link{gpb.interprete}}.}

\item{top_n}{maximal number of top features to include into the plot.}

\item{cols}{the column numbers of layout, will be used only for multiclass classification feature contribution.}

\item{left_margin}{(base R barplot) allows to adjust the left margin size to fit feature names.}

\item{cex}{(base R barplot) passed as \code{cex.names} parameter to \code{barplot}.}
}
\value{
The \code{gpb.plot.interpretation} function creates a \code{barplot}.
}
\description{
Plot previously calculated feature contribution as a bar graph.
}
\details{
The graph represents each feature as a horizontal bar of length proportional to the defined
contribution of a feature. Features are shown ranked in a decreasing contribution order.
}
\examples{
\donttest{
Logit <- function(x) {
  log(x / (1.0 - x))
}
data(agaricus.train, package = "gpboost")
labels <- agaricus.train$label
dtrain <- gpb.Dataset(
  agaricus.train$data
  , label = labels
)
setinfo(dtrain, "init_score", rep(Logit(mean(labels)), length(labels)))

data(agaricus.test, package = "gpboost")

params <- list(
  objective = "binary"
  , learning_rate = 0.1
  , max_depth = -1L
  , min_data_in_leaf = 1L
  , min_sum_hessian_in_leaf = 1.0
)
model <- gpb.train(
  params = params
  , data = dtrain
  , nrounds = 5L
)

tree_interpretation <- gpb.interprete(
  model = model
  , data = agaricus.test$data
  , idxset = 1L:5L
)
gpb.plot.interpretation(
  tree_interpretation_dt = tree_interpretation[[1L]]
  , top_n = 3L
)
}
}
