# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' Process `csisearch` Calls from R
#'
#' @param dir_lhs A vector of vertices with outgoing directed edges
#' @param dir_rhs A vector of vertices with incoming directed edges
#' @param lab A vector of labels for vertices
#' @param p_list A list of known distributions
#' @param q_vec A vector of vertices representing the causal query
#' @param label_map A list of edge labels
#' @param local_csi Local CSI statements
#' @param con_vars A set of variables that have assignments in labels
#'   (non-interventional)
#' @param intv_vars A set of of interventional variables
#' @param n Number of vertices
#' @param time_limit Time limit for the search (in hours)
#' @param rules Overrides the set of default rules
#' @param benchmark Record the search time
#' @param benchmark_rules Record time taken by each individual rule
#' @param draw_derivation Form a string representing the derivation steps (as dot)
#' @param draw_all Draw every distribution that was derived
#'   (vs only those that were used to derive the effect)
#' @param formula Output formula as string
#' @param improve Enable search enhancements
#' @param heuristic Use search heuristic
#' @param cache Use caching for separation criteria
#' @param verbose Print diagnostics during search
#' @noRd
initialize_csisearch <- function(dir_lhs, dir_rhs, lab, p_list, q_vec, label_map, local_csi, con_vars, intv_vars, n, time_limit, rules, benchmark, benchmark_rules, draw_derivation, draw_all, formula, improve, heuristic, cache, verbose) {
    .Call(`_dosearch_initialize_csisearch`, dir_lhs, dir_rhs, lab, p_list, q_vec, label_map, local_csi, con_vars, intv_vars, n, time_limit, rules, benchmark, benchmark_rules, draw_derivation, draw_all, formula, improve, heuristic, cache, verbose)
}

#' Process `dosearch` Calls from R
#'
#' @param dir_lhs A vector of vertices with outgoing directed edges
#' @param dir_rhs A vector of vertices with incoming directed edges
#' @param bi_lhs A vector of vertices with incoming bidirected edges
#' @param bi_rhs A vector of vertices with incoming bidirected edges
#' @param lab A vector of labels for vertices
#' @param p_list A list of known distributions
#' @param q_vec A vector of vertices representing the causal query
#' @param n The number of vertices
#' @param tr A set representing transportability nodes
#' @param sb A set representing selection bias nodes
#' @param md_s A set representing missing data switches
#' @param md_p A set representing missing data proxies
#' @param time_limit Time limit for the search (in hours)
#' @param rules Overrides the set of default rules
#' @param benchmark Record the search time
#' @param benchmark_rules Record time taken by each individual rule
#' @param draw_derivation Form a string representing the
#'   derivation steps (as dot)
#' @param draw_all Draw every distribution that was derived
#'   (vs only those that were used to derive the effect)
#' @param formula Output formula as string
#' @param improve Enable search enhancements
#' @param heuristic Use search heuristic
#' @param md_sym Symbol used to represent active missing data mechanisms
#' @param verbose Print diagnostics during search
#' @noRd
initialize_dosearch <- function(dir_lhs, dir_rhs, bi_lhs, bi_rhs, lab, p_list, q_vec, n, tr, sb, md_s, md_p, time_limit, rules, benchmark, benchmark_rules, draw_derivation, draw_all, formula, improve, heuristic, md_sym, verbose) {
    .Call(`_dosearch_initialize_dosearch`, dir_lhs, dir_rhs, bi_lhs, bi_rhs, lab, p_list, q_vec, n, tr, sb, md_s, md_p, time_limit, rules, benchmark, benchmark_rules, draw_derivation, draw_all, formula, improve, heuristic, md_sym, verbose)
}

