% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{split_disc_cont_ps_qs}
\alias{split_disc_cont_ps_qs}
\title{Split ps and qs into those corresponding to discrete and continuous
parts of a distribution.}
\usage{
split_disc_cont_ps_qs(
  ps,
  qs,
  dup_tol = 1e-06,
  zero_tol = 1e-12,
  is_hurdle = FALSE
)
}
\arguments{
\item{ps}{vector of probability levels}

\item{qs}{vector of quantile values corresponding to ps}

\item{dup_tol}{numeric tolerance for identifying duplicated values indicating
a discrete component of the distribution. If there is a run of values where
each consecutive pair is closer together than the tolerance, all are
labeled as duplicates even if not all values in the run are within the
tolerance.}

\item{zero_tol}{numeric tolerance for identifying values in \code{qs} that are
(approximately) zero.}

\item{is_hurdle}{boolean indicating whether or not this is a hurdle model.
If so, qs of zero always indicate the presence of a point mass at 0.
In this case, 0 is not included among the returned \code{cont_qs}. Setting this
argument to \code{TRUE} is primarily appropriate when we are working with a
distributional family that is bounded above 0 (and may have density 0 at 0)
such as a lognormal.}
}
\value{
named list with the following entries:
\itemize{
\item \code{disc_weight}: estimated numeric weight of the discrete part of the
distribution.
\item \code{disc_ps}: estimated probabilities of discrete components. May be
\code{numeric(0)} if there are no estimated discrete components.
\item \code{disc_qs}: locations of discrete components, corresponding to duplicated
values in the input \code{qs}. May be \code{numeric(0)} if there are no discrete
components.
\item \code{cont_ps}: probability levels for the continuous part of the distribution
\item \code{cont_qs}: quantile values for the continuous part of the distribution
\item \code{disc_ps_range}: a list of length equal to the number of point masses in
the discrete distribution. Each entry is a numeric vector of length two
with the value of the CDF approaching the point mass from the left and
from the right.
}
}
\description{
Split ps and qs into those corresponding to discrete and continuous
parts of a distribution.
}
