% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ard_smd_smd.R
\name{ard_smd_smd}
\alias{ard_smd_smd}
\title{ARD Standardized Mean Difference}
\usage{
ard_smd_smd(data, by, variables, std.error = TRUE, conf.level = 0.95, ...)
}
\arguments{
\item{data}{(\code{data.frame}/\code{survey.design})\cr
a data frame or object of class 'survey.design'
(typically created with \code{\link[survey:svydesign]{survey::svydesign()}}).}

\item{by}{(\code{\link[dplyr:dplyr_tidy_select]{tidy-select}})\cr
column name to compare by.}

\item{variables}{(\code{\link[dplyr:dplyr_tidy_select]{tidy-select}})\cr
column names to be compared. Independent tests will be computed for
each variable.}

\item{std.error}{(scalar \code{logical})\cr
Logical indicator for computing standard errors using \code{smd::compute_smd_var()}.
Default is \code{TRUE}.}

\item{conf.level}{(scalar \code{numeric})\cr
confidence level for confidence interval. Default is \code{0.95}.}

\item{...}{arguments passed to \code{smd::smd()}}
}
\value{
ARD data frame
}
\description{
Standardized mean difference calculated via \code{\link[smd:smd]{smd::smd()}} with \code{na.rm = TRUE}.
Additionally, this function add a confidence interval to the SMD when
\code{std.error=TRUE}, which the original \code{smd::smd()} does not include.
}
\examples{
\dontshow{if (do.call(asNamespace("cardx")$is_pkg_installed, list(pkg = "smd", reference_pkg = "cardx"))) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
ard_smd_smd(cards::ADSL, by = SEX, variables = AGE)
ard_smd_smd(cards::ADSL, by = SEX, variables = AGEGR1)
\dontshow{\}) # examplesIf}
}
