% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.R
\name{summary.SDDRidT}
\alias{summary.SDDRidT}
\title{Provides summary of verifying shocks' normality}
\usage{
\method{summary}{SDDRidT}(object, ...)
}
\arguments{
\item{object}{an object of class \code{SDDRidT} obtained using the
\code{\link{verify_identification.PosteriorBSVART}} function.}

\item{...}{additional arguments affecting the summary produced.}
}
\value{
A table reporting the Bayes factor of normal to
Student-t shocks posterior odds \code{"SDDR"} as well as its logarithm 
\code{"log(SDDR)"}for each structural shock, and the implied posterior 
probability of the normality and Student-t hypothesis, 
\code{"Pr[normal|data]"} and \code{"Pr[Student-t|data]"} 
respectively.
}
\description{
Provides summary of the Savage-Dickey density ratios
for verification of structural shocks normality. The outcomes can be
used to make probabilistic statements about identification through 
non-normality.
}
\examples{
# upload data
data(us_fiscal_lsuw)

# specify the model and set seed
specification  = specify_bsvar_t$new(us_fiscal_lsuw)
set.seed(123)

# estimate the model
posterior      = estimate(specification, 10)

# verify heteroskedasticity
sddr           = verify_identification(posterior)
summary(sddr)

# workflow with the pipe |>
############################################################
set.seed(123)
us_fiscal_lsuw |>
  specify_bsvar_t$new() |>
  estimate(S = 10) |> 
  verify_identification() |> 
  summary() -> sddr_summary

}
\seealso{
\code{\link{verify_identification.PosteriorBSVART}}
}
\author{
Tomasz Woźniak \email{wozniak.tom@pm.me}
}
