% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/biplots.R
\name{biplots}
\alias{biplots}
\alias{biplots.default}
\title{Biplots}
\usage{
\method{biplots}{default}(
  model,
  burnin = 0.3,
  thin = 0.2,
  pb = 0.05,
  plot_stable = TRUE,
  plot_unstable = TRUE,
  ncolors = 5
)
}
\arguments{
\item{model}{Output from `bayes_ammi()`. This should contain the results of the Bayesian AMMI model, including all sampled iterations.}

\item{burnin}{Numeric. Percentage of iterations to discard as burn-in to avoid the effects of random initializations during sampling. For example, `burnin = 0.1` removes the first 10\% of iterations.}

\item{thin}{Numeric. Proportion of sampled iterations to retain for analysis. For example, `thin = 0.2` keeps 20\% of the iterations, selecting 1 out of every 5 iterations.}

\item{pb}{Numeric. Significance levels for the contours in the plot. Smaller values of `pb` result in wider contours, while higher values create smaller, more specific contours.}

\item{plot_stable}{Logical. If `TRUE`, stable instances are highlighted in the output plot.}

\item{plot_unstable}{Logical. If `TRUE`, unstable instances are highlighted in the output plot.}

\item{ncolors}{Integer. Specifies the number of distinct colors to use in the plot. Adjust this to control the visual differentiation of elements in the plot.}
}
\value{
A list with the following components:
\describe{
  \item{plot}{A plot displaying the contours and final biplot values.}
  \item{contour_data}{A `data.frame` containing the data used to create the contours.}
  \item{biplot_data}{A `data.frame` containing the data used to recreate the final biplot values.}
}
}
\description{
biplots
}
\examples{
\dontrun{
data(Maiz)

fm1 <-
  bayes_ammi(
    .data = Maiz,
    .y = y,
    .gen = entry,
    .env = site,
    .rep = rep,
    .nIter = 200
  )

library(ggplot2)

output_05 <- biplots(model = fm1, plot_stable = TRUE, plot_unstable = TRUE, pb = 0.05)
output_05

output_95 <- biplots(model = fm1, plot_stable = TRUE, plot_unstable = TRUE, pb = 0.95)
output_95
}

}
\references{
Crossa, J., Perez-Elizalde, S., Jarquin, D., Cotes, J.M., Viele, K., Liu, G., and Cornelius, P.L. (2011)
 Bayesian Estimation of the Additive Main Effects and Multiplicative Interaction Model
 \emph{Crop Science}, \strong{51}, 1458–1469.
 (\href{https://acsess.onlinelibrary.wiley.com/doi/abs/10.2135/cropsci2010.06.0343}{doi: 10.2135/cropsci2010.06.0343})
}
\author{
\enumerate{
    \item Julian Garcia Abadillo Velasco (\email{garciaabadillo.j@ufl.edu})
    \item Diego Jarquin (\email{diego.jarquin@gmail.com})
   }
}
