% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{M5_CA1_basefc}
\alias{M5_CA1_basefc}
\title{Example of hierarchical forecasts for a store from the M5 competition}
\format{
A list containing:
\itemize{
\item \code{upper}: a list of 11 elements each representing an aggregation level. Each element contains: \code{mu}, \code{sigma} the mean and standard deviation of the Gaussian forecast, \code{actual} the actual value, \code{residuals} the residuals of the model used to estimate forecasts covariance.
\item \code{lower}: a list of 3049 elements each representing a forecast for each item. Each element contains \code{pmf} the probability mass function of the item level forecast, \code{actual} the actual value.
\item \code{A}: the aggregation matrix for A.
\item \code{S}: the S matrix for the hierarchy.
\item \code{Q_u}: scaling factors for computing MASE on the upper forecasts.
\item \code{Q_b}: scaling factors for computing MASE on the bottom forecasts.
}
}
\source{
Makridakis, Spyros & Spiliotis, Evangelos & Assimakopoulos, Vassilis. (2020). \emph{The M5 Accuracy competition: Results, findings and conclusions.} International Journal of Forecasting 38(4) 1346-1364. \doi{10.1016/j.ijforecast.2021.10.009}
}
\usage{
M5_CA1_basefc
}
\description{
This dataset contains forecasts for the hierarchy of time series related to the store \code{CA_1} from the M5 competition.
}
\details{
The store \code{CA_1} contains 3049 item level time series and 11 aggregate time series:
\itemize{
\item Store level aggregation (\code{CA_1})
\item Category level aggregations  (\code{HOBBIES}, \code{HOUSEHOLD}, \code{FOODS})
\item Department level aggregations (\code{HOBBIES_1}, \code{HOBBIES_2}, \code{HOUSEHOLD_1}, \code{HOUSEHOLD_2}, \code{FOODS_1}, \code{FOODS_2}, \code{FOODS_3})
}

Forecasts are generated with the function \code{forecast} and the model \code{adam} from the package \code{smooth}.
\itemize{
\item The models for the bottom time series are selected with multiplicative Gamma error term (\code{MNN});
\item The models for the upper time series (\code{AXZ}) is selected with Gaussian additive error term, seasonality selected based on information criterion.
}

The raw data was downloaded with the package \code{m5}.
}
\references{
Joachimiak K (2022). \emph{m5: 'M5 Forecasting' Challenges Data}. R package version 0.1.1, \url{https://CRAN.R-project.org/package=m5}.

Makridakis, Spyros & Spiliotis, Evangelos & Assimakopoulos, Vassilis. (2020). \emph{The M5 Accuracy competition: Results, findings and conclusions.} International Journal of Forecasting 38(4) 1346-1364. \doi{10.1016/j.ijforecast.2021.10.009}

Svetunkov I (2023). \emph{smooth: Forecasting Using State Space Models}. R package version 4.0.0, \url{https://CRAN.R-project.org/package=smooth}.
}
\keyword{datasets}
