% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/get.R
\docType{methods}
\name{get}
\alias{get}
\alias{get_columns}
\alias{get_columns-method}
\alias{get_rows}
\alias{get_rows-method}
\alias{get_columns,data.frame-method}
\alias{get_rows,data.frame-method}
\title{Get Rows/Columns by Name}
\usage{
get_columns(x, ...)

get_rows(x, ...)

\S4method{get_columns}{data.frame}(x, select = NULL, ...)

\S4method{get_rows}{data.frame}(x, select = NULL, ...)
}
\arguments{
\item{x}{An \R object (should be a \code{\link{matrix}} or a \code{\link{data.frame}}).}

\item{...}{Further arguments to be passed to \code{select}.}

\item{select}{A \code{\link{function}} to be applied to the row/colum names
(e.g. \code{\link[=startsWith]{startsWith()}}). Must return a single \code{integer} or \code{logical} vector.}
}
\value{
An object of the same sort as \code{x}.
}
\description{
Returns rows/columns selected by name in an array-like object.
}
\examples{
## Seek columns
seek_columns(iris, select = startsWith, prefix = "Sepal")

## Get columns
x <- get_columns(iris, select = startsWith, prefix = "Sepal")
head(x)
}
\seealso{
Other data preparation tools: 
\code{\link{append}()},
\code{\link{assign}()},
\code{\link{compact}()},
\code{\link{count}()},
\code{\link{detect}()},
\code{\link{discard}()},
\code{\link{keep}()},
\code{\link{seek}()}
}
\author{
N. Frerebeau
}
\concept{data preparation tools}
