% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/file_read.R, R/file_write.R
\name{file_read}
\alias{file_read}
\alias{file_connections}
\alias{file_write}
\title{Construct a connections for (possibly compressed) files.}
\usage{
file_read(file, mode = "r", filter = NULL, options = character())

file_write(file, mode = "w", filter = NULL, options = character())
}
\arguments{
\item{file}{\code{character(1) || integer(1)} The filename within the archive,
specified either by filename or by position.}

\item{mode}{\code{character(1)} A description of how to open the
connection (if it should be opened initially).  See section
‘Modes’ in \code{\link[base:connections]{base::connections()}} for possible values.}

\item{filter}{\code{character(1)} default: \code{NULL} The archive filter, one of \eval{choices_rd(names(archive:::archive_filters()))}.
Supported filters differ depending on the libarchive version and build.}

\item{options}{\code{character()} default: \code{character(0)} Options to pass to the filter or format.
The list of available options are documented in
options can have one of the following forms:
\itemize{
\item \code{option=value}
The option/value pair will be provided to every module.
Modules that do not accept an option with this name will
ignore it.
\item \code{option}
The option will be provided to every module with a value
of "1".
\item \code{!option}
The option will be provided to every module with a NULL
value.
\item \code{module:option=value}, \code{module:option}, \code{module:!option}
As above, but the corresponding option and value will be
provided only to modules whose name matches module.
See \href{https://man.freebsd.org/cgi/man.cgi?query=archive_read_set_options&sektion=3&format=html}{read options} for available read options
See \href{https://man.freebsd.org/cgi/man.cgi?query=archive_write_set_options&sektion=3&format=html}{write options} for available write options
}}
}
\value{
An 'archive_read' connection (for \code{file_read()}) or an 'archive_write' connection (for \code{file_write()}) to the file.
}
\description{
They are functionally equivalent to calling \link{archive_read} or
\link{archive_write} using \verb{format = "raw", archive = file}.
}
\details{
\code{file_write()} returns an writable output connection,
\code{file_read()} returns a readable input connection.
}
\examples{
if (archive:::libarchive_version() > "3.2.0") {
# Write bzip2, base 64 encoded data and use high compression
write.csv(mtcars,
  file_write("mtcars.bz2",
    filter = c("uuencode", "bzip2"),
    options = "compression-level=9"
  )
)

# Read it back
read.csv(file_read("mtcars.bz2"), row.names = 1, nrows = 3)
unlink("mtcars.bz2")
}
}
