% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ssn_write.R
\name{ssn_write}
\alias{ssn_write}
\title{write an SSN object}
\usage{
ssn_write(ssn, path, overwrite = FALSE, copy_dist = FALSE, import = FALSE)
}
\arguments{
\item{ssn}{An \code{SSN} object.}

\item{path}{filepath to the local .ssn directory to write to.}

\item{overwrite}{If \code{TRUE}, overwrite existing files in \code{file}
(if it exists). Defaults to \code{FALSE}.}

\item{copy_dist}{If \code{TRUE}, copy distance matrices to \code{file}
(if they exist). Defaults to \code{FALSE}.}

\item{import}{If \code{TRUE}, import and return the \code{SSN} object
after writing to file. Defaults to \code{FALSE}.}
}
\value{
{ssn_write} creates an .ssn directory that contains the
spatial, topological, and attribute information stored in the
original \code{SSN} object. Spatial datasets found in the
\code{SSN} object (e.g. edges, obs, and prediction sites) are
saved in GeoPackage format. When \code{import = TRUE}, the
\code{SSN} object is imported and returned.
}
\description{
This function writes an \code{SSN} object to a local
.ssn directory
}
\examples{
## For examples only, copy MiddleFork04.ssn directory to R's
# temporary directory
copy_lsn_to_temp()
## Import SSN object with prediction sites
mf04p <- ssn_import(paste0(tempdir(), "/MiddleFork04.ssn"),
  predpts = "pred1km",
  overwrite = TRUE
)

## Write SSN to new .ssn directory
ssn_write(mf04p,
  path = paste0(tempdir(), "/tempSSN.ssn"),
  overwrite = TRUE
)

## Write SSN to .ssn directory and return SSN object
tempSSN <- ssn_write(mf04p, path = paste0(
  tempdir(),
  "/tempSSN.ssn"
), overwrite = TRUE, import = TRUE)
}
