% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PLR-predict.R
\name{predict.PLR}
\alias{predict.PLR}
\alias{predict.PLR_boot}
\alias{predict.PLR_cv}
\alias{fitted.PLR}
\alias{fitted.PLR_boot}
\alias{fitted.PLR_cv}
\title{Prediction and fitted values for the penalized Lorenz regression}
\usage{
\method{predict}{PLR}(object, newdata, type = c("index", "response"), pars.idx = "BIC", ...)

\method{fitted}{PLR}(object, type = c("index", "response"), pars.idx = "BIC", ...)
}
\arguments{
\item{object}{An object of S3 class \code{"PLR"}. The object might also have S3 classes \code{"PLR_boot"} and/or \code{"PLR_cv"} (both inherit from class \code{"PLR"})}

\item{newdata}{An optional data frame in which to look for variables with which to predict. If omitted, the original data are used.}

\item{type}{A character string indicating the type of prediction or fitted values. Possible values are \code{"response"} and \code{"index"} (the default).
In the first case, the conditional expectation of the response given the covariates is estimated.
In the second case, only the index of the single-index model is estimated.}

\item{pars.idx}{What grid and penalty parameters should be used for parameter selection. Either a character string specifying the selection method, where the possible values are:
\itemize{
   \item \code{"BIC"} (default) - Always available.
   \item \code{"Boot"} - Available if \code{object} inherits from \code{"PLR_boot"}.
   \item \code{"CV"} - Available if \code{object} inherits from \code{"PLR_cv"}.
}
Or a numeric vector of length 2, where the first element is the index of the grid parameter and the second is the index of the penalty parameter.}

\item{...}{Additional arguments passed to the function \code{\link{Rearrangement.estimation}}.}
}
\value{
A vector of predictions for \code{predict}, or a vector of fitted values for \code{fitted}.
}
\description{
\code{prediction} provides predictions for an object of class \code{"PLR"},
while \code{fitted} extracts the fitted values.
}
\details{
If \code{type="response"}, the link function of the single-index model must be estimated. This is done via the function \code{\link{Rearrangement.estimation}}.
}
\examples{
## For examples see example(Lorenz.Reg), example(Lorenz.boot) and example(PLR.CV)

}
\seealso{
\code{\link{Lorenz.Reg}}, \code{\link{Rearrangement.estimation}}
}
