% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hsmm_functions_old.R
\name{tpm_hsmm2}
\alias{tpm_hsmm2}
\title{Build the transition probability matrix of an HSMM-approximating HMM}
\usage{
tpm_hsmm2(omega, dm, eps = 1e-10)
}
\arguments{
\item{omega}{embedded transition probability matrix of dimension c(N,N)}

\item{dm}{state dwell-time distributions arranged in a list of length(N). Each list element needs to be a vector of length N_i, where N_i is the state aggregate size.}

\item{eps}{rounding value: If an entry of the transition probabily matrix is smaller, than it is rounded to zero.}
}
\value{
extended-state-space transition probability matrix of the approximating HMM
}
\description{
Hidden semi-Markov models (HSMMs) are a flexible extension of HMMs. 
For direct numerical maximum likelhood estimation, HSMMs can be represented as HMMs on an enlarged state space (of size \eqn{M}) and with structured transition probabilities.
This function computes the transition matrix of an HSMM.
}
\examples{
# building the t.p.m. of the embedded Markov chain
omega = matrix(c(0,1,1,0), nrow = 2, byrow = TRUE)
# defining state aggregate sizes
sizes = c(20, 30)
# defining state dwell-time distributions
lambda = c(5, 11)
dm = list(dpois(1:sizes[1]-1, lambda[1]), dpois(1:sizes[2]-1, lambda[2]))
# calculating extended-state-space t.p.m.
Gamma = tpm_hsmm(omega, dm)
}
