% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/relief.R
\name{relief}
\alias{relief}
\title{RReliefF filter}
\usage{
relief(formula, data, x, y, neighboursCount = 5, sampleSize = 10)
}
\arguments{
\item{formula}{An object of class \link{formula} with model description.}

\item{data}{A \link{data.frame} accompanying formula.}

\item{x}{A \link{data.frame} with attributes.}

\item{y}{A vector with response variable.}

\item{neighboursCount}{number of neighbours to find for every sampled instance}

\item{sampleSize}{number of instances to sample}
}
\value{
a data.frame containing the worth of attributes in the first column and their names as row names
}
\description{
The algorithm finds weights of continuous and discrete attributes basing on a distance between instances.
}
\details{
The function and it's manual page taken directly from \pkg{FSelector}:
Piotr Romanski and Lars Kotthoff (2018). FSelector: Selecting Attributes.
R package version 0.31. https://CRAN.R-project.org/package=FSelector
}
\examples{

data(iris)

weights <- relief(Species~., iris, neighboursCount = 5, sampleSize = 20)
print(weights)
subset <- cut_attrs(weights, 2)
f <- to_formula(subset, "Species")
print(f)
}
\references{
Igor Kononenko: Estimating Attributes: Analysis and Extensions of RELIEF. In: European Conference on Machine Learning, 171-182, 1994.

Marko Robnik-Sikonja, Igor Kononenko: An adaptation of Relief for attribute estimation in regression. In: Fourteenth International Conference on Machine Learning, 296-304, 1997.
}
