function Snowball() {
BaseStemmer = function() {
this.setCurrent = function(value) {
this.current = value;
this.cursor = 0;
this.limit = this.current.length;
this.limit_backward = 0;
this.bra = this.cursor;
this.ket = this.limit;
};
this.getCurrent = function() {
return this.current;
};
this.copy_from = function(other) {
this.current = other.current;
this.cursor = other.cursor;
this.limit = other.limit;
this.limit_backward = other.limit_backward;
this.bra = other.bra;
this.ket = other.ket;
};
this.in_grouping = function(s, min, max) {
if (this.cursor >= this.limit) return false;
var ch = this.current.charCodeAt(this.cursor);
if (ch > max || ch < min) return false;
ch -= min;
if ((s[ch >>> 3] & (0x1 << (ch & 0x7))) == 0) return false;
this.cursor++;
return true;
};
this.in_grouping_b = function(s, min, max) {
if (this.cursor <= this.limit_backward) return false;
var ch = this.current.charCodeAt(this.cursor - 1);
if (ch > max || ch < min) return false;
ch -= min;
if ((s[ch >>> 3] & (0x1 << (ch & 0x7))) == 0) return false;
this.cursor--;
return true;
};
this.out_grouping = function(s, min, max) {
if (this.cursor >= this.limit) return false;
var ch = this.current.charCodeAt(this.cursor);
if (ch > max || ch < min) {
this.cursor++;
return true;
}
ch -= min;
if ((s[ch >>> 3] & (0X1 << (ch & 0x7))) == 0) {
this.cursor++;
return true;
}
return false;
};
this.out_grouping_b = function(s, min, max) {
if (this.cursor <= this.limit_backward) return false;
var ch = this.current.charCodeAt(this.cursor - 1);
if (ch > max || ch < min) {
this.cursor--;
return true;
}
ch -= min;
if ((s[ch >>> 3] & (0x1 << (ch & 0x7))) == 0) {
this.cursor--;
return true;
}
return false;
};
this.eq_s = function(s)
{
if (this.limit - this.cursor < s.length) return false;
if (this.current.slice(this.cursor, this.cursor + s.length) != s)
{
return false;
}
this.cursor += s.length;
return true;
};
this.eq_s_b = function(s)
{
if (this.cursor - this.limit_backward < s.length) return false;
if (this.current.slice(this.cursor - s.length, this.cursor) != s)
{
return false;
}
this.cursor -= s.length;
return true;
};
 this.find_among = function(v)
{
var i = 0;
var j = v.length;
var c = this.cursor;
var l = this.limit;
var common_i = 0;
var common_j = 0;
var first_key_inspected = false;
while (true)
{
var k = i + ((j - i) >>> 1);
var diff = 0;
var common = common_i < common_j ? common_i : common_j; 
var w = v[k];
var i2;
for (i2 = common; i2 < w[0].length; i2++)
{
if (c + common == l)
{
diff = -1;
break;
}
diff = this.current.charCodeAt(c + common) - w[0].charCodeAt(i2);
if (diff != 0) break;
common++;
}
if (diff < 0)
{
j = k;
common_j = common;
}
else
{
i = k;
common_i = common;
}
if (j - i <= 1)
{
if (i > 0) break; 
if (j == i) break; 
if (first_key_inspected) break;
first_key_inspected = true;
}
}
do {
var w = v[i];
if (common_i >= w[0].length)
{
this.cursor = c + w[0].length;
if (w.length < 4) return w[2];
var res = w[3](this);
this.cursor = c + w[0].length;
if (res) return w[2];
}
i = w[1];
} while (i >= 0);
return 0;
};
this.find_among_b = function(v)
{
var i = 0;
var j = v.length
var c = this.cursor;
var lb = this.limit_backward;
var common_i = 0;
var common_j = 0;
var first_key_inspected = false;
while (true)
{
var k = i + ((j - i) >> 1);
var diff = 0;
var common = common_i < common_j ? common_i : common_j;
var w = v[k];
var i2;
for (i2 = w[0].length - 1 - common; i2 >= 0; i2--)
{
if (c - common == lb)
{
diff = -1;
break;
}
diff = this.current.charCodeAt(c - 1 - common) - w[0].charCodeAt(i2);
if (diff != 0) break;
common++;
}
if (diff < 0)
{
j = k;
common_j = common;
}
else
{
i = k;
common_i = common;
}
if (j - i <= 1)
{
if (i > 0) break;
if (j == i) break;
if (first_key_inspected) break;
first_key_inspected = true;
}
}
do {
var w = v[i];
if (common_i >= w[0].length)
{
this.cursor = c - w[0].length;
if (w.length < 4) return w[2];
var res = w[3](this);
this.cursor = c - w[0].length;
if (res) return w[2];
}
i = w[1];
} while (i >= 0);
return 0;
};
this.replace_s = function(c_bra, c_ket, s)
{
var adjustment = s.length - (c_ket - c_bra);
this.current = this.current.slice(0, c_bra) + s + this.current.slice(c_ket);
this.limit += adjustment;
if (this.cursor >= c_ket) this.cursor += adjustment;
else if (this.cursor > c_bra) this.cursor = c_bra;
return adjustment;
};
this.slice_check = function()
{
if (this.bra < 0 ||
this.bra > this.ket ||
this.ket > this.limit ||
this.limit > this.current.length)
{
return false;
}
return true;
};
this.slice_from = function(s)
{
var result = false;
if (this.slice_check())
{
this.replace_s(this.bra, this.ket, s);
result = true;
}
return result;
};
this.slice_del = function()
{
return this.slice_from("");
};
this.insert = function(c_bra, c_ket, s)
{
var adjustment = this.replace_s(c_bra, c_ket, s);
if (c_bra <= this.bra) this.bra += adjustment;
if (c_bra <= this.ket) this.ket += adjustment;
};
this.slice_to = function()
{
var result = '';
if (this.slice_check())
{
result = this.current.slice(this.bra, this.ket);
}
return result;
};
this.assign_to = function()
{
return this.current.slice(0, this.limit);
};
};
EnglishStemmer = function() {
var base = new BaseStemmer();
 var a_0 = [
["arsen", -1, -1],
["commun", -1, -1],
["gener", -1, -1]
];
 var a_1 = [
["'", -1, 1],
["'s'", 0, 1],
["'s", -1, 1]
];
 var a_2 = [
["ied", -1, 2],
["s", -1, 3],
["ies", 1, 2],
["sses", 1, 1],
["ss", 1, -1],
["us", 1, -1]
];
 var a_3 = [
["", -1, 3],
["bb", 0, 2],
["dd", 0, 2],
["ff", 0, 2],
["gg", 0, 2],
["bl", 0, 1],
["mm", 0, 2],
["nn", 0, 2],
["pp", 0, 2],
["rr", 0, 2],
["at", 0, 1],
["tt", 0, 2],
["iz", 0, 1]
];
 var a_4 = [
["ed", -1, 2],
["eed", 0, 1],
["ing", -1, 2],
["edly", -1, 2],
["eedly", 3, 1],
["ingly", -1, 2]
];
 var a_5 = [
["anci", -1, 3],
["enci", -1, 2],
["ogi", -1, 13],
["li", -1, 15],
["bli", 3, 12],
["abli", 4, 4],
["alli", 3, 8],
["fulli", 3, 9],
["lessli", 3, 14],
["ousli", 3, 10],
["entli", 3, 5],
["aliti", -1, 8],
["biliti", -1, 12],
["iviti", -1, 11],
["tional", -1, 1],
["ational", 14, 7],
["alism", -1, 8],
["ation", -1, 7],
["ization", 17, 6],
["izer", -1, 6],
["ator", -1, 7],
["iveness", -1, 11],
["fulness", -1, 9],
["ousness", -1, 10]
];
 var a_6 = [
["icate", -1, 4],
["ative", -1, 6],
["alize", -1, 3],
["iciti", -1, 4],
["ical", -1, 4],
["tional", -1, 1],
["ational", 5, 2],
["ful", -1, 5],
["ness", -1, 5]
];
 var a_7 = [
["ic", -1, 1],
["ance", -1, 1],
["ence", -1, 1],
["able", -1, 1],
["ible", -1, 1],
["ate", -1, 1],
["ive", -1, 1],
["ize", -1, 1],
["iti", -1, 1],
["al", -1, 1],
["ism", -1, 1],
["ion", -1, 2],
["er", -1, 1],
["ous", -1, 1],
["ant", -1, 1],
["ent", -1, 1],
["ment", 15, 1],
["ement", 16, 1]
];
 var a_8 = [
["e", -1, 1],
["l", -1, 2]
];
 var a_9 = [
["succeed", -1, -1],
["proceed", -1, -1],
["exceed", -1, -1],
["canning", -1, -1],
["inning", -1, -1],
["earring", -1, -1],
["herring", -1, -1],
["outing", -1, -1]
];
 var a_10 = [
["andes", -1, -1],
["atlas", -1, -1],
["bias", -1, -1],
["cosmos", -1, -1],
["dying", -1, 3],
["early", -1, 9],
["gently", -1, 7],
["howe", -1, -1],
["idly", -1, 6],
["lying", -1, 4],
["news", -1, -1],
["only", -1, 10],
["singly", -1, 11],
["skies", -1, 2],
["skis", -1, 1],
["sky", -1, -1],
["tying", -1, 5],
["ugly", -1, 8]
];
 var  g_v = [17, 65, 16, 1];
 var  g_v_WXY = [1, 17, 65, 208, 1];
 var  g_valid_LI = [55, 141, 2];
var  B_Y_found = false;
var  I_p2 = 0;
var  I_p1 = 0;
function r_prelude() {
B_Y_found = false;
var  v_1 = base.cursor;
lab0: {
base.bra = base.cursor;
if (!(base.eq_s("'")))
{
break lab0;
}
base.ket = base.cursor;
if (!base.slice_del())
{
return false;
}
}
base.cursor = v_1;
var  v_2 = base.cursor;
lab1: {
base.bra = base.cursor;
if (!(base.eq_s("y")))
{
break lab1;
}
base.ket = base.cursor;
if (!base.slice_from("Y"))
{
return false;
}
B_Y_found = true;
}
base.cursor = v_2;
var  v_3 = base.cursor;
lab2: {
while(true)
{
var  v_4 = base.cursor;
lab3: {
golab4: while(true)
{
var  v_5 = base.cursor;
lab5: {
if (!(base.in_grouping(g_v, 97, 121)))
{
break lab5;
}
base.bra = base.cursor;
if (!(base.eq_s("y")))
{
break lab5;
}
base.ket = base.cursor;
base.cursor = v_5;
break golab4;
}
base.cursor = v_5;
if (base.cursor >= base.limit)
{
break lab3;
}
base.cursor++;
}
if (!base.slice_from("Y"))
{
return false;
}
B_Y_found = true;
continue;
}
base.cursor = v_4;
break;
}
}
base.cursor = v_3;
return true;
};
function r_mark_regions() {
I_p1 = base.limit;
I_p2 = base.limit;
var  v_1 = base.cursor;
lab0: {
lab1: {
var  v_2 = base.cursor;
lab2: {
if (base.find_among(a_0) == 0)
{
break lab2;
}
break lab1;
}
base.cursor = v_2;
golab3: while(true)
{
lab4: {
if (!(base.in_grouping(g_v, 97, 121)))
{
break lab4;
}
break golab3;
}
if (base.cursor >= base.limit)
{
break lab0;
}
base.cursor++;
}
golab5: while(true)
{
lab6: {
if (!(base.out_grouping(g_v, 97, 121)))
{
break lab6;
}
break golab5;
}
if (base.cursor >= base.limit)
{
break lab0;
}
base.cursor++;
}
}
I_p1 = base.cursor;
golab7: while(true)
{
lab8: {
if (!(base.in_grouping(g_v, 97, 121)))
{
break lab8;
}
break golab7;
}
if (base.cursor >= base.limit)
{
break lab0;
}
base.cursor++;
}
golab9: while(true)
{
lab10: {
if (!(base.out_grouping(g_v, 97, 121)))
{
break lab10;
}
break golab9;
}
if (base.cursor >= base.limit)
{
break lab0;
}
base.cursor++;
}
I_p2 = base.cursor;
}
base.cursor = v_1;
return true;
};
function r_shortv() {
lab0: {
var  v_1 = base.limit - base.cursor;
lab1: {
if (!(base.out_grouping_b(g_v_WXY, 89, 121)))
{
break lab1;
}
if (!(base.in_grouping_b(g_v, 97, 121)))
{
break lab1;
}
if (!(base.out_grouping_b(g_v, 97, 121)))
{
break lab1;
}
break lab0;
}
base.cursor = base.limit - v_1;
if (!(base.out_grouping_b(g_v, 97, 121)))
{
return false;
}
if (!(base.in_grouping_b(g_v, 97, 121)))
{
return false;
}
if (base.cursor > base.limit_backward)
{
return false;
}
}
return true;
};
function r_R1() {
if (!(I_p1 <= base.cursor))
{
return false;
}
return true;
};
function r_R2() {
if (!(I_p2 <= base.cursor))
{
return false;
}
return true;
};
function r_Step_1a() {
var  among_var;
var  v_1 = base.limit - base.cursor;
lab0: {
base.ket = base.cursor;
if (base.find_among_b(a_1) == 0)
{
base.cursor = base.limit - v_1;
break lab0;
}
base.bra = base.cursor;
if (!base.slice_del())
{
return false;
}
}
base.ket = base.cursor;
among_var = base.find_among_b(a_2);
if (among_var == 0)
{
return false;
}
base.bra = base.cursor;
switch (among_var) {
case 1:
if (!base.slice_from("ss"))
{
return false;
}
break;
case 2:
lab1: {
var  v_2 = base.limit - base.cursor;
lab2: {
{
var  c1 = base.cursor - 2;
if (base.limit_backward > c1 || c1 > base.limit)
{
break lab2;
}
base.cursor = c1;
}
if (!base.slice_from("i"))
{
return false;
}
break lab1;
}
base.cursor = base.limit - v_2;
if (!base.slice_from("ie"))
{
return false;
}
}
break;
case 3:
if (base.cursor <= base.limit_backward)
{
return false;
}
base.cursor--;
golab3: while(true)
{
lab4: {
if (!(base.in_grouping_b(g_v, 97, 121)))
{
break lab4;
}
break golab3;
}
if (base.cursor <= base.limit_backward)
{
return false;
}
base.cursor--;
}
if (!base.slice_del())
{
return false;
}
break;
}
return true;
};
function r_Step_1b() {
var  among_var;
base.ket = base.cursor;
among_var = base.find_among_b(a_4);
if (among_var == 0)
{
return false;
}
base.bra = base.cursor;
switch (among_var) {
case 1:
if (!r_R1())
{
return false;
}
if (!base.slice_from("ee"))
{
return false;
}
break;
case 2:
var  v_1 = base.limit - base.cursor;
golab0: while(true)
{
lab1: {
if (!(base.in_grouping_b(g_v, 97, 121)))
{
break lab1;
}
break golab0;
}
if (base.cursor <= base.limit_backward)
{
return false;
}
base.cursor--;
}
base.cursor = base.limit - v_1;
if (!base.slice_del())
{
return false;
}
var  v_3 = base.limit - base.cursor;
among_var = base.find_among_b(a_3);
if (among_var == 0)
{
return false;
}
base.cursor = base.limit - v_3;
switch (among_var) {
case 1:
{
var  c1 = base.cursor;
base.insert(base.cursor, base.cursor, "e");
base.cursor = c1;
}
break;
case 2:
base.ket = base.cursor;
if (base.cursor <= base.limit_backward)
{
return false;
}
base.cursor--;
base.bra = base.cursor;
if (!base.slice_del())
{
return false;
}
break;
case 3:
if (base.cursor != I_p1)
{
return false;
}
var  v_4 = base.limit - base.cursor;
if (!r_shortv())
{
return false;
}
base.cursor = base.limit - v_4;
{
var  c2 = base.cursor;
base.insert(base.cursor, base.cursor, "e");
base.cursor = c2;
}
break;
}
break;
}
return true;
};
function r_Step_1c() {
base.ket = base.cursor;
lab0: {
var  v_1 = base.limit - base.cursor;
lab1: {
if (!(base.eq_s_b("y")))
{
break lab1;
}
break lab0;
}
base.cursor = base.limit - v_1;
if (!(base.eq_s_b("Y")))
{
return false;
}
}
base.bra = base.cursor;
if (!(base.out_grouping_b(g_v, 97, 121)))
{
return false;
}
lab2: {
if (base.cursor > base.limit_backward)
{
break lab2;
}
return false;
}
if (!base.slice_from("i"))
{
return false;
}
return true;
};
function r_Step_2() {
var  among_var;
base.ket = base.cursor;
among_var = base.find_among_b(a_5);
if (among_var == 0)
{
return false;
}
base.bra = base.cursor;
if (!r_R1())
{
return false;
}
switch (among_var) {
case 1:
if (!base.slice_from("tion"))
{
return false;
}
break;
case 2:
if (!base.slice_from("ence"))
{
return false;
}
break;
case 3:
if (!base.slice_from("ance"))
{
return false;
}
break;
case 4:
if (!base.slice_from("able"))
{
return false;
}
break;
case 5:
if (!base.slice_from("ent"))
{
return false;
}
break;
case 6:
if (!base.slice_from("ize"))
{
return false;
}
break;
case 7:
if (!base.slice_from("ate"))
{
return false;
}
break;
case 8:
if (!base.slice_from("al"))
{
return false;
}
break;
case 9:
if (!base.slice_from("ful"))
{
return false;
}
break;
case 10:
if (!base.slice_from("ous"))
{
return false;
}
break;
case 11:
if (!base.slice_from("ive"))
{
return false;
}
break;
case 12:
if (!base.slice_from("ble"))
{
return false;
}
break;
case 13:
if (!(base.eq_s_b("l")))
{
return false;
}
if (!base.slice_from("og"))
{
return false;
}
break;
case 14:
if (!base.slice_from("less"))
{
return false;
}
break;
case 15:
if (!(base.in_grouping_b(g_valid_LI, 99, 116)))
{
return false;
}
if (!base.slice_del())
{
return false;
}
break;
}
return true;
};
function r_Step_3() {
var  among_var;
base.ket = base.cursor;
among_var = base.find_among_b(a_6);
if (among_var == 0)
{
return false;
}
base.bra = base.cursor;
if (!r_R1())
{
return false;
}
switch (among_var) {
case 1:
if (!base.slice_from("tion"))
{
return false;
}
break;
case 2:
if (!base.slice_from("ate"))
{
return false;
}
break;
case 3:
if (!base.slice_from("al"))
{
return false;
}
break;
case 4:
if (!base.slice_from("ic"))
{
return false;
}
break;
case 5:
if (!base.slice_del())
{
return false;
}
break;
case 6:
if (!r_R2())
{
return false;
}
if (!base.slice_del())
{
return false;
}
break;
}
return true;
};
function r_Step_4() {
var  among_var;
base.ket = base.cursor;
among_var = base.find_among_b(a_7);
if (among_var == 0)
{
return false;
}
base.bra = base.cursor;
if (!r_R2())
{
return false;
}
switch (among_var) {
case 1:
if (!base.slice_del())
{
return false;
}
break;
case 2:
lab0: {
var  v_1 = base.limit - base.cursor;
lab1: {
if (!(base.eq_s_b("s")))
{
break lab1;
}
break lab0;
}
base.cursor = base.limit - v_1;
if (!(base.eq_s_b("t")))
{
return false;
}
}
if (!base.slice_del())
{
return false;
}
break;
}
return true;
};
function r_Step_5() {
var  among_var;
base.ket = base.cursor;
among_var = base.find_among_b(a_8);
if (among_var == 0)
{
return false;
}
base.bra = base.cursor;
switch (among_var) {
case 1:
lab0: {
var  v_1 = base.limit - base.cursor;
lab1: {
if (!r_R2())
{
break lab1;
}
break lab0;
}
base.cursor = base.limit - v_1;
if (!r_R1())
{
return false;
}
{
var  v_2 = base.limit - base.cursor;
lab2: {
if (!r_shortv())
{
break lab2;
}
return false;
}
base.cursor = base.limit - v_2;
}
}
if (!base.slice_del())
{
return false;
}
break;
case 2:
if (!r_R2())
{
return false;
}
if (!(base.eq_s_b("l")))
{
return false;
}
if (!base.slice_del())
{
return false;
}
break;
}
return true;
};
function r_exception2() {
base.ket = base.cursor;
if (base.find_among_b(a_9) == 0)
{
return false;
}
base.bra = base.cursor;
if (base.cursor > base.limit_backward)
{
return false;
}
return true;
};
function r_exception1() {
var  among_var;
base.bra = base.cursor;
among_var = base.find_among(a_10);
if (among_var == 0)
{
return false;
}
base.ket = base.cursor;
if (base.cursor < base.limit)
{
return false;
}
switch (among_var) {
case 1:
if (!base.slice_from("ski"))
{
return false;
}
break;
case 2:
if (!base.slice_from("sky"))
{
return false;
}
break;
case 3:
if (!base.slice_from("die"))
{
return false;
}
break;
case 4:
if (!base.slice_from("lie"))
{
return false;
}
break;
case 5:
if (!base.slice_from("tie"))
{
return false;
}
break;
case 6:
if (!base.slice_from("idl"))
{
return false;
}
break;
case 7:
if (!base.slice_from("gentl"))
{
return false;
}
break;
case 8:
if (!base.slice_from("ugli"))
{
return false;
}
break;
case 9:
if (!base.slice_from("earli"))
{
return false;
}
break;
case 10:
if (!base.slice_from("onli"))
{
return false;
}
break;
case 11:
if (!base.slice_from("singl"))
{
return false;
}
break;
}
return true;
};
function r_postlude() {
if (!B_Y_found)
{
return false;
}
while(true)
{
var  v_1 = base.cursor;
lab0: {
golab1: while(true)
{
var  v_2 = base.cursor;
lab2: {
base.bra = base.cursor;
if (!(base.eq_s("Y")))
{
break lab2;
}
base.ket = base.cursor;
base.cursor = v_2;
break golab1;
}
base.cursor = v_2;
if (base.cursor >= base.limit)
{
break lab0;
}
base.cursor++;
}
if (!base.slice_from("y"))
{
return false;
}
continue;
}
base.cursor = v_1;
break;
}
return true;
};
this.stem =  function() {
lab0: {
var  v_1 = base.cursor;
lab1: {
if (!r_exception1())
{
break lab1;
}
break lab0;
}
base.cursor = v_1;
lab2: {
{
var  v_2 = base.cursor;
lab3: {
{
var  c1 = base.cursor + 3;
if (0 > c1 || c1 > base.limit)
{
break lab3;
}
base.cursor = c1;
}
break lab2;
}
base.cursor = v_2;
}
break lab0;
}
base.cursor = v_1;
r_prelude();
r_mark_regions();
base.limit_backward = base.cursor; base.cursor = base.limit;
var  v_5 = base.limit - base.cursor;
r_Step_1a();
base.cursor = base.limit - v_5;
lab4: {
var  v_6 = base.limit - base.cursor;
lab5: {
if (!r_exception2())
{
break lab5;
}
break lab4;
}
base.cursor = base.limit - v_6;
var  v_7 = base.limit - base.cursor;
r_Step_1b();
base.cursor = base.limit - v_7;
var  v_8 = base.limit - base.cursor;
r_Step_1c();
base.cursor = base.limit - v_8;
var  v_9 = base.limit - base.cursor;
r_Step_2();
base.cursor = base.limit - v_9;
var  v_10 = base.limit - base.cursor;
r_Step_3();
base.cursor = base.limit - v_10;
var  v_11 = base.limit - base.cursor;
r_Step_4();
base.cursor = base.limit - v_11;
var  v_12 = base.limit - base.cursor;
r_Step_5();
base.cursor = base.limit - v_12;
}
base.cursor = base.limit_backward;
var  v_13 = base.cursor;
r_postlude();
base.cursor = v_13;
}
return true;
};
this['stemWord'] = function(word) {
base.setCurrent(word);
this.stem();
return base.getCurrent();
};
};
return new EnglishStemmer();
}
wh.search_stemmer = Snowball();
wh.search_baseNameList = [
 "appendix.LanguageToolPlugin.inOmegaT.html",
 "appendix.ScriptingPlugin.inOmegaT.html",
 "appendix.TeamProjects.html",
 "appendix.TokenizerPlugin.inOmegaT.html",
 "appendix.acknowledgements.html",
 "appendix.keyboard.html",
 "appendix.languages.html",
 "appendix.legal.notices.html",
 "appendix.shortcut.custom.html",
 "appendix.website.html",
 "chapter.about.OmegaT.html",
 "chapter.dictionaries.html",
 "chapter.file.filters.html",
 "chapter.files.and.folders.html",
 "chapter.files.to.translate.html",
 "chapter.formatted.text.html",
 "chapter.glossaries.html",
 "chapter.installing.and.running.html",
 "chapter.instant.start.guide.html",
 "chapter.machine.translate.html",
 "chapter.menu.html",
 "chapter.misc.html",
 "chapter.plain.text.html",
 "chapter.project.properties.html",
 "chapter.regexp.html",
 "chapter.searches.html",
 "chapter.segmentation.html",
 "chapter.spellchecker.html",
 "chapter.translation.editing.html",
 "chapter.translation.memories.html",
 "chapter.user.interface.html",
 "index.html",
 "ix01.html"
];
wh.search_titleList = [
 "Приложение E. Модуль «LanguageTool»",
 "Приложение F. Модуль «Scripting»",
 "Приложение C. Командные проекты в ОмегаТ",
 "Приложение D. Модуль «tokenizer»",
 "Приложение J. Благодарности",
 "Приложение B. Сочетания клавиш для редактирования текста",
 "Приложение A. Языки - список кодов ISO 639",
 "Приложение I. Авторские права",
 "Приложение H. Настройка сочетаний клавиш",
 "Приложение G. ОмегаТ в Интернете",
 "Об ОмегаТ - Введение",
 "Словари",
 "Файловые фильтры",
 "Файлы и каталоги ОмегаТ",
 "Файлы для перевода",
 "Работа с форматированным текстом",
 "Глоссарии",
 "Установка и запуск ОмегаТ",
 "Научитесь работать с OmegaT за 5 минут!",
 "Машинный перевод",
 "Меню и сочетания клавиш",
 "Темы, не вошедшие в другие разделы",
 "Работа с простыми текстовыми файлами",
 "Свойства проекта",
 "Регулярные выражения",
 "Поиск",
 "Сегментация исходного текста",
 "Проверка орфографии",
 "Параметры редактирования",
 "Память переводов",
 "Пользовательский интерфейс",
 "Руководство пользователя ОмегаТ 3.0",
 "Предметный указатель"
];
wh.search_wordMap= {
"состоять": [2],
"несоответствия": [[4,29,30]],
"корректности": [18],
"тегами": [15,32,14,31,[10,20,29,30]],
"hall": [7],
"японском": [22],
"таитянский": [6],
"экспорт": [29,32,16,28],
"японской": [20],
"расставлены": [[15,18]],
"подстроку": [29],
"повлиять": [[13,23,30]],
"обрабатываются": [29],
"окнах": [[14,21]],
"tel": [6],
"фоном": [20],
"отличается": [[5,30]],
"некоторых": [29,26,[12,13,15,16,19],[21,23]],
"подстроки": [15],
"частью": [15],
"info.plist": [17],
"anti-alias": [17],
"унаследуют": [29],
"прикрепить": [[9,13]],
"antonio": [7],
"tex": [14],
"множество": [[9,18]],
"статистки": [8],
"fuzzi": [28,30],
"корректность": [15],
"основан": [19],
"языковому": [27],
"отмечаться": [29],
"конфликтовать": [17],
"очевидно": [[19,30]],
"тестовый": [13],
"kua": [6],
"директориях": [17],
"следующая": [[17,22,30]],
"выравнивается": [14],
"пробел": [24,[15,17,26]],
"подлежащего": [12],
"очевидным": [16],
"проверяет": [[20,30]],
"неограниченный": [17],
"область": [30,32,21,31,23,[1,16,20]],
"создатель": [2],
"kur": [6],
"особая": [4],
"dgoogle.api.key": [17],
"унифицировать": [[14,15]],
"резервных": [29],
"увидите": [30],
"ces": [6],
"освоитесь": [21],
"готова": [10],
"пунктов": [30,1],
"заголовок": [12,30],
"tgl": [6],
"tgk": [6],
"нажмите": [30,12,18,17,2,[16,29],[13,15,19,20,26,27]],
"встречаются": [25],
"quiet": [21,17],
"кросс-платформенная": [10],
"пунктом": [[17,23]],
"резервные": [21,[13,17,29]],
"оригинального": [30],
"быстро": [30],
"es_es.d": [27],
"определено": [14],
"каждом": [[14,16,19,21,25,29]],
"tha": [6],
"типизацией": [1],
"сменится": [2],
"the": [[8,28],17,[16,22],30,24],
"удостоверьтесь": [13],
"download.htm": [17],
"каждое": [[8,20]],
"имена": [[12,27],[28,29,30,32]],
"даёт": [30],
"projectimportmenuitem": [8],
"каждой": [[8,26,29]],
"ином": [15],
"заботиться": [21],
"иной": [12],
"imag": [17,13],
"имени": [12,32,[9,16,17,18,22]],
"левому": [14],
"туда": [29],
"определена": [13],
"mihail": [29],
"замедлить": [29],
"последнее": [20,8],
"разном": [13],
"верхнем": [20,[24,30]],
"удалите": [[15,30],[0,3,29]],
"файлами": [22,[10,13,32],[12,14,15,18,21,25,28,30,31]],
"верхней": [26,30],
"сильные": [1],
"последней": [17],
"ttx-файлов": [29],
"вьетнамский": [6],
"вводить": [[2,14,18,28]],
"ретороманский": [6],
"разное": [32,[10,13,20]],
"окончание": [[17,21]],
"currsegment.getsrctext": [1],
"tir": [6],
"cha": [6],
"export": [[14,28]],
"прежнему": [2],
"che": [6],
"умеет": [[15,16,29]],
"клавиш": [8,20,31,5,[10,30,32],14,[2,6,7,9,15,23,28]],
"удалить": [5,15,28,[16,17,20,23,27,29,30,32]],
"check": [23],
"щёлкнув": [17,30,12],
"сворачивает": [30],
"chv": [6],
"chu": [6],
"подробности": [17],
"часы": [[21,29]],
"следующем": [[16,17]],
"xxxx9xxxx9xxxxxxxx9xxx99xxxxx9xx9xxxxxxxxxx": [17],
"системе": [17,[9,10,12,13]],
"базу": [16],
"система": [[30,32],[12,20],[2,10,17,19,29]],
"следующей": [[13,17,29]],
"могут": [29,[17,30],2,14,[10,12,16,23,25],[1,13,15,18,24,26,28]],
"случайно": [15],
"следующее": [[1,2,8,11,19,20,22,27,29,30]],
"fr-fr": [27],
"зелёном": [30],
"соответствующему": [15],
"свободными": [[11,29]],
"защищено": [18],
"немецкого": [29,25],
"базе": [19],
"загружать": [[1,2]],
"madlon-kay": [7],
"одиночный": [15],
"иметь": [2,29,[17,21,23,26,30]],
"новому": [[2,19,29]],
"встретились": [10],
"одиночные": [15,32],
"primari": [17],
"переделать": [30],
"окружает": [15],
"переводчиков": [29,9],
"заголовке": [12],
"различия": [30],
"xmxzzm": [17],
"webster": [11,32,31],
"множества": [29],
"глоссариев": [16,[18,30,32]],
"поддерживается": [[16,18,29]],
"подобная": [[19,24]],
"выход": [[8,20]],
"выравнивать": [21],
"последний": [29],
"каждому": [20],
"инкапсулирует": [29],
"некоторым": [[2,21]],
"лету": [29],
"некоторый": [15],
"некоторые": [[20,29,30],[10,11,12],[0,13,14,15,16,23]],
"последним": [[2,20]],
"переводимого": [[12,29,30]],
"вводите": [[14,28]],
"различными": [1],
"текущего": [30,[28,29],20,23,[1,5,13],[11,14,15,18,19,32]],
"ошибках": [9,32,[4,17,31]],
"оромо": [6],
"syntax": [8],
"сша": [19],
"метод": [17,25],
"будьте": [21],
"английского": [24,[3,17,21]],
"empti": [29,[17,28]],
"посетите": [19],
"псевдо-перевод": [[29,32]],
"логические": [[24,31]],
"n.n_source.zip": [17],
"необходимого": [17],
"написан": [22,[1,10]],
"неоднократное": [14],
"оригинальному": [28],
"lepo": [3],
"spolski": [9],
"сервера": [2],
"начатое": [24],
"локальная": [2],
"подряд": [24],
"переводе": [30,15,[14,18,20,26,28],[3,19]],
"lepa": [3],
"найдёте": [17],
"block": [21],
"экспортировать": [20,[8,10,28]],
"перевода": [30,29,19,[13,20],10,21,12,[14,15,27,32],17,25,23,[18,28,31],[2,16],[3,8,22,24]],
"tmx": [29,32,13,[8,10,17,20,25,30]],
"переводы": [29,[10,28],[12,16,17],2],
"содержится": [13,[2,10,14,25,28]],
"нижней": [[26,28]],
"размеры": [[14,15]],
"серверу": [2],
"тематикой": [29],
"соответствующего": [[12,14,30]],
"секунд": [20],
"предпочтителен": [23],
"переводу": [[12,20]],
"integ": [12],
"выданным": [19],
"intel": [17,[31,32]],
"нижнем": [[24,30]],
"fr-ca": [26],
"совпадёт": [29],
"mainmenushortcuts.properti": [8],
"зрения": [[14,30]],
"сочетаниях": [20],
"сервере": [2,[13,17]],
"параллельно": [17],
"идентификатор": [17],
"cmd": [[5,20],14],
"хорошее": [9],
"coach": [24],
"фильтр": [12],
"xml-синтаксис": [1],
"пакетов": [13],
"систему": [20,[2,9,16,19,30]],
"японским": [17],
"перейти": [5,[9,15,20,25,30]],
"иконке": [2],
"выравнивает": [17],
"японский": [[6,21]],
"предыдущая": [21],
"фильтрам": [23],
"процента": [30],
"gotohistorybackmenuitem": [8],
"счёт": [[3,15]],
"системы": [17,2,[19,32],[12,31],[1,10,13,20,29]],
"слове": [25],
"слова": [[24,25,30],[5,18,19],[3,14,16,20]],
"собственное": [30],
"виртуальной": [1],
"project-save.tmx": [29],
"ton": [6],
"фильтрах": [[14,29]],
"ассоциированы": [17],
"умели": [29],
"языкового": [26],
"powerpc": [17],
"японских": [22],
"появлялось": [14],
"слову": [[20,25,27,30]],
"перемещается": [5],
"слово": [25,[5,16,20,27],[8,10,17,26]],
"avail": [8],
"окончанию": [[18,29]],
"разница": [30],
"синим": [30,[0,15,25]],
"эсперанто": [6],
"атрибутов": [12],
"настроить": [[12,20],[2,3,5,8,15,21,23,26,28,30]],
"имеет": [[2,17],[3,8,14,15,20,21,22,27]],
"найден": [[12,16]],
"буквенный": [[17,24]],
"удобства": [20],
"аналогичной": [11],
"только": [29,17,25,23,[12,20],30,[13,24],[2,15],[16,19,27,28],[10,14,22,26,32]],
"предусмотрен": [[17,21]],
"баг-треккер": [4],
"order2": [29],
"order1": [29],
"средний": [3],
"окончания": [[3,29]],
"отображение": [[14,20,30]],
"некоторыми": [[22,30]],
"minor": [30],
"правилах": [10],
"cos": [6],
"cor": [6],
"каждого": [30,[15,18,29]],
"неприятная": [22],
"воспроизведены": [15],
"правилам": [14,[0,23,26,27]],
"повторяющегося": [30],
"версиях": [4],
"мира": [22],
"подсчёт": [30],
"текущую": [[17,20,23,30]],
"чаще": [[1,14]],
"веб-страницы": [1],
"подготавливать": [2],
"обратитесь": [[23,30],[7,14],[25,26]],
"версиям": [17,2],
"lao": [6],
"собираетесь": [[13,18,30]],
"включена": [[12,17],[20,30]],
"хороший": [3],
"lat": [6],
"lav": [6],
"импортировать": [[8,20],[2,29,30]],
"добавить": [2,[13,20],17,[8,12,16],[1,10,14,15,18,26,27,30]],
"относительно": [17,[13,30]],
"примеры": [32,24,31,[12,28]],
"затрагивать": [28],
"японская": [26],
"совпадающих": [30],
"области": [30,32,16,29,20,[12,14,18,19,31],[0,5,11,15,23,28]],
"примеру": [11,[14,17]],
"translat": [19,32,17,[10,12,28],[1,27,29]],
"навсегда": [22],
"сокращения": [26],
"включительно": [24],
"предыдущих": [10,[4,29,30]],
"включены": [[13,20,22,25,29]],
"добавите": [29],
"примере": [[15,30],[2,16,29],[1,17,25]],
"предыдущий": [20,[8,23,29]],
"отображения": [14,30,[8,22]],
"кодированный": [14],
"типом": [14],
"знакомых": [10],
"примера": [22,[3,12,21,25,30]],
"платформо-независимый": [13],
"резервную": [29,21],
"требуют": [30],
"снабжено": [10],
"предыдущее": [[8,20,30]],
"типов": [13],
"прописная": [24],
"появляться": [[19,20,30]],
"respons": [19],
"tsn": [6],
"interesar": [19],
"придётся": [26,12,[2,16,29,30]],
"tso": [6],
"scripting": [31],
"html-файл": [[12,13]],
"амхарский": [6],
"cre": [6],
"предыдущей": [17,[21,24,29]],
"chmod": [13],
"так": [30,17,[16,21,23],[2,15,29],25,[10,18,20,26],[5,9,11,12,13,14,22,27]],
"разрешены": [2],
"там": [13,[11,17,21,23]],
"иногда": [29,15,12,[1,2,26,27]],
"gnome": [17],
"загруженный_файл.tar.gz": [17],
"нового": [[26,32],18,12,[29,31],[10,17,24,28]],
"возникнуть": [[18,22]],
"перевести": [10,[9,13,14,21,29]],
"выполняется": [[10,25]],
"малагасийский": [6],
"имён": [12,28],
"скорректированный": [[19,30]],
"бразильским": [17],
"бразильский": [27],
"ttx": [[29,32]],
"примете": [17],
"перезагрузили": [16],
"appdata": [13],
"добавляются": [17],
"популярные": [2],
"csv": [[14,16]],
"n.n_linux.tar.bz2": [17],
"нагружает": [30],
"лишние": [24],
"автоматическими": [20],
"tuk": [6],
"экспортировали": [16],
"tur": [6],
"утверждён": [16],
"tuv": [29],
"этой": [13,[7,17,20],[1,9,14,15,16,22]],
"этом": [17,13,[2,23,29],[10,20,30],[5,12,15,16,21,22,26,31]],
"lep": [3],
"секундах": [20],
"lepš": [3],
"тви": [6],
"этот": [17,13,29,21,[2,10,12,20,22,28],[1,3,14,23,24,31]],
"press": [8],
"снятие": [23],
"ddhttp.proxyhost": [17],
"ожидалось": [20],
"перевели": [[18,21,27,29]],
"берётся": [30],
"dmicrosoft.api.client_secret": [17],
"java-файлы": [13],
"отметить": [4,30],
"полем": [[27,30]],
"полей": [17],
"действующих": [23],
"чернового": [4],
"прочитать": [12],
"значком": [[13,20]],
"настраивать": [[2,20]],
"полученные": [[14,28]],
"filenameon": [30],
"немецкий": [6],
"ctrl": [20,8,30,5,[18,32],[14,15],29,[13,16,19,25,28],[1,11,23]],
"mykhalchuk": [7],
"элемент": [16],
"twi": [6],
"document": [12,[13,14,15,17,21,29]],
"netrexx": [1],
"нужная": [30],
"нахождения": [3],
"важно": [[10,15,17,21,29]],
"отсортировано": [29],
"полное": [[12,30]],
"имеют": [[1,13,18,25,26,27,29]],
"выполняются": [17],
"проходит": [14],
"пожалуйста": [4],
"resourc": [17,14],
"briac": [7],
"тех": [[10,25]],
"веб-сайте": [19],
"нажмёте": [25],
"веб-сайта": [2],
"словом": [16],
"team": [17],
"xx_yy": [[12,29]],
"реализациями": [17],
"неизменными": [[10,12,14,28]],
"docx": [14,12],
"находящийся": [17],
"тег": [15,12],
"txt": [22,[14,16],12],
"нахождении": [21],
"прописными": [25],
"тем": [14,[12,13,15,17,21,26,29]],
"популярный": [1],
"прописной": [[8,20,26]],
"обеспечением": [7],
"definit": [8],
"регистре": [20],
"без": [30,[1,4,12,17,29],[13,14,16,26,28,32]],
"подвигать": [26],
"lib": [13],
"умолчанию": [8,12,20,30,[13,29],[2,17,22],[14,32],[25,28],[21,23,24,26,31]],
"регистру": [24],
"применено": [15],
"обработан": [17],
"lin": [6],
"lim": [6],
"тематикам": [2],
"считывание": [16],
"маршалльский": [6],
"цену": [30],
"вошедшие": [21,[6,10,27,31,32]],
"lit": [6],
"viewdisplaymodificationinfoselectedradiobuttonmenuitem": [8],
"omegat.tmx": [[13,29]],
"index.html": [[17,30]],
"регистра": [[24,32]],
"оставаться": [[14,28]],
"гуджарати": [6],
"вовремя": [14],
"бег": [30],
"направление": [14],
"чеченский": [6],
"расстановкой": [18],
"иначе": [[26,29]],
"определять": [[15,29,30]],
"зулу": [6],
"лишней": [29],
"самого": [30],
"некорректного": [15],
"требует": [27],
"неразрывные": [20,8],
"выделением": [16],
"cym": [6],
"миллионов": [17],
"возврат": [32],
"кроме": [24,[14,21,30],[12,13,17,20,25,27,29]],
"конкретное": [29],
"попробуйте": [[2,20]],
"альтернативными": [32],
"конкретном": [29],
"конкретной": [29],
"основаны": [19],
"всегда": [15,29,[12,20],[8,9,16,18,23,30]],
"логотипы": [13],
"логическое": [25],
"нажимайте": [16],
"грузинский": [6],
"луба-катанга": [6],
"колонке": [30],
"описанные": [15],
"project.gettranslationinfo": [1],
"описанный": [[16,25]],
"неправильные": [20],
"статье": [[9,16]],
"тип": [32,12,[14,26,30]],
"статьи": [30],
"пустыми": [[17,29]],
"локаль": [12],
"переключаться": [14],
"вернётся": [13],
"описанных": [[13,29]],
"происходят": [30],
"щелкните": [15],
"скопировано": [15],
"start": [17,32,31],
"группировать": [15],
"smolej": [[7,31]],
"резервной": [29],
"equal": [29,[17,28]],
"резервное": [29,32],
"соответственно": [[3,14,16,17,22,26,29]],
"экземпляров": [23],
"захотеть": [[28,29]],
"optionsalwaysconfirmquitcheckboxmenuitem": [8],
"определяет": [26,[10,15,17,27,30]],
"помечаются": [14],
"затрагивает": [15],
"несуществующей": [23],
"движется": [26],
"неприятно": [13],
"язык": [17,1,[29,32],[14,19],[10,18,21],[15,22,23,26,27]],
"копировать": [20,[5,29,30,32]],
"редактирование": [32,20,12,[4,30,31]],
"пустая": [26],
"особенностями": [30],
"applic": [17,13],
"зелёным": [[20,30]],
"локали": [12],
"повреждён": [15],
"projectteamnewmenuitem": [8],
"разных": [29,2],
"являют": [30],
"различные": [30,10,[12,20],[1,2,29,31]],
"настраивается": [16],
"зелёный": [2],
"расположенного": [15],
"право": [[7,13]],
"копирует": [20,29],
"разным": [32,14,2],
"памятью": [[18,29]],
"memori": [17],
"стандартными": [17],
"тестирования": [24],
"разные": [[2,15,28,29,30]],
"сардинский": [6],
"скопировать": [27,18,[13,14,29,30]],
"различных": [10,[1,23,29]],
"права": [7,2,32,[4,8,10,17,31]],
"пакет": [[13,17]],
"хранящейся": [29],
"разрывы": [[14,26]],
"godfrey": [7],
"буквенного": [24],
"международный": [16],
"слоты": [1],
"log": [13],
"учитываться": [25],
"международные": [29],
"диалоговое": [32,12,23,[20,21,31],[2,18],[1,13,16]],
"tmx-файлах": [29],
"венда": [6],
"форматов": [14,12,[10,18,29,30]],
"диалоговом": [[16,29],[12,13,27,28],[2,3,15,20,30]],
"pane": [16],
"n.n_windows_without_jre.ex": [17],
"внедряются": [15],
"отображаются": [16,28],
"текущий": [20,28,[21,29,30]],
"остались": [10],
"добавлено": [16],
"вместо": [20,22,[1,8,17,18,29]],
"редактировании": [10],
"страна": [[17,29,32]],
"поддерживаются": [[12,16]],
"html-файлы": [17,[12,26]],
"столбец": [[16,30]],
"той": [29,[12,13,21]],
"буфер": [20],
"prof": [26],
"camproj": [14],
"руководитель": [2],
"html-файле": [12],
"добавлены": [18],
"редактированию": [20],
"вместе": [23,12,[0,3,27,29,30]],
"редактирования": [[30,32],28,20,[12,31],5,[10,14,29],18,[0,2,6,8,15,16,19,21,22,23]],
"страны": [12,[17,29]],
"слабой": [1],
"руководителя": [2],
"немногих": [12],
"важен": [13],
"dmicrosoft.api.client_id": [17],
"текущим": [20,[2,29]],
"разрыва": [26,[5,32]],
"страну": [17],
"слабом": [21],
"сеанса": [13],
"соответствующую": [[12,22]],
"перекрывание": [15],
"привязку": [14],
"запрос": [25],
"останутся": [[12,13]],
"текущему": [30,29],
"создателях": [20],
"надёжных": [29],
"наилучшее": [30],
"dan": [6],
"том": [19,[13,17,30],[7,11,15,21,22,28]],
"обсуждений": [13],
"разделения": [30],
"обсуждении": [13],
"тот": [[2,12,20,27,30]],
"надёжным": [15],
"обратите": [17,[15,18],[12,19,26,27,30]],
"корне": [17],
"надёжный": [29],
"гарантированно": [15],
"делает": [5,13],
"последнюю": [29,[2,9,21]],
"локализована": [17],
"system-user-nam": [12],
"едины": [23],
"format": [[12,14,15]],
"три": [[2,29],[9,11,13,15,22,25,30]],
"импортирует": [20],
"битной": [22],
"console.println": [1],
"плавающей": [28],
"довольно": [21,[10,16,30]],
"элементов": [[8,12,14]],
"попадает": [15],
"разархивируйте": [1],
"показывается": [30,20,[10,19,23]],
"неизменяемый": [28],
"полученный": [17,[2,21,29]],
"оставался": [30],
"текущее": [13],
"делайте": [21],
"leender": [7],
"как": [29,30,[15,17],20,[2,10,14,16],32,21,[12,19,25],[13,18,23,24,26,28],[11,22,31],[0,1,5,8,9]],
"объявление": [12],
"текущей": [17,[20,25,26]],
"извлечение": [2],
"индикатор": [30],
"текущем": [30,[10,12,17,20,21]],
"отсутствовать": [16],
"подчёркивания": [24],
"следует": [2,[17,29],[12,15,16,23,24,26,30]],
"втором": [[10,15,16,30]],
"изменяться": [16],
"выводит": [1],
"методов": [25],
"термины": [16,30],
"подобными": [2],
"компьютера": [17,[21,22]],
"optionsexttmxmenuitem": [8],
"видеть": [[15,29]],
"англоязычную": [30],
"компьютере": [[2,17],21,12],
"ltz": [6],
"идёт": [[13,24,29]],
"учётом": [30],
"lub": [6],
"второе": [8],
"продукт": [21],
"исходный-текст": [14],
"активно": [3],
"компьютеру": [[17,22]],
"второй": [[2,29]],
"заранее": [[12,29]],
"marketplac": [17],
"многих": [[4,14,19,22,26]],
"lug": [6],
"термина": [[2,16]],
"правами": [2],
"правила-исключения": [26],
"многоязычными": [32],
"entries.s": [1],
"найдёт": [[16,25]],
"del": [[28,30]],
"словах": [3],
"gotonextuntranslatedmenuitem": [8],
"ожидает": [17],
"targetlocal": [12],
"наибольшим": [30],
"path": [17],
"полистать": [30],
"аспект": [12],
"deu": [6],
"слайдов": [12],
"сомнения": [13],
"получили": [10],
"прописных": [24],
"специфику": [14],
"наибольший": [30],
"возможностями": [[1,10]],
"разработанные": [30],
"помощью": [[17,30],20,[11,12],[15,23]],
"allsegments.tmx": [17],
"префиксом": [29],
"хинди": [6],
"помощь": [18],
"обнаруживать": [0],
"копий": [[2,17,29]],
"тут": [28],
"словам": [25],
"расширены": [19],
"helpcontentsmenuitem": [8],
"копии": [2,[21,29],[9,13,17,27]],
"параметры": [32,[20,30],[28,31],[8,12,29],[17,27],[14,15,19,22],[10,25],[0,13,21,23,24,26]],
"обычной": [[0,30]],
"содержатся": [[13,25],[10,11,15,17,31]],
"обычном": [13],
"учётные": [2],
"силу": [[8,12,26]],
"структуру": [13],
"автора": [[25,30]],
"имя_проекта-omegat.tmx": [29],
"sentenc": [26],
"показа": [30],
"возможностей": [[10,25]],
"uig": [6],
"сообщаете": [10],
"параметра": [[12,21,25]],
"структуре": [26],
"конкретный": [17],
"искать": [25,24,[9,32]],
"сноски": [12],
"структура": [13],
"метасимволы": [24],
"применяется": [[1,14,24]],
"чересчур": [30],
"term": [16,[19,30]],
"копию": [[2,29],21],
"поместить": [29],
"копия": [2],
"dotx": [14],
"конкретных": [30],
"поместите": [29,[16,18,27]],
"классический": [1],
"делённое": [30],
"кнопка": [23,27],
"соответствующих": [[0,8,10,15,27]],
"кнопке": [[1,23,30]],
"мощные": [[10,24]],
"идентичные": [[17,25,28]],
"бесполезной": [23],
"программирования": [1],
"тремя": [14],
"мощный": [25],
"идентичный": [28,[30,32]],
"киргизский": [6],
"румынский": [6],
"соответствующий": [12,17,26,[1,21,24,29]],
"номером": [20,[1,8]],
"голландский": [6],
"перевод": [30,19,[20,29],28,14,[16,32],10,[8,23,31],[1,15,17,18,27],[12,13,21,26]],
"соответствующим": [[14,20]],
"соответствующие": [2,[12,13,15,19,21,25,26,29]],
"структуры": [32,[13,26]],
"spotlight": [17],
"уменьшает": [[14,15],30],
"идентичных": [30,28],
"системной": [16],
"аргумент": [17,29],
"прежде": [[17,19,21]],
"набора": [[19,26]],
"catlik": [3],
"murray": [[4,7]],
"восточной": [22],
"выполняет": [17],
"непальский": [6],
"удобно": [14],
"кросс-платформенным": [17],
"dir": [17],
"попадают": [30],
"кросс-платформенный": [1],
"latex": [14],
"снятым": [26],
"div": [[6,12]],
"преобразовываются": [19],
"кнопки": [30,[17,25,31,32]],
"подписи": [20],
"закрытии": [29],
"viewfilelistmenuitem": [8],
"ukr": [6],
"кнопку": [12,17,[25,26,27],[9,18,23,30]],
"автоматическое": [32,21,[23,31]],
"test": [17,21],
"пароль": [2,20],
"уменьшить": [15],
"файлом": [17],
"файлов": [32,12,29,14,30,18,[16,31],[10,13,17,22],2,[20,21,23],[9,26,28],[1,8,19,25,27]],
"omegat": [17,18,13,21,29,2,[30,32],[9,20,23],[8,10,31]],
"фулах": [6],
"автоматической": [17],
"румынском": [0],
"форматированием": [[14,32],[15,20,26]],
"вставляется": [20],
"равно": [29,17],
"рассматривать": [[0,15,29]],
"цифровой": [24],
"подсказки": [20,8,30,[14,19,29]],
"переходит": [26],
"цвета": [[14,15]],
"console-align": [17,21],
"назначены": [1],
"ms-dos": [17],
"цвете": [14],
"показываются": [25,[16,20,24,29]],
"простых": [14,26,[10,15,16,31,32]],
"михаилу": [29],
"состоящий": [31,[16,30,32]],
"сильно": [15,30],
"jean-christoph": [[4,7]],
"помощи": [30,32,[4,14,20],29,25],
"копиями": [[29,30]],
"пользоваться": [13],
"простым": [10],
"болгарский": [6],
"простые": [32,14,15,[16,19,22,28]],
"состоящие": [26],
"переименуйте": [29,21,27],
"henri": [7],
"продублировали": [15],
"возникать": [[15,20,23]],
"inset": [16],
"финансовая": [32],
"custom": [9],
"нужном": [17],
"единицами": [[10,26]],
"нужной": [[10,17,21,29]],
"und": [27],
"прописные": [[8,20]],
"долларов": [19],
"project_save.tmx.temporari": [[21,29]],
"une": [16],
"помочь": [32,9,[13,31]],
"извлечь": [26],
"алгоритмом": [3],
"графики": [12],
"обновлять": [[16,29]],
"высококачественные": [29],
"середине": [23],
"установленной": [17],
"editoverwritemachinetranslationmenuitem": [8],
"комбинация": [[17,20]],
"путаницы": [29],
"экспорта": [28],
"установленном": [12],
"ingreek": [24],
"переводимом": [[18,29,30]],
"немецком": [0],
"технологию": [10],
"вторая": [[15,17,30]],
"делать": [[13,14,15,26]],
"технология": [10],
"проходя": [26],
"таблицах": [6],
"html-редакторах": [14],
"предустановленные": [[24,31]],
"es_es.aff": [27],
"внешними": [30],
"convert": [28],
"предпочтительной": [26],
"attempt": [28],
"санго": [6],
"pojavnem": [16],
"становится": [[2,10,29]],
"projectexitmenuitem": [8],
"кнопок": [1],
"преимущество": [29],
"открывающееся": [15],
"специфическим": [14],
"столбца": [30],
"воспользоваться": [[2,19],[17,27]],
"вырезать": [20,[5,30]],
"наработки": [[10,21]],
"text": [[22,28]],
"специфические": [29,14],
"потребовалось": [29],
"стилевую": [14],
"навахо": [6],
"табуляцией": [16],
"добавлять": [12,30,2,[15,17,18,20]],
"рабочем": [17,21],
"рассматривает": [29],
"опыт": [15],
"веб-сайт": [9],
"шрифте": [14],
"текстом": [[15,29],[25,28,30,32],[10,13,14,16,20,22,23,26,31]],
"шрифта": [21,[14,20,30]],
"длиной": [19],
"рекомендациями": [23],
"maco": [17],
"передвинуть": [26],
"контекст": [30],
"конечно": [29,[19,23],[16,17,18,22,26]],
"проводится": [[2,15,17,21,30]],
"клавиатурах": [20],
"алфавитном": [29],
"doc": [30,13],
"исключить": [29],
"рабочей": [2],
"чешском": [22],
"личному": [30],
"выводимых": [12],
"ключ": [19,[17,30],14],
"разделе": [10,17,[13,30],[18,19],[5,14,20,29]],
"неправильное": [16],
"создайте": [[2,29],[1,14,27]],
"стать": [15],
"paramet": [17],
"mac": [17,5,8,[13,20],[2,10,14,18,31,32]],
"создаётся": [[2,29],[1,14,26]],
"был": [20,[14,16,25,29]],
"установленным": [[17,23]],
"шрифты": [[14,15,21]],
"разделу": [[23,30],[2,25,26]],
"mah": [6],
"lepša": [3],
"областями": [30],
"mal": [6],
"man": [17],
"разделы": [21,[6,10,14,17,27,30,31,32]],
"соответствующая": [[0,12]],
"lepši": [3],
"mar": [6],
"код": [12,[27,29],1,17],
"преимущества": [2],
"случится": [13],
"urd": [6],
"переведённом": [15,14],
"режимами": [14],
"рядом": [[10,20,27,29,30]],
"столбце": [16],
"url": [[2,12,20]],
"пропущен": [12,24],
"западноевропейская": [32],
"uppercasemenuitem": [8],
"viewmarkuntranslatedsegmentscheckboxmenuitem": [8],
"набору": [[10,30]],
"раздела": [[7,16]],
"уделяйте": [15],
"пунктами": [30],
"www.omegat.org": [9],
"наборы": [[24,31],26],
"use": [17,8],
"букву": [20],
"main": [29],
"каннада": [6],
"действия": [[14,17]],
"вспомогательный": [29],
"omegat.jar": [13,[1,21,29]],
"компьютерах": [18],
"переименовывать": [12],
"открытого": [5],
"джоэла": [9],
"usr": [17],
"буква": [24,14],
"обычных": [30],
"расположенный": [[17,20,30]],
"особый": [12],
"периодически": [13],
"глоссариях": [20],
"модулей": [[1,10]],
"кри": [6],
"скриптовые": [1],
"просматривает": [26],
"doc-файлов": [14],
"обучения": [19],
"подключаются": [2],
"основанные": [19],
"utf": [[16,22],12],
"скриптовый": [1],
"инструменты": [32,[20,30,31],8,[1,13,24],19],
"обычные": [29],
"верхнюю": [30],
"сочетаниями": [8],
"обычный": [[13,14]],
"вам": [29,17,12,[9,13],[21,30],[4,10,18,19,22,28],[15,16,26,27,31]],
"понадобится": [17,18],
"обычным": [[2,20]],
"проверяйте": [[14,21]],
"буквы": [20,8,[15,26]],
"фрагментов": [15],
"servic": [17,[2,19]],
"какую-то": [15],
"действие": [20,8,5],
"xhtml-файлы": [12],
"колонтитулы": [12],
"основанный": [[1,16]],
"действий": [[9,15,17]],
"интерлингве": [6],
"рабочая": [[2,13]],
"интерлингва": [6],
"dsl": [11],
"подключены": [19],
"модулем": [20],
"метода": [[17,22]],
"императивный": [1],
"форматирования": [15,32,14,29,30,31],
"методы": [25],
"достичь": [[17,21,28]],
"соответствующем": [[14,29],10],
"нужного": [17,19],
"продолжит": [21],
"верхняя": [30],
"записываются": [13],
"значение": [25,[8,14,30]],
"методу": [17],
"вашему": [7,[2,9,29,30]],
"обрабатывает": [[23,30]],
"полученном": [12],
"нигде": [17],
"форматированию": [18],
"значений": [24],
"вас": [17,[13,27],29,[2,9,10,14,15,20,21,22,26,28,30]],
"установка": [17,[31,32],[0,1,3,19,27],[10,18,23,25,30]],
"происходит": [20,16,[19,21,28,29]],
"значения": [[17,21],29],
"dtd": [14],
"размер": [[21,30]],
"текстов": [19,10,[14,15,29]],
"ваш": [[2,30],[13,14,17,25]],
"соответствующей": [20],
"ответ": [19],
"соответствующее": [[13,14,15,20]],
"переместить": [5],
"установку": [17],
"форматирование": [15,[19,20,23],[18,29]],
"сделанных": [15],
"нижняя": [30],
"кто": [[4,10]],
"projectcompilemenuitem": [8],
"отображается": [18],
"console-transl": [[17,21]],
"запутать": [29],
"находятся": [[13,17],[15,21],[1,16,20]],
"кончено": [27],
"установки": [17,27,13,[1,23]],
"установке": [[10,17,31]],
"технологии": [[17,19]],
"производят": [29],
"самый": [[13,17,21]],
"пушту": [6],
"переустановите": [13],
"сделанные": [17],
"терминологией": [10,16],
"самым": [[13,15,17,29]],
"чешский": [6],
"хорватский": [6],
"форматировании": [15,29,14],
"переместите": [29],
"wordart": [12],
"самые": [13],
"properties": [31],
"optionsviewoptionsmenuitem": [8],
"отсюда": [9],
"добавил": [30],
"commit": [2],
"разделено": [26],
"расположение": [32,29,[13,17],16,[8,18,21,23]],
"targetlocalelcid": [12],
"возникает": [19],
"вычитания": [30],
"project_stats_match.txt": [[2,13,30]],
"хранит": [10,17],
"экземпляра": [23],
"роль": [10],
"успешное": [13],
"перезагрузке": [[16,21,29]],
"dvd": [21],
"quarkxpress": [14],
"месяц": [[17,21,29]],
"разделены": [16],
"meniju": [16],
"проверяться": [20],
"бамбара": [6],
"навигации": [17],
"нечёткое": [29,[20,30],28],
"правила": [26,32,23,31,[0,13,14,15,24,29,30]],
"корнский": [6],
"устанавливаемой": [17],
"роли": [[20,23]],
"проверять": [15,27,20],
"само": [[20,30]],
"всплывающее": [30],
"правило": [26,[0,10,15,17,21,23,24,30,32]],
"экземпляры": [[20,30]],
"можете": [30,17,12,[20,29],32,[7,9,13,25,27],28,[2,15,21],[0,4,5,8,10,18,22,23,31]],
"сами": [12],
"борьбы": [22],
"сохранёнными": [22],
"бы": [4,[19,20]],
"щёлкнуть": [[17,30],[1,9,13,14,20,25,27]],
"krunner": [17],
"сама": [[17,27]],
"libreoffic": [27,18],
"некоторое": [[27,29,30]],
"диаграммы": [12],
"какие-то": [17],
"английский": [[6,17,19,29]],
"минимальный": [20],
"документами": [[12,20,23]],
"запятыми": [12],
"браузере": [30],
"стандарт": [16],
"авторское": [7],
"во": [30,[16,29],[10,14,17],[1,3,15,18,20,21,26,28]],
"японского": [[26,29]],
"показ": [25,31],
"уже": [17,[29,30],16,[10,13,14,18,20,23,27],[1,2,21,25,26,28,31,32]],
"процентом": [30],
"традиционным": [17],
"обнаруживает": [12],
"юникод": [[16,32]],
"вы": [30,17,29,13,12,20,27,[18,21,25,28],[2,9,15,23],[10,19,32],7,[14,16],[8,22],[0,4,5,11,24,26,31]],
"восстановить": [30,[8,20,21]],
"представления": [[12,15,28]],
"uzb": [6],
"перезагрузит": [30],
"гб": [17],
"английские": [29],
"прокрутки": [26],
"речь": [13],
"просто": [[15,17,30],[13,16],[2,9,10,11,12,14,18,22,26,27,28]],
"простом": [[14,17]],
"стесняйтесь": [13],
"файлам-конфигурации": [[17,21]],
"простой": [24,[1,16,20,28,29]],
"viewdisplaysegmentsourcecheckboxmenuitem": [8],
"представление": [30,15],
"повлияет": [23],
"чисел": [30,28,32],
"годности": [7],
"речи": [19],
"чтобы": [30,17,29,14,12,[15,26],[20,21],2,[9,13,19,28],[10,16,18,23,25],27,[8,11,22]],
"да": [17],
"переводчица": [29],
"open": [12,[14,15],[8,17,29]],
"дд": [[21,29]],
"авторские": [7,32,[4,8,10,31]],
"рабочих": [2],
"указатель": [32,[4,10]],
"www.oracle.com": [17],
"объём": [[17,27]],
"svn-сервер": [2],
"нужных": [[17,29]],
"перед": [[5,15,16,17,24],[0,3,13,14,18,21,27,29,30]],
"mkd": [6],
"правильно": [[13,14]],
"project": [2,[17,23],[8,13,29]],
"обновлены": [12],
"до": [26,[5,20],24,[1,17,29,30],[4,10,13,15,19,21,25]],
"xmx1024m": [17],
"сделайте": [29,13],
"парных": [15],
"переместили": [20],
"файл": [17,29,13,25,16,[20,22],[2,8,14,15,18,30],[11,21,32],12,[7,10]],
"торговых": [28],
"делится": [[10,30]],
"стандартной": [12],
"потом": [24],
"стандартное": [[12,17]],
"dzo": [6],
"двух": [29,2,[15,16,17,28,30]],
"влияют": [23],
"рабочим": [13],
"французском": [0],
"установленная": [12,17],
"рабочий": [[17,25]],
"торговые": [[28,30]],
"черта": [24],
"penalty-xxx": [29,32],
"администратора": [2],
"скорее": [[2,10,17,21,22,23,26,29]],
"собственные": [[24,28,29,30]],
"gotonextsegmentmenuitem": [8],
"загружает": [30],
"ей": [[13,17,21]],
"числа": [[28,30],14],
"обновлена": [23],
"собственный": [2],
"mlg": [6],
"поместив": [8],
"необходимости": [29,[15,17,25,27,28,30]],
"числе": [[3,7,11,16,19]],
"проведения": [17],
"nnn.nnn.nnn.nnn": [17],
"двум": [10],
"выделенного": [20],
"встречается": [10],
"авторских": [20],
"собственных": [28],
"число": [30,[3,20,29],[15,21,25]],
"датой": [25],
"mlt": [6],
"abort": [[17,21]],
"открывается": [30],
"отредактируйте": [[12,17]],
"обновлено": [16],
"удостовериться": [17],
"парный": [15],
"парным": [15],
"букмол": [6],
"черты": [17],
"её": [30,17,[2,13,21,23,26],[7,10,12,15,19,20,29]],
"парные": [15,32],
"вид": [20,[8,32],31,17],
"исследовательских": [19],
"же": [17,29,[12,13,28],[2,14,21,23,30],[9,16,18,20,22,24,26,27]],
"особую": [4],
"введены": [25],
"allow": [28],
"операционных": [20,2],
"фала": [32],
"идущих": [10],
"данном": [10,[2,4,15,29,30]],
"сравнить": [[15,30]],
"мэнский": [6],
"письмом": [32,14,31],
"документа": [5,[14,15,30],[4,10,16]],
"данное": [[10,30]],
"printf": [15,20],
"путь": [17,21,30,14],
"обновить": [2,17,[10,21]],
"упрощает": [[14,15]],
"interest": [19],
"править": [19],
"прогресс": [[2,30]],
"соседних": [15],
"за": [[4,24,29],[10,30],[7,18,23,26],[2,5,14,15],[3,9,12,17,19,25,31]],
"размера": [[20,21]],
"размере": [14],
"следы": [15],
"совсем": [29],
"расположению": [30,[13,32]],
"позиции": [26,25],
"расположения": [30],
"схожести": [[15,28,30]],
"было": [15,[4,14,20,29],[9,17,21,22,30]],
"документы": [[20,29],18,[1,2,8,9,13,14,15,17,26,28,31,32]],
"приведённом": [[19,30]],
"предпочитаемому": [20],
"следующую": [[8,10,17]],
"es-mx": [27],
"были": [[2,29],[13,17,19],[4,15,27,28,30]],
"приведённой": [30],
"считаются": [22,[15,30]],
"marc": [4],
"документе": [14,[12,15,30,31]],
"напоминает": [16],
"была": [17,[20,21,29]],
"позицию": [20,30],
"bash": [13],
"моделей": [19],
"пуст": [13,12,[16,28,29]],
"тсвана": [6],
"из": [30,29,17,13,15,2,20,12,[16,31,32],[1,25,28],[14,27],[23,24,26],[0,3,8,18,19,21]],
"stem": [3],
"base": [16],
"переводчика": [[12,29,30]],
"пуск": [17],
"им": [[2,10,13,16,29]],
"диска": [27],
"рода": [29],
"понимаются": [15],
"скрытый": [12],
"скрытым": [13],
"ит": [16],
"их": [29,14,[10,13,15],[12,17,30],[18,25],[1,2,20,21,26],[16,19,23,24,27,28]],
"mon": [6],
"диске": [[27,29]],
"дивехи": [6],
"план": [20],
"английской": [4],
"сервис": [19,17],
"терминами": [16],
"английском": [[0,2,19]],
"большого": [4],
"следуйте": [17,14],
"идентичны": [17],
"gedit": [16],
"посчитаете": [[13,17]],
"терминала": [17],
"слева": [14,[1,5,26]],
"скриптовом": [[17,21]],
"вышеприведённом": [[1,16]],
"word": [[12,14,18,25]],
"распознавания": [26],
"zn-cn.tmx": [29],
"влево": [5],
"старославянский": [6],
"является": [30,[7,20,26],[1,15,16,17]],
"ко": [30,[13,15]],
"администратор": [2],
"точному": [25],
"классов": [1],
"решить": [29,[15,28]],
"следующих": [[21,24,28,30]],
"убрать": [[14,15]],
"фалов": [29],
"закрывающие": [15],
"закрывающий": [15],
"следующим": [[17,26],[13,18,21,28,30]],
"следующий": [20,8,[24,28,29,30]],
"закрывающим": [15],
"вне": [[5,20,29],[13,28]],
"следующие": [12,[2,14,30],[1,13,17,20,22,25,28]],
"выбирает": [20,[3,27]],
"ли": [17,[19,20,26],[11,12,13,15,27]],
"размечая": [14],
"рабочую": [2],
"переводимых": [[10,19,30]],
"mri": [6],
"вот": [17,[0,10,12,26,30]],
"vcs": [2],
"lingvo": [11],
"расположенном": [20],
"переведённого": [12,32,[15,30],14,21],
"переводимым": [29],
"типам": [14],
"mrs": [26],
"диску": [17],
"расположенное": [17],
"вниз": [5],
"системные": [5],
"переводимые": [[2,19,26]],
"утруждая": [16],
"поэкспериментировать": [29],
"нужные": [[2,17,21,29],[25,27]],
"строчные": [[8,20]],
"нормальной": [13],
"мб": [17],
"tortoisegit": [2],
"нормальном": [[17,21]],
"показанное": [20],
"текстах": [[0,19]],
"sourceforge": [31],
"нужный": [27,14],
"msa": [6],
"иврит": [6],
"возможностям": [[13,30]],
"переведенному": [18],
"нужным": [[13,17,23]],
"решите": [[19,23]],
"мм": [[21,29]],
"место": [2,[15,17]],
"удобен": [17],
"n.n_sourc": [17],
"месту": [15],
"мы": [[9,14]],
"сбросить": [12],
"переключились": [20],
"pt_pt.aff": [27],
"утилитой": [29],
"на": [17,30,2,20,29,[9,19],[1,22],[13,21],5,[8,12,26,27],10,[14,16],[15,18,23],32,[0,25],[11,28,31],[4,7,24]],
"какой-то": [13],
"нечётких": [32,29,30,20,[14,15,28]],
"не": [17,20,30,[16,21,29],23,12,15,[19,24,26],14,5,[2,25],[13,27],[8,28],[7,18],[0,1,4],[3,6,9,10,22,31,32]],
"иерархией": [13],
"ip-адрес": [17,32],
"html": [17,12,14,[1,15,18,21,26,29]],
"каждый": [14,[2,13,16,23,29]],
"нужную": [[27,30]],
"ни": [17,24,29],
"онлайн": [[19,27]],
"ven": [6],
"опыта": [23],
"проблем": [[19,22,32],[2,16,20,23,29,31]],
"нн": [[21,29]],
"но": [29,[5,15,30],25,[2,7,17,18,20,21,23,24,27,28],[1,10,11,13,16]],
"разделённых": [12,16],
"сервер": [2],
"писать": [9],
"раздел": [[10,29],[13,14,20],[4,8,15,21,24]],
"ну": [4],
"ория": [6],
"omegat.bat": [13],
"artund": [27],
"счёта": [19],
"категорию": [30],
"локальной": [2],
"локальном": [2],
"уровне": [32,26],
"об": [9,[8,31],[10,13,17,20,29,32],[4,18,30]],
"уточнять": [20],
"предметным": [10],
"ок": [[2,17]],
"предметный": [32,[4,10]],
"проверяют": [26],
"превышает": [28],
"подраздел": [[19,29]],
"плане": [20],
"месте": [29],
"он": [13,29,[5,15,17,30],[2,4,11,16,19,21,25,28]],
"категорий": [[24,31]],
"ос": [2,17],
"используете": [17,[2,14,16,29]],
"категории": [24],
"от": [30,[19,20,29],17,[10,15],[24,28],[2,8,13,14,22,25],[0,1,3,9,12,18,23,26,27]],
"переходить": [23],
"собственно": [[0,12,13,16,17,27,29]],
"видны": [9],
"sawuła": [7],
"www.ibm.com": [17],
"вариантах": [29],
"задуман": [[17,21]],
"жадные": [24,31],
"открыт": [25,[16,21]],
"названием": [29],
"всю": [14],
"экранировать": [17],
"непереведенному": [18],
"курсора": [20,26,[5,30]],
"удаляете": [15],
"все": [17,29,25,20,30,13,[4,5,8,12,15,22,24],[1,2,3,10,14,16,19,23,26]],
"принимать": [[8,29]],
"видно": [16],
"разрывам": [12,26],
"пределах": [5],
"уровня": [29,13],
"по": [30,20,12,25,[8,32],[13,17,29],[2,14],26,23,15,[10,24,27,31],22,[16,28],[7,9],[1,4,6,18,21]],
"крайней": [2],
"туркменский": [6],
"сегментами": [[20,25,29,30],[10,15,23]],
"сведения": [8,20],
"вышеперечисленными": [17],
"запускающий": [17],
"каждые": [2,20],
"нечёткие": [30],
"срабатывает": [26],
"выравнять": [14],
"переходите": [30],
"command": [17,[8,20,30],18],
"нечётким": [20,30],
"неправильная": [16],
"n.n_without_jr": [17],
"непереведённого": [30],
"всё": [29,[13,19,30],[2,5,9,17,23,32]],
"особое": [15],
"эквивалента": [20],
"наличие": [8],
"наличии": [10],
"открыв": [30],
"произойти": [9],
"стандартный": [[1,10]],
"viewmarkbidicheckboxmenuitem": [8],
"стандартные": [26,[21,29]],
"быстрой": [19],
"спасибо": [4,31],
"vie": [6],
"расширить": [26],
"fileshortpath": [30],
"указан": [2],
"дубликатов": [30],
"стиль": [14],
"стиля": [[0,29]],
"см": [32,[20,29],[13,25],[0,14,26],[2,5,8,16,21,24]],
"динамической": [1],
"ситуации": [29],
"со": [29,13,[12,17,30],[10,11,20,32],[2,16,19,21,27,28,31]],
"работ": [19],
"общую": [2],
"чуть": [1],
"стили": [1],
"терминал": [17],
"google": [31],
"обратно": [14,[2,12,25,30]],
"деталей": [4],
"version": [[2,17]],
"project-dir": [[17,21]],
"дополнительно": [25],
"те": [[12,15,16]],
"folder": [29],
"mya": [6],
"stop": [28],
"никакую": [17],
"стандартных": [26],
"производит": [17],
"то": [20,[12,17],29,27,[16,26,30],[9,13,15,22,25,28],[2,11,14,21,23]],
"vista": [13],
"стандартным": [12],
"насколько": [30],
"сейчас": [2],
"ту": [30],
"счётчики": [30,[31,32]],
"увеличивающимся": [19],
"projecteditmenuitem": [8],
"least": [28],
"помечены": [26],
"начинает": [[10,26]],
"разделять": [26],
"britannica": [32],
"лингала": [6],
"простыми": [[15,22],[28,31,32]],
"весь": [20,[5,30]],
"терминам": [2],
"теперь": [2,[0,3,8,12,15,28,29]],
"длинном": [30],
"получается": [[17,21]],
"адресу": [27],
"необходимые": [17,2,13,[22,27]],
"отредактировать": [30],
"скопируете": [[2,17,21]],
"просмотреть": [30,[13,17]],
"создавать": [16,[26,32],[2,17,18,24,31]],
"iceni": [14],
"недавно": [19],
"мышью": [[16,25]],
"встроенной": [17],
"ситуация": [[15,22]],
"второго": [29],
"член": [2],
"фризский": [6],
"модификаторы": [[24,31]],
"точками": [12],
"языками": [19],
"настройкам": [12,13],
"свободы": [13],
"имеющихся": [17],
"терминологию": [[25,29]],
"переименовать": [27,29],
"прекрасную": [4],
"языком": [17],
"языков": [[14,23,26],[6,19,22,29],[0,1,3,10,11,13,16,21,30,31,32]],
"сначала": [2,[9,26],[13,14,18,19,29]],
"аварский": [6],
"склоняется": [16],
"терминологии": [[10,29]],
"изменение": [20,7,[12,15,23,30,32]],
"изменений": [2,[1,12,13,15,16,25,30]],
"ирландский": [6],
"путайте": [1],
"изменении": [8,20],
"проектам": [[13,17,20]],
"отследить": [14],
"измените": [22,[23,26]],
"ell": [6],
"помечена": [20],
"системного": [12],
"обновляемый": [14],
"однако": [17,29,[15,19,23,27],[2,14,18,22,30]],
"x0b": [24],
"вложенную": [[13,15]],
"настройках": [[20,23,27,30]],
"что-нибудь": [10],
"altern": [28],
"проектах": [29,[2,13,18,23]],
"http": [17,1,19],
"символы": [[12,16,24,25],[5,8],[14,30,31,32]],
"изменить": [12,17,26,14,[8,13,15,18,21,23,30]],
"безопаснее": [23],
"экранирование": [24,31],
"длину": [30],
"символу": [26,[12,25]],
"стороны": [[1,2,19],[15,26,29]],
"открываться": [15],
"стилем": [2],
"доступно": [2],
"разделители": [30],
"полностью": [29,15,[27,30]],
"всему": [30],
"динамический": [1],
"vol": [6],
"длина": [17],
"softwar": [7],
"терминологическими": [16],
"презентациям": [12],
"доступны": [20,2,[8,12],[1,25,30]],
"rexx-синтаксис": [1],
"end": [5],
"экранирования": [17],
"docbook": [[4,14,15]],
"часть": [15,[10,12,13,17,20,21,29,30]],
"повседневного": [17],
"helton": [4],
"символа": [[26,30]],
"eng": [6],
"всеми": [[17,20,29]],
"мексиканского": [27],
"локальными": [29],
"чч": [[21,29]],
"нему": [[2,17],[28,30]],
"испанского": [27],
"повреждения": [16],
"общего": [[21,30]],
"часто": [[10,17,18],[12,29,30]],
"правому": [14],
"части": [26,28,[20,30]],
"okapi": [32],
"зарезервированных": [1],
"забывайте": [25],
"изменения": [2,17,30,[12,20,23,26],[21,25,29],[8,13,14,15,18]],
"доступна": [[2,6,17]],
"стороне": [2],
"специально": [12,[14,29,30]],
"процесс": [10,[26,28]],
"переключателей": [30],
"сунданский": [6],
"заменить": [20,8,17,[30,32]],
"гренландский": [6],
"производятся": [14],
"интернета": [17],
"определяются": [[29,30]],
"moran": [7],
"шона": [6],
"учётная": [17],
"повторить": [20,[8,15]],
"system-os-nam": [12],
"автоматизировать": [12],
"канури": [6],
"по-своему": [14],
"optionstabadvancecheckboxmenuitem": [8],
"номер": [15,[12,17],[19,20,30,32]],
"членов": [2],
"букв": [15],
"через": [[9,14,20],[13,30],[2,10,17]],
"изначальную": [13],
"парам": [21],
"значок": [17],
"замените": [[29,30]],
"specifi": [[8,22]],
"optionsviewoptionsmenuloginitem": [8],
"остаётся": [[12,26,30]],
"разворачивания": [30],
"порче": [15],
"интернете": [[2,9,32],[1,8,10,25,31]],
"оставит": [28],
"соблюдении": [15],
"nav": [6],
"отметкой": [30],
"nau": [6],
"санскрит": [6],
"преобразований": [14],
"tar.bz2": [11],
"epo": [6],
"po-файлов": [[12,30]],
"команда": [17,[2,29],[8,20,24]],
"интернету": [19,27],
"команде": [17],
"мальтийский": [6],
"возрастания": [15],
"tmx-файл": [29,[17,21]],
"команды": [2,32,17,20,[19,29],11],
"x64": [17],
"никогда": [12,4],
"преобразования": [1,14,32],
"nbl": [6],
"единый": [29],
"команду": [17,13],
"наоборот": [[14,23]],
"клавиатурами": [20],
"открыто": [20],
"переключение": [14,5],
"мыши": [[2,17],30,[1,13],[16,20,27,28]],
"общих": [[2,30]],
"keyev": [8],
"прямо": [[10,18]],
"isn\'t": [24],
"вложенные": [[15,32],31],
"совпадением": [20,30],
"предпочитаемых": [30],
"ограничивать": [25],
"предпочитаемый": [[17,30]],
"преобразование": [19,32],
"выбрав": [[1,30],[12,13,17,21,22,23,26]],
"по-русски": [29],
"предложенным": [19],
"optionsteammenuitem": [8],
"процент": [30,29,15],
"предложенный": [19],
"задействован": [27],
"gzip": [29],
"nde": [6],
"автоматизации": [[17,30]],
"импортируйте": [14],
"esc": [30,20],
"имеющие": [[22,29]],
"x86": [17],
"ndo": [6],
"выбрал": [28],
"exampl": [8],
"храниться": [23,[12,13,14,29]],
"даёте": [17],
"замены": [[12,20]],
"следующими": [12,10],
"нельзя": [4],
"nostemscor": [30],
"письменностью": [14],
"переводят": [2],
"отслеживания": [15],
"поддерживающий": [[1,21]],
"общему": [2],
"дальше": [5],
"est": [6],
"поддерживающие": [10],
"абзацам": [23,[10,26],29],
"console-createpseudotranslatetmx": [17],
"точно": [[23,25,30]],
"тонганский": [6],
"значки": [17,13],
"longman": [[11,32]],
"поддерживающих": [[18,29]],
"nep": [6],
"напечатаны": [21,17],
"fuzzyflag": [30],
"шведский": [6],
"заключены": [16],
"значка": [17],
"распакуйте": [17],
"merriam": [[11,31,32]],
"escap": [24],
"разделяет": [[10,26]],
"merrian": [11],
"красный": [2],
"родственными": [19],
"below": [8],
"разрывом": [26],
"эстонский": [6],
"отключить": [12],
"didn\'t": [0],
"запустится": [17,1],
"красным": [[12,15]],
"всего": [17,29,21,[26,30],[1,2,10,11,14,22,23]],
"урду": [6],
"tool": [30],
"содержащую": [17],
"общие": [[2,32],[23,26]],
"ускорения": [29],
"общий": [29,[2,3,30]],
"общим": [23,2],
"загруженный": [17],
"испортите": [15],
"импорт": [29,[2,32],30],
"соединяется": [17],
"доступен": [[2,20]],
"eus": [6],
"рассылки": [9,13,[18,21,29]],
"независящей": [19],
"располагающихся": [1],
"строк": [32,12,[8,14,30],[1,26]],
"открыты": [25,30],
"открыть": [30,[13,20],[2,8,10,25]],
"никто": [16],
"желании": [[29,30]],
"n.n_without_jre.zip": [17],
"ндебеле": [6],
"общее": [30],
"французским": [17],
"общей": [29,32],
"отличает": [15],
"общем": [[24,29]],
"французский": [17,[6,19,21,29]],
"решён": [2],
"примечания": [30,12],
"vxd": [14],
"где": [17,13,[25,29],[1,2,8,16,21,30,32]],
"бирманский": [6],
"рабоать": [16],
"хотите": [29,[9,17,30],[12,20],[8,10,15,19,22,24,25,28]],
"точку": [17,26],
"напрямую": [17,[12,13]],
"активным": [30],
"перекрывали": [30],
"европейских": [26],
"помешает": [29],
"листов": [12],
"ewe": [6],
"рассматриваются": [28],
"martin": [7],
"точки": [[14,24,26,30]],
"примечание": [[20,24,30],[8,14,16,21,23,29],[17,18,25,26]],
"xslt": [1],
"европейским": [29],
"быть": [29,[16,17],[14,15,26],[2,13,30],[10,25],[1,8,12]],
"порта": [17,32],
"посередине": [24],
"примечаний": [30],
"объектами": [1],
"утечки": [2],
"него": [13,[15,16,20,25,27]],
"точка": [24,[13,26]],
"позволяют": [30],
"кастильского": [27],
"отмечать": [28],
"назначении": [10],
"shift": [20,8,14,5,18,16,[28,32]],
"установите": [23,[0,12,17,19,26,27,28]],
"назначение": [32,29],
"wunderlich": [7],
"щелчок": [30],
"установить": [[17,32],[2,11,27],[20,28,31]],
"java": [17,[13,21],1,[8,32],[15,24,31],[12,14,20,29]],
"exe": [17],
"найденному": [25],
"выполнять": [14],
"подключения": [27],
"запомните": [[2,18]],
"project_save.tmx": [29,21,[13,14],[2,20,30]],
"тагальский": [6],
"подключение": [19],
"dictionari": [11,[2,13]],
"словарей": [27,30,32,31,11],
"репозиторий": [2,29],
"смыслу": [15],
"определённого": [29,[12,25]],
"подчёркнутую": [0],
"операциях": [30],
"ознакомления": [26],
"репозитории": [2,29],
"смысла": [17],
"стали": [2],
"flash": [14],
"глоссария": [16,30,32,31,[2,10,14,20,21]],
"пользовательских": [13,32,[8,15,31]],
"переводах": [25,10],
"appl": [20,[17,18]],
"использоваться": [12,29,17,[1,10,20]],
"поможет": [9],
"имейте": [[9,15,21,29]],
"пользовательский": [[10,13,17,30],[9,20,31,32]],
"работах": [29],
"пользовательские": [13,[10,15,17]],
"репозитория": [2,32,4],
"default": [8],
"переводам": [25,[24,31]],
"глоссарий": [20,16,8,[2,18]],
"оставить": [[17,23,28,30,32]],
"глоссарии": [16,32,[10,13,30,31],[3,11,18,19]],
"бислама": [6],
"обеспечивает": [17],
"timestamp": [12],
"стол": [[17,25]],
"суахили": [6],
"изначальной": [12],
"nld": [6],
"исправить": [15,[9,16,23,25,29]],
"назначения": [7],
"plugin": [[0,1,3]],
"замечательно": [25],
"убедиться": [[2,29],[15,27]],
"примечанием": [20],
"языковой": [19,[0,2,21,27,29]],
"omegat-l10n-request": [9],
"создаются": [13],
"загружаете": [13],
"аккуратны": [21],
"носу": [6],
"знаю": [17],
"проверьте": [[11,19],[2,17,27,29]],
"сообщении": [29],
"editinsertsourcemenuitem": [8],
"знак": [[2,24]],
"назывался": [12],
"выглядит": [[13,17]],
"microsoft": [12,[14,32],[10,16,17,18,30]],
"projectnewmenuitem": [8],
"разработаны": [[14,26]],
"зарегистрированы": [2],
"восточноевропейская": [32],
"запущен": [0],
"лучше": [9,[2,19,21,26,27,29]],
"финансово": [9],
"сообщению": [13],
"optionstranstipsenablemenuitem": [8],
"нидерландского": [29],
"segment": [28,26,[15,16]],
"changes.txt": [13],
"сообщения": [9,[17,32],[21,30,31]],
"блок": [24],
"передача": [29],
"glossari": [16,[2,13],18],
"будете": [[2,10,13,17]],
"ignored_words.txt": [[2,13]],
"мириться": [15],
"критерии": [10],
"nno": [6],
"объединяться": [[12,23]],
"рабочего": [2],
"уровней": [29],
"контролируется": [28],
"лежат": [[11,30]],
"сообщение": [[9,17],[2,13]],
"требуется": [[10,13,14,15,17,19,23,24,29]],
"неправильно": [[13,15,16,23]],
"буквами": [[15,25]],
"перестанет": [15],
"nob": [6],
"next": [28],
"остальные": [[12,29]],
"остальным": [[2,29]],
"предпочитаемой": [16],
"переведённыефайлы": [21],
"языковую": [19],
"после": [26,17,[2,21,29],[15,16,18],[13,20,30],[8,12,23],[5,14,19,24,25]],
"nor": [6],
"получает": [[15,30]],
"остальных": [23,[26,30]],
"самую": [29],
"всё-таки": [17],
"not": [17],
"разделёнными": [16],
"ничейных": [29],
"нидерландский": [29],
"положение": [[12,30]],
"закрывать": [25],
"научитесь": [[10,18],[4,7,17,31]],
"ascii": [14],
"пакетном": [17],
"оказать": [26],
"целиком": [20],
"ничейные": [29,32,[26,30]],
"убирается": [19],
"абзацем": [12],
"кнопкой": [2,[1,17,30],[14,16,20,27,28]],
"перетащите": [17],
"тсонга": [6],
"кодировках": [12],
"selection.txt": [28,20],
"находился": [5],
"xhtml": [12,[14,15,26,30]],
"применяться": [26],
"применяемого": [30],
"языках": [29,[0,1]],
"откроете": [13],
"майкрософт": [17],
"подразумевается": [12],
"языкам": [23],
"window": [17,13,[2,32],20,[10,11,14,16,21,24]],
"зарегистрируйтесь": [2],
"клиентов": [2],
"абзацев": [26],
"появятся": [[18,25],[26,27]],
"удалось": [29],
"содержащие": [25,[14,15,16]],
"объёму": [30],
"кодировкой": [16],
"заполнять": [28],
"содержащий": [28],
"ответственный": [2],
"учитывает": [16],
"руководством": [20],
"потребностей": [29],
"omegat.pref": [13],
"when": [28],
"получить": [17,[12,15,26,30]],
"директории": [17],
"содержащих": [25,30],
"возникают": [[2,13,30]],
"fao": [6],
"txml": [14],
"затенён": [20],
"захочет": [26],
"ранние": [29],
"фраза": [[0,25]],
"faq": [9],
"fas": [6],
"каким-либо": [[15,20,27]],
"таблиц": [[16,30,31]],
"способов": [[14,29]],
"записывается": [29],
"следить": [9],
"считываться": [17],
"передать": [[17,19,21]],
"какой-нибудь": [16],
"управляет": [2],
"bartko": [7],
"сделать": [[17,27],[1,2,11,22,23]],
"фактически": [23],
"следите": [15],
"howto": [28],
"модули": [32],
"расчётов": [30],
"имелись": [21],
"проведением": [14],
"клавишей": [20],
"ноль": [[15,24],[12,25]],
"pt_pt.dic": [27],
"проявлением": [4],
"фразы": [18],
"утилитами": [19],
"укажет": [29],
"год": [[21,29]],
"ключа": [17],
"фразу": [25,0],
"подойдёт": [[16,29]],
"разрешается": [17],
"level1": [[18,29],20],
"level2": [[18,29],20],
"эве": [6],
"эквивалентом": [17],
"модуля": [[3,30],[0,13]],
"модуль": [3,0,1,[31,32],27,[2,9]],
"парой": [29],
"direct": [17],
"поэтому": [[9,12,26,29],[15,17,18,30]],
"пакетный": [13],
"началом": [[24,27,30]],
"вносить": [[12,26]],
"командной": [17,21,32,13,31,[4,10,20,29]],
"подчёркнутый": [16],
"web": [17,32,31],
"переводит": [[17,21]],
"berlin": [7],
"самой": [17,[10,18,24,29]],
"самом": [[9,13,14,15,17,29,30]],
"editselectfuzzy4menuitem": [8],
"двуязычными": [29],
"нажимаемые": [5],
"перекрывающиеся": [[15,32],31],
"некое": [15],
"шаблон": [12,[26,32],22],
"самое": [[2,22]],
"объёма": [19],
"извлечёт": [2],
"плюс": [14],
"удалять": [[18,27,28,29]],
"ровно": [12],
"преобразовать": [[14,28]],
"экземпляр": [30],
"pt_br.dic": [27],
"родительный": [3],
"атрибут": [12],
"отдельно": [27],
"сделаны": [17],
"unabridg": [11],
"таблицы": [14,26],
"естественно": [30],
"щелчке": [[20,30]],
"расширение": [16,22,[11,12]],
"широкий": [25],
"mrs.и": [26],
"корневая": [13,32],
"расширения": [12,14,22],
"совершенно": [29],
"n.n_without_jre.ex": [17],
"определённой": [25],
"приходится": [[15,27]],
"рамках": [[2,23],[15,21]],
"которая": [[10,21,22,29],[0,12,14,16,20,30]],
"проще": [14,[10,16,17,27]],
"нидерландском": [[0,29]],
"называют": [[17,26]],
"гереро": [6],
"раннее": [29],
"членам": [2,29],
"внесены": [[2,17]],
"таблица": [20,24,8,30,[5,6]],
"непосредственно": [[12,23]],
"учётной": [17,[2,9,19]],
"таблице": [26],
"поддерживают": [16],
"nnnn": [30,17],
"сохранив": [13],
"либо": [[2,27,28],29,[10,13,15,16,20,24,26,30]],
"кикуйю": [6],
"понадобиться": [29],
"согласно": [12,[0,13]],
"таблицу": [30,15],
"венгерский": [6],
"option": [17],
"редактируете": [30],
"более": [30,[17,24],[19,26],13,[7,10,23,29],[0,3,6,8,14,15,16,18,20,25,28]],
"поиск": [25,32,[20,24],10,[3,8,12,14,18,26,30,31]],
"телугу": [6],
"сохранит": [2],
"длинные": [30],
"переведённых": [12,32,[14,30],[17,20,23,29],19,[10,15,28]],
"myproject": [29],
"медленно": [20],
"отдельному": [20],
"занижается": [29],
"затеняться": [20],
"бывает": [[16,18]],
"продажи": [7],
"zh_cn.tmx": [29],
"языковых": [19,[10,26]],
"словосочетание": [26],
"wordfast": [14],
"переводов": [29,30,[10,32],20,[23,25],[18,31],[2,21],[13,17,26],[12,14,15]],
"созданием": [18],
"командную": [13],
"языковым": [[21,26,29]],
"содержащее": [20],
"huriaux": [7],
"wix": [14],
"языковые": [29,[27,32]],
"переводом": [29,[2,12,17,21,23,27,28,30]],
"принять": [[9,13]],
"файлового": [12,[13,30]],
"переведённым": [25],
"яванский": [6],
"способна": [28],
"txt2": [22],
"visio": [14],
"nya": [6],
"переведённый": [14,15,21],
"txt1": [22],
"высокий": [26],
"archiv": [17],
"пробельному": [26],
"содержащей": [29],
"переведённые": [20,30,[8,12,13,23,29,32],[10,14,15,25,26]],
"содержащем": [25],
"user": [17,[8,13]],
"определённым": [[0,25,26]],
"extens": [12,[1,22]],
"польский": [6],
"фильтра": [12,[30,31,32]],
"дальнейшем": [[18,29],[13,22]],
"находившиеся": [20],
"fij": [6],
"назначается": [14],
"дальнейшей": [20],
"новый": [29,[1,12,26,27],[17,18,20],[2,16,22,23,25]],
"дзонг-кэ": [6],
"fin": [6],
"результатом": [15],
"новые": [[8,16],[20,23],[15,18,26,30]],
"b0": [15],
"b1": [15],
"испанский": [19,[6,27]],
"b2": [15],
"происходить": [26,2],
"выйти": [20],
"клиенту": [29],
"вариантами": [[23,27,30,32]],
"подписываться": [13],
"обзор": [17],
"запуске": [[17,21]],
"клиенты": [2],
"запуска": [17,32,13,19,[4,21,29]],
"aa": [6],
"ab": [6],
"выделенный": [20,[8,28]],
"центральной": [22],
"ae": [6],
"показана": [30],
"af": [6],
"теги": [15,20,32,[14,29],18,[12,23],[8,30],31],
"открытый": [[16,25,30]],
"запуску": [10],
"укажите": [[27,29]],
"конго": [6],
"показано": [[0,18]],
"ak": [6],
"diff": [30],
"теге": [30],
"am": [6],
"an": [24,6],
"editmultiplealtern": [8],
"тега": [15],
"перестаёт": [15],
"ar": [6],
"as": [[6,8]],
"at": [[16,28]],
"просмотра": [32,30,31,16,20,[21,29],[8,14]],
"av": [6],
"корректного": [14],
"дополнительных": [[16,25,30]],
"закрывает": [20],
"последующего": [20],
"ay": [6],
"wln": [6],
"определённых": [29],
"az": [6],
"показаны": [[12,20],[19,25,29,30]],
"содержащего": [28],
"коми": [6],
"ba": [6],
"be": [8,[6,28,30]],
"bg": [6],
"определить": [26,12],
"дополнительные": [32],
"bh": [6],
"bi": [6],
"редактировать": [[12,17]],
"обновлённого": [16],
"дополнительный": [29,[15,17]],
"filters.xml": [13,[2,23]],
"bm": [6],
"напротив": [19],
"bn": [6],
"bo": [6],
"неуклонно": [19],
"дополнительным": [13],
"br": [12,[6,17]],
"исходном": [[14,15,20,29,30]],
"bs": [6],
"search": [25],
"by": [[8,30]],
"стрелка": [5],
"последующая": [2],
"segmentation.conf": [[13,21],[17,23]],
"большую": [15],
"дистрибутива": [17],
"ca": [[6,17]],
"обнаружили": [23],
"сокращается": [1],
"фильтры": [12,23,32,22,[13,20,30,31],[8,18,25]],
"cd": [17,21],
"редактируемого": [5],
"ce": [[6,14]],
"öäüqwß": [25],
"ch": [6],
"конец": [5,24],
"фильтру": [14],
"единственный": [29],
"cn": [17],
"co": [6],
"прочитайте": [[9,15]],
"говоря": [30],
"cr": [6],
"cs": [6],
"совпадениям": [[30,32],[13,20],[8,29,31]],
"cu": [6],
"ресурсы": [13],
"cv": [6],
"символов": [24,[19,31],[12,14,17,20,25,30]],
"новым": [[23,29]],
"cx": [24],
"cy": [6],
"несут": [15],
"apach": [[2,27]],
"новых": [2],
"белорусский": [6],
"da": [6],
"интервал": [20],
"adjustedscor": [30],
"вправо": [5],
"de": [6],
"рисунки": [12],
"ищет": [[0,10,16,25]],
"платформы": [[13,17]],
"состоит": [30,[12,13,29]],
"f0": [20],
"do": [0],
"f1": [20,30,[8,32]],
"уменьшается": [15],
"написать": [13],
"f2": [17],
"f3": [20,[8,32]],
"указанные": [[17,21]],
"dr": [26],
"f5": [[8,20]],
"вложена": [15],
"подходящего": [17],
"северный": [6],
"dv": [6],
"каталог": [29,13,[2,17],27,[1,8,11,12,20,21,30,32]],
"wol": [6],
"dz": [[6,11]],
"editundomenuitem": [8],
"рассматривается": [[25,29]],
"своего": [[9,29]],
"показать": [[8,20],[17,25]],
"инструкции": [[10,31]],
"окончательный": [19],
"ee": [6],
"сегментироваться": [12],
"основные": [[17,19]],
"параметров": [20,[17,18,21,28,31]],
"u000a": [24],
"вносили": [17],
"хоть": [30],
"кодом": [27],
"el": [6],
"хотя": [19,[20,23,29]],
"visualsvn": [2],
"belazar": [19,32,31],
"сохраняются": [[2,30]],
"кодов": [6,32,[26,29,31],[5,10,21]],
"en": [30],
"eo": [6],
"платформа": [19],
"es": [6],
"u000d": [24],
"et": [6],
"u000c": [24],
"eu": [6],
"киньяма": [6],
"платформе": [17],
"подробностями": [7,14],
"представленное": [15],
"областях": [14],
"стандартом": [30],
"имеющиеся": [29,27],
"заданном": [26],
"fa": [6],
"параметром": [20],
"значениях": [12],
"двуязычную": [29],
"таково": [17],
"хостинга": [2],
"ff": [6],
"относится": [17,[2,12,29]],
"stats.txt": [13],
"u001b": [24],
"командные": [32,2,[3,5,10,31]],
"fi": [6],
"fj": [6],
"командным": [2,[17,31]],
"поиске": [[24,25],[15,29,31]],
"командный": [2,[8,32]],
"for": [1,[8,22]],
"спросит": [17],
"fo": [6],
"этапе": [[2,26]],
"fr": [17,[6,21,26,27]],
"content": [17],
"последующем": [2],
"fy": [6],
"внутренней": [[20,30]],
"рассмотрим": [3],
"руководствам": [14],
"подтверждать": [[8,20]],
"applescript": [17],
"внутреннем": [29],
"испанском": [19],
"поиску": [25],
"введёте": [[13,17]],
"ga": [6],
"такого": [19],
"лишь": [[2,17],[12,13,23,25,29]],
"gd": [6],
"class": [12],
"инструкцию": [9],
"правило-исключение": [26,32],
"используемый": [22],
"отсутствовало": [4],
"порядком": [30],
"gl": [6],
"editoverwritetranslationmenuitem": [8],
"outputfilenam": [17],
"gn": [6],
"i0": [15],
"go": [28],
"i2": [15],
"кажется": [[19,29]],
"шрифт": [21,[20,30,32],[8,14,15]],
"aeiou": [24],
"gu": [6],
"используемые": [[13,15],[14,25,30,32]],
"gv": [6],
"внутреннее": [[20,23]],
"указанный": [[17,21]],
"указанным": [20],
"поиска": [25,30,32,31,20,[3,24],[10,15,18,21,29]],
"основе": [[1,2,9,10,20,26]],
"клиента": [29,[2,10,17,30]],
"ha": [6],
"учитывается": [30],
"макеты": [12],
"he": [6],
"запустить": [17,21,[1,13]],
"битную": [22],
"удалив": [28],
"hi": [6],
"подобных": [[14,23]],
"duser.languag": [17],
"ho": [6],
"подобный": [19],
"hr": [6],
"ht": [6],
"hu": [6],
"вызывая": [13],
"hy": [6],
"hz": [6],
"file-target-encod": [12],
"послать": [13],
"fra": [6],
"oci": [6],
"скопирует": [[12,13,30]],
"ia": [6],
"context": [30],
"экспортирует": [20,29],
"briel": [[4,7]],
"id": [[6,30]],
"ie": [6],
"fri": [6],
"if": [[1,8]],
"project_stats.txt": [30,2],
"ig": [6],
"ii": [6],
"сравнению": [13],
"ik": [6],
"португальский": [[6,19,27]],
"предупреждение": [30],
"результат": [[10,18,24,25,29]],
"позже": [[12,13]],
"дополнительную": [13],
"in": [[1,16,17],8],
"португальским": [17],
"io": [6],
"коды": [29,[12,17,27,32]],
"termin": [17],
"отметьте": [17,2],
"особенно": [[10,21],[3,23,26,30]],
"is": [8,[6,24,28]],
"большой": [[21,27]],
"эта": [[17,20],[7,12,28],[0,23]],
"it": [[6,16]],
"iu": [6],
"последующих": [10,[13,17,31]],
"предупреждений": [17],
"большое": [24],
"изначально": [13,[2,19,29]],
"коду": [27],
"odf": [14,[12,15,20,23,26]],
"выделяться": [20,12],
"которое": [20,[15,30],[5,14,23,29]],
"подобные": [29],
"ja": [[6,17,29]],
"которой": [24,[1,2,10,15,27,30]],
"нарушено": [15],
"multiterm": [16,32,31],
"коде": [2],
"jc": [4],
"odp": [14],
"мешать": [2],
"ничего": [20,5,[8,19,30]],
"кода": [17,32,31],
"последующие": [30],
"котором": [[2,17],[13,16],[1,10,18,21,22,27,30]],
"неточности": [4],
"расчёт": [30],
"odt": [14],
"хранится": [[13,23],[1,2,16]],
"обработки": [20,[12,17,19,28],[1,9,29,30]],
"описанной": [20],
"librari": [13],
"версией": [30],
"тематики": [29],
"jp": [22],
"обычного": [[2,27]],
"nplural": [12],
"участникам": [13],
"тематике": [29,16],
"js": [1],
"обработку": [20],
"jv": [6],
"настроены": [10],
"польском": [0],
"возможно": [29,[14,15,16,26],[2,3,9,13,17,18,19,24,30]],
"learned_words.txt": [[2,13]],
"эти": [29,13,30,[14,22,23,25,27]],
"действуют": [5],
"раньше": [29],
"написано": [[4,13]],
"maxym": [7],
"ka": [6],
"это": [29,15,30,12,[14,21],[13,27],[16,20],[1,17,19,24,26,28],[2,4,10,11,18,22,23,25]],
"обработка": [29],
"которого": [29],
"африкаанс": [6],
"kg": [6],
"двуязычные": [32],
"ki": [6],
"эту": [[20,29],[7,10,13,19,23]],
"kj": [6],
"доступных": [[1,12,19,21]],
"kk": [6],
"добровольной": [9],
"kl": [6],
"два": [26,[15,17,27],[2,10,14]],
"km": [6],
"наполняться": [29],
"экспортных": [29],
"kn": [6],
"ko": [6],
"две": [17,[2,13,28,30]],
"kr": [6],
"ks": [6],
"viewdisplaymodificationinfoallradiobuttonmenuitem": [8],
"ku": [6],
"настроена": [17,12],
"вполне": [[16,19,26]],
"kv": [6],
"новую": [[13,16,17,27]],
"kw": [6],
"ky": [6],
"доступные": [[10,27]],
"казахский": [6],
"записей": [[13,16]],
"la": [6],
"lb": [6],
"веб-сайтах": [10],
"lg": [6],
"ful": [6],
"предназначенный": [1],
"li": [6],
"dswing.aatext": [17],
"смене": [30],
"переключатели": [25],
"управлять": [2],
"ln": [6],
"lo": [6],
"изменениями": [[2,17]],
"ls": [13],
"lt": [6],
"прибегнуть": [29],
"lu": [24,6],
"dist": [17],
"отличие": [[19,25,30]],
"перемещаясь": [28],
"потому": [29],
"lv": [6],
"нетронутыми": [12],
"полезными": [24],
"тегах": [15],
"отличии": [30],
"особо": [[20,23]],
"cycleswitchcasemenuitem": [8],
"ходом": [9],
"that": [30],
"тегам": [[15,26]],
"открытом": [[12,13]],
"минимум": [[13,29]],
"доступа": [2,[17,20]],
"новом": [2],
"основного": [1],
"mg": [6],
"новой": [17,[2,24,26,30]],
"mh": [6],
"mi": [6],
"mk": [6],
"чтения": [20,[13,30]],
"новое": [20,2,[17,30]],
"ml": [6],
"доступе": [13],
"установятся": [27],
"направо": [14,5],
"entri": [1],
"mn": [6],
"много": [[10,28]],
"предотвратить": [21],
"mr": [26,6],
"приведён": [17],
"яблока": [20,18],
"ms": [[6,15,26]],
"mt": [6],
"настроек": [30,[13,32],[29,31],[8,15,21,23,27]],
"приведёт": [[13,30]],
"выбором": [[2,30]],
"фрагмент": [[14,16,20]],
"учитывать": [[2,25]],
"wxl": [14],
"потянув": [30],
"марок": [28],
"отображают": [30],
"my": [[6,13]],
"двуязычных": [[11,19]],
"повторно": [29,13],
"интернет-сайт": [9],
"гарантии": [7],
"корейский": [6],
"na": [6],
"аргументами": [17],
"nb": [6],
"переключатель": [12],
"критериев": [25],
"nd": [6],
"ne": [6],
"updat": [2],
"ng": [6],
"латвийский": [6],
"запрещает": [16],
"британника": [11],
"nl": [[6,29]],
"занимается": [0],
"исходный": [16,[14,30],[12,21],[1,15,20,22,26,28]],
"nn": [6],
"no": [12,6],
"code": [8,19],
"nr": [[6,16]],
"исходным": [29,[15,20,22,25,28,30]],
"практически": [12],
"nv": [6],
"gotohistoryforwardmenuitem": [8],
"ny": [6],
"исходные": [29,32,20,[16,30],[8,15,17,19,31]],
"освобождая": [29],
"поскольку": [[15,23],25],
"oc": [6],
"дополнительной": [16],
"od": [14],
"of": [22,[2,8,11,19]],
"сегментировать": [12],
"исландский": [6],
"орфографических": [[0,27]],
"oj": [6],
"ok": [2,18],
"om": [6],
"on": [8],
"ставить": [24],
"keyboard": [8],
"or": [[6,17]],
"ленивые": [24,31],
"os": [17,32,13,[2,6,8,10,14,31]],
"ot": [14],
"осуществления": [26],
"tmx-файлов": [29,32,[17,20]],
"распространение": [7],
"указанную": [25],
"записаны": [0],
"encod": [22],
"oji": [6],
"алгоритм": [3],
"pa": [6],
"editinserttranslationmenuitem": [8],
"pi": [6],
"нюнорск": [6],
"специфичными": [29],
"pl": [6],
"результатов": [25,[30,31]],
"специализированного": [10],
"po": [14,[12,32],[29,30]],
"параметрах": [12],
"указанном": [11],
"окситанский": [[6,19]],
"ps": [6],
"тоже": [17,[2,21,27]],
"pt": [[6,17]],
"startdict": [11],
"большее": [22],
"ключ-значение": [12],
"существующих": [[10,23]],
"постарайтесь": [[14,15]],
"захотите": [18,[12,23]],
"существительными": [19],
"совпадения": [30,29,32,[15,16,28]],
"вашими": [[5,10]],
"секретных": [9],
"страница": [30],
"странице": [17],
"указанной": [25],
"хранящийся": [29],
"темой": [9],
"ничему": [24],
"qu": [6],
"делается": [12],
"editselectfuzzy5menuitem": [8],
"страницу": [5,[13,19]],
"совпадении": [28],
"совпадений": [30,32,29,20,[24,31],[3,14,15,18,21,28]],
"then": [16],
"присвоены": [29],
"ссылкой": [30],
"совпадение": [20,30,8,29,[5,15,28]],
"женский": [3],
"тайский": [6],
"страницы": [[24,30],[8,13,26]],
"платный": [19],
"цветом": [30,[12,15,18,20,25]],
"принят": [29],
"бумажных": [30],
"существующие": [[1,13,18,20,29]],
"rm": [6],
"исходных": [29,12,23,[19,20],[2,3,10,17,22,30,32]],
"rn": [6],
"существующим": [[26,28]],
"ro": [6],
"стирается": [20],
"существующий": [[26,29]],
"ru": [6],
"персональным": [19],
"rw": [6],
"optionstranstipsexactmatchmenuitem": [8],
"третий": [16],
"sa": [6],
"sc": [[6,24]],
"выделены": [30,[15,25]],
"sd": [6],
"записью": [20],
"se": [6],
"проектом": [2,[20,29,32],[23,31],[10,12,26]],
"sg": [6],
"вернуться": [30,23,[12,15,20]],
"сегмента": [5,30,20,28,15,12,[26,29],[1,19,32],[2,8,14,16,18,25]],
"общая": [32],
"si": [6],
"анализируются": [29],
"того": [20,[17,21,29],[2,13,18,30],[9,14,28],[12,15,19,25,27]],
"sk": [6],
"проектов": [[10,23,29],[2,12,30]],
"sl": [[2,6]],
"samuel": [[4,7]],
"sm": [6],
"sn": [6],
"so": [6],
"служит": [29],
"непереводимые": [12],
"sq": [6],
"сегменте": [30,[20,32],[14,16],[10,15,17,19,28]],
"свою": [14],
"sr": [6],
"сегменту": [20,30,[18,25,28],[5,15,19]],
"ss": [6],
"китайский": [29,6],
"st": [6],
"su": [6],
"загружаться": [21],
"sv": [6],
"нумеруются": [15],
"курсором": [5],
"sw": [6],
"конце": [[13,24,30]],
"пункты": [20],
"порог": [28],
"one": [[8,28]],
"выделено": [20,30],
"обязателен": [29],
"сегменты": [29,20,30,25,26,8,[10,12,23,28,32],[13,15,19],[17,18]],
"которую": [[13,15,19,25]],
"перестать": [15],
"ta": [6],
"конца": [[5,24],[25,32]],
"editoverwritesourcemenuitem": [8],
"целях": [17],
"te": [6],
"используемом": [21],
"свой": [2,29],
"принудительно": [2],
"tg": [6],
"перенесены": [[15,23]],
"th": [6],
"свои": [[12,21]],
"ti": [6],
"выделена": [20],
"tk": [[6,28]],
"переводятся": [[10,18]],
"xhtml-файлах": [12],
"remov": [17],
"tl": [6],
"специфического": [29],
"tm": [29,32,30,[2,25],18],
"активном": [16],
"tn": [6],
"сводку": [29],
"to": [28,17,8,[6,22]],
"v2": [19,[17,32]],
"перезапущена": [8],
"tr": [6],
"используемой": [0],
"ts": [6],
"пункта": [8,[1,9,13,20]],
"tt": [6],
"алфавитом": [21],
"document.xx": [12],
"третьем": [30],
"tw": [[6,17]],
"чёткое": [4],
"ty": [6],
"привыкнете": [[17,30]],
"числами": [28],
"использовали": [17],
"выделенной": [17],
"сервисы": [[10,19]],
"hmxp": [14],
"nl-ru": [29],
"сервиса": [[2,17,19]],
"projectwikiimportmenuitem": [8],
"полезным": [[13,17,29]],
"countri": [17],
"ug": [6],
"uk": [6],
"yahoo": [[9,13]],
"веб-браузере": [13,30],
"полезных": [[18,24]],
"un": [16],
"ur": [6],
"смотри": [[17,24],13],
"явно": [[12,21]],
"науру": [6],
"перемещение": [20,32],
"написанный": [14],
"разумен": [22],
"uz": [6],
"перемещении": [15],
"китайской": [20],
"рассчитываемый": [30],
"this": [24],
"примечаниях": [25],
"составляющие": [30],
"журнала": [15],
"написанные": [[1,24]],
"ve": [6],
"разделов": [10,31],
"отображает": [30,[10,20]],
"vi": [[6,17]],
"разделением": [16],
"которому": [[2,17]],
"для": [17,30,[20,29],13,12,2,14,26,19,21,[10,31],[8,15,24,32],1,18,16,[5,25,27],[7,22,23,28],3,[0,6,9,11]],
"поддерживает": [14,29,[1,2,4,11,19,30]],
"vo": [6],
"подобной": [15],
"захламляли": [25],
"выберите": [30,17,2,12,[13,18,25,26,27,29],[1,20,21,22,28]],
"токенизатором": [3],
"словенский": [19,6],
"выделяет": [[17,20]],
"экспортированную": [29],
"creationd": [30],
"wa": [6],
"диапазон": [25],
"способа": [[22,30]],
"omegat.sourceforge.net": [17],
"бухгалтерского": [30],
"groovy.codehaus.org": [1],
"wo": [6],
"представленная": [17],
"ходе": [30],
"рекомендуется": [26,2],
"backspac": [5],
"док": [17],
"licens": [7,13],
"emac": [17],
"введён": [19],
"ori": [6],
"orm": [6],
"латинского": [24],
"совместимая": [17],
"xf": [17],
"зависеть": [29],
"xh": [6],
"xp": [13],
"способы": [[25,32],[16,31]],
"темы": [21,[6,10,27,31,32]],
"корейской": [20],
"xx": [17,12],
"xy": [24],
"sourc": [[13,29],17,[1,28,32],[18,20,21,22,30]],
"щелчком": [13,17],
"папок": [23,[13,20]],
"обусловлены": [30],
"type": [8],
"устареть": [30],
"oss": [6],
"используемую": [[3,23,25]],
"volker": [7],
"yi": [6],
"над": [2,29,[20,31],[10,23,32]],
"теме": [29],
"отображать": [16],
"osx": [17],
"прокси-сервера": [17,32],
"yo": [6],
"нам": [17],
"предложений": [[20,23],[10,19,26,32]],
"yu": [7],
"предложение": [18,26],
"семидесятипроцентные": [29],
"stylesheet": [1],
"yy": [12],
"za": [6],
"otp": [14],
"анализ": [19],
"zh": [6],
"ott": [14],
"регулярными": [[24,32],31],
"найдите": [[11,17]],
"выражаю": [4],
"оставшиеся": [10],
"предложения": [30,[10,19,24]],
"тихом": [[17,21]],
"penalti": [29],
"применяемые": [0],
"exact": [25],
"омегат": [17,32,29,13,[10,21],31,14,[9,30],20,2,12,28,[15,19,22],27,[1,8,23,25],[3,7,16],[4,26],0,18,[5,11,24]],
"zu": [6],
"полезной": [26,10],
"вперёд": [20,8],
"решением": [15],
"zz": [17],
"использована": [29],
"частей": [[15,19]],
"начинающимися": [24],
"заметно": [21],
"utf8": [16,22,14],
"подачей": [17],
"которые": [17,30,29,12,[2,4,10,13,14,15,28],[16,18,19,25,26],[0,1,8,20,23,24,27]],
"автором": [25],
"перемещения": [[15,20,31]],
"который": [[13,17],[12,29,30],[20,21,27],[2,16,18,22,26,28]],
"окружающему": [15],
"которым": [[20,24],[10,26]],
"юникоде": [22],
"никаких": [[9,14,29]],
"юникода": [[24,31]],
"операторы": [[24,31]],
"множеством": [21],
"разными": [14,[2,11,29]],
"щёлкните": [17,2,30,[1,9,16,20,23,28]],
"которых": [[25,29],[10,13,15,28],[3,12,18,20,23,30]],
"power": [12],
"свати": [6],
"оторваться": [27],
"tag-valid": [21,17],
"файлу": [17,[13,20,21]],
"случае": [29,[15,17],30,20,[2,19,21,22,25]],
"имяфайла": [29],
"случаи": [15],
"файлы": [14,32,13,12,29,17,18,30,2,20,[21,22],[10,27],[16,31],28,[8,23],[1,3,11]],
"предпочесть": [1],
"находить": [10],
"tokenizer": [31],
"файла": [12,16,32,30,29,[18,20],[11,14,15,17,22,27],[13,21,26,31]],
"help": [14],
"файле": [17,29,13,[12,20],15,[10,25,30]],
"распаковки": [13],
"автоматического": [17],
"u0009": [24],
"xhh": [24],
"revis": [11],
"u0007": [24],
"несколько": [[17,29,30],25,[13,18,21,24,26,31],[2,14,20,28,32]],
"repositori": [2],
"распаковка": [13],
"предоставить": [29],
"xho": [6],
"date": [16],
"областей": [30,32,31],
"папки": [29,[10,13,17,18,23],[27,30]],
"папке": [[13,20],17,[21,29],[12,16,28]],
"data": [13],
"xht": [14],
"никакой": [7,[14,29]],
"lowercasemenuitem": [8],
"firefox": [27,1],
"lists.sourceforge.net": [9],
"папка": [13,17,[10,21,27,29,32]],
"местном": [16],
"предоставляет": [17,[19,25,30]],
"количеству": [[12,25,27]],
"улучшения": [9,[1,3]],
"translate": [31],
"откроется": [27,[2,15,16,18]],
"функцией": [[15,27]],
"английскому": [4],
"выборе": [[13,20,28]],
"словенской": [[19,30]],
"словенском": [[3,16,25]],
"filepath": [30],
"выбор": [32,[1,10,12,13,28,30]],
"использовать": [29,17,[20,30],[10,12,16],[19,21],[8,13,18,23],[7,14],[1,2,22,24,25,26,27,28]],
"избавляет": [28],
"папку": [17,13,27,[11,16,18,29,30]],
"oasi": [14],
"выбора": [17,[12,20,21,23]],
"другого": [[17,21,28,29]],
"управляющие": [8],
"количества": [29,30],
"nl-zh": [29],
"управляющий": [24],
"like": [17],
"кириллицу": [22],
"вызвать": [[13,18,21,30]],
"неё": [20],
"испорчены": [13],
"записанных": [16],
"последовательной": [19],
"коса": [6],
"начинать": [[12,26],[9,10]],
"внутренняя": [23],
"перечислены": [[8,17]],
"количество": [30,15,[14,29],[24,28]],
"ней": [17,30],
"улучшаться": [19],
"испорчено": [15],
"openoffic": [27],
"нет": [17,[12,29],[16,27,28],[1,13,14,18,20,22,30]],
"записанные": [[16,17]],
"новогреческий": [6],
"ассоциированный": [1],
"называться": [[8,27]],
"количестве": [15],
"единственное": [3],
"доступной": [29],
"note": [30],
"поделиться": [29],
"noth": [0],
"line": [17],
"инструкциям": [17],
"стороннего": [2],
"платформо-независимом": [13],
"переведите": [14],
"внутреннюю": [20],
"helari": [[4,7]],
"проделано": [20],
"git": [2,29],
"скопированные": [2],
"удаляемая": [15],
"скопированный": [14],
"содержащуюся": [29],
"страниц": [[14,20]],
"отключать": [20],
"доступное": [30],
"xx-yy": [12],
"выбору": [7],
"закройте": [29,21],
"will": [4],
"тегом": [15],
"virgul": [16],
"встроенная": [30],
"follow": [8],
"тегов": [15,30,32,[12,20,31],[18,21],17,14,[8,23]],
"экспортированный": [20],
"optionsspellcheckmenuitem": [8],
"необходимой": [11],
"xlf": [14],
"необходимое": [2],
"миллион": [19],
"стандарту": [29],
"optionssetupfilefiltersmenuitem": [8],
"пробелов": [14],
"никак": [[5,14,29]],
"называемый": [3],
"altgraph": [8],
"разделах": [10],
"пометки": [2],
"напишите": [21],
"личный": [17],
"покрывает": [22],
"личных": [9],
"день": [[13,29]],
"внесёте": [12],
"your": [22,8],
"созданы": [13],
"найти": [[13,19,25,30],[10,18,24,28],[4,9,12,14,15,17,21,26,29]],
"галисийский": [[6,19]],
"программистов": [20],
"ним": [17,[5,14,24,29,30]],
"склонение": [[3,16]],
"загружается": [17],
"направленные": [1],
"xml": [14,1,12,[15,16]],
"запуститься": [[3,21]],
"целом": [30,[14,16,20,22,24]],
"них": [10,[13,25,29],[8,14,15,17,21,30]],
"попросить": [29],
"gla": [6],
"кодами": [13],
"gle": [6],
"glg": [6],
"программного": [2],
"по-разному": [20],
"создана": [[13,17]],
"людей": [[4,10]],
"краткое": [10,[0,31]],
"практической": [30],
"выделять": [20],
"принадлежит": [7],
"glv": [6],
"befor": [17],
"соответствовать": [27],
"util": [17],
"специальными": [[2,19]],
"пункт": [30,8,20,[1,13,17],[12,27,28],[2,21,22,23,26,29]],
"tar.bz": [11],
"xltx": [14],
"проекты": [2,32,31,[3,5,10,13,18,29]],
"снаружи": [15],
"жёсткому": [17],
"беспрепятственной": [2],
"присутствуют": [15],
"нажатию": [30],
"интерфейса": [17,[21,32]],
"проекту": [30,21,[17,20],[2,9,13,29]],
"xml-документов": [1],
"имеются": [[2,13,25]],
"проблемой": [22],
"конфликтуют": [8],
"интерфейсе": [17],
"процессе": [13,23],
"табуляций": [14],
"полезны": [[14,26]],
"табуляции": [26,24],
"хранилище": [29],
"размерами": [14],
"использующихся": [10],
"буфера": [20],
"определит": [3],
"стилистические": [10],
"процесса": [[13,17,21,29]],
"оригинал": [20,29,[8,14],[5,19,28]],
"акан": [6],
"проблему": [29],
"вкладки": [30],
"xlsx": [14],
"деле": [[9,14,15,29]],
"проект": [20,29,13,32,21,30,2,[17,31],[8,18],16,[9,26],[1,3,11,12,14,23,27]],
"предпочтениями": [[5,10,20]],
"уточнит": [20],
"отменено": [20],
"проблемы": [32,[11,15,16,31],[14,18,21,22]],
"копирования": [[15,20,30,31]],
"ознакомьтесь": [13],
"двунаправленного": [8],
"посмотреть": [[10,12,30]],
"справочный": [29],
"значением": [24],
"gnu": [17,13,[7,32],2,[10,16,21,24,30,31]],
"регулярному": [12],
"строкой": [29],
"нажатие": [[20,30],25],
"копирование": [[29,32],[15,23]],
"уйгурский": [6],
"нажатий": [28],
"документах": [23,[14,20,28,29]],
"нажатии": [15,[19,20,27]],
"проблема": [16],
"режим": [[14,17],21,32],
"турецкий": [6],
"проекте": [30,20,12,25,[13,21,23],[0,8,16,17,18,29,32]],
"создали": [27],
"target.txt": [28],
"проекта": [29,[20,32],13,[2,18],23,30,[17,31],16,[10,12],[1,8,14,21,26,27],[3,9,11,19,25,28]],
"одноимённый": [13],
"ньянджа": [6],
"поддержание": [2],
"легко": [[15,29,30],[25,28]],
"отправлено": [2],
"забудете": [15],
"степени": [[15,30]],
"степень": [3],
"находиться": [[2,15],[16,17,18,20,30]],
"определениями": [8],
"nameon": [12],
"начать": [26,[9,18,19]],
"pan": [6],
"gotonextnotemenuitem": [8],
"tar.gz": [17],
"gpl": [11],
"trados": [31],
"кодовое": [8],
"перейдите": [17,[2,13]],
"закрыть": [30,20,[8,18]],
"работающих": [29],
"подключили": [19],
"проектами": [2],
"появляются": [[13,28]],
"слов": [30,[20,25,31],[1,3,10,13,16,32]],
"неточностей": [4],
"закрыто": [20],
"поведением": [20],
"справочного": [10],
"сколько": [4],
"приставки": [3],
"аргументов": [17,4],
"lisa": [16],
"невидимое": [[20,23]],
"azur": [17],
"структурное": [19],
"работающие": [30],
"работающий": [2],
"открывающий": [15],
"хранятся": [13,2,17],
"упоминаются": [10],
"выполненный": [30,19],
"фиксации": [2],
"обмена": [20,[16,29]],
"открывающим": [15],
"морфологический": [19],
"rashid": [7],
"фирмы": [20],
"открывающие": [15],
"совет": [30],
"улучшает": [3],
"соответствуют": [12,[2,29]],
"пример": [15,31,21,[16,17,19,24,29,32]],
"значительные": [1],
"navegar": [19],
"контролировать": [[2,17]],
"combin": [8],
"набором": [[19,26]],
"минуты": [2,[21,29]],
"систем": [2,[19,20]],
"grn": [6],
"загрузки": [[12,18,29]],
"коллегами": [30],
"статьёй": [16],
"использующих": [19],
"xtg": [14],
"загрузка": [17,32],
"интерфейсом": [17,21],
"bindownload.cgi": [17],
"таковые": [26],
"функциональный": [1],
"называемую": [2],
"архив": [11,[13,29]],
"загрузке": [29,[12,13]],
"pdf": [1],
"образцы": [[12,29]],
"пробелами": [[20,30]],
"разделам": [10],
"there": [[17,28,30]],
"включают": [20],
"url-адрес": [2],
"описание": [[2,9],[4,8,10,17,20,30]],
"другая": [13],
"фиксация": [2],
"описании": [2],
"русского": [21],
"избежать": [[2,29],[4,28]],
"загруженному": [13],
"групп": [[15,32],31],
"процессорах": [14],
"одновременно": [25,[2,14,17,29,30]],
"хауса": [6],
"toolsshowstatisticsmatchesmenuitem": [8],
"производить": [29,17],
"грубо": [30],
"viewdisplaymodificationinfononeradiobuttonmenuitem": [8],
"отменяет": [20],
"отделяет": [30],
"серым": [20,18],
"меньший": [13],
"морфологического": [3],
"таковой": [14],
"различать": [15],
"клавиша": [20,18,[5,8]],
"сохранили": [20],
"обозначения": [8],
"официального": [1],
"грамматические": [[0,10]],
"приобретёте": [23],
"выглядеть": [[17,18]],
"назначить": [1],
"тексте": [18,[4,10,15,19,29,30]],
"заработает": [27],
"гальский": [6],
"текста": [14,31,[15,20,26,32],[5,28,30],[10,29],[2,16,18,25],[6,8,12,19,21,22,23,27]],
"одноязычные": [11],
"текст": [20,[12,14],28,30,15,[22,26,32],[1,10],[8,21]],
"обозначение": [8,24],
"гигабайт": [17],
"тексту": [26,[7,15],[24,28]],
"тому": [15,[13,24]],
"guj": [6],
"выделен": [30],
"показан": [16],
"docx-файлах": [[20,23]],
"обладать": [2],
"интерес": [30],
"обратной": [17],
"stemmer": [[3,32]],
"изменять": [12,[7,17,20],[8,13,14,23,30]],
"выражения": [24,31,[25,32],10,[11,15,21,26]],
"запускает": [17],
"запускается": [17,29],
"регулярного": [21],
"предположим": [29],
"ограниченная": [30],
"uhhhh": [24],
"java-синтаксисом": [1],
"находится": [17,[21,29],[5,12,20],[2,13,14,16]],
"выражению": [12],
"парами": [[12,29],[2,15,32]],
"украинский": [6],
"optionssentsegmenuitem": [8],
"ответственность": [4],
"фарерский": [6],
"обнаружено": [29],
"сгруппировано": [18],
"предлагает": [[12,28]],
"западной": [22],
"клавиши": [[20,30],8,[5,13,18]],
"перезаписана": [17],
"mб": [17],
"этими": [13],
"взяты": [30],
"понимает": [29],
"dokuwiki": [14],
"взять": [30],
"его": [30,17,29,20,[12,13,14,16],[1,4],[11,22,26,27],[2,10,15,18,21]],
"unix-подобных": [20],
"клавишу": [20],
"test.html": [17],
"начинающих": [18],
"xxx": [29],
"переводиться": [12,23],
"удобном": [29],
"smalltalk": [1],
"функция": [20,[2,15,16,27,28]],
"функцию": [20,16],
"ant.apache.org": [17],
"изменяется": [[1,21]],
"установочного": [13],
"целые": [28],
"окон": [[25,30],20],
"перетащив": [17],
"трудолюбием": [4],
"повторяющихся": [[10,17]],
"сегментам": [[25,29],17],
"переменные": [15,[20,30]],
"целым": [[12,25]],
"гаитянский": [6],
"регистр": [8,20,[17,25,30]],
"pseudotranslatetmx": [[17,29]],
"сегментах": [[14,32],[3,15,25,30]],
"обмениваться": [18],
"классического": [27],
"справочных": [29],
"декларативный": [1],
"окну": [[15,20,30]],
"валлонский": [6],
"переменных": [15,30],
"arno": [7],
"активного": [5,[16,25]],
"сохранённый": [22],
"окно": [32,30,[20,31],12,18,21,[23,25],2,17,15,[1,8,13,16,27,29]],
"velasco": [7],
"тибетский": [6],
"когда": [30,[10,20],[5,14,15,17,21,29],[2,12,13,16,18]],
"targetlanguagecod": [12],
"столе": [[17,30]],
"учитываются": [30],
"svn-репозиторий": [2],
"позицией": [20],
"окне": [30,[20,27,29],[12,16,17],[13,15,25,28],[2,3,23]],
"выражений": [24,[17,26,30],31],
"pilpré": [7],
"выражение": [24,15,17,21,[10,25]],
"окна": [32,30,20,31,26,[1,15,17,22],[14,21,28]],
"окажется": [14],
"загрузили": [17],
"проводятся": [30],
"привязать": [14],
"токенизаторы": [3],
"заменяйте": [29],
"тематических": [9],
"состояние": [20,8,[13,23,30]],
"тексты": [14],
"след": [[0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31]],
"изменённых": [10],
"пытается": [[12,22]],
"подобного": [29],
"отдельная": [24],
"цифрового": [24],
"выделил": [28],
"bundle-файла": [[17,21]],
"отредактированных": [29],
"именами": [[11,18,27]],
"клиент": [2],
"нестандартных": [15],
"новичков": [10],
"другие": [32,[30,31],20,14,[10,13,21],17,[2,5,6,9,12,15,16,27,29]],
"подключить": [29],
"похоже": [30],
"creationid": [30],
"выделит": [[3,20]],
"сохраняется": [29,[14,20,23]],
"другим": [[10,15,18,19,21,27]],
"лингвистических": [19],
"заполните": [26],
"других": [[17,29],[0,2,4,9,13,15,20,27,28,30]],
"pli": [6],
"состояния": [30,[17,21]],
"сканированных": [[20,23]],
"целых": [19],
"мировые": [19],
"лингвистические": [19],
"стоит": [[2,30],[20,26,27,29]],
"символ": [24,5,[2,12],26],
"образом": [17,30,[21,26,28,29],[2,10,13,14,16,18,27]],
"шаблона": [12,26],
"источником": [30],
"изменённый": [20],
"порядковый": [12],
"svn-клиенты": [2],
"подпрограммы": [12],
"определение": [2],
"optionstagvalidationmenuitem": [8],
"создают": [[14,19]],
"подкаталог": [13,32,29,17,[1,2]],
"снимите": [23,[19,26]],
"определении": [30],
"другими": [29,17,[14,15,32]],
"непереведённые": [20,[8,25,28]],
"исключение": [24,26],
"pt_br": [27,17],
"есть": [17,12,[22,28],[10,16,30],[14,25,26],[1,9,13,15,21,23,27,29]],
"диалог": [20,12],
"a-z": [24],
"иерархической": [13],
"содержат": [29,14,[10,18],[12,13,16,22,25,28]],
"непереведённым": [30],
"zoltan": [7],
"шаблону": [[12,15,26]],
"перезагружает": [20],
"удаляя": [15],
"непереведённый": [20,[8,28,30]],
"краю": [14],
"шаблоны": [12,[14,15,24,25,26]],
"электронные": [30],
"запрашивает": [2],
"помечаться": [29,15],
"справочник": [10],
"пробельный": [24],
"want": [8],
"определения": [12,8],
"png": [17],
"плохо": [[20,23]],
"марки": [[28,30]],
"сохраните": [14,[8,16,17,22]],
"пробельные": [12],
"svn-клиента": [2],
"электронных": [[16,30]],
"javascript": [1],
"структурные": [26],
"нужными": [19],
"mediawiki": [[20,30],8],
"относящуюся": [13],
"сохранить": [20,[8,15,17,18,29,30]],
"основной": [[2,17]],
"программ": [[2,14,17,18,24]],
"заданные": [13],
"имя_проекта": [13],
"join.html": [13],
"заново": [[26,29]],
"вставить": [20,[5,8,30],32,[12,14]],
"сербский": [6],
"создаваемого": [17],
"сконструированных": [19],
"pol": [6],
"публикуемые": [29],
"состоят": [[15,29]],
"por": [6],
"гораздо": [[10,25]],
"found": [17],
"отсутствует": [17,21],
"удобнее": [29],
"открытие": [32,[17,18],31],
"отступать": [15],
"сесть": [14],
"прочтите": [13],
"продолжайте": [4],
"добавленные": [16],
"ниже": [17,[2,15,24,29,30],13,[1,14,19,20,21,25,27]],
"снизу": [25],
"волоф": [6],
"открытии": [29,[16,21,28]],
"непоследовательно": [29],
"совпадают": [[16,30],[15,27,29]],
"регулярные": [24,31,32,[10,25],[11,15,26]],
"ему": [12],
"поля": [[12,26,30],10],
"открытия": [[8,20]],
"считает": [25],
"googl": [19,[17,32],[10,25]],
"opendocu": [12],
"приложениях": [20],
"работали": [20],
"европы": [22],
"отображаться": [29,[2,12,18]],
"отсылаться": [19],
"парными": [15],
"регулярных": [[24,26],[17,25],31],
"открытию": [30],
"буквальных": [24],
"поле": [[12,28],[2,17,24,25],[15,30],[19,20,21,26,27]],
"между": [30,14,[19,20],[1,12,15,16,17,29]],
"руководству": [[14,21]],
"sourceforg": [9,[8,13,32],2],
"руководство": [30,[10,31],[2,4,7,8,9,17,18,20,32]],
"structur": [26],
"состоянием": [2],
"подчёркнутому": [[20,27,30]],
"соответствии": [[7,10,17],[2,3,5,13,20,29]],
"pod-файлы": [14],
"пользовательскими": [20],
"загрузите": [17,[1,11,13]],
"руководстве": [20,2],
"hat": [6],
"оповещения": [24],
"руководства": [4,[13,14,18,19,30]],
"keyword": [25],
"hau": [6],
"загрузить": [32,[2,11,27],[1,8,9,13,16,20,29,30,31]],
"первого": [[1,13,23,30]],
"особенности": [10],
"шаблонам": [25],
"editmultipledefault": [8],
"сочетание": [8,14,5],
"editfindinprojectmenuitem": [8],
"пока": [[2,15,17,21,23]],
"сеанс": [17],
"соответствия": [25],
"виду": [29,[9,15,21,23,30]],
"сочетаний": [8,5,[10,30,31,32],[7,9,20]],
"сочетания": [20,[8,31],5,[10,30,32],[2,6,14,15,23]],
"warn": [21,17],
"согласных": [24],
"technetwork": [17],
"тигринья": [6],
"целая": [10],
"вида": [12],
"абсолютным": [29],
"доке": [17],
"набираете": [30],
"виде": [13,[2,17,18,20,23,29,30]],
"пригодный": [19],
"разбит": [30],
"plural": [12],
"подход": [[22,32],31],
"заданных": [[12,29]],
"дудена": [30],
"заданный": [17],
"возвращает": [20,30],
"звонка": [24],
"заданным": [20],
"оба": [15,[19,21]],
"скрыта": [[20,30]],
"подкаталогах": [29],
"разделите": [29],
"документов": [29,32,14,[2,8,10,12,20,23,30]],
"греческий": [6],
"предложенного": [27],
"подчёркивается": [0],
"ганда": [6],
"сегментирует": [26],
"jacob": [7],
"файловом": [[13,27]],
"употреблено": [16],
"экспортировании": [28],
"исключения": [26],
"ограничений": [28],
"windows": [31],
"загружены": [[12,17]],
"перезаписывается": [28],
"кодам": [[6,29]],
"набор": [23,26,[24,25]],
"если": [17,20,12,29,21,30,13,27,15,[14,16,23,25],[18,26],19,[9,28],[0,1,5,10,22],[2,8,11],[3,24]],
"n.n_windows.ex": [17],
"chang": [22],
"введите": [17,[2,20],[16,18,25,26]],
"pop-up": [16],
"передаётся": [12],
"ярлыков": [17],
"позднее": [[12,17,20,28,30]],
"широко": [[1,2,10]],
"бюро": [30],
"heb": [6],
"вверху": [9],
"учебник": [10],
"описанному": [24],
"brune": [7],
"соответствовали": [27],
"редактор": [[1,12,16,17,30]],
"некоему": [24],
"program": [17],
"последовательности": [24,25],
"hostnam": [12],
"pus": [6],
"keith": [7],
"прочтения": [14],
"псевдо-перевода": [29,[31,32]],
"her": [6],
"исключительно": [14],
"нём": [[10,13],17],
"аргументы": [32,17,19],
"веб-сайтов": [19],
"project_save.tmx.гггммддччнн.bak": [[21,29]],
"прочие": [17],
"разу": [24],
"интернетом": [10],
"работает": [20,[13,17,19],[10,12,21,22,24,25,27,29]],
"новая": [[17,29]],
"обратная": [24],
"каком-либо": [12],
"содержит": [29,[13,21,30],[1,9,10,11,15,20,23]],
"camtasia": [14],
"подключиться": [2],
"легче": [22],
"html-документ": [30],
"морфологическое": [19],
"n.n_mac.zip": [17],
"вырезания": [[20,31]],
"канадского": [26],
"сохранённой": [21],
"посылаются": [19],
"рисунок": [30,[13,16,27],[0,11,15,19,23,24,25,28]],
"схожего": [19],
"файловых": [12,23,13,[2,10,14,22]],
"tabl": [8],
"значками": [17],
"предлогов": [4],
"вноситься": [16],
"обращайтесь": [21],
"потеря": [13],
"потерю": [[13,21]],
"файловым": [[23,27]],
"doc-license.txt": [13],
"файловые": [12,32,23,22,[13,20,30,31],[8,18,25]],
"послав": [9],
"yid": [6],
"copyflowgold": [14],
"сущности": [15],
"некорректно": [18],
"опросам": [13],
"даётся": [7],
"маркер": [[30,32]],
"последовательность": [[9,20]],
"потери": [[21,32],[10,23,31]],
"табуляциями": [16],
"editor": [17],
"pseudotranslatetyp": [[17,29]],
"hhc": [14],
"открытием": [[18,20,23]],
"улучшая": [17],
"улучшить": [29],
"hhk": [14],
"сразу": [[16,28,29,30]],
"цифры": [[15,21,29]],
"нечетких": [18],
"оттуда": [27],
"создать": [29,[20,23],[8,17],[2,13,18],[15,16,19,21,26,30,32]],
"команд": [17],
"итак": [17],
"находящиеся": [[17,21,30]],
"цифра": [24,[1,14]],
"шаблоном": [26],
"языковыми": [29,[2,32]],
"наборах": [19],
"сомали": [6],
"шаблонов": [12,[25,32],[20,26,31]],
"использован": [12],
"отправить": [2],
"носители": [21],
"решение": [[19,32],31],
"javaapplicationstub": [17],
"projectclosemenuitem": [8],
"hin": [6],
"viewmarknonuniquesegmentscheckboxmenuitem": [8],
"включать": [20,[12,16]],
"падеже": [16],
"распространяемая": [7],
"помещается": [29],
"замечаний": [18,31],
"чувашский": [6],
"заработать": [8],
"tmx-файле": [29],
"основная": [13],
"tmx-файла": [29,[17,30]],
"мексиканский": [27],
"сложно": [4],
"скрыли": [20],
"group": [13],
"разрешать": [2],
"почти": [[16,22]],
"readme.txt": [[7,12,13]],
"зарегистрирован": [20],
"кхмерский": [6],
"целевого": [29],
"languagetool": [0,[10,31,32],[1,3]],
"дважды": [17,[12,13,24,30]],
"решения": [16],
"source.txt": [28],
"вызовут": [15],
"files.s": [1],
"кандзи": [22],
"создаст": [[17,23]],
"siband": [7],
"пользователям": [[2,25]],
"exchang": [16],
"output-tag-valid": [17],
"непереведённое": [23],
"восклицательный": [2],
"терминологическую": [[16,30]],
"никакого": [[17,30]],
"projectlock": [2],
"предлагать": [10],
"request": [19],
"условий": [15],
"точкой": [[26,28]],
"currseg": [1],
"списком": [12],
"point": [12],
"избегать": [[29,30]],
"general": [7,13],
"l4j.ini": [17],
"участник": [17],
"аналогии": [20],
"описываются": [10],
"функциями": [1],
"вступили": [[8,12,26]],
"условие": [25],
"игнорировать": [[13,27]],
"распознаваться": [16],
"tmx-файлы": [29,32,20],
"преобразованных": [[20,23]],
"внизу": [30,[1,8,11,26]],
"стоимость": [19],
"занять": [[27,30]],
"обработает": [17],
"заданную": [25],
"tmx-файлу": [30],
"andrzej": [7],
"унаследовал": [14],
"ярлыки": [17],
"ярлыке": [17],
"сериализован": [1],
"запускать": [17,1,13],
"установлен": [[12,20],[17,23],[2,13,15,19,25,26,27,28,29]],
"изменяет": [[13,17,20,23]],
"кашмири": [6],
"способ": [17,28,25],
"какое-либо": [26],
"справочной": [29],
"взаимодействовать": [17],
"называемых": [18],
"account": [17],
"dhttp.proxyhost": [17],
"специальный": [[12,28]],
"несоответствиями": [20],
"играет": [[20,23]],
"специальных": [[12,14]],
"hmo": [6],
"ещё": [[17,21],[23,24,25,29]],
"программах": [[1,27,29]],
"специальные": [[13,20,26]],
"переведенные": [18],
"ignored_word": [32],
"оджибве": [6],
"yor": [6],
"you": [[8,17]],
"менее": [[14,21,26,29]],
"доступ": [17,30,[1,13,27]],
"важный": [[13,17,21]],
"api-ключ": [19],
"contient": [16],
"пишите": [21],
"индексы": [12],
"первой": [[4,16]],
"первом": [[10,15,16,17,30]],
"важных": [[9,13,21]],
"configur": [17],
"попытается": [28],
"данного": [[4,12,13,23]],
"важные": [10,[13,18]],
"она": [17,[7,30],[0,5,12,13,16,18,20,22,25]],
"левой": [[1,14,30]],
"какие": [12,10],
"buloichik": [7],
"они": [17,[13,25],[2,21,28,30],[8,12,27,29],[14,15,16,20,22,23,24]],
"китайского": [17],
"относящихся": [29],
"находящемся": [29],
"передается": [17],
"optionsworkflowmenuitem": [8],
"каким": [4],
"оно": [[20,30],[12,17,19,21,23]],
"вариант": [20,30,23,[8,14,19,28]],
"мета-тегов": [12],
"редких": [[23,29]],
"releas": [[8,17]],
"peter": [7],
"каких": [12],
"единица": [29],
"текстового": [30],
"португалия": [17],
"cordonni": [7],
"sparc": [17],
"алфавита": [24],
"релевантными": [30],
"йоруба": [6],
"переведенных": [18,31],
"запоминает": [20],
"корневом": [20],
"подробно": [[20,30]],
"sandra": [7],
"разрыв": [[15,26]],
"даются": [14],
"ненадолго": [27],
"составлять": [29],
"вручную": [16,[14,18,20,23,27,29]],
"татарский": [6],
"творческих": [10],
"запуском": [[0,3]],
"следующего": [[5,20]],
"малаялам": [6],
"повышается": [19],
"основываются": [22],
"обходной": [14],
"подпапке": [18],
"творческом": [26],
"нумерация": [[15,32]],
"проконтролировать": [25],
"prior": [4],
"последнего": [[20,25,30]],
"оснащёнными": [20],
"знакомиться": [10],
"надо": [17,[12,13,15,19]],
"выводящиеся": [[17,21]],
"продуктов": [14],
"огромному": [27],
"маркером": [30],
"какой-либо": [[1,19,27,29]],
"перейдёт": [29],
"count": [30],
"воспользовался": [19],
"запустят": [17],
"hrv": [6],
"скопирован": [[12,18]],
"описывается": [10,[2,5,20,30]],
"предварительная": [29],
"отформатирован": [14],
"удалено": [15],
"ответы": [9],
"file-source-encod": [12],
"опять": [17],
"синдхи": [6],
"называемыми": [10],
"заданному": [20],
"единицы": [29,24],
"разработчиков": [[2,9,13]],
"предварительного": [[21,29]],
"настраиваемый": [28],
"настраиваемые": [13],
"всех": [[23,29,30],[1,12,14,25],[8,15,20,28]],
"используйте": [[17,20,29],[14,30]],
"представлен": [[16,30]],
"всей": [29],
"vilei": [7],
"всем": [4,2,[9,13,15,30,31]],
"посреди": [13],
"tang": [7],
"сообщит": [29],
"мере": [[13,29],[2,30]],
"настраиваемых": [12],
"именительный": [3],
"машины": [[1,12]],
"голубым": [20],
"меньше": [[17,21],[14,24]],
"беру": [4],
"ссылка": [[15,27]],
"расстановке": [20],
"переводчик": [29,[26,30]],
"editexportselectionmenuitem": [8],
"использованном": [14],
"ссылке": [30,[9,15,17]],
"monitor": [9],
"ссылки": [12,[9,30]],
"обработаны": [[14,17]],
"home": [5,[13,17,21]],
"michael": [7],
"перемещать": [[18,30]],
"своём": [2],
"сторонние": [14],
"оставаясь": [5],
"вставит": [28],
"появившемся": [[2,29]],
"зажата": [5],
"исчезнут": [27],
"build.xml": [17],
"подпапку": [18],
"единиц": [29],
"hun": [6],
"закладки": [12],
"названы": [15],
"блоков": [[24,31]],
"обработать": [[20,30]],
"подкаталоге": [13,30,29,[2,11,28,32]],
"подкаталога": [23],
"орфографию": [27],
"идентифицировать": [19],
"совпадать": [28,23],
"aligndir": [[17,21]],
"меню": [8,30,31,20,[17,32],[1,13,23,28],[12,19,27],[10,18,21,22,26],[2,14,29]],
"отдельных": [[2,25,30]],
"описан": [[8,29]],
"заголовкам": [25],
"system-host-nam": [12],
"входа": [17],
"быстрому": [17],
"подойти": [12],
"ошибками": [15,[17,20,25]],
"creat": [[2,16]],
"po-файла": [12,14,30],
"python": [1],
"вставка": [32],
"отдельный": [27],
"es_mx.dic": [27],
"отдельные": [[12,26]],
"исходного": [[12,32],14,[15,17,26],[20,29,30,31],[3,19,22,23,25,28]],
"разработчикам": [9],
"infix": [14],
"проигнорированы": [17,[5,8]],
"po-файле": [12],
"результаты": [[12,24,25]],
"отдельным": [30],
"doc-файл": [14],
"менб": [32],
"поддерживаемых": [[0,10,12,15,18,30]],
"запятая": [24,16],
"черновой": [4],
"подкаталоги": [2,[13,31,32]],
"tarbal": [11],
"гггг": [[21,29]],
"вставке": [28],
"вставки": [20,31],
"поддерживаемым": [14],
"чей": [21],
"псевдо-переводов": [[17,29]],
"чем": [32,[9,19,26],[13,24,31]],
"программные": [[15,20]],
"должном": [15],
"omegat-development-request": [9],
"установлены": [17,[12,19,27]],
"поддерживаемые": [[14,24]],
"нормально": [15],
"поверх": [17],
"программный": [21],
"шрифтом": [30,[15,20,25]],
"объектно-ориентированный": [1],
"достаточно": [29,26,[2,10,13,16,17,18,23]],
"шрифтов": [32,21,17,[14,20,31]],
"переведёнными": [30],
"программным": [7],
"кенгуру": [10],
"словацкий": [6],
"предыдущего": [[20,29]],
"удалены": [13],
"отличный": [16],
"обращении": [14],
"руанда": [6],
"file": [[1,22],17,28],
"результате": [[2,15,19]],
"отличных": [17],
"орфографии": [27,32,31,20,10,[0,8,13,19,21]],
"маори": [6],
"албанского": [19],
"could": [30],
"заголовках": [[30,31,32]],
"подкаталогов": [[10,13],[16,23]],
"windows-системах": [17],
"catti": [3],
"menu": [16,[8,30]],
"цветами": [14],
"исправьте": [[15,30]],
"ссылок": [24],
"hye": [6],
"приостановлена": [17],
"маратхи": [6],
"a-za-z": [24,25],
"зарегистрироваться": [9],
"отображался": [14],
"установлена": [17,[0,2,3,13,14,22,30]],
"return": [19],
"войти": [9],
"назначаемой": [17],
"считывает": [[1,29]],
"какая-либо": [20],
"объявлена": [12],
"локально": [17],
"первых": [16],
"память": [29,32,10,[20,23,31],[13,18],[2,14,15,19,21,26,30]],
"совместимого": [1],
"source-pattern": [[17,21]],
"считать": [22],
"find": [8],
"системами": [[10,20,29,30]],
"нажатием": [[14,30]],
"соответствующими": [[8,30]],
"свободная": [[0,10,19]],
"защите": [23],
"прописывается": [12],
"версиями": [2,29,[13,31]],
"chua": [7],
"синтаксис": [26,[8,12]],
"копией": [2],
"лимбургский": [6],
"следующему": [20,18,[25,26,30]],
"позволит": [29],
"создаёт": [20,[13,17]],
"падеж": [3],
"программе": [[8,13,17,20]],
"ними": [15,[10,17]],
"оригиналах": [25],
"говорят": [30],
"программа": [17,21,13,[0,7,20,22,30,32],[2,10,16,24,31]],
"уверен": [26],
"важной": [[20,23]],
"первым": [20],
"разделяться": [23],
"xliff": [14],
"true": [17],
"первому": [20],
"памяти": [29,30,17,10,32,[20,25],[21,26,31],[2,14,16,18,23,24]],
"первые": [[16,20,25]],
"последнему": [20],
"обращения": [15],
"синхронизировала": [17],
"корректные": [29],
"программу": [17,[0,7,10,13,21,30]],
"разрешить": [[12,28]],
"первый": [[25,30]],
"уэбстера": [30],
"таджикский": [6],
"обрабатывал": [12],
"выделения": [3,28],
"вставленных": [29],
"программы": [17,[13,29],2,[10,20,21,26],[1,14,24,32]],
"groovi": [1],
"пять": [1],
"услугами": [2],
"главного": [30,[20,29],[8,14,17]],
"минут": [[10,18],[4,7,17,20,21,31]],
"мнению": [9],
"объединять": [12],
"best": [28],
"одинаковым": [29],
"transform": [1],
"kmenueditor": [17],
"пяти": [29],
"tortoisesvn": [2],
"денежной": [24],
"показываться": [[17,20,21,29]],
"греческого": [24],
"выделение": [[17,19,32]],
"messageformat": [15],
"азербайджанский": [6],
"изменёнными": [10],
"считаться": [30],
"удаляет": [[20,27]],
"удаляются": [[20,23]],
"kmenuedit": [17],
"вставленный": [16],
"xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxxx": [17],
"writer": [14,18],
"dalloway": [26],
"выделению": [30],
"rubi": [1],
"что-то": [10],
"произведена": [2],
"разработке": [[2,9]],
"ключом": [19],
"разработки": [24],
"токенизатор": [3],
"разработка": [32],
"проверка": [32,27,15,[17,20,31],[8,10,18,21,30],[0,2,14,16,19,24]],
"неоценимой": [4],
"изменениях": [21],
"вставляться": [20],
"исправлять": [29,10],
"проверке": [[12,13,27]],
"проверки": [27,[15,31],30,21,[20,32],[0,17,18]],
"omagat": [18],
"приложение": [[0,1,2,3,5,7,8,9],[4,6],21,[14,17,20,26,29,32]],
"проверил": [30],
"приложении": [10,30],
"одноимённого": [1],
"возможности": [10,[15,19,22,31]],
"locmanag": [14],
"вообще": [15,28,[26,30]],
"regex": [24,31],
"произведено": [15],
"meta": [8],
"ознакомиться": [17],
"сайты": [9,[31,32]],
"предназначен": [[10,21,24,29]],
"except": [26],
"приложения": [13,[14,17,32],[5,10,31]],
"разработку": [9],
"быстрого": [17],
"вашу": [[4,17]],
"достаточен": [29],
"пометить": [[12,20,28]],
"именительном": [16],
"поняли": [27],
"алгоритма": [8],
"global": [12],
"программой": [18],
"адаптации": [15],
"сайта": [1],
"начинаются": [[8,17]],
"ваше": [20],
"сайте": [[2,11,14,18]],
"ваши": [[10,18],[17,28,29]],
"выдаст": [24],
"free": [7],
"ваша": [[10,17]],
"позднюю": [7],
"дополнительными": [17],
"серьёзного": [16],
"запятые": [16],
"значительное": [21],
"вернёт": [23],
"вопросы": [[9,13]],
"энциклопедия": [11],
"ibm": [17],
"предыдущему": [20,[5,30]],
"fish": [3],
"ibo": [6],
"прошедшие": [29],
"побыстрее": [21],
"регистрации": [19],
"подпишитесь": [9],
"содержимым": [[13,20,28]],
"выбранным": [20],
"ядро": [19],
"обоих": [30],
"выбранный": [[1,18,20]],
"слегка": [[10,26]],
"проверкой": [0],
"выбранные": [[12,27],[20,30]],
"задач": [14],
"процессором": [1],
"другое": [20,[13,25,29,30]],
"наименовании": [15],
"подумайте": [22],
"начертании": [14],
"специальном": [[10,15]],
"задан": [[17,21],19],
"другой": [[1,2,15,29],[3,19,20,21,23,26,27,28,30]],
"локализации": [14],
"специальной": [1],
"другом": [10],
"jean": [7],
"bat-файл": [17],
"схожих": [10],
"давать": [30],
"имеется": [[13,20,30]],
"пар": [19],
"скрипта": [[17,32]],
"odt-файл": [14],
"персидский": [6],
"регулярно": [21,[13,14,29]],
"жёсткого": [27],
"схожие": [[2,15,29]],
"локализация": [32],
"переусердствуете": [30],
"ido": [6],
"статистикой": [30],
"устаревшая": [14],
"кем-то": [17],
"idx": [11],
"производиться": [26,[2,15,27]],
"выбранных": [20],
"самостоятельное": [30],
"нижеописанные": [20],
"que": [6],
"qui": [16],
"показывалось": [15],
"rule": [26],
"чувствительны": [24],
"скрипты": [1,[2,13,17]],
"тамильский": [6],
"что": [29,17,2,19,[15,30],[23,25],[13,26,27],9,[10,12,14,16,21,22],[5,7,28],[3,11,18,20]],
"скрипту": [17],
"реализация": [17],
"linux": [17,32,[2,13],[10,16,21,24,30,31]],
"чему": [2],
"аргументах": [17],
"сохранён": [14],
"потребуется": [17],
"checkout": [2],
"скрипте": [17],
"домашний": [13],
"осетинский": [6],
"касающиеся": [[10,30]],
"нажать": [25,[12,18]],
"распакованном": [17],
"зарезервирован": [20],
"гласных": [24],
"форме": [12],
"прокси-сервером": [17],
"подробнее": [9],
"составляет": [[17,20]],
"режиме": [17,21,32,14,31],
"настоящее": [[14,30],15],
"образец": [21],
"несмотря": [[25,26]],
"режима": [[17,21],[10,14]],
"zha": [6],
"секции": [22],
"ifo": [11],
"окружении": [[17,21]],
"схожей": [29],
"запусках": [17],
"окружение": [[17,21]],
"продвинулись": [30],
"отличаться": [12],
"переведён": [[17,29],[12,13,16,21]],
"терминов": [30,[10,16]],
"zho": [6],
"каком": [[17,21,22]],
"xx.docx": [12],
"загруженной": [17],
"позволяет": [20,[12,17,29],28,[1,14],[10,15,16,19,21,22,25,30]],
"найденных": [30],
"граница": [24],
"члены": [2],
"архивы": [13],
"движке": [30],
"машинный": [[19,20],32,[8,30,31],[10,16,27]],
"строки": [17,21,32,24,[13,25,30],5,[16,31],[4,10,14,15,26,28]],
"архива": [11],
"группам": [15],
"строке": [[17,21],[8,29,30]],
"архиве": [11],
"price": [19],
"форму": [25],
"разрабатывавшаяся": [19],
"воспользовавшись": [[23,27]],
"синхронизация": [2],
"строка": [30,29,[3,25,26,28]],
"группах": [30],
"выпущена": [13],
"удобных": [17],
"zip": [[13,17]],
"управлению": [15,[14,31,32]],
"параметрами": [17],
"исключением": [[26,29],[5,24]],
"указываете": [17],
"строку": [25,[12,13],[8,17,21,30]],
"очередному": [28],
"управления": [2,29,[16,19,20,31,32]],
"северносаамский": [6],
"жирным": [15],
"подписаться": [9],
"ibai": [7],
"домашнем": [[17,21]],
"назначать": [17],
"yahoogroups.com": [9],
"выпущены": [11],
"sdlxliff": [14],
"customer-id": [17],
"экран": [[1,17,21]],
"какого-либо": [[10,27,29]],
"объекты": [12],
"албанский": [6],
"волапюк": [6],
"указывается": [21],
"мощными": [1],
"другую": [15,30],
"забыли": [11],
"iii": [6],
"управление": [20,[2,10,32],[5,31]],
"учёта": [30],
"избавиться": [22],
"присутствует": [[12,29]],
"имеющимися": [29,[31,32]],
"пожертвования": [32],
"kyle": [7],
"viewmarknotedsegmentscheckboxmenuitem": [8],
"автоматизированного": [10,[21,29,31]],
"снимки": [9],
"опечатки": [[4,10]],
"создания": [29,30,[8,10,12,13,15,16,20,21]],
"выбранное": [[20,30],2],
"subscrib": [9],
"подробная": [17,[6,13,29,30]],
"запуск": [17,32,[19,21,31],[10,18,30]],
"сингальский": [6],
"optionssaveoptionsmenuitem": [8],
"excel": [12],
"понять": [[25,29]],
"совпадает": [29,[12,15]],
"пополняются": [13],
"runn": [25],
"члена": [29],
"создании": [13,[2,24,29]],
"создание": [32,2,18,31,[14,26,29]],
"будь-то": [10],
"сверху": [25],
"stardict": [11,32],
"возврата": [24],
"корсиканский": [6],
"omegat.l4j.ini": [17],
"span": [12],
"обеспечения": [[2,10]],
"собой": [30,13,[11,14,15,29]],
"примерно": [17],
"предварительный": [[29,32]],
"справки": [10,30],
"prefer": [13],
"поискать": [[17,18]],
"hans-pet": [7],
"справку": [30],
"верхнего": [13],
"имяпроекта-omegat.tmx": [29],
"давали": [29],
"участие": [[9,13]],
"юникод-кодировке": [22],
"iku": [6],
"pijffer": [7],
"действительно": [20,15],
"старая": [[0,3,17]],
"zakharov": [7],
"представьте": [[10,26]],
"понимаете": [13],
"исходя": [[12,30]],
"from": [17,8],
"закрываете": [20],
"ссылками": [[13,30]],
"заданного": [[14,17]],
"сравнительная": [3],
"thunderbird": [27],
"ile": [6],
"editselectfuzzy3menuitem": [8],
"viacheslav": [29],
"сервисом": [19],
"обеспечение": [2],
"арабский": [6],
"сервисов": [19],
"отсутствуют": [29],
"project.projectfil": [1],
"запросы": [9,25],
"открывшемся": [23],
"норвежский": [6],
"задействована": [[17,29]],
"независимо": [24],
"отдельном": [20],
"phillip": [7],
"язык-страна": [26],
"отдельной": [29],
"справка": [[20,32],[8,31],30],
"попытку": [17],
"цветовое": [20],
"завершение": [13],
"появлению": [1],
"вами": [[19,20,25,26]],
"po-файлах": [30],
"подчеркнуть": [29],
"появления": [25],
"примечаниями": [20,8],
"упростите": [15],
"используя": [[16,21,23,25,26]],
"попробовать": [14],
"shortcut": [8],
"public": [7,13],
"вернуть": [20],
"поисковых": [25],
"ларусса": [30],
"сообщал": [4],
"внимание": [[15,17],[18,19],[12,26,27,30]],
"возможность": [26,[2,16,19,25]],
"track": [9],
"ina": [6],
"ind": [6],
"запятой": [[16,26,28]],
"pt_br.aff": [27],
"границы": [[24,31]],
"поисковый": [25],
"передавать": [10],
"занимать": [2],
"поисковые": [25],
"ini": [14,[17,32]],
"каталонский": [19,6],
"вычисляется": [30],
"завершения": [2],
"каким-то": [27],
"отладке": [17],
"относительным": [29],
"начинаете": [29],
"очень": [[17,20],[9,10,13,15,26,29,30]],
"примеров": [[17,24,26],[31,32]],
"запустит": [17],
"dhttp.proxyport": [17],
"какой": [[13,19,26]],
"какую-нибудь": [16],
"trado": [16,32],
"википедии": [30],
"термин": [16,31,[5,10,18,30,32]],
"каков": [19],
"участия": [29],
"образованы": [3],
"subrip": [14],
"этому": [[12,15,17,21]],
"вводя": [16],
"письмо": [9,14],
"score": [30],
"кодировок": [12],
"пакета": [17,[13,16]],
"пригодности": [7],
"подразумевает": [[10,28]],
"пакете": [13],
"правом": [30],
"прекращает": [24],
"правой": [2,[17,30],[1,16,20,27,28]],
"одну": [5,[13,15]],
"процентами": [[29,30]],
"содержимое": [2,[12,29],[13,16,30],[1,11,15,17,18,20,21,22,28]],
"ipk": [6],
"под": [17,15,[11,13,21]],
"таким": [17,[28,29,30],[10,13,14,16,21,27]],
"скриптов": [1],
"одно": [5,12],
"одни": [21],
"таких": [[14,15,22,23,25,30]],
"человек": [2],
"указателем": [10],
"одна": [15,[17,20,24]],
"заметьте": [[17,29],19,[2,23,27],[5,13,16,25]],
"немного": [[13,30]],
"содержание": [10,[30,31],14],
"отказаться": [15],
"использованием": [2,[31,32]],
"такие": [[10,15,29],[12,14,28]],
"задания": [25],
"сложности": [30],
"относятся": [[15,29]],
"contemporari": [11],
"solari": [17,13],
"предложено": [17],
"валлийский": [6],
"размещения": [2],
"пор": [4],
"месторасположение": [17],
"простоты": [2],
"aar": [6],
"конфиденциальности": [17],
"переключится": [20],
"своей": [18],
"информационные": [20],
"выведет": [[17,25]],
"итальянский": [6],
"весьма": [[13,16,26]],
"охвата": [19],
"записанными": [23],
"abc": [24],
"отсутствующими": [30],
"пропускать": [12],
"при": [30,[15,17,29],21,28,[2,13,14,20,25],12,[16,19,23,24],[10,26,27],31],
"данных": [21,[1,32],[10,13,16,17,23,30,31]],
"пользователями": [18],
"abk": [6],
"точного": [16],
"конечного": [15],
"находит": [[0,10,29]],
"письма": [14,32,[5,20,21]],
"опытных": [[10,21,24,29]],
"представлено": [[10,18]],
"главным": [1],
"svn-клиент": [2],
"встречающиеся": [10],
"данный": [[10,17],[12,15,21,30]],
"стоило": [26],
"популярными": [29],
"словарями": [[11,32],[10,27,31]],
"главный": [29,32],
"данные": [30,2,[16,19,21,29]],
"пропустили": [16],
"месторасположения": [20],
"также": [32,17,[20,29],[10,14,30],13,[1,2,3,12,16,21,24,28],[0,4,8,11,15,18,26,31]],
"представлена": [30,[13,15,29]],
"опытные": [17],
"появиться": [[8,17]],
"усердием": [4],
"чём": [13],
"одной": [[15,29],[2,19]],
"isl": [6],
"одном": [32,14,[2,16,25]],
"iso": [6,32,22,31,[5,10,16,21,26,29]],
"субтитров": [14],
"блока": [24],
"абзацы": [[12,14]],
"кодировку": [22,12,14],
"log.txt": [15],
"снова": [[12,15,17]],
"zul": [6],
"кодировки": [12,32,[10,16,22]],
"наконец": [[4,17,19]],
"glossary.txt": [16],
"ita": [6],
"кодировке": [22,[12,16]],
"finish": [2],
"кодировка": [12,32,[16,22],[30,31]],
"упрощение": [[14,15,30]],
"правки": [[17,26]],
"add": [2],
"собрали": [30],
"неактивных": [1],
"правка": [20,32,[8,31],30,[18,28]],
"выводится": [17,21],
"размещать": [2],
"представляет": [30,[13,15]],
"серьёзные": [26],
"кванторы": [24,31],
"себя": [[4,7,13,16,19]],
"разделённого": [16],
"языки": [32,[19,29],[1,6,14,31],[5,10,21,22,23,26]],
"флажков": [20],
"неполный": [29],
"языку": [4],
"поддержке": [4],
"структурированными": [16],
"именем": [17,12,[13,16,18,21,27,29]],
"поддержка": [[9,32]],
"один": [29,[15,24],2,17,[5,10,20,21,30],[11,12,13,16,18,26]],
"угодно": [13],
"себе": [[4,12]],
"завершено": [2],
"untar": [11],
"количеством": [30],
"benjamin": [7],
"поддержку": [1],
"кавычки": [16],
"плюшки": [17],
"подробную": [[13,19],[17,24,28,30]],
"filters.conf": [21,17],
"колчиства": [4],
"циклически": [20],
"бенгальский": [6],
"svg-файлы": [17],
"xml-файл": [13],
"завершена": [21],
"modifi": [8],
"ставьте": [17],
"класс": [1],
"говорит": [29],
"индонезийский": [6],
"объектной": [1],
"улучшенной": [1],
"afr": [6],
"найдутся": [29],
"выписать": [12],
"собраны": [10],
"уникальности": [30],
"pgdn": [5],
"saboga": [7],
"targetlanguag": [12],
"directori": [2],
"свойств": [29],
"южный": [6],
"конкретного": [7,[13,23,26,29]],
"качества": [19,14],
"списка": [12,[1,13,19,27]],
"словаря": [11,27,[10,31]],
"системах": [20,25],
"properti": [[17,21,32],[12,14]],
"хранить": [[14,27]],
"качестве": [17,[10,21],[3,16,24,27,28,29]],
"fisher": [3],
"сполски": [9],
"хранящихся": [[2,29]],
"цикле": [8],
"number": [[28,30]],
"качество": [[19,29],14],
"повторениями": [30],
"допускается": [8],
"simpledateformat": [12],
"чёткого": [22],
"системам": [17],
"словарь": [27,[11,13]],
"вставляет": [20,5],
"операционной": [17,12,[13,20,22]],
"вариантов": [30,29,32,[20,28]],
"платформой": [24],
"удачно": [30],
"аймара": [6],
"показываемый": [30],
"словари": [32,[11,27],[13,30,31],[10,16,24]],
"надежде": [7],
"script": [1,[13,32],[0,9,10,28]],
"курсивом": [12],
"вариантом": [19],
"возымеет": [30],
"будут": [17,12,[20,29],[13,16,21,23,25],[15,26,30],[2,18,24],[5,8,19]],
"учитывались": [30],
"убрав": [12],
"system": [2],
"мегабайтах": [17],
"spellcheck": [27],
"проводиться": [16],
"указывающий": [17],
"устанавливается": [17],
"списки": [[13,16]],
"списке": [12,[9,18,24,29]],
"затенять": [20],
"диалекта": [27],
"двуязычного": [10],
"существуют": [26,[13,14,17]],
"other": [30],
"прикрепляйте": [9],
"нужны": [21],
"нужно": [17,[13,14,21],12,26,[9,15],[24,29],[1,2,11,18,20,22,28,30]],
"серьёзную": [23],
"базами": [16],
"одним": [[2,16,17,25,29]],
"зафиксированы": [2],
"любые": [15,[5,12,17,24,29]],
"оформления": [15],
"взглянуть": [18],
"local": [[2,9,14,17]],
"программист": [1],
"сообщает": [[17,30]],
"locat": [17],
"группа": [15,24],
"любых": [21],
"нужна": [29],
"известен": [[1,17]],
"пропущенные": [0],
"литовский": [6],
"изъясняетесь": [21],
"группу": [15],
"группой": [15],
"пользовательского": [17,32],
"всём": [30],
"скопируйте": [29,17,[1,15,21]],
"отправлен": [20],
"поиском": [[0,10]],
"такими": [[15,19]],
"клавиатуры": [16],
"заполнялось": [28],
"официальное": [31],
"запускаете": [17],
"кодирование": [20],
"aka": [6],
"удачным": [19],
"используется": [30,20,8,10,[1,3,12,13,14,18,23,26,29]],
"группы": [15,32,[30,31]],
"менять": [[14,23]],
"рунди": [6],
"логов": [9],
"отслеживать": [[2,10]],
"подробной": [30,23,[14,19,25,26]],
"сглаживание": [17,32],
"es_mx.aff": [27],
"случаев": [[2,22,24]],
"огромное": [4],
"подробное": [18],
"mode": [17,21],
"rightclick": [16],
"баскский": [6],
"выделите": [17],
"повторения": [30],
"бихарский": [6],
"toolsshowstatisticsstandardmenuitem": [8],
"лингвистическими": [19],
"конфигурации": [21,17,[0,12]],
"комбинирование": [32,14],
"сегмент": [20,15,30,26,8,[5,12,28,29],[2,18,21,23,32]],
"read": [12],
"umarov": [7],
"начинающиеся": [24],
"чжуанский": [6],
"alt": [5,[1,8,17]],
"сжаты": [29],
"занижаться": [29],
"любую": [7,13],
"вверх": [26,5],
"машинного": [19,30,20,32,10],
"созданная": [13],
"стратегии": [[28,29]],
"unit": [29],
"повторений": [[20,30]],
"конфигурация": [30],
"вставлены": [20],
"старту": [17],
"углу": [30],
"сжатие": [32],
"назад": [20,[8,30]],
"wildrich": [7],
"pinfo.list": [19],
"отражают": [15],
"список": [[31,32],[6,9,10,20],[13,19,21,26,29],[0,5,12,14,17,18,25,30]],
"amh": [6],
"collect": [[16,30,32]],
"предыдущими": [13],
"unix": [20],
"возможные": [16,14,[2,8,31,32]],
"повторение": [[15,32]],
"знаком": [16],
"восьмеричным": [24],
"главном": [29,[12,26,30]],
"сборку": [17],
"завершит": [[17,21]],
"задаётся": [29],
"roh": [6],
"знаков": [17,30],
"позволяющие": [25],
"сборки": [[17,21]],
"нашем": [[2,29]],
"абхазский": [6],
"ron": [6],
"афарский": [6],
"сборка": [[17,32],31],
"работаете": [10],
"and": [[8,17],[9,12,13,16,19,21,30]],
"сохранять": [15,[2,12,16,28]],
"главной": [29,[13,14]],
"осуществляется": [26,[9,13,14,19,27]],
"именно": [[14,17,23,26,28]],
"главное": [32,30,31,20,10,[8,21]],
"обновлённая": [2],
"ani": [8],
"объектно-ориентированного": [1],
"вставлен": [[19,29,30]],
"диалогового": [22,[1,26]],
"ant": [17],
"нарушается": [0],
"проверку": [15,20,[17,27]],
"потребоваться": [[14,21]],
"арагонский": [6],
"курсив": [15],
"ввода": [14,[18,25,30]],
"укажете": [23],
"зафиксировать": [2],
"разобрался": [4],
"вновь": [16],
"сменить": [8,20,22],
"спросите": [18],
"применяются": [26,[2,15]],
"освоиться": [21],
"сообщить": [22],
"jnlp": [17],
"минутах": [20],
"приводит": [[1,15]],
"распознает": [22,2],
"omegat.ex": [17],
"ключевых": [30,1],
"просматривать": [30,[11,14]],
"изображением": [[18,20]],
"варианты": [30,[2,10,12,14,19,28,29]],
"sourcetext": [30],
"указаны": [30],
"переводится": [[20,21]],
"жёлтым": [[20,30]],
"ищутся": [30],
"обновляются": [[17,29]],
"ключевые": [25],
"нечёткого": [28],
"подписка": [13,17],
"абзац": [12],
"english": [11],
"ключевым": [25],
"jar": [17,21,13,29],
"api": [19,17],
"глаголов": [19],
"jav": [6],
"editselectfuzzy2menuitem": [8],
"оставляет": [12],
"app": [17],
"отражать": [13],
"курсор": [5,26,0],
"башкирский": [6],
"друг": [[2,10,30]],
"каталогу": [2,29],
"нумеровали": [29],
"аналогично": [30],
"заменой": [29],
"alex": [7],
"грамматики": [0],
"каталога": [2,29,[17,30],[1,25],[0,3,11,13,16]],
"каталоге": [17,21,29,13,2,[0,3,11,16,20,25,30]],
"являются": [15,[11,19,29,30]],
"можно": [17,30,29,14,[16,18,21],[10,15],[2,13],[12,28],[19,23,24,25],[1,26,27],[9,11],[3,8]],
"каталоги": [32,29,[2,13],[12,14,20,31]],
"мальдивский": [6],
"строчными": [25],
"альтернативный": [[14,30]],
"вычитка": [4],
"появился": [2],
"латинский": [6],
"первая": [[15,17]],
"причинам": [[16,27]],
"одинаковыми": [[11,15,29]],
"read.m": [12],
"ara": [6],
"консольном": [17],
"синхронизированы": [2],
"мужской": [3],
"корректными": [19],
"вчерашний": [29],
"необходима": [17],
"альтернативных": [29],
"раз": [24,[2,29],[26,30]],
"arg": [6],
"taken": [8],
"префикс": [28],
"старую": [0],
"люксембургский": [6],
"where": [[8,28]],
"paypal": [9],
"бесплатного": [2],
"редактора": [25],
"необходимо": [[14,17,27],19,[4,10,18,21,29,30]],
"art": [27],
"лаосский": [6],
"некорректные": [29],
"версию": [7,17,[0,2,3,9,21]],
"синхронизировано": [2],
"командой": [29],
"версия": [17,[0,2,3,14,19,29]],
"интернет": [[17,27]],
"стёрты": [15],
"редакторе": [[14,16,22,25]],
"vmoption": [17],
"jdk": [17],
"выделить": [8,20,30,[5,12,17,25,32]],
"обычно": [[15,17],14,[10,11,13,20,21]],
"обозначает": [15],
"версии": [17,[2,4,29],[13,15,16,19,27,30]],
"варианта": [[4,17,30]],
"хранения": [10],
"версий": [[19,29]],
"asm": [6],
"текстовыми": [22,[10,15,26,28,31,32]],
"необходимы": [[13,15]],
"сложные": [[10,24]],
"библиотеки": [1],
"работе": [20,[13,23,30]],
"переводами": [29,[19,31,32]],
"возникающие": [[13,32]],
"выполнение": [[17,21]],
"run": [25,6],
"системными": [8],
"работу": [[4,21,29],[17,23]],
"rus": [6],
"рекомендуем": [14],
"какие-либо": [17,18],
"адрес": [9,[2,30]],
"отношения": [[15,18]],
"представить": [4],
"клиентские": [2],
"компьютер": [[2,20,22]],
"отношению": [[4,29,30]],
"работа": [32,[2,31],[15,22],10,[17,20,21,28,29]],
"превосходная": [3],
"titlecasemenuitem": [8],
"главному": [[2,20]],
"editcreateglossaryentrymenuitem": [8],
"словарных": [30],
"собираются": [29],
"ital": [15],
"необходим": [[15,17]],
"адекватные": [26],
"указали": [[25,27]],
"bold": [15],
"столбцов": [16,[15,30]],
"отобразить": [30],
"интерфейс": [17,[10,21,30],[9,13,20,31,32]],
"скрипт": [1,17],
"словарные": [30],
"работы": [2,[10,13,24],[21,26],[15,17,23,29,30,32],[12,18,19,20,31]],
"сети": [2],
"параметр": [17,21,[20,32]],
"жёстком": [[27,29]],
"name": [12],
"автор": [30,[7,20]],
"старый": [20],
"контекстное": [[20,27,30]],
"должным": [2],
"сформулированы": [17],
"старые": [29],
"содержимому": [2],
"недостаточно": [19],
"будущих": [[2,18]],
"экрана": [9],
"целостности": [10],
"внести": [[12,16,25]],
"android": [14],
"гуарани": [6],
"выпадающем": [23],
"случаях": [26,[14,29],[15,16,19,21,23]],
"материалы": [[2,20]],
"ava": [6],
"синхронизировать": [[2,29]],
"участника": [2],
"ave": [6],
"целостность": [13],
"снять": [29],
"любому": [25,[12,26]],
"аналогичен": [[20,25,30]],
"данными": [19],
"расширяющегося": [19],
"старше": [21],
"двойным": [13],
"указывать": [[17,21,27]],
"указана": [12],
"множественное": [3],
"свободных": [[1,27]],
"pgup": [5],
"включая": [13,[12,25,29,30]],
"процедуре": [29],
"множественном": [[3,16]],
"материала": [10],
"двумя": [17,[21,26,27,29]],
"пространство": [30],
"target": [13,[1,18,20,32],[2,16,29]],
"свободным": [7],
"вашего": [18,29,20,17,[10,13,16,21,27,30]],
"рассматриваться": [30],
"современный": [6],
"указано": [[12,30]],
"обнаружится": [29],
"fabián": [7],
"config-dir": [17,21],
"отношении": [13],
"словарной": [16],
"зависит": [[14,17,19],[13,29]],
"свободной": [[7,31]],
"может": [29,15,30,23,[2,13,14],[16,17,21,26],[1,10,22],[0,8,12,18,20,27,28]],
"внутри": [5,[15,18],[13,16,20,23,30]],
"объектом": [1],
"благодарны": [9],
"расположением": [14],
"дадим": [2],
"больше": [[17,24],[21,23,25,29,30]],
"снят": [26,20],
"www.netrexx.org": [1],
"сложной": [13],
"подразумевают": [17],
"включал": [19],
"внутрь": [15],
"отделяются": [16],
"сложном": [14],
"перенаправит": [13],
"связанные": [30],
"item": [8],
"церковнославянский": [6],
"интенсивно": [30],
"pdf-файлах": [[20,23]],
"трёх": [29,15,[13,16,28,30]],
"распространяется": [7],
"порядке": [[15,25],[26,29]],
"связанных": [15,[14,18]],
"targettext": [30],
"создав": [2],
"объектов": [26],
"aym": [6],
"времени": [12],
"экспортируется": [20],
"совета": [18],
"характерные": [25],
"создан": [17,16],
"файлах": [[25,29],[10,12,14,17,20,30],[0,15,16,21,28]],
"исходными": [[12,13]],
"языка": [27,[12,17,26],3,[14,24,29],[0,6,20,21,25]],
"aaabbb": [24],
"языке": [[22,30],[16,17,19,21,25,27,29],[1,2,3,13,14]],
"aze": [6],
"compil": [14],
"старых": [[10,23]],
"структурой": [13],
"конечные": [19],
"названия": [12,15,[14,19,32]],
"edittagpaintermenuitem": [8],
"названию": [27],
"типы": [14],
"откроет": [[13,30]],
"советы": [32,[15,27,31]],
"переименован": [29],
"найдено": [[16,29,30]],
"агентства": [10],
"хорошо": [29,1],
"системой": [[2,21,22]],
"справа": [14,32,26,[5,17,20,31]],
"viewmarknbspcheckboxmenuitem": [8],
"unicod": [22],
"файлам": [[15,25],[22,30]],
"такой": [[22,28,29]],
"указывает": [17,21,30],
"клиентская": [2],
"такое": [[20,23]],
"типа": [14,[12,17,26]],
"найдены": [[4,17,21,25,30]],
"облегчить": [10],
"зависимости": [20,30,29,[13,15,17,28]],
"таком": [29],
"влияет": [[5,14]],
"платформ": [17],
"содержимого": [12,[1,30]],
"используются": [19,[3,10,13,15,20,24,27,30]],
"en-us": [29],
"операционная": [12],
"выделяется": [[12,17]],
"формате": [[12,14,16],[11,17,21,22,29]],
"возникнут": [21],
"благодаря": [[2,4,17]],
"формата": [[14,16]],
"одиночными": [15],
"истории": [20],
"расширениями": [11],
"выключать": [20],
"процессор": [30],
"фоне": [30],
"игбо": [6],
"msgstr": [12],
"процессом": [13],
"некорректной": [30],
"некорректном": [29],
"наиболее": [30,[10,22,28,29]],
"передний": [20],
"указать": [17,[21,29],[12,13,14,19,23,26,27,30]],
"katarn": [7],
"соглашение": [17],
"содержать": [[29,30],[8,27,28]],
"аннотация": [31],
"щёлкнете": [30],
"распознавать": [28],
"untransl": [28],
"соединения": [10],
"знака": [[8,17,24,26]],
"опции": [[12,25]],
"обычными": [[2,15]],
"небольшие": [[10,26,30]],
"главная": [13,32],
"панели": [17,1],
"обновления": [[17,20]],
"фиолетовым": [20],
"программами": [29],
"македонский": [6],
"autopropag": [23],
"похож": [29],
"конечный": [10],
"обрабатывать": [12,29],
"omegat.project": [[2,13,32]],
"небольших": [10],
"панель": [17],
"targetcountrycod": [12],
"опция": [[20,23,30]],
"обновление": [32,17,29,[16,31]],
"предложениям": [26,23,[10,12,32]],
"пред": [[0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,32]],
"название": [[2,6,12,26,30]],
"редко": [10],
"технически": [12],
"какого": [19],
"текстовых": [14,[10,12,16,22,26]],
"оригиналом": [29],
"переводите": [21,[27,28,30]],
"разбиение": [14,30],
"соединение": [17],
"имя_проекта-level1": [[13,29]],
"webstart": [17],
"имя_проекта-level2": [[13,29]],
"insert": [28],
"лицензионное": [17],
"highlight": [16],
"текстовые": [32,14,12,22,[10,16,28]],
"поставьте": [[12,28]],
"порядка": [29],
"первое": [20,[8,30]],
"свободную": [10],
"сталкиваться": [13],
"типичный": [29],
"sag": [6],
"messag": [2],
"типичных": [17],
"моделью": [1],
"текстовый": [[12,13,14,16,17,20,22]],
"subvers": [2,32],
"отобразит": [18],
"san": [6],
"заменит": [20],
"применим": [25],
"местах": [[17,29]],
"подходит": [30,[20,26]],
"род": [3],
"основываясь": [17,[10,12,27]],
"форматы": [32,14,31,16,[12,30]],
"создавайте": [[14,21]],
"предпочтительного": [17],
"вышеприведённого": [22],
"jpn": [6],
"also": [[0,17]],
"постоянно": [[14,30]],
"размещён": [17,21],
"resx": [14],
"курдский": [6],
"differ": [30],
"этого": [17,21,[12,29],[2,5,13,14,15,26],[1,4,10,16,18,19,20,23,28,30]],
"переводить": [12,[14,30],[10,17,18,28,29]],
"своих": [30],
"жёсткие": [29],
"уважаемому": [4],
"переведены": [29,[13,17],[19,28,30]],
"откройте": [[17,18,29],[12,13,14,21,22,23,25]],
"принципу": [24],
"переведено": [30],
"a123456789b123456789c123456789d12345678": [17],
"viewmarkwhitespacecheckboxmenuitem": [8],
"отсылать": [19],
"описано": [30,5],
"bad": [19],
"концевые": [12],
"подачи": [24],
"корректно": [[17,22],[0,14,16]],
"поведение": [29,[5,17],[12,28]],
"lucen": [32],
"знакомо": [25],
"bak": [[2,6,13]],
"ввод": [20,5,8,[14,15,17,28,30]],
"bam": [6],
"описаны": [20],
"частично": [[1,19,30]],
"убедитесь": [19,17,[2,11,14,27]],
"инуктитут": [6],
"менеджера": [13],
"финский": [6],
"jre": [17,13],
"менеджере": [[13,27]],
"любая": [[13,16,24]],
"optionsfontselectionmenuitem": [8],
"работают": [[10,24,26]],
"posit": [16],
"перезапустите": [8],
"должно": [[16,26],[2,9,17,20,21,23,28]],
"автоматически": [[16,17],[2,29],[12,21,22,23,27,30],[3,10,13,14,15,18,20,25,28]],
"полный": [[8,13,17,30]],
"задать": [17,16,[13,14,20,25,26,28,29]],
"оригиналу": [[28,30,32]],
"монгольский": [6],
"реализованы": [20],
"соответствует": [24,25,26,[12,27],[13,23,29,30]],
"отмечены": [[15,30]],
"текстовом": [[16,22]],
"графическим": [[17,21]],
"кечуа": [6],
"должны": [2,[8,20,27],[12,14,16,17,28,29]],
"оригинала": [[18,20],30,15,25,14,[8,23,28,29],[12,13,16,22,32]],
"переднем": [20],
"корректны": [29],
"aaron": [7],
"флажок": [23,[12,20],26,[19,28],[27,29],[0,2,15,17,25]],
"считаете": [[13,23]],
"настройки": [12,13,17,[21,23],20,[30,32],[14,18,22],[1,2,15,25,26,27,29,31]],
"хиримоту": [6],
"оригинале": [30,18],
"добиться": [14],
"полным": [17],
"показывать": [8,20],
"вплоть": [5,24],
"ошибок": [15,[0,14,18,21,28,30]],
"средство": [[17,21]],
"применять": [29],
"freebsd": [[13,24]],
"rexx": [1],
"любви": [4],
"delet": [5],
"иллюстрации": [30,[2,19,27],[0,11,13]],
"модификатор": [8],
"расположено": [[20,30]],
"русские": [17],
"реализована": [[2,19]],
"обращаться": [[10,15]],
"настоятельно": [14],
"повторяет": [20],
"vito": [[7,31]],
"должна": [[2,8,12,17,26,27]],
"выбирается": [20,[17,30]],
"мета-теги": [12],
"статистические": [[19,30]],
"означает": [[2,5,14,29]],
"русский": [17,[6,29]],
"seq": [16],
"реализовано": [30],
"developerwork": [17],
"иллюстрация": [32],
"set": [[13,17,21]],
"небольшой": [[2,10]],
"n.n_windows_without_jr": [17],
"время": [30,[14,17,18,21],[1,10,15,16,20,26,27,29]],
"поведения": [[10,30]],
"optionsrestoreguimenuitem": [8],
"сохранности": [21],
"отменить": [20,8],
"перезаписывает": [20],
"средства": [10],
"иллюстраций": [31],
"косой": [17],
"ранее": [20,16,[10,17,18,26,29,30]],
"интернет-страницы": [30],
"нижеприведённый": [1],
"щелчками": [16],
"мышкой": [17,13],
"небольшом": [5],
"проект2": [2],
"проект1": [2],
"резервируется": [17],
"fleurk": [7],
"как-нибудь": [29],
"появится": [[2,30],[1,18,20,25,26]],
"содержали": [21],
"точное": [20,[8,15]],
"offic": [15,12],
"terminolog": [[16,32]],
"разному": [30],
"корней": [3],
"армянский": [6],
"bel": [6],
"ben": [6],
"появляется": [2],
"оригинальном": [28],
"прокта": [32],
"веб-браузер": [1],
"подсчёте": [30],
"projectsavemenuitem": [8],
"боснийский": [6],
"выходите": [20],
"увидеть": [[11,18]],
"получения": [19],
"точном": [25],
"joel": [9],
"эффективно": [29],
"задачи": [30],
"контекста": [[20,30]],
"контексте": [15],
"порядок": [[15,26,30]],
"устанавливать": [2],
"предотвращает": [13],
"упрощённого": [10],
"pptx": [14],
"описать": [26],
"расположены": [20],
"разбивается": [15],
"cursor": [16],
"знающая": [29],
"появляющемся": [28],
"обязательно": [13,16],
"оценке": [15],
"вводный": [4],
"оценки": [30],
"идо": [6],
"сопоставляет": [12],
"графический": [21,17],
"задавать": [[10,13,28]],
"вышеупомянутых": [16],
"sin": [6],
"статуса": [30],
"завершён": [30],
"приоритет": [26,32,[13,31]],
"нескольких": [30,31,[12,13,14,16,25,32]],
"русский-белорусский": [19],
"добавления": [[8,12]],
"союзом": [29],
"заменён": [[19,20]],
"сочетает": [1],
"одного": [2,8],
"где-то-что-то": [13],
"сото": [6],
"вашем": [17,30,[2,18,21,27,29]],
"tiago": [7],
"раздражают": [15],
"вышеупомянутые": [17],
"момент": [19,[10,12,15,29,30]],
"произведён": [25],
"обсудить": [30],
"активирована": [20],
"удаления": [[15,29]],
"маловероятна": [16],
"прокси": [[17,20],[8,32]],
"текстовую": [29,1],
"выражениях": [[25,26]],
"удаление": [15,32],
"помимо": [[11,16,17]],
"расширением": [12,16,[2,11,13,22,29]],
"сможет": [29,3],
"вашей": [17,[2,12,13,19,20,23,25]],
"добавление": [17,[2,26,30,32]],
"переводила": [12],
"ндунга": [6],
"foundat": [7],
"выше": [30,29,17,[11,13,20,25],[0,5,12,14,15,19,22,24,27]],
"ассамский": [6],
"bih": [6],
"обновлённых": [32],
"хранящиеся": [29],
"bin": [13],
"двунаправленный": [14],
"человеком": [19],
"поставляется": [[0,3,13]],
"среди": [[10,13]],
"apertium": [19,32,31],
"bis": [[6,24]],
"различающихся": [19],
"малайский": [6],
"русском": [22],
"projectopenmenuitem": [8],
"autom": [17],
"внешнюю": [29],
"русской": [17],
"похожие": [30],
"бретонский": [6],
"возле": [[12,30]],
"стандартного": [20],
"приведена": [17],
"каталог-репозиторий": [29],
"написания": [19,[15,27]],
"toolsvalidatetagsmenuitem": [8],
"названные": [11],
"начальном": [[2,30]],
"утилита": [17],
"далее": [17,12,[2,11,15,16,23]],
"должен": [2,[15,16],[8,21,26,28,29]],
"типами": [14],
"slk": [6],
"электронную": [30],
"документ": [[1,14],12,[15,21,30,31]],
"написание": [25],
"отвечает": [19],
"john": [7],
"приведены": [[20,24]],
"конфликты": [2],
"slv": [6],
"расчёты": [30],
"налево": [14,32,[5,31]],
"viewmarktranslatedsegmentscheckboxmenuitem": [8],
"операции": [32,15,31],
"повторный": [17],
"большинства": [[8,26]],
"обрабатывается": [[14,17]],
"sme": [6],
"каретки": [24],
"работать": [[10,18],[0,2,4,7,14,17,22,27,29,31]],
"сказано": [14],
"навести": [0],
"переводческих": [14],
"похожей": [[28,30]],
"smo": [6],
"большинстве": [[2,14,22,23]],
"построения": [19],
"провести": [17],
"операция": [2],
"приведённого": [12],
"большинство": [22,[13,20]],
"переводческий": [13],
"моменты": [10],
"pojavni": [16],
"этим": [12,[10,16,19,20]],
"переводческие": [10],
"распространять": [7,13],
"прямом": [23],
"подменю": [17],
"номеру": [[20,30]],
"использует": [[10,12,21,29],[14,17,19,27]],
"авестийский": [6],
"break": [26],
"этих": [29,[17,30],[5,10,13,16,18,19,22,28]],
"editselectfuzzy1menuitem": [8],
"уникальными": [30],
"sna": [6],
"большинству": [12],
"пробелу": [26],
"момента": [29],
"snd": [6],
"прямое": [12],
"ограничить": [25],
"отображены": [[16,17]],
"didier": [[4,7]],
"выполнения": [[1,25,30]],
"обзора": [17],
"пустой": [[2,28],30],
"hide": [12],
"внешняя": [15],
"эквивалентных": [29],
"существующего": [20,16],
"пробелы": [[8,12,20,24],[16,30]],
"производится": [[5,17,21,25,29]],
"auto": [29,[22,32],12],
"фраз": [10],
"или": [20,29,[17,24,30],13,12,[18,25],[7,8,10,15],[9,14,26],[1,2,16,21,28],11,[3,23],27],
"notepad": [16],
"document.xx.docx": [12],
"благодарности": [4,[7,10,31,32]],
"совпали": [28],
"электронное": [9],
"som": [6],
"oracl": [17,8,12],
"включить": [[12,20,23,27,28,32]],
"благодарность": [4],
"пробела": [[10,26]],
"sot": [6],
"использованию": [11],
"графическое": [[17,21]],
"использования": [[24,32],31,[17,19,20,27]],
"сегментация": [26,32,23,10,[12,30],[8,15,20,24,25,29,31]],
"обширным": [10],
"переводческом": [29],
"сегментацию": [23,[10,26,29,32]],
"переводческой": [30],
"испробовали": [14],
"представляют": [15,[13,14,29]],
"spa": [6],
"сегментации": [26,23,32,[13,14],[10,15,20,24,29,30],31],
"правильного": [[11,14,27]],
"покажет": [25,[17,20,22]],
"level": [26],
"отключена": [12],
"затем": [17,[14,19,27,29],[2,8,15,16,18,23,25,26,28,30]],
"разместить": [[9,30]],
"загрузится": [17],
"скриптами": [28],
"создаваемые": [29],
"ошибку": [[9,15,23,30]],
"флажка": [23],
"bod": [6],
"режимов": [14],
"флажке": [12],
"игнорируется": [15],
"имеющийся": [16],
"создаваемый": [26],
"расставить": [14],
"ошибки": [30,[0,21],[9,10,15,17],[4,13]],
"ошибке": [9,29,13],
"регулярное": [15,17,[21,24],[10,25]],
"правильной": [15],
"означать": [30],
"копируется": [[20,29]],
"отделить": [29],
"правильном": [11],
"bos": [6],
"ошибка": [[17,29,30]],
"заменяет": [20],
"sqi": [6],
"box": [23],
"вопрос": [2],
"вячеславу": [29],
"косая": [24],
"fouri": [7],
"расчёта": [30],
"расчёте": [30],
"переход": [20,[8,30,31,32],[18,28]],
"kal": [6],
"преобразователи": [19],
"kan": [6],
"пояснение": [[0,17,21]],
"имя": [12,17,[29,30],21,[13,16,20,32],[2,18,23]],
"датский": [6],
"kas": [6],
"thoma": [7],
"конечном": [12],
"kau": [6],
"задаёт": [17],
"kat": [6],
"репозиторием": [2],
"br1": [15],
"присутствовать": [23],
"srd": [6],
"kaz": [6],
"лексическое": [19],
"пользователя": [17,13,[21,30],[31,32],[9,10,12,20],[2,7,8,15,18,19,23,28,29]],
"потеряли": [[21,29]],
"control": [20,[2,8]],
"группировке": [30],
"пользователь": [23,28,[2,8,9,13,19,20,30]],
"компании": [8],
"no-team": [[17,32]],
"чаморро": [6],
"пользователю": [20,[19,30]],
"использование": [32,31,29,17,16,27,[0,1,2,3,11,12,21,25,30],[5,10,14,20,26,28]],
"srp": [6],
"пользователи": [19,[17,20],[2,27,31,32]],
"включает": [[7,9,12,17,24,29]],
"подразумеваемой": [7],
"использовании": [[2,17,30],[21,22]],
"форматах": [[10,12,29]],
"нажав": [18,30,[1,12,17,28]],
"srt": [14],
"одному": [25,[12,20,24,29,30]],
"любого": [12],
"доступности": [19],
"точнее": [[12,17]],
"нажал": [28],
"фрагменты": [[9,10,26]],
"проблемам": [30],
"лицензия": [13],
"форматированный": [32,28],
"потребностями": [2],
"форматированным": [15,32,[10,14,20,22,29,31]],
"прототипно-ориентированный": [1],
"properties-файлы": [21],
"исполняемым": [17,13],
"представлять": [[11,13]],
"внимательно": [13],
"исполняемый": [17],
"введённый": [30],
"environ": [17,13],
"сохранена": [21],
"двух-буквенные": [29],
"сохранены": [29,[12,17]],
"перезагрузить": [[8,12,20,26,29]],
"распознаёт": [[22,29]],
"bre": [6],
"выбрали": [[17,28]],
"двух-буквенный": [29],
"ssw": [6],
"лицензии": [[7,13],20],
"наберите": [17],
"сам": [14],
"указанному": [27],
"запись": [20,[16,17]],
"ааа": [24],
"совместная": [2,[31,32]],
"почитать": [9],
"отсутствующие": [[20,30]],
"задаются": [13],
"креольский": [6],
"выбрана": [26],
"особыми": [14],
"kde": [17,32],
"переходе": [[19,28]],
"записи": [16,17,[2,8,9,15,19,25,31,32]],
"выполнен": [17],
"назначьте": [29],
"перехода": [[18,20],8],
"форматированных": [[10,14]],
"переключает": [14],
"дать": [16],
"sub": [16],
"нужен": [[17,21]],
"painless": [9],
"заменяются": [20],
"действовать": [23],
"смысл": [27],
"переключиться": [[14,23,25]],
"введя": [[17,30]],
"правах": [20],
"languag": [[1,17]],
"подчиняется": [26],
"уметь": [2],
"sun": [6],
"произошла": [17],
"возможных": [[14,15,17,28,29]],
"правам": [17],
"инупиак": [6],
"отсоединили": [20],
"пукта": [28],
"известно": [29],
"дата": [30],
"внешние": [30,[8,13,20]],
"существует": [[13,14,16],[22,24,28,30]],
"де-факто": [30],
"суффиксы": [3],
"сохранения": [[8,12,16,22,29]],
"зависят": [0],
"key": [8,17],
"показывает": [20,30,[10,12,15]],
"пары": [[15,19],[0,2,11,12,21,29,30,32]],
"даст": [29],
"трёх-буквенные": [29],
"svn": [2,32,[17,29,31]],
"эквивалентную": [13],
"launch": [17],
"функций": [[18,20]],
"пару": [19],
"созданных": [20],
"функции": [28,[10,20,24,27,30]],
"используют": [12],
"внесите": [13],
"произошли": [2],
"bug": [9],
"bul": [6],
"куда": [[15,17,21]],
"созданные": [[10,13,16,18,28,29]],
"swa": [6],
"здесь": [[13,15,30],[2,23,25]],
"созданный": [29,[2,13,15,20]],
"произошло": [9],
"пара": [15,12,30],
"swe": [6],
"выражениями": [[24,32],31],
"причине": [13],
"стабильное": [21],
"express": [[12,24,25]],
"фильтром": [12],
"воспроизведения": [9],
"присутствовали": [15],
"услуги": [19],
"бесплатной": [2],
"текстовая": [29],
"противном": [[15,20,29]],
"причины": [16],
"диалоги": [32,30,31],
"variant": [29],
"диалогов": [30],
"называется": [[10,17]],
"выравнивание": [14,[21,32],31],
"диалогу": [20],
"введение": [31,10,[0,1,2,3,19,32],18],
"gotoprevioussegmentmenuitem": [8],
"располагаются": [25],
"называются": [26],
"отдать": [17],
"переменная": [17],
"помните": [[15,29],23],
"пригодиться": [17],
"gotopreviousnotemenuitem": [8],
"ядром": [19],
"подходят": [[21,29,30]],
"словами": [[15,24]],
"сервисами": [30],
"добавьте": [[2,8,17,22]],
"editredomenuitem": [8],
"uilayout.xml": [13],
"khm": [6],
"отображалось": [[14,17]],
"пунктах": [8],
"xml-файлы": [[12,19]],
"выравнивания": [14],
"помечать": [28],
"фильтров": [12,23,13,[2,10,22,31,32]],
"окружающий": [15],
"путём": [17,30],
"строкам": [12,26],
"полях": [16],
"learned_word": [32],
"отменённое": [20],
"сохранениями": [20],
"выделяются": [18],
"kik": [6],
"комментариев": [30,32,[16,29,31]],
"kim": [7],
"иероглифов": [22],
"kin": [6],
"kir": [6],
"условное": [30],
"lakunza": [7],
"каталогов": [13,[30,32]],
"другу": [2],
"подходящая": [17],
"свойства": [32,23,13,20,[12,16,31],[29,30],[3,8,10,11,18,26,27]],
"диалогом": [12],
"guido": [7],
"временем": [19],
"пользователем": [29],
"похожих": [10],
"пользователей": [17,32,31,[13,21,29],[2,9,10,12,14,18,24,30]],
"проверили": [18],
"следуют": [24],
"друга": [30],
"бесплатно": [17],
"взятыми": [1],
"идиш": [[6,19]],
"поддержать": [9],
"любое": [29,[17,18,25]],
"license.txt": [13],
"любой": [24,29,[12,13,16,17,21,30],1],
"исправления": [[15,30]],
"воспроизводится": [15],
"оригинальным": [17],
"оригинальный": [1],
"любом": [[25,29,30]],
"правильность": [26],
"runtim": [17,13],
"указание": [12],
"tester": [24,31],
"физически": [27],
"указании": [23],
"шестнадцатеричным": [24],
"комментария": [8],
"эффекта": [[28,30]],
"несовместимость": [[0,3]],
"пали": [6],
"точные": [[29,30],16],
"посредством": [12],
"объединить": [29],
"комментарии": [12,30,[16,32]],
"фиджи": [6],
"опубликованной": [7],
"комментарий": [16,17],
"отсылала": [19],
"восстанавливается": [19],
"filenam": [12],
"svn-сервера": [2],
"оказаться": [[12,13,24,26,29]],
"включён": [20],
"созданную": [29],
"извлеките": [11],
"roam": [13],
"сих": [4],
"глоссариями": [[16,32],[10,31]],
"компоненты": [20],
"between": [30],
"точных": [[29,30],20],
"пожелаете": [29],
"оставьте": [[2,26]],
"обязаны": [19],
"желаемое": [[15,20]],
"gotosegmentmenuitem": [8],
"ведётся": [10],
"magneto": [14],
"вроде": [[10,30]],
"точный": [[15,25]],
"своими": [20],
"осмысленные": [26],
"корректен": [29],
"заполнения": [17],
"сегментов": [30,29,20,25,10,[23,28],[1,8,14,17,21]],
"склоняемых": [3],
"xx_yy.tmx": [29],
"ресурсов": [[9,14]],
"осторожно": [[15,26]],
"сегментом": [[20,29],[5,15,30]],
"повторяемости": [30],
"распаковать": [17,[11,13]],
"ваших": [[10,18,21,29]],
"изменяете": [12],
"обновляется": [29],
"отчёты": [9],
"helpaboutmenuitem": [8],
"указаниям": [14],
"загружаются": [29],
"классы": [[24,31]],
"принтера": [24],
"задано": [21,17],
"комбинировать": [17],
"самоанский": [6],
"класса": [1],
"атрибута": [30],
"каких-либо": [17],
"например": [29,12,30,17,[14,16,26],[2,10,15,21,22,25,27],[20,24],[1,19,23],[3,11,13,18,28]],
"mandelbaum": [7],
"вашим": [[2,13,22,30]],
"правил": [26,23,[10,15,32],[13,19,24,29,30,31]],
"почаще": [21],
"разворачивает": [30],
"открывает": [20],
"leav": [28],
"полезен": [3],
"каталог-проекта": [21],
"привести": [[15,21,29,30]],
"regular": [[24,25]],
"повторяются": [30],
"подходящее": [17],
"выбрать": [8,[12,20,30],[17,27],23,[2,3,5,13,15,21]],
"c\'est": [16],
"лицензией": [7,[11,13]],
"игнорируются": [[15,30]],
"token": [[3,32],30,[0,2,10]],
"svn-серверу": [2],
"обозначающий": [2],
"правильный": [19],
"свежая": [6],
"которыми": [[12,29]],
"будем": [9],
"omegat.log": [13],
"правильным": [15],
"сохраняет": [20,[21,29],[18,30]],
"направлением": [32,14],
"будет": [17,12,[15,29],2,20,[16,18],[19,21,23,25],[27,30],[0,26,28],[7,13],[10,11,14,24]],
"менеджером": [27],
"создающейся": [30],
"начало": [5,[16,24],[0,1,2,3,4,6,7,8,9,10,11,12,13,14,15,17,18,19,20,21,22,23,25,26,27,28,29,30,32]],
"najlepših": [3],
"узбекский": [6],
"продолжена": [[17,21]],
"kom": [6],
"начале": [[13,17]],
"появилось": [17],
"корень": [3],
"kon": [6],
"полосу": [26],
"начала": [5,26,[2,12,21,29],[10,23,27,30]],
"kor": [6],
"выбранного": [[8,20,21,30]],
"экранирует": [24],
"tab": [16,20,8],
"plain": [22],
"самостоятельно": [13],
"tah": [6],
"tag": [14],
"временно": [30],
"tam": [6],
"полезно": [29,[12,30],[17,18,20,28]],
"tar": [13,17],
"маленькие": [12],
"приложением": [[16,27]],
"модели": [[1,19]],
"tat": [6],
"внешних": [[20,30]],
"onli": [12],
"полезна": [7,[10,20,23]],
"внешний": [17],
"документации": [8,[4,12,19,24]],
"способами": [17,[21,26,27]],
"projectreloadmenuitem": [8],
"документацию": [[7,10,30]],
"осознаете": [13],
"заменять": [12],
"документация": [7,32,[13,31]],
"формат": [[14,16],10,[1,8,18,19,28,32]],
"заданы": [29],
"атрибуты": [12,26],
"безопасности": [17],
"подходящий": [27,12],
"настройка": [32,31,8,30,[10,20,28],[5,7,9,12]],
"сегментирования": [23],
"даже": [17,[7,12,19,20,25,30]],
"sail": [19],
"элементы": [12,20],
"подходящим": [[26,29]],
"совместной": [2],
"нижеприведённом": [17],
"правилами": [17],
"схемами": [1],
"статистика": [32,30,13,[8,20,31]],
"редактируя": [28],
"winrar": [11],
"tbx": [16,32],
"отображен": [18],
"перемещаетесь": [30],
"конфиденциальной": [2],
"po-файлами": [29],
"can": [8,17],
"статистики": [30,32],
"средствами": [17],
"планируете": [[13,27]],
"cat": [3,[6,30]],
"статистику": [20,30],
"переключить": [14],
"пенджабский": [6],
"сможете": [13,30],
"duser.countri": [17],
"tcl": [28],
"provid": [30],
"повторное": [[29,32],31],
"информации": [[2,10,14,16,17,19,21]],
"сегментирование": [26],
"настройками": [[2,3,10,13,20,29]],
"уникальные": [[20,30],[8,23,25]],
"readm": [12,17],
"предотвращение": [[21,32],[10,23,31]],
"информация": [17,[13,29,30],[2,6,10,14,15,19,20,26]],
"уникальный": [15],
"пустым": [[12,26],[2,28,29,30,32]],
"элемента": [17],
"match": [28],
"помогла": [4],
"информацию": [13,[14,29],[17,19,30],[10,15,20,24,28]],
"уникальным": [19],
"информацией": [30,23,[14,25,26,29]],
"пустых": [8],
"ввести": [17,[15,16],[14,20,23,24]],
"одним_пробелом": [20],
"французского": [26],
"полужирным": [30,[20,25]],
"бесплатен": [19],
"уникальных": [30,20],
"полужирный": [[14,15]],
"typo3": [14],
"align.tmx": [17,21],
"пакеты": [17,[13,14]],
"вставлять": [14],
"проверить": [[20,29],[8,18,22,26,28,30]],
"рассказывается": [10],
"пустые": [[12,28]],
"источник": [29]
};
