/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.languagetools;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.languagetool.JLanguageTool;
import org.languagetool.Languages;
import org.languagetool.rules.CategoryId;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.bitext.BitextRule;
import org.languagetool.tools.Tools;
import org.omegat.languagetools.BaseLanguageToolBridge;
import org.omegat.languagetools.LanguageToolResult;
import org.omegat.util.Language;
import org.omegat.util.Log;

public class LanguageToolNativeBridge
extends BaseLanguageToolBridge {
    private final org.languagetool.Language sourceLtLang;
    private final org.languagetool.Language targetLtLang;
    private ThreadLocal<JLanguageTool> sourceLt;
    private ThreadLocal<JLanguageTool> targetLt;
    private List<BitextRule> bRules;

    public LanguageToolNativeBridge(Language sourceLang, Language targetLang) {
        this.sourceLtLang = LanguageToolNativeBridge.getLTLanguage(sourceLang);
        this.targetLtLang = LanguageToolNativeBridge.getLTLanguage(targetLang);
        Log.log("Selected LanguageTool source language: " + (this.sourceLtLang == null ? null : this.sourceLtLang.getShortNameWithCountryAndVariant()));
        Log.log("Selected LanguageTool target language: " + (this.targetLtLang == null ? null : this.targetLtLang.getShortNameWithCountryAndVariant()));
        this.sourceLt = ThreadLocal.withInitial(() -> this.sourceLtLang == null ? null : new JLanguageTool(this.sourceLtLang));
        this.targetLt = ThreadLocal.withInitial(() -> this.targetLtLang == null ? null : new JLanguageTool(this.targetLtLang));
        if (this.sourceLtLang != null && this.targetLtLang != null) {
            try {
                this.bRules = Tools.getBitextRules((org.languagetool.Language)this.sourceLtLang, (org.languagetool.Language)this.targetLtLang);
            }
            catch (Exception e) {
                Log.log(e);
            }
        }
    }

    @Override
    public void stop() {
    }

    @Override
    public void applyRuleFilters(Set<String> disabledCategories, Set<String> disabledRules, Set<String> enabledRules) {
        if (this.targetLtLang != null) {
            Set<CategoryId> dc = disabledCategories.stream().map(CategoryId::new).collect(Collectors.toSet());
            this.targetLt = this.reinitWithRules(this.targetLtLang, dc, disabledRules, enabledRules);
        }
        if (this.bRules != null) {
            this.bRules = this.bRules.stream().filter(rule -> !disabledRules.contains(rule.getId())).collect(Collectors.toList());
        }
    }

    ThreadLocal<JLanguageTool> reinitWithRules(org.languagetool.Language lang, Set<CategoryId> disabledCategories, Set<String> disabledRules, Set<String> enabledRules) {
        return ThreadLocal.withInitial(() -> {
            JLanguageTool lt = new JLanguageTool(lang);
            Tools.selectRules((JLanguageTool)lt, (Set)disabledCategories, Collections.emptySet(), (Set)disabledRules, (Set)enabledRules, (boolean)false);
            return lt;
        });
    }

    @Override
    protected List<LanguageToolResult> getCheckResultsImpl(String sourceText, String translationText) throws Exception {
        return this.getRuleMatches(sourceText, translationText).stream().map(m -> new LanguageToolResult(m.getMessage(), m.getFromPos(), m.getToPos(), m.getRule().getId(), m.getRule().getDescription())).collect(Collectors.toList());
    }

    List<RuleMatch> getRuleMatches(String sourceText, String translationText) throws Exception {
        JLanguageTool ltTarget = this.targetLt.get();
        if (ltTarget == null) {
            return Collections.emptyList();
        }
        JLanguageTool ltSource = this.sourceLt.get();
        if (ltSource != null && this.bRules != null) {
            return Tools.checkBitext((String)sourceText, (String)translationText, (JLanguageTool)ltSource, (JLanguageTool)ltTarget, this.bRules);
        }
        return ltTarget.check(translationText);
    }

    public static org.languagetool.Language getLTLanguage(Language lang) {
        List ltLangs = Languages.get();
        String omLang = lang.getLanguageCode();
        String omCountry = lang.getCountryCode();
        for (org.languagetool.Language ltLang : ltLangs) {
            List<String> countries;
            if (!omLang.equalsIgnoreCase(ltLang.getShortName()) || !(countries = Arrays.asList(ltLang.getCountries())).contains(omCountry)) continue;
            return ltLang;
        }
        for (org.languagetool.Language ltLang : ltLangs) {
            org.languagetool.Language defaultVariant;
            if (!omLang.equalsIgnoreCase(ltLang.getShortName()) || !ltLang.hasVariant() || (defaultVariant = ltLang.getDefaultLanguageVariant()) == null) continue;
            return ltLang;
        }
        for (org.languagetool.Language ltLang : ltLangs) {
            if (!omLang.equalsIgnoreCase(ltLang.getShortName()) || ltLang.hasVariant()) continue;
            return ltLang;
        }
        return null;
    }
}

