/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.filters2.text.ini;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import org.omegat.filters2.AbstractFilter;
import org.omegat.filters2.FilterContext;
import org.omegat.filters2.Instance;
import org.omegat.util.LinebreakPreservingReader;
import org.omegat.util.NullBufferedWriter;
import org.omegat.util.OStrings;
import org.omegat.util.StringUtil;

public class INIFilter
extends AbstractFilter {
    protected Map<String, String> align;

    @Override
    public String getFileFormatName() {
        return OStrings.getString("INIFILTER_FILTER_NAME");
    }

    @Override
    public boolean isSourceEncodingVariable() {
        return true;
    }

    @Override
    public boolean isTargetEncodingVariable() {
        return true;
    }

    @Override
    public Instance[] getDefaultInstances() {
        return new Instance[]{new Instance("*.ini"), new Instance("*.lng"), new Instance("*.strings", StandardCharsets.UTF_8.name(), StandardCharsets.UTF_8.name())};
    }

    private String leftTrim(String s) {
        int i;
        int cp;
        for (i = 0; i < s.length() && ((cp = s.codePointAt(i)) == 32 || cp == 9); i += Character.charCount(cp)) {
        }
        return s.substring(i, s.length());
    }

    @Override
    public void processFile(BufferedReader reader, BufferedWriter outfile, FilterContext fc) throws IOException {
        String str;
        LinebreakPreservingReader lbpr = new LinebreakPreservingReader(reader);
        String group = null;
        while ((str = lbpr.readLine()) != null) {
            int nextOffset;
            int equalsPos;
            String trimmed = str.trim();
            if (trimmed.isEmpty() || trimmed.codePointAt(0) == 35 || trimmed.codePointAt(0) == 59) {
                outfile.write(str);
                outfile.write(lbpr.getLinebreak());
                continue;
            }
            if (trimmed.startsWith("[") && trimmed.endsWith("]")) {
                group = trimmed.substring(trimmed.offsetByCodePoints(0, 1), trimmed.offsetByCodePoints(trimmed.length(), -1));
            }
            if ((equalsPos = str.indexOf(61)) == -1) {
                equalsPos = str.offsetByCodePoints(str.length(), -1);
            }
            while (str.codePointCount(equalsPos, str.length()) > 1 && str.codePointAt(nextOffset = str.offsetByCodePoints(equalsPos, 1)) == 32) {
                equalsPos = nextOffset;
            }
            int afterEqualsPos = str.offsetByCodePoints(equalsPos, 1);
            outfile.write(str.substring(0, afterEqualsPos));
            String key = (group != null ? group + '/' : "") + str.substring(0, equalsPos).trim();
            String value = str.substring(afterEqualsPos);
            value = this.leftTrim(value);
            if (this.entryAlignCallback != null) {
                this.align.put(key, value);
                continue;
            }
            if (this.entryParseCallback != null) {
                this.entryParseCallback.addEntry(key, value, null, false, null, null, this, null);
                continue;
            }
            if (this.entryTranslateCallback == null) continue;
            String trans = this.entryTranslateCallback.getTranslation(key, value, null);
            if (trans == null) {
                trans = value;
            }
            outfile.write(trans);
            outfile.write(lbpr.getLinebreak());
        }
        lbpr.close();
    }

    @Override
    protected void alignFile(BufferedReader sourceFile, BufferedReader translatedFile, FilterContext fc) throws Exception {
        HashMap<String, String> source = new HashMap<String, String>();
        HashMap<String, String> translated = new HashMap<String, String>();
        this.align = source;
        this.processFile(sourceFile, new NullBufferedWriter(), fc);
        this.align = translated;
        this.processFile(translatedFile, new NullBufferedWriter(), fc);
        for (Map.Entry en : source.entrySet()) {
            String tr = (String)translated.get(en.getKey());
            if (StringUtil.isEmpty(tr)) continue;
            this.entryAlignCallback.addTranslation((String)en.getKey(), (String)en.getValue(), tr, false, null, this);
        }
    }
}

