// Copyright 2015-2025 The Khronos Group Inc.
//
// SPDX-License-Identifier: Apache-2.0 OR MIT
//

// This header is generated from the Khronos Vulkan XML API Registry.

#ifndef VULKAN_STRUCTS_HPP
#define VULKAN_STRUCTS_HPP

// include-what-you-use: make sure, vulkan.hpp is used by code-completers
// IWYU pragma: private; include "vulkan.hpp"

#include <cstring>  // strcmp

namespace VULKAN_HPP_NAMESPACE
{

  //===============
  //=== STRUCTS ===
  //===============

  // wrapper struct for struct VkAabbPositionsKHR, see https://registry.khronos.org/vulkan/specs/latest/man/html/VkAabbPositionsKHR.html
  struct AabbPositionsKHR
  {
    using NativeType = VkAabbPositionsKHR;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR
      AabbPositionsKHR( float minX_ = {}, float minY_ = {}, float minZ_ = {}, float maxX_ = {}, float maxY_ = {}, float maxZ_ = {} ) VULKAN_HPP_NOEXCEPT
      : minX{ minX_ }
      , minY{ minY_ }
      , minZ{ minZ_ }
      , maxX{ maxX_ }
      , maxY{ maxY_ }
      , maxZ{ maxZ_ }
    {
    }

    VULKAN_HPP_CONSTEXPR AabbPositionsKHR( AabbPositionsKHR const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    AabbPositionsKHR( VkAabbPositionsKHR const & rhs ) VULKAN_HPP_NOEXCEPT : AabbPositionsKHR( *reinterpret_cast<AabbPositionsKHR const *>( &rhs ) ) {}

    AabbPositionsKHR & operator=( AabbPositionsKHR const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    AabbPositionsKHR & operator=( VkAabbPositionsKHR const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<AabbPositionsKHR const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 AabbPositionsKHR & setMinX( float minX_ ) VULKAN_HPP_NOEXCEPT
    {
      minX = minX_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AabbPositionsKHR & setMinY( float minY_ ) VULKAN_HPP_NOEXCEPT
    {
      minY = minY_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AabbPositionsKHR & setMinZ( float minZ_ ) VULKAN_HPP_NOEXCEPT
    {
      minZ = minZ_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AabbPositionsKHR & setMaxX( float maxX_ ) VULKAN_HPP_NOEXCEPT
    {
      maxX = maxX_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AabbPositionsKHR & setMaxY( float maxY_ ) VULKAN_HPP_NOEXCEPT
    {
      maxY = maxY_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AabbPositionsKHR & setMaxZ( float maxZ_ ) VULKAN_HPP_NOEXCEPT
    {
      maxZ = maxZ_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_SETTERS*/

    operator VkAabbPositionsKHR const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkAabbPositionsKHR *>( this );
    }

    operator VkAabbPositionsKHR &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkAabbPositionsKHR *>( this );
    }

    operator VkAabbPositionsKHR const *() const VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<const VkAabbPositionsKHR *>( this );
    }

    operator VkAabbPositionsKHR *() VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<VkAabbPositionsKHR *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<float const &, float const &, float const &, float const &, float const &, float const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( minX, minY, minZ, maxX, maxY, maxZ );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( AabbPositionsKHR const & ) const = default;
#else
    bool operator==( AabbPositionsKHR const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( minX == rhs.minX ) && ( minY == rhs.minY ) && ( minZ == rhs.minZ ) && ( maxX == rhs.maxX ) && ( maxY == rhs.maxY ) && ( maxZ == rhs.maxZ );
#  endif
    }

    bool operator!=( AabbPositionsKHR const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    float minX = {};
    float minY = {};
    float minZ = {};
    float maxX = {};
    float maxY = {};
    float maxZ = {};
  };

  using AabbPositionsNV = AabbPositionsKHR;

  union DeviceOrHostAddressConstKHR
  {
    using NativeType = VkDeviceOrHostAddressConstKHR;
#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_UNION_CONSTRUCTORS )

    VULKAN_HPP_CONSTEXPR_14 DeviceOrHostAddressConstKHR( DeviceAddress deviceAddress_ = {} ) : deviceAddress( deviceAddress_ ) {}

    VULKAN_HPP_CONSTEXPR_14 DeviceOrHostAddressConstKHR( const void * hostAddress_ ) : hostAddress( hostAddress_ ) {}
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_UNION_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 DeviceOrHostAddressConstKHR & setDeviceAddress( DeviceAddress deviceAddress_ ) VULKAN_HPP_NOEXCEPT
    {
      deviceAddress = deviceAddress_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DeviceOrHostAddressConstKHR & setHostAddress( const void * hostAddress_ ) VULKAN_HPP_NOEXCEPT
    {
      hostAddress = hostAddress_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_SETTERS*/

    operator VkDeviceOrHostAddressConstKHR const &() const
    {
      return *reinterpret_cast<const VkDeviceOrHostAddressConstKHR *>( this );
    }

    operator VkDeviceOrHostAddressConstKHR &()
    {
      return *reinterpret_cast<VkDeviceOrHostAddressConstKHR *>( this );
    }

#ifdef VULKAN_HPP_HAS_UNRESTRICTED_UNIONS
    DeviceAddress deviceAddress;
    const void *  hostAddress;
#else
    VkDeviceAddress deviceAddress;
    const void *    hostAddress;
#endif /*VULKAN_HPP_HAS_UNRESTRICTED_UNIONS*/
  };

  // wrapper struct for struct VkAccelerationStructureGeometryTrianglesDataKHR, see
  // https://registry.khronos.org/vulkan/specs/latest/man/html/VkAccelerationStructureGeometryTrianglesDataKHR.html
  struct AccelerationStructureGeometryTrianglesDataKHR
  {
    using NativeType = VkAccelerationStructureGeometryTrianglesDataKHR;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eAccelerationStructureGeometryTrianglesDataKHR;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureGeometryTrianglesDataKHR( Format                      vertexFormat_  = Format::eUndefined,
                                                                           DeviceOrHostAddressConstKHR vertexData_    = {},
                                                                           DeviceSize                  vertexStride_  = {},
                                                                           uint32_t                    maxVertex_     = {},
                                                                           IndexType                   indexType_     = IndexType::eUint16,
                                                                           DeviceOrHostAddressConstKHR indexData_     = {},
                                                                           DeviceOrHostAddressConstKHR transformData_ = {},
                                                                           const void *                pNext_         = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , vertexFormat{ vertexFormat_ }
      , vertexData{ vertexData_ }
      , vertexStride{ vertexStride_ }
      , maxVertex{ maxVertex_ }
      , indexType{ indexType_ }
      , indexData{ indexData_ }
      , transformData{ transformData_ }
    {
    }

    VULKAN_HPP_CONSTEXPR_14
      AccelerationStructureGeometryTrianglesDataKHR( AccelerationStructureGeometryTrianglesDataKHR const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    AccelerationStructureGeometryTrianglesDataKHR( VkAccelerationStructureGeometryTrianglesDataKHR const & rhs ) VULKAN_HPP_NOEXCEPT
      : AccelerationStructureGeometryTrianglesDataKHR( *reinterpret_cast<AccelerationStructureGeometryTrianglesDataKHR const *>( &rhs ) )
    {
    }

    AccelerationStructureGeometryTrianglesDataKHR & operator=( AccelerationStructureGeometryTrianglesDataKHR const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    AccelerationStructureGeometryTrianglesDataKHR & operator=( VkAccelerationStructureGeometryTrianglesDataKHR const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<AccelerationStructureGeometryTrianglesDataKHR const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureGeometryTrianglesDataKHR & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureGeometryTrianglesDataKHR & setVertexFormat( Format vertexFormat_ ) VULKAN_HPP_NOEXCEPT
    {
      vertexFormat = vertexFormat_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureGeometryTrianglesDataKHR & setVertexData( DeviceOrHostAddressConstKHR const & vertexData_ ) VULKAN_HPP_NOEXCEPT
    {
      vertexData = vertexData_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureGeometryTrianglesDataKHR & setVertexStride( DeviceSize vertexStride_ ) VULKAN_HPP_NOEXCEPT
    {
      vertexStride = vertexStride_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureGeometryTrianglesDataKHR & setMaxVertex( uint32_t maxVertex_ ) VULKAN_HPP_NOEXCEPT
    {
      maxVertex = maxVertex_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureGeometryTrianglesDataKHR & setIndexType( IndexType indexType_ ) VULKAN_HPP_NOEXCEPT
    {
      indexType = indexType_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureGeometryTrianglesDataKHR & setIndexData( DeviceOrHostAddressConstKHR const & indexData_ ) VULKAN_HPP_NOEXCEPT
    {
      indexData = indexData_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureGeometryTrianglesDataKHR &
      setTransformData( DeviceOrHostAddressConstKHR const & transformData_ ) VULKAN_HPP_NOEXCEPT
    {
      transformData = transformData_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_SETTERS*/

    operator VkAccelerationStructureGeometryTrianglesDataKHR const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkAccelerationStructureGeometryTrianglesDataKHR *>( this );
    }

    operator VkAccelerationStructureGeometryTrianglesDataKHR &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkAccelerationStructureGeometryTrianglesDataKHR *>( this );
    }

    operator VkAccelerationStructureGeometryTrianglesDataKHR const *() const VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<const VkAccelerationStructureGeometryTrianglesDataKHR *>( this );
    }

    operator VkAccelerationStructureGeometryTrianglesDataKHR *() VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<VkAccelerationStructureGeometryTrianglesDataKHR *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<StructureType const &,
               const void * const &,
               Format const &,
               DeviceOrHostAddressConstKHR const &,
               DeviceSize const &,
               uint32_t const &,
               IndexType const &,
               DeviceOrHostAddressConstKHR const &,
               DeviceOrHostAddressConstKHR const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, vertexFormat, vertexData, vertexStride, maxVertex, indexType, indexData, transformData );
    }
#endif

  public:
    StructureType               sType         = StructureType::eAccelerationStructureGeometryTrianglesDataKHR;
    const void *                pNext         = {};
    Format                      vertexFormat  = Format::eUndefined;
    DeviceOrHostAddressConstKHR vertexData    = {};
    DeviceSize                  vertexStride  = {};
    uint32_t                    maxVertex     = {};
    IndexType                   indexType     = IndexType::eUint16;
    DeviceOrHostAddressConstKHR indexData     = {};
    DeviceOrHostAddressConstKHR transformData = {};
  };

  template <>
  struct CppType<StructureType, StructureType::eAccelerationStructureGeometryTrianglesDataKHR>
  {
    using Type = AccelerationStructureGeometryTrianglesDataKHR;
  };

  // wrapper struct for struct VkAccelerationStructureGeometryAabbsDataKHR, see
  // https://registry.khronos.org/vulkan/specs/latest/man/html/VkAccelerationStructureGeometryAabbsDataKHR.html
  struct AccelerationStructureGeometryAabbsDataKHR
  {
    using NativeType = VkAccelerationStructureGeometryAabbsDataKHR;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eAccelerationStructureGeometryAabbsDataKHR;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureGeometryAabbsDataKHR( DeviceOrHostAddressConstKHR data_   = {},
                                                                       DeviceSize                  stride_ = {},
                                                                       const void *                pNext_  = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , data{ data_ }
      , stride{ stride_ }
    {
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureGeometryAabbsDataKHR( AccelerationStructureGeometryAabbsDataKHR const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    AccelerationStructureGeometryAabbsDataKHR( VkAccelerationStructureGeometryAabbsDataKHR const & rhs ) VULKAN_HPP_NOEXCEPT
      : AccelerationStructureGeometryAabbsDataKHR( *reinterpret_cast<AccelerationStructureGeometryAabbsDataKHR const *>( &rhs ) )
    {
    }

    AccelerationStructureGeometryAabbsDataKHR & operator=( AccelerationStructureGeometryAabbsDataKHR const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    AccelerationStructureGeometryAabbsDataKHR & operator=( VkAccelerationStructureGeometryAabbsDataKHR const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<AccelerationStructureGeometryAabbsDataKHR const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureGeometryAabbsDataKHR & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureGeometryAabbsDataKHR & setData( DeviceOrHostAddressConstKHR const & data_ ) VULKAN_HPP_NOEXCEPT
    {
      data = data_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureGeometryAabbsDataKHR & setStride( DeviceSize stride_ ) VULKAN_HPP_NOEXCEPT
    {
      stride = stride_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_SETTERS*/

    operator VkAccelerationStructureGeometryAabbsDataKHR const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkAccelerationStructureGeometryAabbsDataKHR *>( this );
    }

    operator VkAccelerationStructureGeometryAabbsDataKHR &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkAccelerationStructureGeometryAabbsDataKHR *>( this );
    }

    operator VkAccelerationStructureGeometryAabbsDataKHR const *() const VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<const VkAccelerationStructureGeometryAabbsDataKHR *>( this );
    }

    operator VkAccelerationStructureGeometryAabbsDataKHR *() VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<VkAccelerationStructureGeometryAabbsDataKHR *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<StructureType const &, const void * const &, DeviceOrHostAddressConstKHR const &, DeviceSize const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, data, stride );
    }
#endif

  public:
    StructureType               sType  = StructureType::eAccelerationStructureGeometryAabbsDataKHR;
    const void *                pNext  = {};
    DeviceOrHostAddressConstKHR data   = {};
    DeviceSize                  stride = {};
  };

  template <>
  struct CppType<StructureType, StructureType::eAccelerationStructureGeometryAabbsDataKHR>
  {
    using Type = AccelerationStructureGeometryAabbsDataKHR;
  };

  // wrapper struct for struct VkAccelerationStructureGeometryInstancesDataKHR, see
  // https://registry.khronos.org/vulkan/specs/latest/man/html/VkAccelerationStructureGeometryInstancesDataKHR.html
  struct AccelerationStructureGeometryInstancesDataKHR
  {
    using NativeType = VkAccelerationStructureGeometryInstancesDataKHR;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eAccelerationStructureGeometryInstancesDataKHR;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureGeometryInstancesDataKHR( Bool32                      arrayOfPointers_ = {},
                                                                           DeviceOrHostAddressConstKHR data_            = {},
                                                                           const void *                pNext_           = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , arrayOfPointers{ arrayOfPointers_ }
      , data{ data_ }
    {
    }

    VULKAN_HPP_CONSTEXPR_14
      AccelerationStructureGeometryInstancesDataKHR( AccelerationStructureGeometryInstancesDataKHR const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    AccelerationStructureGeometryInstancesDataKHR( VkAccelerationStructureGeometryInstancesDataKHR const & rhs ) VULKAN_HPP_NOEXCEPT
      : AccelerationStructureGeometryInstancesDataKHR( *reinterpret_cast<AccelerationStructureGeometryInstancesDataKHR const *>( &rhs ) )
    {
    }

    AccelerationStructureGeometryInstancesDataKHR & operator=( AccelerationStructureGeometryInstancesDataKHR const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    AccelerationStructureGeometryInstancesDataKHR & operator=( VkAccelerationStructureGeometryInstancesDataKHR const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<AccelerationStructureGeometryInstancesDataKHR const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureGeometryInstancesDataKHR & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureGeometryInstancesDataKHR & setArrayOfPointers( Bool32 arrayOfPointers_ ) VULKAN_HPP_NOEXCEPT
    {
      arrayOfPointers = arrayOfPointers_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureGeometryInstancesDataKHR & setData( DeviceOrHostAddressConstKHR const & data_ ) VULKAN_HPP_NOEXCEPT
    {
      data = data_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_SETTERS*/

    operator VkAccelerationStructureGeometryInstancesDataKHR const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkAccelerationStructureGeometryInstancesDataKHR *>( this );
    }

    operator VkAccelerationStructureGeometryInstancesDataKHR &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkAccelerationStructureGeometryInstancesDataKHR *>( this );
    }

    operator VkAccelerationStructureGeometryInstancesDataKHR const *() const VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<const VkAccelerationStructureGeometryInstancesDataKHR *>( this );
    }

    operator VkAccelerationStructureGeometryInstancesDataKHR *() VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<VkAccelerationStructureGeometryInstancesDataKHR *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<StructureType const &, const void * const &, Bool32 const &, DeviceOrHostAddressConstKHR const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, arrayOfPointers, data );
    }
#endif

  public:
    StructureType               sType           = StructureType::eAccelerationStructureGeometryInstancesDataKHR;
    const void *                pNext           = {};
    Bool32                      arrayOfPointers = {};
    DeviceOrHostAddressConstKHR data            = {};
  };

  template <>
  struct CppType<StructureType, StructureType::eAccelerationStructureGeometryInstancesDataKHR>
  {
    using Type = AccelerationStructureGeometryInstancesDataKHR;
  };

  union AccelerationStructureGeometryDataKHR
  {
    using NativeType = VkAccelerationStructureGeometryDataKHR;
#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_UNION_CONSTRUCTORS )

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureGeometryDataKHR( AccelerationStructureGeometryTrianglesDataKHR triangles_ = {} ) : triangles( triangles_ ) {}

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureGeometryDataKHR( AccelerationStructureGeometryAabbsDataKHR aabbs_ ) : aabbs( aabbs_ ) {}

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureGeometryDataKHR( AccelerationStructureGeometryInstancesDataKHR instances_ ) : instances( instances_ ) {}
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_UNION_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureGeometryDataKHR &
      setTriangles( AccelerationStructureGeometryTrianglesDataKHR const & triangles_ ) VULKAN_HPP_NOEXCEPT
    {
      triangles = triangles_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureGeometryDataKHR & setAabbs( AccelerationStructureGeometryAabbsDataKHR const & aabbs_ ) VULKAN_HPP_NOEXCEPT
    {
      aabbs = aabbs_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureGeometryDataKHR &
      setInstances( AccelerationStructureGeometryInstancesDataKHR const & instances_ ) VULKAN_HPP_NOEXCEPT
    {
      instances = instances_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_SETTERS*/

    operator VkAccelerationStructureGeometryDataKHR const &() const
    {
      return *reinterpret_cast<const VkAccelerationStructureGeometryDataKHR *>( this );
    }

    operator VkAccelerationStructureGeometryDataKHR &()
    {
      return *reinterpret_cast<VkAccelerationStructureGeometryDataKHR *>( this );
    }

#ifdef VULKAN_HPP_HAS_UNRESTRICTED_UNIONS
    AccelerationStructureGeometryTrianglesDataKHR triangles;
    AccelerationStructureGeometryAabbsDataKHR     aabbs;
    AccelerationStructureGeometryInstancesDataKHR instances;
#else
    VkAccelerationStructureGeometryTrianglesDataKHR triangles;
    VkAccelerationStructureGeometryAabbsDataKHR     aabbs;
    VkAccelerationStructureGeometryInstancesDataKHR instances;
#endif /*VULKAN_HPP_HAS_UNRESTRICTED_UNIONS*/
  };

  // wrapper struct for struct VkAccelerationStructureGeometryKHR, see
  // https://registry.khronos.org/vulkan/specs/latest/man/html/VkAccelerationStructureGeometryKHR.html
  struct AccelerationStructureGeometryKHR
  {
    using NativeType = VkAccelerationStructureGeometryKHR;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eAccelerationStructureGeometryKHR;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureGeometryKHR( GeometryTypeKHR                      geometryType_ = GeometryTypeKHR::eTriangles,
                                                              AccelerationStructureGeometryDataKHR geometry_     = {},
                                                              GeometryFlagsKHR                     flags_        = {},
                                                              const void *                         pNext_        = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , geometryType{ geometryType_ }
      , geometry{ geometry_ }
      , flags{ flags_ }
    {
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureGeometryKHR( AccelerationStructureGeometryKHR const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    AccelerationStructureGeometryKHR( VkAccelerationStructureGeometryKHR const & rhs ) VULKAN_HPP_NOEXCEPT
      : AccelerationStructureGeometryKHR( *reinterpret_cast<AccelerationStructureGeometryKHR const *>( &rhs ) )
    {
    }

    AccelerationStructureGeometryKHR & operator=( AccelerationStructureGeometryKHR const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    AccelerationStructureGeometryKHR & operator=( VkAccelerationStructureGeometryKHR const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<AccelerationStructureGeometryKHR const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureGeometryKHR & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureGeometryKHR & setGeometryType( GeometryTypeKHR geometryType_ ) VULKAN_HPP_NOEXCEPT
    {
      geometryType = geometryType_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureGeometryKHR & setGeometry( AccelerationStructureGeometryDataKHR const & geometry_ ) VULKAN_HPP_NOEXCEPT
    {
      geometry = geometry_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureGeometryKHR & setFlags( GeometryFlagsKHR flags_ ) VULKAN_HPP_NOEXCEPT
    {
      flags = flags_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_SETTERS*/

    operator VkAccelerationStructureGeometryKHR const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkAccelerationStructureGeometryKHR *>( this );
    }

    operator VkAccelerationStructureGeometryKHR &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkAccelerationStructureGeometryKHR *>( this );
    }

    operator VkAccelerationStructureGeometryKHR const *() const VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<const VkAccelerationStructureGeometryKHR *>( this );
    }

    operator VkAccelerationStructureGeometryKHR *() VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<VkAccelerationStructureGeometryKHR *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<StructureType const &, const void * const &, GeometryTypeKHR const &, AccelerationStructureGeometryDataKHR const &, GeometryFlagsKHR const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, geometryType, geometry, flags );
    }
#endif

  public:
    StructureType                        sType        = StructureType::eAccelerationStructureGeometryKHR;
    const void *                         pNext        = {};
    GeometryTypeKHR                      geometryType = GeometryTypeKHR::eTriangles;
    AccelerationStructureGeometryDataKHR geometry     = {};
    GeometryFlagsKHR                     flags        = {};
  };

  template <>
  struct CppType<StructureType, StructureType::eAccelerationStructureGeometryKHR>
  {
    using Type = AccelerationStructureGeometryKHR;
  };

  union DeviceOrHostAddressKHR
  {
    using NativeType = VkDeviceOrHostAddressKHR;
#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_UNION_CONSTRUCTORS )

    VULKAN_HPP_CONSTEXPR_14 DeviceOrHostAddressKHR( DeviceAddress deviceAddress_ = {} ) : deviceAddress( deviceAddress_ ) {}

    VULKAN_HPP_CONSTEXPR_14 DeviceOrHostAddressKHR( void * hostAddress_ ) : hostAddress( hostAddress_ ) {}
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_UNION_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 DeviceOrHostAddressKHR & setDeviceAddress( DeviceAddress deviceAddress_ ) VULKAN_HPP_NOEXCEPT
    {
      deviceAddress = deviceAddress_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 DeviceOrHostAddressKHR & setHostAddress( void * hostAddress_ ) VULKAN_HPP_NOEXCEPT
    {
      hostAddress = hostAddress_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_SETTERS*/

    operator VkDeviceOrHostAddressKHR const &() const
    {
      return *reinterpret_cast<const VkDeviceOrHostAddressKHR *>( this );
    }

    operator VkDeviceOrHostAddressKHR &()
    {
      return *reinterpret_cast<VkDeviceOrHostAddressKHR *>( this );
    }

#ifdef VULKAN_HPP_HAS_UNRESTRICTED_UNIONS
    DeviceAddress deviceAddress;
    void *        hostAddress;
#else
    VkDeviceAddress deviceAddress;
    void *          hostAddress;
#endif /*VULKAN_HPP_HAS_UNRESTRICTED_UNIONS*/
  };

  // wrapper struct for struct VkAccelerationStructureBuildGeometryInfoKHR, see
  // https://registry.khronos.org/vulkan/specs/latest/man/html/VkAccelerationStructureBuildGeometryInfoKHR.html
  struct AccelerationStructureBuildGeometryInfoKHR
  {
    using NativeType = VkAccelerationStructureBuildGeometryInfoKHR;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eAccelerationStructureBuildGeometryInfoKHR;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureBuildGeometryInfoKHR( AccelerationStructureTypeKHR       type_  = AccelerationStructureTypeKHR::eTopLevel,
                                                                       BuildAccelerationStructureFlagsKHR flags_ = {},
                                                                       BuildAccelerationStructureModeKHR  mode_  = BuildAccelerationStructureModeKHR::eBuild,
                                                                       AccelerationStructureKHR           srcAccelerationStructure_   = {},
                                                                       AccelerationStructureKHR           dstAccelerationStructure_   = {},
                                                                       uint32_t                           geometryCount_              = {},
                                                                       const AccelerationStructureGeometryKHR *         pGeometries_  = {},
                                                                       const AccelerationStructureGeometryKHR * const * ppGeometries_ = {},
                                                                       DeviceOrHostAddressKHR                           scratchData_  = {},
                                                                       const void *                                     pNext_ = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , type{ type_ }
      , flags{ flags_ }
      , mode{ mode_ }
      , srcAccelerationStructure{ srcAccelerationStructure_ }
      , dstAccelerationStructure{ dstAccelerationStructure_ }
      , geometryCount{ geometryCount_ }
      , pGeometries{ pGeometries_ }
      , ppGeometries{ ppGeometries_ }
      , scratchData{ scratchData_ }
    {
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureBuildGeometryInfoKHR( AccelerationStructureBuildGeometryInfoKHR const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    AccelerationStructureBuildGeometryInfoKHR( VkAccelerationStructureBuildGeometryInfoKHR const & rhs ) VULKAN_HPP_NOEXCEPT
      : AccelerationStructureBuildGeometryInfoKHR( *reinterpret_cast<AccelerationStructureBuildGeometryInfoKHR const *>( &rhs ) )
    {
    }

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    AccelerationStructureBuildGeometryInfoKHR( AccelerationStructureTypeKHR                                                    type_,
                                               BuildAccelerationStructureFlagsKHR                                              flags_,
                                               BuildAccelerationStructureModeKHR                                               mode_,
                                               AccelerationStructureKHR                                                        srcAccelerationStructure_,
                                               AccelerationStructureKHR                                                        dstAccelerationStructure_,
                                               ArrayProxyNoTemporaries<const AccelerationStructureGeometryKHR> const &         geometries_,
                                               ArrayProxyNoTemporaries<const AccelerationStructureGeometryKHR * const> const & pGeometries_ = {},
                                               DeviceOrHostAddressKHR                                                          scratchData_ = {},
                                               const void *                                                                    pNext_       = nullptr )
      : pNext( pNext_ )
      , type( type_ )
      , flags( flags_ )
      , mode( mode_ )
      , srcAccelerationStructure( srcAccelerationStructure_ )
      , dstAccelerationStructure( dstAccelerationStructure_ )
      , geometryCount( static_cast<uint32_t>( !geometries_.empty() ? geometries_.size() : pGeometries_.size() ) )
      , pGeometries( geometries_.data() )
      , ppGeometries( pGeometries_.data() )
      , scratchData( scratchData_ )
    {
#    ifdef VULKAN_HPP_NO_EXCEPTIONS
      VULKAN_HPP_ASSERT( ( !geometries_.empty() + !pGeometries_.empty() ) <= 1 );
#    else
      if ( 1 < ( !geometries_.empty() + !pGeometries_.empty() ) )
      {
        throw LogicError(
          VULKAN_HPP_NAMESPACE_STRING
          "::AccelerationStructureBuildGeometryInfoKHR::AccelerationStructureBuildGeometryInfoKHR: 1 < ( !geometries_.empty() + !pGeometries_.empty() )" );
      }
#    endif /*VULKAN_HPP_NO_EXCEPTIONS*/
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/

    AccelerationStructureBuildGeometryInfoKHR & operator=( AccelerationStructureBuildGeometryInfoKHR const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    AccelerationStructureBuildGeometryInfoKHR & operator=( VkAccelerationStructureBuildGeometryInfoKHR const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<AccelerationStructureBuildGeometryInfoKHR const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureBuildGeometryInfoKHR & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureBuildGeometryInfoKHR & setType( AccelerationStructureTypeKHR type_ ) VULKAN_HPP_NOEXCEPT
    {
      type = type_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureBuildGeometryInfoKHR & setFlags( BuildAccelerationStructureFlagsKHR flags_ ) VULKAN_HPP_NOEXCEPT
    {
      flags = flags_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureBuildGeometryInfoKHR & setMode( BuildAccelerationStructureModeKHR mode_ ) VULKAN_HPP_NOEXCEPT
    {
      mode = mode_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureBuildGeometryInfoKHR &
      setSrcAccelerationStructure( AccelerationStructureKHR srcAccelerationStructure_ ) VULKAN_HPP_NOEXCEPT
    {
      srcAccelerationStructure = srcAccelerationStructure_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureBuildGeometryInfoKHR &
      setDstAccelerationStructure( AccelerationStructureKHR dstAccelerationStructure_ ) VULKAN_HPP_NOEXCEPT
    {
      dstAccelerationStructure = dstAccelerationStructure_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureBuildGeometryInfoKHR & setGeometryCount( uint32_t geometryCount_ ) VULKAN_HPP_NOEXCEPT
    {
      geometryCount = geometryCount_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureBuildGeometryInfoKHR &
      setPGeometries( const AccelerationStructureGeometryKHR * pGeometries_ ) VULKAN_HPP_NOEXCEPT
    {
      pGeometries = pGeometries_;
      return *this;
    }

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    AccelerationStructureBuildGeometryInfoKHR &
      setGeometries( ArrayProxyNoTemporaries<const AccelerationStructureGeometryKHR> const & geometries_ ) VULKAN_HPP_NOEXCEPT
    {
      geometryCount = static_cast<uint32_t>( geometries_.size() );
      pGeometries   = geometries_.data();
      return *this;
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureBuildGeometryInfoKHR &
      setPpGeometries( const AccelerationStructureGeometryKHR * const * ppGeometries_ ) VULKAN_HPP_NOEXCEPT
    {
      ppGeometries = ppGeometries_;
      return *this;
    }

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    AccelerationStructureBuildGeometryInfoKHR &
      setPGeometries( ArrayProxyNoTemporaries<const AccelerationStructureGeometryKHR * const> const & pGeometries_ ) VULKAN_HPP_NOEXCEPT
    {
      geometryCount = static_cast<uint32_t>( pGeometries_.size() );
      ppGeometries  = pGeometries_.data();
      return *this;
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureBuildGeometryInfoKHR & setScratchData( DeviceOrHostAddressKHR const & scratchData_ ) VULKAN_HPP_NOEXCEPT
    {
      scratchData = scratchData_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_SETTERS*/

    operator VkAccelerationStructureBuildGeometryInfoKHR const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkAccelerationStructureBuildGeometryInfoKHR *>( this );
    }

    operator VkAccelerationStructureBuildGeometryInfoKHR &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkAccelerationStructureBuildGeometryInfoKHR *>( this );
    }

    operator VkAccelerationStructureBuildGeometryInfoKHR const *() const VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<const VkAccelerationStructureBuildGeometryInfoKHR *>( this );
    }

    operator VkAccelerationStructureBuildGeometryInfoKHR *() VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<VkAccelerationStructureBuildGeometryInfoKHR *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<StructureType const &,
               const void * const &,
               AccelerationStructureTypeKHR const &,
               BuildAccelerationStructureFlagsKHR const &,
               BuildAccelerationStructureModeKHR const &,
               AccelerationStructureKHR const &,
               AccelerationStructureKHR const &,
               uint32_t const &,
               const AccelerationStructureGeometryKHR * const &,
               const AccelerationStructureGeometryKHR * const * const &,
               DeviceOrHostAddressKHR const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie(
        sType, pNext, type, flags, mode, srcAccelerationStructure, dstAccelerationStructure, geometryCount, pGeometries, ppGeometries, scratchData );
    }
#endif

  public:
    StructureType                                    sType                    = StructureType::eAccelerationStructureBuildGeometryInfoKHR;
    const void *                                     pNext                    = {};
    AccelerationStructureTypeKHR                     type                     = AccelerationStructureTypeKHR::eTopLevel;
    BuildAccelerationStructureFlagsKHR               flags                    = {};
    BuildAccelerationStructureModeKHR                mode                     = BuildAccelerationStructureModeKHR::eBuild;
    AccelerationStructureKHR                         srcAccelerationStructure = {};
    AccelerationStructureKHR                         dstAccelerationStructure = {};
    uint32_t                                         geometryCount            = {};
    const AccelerationStructureGeometryKHR *         pGeometries              = {};
    const AccelerationStructureGeometryKHR * const * ppGeometries             = {};
    DeviceOrHostAddressKHR                           scratchData              = {};
  };

  template <>
  struct CppType<StructureType, StructureType::eAccelerationStructureBuildGeometryInfoKHR>
  {
    using Type = AccelerationStructureBuildGeometryInfoKHR;
  };

  // wrapper struct for struct VkAccelerationStructureBuildRangeInfoKHR, see
  // https://registry.khronos.org/vulkan/specs/latest/man/html/VkAccelerationStructureBuildRangeInfoKHR.html
  struct AccelerationStructureBuildRangeInfoKHR
  {
    using NativeType = VkAccelerationStructureBuildRangeInfoKHR;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR AccelerationStructureBuildRangeInfoKHR( uint32_t primitiveCount_  = {},
                                                                 uint32_t primitiveOffset_ = {},
                                                                 uint32_t firstVertex_     = {},
                                                                 uint32_t transformOffset_ = {} ) VULKAN_HPP_NOEXCEPT
      : primitiveCount{ primitiveCount_ }
      , primitiveOffset{ primitiveOffset_ }
      , firstVertex{ firstVertex_ }
      , transformOffset{ transformOffset_ }
    {
    }

    VULKAN_HPP_CONSTEXPR AccelerationStructureBuildRangeInfoKHR( AccelerationStructureBuildRangeInfoKHR const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    AccelerationStructureBuildRangeInfoKHR( VkAccelerationStructureBuildRangeInfoKHR const & rhs ) VULKAN_HPP_NOEXCEPT
      : AccelerationStructureBuildRangeInfoKHR( *reinterpret_cast<AccelerationStructureBuildRangeInfoKHR const *>( &rhs ) )
    {
    }

    AccelerationStructureBuildRangeInfoKHR & operator=( AccelerationStructureBuildRangeInfoKHR const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    AccelerationStructureBuildRangeInfoKHR & operator=( VkAccelerationStructureBuildRangeInfoKHR const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<AccelerationStructureBuildRangeInfoKHR const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureBuildRangeInfoKHR & setPrimitiveCount( uint32_t primitiveCount_ ) VULKAN_HPP_NOEXCEPT
    {
      primitiveCount = primitiveCount_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureBuildRangeInfoKHR & setPrimitiveOffset( uint32_t primitiveOffset_ ) VULKAN_HPP_NOEXCEPT
    {
      primitiveOffset = primitiveOffset_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureBuildRangeInfoKHR & setFirstVertex( uint32_t firstVertex_ ) VULKAN_HPP_NOEXCEPT
    {
      firstVertex = firstVertex_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureBuildRangeInfoKHR & setTransformOffset( uint32_t transformOffset_ ) VULKAN_HPP_NOEXCEPT
    {
      transformOffset = transformOffset_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_SETTERS*/

    operator VkAccelerationStructureBuildRangeInfoKHR const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkAccelerationStructureBuildRangeInfoKHR *>( this );
    }

    operator VkAccelerationStructureBuildRangeInfoKHR &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkAccelerationStructureBuildRangeInfoKHR *>( this );
    }

    operator VkAccelerationStructureBuildRangeInfoKHR const *() const VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<const VkAccelerationStructureBuildRangeInfoKHR *>( this );
    }

    operator VkAccelerationStructureBuildRangeInfoKHR *() VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<VkAccelerationStructureBuildRangeInfoKHR *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<uint32_t const &, uint32_t const &, uint32_t const &, uint32_t const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( primitiveCount, primitiveOffset, firstVertex, transformOffset );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( AccelerationStructureBuildRangeInfoKHR const & ) const = default;
#else
    bool operator==( AccelerationStructureBuildRangeInfoKHR const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( primitiveCount == rhs.primitiveCount ) && ( primitiveOffset == rhs.primitiveOffset ) && ( firstVertex == rhs.firstVertex ) &&
             ( transformOffset == rhs.transformOffset );
#  endif
    }

    bool operator!=( AccelerationStructureBuildRangeInfoKHR const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    uint32_t primitiveCount  = {};
    uint32_t primitiveOffset = {};
    uint32_t firstVertex     = {};
    uint32_t transformOffset = {};
  };

  // wrapper struct for struct VkAccelerationStructureBuildSizesInfoKHR, see
  // https://registry.khronos.org/vulkan/specs/latest/man/html/VkAccelerationStructureBuildSizesInfoKHR.html
  struct AccelerationStructureBuildSizesInfoKHR
  {
    using NativeType = VkAccelerationStructureBuildSizesInfoKHR;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eAccelerationStructureBuildSizesInfoKHR;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR AccelerationStructureBuildSizesInfoKHR( DeviceSize   accelerationStructureSize_ = {},
                                                                 DeviceSize   updateScratchSize_         = {},
                                                                 DeviceSize   buildScratchSize_          = {},
                                                                 const void * pNext_                     = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , accelerationStructureSize{ accelerationStructureSize_ }
      , updateScratchSize{ updateScratchSize_ }
      , buildScratchSize{ buildScratchSize_ }
    {
    }

    VULKAN_HPP_CONSTEXPR AccelerationStructureBuildSizesInfoKHR( AccelerationStructureBuildSizesInfoKHR const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    AccelerationStructureBuildSizesInfoKHR( VkAccelerationStructureBuildSizesInfoKHR const & rhs ) VULKAN_HPP_NOEXCEPT
      : AccelerationStructureBuildSizesInfoKHR( *reinterpret_cast<AccelerationStructureBuildSizesInfoKHR const *>( &rhs ) )
    {
    }

    AccelerationStructureBuildSizesInfoKHR & operator=( AccelerationStructureBuildSizesInfoKHR const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    AccelerationStructureBuildSizesInfoKHR & operator=( VkAccelerationStructureBuildSizesInfoKHR const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<AccelerationStructureBuildSizesInfoKHR const *>( &rhs );
      return *this;
    }

    operator VkAccelerationStructureBuildSizesInfoKHR const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkAccelerationStructureBuildSizesInfoKHR *>( this );
    }

    operator VkAccelerationStructureBuildSizesInfoKHR &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkAccelerationStructureBuildSizesInfoKHR *>( this );
    }

    operator VkAccelerationStructureBuildSizesInfoKHR const *() const VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<const VkAccelerationStructureBuildSizesInfoKHR *>( this );
    }

    operator VkAccelerationStructureBuildSizesInfoKHR *() VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<VkAccelerationStructureBuildSizesInfoKHR *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<StructureType const &, const void * const &, DeviceSize const &, DeviceSize const &, DeviceSize const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, accelerationStructureSize, updateScratchSize, buildScratchSize );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( AccelerationStructureBuildSizesInfoKHR const & ) const = default;
#else
    bool operator==( AccelerationStructureBuildSizesInfoKHR const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( accelerationStructureSize == rhs.accelerationStructureSize ) &&
             ( updateScratchSize == rhs.updateScratchSize ) && ( buildScratchSize == rhs.buildScratchSize );
#  endif
    }

    bool operator!=( AccelerationStructureBuildSizesInfoKHR const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    StructureType sType                     = StructureType::eAccelerationStructureBuildSizesInfoKHR;
    const void *  pNext                     = {};
    DeviceSize    accelerationStructureSize = {};
    DeviceSize    updateScratchSize         = {};
    DeviceSize    buildScratchSize          = {};
  };

  template <>
  struct CppType<StructureType, StructureType::eAccelerationStructureBuildSizesInfoKHR>
  {
    using Type = AccelerationStructureBuildSizesInfoKHR;
  };

  // wrapper struct for struct VkAccelerationStructureCaptureDescriptorDataInfoEXT, see
  // https://registry.khronos.org/vulkan/specs/latest/man/html/VkAccelerationStructureCaptureDescriptorDataInfoEXT.html
  struct AccelerationStructureCaptureDescriptorDataInfoEXT
  {
    using NativeType = VkAccelerationStructureCaptureDescriptorDataInfoEXT;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eAccelerationStructureCaptureDescriptorDataInfoEXT;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR AccelerationStructureCaptureDescriptorDataInfoEXT( AccelerationStructureKHR accelerationStructure_   = {},
                                                                            AccelerationStructureNV  accelerationStructureNV_ = {},
                                                                            const void *             pNext_                   = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , accelerationStructure{ accelerationStructure_ }
      , accelerationStructureNV{ accelerationStructureNV_ }
    {
    }

    VULKAN_HPP_CONSTEXPR
      AccelerationStructureCaptureDescriptorDataInfoEXT( AccelerationStructureCaptureDescriptorDataInfoEXT const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    AccelerationStructureCaptureDescriptorDataInfoEXT( VkAccelerationStructureCaptureDescriptorDataInfoEXT const & rhs ) VULKAN_HPP_NOEXCEPT
      : AccelerationStructureCaptureDescriptorDataInfoEXT( *reinterpret_cast<AccelerationStructureCaptureDescriptorDataInfoEXT const *>( &rhs ) )
    {
    }

    AccelerationStructureCaptureDescriptorDataInfoEXT &
      operator=( AccelerationStructureCaptureDescriptorDataInfoEXT const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    AccelerationStructureCaptureDescriptorDataInfoEXT & operator=( VkAccelerationStructureCaptureDescriptorDataInfoEXT const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<AccelerationStructureCaptureDescriptorDataInfoEXT const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureCaptureDescriptorDataInfoEXT & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureCaptureDescriptorDataInfoEXT &
      setAccelerationStructure( AccelerationStructureKHR accelerationStructure_ ) VULKAN_HPP_NOEXCEPT
    {
      accelerationStructure = accelerationStructure_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureCaptureDescriptorDataInfoEXT &
      setAccelerationStructureNV( AccelerationStructureNV accelerationStructureNV_ ) VULKAN_HPP_NOEXCEPT
    {
      accelerationStructureNV = accelerationStructureNV_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_SETTERS*/

    operator VkAccelerationStructureCaptureDescriptorDataInfoEXT const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkAccelerationStructureCaptureDescriptorDataInfoEXT *>( this );
    }

    operator VkAccelerationStructureCaptureDescriptorDataInfoEXT &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkAccelerationStructureCaptureDescriptorDataInfoEXT *>( this );
    }

    operator VkAccelerationStructureCaptureDescriptorDataInfoEXT const *() const VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<const VkAccelerationStructureCaptureDescriptorDataInfoEXT *>( this );
    }

    operator VkAccelerationStructureCaptureDescriptorDataInfoEXT *() VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<VkAccelerationStructureCaptureDescriptorDataInfoEXT *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<StructureType const &, const void * const &, AccelerationStructureKHR const &, AccelerationStructureNV const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, accelerationStructure, accelerationStructureNV );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( AccelerationStructureCaptureDescriptorDataInfoEXT const & ) const = default;
#else
    bool operator==( AccelerationStructureCaptureDescriptorDataInfoEXT const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( accelerationStructure == rhs.accelerationStructure ) &&
             ( accelerationStructureNV == rhs.accelerationStructureNV );
#  endif
    }

    bool operator!=( AccelerationStructureCaptureDescriptorDataInfoEXT const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    StructureType            sType                   = StructureType::eAccelerationStructureCaptureDescriptorDataInfoEXT;
    const void *             pNext                   = {};
    AccelerationStructureKHR accelerationStructure   = {};
    AccelerationStructureNV  accelerationStructureNV = {};
  };

  template <>
  struct CppType<StructureType, StructureType::eAccelerationStructureCaptureDescriptorDataInfoEXT>
  {
    using Type = AccelerationStructureCaptureDescriptorDataInfoEXT;
  };

  // wrapper struct for struct VkAccelerationStructureCreateInfoKHR, see
  // https://registry.khronos.org/vulkan/specs/latest/man/html/VkAccelerationStructureCreateInfoKHR.html
  struct AccelerationStructureCreateInfoKHR
  {
    using NativeType = VkAccelerationStructureCreateInfoKHR;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eAccelerationStructureCreateInfoKHR;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR AccelerationStructureCreateInfoKHR( AccelerationStructureCreateFlagsKHR createFlags_   = {},
                                                             Buffer                              buffer_        = {},
                                                             DeviceSize                          offset_        = {},
                                                             DeviceSize                          size_          = {},
                                                             AccelerationStructureTypeKHR        type_          = AccelerationStructureTypeKHR::eTopLevel,
                                                             DeviceAddress                       deviceAddress_ = {},
                                                             const void *                        pNext_         = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , createFlags{ createFlags_ }
      , buffer{ buffer_ }
      , offset{ offset_ }
      , size{ size_ }
      , type{ type_ }
      , deviceAddress{ deviceAddress_ }
    {
    }

    VULKAN_HPP_CONSTEXPR AccelerationStructureCreateInfoKHR( AccelerationStructureCreateInfoKHR const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    AccelerationStructureCreateInfoKHR( VkAccelerationStructureCreateInfoKHR const & rhs ) VULKAN_HPP_NOEXCEPT
      : AccelerationStructureCreateInfoKHR( *reinterpret_cast<AccelerationStructureCreateInfoKHR const *>( &rhs ) )
    {
    }

    AccelerationStructureCreateInfoKHR & operator=( AccelerationStructureCreateInfoKHR const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    AccelerationStructureCreateInfoKHR & operator=( VkAccelerationStructureCreateInfoKHR const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<AccelerationStructureCreateInfoKHR const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureCreateInfoKHR & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureCreateInfoKHR & setCreateFlags( AccelerationStructureCreateFlagsKHR createFlags_ ) VULKAN_HPP_NOEXCEPT
    {
      createFlags = createFlags_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureCreateInfoKHR & setBuffer( Buffer buffer_ ) VULKAN_HPP_NOEXCEPT
    {
      buffer = buffer_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureCreateInfoKHR & setOffset( DeviceSize offset_ ) VULKAN_HPP_NOEXCEPT
    {
      offset = offset_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureCreateInfoKHR & setSize( DeviceSize size_ ) VULKAN_HPP_NOEXCEPT
    {
      size = size_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureCreateInfoKHR & setType( AccelerationStructureTypeKHR type_ ) VULKAN_HPP_NOEXCEPT
    {
      type = type_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureCreateInfoKHR & setDeviceAddress( DeviceAddress deviceAddress_ ) VULKAN_HPP_NOEXCEPT
    {
      deviceAddress = deviceAddress_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_SETTERS*/

    operator VkAccelerationStructureCreateInfoKHR const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkAccelerationStructureCreateInfoKHR *>( this );
    }

    operator VkAccelerationStructureCreateInfoKHR &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkAccelerationStructureCreateInfoKHR *>( this );
    }

    operator VkAccelerationStructureCreateInfoKHR const *() const VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<const VkAccelerationStructureCreateInfoKHR *>( this );
    }

    operator VkAccelerationStructureCreateInfoKHR *() VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<VkAccelerationStructureCreateInfoKHR *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<StructureType const &,
               const void * const &,
               AccelerationStructureCreateFlagsKHR const &,
               Buffer const &,
               DeviceSize const &,
               DeviceSize const &,
               AccelerationStructureTypeKHR const &,
               DeviceAddress const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, createFlags, buffer, offset, size, type, deviceAddress );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( AccelerationStructureCreateInfoKHR const & ) const = default;
#else
    bool operator==( AccelerationStructureCreateInfoKHR const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( createFlags == rhs.createFlags ) && ( buffer == rhs.buffer ) && ( offset == rhs.offset ) &&
             ( size == rhs.size ) && ( type == rhs.type ) && ( deviceAddress == rhs.deviceAddress );
#  endif
    }

    bool operator!=( AccelerationStructureCreateInfoKHR const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    StructureType                       sType         = StructureType::eAccelerationStructureCreateInfoKHR;
    const void *                        pNext         = {};
    AccelerationStructureCreateFlagsKHR createFlags   = {};
    Buffer                              buffer        = {};
    DeviceSize                          offset        = {};
    DeviceSize                          size          = {};
    AccelerationStructureTypeKHR        type          = AccelerationStructureTypeKHR::eTopLevel;
    DeviceAddress                       deviceAddress = {};
  };

  template <>
  struct CppType<StructureType, StructureType::eAccelerationStructureCreateInfoKHR>
  {
    using Type = AccelerationStructureCreateInfoKHR;
  };

  // wrapper struct for struct VkGeometryTrianglesNV, see https://registry.khronos.org/vulkan/specs/latest/man/html/VkGeometryTrianglesNV.html
  struct GeometryTrianglesNV
  {
    using NativeType = VkGeometryTrianglesNV;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eGeometryTrianglesNV;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR GeometryTrianglesNV( Buffer       vertexData_      = {},
                                              DeviceSize   vertexOffset_    = {},
                                              uint32_t     vertexCount_     = {},
                                              DeviceSize   vertexStride_    = {},
                                              Format       vertexFormat_    = Format::eUndefined,
                                              Buffer       indexData_       = {},
                                              DeviceSize   indexOffset_     = {},
                                              uint32_t     indexCount_      = {},
                                              IndexType    indexType_       = IndexType::eUint16,
                                              Buffer       transformData_   = {},
                                              DeviceSize   transformOffset_ = {},
                                              const void * pNext_           = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , vertexData{ vertexData_ }
      , vertexOffset{ vertexOffset_ }
      , vertexCount{ vertexCount_ }
      , vertexStride{ vertexStride_ }
      , vertexFormat{ vertexFormat_ }
      , indexData{ indexData_ }
      , indexOffset{ indexOffset_ }
      , indexCount{ indexCount_ }
      , indexType{ indexType_ }
      , transformData{ transformData_ }
      , transformOffset{ transformOffset_ }
    {
    }

    VULKAN_HPP_CONSTEXPR GeometryTrianglesNV( GeometryTrianglesNV const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    GeometryTrianglesNV( VkGeometryTrianglesNV const & rhs ) VULKAN_HPP_NOEXCEPT : GeometryTrianglesNV( *reinterpret_cast<GeometryTrianglesNV const *>( &rhs ) )
    {
    }

    GeometryTrianglesNV & operator=( GeometryTrianglesNV const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    GeometryTrianglesNV & operator=( VkGeometryTrianglesNV const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<GeometryTrianglesNV const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 GeometryTrianglesNV & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 GeometryTrianglesNV & setVertexData( Buffer vertexData_ ) VULKAN_HPP_NOEXCEPT
    {
      vertexData = vertexData_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 GeometryTrianglesNV & setVertexOffset( DeviceSize vertexOffset_ ) VULKAN_HPP_NOEXCEPT
    {
      vertexOffset = vertexOffset_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 GeometryTrianglesNV & setVertexCount( uint32_t vertexCount_ ) VULKAN_HPP_NOEXCEPT
    {
      vertexCount = vertexCount_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 GeometryTrianglesNV & setVertexStride( DeviceSize vertexStride_ ) VULKAN_HPP_NOEXCEPT
    {
      vertexStride = vertexStride_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 GeometryTrianglesNV & setVertexFormat( Format vertexFormat_ ) VULKAN_HPP_NOEXCEPT
    {
      vertexFormat = vertexFormat_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 GeometryTrianglesNV & setIndexData( Buffer indexData_ ) VULKAN_HPP_NOEXCEPT
    {
      indexData = indexData_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 GeometryTrianglesNV & setIndexOffset( DeviceSize indexOffset_ ) VULKAN_HPP_NOEXCEPT
    {
      indexOffset = indexOffset_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 GeometryTrianglesNV & setIndexCount( uint32_t indexCount_ ) VULKAN_HPP_NOEXCEPT
    {
      indexCount = indexCount_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 GeometryTrianglesNV & setIndexType( IndexType indexType_ ) VULKAN_HPP_NOEXCEPT
    {
      indexType = indexType_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 GeometryTrianglesNV & setTransformData( Buffer transformData_ ) VULKAN_HPP_NOEXCEPT
    {
      transformData = transformData_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 GeometryTrianglesNV & setTransformOffset( DeviceSize transformOffset_ ) VULKAN_HPP_NOEXCEPT
    {
      transformOffset = transformOffset_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_SETTERS*/

    operator VkGeometryTrianglesNV const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkGeometryTrianglesNV *>( this );
    }

    operator VkGeometryTrianglesNV &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkGeometryTrianglesNV *>( this );
    }

    operator VkGeometryTrianglesNV const *() const VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<const VkGeometryTrianglesNV *>( this );
    }

    operator VkGeometryTrianglesNV *() VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<VkGeometryTrianglesNV *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<StructureType const &,
               const void * const &,
               Buffer const &,
               DeviceSize const &,
               uint32_t const &,
               DeviceSize const &,
               Format const &,
               Buffer const &,
               DeviceSize const &,
               uint32_t const &,
               IndexType const &,
               Buffer const &,
               DeviceSize const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType,
                       pNext,
                       vertexData,
                       vertexOffset,
                       vertexCount,
                       vertexStride,
                       vertexFormat,
                       indexData,
                       indexOffset,
                       indexCount,
                       indexType,
                       transformData,
                       transformOffset );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( GeometryTrianglesNV const & ) const = default;
#else
    bool operator==( GeometryTrianglesNV const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( vertexData == rhs.vertexData ) && ( vertexOffset == rhs.vertexOffset ) &&
             ( vertexCount == rhs.vertexCount ) && ( vertexStride == rhs.vertexStride ) && ( vertexFormat == rhs.vertexFormat ) &&
             ( indexData == rhs.indexData ) && ( indexOffset == rhs.indexOffset ) && ( indexCount == rhs.indexCount ) && ( indexType == rhs.indexType ) &&
             ( transformData == rhs.transformData ) && ( transformOffset == rhs.transformOffset );
#  endif
    }

    bool operator!=( GeometryTrianglesNV const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    StructureType sType           = StructureType::eGeometryTrianglesNV;
    const void *  pNext           = {};
    Buffer        vertexData      = {};
    DeviceSize    vertexOffset    = {};
    uint32_t      vertexCount     = {};
    DeviceSize    vertexStride    = {};
    Format        vertexFormat    = Format::eUndefined;
    Buffer        indexData       = {};
    DeviceSize    indexOffset     = {};
    uint32_t      indexCount      = {};
    IndexType     indexType       = IndexType::eUint16;
    Buffer        transformData   = {};
    DeviceSize    transformOffset = {};
  };

  template <>
  struct CppType<StructureType, StructureType::eGeometryTrianglesNV>
  {
    using Type = GeometryTrianglesNV;
  };

  // wrapper struct for struct VkGeometryAABBNV, see https://registry.khronos.org/vulkan/specs/latest/man/html/VkGeometryAABBNV.html
  struct GeometryAABBNV
  {
    using NativeType = VkGeometryAABBNV;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eGeometryAabbNV;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR GeometryAABBNV(
      Buffer aabbData_ = {}, uint32_t numAABBs_ = {}, uint32_t stride_ = {}, DeviceSize offset_ = {}, const void * pNext_ = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , aabbData{ aabbData_ }
      , numAABBs{ numAABBs_ }
      , stride{ stride_ }
      , offset{ offset_ }
    {
    }

    VULKAN_HPP_CONSTEXPR GeometryAABBNV( GeometryAABBNV const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    GeometryAABBNV( VkGeometryAABBNV const & rhs ) VULKAN_HPP_NOEXCEPT : GeometryAABBNV( *reinterpret_cast<GeometryAABBNV const *>( &rhs ) ) {}

    GeometryAABBNV & operator=( GeometryAABBNV const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    GeometryAABBNV & operator=( VkGeometryAABBNV const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<GeometryAABBNV const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 GeometryAABBNV & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 GeometryAABBNV & setAabbData( Buffer aabbData_ ) VULKAN_HPP_NOEXCEPT
    {
      aabbData = aabbData_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 GeometryAABBNV & setNumAABBs( uint32_t numAABBs_ ) VULKAN_HPP_NOEXCEPT
    {
      numAABBs = numAABBs_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 GeometryAABBNV & setStride( uint32_t stride_ ) VULKAN_HPP_NOEXCEPT
    {
      stride = stride_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 GeometryAABBNV & setOffset( DeviceSize offset_ ) VULKAN_HPP_NOEXCEPT
    {
      offset = offset_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_SETTERS*/

    operator VkGeometryAABBNV const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkGeometryAABBNV *>( this );
    }

    operator VkGeometryAABBNV &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkGeometryAABBNV *>( this );
    }

    operator VkGeometryAABBNV const *() const VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<const VkGeometryAABBNV *>( this );
    }

    operator VkGeometryAABBNV *() VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<VkGeometryAABBNV *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<StructureType const &, const void * const &, Buffer const &, uint32_t const &, uint32_t const &, DeviceSize const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, aabbData, numAABBs, stride, offset );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( GeometryAABBNV const & ) const = default;
#else
    bool operator==( GeometryAABBNV const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( aabbData == rhs.aabbData ) && ( numAABBs == rhs.numAABBs ) && ( stride == rhs.stride ) &&
             ( offset == rhs.offset );
#  endif
    }

    bool operator!=( GeometryAABBNV const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    StructureType sType    = StructureType::eGeometryAabbNV;
    const void *  pNext    = {};
    Buffer        aabbData = {};
    uint32_t      numAABBs = {};
    uint32_t      stride   = {};
    DeviceSize    offset   = {};
  };

  template <>
  struct CppType<StructureType, StructureType::eGeometryAabbNV>
  {
    using Type = GeometryAABBNV;
  };

  // wrapper struct for struct VkGeometryDataNV, see https://registry.khronos.org/vulkan/specs/latest/man/html/VkGeometryDataNV.html
  struct GeometryDataNV
  {
    using NativeType = VkGeometryDataNV;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR GeometryDataNV( GeometryTrianglesNV triangles_ = {}, GeometryAABBNV aabbs_ = {} ) VULKAN_HPP_NOEXCEPT
      : triangles{ triangles_ }
      , aabbs{ aabbs_ }
    {
    }

    VULKAN_HPP_CONSTEXPR GeometryDataNV( GeometryDataNV const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    GeometryDataNV( VkGeometryDataNV const & rhs ) VULKAN_HPP_NOEXCEPT : GeometryDataNV( *reinterpret_cast<GeometryDataNV const *>( &rhs ) ) {}

    GeometryDataNV & operator=( GeometryDataNV const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    GeometryDataNV & operator=( VkGeometryDataNV const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<GeometryDataNV const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 GeometryDataNV & setTriangles( GeometryTrianglesNV const & triangles_ ) VULKAN_HPP_NOEXCEPT
    {
      triangles = triangles_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 GeometryDataNV & setAabbs( GeometryAABBNV const & aabbs_ ) VULKAN_HPP_NOEXCEPT
    {
      aabbs = aabbs_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_SETTERS*/

    operator VkGeometryDataNV const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkGeometryDataNV *>( this );
    }

    operator VkGeometryDataNV &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkGeometryDataNV *>( this );
    }

    operator VkGeometryDataNV const *() const VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<const VkGeometryDataNV *>( this );
    }

    operator VkGeometryDataNV *() VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<VkGeometryDataNV *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<GeometryTrianglesNV const &, GeometryAABBNV const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( triangles, aabbs );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( GeometryDataNV const & ) const = default;
#else
    bool operator==( GeometryDataNV const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( triangles == rhs.triangles ) && ( aabbs == rhs.aabbs );
#  endif
    }

    bool operator!=( GeometryDataNV const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    GeometryTrianglesNV triangles = {};
    GeometryAABBNV      aabbs     = {};
  };

  // wrapper struct for struct VkGeometryNV, see https://registry.khronos.org/vulkan/specs/latest/man/html/VkGeometryNV.html
  struct GeometryNV
  {
    using NativeType = VkGeometryNV;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eGeometryNV;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR GeometryNV( GeometryTypeKHR  geometryType_ = GeometryTypeKHR::eTriangles,
                                     GeometryDataNV   geometry_     = {},
                                     GeometryFlagsKHR flags_        = {},
                                     const void *     pNext_        = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , geometryType{ geometryType_ }
      , geometry{ geometry_ }
      , flags{ flags_ }
    {
    }

    VULKAN_HPP_CONSTEXPR GeometryNV( GeometryNV const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    GeometryNV( VkGeometryNV const & rhs ) VULKAN_HPP_NOEXCEPT : GeometryNV( *reinterpret_cast<GeometryNV const *>( &rhs ) ) {}

    GeometryNV & operator=( GeometryNV const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    GeometryNV & operator=( VkGeometryNV const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<GeometryNV const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 GeometryNV & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 GeometryNV & setGeometryType( GeometryTypeKHR geometryType_ ) VULKAN_HPP_NOEXCEPT
    {
      geometryType = geometryType_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 GeometryNV & setGeometry( GeometryDataNV const & geometry_ ) VULKAN_HPP_NOEXCEPT
    {
      geometry = geometry_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 GeometryNV & setFlags( GeometryFlagsKHR flags_ ) VULKAN_HPP_NOEXCEPT
    {
      flags = flags_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_SETTERS*/

    operator VkGeometryNV const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkGeometryNV *>( this );
    }

    operator VkGeometryNV &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkGeometryNV *>( this );
    }

    operator VkGeometryNV const *() const VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<const VkGeometryNV *>( this );
    }

    operator VkGeometryNV *() VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<VkGeometryNV *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<StructureType const &, const void * const &, GeometryTypeKHR const &, GeometryDataNV const &, GeometryFlagsKHR const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, geometryType, geometry, flags );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( GeometryNV const & ) const = default;
#else
    bool operator==( GeometryNV const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( geometryType == rhs.geometryType ) && ( geometry == rhs.geometry ) && ( flags == rhs.flags );
#  endif
    }

    bool operator!=( GeometryNV const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    StructureType    sType        = StructureType::eGeometryNV;
    const void *     pNext        = {};
    GeometryTypeKHR  geometryType = GeometryTypeKHR::eTriangles;
    GeometryDataNV   geometry     = {};
    GeometryFlagsKHR flags        = {};
  };

  template <>
  struct CppType<StructureType, StructureType::eGeometryNV>
  {
    using Type = GeometryNV;
  };

  // wrapper struct for struct VkAccelerationStructureInfoNV, see https://registry.khronos.org/vulkan/specs/latest/man/html/VkAccelerationStructureInfoNV.html
  struct AccelerationStructureInfoNV
  {
    using NativeType = VkAccelerationStructureInfoNV;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eAccelerationStructureInfoNV;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR AccelerationStructureInfoNV( AccelerationStructureTypeNV       type_          = {},
                                                      BuildAccelerationStructureFlagsNV flags_         = {},
                                                      uint32_t                          instanceCount_ = {},
                                                      uint32_t                          geometryCount_ = {},
                                                      const GeometryNV *                pGeometries_   = {},
                                                      const void *                      pNext_         = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , type{ type_ }
      , flags{ flags_ }
      , instanceCount{ instanceCount_ }
      , geometryCount{ geometryCount_ }
      , pGeometries{ pGeometries_ }
    {
    }

    VULKAN_HPP_CONSTEXPR AccelerationStructureInfoNV( AccelerationStructureInfoNV const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    AccelerationStructureInfoNV( VkAccelerationStructureInfoNV const & rhs ) VULKAN_HPP_NOEXCEPT
      : AccelerationStructureInfoNV( *reinterpret_cast<AccelerationStructureInfoNV const *>( &rhs ) )
    {
    }

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    AccelerationStructureInfoNV( AccelerationStructureTypeNV                       type_,
                                 BuildAccelerationStructureFlagsNV                 flags_,
                                 uint32_t                                          instanceCount_,
                                 ArrayProxyNoTemporaries<const GeometryNV> const & geometries_,
                                 const void *                                      pNext_ = nullptr )
      : pNext( pNext_ )
      , type( type_ )
      , flags( flags_ )
      , instanceCount( instanceCount_ )
      , geometryCount( static_cast<uint32_t>( geometries_.size() ) )
      , pGeometries( geometries_.data() )
    {
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/

    AccelerationStructureInfoNV & operator=( AccelerationStructureInfoNV const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    AccelerationStructureInfoNV & operator=( VkAccelerationStructureInfoNV const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<AccelerationStructureInfoNV const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureInfoNV & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureInfoNV & setType( AccelerationStructureTypeNV type_ ) VULKAN_HPP_NOEXCEPT
    {
      type = type_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureInfoNV & setFlags( BuildAccelerationStructureFlagsNV flags_ ) VULKAN_HPP_NOEXCEPT
    {
      flags = flags_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureInfoNV & setInstanceCount( uint32_t instanceCount_ ) VULKAN_HPP_NOEXCEPT
    {
      instanceCount = instanceCount_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureInfoNV & setGeometryCount( uint32_t geometryCount_ ) VULKAN_HPP_NOEXCEPT
    {
      geometryCount = geometryCount_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureInfoNV & setPGeometries( const GeometryNV * pGeometries_ ) VULKAN_HPP_NOEXCEPT
    {
      pGeometries = pGeometries_;
      return *this;
    }

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    AccelerationStructureInfoNV & setGeometries( ArrayProxyNoTemporaries<const GeometryNV> const & geometries_ ) VULKAN_HPP_NOEXCEPT
    {
      geometryCount = static_cast<uint32_t>( geometries_.size() );
      pGeometries   = geometries_.data();
      return *this;
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/
#endif   /*VULKAN_HPP_NO_SETTERS*/

    operator VkAccelerationStructureInfoNV const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkAccelerationStructureInfoNV *>( this );
    }

    operator VkAccelerationStructureInfoNV &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkAccelerationStructureInfoNV *>( this );
    }

    operator VkAccelerationStructureInfoNV const *() const VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<const VkAccelerationStructureInfoNV *>( this );
    }

    operator VkAccelerationStructureInfoNV *() VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<VkAccelerationStructureInfoNV *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<StructureType const &,
               const void * const &,
               AccelerationStructureTypeNV const &,
               BuildAccelerationStructureFlagsNV const &,
               uint32_t const &,
               uint32_t const &,
               const GeometryNV * const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, type, flags, instanceCount, geometryCount, pGeometries );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( AccelerationStructureInfoNV const & ) const = default;
#else
    bool operator==( AccelerationStructureInfoNV const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( type == rhs.type ) && ( flags == rhs.flags ) && ( instanceCount == rhs.instanceCount ) &&
             ( geometryCount == rhs.geometryCount ) && ( pGeometries == rhs.pGeometries );
#  endif
    }

    bool operator!=( AccelerationStructureInfoNV const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    StructureType                     sType         = StructureType::eAccelerationStructureInfoNV;
    const void *                      pNext         = {};
    AccelerationStructureTypeNV       type          = {};
    BuildAccelerationStructureFlagsNV flags         = {};
    uint32_t                          instanceCount = {};
    uint32_t                          geometryCount = {};
    const GeometryNV *                pGeometries   = {};
  };

  template <>
  struct CppType<StructureType, StructureType::eAccelerationStructureInfoNV>
  {
    using Type = AccelerationStructureInfoNV;
  };

  // wrapper struct for struct VkAccelerationStructureCreateInfoNV, see
  // https://registry.khronos.org/vulkan/specs/latest/man/html/VkAccelerationStructureCreateInfoNV.html
  struct AccelerationStructureCreateInfoNV
  {
    using NativeType = VkAccelerationStructureCreateInfoNV;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eAccelerationStructureCreateInfoNV;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR AccelerationStructureCreateInfoNV( DeviceSize                  compactedSize_ = {},
                                                            AccelerationStructureInfoNV info_          = {},
                                                            const void *                pNext_         = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , compactedSize{ compactedSize_ }
      , info{ info_ }
    {
    }

    VULKAN_HPP_CONSTEXPR AccelerationStructureCreateInfoNV( AccelerationStructureCreateInfoNV const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    AccelerationStructureCreateInfoNV( VkAccelerationStructureCreateInfoNV const & rhs ) VULKAN_HPP_NOEXCEPT
      : AccelerationStructureCreateInfoNV( *reinterpret_cast<AccelerationStructureCreateInfoNV const *>( &rhs ) )
    {
    }

    AccelerationStructureCreateInfoNV & operator=( AccelerationStructureCreateInfoNV const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    AccelerationStructureCreateInfoNV & operator=( VkAccelerationStructureCreateInfoNV const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<AccelerationStructureCreateInfoNV const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureCreateInfoNV & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureCreateInfoNV & setCompactedSize( DeviceSize compactedSize_ ) VULKAN_HPP_NOEXCEPT
    {
      compactedSize = compactedSize_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureCreateInfoNV & setInfo( AccelerationStructureInfoNV const & info_ ) VULKAN_HPP_NOEXCEPT
    {
      info = info_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_SETTERS*/

    operator VkAccelerationStructureCreateInfoNV const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkAccelerationStructureCreateInfoNV *>( this );
    }

    operator VkAccelerationStructureCreateInfoNV &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkAccelerationStructureCreateInfoNV *>( this );
    }

    operator VkAccelerationStructureCreateInfoNV const *() const VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<const VkAccelerationStructureCreateInfoNV *>( this );
    }

    operator VkAccelerationStructureCreateInfoNV *() VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<VkAccelerationStructureCreateInfoNV *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<StructureType const &, const void * const &, DeviceSize const &, AccelerationStructureInfoNV const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, compactedSize, info );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( AccelerationStructureCreateInfoNV const & ) const = default;
#else
    bool operator==( AccelerationStructureCreateInfoNV const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( compactedSize == rhs.compactedSize ) && ( info == rhs.info );
#  endif
    }

    bool operator!=( AccelerationStructureCreateInfoNV const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    StructureType               sType         = StructureType::eAccelerationStructureCreateInfoNV;
    const void *                pNext         = {};
    DeviceSize                  compactedSize = {};
    AccelerationStructureInfoNV info          = {};
  };

  template <>
  struct CppType<StructureType, StructureType::eAccelerationStructureCreateInfoNV>
  {
    using Type = AccelerationStructureCreateInfoNV;
  };

  // wrapper struct for struct VkAccelerationStructureDeviceAddressInfoKHR, see
  // https://registry.khronos.org/vulkan/specs/latest/man/html/VkAccelerationStructureDeviceAddressInfoKHR.html
  struct AccelerationStructureDeviceAddressInfoKHR
  {
    using NativeType = VkAccelerationStructureDeviceAddressInfoKHR;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eAccelerationStructureDeviceAddressInfoKHR;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR AccelerationStructureDeviceAddressInfoKHR( AccelerationStructureKHR accelerationStructure_ = {},
                                                                    const void *             pNext_                 = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , accelerationStructure{ accelerationStructure_ }
    {
    }

    VULKAN_HPP_CONSTEXPR AccelerationStructureDeviceAddressInfoKHR( AccelerationStructureDeviceAddressInfoKHR const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    AccelerationStructureDeviceAddressInfoKHR( VkAccelerationStructureDeviceAddressInfoKHR const & rhs ) VULKAN_HPP_NOEXCEPT
      : AccelerationStructureDeviceAddressInfoKHR( *reinterpret_cast<AccelerationStructureDeviceAddressInfoKHR const *>( &rhs ) )
    {
    }

    AccelerationStructureDeviceAddressInfoKHR & operator=( AccelerationStructureDeviceAddressInfoKHR const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    AccelerationStructureDeviceAddressInfoKHR & operator=( VkAccelerationStructureDeviceAddressInfoKHR const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<AccelerationStructureDeviceAddressInfoKHR const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureDeviceAddressInfoKHR & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureDeviceAddressInfoKHR &
      setAccelerationStructure( AccelerationStructureKHR accelerationStructure_ ) VULKAN_HPP_NOEXCEPT
    {
      accelerationStructure = accelerationStructure_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_SETTERS*/

    operator VkAccelerationStructureDeviceAddressInfoKHR const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkAccelerationStructureDeviceAddressInfoKHR *>( this );
    }

    operator VkAccelerationStructureDeviceAddressInfoKHR &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkAccelerationStructureDeviceAddressInfoKHR *>( this );
    }

    operator VkAccelerationStructureDeviceAddressInfoKHR const *() const VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<const VkAccelerationStructureDeviceAddressInfoKHR *>( this );
    }

    operator VkAccelerationStructureDeviceAddressInfoKHR *() VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<VkAccelerationStructureDeviceAddressInfoKHR *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<StructureType const &, const void * const &, AccelerationStructureKHR const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, accelerationStructure );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( AccelerationStructureDeviceAddressInfoKHR const & ) const = default;
#else
    bool operator==( AccelerationStructureDeviceAddressInfoKHR const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( accelerationStructure == rhs.accelerationStructure );
#  endif
    }

    bool operator!=( AccelerationStructureDeviceAddressInfoKHR const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    StructureType            sType                 = StructureType::eAccelerationStructureDeviceAddressInfoKHR;
    const void *             pNext                 = {};
    AccelerationStructureKHR accelerationStructure = {};
  };

  template <>
  struct CppType<StructureType, StructureType::eAccelerationStructureDeviceAddressInfoKHR>
  {
    using Type = AccelerationStructureDeviceAddressInfoKHR;
  };

  // wrapper struct for struct VkAccelerationStructureGeometryLinearSweptSpheresDataNV, see
  // https://registry.khronos.org/vulkan/specs/latest/man/html/VkAccelerationStructureGeometryLinearSweptSpheresDataNV.html
  struct AccelerationStructureGeometryLinearSweptSpheresDataNV
  {
    using NativeType = VkAccelerationStructureGeometryLinearSweptSpheresDataNV;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eAccelerationStructureGeometryLinearSweptSpheresDataNV;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR_14
      AccelerationStructureGeometryLinearSweptSpheresDataNV( Format                              vertexFormat_ = Format::eUndefined,
                                                             DeviceOrHostAddressConstKHR         vertexData_   = {},
                                                             DeviceSize                          vertexStride_ = {},
                                                             Format                              radiusFormat_ = Format::eUndefined,
                                                             DeviceOrHostAddressConstKHR         radiusData_   = {},
                                                             DeviceSize                          radiusStride_ = {},
                                                             IndexType                           indexType_    = IndexType::eUint16,
                                                             DeviceOrHostAddressConstKHR         indexData_    = {},
                                                             DeviceSize                          indexStride_  = {},
                                                             RayTracingLssIndexingModeNV         indexingMode_ = RayTracingLssIndexingModeNV::eList,
                                                             RayTracingLssPrimitiveEndCapsModeNV endCapsMode_  = RayTracingLssPrimitiveEndCapsModeNV::eNone,
                                                             const void *                        pNext_        = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , vertexFormat{ vertexFormat_ }
      , vertexData{ vertexData_ }
      , vertexStride{ vertexStride_ }
      , radiusFormat{ radiusFormat_ }
      , radiusData{ radiusData_ }
      , radiusStride{ radiusStride_ }
      , indexType{ indexType_ }
      , indexData{ indexData_ }
      , indexStride{ indexStride_ }
      , indexingMode{ indexingMode_ }
      , endCapsMode{ endCapsMode_ }
    {
    }

    VULKAN_HPP_CONSTEXPR_14
      AccelerationStructureGeometryLinearSweptSpheresDataNV( AccelerationStructureGeometryLinearSweptSpheresDataNV const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    AccelerationStructureGeometryLinearSweptSpheresDataNV( VkAccelerationStructureGeometryLinearSweptSpheresDataNV const & rhs ) VULKAN_HPP_NOEXCEPT
      : AccelerationStructureGeometryLinearSweptSpheresDataNV( *reinterpret_cast<AccelerationStructureGeometryLinearSweptSpheresDataNV const *>( &rhs ) )
    {
    }

    AccelerationStructureGeometryLinearSweptSpheresDataNV &
      operator=( AccelerationStructureGeometryLinearSweptSpheresDataNV const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    AccelerationStructureGeometryLinearSweptSpheresDataNV & operator=( VkAccelerationStructureGeometryLinearSweptSpheresDataNV const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<AccelerationStructureGeometryLinearSweptSpheresDataNV const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureGeometryLinearSweptSpheresDataNV & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureGeometryLinearSweptSpheresDataNV & setVertexFormat( Format vertexFormat_ ) VULKAN_HPP_NOEXCEPT
    {
      vertexFormat = vertexFormat_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureGeometryLinearSweptSpheresDataNV &
      setVertexData( DeviceOrHostAddressConstKHR const & vertexData_ ) VULKAN_HPP_NOEXCEPT
    {
      vertexData = vertexData_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureGeometryLinearSweptSpheresDataNV & setVertexStride( DeviceSize vertexStride_ ) VULKAN_HPP_NOEXCEPT
    {
      vertexStride = vertexStride_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureGeometryLinearSweptSpheresDataNV & setRadiusFormat( Format radiusFormat_ ) VULKAN_HPP_NOEXCEPT
    {
      radiusFormat = radiusFormat_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureGeometryLinearSweptSpheresDataNV &
      setRadiusData( DeviceOrHostAddressConstKHR const & radiusData_ ) VULKAN_HPP_NOEXCEPT
    {
      radiusData = radiusData_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureGeometryLinearSweptSpheresDataNV & setRadiusStride( DeviceSize radiusStride_ ) VULKAN_HPP_NOEXCEPT
    {
      radiusStride = radiusStride_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureGeometryLinearSweptSpheresDataNV & setIndexType( IndexType indexType_ ) VULKAN_HPP_NOEXCEPT
    {
      indexType = indexType_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureGeometryLinearSweptSpheresDataNV &
      setIndexData( DeviceOrHostAddressConstKHR const & indexData_ ) VULKAN_HPP_NOEXCEPT
    {
      indexData = indexData_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureGeometryLinearSweptSpheresDataNV & setIndexStride( DeviceSize indexStride_ ) VULKAN_HPP_NOEXCEPT
    {
      indexStride = indexStride_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureGeometryLinearSweptSpheresDataNV &
      setIndexingMode( RayTracingLssIndexingModeNV indexingMode_ ) VULKAN_HPP_NOEXCEPT
    {
      indexingMode = indexingMode_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureGeometryLinearSweptSpheresDataNV &
      setEndCapsMode( RayTracingLssPrimitiveEndCapsModeNV endCapsMode_ ) VULKAN_HPP_NOEXCEPT
    {
      endCapsMode = endCapsMode_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_SETTERS*/

    operator VkAccelerationStructureGeometryLinearSweptSpheresDataNV const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkAccelerationStructureGeometryLinearSweptSpheresDataNV *>( this );
    }

    operator VkAccelerationStructureGeometryLinearSweptSpheresDataNV &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkAccelerationStructureGeometryLinearSweptSpheresDataNV *>( this );
    }

    operator VkAccelerationStructureGeometryLinearSweptSpheresDataNV const *() const VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<const VkAccelerationStructureGeometryLinearSweptSpheresDataNV *>( this );
    }

    operator VkAccelerationStructureGeometryLinearSweptSpheresDataNV *() VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<VkAccelerationStructureGeometryLinearSweptSpheresDataNV *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<StructureType const &,
               const void * const &,
               Format const &,
               DeviceOrHostAddressConstKHR const &,
               DeviceSize const &,
               Format const &,
               DeviceOrHostAddressConstKHR const &,
               DeviceSize const &,
               IndexType const &,
               DeviceOrHostAddressConstKHR const &,
               DeviceSize const &,
               RayTracingLssIndexingModeNV const &,
               RayTracingLssPrimitiveEndCapsModeNV const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType,
                       pNext,
                       vertexFormat,
                       vertexData,
                       vertexStride,
                       radiusFormat,
                       radiusData,
                       radiusStride,
                       indexType,
                       indexData,
                       indexStride,
                       indexingMode,
                       endCapsMode );
    }
#endif

  public:
    StructureType                       sType        = StructureType::eAccelerationStructureGeometryLinearSweptSpheresDataNV;
    const void *                        pNext        = {};
    Format                              vertexFormat = Format::eUndefined;
    DeviceOrHostAddressConstKHR         vertexData   = {};
    DeviceSize                          vertexStride = {};
    Format                              radiusFormat = Format::eUndefined;
    DeviceOrHostAddressConstKHR         radiusData   = {};
    DeviceSize                          radiusStride = {};
    IndexType                           indexType    = IndexType::eUint16;
    DeviceOrHostAddressConstKHR         indexData    = {};
    DeviceSize                          indexStride  = {};
    RayTracingLssIndexingModeNV         indexingMode = RayTracingLssIndexingModeNV::eList;
    RayTracingLssPrimitiveEndCapsModeNV endCapsMode  = RayTracingLssPrimitiveEndCapsModeNV::eNone;
  };

  template <>
  struct CppType<StructureType, StructureType::eAccelerationStructureGeometryLinearSweptSpheresDataNV>
  {
    using Type = AccelerationStructureGeometryLinearSweptSpheresDataNV;
  };

  // wrapper struct for struct VkAccelerationStructureGeometryMotionTrianglesDataNV, see
  // https://registry.khronos.org/vulkan/specs/latest/man/html/VkAccelerationStructureGeometryMotionTrianglesDataNV.html
  struct AccelerationStructureGeometryMotionTrianglesDataNV
  {
    using NativeType = VkAccelerationStructureGeometryMotionTrianglesDataNV;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eAccelerationStructureGeometryMotionTrianglesDataNV;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureGeometryMotionTrianglesDataNV( DeviceOrHostAddressConstKHR vertexData_ = {},
                                                                                const void *                pNext_      = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , vertexData{ vertexData_ }
    {
    }

    VULKAN_HPP_CONSTEXPR_14
      AccelerationStructureGeometryMotionTrianglesDataNV( AccelerationStructureGeometryMotionTrianglesDataNV const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    AccelerationStructureGeometryMotionTrianglesDataNV( VkAccelerationStructureGeometryMotionTrianglesDataNV const & rhs ) VULKAN_HPP_NOEXCEPT
      : AccelerationStructureGeometryMotionTrianglesDataNV( *reinterpret_cast<AccelerationStructureGeometryMotionTrianglesDataNV const *>( &rhs ) )
    {
    }

    AccelerationStructureGeometryMotionTrianglesDataNV &
      operator=( AccelerationStructureGeometryMotionTrianglesDataNV const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    AccelerationStructureGeometryMotionTrianglesDataNV & operator=( VkAccelerationStructureGeometryMotionTrianglesDataNV const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<AccelerationStructureGeometryMotionTrianglesDataNV const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureGeometryMotionTrianglesDataNV & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureGeometryMotionTrianglesDataNV &
      setVertexData( DeviceOrHostAddressConstKHR const & vertexData_ ) VULKAN_HPP_NOEXCEPT
    {
      vertexData = vertexData_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_SETTERS*/

    operator VkAccelerationStructureGeometryMotionTrianglesDataNV const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkAccelerationStructureGeometryMotionTrianglesDataNV *>( this );
    }

    operator VkAccelerationStructureGeometryMotionTrianglesDataNV &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkAccelerationStructureGeometryMotionTrianglesDataNV *>( this );
    }

    operator VkAccelerationStructureGeometryMotionTrianglesDataNV const *() const VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<const VkAccelerationStructureGeometryMotionTrianglesDataNV *>( this );
    }

    operator VkAccelerationStructureGeometryMotionTrianglesDataNV *() VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<VkAccelerationStructureGeometryMotionTrianglesDataNV *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<StructureType const &, const void * const &, DeviceOrHostAddressConstKHR const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, vertexData );
    }
#endif

  public:
    StructureType               sType      = StructureType::eAccelerationStructureGeometryMotionTrianglesDataNV;
    const void *                pNext      = {};
    DeviceOrHostAddressConstKHR vertexData = {};
  };

  template <>
  struct CppType<StructureType, StructureType::eAccelerationStructureGeometryMotionTrianglesDataNV>
  {
    using Type = AccelerationStructureGeometryMotionTrianglesDataNV;
  };

  // wrapper struct for struct VkAccelerationStructureGeometrySpheresDataNV, see
  // https://registry.khronos.org/vulkan/specs/latest/man/html/VkAccelerationStructureGeometrySpheresDataNV.html
  struct AccelerationStructureGeometrySpheresDataNV
  {
    using NativeType = VkAccelerationStructureGeometrySpheresDataNV;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eAccelerationStructureGeometrySpheresDataNV;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureGeometrySpheresDataNV( Format                      vertexFormat_ = Format::eUndefined,
                                                                        DeviceOrHostAddressConstKHR vertexData_   = {},
                                                                        DeviceSize                  vertexStride_ = {},
                                                                        Format                      radiusFormat_ = Format::eUndefined,
                                                                        DeviceOrHostAddressConstKHR radiusData_   = {},
                                                                        DeviceSize                  radiusStride_ = {},
                                                                        IndexType                   indexType_    = IndexType::eUint16,
                                                                        DeviceOrHostAddressConstKHR indexData_    = {},
                                                                        DeviceSize                  indexStride_  = {},
                                                                        const void *                pNext_        = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , vertexFormat{ vertexFormat_ }
      , vertexData{ vertexData_ }
      , vertexStride{ vertexStride_ }
      , radiusFormat{ radiusFormat_ }
      , radiusData{ radiusData_ }
      , radiusStride{ radiusStride_ }
      , indexType{ indexType_ }
      , indexData{ indexData_ }
      , indexStride{ indexStride_ }
    {
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureGeometrySpheresDataNV( AccelerationStructureGeometrySpheresDataNV const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    AccelerationStructureGeometrySpheresDataNV( VkAccelerationStructureGeometrySpheresDataNV const & rhs ) VULKAN_HPP_NOEXCEPT
      : AccelerationStructureGeometrySpheresDataNV( *reinterpret_cast<AccelerationStructureGeometrySpheresDataNV const *>( &rhs ) )
    {
    }

    AccelerationStructureGeometrySpheresDataNV & operator=( AccelerationStructureGeometrySpheresDataNV const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    AccelerationStructureGeometrySpheresDataNV & operator=( VkAccelerationStructureGeometrySpheresDataNV const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<AccelerationStructureGeometrySpheresDataNV const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureGeometrySpheresDataNV & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureGeometrySpheresDataNV & setVertexFormat( Format vertexFormat_ ) VULKAN_HPP_NOEXCEPT
    {
      vertexFormat = vertexFormat_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureGeometrySpheresDataNV & setVertexData( DeviceOrHostAddressConstKHR const & vertexData_ ) VULKAN_HPP_NOEXCEPT
    {
      vertexData = vertexData_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureGeometrySpheresDataNV & setVertexStride( DeviceSize vertexStride_ ) VULKAN_HPP_NOEXCEPT
    {
      vertexStride = vertexStride_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureGeometrySpheresDataNV & setRadiusFormat( Format radiusFormat_ ) VULKAN_HPP_NOEXCEPT
    {
      radiusFormat = radiusFormat_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureGeometrySpheresDataNV & setRadiusData( DeviceOrHostAddressConstKHR const & radiusData_ ) VULKAN_HPP_NOEXCEPT
    {
      radiusData = radiusData_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureGeometrySpheresDataNV & setRadiusStride( DeviceSize radiusStride_ ) VULKAN_HPP_NOEXCEPT
    {
      radiusStride = radiusStride_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureGeometrySpheresDataNV & setIndexType( IndexType indexType_ ) VULKAN_HPP_NOEXCEPT
    {
      indexType = indexType_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureGeometrySpheresDataNV & setIndexData( DeviceOrHostAddressConstKHR const & indexData_ ) VULKAN_HPP_NOEXCEPT
    {
      indexData = indexData_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureGeometrySpheresDataNV & setIndexStride( DeviceSize indexStride_ ) VULKAN_HPP_NOEXCEPT
    {
      indexStride = indexStride_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_SETTERS*/

    operator VkAccelerationStructureGeometrySpheresDataNV const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkAccelerationStructureGeometrySpheresDataNV *>( this );
    }

    operator VkAccelerationStructureGeometrySpheresDataNV &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkAccelerationStructureGeometrySpheresDataNV *>( this );
    }

    operator VkAccelerationStructureGeometrySpheresDataNV const *() const VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<const VkAccelerationStructureGeometrySpheresDataNV *>( this );
    }

    operator VkAccelerationStructureGeometrySpheresDataNV *() VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<VkAccelerationStructureGeometrySpheresDataNV *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<StructureType const &,
               const void * const &,
               Format const &,
               DeviceOrHostAddressConstKHR const &,
               DeviceSize const &,
               Format const &,
               DeviceOrHostAddressConstKHR const &,
               DeviceSize const &,
               IndexType const &,
               DeviceOrHostAddressConstKHR const &,
               DeviceSize const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, vertexFormat, vertexData, vertexStride, radiusFormat, radiusData, radiusStride, indexType, indexData, indexStride );
    }
#endif

  public:
    StructureType               sType        = StructureType::eAccelerationStructureGeometrySpheresDataNV;
    const void *                pNext        = {};
    Format                      vertexFormat = Format::eUndefined;
    DeviceOrHostAddressConstKHR vertexData   = {};
    DeviceSize                  vertexStride = {};
    Format                      radiusFormat = Format::eUndefined;
    DeviceOrHostAddressConstKHR radiusData   = {};
    DeviceSize                  radiusStride = {};
    IndexType                   indexType    = IndexType::eUint16;
    DeviceOrHostAddressConstKHR indexData    = {};
    DeviceSize                  indexStride  = {};
  };

  template <>
  struct CppType<StructureType, StructureType::eAccelerationStructureGeometrySpheresDataNV>
  {
    using Type = AccelerationStructureGeometrySpheresDataNV;
  };

  // wrapper struct for struct VkTransformMatrixKHR, see https://registry.khronos.org/vulkan/specs/latest/man/html/VkTransformMatrixKHR.html
  struct TransformMatrixKHR
  {
    using NativeType = VkTransformMatrixKHR;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR_14 TransformMatrixKHR( std::array<std::array<float, 4>, 3> const & matrix_ = {} ) VULKAN_HPP_NOEXCEPT : matrix{ matrix_ } {}

    VULKAN_HPP_CONSTEXPR_14 TransformMatrixKHR( TransformMatrixKHR const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    TransformMatrixKHR( VkTransformMatrixKHR const & rhs ) VULKAN_HPP_NOEXCEPT : TransformMatrixKHR( *reinterpret_cast<TransformMatrixKHR const *>( &rhs ) ) {}

    TransformMatrixKHR & operator=( TransformMatrixKHR const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    TransformMatrixKHR & operator=( VkTransformMatrixKHR const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<TransformMatrixKHR const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 TransformMatrixKHR & setMatrix( std::array<std::array<float, 4>, 3> matrix_ ) VULKAN_HPP_NOEXCEPT
    {
      matrix = matrix_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_SETTERS*/

    operator VkTransformMatrixKHR const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkTransformMatrixKHR *>( this );
    }

    operator VkTransformMatrixKHR &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkTransformMatrixKHR *>( this );
    }

    operator VkTransformMatrixKHR const *() const VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<const VkTransformMatrixKHR *>( this );
    }

    operator VkTransformMatrixKHR *() VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<VkTransformMatrixKHR *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<ArrayWrapper2D<float, 3, 4> const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( matrix );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( TransformMatrixKHR const & ) const = default;
#else
    bool operator==( TransformMatrixKHR const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( matrix == rhs.matrix );
#  endif
    }

    bool operator!=( TransformMatrixKHR const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    ArrayWrapper2D<float, 3, 4> matrix = {};
  };

  using TransformMatrixNV = TransformMatrixKHR;

  // wrapper struct for struct VkAccelerationStructureInstanceKHR, see
  // https://registry.khronos.org/vulkan/specs/latest/man/html/VkAccelerationStructureInstanceKHR.html
  struct AccelerationStructureInstanceKHR
  {
    using NativeType = VkAccelerationStructureInstanceKHR;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureInstanceKHR( TransformMatrixKHR       transform_                              = {},
                                                              uint32_t                 instanceCustomIndex_                    = {},
                                                              uint32_t                 mask_                                   = {},
                                                              uint32_t                 instanceShaderBindingTableRecordOffset_ = {},
                                                              GeometryInstanceFlagsKHR flags_                                  = {},
                                                              uint64_t                 accelerationStructureReference_         = {} ) VULKAN_HPP_NOEXCEPT
      : transform{ transform_ }
      , instanceCustomIndex{ instanceCustomIndex_ }
      , mask{ mask_ }
      , instanceShaderBindingTableRecordOffset{ instanceShaderBindingTableRecordOffset_ }
      , flags{ flags_ }
      , accelerationStructureReference{ accelerationStructureReference_ }
    {
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureInstanceKHR( AccelerationStructureInstanceKHR const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    AccelerationStructureInstanceKHR( VkAccelerationStructureInstanceKHR const & rhs ) VULKAN_HPP_NOEXCEPT
      : AccelerationStructureInstanceKHR( *reinterpret_cast<AccelerationStructureInstanceKHR const *>( &rhs ) )
    {
    }

    AccelerationStructureInstanceKHR & operator=( AccelerationStructureInstanceKHR const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    AccelerationStructureInstanceKHR & operator=( VkAccelerationStructureInstanceKHR const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<AccelerationStructureInstanceKHR const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureInstanceKHR & setTransform( TransformMatrixKHR const & transform_ ) VULKAN_HPP_NOEXCEPT
    {
      transform = transform_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureInstanceKHR & setInstanceCustomIndex( uint32_t instanceCustomIndex_ ) VULKAN_HPP_NOEXCEPT
    {
      instanceCustomIndex = instanceCustomIndex_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureInstanceKHR & setMask( uint32_t mask_ ) VULKAN_HPP_NOEXCEPT
    {
      mask = mask_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureInstanceKHR &
      setInstanceShaderBindingTableRecordOffset( uint32_t instanceShaderBindingTableRecordOffset_ ) VULKAN_HPP_NOEXCEPT
    {
      instanceShaderBindingTableRecordOffset = instanceShaderBindingTableRecordOffset_;
      return *this;
    }

    AccelerationStructureInstanceKHR & setFlags( GeometryInstanceFlagsKHR flags_ ) VULKAN_HPP_NOEXCEPT
    {
      flags = *reinterpret_cast<VkGeometryInstanceFlagsKHR *>( &flags_ );
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureInstanceKHR & setAccelerationStructureReference( uint64_t accelerationStructureReference_ ) VULKAN_HPP_NOEXCEPT
    {
      accelerationStructureReference = accelerationStructureReference_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_SETTERS*/

    operator VkAccelerationStructureInstanceKHR const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkAccelerationStructureInstanceKHR *>( this );
    }

    operator VkAccelerationStructureInstanceKHR &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkAccelerationStructureInstanceKHR *>( this );
    }

    operator VkAccelerationStructureInstanceKHR const *() const VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<const VkAccelerationStructureInstanceKHR *>( this );
    }

    operator VkAccelerationStructureInstanceKHR *() VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<VkAccelerationStructureInstanceKHR *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<TransformMatrixKHR const &, uint32_t const &, uint32_t const &, uint32_t const &, VkGeometryInstanceFlagsKHR const &, uint64_t const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( transform, instanceCustomIndex, mask, instanceShaderBindingTableRecordOffset, flags, accelerationStructureReference );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( AccelerationStructureInstanceKHR const & ) const = default;
#else
    bool operator==( AccelerationStructureInstanceKHR const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( transform == rhs.transform ) && ( instanceCustomIndex == rhs.instanceCustomIndex ) && ( mask == rhs.mask ) &&
             ( instanceShaderBindingTableRecordOffset == rhs.instanceShaderBindingTableRecordOffset ) && ( flags == rhs.flags ) &&
             ( accelerationStructureReference == rhs.accelerationStructureReference );
#  endif
    }

    bool operator!=( AccelerationStructureInstanceKHR const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    TransformMatrixKHR         transform = {};
    uint32_t                   instanceCustomIndex                    : 24;
    uint32_t                   mask                                   : 8;
    uint32_t                   instanceShaderBindingTableRecordOffset : 24;
    VkGeometryInstanceFlagsKHR flags                                  : 8;
    uint64_t                   accelerationStructureReference = {};
  };

  using AccelerationStructureInstanceNV = AccelerationStructureInstanceKHR;

  // wrapper struct for struct VkAccelerationStructureMatrixMotionInstanceNV, see
  // https://registry.khronos.org/vulkan/specs/latest/man/html/VkAccelerationStructureMatrixMotionInstanceNV.html
  struct AccelerationStructureMatrixMotionInstanceNV
  {
    using NativeType = VkAccelerationStructureMatrixMotionInstanceNV;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureMatrixMotionInstanceNV( TransformMatrixKHR       transformT0_                            = {},
                                                                         TransformMatrixKHR       transformT1_                            = {},
                                                                         uint32_t                 instanceCustomIndex_                    = {},
                                                                         uint32_t                 mask_                                   = {},
                                                                         uint32_t                 instanceShaderBindingTableRecordOffset_ = {},
                                                                         GeometryInstanceFlagsKHR flags_                                  = {},
                                                                         uint64_t                 accelerationStructureReference_ = {} ) VULKAN_HPP_NOEXCEPT
      : transformT0{ transformT0_ }
      , transformT1{ transformT1_ }
      , instanceCustomIndex{ instanceCustomIndex_ }
      , mask{ mask_ }
      , instanceShaderBindingTableRecordOffset{ instanceShaderBindingTableRecordOffset_ }
      , flags{ flags_ }
      , accelerationStructureReference{ accelerationStructureReference_ }
    {
    }

    VULKAN_HPP_CONSTEXPR_14
      AccelerationStructureMatrixMotionInstanceNV( AccelerationStructureMatrixMotionInstanceNV const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    AccelerationStructureMatrixMotionInstanceNV( VkAccelerationStructureMatrixMotionInstanceNV const & rhs ) VULKAN_HPP_NOEXCEPT
      : AccelerationStructureMatrixMotionInstanceNV( *reinterpret_cast<AccelerationStructureMatrixMotionInstanceNV const *>( &rhs ) )
    {
    }

    AccelerationStructureMatrixMotionInstanceNV & operator=( AccelerationStructureMatrixMotionInstanceNV const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    AccelerationStructureMatrixMotionInstanceNV & operator=( VkAccelerationStructureMatrixMotionInstanceNV const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<AccelerationStructureMatrixMotionInstanceNV const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureMatrixMotionInstanceNV & setTransformT0( TransformMatrixKHR const & transformT0_ ) VULKAN_HPP_NOEXCEPT
    {
      transformT0 = transformT0_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureMatrixMotionInstanceNV & setTransformT1( TransformMatrixKHR const & transformT1_ ) VULKAN_HPP_NOEXCEPT
    {
      transformT1 = transformT1_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureMatrixMotionInstanceNV & setInstanceCustomIndex( uint32_t instanceCustomIndex_ ) VULKAN_HPP_NOEXCEPT
    {
      instanceCustomIndex = instanceCustomIndex_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureMatrixMotionInstanceNV & setMask( uint32_t mask_ ) VULKAN_HPP_NOEXCEPT
    {
      mask = mask_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureMatrixMotionInstanceNV &
      setInstanceShaderBindingTableRecordOffset( uint32_t instanceShaderBindingTableRecordOffset_ ) VULKAN_HPP_NOEXCEPT
    {
      instanceShaderBindingTableRecordOffset = instanceShaderBindingTableRecordOffset_;
      return *this;
    }

    AccelerationStructureMatrixMotionInstanceNV & setFlags( GeometryInstanceFlagsKHR flags_ ) VULKAN_HPP_NOEXCEPT
    {
      flags = *reinterpret_cast<VkGeometryInstanceFlagsKHR *>( &flags_ );
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureMatrixMotionInstanceNV &
      setAccelerationStructureReference( uint64_t accelerationStructureReference_ ) VULKAN_HPP_NOEXCEPT
    {
      accelerationStructureReference = accelerationStructureReference_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_SETTERS*/

    operator VkAccelerationStructureMatrixMotionInstanceNV const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkAccelerationStructureMatrixMotionInstanceNV *>( this );
    }

    operator VkAccelerationStructureMatrixMotionInstanceNV &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkAccelerationStructureMatrixMotionInstanceNV *>( this );
    }

    operator VkAccelerationStructureMatrixMotionInstanceNV const *() const VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<const VkAccelerationStructureMatrixMotionInstanceNV *>( this );
    }

    operator VkAccelerationStructureMatrixMotionInstanceNV *() VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<VkAccelerationStructureMatrixMotionInstanceNV *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<TransformMatrixKHR const &,
               TransformMatrixKHR const &,
               uint32_t const &,
               uint32_t const &,
               uint32_t const &,
               VkGeometryInstanceFlagsKHR const &,
               uint64_t const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( transformT0, transformT1, instanceCustomIndex, mask, instanceShaderBindingTableRecordOffset, flags, accelerationStructureReference );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( AccelerationStructureMatrixMotionInstanceNV const & ) const = default;
#else
    bool operator==( AccelerationStructureMatrixMotionInstanceNV const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( transformT0 == rhs.transformT0 ) && ( transformT1 == rhs.transformT1 ) && ( instanceCustomIndex == rhs.instanceCustomIndex ) &&
             ( mask == rhs.mask ) && ( instanceShaderBindingTableRecordOffset == rhs.instanceShaderBindingTableRecordOffset ) && ( flags == rhs.flags ) &&
             ( accelerationStructureReference == rhs.accelerationStructureReference );
#  endif
    }

    bool operator!=( AccelerationStructureMatrixMotionInstanceNV const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    TransformMatrixKHR         transformT0 = {};
    TransformMatrixKHR         transformT1 = {};
    uint32_t                   instanceCustomIndex                    : 24;
    uint32_t                   mask                                   : 8;
    uint32_t                   instanceShaderBindingTableRecordOffset : 24;
    VkGeometryInstanceFlagsKHR flags                                  : 8;
    uint64_t                   accelerationStructureReference = {};
  };

  // wrapper struct for struct VkAccelerationStructureMemoryRequirementsInfoNV, see
  // https://registry.khronos.org/vulkan/specs/latest/man/html/VkAccelerationStructureMemoryRequirementsInfoNV.html
  struct AccelerationStructureMemoryRequirementsInfoNV
  {
    using NativeType = VkAccelerationStructureMemoryRequirementsInfoNV;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eAccelerationStructureMemoryRequirementsInfoNV;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR AccelerationStructureMemoryRequirementsInfoNV(
      AccelerationStructureMemoryRequirementsTypeNV type_                  = AccelerationStructureMemoryRequirementsTypeNV::eObject,
      AccelerationStructureNV                       accelerationStructure_ = {},
      const void *                                  pNext_                 = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , type{ type_ }
      , accelerationStructure{ accelerationStructure_ }
    {
    }

    VULKAN_HPP_CONSTEXPR
      AccelerationStructureMemoryRequirementsInfoNV( AccelerationStructureMemoryRequirementsInfoNV const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    AccelerationStructureMemoryRequirementsInfoNV( VkAccelerationStructureMemoryRequirementsInfoNV const & rhs ) VULKAN_HPP_NOEXCEPT
      : AccelerationStructureMemoryRequirementsInfoNV( *reinterpret_cast<AccelerationStructureMemoryRequirementsInfoNV const *>( &rhs ) )
    {
    }

    AccelerationStructureMemoryRequirementsInfoNV & operator=( AccelerationStructureMemoryRequirementsInfoNV const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    AccelerationStructureMemoryRequirementsInfoNV & operator=( VkAccelerationStructureMemoryRequirementsInfoNV const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<AccelerationStructureMemoryRequirementsInfoNV const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureMemoryRequirementsInfoNV & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureMemoryRequirementsInfoNV & setType( AccelerationStructureMemoryRequirementsTypeNV type_ ) VULKAN_HPP_NOEXCEPT
    {
      type = type_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureMemoryRequirementsInfoNV &
      setAccelerationStructure( AccelerationStructureNV accelerationStructure_ ) VULKAN_HPP_NOEXCEPT
    {
      accelerationStructure = accelerationStructure_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_SETTERS*/

    operator VkAccelerationStructureMemoryRequirementsInfoNV const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkAccelerationStructureMemoryRequirementsInfoNV *>( this );
    }

    operator VkAccelerationStructureMemoryRequirementsInfoNV &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkAccelerationStructureMemoryRequirementsInfoNV *>( this );
    }

    operator VkAccelerationStructureMemoryRequirementsInfoNV const *() const VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<const VkAccelerationStructureMemoryRequirementsInfoNV *>( this );
    }

    operator VkAccelerationStructureMemoryRequirementsInfoNV *() VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<VkAccelerationStructureMemoryRequirementsInfoNV *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<StructureType const &, const void * const &, AccelerationStructureMemoryRequirementsTypeNV const &, AccelerationStructureNV const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, type, accelerationStructure );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( AccelerationStructureMemoryRequirementsInfoNV const & ) const = default;
#else
    bool operator==( AccelerationStructureMemoryRequirementsInfoNV const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( type == rhs.type ) && ( accelerationStructure == rhs.accelerationStructure );
#  endif
    }

    bool operator!=( AccelerationStructureMemoryRequirementsInfoNV const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    StructureType                                 sType                 = StructureType::eAccelerationStructureMemoryRequirementsInfoNV;
    const void *                                  pNext                 = {};
    AccelerationStructureMemoryRequirementsTypeNV type                  = AccelerationStructureMemoryRequirementsTypeNV::eObject;
    AccelerationStructureNV                       accelerationStructure = {};
  };

  template <>
  struct CppType<StructureType, StructureType::eAccelerationStructureMemoryRequirementsInfoNV>
  {
    using Type = AccelerationStructureMemoryRequirementsInfoNV;
  };

  // wrapper struct for struct VkAccelerationStructureMotionInfoNV, see
  // https://registry.khronos.org/vulkan/specs/latest/man/html/VkAccelerationStructureMotionInfoNV.html
  struct AccelerationStructureMotionInfoNV
  {
    using NativeType = VkAccelerationStructureMotionInfoNV;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eAccelerationStructureMotionInfoNV;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR AccelerationStructureMotionInfoNV( uint32_t                               maxInstances_ = {},
                                                            AccelerationStructureMotionInfoFlagsNV flags_        = {},
                                                            const void *                           pNext_        = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , maxInstances{ maxInstances_ }
      , flags{ flags_ }
    {
    }

    VULKAN_HPP_CONSTEXPR AccelerationStructureMotionInfoNV( AccelerationStructureMotionInfoNV const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    AccelerationStructureMotionInfoNV( VkAccelerationStructureMotionInfoNV const & rhs ) VULKAN_HPP_NOEXCEPT
      : AccelerationStructureMotionInfoNV( *reinterpret_cast<AccelerationStructureMotionInfoNV const *>( &rhs ) )
    {
    }

    AccelerationStructureMotionInfoNV & operator=( AccelerationStructureMotionInfoNV const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    AccelerationStructureMotionInfoNV & operator=( VkAccelerationStructureMotionInfoNV const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<AccelerationStructureMotionInfoNV const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureMotionInfoNV & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureMotionInfoNV & setMaxInstances( uint32_t maxInstances_ ) VULKAN_HPP_NOEXCEPT
    {
      maxInstances = maxInstances_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureMotionInfoNV & setFlags( AccelerationStructureMotionInfoFlagsNV flags_ ) VULKAN_HPP_NOEXCEPT
    {
      flags = flags_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_SETTERS*/

    operator VkAccelerationStructureMotionInfoNV const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkAccelerationStructureMotionInfoNV *>( this );
    }

    operator VkAccelerationStructureMotionInfoNV &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkAccelerationStructureMotionInfoNV *>( this );
    }

    operator VkAccelerationStructureMotionInfoNV const *() const VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<const VkAccelerationStructureMotionInfoNV *>( this );
    }

    operator VkAccelerationStructureMotionInfoNV *() VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<VkAccelerationStructureMotionInfoNV *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<StructureType const &, const void * const &, uint32_t const &, AccelerationStructureMotionInfoFlagsNV const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, maxInstances, flags );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( AccelerationStructureMotionInfoNV const & ) const = default;
#else
    bool operator==( AccelerationStructureMotionInfoNV const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( maxInstances == rhs.maxInstances ) && ( flags == rhs.flags );
#  endif
    }

    bool operator!=( AccelerationStructureMotionInfoNV const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    StructureType                          sType        = StructureType::eAccelerationStructureMotionInfoNV;
    const void *                           pNext        = {};
    uint32_t                               maxInstances = {};
    AccelerationStructureMotionInfoFlagsNV flags        = {};
  };

  template <>
  struct CppType<StructureType, StructureType::eAccelerationStructureMotionInfoNV>
  {
    using Type = AccelerationStructureMotionInfoNV;
  };

  // wrapper struct for struct VkSRTDataNV, see https://registry.khronos.org/vulkan/specs/latest/man/html/VkSRTDataNV.html
  struct SRTDataNV
  {
    using NativeType = VkSRTDataNV;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR SRTDataNV( float sx_  = {},
                                    float a_   = {},
                                    float b_   = {},
                                    float pvx_ = {},
                                    float sy_  = {},
                                    float c_   = {},
                                    float pvy_ = {},
                                    float sz_  = {},
                                    float pvz_ = {},
                                    float qx_  = {},
                                    float qy_  = {},
                                    float qz_  = {},
                                    float qw_  = {},
                                    float tx_  = {},
                                    float ty_  = {},
                                    float tz_  = {} ) VULKAN_HPP_NOEXCEPT
      : sx{ sx_ }
      , a{ a_ }
      , b{ b_ }
      , pvx{ pvx_ }
      , sy{ sy_ }
      , c{ c_ }
      , pvy{ pvy_ }
      , sz{ sz_ }
      , pvz{ pvz_ }
      , qx{ qx_ }
      , qy{ qy_ }
      , qz{ qz_ }
      , qw{ qw_ }
      , tx{ tx_ }
      , ty{ ty_ }
      , tz{ tz_ }
    {
    }

    VULKAN_HPP_CONSTEXPR SRTDataNV( SRTDataNV const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    SRTDataNV( VkSRTDataNV const & rhs ) VULKAN_HPP_NOEXCEPT : SRTDataNV( *reinterpret_cast<SRTDataNV const *>( &rhs ) ) {}

    SRTDataNV & operator=( SRTDataNV const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    SRTDataNV & operator=( VkSRTDataNV const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<SRTDataNV const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 SRTDataNV & setSx( float sx_ ) VULKAN_HPP_NOEXCEPT
    {
      sx = sx_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 SRTDataNV & setA( float a_ ) VULKAN_HPP_NOEXCEPT
    {
      a = a_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 SRTDataNV & setB( float b_ ) VULKAN_HPP_NOEXCEPT
    {
      b = b_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 SRTDataNV & setPvx( float pvx_ ) VULKAN_HPP_NOEXCEPT
    {
      pvx = pvx_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 SRTDataNV & setSy( float sy_ ) VULKAN_HPP_NOEXCEPT
    {
      sy = sy_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 SRTDataNV & setC( float c_ ) VULKAN_HPP_NOEXCEPT
    {
      c = c_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 SRTDataNV & setPvy( float pvy_ ) VULKAN_HPP_NOEXCEPT
    {
      pvy = pvy_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 SRTDataNV & setSz( float sz_ ) VULKAN_HPP_NOEXCEPT
    {
      sz = sz_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 SRTDataNV & setPvz( float pvz_ ) VULKAN_HPP_NOEXCEPT
    {
      pvz = pvz_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 SRTDataNV & setQx( float qx_ ) VULKAN_HPP_NOEXCEPT
    {
      qx = qx_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 SRTDataNV & setQy( float qy_ ) VULKAN_HPP_NOEXCEPT
    {
      qy = qy_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 SRTDataNV & setQz( float qz_ ) VULKAN_HPP_NOEXCEPT
    {
      qz = qz_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 SRTDataNV & setQw( float qw_ ) VULKAN_HPP_NOEXCEPT
    {
      qw = qw_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 SRTDataNV & setTx( float tx_ ) VULKAN_HPP_NOEXCEPT
    {
      tx = tx_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 SRTDataNV & setTy( float ty_ ) VULKAN_HPP_NOEXCEPT
    {
      ty = ty_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 SRTDataNV & setTz( float tz_ ) VULKAN_HPP_NOEXCEPT
    {
      tz = tz_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_SETTERS*/

    operator VkSRTDataNV const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkSRTDataNV *>( this );
    }

    operator VkSRTDataNV &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkSRTDataNV *>( this );
    }

    operator VkSRTDataNV const *() const VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<const VkSRTDataNV *>( this );
    }

    operator VkSRTDataNV *() VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<VkSRTDataNV *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<float const &,
               float const &,
               float const &,
               float const &,
               float const &,
               float const &,
               float const &,
               float const &,
               float const &,
               float const &,
               float const &,
               float const &,
               float const &,
               float const &,
               float const &,
               float const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sx, a, b, pvx, sy, c, pvy, sz, pvz, qx, qy, qz, qw, tx, ty, tz );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( SRTDataNV const & ) const = default;
#else
    bool operator==( SRTDataNV const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sx == rhs.sx ) && ( a == rhs.a ) && ( b == rhs.b ) && ( pvx == rhs.pvx ) && ( sy == rhs.sy ) && ( c == rhs.c ) && ( pvy == rhs.pvy ) &&
             ( sz == rhs.sz ) && ( pvz == rhs.pvz ) && ( qx == rhs.qx ) && ( qy == rhs.qy ) && ( qz == rhs.qz ) && ( qw == rhs.qw ) && ( tx == rhs.tx ) &&
             ( ty == rhs.ty ) && ( tz == rhs.tz );
#  endif
    }

    bool operator!=( SRTDataNV const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    float sx  = {};
    float a   = {};
    float b   = {};
    float pvx = {};
    float sy  = {};
    float c   = {};
    float pvy = {};
    float sz  = {};
    float pvz = {};
    float qx  = {};
    float qy  = {};
    float qz  = {};
    float qw  = {};
    float tx  = {};
    float ty  = {};
    float tz  = {};
  };

  // wrapper struct for struct VkAccelerationStructureSRTMotionInstanceNV, see
  // https://registry.khronos.org/vulkan/specs/latest/man/html/VkAccelerationStructureSRTMotionInstanceNV.html
  struct AccelerationStructureSRTMotionInstanceNV
  {
    using NativeType = VkAccelerationStructureSRTMotionInstanceNV;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR AccelerationStructureSRTMotionInstanceNV( SRTDataNV                transformT0_                            = {},
                                                                   SRTDataNV                transformT1_                            = {},
                                                                   uint32_t                 instanceCustomIndex_                    = {},
                                                                   uint32_t                 mask_                                   = {},
                                                                   uint32_t                 instanceShaderBindingTableRecordOffset_ = {},
                                                                   GeometryInstanceFlagsKHR flags_                                  = {},
                                                                   uint64_t                 accelerationStructureReference_         = {} ) VULKAN_HPP_NOEXCEPT
      : transformT0{ transformT0_ }
      , transformT1{ transformT1_ }
      , instanceCustomIndex{ instanceCustomIndex_ }
      , mask{ mask_ }
      , instanceShaderBindingTableRecordOffset{ instanceShaderBindingTableRecordOffset_ }
      , flags{ flags_ }
      , accelerationStructureReference{ accelerationStructureReference_ }
    {
    }

    VULKAN_HPP_CONSTEXPR AccelerationStructureSRTMotionInstanceNV( AccelerationStructureSRTMotionInstanceNV const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    AccelerationStructureSRTMotionInstanceNV( VkAccelerationStructureSRTMotionInstanceNV const & rhs ) VULKAN_HPP_NOEXCEPT
      : AccelerationStructureSRTMotionInstanceNV( *reinterpret_cast<AccelerationStructureSRTMotionInstanceNV const *>( &rhs ) )
    {
    }

    AccelerationStructureSRTMotionInstanceNV & operator=( AccelerationStructureSRTMotionInstanceNV const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    AccelerationStructureSRTMotionInstanceNV & operator=( VkAccelerationStructureSRTMotionInstanceNV const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<AccelerationStructureSRTMotionInstanceNV const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureSRTMotionInstanceNV & setTransformT0( SRTDataNV const & transformT0_ ) VULKAN_HPP_NOEXCEPT
    {
      transformT0 = transformT0_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureSRTMotionInstanceNV & setTransformT1( SRTDataNV const & transformT1_ ) VULKAN_HPP_NOEXCEPT
    {
      transformT1 = transformT1_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureSRTMotionInstanceNV & setInstanceCustomIndex( uint32_t instanceCustomIndex_ ) VULKAN_HPP_NOEXCEPT
    {
      instanceCustomIndex = instanceCustomIndex_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureSRTMotionInstanceNV & setMask( uint32_t mask_ ) VULKAN_HPP_NOEXCEPT
    {
      mask = mask_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureSRTMotionInstanceNV &
      setInstanceShaderBindingTableRecordOffset( uint32_t instanceShaderBindingTableRecordOffset_ ) VULKAN_HPP_NOEXCEPT
    {
      instanceShaderBindingTableRecordOffset = instanceShaderBindingTableRecordOffset_;
      return *this;
    }

    AccelerationStructureSRTMotionInstanceNV & setFlags( GeometryInstanceFlagsKHR flags_ ) VULKAN_HPP_NOEXCEPT
    {
      flags = *reinterpret_cast<VkGeometryInstanceFlagsKHR *>( &flags_ );
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureSRTMotionInstanceNV &
      setAccelerationStructureReference( uint64_t accelerationStructureReference_ ) VULKAN_HPP_NOEXCEPT
    {
      accelerationStructureReference = accelerationStructureReference_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_SETTERS*/

    operator VkAccelerationStructureSRTMotionInstanceNV const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkAccelerationStructureSRTMotionInstanceNV *>( this );
    }

    operator VkAccelerationStructureSRTMotionInstanceNV &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkAccelerationStructureSRTMotionInstanceNV *>( this );
    }

    operator VkAccelerationStructureSRTMotionInstanceNV const *() const VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<const VkAccelerationStructureSRTMotionInstanceNV *>( this );
    }

    operator VkAccelerationStructureSRTMotionInstanceNV *() VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<VkAccelerationStructureSRTMotionInstanceNV *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<SRTDataNV const &, SRTDataNV const &, uint32_t const &, uint32_t const &, uint32_t const &, VkGeometryInstanceFlagsKHR const &, uint64_t const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( transformT0, transformT1, instanceCustomIndex, mask, instanceShaderBindingTableRecordOffset, flags, accelerationStructureReference );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( AccelerationStructureSRTMotionInstanceNV const & ) const = default;
#else
    bool operator==( AccelerationStructureSRTMotionInstanceNV const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( transformT0 == rhs.transformT0 ) && ( transformT1 == rhs.transformT1 ) && ( instanceCustomIndex == rhs.instanceCustomIndex ) &&
             ( mask == rhs.mask ) && ( instanceShaderBindingTableRecordOffset == rhs.instanceShaderBindingTableRecordOffset ) && ( flags == rhs.flags ) &&
             ( accelerationStructureReference == rhs.accelerationStructureReference );
#  endif
    }

    bool operator!=( AccelerationStructureSRTMotionInstanceNV const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    SRTDataNV                  transformT0 = {};
    SRTDataNV                  transformT1 = {};
    uint32_t                   instanceCustomIndex                    : 24;
    uint32_t                   mask                                   : 8;
    uint32_t                   instanceShaderBindingTableRecordOffset : 24;
    VkGeometryInstanceFlagsKHR flags                                  : 8;
    uint64_t                   accelerationStructureReference = {};
  };

  union AccelerationStructureMotionInstanceDataNV
  {
    using NativeType = VkAccelerationStructureMotionInstanceDataNV;
#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_UNION_CONSTRUCTORS )

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureMotionInstanceDataNV( AccelerationStructureInstanceKHR staticInstance_ = {} )
      : staticInstance( staticInstance_ )
    {
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureMotionInstanceDataNV( AccelerationStructureMatrixMotionInstanceNV matrixMotionInstance_ )
      : matrixMotionInstance( matrixMotionInstance_ )
    {
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureMotionInstanceDataNV( AccelerationStructureSRTMotionInstanceNV srtMotionInstance_ )
      : srtMotionInstance( srtMotionInstance_ )
    {
    }
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_UNION_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureMotionInstanceDataNV &
      setStaticInstance( AccelerationStructureInstanceKHR const & staticInstance_ ) VULKAN_HPP_NOEXCEPT
    {
      staticInstance = staticInstance_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureMotionInstanceDataNV &
      setMatrixMotionInstance( AccelerationStructureMatrixMotionInstanceNV const & matrixMotionInstance_ ) VULKAN_HPP_NOEXCEPT
    {
      matrixMotionInstance = matrixMotionInstance_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureMotionInstanceDataNV &
      setSrtMotionInstance( AccelerationStructureSRTMotionInstanceNV const & srtMotionInstance_ ) VULKAN_HPP_NOEXCEPT
    {
      srtMotionInstance = srtMotionInstance_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_SETTERS*/

    operator VkAccelerationStructureMotionInstanceDataNV const &() const
    {
      return *reinterpret_cast<const VkAccelerationStructureMotionInstanceDataNV *>( this );
    }

    operator VkAccelerationStructureMotionInstanceDataNV &()
    {
      return *reinterpret_cast<VkAccelerationStructureMotionInstanceDataNV *>( this );
    }

#ifdef VULKAN_HPP_HAS_UNRESTRICTED_UNIONS
    AccelerationStructureInstanceKHR            staticInstance;
    AccelerationStructureMatrixMotionInstanceNV matrixMotionInstance;
    AccelerationStructureSRTMotionInstanceNV    srtMotionInstance;
#else
    VkAccelerationStructureInstanceKHR            staticInstance;
    VkAccelerationStructureMatrixMotionInstanceNV matrixMotionInstance;
    VkAccelerationStructureSRTMotionInstanceNV    srtMotionInstance;
#endif /*VULKAN_HPP_HAS_UNRESTRICTED_UNIONS*/
  };

  // wrapper struct for struct VkAccelerationStructureMotionInstanceNV, see
  // https://registry.khronos.org/vulkan/specs/latest/man/html/VkAccelerationStructureMotionInstanceNV.html
  struct AccelerationStructureMotionInstanceNV
  {
    using NativeType = VkAccelerationStructureMotionInstanceNV;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR_14
      AccelerationStructureMotionInstanceNV( AccelerationStructureMotionInstanceTypeNV  type_  = AccelerationStructureMotionInstanceTypeNV::eStatic,
                                             AccelerationStructureMotionInstanceFlagsNV flags_ = {},
                                             AccelerationStructureMotionInstanceDataNV  data_  = {} ) VULKAN_HPP_NOEXCEPT
      : type{ type_ }
      , flags{ flags_ }
      , data{ data_ }
    {
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureMotionInstanceNV( AccelerationStructureMotionInstanceNV const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    AccelerationStructureMotionInstanceNV( VkAccelerationStructureMotionInstanceNV const & rhs ) VULKAN_HPP_NOEXCEPT
      : AccelerationStructureMotionInstanceNV( *reinterpret_cast<AccelerationStructureMotionInstanceNV const *>( &rhs ) )
    {
    }

    AccelerationStructureMotionInstanceNV & operator=( AccelerationStructureMotionInstanceNV const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    AccelerationStructureMotionInstanceNV & operator=( VkAccelerationStructureMotionInstanceNV const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<AccelerationStructureMotionInstanceNV const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureMotionInstanceNV & setType( AccelerationStructureMotionInstanceTypeNV type_ ) VULKAN_HPP_NOEXCEPT
    {
      type = type_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureMotionInstanceNV & setFlags( AccelerationStructureMotionInstanceFlagsNV flags_ ) VULKAN_HPP_NOEXCEPT
    {
      flags = flags_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureMotionInstanceNV & setData( AccelerationStructureMotionInstanceDataNV const & data_ ) VULKAN_HPP_NOEXCEPT
    {
      data = data_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_SETTERS*/

    operator VkAccelerationStructureMotionInstanceNV const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkAccelerationStructureMotionInstanceNV *>( this );
    }

    operator VkAccelerationStructureMotionInstanceNV &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkAccelerationStructureMotionInstanceNV *>( this );
    }

    operator VkAccelerationStructureMotionInstanceNV const *() const VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<const VkAccelerationStructureMotionInstanceNV *>( this );
    }

    operator VkAccelerationStructureMotionInstanceNV *() VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<VkAccelerationStructureMotionInstanceNV *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<AccelerationStructureMotionInstanceTypeNV const &,
               AccelerationStructureMotionInstanceFlagsNV const &,
               AccelerationStructureMotionInstanceDataNV const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( type, flags, data );
    }
#endif

  public:
    AccelerationStructureMotionInstanceTypeNV  type  = AccelerationStructureMotionInstanceTypeNV::eStatic;
    AccelerationStructureMotionInstanceFlagsNV flags = {};
    AccelerationStructureMotionInstanceDataNV  data  = {};
  };

  // wrapper struct for struct VkMicromapUsageEXT, see https://registry.khronos.org/vulkan/specs/latest/man/html/VkMicromapUsageEXT.html
  struct MicromapUsageEXT
  {
    using NativeType = VkMicromapUsageEXT;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR MicromapUsageEXT( uint32_t count_ = {}, uint32_t subdivisionLevel_ = {}, uint32_t format_ = {} ) VULKAN_HPP_NOEXCEPT
      : count{ count_ }
      , subdivisionLevel{ subdivisionLevel_ }
      , format{ format_ }
    {
    }

    VULKAN_HPP_CONSTEXPR MicromapUsageEXT( MicromapUsageEXT const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    MicromapUsageEXT( VkMicromapUsageEXT const & rhs ) VULKAN_HPP_NOEXCEPT : MicromapUsageEXT( *reinterpret_cast<MicromapUsageEXT const *>( &rhs ) ) {}

    MicromapUsageEXT & operator=( MicromapUsageEXT const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    MicromapUsageEXT & operator=( VkMicromapUsageEXT const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<MicromapUsageEXT const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 MicromapUsageEXT & setCount( uint32_t count_ ) VULKAN_HPP_NOEXCEPT
    {
      count = count_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 MicromapUsageEXT & setSubdivisionLevel( uint32_t subdivisionLevel_ ) VULKAN_HPP_NOEXCEPT
    {
      subdivisionLevel = subdivisionLevel_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 MicromapUsageEXT & setFormat( uint32_t format_ ) VULKAN_HPP_NOEXCEPT
    {
      format = format_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_SETTERS*/

    operator VkMicromapUsageEXT const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkMicromapUsageEXT *>( this );
    }

    operator VkMicromapUsageEXT &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkMicromapUsageEXT *>( this );
    }

    operator VkMicromapUsageEXT const *() const VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<const VkMicromapUsageEXT *>( this );
    }

    operator VkMicromapUsageEXT *() VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<VkMicromapUsageEXT *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<uint32_t const &, uint32_t const &, uint32_t const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( count, subdivisionLevel, format );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( MicromapUsageEXT const & ) const = default;
#else
    bool operator==( MicromapUsageEXT const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( count == rhs.count ) && ( subdivisionLevel == rhs.subdivisionLevel ) && ( format == rhs.format );
#  endif
    }

    bool operator!=( MicromapUsageEXT const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    uint32_t count            = {};
    uint32_t subdivisionLevel = {};
    uint32_t format           = {};
  };

#if defined( VK_ENABLE_BETA_EXTENSIONS )
  // wrapper struct for struct VkAccelerationStructureTrianglesDisplacementMicromapNV, see
  // https://registry.khronos.org/vulkan/specs/latest/man/html/VkAccelerationStructureTrianglesDisplacementMicromapNV.html
  struct AccelerationStructureTrianglesDisplacementMicromapNV
  {
    using NativeType = VkAccelerationStructureTrianglesDisplacementMicromapNV;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eAccelerationStructureTrianglesDisplacementMicromapNV;

#  if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureTrianglesDisplacementMicromapNV( Format displacementBiasAndScaleFormat_ = Format::eUndefined,
                                                                                  Format displacementVectorFormat_       = Format::eUndefined,
                                                                                  DeviceOrHostAddressConstKHR      displacementBiasAndScaleBuffer_        = {},
                                                                                  DeviceSize                       displacementBiasAndScaleStride_        = {},
                                                                                  DeviceOrHostAddressConstKHR      displacementVectorBuffer_              = {},
                                                                                  DeviceSize                       displacementVectorStride_              = {},
                                                                                  DeviceOrHostAddressConstKHR      displacedMicromapPrimitiveFlags_       = {},
                                                                                  DeviceSize                       displacedMicromapPrimitiveFlagsStride_ = {},
                                                                                  IndexType                        indexType_        = IndexType::eUint16,
                                                                                  DeviceOrHostAddressConstKHR      indexBuffer_      = {},
                                                                                  DeviceSize                       indexStride_      = {},
                                                                                  uint32_t                         baseTriangle_     = {},
                                                                                  uint32_t                         usageCountsCount_ = {},
                                                                                  const MicromapUsageEXT *         pUsageCounts_     = {},
                                                                                  const MicromapUsageEXT * const * ppUsageCounts_    = {},
                                                                                  MicromapEXT                      micromap_         = {},
                                                                                  void *                           pNext_ = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , displacementBiasAndScaleFormat{ displacementBiasAndScaleFormat_ }
      , displacementVectorFormat{ displacementVectorFormat_ }
      , displacementBiasAndScaleBuffer{ displacementBiasAndScaleBuffer_ }
      , displacementBiasAndScaleStride{ displacementBiasAndScaleStride_ }
      , displacementVectorBuffer{ displacementVectorBuffer_ }
      , displacementVectorStride{ displacementVectorStride_ }
      , displacedMicromapPrimitiveFlags{ displacedMicromapPrimitiveFlags_ }
      , displacedMicromapPrimitiveFlagsStride{ displacedMicromapPrimitiveFlagsStride_ }
      , indexType{ indexType_ }
      , indexBuffer{ indexBuffer_ }
      , indexStride{ indexStride_ }
      , baseTriangle{ baseTriangle_ }
      , usageCountsCount{ usageCountsCount_ }
      , pUsageCounts{ pUsageCounts_ }
      , ppUsageCounts{ ppUsageCounts_ }
      , micromap{ micromap_ }
    {
    }

    VULKAN_HPP_CONSTEXPR_14
      AccelerationStructureTrianglesDisplacementMicromapNV( AccelerationStructureTrianglesDisplacementMicromapNV const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    AccelerationStructureTrianglesDisplacementMicromapNV( VkAccelerationStructureTrianglesDisplacementMicromapNV const & rhs ) VULKAN_HPP_NOEXCEPT
      : AccelerationStructureTrianglesDisplacementMicromapNV( *reinterpret_cast<AccelerationStructureTrianglesDisplacementMicromapNV const *>( &rhs ) )
    {
    }

#    if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    AccelerationStructureTrianglesDisplacementMicromapNV( Format                                                  displacementBiasAndScaleFormat_,
                                                          Format                                                  displacementVectorFormat_,
                                                          DeviceOrHostAddressConstKHR                             displacementBiasAndScaleBuffer_,
                                                          DeviceSize                                              displacementBiasAndScaleStride_,
                                                          DeviceOrHostAddressConstKHR                             displacementVectorBuffer_,
                                                          DeviceSize                                              displacementVectorStride_,
                                                          DeviceOrHostAddressConstKHR                             displacedMicromapPrimitiveFlags_,
                                                          DeviceSize                                              displacedMicromapPrimitiveFlagsStride_,
                                                          IndexType                                               indexType_,
                                                          DeviceOrHostAddressConstKHR                             indexBuffer_,
                                                          DeviceSize                                              indexStride_,
                                                          uint32_t                                                baseTriangle_,
                                                          ArrayProxyNoTemporaries<const MicromapUsageEXT> const & usageCounts_,
                                                          ArrayProxyNoTemporaries<const MicromapUsageEXT * const> const & pUsageCounts_ = {},
                                                          MicromapEXT                                                     micromap_     = {},
                                                          void *                                                          pNext_        = nullptr )
      : pNext( pNext_ )
      , displacementBiasAndScaleFormat( displacementBiasAndScaleFormat_ )
      , displacementVectorFormat( displacementVectorFormat_ )
      , displacementBiasAndScaleBuffer( displacementBiasAndScaleBuffer_ )
      , displacementBiasAndScaleStride( displacementBiasAndScaleStride_ )
      , displacementVectorBuffer( displacementVectorBuffer_ )
      , displacementVectorStride( displacementVectorStride_ )
      , displacedMicromapPrimitiveFlags( displacedMicromapPrimitiveFlags_ )
      , displacedMicromapPrimitiveFlagsStride( displacedMicromapPrimitiveFlagsStride_ )
      , indexType( indexType_ )
      , indexBuffer( indexBuffer_ )
      , indexStride( indexStride_ )
      , baseTriangle( baseTriangle_ )
      , usageCountsCount( static_cast<uint32_t>( usageCounts_.size() ) )
      , pUsageCounts( usageCounts_.data() )
      , ppUsageCounts( pUsageCounts_.data() )
      , micromap( micromap_ )
    {
#      ifdef VULKAN_HPP_NO_EXCEPTIONS
      VULKAN_HPP_ASSERT( usageCounts_.empty() || pUsageCounts_.empty() || ( usageCounts_.size() == pUsageCounts_.size() ) );
#      else
      if ( !usageCounts_.empty() && !pUsageCounts_.empty() && ( usageCounts_.size() != pUsageCounts_.size() ) )
      {
        throw LogicError(
          VULKAN_HPP_NAMESPACE_STRING
          "::AccelerationStructureTrianglesDisplacementMicromapNV::AccelerationStructureTrianglesDisplacementMicromapNV: !usageCounts_.empty() && !pUsageCounts_.empty() && ( usageCounts_.size() != pUsageCounts_.size() )" );
      }
#      endif /*VULKAN_HPP_NO_EXCEPTIONS*/
    }
#    endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/

    AccelerationStructureTrianglesDisplacementMicromapNV &
      operator=( AccelerationStructureTrianglesDisplacementMicromapNV const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#  endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    AccelerationStructureTrianglesDisplacementMicromapNV & operator=( VkAccelerationStructureTrianglesDisplacementMicromapNV const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<AccelerationStructureTrianglesDisplacementMicromapNV const *>( &rhs );
      return *this;
    }

#  if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureTrianglesDisplacementMicromapNV & setPNext( void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureTrianglesDisplacementMicromapNV &
      setDisplacementBiasAndScaleFormat( Format displacementBiasAndScaleFormat_ ) VULKAN_HPP_NOEXCEPT
    {
      displacementBiasAndScaleFormat = displacementBiasAndScaleFormat_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureTrianglesDisplacementMicromapNV &
      setDisplacementVectorFormat( Format displacementVectorFormat_ ) VULKAN_HPP_NOEXCEPT
    {
      displacementVectorFormat = displacementVectorFormat_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureTrianglesDisplacementMicromapNV &
      setDisplacementBiasAndScaleBuffer( DeviceOrHostAddressConstKHR const & displacementBiasAndScaleBuffer_ ) VULKAN_HPP_NOEXCEPT
    {
      displacementBiasAndScaleBuffer = displacementBiasAndScaleBuffer_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureTrianglesDisplacementMicromapNV &
      setDisplacementBiasAndScaleStride( DeviceSize displacementBiasAndScaleStride_ ) VULKAN_HPP_NOEXCEPT
    {
      displacementBiasAndScaleStride = displacementBiasAndScaleStride_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureTrianglesDisplacementMicromapNV &
      setDisplacementVectorBuffer( DeviceOrHostAddressConstKHR const & displacementVectorBuffer_ ) VULKAN_HPP_NOEXCEPT
    {
      displacementVectorBuffer = displacementVectorBuffer_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureTrianglesDisplacementMicromapNV &
      setDisplacementVectorStride( DeviceSize displacementVectorStride_ ) VULKAN_HPP_NOEXCEPT
    {
      displacementVectorStride = displacementVectorStride_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureTrianglesDisplacementMicromapNV &
      setDisplacedMicromapPrimitiveFlags( DeviceOrHostAddressConstKHR const & displacedMicromapPrimitiveFlags_ ) VULKAN_HPP_NOEXCEPT
    {
      displacedMicromapPrimitiveFlags = displacedMicromapPrimitiveFlags_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureTrianglesDisplacementMicromapNV &
      setDisplacedMicromapPrimitiveFlagsStride( DeviceSize displacedMicromapPrimitiveFlagsStride_ ) VULKAN_HPP_NOEXCEPT
    {
      displacedMicromapPrimitiveFlagsStride = displacedMicromapPrimitiveFlagsStride_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureTrianglesDisplacementMicromapNV & setIndexType( IndexType indexType_ ) VULKAN_HPP_NOEXCEPT
    {
      indexType = indexType_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureTrianglesDisplacementMicromapNV &
      setIndexBuffer( DeviceOrHostAddressConstKHR const & indexBuffer_ ) VULKAN_HPP_NOEXCEPT
    {
      indexBuffer = indexBuffer_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureTrianglesDisplacementMicromapNV & setIndexStride( DeviceSize indexStride_ ) VULKAN_HPP_NOEXCEPT
    {
      indexStride = indexStride_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureTrianglesDisplacementMicromapNV & setBaseTriangle( uint32_t baseTriangle_ ) VULKAN_HPP_NOEXCEPT
    {
      baseTriangle = baseTriangle_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureTrianglesDisplacementMicromapNV & setUsageCountsCount( uint32_t usageCountsCount_ ) VULKAN_HPP_NOEXCEPT
    {
      usageCountsCount = usageCountsCount_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureTrianglesDisplacementMicromapNV & setPUsageCounts( const MicromapUsageEXT * pUsageCounts_ ) VULKAN_HPP_NOEXCEPT
    {
      pUsageCounts = pUsageCounts_;
      return *this;
    }

#    if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    AccelerationStructureTrianglesDisplacementMicromapNV &
      setUsageCounts( ArrayProxyNoTemporaries<const MicromapUsageEXT> const & usageCounts_ ) VULKAN_HPP_NOEXCEPT
    {
      usageCountsCount = static_cast<uint32_t>( usageCounts_.size() );
      pUsageCounts     = usageCounts_.data();
      return *this;
    }
#    endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureTrianglesDisplacementMicromapNV &
      setPpUsageCounts( const MicromapUsageEXT * const * ppUsageCounts_ ) VULKAN_HPP_NOEXCEPT
    {
      ppUsageCounts = ppUsageCounts_;
      return *this;
    }

#    if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    AccelerationStructureTrianglesDisplacementMicromapNV &
      setPUsageCounts( ArrayProxyNoTemporaries<const MicromapUsageEXT * const> const & pUsageCounts_ ) VULKAN_HPP_NOEXCEPT
    {
      usageCountsCount = static_cast<uint32_t>( pUsageCounts_.size() );
      ppUsageCounts    = pUsageCounts_.data();
      return *this;
    }
#    endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureTrianglesDisplacementMicromapNV & setMicromap( MicromapEXT micromap_ ) VULKAN_HPP_NOEXCEPT
    {
      micromap = micromap_;
      return *this;
    }
#  endif /*VULKAN_HPP_NO_SETTERS*/

    operator VkAccelerationStructureTrianglesDisplacementMicromapNV const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkAccelerationStructureTrianglesDisplacementMicromapNV *>( this );
    }

    operator VkAccelerationStructureTrianglesDisplacementMicromapNV &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkAccelerationStructureTrianglesDisplacementMicromapNV *>( this );
    }

    operator VkAccelerationStructureTrianglesDisplacementMicromapNV const *() const VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<const VkAccelerationStructureTrianglesDisplacementMicromapNV *>( this );
    }

    operator VkAccelerationStructureTrianglesDisplacementMicromapNV *() VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<VkAccelerationStructureTrianglesDisplacementMicromapNV *>( this );
    }

#  if defined( VULKAN_HPP_USE_REFLECT )
#    if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#    else
    std::tuple<StructureType const &,
               void * const &,
               Format const &,
               Format const &,
               DeviceOrHostAddressConstKHR const &,
               DeviceSize const &,
               DeviceOrHostAddressConstKHR const &,
               DeviceSize const &,
               DeviceOrHostAddressConstKHR const &,
               DeviceSize const &,
               IndexType const &,
               DeviceOrHostAddressConstKHR const &,
               DeviceSize const &,
               uint32_t const &,
               uint32_t const &,
               const MicromapUsageEXT * const &,
               const MicromapUsageEXT * const * const &,
               MicromapEXT const &>
#    endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType,
                       pNext,
                       displacementBiasAndScaleFormat,
                       displacementVectorFormat,
                       displacementBiasAndScaleBuffer,
                       displacementBiasAndScaleStride,
                       displacementVectorBuffer,
                       displacementVectorStride,
                       displacedMicromapPrimitiveFlags,
                       displacedMicromapPrimitiveFlagsStride,
                       indexType,
                       indexBuffer,
                       indexStride,
                       baseTriangle,
                       usageCountsCount,
                       pUsageCounts,
                       ppUsageCounts,
                       micromap );
    }
#  endif

  public:
    StructureType                    sType                                 = StructureType::eAccelerationStructureTrianglesDisplacementMicromapNV;
    void *                           pNext                                 = {};
    Format                           displacementBiasAndScaleFormat        = Format::eUndefined;
    Format                           displacementVectorFormat              = Format::eUndefined;
    DeviceOrHostAddressConstKHR      displacementBiasAndScaleBuffer        = {};
    DeviceSize                       displacementBiasAndScaleStride        = {};
    DeviceOrHostAddressConstKHR      displacementVectorBuffer              = {};
    DeviceSize                       displacementVectorStride              = {};
    DeviceOrHostAddressConstKHR      displacedMicromapPrimitiveFlags       = {};
    DeviceSize                       displacedMicromapPrimitiveFlagsStride = {};
    IndexType                        indexType                             = IndexType::eUint16;
    DeviceOrHostAddressConstKHR      indexBuffer                           = {};
    DeviceSize                       indexStride                           = {};
    uint32_t                         baseTriangle                          = {};
    uint32_t                         usageCountsCount                      = {};
    const MicromapUsageEXT *         pUsageCounts                          = {};
    const MicromapUsageEXT * const * ppUsageCounts                         = {};
    MicromapEXT                      micromap                              = {};
  };

  template <>
  struct CppType<StructureType, StructureType::eAccelerationStructureTrianglesDisplacementMicromapNV>
  {
    using Type = AccelerationStructureTrianglesDisplacementMicromapNV;
  };
#endif /*VK_ENABLE_BETA_EXTENSIONS*/

  // wrapper struct for struct VkAccelerationStructureTrianglesOpacityMicromapEXT, see
  // https://registry.khronos.org/vulkan/specs/latest/man/html/VkAccelerationStructureTrianglesOpacityMicromapEXT.html
  struct AccelerationStructureTrianglesOpacityMicromapEXT
  {
    using NativeType = VkAccelerationStructureTrianglesOpacityMicromapEXT;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eAccelerationStructureTrianglesOpacityMicromapEXT;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureTrianglesOpacityMicromapEXT( IndexType                        indexType_        = IndexType::eUint16,
                                                                              DeviceOrHostAddressConstKHR      indexBuffer_      = {},
                                                                              DeviceSize                       indexStride_      = {},
                                                                              uint32_t                         baseTriangle_     = {},
                                                                              uint32_t                         usageCountsCount_ = {},
                                                                              const MicromapUsageEXT *         pUsageCounts_     = {},
                                                                              const MicromapUsageEXT * const * ppUsageCounts_    = {},
                                                                              MicromapEXT                      micromap_         = {},
                                                                              void *                           pNext_            = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , indexType{ indexType_ }
      , indexBuffer{ indexBuffer_ }
      , indexStride{ indexStride_ }
      , baseTriangle{ baseTriangle_ }
      , usageCountsCount{ usageCountsCount_ }
      , pUsageCounts{ pUsageCounts_ }
      , ppUsageCounts{ ppUsageCounts_ }
      , micromap{ micromap_ }
    {
    }

    VULKAN_HPP_CONSTEXPR_14
      AccelerationStructureTrianglesOpacityMicromapEXT( AccelerationStructureTrianglesOpacityMicromapEXT const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    AccelerationStructureTrianglesOpacityMicromapEXT( VkAccelerationStructureTrianglesOpacityMicromapEXT const & rhs ) VULKAN_HPP_NOEXCEPT
      : AccelerationStructureTrianglesOpacityMicromapEXT( *reinterpret_cast<AccelerationStructureTrianglesOpacityMicromapEXT const *>( &rhs ) )
    {
    }

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    AccelerationStructureTrianglesOpacityMicromapEXT( IndexType                                                       indexType_,
                                                      DeviceOrHostAddressConstKHR                                     indexBuffer_,
                                                      DeviceSize                                                      indexStride_,
                                                      uint32_t                                                        baseTriangle_,
                                                      ArrayProxyNoTemporaries<const MicromapUsageEXT> const &         usageCounts_,
                                                      ArrayProxyNoTemporaries<const MicromapUsageEXT * const> const & pUsageCounts_ = {},
                                                      MicromapEXT                                                     micromap_     = {},
                                                      void *                                                          pNext_        = nullptr )
      : pNext( pNext_ )
      , indexType( indexType_ )
      , indexBuffer( indexBuffer_ )
      , indexStride( indexStride_ )
      , baseTriangle( baseTriangle_ )
      , usageCountsCount( static_cast<uint32_t>( !usageCounts_.empty() ? usageCounts_.size() : pUsageCounts_.size() ) )
      , pUsageCounts( usageCounts_.data() )
      , ppUsageCounts( pUsageCounts_.data() )
      , micromap( micromap_ )
    {
#    ifdef VULKAN_HPP_NO_EXCEPTIONS
      VULKAN_HPP_ASSERT( ( !usageCounts_.empty() + !pUsageCounts_.empty() ) <= 1 );
#    else
      if ( 1 < ( !usageCounts_.empty() + !pUsageCounts_.empty() ) )
      {
        throw LogicError(
          VULKAN_HPP_NAMESPACE_STRING
          "::AccelerationStructureTrianglesOpacityMicromapEXT::AccelerationStructureTrianglesOpacityMicromapEXT: 1 < ( !usageCounts_.empty() + !pUsageCounts_.empty() )" );
      }
#    endif /*VULKAN_HPP_NO_EXCEPTIONS*/
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/

    AccelerationStructureTrianglesOpacityMicromapEXT & operator=( AccelerationStructureTrianglesOpacityMicromapEXT const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    AccelerationStructureTrianglesOpacityMicromapEXT & operator=( VkAccelerationStructureTrianglesOpacityMicromapEXT const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<AccelerationStructureTrianglesOpacityMicromapEXT const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureTrianglesOpacityMicromapEXT & setPNext( void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureTrianglesOpacityMicromapEXT & setIndexType( IndexType indexType_ ) VULKAN_HPP_NOEXCEPT
    {
      indexType = indexType_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureTrianglesOpacityMicromapEXT &
      setIndexBuffer( DeviceOrHostAddressConstKHR const & indexBuffer_ ) VULKAN_HPP_NOEXCEPT
    {
      indexBuffer = indexBuffer_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureTrianglesOpacityMicromapEXT & setIndexStride( DeviceSize indexStride_ ) VULKAN_HPP_NOEXCEPT
    {
      indexStride = indexStride_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureTrianglesOpacityMicromapEXT & setBaseTriangle( uint32_t baseTriangle_ ) VULKAN_HPP_NOEXCEPT
    {
      baseTriangle = baseTriangle_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureTrianglesOpacityMicromapEXT & setUsageCountsCount( uint32_t usageCountsCount_ ) VULKAN_HPP_NOEXCEPT
    {
      usageCountsCount = usageCountsCount_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureTrianglesOpacityMicromapEXT & setPUsageCounts( const MicromapUsageEXT * pUsageCounts_ ) VULKAN_HPP_NOEXCEPT
    {
      pUsageCounts = pUsageCounts_;
      return *this;
    }

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    AccelerationStructureTrianglesOpacityMicromapEXT &
      setUsageCounts( ArrayProxyNoTemporaries<const MicromapUsageEXT> const & usageCounts_ ) VULKAN_HPP_NOEXCEPT
    {
      usageCountsCount = static_cast<uint32_t>( usageCounts_.size() );
      pUsageCounts     = usageCounts_.data();
      return *this;
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureTrianglesOpacityMicromapEXT &
      setPpUsageCounts( const MicromapUsageEXT * const * ppUsageCounts_ ) VULKAN_HPP_NOEXCEPT
    {
      ppUsageCounts = ppUsageCounts_;
      return *this;
    }

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    AccelerationStructureTrianglesOpacityMicromapEXT &
      setPUsageCounts( ArrayProxyNoTemporaries<const MicromapUsageEXT * const> const & pUsageCounts_ ) VULKAN_HPP_NOEXCEPT
    {
      usageCountsCount = static_cast<uint32_t>( pUsageCounts_.size() );
      ppUsageCounts    = pUsageCounts_.data();
      return *this;
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureTrianglesOpacityMicromapEXT & setMicromap( MicromapEXT micromap_ ) VULKAN_HPP_NOEXCEPT
    {
      micromap = micromap_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_SETTERS*/

    operator VkAccelerationStructureTrianglesOpacityMicromapEXT const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkAccelerationStructureTrianglesOpacityMicromapEXT *>( this );
    }

    operator VkAccelerationStructureTrianglesOpacityMicromapEXT &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkAccelerationStructureTrianglesOpacityMicromapEXT *>( this );
    }

    operator VkAccelerationStructureTrianglesOpacityMicromapEXT const *() const VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<const VkAccelerationStructureTrianglesOpacityMicromapEXT *>( this );
    }

    operator VkAccelerationStructureTrianglesOpacityMicromapEXT *() VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<VkAccelerationStructureTrianglesOpacityMicromapEXT *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<StructureType const &,
               void * const &,
               IndexType const &,
               DeviceOrHostAddressConstKHR const &,
               DeviceSize const &,
               uint32_t const &,
               uint32_t const &,
               const MicromapUsageEXT * const &,
               const MicromapUsageEXT * const * const &,
               MicromapEXT const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, indexType, indexBuffer, indexStride, baseTriangle, usageCountsCount, pUsageCounts, ppUsageCounts, micromap );
    }
#endif

  public:
    StructureType                    sType            = StructureType::eAccelerationStructureTrianglesOpacityMicromapEXT;
    void *                           pNext            = {};
    IndexType                        indexType        = IndexType::eUint16;
    DeviceOrHostAddressConstKHR      indexBuffer      = {};
    DeviceSize                       indexStride      = {};
    uint32_t                         baseTriangle     = {};
    uint32_t                         usageCountsCount = {};
    const MicromapUsageEXT *         pUsageCounts     = {};
    const MicromapUsageEXT * const * ppUsageCounts    = {};
    MicromapEXT                      micromap         = {};
  };

  template <>
  struct CppType<StructureType, StructureType::eAccelerationStructureTrianglesOpacityMicromapEXT>
  {
    using Type = AccelerationStructureTrianglesOpacityMicromapEXT;
  };

  // wrapper struct for struct VkAccelerationStructureVersionInfoKHR, see
  // https://registry.khronos.org/vulkan/specs/latest/man/html/VkAccelerationStructureVersionInfoKHR.html
  struct AccelerationStructureVersionInfoKHR
  {
    using NativeType = VkAccelerationStructureVersionInfoKHR;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eAccelerationStructureVersionInfoKHR;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR AccelerationStructureVersionInfoKHR( const uint8_t * pVersionData_ = {}, const void * pNext_ = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , pVersionData{ pVersionData_ }
    {
    }

    VULKAN_HPP_CONSTEXPR AccelerationStructureVersionInfoKHR( AccelerationStructureVersionInfoKHR const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    AccelerationStructureVersionInfoKHR( VkAccelerationStructureVersionInfoKHR const & rhs ) VULKAN_HPP_NOEXCEPT
      : AccelerationStructureVersionInfoKHR( *reinterpret_cast<AccelerationStructureVersionInfoKHR const *>( &rhs ) )
    {
    }

    AccelerationStructureVersionInfoKHR & operator=( AccelerationStructureVersionInfoKHR const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    AccelerationStructureVersionInfoKHR & operator=( VkAccelerationStructureVersionInfoKHR const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<AccelerationStructureVersionInfoKHR const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureVersionInfoKHR & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AccelerationStructureVersionInfoKHR & setPVersionData( const uint8_t * pVersionData_ ) VULKAN_HPP_NOEXCEPT
    {
      pVersionData = pVersionData_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_SETTERS*/

    operator VkAccelerationStructureVersionInfoKHR const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkAccelerationStructureVersionInfoKHR *>( this );
    }

    operator VkAccelerationStructureVersionInfoKHR &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkAccelerationStructureVersionInfoKHR *>( this );
    }

    operator VkAccelerationStructureVersionInfoKHR const *() const VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<const VkAccelerationStructureVersionInfoKHR *>( this );
    }

    operator VkAccelerationStructureVersionInfoKHR *() VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<VkAccelerationStructureVersionInfoKHR *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<StructureType const &, const void * const &, const uint8_t * const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, pVersionData );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( AccelerationStructureVersionInfoKHR const & ) const = default;
#else
    bool operator==( AccelerationStructureVersionInfoKHR const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( pVersionData == rhs.pVersionData );
#  endif
    }

    bool operator!=( AccelerationStructureVersionInfoKHR const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    StructureType   sType        = StructureType::eAccelerationStructureVersionInfoKHR;
    const void *    pNext        = {};
    const uint8_t * pVersionData = {};
  };

  template <>
  struct CppType<StructureType, StructureType::eAccelerationStructureVersionInfoKHR>
  {
    using Type = AccelerationStructureVersionInfoKHR;
  };

  // wrapper struct for struct VkAcquireNextImageInfoKHR, see https://registry.khronos.org/vulkan/specs/latest/man/html/VkAcquireNextImageInfoKHR.html
  struct AcquireNextImageInfoKHR
  {
    using NativeType = VkAcquireNextImageInfoKHR;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eAcquireNextImageInfoKHR;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR AcquireNextImageInfoKHR( SwapchainKHR swapchain_  = {},
                                                  uint64_t     timeout_    = {},
                                                  Semaphore    semaphore_  = {},
                                                  Fence        fence_      = {},
                                                  uint32_t     deviceMask_ = {},
                                                  const void * pNext_      = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , swapchain{ swapchain_ }
      , timeout{ timeout_ }
      , semaphore{ semaphore_ }
      , fence{ fence_ }
      , deviceMask{ deviceMask_ }
    {
    }

    VULKAN_HPP_CONSTEXPR AcquireNextImageInfoKHR( AcquireNextImageInfoKHR const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    AcquireNextImageInfoKHR( VkAcquireNextImageInfoKHR const & rhs ) VULKAN_HPP_NOEXCEPT
      : AcquireNextImageInfoKHR( *reinterpret_cast<AcquireNextImageInfoKHR const *>( &rhs ) )
    {
    }

    AcquireNextImageInfoKHR & operator=( AcquireNextImageInfoKHR const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    AcquireNextImageInfoKHR & operator=( VkAcquireNextImageInfoKHR const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<AcquireNextImageInfoKHR const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 AcquireNextImageInfoKHR & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AcquireNextImageInfoKHR & setSwapchain( SwapchainKHR swapchain_ ) VULKAN_HPP_NOEXCEPT
    {
      swapchain = swapchain_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AcquireNextImageInfoKHR & setTimeout( uint64_t timeout_ ) VULKAN_HPP_NOEXCEPT
    {
      timeout = timeout_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AcquireNextImageInfoKHR & setSemaphore( Semaphore semaphore_ ) VULKAN_HPP_NOEXCEPT
    {
      semaphore = semaphore_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AcquireNextImageInfoKHR & setFence( Fence fence_ ) VULKAN_HPP_NOEXCEPT
    {
      fence = fence_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AcquireNextImageInfoKHR & setDeviceMask( uint32_t deviceMask_ ) VULKAN_HPP_NOEXCEPT
    {
      deviceMask = deviceMask_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_SETTERS*/

    operator VkAcquireNextImageInfoKHR const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkAcquireNextImageInfoKHR *>( this );
    }

    operator VkAcquireNextImageInfoKHR &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkAcquireNextImageInfoKHR *>( this );
    }

    operator VkAcquireNextImageInfoKHR const *() const VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<const VkAcquireNextImageInfoKHR *>( this );
    }

    operator VkAcquireNextImageInfoKHR *() VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<VkAcquireNextImageInfoKHR *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<StructureType const &, const void * const &, SwapchainKHR const &, uint64_t const &, Semaphore const &, Fence const &, uint32_t const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, swapchain, timeout, semaphore, fence, deviceMask );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( AcquireNextImageInfoKHR const & ) const = default;
#else
    bool operator==( AcquireNextImageInfoKHR const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( swapchain == rhs.swapchain ) && ( timeout == rhs.timeout ) &&
             ( semaphore == rhs.semaphore ) && ( fence == rhs.fence ) && ( deviceMask == rhs.deviceMask );
#  endif
    }

    bool operator!=( AcquireNextImageInfoKHR const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    StructureType sType      = StructureType::eAcquireNextImageInfoKHR;
    const void *  pNext      = {};
    SwapchainKHR  swapchain  = {};
    uint64_t      timeout    = {};
    Semaphore     semaphore  = {};
    Fence         fence      = {};
    uint32_t      deviceMask = {};
  };

  template <>
  struct CppType<StructureType, StructureType::eAcquireNextImageInfoKHR>
  {
    using Type = AcquireNextImageInfoKHR;
  };

  // wrapper struct for struct VkAcquireProfilingLockInfoKHR, see https://registry.khronos.org/vulkan/specs/latest/man/html/VkAcquireProfilingLockInfoKHR.html
  struct AcquireProfilingLockInfoKHR
  {
    using NativeType = VkAcquireProfilingLockInfoKHR;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eAcquireProfilingLockInfoKHR;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR
      AcquireProfilingLockInfoKHR( AcquireProfilingLockFlagsKHR flags_ = {}, uint64_t timeout_ = {}, const void * pNext_ = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , flags{ flags_ }
      , timeout{ timeout_ }
    {
    }

    VULKAN_HPP_CONSTEXPR AcquireProfilingLockInfoKHR( AcquireProfilingLockInfoKHR const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    AcquireProfilingLockInfoKHR( VkAcquireProfilingLockInfoKHR const & rhs ) VULKAN_HPP_NOEXCEPT
      : AcquireProfilingLockInfoKHR( *reinterpret_cast<AcquireProfilingLockInfoKHR const *>( &rhs ) )
    {
    }

    AcquireProfilingLockInfoKHR & operator=( AcquireProfilingLockInfoKHR const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    AcquireProfilingLockInfoKHR & operator=( VkAcquireProfilingLockInfoKHR const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<AcquireProfilingLockInfoKHR const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 AcquireProfilingLockInfoKHR & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AcquireProfilingLockInfoKHR & setFlags( AcquireProfilingLockFlagsKHR flags_ ) VULKAN_HPP_NOEXCEPT
    {
      flags = flags_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AcquireProfilingLockInfoKHR & setTimeout( uint64_t timeout_ ) VULKAN_HPP_NOEXCEPT
    {
      timeout = timeout_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_SETTERS*/

    operator VkAcquireProfilingLockInfoKHR const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkAcquireProfilingLockInfoKHR *>( this );
    }

    operator VkAcquireProfilingLockInfoKHR &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkAcquireProfilingLockInfoKHR *>( this );
    }

    operator VkAcquireProfilingLockInfoKHR const *() const VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<const VkAcquireProfilingLockInfoKHR *>( this );
    }

    operator VkAcquireProfilingLockInfoKHR *() VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<VkAcquireProfilingLockInfoKHR *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<StructureType const &, const void * const &, AcquireProfilingLockFlagsKHR const &, uint64_t const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, flags, timeout );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( AcquireProfilingLockInfoKHR const & ) const = default;
#else
    bool operator==( AcquireProfilingLockInfoKHR const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( flags == rhs.flags ) && ( timeout == rhs.timeout );
#  endif
    }

    bool operator!=( AcquireProfilingLockInfoKHR const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    StructureType                sType   = StructureType::eAcquireProfilingLockInfoKHR;
    const void *                 pNext   = {};
    AcquireProfilingLockFlagsKHR flags   = {};
    uint64_t                     timeout = {};
  };

  template <>
  struct CppType<StructureType, StructureType::eAcquireProfilingLockInfoKHR>
  {
    using Type = AcquireProfilingLockInfoKHR;
  };

  typedef void *( VKAPI_PTR * PFN_AllocationFunction )( void * pUserData, size_t size, size_t alignment, SystemAllocationScope allocationScope );

  typedef void *( VKAPI_PTR * PFN_ReallocationFunction )(
    void * pUserData, void * pOriginal, size_t size, size_t alignment, SystemAllocationScope allocationScope );

  typedef void( VKAPI_PTR * PFN_FreeFunction )( void * pUserData, void * pMemory );

  typedef void( VKAPI_PTR * PFN_InternalAllocationNotification )( void *                 pUserData,
                                                                  size_t                 size,
                                                                  InternalAllocationType allocationType,
                                                                  SystemAllocationScope  allocationScope );

  typedef void( VKAPI_PTR * PFN_InternalFreeNotification )( void *                 pUserData,
                                                            size_t                 size,
                                                            InternalAllocationType allocationType,
                                                            SystemAllocationScope  allocationScope );

  // wrapper struct for struct VkAllocationCallbacks, see https://registry.khronos.org/vulkan/specs/latest/man/html/VkAllocationCallbacks.html
  struct AllocationCallbacks
  {
    using NativeType = VkAllocationCallbacks;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR AllocationCallbacks( void *                             pUserData_             = {},
                                              PFN_AllocationFunction             pfnAllocation_         = {},
                                              PFN_ReallocationFunction           pfnReallocation_       = {},
                                              PFN_FreeFunction                   pfnFree_               = {},
                                              PFN_InternalAllocationNotification pfnInternalAllocation_ = {},
                                              PFN_InternalFreeNotification       pfnInternalFree_       = {} ) VULKAN_HPP_NOEXCEPT
      : pUserData{ pUserData_ }
      , pfnAllocation{ pfnAllocation_ }
      , pfnReallocation{ pfnReallocation_ }
      , pfnFree{ pfnFree_ }
      , pfnInternalAllocation{ pfnInternalAllocation_ }
      , pfnInternalFree{ pfnInternalFree_ }
    {
    }

    VULKAN_HPP_CONSTEXPR AllocationCallbacks( AllocationCallbacks const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    AllocationCallbacks( VkAllocationCallbacks const & rhs ) VULKAN_HPP_NOEXCEPT : AllocationCallbacks( *reinterpret_cast<AllocationCallbacks const *>( &rhs ) )
    {
    }

#  if defined( __clang__ ) || defined( __GNUC__ )
#    pragma GCC diagnostic push
#    if defined( __clang__ )
#      pragma clang diagnostic ignored "-Wunknown-warning-option"
#    endif
#    pragma GCC diagnostic ignored "-Wcast-function-type"
#  endif
    VULKAN_HPP_DEPRECATED( "This constructor is deprecated. Use the one taking function pointer types from the vk-namespace instead." )

    AllocationCallbacks( void *                               pUserData_,
                         PFN_vkAllocationFunction             pfnAllocation_,
                         PFN_vkReallocationFunction           pfnReallocation_       = {},
                         PFN_vkFreeFunction                   pfnFree_               = {},
                         PFN_vkInternalAllocationNotification pfnInternalAllocation_ = {},
                         PFN_vkInternalFreeNotification       pfnInternalFree_       = {} ) VULKAN_HPP_NOEXCEPT
      : AllocationCallbacks( pUserData_,
                             reinterpret_cast<PFN_AllocationFunction>( pfnAllocation_ ),
                             reinterpret_cast<PFN_ReallocationFunction>( pfnReallocation_ ),
                             reinterpret_cast<PFN_FreeFunction>( pfnFree_ ),
                             reinterpret_cast<PFN_InternalAllocationNotification>( pfnInternalAllocation_ ),
                             reinterpret_cast<PFN_InternalFreeNotification>( pfnInternalFree_ ) )
    {
    }
#  if defined( __clang__ ) || defined( __GNUC__ )
#    pragma GCC diagnostic pop
#  endif

    AllocationCallbacks & operator=( AllocationCallbacks const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    AllocationCallbacks & operator=( VkAllocationCallbacks const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<AllocationCallbacks const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 AllocationCallbacks & setPUserData( void * pUserData_ ) VULKAN_HPP_NOEXCEPT
    {
      pUserData = pUserData_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AllocationCallbacks & setPfnAllocation( PFN_AllocationFunction pfnAllocation_ ) VULKAN_HPP_NOEXCEPT
    {
      pfnAllocation = pfnAllocation_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AllocationCallbacks & setPfnReallocation( PFN_ReallocationFunction pfnReallocation_ ) VULKAN_HPP_NOEXCEPT
    {
      pfnReallocation = pfnReallocation_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AllocationCallbacks & setPfnFree( PFN_FreeFunction pfnFree_ ) VULKAN_HPP_NOEXCEPT
    {
      pfnFree = pfnFree_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AllocationCallbacks & setPfnInternalAllocation( PFN_InternalAllocationNotification pfnInternalAllocation_ ) VULKAN_HPP_NOEXCEPT
    {
      pfnInternalAllocation = pfnInternalAllocation_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AllocationCallbacks & setPfnInternalFree( PFN_InternalFreeNotification pfnInternalFree_ ) VULKAN_HPP_NOEXCEPT
    {
      pfnInternalFree = pfnInternalFree_;
      return *this;
    }

#  if defined( __clang__ ) || defined( __GNUC__ )
#    pragma GCC diagnostic push
#    if defined( __clang__ )
#      pragma clang diagnostic ignored "-Wunknown-warning-option"
#    endif
#    pragma GCC diagnostic ignored "-Wcast-function-type"
#  endif
    VULKAN_HPP_DEPRECATED( "This setter is deprecated. Use the one taking a function pointer type from the vk-namespace instead." )

    AllocationCallbacks & setPfnAllocation( PFN_vkAllocationFunction pfnAllocation_ ) VULKAN_HPP_NOEXCEPT
    {
      return setPfnAllocation( reinterpret_cast<PFN_AllocationFunction>( pfnAllocation_ ) );
    }

    VULKAN_HPP_DEPRECATED( "This setter is deprecated. Use the one taking a function pointer type from the vk-namespace instead." )

    AllocationCallbacks & setPfnReallocation( PFN_vkReallocationFunction pfnReallocation_ ) VULKAN_HPP_NOEXCEPT
    {
      return setPfnReallocation( reinterpret_cast<PFN_ReallocationFunction>( pfnReallocation_ ) );
    }

    VULKAN_HPP_DEPRECATED( "This setter is deprecated. Use the one taking a function pointer type from the vk-namespace instead." )

    AllocationCallbacks & setPfnInternalAllocation( PFN_vkInternalAllocationNotification pfnInternalAllocation_ ) VULKAN_HPP_NOEXCEPT
    {
      return setPfnInternalAllocation( reinterpret_cast<PFN_InternalAllocationNotification>( pfnInternalAllocation_ ) );
    }

    VULKAN_HPP_DEPRECATED( "This setter is deprecated. Use the one taking a function pointer type from the vk-namespace instead." )

    AllocationCallbacks & setPfnInternalFree( PFN_vkInternalFreeNotification pfnInternalFree_ ) VULKAN_HPP_NOEXCEPT
    {
      return setPfnInternalFree( reinterpret_cast<PFN_InternalFreeNotification>( pfnInternalFree_ ) );
    }
#  if defined( __clang__ ) || defined( __GNUC__ )
#    pragma GCC diagnostic pop
#  endif
#endif /*VULKAN_HPP_NO_SETTERS*/

    operator VkAllocationCallbacks const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkAllocationCallbacks *>( this );
    }

    operator VkAllocationCallbacks &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkAllocationCallbacks *>( this );
    }

    operator VkAllocationCallbacks const *() const VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<const VkAllocationCallbacks *>( this );
    }

    operator VkAllocationCallbacks *() VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<VkAllocationCallbacks *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<void * const &,
               PFN_AllocationFunction const &,
               PFN_ReallocationFunction const &,
               PFN_FreeFunction const &,
               PFN_InternalAllocationNotification const &,
               PFN_InternalFreeNotification const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( pUserData, pfnAllocation, pfnReallocation, pfnFree, pfnInternalAllocation, pfnInternalFree );
    }
#endif

    bool operator==( AllocationCallbacks const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#else
      return ( pUserData == rhs.pUserData ) && ( pfnAllocation == rhs.pfnAllocation ) && ( pfnReallocation == rhs.pfnReallocation ) &&
             ( pfnFree == rhs.pfnFree ) && ( pfnInternalAllocation == rhs.pfnInternalAllocation ) && ( pfnInternalFree == rhs.pfnInternalFree );
#endif
    }

    bool operator!=( AllocationCallbacks const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }

  public:
    void *                             pUserData             = {};
    PFN_AllocationFunction             pfnAllocation         = {};
    PFN_ReallocationFunction           pfnReallocation       = {};
    PFN_FreeFunction                   pfnFree               = {};
    PFN_InternalAllocationNotification pfnInternalAllocation = {};
    PFN_InternalFreeNotification       pfnInternalFree       = {};
  };

  // wrapper struct for struct VkAmigoProfilingSubmitInfoSEC, see https://registry.khronos.org/vulkan/specs/latest/man/html/VkAmigoProfilingSubmitInfoSEC.html
  struct AmigoProfilingSubmitInfoSEC
  {
    using NativeType = VkAmigoProfilingSubmitInfoSEC;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eAmigoProfilingSubmitInfoSEC;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR
      AmigoProfilingSubmitInfoSEC( uint64_t firstDrawTimestamp_ = {}, uint64_t swapBufferTimestamp_ = {}, const void * pNext_ = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , firstDrawTimestamp{ firstDrawTimestamp_ }
      , swapBufferTimestamp{ swapBufferTimestamp_ }
    {
    }

    VULKAN_HPP_CONSTEXPR AmigoProfilingSubmitInfoSEC( AmigoProfilingSubmitInfoSEC const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    AmigoProfilingSubmitInfoSEC( VkAmigoProfilingSubmitInfoSEC const & rhs ) VULKAN_HPP_NOEXCEPT
      : AmigoProfilingSubmitInfoSEC( *reinterpret_cast<AmigoProfilingSubmitInfoSEC const *>( &rhs ) )
    {
    }

    AmigoProfilingSubmitInfoSEC & operator=( AmigoProfilingSubmitInfoSEC const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    AmigoProfilingSubmitInfoSEC & operator=( VkAmigoProfilingSubmitInfoSEC const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<AmigoProfilingSubmitInfoSEC const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 AmigoProfilingSubmitInfoSEC & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AmigoProfilingSubmitInfoSEC & setFirstDrawTimestamp( uint64_t firstDrawTimestamp_ ) VULKAN_HPP_NOEXCEPT
    {
      firstDrawTimestamp = firstDrawTimestamp_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AmigoProfilingSubmitInfoSEC & setSwapBufferTimestamp( uint64_t swapBufferTimestamp_ ) VULKAN_HPP_NOEXCEPT
    {
      swapBufferTimestamp = swapBufferTimestamp_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_SETTERS*/

    operator VkAmigoProfilingSubmitInfoSEC const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkAmigoProfilingSubmitInfoSEC *>( this );
    }

    operator VkAmigoProfilingSubmitInfoSEC &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkAmigoProfilingSubmitInfoSEC *>( this );
    }

    operator VkAmigoProfilingSubmitInfoSEC const *() const VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<const VkAmigoProfilingSubmitInfoSEC *>( this );
    }

    operator VkAmigoProfilingSubmitInfoSEC *() VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<VkAmigoProfilingSubmitInfoSEC *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<StructureType const &, const void * const &, uint64_t const &, uint64_t const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, firstDrawTimestamp, swapBufferTimestamp );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( AmigoProfilingSubmitInfoSEC const & ) const = default;
#else
    bool operator==( AmigoProfilingSubmitInfoSEC const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( firstDrawTimestamp == rhs.firstDrawTimestamp ) &&
             ( swapBufferTimestamp == rhs.swapBufferTimestamp );
#  endif
    }

    bool operator!=( AmigoProfilingSubmitInfoSEC const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    StructureType sType               = StructureType::eAmigoProfilingSubmitInfoSEC;
    const void *  pNext               = {};
    uint64_t      firstDrawTimestamp  = {};
    uint64_t      swapBufferTimestamp = {};
  };

  template <>
  struct CppType<StructureType, StructureType::eAmigoProfilingSubmitInfoSEC>
  {
    using Type = AmigoProfilingSubmitInfoSEC;
  };

  // wrapper struct for struct VkComponentMapping, see https://registry.khronos.org/vulkan/specs/latest/man/html/VkComponentMapping.html
  struct ComponentMapping
  {
    using NativeType = VkComponentMapping;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR ComponentMapping( ComponentSwizzle r_ = ComponentSwizzle::eIdentity,
                                           ComponentSwizzle g_ = ComponentSwizzle::eIdentity,
                                           ComponentSwizzle b_ = ComponentSwizzle::eIdentity,
                                           ComponentSwizzle a_ = ComponentSwizzle::eIdentity ) VULKAN_HPP_NOEXCEPT
      : r{ r_ }
      , g{ g_ }
      , b{ b_ }
      , a{ a_ }
    {
    }

    VULKAN_HPP_CONSTEXPR ComponentMapping( ComponentMapping const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    ComponentMapping( VkComponentMapping const & rhs ) VULKAN_HPP_NOEXCEPT : ComponentMapping( *reinterpret_cast<ComponentMapping const *>( &rhs ) ) {}

    ComponentMapping & operator=( ComponentMapping const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    ComponentMapping & operator=( VkComponentMapping const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<ComponentMapping const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 ComponentMapping & setR( ComponentSwizzle r_ ) VULKAN_HPP_NOEXCEPT
    {
      r = r_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ComponentMapping & setG( ComponentSwizzle g_ ) VULKAN_HPP_NOEXCEPT
    {
      g = g_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ComponentMapping & setB( ComponentSwizzle b_ ) VULKAN_HPP_NOEXCEPT
    {
      b = b_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ComponentMapping & setA( ComponentSwizzle a_ ) VULKAN_HPP_NOEXCEPT
    {
      a = a_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_SETTERS*/

    operator VkComponentMapping const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkComponentMapping *>( this );
    }

    operator VkComponentMapping &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkComponentMapping *>( this );
    }

    operator VkComponentMapping const *() const VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<const VkComponentMapping *>( this );
    }

    operator VkComponentMapping *() VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<VkComponentMapping *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<ComponentSwizzle const &, ComponentSwizzle const &, ComponentSwizzle const &, ComponentSwizzle const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( r, g, b, a );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( ComponentMapping const & ) const = default;
#else
    bool operator==( ComponentMapping const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( r == rhs.r ) && ( g == rhs.g ) && ( b == rhs.b ) && ( a == rhs.a );
#  endif
    }

    bool operator!=( ComponentMapping const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    ComponentSwizzle r = ComponentSwizzle::eIdentity;
    ComponentSwizzle g = ComponentSwizzle::eIdentity;
    ComponentSwizzle b = ComponentSwizzle::eIdentity;
    ComponentSwizzle a = ComponentSwizzle::eIdentity;
  };

#if defined( VK_USE_PLATFORM_ANDROID_KHR )
  // wrapper struct for struct VkAndroidHardwareBufferFormatProperties2ANDROID, see
  // https://registry.khronos.org/vulkan/specs/latest/man/html/VkAndroidHardwareBufferFormatProperties2ANDROID.html
  struct AndroidHardwareBufferFormatProperties2ANDROID
  {
    using NativeType = VkAndroidHardwareBufferFormatProperties2ANDROID;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eAndroidHardwareBufferFormatProperties2ANDROID;

#  if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR
      AndroidHardwareBufferFormatProperties2ANDROID( Format                      format_                           = Format::eUndefined,
                                                     uint64_t                    externalFormat_                   = {},
                                                     FormatFeatureFlags2         formatFeatures_                   = {},
                                                     ComponentMapping            samplerYcbcrConversionComponents_ = {},
                                                     SamplerYcbcrModelConversion suggestedYcbcrModel_              = SamplerYcbcrModelConversion::eRgbIdentity,
                                                     SamplerYcbcrRange           suggestedYcbcrRange_              = SamplerYcbcrRange::eItuFull,
                                                     ChromaLocation              suggestedXChromaOffset_           = ChromaLocation::eCositedEven,
                                                     ChromaLocation              suggestedYChromaOffset_           = ChromaLocation::eCositedEven,
                                                     void *                      pNext_                            = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , format{ format_ }
      , externalFormat{ externalFormat_ }
      , formatFeatures{ formatFeatures_ }
      , samplerYcbcrConversionComponents{ samplerYcbcrConversionComponents_ }
      , suggestedYcbcrModel{ suggestedYcbcrModel_ }
      , suggestedYcbcrRange{ suggestedYcbcrRange_ }
      , suggestedXChromaOffset{ suggestedXChromaOffset_ }
      , suggestedYChromaOffset{ suggestedYChromaOffset_ }
    {
    }

    VULKAN_HPP_CONSTEXPR
      AndroidHardwareBufferFormatProperties2ANDROID( AndroidHardwareBufferFormatProperties2ANDROID const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    AndroidHardwareBufferFormatProperties2ANDROID( VkAndroidHardwareBufferFormatProperties2ANDROID const & rhs ) VULKAN_HPP_NOEXCEPT
      : AndroidHardwareBufferFormatProperties2ANDROID( *reinterpret_cast<AndroidHardwareBufferFormatProperties2ANDROID const *>( &rhs ) )
    {
    }

    AndroidHardwareBufferFormatProperties2ANDROID & operator=( AndroidHardwareBufferFormatProperties2ANDROID const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#  endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    AndroidHardwareBufferFormatProperties2ANDROID & operator=( VkAndroidHardwareBufferFormatProperties2ANDROID const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<AndroidHardwareBufferFormatProperties2ANDROID const *>( &rhs );
      return *this;
    }

    operator VkAndroidHardwareBufferFormatProperties2ANDROID const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkAndroidHardwareBufferFormatProperties2ANDROID *>( this );
    }

    operator VkAndroidHardwareBufferFormatProperties2ANDROID &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkAndroidHardwareBufferFormatProperties2ANDROID *>( this );
    }

    operator VkAndroidHardwareBufferFormatProperties2ANDROID const *() const VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<const VkAndroidHardwareBufferFormatProperties2ANDROID *>( this );
    }

    operator VkAndroidHardwareBufferFormatProperties2ANDROID *() VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<VkAndroidHardwareBufferFormatProperties2ANDROID *>( this );
    }

#  if defined( VULKAN_HPP_USE_REFLECT )
#    if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#    else
    std::tuple<StructureType const &,
               void * const &,
               Format const &,
               uint64_t const &,
               FormatFeatureFlags2 const &,
               ComponentMapping const &,
               SamplerYcbcrModelConversion const &,
               SamplerYcbcrRange const &,
               ChromaLocation const &,
               ChromaLocation const &>
#    endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType,
                       pNext,
                       format,
                       externalFormat,
                       formatFeatures,
                       samplerYcbcrConversionComponents,
                       suggestedYcbcrModel,
                       suggestedYcbcrRange,
                       suggestedXChromaOffset,
                       suggestedYChromaOffset );
    }
#  endif

#  if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( AndroidHardwareBufferFormatProperties2ANDROID const & ) const = default;
#  else
    bool operator==( AndroidHardwareBufferFormatProperties2ANDROID const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#    if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#    else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( format == rhs.format ) && ( externalFormat == rhs.externalFormat ) &&
             ( formatFeatures == rhs.formatFeatures ) && ( samplerYcbcrConversionComponents == rhs.samplerYcbcrConversionComponents ) &&
             ( suggestedYcbcrModel == rhs.suggestedYcbcrModel ) && ( suggestedYcbcrRange == rhs.suggestedYcbcrRange ) &&
             ( suggestedXChromaOffset == rhs.suggestedXChromaOffset ) && ( suggestedYChromaOffset == rhs.suggestedYChromaOffset );
#    endif
    }

    bool operator!=( AndroidHardwareBufferFormatProperties2ANDROID const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#  endif

  public:
    StructureType               sType                            = StructureType::eAndroidHardwareBufferFormatProperties2ANDROID;
    void *                      pNext                            = {};
    Format                      format                           = Format::eUndefined;
    uint64_t                    externalFormat                   = {};
    FormatFeatureFlags2         formatFeatures                   = {};
    ComponentMapping            samplerYcbcrConversionComponents = {};
    SamplerYcbcrModelConversion suggestedYcbcrModel              = SamplerYcbcrModelConversion::eRgbIdentity;
    SamplerYcbcrRange           suggestedYcbcrRange              = SamplerYcbcrRange::eItuFull;
    ChromaLocation              suggestedXChromaOffset           = ChromaLocation::eCositedEven;
    ChromaLocation              suggestedYChromaOffset           = ChromaLocation::eCositedEven;
  };

  template <>
  struct CppType<StructureType, StructureType::eAndroidHardwareBufferFormatProperties2ANDROID>
  {
    using Type = AndroidHardwareBufferFormatProperties2ANDROID;
  };
#endif /*VK_USE_PLATFORM_ANDROID_KHR*/

#if defined( VK_USE_PLATFORM_ANDROID_KHR )
  // wrapper struct for struct VkAndroidHardwareBufferFormatPropertiesANDROID, see
  // https://registry.khronos.org/vulkan/specs/latest/man/html/VkAndroidHardwareBufferFormatPropertiesANDROID.html
  struct AndroidHardwareBufferFormatPropertiesANDROID
  {
    using NativeType = VkAndroidHardwareBufferFormatPropertiesANDROID;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eAndroidHardwareBufferFormatPropertiesANDROID;

#  if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR
      AndroidHardwareBufferFormatPropertiesANDROID( Format                      format_                           = Format::eUndefined,
                                                    uint64_t                    externalFormat_                   = {},
                                                    FormatFeatureFlags          formatFeatures_                   = {},
                                                    ComponentMapping            samplerYcbcrConversionComponents_ = {},
                                                    SamplerYcbcrModelConversion suggestedYcbcrModel_              = SamplerYcbcrModelConversion::eRgbIdentity,
                                                    SamplerYcbcrRange           suggestedYcbcrRange_              = SamplerYcbcrRange::eItuFull,
                                                    ChromaLocation              suggestedXChromaOffset_           = ChromaLocation::eCositedEven,
                                                    ChromaLocation              suggestedYChromaOffset_           = ChromaLocation::eCositedEven,
                                                    void *                      pNext_                            = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , format{ format_ }
      , externalFormat{ externalFormat_ }
      , formatFeatures{ formatFeatures_ }
      , samplerYcbcrConversionComponents{ samplerYcbcrConversionComponents_ }
      , suggestedYcbcrModel{ suggestedYcbcrModel_ }
      , suggestedYcbcrRange{ suggestedYcbcrRange_ }
      , suggestedXChromaOffset{ suggestedXChromaOffset_ }
      , suggestedYChromaOffset{ suggestedYChromaOffset_ }
    {
    }

    VULKAN_HPP_CONSTEXPR AndroidHardwareBufferFormatPropertiesANDROID( AndroidHardwareBufferFormatPropertiesANDROID const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    AndroidHardwareBufferFormatPropertiesANDROID( VkAndroidHardwareBufferFormatPropertiesANDROID const & rhs ) VULKAN_HPP_NOEXCEPT
      : AndroidHardwareBufferFormatPropertiesANDROID( *reinterpret_cast<AndroidHardwareBufferFormatPropertiesANDROID const *>( &rhs ) )
    {
    }

    AndroidHardwareBufferFormatPropertiesANDROID & operator=( AndroidHardwareBufferFormatPropertiesANDROID const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#  endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    AndroidHardwareBufferFormatPropertiesANDROID & operator=( VkAndroidHardwareBufferFormatPropertiesANDROID const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<AndroidHardwareBufferFormatPropertiesANDROID const *>( &rhs );
      return *this;
    }

    operator VkAndroidHardwareBufferFormatPropertiesANDROID const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkAndroidHardwareBufferFormatPropertiesANDROID *>( this );
    }

    operator VkAndroidHardwareBufferFormatPropertiesANDROID &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkAndroidHardwareBufferFormatPropertiesANDROID *>( this );
    }

    operator VkAndroidHardwareBufferFormatPropertiesANDROID const *() const VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<const VkAndroidHardwareBufferFormatPropertiesANDROID *>( this );
    }

    operator VkAndroidHardwareBufferFormatPropertiesANDROID *() VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<VkAndroidHardwareBufferFormatPropertiesANDROID *>( this );
    }

#  if defined( VULKAN_HPP_USE_REFLECT )
#    if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#    else
    std::tuple<StructureType const &,
               void * const &,
               Format const &,
               uint64_t const &,
               FormatFeatureFlags const &,
               ComponentMapping const &,
               SamplerYcbcrModelConversion const &,
               SamplerYcbcrRange const &,
               ChromaLocation const &,
               ChromaLocation const &>
#    endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType,
                       pNext,
                       format,
                       externalFormat,
                       formatFeatures,
                       samplerYcbcrConversionComponents,
                       suggestedYcbcrModel,
                       suggestedYcbcrRange,
                       suggestedXChromaOffset,
                       suggestedYChromaOffset );
    }
#  endif

#  if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( AndroidHardwareBufferFormatPropertiesANDROID const & ) const = default;
#  else
    bool operator==( AndroidHardwareBufferFormatPropertiesANDROID const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#    if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#    else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( format == rhs.format ) && ( externalFormat == rhs.externalFormat ) &&
             ( formatFeatures == rhs.formatFeatures ) && ( samplerYcbcrConversionComponents == rhs.samplerYcbcrConversionComponents ) &&
             ( suggestedYcbcrModel == rhs.suggestedYcbcrModel ) && ( suggestedYcbcrRange == rhs.suggestedYcbcrRange ) &&
             ( suggestedXChromaOffset == rhs.suggestedXChromaOffset ) && ( suggestedYChromaOffset == rhs.suggestedYChromaOffset );
#    endif
    }

    bool operator!=( AndroidHardwareBufferFormatPropertiesANDROID const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#  endif

  public:
    StructureType               sType                            = StructureType::eAndroidHardwareBufferFormatPropertiesANDROID;
    void *                      pNext                            = {};
    Format                      format                           = Format::eUndefined;
    uint64_t                    externalFormat                   = {};
    FormatFeatureFlags          formatFeatures                   = {};
    ComponentMapping            samplerYcbcrConversionComponents = {};
    SamplerYcbcrModelConversion suggestedYcbcrModel              = SamplerYcbcrModelConversion::eRgbIdentity;
    SamplerYcbcrRange           suggestedYcbcrRange              = SamplerYcbcrRange::eItuFull;
    ChromaLocation              suggestedXChromaOffset           = ChromaLocation::eCositedEven;
    ChromaLocation              suggestedYChromaOffset           = ChromaLocation::eCositedEven;
  };

  template <>
  struct CppType<StructureType, StructureType::eAndroidHardwareBufferFormatPropertiesANDROID>
  {
    using Type = AndroidHardwareBufferFormatPropertiesANDROID;
  };
#endif /*VK_USE_PLATFORM_ANDROID_KHR*/

#if defined( VK_USE_PLATFORM_ANDROID_KHR )
  // wrapper struct for struct VkAndroidHardwareBufferFormatResolvePropertiesANDROID, see
  // https://registry.khronos.org/vulkan/specs/latest/man/html/VkAndroidHardwareBufferFormatResolvePropertiesANDROID.html
  struct AndroidHardwareBufferFormatResolvePropertiesANDROID
  {
    using NativeType = VkAndroidHardwareBufferFormatResolvePropertiesANDROID;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eAndroidHardwareBufferFormatResolvePropertiesANDROID;

#  if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR AndroidHardwareBufferFormatResolvePropertiesANDROID( Format colorAttachmentFormat_ = Format::eUndefined,
                                                                              void * pNext_                 = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , colorAttachmentFormat{ colorAttachmentFormat_ }
    {
    }

    VULKAN_HPP_CONSTEXPR
      AndroidHardwareBufferFormatResolvePropertiesANDROID( AndroidHardwareBufferFormatResolvePropertiesANDROID const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    AndroidHardwareBufferFormatResolvePropertiesANDROID( VkAndroidHardwareBufferFormatResolvePropertiesANDROID const & rhs ) VULKAN_HPP_NOEXCEPT
      : AndroidHardwareBufferFormatResolvePropertiesANDROID( *reinterpret_cast<AndroidHardwareBufferFormatResolvePropertiesANDROID const *>( &rhs ) )
    {
    }

    AndroidHardwareBufferFormatResolvePropertiesANDROID &
      operator=( AndroidHardwareBufferFormatResolvePropertiesANDROID const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#  endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    AndroidHardwareBufferFormatResolvePropertiesANDROID & operator=( VkAndroidHardwareBufferFormatResolvePropertiesANDROID const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<AndroidHardwareBufferFormatResolvePropertiesANDROID const *>( &rhs );
      return *this;
    }

    operator VkAndroidHardwareBufferFormatResolvePropertiesANDROID const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkAndroidHardwareBufferFormatResolvePropertiesANDROID *>( this );
    }

    operator VkAndroidHardwareBufferFormatResolvePropertiesANDROID &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkAndroidHardwareBufferFormatResolvePropertiesANDROID *>( this );
    }

    operator VkAndroidHardwareBufferFormatResolvePropertiesANDROID const *() const VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<const VkAndroidHardwareBufferFormatResolvePropertiesANDROID *>( this );
    }

    operator VkAndroidHardwareBufferFormatResolvePropertiesANDROID *() VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<VkAndroidHardwareBufferFormatResolvePropertiesANDROID *>( this );
    }

#  if defined( VULKAN_HPP_USE_REFLECT )
#    if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#    else
    std::tuple<StructureType const &, void * const &, Format const &>
#    endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, colorAttachmentFormat );
    }
#  endif

#  if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( AndroidHardwareBufferFormatResolvePropertiesANDROID const & ) const = default;
#  else
    bool operator==( AndroidHardwareBufferFormatResolvePropertiesANDROID const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#    if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#    else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( colorAttachmentFormat == rhs.colorAttachmentFormat );
#    endif
    }

    bool operator!=( AndroidHardwareBufferFormatResolvePropertiesANDROID const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#  endif

  public:
    StructureType sType                 = StructureType::eAndroidHardwareBufferFormatResolvePropertiesANDROID;
    void *        pNext                 = {};
    Format        colorAttachmentFormat = Format::eUndefined;
  };

  template <>
  struct CppType<StructureType, StructureType::eAndroidHardwareBufferFormatResolvePropertiesANDROID>
  {
    using Type = AndroidHardwareBufferFormatResolvePropertiesANDROID;
  };
#endif /*VK_USE_PLATFORM_ANDROID_KHR*/

#if defined( VK_USE_PLATFORM_ANDROID_KHR )
  // wrapper struct for struct VkAndroidHardwareBufferPropertiesANDROID, see
  // https://registry.khronos.org/vulkan/specs/latest/man/html/VkAndroidHardwareBufferPropertiesANDROID.html
  struct AndroidHardwareBufferPropertiesANDROID
  {
    using NativeType = VkAndroidHardwareBufferPropertiesANDROID;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eAndroidHardwareBufferPropertiesANDROID;

#  if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR
      AndroidHardwareBufferPropertiesANDROID( DeviceSize allocationSize_ = {}, uint32_t memoryTypeBits_ = {}, void * pNext_ = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , allocationSize{ allocationSize_ }
      , memoryTypeBits{ memoryTypeBits_ }
    {
    }

    VULKAN_HPP_CONSTEXPR AndroidHardwareBufferPropertiesANDROID( AndroidHardwareBufferPropertiesANDROID const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    AndroidHardwareBufferPropertiesANDROID( VkAndroidHardwareBufferPropertiesANDROID const & rhs ) VULKAN_HPP_NOEXCEPT
      : AndroidHardwareBufferPropertiesANDROID( *reinterpret_cast<AndroidHardwareBufferPropertiesANDROID const *>( &rhs ) )
    {
    }

    AndroidHardwareBufferPropertiesANDROID & operator=( AndroidHardwareBufferPropertiesANDROID const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#  endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    AndroidHardwareBufferPropertiesANDROID & operator=( VkAndroidHardwareBufferPropertiesANDROID const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<AndroidHardwareBufferPropertiesANDROID const *>( &rhs );
      return *this;
    }

    operator VkAndroidHardwareBufferPropertiesANDROID const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkAndroidHardwareBufferPropertiesANDROID *>( this );
    }

    operator VkAndroidHardwareBufferPropertiesANDROID &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkAndroidHardwareBufferPropertiesANDROID *>( this );
    }

    operator VkAndroidHardwareBufferPropertiesANDROID const *() const VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<const VkAndroidHardwareBufferPropertiesANDROID *>( this );
    }

    operator VkAndroidHardwareBufferPropertiesANDROID *() VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<VkAndroidHardwareBufferPropertiesANDROID *>( this );
    }

#  if defined( VULKAN_HPP_USE_REFLECT )
#    if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#    else
    std::tuple<StructureType const &, void * const &, DeviceSize const &, uint32_t const &>
#    endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, allocationSize, memoryTypeBits );
    }
#  endif

#  if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( AndroidHardwareBufferPropertiesANDROID const & ) const = default;
#  else
    bool operator==( AndroidHardwareBufferPropertiesANDROID const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#    if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#    else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( allocationSize == rhs.allocationSize ) && ( memoryTypeBits == rhs.memoryTypeBits );
#    endif
    }

    bool operator!=( AndroidHardwareBufferPropertiesANDROID const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#  endif

  public:
    StructureType sType          = StructureType::eAndroidHardwareBufferPropertiesANDROID;
    void *        pNext          = {};
    DeviceSize    allocationSize = {};
    uint32_t      memoryTypeBits = {};
  };

  template <>
  struct CppType<StructureType, StructureType::eAndroidHardwareBufferPropertiesANDROID>
  {
    using Type = AndroidHardwareBufferPropertiesANDROID;
  };
#endif /*VK_USE_PLATFORM_ANDROID_KHR*/

#if defined( VK_USE_PLATFORM_ANDROID_KHR )
  // wrapper struct for struct VkAndroidHardwareBufferUsageANDROID, see
  // https://registry.khronos.org/vulkan/specs/latest/man/html/VkAndroidHardwareBufferUsageANDROID.html
  struct AndroidHardwareBufferUsageANDROID
  {
    using NativeType = VkAndroidHardwareBufferUsageANDROID;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eAndroidHardwareBufferUsageANDROID;

#  if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR AndroidHardwareBufferUsageANDROID( uint64_t androidHardwareBufferUsage_ = {}, void * pNext_ = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , androidHardwareBufferUsage{ androidHardwareBufferUsage_ }
    {
    }

    VULKAN_HPP_CONSTEXPR AndroidHardwareBufferUsageANDROID( AndroidHardwareBufferUsageANDROID const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    AndroidHardwareBufferUsageANDROID( VkAndroidHardwareBufferUsageANDROID const & rhs ) VULKAN_HPP_NOEXCEPT
      : AndroidHardwareBufferUsageANDROID( *reinterpret_cast<AndroidHardwareBufferUsageANDROID const *>( &rhs ) )
    {
    }

    AndroidHardwareBufferUsageANDROID & operator=( AndroidHardwareBufferUsageANDROID const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#  endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    AndroidHardwareBufferUsageANDROID & operator=( VkAndroidHardwareBufferUsageANDROID const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<AndroidHardwareBufferUsageANDROID const *>( &rhs );
      return *this;
    }

    operator VkAndroidHardwareBufferUsageANDROID const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkAndroidHardwareBufferUsageANDROID *>( this );
    }

    operator VkAndroidHardwareBufferUsageANDROID &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkAndroidHardwareBufferUsageANDROID *>( this );
    }

    operator VkAndroidHardwareBufferUsageANDROID const *() const VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<const VkAndroidHardwareBufferUsageANDROID *>( this );
    }

    operator VkAndroidHardwareBufferUsageANDROID *() VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<VkAndroidHardwareBufferUsageANDROID *>( this );
    }

#  if defined( VULKAN_HPP_USE_REFLECT )
#    if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#    else
    std::tuple<StructureType const &, void * const &, uint64_t const &>
#    endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, androidHardwareBufferUsage );
    }
#  endif

#  if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( AndroidHardwareBufferUsageANDROID const & ) const = default;
#  else
    bool operator==( AndroidHardwareBufferUsageANDROID const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#    if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#    else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( androidHardwareBufferUsage == rhs.androidHardwareBufferUsage );
#    endif
    }

    bool operator!=( AndroidHardwareBufferUsageANDROID const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#  endif

  public:
    StructureType sType                      = StructureType::eAndroidHardwareBufferUsageANDROID;
    void *        pNext                      = {};
    uint64_t      androidHardwareBufferUsage = {};
  };

  template <>
  struct CppType<StructureType, StructureType::eAndroidHardwareBufferUsageANDROID>
  {
    using Type = AndroidHardwareBufferUsageANDROID;
  };
#endif /*VK_USE_PLATFORM_ANDROID_KHR*/

#if defined( VK_USE_PLATFORM_ANDROID_KHR )
  // wrapper struct for struct VkAndroidSurfaceCreateInfoKHR, see https://registry.khronos.org/vulkan/specs/latest/man/html/VkAndroidSurfaceCreateInfoKHR.html
  struct AndroidSurfaceCreateInfoKHR
  {
    using NativeType = VkAndroidSurfaceCreateInfoKHR;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eAndroidSurfaceCreateInfoKHR;

#  if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR AndroidSurfaceCreateInfoKHR( AndroidSurfaceCreateFlagsKHR flags_  = {},
                                                      struct ANativeWindow *       window_ = {},
                                                      const void *                 pNext_  = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , flags{ flags_ }
      , window{ window_ }
    {
    }

    VULKAN_HPP_CONSTEXPR AndroidSurfaceCreateInfoKHR( AndroidSurfaceCreateInfoKHR const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    AndroidSurfaceCreateInfoKHR( VkAndroidSurfaceCreateInfoKHR const & rhs ) VULKAN_HPP_NOEXCEPT
      : AndroidSurfaceCreateInfoKHR( *reinterpret_cast<AndroidSurfaceCreateInfoKHR const *>( &rhs ) )
    {
    }

    AndroidSurfaceCreateInfoKHR & operator=( AndroidSurfaceCreateInfoKHR const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#  endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    AndroidSurfaceCreateInfoKHR & operator=( VkAndroidSurfaceCreateInfoKHR const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<AndroidSurfaceCreateInfoKHR const *>( &rhs );
      return *this;
    }

#  if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 AndroidSurfaceCreateInfoKHR & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AndroidSurfaceCreateInfoKHR & setFlags( AndroidSurfaceCreateFlagsKHR flags_ ) VULKAN_HPP_NOEXCEPT
    {
      flags = flags_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AndroidSurfaceCreateInfoKHR & setWindow( struct ANativeWindow * window_ ) VULKAN_HPP_NOEXCEPT
    {
      window = window_;
      return *this;
    }
#  endif /*VULKAN_HPP_NO_SETTERS*/

    operator VkAndroidSurfaceCreateInfoKHR const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkAndroidSurfaceCreateInfoKHR *>( this );
    }

    operator VkAndroidSurfaceCreateInfoKHR &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkAndroidSurfaceCreateInfoKHR *>( this );
    }

    operator VkAndroidSurfaceCreateInfoKHR const *() const VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<const VkAndroidSurfaceCreateInfoKHR *>( this );
    }

    operator VkAndroidSurfaceCreateInfoKHR *() VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<VkAndroidSurfaceCreateInfoKHR *>( this );
    }

#  if defined( VULKAN_HPP_USE_REFLECT )
#    if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#    else
    std::tuple<StructureType const &, const void * const &, AndroidSurfaceCreateFlagsKHR const &, struct ANativeWindow * const &>
#    endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, flags, window );
    }
#  endif

#  if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( AndroidSurfaceCreateInfoKHR const & ) const = default;
#  else
    bool operator==( AndroidSurfaceCreateInfoKHR const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#    if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#    else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( flags == rhs.flags ) && ( window == rhs.window );
#    endif
    }

    bool operator!=( AndroidSurfaceCreateInfoKHR const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#  endif

  public:
    StructureType                sType  = StructureType::eAndroidSurfaceCreateInfoKHR;
    const void *                 pNext  = {};
    AndroidSurfaceCreateFlagsKHR flags  = {};
    struct ANativeWindow *       window = {};
  };

  template <>
  struct CppType<StructureType, StructureType::eAndroidSurfaceCreateInfoKHR>
  {
    using Type = AndroidSurfaceCreateInfoKHR;
  };
#endif /*VK_USE_PLATFORM_ANDROID_KHR*/

  // wrapper struct for struct VkAntiLagPresentationInfoAMD, see https://registry.khronos.org/vulkan/specs/latest/man/html/VkAntiLagPresentationInfoAMD.html
  struct AntiLagPresentationInfoAMD
  {
    using NativeType = VkAntiLagPresentationInfoAMD;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eAntiLagPresentationInfoAMD;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR
      AntiLagPresentationInfoAMD( AntiLagStageAMD stage_ = AntiLagStageAMD::eInput, uint64_t frameIndex_ = {}, void * pNext_ = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , stage{ stage_ }
      , frameIndex{ frameIndex_ }
    {
    }

    VULKAN_HPP_CONSTEXPR AntiLagPresentationInfoAMD( AntiLagPresentationInfoAMD const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    AntiLagPresentationInfoAMD( VkAntiLagPresentationInfoAMD const & rhs ) VULKAN_HPP_NOEXCEPT
      : AntiLagPresentationInfoAMD( *reinterpret_cast<AntiLagPresentationInfoAMD const *>( &rhs ) )
    {
    }

    AntiLagPresentationInfoAMD & operator=( AntiLagPresentationInfoAMD const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    AntiLagPresentationInfoAMD & operator=( VkAntiLagPresentationInfoAMD const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<AntiLagPresentationInfoAMD const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 AntiLagPresentationInfoAMD & setPNext( void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AntiLagPresentationInfoAMD & setStage( AntiLagStageAMD stage_ ) VULKAN_HPP_NOEXCEPT
    {
      stage = stage_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AntiLagPresentationInfoAMD & setFrameIndex( uint64_t frameIndex_ ) VULKAN_HPP_NOEXCEPT
    {
      frameIndex = frameIndex_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_SETTERS*/

    operator VkAntiLagPresentationInfoAMD const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkAntiLagPresentationInfoAMD *>( this );
    }

    operator VkAntiLagPresentationInfoAMD &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkAntiLagPresentationInfoAMD *>( this );
    }

    operator VkAntiLagPresentationInfoAMD const *() const VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<const VkAntiLagPresentationInfoAMD *>( this );
    }

    operator VkAntiLagPresentationInfoAMD *() VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<VkAntiLagPresentationInfoAMD *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<StructureType const &, void * const &, AntiLagStageAMD const &, uint64_t const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, stage, frameIndex );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( AntiLagPresentationInfoAMD const & ) const = default;
#else
    bool operator==( AntiLagPresentationInfoAMD const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( stage == rhs.stage ) && ( frameIndex == rhs.frameIndex );
#  endif
    }

    bool operator!=( AntiLagPresentationInfoAMD const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    StructureType   sType      = StructureType::eAntiLagPresentationInfoAMD;
    void *          pNext      = {};
    AntiLagStageAMD stage      = AntiLagStageAMD::eInput;
    uint64_t        frameIndex = {};
  };

  template <>
  struct CppType<StructureType, StructureType::eAntiLagPresentationInfoAMD>
  {
    using Type = AntiLagPresentationInfoAMD;
  };

  // wrapper struct for struct VkAntiLagDataAMD, see https://registry.khronos.org/vulkan/specs/latest/man/html/VkAntiLagDataAMD.html
  struct AntiLagDataAMD
  {
    using NativeType = VkAntiLagDataAMD;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eAntiLagDataAMD;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR AntiLagDataAMD( AntiLagModeAMD                     mode_              = AntiLagModeAMD::eDriverControl,
                                         uint32_t                           maxFPS_            = {},
                                         const AntiLagPresentationInfoAMD * pPresentationInfo_ = {},
                                         const void *                       pNext_             = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , mode{ mode_ }
      , maxFPS{ maxFPS_ }
      , pPresentationInfo{ pPresentationInfo_ }
    {
    }

    VULKAN_HPP_CONSTEXPR AntiLagDataAMD( AntiLagDataAMD const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    AntiLagDataAMD( VkAntiLagDataAMD const & rhs ) VULKAN_HPP_NOEXCEPT : AntiLagDataAMD( *reinterpret_cast<AntiLagDataAMD const *>( &rhs ) ) {}

    AntiLagDataAMD & operator=( AntiLagDataAMD const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    AntiLagDataAMD & operator=( VkAntiLagDataAMD const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<AntiLagDataAMD const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 AntiLagDataAMD & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AntiLagDataAMD & setMode( AntiLagModeAMD mode_ ) VULKAN_HPP_NOEXCEPT
    {
      mode = mode_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AntiLagDataAMD & setMaxFPS( uint32_t maxFPS_ ) VULKAN_HPP_NOEXCEPT
    {
      maxFPS = maxFPS_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AntiLagDataAMD & setPPresentationInfo( const AntiLagPresentationInfoAMD * pPresentationInfo_ ) VULKAN_HPP_NOEXCEPT
    {
      pPresentationInfo = pPresentationInfo_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_SETTERS*/

    operator VkAntiLagDataAMD const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkAntiLagDataAMD *>( this );
    }

    operator VkAntiLagDataAMD &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkAntiLagDataAMD *>( this );
    }

    operator VkAntiLagDataAMD const *() const VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<const VkAntiLagDataAMD *>( this );
    }

    operator VkAntiLagDataAMD *() VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<VkAntiLagDataAMD *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<StructureType const &, const void * const &, AntiLagModeAMD const &, uint32_t const &, const AntiLagPresentationInfoAMD * const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, mode, maxFPS, pPresentationInfo );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( AntiLagDataAMD const & ) const = default;
#else
    bool operator==( AntiLagDataAMD const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( mode == rhs.mode ) && ( maxFPS == rhs.maxFPS ) &&
             ( pPresentationInfo == rhs.pPresentationInfo );
#  endif
    }

    bool operator!=( AntiLagDataAMD const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    StructureType                      sType             = StructureType::eAntiLagDataAMD;
    const void *                       pNext             = {};
    AntiLagModeAMD                     mode              = AntiLagModeAMD::eDriverControl;
    uint32_t                           maxFPS            = {};
    const AntiLagPresentationInfoAMD * pPresentationInfo = {};
  };

  template <>
  struct CppType<StructureType, StructureType::eAntiLagDataAMD>
  {
    using Type = AntiLagDataAMD;
  };

  // wrapper struct for struct VkApplicationInfo, see https://registry.khronos.org/vulkan/specs/latest/man/html/VkApplicationInfo.html
  struct ApplicationInfo
  {
    using NativeType = VkApplicationInfo;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eApplicationInfo;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR ApplicationInfo( const char * pApplicationName_   = {},
                                          uint32_t     applicationVersion_ = {},
                                          const char * pEngineName_        = {},
                                          uint32_t     engineVersion_      = {},
                                          uint32_t     apiVersion_         = {},
                                          const void * pNext_              = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , pApplicationName{ pApplicationName_ }
      , applicationVersion{ applicationVersion_ }
      , pEngineName{ pEngineName_ }
      , engineVersion{ engineVersion_ }
      , apiVersion{ apiVersion_ }
    {
    }

    VULKAN_HPP_CONSTEXPR ApplicationInfo( ApplicationInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    ApplicationInfo( VkApplicationInfo const & rhs ) VULKAN_HPP_NOEXCEPT : ApplicationInfo( *reinterpret_cast<ApplicationInfo const *>( &rhs ) ) {}

    ApplicationInfo & operator=( ApplicationInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    ApplicationInfo & operator=( VkApplicationInfo const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<ApplicationInfo const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 ApplicationInfo & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ApplicationInfo & setPApplicationName( const char * pApplicationName_ ) VULKAN_HPP_NOEXCEPT
    {
      pApplicationName = pApplicationName_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ApplicationInfo & setApplicationVersion( uint32_t applicationVersion_ ) VULKAN_HPP_NOEXCEPT
    {
      applicationVersion = applicationVersion_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ApplicationInfo & setPEngineName( const char * pEngineName_ ) VULKAN_HPP_NOEXCEPT
    {
      pEngineName = pEngineName_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ApplicationInfo & setEngineVersion( uint32_t engineVersion_ ) VULKAN_HPP_NOEXCEPT
    {
      engineVersion = engineVersion_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ApplicationInfo & setApiVersion( uint32_t apiVersion_ ) VULKAN_HPP_NOEXCEPT
    {
      apiVersion = apiVersion_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_SETTERS*/

    operator VkApplicationInfo const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkApplicationInfo *>( this );
    }

    operator VkApplicationInfo &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkApplicationInfo *>( this );
    }

    operator VkApplicationInfo const *() const VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<const VkApplicationInfo *>( this );
    }

    operator VkApplicationInfo *() VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<VkApplicationInfo *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<StructureType const &, const void * const &, const char * const &, uint32_t const &, const char * const &, uint32_t const &, uint32_t const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, pApplicationName, applicationVersion, pEngineName, engineVersion, apiVersion );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    std::strong_ordering operator<=>( ApplicationInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      if ( auto cmp = sType <=> rhs.sType; cmp != 0 )
        return cmp;
      if ( auto cmp = pNext <=> rhs.pNext; cmp != 0 )
        return cmp;
      if ( pApplicationName != rhs.pApplicationName )
        if ( auto cmp = strcmp( pApplicationName, rhs.pApplicationName ); cmp != 0 )
          return ( cmp < 0 ) ? std::strong_ordering::less : std::strong_ordering::greater;
      if ( auto cmp = applicationVersion <=> rhs.applicationVersion; cmp != 0 )
        return cmp;
      if ( pEngineName != rhs.pEngineName )
        if ( auto cmp = strcmp( pEngineName, rhs.pEngineName ); cmp != 0 )
          return ( cmp < 0 ) ? std::strong_ordering::less : std::strong_ordering::greater;
      if ( auto cmp = engineVersion <=> rhs.engineVersion; cmp != 0 )
        return cmp;
      if ( auto cmp = apiVersion <=> rhs.apiVersion; cmp != 0 )
        return cmp;

      return std::strong_ordering::equivalent;
    }
#endif

    bool operator==( ApplicationInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) &&
             ( ( pApplicationName == rhs.pApplicationName ) || ( strcmp( pApplicationName, rhs.pApplicationName ) == 0 ) ) &&
             ( applicationVersion == rhs.applicationVersion ) && ( ( pEngineName == rhs.pEngineName ) || ( strcmp( pEngineName, rhs.pEngineName ) == 0 ) ) &&
             ( engineVersion == rhs.engineVersion ) && ( apiVersion == rhs.apiVersion );
    }

    bool operator!=( ApplicationInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }

  public:
    StructureType sType              = StructureType::eApplicationInfo;
    const void *  pNext              = {};
    const char *  pApplicationName   = {};
    uint32_t      applicationVersion = {};
    const char *  pEngineName        = {};
    uint32_t      engineVersion      = {};
    uint32_t      apiVersion         = {};
  };

  template <>
  struct CppType<StructureType, StructureType::eApplicationInfo>
  {
    using Type = ApplicationInfo;
  };

  // wrapper struct for struct VkAttachmentDescription, see https://registry.khronos.org/vulkan/specs/latest/man/html/VkAttachmentDescription.html
  struct AttachmentDescription
  {
    using NativeType = VkAttachmentDescription;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR AttachmentDescription( AttachmentDescriptionFlags flags_          = {},
                                                Format                     format_         = Format::eUndefined,
                                                SampleCountFlagBits        samples_        = SampleCountFlagBits::e1,
                                                AttachmentLoadOp           loadOp_         = AttachmentLoadOp::eLoad,
                                                AttachmentStoreOp          storeOp_        = AttachmentStoreOp::eStore,
                                                AttachmentLoadOp           stencilLoadOp_  = AttachmentLoadOp::eLoad,
                                                AttachmentStoreOp          stencilStoreOp_ = AttachmentStoreOp::eStore,
                                                ImageLayout                initialLayout_  = ImageLayout::eUndefined,
                                                ImageLayout                finalLayout_    = ImageLayout::eUndefined ) VULKAN_HPP_NOEXCEPT
      : flags{ flags_ }
      , format{ format_ }
      , samples{ samples_ }
      , loadOp{ loadOp_ }
      , storeOp{ storeOp_ }
      , stencilLoadOp{ stencilLoadOp_ }
      , stencilStoreOp{ stencilStoreOp_ }
      , initialLayout{ initialLayout_ }
      , finalLayout{ finalLayout_ }
    {
    }

    VULKAN_HPP_CONSTEXPR AttachmentDescription( AttachmentDescription const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    AttachmentDescription( VkAttachmentDescription const & rhs ) VULKAN_HPP_NOEXCEPT
      : AttachmentDescription( *reinterpret_cast<AttachmentDescription const *>( &rhs ) )
    {
    }

    AttachmentDescription & operator=( AttachmentDescription const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    AttachmentDescription & operator=( VkAttachmentDescription const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<AttachmentDescription const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 AttachmentDescription & setFlags( AttachmentDescriptionFlags flags_ ) VULKAN_HPP_NOEXCEPT
    {
      flags = flags_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AttachmentDescription & setFormat( Format format_ ) VULKAN_HPP_NOEXCEPT
    {
      format = format_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AttachmentDescription & setSamples( SampleCountFlagBits samples_ ) VULKAN_HPP_NOEXCEPT
    {
      samples = samples_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AttachmentDescription & setLoadOp( AttachmentLoadOp loadOp_ ) VULKAN_HPP_NOEXCEPT
    {
      loadOp = loadOp_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AttachmentDescription & setStoreOp( AttachmentStoreOp storeOp_ ) VULKAN_HPP_NOEXCEPT
    {
      storeOp = storeOp_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AttachmentDescription & setStencilLoadOp( AttachmentLoadOp stencilLoadOp_ ) VULKAN_HPP_NOEXCEPT
    {
      stencilLoadOp = stencilLoadOp_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AttachmentDescription & setStencilStoreOp( AttachmentStoreOp stencilStoreOp_ ) VULKAN_HPP_NOEXCEPT
    {
      stencilStoreOp = stencilStoreOp_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AttachmentDescription & setInitialLayout( ImageLayout initialLayout_ ) VULKAN_HPP_NOEXCEPT
    {
      initialLayout = initialLayout_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AttachmentDescription & setFinalLayout( ImageLayout finalLayout_ ) VULKAN_HPP_NOEXCEPT
    {
      finalLayout = finalLayout_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_SETTERS*/

    operator VkAttachmentDescription const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkAttachmentDescription *>( this );
    }

    operator VkAttachmentDescription &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkAttachmentDescription *>( this );
    }

    operator VkAttachmentDescription const *() const VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<const VkAttachmentDescription *>( this );
    }

    operator VkAttachmentDescription *() VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<VkAttachmentDescription *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<AttachmentDescriptionFlags const &,
               Format const &,
               SampleCountFlagBits const &,
               AttachmentLoadOp const &,
               AttachmentStoreOp const &,
               AttachmentLoadOp const &,
               AttachmentStoreOp const &,
               ImageLayout const &,
               ImageLayout const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( flags, format, samples, loadOp, storeOp, stencilLoadOp, stencilStoreOp, initialLayout, finalLayout );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( AttachmentDescription const & ) const = default;
#else
    bool operator==( AttachmentDescription const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( flags == rhs.flags ) && ( format == rhs.format ) && ( samples == rhs.samples ) && ( loadOp == rhs.loadOp ) && ( storeOp == rhs.storeOp ) &&
             ( stencilLoadOp == rhs.stencilLoadOp ) && ( stencilStoreOp == rhs.stencilStoreOp ) && ( initialLayout == rhs.initialLayout ) &&
             ( finalLayout == rhs.finalLayout );
#  endif
    }

    bool operator!=( AttachmentDescription const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    AttachmentDescriptionFlags flags          = {};
    Format                     format         = Format::eUndefined;
    SampleCountFlagBits        samples        = SampleCountFlagBits::e1;
    AttachmentLoadOp           loadOp         = AttachmentLoadOp::eLoad;
    AttachmentStoreOp          storeOp        = AttachmentStoreOp::eStore;
    AttachmentLoadOp           stencilLoadOp  = AttachmentLoadOp::eLoad;
    AttachmentStoreOp          stencilStoreOp = AttachmentStoreOp::eStore;
    ImageLayout                initialLayout  = ImageLayout::eUndefined;
    ImageLayout                finalLayout    = ImageLayout::eUndefined;
  };

  // wrapper struct for struct VkAttachmentDescription2, see https://registry.khronos.org/vulkan/specs/latest/man/html/VkAttachmentDescription2.html
  struct AttachmentDescription2
  {
    using NativeType = VkAttachmentDescription2;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eAttachmentDescription2;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR AttachmentDescription2( AttachmentDescriptionFlags flags_          = {},
                                                 Format                     format_         = Format::eUndefined,
                                                 SampleCountFlagBits        samples_        = SampleCountFlagBits::e1,
                                                 AttachmentLoadOp           loadOp_         = AttachmentLoadOp::eLoad,
                                                 AttachmentStoreOp          storeOp_        = AttachmentStoreOp::eStore,
                                                 AttachmentLoadOp           stencilLoadOp_  = AttachmentLoadOp::eLoad,
                                                 AttachmentStoreOp          stencilStoreOp_ = AttachmentStoreOp::eStore,
                                                 ImageLayout                initialLayout_  = ImageLayout::eUndefined,
                                                 ImageLayout                finalLayout_    = ImageLayout::eUndefined,
                                                 const void *               pNext_          = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , flags{ flags_ }
      , format{ format_ }
      , samples{ samples_ }
      , loadOp{ loadOp_ }
      , storeOp{ storeOp_ }
      , stencilLoadOp{ stencilLoadOp_ }
      , stencilStoreOp{ stencilStoreOp_ }
      , initialLayout{ initialLayout_ }
      , finalLayout{ finalLayout_ }
    {
    }

    VULKAN_HPP_CONSTEXPR AttachmentDescription2( AttachmentDescription2 const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    AttachmentDescription2( VkAttachmentDescription2 const & rhs ) VULKAN_HPP_NOEXCEPT
      : AttachmentDescription2( *reinterpret_cast<AttachmentDescription2 const *>( &rhs ) )
    {
    }

    AttachmentDescription2 & operator=( AttachmentDescription2 const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    AttachmentDescription2 & operator=( VkAttachmentDescription2 const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<AttachmentDescription2 const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 AttachmentDescription2 & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AttachmentDescription2 & setFlags( AttachmentDescriptionFlags flags_ ) VULKAN_HPP_NOEXCEPT
    {
      flags = flags_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AttachmentDescription2 & setFormat( Format format_ ) VULKAN_HPP_NOEXCEPT
    {
      format = format_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AttachmentDescription2 & setSamples( SampleCountFlagBits samples_ ) VULKAN_HPP_NOEXCEPT
    {
      samples = samples_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AttachmentDescription2 & setLoadOp( AttachmentLoadOp loadOp_ ) VULKAN_HPP_NOEXCEPT
    {
      loadOp = loadOp_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AttachmentDescription2 & setStoreOp( AttachmentStoreOp storeOp_ ) VULKAN_HPP_NOEXCEPT
    {
      storeOp = storeOp_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AttachmentDescription2 & setStencilLoadOp( AttachmentLoadOp stencilLoadOp_ ) VULKAN_HPP_NOEXCEPT
    {
      stencilLoadOp = stencilLoadOp_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AttachmentDescription2 & setStencilStoreOp( AttachmentStoreOp stencilStoreOp_ ) VULKAN_HPP_NOEXCEPT
    {
      stencilStoreOp = stencilStoreOp_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AttachmentDescription2 & setInitialLayout( ImageLayout initialLayout_ ) VULKAN_HPP_NOEXCEPT
    {
      initialLayout = initialLayout_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AttachmentDescription2 & setFinalLayout( ImageLayout finalLayout_ ) VULKAN_HPP_NOEXCEPT
    {
      finalLayout = finalLayout_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_SETTERS*/

    operator VkAttachmentDescription2 const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkAttachmentDescription2 *>( this );
    }

    operator VkAttachmentDescription2 &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkAttachmentDescription2 *>( this );
    }

    operator VkAttachmentDescription2 const *() const VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<const VkAttachmentDescription2 *>( this );
    }

    operator VkAttachmentDescription2 *() VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<VkAttachmentDescription2 *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<StructureType const &,
               const void * const &,
               AttachmentDescriptionFlags const &,
               Format const &,
               SampleCountFlagBits const &,
               AttachmentLoadOp const &,
               AttachmentStoreOp const &,
               AttachmentLoadOp const &,
               AttachmentStoreOp const &,
               ImageLayout const &,
               ImageLayout const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, flags, format, samples, loadOp, storeOp, stencilLoadOp, stencilStoreOp, initialLayout, finalLayout );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( AttachmentDescription2 const & ) const = default;
#else
    bool operator==( AttachmentDescription2 const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( flags == rhs.flags ) && ( format == rhs.format ) && ( samples == rhs.samples ) &&
             ( loadOp == rhs.loadOp ) && ( storeOp == rhs.storeOp ) && ( stencilLoadOp == rhs.stencilLoadOp ) && ( stencilStoreOp == rhs.stencilStoreOp ) &&
             ( initialLayout == rhs.initialLayout ) && ( finalLayout == rhs.finalLayout );
#  endif
    }

    bool operator!=( AttachmentDescription2 const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    StructureType              sType          = StructureType::eAttachmentDescription2;
    const void *               pNext          = {};
    AttachmentDescriptionFlags flags          = {};
    Format                     format         = Format::eUndefined;
    SampleCountFlagBits        samples        = SampleCountFlagBits::e1;
    AttachmentLoadOp           loadOp         = AttachmentLoadOp::eLoad;
    AttachmentStoreOp          storeOp        = AttachmentStoreOp::eStore;
    AttachmentLoadOp           stencilLoadOp  = AttachmentLoadOp::eLoad;
    AttachmentStoreOp          stencilStoreOp = AttachmentStoreOp::eStore;
    ImageLayout                initialLayout  = ImageLayout::eUndefined;
    ImageLayout                finalLayout    = ImageLayout::eUndefined;
  };

  template <>
  struct CppType<StructureType, StructureType::eAttachmentDescription2>
  {
    using Type = AttachmentDescription2;
  };

  using AttachmentDescription2KHR = AttachmentDescription2;

  // wrapper struct for struct VkAttachmentDescriptionStencilLayout, see
  // https://registry.khronos.org/vulkan/specs/latest/man/html/VkAttachmentDescriptionStencilLayout.html
  struct AttachmentDescriptionStencilLayout
  {
    using NativeType = VkAttachmentDescriptionStencilLayout;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eAttachmentDescriptionStencilLayout;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR AttachmentDescriptionStencilLayout( ImageLayout stencilInitialLayout_ = ImageLayout::eUndefined,
                                                             ImageLayout stencilFinalLayout_   = ImageLayout::eUndefined,
                                                             void *      pNext_                = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , stencilInitialLayout{ stencilInitialLayout_ }
      , stencilFinalLayout{ stencilFinalLayout_ }
    {
    }

    VULKAN_HPP_CONSTEXPR AttachmentDescriptionStencilLayout( AttachmentDescriptionStencilLayout const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    AttachmentDescriptionStencilLayout( VkAttachmentDescriptionStencilLayout const & rhs ) VULKAN_HPP_NOEXCEPT
      : AttachmentDescriptionStencilLayout( *reinterpret_cast<AttachmentDescriptionStencilLayout const *>( &rhs ) )
    {
    }

    AttachmentDescriptionStencilLayout & operator=( AttachmentDescriptionStencilLayout const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    AttachmentDescriptionStencilLayout & operator=( VkAttachmentDescriptionStencilLayout const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<AttachmentDescriptionStencilLayout const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 AttachmentDescriptionStencilLayout & setPNext( void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AttachmentDescriptionStencilLayout & setStencilInitialLayout( ImageLayout stencilInitialLayout_ ) VULKAN_HPP_NOEXCEPT
    {
      stencilInitialLayout = stencilInitialLayout_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AttachmentDescriptionStencilLayout & setStencilFinalLayout( ImageLayout stencilFinalLayout_ ) VULKAN_HPP_NOEXCEPT
    {
      stencilFinalLayout = stencilFinalLayout_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_SETTERS*/

    operator VkAttachmentDescriptionStencilLayout const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkAttachmentDescriptionStencilLayout *>( this );
    }

    operator VkAttachmentDescriptionStencilLayout &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkAttachmentDescriptionStencilLayout *>( this );
    }

    operator VkAttachmentDescriptionStencilLayout const *() const VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<const VkAttachmentDescriptionStencilLayout *>( this );
    }

    operator VkAttachmentDescriptionStencilLayout *() VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<VkAttachmentDescriptionStencilLayout *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<StructureType const &, void * const &, ImageLayout const &, ImageLayout const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, stencilInitialLayout, stencilFinalLayout );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( AttachmentDescriptionStencilLayout const & ) const = default;
#else
    bool operator==( AttachmentDescriptionStencilLayout const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( stencilInitialLayout == rhs.stencilInitialLayout ) &&
             ( stencilFinalLayout == rhs.stencilFinalLayout );
#  endif
    }

    bool operator!=( AttachmentDescriptionStencilLayout const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    StructureType sType                = StructureType::eAttachmentDescriptionStencilLayout;
    void *        pNext                = {};
    ImageLayout   stencilInitialLayout = ImageLayout::eUndefined;
    ImageLayout   stencilFinalLayout   = ImageLayout::eUndefined;
  };

  template <>
  struct CppType<StructureType, StructureType::eAttachmentDescriptionStencilLayout>
  {
    using Type = AttachmentDescriptionStencilLayout;
  };

  using AttachmentDescriptionStencilLayoutKHR = AttachmentDescriptionStencilLayout;

  // wrapper struct for struct VkAttachmentFeedbackLoopInfoEXT, see
  // https://registry.khronos.org/vulkan/specs/latest/man/html/VkAttachmentFeedbackLoopInfoEXT.html
  struct AttachmentFeedbackLoopInfoEXT
  {
    using NativeType = VkAttachmentFeedbackLoopInfoEXT;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eAttachmentFeedbackLoopInfoEXT;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR AttachmentFeedbackLoopInfoEXT( Bool32 feedbackLoopEnable_ = {}, const void * pNext_ = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , feedbackLoopEnable{ feedbackLoopEnable_ }
    {
    }

    VULKAN_HPP_CONSTEXPR AttachmentFeedbackLoopInfoEXT( AttachmentFeedbackLoopInfoEXT const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    AttachmentFeedbackLoopInfoEXT( VkAttachmentFeedbackLoopInfoEXT const & rhs ) VULKAN_HPP_NOEXCEPT
      : AttachmentFeedbackLoopInfoEXT( *reinterpret_cast<AttachmentFeedbackLoopInfoEXT const *>( &rhs ) )
    {
    }

    AttachmentFeedbackLoopInfoEXT & operator=( AttachmentFeedbackLoopInfoEXT const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    AttachmentFeedbackLoopInfoEXT & operator=( VkAttachmentFeedbackLoopInfoEXT const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<AttachmentFeedbackLoopInfoEXT const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 AttachmentFeedbackLoopInfoEXT & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AttachmentFeedbackLoopInfoEXT & setFeedbackLoopEnable( Bool32 feedbackLoopEnable_ ) VULKAN_HPP_NOEXCEPT
    {
      feedbackLoopEnable = feedbackLoopEnable_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_SETTERS*/

    operator VkAttachmentFeedbackLoopInfoEXT const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkAttachmentFeedbackLoopInfoEXT *>( this );
    }

    operator VkAttachmentFeedbackLoopInfoEXT &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkAttachmentFeedbackLoopInfoEXT *>( this );
    }

    operator VkAttachmentFeedbackLoopInfoEXT const *() const VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<const VkAttachmentFeedbackLoopInfoEXT *>( this );
    }

    operator VkAttachmentFeedbackLoopInfoEXT *() VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<VkAttachmentFeedbackLoopInfoEXT *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<StructureType const &, const void * const &, Bool32 const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, feedbackLoopEnable );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( AttachmentFeedbackLoopInfoEXT const & ) const = default;
#else
    bool operator==( AttachmentFeedbackLoopInfoEXT const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( feedbackLoopEnable == rhs.feedbackLoopEnable );
#  endif
    }

    bool operator!=( AttachmentFeedbackLoopInfoEXT const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    StructureType sType              = StructureType::eAttachmentFeedbackLoopInfoEXT;
    const void *  pNext              = {};
    Bool32        feedbackLoopEnable = {};
  };

  template <>
  struct CppType<StructureType, StructureType::eAttachmentFeedbackLoopInfoEXT>
  {
    using Type = AttachmentFeedbackLoopInfoEXT;
  };

  // wrapper struct for struct VkAttachmentReference, see https://registry.khronos.org/vulkan/specs/latest/man/html/VkAttachmentReference.html
  struct AttachmentReference
  {
    using NativeType = VkAttachmentReference;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR AttachmentReference( uint32_t attachment_ = {}, ImageLayout layout_ = ImageLayout::eUndefined ) VULKAN_HPP_NOEXCEPT
      : attachment{ attachment_ }
      , layout{ layout_ }
    {
    }

    VULKAN_HPP_CONSTEXPR AttachmentReference( AttachmentReference const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    AttachmentReference( VkAttachmentReference const & rhs ) VULKAN_HPP_NOEXCEPT : AttachmentReference( *reinterpret_cast<AttachmentReference const *>( &rhs ) )
    {
    }

    AttachmentReference & operator=( AttachmentReference const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    AttachmentReference & operator=( VkAttachmentReference const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<AttachmentReference const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 AttachmentReference & setAttachment( uint32_t attachment_ ) VULKAN_HPP_NOEXCEPT
    {
      attachment = attachment_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AttachmentReference & setLayout( ImageLayout layout_ ) VULKAN_HPP_NOEXCEPT
    {
      layout = layout_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_SETTERS*/

    operator VkAttachmentReference const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkAttachmentReference *>( this );
    }

    operator VkAttachmentReference &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkAttachmentReference *>( this );
    }

    operator VkAttachmentReference const *() const VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<const VkAttachmentReference *>( this );
    }

    operator VkAttachmentReference *() VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<VkAttachmentReference *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<uint32_t const &, ImageLayout const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( attachment, layout );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( AttachmentReference const & ) const = default;
#else
    bool operator==( AttachmentReference const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( attachment == rhs.attachment ) && ( layout == rhs.layout );
#  endif
    }

    bool operator!=( AttachmentReference const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    uint32_t    attachment = {};
    ImageLayout layout     = ImageLayout::eUndefined;
  };

  // wrapper struct for struct VkAttachmentReference2, see https://registry.khronos.org/vulkan/specs/latest/man/html/VkAttachmentReference2.html
  struct AttachmentReference2
  {
    using NativeType = VkAttachmentReference2;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eAttachmentReference2;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR AttachmentReference2( uint32_t         attachment_ = {},
                                               ImageLayout      layout_     = ImageLayout::eUndefined,
                                               ImageAspectFlags aspectMask_ = {},
                                               const void *     pNext_      = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , attachment{ attachment_ }
      , layout{ layout_ }
      , aspectMask{ aspectMask_ }
    {
    }

    VULKAN_HPP_CONSTEXPR AttachmentReference2( AttachmentReference2 const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    AttachmentReference2( VkAttachmentReference2 const & rhs ) VULKAN_HPP_NOEXCEPT
      : AttachmentReference2( *reinterpret_cast<AttachmentReference2 const *>( &rhs ) )
    {
    }

    AttachmentReference2 & operator=( AttachmentReference2 const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    AttachmentReference2 & operator=( VkAttachmentReference2 const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<AttachmentReference2 const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 AttachmentReference2 & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AttachmentReference2 & setAttachment( uint32_t attachment_ ) VULKAN_HPP_NOEXCEPT
    {
      attachment = attachment_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AttachmentReference2 & setLayout( ImageLayout layout_ ) VULKAN_HPP_NOEXCEPT
    {
      layout = layout_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AttachmentReference2 & setAspectMask( ImageAspectFlags aspectMask_ ) VULKAN_HPP_NOEXCEPT
    {
      aspectMask = aspectMask_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_SETTERS*/

    operator VkAttachmentReference2 const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkAttachmentReference2 *>( this );
    }

    operator VkAttachmentReference2 &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkAttachmentReference2 *>( this );
    }

    operator VkAttachmentReference2 const *() const VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<const VkAttachmentReference2 *>( this );
    }

    operator VkAttachmentReference2 *() VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<VkAttachmentReference2 *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<StructureType const &, const void * const &, uint32_t const &, ImageLayout const &, ImageAspectFlags const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, attachment, layout, aspectMask );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( AttachmentReference2 const & ) const = default;
#else
    bool operator==( AttachmentReference2 const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( attachment == rhs.attachment ) && ( layout == rhs.layout ) &&
             ( aspectMask == rhs.aspectMask );
#  endif
    }

    bool operator!=( AttachmentReference2 const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    StructureType    sType      = StructureType::eAttachmentReference2;
    const void *     pNext      = {};
    uint32_t         attachment = {};
    ImageLayout      layout     = ImageLayout::eUndefined;
    ImageAspectFlags aspectMask = {};
  };

  template <>
  struct CppType<StructureType, StructureType::eAttachmentReference2>
  {
    using Type = AttachmentReference2;
  };

  using AttachmentReference2KHR = AttachmentReference2;

  // wrapper struct for struct VkAttachmentReferenceStencilLayout, see
  // https://registry.khronos.org/vulkan/specs/latest/man/html/VkAttachmentReferenceStencilLayout.html
  struct AttachmentReferenceStencilLayout
  {
    using NativeType = VkAttachmentReferenceStencilLayout;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eAttachmentReferenceStencilLayout;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR AttachmentReferenceStencilLayout( ImageLayout stencilLayout_ = ImageLayout::eUndefined, void * pNext_ = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , stencilLayout{ stencilLayout_ }
    {
    }

    VULKAN_HPP_CONSTEXPR AttachmentReferenceStencilLayout( AttachmentReferenceStencilLayout const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    AttachmentReferenceStencilLayout( VkAttachmentReferenceStencilLayout const & rhs ) VULKAN_HPP_NOEXCEPT
      : AttachmentReferenceStencilLayout( *reinterpret_cast<AttachmentReferenceStencilLayout const *>( &rhs ) )
    {
    }

    AttachmentReferenceStencilLayout & operator=( AttachmentReferenceStencilLayout const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    AttachmentReferenceStencilLayout & operator=( VkAttachmentReferenceStencilLayout const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<AttachmentReferenceStencilLayout const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 AttachmentReferenceStencilLayout & setPNext( void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AttachmentReferenceStencilLayout & setStencilLayout( ImageLayout stencilLayout_ ) VULKAN_HPP_NOEXCEPT
    {
      stencilLayout = stencilLayout_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_SETTERS*/

    operator VkAttachmentReferenceStencilLayout const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkAttachmentReferenceStencilLayout *>( this );
    }

    operator VkAttachmentReferenceStencilLayout &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkAttachmentReferenceStencilLayout *>( this );
    }

    operator VkAttachmentReferenceStencilLayout const *() const VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<const VkAttachmentReferenceStencilLayout *>( this );
    }

    operator VkAttachmentReferenceStencilLayout *() VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<VkAttachmentReferenceStencilLayout *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<StructureType const &, void * const &, ImageLayout const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, stencilLayout );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( AttachmentReferenceStencilLayout const & ) const = default;
#else
    bool operator==( AttachmentReferenceStencilLayout const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( stencilLayout == rhs.stencilLayout );
#  endif
    }

    bool operator!=( AttachmentReferenceStencilLayout const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    StructureType sType         = StructureType::eAttachmentReferenceStencilLayout;
    void *        pNext         = {};
    ImageLayout   stencilLayout = ImageLayout::eUndefined;
  };

  template <>
  struct CppType<StructureType, StructureType::eAttachmentReferenceStencilLayout>
  {
    using Type = AttachmentReferenceStencilLayout;
  };

  using AttachmentReferenceStencilLayoutKHR = AttachmentReferenceStencilLayout;

  // wrapper struct for struct VkAttachmentSampleCountInfoAMD, see https://registry.khronos.org/vulkan/specs/latest/man/html/VkAttachmentSampleCountInfoAMD.html
  struct AttachmentSampleCountInfoAMD
  {
    using NativeType = VkAttachmentSampleCountInfoAMD;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eAttachmentSampleCountInfoAMD;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR AttachmentSampleCountInfoAMD( uint32_t                    colorAttachmentCount_          = {},
                                                       const SampleCountFlagBits * pColorAttachmentSamples_       = {},
                                                       SampleCountFlagBits         depthStencilAttachmentSamples_ = SampleCountFlagBits::e1,
                                                       const void *                pNext_                         = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , colorAttachmentCount{ colorAttachmentCount_ }
      , pColorAttachmentSamples{ pColorAttachmentSamples_ }
      , depthStencilAttachmentSamples{ depthStencilAttachmentSamples_ }
    {
    }

    VULKAN_HPP_CONSTEXPR AttachmentSampleCountInfoAMD( AttachmentSampleCountInfoAMD const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    AttachmentSampleCountInfoAMD( VkAttachmentSampleCountInfoAMD const & rhs ) VULKAN_HPP_NOEXCEPT
      : AttachmentSampleCountInfoAMD( *reinterpret_cast<AttachmentSampleCountInfoAMD const *>( &rhs ) )
    {
    }

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    AttachmentSampleCountInfoAMD( ArrayProxyNoTemporaries<const SampleCountFlagBits> const & colorAttachmentSamples_,
                                  SampleCountFlagBits                                        depthStencilAttachmentSamples_ = SampleCountFlagBits::e1,
                                  const void *                                               pNext_                         = nullptr )
      : pNext( pNext_ )
      , colorAttachmentCount( static_cast<uint32_t>( colorAttachmentSamples_.size() ) )
      , pColorAttachmentSamples( colorAttachmentSamples_.data() )
      , depthStencilAttachmentSamples( depthStencilAttachmentSamples_ )
    {
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/

    AttachmentSampleCountInfoAMD & operator=( AttachmentSampleCountInfoAMD const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    AttachmentSampleCountInfoAMD & operator=( VkAttachmentSampleCountInfoAMD const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<AttachmentSampleCountInfoAMD const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 AttachmentSampleCountInfoAMD & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AttachmentSampleCountInfoAMD & setColorAttachmentCount( uint32_t colorAttachmentCount_ ) VULKAN_HPP_NOEXCEPT
    {
      colorAttachmentCount = colorAttachmentCount_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AttachmentSampleCountInfoAMD &
      setPColorAttachmentSamples( const SampleCountFlagBits * pColorAttachmentSamples_ ) VULKAN_HPP_NOEXCEPT
    {
      pColorAttachmentSamples = pColorAttachmentSamples_;
      return *this;
    }

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    AttachmentSampleCountInfoAMD &
      setColorAttachmentSamples( ArrayProxyNoTemporaries<const SampleCountFlagBits> const & colorAttachmentSamples_ ) VULKAN_HPP_NOEXCEPT
    {
      colorAttachmentCount    = static_cast<uint32_t>( colorAttachmentSamples_.size() );
      pColorAttachmentSamples = colorAttachmentSamples_.data();
      return *this;
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/

    VULKAN_HPP_CONSTEXPR_14 AttachmentSampleCountInfoAMD &
      setDepthStencilAttachmentSamples( SampleCountFlagBits depthStencilAttachmentSamples_ ) VULKAN_HPP_NOEXCEPT
    {
      depthStencilAttachmentSamples = depthStencilAttachmentSamples_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_SETTERS*/

    operator VkAttachmentSampleCountInfoAMD const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkAttachmentSampleCountInfoAMD *>( this );
    }

    operator VkAttachmentSampleCountInfoAMD &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkAttachmentSampleCountInfoAMD *>( this );
    }

    operator VkAttachmentSampleCountInfoAMD const *() const VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<const VkAttachmentSampleCountInfoAMD *>( this );
    }

    operator VkAttachmentSampleCountInfoAMD *() VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<VkAttachmentSampleCountInfoAMD *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<StructureType const &, const void * const &, uint32_t const &, const SampleCountFlagBits * const &, SampleCountFlagBits const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, colorAttachmentCount, pColorAttachmentSamples, depthStencilAttachmentSamples );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( AttachmentSampleCountInfoAMD const & ) const = default;
#else
    bool operator==( AttachmentSampleCountInfoAMD const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( colorAttachmentCount == rhs.colorAttachmentCount ) &&
             ( pColorAttachmentSamples == rhs.pColorAttachmentSamples ) && ( depthStencilAttachmentSamples == rhs.depthStencilAttachmentSamples );
#  endif
    }

    bool operator!=( AttachmentSampleCountInfoAMD const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    StructureType               sType                         = StructureType::eAttachmentSampleCountInfoAMD;
    const void *                pNext                         = {};
    uint32_t                    colorAttachmentCount          = {};
    const SampleCountFlagBits * pColorAttachmentSamples       = {};
    SampleCountFlagBits         depthStencilAttachmentSamples = SampleCountFlagBits::e1;
  };

  template <>
  struct CppType<StructureType, StructureType::eAttachmentSampleCountInfoAMD>
  {
    using Type = AttachmentSampleCountInfoAMD;
  };

  using AttachmentSampleCountInfoNV = AttachmentSampleCountInfoAMD;

  // wrapper struct for struct VkExtent2D, see https://registry.khronos.org/vulkan/specs/latest/man/html/VkExtent2D.html
  struct Extent2D
  {
    using NativeType = VkExtent2D;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR Extent2D( uint32_t width_ = {}, uint32_t height_ = {} ) VULKAN_HPP_NOEXCEPT
      : width{ width_ }
      , height{ height_ }
    {
    }

    VULKAN_HPP_CONSTEXPR Extent2D( Extent2D const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    Extent2D( VkExtent2D const & rhs ) VULKAN_HPP_NOEXCEPT : Extent2D( *reinterpret_cast<Extent2D const *>( &rhs ) ) {}

    Extent2D & operator=( Extent2D const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    Extent2D & operator=( VkExtent2D const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<Extent2D const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 Extent2D & setWidth( uint32_t width_ ) VULKAN_HPP_NOEXCEPT
    {
      width = width_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 Extent2D & setHeight( uint32_t height_ ) VULKAN_HPP_NOEXCEPT
    {
      height = height_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_SETTERS*/

    operator VkExtent2D const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkExtent2D *>( this );
    }

    operator VkExtent2D &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkExtent2D *>( this );
    }

    operator VkExtent2D const *() const VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<const VkExtent2D *>( this );
    }

    operator VkExtent2D *() VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<VkExtent2D *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<uint32_t const &, uint32_t const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( width, height );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( Extent2D const & ) const = default;
#else
    bool operator==( Extent2D const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( width == rhs.width ) && ( height == rhs.height );
#  endif
    }

    bool operator!=( Extent2D const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    uint32_t width  = {};
    uint32_t height = {};
  };

  // wrapper struct for struct VkSampleLocationEXT, see https://registry.khronos.org/vulkan/specs/latest/man/html/VkSampleLocationEXT.html
  struct SampleLocationEXT
  {
    using NativeType = VkSampleLocationEXT;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR SampleLocationEXT( float x_ = {}, float y_ = {} ) VULKAN_HPP_NOEXCEPT
      : x{ x_ }
      , y{ y_ }
    {
    }

    VULKAN_HPP_CONSTEXPR SampleLocationEXT( SampleLocationEXT const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    SampleLocationEXT( VkSampleLocationEXT const & rhs ) VULKAN_HPP_NOEXCEPT : SampleLocationEXT( *reinterpret_cast<SampleLocationEXT const *>( &rhs ) ) {}

    SampleLocationEXT & operator=( SampleLocationEXT const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    SampleLocationEXT & operator=( VkSampleLocationEXT const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<SampleLocationEXT const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 SampleLocationEXT & setX( float x_ ) VULKAN_HPP_NOEXCEPT
    {
      x = x_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 SampleLocationEXT & setY( float y_ ) VULKAN_HPP_NOEXCEPT
    {
      y = y_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_SETTERS*/

    operator VkSampleLocationEXT const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkSampleLocationEXT *>( this );
    }

    operator VkSampleLocationEXT &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkSampleLocationEXT *>( this );
    }

    operator VkSampleLocationEXT const *() const VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<const VkSampleLocationEXT *>( this );
    }

    operator VkSampleLocationEXT *() VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<VkSampleLocationEXT *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<float const &, float const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( x, y );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( SampleLocationEXT const & ) const = default;
#else
    bool operator==( SampleLocationEXT const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( x == rhs.x ) && ( y == rhs.y );
#  endif
    }

    bool operator!=( SampleLocationEXT const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    float x = {};
    float y = {};
  };

  // wrapper struct for struct VkSampleLocationsInfoEXT, see https://registry.khronos.org/vulkan/specs/latest/man/html/VkSampleLocationsInfoEXT.html
  struct SampleLocationsInfoEXT
  {
    using NativeType = VkSampleLocationsInfoEXT;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eSampleLocationsInfoEXT;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR SampleLocationsInfoEXT( SampleCountFlagBits       sampleLocationsPerPixel_ = SampleCountFlagBits::e1,
                                                 Extent2D                  sampleLocationGridSize_  = {},
                                                 uint32_t                  sampleLocationsCount_    = {},
                                                 const SampleLocationEXT * pSampleLocations_        = {},
                                                 const void *              pNext_                   = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , sampleLocationsPerPixel{ sampleLocationsPerPixel_ }
      , sampleLocationGridSize{ sampleLocationGridSize_ }
      , sampleLocationsCount{ sampleLocationsCount_ }
      , pSampleLocations{ pSampleLocations_ }
    {
    }

    VULKAN_HPP_CONSTEXPR SampleLocationsInfoEXT( SampleLocationsInfoEXT const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    SampleLocationsInfoEXT( VkSampleLocationsInfoEXT const & rhs ) VULKAN_HPP_NOEXCEPT
      : SampleLocationsInfoEXT( *reinterpret_cast<SampleLocationsInfoEXT const *>( &rhs ) )
    {
    }

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    SampleLocationsInfoEXT( SampleCountFlagBits                                      sampleLocationsPerPixel_,
                            Extent2D                                                 sampleLocationGridSize_,
                            ArrayProxyNoTemporaries<const SampleLocationEXT> const & sampleLocations_,
                            const void *                                             pNext_ = nullptr )
      : pNext( pNext_ )
      , sampleLocationsPerPixel( sampleLocationsPerPixel_ )
      , sampleLocationGridSize( sampleLocationGridSize_ )
      , sampleLocationsCount( static_cast<uint32_t>( sampleLocations_.size() ) )
      , pSampleLocations( sampleLocations_.data() )
    {
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/

    SampleLocationsInfoEXT & operator=( SampleLocationsInfoEXT const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    SampleLocationsInfoEXT & operator=( VkSampleLocationsInfoEXT const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<SampleLocationsInfoEXT const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 SampleLocationsInfoEXT & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 SampleLocationsInfoEXT & setSampleLocationsPerPixel( SampleCountFlagBits sampleLocationsPerPixel_ ) VULKAN_HPP_NOEXCEPT
    {
      sampleLocationsPerPixel = sampleLocationsPerPixel_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 SampleLocationsInfoEXT & setSampleLocationGridSize( Extent2D const & sampleLocationGridSize_ ) VULKAN_HPP_NOEXCEPT
    {
      sampleLocationGridSize = sampleLocationGridSize_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 SampleLocationsInfoEXT & setSampleLocationsCount( uint32_t sampleLocationsCount_ ) VULKAN_HPP_NOEXCEPT
    {
      sampleLocationsCount = sampleLocationsCount_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 SampleLocationsInfoEXT & setPSampleLocations( const SampleLocationEXT * pSampleLocations_ ) VULKAN_HPP_NOEXCEPT
    {
      pSampleLocations = pSampleLocations_;
      return *this;
    }

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    SampleLocationsInfoEXT & setSampleLocations( ArrayProxyNoTemporaries<const SampleLocationEXT> const & sampleLocations_ ) VULKAN_HPP_NOEXCEPT
    {
      sampleLocationsCount = static_cast<uint32_t>( sampleLocations_.size() );
      pSampleLocations     = sampleLocations_.data();
      return *this;
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/
#endif   /*VULKAN_HPP_NO_SETTERS*/

    operator VkSampleLocationsInfoEXT const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkSampleLocationsInfoEXT *>( this );
    }

    operator VkSampleLocationsInfoEXT &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkSampleLocationsInfoEXT *>( this );
    }

    operator VkSampleLocationsInfoEXT const *() const VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<const VkSampleLocationsInfoEXT *>( this );
    }

    operator VkSampleLocationsInfoEXT *() VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<VkSampleLocationsInfoEXT *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<StructureType const &, const void * const &, SampleCountFlagBits const &, Extent2D const &, uint32_t const &, const SampleLocationEXT * const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, sampleLocationsPerPixel, sampleLocationGridSize, sampleLocationsCount, pSampleLocations );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( SampleLocationsInfoEXT const & ) const = default;
#else
    bool operator==( SampleLocationsInfoEXT const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( sampleLocationsPerPixel == rhs.sampleLocationsPerPixel ) &&
             ( sampleLocationGridSize == rhs.sampleLocationGridSize ) && ( sampleLocationsCount == rhs.sampleLocationsCount ) &&
             ( pSampleLocations == rhs.pSampleLocations );
#  endif
    }

    bool operator!=( SampleLocationsInfoEXT const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    StructureType             sType                   = StructureType::eSampleLocationsInfoEXT;
    const void *              pNext                   = {};
    SampleCountFlagBits       sampleLocationsPerPixel = SampleCountFlagBits::e1;
    Extent2D                  sampleLocationGridSize  = {};
    uint32_t                  sampleLocationsCount    = {};
    const SampleLocationEXT * pSampleLocations        = {};
  };

  template <>
  struct CppType<StructureType, StructureType::eSampleLocationsInfoEXT>
  {
    using Type = SampleLocationsInfoEXT;
  };

  // wrapper struct for struct VkAttachmentSampleLocationsEXT, see https://registry.khronos.org/vulkan/specs/latest/man/html/VkAttachmentSampleLocationsEXT.html
  struct AttachmentSampleLocationsEXT
  {
    using NativeType = VkAttachmentSampleLocationsEXT;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR AttachmentSampleLocationsEXT( uint32_t attachmentIndex_ = {}, SampleLocationsInfoEXT sampleLocationsInfo_ = {} ) VULKAN_HPP_NOEXCEPT
      : attachmentIndex{ attachmentIndex_ }
      , sampleLocationsInfo{ sampleLocationsInfo_ }
    {
    }

    VULKAN_HPP_CONSTEXPR AttachmentSampleLocationsEXT( AttachmentSampleLocationsEXT const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    AttachmentSampleLocationsEXT( VkAttachmentSampleLocationsEXT const & rhs ) VULKAN_HPP_NOEXCEPT
      : AttachmentSampleLocationsEXT( *reinterpret_cast<AttachmentSampleLocationsEXT const *>( &rhs ) )
    {
    }

    AttachmentSampleLocationsEXT & operator=( AttachmentSampleLocationsEXT const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    AttachmentSampleLocationsEXT & operator=( VkAttachmentSampleLocationsEXT const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<AttachmentSampleLocationsEXT const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 AttachmentSampleLocationsEXT & setAttachmentIndex( uint32_t attachmentIndex_ ) VULKAN_HPP_NOEXCEPT
    {
      attachmentIndex = attachmentIndex_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 AttachmentSampleLocationsEXT & setSampleLocationsInfo( SampleLocationsInfoEXT const & sampleLocationsInfo_ ) VULKAN_HPP_NOEXCEPT
    {
      sampleLocationsInfo = sampleLocationsInfo_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_SETTERS*/

    operator VkAttachmentSampleLocationsEXT const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkAttachmentSampleLocationsEXT *>( this );
    }

    operator VkAttachmentSampleLocationsEXT &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkAttachmentSampleLocationsEXT *>( this );
    }

    operator VkAttachmentSampleLocationsEXT const *() const VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<const VkAttachmentSampleLocationsEXT *>( this );
    }

    operator VkAttachmentSampleLocationsEXT *() VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<VkAttachmentSampleLocationsEXT *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<uint32_t const &, SampleLocationsInfoEXT const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( attachmentIndex, sampleLocationsInfo );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( AttachmentSampleLocationsEXT const & ) const = default;
#else
    bool operator==( AttachmentSampleLocationsEXT const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( attachmentIndex == rhs.attachmentIndex ) && ( sampleLocationsInfo == rhs.sampleLocationsInfo );
#  endif
    }

    bool operator!=( AttachmentSampleLocationsEXT const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    uint32_t               attachmentIndex     = {};
    SampleLocationsInfoEXT sampleLocationsInfo = {};
  };

  // wrapper struct for struct VkBaseInStructure, see https://registry.khronos.org/vulkan/specs/latest/man/html/VkBaseInStructure.html
  struct BaseInStructure
  {
    using NativeType = VkBaseInStructure;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    BaseInStructure( StructureType sType_ = StructureType::eApplicationInfo, const struct BaseInStructure * pNext_ = nullptr ) VULKAN_HPP_NOEXCEPT
      : sType{ sType_ }
      , pNext{ pNext_ }
    {
    }

    BaseInStructure( BaseInStructure const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    BaseInStructure( VkBaseInStructure const & rhs ) VULKAN_HPP_NOEXCEPT : BaseInStructure( *reinterpret_cast<BaseInStructure const *>( &rhs ) ) {}

    BaseInStructure & operator=( BaseInStructure const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    BaseInStructure & operator=( VkBaseInStructure const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<BaseInStructure const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 BaseInStructure & setPNext( const struct BaseInStructure * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_SETTERS*/

    operator VkBaseInStructure const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkBaseInStructure *>( this );
    }

    operator VkBaseInStructure &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkBaseInStructure *>( this );
    }

    operator VkBaseInStructure const *() const VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<const VkBaseInStructure *>( this );
    }

    operator VkBaseInStructure *() VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<VkBaseInStructure *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<StructureType const &, const struct BaseInStructure * const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( BaseInStructure const & ) const = default;
#else
    bool operator==( BaseInStructure const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext );
#  endif
    }

    bool operator!=( BaseInStructure const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    StructureType                  sType = StructureType::eApplicationInfo;
    const struct BaseInStructure * pNext = {};
  };

  // wrapper struct for struct VkBaseOutStructure, see https://registry.khronos.org/vulkan/specs/latest/man/html/VkBaseOutStructure.html
  struct BaseOutStructure
  {
    using NativeType = VkBaseOutStructure;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    BaseOutStructure( StructureType sType_ = StructureType::eApplicationInfo, struct BaseOutStructure * pNext_ = nullptr ) VULKAN_HPP_NOEXCEPT
      : sType{ sType_ }
      , pNext{ pNext_ }
    {
    }

    BaseOutStructure( BaseOutStructure const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    BaseOutStructure( VkBaseOutStructure const & rhs ) VULKAN_HPP_NOEXCEPT : BaseOutStructure( *reinterpret_cast<BaseOutStructure const *>( &rhs ) ) {}

    BaseOutStructure & operator=( BaseOutStructure const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    BaseOutStructure & operator=( VkBaseOutStructure const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<BaseOutStructure const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 BaseOutStructure & setPNext( struct BaseOutStructure * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_SETTERS*/

    operator VkBaseOutStructure const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkBaseOutStructure *>( this );
    }

    operator VkBaseOutStructure &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkBaseOutStructure *>( this );
    }

    operator VkBaseOutStructure const *() const VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<const VkBaseOutStructure *>( this );
    }

    operator VkBaseOutStructure *() VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<VkBaseOutStructure *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<StructureType const &, struct BaseOutStructure * const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( BaseOutStructure const & ) const = default;
#else
    bool operator==( BaseOutStructure const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext );
#  endif
    }

    bool operator!=( BaseOutStructure const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    StructureType             sType = StructureType::eApplicationInfo;
    struct BaseOutStructure * pNext = {};
  };

  // wrapper struct for struct VkBindAccelerationStructureMemoryInfoNV, see
  // https://registry.khronos.org/vulkan/specs/latest/man/html/VkBindAccelerationStructureMemoryInfoNV.html
  struct BindAccelerationStructureMemoryInfoNV
  {
    using NativeType = VkBindAccelerationStructureMemoryInfoNV;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eBindAccelerationStructureMemoryInfoNV;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR BindAccelerationStructureMemoryInfoNV( AccelerationStructureNV accelerationStructure_ = {},
                                                                DeviceMemory            memory_                = {},
                                                                DeviceSize              memoryOffset_          = {},
                                                                uint32_t                deviceIndexCount_      = {},
                                                                const uint32_t *        pDeviceIndices_        = {},
                                                                const void *            pNext_                 = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , accelerationStructure{ accelerationStructure_ }
      , memory{ memory_ }
      , memoryOffset{ memoryOffset_ }
      , deviceIndexCount{ deviceIndexCount_ }
      , pDeviceIndices{ pDeviceIndices_ }
    {
    }

    VULKAN_HPP_CONSTEXPR BindAccelerationStructureMemoryInfoNV( BindAccelerationStructureMemoryInfoNV const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    BindAccelerationStructureMemoryInfoNV( VkBindAccelerationStructureMemoryInfoNV const & rhs ) VULKAN_HPP_NOEXCEPT
      : BindAccelerationStructureMemoryInfoNV( *reinterpret_cast<BindAccelerationStructureMemoryInfoNV const *>( &rhs ) )
    {
    }

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    BindAccelerationStructureMemoryInfoNV( AccelerationStructureNV                         accelerationStructure_,
                                           DeviceMemory                                    memory_,
                                           DeviceSize                                      memoryOffset_,
                                           ArrayProxyNoTemporaries<const uint32_t> const & deviceIndices_,
                                           const void *                                    pNext_ = nullptr )
      : pNext( pNext_ )
      , accelerationStructure( accelerationStructure_ )
      , memory( memory_ )
      , memoryOffset( memoryOffset_ )
      , deviceIndexCount( static_cast<uint32_t>( deviceIndices_.size() ) )
      , pDeviceIndices( deviceIndices_.data() )
    {
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/

    BindAccelerationStructureMemoryInfoNV & operator=( BindAccelerationStructureMemoryInfoNV const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    BindAccelerationStructureMemoryInfoNV & operator=( VkBindAccelerationStructureMemoryInfoNV const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<BindAccelerationStructureMemoryInfoNV const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 BindAccelerationStructureMemoryInfoNV & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BindAccelerationStructureMemoryInfoNV &
      setAccelerationStructure( AccelerationStructureNV accelerationStructure_ ) VULKAN_HPP_NOEXCEPT
    {
      accelerationStructure = accelerationStructure_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BindAccelerationStructureMemoryInfoNV & setMemory( DeviceMemory memory_ ) VULKAN_HPP_NOEXCEPT
    {
      memory = memory_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BindAccelerationStructureMemoryInfoNV & setMemoryOffset( DeviceSize memoryOffset_ ) VULKAN_HPP_NOEXCEPT
    {
      memoryOffset = memoryOffset_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BindAccelerationStructureMemoryInfoNV & setDeviceIndexCount( uint32_t deviceIndexCount_ ) VULKAN_HPP_NOEXCEPT
    {
      deviceIndexCount = deviceIndexCount_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BindAccelerationStructureMemoryInfoNV & setPDeviceIndices( const uint32_t * pDeviceIndices_ ) VULKAN_HPP_NOEXCEPT
    {
      pDeviceIndices = pDeviceIndices_;
      return *this;
    }

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    BindAccelerationStructureMemoryInfoNV & setDeviceIndices( ArrayProxyNoTemporaries<const uint32_t> const & deviceIndices_ ) VULKAN_HPP_NOEXCEPT
    {
      deviceIndexCount = static_cast<uint32_t>( deviceIndices_.size() );
      pDeviceIndices   = deviceIndices_.data();
      return *this;
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/
#endif   /*VULKAN_HPP_NO_SETTERS*/

    operator VkBindAccelerationStructureMemoryInfoNV const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkBindAccelerationStructureMemoryInfoNV *>( this );
    }

    operator VkBindAccelerationStructureMemoryInfoNV &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkBindAccelerationStructureMemoryInfoNV *>( this );
    }

    operator VkBindAccelerationStructureMemoryInfoNV const *() const VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<const VkBindAccelerationStructureMemoryInfoNV *>( this );
    }

    operator VkBindAccelerationStructureMemoryInfoNV *() VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<VkBindAccelerationStructureMemoryInfoNV *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<StructureType const &,
               const void * const &,
               AccelerationStructureNV const &,
               DeviceMemory const &,
               DeviceSize const &,
               uint32_t const &,
               const uint32_t * const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, accelerationStructure, memory, memoryOffset, deviceIndexCount, pDeviceIndices );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( BindAccelerationStructureMemoryInfoNV const & ) const = default;
#else
    bool operator==( BindAccelerationStructureMemoryInfoNV const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( accelerationStructure == rhs.accelerationStructure ) && ( memory == rhs.memory ) &&
             ( memoryOffset == rhs.memoryOffset ) && ( deviceIndexCount == rhs.deviceIndexCount ) && ( pDeviceIndices == rhs.pDeviceIndices );
#  endif
    }

    bool operator!=( BindAccelerationStructureMemoryInfoNV const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    StructureType           sType                 = StructureType::eBindAccelerationStructureMemoryInfoNV;
    const void *            pNext                 = {};
    AccelerationStructureNV accelerationStructure = {};
    DeviceMemory            memory                = {};
    DeviceSize              memoryOffset          = {};
    uint32_t                deviceIndexCount      = {};
    const uint32_t *        pDeviceIndices        = {};
  };

  template <>
  struct CppType<StructureType, StructureType::eBindAccelerationStructureMemoryInfoNV>
  {
    using Type = BindAccelerationStructureMemoryInfoNV;
  };

  // wrapper struct for struct VkBindBufferMemoryDeviceGroupInfo, see
  // https://registry.khronos.org/vulkan/specs/latest/man/html/VkBindBufferMemoryDeviceGroupInfo.html
  struct BindBufferMemoryDeviceGroupInfo
  {
    using NativeType = VkBindBufferMemoryDeviceGroupInfo;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eBindBufferMemoryDeviceGroupInfo;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR BindBufferMemoryDeviceGroupInfo( uint32_t         deviceIndexCount_ = {},
                                                          const uint32_t * pDeviceIndices_   = {},
                                                          const void *     pNext_            = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , deviceIndexCount{ deviceIndexCount_ }
      , pDeviceIndices{ pDeviceIndices_ }
    {
    }

    VULKAN_HPP_CONSTEXPR BindBufferMemoryDeviceGroupInfo( BindBufferMemoryDeviceGroupInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    BindBufferMemoryDeviceGroupInfo( VkBindBufferMemoryDeviceGroupInfo const & rhs ) VULKAN_HPP_NOEXCEPT
      : BindBufferMemoryDeviceGroupInfo( *reinterpret_cast<BindBufferMemoryDeviceGroupInfo const *>( &rhs ) )
    {
    }

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    BindBufferMemoryDeviceGroupInfo( ArrayProxyNoTemporaries<const uint32_t> const & deviceIndices_, const void * pNext_ = nullptr )
      : pNext( pNext_ ), deviceIndexCount( static_cast<uint32_t>( deviceIndices_.size() ) ), pDeviceIndices( deviceIndices_.data() )
    {
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/

    BindBufferMemoryDeviceGroupInfo & operator=( BindBufferMemoryDeviceGroupInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    BindBufferMemoryDeviceGroupInfo & operator=( VkBindBufferMemoryDeviceGroupInfo const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<BindBufferMemoryDeviceGroupInfo const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 BindBufferMemoryDeviceGroupInfo & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BindBufferMemoryDeviceGroupInfo & setDeviceIndexCount( uint32_t deviceIndexCount_ ) VULKAN_HPP_NOEXCEPT
    {
      deviceIndexCount = deviceIndexCount_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BindBufferMemoryDeviceGroupInfo & setPDeviceIndices( const uint32_t * pDeviceIndices_ ) VULKAN_HPP_NOEXCEPT
    {
      pDeviceIndices = pDeviceIndices_;
      return *this;
    }

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    BindBufferMemoryDeviceGroupInfo & setDeviceIndices( ArrayProxyNoTemporaries<const uint32_t> const & deviceIndices_ ) VULKAN_HPP_NOEXCEPT
    {
      deviceIndexCount = static_cast<uint32_t>( deviceIndices_.size() );
      pDeviceIndices   = deviceIndices_.data();
      return *this;
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/
#endif   /*VULKAN_HPP_NO_SETTERS*/

    operator VkBindBufferMemoryDeviceGroupInfo const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkBindBufferMemoryDeviceGroupInfo *>( this );
    }

    operator VkBindBufferMemoryDeviceGroupInfo &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkBindBufferMemoryDeviceGroupInfo *>( this );
    }

    operator VkBindBufferMemoryDeviceGroupInfo const *() const VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<const VkBindBufferMemoryDeviceGroupInfo *>( this );
    }

    operator VkBindBufferMemoryDeviceGroupInfo *() VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<VkBindBufferMemoryDeviceGroupInfo *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<StructureType const &, const void * const &, uint32_t const &, const uint32_t * const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, deviceIndexCount, pDeviceIndices );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( BindBufferMemoryDeviceGroupInfo const & ) const = default;
#else
    bool operator==( BindBufferMemoryDeviceGroupInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( deviceIndexCount == rhs.deviceIndexCount ) && ( pDeviceIndices == rhs.pDeviceIndices );
#  endif
    }

    bool operator!=( BindBufferMemoryDeviceGroupInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    StructureType    sType            = StructureType::eBindBufferMemoryDeviceGroupInfo;
    const void *     pNext            = {};
    uint32_t         deviceIndexCount = {};
    const uint32_t * pDeviceIndices   = {};
  };

  template <>
  struct CppType<StructureType, StructureType::eBindBufferMemoryDeviceGroupInfo>
  {
    using Type = BindBufferMemoryDeviceGroupInfo;
  };

  using BindBufferMemoryDeviceGroupInfoKHR = BindBufferMemoryDeviceGroupInfo;

  // wrapper struct for struct VkBindBufferMemoryInfo, see https://registry.khronos.org/vulkan/specs/latest/man/html/VkBindBufferMemoryInfo.html
  struct BindBufferMemoryInfo
  {
    using NativeType = VkBindBufferMemoryInfo;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eBindBufferMemoryInfo;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR
      BindBufferMemoryInfo( Buffer buffer_ = {}, DeviceMemory memory_ = {}, DeviceSize memoryOffset_ = {}, const void * pNext_ = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , buffer{ buffer_ }
      , memory{ memory_ }
      , memoryOffset{ memoryOffset_ }
    {
    }

    VULKAN_HPP_CONSTEXPR BindBufferMemoryInfo( BindBufferMemoryInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    BindBufferMemoryInfo( VkBindBufferMemoryInfo const & rhs ) VULKAN_HPP_NOEXCEPT
      : BindBufferMemoryInfo( *reinterpret_cast<BindBufferMemoryInfo const *>( &rhs ) )
    {
    }

    BindBufferMemoryInfo & operator=( BindBufferMemoryInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    BindBufferMemoryInfo & operator=( VkBindBufferMemoryInfo const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<BindBufferMemoryInfo const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 BindBufferMemoryInfo & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BindBufferMemoryInfo & setBuffer( Buffer buffer_ ) VULKAN_HPP_NOEXCEPT
    {
      buffer = buffer_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BindBufferMemoryInfo & setMemory( DeviceMemory memory_ ) VULKAN_HPP_NOEXCEPT
    {
      memory = memory_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BindBufferMemoryInfo & setMemoryOffset( DeviceSize memoryOffset_ ) VULKAN_HPP_NOEXCEPT
    {
      memoryOffset = memoryOffset_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_SETTERS*/

    operator VkBindBufferMemoryInfo const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkBindBufferMemoryInfo *>( this );
    }

    operator VkBindBufferMemoryInfo &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkBindBufferMemoryInfo *>( this );
    }

    operator VkBindBufferMemoryInfo const *() const VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<const VkBindBufferMemoryInfo *>( this );
    }

    operator VkBindBufferMemoryInfo *() VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<VkBindBufferMemoryInfo *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<StructureType const &, const void * const &, Buffer const &, DeviceMemory const &, DeviceSize const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, buffer, memory, memoryOffset );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( BindBufferMemoryInfo const & ) const = default;
#else
    bool operator==( BindBufferMemoryInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( buffer == rhs.buffer ) && ( memory == rhs.memory ) && ( memoryOffset == rhs.memoryOffset );
#  endif
    }

    bool operator!=( BindBufferMemoryInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    StructureType sType        = StructureType::eBindBufferMemoryInfo;
    const void *  pNext        = {};
    Buffer        buffer       = {};
    DeviceMemory  memory       = {};
    DeviceSize    memoryOffset = {};
  };

  template <>
  struct CppType<StructureType, StructureType::eBindBufferMemoryInfo>
  {
    using Type = BindBufferMemoryInfo;
  };

  using BindBufferMemoryInfoKHR = BindBufferMemoryInfo;

  // wrapper struct for struct VkBindDataGraphPipelineSessionMemoryInfoARM, see
  // https://registry.khronos.org/vulkan/specs/latest/man/html/VkBindDataGraphPipelineSessionMemoryInfoARM.html
  struct BindDataGraphPipelineSessionMemoryInfoARM
  {
    using NativeType = VkBindDataGraphPipelineSessionMemoryInfoARM;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eBindDataGraphPipelineSessionMemoryInfoARM;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR
      BindDataGraphPipelineSessionMemoryInfoARM( DataGraphPipelineSessionARM          session_      = {},
                                                 DataGraphPipelineSessionBindPointARM bindPoint_    = DataGraphPipelineSessionBindPointARM::eTransient,
                                                 uint32_t                             objectIndex_  = {},
                                                 DeviceMemory                         memory_       = {},
                                                 DeviceSize                           memoryOffset_ = {},
                                                 const void *                         pNext_        = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , session{ session_ }
      , bindPoint{ bindPoint_ }
      , objectIndex{ objectIndex_ }
      , memory{ memory_ }
      , memoryOffset{ memoryOffset_ }
    {
    }

    VULKAN_HPP_CONSTEXPR BindDataGraphPipelineSessionMemoryInfoARM( BindDataGraphPipelineSessionMemoryInfoARM const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    BindDataGraphPipelineSessionMemoryInfoARM( VkBindDataGraphPipelineSessionMemoryInfoARM const & rhs ) VULKAN_HPP_NOEXCEPT
      : BindDataGraphPipelineSessionMemoryInfoARM( *reinterpret_cast<BindDataGraphPipelineSessionMemoryInfoARM const *>( &rhs ) )
    {
    }

    BindDataGraphPipelineSessionMemoryInfoARM & operator=( BindDataGraphPipelineSessionMemoryInfoARM const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    BindDataGraphPipelineSessionMemoryInfoARM & operator=( VkBindDataGraphPipelineSessionMemoryInfoARM const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<BindDataGraphPipelineSessionMemoryInfoARM const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 BindDataGraphPipelineSessionMemoryInfoARM & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BindDataGraphPipelineSessionMemoryInfoARM & setSession( DataGraphPipelineSessionARM session_ ) VULKAN_HPP_NOEXCEPT
    {
      session = session_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BindDataGraphPipelineSessionMemoryInfoARM & setBindPoint( DataGraphPipelineSessionBindPointARM bindPoint_ ) VULKAN_HPP_NOEXCEPT
    {
      bindPoint = bindPoint_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BindDataGraphPipelineSessionMemoryInfoARM & setObjectIndex( uint32_t objectIndex_ ) VULKAN_HPP_NOEXCEPT
    {
      objectIndex = objectIndex_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BindDataGraphPipelineSessionMemoryInfoARM & setMemory( DeviceMemory memory_ ) VULKAN_HPP_NOEXCEPT
    {
      memory = memory_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BindDataGraphPipelineSessionMemoryInfoARM & setMemoryOffset( DeviceSize memoryOffset_ ) VULKAN_HPP_NOEXCEPT
    {
      memoryOffset = memoryOffset_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_SETTERS*/

    operator VkBindDataGraphPipelineSessionMemoryInfoARM const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkBindDataGraphPipelineSessionMemoryInfoARM *>( this );
    }

    operator VkBindDataGraphPipelineSessionMemoryInfoARM &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkBindDataGraphPipelineSessionMemoryInfoARM *>( this );
    }

    operator VkBindDataGraphPipelineSessionMemoryInfoARM const *() const VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<const VkBindDataGraphPipelineSessionMemoryInfoARM *>( this );
    }

    operator VkBindDataGraphPipelineSessionMemoryInfoARM *() VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<VkBindDataGraphPipelineSessionMemoryInfoARM *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<StructureType const &,
               const void * const &,
               DataGraphPipelineSessionARM const &,
               DataGraphPipelineSessionBindPointARM const &,
               uint32_t const &,
               DeviceMemory const &,
               DeviceSize const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, session, bindPoint, objectIndex, memory, memoryOffset );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( BindDataGraphPipelineSessionMemoryInfoARM const & ) const = default;
#else
    bool operator==( BindDataGraphPipelineSessionMemoryInfoARM const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( session == rhs.session ) && ( bindPoint == rhs.bindPoint ) &&
             ( objectIndex == rhs.objectIndex ) && ( memory == rhs.memory ) && ( memoryOffset == rhs.memoryOffset );
#  endif
    }

    bool operator!=( BindDataGraphPipelineSessionMemoryInfoARM const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    StructureType                        sType        = StructureType::eBindDataGraphPipelineSessionMemoryInfoARM;
    const void *                         pNext        = {};
    DataGraphPipelineSessionARM          session      = {};
    DataGraphPipelineSessionBindPointARM bindPoint    = DataGraphPipelineSessionBindPointARM::eTransient;
    uint32_t                             objectIndex  = {};
    DeviceMemory                         memory       = {};
    DeviceSize                           memoryOffset = {};
  };

  template <>
  struct CppType<StructureType, StructureType::eBindDataGraphPipelineSessionMemoryInfoARM>
  {
    using Type = BindDataGraphPipelineSessionMemoryInfoARM;
  };

  // wrapper struct for struct VkBindDescriptorBufferEmbeddedSamplersInfoEXT, see
  // https://registry.khronos.org/vulkan/specs/latest/man/html/VkBindDescriptorBufferEmbeddedSamplersInfoEXT.html
  struct BindDescriptorBufferEmbeddedSamplersInfoEXT
  {
    using NativeType = VkBindDescriptorBufferEmbeddedSamplersInfoEXT;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eBindDescriptorBufferEmbeddedSamplersInfoEXT;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR BindDescriptorBufferEmbeddedSamplersInfoEXT( ShaderStageFlags stageFlags_ = {},
                                                                      PipelineLayout   layout_     = {},
                                                                      uint32_t         set_        = {},
                                                                      const void *     pNext_      = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , stageFlags{ stageFlags_ }
      , layout{ layout_ }
      , set{ set_ }
    {
    }

    VULKAN_HPP_CONSTEXPR BindDescriptorBufferEmbeddedSamplersInfoEXT( BindDescriptorBufferEmbeddedSamplersInfoEXT const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    BindDescriptorBufferEmbeddedSamplersInfoEXT( VkBindDescriptorBufferEmbeddedSamplersInfoEXT const & rhs ) VULKAN_HPP_NOEXCEPT
      : BindDescriptorBufferEmbeddedSamplersInfoEXT( *reinterpret_cast<BindDescriptorBufferEmbeddedSamplersInfoEXT const *>( &rhs ) )
    {
    }

    BindDescriptorBufferEmbeddedSamplersInfoEXT & operator=( BindDescriptorBufferEmbeddedSamplersInfoEXT const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    BindDescriptorBufferEmbeddedSamplersInfoEXT & operator=( VkBindDescriptorBufferEmbeddedSamplersInfoEXT const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<BindDescriptorBufferEmbeddedSamplersInfoEXT const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 BindDescriptorBufferEmbeddedSamplersInfoEXT & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BindDescriptorBufferEmbeddedSamplersInfoEXT & setStageFlags( ShaderStageFlags stageFlags_ ) VULKAN_HPP_NOEXCEPT
    {
      stageFlags = stageFlags_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BindDescriptorBufferEmbeddedSamplersInfoEXT & setLayout( PipelineLayout layout_ ) VULKAN_HPP_NOEXCEPT
    {
      layout = layout_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BindDescriptorBufferEmbeddedSamplersInfoEXT & setSet( uint32_t set_ ) VULKAN_HPP_NOEXCEPT
    {
      set = set_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_SETTERS*/

    operator VkBindDescriptorBufferEmbeddedSamplersInfoEXT const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkBindDescriptorBufferEmbeddedSamplersInfoEXT *>( this );
    }

    operator VkBindDescriptorBufferEmbeddedSamplersInfoEXT &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkBindDescriptorBufferEmbeddedSamplersInfoEXT *>( this );
    }

    operator VkBindDescriptorBufferEmbeddedSamplersInfoEXT const *() const VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<const VkBindDescriptorBufferEmbeddedSamplersInfoEXT *>( this );
    }

    operator VkBindDescriptorBufferEmbeddedSamplersInfoEXT *() VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<VkBindDescriptorBufferEmbeddedSamplersInfoEXT *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<StructureType const &, const void * const &, ShaderStageFlags const &, PipelineLayout const &, uint32_t const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, stageFlags, layout, set );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( BindDescriptorBufferEmbeddedSamplersInfoEXT const & ) const = default;
#else
    bool operator==( BindDescriptorBufferEmbeddedSamplersInfoEXT const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( stageFlags == rhs.stageFlags ) && ( layout == rhs.layout ) && ( set == rhs.set );
#  endif
    }

    bool operator!=( BindDescriptorBufferEmbeddedSamplersInfoEXT const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    StructureType    sType      = StructureType::eBindDescriptorBufferEmbeddedSamplersInfoEXT;
    const void *     pNext      = {};
    ShaderStageFlags stageFlags = {};
    PipelineLayout   layout     = {};
    uint32_t         set        = {};
  };

  template <>
  struct CppType<StructureType, StructureType::eBindDescriptorBufferEmbeddedSamplersInfoEXT>
  {
    using Type = BindDescriptorBufferEmbeddedSamplersInfoEXT;
  };

  // wrapper struct for struct VkBindDescriptorSetsInfo, see https://registry.khronos.org/vulkan/specs/latest/man/html/VkBindDescriptorSetsInfo.html
  struct BindDescriptorSetsInfo
  {
    using NativeType = VkBindDescriptorSetsInfo;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eBindDescriptorSetsInfo;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR BindDescriptorSetsInfo( ShaderStageFlags      stageFlags_         = {},
                                                 PipelineLayout        layout_             = {},
                                                 uint32_t              firstSet_           = {},
                                                 uint32_t              descriptorSetCount_ = {},
                                                 const DescriptorSet * pDescriptorSets_    = {},
                                                 uint32_t              dynamicOffsetCount_ = {},
                                                 const uint32_t *      pDynamicOffsets_    = {},
                                                 const void *          pNext_              = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , stageFlags{ stageFlags_ }
      , layout{ layout_ }
      , firstSet{ firstSet_ }
      , descriptorSetCount{ descriptorSetCount_ }
      , pDescriptorSets{ pDescriptorSets_ }
      , dynamicOffsetCount{ dynamicOffsetCount_ }
      , pDynamicOffsets{ pDynamicOffsets_ }
    {
    }

    VULKAN_HPP_CONSTEXPR BindDescriptorSetsInfo( BindDescriptorSetsInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    BindDescriptorSetsInfo( VkBindDescriptorSetsInfo const & rhs ) VULKAN_HPP_NOEXCEPT
      : BindDescriptorSetsInfo( *reinterpret_cast<BindDescriptorSetsInfo const *>( &rhs ) )
    {
    }

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    BindDescriptorSetsInfo( ShaderStageFlags                                     stageFlags_,
                            PipelineLayout                                       layout_,
                            uint32_t                                             firstSet_,
                            ArrayProxyNoTemporaries<const DescriptorSet> const & descriptorSets_,
                            ArrayProxyNoTemporaries<const uint32_t> const &      dynamicOffsets_ = {},
                            const void *                                         pNext_          = nullptr )
      : pNext( pNext_ )
      , stageFlags( stageFlags_ )
      , layout( layout_ )
      , firstSet( firstSet_ )
      , descriptorSetCount( static_cast<uint32_t>( descriptorSets_.size() ) )
      , pDescriptorSets( descriptorSets_.data() )
      , dynamicOffsetCount( static_cast<uint32_t>( dynamicOffsets_.size() ) )
      , pDynamicOffsets( dynamicOffsets_.data() )
    {
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/

    BindDescriptorSetsInfo & operator=( BindDescriptorSetsInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    BindDescriptorSetsInfo & operator=( VkBindDescriptorSetsInfo const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<BindDescriptorSetsInfo const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 BindDescriptorSetsInfo & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BindDescriptorSetsInfo & setStageFlags( ShaderStageFlags stageFlags_ ) VULKAN_HPP_NOEXCEPT
    {
      stageFlags = stageFlags_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BindDescriptorSetsInfo & setLayout( PipelineLayout layout_ ) VULKAN_HPP_NOEXCEPT
    {
      layout = layout_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BindDescriptorSetsInfo & setFirstSet( uint32_t firstSet_ ) VULKAN_HPP_NOEXCEPT
    {
      firstSet = firstSet_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BindDescriptorSetsInfo & setDescriptorSetCount( uint32_t descriptorSetCount_ ) VULKAN_HPP_NOEXCEPT
    {
      descriptorSetCount = descriptorSetCount_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BindDescriptorSetsInfo & setPDescriptorSets( const DescriptorSet * pDescriptorSets_ ) VULKAN_HPP_NOEXCEPT
    {
      pDescriptorSets = pDescriptorSets_;
      return *this;
    }

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    BindDescriptorSetsInfo & setDescriptorSets( ArrayProxyNoTemporaries<const DescriptorSet> const & descriptorSets_ ) VULKAN_HPP_NOEXCEPT
    {
      descriptorSetCount = static_cast<uint32_t>( descriptorSets_.size() );
      pDescriptorSets    = descriptorSets_.data();
      return *this;
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/

    VULKAN_HPP_CONSTEXPR_14 BindDescriptorSetsInfo & setDynamicOffsetCount( uint32_t dynamicOffsetCount_ ) VULKAN_HPP_NOEXCEPT
    {
      dynamicOffsetCount = dynamicOffsetCount_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BindDescriptorSetsInfo & setPDynamicOffsets( const uint32_t * pDynamicOffsets_ ) VULKAN_HPP_NOEXCEPT
    {
      pDynamicOffsets = pDynamicOffsets_;
      return *this;
    }

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    BindDescriptorSetsInfo & setDynamicOffsets( ArrayProxyNoTemporaries<const uint32_t> const & dynamicOffsets_ ) VULKAN_HPP_NOEXCEPT
    {
      dynamicOffsetCount = static_cast<uint32_t>( dynamicOffsets_.size() );
      pDynamicOffsets    = dynamicOffsets_.data();
      return *this;
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/
#endif   /*VULKAN_HPP_NO_SETTERS*/

    operator VkBindDescriptorSetsInfo const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkBindDescriptorSetsInfo *>( this );
    }

    operator VkBindDescriptorSetsInfo &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkBindDescriptorSetsInfo *>( this );
    }

    operator VkBindDescriptorSetsInfo const *() const VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<const VkBindDescriptorSetsInfo *>( this );
    }

    operator VkBindDescriptorSetsInfo *() VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<VkBindDescriptorSetsInfo *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<StructureType const &,
               const void * const &,
               ShaderStageFlags const &,
               PipelineLayout const &,
               uint32_t const &,
               uint32_t const &,
               const DescriptorSet * const &,
               uint32_t const &,
               const uint32_t * const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, stageFlags, layout, firstSet, descriptorSetCount, pDescriptorSets, dynamicOffsetCount, pDynamicOffsets );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( BindDescriptorSetsInfo const & ) const = default;
#else
    bool operator==( BindDescriptorSetsInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( stageFlags == rhs.stageFlags ) && ( layout == rhs.layout ) && ( firstSet == rhs.firstSet ) &&
             ( descriptorSetCount == rhs.descriptorSetCount ) && ( pDescriptorSets == rhs.pDescriptorSets ) &&
             ( dynamicOffsetCount == rhs.dynamicOffsetCount ) && ( pDynamicOffsets == rhs.pDynamicOffsets );
#  endif
    }

    bool operator!=( BindDescriptorSetsInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    StructureType         sType              = StructureType::eBindDescriptorSetsInfo;
    const void *          pNext              = {};
    ShaderStageFlags      stageFlags         = {};
    PipelineLayout        layout             = {};
    uint32_t              firstSet           = {};
    uint32_t              descriptorSetCount = {};
    const DescriptorSet * pDescriptorSets    = {};
    uint32_t              dynamicOffsetCount = {};
    const uint32_t *      pDynamicOffsets    = {};
  };

  template <>
  struct CppType<StructureType, StructureType::eBindDescriptorSetsInfo>
  {
    using Type = BindDescriptorSetsInfo;
  };

  using BindDescriptorSetsInfoKHR = BindDescriptorSetsInfo;

  // wrapper struct for struct VkOffset2D, see https://registry.khronos.org/vulkan/specs/latest/man/html/VkOffset2D.html
  struct Offset2D
  {
    using NativeType = VkOffset2D;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR Offset2D( int32_t x_ = {}, int32_t y_ = {} ) VULKAN_HPP_NOEXCEPT
      : x{ x_ }
      , y{ y_ }
    {
    }

    VULKAN_HPP_CONSTEXPR Offset2D( Offset2D const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    Offset2D( VkOffset2D const & rhs ) VULKAN_HPP_NOEXCEPT : Offset2D( *reinterpret_cast<Offset2D const *>( &rhs ) ) {}

    Offset2D & operator=( Offset2D const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    Offset2D & operator=( VkOffset2D const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<Offset2D const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 Offset2D & setX( int32_t x_ ) VULKAN_HPP_NOEXCEPT
    {
      x = x_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 Offset2D & setY( int32_t y_ ) VULKAN_HPP_NOEXCEPT
    {
      y = y_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_SETTERS*/

    operator VkOffset2D const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkOffset2D *>( this );
    }

    operator VkOffset2D &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkOffset2D *>( this );
    }

    operator VkOffset2D const *() const VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<const VkOffset2D *>( this );
    }

    operator VkOffset2D *() VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<VkOffset2D *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<int32_t const &, int32_t const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( x, y );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( Offset2D const & ) const = default;
#else
    bool operator==( Offset2D const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( x == rhs.x ) && ( y == rhs.y );
#  endif
    }

    bool operator!=( Offset2D const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    int32_t x = {};
    int32_t y = {};
  };

  // wrapper struct for struct VkRect2D, see https://registry.khronos.org/vulkan/specs/latest/man/html/VkRect2D.html
  struct Rect2D
  {
    using NativeType = VkRect2D;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR Rect2D( Offset2D offset_ = {}, Extent2D extent_ = {} ) VULKAN_HPP_NOEXCEPT
      : offset{ offset_ }
      , extent{ extent_ }
    {
    }

    VULKAN_HPP_CONSTEXPR Rect2D( Rect2D const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    Rect2D( VkRect2D const & rhs ) VULKAN_HPP_NOEXCEPT : Rect2D( *reinterpret_cast<Rect2D const *>( &rhs ) ) {}

    Rect2D & operator=( Rect2D const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    Rect2D & operator=( VkRect2D const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<Rect2D const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 Rect2D & setOffset( Offset2D const & offset_ ) VULKAN_HPP_NOEXCEPT
    {
      offset = offset_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 Rect2D & setExtent( Extent2D const & extent_ ) VULKAN_HPP_NOEXCEPT
    {
      extent = extent_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_SETTERS*/

    operator VkRect2D const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkRect2D *>( this );
    }

    operator VkRect2D &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkRect2D *>( this );
    }

    operator VkRect2D const *() const VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<const VkRect2D *>( this );
    }

    operator VkRect2D *() VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<VkRect2D *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<Offset2D const &, Extent2D const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( offset, extent );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( Rect2D const & ) const = default;
#else
    bool operator==( Rect2D const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( offset == rhs.offset ) && ( extent == rhs.extent );
#  endif
    }

    bool operator!=( Rect2D const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    Offset2D offset = {};
    Extent2D extent = {};
  };

  // wrapper struct for struct VkBindImageMemoryDeviceGroupInfo, see
  // https://registry.khronos.org/vulkan/specs/latest/man/html/VkBindImageMemoryDeviceGroupInfo.html
  struct BindImageMemoryDeviceGroupInfo
  {
    using NativeType = VkBindImageMemoryDeviceGroupInfo;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eBindImageMemoryDeviceGroupInfo;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR BindImageMemoryDeviceGroupInfo( uint32_t         deviceIndexCount_             = {},
                                                         const uint32_t * pDeviceIndices_               = {},
                                                         uint32_t         splitInstanceBindRegionCount_ = {},
                                                         const Rect2D *   pSplitInstanceBindRegions_    = {},
                                                         const void *     pNext_                        = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , deviceIndexCount{ deviceIndexCount_ }
      , pDeviceIndices{ pDeviceIndices_ }
      , splitInstanceBindRegionCount{ splitInstanceBindRegionCount_ }
      , pSplitInstanceBindRegions{ pSplitInstanceBindRegions_ }
    {
    }

    VULKAN_HPP_CONSTEXPR BindImageMemoryDeviceGroupInfo( BindImageMemoryDeviceGroupInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    BindImageMemoryDeviceGroupInfo( VkBindImageMemoryDeviceGroupInfo const & rhs ) VULKAN_HPP_NOEXCEPT
      : BindImageMemoryDeviceGroupInfo( *reinterpret_cast<BindImageMemoryDeviceGroupInfo const *>( &rhs ) )
    {
    }

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    BindImageMemoryDeviceGroupInfo( ArrayProxyNoTemporaries<const uint32_t> const & deviceIndices_,
                                    ArrayProxyNoTemporaries<const Rect2D> const &   splitInstanceBindRegions_ = {},
                                    const void *                                    pNext_                    = nullptr )
      : pNext( pNext_ )
      , deviceIndexCount( static_cast<uint32_t>( deviceIndices_.size() ) )
      , pDeviceIndices( deviceIndices_.data() )
      , splitInstanceBindRegionCount( static_cast<uint32_t>( splitInstanceBindRegions_.size() ) )
      , pSplitInstanceBindRegions( splitInstanceBindRegions_.data() )
    {
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/

    BindImageMemoryDeviceGroupInfo & operator=( BindImageMemoryDeviceGroupInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    BindImageMemoryDeviceGroupInfo & operator=( VkBindImageMemoryDeviceGroupInfo const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<BindImageMemoryDeviceGroupInfo const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 BindImageMemoryDeviceGroupInfo & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BindImageMemoryDeviceGroupInfo & setDeviceIndexCount( uint32_t deviceIndexCount_ ) VULKAN_HPP_NOEXCEPT
    {
      deviceIndexCount = deviceIndexCount_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BindImageMemoryDeviceGroupInfo & setPDeviceIndices( const uint32_t * pDeviceIndices_ ) VULKAN_HPP_NOEXCEPT
    {
      pDeviceIndices = pDeviceIndices_;
      return *this;
    }

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    BindImageMemoryDeviceGroupInfo & setDeviceIndices( ArrayProxyNoTemporaries<const uint32_t> const & deviceIndices_ ) VULKAN_HPP_NOEXCEPT
    {
      deviceIndexCount = static_cast<uint32_t>( deviceIndices_.size() );
      pDeviceIndices   = deviceIndices_.data();
      return *this;
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/

    VULKAN_HPP_CONSTEXPR_14 BindImageMemoryDeviceGroupInfo & setSplitInstanceBindRegionCount( uint32_t splitInstanceBindRegionCount_ ) VULKAN_HPP_NOEXCEPT
    {
      splitInstanceBindRegionCount = splitInstanceBindRegionCount_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BindImageMemoryDeviceGroupInfo & setPSplitInstanceBindRegions( const Rect2D * pSplitInstanceBindRegions_ ) VULKAN_HPP_NOEXCEPT
    {
      pSplitInstanceBindRegions = pSplitInstanceBindRegions_;
      return *this;
    }

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    BindImageMemoryDeviceGroupInfo & setSplitInstanceBindRegions( ArrayProxyNoTemporaries<const Rect2D> const & splitInstanceBindRegions_ ) VULKAN_HPP_NOEXCEPT
    {
      splitInstanceBindRegionCount = static_cast<uint32_t>( splitInstanceBindRegions_.size() );
      pSplitInstanceBindRegions    = splitInstanceBindRegions_.data();
      return *this;
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/
#endif   /*VULKAN_HPP_NO_SETTERS*/

    operator VkBindImageMemoryDeviceGroupInfo const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkBindImageMemoryDeviceGroupInfo *>( this );
    }

    operator VkBindImageMemoryDeviceGroupInfo &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkBindImageMemoryDeviceGroupInfo *>( this );
    }

    operator VkBindImageMemoryDeviceGroupInfo const *() const VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<const VkBindImageMemoryDeviceGroupInfo *>( this );
    }

    operator VkBindImageMemoryDeviceGroupInfo *() VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<VkBindImageMemoryDeviceGroupInfo *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<StructureType const &, const void * const &, uint32_t const &, const uint32_t * const &, uint32_t const &, const Rect2D * const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, deviceIndexCount, pDeviceIndices, splitInstanceBindRegionCount, pSplitInstanceBindRegions );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( BindImageMemoryDeviceGroupInfo const & ) const = default;
#else
    bool operator==( BindImageMemoryDeviceGroupInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( deviceIndexCount == rhs.deviceIndexCount ) && ( pDeviceIndices == rhs.pDeviceIndices ) &&
             ( splitInstanceBindRegionCount == rhs.splitInstanceBindRegionCount ) && ( pSplitInstanceBindRegions == rhs.pSplitInstanceBindRegions );
#  endif
    }

    bool operator!=( BindImageMemoryDeviceGroupInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    StructureType    sType                        = StructureType::eBindImageMemoryDeviceGroupInfo;
    const void *     pNext                        = {};
    uint32_t         deviceIndexCount             = {};
    const uint32_t * pDeviceIndices               = {};
    uint32_t         splitInstanceBindRegionCount = {};
    const Rect2D *   pSplitInstanceBindRegions    = {};
  };

  template <>
  struct CppType<StructureType, StructureType::eBindImageMemoryDeviceGroupInfo>
  {
    using Type = BindImageMemoryDeviceGroupInfo;
  };

  using BindImageMemoryDeviceGroupInfoKHR = BindImageMemoryDeviceGroupInfo;

  // wrapper struct for struct VkBindImageMemoryInfo, see https://registry.khronos.org/vulkan/specs/latest/man/html/VkBindImageMemoryInfo.html
  struct BindImageMemoryInfo
  {
    using NativeType = VkBindImageMemoryInfo;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eBindImageMemoryInfo;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR
      BindImageMemoryInfo( Image image_ = {}, DeviceMemory memory_ = {}, DeviceSize memoryOffset_ = {}, const void * pNext_ = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , image{ image_ }
      , memory{ memory_ }
      , memoryOffset{ memoryOffset_ }
    {
    }

    VULKAN_HPP_CONSTEXPR BindImageMemoryInfo( BindImageMemoryInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    BindImageMemoryInfo( VkBindImageMemoryInfo const & rhs ) VULKAN_HPP_NOEXCEPT : BindImageMemoryInfo( *reinterpret_cast<BindImageMemoryInfo const *>( &rhs ) )
    {
    }

    BindImageMemoryInfo & operator=( BindImageMemoryInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    BindImageMemoryInfo & operator=( VkBindImageMemoryInfo const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<BindImageMemoryInfo const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 BindImageMemoryInfo & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BindImageMemoryInfo & setImage( Image image_ ) VULKAN_HPP_NOEXCEPT
    {
      image = image_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BindImageMemoryInfo & setMemory( DeviceMemory memory_ ) VULKAN_HPP_NOEXCEPT
    {
      memory = memory_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BindImageMemoryInfo & setMemoryOffset( DeviceSize memoryOffset_ ) VULKAN_HPP_NOEXCEPT
    {
      memoryOffset = memoryOffset_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_SETTERS*/

    operator VkBindImageMemoryInfo const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkBindImageMemoryInfo *>( this );
    }

    operator VkBindImageMemoryInfo &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkBindImageMemoryInfo *>( this );
    }

    operator VkBindImageMemoryInfo const *() const VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<const VkBindImageMemoryInfo *>( this );
    }

    operator VkBindImageMemoryInfo *() VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<VkBindImageMemoryInfo *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<StructureType const &, const void * const &, Image const &, DeviceMemory const &, DeviceSize const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, image, memory, memoryOffset );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( BindImageMemoryInfo const & ) const = default;
#else
    bool operator==( BindImageMemoryInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( image == rhs.image ) && ( memory == rhs.memory ) && ( memoryOffset == rhs.memoryOffset );
#  endif
    }

    bool operator!=( BindImageMemoryInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    StructureType sType        = StructureType::eBindImageMemoryInfo;
    const void *  pNext        = {};
    Image         image        = {};
    DeviceMemory  memory       = {};
    DeviceSize    memoryOffset = {};
  };

  template <>
  struct CppType<StructureType, StructureType::eBindImageMemoryInfo>
  {
    using Type = BindImageMemoryInfo;
  };

  using BindImageMemoryInfoKHR = BindImageMemoryInfo;

  // wrapper struct for struct VkBindImageMemorySwapchainInfoKHR, see
  // https://registry.khronos.org/vulkan/specs/latest/man/html/VkBindImageMemorySwapchainInfoKHR.html
  struct BindImageMemorySwapchainInfoKHR
  {
    using NativeType = VkBindImageMemorySwapchainInfoKHR;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eBindImageMemorySwapchainInfoKHR;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR
      BindImageMemorySwapchainInfoKHR( SwapchainKHR swapchain_ = {}, uint32_t imageIndex_ = {}, const void * pNext_ = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , swapchain{ swapchain_ }
      , imageIndex{ imageIndex_ }
    {
    }

    VULKAN_HPP_CONSTEXPR BindImageMemorySwapchainInfoKHR( BindImageMemorySwapchainInfoKHR const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    BindImageMemorySwapchainInfoKHR( VkBindImageMemorySwapchainInfoKHR const & rhs ) VULKAN_HPP_NOEXCEPT
      : BindImageMemorySwapchainInfoKHR( *reinterpret_cast<BindImageMemorySwapchainInfoKHR const *>( &rhs ) )
    {
    }

    BindImageMemorySwapchainInfoKHR & operator=( BindImageMemorySwapchainInfoKHR const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    BindImageMemorySwapchainInfoKHR & operator=( VkBindImageMemorySwapchainInfoKHR const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<BindImageMemorySwapchainInfoKHR const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 BindImageMemorySwapchainInfoKHR & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BindImageMemorySwapchainInfoKHR & setSwapchain( SwapchainKHR swapchain_ ) VULKAN_HPP_NOEXCEPT
    {
      swapchain = swapchain_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BindImageMemorySwapchainInfoKHR & setImageIndex( uint32_t imageIndex_ ) VULKAN_HPP_NOEXCEPT
    {
      imageIndex = imageIndex_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_SETTERS*/

    operator VkBindImageMemorySwapchainInfoKHR const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkBindImageMemorySwapchainInfoKHR *>( this );
    }

    operator VkBindImageMemorySwapchainInfoKHR &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkBindImageMemorySwapchainInfoKHR *>( this );
    }

    operator VkBindImageMemorySwapchainInfoKHR const *() const VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<const VkBindImageMemorySwapchainInfoKHR *>( this );
    }

    operator VkBindImageMemorySwapchainInfoKHR *() VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<VkBindImageMemorySwapchainInfoKHR *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<StructureType const &, const void * const &, SwapchainKHR const &, uint32_t const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, swapchain, imageIndex );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( BindImageMemorySwapchainInfoKHR const & ) const = default;
#else
    bool operator==( BindImageMemorySwapchainInfoKHR const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( swapchain == rhs.swapchain ) && ( imageIndex == rhs.imageIndex );
#  endif
    }

    bool operator!=( BindImageMemorySwapchainInfoKHR const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    StructureType sType      = StructureType::eBindImageMemorySwapchainInfoKHR;
    const void *  pNext      = {};
    SwapchainKHR  swapchain  = {};
    uint32_t      imageIndex = {};
  };

  template <>
  struct CppType<StructureType, StructureType::eBindImageMemorySwapchainInfoKHR>
  {
    using Type = BindImageMemorySwapchainInfoKHR;
  };

  // wrapper struct for struct VkBindImagePlaneMemoryInfo, see https://registry.khronos.org/vulkan/specs/latest/man/html/VkBindImagePlaneMemoryInfo.html
  struct BindImagePlaneMemoryInfo
  {
    using NativeType = VkBindImagePlaneMemoryInfo;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eBindImagePlaneMemoryInfo;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR BindImagePlaneMemoryInfo( ImageAspectFlagBits planeAspect_ = ImageAspectFlagBits::eColor,
                                                   const void *        pNext_       = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , planeAspect{ planeAspect_ }
    {
    }

    VULKAN_HPP_CONSTEXPR BindImagePlaneMemoryInfo( BindImagePlaneMemoryInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    BindImagePlaneMemoryInfo( VkBindImagePlaneMemoryInfo const & rhs ) VULKAN_HPP_NOEXCEPT
      : BindImagePlaneMemoryInfo( *reinterpret_cast<BindImagePlaneMemoryInfo const *>( &rhs ) )
    {
    }

    BindImagePlaneMemoryInfo & operator=( BindImagePlaneMemoryInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    BindImagePlaneMemoryInfo & operator=( VkBindImagePlaneMemoryInfo const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<BindImagePlaneMemoryInfo const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 BindImagePlaneMemoryInfo & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BindImagePlaneMemoryInfo & setPlaneAspect( ImageAspectFlagBits planeAspect_ ) VULKAN_HPP_NOEXCEPT
    {
      planeAspect = planeAspect_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_SETTERS*/

    operator VkBindImagePlaneMemoryInfo const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkBindImagePlaneMemoryInfo *>( this );
    }

    operator VkBindImagePlaneMemoryInfo &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkBindImagePlaneMemoryInfo *>( this );
    }

    operator VkBindImagePlaneMemoryInfo const *() const VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<const VkBindImagePlaneMemoryInfo *>( this );
    }

    operator VkBindImagePlaneMemoryInfo *() VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<VkBindImagePlaneMemoryInfo *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<StructureType const &, const void * const &, ImageAspectFlagBits const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, planeAspect );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( BindImagePlaneMemoryInfo const & ) const = default;
#else
    bool operator==( BindImagePlaneMemoryInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( planeAspect == rhs.planeAspect );
#  endif
    }

    bool operator!=( BindImagePlaneMemoryInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    StructureType       sType       = StructureType::eBindImagePlaneMemoryInfo;
    const void *        pNext       = {};
    ImageAspectFlagBits planeAspect = ImageAspectFlagBits::eColor;
  };

  template <>
  struct CppType<StructureType, StructureType::eBindImagePlaneMemoryInfo>
  {
    using Type = BindImagePlaneMemoryInfo;
  };

  using BindImagePlaneMemoryInfoKHR = BindImagePlaneMemoryInfo;

  // wrapper struct for struct VkBindIndexBufferIndirectCommandEXT, see
  // https://registry.khronos.org/vulkan/specs/latest/man/html/VkBindIndexBufferIndirectCommandEXT.html
  struct BindIndexBufferIndirectCommandEXT
  {
    using NativeType = VkBindIndexBufferIndirectCommandEXT;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR
      BindIndexBufferIndirectCommandEXT( DeviceAddress bufferAddress_ = {}, uint32_t size_ = {}, IndexType indexType_ = IndexType::eUint16 ) VULKAN_HPP_NOEXCEPT
      : bufferAddress{ bufferAddress_ }
      , size{ size_ }
      , indexType{ indexType_ }
    {
    }

    VULKAN_HPP_CONSTEXPR BindIndexBufferIndirectCommandEXT( BindIndexBufferIndirectCommandEXT const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    BindIndexBufferIndirectCommandEXT( VkBindIndexBufferIndirectCommandEXT const & rhs ) VULKAN_HPP_NOEXCEPT
      : BindIndexBufferIndirectCommandEXT( *reinterpret_cast<BindIndexBufferIndirectCommandEXT const *>( &rhs ) )
    {
    }

    BindIndexBufferIndirectCommandEXT & operator=( BindIndexBufferIndirectCommandEXT const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    BindIndexBufferIndirectCommandEXT & operator=( VkBindIndexBufferIndirectCommandEXT const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<BindIndexBufferIndirectCommandEXT const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 BindIndexBufferIndirectCommandEXT & setBufferAddress( DeviceAddress bufferAddress_ ) VULKAN_HPP_NOEXCEPT
    {
      bufferAddress = bufferAddress_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BindIndexBufferIndirectCommandEXT & setSize( uint32_t size_ ) VULKAN_HPP_NOEXCEPT
    {
      size = size_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BindIndexBufferIndirectCommandEXT & setIndexType( IndexType indexType_ ) VULKAN_HPP_NOEXCEPT
    {
      indexType = indexType_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_SETTERS*/

    operator VkBindIndexBufferIndirectCommandEXT const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkBindIndexBufferIndirectCommandEXT *>( this );
    }

    operator VkBindIndexBufferIndirectCommandEXT &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkBindIndexBufferIndirectCommandEXT *>( this );
    }

    operator VkBindIndexBufferIndirectCommandEXT const *() const VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<const VkBindIndexBufferIndirectCommandEXT *>( this );
    }

    operator VkBindIndexBufferIndirectCommandEXT *() VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<VkBindIndexBufferIndirectCommandEXT *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<DeviceAddress const &, uint32_t const &, IndexType const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( bufferAddress, size, indexType );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( BindIndexBufferIndirectCommandEXT const & ) const = default;
#else
    bool operator==( BindIndexBufferIndirectCommandEXT const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( bufferAddress == rhs.bufferAddress ) && ( size == rhs.size ) && ( indexType == rhs.indexType );
#  endif
    }

    bool operator!=( BindIndexBufferIndirectCommandEXT const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    DeviceAddress bufferAddress = {};
    uint32_t      size          = {};
    IndexType     indexType     = IndexType::eUint16;
  };

  // wrapper struct for struct VkBindIndexBufferIndirectCommandNV, see
  // https://registry.khronos.org/vulkan/specs/latest/man/html/VkBindIndexBufferIndirectCommandNV.html
  struct BindIndexBufferIndirectCommandNV
  {
    using NativeType = VkBindIndexBufferIndirectCommandNV;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR
      BindIndexBufferIndirectCommandNV( DeviceAddress bufferAddress_ = {}, uint32_t size_ = {}, IndexType indexType_ = IndexType::eUint16 ) VULKAN_HPP_NOEXCEPT
      : bufferAddress{ bufferAddress_ }
      , size{ size_ }
      , indexType{ indexType_ }
    {
    }

    VULKAN_HPP_CONSTEXPR BindIndexBufferIndirectCommandNV( BindIndexBufferIndirectCommandNV const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    BindIndexBufferIndirectCommandNV( VkBindIndexBufferIndirectCommandNV const & rhs ) VULKAN_HPP_NOEXCEPT
      : BindIndexBufferIndirectCommandNV( *reinterpret_cast<BindIndexBufferIndirectCommandNV const *>( &rhs ) )
    {
    }

    BindIndexBufferIndirectCommandNV & operator=( BindIndexBufferIndirectCommandNV const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    BindIndexBufferIndirectCommandNV & operator=( VkBindIndexBufferIndirectCommandNV const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<BindIndexBufferIndirectCommandNV const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 BindIndexBufferIndirectCommandNV & setBufferAddress( DeviceAddress bufferAddress_ ) VULKAN_HPP_NOEXCEPT
    {
      bufferAddress = bufferAddress_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BindIndexBufferIndirectCommandNV & setSize( uint32_t size_ ) VULKAN_HPP_NOEXCEPT
    {
      size = size_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BindIndexBufferIndirectCommandNV & setIndexType( IndexType indexType_ ) VULKAN_HPP_NOEXCEPT
    {
      indexType = indexType_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_SETTERS*/

    operator VkBindIndexBufferIndirectCommandNV const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkBindIndexBufferIndirectCommandNV *>( this );
    }

    operator VkBindIndexBufferIndirectCommandNV &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkBindIndexBufferIndirectCommandNV *>( this );
    }

    operator VkBindIndexBufferIndirectCommandNV const *() const VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<const VkBindIndexBufferIndirectCommandNV *>( this );
    }

    operator VkBindIndexBufferIndirectCommandNV *() VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<VkBindIndexBufferIndirectCommandNV *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<DeviceAddress const &, uint32_t const &, IndexType const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( bufferAddress, size, indexType );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( BindIndexBufferIndirectCommandNV const & ) const = default;
#else
    bool operator==( BindIndexBufferIndirectCommandNV const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( bufferAddress == rhs.bufferAddress ) && ( size == rhs.size ) && ( indexType == rhs.indexType );
#  endif
    }

    bool operator!=( BindIndexBufferIndirectCommandNV const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    DeviceAddress bufferAddress = {};
    uint32_t      size          = {};
    IndexType     indexType     = IndexType::eUint16;
  };

  // wrapper struct for struct VkBindMemoryStatus, see https://registry.khronos.org/vulkan/specs/latest/man/html/VkBindMemoryStatus.html
  struct BindMemoryStatus
  {
    using NativeType = VkBindMemoryStatus;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eBindMemoryStatus;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR BindMemoryStatus( Result * pResult_ = {}, const void * pNext_ = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , pResult{ pResult_ }
    {
    }

    VULKAN_HPP_CONSTEXPR BindMemoryStatus( BindMemoryStatus const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    BindMemoryStatus( VkBindMemoryStatus const & rhs ) VULKAN_HPP_NOEXCEPT : BindMemoryStatus( *reinterpret_cast<BindMemoryStatus const *>( &rhs ) ) {}

    BindMemoryStatus & operator=( BindMemoryStatus const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    BindMemoryStatus & operator=( VkBindMemoryStatus const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<BindMemoryStatus const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 BindMemoryStatus & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BindMemoryStatus & setPResult( Result * pResult_ ) VULKAN_HPP_NOEXCEPT
    {
      pResult = pResult_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_SETTERS*/

    operator VkBindMemoryStatus const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkBindMemoryStatus *>( this );
    }

    operator VkBindMemoryStatus &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkBindMemoryStatus *>( this );
    }

    operator VkBindMemoryStatus const *() const VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<const VkBindMemoryStatus *>( this );
    }

    operator VkBindMemoryStatus *() VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<VkBindMemoryStatus *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<StructureType const &, const void * const &, Result * const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, pResult );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( BindMemoryStatus const & ) const = default;
#else
    bool operator==( BindMemoryStatus const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( pResult == rhs.pResult );
#  endif
    }

    bool operator!=( BindMemoryStatus const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    StructureType sType   = StructureType::eBindMemoryStatus;
    const void *  pNext   = {};
    Result *      pResult = {};
  };

  template <>
  struct CppType<StructureType, StructureType::eBindMemoryStatus>
  {
    using Type = BindMemoryStatus;
  };

  using BindMemoryStatusKHR = BindMemoryStatus;

  // wrapper struct for struct VkBindPipelineIndirectCommandNV, see
  // https://registry.khronos.org/vulkan/specs/latest/man/html/VkBindPipelineIndirectCommandNV.html
  struct BindPipelineIndirectCommandNV
  {
    using NativeType = VkBindPipelineIndirectCommandNV;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR BindPipelineIndirectCommandNV( DeviceAddress pipelineAddress_ = {} ) VULKAN_HPP_NOEXCEPT : pipelineAddress{ pipelineAddress_ } {}

    VULKAN_HPP_CONSTEXPR BindPipelineIndirectCommandNV( BindPipelineIndirectCommandNV const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    BindPipelineIndirectCommandNV( VkBindPipelineIndirectCommandNV const & rhs ) VULKAN_HPP_NOEXCEPT
      : BindPipelineIndirectCommandNV( *reinterpret_cast<BindPipelineIndirectCommandNV const *>( &rhs ) )
    {
    }

    BindPipelineIndirectCommandNV & operator=( BindPipelineIndirectCommandNV const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    BindPipelineIndirectCommandNV & operator=( VkBindPipelineIndirectCommandNV const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<BindPipelineIndirectCommandNV const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 BindPipelineIndirectCommandNV & setPipelineAddress( DeviceAddress pipelineAddress_ ) VULKAN_HPP_NOEXCEPT
    {
      pipelineAddress = pipelineAddress_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_SETTERS*/

    operator VkBindPipelineIndirectCommandNV const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkBindPipelineIndirectCommandNV *>( this );
    }

    operator VkBindPipelineIndirectCommandNV &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkBindPipelineIndirectCommandNV *>( this );
    }

    operator VkBindPipelineIndirectCommandNV const *() const VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<const VkBindPipelineIndirectCommandNV *>( this );
    }

    operator VkBindPipelineIndirectCommandNV *() VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<VkBindPipelineIndirectCommandNV *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<DeviceAddress const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( pipelineAddress );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( BindPipelineIndirectCommandNV const & ) const = default;
#else
    bool operator==( BindPipelineIndirectCommandNV const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( pipelineAddress == rhs.pipelineAddress );
#  endif
    }

    bool operator!=( BindPipelineIndirectCommandNV const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    DeviceAddress pipelineAddress = {};
  };

  // wrapper struct for struct VkBindShaderGroupIndirectCommandNV, see
  // https://registry.khronos.org/vulkan/specs/latest/man/html/VkBindShaderGroupIndirectCommandNV.html
  struct BindShaderGroupIndirectCommandNV
  {
    using NativeType = VkBindShaderGroupIndirectCommandNV;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR BindShaderGroupIndirectCommandNV( uint32_t groupIndex_ = {} ) VULKAN_HPP_NOEXCEPT : groupIndex{ groupIndex_ } {}

    VULKAN_HPP_CONSTEXPR BindShaderGroupIndirectCommandNV( BindShaderGroupIndirectCommandNV const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    BindShaderGroupIndirectCommandNV( VkBindShaderGroupIndirectCommandNV const & rhs ) VULKAN_HPP_NOEXCEPT
      : BindShaderGroupIndirectCommandNV( *reinterpret_cast<BindShaderGroupIndirectCommandNV const *>( &rhs ) )
    {
    }

    BindShaderGroupIndirectCommandNV & operator=( BindShaderGroupIndirectCommandNV const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    BindShaderGroupIndirectCommandNV & operator=( VkBindShaderGroupIndirectCommandNV const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<BindShaderGroupIndirectCommandNV const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 BindShaderGroupIndirectCommandNV & setGroupIndex( uint32_t groupIndex_ ) VULKAN_HPP_NOEXCEPT
    {
      groupIndex = groupIndex_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_SETTERS*/

    operator VkBindShaderGroupIndirectCommandNV const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkBindShaderGroupIndirectCommandNV *>( this );
    }

    operator VkBindShaderGroupIndirectCommandNV &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkBindShaderGroupIndirectCommandNV *>( this );
    }

    operator VkBindShaderGroupIndirectCommandNV const *() const VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<const VkBindShaderGroupIndirectCommandNV *>( this );
    }

    operator VkBindShaderGroupIndirectCommandNV *() VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<VkBindShaderGroupIndirectCommandNV *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<uint32_t const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( groupIndex );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( BindShaderGroupIndirectCommandNV const & ) const = default;
#else
    bool operator==( BindShaderGroupIndirectCommandNV const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( groupIndex == rhs.groupIndex );
#  endif
    }

    bool operator!=( BindShaderGroupIndirectCommandNV const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    uint32_t groupIndex = {};
  };

  // wrapper struct for struct VkSparseMemoryBind, see https://registry.khronos.org/vulkan/specs/latest/man/html/VkSparseMemoryBind.html
  struct SparseMemoryBind
  {
    using NativeType = VkSparseMemoryBind;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR SparseMemoryBind( DeviceSize            resourceOffset_ = {},
                                           DeviceSize            size_           = {},
                                           DeviceMemory          memory_         = {},
                                           DeviceSize            memoryOffset_   = {},
                                           SparseMemoryBindFlags flags_          = {} ) VULKAN_HPP_NOEXCEPT
      : resourceOffset{ resourceOffset_ }
      , size{ size_ }
      , memory{ memory_ }
      , memoryOffset{ memoryOffset_ }
      , flags{ flags_ }
    {
    }

    VULKAN_HPP_CONSTEXPR SparseMemoryBind( SparseMemoryBind const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    SparseMemoryBind( VkSparseMemoryBind const & rhs ) VULKAN_HPP_NOEXCEPT : SparseMemoryBind( *reinterpret_cast<SparseMemoryBind const *>( &rhs ) ) {}

    SparseMemoryBind & operator=( SparseMemoryBind const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    SparseMemoryBind & operator=( VkSparseMemoryBind const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<SparseMemoryBind const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 SparseMemoryBind & setResourceOffset( DeviceSize resourceOffset_ ) VULKAN_HPP_NOEXCEPT
    {
      resourceOffset = resourceOffset_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 SparseMemoryBind & setSize( DeviceSize size_ ) VULKAN_HPP_NOEXCEPT
    {
      size = size_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 SparseMemoryBind & setMemory( DeviceMemory memory_ ) VULKAN_HPP_NOEXCEPT
    {
      memory = memory_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 SparseMemoryBind & setMemoryOffset( DeviceSize memoryOffset_ ) VULKAN_HPP_NOEXCEPT
    {
      memoryOffset = memoryOffset_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 SparseMemoryBind & setFlags( SparseMemoryBindFlags flags_ ) VULKAN_HPP_NOEXCEPT
    {
      flags = flags_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_SETTERS*/

    operator VkSparseMemoryBind const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkSparseMemoryBind *>( this );
    }

    operator VkSparseMemoryBind &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkSparseMemoryBind *>( this );
    }

    operator VkSparseMemoryBind const *() const VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<const VkSparseMemoryBind *>( this );
    }

    operator VkSparseMemoryBind *() VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<VkSparseMemoryBind *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<DeviceSize const &, DeviceSize const &, DeviceMemory const &, DeviceSize const &, SparseMemoryBindFlags const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( resourceOffset, size, memory, memoryOffset, flags );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( SparseMemoryBind const & ) const = default;
#else
    bool operator==( SparseMemoryBind const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( resourceOffset == rhs.resourceOffset ) && ( size == rhs.size ) && ( memory == rhs.memory ) && ( memoryOffset == rhs.memoryOffset ) &&
             ( flags == rhs.flags );
#  endif
    }

    bool operator!=( SparseMemoryBind const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    DeviceSize            resourceOffset = {};
    DeviceSize            size           = {};
    DeviceMemory          memory         = {};
    DeviceSize            memoryOffset   = {};
    SparseMemoryBindFlags flags          = {};
  };

  // wrapper struct for struct VkSparseBufferMemoryBindInfo, see https://registry.khronos.org/vulkan/specs/latest/man/html/VkSparseBufferMemoryBindInfo.html
  struct SparseBufferMemoryBindInfo
  {
    using NativeType = VkSparseBufferMemoryBindInfo;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR SparseBufferMemoryBindInfo( Buffer buffer_ = {}, uint32_t bindCount_ = {}, const SparseMemoryBind * pBinds_ = {} ) VULKAN_HPP_NOEXCEPT
      : buffer{ buffer_ }
      , bindCount{ bindCount_ }
      , pBinds{ pBinds_ }
    {
    }

    VULKAN_HPP_CONSTEXPR SparseBufferMemoryBindInfo( SparseBufferMemoryBindInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    SparseBufferMemoryBindInfo( VkSparseBufferMemoryBindInfo const & rhs ) VULKAN_HPP_NOEXCEPT
      : SparseBufferMemoryBindInfo( *reinterpret_cast<SparseBufferMemoryBindInfo const *>( &rhs ) )
    {
    }

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    SparseBufferMemoryBindInfo( Buffer buffer_, ArrayProxyNoTemporaries<const SparseMemoryBind> const & binds_ )
      : buffer( buffer_ ), bindCount( static_cast<uint32_t>( binds_.size() ) ), pBinds( binds_.data() )
    {
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/

    SparseBufferMemoryBindInfo & operator=( SparseBufferMemoryBindInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    SparseBufferMemoryBindInfo & operator=( VkSparseBufferMemoryBindInfo const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<SparseBufferMemoryBindInfo const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 SparseBufferMemoryBindInfo & setBuffer( Buffer buffer_ ) VULKAN_HPP_NOEXCEPT
    {
      buffer = buffer_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 SparseBufferMemoryBindInfo & setBindCount( uint32_t bindCount_ ) VULKAN_HPP_NOEXCEPT
    {
      bindCount = bindCount_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 SparseBufferMemoryBindInfo & setPBinds( const SparseMemoryBind * pBinds_ ) VULKAN_HPP_NOEXCEPT
    {
      pBinds = pBinds_;
      return *this;
    }

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    SparseBufferMemoryBindInfo & setBinds( ArrayProxyNoTemporaries<const SparseMemoryBind> const & binds_ ) VULKAN_HPP_NOEXCEPT
    {
      bindCount = static_cast<uint32_t>( binds_.size() );
      pBinds    = binds_.data();
      return *this;
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/
#endif   /*VULKAN_HPP_NO_SETTERS*/

    operator VkSparseBufferMemoryBindInfo const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkSparseBufferMemoryBindInfo *>( this );
    }

    operator VkSparseBufferMemoryBindInfo &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkSparseBufferMemoryBindInfo *>( this );
    }

    operator VkSparseBufferMemoryBindInfo const *() const VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<const VkSparseBufferMemoryBindInfo *>( this );
    }

    operator VkSparseBufferMemoryBindInfo *() VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<VkSparseBufferMemoryBindInfo *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<Buffer const &, uint32_t const &, const SparseMemoryBind * const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( buffer, bindCount, pBinds );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( SparseBufferMemoryBindInfo const & ) const = default;
#else
    bool operator==( SparseBufferMemoryBindInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( buffer == rhs.buffer ) && ( bindCount == rhs.bindCount ) && ( pBinds == rhs.pBinds );
#  endif
    }

    bool operator!=( SparseBufferMemoryBindInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    Buffer                   buffer    = {};
    uint32_t                 bindCount = {};
    const SparseMemoryBind * pBinds    = {};
  };

  // wrapper struct for struct VkSparseImageOpaqueMemoryBindInfo, see
  // https://registry.khronos.org/vulkan/specs/latest/man/html/VkSparseImageOpaqueMemoryBindInfo.html
  struct SparseImageOpaqueMemoryBindInfo
  {
    using NativeType = VkSparseImageOpaqueMemoryBindInfo;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR
      SparseImageOpaqueMemoryBindInfo( Image image_ = {}, uint32_t bindCount_ = {}, const SparseMemoryBind * pBinds_ = {} ) VULKAN_HPP_NOEXCEPT
      : image{ image_ }
      , bindCount{ bindCount_ }
      , pBinds{ pBinds_ }
    {
    }

    VULKAN_HPP_CONSTEXPR SparseImageOpaqueMemoryBindInfo( SparseImageOpaqueMemoryBindInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    SparseImageOpaqueMemoryBindInfo( VkSparseImageOpaqueMemoryBindInfo const & rhs ) VULKAN_HPP_NOEXCEPT
      : SparseImageOpaqueMemoryBindInfo( *reinterpret_cast<SparseImageOpaqueMemoryBindInfo const *>( &rhs ) )
    {
    }

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    SparseImageOpaqueMemoryBindInfo( Image image_, ArrayProxyNoTemporaries<const SparseMemoryBind> const & binds_ )
      : image( image_ ), bindCount( static_cast<uint32_t>( binds_.size() ) ), pBinds( binds_.data() )
    {
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/

    SparseImageOpaqueMemoryBindInfo & operator=( SparseImageOpaqueMemoryBindInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    SparseImageOpaqueMemoryBindInfo & operator=( VkSparseImageOpaqueMemoryBindInfo const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<SparseImageOpaqueMemoryBindInfo const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 SparseImageOpaqueMemoryBindInfo & setImage( Image image_ ) VULKAN_HPP_NOEXCEPT
    {
      image = image_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 SparseImageOpaqueMemoryBindInfo & setBindCount( uint32_t bindCount_ ) VULKAN_HPP_NOEXCEPT
    {
      bindCount = bindCount_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 SparseImageOpaqueMemoryBindInfo & setPBinds( const SparseMemoryBind * pBinds_ ) VULKAN_HPP_NOEXCEPT
    {
      pBinds = pBinds_;
      return *this;
    }

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    SparseImageOpaqueMemoryBindInfo & setBinds( ArrayProxyNoTemporaries<const SparseMemoryBind> const & binds_ ) VULKAN_HPP_NOEXCEPT
    {
      bindCount = static_cast<uint32_t>( binds_.size() );
      pBinds    = binds_.data();
      return *this;
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/
#endif   /*VULKAN_HPP_NO_SETTERS*/

    operator VkSparseImageOpaqueMemoryBindInfo const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkSparseImageOpaqueMemoryBindInfo *>( this );
    }

    operator VkSparseImageOpaqueMemoryBindInfo &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkSparseImageOpaqueMemoryBindInfo *>( this );
    }

    operator VkSparseImageOpaqueMemoryBindInfo const *() const VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<const VkSparseImageOpaqueMemoryBindInfo *>( this );
    }

    operator VkSparseImageOpaqueMemoryBindInfo *() VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<VkSparseImageOpaqueMemoryBindInfo *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<Image const &, uint32_t const &, const SparseMemoryBind * const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( image, bindCount, pBinds );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( SparseImageOpaqueMemoryBindInfo const & ) const = default;
#else
    bool operator==( SparseImageOpaqueMemoryBindInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( image == rhs.image ) && ( bindCount == rhs.bindCount ) && ( pBinds == rhs.pBinds );
#  endif
    }

    bool operator!=( SparseImageOpaqueMemoryBindInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    Image                    image     = {};
    uint32_t                 bindCount = {};
    const SparseMemoryBind * pBinds    = {};
  };

  // wrapper struct for struct VkImageSubresource, see https://registry.khronos.org/vulkan/specs/latest/man/html/VkImageSubresource.html
  struct ImageSubresource
  {
    using NativeType = VkImageSubresource;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR ImageSubresource( ImageAspectFlags aspectMask_ = {}, uint32_t mipLevel_ = {}, uint32_t arrayLayer_ = {} ) VULKAN_HPP_NOEXCEPT
      : aspectMask{ aspectMask_ }
      , mipLevel{ mipLevel_ }
      , arrayLayer{ arrayLayer_ }
    {
    }

    VULKAN_HPP_CONSTEXPR ImageSubresource( ImageSubresource const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    ImageSubresource( VkImageSubresource const & rhs ) VULKAN_HPP_NOEXCEPT : ImageSubresource( *reinterpret_cast<ImageSubresource const *>( &rhs ) ) {}

    ImageSubresource & operator=( ImageSubresource const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    ImageSubresource & operator=( VkImageSubresource const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<ImageSubresource const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 ImageSubresource & setAspectMask( ImageAspectFlags aspectMask_ ) VULKAN_HPP_NOEXCEPT
    {
      aspectMask = aspectMask_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ImageSubresource & setMipLevel( uint32_t mipLevel_ ) VULKAN_HPP_NOEXCEPT
    {
      mipLevel = mipLevel_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ImageSubresource & setArrayLayer( uint32_t arrayLayer_ ) VULKAN_HPP_NOEXCEPT
    {
      arrayLayer = arrayLayer_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_SETTERS*/

    operator VkImageSubresource const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkImageSubresource *>( this );
    }

    operator VkImageSubresource &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkImageSubresource *>( this );
    }

    operator VkImageSubresource const *() const VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<const VkImageSubresource *>( this );
    }

    operator VkImageSubresource *() VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<VkImageSubresource *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<ImageAspectFlags const &, uint32_t const &, uint32_t const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( aspectMask, mipLevel, arrayLayer );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( ImageSubresource const & ) const = default;
#else
    bool operator==( ImageSubresource const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( aspectMask == rhs.aspectMask ) && ( mipLevel == rhs.mipLevel ) && ( arrayLayer == rhs.arrayLayer );
#  endif
    }

    bool operator!=( ImageSubresource const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    ImageAspectFlags aspectMask = {};
    uint32_t         mipLevel   = {};
    uint32_t         arrayLayer = {};
  };

  // wrapper struct for struct VkOffset3D, see https://registry.khronos.org/vulkan/specs/latest/man/html/VkOffset3D.html
  struct Offset3D
  {
    using NativeType = VkOffset3D;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR Offset3D( int32_t x_ = {}, int32_t y_ = {}, int32_t z_ = {} ) VULKAN_HPP_NOEXCEPT
      : x{ x_ }
      , y{ y_ }
      , z{ z_ }
    {
    }

    VULKAN_HPP_CONSTEXPR Offset3D( Offset3D const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    Offset3D( VkOffset3D const & rhs ) VULKAN_HPP_NOEXCEPT : Offset3D( *reinterpret_cast<Offset3D const *>( &rhs ) ) {}

    explicit Offset3D( Offset2D const & offset2D, int32_t z_ = {} ) : x( offset2D.x ), y( offset2D.y ), z( z_ ) {}

    Offset3D & operator=( Offset3D const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    Offset3D & operator=( VkOffset3D const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<Offset3D const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 Offset3D & setX( int32_t x_ ) VULKAN_HPP_NOEXCEPT
    {
      x = x_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 Offset3D & setY( int32_t y_ ) VULKAN_HPP_NOEXCEPT
    {
      y = y_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 Offset3D & setZ( int32_t z_ ) VULKAN_HPP_NOEXCEPT
    {
      z = z_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_SETTERS*/

    operator VkOffset3D const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkOffset3D *>( this );
    }

    operator VkOffset3D &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkOffset3D *>( this );
    }

    operator VkOffset3D const *() const VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<const VkOffset3D *>( this );
    }

    operator VkOffset3D *() VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<VkOffset3D *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<int32_t const &, int32_t const &, int32_t const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( x, y, z );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( Offset3D const & ) const = default;
#else
    bool operator==( Offset3D const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( x == rhs.x ) && ( y == rhs.y ) && ( z == rhs.z );
#  endif
    }

    bool operator!=( Offset3D const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    int32_t x = {};
    int32_t y = {};
    int32_t z = {};
  };

  // wrapper struct for struct VkExtent3D, see https://registry.khronos.org/vulkan/specs/latest/man/html/VkExtent3D.html
  struct Extent3D
  {
    using NativeType = VkExtent3D;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR Extent3D( uint32_t width_ = {}, uint32_t height_ = {}, uint32_t depth_ = {} ) VULKAN_HPP_NOEXCEPT
      : width{ width_ }
      , height{ height_ }
      , depth{ depth_ }
    {
    }

    VULKAN_HPP_CONSTEXPR Extent3D( Extent3D const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    Extent3D( VkExtent3D const & rhs ) VULKAN_HPP_NOEXCEPT : Extent3D( *reinterpret_cast<Extent3D const *>( &rhs ) ) {}

    explicit Extent3D( Extent2D const & extent2D, uint32_t depth_ = {} ) : width( extent2D.width ), height( extent2D.height ), depth( depth_ ) {}

    Extent3D & operator=( Extent3D const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    Extent3D & operator=( VkExtent3D const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<Extent3D const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 Extent3D & setWidth( uint32_t width_ ) VULKAN_HPP_NOEXCEPT
    {
      width = width_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 Extent3D & setHeight( uint32_t height_ ) VULKAN_HPP_NOEXCEPT
    {
      height = height_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 Extent3D & setDepth( uint32_t depth_ ) VULKAN_HPP_NOEXCEPT
    {
      depth = depth_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_SETTERS*/

    operator VkExtent3D const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkExtent3D *>( this );
    }

    operator VkExtent3D &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkExtent3D *>( this );
    }

    operator VkExtent3D const *() const VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<const VkExtent3D *>( this );
    }

    operator VkExtent3D *() VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<VkExtent3D *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<uint32_t const &, uint32_t const &, uint32_t const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( width, height, depth );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( Extent3D const & ) const = default;
#else
    bool operator==( Extent3D const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( width == rhs.width ) && ( height == rhs.height ) && ( depth == rhs.depth );
#  endif
    }

    bool operator!=( Extent3D const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    uint32_t width  = {};
    uint32_t height = {};
    uint32_t depth  = {};
  };

  // wrapper struct for struct VkSparseImageMemoryBind, see https://registry.khronos.org/vulkan/specs/latest/man/html/VkSparseImageMemoryBind.html
  struct SparseImageMemoryBind
  {
    using NativeType = VkSparseImageMemoryBind;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR SparseImageMemoryBind( ImageSubresource      subresource_  = {},
                                                Offset3D              offset_       = {},
                                                Extent3D              extent_       = {},
                                                DeviceMemory          memory_       = {},
                                                DeviceSize            memoryOffset_ = {},
                                                SparseMemoryBindFlags flags_        = {} ) VULKAN_HPP_NOEXCEPT
      : subresource{ subresource_ }
      , offset{ offset_ }
      , extent{ extent_ }
      , memory{ memory_ }
      , memoryOffset{ memoryOffset_ }
      , flags{ flags_ }
    {
    }

    VULKAN_HPP_CONSTEXPR SparseImageMemoryBind( SparseImageMemoryBind const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    SparseImageMemoryBind( VkSparseImageMemoryBind const & rhs ) VULKAN_HPP_NOEXCEPT
      : SparseImageMemoryBind( *reinterpret_cast<SparseImageMemoryBind const *>( &rhs ) )
    {
    }

    SparseImageMemoryBind & operator=( SparseImageMemoryBind const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    SparseImageMemoryBind & operator=( VkSparseImageMemoryBind const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<SparseImageMemoryBind const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 SparseImageMemoryBind & setSubresource( ImageSubresource const & subresource_ ) VULKAN_HPP_NOEXCEPT
    {
      subresource = subresource_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 SparseImageMemoryBind & setOffset( Offset3D const & offset_ ) VULKAN_HPP_NOEXCEPT
    {
      offset = offset_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 SparseImageMemoryBind & setExtent( Extent3D const & extent_ ) VULKAN_HPP_NOEXCEPT
    {
      extent = extent_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 SparseImageMemoryBind & setMemory( DeviceMemory memory_ ) VULKAN_HPP_NOEXCEPT
    {
      memory = memory_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 SparseImageMemoryBind & setMemoryOffset( DeviceSize memoryOffset_ ) VULKAN_HPP_NOEXCEPT
    {
      memoryOffset = memoryOffset_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 SparseImageMemoryBind & setFlags( SparseMemoryBindFlags flags_ ) VULKAN_HPP_NOEXCEPT
    {
      flags = flags_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_SETTERS*/

    operator VkSparseImageMemoryBind const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkSparseImageMemoryBind *>( this );
    }

    operator VkSparseImageMemoryBind &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkSparseImageMemoryBind *>( this );
    }

    operator VkSparseImageMemoryBind const *() const VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<const VkSparseImageMemoryBind *>( this );
    }

    operator VkSparseImageMemoryBind *() VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<VkSparseImageMemoryBind *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<ImageSubresource const &, Offset3D const &, Extent3D const &, DeviceMemory const &, DeviceSize const &, SparseMemoryBindFlags const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( subresource, offset, extent, memory, memoryOffset, flags );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( SparseImageMemoryBind const & ) const = default;
#else
    bool operator==( SparseImageMemoryBind const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( subresource == rhs.subresource ) && ( offset == rhs.offset ) && ( extent == rhs.extent ) && ( memory == rhs.memory ) &&
             ( memoryOffset == rhs.memoryOffset ) && ( flags == rhs.flags );
#  endif
    }

    bool operator!=( SparseImageMemoryBind const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    ImageSubresource      subresource  = {};
    Offset3D              offset       = {};
    Extent3D              extent       = {};
    DeviceMemory          memory       = {};
    DeviceSize            memoryOffset = {};
    SparseMemoryBindFlags flags        = {};
  };

  // wrapper struct for struct VkSparseImageMemoryBindInfo, see https://registry.khronos.org/vulkan/specs/latest/man/html/VkSparseImageMemoryBindInfo.html
  struct SparseImageMemoryBindInfo
  {
    using NativeType = VkSparseImageMemoryBindInfo;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR
      SparseImageMemoryBindInfo( Image image_ = {}, uint32_t bindCount_ = {}, const SparseImageMemoryBind * pBinds_ = {} ) VULKAN_HPP_NOEXCEPT
      : image{ image_ }
      , bindCount{ bindCount_ }
      , pBinds{ pBinds_ }
    {
    }

    VULKAN_HPP_CONSTEXPR SparseImageMemoryBindInfo( SparseImageMemoryBindInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    SparseImageMemoryBindInfo( VkSparseImageMemoryBindInfo const & rhs ) VULKAN_HPP_NOEXCEPT
      : SparseImageMemoryBindInfo( *reinterpret_cast<SparseImageMemoryBindInfo const *>( &rhs ) )
    {
    }

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    SparseImageMemoryBindInfo( Image image_, ArrayProxyNoTemporaries<const SparseImageMemoryBind> const & binds_ )
      : image( image_ ), bindCount( static_cast<uint32_t>( binds_.size() ) ), pBinds( binds_.data() )
    {
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/

    SparseImageMemoryBindInfo & operator=( SparseImageMemoryBindInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    SparseImageMemoryBindInfo & operator=( VkSparseImageMemoryBindInfo const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<SparseImageMemoryBindInfo const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 SparseImageMemoryBindInfo & setImage( Image image_ ) VULKAN_HPP_NOEXCEPT
    {
      image = image_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 SparseImageMemoryBindInfo & setBindCount( uint32_t bindCount_ ) VULKAN_HPP_NOEXCEPT
    {
      bindCount = bindCount_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 SparseImageMemoryBindInfo & setPBinds( const SparseImageMemoryBind * pBinds_ ) VULKAN_HPP_NOEXCEPT
    {
      pBinds = pBinds_;
      return *this;
    }

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    SparseImageMemoryBindInfo & setBinds( ArrayProxyNoTemporaries<const SparseImageMemoryBind> const & binds_ ) VULKAN_HPP_NOEXCEPT
    {
      bindCount = static_cast<uint32_t>( binds_.size() );
      pBinds    = binds_.data();
      return *this;
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/
#endif   /*VULKAN_HPP_NO_SETTERS*/

    operator VkSparseImageMemoryBindInfo const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkSparseImageMemoryBindInfo *>( this );
    }

    operator VkSparseImageMemoryBindInfo &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkSparseImageMemoryBindInfo *>( this );
    }

    operator VkSparseImageMemoryBindInfo const *() const VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<const VkSparseImageMemoryBindInfo *>( this );
    }

    operator VkSparseImageMemoryBindInfo *() VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<VkSparseImageMemoryBindInfo *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<Image const &, uint32_t const &, const SparseImageMemoryBind * const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( image, bindCount, pBinds );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( SparseImageMemoryBindInfo const & ) const = default;
#else
    bool operator==( SparseImageMemoryBindInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( image == rhs.image ) && ( bindCount == rhs.bindCount ) && ( pBinds == rhs.pBinds );
#  endif
    }

    bool operator!=( SparseImageMemoryBindInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    Image                         image     = {};
    uint32_t                      bindCount = {};
    const SparseImageMemoryBind * pBinds    = {};
  };

  // wrapper struct for struct VkBindSparseInfo, see https://registry.khronos.org/vulkan/specs/latest/man/html/VkBindSparseInfo.html
  struct BindSparseInfo
  {
    using NativeType = VkBindSparseInfo;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eBindSparseInfo;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR BindSparseInfo( uint32_t                                waitSemaphoreCount_   = {},
                                         const Semaphore *                       pWaitSemaphores_      = {},
                                         uint32_t                                bufferBindCount_      = {},
                                         const SparseBufferMemoryBindInfo *      pBufferBinds_         = {},
                                         uint32_t                                imageOpaqueBindCount_ = {},
                                         const SparseImageOpaqueMemoryBindInfo * pImageOpaqueBinds_    = {},
                                         uint32_t                                imageBindCount_       = {},
                                         const SparseImageMemoryBindInfo *       pImageBinds_          = {},
                                         uint32_t                                signalSemaphoreCount_ = {},
                                         const Semaphore *                       pSignalSemaphores_    = {},
                                         const void *                            pNext_                = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , waitSemaphoreCount{ waitSemaphoreCount_ }
      , pWaitSemaphores{ pWaitSemaphores_ }
      , bufferBindCount{ bufferBindCount_ }
      , pBufferBinds{ pBufferBinds_ }
      , imageOpaqueBindCount{ imageOpaqueBindCount_ }
      , pImageOpaqueBinds{ pImageOpaqueBinds_ }
      , imageBindCount{ imageBindCount_ }
      , pImageBinds{ pImageBinds_ }
      , signalSemaphoreCount{ signalSemaphoreCount_ }
      , pSignalSemaphores{ pSignalSemaphores_ }
    {
    }

    VULKAN_HPP_CONSTEXPR BindSparseInfo( BindSparseInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    BindSparseInfo( VkBindSparseInfo const & rhs ) VULKAN_HPP_NOEXCEPT : BindSparseInfo( *reinterpret_cast<BindSparseInfo const *>( &rhs ) ) {}

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    BindSparseInfo( ArrayProxyNoTemporaries<const Semaphore> const &                       waitSemaphores_,
                    ArrayProxyNoTemporaries<const SparseBufferMemoryBindInfo> const &      bufferBinds_      = {},
                    ArrayProxyNoTemporaries<const SparseImageOpaqueMemoryBindInfo> const & imageOpaqueBinds_ = {},
                    ArrayProxyNoTemporaries<const SparseImageMemoryBindInfo> const &       imageBinds_       = {},
                    ArrayProxyNoTemporaries<const Semaphore> const &                       signalSemaphores_ = {},
                    const void *                                                           pNext_            = nullptr )
      : pNext( pNext_ )
      , waitSemaphoreCount( static_cast<uint32_t>( waitSemaphores_.size() ) )
      , pWaitSemaphores( waitSemaphores_.data() )
      , bufferBindCount( static_cast<uint32_t>( bufferBinds_.size() ) )
      , pBufferBinds( bufferBinds_.data() )
      , imageOpaqueBindCount( static_cast<uint32_t>( imageOpaqueBinds_.size() ) )
      , pImageOpaqueBinds( imageOpaqueBinds_.data() )
      , imageBindCount( static_cast<uint32_t>( imageBinds_.size() ) )
      , pImageBinds( imageBinds_.data() )
      , signalSemaphoreCount( static_cast<uint32_t>( signalSemaphores_.size() ) )
      , pSignalSemaphores( signalSemaphores_.data() )
    {
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/

    BindSparseInfo & operator=( BindSparseInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    BindSparseInfo & operator=( VkBindSparseInfo const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<BindSparseInfo const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 BindSparseInfo & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BindSparseInfo & setWaitSemaphoreCount( uint32_t waitSemaphoreCount_ ) VULKAN_HPP_NOEXCEPT
    {
      waitSemaphoreCount = waitSemaphoreCount_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BindSparseInfo & setPWaitSemaphores( const Semaphore * pWaitSemaphores_ ) VULKAN_HPP_NOEXCEPT
    {
      pWaitSemaphores = pWaitSemaphores_;
      return *this;
    }

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    BindSparseInfo & setWaitSemaphores( ArrayProxyNoTemporaries<const Semaphore> const & waitSemaphores_ ) VULKAN_HPP_NOEXCEPT
    {
      waitSemaphoreCount = static_cast<uint32_t>( waitSemaphores_.size() );
      pWaitSemaphores    = waitSemaphores_.data();
      return *this;
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/

    VULKAN_HPP_CONSTEXPR_14 BindSparseInfo & setBufferBindCount( uint32_t bufferBindCount_ ) VULKAN_HPP_NOEXCEPT
    {
      bufferBindCount = bufferBindCount_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BindSparseInfo & setPBufferBinds( const SparseBufferMemoryBindInfo * pBufferBinds_ ) VULKAN_HPP_NOEXCEPT
    {
      pBufferBinds = pBufferBinds_;
      return *this;
    }

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    BindSparseInfo & setBufferBinds( ArrayProxyNoTemporaries<const SparseBufferMemoryBindInfo> const & bufferBinds_ ) VULKAN_HPP_NOEXCEPT
    {
      bufferBindCount = static_cast<uint32_t>( bufferBinds_.size() );
      pBufferBinds    = bufferBinds_.data();
      return *this;
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/

    VULKAN_HPP_CONSTEXPR_14 BindSparseInfo & setImageOpaqueBindCount( uint32_t imageOpaqueBindCount_ ) VULKAN_HPP_NOEXCEPT
    {
      imageOpaqueBindCount = imageOpaqueBindCount_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BindSparseInfo & setPImageOpaqueBinds( const SparseImageOpaqueMemoryBindInfo * pImageOpaqueBinds_ ) VULKAN_HPP_NOEXCEPT
    {
      pImageOpaqueBinds = pImageOpaqueBinds_;
      return *this;
    }

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    BindSparseInfo & setImageOpaqueBinds( ArrayProxyNoTemporaries<const SparseImageOpaqueMemoryBindInfo> const & imageOpaqueBinds_ ) VULKAN_HPP_NOEXCEPT
    {
      imageOpaqueBindCount = static_cast<uint32_t>( imageOpaqueBinds_.size() );
      pImageOpaqueBinds    = imageOpaqueBinds_.data();
      return *this;
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/

    VULKAN_HPP_CONSTEXPR_14 BindSparseInfo & setImageBindCount( uint32_t imageBindCount_ ) VULKAN_HPP_NOEXCEPT
    {
      imageBindCount = imageBindCount_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BindSparseInfo & setPImageBinds( const SparseImageMemoryBindInfo * pImageBinds_ ) VULKAN_HPP_NOEXCEPT
    {
      pImageBinds = pImageBinds_;
      return *this;
    }

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    BindSparseInfo & setImageBinds( ArrayProxyNoTemporaries<const SparseImageMemoryBindInfo> const & imageBinds_ ) VULKAN_HPP_NOEXCEPT
    {
      imageBindCount = static_cast<uint32_t>( imageBinds_.size() );
      pImageBinds    = imageBinds_.data();
      return *this;
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/

    VULKAN_HPP_CONSTEXPR_14 BindSparseInfo & setSignalSemaphoreCount( uint32_t signalSemaphoreCount_ ) VULKAN_HPP_NOEXCEPT
    {
      signalSemaphoreCount = signalSemaphoreCount_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BindSparseInfo & setPSignalSemaphores( const Semaphore * pSignalSemaphores_ ) VULKAN_HPP_NOEXCEPT
    {
      pSignalSemaphores = pSignalSemaphores_;
      return *this;
    }

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    BindSparseInfo & setSignalSemaphores( ArrayProxyNoTemporaries<const Semaphore> const & signalSemaphores_ ) VULKAN_HPP_NOEXCEPT
    {
      signalSemaphoreCount = static_cast<uint32_t>( signalSemaphores_.size() );
      pSignalSemaphores    = signalSemaphores_.data();
      return *this;
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/
#endif   /*VULKAN_HPP_NO_SETTERS*/

    operator VkBindSparseInfo const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkBindSparseInfo *>( this );
    }

    operator VkBindSparseInfo &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkBindSparseInfo *>( this );
    }

    operator VkBindSparseInfo const *() const VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<const VkBindSparseInfo *>( this );
    }

    operator VkBindSparseInfo *() VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<VkBindSparseInfo *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<StructureType const &,
               const void * const &,
               uint32_t const &,
               const Semaphore * const &,
               uint32_t const &,
               const SparseBufferMemoryBindInfo * const &,
               uint32_t const &,
               const SparseImageOpaqueMemoryBindInfo * const &,
               uint32_t const &,
               const SparseImageMemoryBindInfo * const &,
               uint32_t const &,
               const Semaphore * const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType,
                       pNext,
                       waitSemaphoreCount,
                       pWaitSemaphores,
                       bufferBindCount,
                       pBufferBinds,
                       imageOpaqueBindCount,
                       pImageOpaqueBinds,
                       imageBindCount,
                       pImageBinds,
                       signalSemaphoreCount,
                       pSignalSemaphores );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( BindSparseInfo const & ) const = default;
#else
    bool operator==( BindSparseInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( waitSemaphoreCount == rhs.waitSemaphoreCount ) &&
             ( pWaitSemaphores == rhs.pWaitSemaphores ) && ( bufferBindCount == rhs.bufferBindCount ) && ( pBufferBinds == rhs.pBufferBinds ) &&
             ( imageOpaqueBindCount == rhs.imageOpaqueBindCount ) && ( pImageOpaqueBinds == rhs.pImageOpaqueBinds ) &&
             ( imageBindCount == rhs.imageBindCount ) && ( pImageBinds == rhs.pImageBinds ) && ( signalSemaphoreCount == rhs.signalSemaphoreCount ) &&
             ( pSignalSemaphores == rhs.pSignalSemaphores );
#  endif
    }

    bool operator!=( BindSparseInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    StructureType                           sType                = StructureType::eBindSparseInfo;
    const void *                            pNext                = {};
    uint32_t                                waitSemaphoreCount   = {};
    const Semaphore *                       pWaitSemaphores      = {};
    uint32_t                                bufferBindCount      = {};
    const SparseBufferMemoryBindInfo *      pBufferBinds         = {};
    uint32_t                                imageOpaqueBindCount = {};
    const SparseImageOpaqueMemoryBindInfo * pImageOpaqueBinds    = {};
    uint32_t                                imageBindCount       = {};
    const SparseImageMemoryBindInfo *       pImageBinds          = {};
    uint32_t                                signalSemaphoreCount = {};
    const Semaphore *                       pSignalSemaphores    = {};
  };

  template <>
  struct CppType<StructureType, StructureType::eBindSparseInfo>
  {
    using Type = BindSparseInfo;
  };

  // wrapper struct for struct VkBindTensorMemoryInfoARM, see https://registry.khronos.org/vulkan/specs/latest/man/html/VkBindTensorMemoryInfoARM.html
  struct BindTensorMemoryInfoARM
  {
    using NativeType = VkBindTensorMemoryInfoARM;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eBindTensorMemoryInfoARM;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR BindTensorMemoryInfoARM( TensorARM    tensor_       = {},
                                                  DeviceMemory memory_       = {},
                                                  DeviceSize   memoryOffset_ = {},
                                                  const void * pNext_        = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , tensor{ tensor_ }
      , memory{ memory_ }
      , memoryOffset{ memoryOffset_ }
    {
    }

    VULKAN_HPP_CONSTEXPR BindTensorMemoryInfoARM( BindTensorMemoryInfoARM const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    BindTensorMemoryInfoARM( VkBindTensorMemoryInfoARM const & rhs ) VULKAN_HPP_NOEXCEPT
      : BindTensorMemoryInfoARM( *reinterpret_cast<BindTensorMemoryInfoARM const *>( &rhs ) )
    {
    }

    BindTensorMemoryInfoARM & operator=( BindTensorMemoryInfoARM const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    BindTensorMemoryInfoARM & operator=( VkBindTensorMemoryInfoARM const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<BindTensorMemoryInfoARM const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 BindTensorMemoryInfoARM & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BindTensorMemoryInfoARM & setTensor( TensorARM tensor_ ) VULKAN_HPP_NOEXCEPT
    {
      tensor = tensor_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BindTensorMemoryInfoARM & setMemory( DeviceMemory memory_ ) VULKAN_HPP_NOEXCEPT
    {
      memory = memory_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BindTensorMemoryInfoARM & setMemoryOffset( DeviceSize memoryOffset_ ) VULKAN_HPP_NOEXCEPT
    {
      memoryOffset = memoryOffset_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_SETTERS*/

    operator VkBindTensorMemoryInfoARM const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkBindTensorMemoryInfoARM *>( this );
    }

    operator VkBindTensorMemoryInfoARM &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkBindTensorMemoryInfoARM *>( this );
    }

    operator VkBindTensorMemoryInfoARM const *() const VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<const VkBindTensorMemoryInfoARM *>( this );
    }

    operator VkBindTensorMemoryInfoARM *() VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<VkBindTensorMemoryInfoARM *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<StructureType const &, const void * const &, TensorARM const &, DeviceMemory const &, DeviceSize const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, tensor, memory, memoryOffset );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( BindTensorMemoryInfoARM const & ) const = default;
#else
    bool operator==( BindTensorMemoryInfoARM const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( tensor == rhs.tensor ) && ( memory == rhs.memory ) && ( memoryOffset == rhs.memoryOffset );
#  endif
    }

    bool operator!=( BindTensorMemoryInfoARM const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    StructureType sType        = StructureType::eBindTensorMemoryInfoARM;
    const void *  pNext        = {};
    TensorARM     tensor       = {};
    DeviceMemory  memory       = {};
    DeviceSize    memoryOffset = {};
  };

  template <>
  struct CppType<StructureType, StructureType::eBindTensorMemoryInfoARM>
  {
    using Type = BindTensorMemoryInfoARM;
  };

  // wrapper struct for struct VkBindVertexBufferIndirectCommandEXT, see
  // https://registry.khronos.org/vulkan/specs/latest/man/html/VkBindVertexBufferIndirectCommandEXT.html
  struct BindVertexBufferIndirectCommandEXT
  {
    using NativeType = VkBindVertexBufferIndirectCommandEXT;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR BindVertexBufferIndirectCommandEXT( DeviceAddress bufferAddress_ = {}, uint32_t size_ = {}, uint32_t stride_ = {} ) VULKAN_HPP_NOEXCEPT
      : bufferAddress{ bufferAddress_ }
      , size{ size_ }
      , stride{ stride_ }
    {
    }

    VULKAN_HPP_CONSTEXPR BindVertexBufferIndirectCommandEXT( BindVertexBufferIndirectCommandEXT const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    BindVertexBufferIndirectCommandEXT( VkBindVertexBufferIndirectCommandEXT const & rhs ) VULKAN_HPP_NOEXCEPT
      : BindVertexBufferIndirectCommandEXT( *reinterpret_cast<BindVertexBufferIndirectCommandEXT const *>( &rhs ) )
    {
    }

    BindVertexBufferIndirectCommandEXT & operator=( BindVertexBufferIndirectCommandEXT const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    BindVertexBufferIndirectCommandEXT & operator=( VkBindVertexBufferIndirectCommandEXT const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<BindVertexBufferIndirectCommandEXT const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 BindVertexBufferIndirectCommandEXT & setBufferAddress( DeviceAddress bufferAddress_ ) VULKAN_HPP_NOEXCEPT
    {
      bufferAddress = bufferAddress_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BindVertexBufferIndirectCommandEXT & setSize( uint32_t size_ ) VULKAN_HPP_NOEXCEPT
    {
      size = size_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BindVertexBufferIndirectCommandEXT & setStride( uint32_t stride_ ) VULKAN_HPP_NOEXCEPT
    {
      stride = stride_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_SETTERS*/

    operator VkBindVertexBufferIndirectCommandEXT const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkBindVertexBufferIndirectCommandEXT *>( this );
    }

    operator VkBindVertexBufferIndirectCommandEXT &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkBindVertexBufferIndirectCommandEXT *>( this );
    }

    operator VkBindVertexBufferIndirectCommandEXT const *() const VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<const VkBindVertexBufferIndirectCommandEXT *>( this );
    }

    operator VkBindVertexBufferIndirectCommandEXT *() VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<VkBindVertexBufferIndirectCommandEXT *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<DeviceAddress const &, uint32_t const &, uint32_t const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( bufferAddress, size, stride );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( BindVertexBufferIndirectCommandEXT const & ) const = default;
#else
    bool operator==( BindVertexBufferIndirectCommandEXT const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( bufferAddress == rhs.bufferAddress ) && ( size == rhs.size ) && ( stride == rhs.stride );
#  endif
    }

    bool operator!=( BindVertexBufferIndirectCommandEXT const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    DeviceAddress bufferAddress = {};
    uint32_t      size          = {};
    uint32_t      stride        = {};
  };

  // wrapper struct for struct VkBindVertexBufferIndirectCommandNV, see
  // https://registry.khronos.org/vulkan/specs/latest/man/html/VkBindVertexBufferIndirectCommandNV.html
  struct BindVertexBufferIndirectCommandNV
  {
    using NativeType = VkBindVertexBufferIndirectCommandNV;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR BindVertexBufferIndirectCommandNV( DeviceAddress bufferAddress_ = {}, uint32_t size_ = {}, uint32_t stride_ = {} ) VULKAN_HPP_NOEXCEPT
      : bufferAddress{ bufferAddress_ }
      , size{ size_ }
      , stride{ stride_ }
    {
    }

    VULKAN_HPP_CONSTEXPR BindVertexBufferIndirectCommandNV( BindVertexBufferIndirectCommandNV const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    BindVertexBufferIndirectCommandNV( VkBindVertexBufferIndirectCommandNV const & rhs ) VULKAN_HPP_NOEXCEPT
      : BindVertexBufferIndirectCommandNV( *reinterpret_cast<BindVertexBufferIndirectCommandNV const *>( &rhs ) )
    {
    }

    BindVertexBufferIndirectCommandNV & operator=( BindVertexBufferIndirectCommandNV const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    BindVertexBufferIndirectCommandNV & operator=( VkBindVertexBufferIndirectCommandNV const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<BindVertexBufferIndirectCommandNV const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 BindVertexBufferIndirectCommandNV & setBufferAddress( DeviceAddress bufferAddress_ ) VULKAN_HPP_NOEXCEPT
    {
      bufferAddress = bufferAddress_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BindVertexBufferIndirectCommandNV & setSize( uint32_t size_ ) VULKAN_HPP_NOEXCEPT
    {
      size = size_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BindVertexBufferIndirectCommandNV & setStride( uint32_t stride_ ) VULKAN_HPP_NOEXCEPT
    {
      stride = stride_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_SETTERS*/

    operator VkBindVertexBufferIndirectCommandNV const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkBindVertexBufferIndirectCommandNV *>( this );
    }

    operator VkBindVertexBufferIndirectCommandNV &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkBindVertexBufferIndirectCommandNV *>( this );
    }

    operator VkBindVertexBufferIndirectCommandNV const *() const VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<const VkBindVertexBufferIndirectCommandNV *>( this );
    }

    operator VkBindVertexBufferIndirectCommandNV *() VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<VkBindVertexBufferIndirectCommandNV *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<DeviceAddress const &, uint32_t const &, uint32_t const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( bufferAddress, size, stride );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( BindVertexBufferIndirectCommandNV const & ) const = default;
#else
    bool operator==( BindVertexBufferIndirectCommandNV const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( bufferAddress == rhs.bufferAddress ) && ( size == rhs.size ) && ( stride == rhs.stride );
#  endif
    }

    bool operator!=( BindVertexBufferIndirectCommandNV const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    DeviceAddress bufferAddress = {};
    uint32_t      size          = {};
    uint32_t      stride        = {};
  };

  // wrapper struct for struct VkBindVideoSessionMemoryInfoKHR, see
  // https://registry.khronos.org/vulkan/specs/latest/man/html/VkBindVideoSessionMemoryInfoKHR.html
  struct BindVideoSessionMemoryInfoKHR
  {
    using NativeType = VkBindVideoSessionMemoryInfoKHR;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eBindVideoSessionMemoryInfoKHR;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR BindVideoSessionMemoryInfoKHR( uint32_t     memoryBindIndex_ = {},
                                                        DeviceMemory memory_          = {},
                                                        DeviceSize   memoryOffset_    = {},
                                                        DeviceSize   memorySize_      = {},
                                                        const void * pNext_           = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , memoryBindIndex{ memoryBindIndex_ }
      , memory{ memory_ }
      , memoryOffset{ memoryOffset_ }
      , memorySize{ memorySize_ }
    {
    }

    VULKAN_HPP_CONSTEXPR BindVideoSessionMemoryInfoKHR( BindVideoSessionMemoryInfoKHR const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    BindVideoSessionMemoryInfoKHR( VkBindVideoSessionMemoryInfoKHR const & rhs ) VULKAN_HPP_NOEXCEPT
      : BindVideoSessionMemoryInfoKHR( *reinterpret_cast<BindVideoSessionMemoryInfoKHR const *>( &rhs ) )
    {
    }

    BindVideoSessionMemoryInfoKHR & operator=( BindVideoSessionMemoryInfoKHR const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    BindVideoSessionMemoryInfoKHR & operator=( VkBindVideoSessionMemoryInfoKHR const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<BindVideoSessionMemoryInfoKHR const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 BindVideoSessionMemoryInfoKHR & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BindVideoSessionMemoryInfoKHR & setMemoryBindIndex( uint32_t memoryBindIndex_ ) VULKAN_HPP_NOEXCEPT
    {
      memoryBindIndex = memoryBindIndex_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BindVideoSessionMemoryInfoKHR & setMemory( DeviceMemory memory_ ) VULKAN_HPP_NOEXCEPT
    {
      memory = memory_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BindVideoSessionMemoryInfoKHR & setMemoryOffset( DeviceSize memoryOffset_ ) VULKAN_HPP_NOEXCEPT
    {
      memoryOffset = memoryOffset_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BindVideoSessionMemoryInfoKHR & setMemorySize( DeviceSize memorySize_ ) VULKAN_HPP_NOEXCEPT
    {
      memorySize = memorySize_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_SETTERS*/

    operator VkBindVideoSessionMemoryInfoKHR const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkBindVideoSessionMemoryInfoKHR *>( this );
    }

    operator VkBindVideoSessionMemoryInfoKHR &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkBindVideoSessionMemoryInfoKHR *>( this );
    }

    operator VkBindVideoSessionMemoryInfoKHR const *() const VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<const VkBindVideoSessionMemoryInfoKHR *>( this );
    }

    operator VkBindVideoSessionMemoryInfoKHR *() VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<VkBindVideoSessionMemoryInfoKHR *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<StructureType const &, const void * const &, uint32_t const &, DeviceMemory const &, DeviceSize const &, DeviceSize const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, memoryBindIndex, memory, memoryOffset, memorySize );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( BindVideoSessionMemoryInfoKHR const & ) const = default;
#else
    bool operator==( BindVideoSessionMemoryInfoKHR const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( memoryBindIndex == rhs.memoryBindIndex ) && ( memory == rhs.memory ) &&
             ( memoryOffset == rhs.memoryOffset ) && ( memorySize == rhs.memorySize );
#  endif
    }

    bool operator!=( BindVideoSessionMemoryInfoKHR const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    StructureType sType           = StructureType::eBindVideoSessionMemoryInfoKHR;
    const void *  pNext           = {};
    uint32_t      memoryBindIndex = {};
    DeviceMemory  memory          = {};
    DeviceSize    memoryOffset    = {};
    DeviceSize    memorySize      = {};
  };

  template <>
  struct CppType<StructureType, StructureType::eBindVideoSessionMemoryInfoKHR>
  {
    using Type = BindVideoSessionMemoryInfoKHR;
  };

  // wrapper struct for struct VkBlitImageCubicWeightsInfoQCOM, see
  // https://registry.khronos.org/vulkan/specs/latest/man/html/VkBlitImageCubicWeightsInfoQCOM.html
  struct BlitImageCubicWeightsInfoQCOM
  {
    using NativeType = VkBlitImageCubicWeightsInfoQCOM;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eBlitImageCubicWeightsInfoQCOM;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR BlitImageCubicWeightsInfoQCOM( CubicFilterWeightsQCOM cubicWeights_ = CubicFilterWeightsQCOM::eCatmullRom,
                                                        const void *           pNext_        = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , cubicWeights{ cubicWeights_ }
    {
    }

    VULKAN_HPP_CONSTEXPR BlitImageCubicWeightsInfoQCOM( BlitImageCubicWeightsInfoQCOM const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    BlitImageCubicWeightsInfoQCOM( VkBlitImageCubicWeightsInfoQCOM const & rhs ) VULKAN_HPP_NOEXCEPT
      : BlitImageCubicWeightsInfoQCOM( *reinterpret_cast<BlitImageCubicWeightsInfoQCOM const *>( &rhs ) )
    {
    }

    BlitImageCubicWeightsInfoQCOM & operator=( BlitImageCubicWeightsInfoQCOM const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    BlitImageCubicWeightsInfoQCOM & operator=( VkBlitImageCubicWeightsInfoQCOM const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<BlitImageCubicWeightsInfoQCOM const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 BlitImageCubicWeightsInfoQCOM & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BlitImageCubicWeightsInfoQCOM & setCubicWeights( CubicFilterWeightsQCOM cubicWeights_ ) VULKAN_HPP_NOEXCEPT
    {
      cubicWeights = cubicWeights_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_SETTERS*/

    operator VkBlitImageCubicWeightsInfoQCOM const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkBlitImageCubicWeightsInfoQCOM *>( this );
    }

    operator VkBlitImageCubicWeightsInfoQCOM &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkBlitImageCubicWeightsInfoQCOM *>( this );
    }

    operator VkBlitImageCubicWeightsInfoQCOM const *() const VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<const VkBlitImageCubicWeightsInfoQCOM *>( this );
    }

    operator VkBlitImageCubicWeightsInfoQCOM *() VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<VkBlitImageCubicWeightsInfoQCOM *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<StructureType const &, const void * const &, CubicFilterWeightsQCOM const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, cubicWeights );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( BlitImageCubicWeightsInfoQCOM const & ) const = default;
#else
    bool operator==( BlitImageCubicWeightsInfoQCOM const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( cubicWeights == rhs.cubicWeights );
#  endif
    }

    bool operator!=( BlitImageCubicWeightsInfoQCOM const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    StructureType          sType        = StructureType::eBlitImageCubicWeightsInfoQCOM;
    const void *           pNext        = {};
    CubicFilterWeightsQCOM cubicWeights = CubicFilterWeightsQCOM::eCatmullRom;
  };

  template <>
  struct CppType<StructureType, StructureType::eBlitImageCubicWeightsInfoQCOM>
  {
    using Type = BlitImageCubicWeightsInfoQCOM;
  };

  // wrapper struct for struct VkImageSubresourceLayers, see https://registry.khronos.org/vulkan/specs/latest/man/html/VkImageSubresourceLayers.html
  struct ImageSubresourceLayers
  {
    using NativeType = VkImageSubresourceLayers;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR ImageSubresourceLayers( ImageAspectFlags aspectMask_     = {},
                                                 uint32_t         mipLevel_       = {},
                                                 uint32_t         baseArrayLayer_ = {},
                                                 uint32_t         layerCount_     = {} ) VULKAN_HPP_NOEXCEPT
      : aspectMask{ aspectMask_ }
      , mipLevel{ mipLevel_ }
      , baseArrayLayer{ baseArrayLayer_ }
      , layerCount{ layerCount_ }
    {
    }

    VULKAN_HPP_CONSTEXPR ImageSubresourceLayers( ImageSubresourceLayers const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    ImageSubresourceLayers( VkImageSubresourceLayers const & rhs ) VULKAN_HPP_NOEXCEPT
      : ImageSubresourceLayers( *reinterpret_cast<ImageSubresourceLayers const *>( &rhs ) )
    {
    }

    ImageSubresourceLayers & operator=( ImageSubresourceLayers const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    ImageSubresourceLayers & operator=( VkImageSubresourceLayers const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<ImageSubresourceLayers const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 ImageSubresourceLayers & setAspectMask( ImageAspectFlags aspectMask_ ) VULKAN_HPP_NOEXCEPT
    {
      aspectMask = aspectMask_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ImageSubresourceLayers & setMipLevel( uint32_t mipLevel_ ) VULKAN_HPP_NOEXCEPT
    {
      mipLevel = mipLevel_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ImageSubresourceLayers & setBaseArrayLayer( uint32_t baseArrayLayer_ ) VULKAN_HPP_NOEXCEPT
    {
      baseArrayLayer = baseArrayLayer_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ImageSubresourceLayers & setLayerCount( uint32_t layerCount_ ) VULKAN_HPP_NOEXCEPT
    {
      layerCount = layerCount_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_SETTERS*/

    operator VkImageSubresourceLayers const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkImageSubresourceLayers *>( this );
    }

    operator VkImageSubresourceLayers &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkImageSubresourceLayers *>( this );
    }

    operator VkImageSubresourceLayers const *() const VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<const VkImageSubresourceLayers *>( this );
    }

    operator VkImageSubresourceLayers *() VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<VkImageSubresourceLayers *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<ImageAspectFlags const &, uint32_t const &, uint32_t const &, uint32_t const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( aspectMask, mipLevel, baseArrayLayer, layerCount );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( ImageSubresourceLayers const & ) const = default;
#else
    bool operator==( ImageSubresourceLayers const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( aspectMask == rhs.aspectMask ) && ( mipLevel == rhs.mipLevel ) && ( baseArrayLayer == rhs.baseArrayLayer ) && ( layerCount == rhs.layerCount );
#  endif
    }

    bool operator!=( ImageSubresourceLayers const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    ImageAspectFlags aspectMask     = {};
    uint32_t         mipLevel       = {};
    uint32_t         baseArrayLayer = {};
    uint32_t         layerCount     = {};
  };

  // wrapper struct for struct VkImageBlit2, see https://registry.khronos.org/vulkan/specs/latest/man/html/VkImageBlit2.html
  struct ImageBlit2
  {
    using NativeType = VkImageBlit2;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eImageBlit2;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR_14 ImageBlit2( ImageSubresourceLayers          srcSubresource_ = {},
                                        std::array<Offset3D, 2> const & srcOffsets_     = {},
                                        ImageSubresourceLayers          dstSubresource_ = {},
                                        std::array<Offset3D, 2> const & dstOffsets_     = {},
                                        const void *                    pNext_          = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , srcSubresource{ srcSubresource_ }
      , srcOffsets{ srcOffsets_ }
      , dstSubresource{ dstSubresource_ }
      , dstOffsets{ dstOffsets_ }
    {
    }

    VULKAN_HPP_CONSTEXPR_14 ImageBlit2( ImageBlit2 const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    ImageBlit2( VkImageBlit2 const & rhs ) VULKAN_HPP_NOEXCEPT : ImageBlit2( *reinterpret_cast<ImageBlit2 const *>( &rhs ) ) {}

    ImageBlit2 & operator=( ImageBlit2 const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    ImageBlit2 & operator=( VkImageBlit2 const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<ImageBlit2 const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 ImageBlit2 & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ImageBlit2 & setSrcSubresource( ImageSubresourceLayers const & srcSubresource_ ) VULKAN_HPP_NOEXCEPT
    {
      srcSubresource = srcSubresource_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ImageBlit2 & setSrcOffsets( std::array<Offset3D, 2> const & srcOffsets_ ) VULKAN_HPP_NOEXCEPT
    {
      srcOffsets = srcOffsets_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ImageBlit2 & setDstSubresource( ImageSubresourceLayers const & dstSubresource_ ) VULKAN_HPP_NOEXCEPT
    {
      dstSubresource = dstSubresource_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ImageBlit2 & setDstOffsets( std::array<Offset3D, 2> const & dstOffsets_ ) VULKAN_HPP_NOEXCEPT
    {
      dstOffsets = dstOffsets_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_SETTERS*/

    operator VkImageBlit2 const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkImageBlit2 *>( this );
    }

    operator VkImageBlit2 &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkImageBlit2 *>( this );
    }

    operator VkImageBlit2 const *() const VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<const VkImageBlit2 *>( this );
    }

    operator VkImageBlit2 *() VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<VkImageBlit2 *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<StructureType const &,
               const void * const &,
               ImageSubresourceLayers const &,
               ArrayWrapper1D<Offset3D, 2> const &,
               ImageSubresourceLayers const &,
               ArrayWrapper1D<Offset3D, 2> const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, srcSubresource, srcOffsets, dstSubresource, dstOffsets );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( ImageBlit2 const & ) const = default;
#else
    bool operator==( ImageBlit2 const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( srcSubresource == rhs.srcSubresource ) && ( srcOffsets == rhs.srcOffsets ) &&
             ( dstSubresource == rhs.dstSubresource ) && ( dstOffsets == rhs.dstOffsets );
#  endif
    }

    bool operator!=( ImageBlit2 const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    StructureType               sType          = StructureType::eImageBlit2;
    const void *                pNext          = {};
    ImageSubresourceLayers      srcSubresource = {};
    ArrayWrapper1D<Offset3D, 2> srcOffsets     = {};
    ImageSubresourceLayers      dstSubresource = {};
    ArrayWrapper1D<Offset3D, 2> dstOffsets     = {};
  };

  template <>
  struct CppType<StructureType, StructureType::eImageBlit2>
  {
    using Type = ImageBlit2;
  };

  using ImageBlit2KHR = ImageBlit2;

  // wrapper struct for struct VkBlitImageInfo2, see https://registry.khronos.org/vulkan/specs/latest/man/html/VkBlitImageInfo2.html
  struct BlitImageInfo2
  {
    using NativeType = VkBlitImageInfo2;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eBlitImageInfo2;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR_14 BlitImageInfo2( Image              srcImage_       = {},
                                            ImageLayout        srcImageLayout_ = ImageLayout::eUndefined,
                                            Image              dstImage_       = {},
                                            ImageLayout        dstImageLayout_ = ImageLayout::eUndefined,
                                            uint32_t           regionCount_    = {},
                                            const ImageBlit2 * pRegions_       = {},
                                            Filter             filter_         = Filter::eNearest,
                                            const void *       pNext_          = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , srcImage{ srcImage_ }
      , srcImageLayout{ srcImageLayout_ }
      , dstImage{ dstImage_ }
      , dstImageLayout{ dstImageLayout_ }
      , regionCount{ regionCount_ }
      , pRegions{ pRegions_ }
      , filter{ filter_ }
    {
    }

    VULKAN_HPP_CONSTEXPR_14 BlitImageInfo2( BlitImageInfo2 const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    BlitImageInfo2( VkBlitImageInfo2 const & rhs ) VULKAN_HPP_NOEXCEPT : BlitImageInfo2( *reinterpret_cast<BlitImageInfo2 const *>( &rhs ) ) {}

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    BlitImageInfo2( Image                                             srcImage_,
                    ImageLayout                                       srcImageLayout_,
                    Image                                             dstImage_,
                    ImageLayout                                       dstImageLayout_,
                    ArrayProxyNoTemporaries<const ImageBlit2> const & regions_,
                    Filter                                            filter_ = Filter::eNearest,
                    const void *                                      pNext_  = nullptr )
      : pNext( pNext_ )
      , srcImage( srcImage_ )
      , srcImageLayout( srcImageLayout_ )
      , dstImage( dstImage_ )
      , dstImageLayout( dstImageLayout_ )
      , regionCount( static_cast<uint32_t>( regions_.size() ) )
      , pRegions( regions_.data() )
      , filter( filter_ )
    {
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/

    BlitImageInfo2 & operator=( BlitImageInfo2 const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    BlitImageInfo2 & operator=( VkBlitImageInfo2 const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<BlitImageInfo2 const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 BlitImageInfo2 & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BlitImageInfo2 & setSrcImage( Image srcImage_ ) VULKAN_HPP_NOEXCEPT
    {
      srcImage = srcImage_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BlitImageInfo2 & setSrcImageLayout( ImageLayout srcImageLayout_ ) VULKAN_HPP_NOEXCEPT
    {
      srcImageLayout = srcImageLayout_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BlitImageInfo2 & setDstImage( Image dstImage_ ) VULKAN_HPP_NOEXCEPT
    {
      dstImage = dstImage_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BlitImageInfo2 & setDstImageLayout( ImageLayout dstImageLayout_ ) VULKAN_HPP_NOEXCEPT
    {
      dstImageLayout = dstImageLayout_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BlitImageInfo2 & setRegionCount( uint32_t regionCount_ ) VULKAN_HPP_NOEXCEPT
    {
      regionCount = regionCount_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BlitImageInfo2 & setPRegions( const ImageBlit2 * pRegions_ ) VULKAN_HPP_NOEXCEPT
    {
      pRegions = pRegions_;
      return *this;
    }

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    BlitImageInfo2 & setRegions( ArrayProxyNoTemporaries<const ImageBlit2> const & regions_ ) VULKAN_HPP_NOEXCEPT
    {
      regionCount = static_cast<uint32_t>( regions_.size() );
      pRegions    = regions_.data();
      return *this;
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/

    VULKAN_HPP_CONSTEXPR_14 BlitImageInfo2 & setFilter( Filter filter_ ) VULKAN_HPP_NOEXCEPT
    {
      filter = filter_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_SETTERS*/

    operator VkBlitImageInfo2 const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkBlitImageInfo2 *>( this );
    }

    operator VkBlitImageInfo2 &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkBlitImageInfo2 *>( this );
    }

    operator VkBlitImageInfo2 const *() const VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<const VkBlitImageInfo2 *>( this );
    }

    operator VkBlitImageInfo2 *() VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<VkBlitImageInfo2 *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<StructureType const &,
               const void * const &,
               Image const &,
               ImageLayout const &,
               Image const &,
               ImageLayout const &,
               uint32_t const &,
               const ImageBlit2 * const &,
               Filter const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, srcImage, srcImageLayout, dstImage, dstImageLayout, regionCount, pRegions, filter );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( BlitImageInfo2 const & ) const = default;
#else
    bool operator==( BlitImageInfo2 const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( srcImage == rhs.srcImage ) && ( srcImageLayout == rhs.srcImageLayout ) &&
             ( dstImage == rhs.dstImage ) && ( dstImageLayout == rhs.dstImageLayout ) && ( regionCount == rhs.regionCount ) && ( pRegions == rhs.pRegions ) &&
             ( filter == rhs.filter );
#  endif
    }

    bool operator!=( BlitImageInfo2 const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    StructureType      sType          = StructureType::eBlitImageInfo2;
    const void *       pNext          = {};
    Image              srcImage       = {};
    ImageLayout        srcImageLayout = ImageLayout::eUndefined;
    Image              dstImage       = {};
    ImageLayout        dstImageLayout = ImageLayout::eUndefined;
    uint32_t           regionCount    = {};
    const ImageBlit2 * pRegions       = {};
    Filter             filter         = Filter::eNearest;
  };

  template <>
  struct CppType<StructureType, StructureType::eBlitImageInfo2>
  {
    using Type = BlitImageInfo2;
  };

  using BlitImageInfo2KHR = BlitImageInfo2;

  // wrapper struct for struct VkBufferCaptureDescriptorDataInfoEXT, see
  // https://registry.khronos.org/vulkan/specs/latest/man/html/VkBufferCaptureDescriptorDataInfoEXT.html
  struct BufferCaptureDescriptorDataInfoEXT
  {
    using NativeType = VkBufferCaptureDescriptorDataInfoEXT;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eBufferCaptureDescriptorDataInfoEXT;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR BufferCaptureDescriptorDataInfoEXT( Buffer buffer_ = {}, const void * pNext_ = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , buffer{ buffer_ }
    {
    }

    VULKAN_HPP_CONSTEXPR BufferCaptureDescriptorDataInfoEXT( BufferCaptureDescriptorDataInfoEXT const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    BufferCaptureDescriptorDataInfoEXT( VkBufferCaptureDescriptorDataInfoEXT const & rhs ) VULKAN_HPP_NOEXCEPT
      : BufferCaptureDescriptorDataInfoEXT( *reinterpret_cast<BufferCaptureDescriptorDataInfoEXT const *>( &rhs ) )
    {
    }

    BufferCaptureDescriptorDataInfoEXT & operator=( BufferCaptureDescriptorDataInfoEXT const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    BufferCaptureDescriptorDataInfoEXT & operator=( VkBufferCaptureDescriptorDataInfoEXT const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<BufferCaptureDescriptorDataInfoEXT const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 BufferCaptureDescriptorDataInfoEXT & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BufferCaptureDescriptorDataInfoEXT & setBuffer( Buffer buffer_ ) VULKAN_HPP_NOEXCEPT
    {
      buffer = buffer_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_SETTERS*/

    operator VkBufferCaptureDescriptorDataInfoEXT const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkBufferCaptureDescriptorDataInfoEXT *>( this );
    }

    operator VkBufferCaptureDescriptorDataInfoEXT &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkBufferCaptureDescriptorDataInfoEXT *>( this );
    }

    operator VkBufferCaptureDescriptorDataInfoEXT const *() const VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<const VkBufferCaptureDescriptorDataInfoEXT *>( this );
    }

    operator VkBufferCaptureDescriptorDataInfoEXT *() VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<VkBufferCaptureDescriptorDataInfoEXT *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<StructureType const &, const void * const &, Buffer const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, buffer );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( BufferCaptureDescriptorDataInfoEXT const & ) const = default;
#else
    bool operator==( BufferCaptureDescriptorDataInfoEXT const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( buffer == rhs.buffer );
#  endif
    }

    bool operator!=( BufferCaptureDescriptorDataInfoEXT const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    StructureType sType  = StructureType::eBufferCaptureDescriptorDataInfoEXT;
    const void *  pNext  = {};
    Buffer        buffer = {};
  };

  template <>
  struct CppType<StructureType, StructureType::eBufferCaptureDescriptorDataInfoEXT>
  {
    using Type = BufferCaptureDescriptorDataInfoEXT;
  };

#if defined( VK_USE_PLATFORM_FUCHSIA )
  // wrapper struct for struct VkBufferCollectionBufferCreateInfoFUCHSIA, see
  // https://registry.khronos.org/vulkan/specs/latest/man/html/VkBufferCollectionBufferCreateInfoFUCHSIA.html
  struct BufferCollectionBufferCreateInfoFUCHSIA
  {
    using NativeType = VkBufferCollectionBufferCreateInfoFUCHSIA;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eBufferCollectionBufferCreateInfoFUCHSIA;

#  if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR BufferCollectionBufferCreateInfoFUCHSIA( BufferCollectionFUCHSIA collection_ = {},
                                                                  uint32_t                index_      = {},
                                                                  const void *            pNext_      = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , collection{ collection_ }
      , index{ index_ }
    {
    }

    VULKAN_HPP_CONSTEXPR BufferCollectionBufferCreateInfoFUCHSIA( BufferCollectionBufferCreateInfoFUCHSIA const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    BufferCollectionBufferCreateInfoFUCHSIA( VkBufferCollectionBufferCreateInfoFUCHSIA const & rhs ) VULKAN_HPP_NOEXCEPT
      : BufferCollectionBufferCreateInfoFUCHSIA( *reinterpret_cast<BufferCollectionBufferCreateInfoFUCHSIA const *>( &rhs ) )
    {
    }

    BufferCollectionBufferCreateInfoFUCHSIA & operator=( BufferCollectionBufferCreateInfoFUCHSIA const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#  endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    BufferCollectionBufferCreateInfoFUCHSIA & operator=( VkBufferCollectionBufferCreateInfoFUCHSIA const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<BufferCollectionBufferCreateInfoFUCHSIA const *>( &rhs );
      return *this;
    }

#  if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 BufferCollectionBufferCreateInfoFUCHSIA & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BufferCollectionBufferCreateInfoFUCHSIA & setCollection( BufferCollectionFUCHSIA collection_ ) VULKAN_HPP_NOEXCEPT
    {
      collection = collection_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BufferCollectionBufferCreateInfoFUCHSIA & setIndex( uint32_t index_ ) VULKAN_HPP_NOEXCEPT
    {
      index = index_;
      return *this;
    }
#  endif /*VULKAN_HPP_NO_SETTERS*/

    operator VkBufferCollectionBufferCreateInfoFUCHSIA const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkBufferCollectionBufferCreateInfoFUCHSIA *>( this );
    }

    operator VkBufferCollectionBufferCreateInfoFUCHSIA &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkBufferCollectionBufferCreateInfoFUCHSIA *>( this );
    }

    operator VkBufferCollectionBufferCreateInfoFUCHSIA const *() const VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<const VkBufferCollectionBufferCreateInfoFUCHSIA *>( this );
    }

    operator VkBufferCollectionBufferCreateInfoFUCHSIA *() VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<VkBufferCollectionBufferCreateInfoFUCHSIA *>( this );
    }

#  if defined( VULKAN_HPP_USE_REFLECT )
#    if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#    else
    std::tuple<StructureType const &, const void * const &, BufferCollectionFUCHSIA const &, uint32_t const &>
#    endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, collection, index );
    }
#  endif

#  if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( BufferCollectionBufferCreateInfoFUCHSIA const & ) const = default;
#  else
    bool operator==( BufferCollectionBufferCreateInfoFUCHSIA const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#    if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#    else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( collection == rhs.collection ) && ( index == rhs.index );
#    endif
    }

    bool operator!=( BufferCollectionBufferCreateInfoFUCHSIA const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#  endif

  public:
    StructureType           sType      = StructureType::eBufferCollectionBufferCreateInfoFUCHSIA;
    const void *            pNext      = {};
    BufferCollectionFUCHSIA collection = {};
    uint32_t                index      = {};
  };

  template <>
  struct CppType<StructureType, StructureType::eBufferCollectionBufferCreateInfoFUCHSIA>
  {
    using Type = BufferCollectionBufferCreateInfoFUCHSIA;
  };
#endif /*VK_USE_PLATFORM_FUCHSIA*/

#if defined( VK_USE_PLATFORM_FUCHSIA )
  // wrapper struct for struct VkBufferCollectionConstraintsInfoFUCHSIA, see
  // https://registry.khronos.org/vulkan/specs/latest/man/html/VkBufferCollectionConstraintsInfoFUCHSIA.html
  struct BufferCollectionConstraintsInfoFUCHSIA
  {
    using NativeType = VkBufferCollectionConstraintsInfoFUCHSIA;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eBufferCollectionConstraintsInfoFUCHSIA;

#  if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR BufferCollectionConstraintsInfoFUCHSIA( uint32_t     minBufferCount_                  = {},
                                                                 uint32_t     maxBufferCount_                  = {},
                                                                 uint32_t     minBufferCountForCamping_        = {},
                                                                 uint32_t     minBufferCountForDedicatedSlack_ = {},
                                                                 uint32_t     minBufferCountForSharedSlack_    = {},
                                                                 const void * pNext_                           = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , minBufferCount{ minBufferCount_ }
      , maxBufferCount{ maxBufferCount_ }
      , minBufferCountForCamping{ minBufferCountForCamping_ }
      , minBufferCountForDedicatedSlack{ minBufferCountForDedicatedSlack_ }
      , minBufferCountForSharedSlack{ minBufferCountForSharedSlack_ }
    {
    }

    VULKAN_HPP_CONSTEXPR BufferCollectionConstraintsInfoFUCHSIA( BufferCollectionConstraintsInfoFUCHSIA const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    BufferCollectionConstraintsInfoFUCHSIA( VkBufferCollectionConstraintsInfoFUCHSIA const & rhs ) VULKAN_HPP_NOEXCEPT
      : BufferCollectionConstraintsInfoFUCHSIA( *reinterpret_cast<BufferCollectionConstraintsInfoFUCHSIA const *>( &rhs ) )
    {
    }

    BufferCollectionConstraintsInfoFUCHSIA & operator=( BufferCollectionConstraintsInfoFUCHSIA const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#  endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    BufferCollectionConstraintsInfoFUCHSIA & operator=( VkBufferCollectionConstraintsInfoFUCHSIA const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<BufferCollectionConstraintsInfoFUCHSIA const *>( &rhs );
      return *this;
    }

#  if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 BufferCollectionConstraintsInfoFUCHSIA & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BufferCollectionConstraintsInfoFUCHSIA & setMinBufferCount( uint32_t minBufferCount_ ) VULKAN_HPP_NOEXCEPT
    {
      minBufferCount = minBufferCount_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BufferCollectionConstraintsInfoFUCHSIA & setMaxBufferCount( uint32_t maxBufferCount_ ) VULKAN_HPP_NOEXCEPT
    {
      maxBufferCount = maxBufferCount_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BufferCollectionConstraintsInfoFUCHSIA & setMinBufferCountForCamping( uint32_t minBufferCountForCamping_ ) VULKAN_HPP_NOEXCEPT
    {
      minBufferCountForCamping = minBufferCountForCamping_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BufferCollectionConstraintsInfoFUCHSIA &
      setMinBufferCountForDedicatedSlack( uint32_t minBufferCountForDedicatedSlack_ ) VULKAN_HPP_NOEXCEPT
    {
      minBufferCountForDedicatedSlack = minBufferCountForDedicatedSlack_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BufferCollectionConstraintsInfoFUCHSIA &
      setMinBufferCountForSharedSlack( uint32_t minBufferCountForSharedSlack_ ) VULKAN_HPP_NOEXCEPT
    {
      minBufferCountForSharedSlack = minBufferCountForSharedSlack_;
      return *this;
    }
#  endif /*VULKAN_HPP_NO_SETTERS*/

    operator VkBufferCollectionConstraintsInfoFUCHSIA const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkBufferCollectionConstraintsInfoFUCHSIA *>( this );
    }

    operator VkBufferCollectionConstraintsInfoFUCHSIA &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkBufferCollectionConstraintsInfoFUCHSIA *>( this );
    }

    operator VkBufferCollectionConstraintsInfoFUCHSIA const *() const VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<const VkBufferCollectionConstraintsInfoFUCHSIA *>( this );
    }

    operator VkBufferCollectionConstraintsInfoFUCHSIA *() VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<VkBufferCollectionConstraintsInfoFUCHSIA *>( this );
    }

#  if defined( VULKAN_HPP_USE_REFLECT )
#    if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#    else
    std::tuple<StructureType const &, const void * const &, uint32_t const &, uint32_t const &, uint32_t const &, uint32_t const &, uint32_t const &>
#    endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, minBufferCount, maxBufferCount, minBufferCountForCamping, minBufferCountForDedicatedSlack, minBufferCountForSharedSlack );
    }
#  endif

#  if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( BufferCollectionConstraintsInfoFUCHSIA const & ) const = default;
#  else
    bool operator==( BufferCollectionConstraintsInfoFUCHSIA const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#    if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#    else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( minBufferCount == rhs.minBufferCount ) && ( maxBufferCount == rhs.maxBufferCount ) &&
             ( minBufferCountForCamping == rhs.minBufferCountForCamping ) && ( minBufferCountForDedicatedSlack == rhs.minBufferCountForDedicatedSlack ) &&
             ( minBufferCountForSharedSlack == rhs.minBufferCountForSharedSlack );
#    endif
    }

    bool operator!=( BufferCollectionConstraintsInfoFUCHSIA const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#  endif

  public:
    StructureType sType                           = StructureType::eBufferCollectionConstraintsInfoFUCHSIA;
    const void *  pNext                           = {};
    uint32_t      minBufferCount                  = {};
    uint32_t      maxBufferCount                  = {};
    uint32_t      minBufferCountForCamping        = {};
    uint32_t      minBufferCountForDedicatedSlack = {};
    uint32_t      minBufferCountForSharedSlack    = {};
  };

  template <>
  struct CppType<StructureType, StructureType::eBufferCollectionConstraintsInfoFUCHSIA>
  {
    using Type = BufferCollectionConstraintsInfoFUCHSIA;
  };
#endif /*VK_USE_PLATFORM_FUCHSIA*/

#if defined( VK_USE_PLATFORM_FUCHSIA )
  // wrapper struct for struct VkBufferCollectionCreateInfoFUCHSIA, see
  // https://registry.khronos.org/vulkan/specs/latest/man/html/VkBufferCollectionCreateInfoFUCHSIA.html
  struct BufferCollectionCreateInfoFUCHSIA
  {
    using NativeType = VkBufferCollectionCreateInfoFUCHSIA;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eBufferCollectionCreateInfoFUCHSIA;

#  if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR BufferCollectionCreateInfoFUCHSIA( zx_handle_t collectionToken_ = {}, const void * pNext_ = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , collectionToken{ collectionToken_ }
    {
    }

    VULKAN_HPP_CONSTEXPR BufferCollectionCreateInfoFUCHSIA( BufferCollectionCreateInfoFUCHSIA const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    BufferCollectionCreateInfoFUCHSIA( VkBufferCollectionCreateInfoFUCHSIA const & rhs ) VULKAN_HPP_NOEXCEPT
      : BufferCollectionCreateInfoFUCHSIA( *reinterpret_cast<BufferCollectionCreateInfoFUCHSIA const *>( &rhs ) )
    {
    }

    BufferCollectionCreateInfoFUCHSIA & operator=( BufferCollectionCreateInfoFUCHSIA const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#  endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    BufferCollectionCreateInfoFUCHSIA & operator=( VkBufferCollectionCreateInfoFUCHSIA const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<BufferCollectionCreateInfoFUCHSIA const *>( &rhs );
      return *this;
    }

#  if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 BufferCollectionCreateInfoFUCHSIA & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BufferCollectionCreateInfoFUCHSIA & setCollectionToken( zx_handle_t collectionToken_ ) VULKAN_HPP_NOEXCEPT
    {
      collectionToken = collectionToken_;
      return *this;
    }
#  endif /*VULKAN_HPP_NO_SETTERS*/

    operator VkBufferCollectionCreateInfoFUCHSIA const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkBufferCollectionCreateInfoFUCHSIA *>( this );
    }

    operator VkBufferCollectionCreateInfoFUCHSIA &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkBufferCollectionCreateInfoFUCHSIA *>( this );
    }

    operator VkBufferCollectionCreateInfoFUCHSIA const *() const VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<const VkBufferCollectionCreateInfoFUCHSIA *>( this );
    }

    operator VkBufferCollectionCreateInfoFUCHSIA *() VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<VkBufferCollectionCreateInfoFUCHSIA *>( this );
    }

#  if defined( VULKAN_HPP_USE_REFLECT )
#    if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#    else
    std::tuple<StructureType const &, const void * const &, zx_handle_t const &>
#    endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, collectionToken );
    }
#  endif

#  if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    std::strong_ordering operator<=>( BufferCollectionCreateInfoFUCHSIA const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      if ( auto cmp = sType <=> rhs.sType; cmp != 0 )
        return cmp;
      if ( auto cmp = pNext <=> rhs.pNext; cmp != 0 )
        return cmp;
      if ( auto cmp = memcmp( &collectionToken, &rhs.collectionToken, sizeof( zx_handle_t ) ); cmp != 0 )
        return ( cmp < 0 ) ? std::strong_ordering::less : std::strong_ordering::greater;

      return std::strong_ordering::equivalent;
    }
#  endif

    bool operator==( BufferCollectionCreateInfoFUCHSIA const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( memcmp( &collectionToken, &rhs.collectionToken, sizeof( zx_handle_t ) ) == 0 );
    }

    bool operator!=( BufferCollectionCreateInfoFUCHSIA const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }

  public:
    StructureType sType           = StructureType::eBufferCollectionCreateInfoFUCHSIA;
    const void *  pNext           = {};
    zx_handle_t   collectionToken = {};
  };

  template <>
  struct CppType<StructureType, StructureType::eBufferCollectionCreateInfoFUCHSIA>
  {
    using Type = BufferCollectionCreateInfoFUCHSIA;
  };
#endif /*VK_USE_PLATFORM_FUCHSIA*/

#if defined( VK_USE_PLATFORM_FUCHSIA )
  // wrapper struct for struct VkBufferCollectionImageCreateInfoFUCHSIA, see
  // https://registry.khronos.org/vulkan/specs/latest/man/html/VkBufferCollectionImageCreateInfoFUCHSIA.html
  struct BufferCollectionImageCreateInfoFUCHSIA
  {
    using NativeType = VkBufferCollectionImageCreateInfoFUCHSIA;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eBufferCollectionImageCreateInfoFUCHSIA;

#  if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR BufferCollectionImageCreateInfoFUCHSIA( BufferCollectionFUCHSIA collection_ = {},
                                                                 uint32_t                index_      = {},
                                                                 const void *            pNext_      = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , collection{ collection_ }
      , index{ index_ }
    {
    }

    VULKAN_HPP_CONSTEXPR BufferCollectionImageCreateInfoFUCHSIA( BufferCollectionImageCreateInfoFUCHSIA const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    BufferCollectionImageCreateInfoFUCHSIA( VkBufferCollectionImageCreateInfoFUCHSIA const & rhs ) VULKAN_HPP_NOEXCEPT
      : BufferCollectionImageCreateInfoFUCHSIA( *reinterpret_cast<BufferCollectionImageCreateInfoFUCHSIA const *>( &rhs ) )
    {
    }

    BufferCollectionImageCreateInfoFUCHSIA & operator=( BufferCollectionImageCreateInfoFUCHSIA const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#  endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    BufferCollectionImageCreateInfoFUCHSIA & operator=( VkBufferCollectionImageCreateInfoFUCHSIA const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<BufferCollectionImageCreateInfoFUCHSIA const *>( &rhs );
      return *this;
    }

#  if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 BufferCollectionImageCreateInfoFUCHSIA & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BufferCollectionImageCreateInfoFUCHSIA & setCollection( BufferCollectionFUCHSIA collection_ ) VULKAN_HPP_NOEXCEPT
    {
      collection = collection_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BufferCollectionImageCreateInfoFUCHSIA & setIndex( uint32_t index_ ) VULKAN_HPP_NOEXCEPT
    {
      index = index_;
      return *this;
    }
#  endif /*VULKAN_HPP_NO_SETTERS*/

    operator VkBufferCollectionImageCreateInfoFUCHSIA const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkBufferCollectionImageCreateInfoFUCHSIA *>( this );
    }

    operator VkBufferCollectionImageCreateInfoFUCHSIA &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkBufferCollectionImageCreateInfoFUCHSIA *>( this );
    }

    operator VkBufferCollectionImageCreateInfoFUCHSIA const *() const VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<const VkBufferCollectionImageCreateInfoFUCHSIA *>( this );
    }

    operator VkBufferCollectionImageCreateInfoFUCHSIA *() VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<VkBufferCollectionImageCreateInfoFUCHSIA *>( this );
    }

#  if defined( VULKAN_HPP_USE_REFLECT )
#    if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#    else
    std::tuple<StructureType const &, const void * const &, BufferCollectionFUCHSIA const &, uint32_t const &>
#    endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, collection, index );
    }
#  endif

#  if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( BufferCollectionImageCreateInfoFUCHSIA const & ) const = default;
#  else
    bool operator==( BufferCollectionImageCreateInfoFUCHSIA const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#    if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#    else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( collection == rhs.collection ) && ( index == rhs.index );
#    endif
    }

    bool operator!=( BufferCollectionImageCreateInfoFUCHSIA const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#  endif

  public:
    StructureType           sType      = StructureType::eBufferCollectionImageCreateInfoFUCHSIA;
    const void *            pNext      = {};
    BufferCollectionFUCHSIA collection = {};
    uint32_t                index      = {};
  };

  template <>
  struct CppType<StructureType, StructureType::eBufferCollectionImageCreateInfoFUCHSIA>
  {
    using Type = BufferCollectionImageCreateInfoFUCHSIA;
  };
#endif /*VK_USE_PLATFORM_FUCHSIA*/

#if defined( VK_USE_PLATFORM_FUCHSIA )
  // wrapper struct for struct VkSysmemColorSpaceFUCHSIA, see https://registry.khronos.org/vulkan/specs/latest/man/html/VkSysmemColorSpaceFUCHSIA.html
  struct SysmemColorSpaceFUCHSIA
  {
    using NativeType = VkSysmemColorSpaceFUCHSIA;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eSysmemColorSpaceFUCHSIA;

#  if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR SysmemColorSpaceFUCHSIA( uint32_t colorSpace_ = {}, const void * pNext_ = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , colorSpace{ colorSpace_ }
    {
    }

    VULKAN_HPP_CONSTEXPR SysmemColorSpaceFUCHSIA( SysmemColorSpaceFUCHSIA const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    SysmemColorSpaceFUCHSIA( VkSysmemColorSpaceFUCHSIA const & rhs ) VULKAN_HPP_NOEXCEPT
      : SysmemColorSpaceFUCHSIA( *reinterpret_cast<SysmemColorSpaceFUCHSIA const *>( &rhs ) )
    {
    }

    SysmemColorSpaceFUCHSIA & operator=( SysmemColorSpaceFUCHSIA const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#  endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    SysmemColorSpaceFUCHSIA & operator=( VkSysmemColorSpaceFUCHSIA const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<SysmemColorSpaceFUCHSIA const *>( &rhs );
      return *this;
    }

#  if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 SysmemColorSpaceFUCHSIA & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 SysmemColorSpaceFUCHSIA & setColorSpace( uint32_t colorSpace_ ) VULKAN_HPP_NOEXCEPT
    {
      colorSpace = colorSpace_;
      return *this;
    }
#  endif /*VULKAN_HPP_NO_SETTERS*/

    operator VkSysmemColorSpaceFUCHSIA const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkSysmemColorSpaceFUCHSIA *>( this );
    }

    operator VkSysmemColorSpaceFUCHSIA &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkSysmemColorSpaceFUCHSIA *>( this );
    }

    operator VkSysmemColorSpaceFUCHSIA const *() const VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<const VkSysmemColorSpaceFUCHSIA *>( this );
    }

    operator VkSysmemColorSpaceFUCHSIA *() VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<VkSysmemColorSpaceFUCHSIA *>( this );
    }

#  if defined( VULKAN_HPP_USE_REFLECT )
#    if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#    else
    std::tuple<StructureType const &, const void * const &, uint32_t const &>
#    endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, colorSpace );
    }
#  endif

#  if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( SysmemColorSpaceFUCHSIA const & ) const = default;
#  else
    bool operator==( SysmemColorSpaceFUCHSIA const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#    if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#    else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( colorSpace == rhs.colorSpace );
#    endif
    }

    bool operator!=( SysmemColorSpaceFUCHSIA const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#  endif

  public:
    StructureType sType      = StructureType::eSysmemColorSpaceFUCHSIA;
    const void *  pNext      = {};
    uint32_t      colorSpace = {};
  };

  template <>
  struct CppType<StructureType, StructureType::eSysmemColorSpaceFUCHSIA>
  {
    using Type = SysmemColorSpaceFUCHSIA;
  };
#endif /*VK_USE_PLATFORM_FUCHSIA*/

#if defined( VK_USE_PLATFORM_FUCHSIA )
  // wrapper struct for struct VkBufferCollectionPropertiesFUCHSIA, see
  // https://registry.khronos.org/vulkan/specs/latest/man/html/VkBufferCollectionPropertiesFUCHSIA.html
  struct BufferCollectionPropertiesFUCHSIA
  {
    using NativeType = VkBufferCollectionPropertiesFUCHSIA;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eBufferCollectionPropertiesFUCHSIA;

#  if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR BufferCollectionPropertiesFUCHSIA( uint32_t                    memoryTypeBits_                   = {},
                                                            uint32_t                    bufferCount_                      = {},
                                                            uint32_t                    createInfoIndex_                  = {},
                                                            uint64_t                    sysmemPixelFormat_                = {},
                                                            FormatFeatureFlags          formatFeatures_                   = {},
                                                            SysmemColorSpaceFUCHSIA     sysmemColorSpaceIndex_            = {},
                                                            ComponentMapping            samplerYcbcrConversionComponents_ = {},
                                                            SamplerYcbcrModelConversion suggestedYcbcrModel_    = SamplerYcbcrModelConversion::eRgbIdentity,
                                                            SamplerYcbcrRange           suggestedYcbcrRange_    = SamplerYcbcrRange::eItuFull,
                                                            ChromaLocation              suggestedXChromaOffset_ = ChromaLocation::eCositedEven,
                                                            ChromaLocation              suggestedYChromaOffset_ = ChromaLocation::eCositedEven,
                                                            void *                      pNext_                  = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , memoryTypeBits{ memoryTypeBits_ }
      , bufferCount{ bufferCount_ }
      , createInfoIndex{ createInfoIndex_ }
      , sysmemPixelFormat{ sysmemPixelFormat_ }
      , formatFeatures{ formatFeatures_ }
      , sysmemColorSpaceIndex{ sysmemColorSpaceIndex_ }
      , samplerYcbcrConversionComponents{ samplerYcbcrConversionComponents_ }
      , suggestedYcbcrModel{ suggestedYcbcrModel_ }
      , suggestedYcbcrRange{ suggestedYcbcrRange_ }
      , suggestedXChromaOffset{ suggestedXChromaOffset_ }
      , suggestedYChromaOffset{ suggestedYChromaOffset_ }
    {
    }

    VULKAN_HPP_CONSTEXPR BufferCollectionPropertiesFUCHSIA( BufferCollectionPropertiesFUCHSIA const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    BufferCollectionPropertiesFUCHSIA( VkBufferCollectionPropertiesFUCHSIA const & rhs ) VULKAN_HPP_NOEXCEPT
      : BufferCollectionPropertiesFUCHSIA( *reinterpret_cast<BufferCollectionPropertiesFUCHSIA const *>( &rhs ) )
    {
    }

    BufferCollectionPropertiesFUCHSIA & operator=( BufferCollectionPropertiesFUCHSIA const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#  endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    BufferCollectionPropertiesFUCHSIA & operator=( VkBufferCollectionPropertiesFUCHSIA const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<BufferCollectionPropertiesFUCHSIA const *>( &rhs );
      return *this;
    }

    operator VkBufferCollectionPropertiesFUCHSIA const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkBufferCollectionPropertiesFUCHSIA *>( this );
    }

    operator VkBufferCollectionPropertiesFUCHSIA &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkBufferCollectionPropertiesFUCHSIA *>( this );
    }

    operator VkBufferCollectionPropertiesFUCHSIA const *() const VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<const VkBufferCollectionPropertiesFUCHSIA *>( this );
    }

    operator VkBufferCollectionPropertiesFUCHSIA *() VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<VkBufferCollectionPropertiesFUCHSIA *>( this );
    }

#  if defined( VULKAN_HPP_USE_REFLECT )
#    if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#    else
    std::tuple<StructureType const &,
               void * const &,
               uint32_t const &,
               uint32_t const &,
               uint32_t const &,
               uint64_t const &,
               FormatFeatureFlags const &,
               SysmemColorSpaceFUCHSIA const &,
               ComponentMapping const &,
               SamplerYcbcrModelConversion const &,
               SamplerYcbcrRange const &,
               ChromaLocation const &,
               ChromaLocation const &>
#    endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType,
                       pNext,
                       memoryTypeBits,
                       bufferCount,
                       createInfoIndex,
                       sysmemPixelFormat,
                       formatFeatures,
                       sysmemColorSpaceIndex,
                       samplerYcbcrConversionComponents,
                       suggestedYcbcrModel,
                       suggestedYcbcrRange,
                       suggestedXChromaOffset,
                       suggestedYChromaOffset );
    }
#  endif

#  if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( BufferCollectionPropertiesFUCHSIA const & ) const = default;
#  else
    bool operator==( BufferCollectionPropertiesFUCHSIA const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#    if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#    else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( memoryTypeBits == rhs.memoryTypeBits ) && ( bufferCount == rhs.bufferCount ) &&
             ( createInfoIndex == rhs.createInfoIndex ) && ( sysmemPixelFormat == rhs.sysmemPixelFormat ) && ( formatFeatures == rhs.formatFeatures ) &&
             ( sysmemColorSpaceIndex == rhs.sysmemColorSpaceIndex ) && ( samplerYcbcrConversionComponents == rhs.samplerYcbcrConversionComponents ) &&
             ( suggestedYcbcrModel == rhs.suggestedYcbcrModel ) && ( suggestedYcbcrRange == rhs.suggestedYcbcrRange ) &&
             ( suggestedXChromaOffset == rhs.suggestedXChromaOffset ) && ( suggestedYChromaOffset == rhs.suggestedYChromaOffset );
#    endif
    }

    bool operator!=( BufferCollectionPropertiesFUCHSIA const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#  endif

  public:
    StructureType               sType                            = StructureType::eBufferCollectionPropertiesFUCHSIA;
    void *                      pNext                            = {};
    uint32_t                    memoryTypeBits                   = {};
    uint32_t                    bufferCount                      = {};
    uint32_t                    createInfoIndex                  = {};
    uint64_t                    sysmemPixelFormat                = {};
    FormatFeatureFlags          formatFeatures                   = {};
    SysmemColorSpaceFUCHSIA     sysmemColorSpaceIndex            = {};
    ComponentMapping            samplerYcbcrConversionComponents = {};
    SamplerYcbcrModelConversion suggestedYcbcrModel              = SamplerYcbcrModelConversion::eRgbIdentity;
    SamplerYcbcrRange           suggestedYcbcrRange              = SamplerYcbcrRange::eItuFull;
    ChromaLocation              suggestedXChromaOffset           = ChromaLocation::eCositedEven;
    ChromaLocation              suggestedYChromaOffset           = ChromaLocation::eCositedEven;
  };

  template <>
  struct CppType<StructureType, StructureType::eBufferCollectionPropertiesFUCHSIA>
  {
    using Type = BufferCollectionPropertiesFUCHSIA;
  };
#endif /*VK_USE_PLATFORM_FUCHSIA*/

  // wrapper struct for struct VkBufferCreateInfo, see https://registry.khronos.org/vulkan/specs/latest/man/html/VkBufferCreateInfo.html
  struct BufferCreateInfo
  {
    using NativeType = VkBufferCreateInfo;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eBufferCreateInfo;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR BufferCreateInfo( BufferCreateFlags flags_                 = {},
                                           DeviceSize        size_                  = {},
                                           BufferUsageFlags  usage_                 = {},
                                           SharingMode       sharingMode_           = SharingMode::eExclusive,
                                           uint32_t          queueFamilyIndexCount_ = {},
                                           const uint32_t *  pQueueFamilyIndices_   = {},
                                           const void *      pNext_                 = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , flags{ flags_ }
      , size{ size_ }
      , usage{ usage_ }
      , sharingMode{ sharingMode_ }
      , queueFamilyIndexCount{ queueFamilyIndexCount_ }
      , pQueueFamilyIndices{ pQueueFamilyIndices_ }
    {
    }

    VULKAN_HPP_CONSTEXPR BufferCreateInfo( BufferCreateInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    BufferCreateInfo( VkBufferCreateInfo const & rhs ) VULKAN_HPP_NOEXCEPT : BufferCreateInfo( *reinterpret_cast<BufferCreateInfo const *>( &rhs ) ) {}

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    BufferCreateInfo( BufferCreateFlags                               flags_,
                      DeviceSize                                      size_,
                      BufferUsageFlags                                usage_,
                      SharingMode                                     sharingMode_,
                      ArrayProxyNoTemporaries<const uint32_t> const & queueFamilyIndices_,
                      const void *                                    pNext_ = nullptr )
      : pNext( pNext_ )
      , flags( flags_ )
      , size( size_ )
      , usage( usage_ )
      , sharingMode( sharingMode_ )
      , queueFamilyIndexCount( static_cast<uint32_t>( queueFamilyIndices_.size() ) )
      , pQueueFamilyIndices( queueFamilyIndices_.data() )
    {
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/

    BufferCreateInfo & operator=( BufferCreateInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    BufferCreateInfo & operator=( VkBufferCreateInfo const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<BufferCreateInfo const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 BufferCreateInfo & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BufferCreateInfo & setFlags( BufferCreateFlags flags_ ) VULKAN_HPP_NOEXCEPT
    {
      flags = flags_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BufferCreateInfo & setSize( DeviceSize size_ ) VULKAN_HPP_NOEXCEPT
    {
      size = size_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BufferCreateInfo & setUsage( BufferUsageFlags usage_ ) VULKAN_HPP_NOEXCEPT
    {
      usage = usage_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BufferCreateInfo & setSharingMode( SharingMode sharingMode_ ) VULKAN_HPP_NOEXCEPT
    {
      sharingMode = sharingMode_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BufferCreateInfo & setQueueFamilyIndexCount( uint32_t queueFamilyIndexCount_ ) VULKAN_HPP_NOEXCEPT
    {
      queueFamilyIndexCount = queueFamilyIndexCount_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BufferCreateInfo & setPQueueFamilyIndices( const uint32_t * pQueueFamilyIndices_ ) VULKAN_HPP_NOEXCEPT
    {
      pQueueFamilyIndices = pQueueFamilyIndices_;
      return *this;
    }

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    BufferCreateInfo & setQueueFamilyIndices( ArrayProxyNoTemporaries<const uint32_t> const & queueFamilyIndices_ ) VULKAN_HPP_NOEXCEPT
    {
      queueFamilyIndexCount = static_cast<uint32_t>( queueFamilyIndices_.size() );
      pQueueFamilyIndices   = queueFamilyIndices_.data();
      return *this;
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/
#endif   /*VULKAN_HPP_NO_SETTERS*/

    operator VkBufferCreateInfo const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkBufferCreateInfo *>( this );
    }

    operator VkBufferCreateInfo &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkBufferCreateInfo *>( this );
    }

    operator VkBufferCreateInfo const *() const VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<const VkBufferCreateInfo *>( this );
    }

    operator VkBufferCreateInfo *() VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<VkBufferCreateInfo *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<StructureType const &,
               const void * const &,
               BufferCreateFlags const &,
               DeviceSize const &,
               BufferUsageFlags const &,
               SharingMode const &,
               uint32_t const &,
               const uint32_t * const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, flags, size, usage, sharingMode, queueFamilyIndexCount, pQueueFamilyIndices );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( BufferCreateInfo const & ) const = default;
#else
    bool operator==( BufferCreateInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( flags == rhs.flags ) && ( size == rhs.size ) && ( usage == rhs.usage ) &&
             ( sharingMode == rhs.sharingMode ) && ( queueFamilyIndexCount == rhs.queueFamilyIndexCount ) && ( pQueueFamilyIndices == rhs.pQueueFamilyIndices );
#  endif
    }

    bool operator!=( BufferCreateInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    StructureType     sType                 = StructureType::eBufferCreateInfo;
    const void *      pNext                 = {};
    BufferCreateFlags flags                 = {};
    DeviceSize        size                  = {};
    BufferUsageFlags  usage                 = {};
    SharingMode       sharingMode           = SharingMode::eExclusive;
    uint32_t          queueFamilyIndexCount = {};
    const uint32_t *  pQueueFamilyIndices   = {};
  };

  template <>
  struct CppType<StructureType, StructureType::eBufferCreateInfo>
  {
    using Type = BufferCreateInfo;
  };

#if defined( VK_USE_PLATFORM_FUCHSIA )
  // wrapper struct for struct VkBufferConstraintsInfoFUCHSIA, see https://registry.khronos.org/vulkan/specs/latest/man/html/VkBufferConstraintsInfoFUCHSIA.html
  struct BufferConstraintsInfoFUCHSIA
  {
    using NativeType = VkBufferConstraintsInfoFUCHSIA;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eBufferConstraintsInfoFUCHSIA;

#  if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR BufferConstraintsInfoFUCHSIA( BufferCreateInfo                       createInfo_                  = {},
                                                       FormatFeatureFlags                     requiredFormatFeatures_      = {},
                                                       BufferCollectionConstraintsInfoFUCHSIA bufferCollectionConstraints_ = {},
                                                       const void *                           pNext_                       = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , createInfo{ createInfo_ }
      , requiredFormatFeatures{ requiredFormatFeatures_ }
      , bufferCollectionConstraints{ bufferCollectionConstraints_ }
    {
    }

    VULKAN_HPP_CONSTEXPR BufferConstraintsInfoFUCHSIA( BufferConstraintsInfoFUCHSIA const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    BufferConstraintsInfoFUCHSIA( VkBufferConstraintsInfoFUCHSIA const & rhs ) VULKAN_HPP_NOEXCEPT
      : BufferConstraintsInfoFUCHSIA( *reinterpret_cast<BufferConstraintsInfoFUCHSIA const *>( &rhs ) )
    {
    }

    BufferConstraintsInfoFUCHSIA & operator=( BufferConstraintsInfoFUCHSIA const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#  endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    BufferConstraintsInfoFUCHSIA & operator=( VkBufferConstraintsInfoFUCHSIA const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<BufferConstraintsInfoFUCHSIA const *>( &rhs );
      return *this;
    }

#  if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 BufferConstraintsInfoFUCHSIA & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BufferConstraintsInfoFUCHSIA & setCreateInfo( BufferCreateInfo const & createInfo_ ) VULKAN_HPP_NOEXCEPT
    {
      createInfo = createInfo_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BufferConstraintsInfoFUCHSIA & setRequiredFormatFeatures( FormatFeatureFlags requiredFormatFeatures_ ) VULKAN_HPP_NOEXCEPT
    {
      requiredFormatFeatures = requiredFormatFeatures_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BufferConstraintsInfoFUCHSIA &
      setBufferCollectionConstraints( BufferCollectionConstraintsInfoFUCHSIA const & bufferCollectionConstraints_ ) VULKAN_HPP_NOEXCEPT
    {
      bufferCollectionConstraints = bufferCollectionConstraints_;
      return *this;
    }
#  endif /*VULKAN_HPP_NO_SETTERS*/

    operator VkBufferConstraintsInfoFUCHSIA const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkBufferConstraintsInfoFUCHSIA *>( this );
    }

    operator VkBufferConstraintsInfoFUCHSIA &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkBufferConstraintsInfoFUCHSIA *>( this );
    }

    operator VkBufferConstraintsInfoFUCHSIA const *() const VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<const VkBufferConstraintsInfoFUCHSIA *>( this );
    }

    operator VkBufferConstraintsInfoFUCHSIA *() VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<VkBufferConstraintsInfoFUCHSIA *>( this );
    }

#  if defined( VULKAN_HPP_USE_REFLECT )
#    if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#    else
    std::
      tuple<StructureType const &, const void * const &, BufferCreateInfo const &, FormatFeatureFlags const &, BufferCollectionConstraintsInfoFUCHSIA const &>
#    endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, createInfo, requiredFormatFeatures, bufferCollectionConstraints );
    }
#  endif

#  if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( BufferConstraintsInfoFUCHSIA const & ) const = default;
#  else
    bool operator==( BufferConstraintsInfoFUCHSIA const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#    if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#    else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( createInfo == rhs.createInfo ) && ( requiredFormatFeatures == rhs.requiredFormatFeatures ) &&
             ( bufferCollectionConstraints == rhs.bufferCollectionConstraints );
#    endif
    }

    bool operator!=( BufferConstraintsInfoFUCHSIA const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#  endif

  public:
    StructureType                          sType                       = StructureType::eBufferConstraintsInfoFUCHSIA;
    const void *                           pNext                       = {};
    BufferCreateInfo                       createInfo                  = {};
    FormatFeatureFlags                     requiredFormatFeatures      = {};
    BufferCollectionConstraintsInfoFUCHSIA bufferCollectionConstraints = {};
  };

  template <>
  struct CppType<StructureType, StructureType::eBufferConstraintsInfoFUCHSIA>
  {
    using Type = BufferConstraintsInfoFUCHSIA;
  };
#endif /*VK_USE_PLATFORM_FUCHSIA*/

  // wrapper struct for struct VkBufferCopy, see https://registry.khronos.org/vulkan/specs/latest/man/html/VkBufferCopy.html
  struct BufferCopy
  {
    using NativeType = VkBufferCopy;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR BufferCopy( DeviceSize srcOffset_ = {}, DeviceSize dstOffset_ = {}, DeviceSize size_ = {} ) VULKAN_HPP_NOEXCEPT
      : srcOffset{ srcOffset_ }
      , dstOffset{ dstOffset_ }
      , size{ size_ }
    {
    }

    VULKAN_HPP_CONSTEXPR BufferCopy( BufferCopy const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    BufferCopy( VkBufferCopy const & rhs ) VULKAN_HPP_NOEXCEPT : BufferCopy( *reinterpret_cast<BufferCopy const *>( &rhs ) ) {}

    BufferCopy & operator=( BufferCopy const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    BufferCopy & operator=( VkBufferCopy const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<BufferCopy const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 BufferCopy & setSrcOffset( DeviceSize srcOffset_ ) VULKAN_HPP_NOEXCEPT
    {
      srcOffset = srcOffset_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BufferCopy & setDstOffset( DeviceSize dstOffset_ ) VULKAN_HPP_NOEXCEPT
    {
      dstOffset = dstOffset_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BufferCopy & setSize( DeviceSize size_ ) VULKAN_HPP_NOEXCEPT
    {
      size = size_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_SETTERS*/

    operator VkBufferCopy const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkBufferCopy *>( this );
    }

    operator VkBufferCopy &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkBufferCopy *>( this );
    }

    operator VkBufferCopy const *() const VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<const VkBufferCopy *>( this );
    }

    operator VkBufferCopy *() VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<VkBufferCopy *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<DeviceSize const &, DeviceSize const &, DeviceSize const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( srcOffset, dstOffset, size );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( BufferCopy const & ) const = default;
#else
    bool operator==( BufferCopy const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( srcOffset == rhs.srcOffset ) && ( dstOffset == rhs.dstOffset ) && ( size == rhs.size );
#  endif
    }

    bool operator!=( BufferCopy const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    DeviceSize srcOffset = {};
    DeviceSize dstOffset = {};
    DeviceSize size      = {};
  };

  // wrapper struct for struct VkBufferCopy2, see https://registry.khronos.org/vulkan/specs/latest/man/html/VkBufferCopy2.html
  struct BufferCopy2
  {
    using NativeType = VkBufferCopy2;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eBufferCopy2;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR
      BufferCopy2( DeviceSize srcOffset_ = {}, DeviceSize dstOffset_ = {}, DeviceSize size_ = {}, const void * pNext_ = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , srcOffset{ srcOffset_ }
      , dstOffset{ dstOffset_ }
      , size{ size_ }
    {
    }

    VULKAN_HPP_CONSTEXPR BufferCopy2( BufferCopy2 const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    BufferCopy2( VkBufferCopy2 const & rhs ) VULKAN_HPP_NOEXCEPT : BufferCopy2( *reinterpret_cast<BufferCopy2 const *>( &rhs ) ) {}

    BufferCopy2 & operator=( BufferCopy2 const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    BufferCopy2 & operator=( VkBufferCopy2 const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<BufferCopy2 const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 BufferCopy2 & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BufferCopy2 & setSrcOffset( DeviceSize srcOffset_ ) VULKAN_HPP_NOEXCEPT
    {
      srcOffset = srcOffset_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BufferCopy2 & setDstOffset( DeviceSize dstOffset_ ) VULKAN_HPP_NOEXCEPT
    {
      dstOffset = dstOffset_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BufferCopy2 & setSize( DeviceSize size_ ) VULKAN_HPP_NOEXCEPT
    {
      size = size_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_SETTERS*/

    operator VkBufferCopy2 const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkBufferCopy2 *>( this );
    }

    operator VkBufferCopy2 &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkBufferCopy2 *>( this );
    }

    operator VkBufferCopy2 const *() const VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<const VkBufferCopy2 *>( this );
    }

    operator VkBufferCopy2 *() VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<VkBufferCopy2 *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<StructureType const &, const void * const &, DeviceSize const &, DeviceSize const &, DeviceSize const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, srcOffset, dstOffset, size );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( BufferCopy2 const & ) const = default;
#else
    bool operator==( BufferCopy2 const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( srcOffset == rhs.srcOffset ) && ( dstOffset == rhs.dstOffset ) && ( size == rhs.size );
#  endif
    }

    bool operator!=( BufferCopy2 const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    StructureType sType     = StructureType::eBufferCopy2;
    const void *  pNext     = {};
    DeviceSize    srcOffset = {};
    DeviceSize    dstOffset = {};
    DeviceSize    size      = {};
  };

  template <>
  struct CppType<StructureType, StructureType::eBufferCopy2>
  {
    using Type = BufferCopy2;
  };

  using BufferCopy2KHR = BufferCopy2;

  // wrapper struct for struct VkBufferDeviceAddressCreateInfoEXT, see
  // https://registry.khronos.org/vulkan/specs/latest/man/html/VkBufferDeviceAddressCreateInfoEXT.html
  struct BufferDeviceAddressCreateInfoEXT
  {
    using NativeType = VkBufferDeviceAddressCreateInfoEXT;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eBufferDeviceAddressCreateInfoEXT;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR BufferDeviceAddressCreateInfoEXT( DeviceAddress deviceAddress_ = {}, const void * pNext_ = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , deviceAddress{ deviceAddress_ }
    {
    }

    VULKAN_HPP_CONSTEXPR BufferDeviceAddressCreateInfoEXT( BufferDeviceAddressCreateInfoEXT const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    BufferDeviceAddressCreateInfoEXT( VkBufferDeviceAddressCreateInfoEXT const & rhs ) VULKAN_HPP_NOEXCEPT
      : BufferDeviceAddressCreateInfoEXT( *reinterpret_cast<BufferDeviceAddressCreateInfoEXT const *>( &rhs ) )
    {
    }

    BufferDeviceAddressCreateInfoEXT & operator=( BufferDeviceAddressCreateInfoEXT const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    BufferDeviceAddressCreateInfoEXT & operator=( VkBufferDeviceAddressCreateInfoEXT const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<BufferDeviceAddressCreateInfoEXT const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 BufferDeviceAddressCreateInfoEXT & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BufferDeviceAddressCreateInfoEXT & setDeviceAddress( DeviceAddress deviceAddress_ ) VULKAN_HPP_NOEXCEPT
    {
      deviceAddress = deviceAddress_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_SETTERS*/

    operator VkBufferDeviceAddressCreateInfoEXT const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkBufferDeviceAddressCreateInfoEXT *>( this );
    }

    operator VkBufferDeviceAddressCreateInfoEXT &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkBufferDeviceAddressCreateInfoEXT *>( this );
    }

    operator VkBufferDeviceAddressCreateInfoEXT const *() const VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<const VkBufferDeviceAddressCreateInfoEXT *>( this );
    }

    operator VkBufferDeviceAddressCreateInfoEXT *() VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<VkBufferDeviceAddressCreateInfoEXT *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<StructureType const &, const void * const &, DeviceAddress const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, deviceAddress );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( BufferDeviceAddressCreateInfoEXT const & ) const = default;
#else
    bool operator==( BufferDeviceAddressCreateInfoEXT const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( deviceAddress == rhs.deviceAddress );
#  endif
    }

    bool operator!=( BufferDeviceAddressCreateInfoEXT const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    StructureType sType         = StructureType::eBufferDeviceAddressCreateInfoEXT;
    const void *  pNext         = {};
    DeviceAddress deviceAddress = {};
  };

  template <>
  struct CppType<StructureType, StructureType::eBufferDeviceAddressCreateInfoEXT>
  {
    using Type = BufferDeviceAddressCreateInfoEXT;
  };

  // wrapper struct for struct VkBufferDeviceAddressInfo, see https://registry.khronos.org/vulkan/specs/latest/man/html/VkBufferDeviceAddressInfo.html
  struct BufferDeviceAddressInfo
  {
    using NativeType = VkBufferDeviceAddressInfo;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eBufferDeviceAddressInfo;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR BufferDeviceAddressInfo( Buffer buffer_ = {}, const void * pNext_ = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , buffer{ buffer_ }
    {
    }

    VULKAN_HPP_CONSTEXPR BufferDeviceAddressInfo( BufferDeviceAddressInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    BufferDeviceAddressInfo( VkBufferDeviceAddressInfo const & rhs ) VULKAN_HPP_NOEXCEPT
      : BufferDeviceAddressInfo( *reinterpret_cast<BufferDeviceAddressInfo const *>( &rhs ) )
    {
    }

    BufferDeviceAddressInfo & operator=( BufferDeviceAddressInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    BufferDeviceAddressInfo & operator=( VkBufferDeviceAddressInfo const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<BufferDeviceAddressInfo const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 BufferDeviceAddressInfo & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BufferDeviceAddressInfo & setBuffer( Buffer buffer_ ) VULKAN_HPP_NOEXCEPT
    {
      buffer = buffer_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_SETTERS*/

    operator VkBufferDeviceAddressInfo const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkBufferDeviceAddressInfo *>( this );
    }

    operator VkBufferDeviceAddressInfo &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkBufferDeviceAddressInfo *>( this );
    }

    operator VkBufferDeviceAddressInfo const *() const VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<const VkBufferDeviceAddressInfo *>( this );
    }

    operator VkBufferDeviceAddressInfo *() VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<VkBufferDeviceAddressInfo *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<StructureType const &, const void * const &, Buffer const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, buffer );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( BufferDeviceAddressInfo const & ) const = default;
#else
    bool operator==( BufferDeviceAddressInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( buffer == rhs.buffer );
#  endif
    }

    bool operator!=( BufferDeviceAddressInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    StructureType sType  = StructureType::eBufferDeviceAddressInfo;
    const void *  pNext  = {};
    Buffer        buffer = {};
  };

  template <>
  struct CppType<StructureType, StructureType::eBufferDeviceAddressInfo>
  {
    using Type = BufferDeviceAddressInfo;
  };

  using BufferDeviceAddressInfoEXT = BufferDeviceAddressInfo;
  using BufferDeviceAddressInfoKHR = BufferDeviceAddressInfo;

  // wrapper struct for struct VkBufferImageCopy, see https://registry.khronos.org/vulkan/specs/latest/man/html/VkBufferImageCopy.html
  struct BufferImageCopy
  {
    using NativeType = VkBufferImageCopy;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR BufferImageCopy( DeviceSize             bufferOffset_      = {},
                                          uint32_t               bufferRowLength_   = {},
                                          uint32_t               bufferImageHeight_ = {},
                                          ImageSubresourceLayers imageSubresource_  = {},
                                          Offset3D               imageOffset_       = {},
                                          Extent3D               imageExtent_       = {} ) VULKAN_HPP_NOEXCEPT
      : bufferOffset{ bufferOffset_ }
      , bufferRowLength{ bufferRowLength_ }
      , bufferImageHeight{ bufferImageHeight_ }
      , imageSubresource{ imageSubresource_ }
      , imageOffset{ imageOffset_ }
      , imageExtent{ imageExtent_ }
    {
    }

    VULKAN_HPP_CONSTEXPR BufferImageCopy( BufferImageCopy const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    BufferImageCopy( VkBufferImageCopy const & rhs ) VULKAN_HPP_NOEXCEPT : BufferImageCopy( *reinterpret_cast<BufferImageCopy const *>( &rhs ) ) {}

    BufferImageCopy & operator=( BufferImageCopy const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    BufferImageCopy & operator=( VkBufferImageCopy const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<BufferImageCopy const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 BufferImageCopy & setBufferOffset( DeviceSize bufferOffset_ ) VULKAN_HPP_NOEXCEPT
    {
      bufferOffset = bufferOffset_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BufferImageCopy & setBufferRowLength( uint32_t bufferRowLength_ ) VULKAN_HPP_NOEXCEPT
    {
      bufferRowLength = bufferRowLength_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BufferImageCopy & setBufferImageHeight( uint32_t bufferImageHeight_ ) VULKAN_HPP_NOEXCEPT
    {
      bufferImageHeight = bufferImageHeight_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BufferImageCopy & setImageSubresource( ImageSubresourceLayers const & imageSubresource_ ) VULKAN_HPP_NOEXCEPT
    {
      imageSubresource = imageSubresource_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BufferImageCopy & setImageOffset( Offset3D const & imageOffset_ ) VULKAN_HPP_NOEXCEPT
    {
      imageOffset = imageOffset_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BufferImageCopy & setImageExtent( Extent3D const & imageExtent_ ) VULKAN_HPP_NOEXCEPT
    {
      imageExtent = imageExtent_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_SETTERS*/

    operator VkBufferImageCopy const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkBufferImageCopy *>( this );
    }

    operator VkBufferImageCopy &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkBufferImageCopy *>( this );
    }

    operator VkBufferImageCopy const *() const VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<const VkBufferImageCopy *>( this );
    }

    operator VkBufferImageCopy *() VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<VkBufferImageCopy *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<DeviceSize const &, uint32_t const &, uint32_t const &, ImageSubresourceLayers const &, Offset3D const &, Extent3D const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( bufferOffset, bufferRowLength, bufferImageHeight, imageSubresource, imageOffset, imageExtent );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( BufferImageCopy const & ) const = default;
#else
    bool operator==( BufferImageCopy const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( bufferOffset == rhs.bufferOffset ) && ( bufferRowLength == rhs.bufferRowLength ) && ( bufferImageHeight == rhs.bufferImageHeight ) &&
             ( imageSubresource == rhs.imageSubresource ) && ( imageOffset == rhs.imageOffset ) && ( imageExtent == rhs.imageExtent );
#  endif
    }

    bool operator!=( BufferImageCopy const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    DeviceSize             bufferOffset      = {};
    uint32_t               bufferRowLength   = {};
    uint32_t               bufferImageHeight = {};
    ImageSubresourceLayers imageSubresource  = {};
    Offset3D               imageOffset       = {};
    Extent3D               imageExtent       = {};
  };

  // wrapper struct for struct VkBufferImageCopy2, see https://registry.khronos.org/vulkan/specs/latest/man/html/VkBufferImageCopy2.html
  struct BufferImageCopy2
  {
    using NativeType = VkBufferImageCopy2;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eBufferImageCopy2;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR BufferImageCopy2( DeviceSize             bufferOffset_      = {},
                                           uint32_t               bufferRowLength_   = {},
                                           uint32_t               bufferImageHeight_ = {},
                                           ImageSubresourceLayers imageSubresource_  = {},
                                           Offset3D               imageOffset_       = {},
                                           Extent3D               imageExtent_       = {},
                                           const void *           pNext_             = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , bufferOffset{ bufferOffset_ }
      , bufferRowLength{ bufferRowLength_ }
      , bufferImageHeight{ bufferImageHeight_ }
      , imageSubresource{ imageSubresource_ }
      , imageOffset{ imageOffset_ }
      , imageExtent{ imageExtent_ }
    {
    }

    VULKAN_HPP_CONSTEXPR BufferImageCopy2( BufferImageCopy2 const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    BufferImageCopy2( VkBufferImageCopy2 const & rhs ) VULKAN_HPP_NOEXCEPT : BufferImageCopy2( *reinterpret_cast<BufferImageCopy2 const *>( &rhs ) ) {}

    BufferImageCopy2 & operator=( BufferImageCopy2 const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    BufferImageCopy2 & operator=( VkBufferImageCopy2 const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<BufferImageCopy2 const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 BufferImageCopy2 & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BufferImageCopy2 & setBufferOffset( DeviceSize bufferOffset_ ) VULKAN_HPP_NOEXCEPT
    {
      bufferOffset = bufferOffset_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BufferImageCopy2 & setBufferRowLength( uint32_t bufferRowLength_ ) VULKAN_HPP_NOEXCEPT
    {
      bufferRowLength = bufferRowLength_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BufferImageCopy2 & setBufferImageHeight( uint32_t bufferImageHeight_ ) VULKAN_HPP_NOEXCEPT
    {
      bufferImageHeight = bufferImageHeight_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BufferImageCopy2 & setImageSubresource( ImageSubresourceLayers const & imageSubresource_ ) VULKAN_HPP_NOEXCEPT
    {
      imageSubresource = imageSubresource_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BufferImageCopy2 & setImageOffset( Offset3D const & imageOffset_ ) VULKAN_HPP_NOEXCEPT
    {
      imageOffset = imageOffset_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BufferImageCopy2 & setImageExtent( Extent3D const & imageExtent_ ) VULKAN_HPP_NOEXCEPT
    {
      imageExtent = imageExtent_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_SETTERS*/

    operator VkBufferImageCopy2 const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkBufferImageCopy2 *>( this );
    }

    operator VkBufferImageCopy2 &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkBufferImageCopy2 *>( this );
    }

    operator VkBufferImageCopy2 const *() const VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<const VkBufferImageCopy2 *>( this );
    }

    operator VkBufferImageCopy2 *() VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<VkBufferImageCopy2 *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<StructureType const &,
               const void * const &,
               DeviceSize const &,
               uint32_t const &,
               uint32_t const &,
               ImageSubresourceLayers const &,
               Offset3D const &,
               Extent3D const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, bufferOffset, bufferRowLength, bufferImageHeight, imageSubresource, imageOffset, imageExtent );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( BufferImageCopy2 const & ) const = default;
#else
    bool operator==( BufferImageCopy2 const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( bufferOffset == rhs.bufferOffset ) && ( bufferRowLength == rhs.bufferRowLength ) &&
             ( bufferImageHeight == rhs.bufferImageHeight ) && ( imageSubresource == rhs.imageSubresource ) && ( imageOffset == rhs.imageOffset ) &&
             ( imageExtent == rhs.imageExtent );
#  endif
    }

    bool operator!=( BufferImageCopy2 const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    StructureType          sType             = StructureType::eBufferImageCopy2;
    const void *           pNext             = {};
    DeviceSize             bufferOffset      = {};
    uint32_t               bufferRowLength   = {};
    uint32_t               bufferImageHeight = {};
    ImageSubresourceLayers imageSubresource  = {};
    Offset3D               imageOffset       = {};
    Extent3D               imageExtent       = {};
  };

  template <>
  struct CppType<StructureType, StructureType::eBufferImageCopy2>
  {
    using Type = BufferImageCopy2;
  };

  using BufferImageCopy2KHR = BufferImageCopy2;

  // wrapper struct for struct VkBufferMemoryBarrier, see https://registry.khronos.org/vulkan/specs/latest/man/html/VkBufferMemoryBarrier.html
  struct BufferMemoryBarrier
  {
    using NativeType = VkBufferMemoryBarrier;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eBufferMemoryBarrier;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR BufferMemoryBarrier( AccessFlags  srcAccessMask_       = {},
                                              AccessFlags  dstAccessMask_       = {},
                                              uint32_t     srcQueueFamilyIndex_ = {},
                                              uint32_t     dstQueueFamilyIndex_ = {},
                                              Buffer       buffer_              = {},
                                              DeviceSize   offset_              = {},
                                              DeviceSize   size_                = {},
                                              const void * pNext_               = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , srcAccessMask{ srcAccessMask_ }
      , dstAccessMask{ dstAccessMask_ }
      , srcQueueFamilyIndex{ srcQueueFamilyIndex_ }
      , dstQueueFamilyIndex{ dstQueueFamilyIndex_ }
      , buffer{ buffer_ }
      , offset{ offset_ }
      , size{ size_ }
    {
    }

    VULKAN_HPP_CONSTEXPR BufferMemoryBarrier( BufferMemoryBarrier const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    BufferMemoryBarrier( VkBufferMemoryBarrier const & rhs ) VULKAN_HPP_NOEXCEPT : BufferMemoryBarrier( *reinterpret_cast<BufferMemoryBarrier const *>( &rhs ) )
    {
    }

    BufferMemoryBarrier & operator=( BufferMemoryBarrier const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    BufferMemoryBarrier & operator=( VkBufferMemoryBarrier const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<BufferMemoryBarrier const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 BufferMemoryBarrier & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BufferMemoryBarrier & setSrcAccessMask( AccessFlags srcAccessMask_ ) VULKAN_HPP_NOEXCEPT
    {
      srcAccessMask = srcAccessMask_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BufferMemoryBarrier & setDstAccessMask( AccessFlags dstAccessMask_ ) VULKAN_HPP_NOEXCEPT
    {
      dstAccessMask = dstAccessMask_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BufferMemoryBarrier & setSrcQueueFamilyIndex( uint32_t srcQueueFamilyIndex_ ) VULKAN_HPP_NOEXCEPT
    {
      srcQueueFamilyIndex = srcQueueFamilyIndex_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BufferMemoryBarrier & setDstQueueFamilyIndex( uint32_t dstQueueFamilyIndex_ ) VULKAN_HPP_NOEXCEPT
    {
      dstQueueFamilyIndex = dstQueueFamilyIndex_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BufferMemoryBarrier & setBuffer( Buffer buffer_ ) VULKAN_HPP_NOEXCEPT
    {
      buffer = buffer_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BufferMemoryBarrier & setOffset( DeviceSize offset_ ) VULKAN_HPP_NOEXCEPT
    {
      offset = offset_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BufferMemoryBarrier & setSize( DeviceSize size_ ) VULKAN_HPP_NOEXCEPT
    {
      size = size_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_SETTERS*/

    operator VkBufferMemoryBarrier const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkBufferMemoryBarrier *>( this );
    }

    operator VkBufferMemoryBarrier &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkBufferMemoryBarrier *>( this );
    }

    operator VkBufferMemoryBarrier const *() const VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<const VkBufferMemoryBarrier *>( this );
    }

    operator VkBufferMemoryBarrier *() VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<VkBufferMemoryBarrier *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<StructureType const &,
               const void * const &,
               AccessFlags const &,
               AccessFlags const &,
               uint32_t const &,
               uint32_t const &,
               Buffer const &,
               DeviceSize const &,
               DeviceSize const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, srcAccessMask, dstAccessMask, srcQueueFamilyIndex, dstQueueFamilyIndex, buffer, offset, size );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( BufferMemoryBarrier const & ) const = default;
#else
    bool operator==( BufferMemoryBarrier const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( srcAccessMask == rhs.srcAccessMask ) && ( dstAccessMask == rhs.dstAccessMask ) &&
             ( srcQueueFamilyIndex == rhs.srcQueueFamilyIndex ) && ( dstQueueFamilyIndex == rhs.dstQueueFamilyIndex ) && ( buffer == rhs.buffer ) &&
             ( offset == rhs.offset ) && ( size == rhs.size );
#  endif
    }

    bool operator!=( BufferMemoryBarrier const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    StructureType sType               = StructureType::eBufferMemoryBarrier;
    const void *  pNext               = {};
    AccessFlags   srcAccessMask       = {};
    AccessFlags   dstAccessMask       = {};
    uint32_t      srcQueueFamilyIndex = {};
    uint32_t      dstQueueFamilyIndex = {};
    Buffer        buffer              = {};
    DeviceSize    offset              = {};
    DeviceSize    size                = {};
  };

  template <>
  struct CppType<StructureType, StructureType::eBufferMemoryBarrier>
  {
    using Type = BufferMemoryBarrier;
  };

  // wrapper struct for struct VkBufferMemoryBarrier2, see https://registry.khronos.org/vulkan/specs/latest/man/html/VkBufferMemoryBarrier2.html
  struct BufferMemoryBarrier2
  {
    using NativeType = VkBufferMemoryBarrier2;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eBufferMemoryBarrier2;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR BufferMemoryBarrier2( PipelineStageFlags2 srcStageMask_        = {},
                                               AccessFlags2        srcAccessMask_       = {},
                                               PipelineStageFlags2 dstStageMask_        = {},
                                               AccessFlags2        dstAccessMask_       = {},
                                               uint32_t            srcQueueFamilyIndex_ = {},
                                               uint32_t            dstQueueFamilyIndex_ = {},
                                               Buffer              buffer_              = {},
                                               DeviceSize          offset_              = {},
                                               DeviceSize          size_                = {},
                                               const void *        pNext_               = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , srcStageMask{ srcStageMask_ }
      , srcAccessMask{ srcAccessMask_ }
      , dstStageMask{ dstStageMask_ }
      , dstAccessMask{ dstAccessMask_ }
      , srcQueueFamilyIndex{ srcQueueFamilyIndex_ }
      , dstQueueFamilyIndex{ dstQueueFamilyIndex_ }
      , buffer{ buffer_ }
      , offset{ offset_ }
      , size{ size_ }
    {
    }

    VULKAN_HPP_CONSTEXPR BufferMemoryBarrier2( BufferMemoryBarrier2 const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    BufferMemoryBarrier2( VkBufferMemoryBarrier2 const & rhs ) VULKAN_HPP_NOEXCEPT
      : BufferMemoryBarrier2( *reinterpret_cast<BufferMemoryBarrier2 const *>( &rhs ) )
    {
    }

    BufferMemoryBarrier2 & operator=( BufferMemoryBarrier2 const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    BufferMemoryBarrier2 & operator=( VkBufferMemoryBarrier2 const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<BufferMemoryBarrier2 const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 BufferMemoryBarrier2 & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BufferMemoryBarrier2 & setSrcStageMask( PipelineStageFlags2 srcStageMask_ ) VULKAN_HPP_NOEXCEPT
    {
      srcStageMask = srcStageMask_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BufferMemoryBarrier2 & setSrcAccessMask( AccessFlags2 srcAccessMask_ ) VULKAN_HPP_NOEXCEPT
    {
      srcAccessMask = srcAccessMask_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BufferMemoryBarrier2 & setDstStageMask( PipelineStageFlags2 dstStageMask_ ) VULKAN_HPP_NOEXCEPT
    {
      dstStageMask = dstStageMask_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BufferMemoryBarrier2 & setDstAccessMask( AccessFlags2 dstAccessMask_ ) VULKAN_HPP_NOEXCEPT
    {
      dstAccessMask = dstAccessMask_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BufferMemoryBarrier2 & setSrcQueueFamilyIndex( uint32_t srcQueueFamilyIndex_ ) VULKAN_HPP_NOEXCEPT
    {
      srcQueueFamilyIndex = srcQueueFamilyIndex_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BufferMemoryBarrier2 & setDstQueueFamilyIndex( uint32_t dstQueueFamilyIndex_ ) VULKAN_HPP_NOEXCEPT
    {
      dstQueueFamilyIndex = dstQueueFamilyIndex_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BufferMemoryBarrier2 & setBuffer( Buffer buffer_ ) VULKAN_HPP_NOEXCEPT
    {
      buffer = buffer_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BufferMemoryBarrier2 & setOffset( DeviceSize offset_ ) VULKAN_HPP_NOEXCEPT
    {
      offset = offset_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BufferMemoryBarrier2 & setSize( DeviceSize size_ ) VULKAN_HPP_NOEXCEPT
    {
      size = size_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_SETTERS*/

    operator VkBufferMemoryBarrier2 const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkBufferMemoryBarrier2 *>( this );
    }

    operator VkBufferMemoryBarrier2 &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkBufferMemoryBarrier2 *>( this );
    }

    operator VkBufferMemoryBarrier2 const *() const VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<const VkBufferMemoryBarrier2 *>( this );
    }

    operator VkBufferMemoryBarrier2 *() VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<VkBufferMemoryBarrier2 *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<StructureType const &,
               const void * const &,
               PipelineStageFlags2 const &,
               AccessFlags2 const &,
               PipelineStageFlags2 const &,
               AccessFlags2 const &,
               uint32_t const &,
               uint32_t const &,
               Buffer const &,
               DeviceSize const &,
               DeviceSize const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, srcStageMask, srcAccessMask, dstStageMask, dstAccessMask, srcQueueFamilyIndex, dstQueueFamilyIndex, buffer, offset, size );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( BufferMemoryBarrier2 const & ) const = default;
#else
    bool operator==( BufferMemoryBarrier2 const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( srcStageMask == rhs.srcStageMask ) && ( srcAccessMask == rhs.srcAccessMask ) &&
             ( dstStageMask == rhs.dstStageMask ) && ( dstAccessMask == rhs.dstAccessMask ) && ( srcQueueFamilyIndex == rhs.srcQueueFamilyIndex ) &&
             ( dstQueueFamilyIndex == rhs.dstQueueFamilyIndex ) && ( buffer == rhs.buffer ) && ( offset == rhs.offset ) && ( size == rhs.size );
#  endif
    }

    bool operator!=( BufferMemoryBarrier2 const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    StructureType       sType               = StructureType::eBufferMemoryBarrier2;
    const void *        pNext               = {};
    PipelineStageFlags2 srcStageMask        = {};
    AccessFlags2        srcAccessMask       = {};
    PipelineStageFlags2 dstStageMask        = {};
    AccessFlags2        dstAccessMask       = {};
    uint32_t            srcQueueFamilyIndex = {};
    uint32_t            dstQueueFamilyIndex = {};
    Buffer              buffer              = {};
    DeviceSize          offset              = {};
    DeviceSize          size                = {};
  };

  template <>
  struct CppType<StructureType, StructureType::eBufferMemoryBarrier2>
  {
    using Type = BufferMemoryBarrier2;
  };

  using BufferMemoryBarrier2KHR = BufferMemoryBarrier2;

  // wrapper struct for struct VkBufferMemoryRequirementsInfo2, see
  // https://registry.khronos.org/vulkan/specs/latest/man/html/VkBufferMemoryRequirementsInfo2.html
  struct BufferMemoryRequirementsInfo2
  {
    using NativeType = VkBufferMemoryRequirementsInfo2;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eBufferMemoryRequirementsInfo2;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR BufferMemoryRequirementsInfo2( Buffer buffer_ = {}, const void * pNext_ = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , buffer{ buffer_ }
    {
    }

    VULKAN_HPP_CONSTEXPR BufferMemoryRequirementsInfo2( BufferMemoryRequirementsInfo2 const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    BufferMemoryRequirementsInfo2( VkBufferMemoryRequirementsInfo2 const & rhs ) VULKAN_HPP_NOEXCEPT
      : BufferMemoryRequirementsInfo2( *reinterpret_cast<BufferMemoryRequirementsInfo2 const *>( &rhs ) )
    {
    }

    BufferMemoryRequirementsInfo2 & operator=( BufferMemoryRequirementsInfo2 const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    BufferMemoryRequirementsInfo2 & operator=( VkBufferMemoryRequirementsInfo2 const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<BufferMemoryRequirementsInfo2 const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 BufferMemoryRequirementsInfo2 & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BufferMemoryRequirementsInfo2 & setBuffer( Buffer buffer_ ) VULKAN_HPP_NOEXCEPT
    {
      buffer = buffer_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_SETTERS*/

    operator VkBufferMemoryRequirementsInfo2 const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkBufferMemoryRequirementsInfo2 *>( this );
    }

    operator VkBufferMemoryRequirementsInfo2 &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkBufferMemoryRequirementsInfo2 *>( this );
    }

    operator VkBufferMemoryRequirementsInfo2 const *() const VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<const VkBufferMemoryRequirementsInfo2 *>( this );
    }

    operator VkBufferMemoryRequirementsInfo2 *() VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<VkBufferMemoryRequirementsInfo2 *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<StructureType const &, const void * const &, Buffer const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, buffer );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( BufferMemoryRequirementsInfo2 const & ) const = default;
#else
    bool operator==( BufferMemoryRequirementsInfo2 const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( buffer == rhs.buffer );
#  endif
    }

    bool operator!=( BufferMemoryRequirementsInfo2 const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    StructureType sType  = StructureType::eBufferMemoryRequirementsInfo2;
    const void *  pNext  = {};
    Buffer        buffer = {};
  };

  template <>
  struct CppType<StructureType, StructureType::eBufferMemoryRequirementsInfo2>
  {
    using Type = BufferMemoryRequirementsInfo2;
  };

  using BufferMemoryRequirementsInfo2KHR = BufferMemoryRequirementsInfo2;

  // wrapper struct for struct VkBufferOpaqueCaptureAddressCreateInfo, see
  // https://registry.khronos.org/vulkan/specs/latest/man/html/VkBufferOpaqueCaptureAddressCreateInfo.html
  struct BufferOpaqueCaptureAddressCreateInfo
  {
    using NativeType = VkBufferOpaqueCaptureAddressCreateInfo;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eBufferOpaqueCaptureAddressCreateInfo;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR BufferOpaqueCaptureAddressCreateInfo( uint64_t opaqueCaptureAddress_ = {}, const void * pNext_ = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , opaqueCaptureAddress{ opaqueCaptureAddress_ }
    {
    }

    VULKAN_HPP_CONSTEXPR BufferOpaqueCaptureAddressCreateInfo( BufferOpaqueCaptureAddressCreateInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    BufferOpaqueCaptureAddressCreateInfo( VkBufferOpaqueCaptureAddressCreateInfo const & rhs ) VULKAN_HPP_NOEXCEPT
      : BufferOpaqueCaptureAddressCreateInfo( *reinterpret_cast<BufferOpaqueCaptureAddressCreateInfo const *>( &rhs ) )
    {
    }

    BufferOpaqueCaptureAddressCreateInfo & operator=( BufferOpaqueCaptureAddressCreateInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    BufferOpaqueCaptureAddressCreateInfo & operator=( VkBufferOpaqueCaptureAddressCreateInfo const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<BufferOpaqueCaptureAddressCreateInfo const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 BufferOpaqueCaptureAddressCreateInfo & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BufferOpaqueCaptureAddressCreateInfo & setOpaqueCaptureAddress( uint64_t opaqueCaptureAddress_ ) VULKAN_HPP_NOEXCEPT
    {
      opaqueCaptureAddress = opaqueCaptureAddress_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_SETTERS*/

    operator VkBufferOpaqueCaptureAddressCreateInfo const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkBufferOpaqueCaptureAddressCreateInfo *>( this );
    }

    operator VkBufferOpaqueCaptureAddressCreateInfo &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkBufferOpaqueCaptureAddressCreateInfo *>( this );
    }

    operator VkBufferOpaqueCaptureAddressCreateInfo const *() const VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<const VkBufferOpaqueCaptureAddressCreateInfo *>( this );
    }

    operator VkBufferOpaqueCaptureAddressCreateInfo *() VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<VkBufferOpaqueCaptureAddressCreateInfo *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<StructureType const &, const void * const &, uint64_t const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, opaqueCaptureAddress );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( BufferOpaqueCaptureAddressCreateInfo const & ) const = default;
#else
    bool operator==( BufferOpaqueCaptureAddressCreateInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( opaqueCaptureAddress == rhs.opaqueCaptureAddress );
#  endif
    }

    bool operator!=( BufferOpaqueCaptureAddressCreateInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    StructureType sType                = StructureType::eBufferOpaqueCaptureAddressCreateInfo;
    const void *  pNext                = {};
    uint64_t      opaqueCaptureAddress = {};
  };

  template <>
  struct CppType<StructureType, StructureType::eBufferOpaqueCaptureAddressCreateInfo>
  {
    using Type = BufferOpaqueCaptureAddressCreateInfo;
  };

  using BufferOpaqueCaptureAddressCreateInfoKHR = BufferOpaqueCaptureAddressCreateInfo;

  // wrapper struct for struct VkBufferUsageFlags2CreateInfo, see https://registry.khronos.org/vulkan/specs/latest/man/html/VkBufferUsageFlags2CreateInfo.html
  struct BufferUsageFlags2CreateInfo
  {
    using NativeType = VkBufferUsageFlags2CreateInfo;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eBufferUsageFlags2CreateInfo;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR BufferUsageFlags2CreateInfo( BufferUsageFlags2 usage_ = {}, const void * pNext_ = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , usage{ usage_ }
    {
    }

    VULKAN_HPP_CONSTEXPR BufferUsageFlags2CreateInfo( BufferUsageFlags2CreateInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    BufferUsageFlags2CreateInfo( VkBufferUsageFlags2CreateInfo const & rhs ) VULKAN_HPP_NOEXCEPT
      : BufferUsageFlags2CreateInfo( *reinterpret_cast<BufferUsageFlags2CreateInfo const *>( &rhs ) )
    {
    }

    BufferUsageFlags2CreateInfo & operator=( BufferUsageFlags2CreateInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    BufferUsageFlags2CreateInfo & operator=( VkBufferUsageFlags2CreateInfo const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<BufferUsageFlags2CreateInfo const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 BufferUsageFlags2CreateInfo & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BufferUsageFlags2CreateInfo & setUsage( BufferUsageFlags2 usage_ ) VULKAN_HPP_NOEXCEPT
    {
      usage = usage_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_SETTERS*/

    operator VkBufferUsageFlags2CreateInfo const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkBufferUsageFlags2CreateInfo *>( this );
    }

    operator VkBufferUsageFlags2CreateInfo &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkBufferUsageFlags2CreateInfo *>( this );
    }

    operator VkBufferUsageFlags2CreateInfo const *() const VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<const VkBufferUsageFlags2CreateInfo *>( this );
    }

    operator VkBufferUsageFlags2CreateInfo *() VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<VkBufferUsageFlags2CreateInfo *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<StructureType const &, const void * const &, BufferUsageFlags2 const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, usage );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( BufferUsageFlags2CreateInfo const & ) const = default;
#else
    bool operator==( BufferUsageFlags2CreateInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( usage == rhs.usage );
#  endif
    }

    bool operator!=( BufferUsageFlags2CreateInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    StructureType     sType = StructureType::eBufferUsageFlags2CreateInfo;
    const void *      pNext = {};
    BufferUsageFlags2 usage = {};
  };

  template <>
  struct CppType<StructureType, StructureType::eBufferUsageFlags2CreateInfo>
  {
    using Type = BufferUsageFlags2CreateInfo;
  };

  using BufferUsageFlags2CreateInfoKHR = BufferUsageFlags2CreateInfo;

  // wrapper struct for struct VkBufferViewCreateInfo, see https://registry.khronos.org/vulkan/specs/latest/man/html/VkBufferViewCreateInfo.html
  struct BufferViewCreateInfo
  {
    using NativeType = VkBufferViewCreateInfo;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eBufferViewCreateInfo;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR BufferViewCreateInfo( BufferViewCreateFlags flags_  = {},
                                               Buffer                buffer_ = {},
                                               Format                format_ = Format::eUndefined,
                                               DeviceSize            offset_ = {},
                                               DeviceSize            range_  = {},
                                               const void *          pNext_  = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , flags{ flags_ }
      , buffer{ buffer_ }
      , format{ format_ }
      , offset{ offset_ }
      , range{ range_ }
    {
    }

    VULKAN_HPP_CONSTEXPR BufferViewCreateInfo( BufferViewCreateInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    BufferViewCreateInfo( VkBufferViewCreateInfo const & rhs ) VULKAN_HPP_NOEXCEPT
      : BufferViewCreateInfo( *reinterpret_cast<BufferViewCreateInfo const *>( &rhs ) )
    {
    }

    BufferViewCreateInfo & operator=( BufferViewCreateInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    BufferViewCreateInfo & operator=( VkBufferViewCreateInfo const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<BufferViewCreateInfo const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 BufferViewCreateInfo & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BufferViewCreateInfo & setFlags( BufferViewCreateFlags flags_ ) VULKAN_HPP_NOEXCEPT
    {
      flags = flags_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BufferViewCreateInfo & setBuffer( Buffer buffer_ ) VULKAN_HPP_NOEXCEPT
    {
      buffer = buffer_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BufferViewCreateInfo & setFormat( Format format_ ) VULKAN_HPP_NOEXCEPT
    {
      format = format_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BufferViewCreateInfo & setOffset( DeviceSize offset_ ) VULKAN_HPP_NOEXCEPT
    {
      offset = offset_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BufferViewCreateInfo & setRange( DeviceSize range_ ) VULKAN_HPP_NOEXCEPT
    {
      range = range_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_SETTERS*/

    operator VkBufferViewCreateInfo const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkBufferViewCreateInfo *>( this );
    }

    operator VkBufferViewCreateInfo &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkBufferViewCreateInfo *>( this );
    }

    operator VkBufferViewCreateInfo const *() const VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<const VkBufferViewCreateInfo *>( this );
    }

    operator VkBufferViewCreateInfo *() VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<VkBufferViewCreateInfo *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::
      tuple<StructureType const &, const void * const &, BufferViewCreateFlags const &, Buffer const &, Format const &, DeviceSize const &, DeviceSize const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, flags, buffer, format, offset, range );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( BufferViewCreateInfo const & ) const = default;
#else
    bool operator==( BufferViewCreateInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( flags == rhs.flags ) && ( buffer == rhs.buffer ) && ( format == rhs.format ) &&
             ( offset == rhs.offset ) && ( range == rhs.range );
#  endif
    }

    bool operator!=( BufferViewCreateInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    StructureType         sType  = StructureType::eBufferViewCreateInfo;
    const void *          pNext  = {};
    BufferViewCreateFlags flags  = {};
    Buffer                buffer = {};
    Format                format = Format::eUndefined;
    DeviceSize            offset = {};
    DeviceSize            range  = {};
  };

  template <>
  struct CppType<StructureType, StructureType::eBufferViewCreateInfo>
  {
    using Type = BufferViewCreateInfo;
  };

  // wrapper struct for struct VkStridedDeviceAddressNV, see https://registry.khronos.org/vulkan/specs/latest/man/html/VkStridedDeviceAddressNV.html
  struct StridedDeviceAddressNV
  {
    using NativeType = VkStridedDeviceAddressNV;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR StridedDeviceAddressNV( DeviceAddress startAddress_ = {}, DeviceSize strideInBytes_ = {} ) VULKAN_HPP_NOEXCEPT
      : startAddress{ startAddress_ }
      , strideInBytes{ strideInBytes_ }
    {
    }

    VULKAN_HPP_CONSTEXPR StridedDeviceAddressNV( StridedDeviceAddressNV const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    StridedDeviceAddressNV( VkStridedDeviceAddressNV const & rhs ) VULKAN_HPP_NOEXCEPT
      : StridedDeviceAddressNV( *reinterpret_cast<StridedDeviceAddressNV const *>( &rhs ) )
    {
    }

    StridedDeviceAddressNV & operator=( StridedDeviceAddressNV const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    StridedDeviceAddressNV & operator=( VkStridedDeviceAddressNV const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<StridedDeviceAddressNV const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 StridedDeviceAddressNV & setStartAddress( DeviceAddress startAddress_ ) VULKAN_HPP_NOEXCEPT
    {
      startAddress = startAddress_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 StridedDeviceAddressNV & setStrideInBytes( DeviceSize strideInBytes_ ) VULKAN_HPP_NOEXCEPT
    {
      strideInBytes = strideInBytes_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_SETTERS*/

    operator VkStridedDeviceAddressNV const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkStridedDeviceAddressNV *>( this );
    }

    operator VkStridedDeviceAddressNV &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkStridedDeviceAddressNV *>( this );
    }

    operator VkStridedDeviceAddressNV const *() const VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<const VkStridedDeviceAddressNV *>( this );
    }

    operator VkStridedDeviceAddressNV *() VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<VkStridedDeviceAddressNV *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<DeviceAddress const &, DeviceSize const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( startAddress, strideInBytes );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( StridedDeviceAddressNV const & ) const = default;
#else
    bool operator==( StridedDeviceAddressNV const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( startAddress == rhs.startAddress ) && ( strideInBytes == rhs.strideInBytes );
#  endif
    }

    bool operator!=( StridedDeviceAddressNV const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    DeviceAddress startAddress  = {};
    DeviceSize    strideInBytes = {};
  };

  // wrapper struct for struct VkBuildPartitionedAccelerationStructureIndirectCommandNV, see
  // https://registry.khronos.org/vulkan/specs/latest/man/html/VkBuildPartitionedAccelerationStructureIndirectCommandNV.html
  struct BuildPartitionedAccelerationStructureIndirectCommandNV
  {
    using NativeType = VkBuildPartitionedAccelerationStructureIndirectCommandNV;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR BuildPartitionedAccelerationStructureIndirectCommandNV(
      PartitionedAccelerationStructureOpTypeNV opType_   = PartitionedAccelerationStructureOpTypeNV::eWriteInstance,
      uint32_t                                 argCount_ = {},
      StridedDeviceAddressNV                   argData_  = {} ) VULKAN_HPP_NOEXCEPT
      : opType{ opType_ }
      , argCount{ argCount_ }
      , argData{ argData_ }
    {
    }

    VULKAN_HPP_CONSTEXPR BuildPartitionedAccelerationStructureIndirectCommandNV( BuildPartitionedAccelerationStructureIndirectCommandNV const & rhs )
      VULKAN_HPP_NOEXCEPT = default;

    BuildPartitionedAccelerationStructureIndirectCommandNV( VkBuildPartitionedAccelerationStructureIndirectCommandNV const & rhs ) VULKAN_HPP_NOEXCEPT
      : BuildPartitionedAccelerationStructureIndirectCommandNV( *reinterpret_cast<BuildPartitionedAccelerationStructureIndirectCommandNV const *>( &rhs ) )
    {
    }

    BuildPartitionedAccelerationStructureIndirectCommandNV &
      operator=( BuildPartitionedAccelerationStructureIndirectCommandNV const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    BuildPartitionedAccelerationStructureIndirectCommandNV &
      operator=( VkBuildPartitionedAccelerationStructureIndirectCommandNV const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<BuildPartitionedAccelerationStructureIndirectCommandNV const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 BuildPartitionedAccelerationStructureIndirectCommandNV &
      setOpType( PartitionedAccelerationStructureOpTypeNV opType_ ) VULKAN_HPP_NOEXCEPT
    {
      opType = opType_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BuildPartitionedAccelerationStructureIndirectCommandNV & setArgCount( uint32_t argCount_ ) VULKAN_HPP_NOEXCEPT
    {
      argCount = argCount_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BuildPartitionedAccelerationStructureIndirectCommandNV & setArgData( StridedDeviceAddressNV const & argData_ ) VULKAN_HPP_NOEXCEPT
    {
      argData = argData_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_SETTERS*/

    operator VkBuildPartitionedAccelerationStructureIndirectCommandNV const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkBuildPartitionedAccelerationStructureIndirectCommandNV *>( this );
    }

    operator VkBuildPartitionedAccelerationStructureIndirectCommandNV &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkBuildPartitionedAccelerationStructureIndirectCommandNV *>( this );
    }

    operator VkBuildPartitionedAccelerationStructureIndirectCommandNV const *() const VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<const VkBuildPartitionedAccelerationStructureIndirectCommandNV *>( this );
    }

    operator VkBuildPartitionedAccelerationStructureIndirectCommandNV *() VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<VkBuildPartitionedAccelerationStructureIndirectCommandNV *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<PartitionedAccelerationStructureOpTypeNV const &, uint32_t const &, StridedDeviceAddressNV const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( opType, argCount, argData );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( BuildPartitionedAccelerationStructureIndirectCommandNV const & ) const = default;
#else
    bool operator==( BuildPartitionedAccelerationStructureIndirectCommandNV const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( opType == rhs.opType ) && ( argCount == rhs.argCount ) && ( argData == rhs.argData );
#  endif
    }

    bool operator!=( BuildPartitionedAccelerationStructureIndirectCommandNV const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    PartitionedAccelerationStructureOpTypeNV opType   = PartitionedAccelerationStructureOpTypeNV::eWriteInstance;
    uint32_t                                 argCount = {};
    StridedDeviceAddressNV                   argData  = {};
  };

  // wrapper struct for struct VkPartitionedAccelerationStructureInstancesInputNV, see
  // https://registry.khronos.org/vulkan/specs/latest/man/html/VkPartitionedAccelerationStructureInstancesInputNV.html
  struct PartitionedAccelerationStructureInstancesInputNV
  {
    using NativeType = VkPartitionedAccelerationStructureInstancesInputNV;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::ePartitionedAccelerationStructureInstancesInputNV;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR PartitionedAccelerationStructureInstancesInputNV( BuildAccelerationStructureFlagsKHR flags_                             = {},
                                                                           uint32_t                           instanceCount_                     = {},
                                                                           uint32_t                           maxInstancePerPartitionCount_      = {},
                                                                           uint32_t                           partitionCount_                    = {},
                                                                           uint32_t                           maxInstanceInGlobalPartitionCount_ = {},
                                                                           void *                             pNext_ = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , flags{ flags_ }
      , instanceCount{ instanceCount_ }
      , maxInstancePerPartitionCount{ maxInstancePerPartitionCount_ }
      , partitionCount{ partitionCount_ }
      , maxInstanceInGlobalPartitionCount{ maxInstanceInGlobalPartitionCount_ }
    {
    }

    VULKAN_HPP_CONSTEXPR
      PartitionedAccelerationStructureInstancesInputNV( PartitionedAccelerationStructureInstancesInputNV const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    PartitionedAccelerationStructureInstancesInputNV( VkPartitionedAccelerationStructureInstancesInputNV const & rhs ) VULKAN_HPP_NOEXCEPT
      : PartitionedAccelerationStructureInstancesInputNV( *reinterpret_cast<PartitionedAccelerationStructureInstancesInputNV const *>( &rhs ) )
    {
    }

    PartitionedAccelerationStructureInstancesInputNV & operator=( PartitionedAccelerationStructureInstancesInputNV const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    PartitionedAccelerationStructureInstancesInputNV & operator=( VkPartitionedAccelerationStructureInstancesInputNV const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<PartitionedAccelerationStructureInstancesInputNV const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 PartitionedAccelerationStructureInstancesInputNV & setPNext( void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 PartitionedAccelerationStructureInstancesInputNV & setFlags( BuildAccelerationStructureFlagsKHR flags_ ) VULKAN_HPP_NOEXCEPT
    {
      flags = flags_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 PartitionedAccelerationStructureInstancesInputNV & setInstanceCount( uint32_t instanceCount_ ) VULKAN_HPP_NOEXCEPT
    {
      instanceCount = instanceCount_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 PartitionedAccelerationStructureInstancesInputNV &
      setMaxInstancePerPartitionCount( uint32_t maxInstancePerPartitionCount_ ) VULKAN_HPP_NOEXCEPT
    {
      maxInstancePerPartitionCount = maxInstancePerPartitionCount_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 PartitionedAccelerationStructureInstancesInputNV & setPartitionCount( uint32_t partitionCount_ ) VULKAN_HPP_NOEXCEPT
    {
      partitionCount = partitionCount_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 PartitionedAccelerationStructureInstancesInputNV &
      setMaxInstanceInGlobalPartitionCount( uint32_t maxInstanceInGlobalPartitionCount_ ) VULKAN_HPP_NOEXCEPT
    {
      maxInstanceInGlobalPartitionCount = maxInstanceInGlobalPartitionCount_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_SETTERS*/

    operator VkPartitionedAccelerationStructureInstancesInputNV const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkPartitionedAccelerationStructureInstancesInputNV *>( this );
    }

    operator VkPartitionedAccelerationStructureInstancesInputNV &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkPartitionedAccelerationStructureInstancesInputNV *>( this );
    }

    operator VkPartitionedAccelerationStructureInstancesInputNV const *() const VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<const VkPartitionedAccelerationStructureInstancesInputNV *>( this );
    }

    operator VkPartitionedAccelerationStructureInstancesInputNV *() VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<VkPartitionedAccelerationStructureInstancesInputNV *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<StructureType const &,
               void * const &,
               BuildAccelerationStructureFlagsKHR const &,
               uint32_t const &,
               uint32_t const &,
               uint32_t const &,
               uint32_t const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, flags, instanceCount, maxInstancePerPartitionCount, partitionCount, maxInstanceInGlobalPartitionCount );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( PartitionedAccelerationStructureInstancesInputNV const & ) const = default;
#else
    bool operator==( PartitionedAccelerationStructureInstancesInputNV const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( flags == rhs.flags ) && ( instanceCount == rhs.instanceCount ) &&
             ( maxInstancePerPartitionCount == rhs.maxInstancePerPartitionCount ) && ( partitionCount == rhs.partitionCount ) &&
             ( maxInstanceInGlobalPartitionCount == rhs.maxInstanceInGlobalPartitionCount );
#  endif
    }

    bool operator!=( PartitionedAccelerationStructureInstancesInputNV const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    StructureType                      sType                             = StructureType::ePartitionedAccelerationStructureInstancesInputNV;
    void *                             pNext                             = {};
    BuildAccelerationStructureFlagsKHR flags                             = {};
    uint32_t                           instanceCount                     = {};
    uint32_t                           maxInstancePerPartitionCount      = {};
    uint32_t                           partitionCount                    = {};
    uint32_t                           maxInstanceInGlobalPartitionCount = {};
  };

  template <>
  struct CppType<StructureType, StructureType::ePartitionedAccelerationStructureInstancesInputNV>
  {
    using Type = PartitionedAccelerationStructureInstancesInputNV;
  };

  // wrapper struct for struct VkBuildPartitionedAccelerationStructureInfoNV, see
  // https://registry.khronos.org/vulkan/specs/latest/man/html/VkBuildPartitionedAccelerationStructureInfoNV.html
  struct BuildPartitionedAccelerationStructureInfoNV
  {
    using NativeType = VkBuildPartitionedAccelerationStructureInfoNV;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eBuildPartitionedAccelerationStructureInfoNV;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR BuildPartitionedAccelerationStructureInfoNV( PartitionedAccelerationStructureInstancesInputNV input_                        = {},
                                                                      DeviceAddress                                    srcAccelerationStructureData_ = {},
                                                                      DeviceAddress                                    dstAccelerationStructureData_ = {},
                                                                      DeviceAddress                                    scratchData_                  = {},
                                                                      DeviceAddress                                    srcInfos_                     = {},
                                                                      DeviceAddress                                    srcInfosCount_                = {},
                                                                      void *                                           pNext_ = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , input{ input_ }
      , srcAccelerationStructureData{ srcAccelerationStructureData_ }
      , dstAccelerationStructureData{ dstAccelerationStructureData_ }
      , scratchData{ scratchData_ }
      , srcInfos{ srcInfos_ }
      , srcInfosCount{ srcInfosCount_ }
    {
    }

    VULKAN_HPP_CONSTEXPR BuildPartitionedAccelerationStructureInfoNV( BuildPartitionedAccelerationStructureInfoNV const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    BuildPartitionedAccelerationStructureInfoNV( VkBuildPartitionedAccelerationStructureInfoNV const & rhs ) VULKAN_HPP_NOEXCEPT
      : BuildPartitionedAccelerationStructureInfoNV( *reinterpret_cast<BuildPartitionedAccelerationStructureInfoNV const *>( &rhs ) )
    {
    }

    BuildPartitionedAccelerationStructureInfoNV & operator=( BuildPartitionedAccelerationStructureInfoNV const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    BuildPartitionedAccelerationStructureInfoNV & operator=( VkBuildPartitionedAccelerationStructureInfoNV const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<BuildPartitionedAccelerationStructureInfoNV const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 BuildPartitionedAccelerationStructureInfoNV & setPNext( void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BuildPartitionedAccelerationStructureInfoNV &
      setInput( PartitionedAccelerationStructureInstancesInputNV const & input_ ) VULKAN_HPP_NOEXCEPT
    {
      input = input_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BuildPartitionedAccelerationStructureInfoNV &
      setSrcAccelerationStructureData( DeviceAddress srcAccelerationStructureData_ ) VULKAN_HPP_NOEXCEPT
    {
      srcAccelerationStructureData = srcAccelerationStructureData_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BuildPartitionedAccelerationStructureInfoNV &
      setDstAccelerationStructureData( DeviceAddress dstAccelerationStructureData_ ) VULKAN_HPP_NOEXCEPT
    {
      dstAccelerationStructureData = dstAccelerationStructureData_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BuildPartitionedAccelerationStructureInfoNV & setScratchData( DeviceAddress scratchData_ ) VULKAN_HPP_NOEXCEPT
    {
      scratchData = scratchData_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BuildPartitionedAccelerationStructureInfoNV & setSrcInfos( DeviceAddress srcInfos_ ) VULKAN_HPP_NOEXCEPT
    {
      srcInfos = srcInfos_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 BuildPartitionedAccelerationStructureInfoNV & setSrcInfosCount( DeviceAddress srcInfosCount_ ) VULKAN_HPP_NOEXCEPT
    {
      srcInfosCount = srcInfosCount_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_SETTERS*/

    operator VkBuildPartitionedAccelerationStructureInfoNV const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkBuildPartitionedAccelerationStructureInfoNV *>( this );
    }

    operator VkBuildPartitionedAccelerationStructureInfoNV &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkBuildPartitionedAccelerationStructureInfoNV *>( this );
    }

    operator VkBuildPartitionedAccelerationStructureInfoNV const *() const VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<const VkBuildPartitionedAccelerationStructureInfoNV *>( this );
    }

    operator VkBuildPartitionedAccelerationStructureInfoNV *() VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<VkBuildPartitionedAccelerationStructureInfoNV *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<StructureType const &,
               void * const &,
               PartitionedAccelerationStructureInstancesInputNV const &,
               DeviceAddress const &,
               DeviceAddress const &,
               DeviceAddress const &,
               DeviceAddress const &,
               DeviceAddress const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, input, srcAccelerationStructureData, dstAccelerationStructureData, scratchData, srcInfos, srcInfosCount );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( BuildPartitionedAccelerationStructureInfoNV const & ) const = default;
#else
    bool operator==( BuildPartitionedAccelerationStructureInfoNV const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( input == rhs.input ) &&
             ( srcAccelerationStructureData == rhs.srcAccelerationStructureData ) && ( dstAccelerationStructureData == rhs.dstAccelerationStructureData ) &&
             ( scratchData == rhs.scratchData ) && ( srcInfos == rhs.srcInfos ) && ( srcInfosCount == rhs.srcInfosCount );
#  endif
    }

    bool operator!=( BuildPartitionedAccelerationStructureInfoNV const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    StructureType                                    sType                        = StructureType::eBuildPartitionedAccelerationStructureInfoNV;
    void *                                           pNext                        = {};
    PartitionedAccelerationStructureInstancesInputNV input                        = {};
    DeviceAddress                                    srcAccelerationStructureData = {};
    DeviceAddress                                    dstAccelerationStructureData = {};
    DeviceAddress                                    scratchData                  = {};
    DeviceAddress                                    srcInfos                     = {};
    DeviceAddress                                    srcInfosCount                = {};
  };

  template <>
  struct CppType<StructureType, StructureType::eBuildPartitionedAccelerationStructureInfoNV>
  {
    using Type = BuildPartitionedAccelerationStructureInfoNV;
  };

  // wrapper struct for struct VkCalibratedTimestampInfoKHR, see https://registry.khronos.org/vulkan/specs/latest/man/html/VkCalibratedTimestampInfoKHR.html
  struct CalibratedTimestampInfoKHR
  {
    using NativeType = VkCalibratedTimestampInfoKHR;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eCalibratedTimestampInfoKHR;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR CalibratedTimestampInfoKHR( TimeDomainKHR timeDomain_ = TimeDomainKHR::eDevice, const void * pNext_ = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , timeDomain{ timeDomain_ }
    {
    }

    VULKAN_HPP_CONSTEXPR CalibratedTimestampInfoKHR( CalibratedTimestampInfoKHR const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    CalibratedTimestampInfoKHR( VkCalibratedTimestampInfoKHR const & rhs ) VULKAN_HPP_NOEXCEPT
      : CalibratedTimestampInfoKHR( *reinterpret_cast<CalibratedTimestampInfoKHR const *>( &rhs ) )
    {
    }

    CalibratedTimestampInfoKHR & operator=( CalibratedTimestampInfoKHR const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    CalibratedTimestampInfoKHR & operator=( VkCalibratedTimestampInfoKHR const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<CalibratedTimestampInfoKHR const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 CalibratedTimestampInfoKHR & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CalibratedTimestampInfoKHR & setTimeDomain( TimeDomainKHR timeDomain_ ) VULKAN_HPP_NOEXCEPT
    {
      timeDomain = timeDomain_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_SETTERS*/

    operator VkCalibratedTimestampInfoKHR const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkCalibratedTimestampInfoKHR *>( this );
    }

    operator VkCalibratedTimestampInfoKHR &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkCalibratedTimestampInfoKHR *>( this );
    }

    operator VkCalibratedTimestampInfoKHR const *() const VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<const VkCalibratedTimestampInfoKHR *>( this );
    }

    operator VkCalibratedTimestampInfoKHR *() VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<VkCalibratedTimestampInfoKHR *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<StructureType const &, const void * const &, TimeDomainKHR const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, timeDomain );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( CalibratedTimestampInfoKHR const & ) const = default;
#else
    bool operator==( CalibratedTimestampInfoKHR const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( timeDomain == rhs.timeDomain );
#  endif
    }

    bool operator!=( CalibratedTimestampInfoKHR const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    StructureType sType      = StructureType::eCalibratedTimestampInfoKHR;
    const void *  pNext      = {};
    TimeDomainKHR timeDomain = TimeDomainKHR::eDevice;
  };

  template <>
  struct CppType<StructureType, StructureType::eCalibratedTimestampInfoKHR>
  {
    using Type = CalibratedTimestampInfoKHR;
  };

  using CalibratedTimestampInfoEXT = CalibratedTimestampInfoKHR;

  // wrapper struct for struct VkCheckpointData2NV, see https://registry.khronos.org/vulkan/specs/latest/man/html/VkCheckpointData2NV.html
  struct CheckpointData2NV
  {
    using NativeType = VkCheckpointData2NV;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eCheckpointData2NV;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR CheckpointData2NV( PipelineStageFlags2 stage_ = {}, void * pCheckpointMarker_ = {}, void * pNext_ = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , stage{ stage_ }
      , pCheckpointMarker{ pCheckpointMarker_ }
    {
    }

    VULKAN_HPP_CONSTEXPR CheckpointData2NV( CheckpointData2NV const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    CheckpointData2NV( VkCheckpointData2NV const & rhs ) VULKAN_HPP_NOEXCEPT : CheckpointData2NV( *reinterpret_cast<CheckpointData2NV const *>( &rhs ) ) {}

    CheckpointData2NV & operator=( CheckpointData2NV const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    CheckpointData2NV & operator=( VkCheckpointData2NV const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<CheckpointData2NV const *>( &rhs );
      return *this;
    }

    operator VkCheckpointData2NV const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkCheckpointData2NV *>( this );
    }

    operator VkCheckpointData2NV &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkCheckpointData2NV *>( this );
    }

    operator VkCheckpointData2NV const *() const VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<const VkCheckpointData2NV *>( this );
    }

    operator VkCheckpointData2NV *() VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<VkCheckpointData2NV *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<StructureType const &, void * const &, PipelineStageFlags2 const &, void * const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, stage, pCheckpointMarker );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( CheckpointData2NV const & ) const = default;
#else
    bool operator==( CheckpointData2NV const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( stage == rhs.stage ) && ( pCheckpointMarker == rhs.pCheckpointMarker );
#  endif
    }

    bool operator!=( CheckpointData2NV const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    StructureType       sType             = StructureType::eCheckpointData2NV;
    void *              pNext             = {};
    PipelineStageFlags2 stage             = {};
    void *              pCheckpointMarker = {};
  };

  template <>
  struct CppType<StructureType, StructureType::eCheckpointData2NV>
  {
    using Type = CheckpointData2NV;
  };

  // wrapper struct for struct VkCheckpointDataNV, see https://registry.khronos.org/vulkan/specs/latest/man/html/VkCheckpointDataNV.html
  struct CheckpointDataNV
  {
    using NativeType = VkCheckpointDataNV;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eCheckpointDataNV;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR CheckpointDataNV( PipelineStageFlagBits stage_             = PipelineStageFlagBits::eTopOfPipe,
                                           void *                pCheckpointMarker_ = {},
                                           void *                pNext_             = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , stage{ stage_ }
      , pCheckpointMarker{ pCheckpointMarker_ }
    {
    }

    VULKAN_HPP_CONSTEXPR CheckpointDataNV( CheckpointDataNV const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    CheckpointDataNV( VkCheckpointDataNV const & rhs ) VULKAN_HPP_NOEXCEPT : CheckpointDataNV( *reinterpret_cast<CheckpointDataNV const *>( &rhs ) ) {}

    CheckpointDataNV & operator=( CheckpointDataNV const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    CheckpointDataNV & operator=( VkCheckpointDataNV const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<CheckpointDataNV const *>( &rhs );
      return *this;
    }

    operator VkCheckpointDataNV const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkCheckpointDataNV *>( this );
    }

    operator VkCheckpointDataNV &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkCheckpointDataNV *>( this );
    }

    operator VkCheckpointDataNV const *() const VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<const VkCheckpointDataNV *>( this );
    }

    operator VkCheckpointDataNV *() VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<VkCheckpointDataNV *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<StructureType const &, void * const &, PipelineStageFlagBits const &, void * const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, stage, pCheckpointMarker );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( CheckpointDataNV const & ) const = default;
#else
    bool operator==( CheckpointDataNV const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( stage == rhs.stage ) && ( pCheckpointMarker == rhs.pCheckpointMarker );
#  endif
    }

    bool operator!=( CheckpointDataNV const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    StructureType         sType             = StructureType::eCheckpointDataNV;
    void *                pNext             = {};
    PipelineStageFlagBits stage             = PipelineStageFlagBits::eTopOfPipe;
    void *                pCheckpointMarker = {};
  };

  template <>
  struct CppType<StructureType, StructureType::eCheckpointDataNV>
  {
    using Type = CheckpointDataNV;
  };

  union ClearColorValue
  {
    using NativeType = VkClearColorValue;
#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_UNION_CONSTRUCTORS )

    VULKAN_HPP_CONSTEXPR_14 ClearColorValue( const std::array<float, 4> & float32_ = {} ) : float32( float32_ ) {}

    VULKAN_HPP_CONSTEXPR ClearColorValue( float float32_0, float float32_1, float float32_2, float float32_3 )
      : float32{ { { float32_0, float32_1, float32_2, float32_3 } } }
    {
    }

    VULKAN_HPP_CONSTEXPR_14 ClearColorValue( const std::array<int32_t, 4> & int32_ ) : int32( int32_ ) {}

    VULKAN_HPP_CONSTEXPR ClearColorValue( int32_t int32_0, int32_t int32_1, int32_t int32_2, int32_t int32_3 )
      : int32{ { { int32_0, int32_1, int32_2, int32_3 } } }
    {
    }

    VULKAN_HPP_CONSTEXPR_14 ClearColorValue( const std::array<uint32_t, 4> & uint32_ ) : uint32( uint32_ ) {}

    VULKAN_HPP_CONSTEXPR ClearColorValue( uint32_t uint32_0, uint32_t uint32_1, uint32_t uint32_2, uint32_t uint32_3 )
      : uint32{ { { uint32_0, uint32_1, uint32_2, uint32_3 } } }
    {
    }
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_UNION_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 ClearColorValue & setFloat32( std::array<float, 4> float32_ ) VULKAN_HPP_NOEXCEPT
    {
      float32 = float32_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ClearColorValue & setInt32( std::array<int32_t, 4> int32_ ) VULKAN_HPP_NOEXCEPT
    {
      int32 = int32_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ClearColorValue & setUint32( std::array<uint32_t, 4> uint32_ ) VULKAN_HPP_NOEXCEPT
    {
      uint32 = uint32_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_SETTERS*/

    operator VkClearColorValue const &() const
    {
      return *reinterpret_cast<const VkClearColorValue *>( this );
    }

    operator VkClearColorValue &()
    {
      return *reinterpret_cast<VkClearColorValue *>( this );
    }

    ArrayWrapper1D<float, 4>    float32;
    ArrayWrapper1D<int32_t, 4>  int32;
    ArrayWrapper1D<uint32_t, 4> uint32;
  };

  // wrapper struct for struct VkClearDepthStencilValue, see https://registry.khronos.org/vulkan/specs/latest/man/html/VkClearDepthStencilValue.html
  struct ClearDepthStencilValue
  {
    using NativeType = VkClearDepthStencilValue;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR ClearDepthStencilValue( float depth_ = {}, uint32_t stencil_ = {} ) VULKAN_HPP_NOEXCEPT
      : depth{ depth_ }
      , stencil{ stencil_ }
    {
    }

    VULKAN_HPP_CONSTEXPR ClearDepthStencilValue( ClearDepthStencilValue const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    ClearDepthStencilValue( VkClearDepthStencilValue const & rhs ) VULKAN_HPP_NOEXCEPT
      : ClearDepthStencilValue( *reinterpret_cast<ClearDepthStencilValue const *>( &rhs ) )
    {
    }

    ClearDepthStencilValue & operator=( ClearDepthStencilValue const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    ClearDepthStencilValue & operator=( VkClearDepthStencilValue const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<ClearDepthStencilValue const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 ClearDepthStencilValue & setDepth( float depth_ ) VULKAN_HPP_NOEXCEPT
    {
      depth = depth_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ClearDepthStencilValue & setStencil( uint32_t stencil_ ) VULKAN_HPP_NOEXCEPT
    {
      stencil = stencil_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_SETTERS*/

    operator VkClearDepthStencilValue const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkClearDepthStencilValue *>( this );
    }

    operator VkClearDepthStencilValue &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkClearDepthStencilValue *>( this );
    }

    operator VkClearDepthStencilValue const *() const VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<const VkClearDepthStencilValue *>( this );
    }

    operator VkClearDepthStencilValue *() VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<VkClearDepthStencilValue *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<float const &, uint32_t const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( depth, stencil );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( ClearDepthStencilValue const & ) const = default;
#else
    bool operator==( ClearDepthStencilValue const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( depth == rhs.depth ) && ( stencil == rhs.stencil );
#  endif
    }

    bool operator!=( ClearDepthStencilValue const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    float    depth   = {};
    uint32_t stencil = {};
  };

  union ClearValue
  {
    using NativeType = VkClearValue;
#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_UNION_CONSTRUCTORS )

    VULKAN_HPP_CONSTEXPR_14 ClearValue( ClearColorValue color_ = {} ) : color( color_ ) {}

    VULKAN_HPP_CONSTEXPR_14 ClearValue( ClearDepthStencilValue depthStencil_ ) : depthStencil( depthStencil_ ) {}
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_UNION_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 ClearValue & setColor( ClearColorValue const & color_ ) VULKAN_HPP_NOEXCEPT
    {
      color = color_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ClearValue & setDepthStencil( ClearDepthStencilValue const & depthStencil_ ) VULKAN_HPP_NOEXCEPT
    {
      depthStencil = depthStencil_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_SETTERS*/

    operator VkClearValue const &() const
    {
      return *reinterpret_cast<const VkClearValue *>( this );
    }

    operator VkClearValue &()
    {
      return *reinterpret_cast<VkClearValue *>( this );
    }

#ifdef VULKAN_HPP_HAS_UNRESTRICTED_UNIONS
    ClearColorValue        color;
    ClearDepthStencilValue depthStencil;
#else
    VkClearColorValue        color;
    VkClearDepthStencilValue depthStencil;
#endif /*VULKAN_HPP_HAS_UNRESTRICTED_UNIONS*/
  };

  // wrapper struct for struct VkClearAttachment, see https://registry.khronos.org/vulkan/specs/latest/man/html/VkClearAttachment.html
  struct ClearAttachment
  {
    using NativeType = VkClearAttachment;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR_14
      ClearAttachment( ImageAspectFlags aspectMask_ = {}, uint32_t colorAttachment_ = {}, ClearValue clearValue_ = {} ) VULKAN_HPP_NOEXCEPT
      : aspectMask{ aspectMask_ }
      , colorAttachment{ colorAttachment_ }
      , clearValue{ clearValue_ }
    {
    }

    VULKAN_HPP_CONSTEXPR_14 ClearAttachment( ClearAttachment const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    ClearAttachment( VkClearAttachment const & rhs ) VULKAN_HPP_NOEXCEPT : ClearAttachment( *reinterpret_cast<ClearAttachment const *>( &rhs ) ) {}

    ClearAttachment & operator=( ClearAttachment const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    ClearAttachment & operator=( VkClearAttachment const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<ClearAttachment const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 ClearAttachment & setAspectMask( ImageAspectFlags aspectMask_ ) VULKAN_HPP_NOEXCEPT
    {
      aspectMask = aspectMask_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ClearAttachment & setColorAttachment( uint32_t colorAttachment_ ) VULKAN_HPP_NOEXCEPT
    {
      colorAttachment = colorAttachment_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ClearAttachment & setClearValue( ClearValue const & clearValue_ ) VULKAN_HPP_NOEXCEPT
    {
      clearValue = clearValue_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_SETTERS*/

    operator VkClearAttachment const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkClearAttachment *>( this );
    }

    operator VkClearAttachment &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkClearAttachment *>( this );
    }

    operator VkClearAttachment const *() const VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<const VkClearAttachment *>( this );
    }

    operator VkClearAttachment *() VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<VkClearAttachment *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<ImageAspectFlags const &, uint32_t const &, ClearValue const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( aspectMask, colorAttachment, clearValue );
    }
#endif

  public:
    ImageAspectFlags aspectMask      = {};
    uint32_t         colorAttachment = {};
    ClearValue       clearValue      = {};
  };

  // wrapper struct for struct VkClearRect, see https://registry.khronos.org/vulkan/specs/latest/man/html/VkClearRect.html
  struct ClearRect
  {
    using NativeType = VkClearRect;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR ClearRect( Rect2D rect_ = {}, uint32_t baseArrayLayer_ = {}, uint32_t layerCount_ = {} ) VULKAN_HPP_NOEXCEPT
      : rect{ rect_ }
      , baseArrayLayer{ baseArrayLayer_ }
      , layerCount{ layerCount_ }
    {
    }

    VULKAN_HPP_CONSTEXPR ClearRect( ClearRect const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    ClearRect( VkClearRect const & rhs ) VULKAN_HPP_NOEXCEPT : ClearRect( *reinterpret_cast<ClearRect const *>( &rhs ) ) {}

    ClearRect & operator=( ClearRect const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    ClearRect & operator=( VkClearRect const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<ClearRect const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 ClearRect & setRect( Rect2D const & rect_ ) VULKAN_HPP_NOEXCEPT
    {
      rect = rect_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ClearRect & setBaseArrayLayer( uint32_t baseArrayLayer_ ) VULKAN_HPP_NOEXCEPT
    {
      baseArrayLayer = baseArrayLayer_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ClearRect & setLayerCount( uint32_t layerCount_ ) VULKAN_HPP_NOEXCEPT
    {
      layerCount = layerCount_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_SETTERS*/

    operator VkClearRect const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkClearRect *>( this );
    }

    operator VkClearRect &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkClearRect *>( this );
    }

    operator VkClearRect const *() const VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<const VkClearRect *>( this );
    }

    operator VkClearRect *() VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<VkClearRect *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<Rect2D const &, uint32_t const &, uint32_t const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( rect, baseArrayLayer, layerCount );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( ClearRect const & ) const = default;
#else
    bool operator==( ClearRect const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( rect == rhs.rect ) && ( baseArrayLayer == rhs.baseArrayLayer ) && ( layerCount == rhs.layerCount );
#  endif
    }

    bool operator!=( ClearRect const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    Rect2D   rect           = {};
    uint32_t baseArrayLayer = {};
    uint32_t layerCount     = {};
  };

  // wrapper struct for struct VkClusterAccelerationStructureBuildClustersBottomLevelInfoNV, see
  // https://registry.khronos.org/vulkan/specs/latest/man/html/VkClusterAccelerationStructureBuildClustersBottomLevelInfoNV.html
  struct ClusterAccelerationStructureBuildClustersBottomLevelInfoNV
  {
    using NativeType = VkClusterAccelerationStructureBuildClustersBottomLevelInfoNV;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR ClusterAccelerationStructureBuildClustersBottomLevelInfoNV( uint32_t      clusterReferencesCount_  = {},
                                                                                     uint32_t      clusterReferencesStride_ = {},
                                                                                     DeviceAddress clusterReferences_       = {} ) VULKAN_HPP_NOEXCEPT
      : clusterReferencesCount{ clusterReferencesCount_ }
      , clusterReferencesStride{ clusterReferencesStride_ }
      , clusterReferences{ clusterReferences_ }
    {
    }

    VULKAN_HPP_CONSTEXPR ClusterAccelerationStructureBuildClustersBottomLevelInfoNV( ClusterAccelerationStructureBuildClustersBottomLevelInfoNV const & rhs )
      VULKAN_HPP_NOEXCEPT = default;

    ClusterAccelerationStructureBuildClustersBottomLevelInfoNV( VkClusterAccelerationStructureBuildClustersBottomLevelInfoNV const & rhs ) VULKAN_HPP_NOEXCEPT
      : ClusterAccelerationStructureBuildClustersBottomLevelInfoNV(
          *reinterpret_cast<ClusterAccelerationStructureBuildClustersBottomLevelInfoNV const *>( &rhs ) )
    {
    }

    ClusterAccelerationStructureBuildClustersBottomLevelInfoNV &
      operator=( ClusterAccelerationStructureBuildClustersBottomLevelInfoNV const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    ClusterAccelerationStructureBuildClustersBottomLevelInfoNV &
      operator=( VkClusterAccelerationStructureBuildClustersBottomLevelInfoNV const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<ClusterAccelerationStructureBuildClustersBottomLevelInfoNV const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 ClusterAccelerationStructureBuildClustersBottomLevelInfoNV &
      setClusterReferencesCount( uint32_t clusterReferencesCount_ ) VULKAN_HPP_NOEXCEPT
    {
      clusterReferencesCount = clusterReferencesCount_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ClusterAccelerationStructureBuildClustersBottomLevelInfoNV &
      setClusterReferencesStride( uint32_t clusterReferencesStride_ ) VULKAN_HPP_NOEXCEPT
    {
      clusterReferencesStride = clusterReferencesStride_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ClusterAccelerationStructureBuildClustersBottomLevelInfoNV &
      setClusterReferences( DeviceAddress clusterReferences_ ) VULKAN_HPP_NOEXCEPT
    {
      clusterReferences = clusterReferences_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_SETTERS*/

    operator VkClusterAccelerationStructureBuildClustersBottomLevelInfoNV const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkClusterAccelerationStructureBuildClustersBottomLevelInfoNV *>( this );
    }

    operator VkClusterAccelerationStructureBuildClustersBottomLevelInfoNV &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkClusterAccelerationStructureBuildClustersBottomLevelInfoNV *>( this );
    }

    operator VkClusterAccelerationStructureBuildClustersBottomLevelInfoNV const *() const VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<const VkClusterAccelerationStructureBuildClustersBottomLevelInfoNV *>( this );
    }

    operator VkClusterAccelerationStructureBuildClustersBottomLevelInfoNV *() VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<VkClusterAccelerationStructureBuildClustersBottomLevelInfoNV *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<uint32_t const &, uint32_t const &, DeviceAddress const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( clusterReferencesCount, clusterReferencesStride, clusterReferences );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( ClusterAccelerationStructureBuildClustersBottomLevelInfoNV const & ) const = default;
#else
    bool operator==( ClusterAccelerationStructureBuildClustersBottomLevelInfoNV const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( clusterReferencesCount == rhs.clusterReferencesCount ) && ( clusterReferencesStride == rhs.clusterReferencesStride ) &&
             ( clusterReferences == rhs.clusterReferences );
#  endif
    }

    bool operator!=( ClusterAccelerationStructureBuildClustersBottomLevelInfoNV const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    uint32_t      clusterReferencesCount  = {};
    uint32_t      clusterReferencesStride = {};
    DeviceAddress clusterReferences       = {};
  };

  // wrapper struct for struct VkClusterAccelerationStructureGeometryIndexAndGeometryFlagsNV, see
  // https://registry.khronos.org/vulkan/specs/latest/man/html/VkClusterAccelerationStructureGeometryIndexAndGeometryFlagsNV.html
  struct ClusterAccelerationStructureGeometryIndexAndGeometryFlagsNV
  {
    using NativeType = VkClusterAccelerationStructureGeometryIndexAndGeometryFlagsNV;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR ClusterAccelerationStructureGeometryIndexAndGeometryFlagsNV( uint32_t geometryIndex_ = {},
                                                                                      uint32_t reserved_      = {},
                                                                                      uint32_t geometryFlags_ = {} ) VULKAN_HPP_NOEXCEPT
      : geometryIndex{ geometryIndex_ }
      , reserved{ reserved_ }
      , geometryFlags{ geometryFlags_ }
    {
    }

    VULKAN_HPP_CONSTEXPR ClusterAccelerationStructureGeometryIndexAndGeometryFlagsNV( ClusterAccelerationStructureGeometryIndexAndGeometryFlagsNV const & rhs )
      VULKAN_HPP_NOEXCEPT = default;

    ClusterAccelerationStructureGeometryIndexAndGeometryFlagsNV( VkClusterAccelerationStructureGeometryIndexAndGeometryFlagsNV const & rhs ) VULKAN_HPP_NOEXCEPT
      : ClusterAccelerationStructureGeometryIndexAndGeometryFlagsNV(
          *reinterpret_cast<ClusterAccelerationStructureGeometryIndexAndGeometryFlagsNV const *>( &rhs ) )
    {
    }

    ClusterAccelerationStructureGeometryIndexAndGeometryFlagsNV &
      operator=( ClusterAccelerationStructureGeometryIndexAndGeometryFlagsNV const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    ClusterAccelerationStructureGeometryIndexAndGeometryFlagsNV &
      operator=( VkClusterAccelerationStructureGeometryIndexAndGeometryFlagsNV const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<ClusterAccelerationStructureGeometryIndexAndGeometryFlagsNV const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 ClusterAccelerationStructureGeometryIndexAndGeometryFlagsNV & setGeometryIndex( uint32_t geometryIndex_ ) VULKAN_HPP_NOEXCEPT
    {
      geometryIndex = geometryIndex_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ClusterAccelerationStructureGeometryIndexAndGeometryFlagsNV & setReserved( uint32_t reserved_ ) VULKAN_HPP_NOEXCEPT
    {
      reserved = reserved_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ClusterAccelerationStructureGeometryIndexAndGeometryFlagsNV & setGeometryFlags( uint32_t geometryFlags_ ) VULKAN_HPP_NOEXCEPT
    {
      geometryFlags = geometryFlags_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_SETTERS*/

    operator VkClusterAccelerationStructureGeometryIndexAndGeometryFlagsNV const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkClusterAccelerationStructureGeometryIndexAndGeometryFlagsNV *>( this );
    }

    operator VkClusterAccelerationStructureGeometryIndexAndGeometryFlagsNV &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkClusterAccelerationStructureGeometryIndexAndGeometryFlagsNV *>( this );
    }

    operator VkClusterAccelerationStructureGeometryIndexAndGeometryFlagsNV const *() const VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<const VkClusterAccelerationStructureGeometryIndexAndGeometryFlagsNV *>( this );
    }

    operator VkClusterAccelerationStructureGeometryIndexAndGeometryFlagsNV *() VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<VkClusterAccelerationStructureGeometryIndexAndGeometryFlagsNV *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<uint32_t const &, uint32_t const &, uint32_t const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( geometryIndex, reserved, geometryFlags );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( ClusterAccelerationStructureGeometryIndexAndGeometryFlagsNV const & ) const = default;
#else
    bool operator==( ClusterAccelerationStructureGeometryIndexAndGeometryFlagsNV const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( geometryIndex == rhs.geometryIndex ) && ( reserved == rhs.reserved ) && ( geometryFlags == rhs.geometryFlags );
#  endif
    }

    bool operator!=( ClusterAccelerationStructureGeometryIndexAndGeometryFlagsNV const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    uint32_t geometryIndex : 24;
    uint32_t reserved      : 5;
    uint32_t geometryFlags : 3;
  };

  // wrapper struct for struct VkClusterAccelerationStructureBuildTriangleClusterInfoNV, see
  // https://registry.khronos.org/vulkan/specs/latest/man/html/VkClusterAccelerationStructureBuildTriangleClusterInfoNV.html
  struct ClusterAccelerationStructureBuildTriangleClusterInfoNV
  {
    using NativeType = VkClusterAccelerationStructureBuildTriangleClusterInfoNV;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR ClusterAccelerationStructureBuildTriangleClusterInfoNV(
      uint32_t                                                    clusterID_                         = {},
      ClusterAccelerationStructureClusterFlagsNV                  clusterFlags_                      = {},
      uint32_t                                                    triangleCount_                     = {},
      uint32_t                                                    vertexCount_                       = {},
      uint32_t                                                    positionTruncateBitCount_          = {},
      uint32_t                                                    indexType_                         = {},
      uint32_t                                                    opacityMicromapIndexType_          = {},
      ClusterAccelerationStructureGeometryIndexAndGeometryFlagsNV baseGeometryIndexAndGeometryFlags_ = {},
      uint16_t                                                    indexBufferStride_                 = {},
      uint16_t                                                    vertexBufferStride_                = {},
      uint16_t                                                    geometryIndexAndFlagsBufferStride_ = {},
      uint16_t                                                    opacityMicromapIndexBufferStride_  = {},
      DeviceAddress                                               indexBuffer_                       = {},
      DeviceAddress                                               vertexBuffer_                      = {},
      DeviceAddress                                               geometryIndexAndFlagsBuffer_       = {},
      DeviceAddress                                               opacityMicromapArray_              = {},
      DeviceAddress                                               opacityMicromapIndexBuffer_        = {} ) VULKAN_HPP_NOEXCEPT
      : clusterID{ clusterID_ }
      , clusterFlags{ clusterFlags_ }
      , triangleCount{ triangleCount_ }
      , vertexCount{ vertexCount_ }
      , positionTruncateBitCount{ positionTruncateBitCount_ }
      , indexType{ indexType_ }
      , opacityMicromapIndexType{ opacityMicromapIndexType_ }
      , baseGeometryIndexAndGeometryFlags{ baseGeometryIndexAndGeometryFlags_ }
      , indexBufferStride{ indexBufferStride_ }
      , vertexBufferStride{ vertexBufferStride_ }
      , geometryIndexAndFlagsBufferStride{ geometryIndexAndFlagsBufferStride_ }
      , opacityMicromapIndexBufferStride{ opacityMicromapIndexBufferStride_ }
      , indexBuffer{ indexBuffer_ }
      , vertexBuffer{ vertexBuffer_ }
      , geometryIndexAndFlagsBuffer{ geometryIndexAndFlagsBuffer_ }
      , opacityMicromapArray{ opacityMicromapArray_ }
      , opacityMicromapIndexBuffer{ opacityMicromapIndexBuffer_ }
    {
    }

    VULKAN_HPP_CONSTEXPR ClusterAccelerationStructureBuildTriangleClusterInfoNV( ClusterAccelerationStructureBuildTriangleClusterInfoNV const & rhs )
      VULKAN_HPP_NOEXCEPT = default;

    ClusterAccelerationStructureBuildTriangleClusterInfoNV( VkClusterAccelerationStructureBuildTriangleClusterInfoNV const & rhs ) VULKAN_HPP_NOEXCEPT
      : ClusterAccelerationStructureBuildTriangleClusterInfoNV( *reinterpret_cast<ClusterAccelerationStructureBuildTriangleClusterInfoNV const *>( &rhs ) )
    {
    }

    ClusterAccelerationStructureBuildTriangleClusterInfoNV &
      operator=( ClusterAccelerationStructureBuildTriangleClusterInfoNV const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    ClusterAccelerationStructureBuildTriangleClusterInfoNV &
      operator=( VkClusterAccelerationStructureBuildTriangleClusterInfoNV const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<ClusterAccelerationStructureBuildTriangleClusterInfoNV const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 ClusterAccelerationStructureBuildTriangleClusterInfoNV & setClusterID( uint32_t clusterID_ ) VULKAN_HPP_NOEXCEPT
    {
      clusterID = clusterID_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ClusterAccelerationStructureBuildTriangleClusterInfoNV &
      setClusterFlags( ClusterAccelerationStructureClusterFlagsNV clusterFlags_ ) VULKAN_HPP_NOEXCEPT
    {
      clusterFlags = clusterFlags_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ClusterAccelerationStructureBuildTriangleClusterInfoNV & setTriangleCount( uint32_t triangleCount_ ) VULKAN_HPP_NOEXCEPT
    {
      triangleCount = triangleCount_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ClusterAccelerationStructureBuildTriangleClusterInfoNV & setVertexCount( uint32_t vertexCount_ ) VULKAN_HPP_NOEXCEPT
    {
      vertexCount = vertexCount_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ClusterAccelerationStructureBuildTriangleClusterInfoNV &
      setPositionTruncateBitCount( uint32_t positionTruncateBitCount_ ) VULKAN_HPP_NOEXCEPT
    {
      positionTruncateBitCount = positionTruncateBitCount_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ClusterAccelerationStructureBuildTriangleClusterInfoNV & setIndexType( uint32_t indexType_ ) VULKAN_HPP_NOEXCEPT
    {
      indexType = indexType_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ClusterAccelerationStructureBuildTriangleClusterInfoNV &
      setOpacityMicromapIndexType( uint32_t opacityMicromapIndexType_ ) VULKAN_HPP_NOEXCEPT
    {
      opacityMicromapIndexType = opacityMicromapIndexType_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ClusterAccelerationStructureBuildTriangleClusterInfoNV & setBaseGeometryIndexAndGeometryFlags(
      ClusterAccelerationStructureGeometryIndexAndGeometryFlagsNV const & baseGeometryIndexAndGeometryFlags_ ) VULKAN_HPP_NOEXCEPT
    {
      baseGeometryIndexAndGeometryFlags = baseGeometryIndexAndGeometryFlags_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ClusterAccelerationStructureBuildTriangleClusterInfoNV & setIndexBufferStride( uint16_t indexBufferStride_ ) VULKAN_HPP_NOEXCEPT
    {
      indexBufferStride = indexBufferStride_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ClusterAccelerationStructureBuildTriangleClusterInfoNV & setVertexBufferStride( uint16_t vertexBufferStride_ ) VULKAN_HPP_NOEXCEPT
    {
      vertexBufferStride = vertexBufferStride_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ClusterAccelerationStructureBuildTriangleClusterInfoNV &
      setGeometryIndexAndFlagsBufferStride( uint16_t geometryIndexAndFlagsBufferStride_ ) VULKAN_HPP_NOEXCEPT
    {
      geometryIndexAndFlagsBufferStride = geometryIndexAndFlagsBufferStride_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ClusterAccelerationStructureBuildTriangleClusterInfoNV &
      setOpacityMicromapIndexBufferStride( uint16_t opacityMicromapIndexBufferStride_ ) VULKAN_HPP_NOEXCEPT
    {
      opacityMicromapIndexBufferStride = opacityMicromapIndexBufferStride_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ClusterAccelerationStructureBuildTriangleClusterInfoNV & setIndexBuffer( DeviceAddress indexBuffer_ ) VULKAN_HPP_NOEXCEPT
    {
      indexBuffer = indexBuffer_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ClusterAccelerationStructureBuildTriangleClusterInfoNV & setVertexBuffer( DeviceAddress vertexBuffer_ ) VULKAN_HPP_NOEXCEPT
    {
      vertexBuffer = vertexBuffer_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ClusterAccelerationStructureBuildTriangleClusterInfoNV &
      setGeometryIndexAndFlagsBuffer( DeviceAddress geometryIndexAndFlagsBuffer_ ) VULKAN_HPP_NOEXCEPT
    {
      geometryIndexAndFlagsBuffer = geometryIndexAndFlagsBuffer_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ClusterAccelerationStructureBuildTriangleClusterInfoNV &
      setOpacityMicromapArray( DeviceAddress opacityMicromapArray_ ) VULKAN_HPP_NOEXCEPT
    {
      opacityMicromapArray = opacityMicromapArray_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ClusterAccelerationStructureBuildTriangleClusterInfoNV &
      setOpacityMicromapIndexBuffer( DeviceAddress opacityMicromapIndexBuffer_ ) VULKAN_HPP_NOEXCEPT
    {
      opacityMicromapIndexBuffer = opacityMicromapIndexBuffer_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_SETTERS*/

    operator VkClusterAccelerationStructureBuildTriangleClusterInfoNV const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkClusterAccelerationStructureBuildTriangleClusterInfoNV *>( this );
    }

    operator VkClusterAccelerationStructureBuildTriangleClusterInfoNV &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkClusterAccelerationStructureBuildTriangleClusterInfoNV *>( this );
    }

    operator VkClusterAccelerationStructureBuildTriangleClusterInfoNV const *() const VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<const VkClusterAccelerationStructureBuildTriangleClusterInfoNV *>( this );
    }

    operator VkClusterAccelerationStructureBuildTriangleClusterInfoNV *() VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<VkClusterAccelerationStructureBuildTriangleClusterInfoNV *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<uint32_t const &,
               ClusterAccelerationStructureClusterFlagsNV const &,
               uint32_t const &,
               uint32_t const &,
               uint32_t const &,
               uint32_t const &,
               uint32_t const &,
               ClusterAccelerationStructureGeometryIndexAndGeometryFlagsNV const &,
               uint16_t const &,
               uint16_t const &,
               uint16_t const &,
               uint16_t const &,
               DeviceAddress const &,
               DeviceAddress const &,
               DeviceAddress const &,
               DeviceAddress const &,
               DeviceAddress const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( clusterID,
                       clusterFlags,
                       triangleCount,
                       vertexCount,
                       positionTruncateBitCount,
                       indexType,
                       opacityMicromapIndexType,
                       baseGeometryIndexAndGeometryFlags,
                       indexBufferStride,
                       vertexBufferStride,
                       geometryIndexAndFlagsBufferStride,
                       opacityMicromapIndexBufferStride,
                       indexBuffer,
                       vertexBuffer,
                       geometryIndexAndFlagsBuffer,
                       opacityMicromapArray,
                       opacityMicromapIndexBuffer );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( ClusterAccelerationStructureBuildTriangleClusterInfoNV const & ) const = default;
#else
    bool operator==( ClusterAccelerationStructureBuildTriangleClusterInfoNV const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( clusterID == rhs.clusterID ) && ( clusterFlags == rhs.clusterFlags ) && ( triangleCount == rhs.triangleCount ) &&
             ( vertexCount == rhs.vertexCount ) && ( positionTruncateBitCount == rhs.positionTruncateBitCount ) && ( indexType == rhs.indexType ) &&
             ( opacityMicromapIndexType == rhs.opacityMicromapIndexType ) && ( baseGeometryIndexAndGeometryFlags == rhs.baseGeometryIndexAndGeometryFlags ) &&
             ( indexBufferStride == rhs.indexBufferStride ) && ( vertexBufferStride == rhs.vertexBufferStride ) &&
             ( geometryIndexAndFlagsBufferStride == rhs.geometryIndexAndFlagsBufferStride ) &&
             ( opacityMicromapIndexBufferStride == rhs.opacityMicromapIndexBufferStride ) && ( indexBuffer == rhs.indexBuffer ) &&
             ( vertexBuffer == rhs.vertexBuffer ) && ( geometryIndexAndFlagsBuffer == rhs.geometryIndexAndFlagsBuffer ) &&
             ( opacityMicromapArray == rhs.opacityMicromapArray ) && ( opacityMicromapIndexBuffer == rhs.opacityMicromapIndexBuffer );
#  endif
    }

    bool operator!=( ClusterAccelerationStructureBuildTriangleClusterInfoNV const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    uint32_t                                                    clusterID    = {};
    ClusterAccelerationStructureClusterFlagsNV                  clusterFlags = {};
    uint32_t                                                    triangleCount            : 9;
    uint32_t                                                    vertexCount              : 9;
    uint32_t                                                    positionTruncateBitCount : 6;
    uint32_t                                                    indexType                : 4;
    uint32_t                                                    opacityMicromapIndexType : 4;
    ClusterAccelerationStructureGeometryIndexAndGeometryFlagsNV baseGeometryIndexAndGeometryFlags = {};
    uint16_t                                                    indexBufferStride                 = {};
    uint16_t                                                    vertexBufferStride                = {};
    uint16_t                                                    geometryIndexAndFlagsBufferStride = {};
    uint16_t                                                    opacityMicromapIndexBufferStride  = {};
    DeviceAddress                                               indexBuffer                       = {};
    DeviceAddress                                               vertexBuffer                      = {};
    DeviceAddress                                               geometryIndexAndFlagsBuffer       = {};
    DeviceAddress                                               opacityMicromapArray              = {};
    DeviceAddress                                               opacityMicromapIndexBuffer        = {};
  };

  // wrapper struct for struct VkClusterAccelerationStructureBuildTriangleClusterTemplateInfoNV, see
  // https://registry.khronos.org/vulkan/specs/latest/man/html/VkClusterAccelerationStructureBuildTriangleClusterTemplateInfoNV.html
  struct ClusterAccelerationStructureBuildTriangleClusterTemplateInfoNV
  {
    using NativeType = VkClusterAccelerationStructureBuildTriangleClusterTemplateInfoNV;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR ClusterAccelerationStructureBuildTriangleClusterTemplateInfoNV(
      uint32_t                                                    clusterID_                         = {},
      ClusterAccelerationStructureClusterFlagsNV                  clusterFlags_                      = {},
      uint32_t                                                    triangleCount_                     = {},
      uint32_t                                                    vertexCount_                       = {},
      uint32_t                                                    positionTruncateBitCount_          = {},
      uint32_t                                                    indexType_                         = {},
      uint32_t                                                    opacityMicromapIndexType_          = {},
      ClusterAccelerationStructureGeometryIndexAndGeometryFlagsNV baseGeometryIndexAndGeometryFlags_ = {},
      uint16_t                                                    indexBufferStride_                 = {},
      uint16_t                                                    vertexBufferStride_                = {},
      uint16_t                                                    geometryIndexAndFlagsBufferStride_ = {},
      uint16_t                                                    opacityMicromapIndexBufferStride_  = {},
      DeviceAddress                                               indexBuffer_                       = {},
      DeviceAddress                                               vertexBuffer_                      = {},
      DeviceAddress                                               geometryIndexAndFlagsBuffer_       = {},
      DeviceAddress                                               opacityMicromapArray_              = {},
      DeviceAddress                                               opacityMicromapIndexBuffer_        = {},
      DeviceAddress                                               instantiationBoundingBoxLimit_     = {} ) VULKAN_HPP_NOEXCEPT
      : clusterID{ clusterID_ }
      , clusterFlags{ clusterFlags_ }
      , triangleCount{ triangleCount_ }
      , vertexCount{ vertexCount_ }
      , positionTruncateBitCount{ positionTruncateBitCount_ }
      , indexType{ indexType_ }
      , opacityMicromapIndexType{ opacityMicromapIndexType_ }
      , baseGeometryIndexAndGeometryFlags{ baseGeometryIndexAndGeometryFlags_ }
      , indexBufferStride{ indexBufferStride_ }
      , vertexBufferStride{ vertexBufferStride_ }
      , geometryIndexAndFlagsBufferStride{ geometryIndexAndFlagsBufferStride_ }
      , opacityMicromapIndexBufferStride{ opacityMicromapIndexBufferStride_ }
      , indexBuffer{ indexBuffer_ }
      , vertexBuffer{ vertexBuffer_ }
      , geometryIndexAndFlagsBuffer{ geometryIndexAndFlagsBuffer_ }
      , opacityMicromapArray{ opacityMicromapArray_ }
      , opacityMicromapIndexBuffer{ opacityMicromapIndexBuffer_ }
      , instantiationBoundingBoxLimit{ instantiationBoundingBoxLimit_ }
    {
    }

    VULKAN_HPP_CONSTEXPR ClusterAccelerationStructureBuildTriangleClusterTemplateInfoNV(
      ClusterAccelerationStructureBuildTriangleClusterTemplateInfoNV const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    ClusterAccelerationStructureBuildTriangleClusterTemplateInfoNV( VkClusterAccelerationStructureBuildTriangleClusterTemplateInfoNV const & rhs )
      VULKAN_HPP_NOEXCEPT
      : ClusterAccelerationStructureBuildTriangleClusterTemplateInfoNV(
          *reinterpret_cast<ClusterAccelerationStructureBuildTriangleClusterTemplateInfoNV const *>( &rhs ) )
    {
    }

    explicit ClusterAccelerationStructureBuildTriangleClusterTemplateInfoNV(
      ClusterAccelerationStructureBuildTriangleClusterInfoNV const & clusterAccelerationStructureBuildTriangleClusterInfoNV,
      DeviceAddress                                                  instantiationBoundingBoxLimit_ = {} )
      : clusterID( clusterAccelerationStructureBuildTriangleClusterInfoNV.clusterID )
      , clusterFlags( clusterAccelerationStructureBuildTriangleClusterInfoNV.clusterFlags )
      , triangleCount( clusterAccelerationStructureBuildTriangleClusterInfoNV.triangleCount )
      , vertexCount( clusterAccelerationStructureBuildTriangleClusterInfoNV.vertexCount )
      , positionTruncateBitCount( clusterAccelerationStructureBuildTriangleClusterInfoNV.positionTruncateBitCount )
      , indexType( clusterAccelerationStructureBuildTriangleClusterInfoNV.indexType )
      , opacityMicromapIndexType( clusterAccelerationStructureBuildTriangleClusterInfoNV.opacityMicromapIndexType )
      , baseGeometryIndexAndGeometryFlags( clusterAccelerationStructureBuildTriangleClusterInfoNV.baseGeometryIndexAndGeometryFlags )
      , indexBufferStride( clusterAccelerationStructureBuildTriangleClusterInfoNV.indexBufferStride )
      , vertexBufferStride( clusterAccelerationStructureBuildTriangleClusterInfoNV.vertexBufferStride )
      , geometryIndexAndFlagsBufferStride( clusterAccelerationStructureBuildTriangleClusterInfoNV.geometryIndexAndFlagsBufferStride )
      , opacityMicromapIndexBufferStride( clusterAccelerationStructureBuildTriangleClusterInfoNV.opacityMicromapIndexBufferStride )
      , indexBuffer( clusterAccelerationStructureBuildTriangleClusterInfoNV.indexBuffer )
      , vertexBuffer( clusterAccelerationStructureBuildTriangleClusterInfoNV.vertexBuffer )
      , geometryIndexAndFlagsBuffer( clusterAccelerationStructureBuildTriangleClusterInfoNV.geometryIndexAndFlagsBuffer )
      , opacityMicromapArray( clusterAccelerationStructureBuildTriangleClusterInfoNV.opacityMicromapArray )
      , opacityMicromapIndexBuffer( clusterAccelerationStructureBuildTriangleClusterInfoNV.opacityMicromapIndexBuffer )
      , instantiationBoundingBoxLimit( instantiationBoundingBoxLimit_ )
    {
    }

    ClusterAccelerationStructureBuildTriangleClusterTemplateInfoNV &
      operator=( ClusterAccelerationStructureBuildTriangleClusterTemplateInfoNV const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    ClusterAccelerationStructureBuildTriangleClusterTemplateInfoNV &
      operator=( VkClusterAccelerationStructureBuildTriangleClusterTemplateInfoNV const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<ClusterAccelerationStructureBuildTriangleClusterTemplateInfoNV const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 ClusterAccelerationStructureBuildTriangleClusterTemplateInfoNV & setClusterID( uint32_t clusterID_ ) VULKAN_HPP_NOEXCEPT
    {
      clusterID = clusterID_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ClusterAccelerationStructureBuildTriangleClusterTemplateInfoNV &
      setClusterFlags( ClusterAccelerationStructureClusterFlagsNV clusterFlags_ ) VULKAN_HPP_NOEXCEPT
    {
      clusterFlags = clusterFlags_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ClusterAccelerationStructureBuildTriangleClusterTemplateInfoNV & setTriangleCount( uint32_t triangleCount_ ) VULKAN_HPP_NOEXCEPT
    {
      triangleCount = triangleCount_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ClusterAccelerationStructureBuildTriangleClusterTemplateInfoNV & setVertexCount( uint32_t vertexCount_ ) VULKAN_HPP_NOEXCEPT
    {
      vertexCount = vertexCount_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ClusterAccelerationStructureBuildTriangleClusterTemplateInfoNV &
      setPositionTruncateBitCount( uint32_t positionTruncateBitCount_ ) VULKAN_HPP_NOEXCEPT
    {
      positionTruncateBitCount = positionTruncateBitCount_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ClusterAccelerationStructureBuildTriangleClusterTemplateInfoNV & setIndexType( uint32_t indexType_ ) VULKAN_HPP_NOEXCEPT
    {
      indexType = indexType_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ClusterAccelerationStructureBuildTriangleClusterTemplateInfoNV &
      setOpacityMicromapIndexType( uint32_t opacityMicromapIndexType_ ) VULKAN_HPP_NOEXCEPT
    {
      opacityMicromapIndexType = opacityMicromapIndexType_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ClusterAccelerationStructureBuildTriangleClusterTemplateInfoNV & setBaseGeometryIndexAndGeometryFlags(
      ClusterAccelerationStructureGeometryIndexAndGeometryFlagsNV const & baseGeometryIndexAndGeometryFlags_ ) VULKAN_HPP_NOEXCEPT
    {
      baseGeometryIndexAndGeometryFlags = baseGeometryIndexAndGeometryFlags_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ClusterAccelerationStructureBuildTriangleClusterTemplateInfoNV &
      setIndexBufferStride( uint16_t indexBufferStride_ ) VULKAN_HPP_NOEXCEPT
    {
      indexBufferStride = indexBufferStride_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ClusterAccelerationStructureBuildTriangleClusterTemplateInfoNV &
      setVertexBufferStride( uint16_t vertexBufferStride_ ) VULKAN_HPP_NOEXCEPT
    {
      vertexBufferStride = vertexBufferStride_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ClusterAccelerationStructureBuildTriangleClusterTemplateInfoNV &
      setGeometryIndexAndFlagsBufferStride( uint16_t geometryIndexAndFlagsBufferStride_ ) VULKAN_HPP_NOEXCEPT
    {
      geometryIndexAndFlagsBufferStride = geometryIndexAndFlagsBufferStride_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ClusterAccelerationStructureBuildTriangleClusterTemplateInfoNV &
      setOpacityMicromapIndexBufferStride( uint16_t opacityMicromapIndexBufferStride_ ) VULKAN_HPP_NOEXCEPT
    {
      opacityMicromapIndexBufferStride = opacityMicromapIndexBufferStride_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ClusterAccelerationStructureBuildTriangleClusterTemplateInfoNV & setIndexBuffer( DeviceAddress indexBuffer_ ) VULKAN_HPP_NOEXCEPT
    {
      indexBuffer = indexBuffer_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ClusterAccelerationStructureBuildTriangleClusterTemplateInfoNV & setVertexBuffer( DeviceAddress vertexBuffer_ ) VULKAN_HPP_NOEXCEPT
    {
      vertexBuffer = vertexBuffer_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ClusterAccelerationStructureBuildTriangleClusterTemplateInfoNV &
      setGeometryIndexAndFlagsBuffer( DeviceAddress geometryIndexAndFlagsBuffer_ ) VULKAN_HPP_NOEXCEPT
    {
      geometryIndexAndFlagsBuffer = geometryIndexAndFlagsBuffer_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ClusterAccelerationStructureBuildTriangleClusterTemplateInfoNV &
      setOpacityMicromapArray( DeviceAddress opacityMicromapArray_ ) VULKAN_HPP_NOEXCEPT
    {
      opacityMicromapArray = opacityMicromapArray_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ClusterAccelerationStructureBuildTriangleClusterTemplateInfoNV &
      setOpacityMicromapIndexBuffer( DeviceAddress opacityMicromapIndexBuffer_ ) VULKAN_HPP_NOEXCEPT
    {
      opacityMicromapIndexBuffer = opacityMicromapIndexBuffer_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ClusterAccelerationStructureBuildTriangleClusterTemplateInfoNV &
      setInstantiationBoundingBoxLimit( DeviceAddress instantiationBoundingBoxLimit_ ) VULKAN_HPP_NOEXCEPT
    {
      instantiationBoundingBoxLimit = instantiationBoundingBoxLimit_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_SETTERS*/

    operator VkClusterAccelerationStructureBuildTriangleClusterTemplateInfoNV const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkClusterAccelerationStructureBuildTriangleClusterTemplateInfoNV *>( this );
    }

    operator VkClusterAccelerationStructureBuildTriangleClusterTemplateInfoNV &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkClusterAccelerationStructureBuildTriangleClusterTemplateInfoNV *>( this );
    }

    operator VkClusterAccelerationStructureBuildTriangleClusterTemplateInfoNV const *() const VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<const VkClusterAccelerationStructureBuildTriangleClusterTemplateInfoNV *>( this );
    }

    operator VkClusterAccelerationStructureBuildTriangleClusterTemplateInfoNV *() VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<VkClusterAccelerationStructureBuildTriangleClusterTemplateInfoNV *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<uint32_t const &,
               ClusterAccelerationStructureClusterFlagsNV const &,
               uint32_t const &,
               uint32_t const &,
               uint32_t const &,
               uint32_t const &,
               uint32_t const &,
               ClusterAccelerationStructureGeometryIndexAndGeometryFlagsNV const &,
               uint16_t const &,
               uint16_t const &,
               uint16_t const &,
               uint16_t const &,
               DeviceAddress const &,
               DeviceAddress const &,
               DeviceAddress const &,
               DeviceAddress const &,
               DeviceAddress const &,
               DeviceAddress const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( clusterID,
                       clusterFlags,
                       triangleCount,
                       vertexCount,
                       positionTruncateBitCount,
                       indexType,
                       opacityMicromapIndexType,
                       baseGeometryIndexAndGeometryFlags,
                       indexBufferStride,
                       vertexBufferStride,
                       geometryIndexAndFlagsBufferStride,
                       opacityMicromapIndexBufferStride,
                       indexBuffer,
                       vertexBuffer,
                       geometryIndexAndFlagsBuffer,
                       opacityMicromapArray,
                       opacityMicromapIndexBuffer,
                       instantiationBoundingBoxLimit );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( ClusterAccelerationStructureBuildTriangleClusterTemplateInfoNV const & ) const = default;
#else
    bool operator==( ClusterAccelerationStructureBuildTriangleClusterTemplateInfoNV const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( clusterID == rhs.clusterID ) && ( clusterFlags == rhs.clusterFlags ) && ( triangleCount == rhs.triangleCount ) &&
             ( vertexCount == rhs.vertexCount ) && ( positionTruncateBitCount == rhs.positionTruncateBitCount ) && ( indexType == rhs.indexType ) &&
             ( opacityMicromapIndexType == rhs.opacityMicromapIndexType ) && ( baseGeometryIndexAndGeometryFlags == rhs.baseGeometryIndexAndGeometryFlags ) &&
             ( indexBufferStride == rhs.indexBufferStride ) && ( vertexBufferStride == rhs.vertexBufferStride ) &&
             ( geometryIndexAndFlagsBufferStride == rhs.geometryIndexAndFlagsBufferStride ) &&
             ( opacityMicromapIndexBufferStride == rhs.opacityMicromapIndexBufferStride ) && ( indexBuffer == rhs.indexBuffer ) &&
             ( vertexBuffer == rhs.vertexBuffer ) && ( geometryIndexAndFlagsBuffer == rhs.geometryIndexAndFlagsBuffer ) &&
             ( opacityMicromapArray == rhs.opacityMicromapArray ) && ( opacityMicromapIndexBuffer == rhs.opacityMicromapIndexBuffer ) &&
             ( instantiationBoundingBoxLimit == rhs.instantiationBoundingBoxLimit );
#  endif
    }

    bool operator!=( ClusterAccelerationStructureBuildTriangleClusterTemplateInfoNV const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    uint32_t                                                    clusterID    = {};
    ClusterAccelerationStructureClusterFlagsNV                  clusterFlags = {};
    uint32_t                                                    triangleCount            : 9;
    uint32_t                                                    vertexCount              : 9;
    uint32_t                                                    positionTruncateBitCount : 6;
    uint32_t                                                    indexType                : 4;
    uint32_t                                                    opacityMicromapIndexType : 4;
    ClusterAccelerationStructureGeometryIndexAndGeometryFlagsNV baseGeometryIndexAndGeometryFlags = {};
    uint16_t                                                    indexBufferStride                 = {};
    uint16_t                                                    vertexBufferStride                = {};
    uint16_t                                                    geometryIndexAndFlagsBufferStride = {};
    uint16_t                                                    opacityMicromapIndexBufferStride  = {};
    DeviceAddress                                               indexBuffer                       = {};
    DeviceAddress                                               vertexBuffer                      = {};
    DeviceAddress                                               geometryIndexAndFlagsBuffer       = {};
    DeviceAddress                                               opacityMicromapArray              = {};
    DeviceAddress                                               opacityMicromapIndexBuffer        = {};
    DeviceAddress                                               instantiationBoundingBoxLimit     = {};
  };

  // wrapper struct for struct VkClusterAccelerationStructureClustersBottomLevelInputNV, see
  // https://registry.khronos.org/vulkan/specs/latest/man/html/VkClusterAccelerationStructureClustersBottomLevelInputNV.html
  struct ClusterAccelerationStructureClustersBottomLevelInputNV
  {
    using NativeType = VkClusterAccelerationStructureClustersBottomLevelInputNV;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eClusterAccelerationStructureClustersBottomLevelInputNV;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR ClusterAccelerationStructureClustersBottomLevelInputNV( uint32_t maxTotalClusterCount_                    = {},
                                                                                 uint32_t maxClusterCountPerAccelerationStructure_ = {},
                                                                                 void *   pNext_ = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , maxTotalClusterCount{ maxTotalClusterCount_ }
      , maxClusterCountPerAccelerationStructure{ maxClusterCountPerAccelerationStructure_ }
    {
    }

    VULKAN_HPP_CONSTEXPR ClusterAccelerationStructureClustersBottomLevelInputNV( ClusterAccelerationStructureClustersBottomLevelInputNV const & rhs )
      VULKAN_HPP_NOEXCEPT = default;

    ClusterAccelerationStructureClustersBottomLevelInputNV( VkClusterAccelerationStructureClustersBottomLevelInputNV const & rhs ) VULKAN_HPP_NOEXCEPT
      : ClusterAccelerationStructureClustersBottomLevelInputNV( *reinterpret_cast<ClusterAccelerationStructureClustersBottomLevelInputNV const *>( &rhs ) )
    {
    }

    ClusterAccelerationStructureClustersBottomLevelInputNV &
      operator=( ClusterAccelerationStructureClustersBottomLevelInputNV const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    ClusterAccelerationStructureClustersBottomLevelInputNV &
      operator=( VkClusterAccelerationStructureClustersBottomLevelInputNV const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<ClusterAccelerationStructureClustersBottomLevelInputNV const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 ClusterAccelerationStructureClustersBottomLevelInputNV & setPNext( void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ClusterAccelerationStructureClustersBottomLevelInputNV &
      setMaxTotalClusterCount( uint32_t maxTotalClusterCount_ ) VULKAN_HPP_NOEXCEPT
    {
      maxTotalClusterCount = maxTotalClusterCount_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ClusterAccelerationStructureClustersBottomLevelInputNV &
      setMaxClusterCountPerAccelerationStructure( uint32_t maxClusterCountPerAccelerationStructure_ ) VULKAN_HPP_NOEXCEPT
    {
      maxClusterCountPerAccelerationStructure = maxClusterCountPerAccelerationStructure_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_SETTERS*/

    operator VkClusterAccelerationStructureClustersBottomLevelInputNV const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkClusterAccelerationStructureClustersBottomLevelInputNV *>( this );
    }

    operator VkClusterAccelerationStructureClustersBottomLevelInputNV &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkClusterAccelerationStructureClustersBottomLevelInputNV *>( this );
    }

    operator VkClusterAccelerationStructureClustersBottomLevelInputNV const *() const VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<const VkClusterAccelerationStructureClustersBottomLevelInputNV *>( this );
    }

    operator VkClusterAccelerationStructureClustersBottomLevelInputNV *() VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<VkClusterAccelerationStructureClustersBottomLevelInputNV *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<StructureType const &, void * const &, uint32_t const &, uint32_t const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, maxTotalClusterCount, maxClusterCountPerAccelerationStructure );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( ClusterAccelerationStructureClustersBottomLevelInputNV const & ) const = default;
#else
    bool operator==( ClusterAccelerationStructureClustersBottomLevelInputNV const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( maxTotalClusterCount == rhs.maxTotalClusterCount ) &&
             ( maxClusterCountPerAccelerationStructure == rhs.maxClusterCountPerAccelerationStructure );
#  endif
    }

    bool operator!=( ClusterAccelerationStructureClustersBottomLevelInputNV const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    StructureType sType                                   = StructureType::eClusterAccelerationStructureClustersBottomLevelInputNV;
    void *        pNext                                   = {};
    uint32_t      maxTotalClusterCount                    = {};
    uint32_t      maxClusterCountPerAccelerationStructure = {};
  };

  template <>
  struct CppType<StructureType, StructureType::eClusterAccelerationStructureClustersBottomLevelInputNV>
  {
    using Type = ClusterAccelerationStructureClustersBottomLevelInputNV;
  };

  // wrapper struct for struct VkClusterAccelerationStructureTriangleClusterInputNV, see
  // https://registry.khronos.org/vulkan/specs/latest/man/html/VkClusterAccelerationStructureTriangleClusterInputNV.html
  struct ClusterAccelerationStructureTriangleClusterInputNV
  {
    using NativeType = VkClusterAccelerationStructureTriangleClusterInputNV;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eClusterAccelerationStructureTriangleClusterInputNV;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR ClusterAccelerationStructureTriangleClusterInputNV( Format   vertexFormat_                  = Format::eUndefined,
                                                                             uint32_t maxGeometryIndexValue_         = {},
                                                                             uint32_t maxClusterUniqueGeometryCount_ = {},
                                                                             uint32_t maxClusterTriangleCount_       = {},
                                                                             uint32_t maxClusterVertexCount_         = {},
                                                                             uint32_t maxTotalTriangleCount_         = {},
                                                                             uint32_t maxTotalVertexCount_           = {},
                                                                             uint32_t minPositionTruncateBitCount_   = {},
                                                                             void *   pNext_                         = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , vertexFormat{ vertexFormat_ }
      , maxGeometryIndexValue{ maxGeometryIndexValue_ }
      , maxClusterUniqueGeometryCount{ maxClusterUniqueGeometryCount_ }
      , maxClusterTriangleCount{ maxClusterTriangleCount_ }
      , maxClusterVertexCount{ maxClusterVertexCount_ }
      , maxTotalTriangleCount{ maxTotalTriangleCount_ }
      , maxTotalVertexCount{ maxTotalVertexCount_ }
      , minPositionTruncateBitCount{ minPositionTruncateBitCount_ }
    {
    }

    VULKAN_HPP_CONSTEXPR
      ClusterAccelerationStructureTriangleClusterInputNV( ClusterAccelerationStructureTriangleClusterInputNV const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    ClusterAccelerationStructureTriangleClusterInputNV( VkClusterAccelerationStructureTriangleClusterInputNV const & rhs ) VULKAN_HPP_NOEXCEPT
      : ClusterAccelerationStructureTriangleClusterInputNV( *reinterpret_cast<ClusterAccelerationStructureTriangleClusterInputNV const *>( &rhs ) )
    {
    }

    ClusterAccelerationStructureTriangleClusterInputNV &
      operator=( ClusterAccelerationStructureTriangleClusterInputNV const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    ClusterAccelerationStructureTriangleClusterInputNV & operator=( VkClusterAccelerationStructureTriangleClusterInputNV const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<ClusterAccelerationStructureTriangleClusterInputNV const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 ClusterAccelerationStructureTriangleClusterInputNV & setPNext( void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ClusterAccelerationStructureTriangleClusterInputNV & setVertexFormat( Format vertexFormat_ ) VULKAN_HPP_NOEXCEPT
    {
      vertexFormat = vertexFormat_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ClusterAccelerationStructureTriangleClusterInputNV & setMaxGeometryIndexValue( uint32_t maxGeometryIndexValue_ ) VULKAN_HPP_NOEXCEPT
    {
      maxGeometryIndexValue = maxGeometryIndexValue_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ClusterAccelerationStructureTriangleClusterInputNV &
      setMaxClusterUniqueGeometryCount( uint32_t maxClusterUniqueGeometryCount_ ) VULKAN_HPP_NOEXCEPT
    {
      maxClusterUniqueGeometryCount = maxClusterUniqueGeometryCount_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ClusterAccelerationStructureTriangleClusterInputNV &
      setMaxClusterTriangleCount( uint32_t maxClusterTriangleCount_ ) VULKAN_HPP_NOEXCEPT
    {
      maxClusterTriangleCount = maxClusterTriangleCount_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ClusterAccelerationStructureTriangleClusterInputNV & setMaxClusterVertexCount( uint32_t maxClusterVertexCount_ ) VULKAN_HPP_NOEXCEPT
    {
      maxClusterVertexCount = maxClusterVertexCount_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ClusterAccelerationStructureTriangleClusterInputNV & setMaxTotalTriangleCount( uint32_t maxTotalTriangleCount_ ) VULKAN_HPP_NOEXCEPT
    {
      maxTotalTriangleCount = maxTotalTriangleCount_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ClusterAccelerationStructureTriangleClusterInputNV & setMaxTotalVertexCount( uint32_t maxTotalVertexCount_ ) VULKAN_HPP_NOEXCEPT
    {
      maxTotalVertexCount = maxTotalVertexCount_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ClusterAccelerationStructureTriangleClusterInputNV &
      setMinPositionTruncateBitCount( uint32_t minPositionTruncateBitCount_ ) VULKAN_HPP_NOEXCEPT
    {
      minPositionTruncateBitCount = minPositionTruncateBitCount_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_SETTERS*/

    operator VkClusterAccelerationStructureTriangleClusterInputNV const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkClusterAccelerationStructureTriangleClusterInputNV *>( this );
    }

    operator VkClusterAccelerationStructureTriangleClusterInputNV &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkClusterAccelerationStructureTriangleClusterInputNV *>( this );
    }

    operator VkClusterAccelerationStructureTriangleClusterInputNV const *() const VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<const VkClusterAccelerationStructureTriangleClusterInputNV *>( this );
    }

    operator VkClusterAccelerationStructureTriangleClusterInputNV *() VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<VkClusterAccelerationStructureTriangleClusterInputNV *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<StructureType const &,
               void * const &,
               Format const &,
               uint32_t const &,
               uint32_t const &,
               uint32_t const &,
               uint32_t const &,
               uint32_t const &,
               uint32_t const &,
               uint32_t const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType,
                       pNext,
                       vertexFormat,
                       maxGeometryIndexValue,
                       maxClusterUniqueGeometryCount,
                       maxClusterTriangleCount,
                       maxClusterVertexCount,
                       maxTotalTriangleCount,
                       maxTotalVertexCount,
                       minPositionTruncateBitCount );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( ClusterAccelerationStructureTriangleClusterInputNV const & ) const = default;
#else
    bool operator==( ClusterAccelerationStructureTriangleClusterInputNV const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( vertexFormat == rhs.vertexFormat ) &&
             ( maxGeometryIndexValue == rhs.maxGeometryIndexValue ) && ( maxClusterUniqueGeometryCount == rhs.maxClusterUniqueGeometryCount ) &&
             ( maxClusterTriangleCount == rhs.maxClusterTriangleCount ) && ( maxClusterVertexCount == rhs.maxClusterVertexCount ) &&
             ( maxTotalTriangleCount == rhs.maxTotalTriangleCount ) && ( maxTotalVertexCount == rhs.maxTotalVertexCount ) &&
             ( minPositionTruncateBitCount == rhs.minPositionTruncateBitCount );
#  endif
    }

    bool operator!=( ClusterAccelerationStructureTriangleClusterInputNV const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    StructureType sType                         = StructureType::eClusterAccelerationStructureTriangleClusterInputNV;
    void *        pNext                         = {};
    Format        vertexFormat                  = Format::eUndefined;
    uint32_t      maxGeometryIndexValue         = {};
    uint32_t      maxClusterUniqueGeometryCount = {};
    uint32_t      maxClusterTriangleCount       = {};
    uint32_t      maxClusterVertexCount         = {};
    uint32_t      maxTotalTriangleCount         = {};
    uint32_t      maxTotalVertexCount           = {};
    uint32_t      minPositionTruncateBitCount   = {};
  };

  template <>
  struct CppType<StructureType, StructureType::eClusterAccelerationStructureTriangleClusterInputNV>
  {
    using Type = ClusterAccelerationStructureTriangleClusterInputNV;
  };

  // wrapper struct for struct VkClusterAccelerationStructureMoveObjectsInputNV, see
  // https://registry.khronos.org/vulkan/specs/latest/man/html/VkClusterAccelerationStructureMoveObjectsInputNV.html
  struct ClusterAccelerationStructureMoveObjectsInputNV
  {
    using NativeType = VkClusterAccelerationStructureMoveObjectsInputNV;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eClusterAccelerationStructureMoveObjectsInputNV;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR
      ClusterAccelerationStructureMoveObjectsInputNV( ClusterAccelerationStructureTypeNV type_ = ClusterAccelerationStructureTypeNV::eClustersBottomLevel,
                                                      Bool32                             noMoveOverlap_ = {},
                                                      DeviceSize                         maxMovedBytes_ = {},
                                                      void *                             pNext_         = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , type{ type_ }
      , noMoveOverlap{ noMoveOverlap_ }
      , maxMovedBytes{ maxMovedBytes_ }
    {
    }

    VULKAN_HPP_CONSTEXPR
      ClusterAccelerationStructureMoveObjectsInputNV( ClusterAccelerationStructureMoveObjectsInputNV const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    ClusterAccelerationStructureMoveObjectsInputNV( VkClusterAccelerationStructureMoveObjectsInputNV const & rhs ) VULKAN_HPP_NOEXCEPT
      : ClusterAccelerationStructureMoveObjectsInputNV( *reinterpret_cast<ClusterAccelerationStructureMoveObjectsInputNV const *>( &rhs ) )
    {
    }

    ClusterAccelerationStructureMoveObjectsInputNV & operator=( ClusterAccelerationStructureMoveObjectsInputNV const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    ClusterAccelerationStructureMoveObjectsInputNV & operator=( VkClusterAccelerationStructureMoveObjectsInputNV const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<ClusterAccelerationStructureMoveObjectsInputNV const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 ClusterAccelerationStructureMoveObjectsInputNV & setPNext( void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ClusterAccelerationStructureMoveObjectsInputNV & setType( ClusterAccelerationStructureTypeNV type_ ) VULKAN_HPP_NOEXCEPT
    {
      type = type_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ClusterAccelerationStructureMoveObjectsInputNV & setNoMoveOverlap( Bool32 noMoveOverlap_ ) VULKAN_HPP_NOEXCEPT
    {
      noMoveOverlap = noMoveOverlap_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ClusterAccelerationStructureMoveObjectsInputNV & setMaxMovedBytes( DeviceSize maxMovedBytes_ ) VULKAN_HPP_NOEXCEPT
    {
      maxMovedBytes = maxMovedBytes_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_SETTERS*/

    operator VkClusterAccelerationStructureMoveObjectsInputNV const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkClusterAccelerationStructureMoveObjectsInputNV *>( this );
    }

    operator VkClusterAccelerationStructureMoveObjectsInputNV &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkClusterAccelerationStructureMoveObjectsInputNV *>( this );
    }

    operator VkClusterAccelerationStructureMoveObjectsInputNV const *() const VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<const VkClusterAccelerationStructureMoveObjectsInputNV *>( this );
    }

    operator VkClusterAccelerationStructureMoveObjectsInputNV *() VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<VkClusterAccelerationStructureMoveObjectsInputNV *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<StructureType const &, void * const &, ClusterAccelerationStructureTypeNV const &, Bool32 const &, DeviceSize const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, type, noMoveOverlap, maxMovedBytes );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( ClusterAccelerationStructureMoveObjectsInputNV const & ) const = default;
#else
    bool operator==( ClusterAccelerationStructureMoveObjectsInputNV const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( type == rhs.type ) && ( noMoveOverlap == rhs.noMoveOverlap ) &&
             ( maxMovedBytes == rhs.maxMovedBytes );
#  endif
    }

    bool operator!=( ClusterAccelerationStructureMoveObjectsInputNV const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    StructureType                      sType         = StructureType::eClusterAccelerationStructureMoveObjectsInputNV;
    void *                             pNext         = {};
    ClusterAccelerationStructureTypeNV type          = ClusterAccelerationStructureTypeNV::eClustersBottomLevel;
    Bool32                             noMoveOverlap = {};
    DeviceSize                         maxMovedBytes = {};
  };

  template <>
  struct CppType<StructureType, StructureType::eClusterAccelerationStructureMoveObjectsInputNV>
  {
    using Type = ClusterAccelerationStructureMoveObjectsInputNV;
  };

  union ClusterAccelerationStructureOpInputNV
  {
    using NativeType = VkClusterAccelerationStructureOpInputNV;
#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_UNION_CONSTRUCTORS )

    VULKAN_HPP_CONSTEXPR_14 ClusterAccelerationStructureOpInputNV( ClusterAccelerationStructureClustersBottomLevelInputNV * pClustersBottomLevel_ = {} )
      : pClustersBottomLevel( pClustersBottomLevel_ )
    {
    }

    VULKAN_HPP_CONSTEXPR_14 ClusterAccelerationStructureOpInputNV( ClusterAccelerationStructureTriangleClusterInputNV * pTriangleClusters_ )
      : pTriangleClusters( pTriangleClusters_ )
    {
    }

    VULKAN_HPP_CONSTEXPR_14 ClusterAccelerationStructureOpInputNV( ClusterAccelerationStructureMoveObjectsInputNV * pMoveObjects_ )
      : pMoveObjects( pMoveObjects_ )
    {
    }
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_UNION_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 ClusterAccelerationStructureOpInputNV &
      setPClustersBottomLevel( ClusterAccelerationStructureClustersBottomLevelInputNV * pClustersBottomLevel_ ) VULKAN_HPP_NOEXCEPT
    {
      pClustersBottomLevel = pClustersBottomLevel_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ClusterAccelerationStructureOpInputNV &
      setPTriangleClusters( ClusterAccelerationStructureTriangleClusterInputNV * pTriangleClusters_ ) VULKAN_HPP_NOEXCEPT
    {
      pTriangleClusters = pTriangleClusters_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ClusterAccelerationStructureOpInputNV &
      setPMoveObjects( ClusterAccelerationStructureMoveObjectsInputNV * pMoveObjects_ ) VULKAN_HPP_NOEXCEPT
    {
      pMoveObjects = pMoveObjects_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_SETTERS*/

    operator VkClusterAccelerationStructureOpInputNV const &() const
    {
      return *reinterpret_cast<const VkClusterAccelerationStructureOpInputNV *>( this );
    }

    operator VkClusterAccelerationStructureOpInputNV &()
    {
      return *reinterpret_cast<VkClusterAccelerationStructureOpInputNV *>( this );
    }

#ifdef VULKAN_HPP_HAS_UNRESTRICTED_UNIONS
    ClusterAccelerationStructureClustersBottomLevelInputNV * pClustersBottomLevel;
    ClusterAccelerationStructureTriangleClusterInputNV *     pTriangleClusters;
    ClusterAccelerationStructureMoveObjectsInputNV *         pMoveObjects;
#else
    VkClusterAccelerationStructureClustersBottomLevelInputNV * pClustersBottomLevel;
    VkClusterAccelerationStructureTriangleClusterInputNV *     pTriangleClusters;
    VkClusterAccelerationStructureMoveObjectsInputNV *         pMoveObjects;
#endif /*VULKAN_HPP_HAS_UNRESTRICTED_UNIONS*/
  };

  // wrapper struct for struct VkClusterAccelerationStructureInputInfoNV, see
  // https://registry.khronos.org/vulkan/specs/latest/man/html/VkClusterAccelerationStructureInputInfoNV.html
  struct ClusterAccelerationStructureInputInfoNV
  {
    using NativeType = VkClusterAccelerationStructureInputInfoNV;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eClusterAccelerationStructureInputInfoNV;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR_14
      ClusterAccelerationStructureInputInfoNV( uint32_t                              maxAccelerationStructureCount_ = {},
                                               BuildAccelerationStructureFlagsKHR    flags_                         = {},
                                               ClusterAccelerationStructureOpTypeNV  opType_  = ClusterAccelerationStructureOpTypeNV::eMoveObjects,
                                               ClusterAccelerationStructureOpModeNV  opMode_  = ClusterAccelerationStructureOpModeNV::eImplicitDestinations,
                                               ClusterAccelerationStructureOpInputNV opInput_ = {},
                                               void *                                pNext_   = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , maxAccelerationStructureCount{ maxAccelerationStructureCount_ }
      , flags{ flags_ }
      , opType{ opType_ }
      , opMode{ opMode_ }
      , opInput{ opInput_ }
    {
    }

    VULKAN_HPP_CONSTEXPR_14 ClusterAccelerationStructureInputInfoNV( ClusterAccelerationStructureInputInfoNV const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    ClusterAccelerationStructureInputInfoNV( VkClusterAccelerationStructureInputInfoNV const & rhs ) VULKAN_HPP_NOEXCEPT
      : ClusterAccelerationStructureInputInfoNV( *reinterpret_cast<ClusterAccelerationStructureInputInfoNV const *>( &rhs ) )
    {
    }

    ClusterAccelerationStructureInputInfoNV & operator=( ClusterAccelerationStructureInputInfoNV const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    ClusterAccelerationStructureInputInfoNV & operator=( VkClusterAccelerationStructureInputInfoNV const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<ClusterAccelerationStructureInputInfoNV const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 ClusterAccelerationStructureInputInfoNV & setPNext( void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ClusterAccelerationStructureInputInfoNV &
      setMaxAccelerationStructureCount( uint32_t maxAccelerationStructureCount_ ) VULKAN_HPP_NOEXCEPT
    {
      maxAccelerationStructureCount = maxAccelerationStructureCount_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ClusterAccelerationStructureInputInfoNV & setFlags( BuildAccelerationStructureFlagsKHR flags_ ) VULKAN_HPP_NOEXCEPT
    {
      flags = flags_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ClusterAccelerationStructureInputInfoNV & setOpType( ClusterAccelerationStructureOpTypeNV opType_ ) VULKAN_HPP_NOEXCEPT
    {
      opType = opType_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ClusterAccelerationStructureInputInfoNV & setOpMode( ClusterAccelerationStructureOpModeNV opMode_ ) VULKAN_HPP_NOEXCEPT
    {
      opMode = opMode_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ClusterAccelerationStructureInputInfoNV & setOpInput( ClusterAccelerationStructureOpInputNV const & opInput_ ) VULKAN_HPP_NOEXCEPT
    {
      opInput = opInput_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_SETTERS*/

    operator VkClusterAccelerationStructureInputInfoNV const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkClusterAccelerationStructureInputInfoNV *>( this );
    }

    operator VkClusterAccelerationStructureInputInfoNV &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkClusterAccelerationStructureInputInfoNV *>( this );
    }

    operator VkClusterAccelerationStructureInputInfoNV const *() const VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<const VkClusterAccelerationStructureInputInfoNV *>( this );
    }

    operator VkClusterAccelerationStructureInputInfoNV *() VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<VkClusterAccelerationStructureInputInfoNV *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<StructureType const &,
               void * const &,
               uint32_t const &,
               BuildAccelerationStructureFlagsKHR const &,
               ClusterAccelerationStructureOpTypeNV const &,
               ClusterAccelerationStructureOpModeNV const &,
               ClusterAccelerationStructureOpInputNV const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, maxAccelerationStructureCount, flags, opType, opMode, opInput );
    }
#endif

  public:
    StructureType                         sType                         = StructureType::eClusterAccelerationStructureInputInfoNV;
    void *                                pNext                         = {};
    uint32_t                              maxAccelerationStructureCount = {};
    BuildAccelerationStructureFlagsKHR    flags                         = {};
    ClusterAccelerationStructureOpTypeNV  opType                        = ClusterAccelerationStructureOpTypeNV::eMoveObjects;
    ClusterAccelerationStructureOpModeNV  opMode                        = ClusterAccelerationStructureOpModeNV::eImplicitDestinations;
    ClusterAccelerationStructureOpInputNV opInput                       = {};
  };

  template <>
  struct CppType<StructureType, StructureType::eClusterAccelerationStructureInputInfoNV>
  {
    using Type = ClusterAccelerationStructureInputInfoNV;
  };

  // wrapper struct for struct VkStridedDeviceAddressRegionKHR, see
  // https://registry.khronos.org/vulkan/specs/latest/man/html/VkStridedDeviceAddressRegionKHR.html
  struct StridedDeviceAddressRegionKHR
  {
    using NativeType = VkStridedDeviceAddressRegionKHR;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR StridedDeviceAddressRegionKHR( DeviceAddress deviceAddress_ = {}, DeviceSize stride_ = {}, DeviceSize size_ = {} ) VULKAN_HPP_NOEXCEPT
      : deviceAddress{ deviceAddress_ }
      , stride{ stride_ }
      , size{ size_ }
    {
    }

    VULKAN_HPP_CONSTEXPR StridedDeviceAddressRegionKHR( StridedDeviceAddressRegionKHR const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    StridedDeviceAddressRegionKHR( VkStridedDeviceAddressRegionKHR const & rhs ) VULKAN_HPP_NOEXCEPT
      : StridedDeviceAddressRegionKHR( *reinterpret_cast<StridedDeviceAddressRegionKHR const *>( &rhs ) )
    {
    }

    StridedDeviceAddressRegionKHR & operator=( StridedDeviceAddressRegionKHR const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    StridedDeviceAddressRegionKHR & operator=( VkStridedDeviceAddressRegionKHR const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<StridedDeviceAddressRegionKHR const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 StridedDeviceAddressRegionKHR & setDeviceAddress( DeviceAddress deviceAddress_ ) VULKAN_HPP_NOEXCEPT
    {
      deviceAddress = deviceAddress_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 StridedDeviceAddressRegionKHR & setStride( DeviceSize stride_ ) VULKAN_HPP_NOEXCEPT
    {
      stride = stride_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 StridedDeviceAddressRegionKHR & setSize( DeviceSize size_ ) VULKAN_HPP_NOEXCEPT
    {
      size = size_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_SETTERS*/

    operator VkStridedDeviceAddressRegionKHR const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkStridedDeviceAddressRegionKHR *>( this );
    }

    operator VkStridedDeviceAddressRegionKHR &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkStridedDeviceAddressRegionKHR *>( this );
    }

    operator VkStridedDeviceAddressRegionKHR const *() const VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<const VkStridedDeviceAddressRegionKHR *>( this );
    }

    operator VkStridedDeviceAddressRegionKHR *() VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<VkStridedDeviceAddressRegionKHR *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<DeviceAddress const &, DeviceSize const &, DeviceSize const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( deviceAddress, stride, size );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( StridedDeviceAddressRegionKHR const & ) const = default;
#else
    bool operator==( StridedDeviceAddressRegionKHR const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( deviceAddress == rhs.deviceAddress ) && ( stride == rhs.stride ) && ( size == rhs.size );
#  endif
    }

    bool operator!=( StridedDeviceAddressRegionKHR const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    DeviceAddress deviceAddress = {};
    DeviceSize    stride        = {};
    DeviceSize    size          = {};
  };

  // wrapper struct for struct VkClusterAccelerationStructureCommandsInfoNV, see
  // https://registry.khronos.org/vulkan/specs/latest/man/html/VkClusterAccelerationStructureCommandsInfoNV.html
  struct ClusterAccelerationStructureCommandsInfoNV
  {
    using NativeType = VkClusterAccelerationStructureCommandsInfoNV;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eClusterAccelerationStructureCommandsInfoNV;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR_14 ClusterAccelerationStructureCommandsInfoNV( ClusterAccelerationStructureInputInfoNV              input_                  = {},
                                                                        DeviceAddress                                        dstImplicitData_        = {},
                                                                        DeviceAddress                                        scratchData_            = {},
                                                                        StridedDeviceAddressRegionKHR                        dstAddressesArray_      = {},
                                                                        StridedDeviceAddressRegionKHR                        dstSizesArray_          = {},
                                                                        StridedDeviceAddressRegionKHR                        srcInfosArray_          = {},
                                                                        DeviceAddress                                        srcInfosCount_          = {},
                                                                        ClusterAccelerationStructureAddressResolutionFlagsNV addressResolutionFlags_ = {},
                                                                        void * pNext_ = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , input{ input_ }
      , dstImplicitData{ dstImplicitData_ }
      , scratchData{ scratchData_ }
      , dstAddressesArray{ dstAddressesArray_ }
      , dstSizesArray{ dstSizesArray_ }
      , srcInfosArray{ srcInfosArray_ }
      , srcInfosCount{ srcInfosCount_ }
      , addressResolutionFlags{ addressResolutionFlags_ }
    {
    }

    VULKAN_HPP_CONSTEXPR_14 ClusterAccelerationStructureCommandsInfoNV( ClusterAccelerationStructureCommandsInfoNV const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    ClusterAccelerationStructureCommandsInfoNV( VkClusterAccelerationStructureCommandsInfoNV const & rhs ) VULKAN_HPP_NOEXCEPT
      : ClusterAccelerationStructureCommandsInfoNV( *reinterpret_cast<ClusterAccelerationStructureCommandsInfoNV const *>( &rhs ) )
    {
    }

    ClusterAccelerationStructureCommandsInfoNV & operator=( ClusterAccelerationStructureCommandsInfoNV const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    ClusterAccelerationStructureCommandsInfoNV & operator=( VkClusterAccelerationStructureCommandsInfoNV const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<ClusterAccelerationStructureCommandsInfoNV const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 ClusterAccelerationStructureCommandsInfoNV & setPNext( void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ClusterAccelerationStructureCommandsInfoNV & setInput( ClusterAccelerationStructureInputInfoNV const & input_ ) VULKAN_HPP_NOEXCEPT
    {
      input = input_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ClusterAccelerationStructureCommandsInfoNV & setDstImplicitData( DeviceAddress dstImplicitData_ ) VULKAN_HPP_NOEXCEPT
    {
      dstImplicitData = dstImplicitData_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ClusterAccelerationStructureCommandsInfoNV & setScratchData( DeviceAddress scratchData_ ) VULKAN_HPP_NOEXCEPT
    {
      scratchData = scratchData_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ClusterAccelerationStructureCommandsInfoNV &
      setDstAddressesArray( StridedDeviceAddressRegionKHR const & dstAddressesArray_ ) VULKAN_HPP_NOEXCEPT
    {
      dstAddressesArray = dstAddressesArray_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ClusterAccelerationStructureCommandsInfoNV &
      setDstSizesArray( StridedDeviceAddressRegionKHR const & dstSizesArray_ ) VULKAN_HPP_NOEXCEPT
    {
      dstSizesArray = dstSizesArray_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ClusterAccelerationStructureCommandsInfoNV &
      setSrcInfosArray( StridedDeviceAddressRegionKHR const & srcInfosArray_ ) VULKAN_HPP_NOEXCEPT
    {
      srcInfosArray = srcInfosArray_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ClusterAccelerationStructureCommandsInfoNV & setSrcInfosCount( DeviceAddress srcInfosCount_ ) VULKAN_HPP_NOEXCEPT
    {
      srcInfosCount = srcInfosCount_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ClusterAccelerationStructureCommandsInfoNV &
      setAddressResolutionFlags( ClusterAccelerationStructureAddressResolutionFlagsNV addressResolutionFlags_ ) VULKAN_HPP_NOEXCEPT
    {
      addressResolutionFlags = addressResolutionFlags_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_SETTERS*/

    operator VkClusterAccelerationStructureCommandsInfoNV const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkClusterAccelerationStructureCommandsInfoNV *>( this );
    }

    operator VkClusterAccelerationStructureCommandsInfoNV &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkClusterAccelerationStructureCommandsInfoNV *>( this );
    }

    operator VkClusterAccelerationStructureCommandsInfoNV const *() const VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<const VkClusterAccelerationStructureCommandsInfoNV *>( this );
    }

    operator VkClusterAccelerationStructureCommandsInfoNV *() VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<VkClusterAccelerationStructureCommandsInfoNV *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<StructureType const &,
               void * const &,
               ClusterAccelerationStructureInputInfoNV const &,
               DeviceAddress const &,
               DeviceAddress const &,
               StridedDeviceAddressRegionKHR const &,
               StridedDeviceAddressRegionKHR const &,
               StridedDeviceAddressRegionKHR const &,
               DeviceAddress const &,
               ClusterAccelerationStructureAddressResolutionFlagsNV const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie(
        sType, pNext, input, dstImplicitData, scratchData, dstAddressesArray, dstSizesArray, srcInfosArray, srcInfosCount, addressResolutionFlags );
    }
#endif

  public:
    StructureType                                        sType                  = StructureType::eClusterAccelerationStructureCommandsInfoNV;
    void *                                               pNext                  = {};
    ClusterAccelerationStructureInputInfoNV              input                  = {};
    DeviceAddress                                        dstImplicitData        = {};
    DeviceAddress                                        scratchData            = {};
    StridedDeviceAddressRegionKHR                        dstAddressesArray      = {};
    StridedDeviceAddressRegionKHR                        dstSizesArray          = {};
    StridedDeviceAddressRegionKHR                        srcInfosArray          = {};
    DeviceAddress                                        srcInfosCount          = {};
    ClusterAccelerationStructureAddressResolutionFlagsNV addressResolutionFlags = {};
  };

  template <>
  struct CppType<StructureType, StructureType::eClusterAccelerationStructureCommandsInfoNV>
  {
    using Type = ClusterAccelerationStructureCommandsInfoNV;
  };

  // wrapper struct for struct VkClusterAccelerationStructureGetTemplateIndicesInfoNV, see
  // https://registry.khronos.org/vulkan/specs/latest/man/html/VkClusterAccelerationStructureGetTemplateIndicesInfoNV.html
  struct ClusterAccelerationStructureGetTemplateIndicesInfoNV
  {
    using NativeType = VkClusterAccelerationStructureGetTemplateIndicesInfoNV;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR ClusterAccelerationStructureGetTemplateIndicesInfoNV( DeviceAddress clusterTemplateAddress_ = {} ) VULKAN_HPP_NOEXCEPT
      : clusterTemplateAddress{ clusterTemplateAddress_ }
    {
    }

    VULKAN_HPP_CONSTEXPR
      ClusterAccelerationStructureGetTemplateIndicesInfoNV( ClusterAccelerationStructureGetTemplateIndicesInfoNV const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    ClusterAccelerationStructureGetTemplateIndicesInfoNV( VkClusterAccelerationStructureGetTemplateIndicesInfoNV const & rhs ) VULKAN_HPP_NOEXCEPT
      : ClusterAccelerationStructureGetTemplateIndicesInfoNV( *reinterpret_cast<ClusterAccelerationStructureGetTemplateIndicesInfoNV const *>( &rhs ) )
    {
    }

    ClusterAccelerationStructureGetTemplateIndicesInfoNV &
      operator=( ClusterAccelerationStructureGetTemplateIndicesInfoNV const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    ClusterAccelerationStructureGetTemplateIndicesInfoNV & operator=( VkClusterAccelerationStructureGetTemplateIndicesInfoNV const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<ClusterAccelerationStructureGetTemplateIndicesInfoNV const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 ClusterAccelerationStructureGetTemplateIndicesInfoNV &
      setClusterTemplateAddress( DeviceAddress clusterTemplateAddress_ ) VULKAN_HPP_NOEXCEPT
    {
      clusterTemplateAddress = clusterTemplateAddress_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_SETTERS*/

    operator VkClusterAccelerationStructureGetTemplateIndicesInfoNV const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkClusterAccelerationStructureGetTemplateIndicesInfoNV *>( this );
    }

    operator VkClusterAccelerationStructureGetTemplateIndicesInfoNV &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkClusterAccelerationStructureGetTemplateIndicesInfoNV *>( this );
    }

    operator VkClusterAccelerationStructureGetTemplateIndicesInfoNV const *() const VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<const VkClusterAccelerationStructureGetTemplateIndicesInfoNV *>( this );
    }

    operator VkClusterAccelerationStructureGetTemplateIndicesInfoNV *() VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<VkClusterAccelerationStructureGetTemplateIndicesInfoNV *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<DeviceAddress const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( clusterTemplateAddress );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( ClusterAccelerationStructureGetTemplateIndicesInfoNV const & ) const = default;
#else
    bool operator==( ClusterAccelerationStructureGetTemplateIndicesInfoNV const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( clusterTemplateAddress == rhs.clusterTemplateAddress );
#  endif
    }

    bool operator!=( ClusterAccelerationStructureGetTemplateIndicesInfoNV const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    DeviceAddress clusterTemplateAddress = {};
  };

  // wrapper struct for struct VkClusterAccelerationStructureInstantiateClusterInfoNV, see
  // https://registry.khronos.org/vulkan/specs/latest/man/html/VkClusterAccelerationStructureInstantiateClusterInfoNV.html
  struct ClusterAccelerationStructureInstantiateClusterInfoNV
  {
    using NativeType = VkClusterAccelerationStructureInstantiateClusterInfoNV;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR ClusterAccelerationStructureInstantiateClusterInfoNV( uint32_t               clusterIdOffset_        = {},
                                                                               uint32_t               geometryIndexOffset_    = {},
                                                                               uint32_t               reserved_               = {},
                                                                               DeviceAddress          clusterTemplateAddress_ = {},
                                                                               StridedDeviceAddressNV vertexBuffer_           = {} ) VULKAN_HPP_NOEXCEPT
      : clusterIdOffset{ clusterIdOffset_ }
      , geometryIndexOffset{ geometryIndexOffset_ }
      , reserved{ reserved_ }
      , clusterTemplateAddress{ clusterTemplateAddress_ }
      , vertexBuffer{ vertexBuffer_ }
    {
    }

    VULKAN_HPP_CONSTEXPR
      ClusterAccelerationStructureInstantiateClusterInfoNV( ClusterAccelerationStructureInstantiateClusterInfoNV const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    ClusterAccelerationStructureInstantiateClusterInfoNV( VkClusterAccelerationStructureInstantiateClusterInfoNV const & rhs ) VULKAN_HPP_NOEXCEPT
      : ClusterAccelerationStructureInstantiateClusterInfoNV( *reinterpret_cast<ClusterAccelerationStructureInstantiateClusterInfoNV const *>( &rhs ) )
    {
    }

    ClusterAccelerationStructureInstantiateClusterInfoNV &
      operator=( ClusterAccelerationStructureInstantiateClusterInfoNV const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    ClusterAccelerationStructureInstantiateClusterInfoNV & operator=( VkClusterAccelerationStructureInstantiateClusterInfoNV const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<ClusterAccelerationStructureInstantiateClusterInfoNV const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 ClusterAccelerationStructureInstantiateClusterInfoNV & setClusterIdOffset( uint32_t clusterIdOffset_ ) VULKAN_HPP_NOEXCEPT
    {
      clusterIdOffset = clusterIdOffset_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ClusterAccelerationStructureInstantiateClusterInfoNV & setGeometryIndexOffset( uint32_t geometryIndexOffset_ ) VULKAN_HPP_NOEXCEPT
    {
      geometryIndexOffset = geometryIndexOffset_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ClusterAccelerationStructureInstantiateClusterInfoNV & setReserved( uint32_t reserved_ ) VULKAN_HPP_NOEXCEPT
    {
      reserved = reserved_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ClusterAccelerationStructureInstantiateClusterInfoNV &
      setClusterTemplateAddress( DeviceAddress clusterTemplateAddress_ ) VULKAN_HPP_NOEXCEPT
    {
      clusterTemplateAddress = clusterTemplateAddress_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ClusterAccelerationStructureInstantiateClusterInfoNV &
      setVertexBuffer( StridedDeviceAddressNV const & vertexBuffer_ ) VULKAN_HPP_NOEXCEPT
    {
      vertexBuffer = vertexBuffer_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_SETTERS*/

    operator VkClusterAccelerationStructureInstantiateClusterInfoNV const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkClusterAccelerationStructureInstantiateClusterInfoNV *>( this );
    }

    operator VkClusterAccelerationStructureInstantiateClusterInfoNV &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkClusterAccelerationStructureInstantiateClusterInfoNV *>( this );
    }

    operator VkClusterAccelerationStructureInstantiateClusterInfoNV const *() const VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<const VkClusterAccelerationStructureInstantiateClusterInfoNV *>( this );
    }

    operator VkClusterAccelerationStructureInstantiateClusterInfoNV *() VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<VkClusterAccelerationStructureInstantiateClusterInfoNV *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<uint32_t const &, uint32_t const &, uint32_t const &, DeviceAddress const &, StridedDeviceAddressNV const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( clusterIdOffset, geometryIndexOffset, reserved, clusterTemplateAddress, vertexBuffer );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( ClusterAccelerationStructureInstantiateClusterInfoNV const & ) const = default;
#else
    bool operator==( ClusterAccelerationStructureInstantiateClusterInfoNV const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( clusterIdOffset == rhs.clusterIdOffset ) && ( geometryIndexOffset == rhs.geometryIndexOffset ) && ( reserved == rhs.reserved ) &&
             ( clusterTemplateAddress == rhs.clusterTemplateAddress ) && ( vertexBuffer == rhs.vertexBuffer );
#  endif
    }

    bool operator!=( ClusterAccelerationStructureInstantiateClusterInfoNV const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    uint32_t               clusterIdOffset = {};
    uint32_t               geometryIndexOffset : 24;
    uint32_t               reserved            : 8;
    DeviceAddress          clusterTemplateAddress = {};
    StridedDeviceAddressNV vertexBuffer           = {};
  };

  // wrapper struct for struct VkClusterAccelerationStructureMoveObjectsInfoNV, see
  // https://registry.khronos.org/vulkan/specs/latest/man/html/VkClusterAccelerationStructureMoveObjectsInfoNV.html
  struct ClusterAccelerationStructureMoveObjectsInfoNV
  {
    using NativeType = VkClusterAccelerationStructureMoveObjectsInfoNV;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR ClusterAccelerationStructureMoveObjectsInfoNV( DeviceAddress srcAccelerationStructure_ = {} ) VULKAN_HPP_NOEXCEPT
      : srcAccelerationStructure{ srcAccelerationStructure_ }
    {
    }

    VULKAN_HPP_CONSTEXPR
      ClusterAccelerationStructureMoveObjectsInfoNV( ClusterAccelerationStructureMoveObjectsInfoNV const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    ClusterAccelerationStructureMoveObjectsInfoNV( VkClusterAccelerationStructureMoveObjectsInfoNV const & rhs ) VULKAN_HPP_NOEXCEPT
      : ClusterAccelerationStructureMoveObjectsInfoNV( *reinterpret_cast<ClusterAccelerationStructureMoveObjectsInfoNV const *>( &rhs ) )
    {
    }

    ClusterAccelerationStructureMoveObjectsInfoNV & operator=( ClusterAccelerationStructureMoveObjectsInfoNV const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    ClusterAccelerationStructureMoveObjectsInfoNV & operator=( VkClusterAccelerationStructureMoveObjectsInfoNV const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<ClusterAccelerationStructureMoveObjectsInfoNV const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 ClusterAccelerationStructureMoveObjectsInfoNV &
      setSrcAccelerationStructure( DeviceAddress srcAccelerationStructure_ ) VULKAN_HPP_NOEXCEPT
    {
      srcAccelerationStructure = srcAccelerationStructure_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_SETTERS*/

    operator VkClusterAccelerationStructureMoveObjectsInfoNV const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkClusterAccelerationStructureMoveObjectsInfoNV *>( this );
    }

    operator VkClusterAccelerationStructureMoveObjectsInfoNV &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkClusterAccelerationStructureMoveObjectsInfoNV *>( this );
    }

    operator VkClusterAccelerationStructureMoveObjectsInfoNV const *() const VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<const VkClusterAccelerationStructureMoveObjectsInfoNV *>( this );
    }

    operator VkClusterAccelerationStructureMoveObjectsInfoNV *() VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<VkClusterAccelerationStructureMoveObjectsInfoNV *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<DeviceAddress const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( srcAccelerationStructure );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( ClusterAccelerationStructureMoveObjectsInfoNV const & ) const = default;
#else
    bool operator==( ClusterAccelerationStructureMoveObjectsInfoNV const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( srcAccelerationStructure == rhs.srcAccelerationStructure );
#  endif
    }

    bool operator!=( ClusterAccelerationStructureMoveObjectsInfoNV const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    DeviceAddress srcAccelerationStructure = {};
  };

  // wrapper struct for struct VkCoarseSampleLocationNV, see https://registry.khronos.org/vulkan/specs/latest/man/html/VkCoarseSampleLocationNV.html
  struct CoarseSampleLocationNV
  {
    using NativeType = VkCoarseSampleLocationNV;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR CoarseSampleLocationNV( uint32_t pixelX_ = {}, uint32_t pixelY_ = {}, uint32_t sample_ = {} ) VULKAN_HPP_NOEXCEPT
      : pixelX{ pixelX_ }
      , pixelY{ pixelY_ }
      , sample{ sample_ }
    {
    }

    VULKAN_HPP_CONSTEXPR CoarseSampleLocationNV( CoarseSampleLocationNV const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    CoarseSampleLocationNV( VkCoarseSampleLocationNV const & rhs ) VULKAN_HPP_NOEXCEPT
      : CoarseSampleLocationNV( *reinterpret_cast<CoarseSampleLocationNV const *>( &rhs ) )
    {
    }

    CoarseSampleLocationNV & operator=( CoarseSampleLocationNV const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    CoarseSampleLocationNV & operator=( VkCoarseSampleLocationNV const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<CoarseSampleLocationNV const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 CoarseSampleLocationNV & setPixelX( uint32_t pixelX_ ) VULKAN_HPP_NOEXCEPT
    {
      pixelX = pixelX_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CoarseSampleLocationNV & setPixelY( uint32_t pixelY_ ) VULKAN_HPP_NOEXCEPT
    {
      pixelY = pixelY_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CoarseSampleLocationNV & setSample( uint32_t sample_ ) VULKAN_HPP_NOEXCEPT
    {
      sample = sample_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_SETTERS*/

    operator VkCoarseSampleLocationNV const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkCoarseSampleLocationNV *>( this );
    }

    operator VkCoarseSampleLocationNV &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkCoarseSampleLocationNV *>( this );
    }

    operator VkCoarseSampleLocationNV const *() const VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<const VkCoarseSampleLocationNV *>( this );
    }

    operator VkCoarseSampleLocationNV *() VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<VkCoarseSampleLocationNV *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<uint32_t const &, uint32_t const &, uint32_t const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( pixelX, pixelY, sample );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( CoarseSampleLocationNV const & ) const = default;
#else
    bool operator==( CoarseSampleLocationNV const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( pixelX == rhs.pixelX ) && ( pixelY == rhs.pixelY ) && ( sample == rhs.sample );
#  endif
    }

    bool operator!=( CoarseSampleLocationNV const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    uint32_t pixelX = {};
    uint32_t pixelY = {};
    uint32_t sample = {};
  };

  // wrapper struct for struct VkCoarseSampleOrderCustomNV, see https://registry.khronos.org/vulkan/specs/latest/man/html/VkCoarseSampleOrderCustomNV.html
  struct CoarseSampleOrderCustomNV
  {
    using NativeType = VkCoarseSampleOrderCustomNV;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR CoarseSampleOrderCustomNV( ShadingRatePaletteEntryNV      shadingRate_         = ShadingRatePaletteEntryNV::eNoInvocations,
                                                    uint32_t                       sampleCount_         = {},
                                                    uint32_t                       sampleLocationCount_ = {},
                                                    const CoarseSampleLocationNV * pSampleLocations_    = {} ) VULKAN_HPP_NOEXCEPT
      : shadingRate{ shadingRate_ }
      , sampleCount{ sampleCount_ }
      , sampleLocationCount{ sampleLocationCount_ }
      , pSampleLocations{ pSampleLocations_ }
    {
    }

    VULKAN_HPP_CONSTEXPR CoarseSampleOrderCustomNV( CoarseSampleOrderCustomNV const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    CoarseSampleOrderCustomNV( VkCoarseSampleOrderCustomNV const & rhs ) VULKAN_HPP_NOEXCEPT
      : CoarseSampleOrderCustomNV( *reinterpret_cast<CoarseSampleOrderCustomNV const *>( &rhs ) )
    {
    }

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    CoarseSampleOrderCustomNV( ShadingRatePaletteEntryNV                                     shadingRate_,
                               uint32_t                                                      sampleCount_,
                               ArrayProxyNoTemporaries<const CoarseSampleLocationNV> const & sampleLocations_ )
      : shadingRate( shadingRate_ )
      , sampleCount( sampleCount_ )
      , sampleLocationCount( static_cast<uint32_t>( sampleLocations_.size() ) )
      , pSampleLocations( sampleLocations_.data() )
    {
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/

    CoarseSampleOrderCustomNV & operator=( CoarseSampleOrderCustomNV const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    CoarseSampleOrderCustomNV & operator=( VkCoarseSampleOrderCustomNV const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<CoarseSampleOrderCustomNV const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 CoarseSampleOrderCustomNV & setShadingRate( ShadingRatePaletteEntryNV shadingRate_ ) VULKAN_HPP_NOEXCEPT
    {
      shadingRate = shadingRate_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CoarseSampleOrderCustomNV & setSampleCount( uint32_t sampleCount_ ) VULKAN_HPP_NOEXCEPT
    {
      sampleCount = sampleCount_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CoarseSampleOrderCustomNV & setSampleLocationCount( uint32_t sampleLocationCount_ ) VULKAN_HPP_NOEXCEPT
    {
      sampleLocationCount = sampleLocationCount_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CoarseSampleOrderCustomNV & setPSampleLocations( const CoarseSampleLocationNV * pSampleLocations_ ) VULKAN_HPP_NOEXCEPT
    {
      pSampleLocations = pSampleLocations_;
      return *this;
    }

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    CoarseSampleOrderCustomNV & setSampleLocations( ArrayProxyNoTemporaries<const CoarseSampleLocationNV> const & sampleLocations_ ) VULKAN_HPP_NOEXCEPT
    {
      sampleLocationCount = static_cast<uint32_t>( sampleLocations_.size() );
      pSampleLocations    = sampleLocations_.data();
      return *this;
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/
#endif   /*VULKAN_HPP_NO_SETTERS*/

    operator VkCoarseSampleOrderCustomNV const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkCoarseSampleOrderCustomNV *>( this );
    }

    operator VkCoarseSampleOrderCustomNV &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkCoarseSampleOrderCustomNV *>( this );
    }

    operator VkCoarseSampleOrderCustomNV const *() const VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<const VkCoarseSampleOrderCustomNV *>( this );
    }

    operator VkCoarseSampleOrderCustomNV *() VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<VkCoarseSampleOrderCustomNV *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<ShadingRatePaletteEntryNV const &, uint32_t const &, uint32_t const &, const CoarseSampleLocationNV * const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( shadingRate, sampleCount, sampleLocationCount, pSampleLocations );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( CoarseSampleOrderCustomNV const & ) const = default;
#else
    bool operator==( CoarseSampleOrderCustomNV const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( shadingRate == rhs.shadingRate ) && ( sampleCount == rhs.sampleCount ) && ( sampleLocationCount == rhs.sampleLocationCount ) &&
             ( pSampleLocations == rhs.pSampleLocations );
#  endif
    }

    bool operator!=( CoarseSampleOrderCustomNV const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    ShadingRatePaletteEntryNV      shadingRate         = ShadingRatePaletteEntryNV::eNoInvocations;
    uint32_t                       sampleCount         = {};
    uint32_t                       sampleLocationCount = {};
    const CoarseSampleLocationNV * pSampleLocations    = {};
  };

  // wrapper struct for struct VkColorBlendAdvancedEXT, see https://registry.khronos.org/vulkan/specs/latest/man/html/VkColorBlendAdvancedEXT.html
  struct ColorBlendAdvancedEXT
  {
    using NativeType = VkColorBlendAdvancedEXT;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR ColorBlendAdvancedEXT( BlendOp         advancedBlendOp_  = BlendOp::eAdd,
                                                Bool32          srcPremultiplied_ = {},
                                                Bool32          dstPremultiplied_ = {},
                                                BlendOverlapEXT blendOverlap_     = BlendOverlapEXT::eUncorrelated,
                                                Bool32          clampResults_     = {} ) VULKAN_HPP_NOEXCEPT
      : advancedBlendOp{ advancedBlendOp_ }
      , srcPremultiplied{ srcPremultiplied_ }
      , dstPremultiplied{ dstPremultiplied_ }
      , blendOverlap{ blendOverlap_ }
      , clampResults{ clampResults_ }
    {
    }

    VULKAN_HPP_CONSTEXPR ColorBlendAdvancedEXT( ColorBlendAdvancedEXT const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    ColorBlendAdvancedEXT( VkColorBlendAdvancedEXT const & rhs ) VULKAN_HPP_NOEXCEPT
      : ColorBlendAdvancedEXT( *reinterpret_cast<ColorBlendAdvancedEXT const *>( &rhs ) )
    {
    }

    ColorBlendAdvancedEXT & operator=( ColorBlendAdvancedEXT const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    ColorBlendAdvancedEXT & operator=( VkColorBlendAdvancedEXT const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<ColorBlendAdvancedEXT const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 ColorBlendAdvancedEXT & setAdvancedBlendOp( BlendOp advancedBlendOp_ ) VULKAN_HPP_NOEXCEPT
    {
      advancedBlendOp = advancedBlendOp_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ColorBlendAdvancedEXT & setSrcPremultiplied( Bool32 srcPremultiplied_ ) VULKAN_HPP_NOEXCEPT
    {
      srcPremultiplied = srcPremultiplied_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ColorBlendAdvancedEXT & setDstPremultiplied( Bool32 dstPremultiplied_ ) VULKAN_HPP_NOEXCEPT
    {
      dstPremultiplied = dstPremultiplied_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ColorBlendAdvancedEXT & setBlendOverlap( BlendOverlapEXT blendOverlap_ ) VULKAN_HPP_NOEXCEPT
    {
      blendOverlap = blendOverlap_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ColorBlendAdvancedEXT & setClampResults( Bool32 clampResults_ ) VULKAN_HPP_NOEXCEPT
    {
      clampResults = clampResults_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_SETTERS*/

    operator VkColorBlendAdvancedEXT const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkColorBlendAdvancedEXT *>( this );
    }

    operator VkColorBlendAdvancedEXT &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkColorBlendAdvancedEXT *>( this );
    }

    operator VkColorBlendAdvancedEXT const *() const VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<const VkColorBlendAdvancedEXT *>( this );
    }

    operator VkColorBlendAdvancedEXT *() VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<VkColorBlendAdvancedEXT *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<BlendOp const &, Bool32 const &, Bool32 const &, BlendOverlapEXT const &, Bool32 const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( advancedBlendOp, srcPremultiplied, dstPremultiplied, blendOverlap, clampResults );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( ColorBlendAdvancedEXT const & ) const = default;
#else
    bool operator==( ColorBlendAdvancedEXT const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( advancedBlendOp == rhs.advancedBlendOp ) && ( srcPremultiplied == rhs.srcPremultiplied ) && ( dstPremultiplied == rhs.dstPremultiplied ) &&
             ( blendOverlap == rhs.blendOverlap ) && ( clampResults == rhs.clampResults );
#  endif
    }

    bool operator!=( ColorBlendAdvancedEXT const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    BlendOp         advancedBlendOp  = BlendOp::eAdd;
    Bool32          srcPremultiplied = {};
    Bool32          dstPremultiplied = {};
    BlendOverlapEXT blendOverlap     = BlendOverlapEXT::eUncorrelated;
    Bool32          clampResults     = {};
  };

  // wrapper struct for struct VkColorBlendEquationEXT, see https://registry.khronos.org/vulkan/specs/latest/man/html/VkColorBlendEquationEXT.html
  struct ColorBlendEquationEXT
  {
    using NativeType = VkColorBlendEquationEXT;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR ColorBlendEquationEXT( BlendFactor srcColorBlendFactor_ = BlendFactor::eZero,
                                                BlendFactor dstColorBlendFactor_ = BlendFactor::eZero,
                                                BlendOp     colorBlendOp_        = BlendOp::eAdd,
                                                BlendFactor srcAlphaBlendFactor_ = BlendFactor::eZero,
                                                BlendFactor dstAlphaBlendFactor_ = BlendFactor::eZero,
                                                BlendOp     alphaBlendOp_        = BlendOp::eAdd ) VULKAN_HPP_NOEXCEPT
      : srcColorBlendFactor{ srcColorBlendFactor_ }
      , dstColorBlendFactor{ dstColorBlendFactor_ }
      , colorBlendOp{ colorBlendOp_ }
      , srcAlphaBlendFactor{ srcAlphaBlendFactor_ }
      , dstAlphaBlendFactor{ dstAlphaBlendFactor_ }
      , alphaBlendOp{ alphaBlendOp_ }
    {
    }

    VULKAN_HPP_CONSTEXPR ColorBlendEquationEXT( ColorBlendEquationEXT const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    ColorBlendEquationEXT( VkColorBlendEquationEXT const & rhs ) VULKAN_HPP_NOEXCEPT
      : ColorBlendEquationEXT( *reinterpret_cast<ColorBlendEquationEXT const *>( &rhs ) )
    {
    }

    ColorBlendEquationEXT & operator=( ColorBlendEquationEXT const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    ColorBlendEquationEXT & operator=( VkColorBlendEquationEXT const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<ColorBlendEquationEXT const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 ColorBlendEquationEXT & setSrcColorBlendFactor( BlendFactor srcColorBlendFactor_ ) VULKAN_HPP_NOEXCEPT
    {
      srcColorBlendFactor = srcColorBlendFactor_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ColorBlendEquationEXT & setDstColorBlendFactor( BlendFactor dstColorBlendFactor_ ) VULKAN_HPP_NOEXCEPT
    {
      dstColorBlendFactor = dstColorBlendFactor_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ColorBlendEquationEXT & setColorBlendOp( BlendOp colorBlendOp_ ) VULKAN_HPP_NOEXCEPT
    {
      colorBlendOp = colorBlendOp_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ColorBlendEquationEXT & setSrcAlphaBlendFactor( BlendFactor srcAlphaBlendFactor_ ) VULKAN_HPP_NOEXCEPT
    {
      srcAlphaBlendFactor = srcAlphaBlendFactor_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ColorBlendEquationEXT & setDstAlphaBlendFactor( BlendFactor dstAlphaBlendFactor_ ) VULKAN_HPP_NOEXCEPT
    {
      dstAlphaBlendFactor = dstAlphaBlendFactor_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ColorBlendEquationEXT & setAlphaBlendOp( BlendOp alphaBlendOp_ ) VULKAN_HPP_NOEXCEPT
    {
      alphaBlendOp = alphaBlendOp_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_SETTERS*/

    operator VkColorBlendEquationEXT const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkColorBlendEquationEXT *>( this );
    }

    operator VkColorBlendEquationEXT &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkColorBlendEquationEXT *>( this );
    }

    operator VkColorBlendEquationEXT const *() const VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<const VkColorBlendEquationEXT *>( this );
    }

    operator VkColorBlendEquationEXT *() VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<VkColorBlendEquationEXT *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<BlendFactor const &, BlendFactor const &, BlendOp const &, BlendFactor const &, BlendFactor const &, BlendOp const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( srcColorBlendFactor, dstColorBlendFactor, colorBlendOp, srcAlphaBlendFactor, dstAlphaBlendFactor, alphaBlendOp );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( ColorBlendEquationEXT const & ) const = default;
#else
    bool operator==( ColorBlendEquationEXT const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( srcColorBlendFactor == rhs.srcColorBlendFactor ) && ( dstColorBlendFactor == rhs.dstColorBlendFactor ) && ( colorBlendOp == rhs.colorBlendOp ) &&
             ( srcAlphaBlendFactor == rhs.srcAlphaBlendFactor ) && ( dstAlphaBlendFactor == rhs.dstAlphaBlendFactor ) && ( alphaBlendOp == rhs.alphaBlendOp );
#  endif
    }

    bool operator!=( ColorBlendEquationEXT const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    BlendFactor srcColorBlendFactor = BlendFactor::eZero;
    BlendFactor dstColorBlendFactor = BlendFactor::eZero;
    BlendOp     colorBlendOp        = BlendOp::eAdd;
    BlendFactor srcAlphaBlendFactor = BlendFactor::eZero;
    BlendFactor dstAlphaBlendFactor = BlendFactor::eZero;
    BlendOp     alphaBlendOp        = BlendOp::eAdd;
  };

  // wrapper struct for struct VkCommandBufferAllocateInfo, see https://registry.khronos.org/vulkan/specs/latest/man/html/VkCommandBufferAllocateInfo.html
  struct CommandBufferAllocateInfo
  {
    using NativeType = VkCommandBufferAllocateInfo;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eCommandBufferAllocateInfo;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR CommandBufferAllocateInfo( CommandPool        commandPool_        = {},
                                                    CommandBufferLevel level_              = CommandBufferLevel::ePrimary,
                                                    uint32_t           commandBufferCount_ = {},
                                                    const void *       pNext_              = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , commandPool{ commandPool_ }
      , level{ level_ }
      , commandBufferCount{ commandBufferCount_ }
    {
    }

    VULKAN_HPP_CONSTEXPR CommandBufferAllocateInfo( CommandBufferAllocateInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    CommandBufferAllocateInfo( VkCommandBufferAllocateInfo const & rhs ) VULKAN_HPP_NOEXCEPT
      : CommandBufferAllocateInfo( *reinterpret_cast<CommandBufferAllocateInfo const *>( &rhs ) )
    {
    }

    CommandBufferAllocateInfo & operator=( CommandBufferAllocateInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    CommandBufferAllocateInfo & operator=( VkCommandBufferAllocateInfo const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<CommandBufferAllocateInfo const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 CommandBufferAllocateInfo & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CommandBufferAllocateInfo & setCommandPool( CommandPool commandPool_ ) VULKAN_HPP_NOEXCEPT
    {
      commandPool = commandPool_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CommandBufferAllocateInfo & setLevel( CommandBufferLevel level_ ) VULKAN_HPP_NOEXCEPT
    {
      level = level_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CommandBufferAllocateInfo & setCommandBufferCount( uint32_t commandBufferCount_ ) VULKAN_HPP_NOEXCEPT
    {
      commandBufferCount = commandBufferCount_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_SETTERS*/

    operator VkCommandBufferAllocateInfo const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkCommandBufferAllocateInfo *>( this );
    }

    operator VkCommandBufferAllocateInfo &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkCommandBufferAllocateInfo *>( this );
    }

    operator VkCommandBufferAllocateInfo const *() const VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<const VkCommandBufferAllocateInfo *>( this );
    }

    operator VkCommandBufferAllocateInfo *() VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<VkCommandBufferAllocateInfo *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<StructureType const &, const void * const &, CommandPool const &, CommandBufferLevel const &, uint32_t const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, commandPool, level, commandBufferCount );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( CommandBufferAllocateInfo const & ) const = default;
#else
    bool operator==( CommandBufferAllocateInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( commandPool == rhs.commandPool ) && ( level == rhs.level ) &&
             ( commandBufferCount == rhs.commandBufferCount );
#  endif
    }

    bool operator!=( CommandBufferAllocateInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    StructureType      sType              = StructureType::eCommandBufferAllocateInfo;
    const void *       pNext              = {};
    CommandPool        commandPool        = {};
    CommandBufferLevel level              = CommandBufferLevel::ePrimary;
    uint32_t           commandBufferCount = {};
  };

  template <>
  struct CppType<StructureType, StructureType::eCommandBufferAllocateInfo>
  {
    using Type = CommandBufferAllocateInfo;
  };

  // wrapper struct for struct VkCommandBufferInheritanceInfo, see https://registry.khronos.org/vulkan/specs/latest/man/html/VkCommandBufferInheritanceInfo.html
  struct CommandBufferInheritanceInfo
  {
    using NativeType = VkCommandBufferInheritanceInfo;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eCommandBufferInheritanceInfo;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR CommandBufferInheritanceInfo( RenderPass                  renderPass_           = {},
                                                       uint32_t                    subpass_              = {},
                                                       Framebuffer                 framebuffer_          = {},
                                                       Bool32                      occlusionQueryEnable_ = {},
                                                       QueryControlFlags           queryFlags_           = {},
                                                       QueryPipelineStatisticFlags pipelineStatistics_   = {},
                                                       const void *                pNext_                = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , renderPass{ renderPass_ }
      , subpass{ subpass_ }
      , framebuffer{ framebuffer_ }
      , occlusionQueryEnable{ occlusionQueryEnable_ }
      , queryFlags{ queryFlags_ }
      , pipelineStatistics{ pipelineStatistics_ }
    {
    }

    VULKAN_HPP_CONSTEXPR CommandBufferInheritanceInfo( CommandBufferInheritanceInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    CommandBufferInheritanceInfo( VkCommandBufferInheritanceInfo const & rhs ) VULKAN_HPP_NOEXCEPT
      : CommandBufferInheritanceInfo( *reinterpret_cast<CommandBufferInheritanceInfo const *>( &rhs ) )
    {
    }

    CommandBufferInheritanceInfo & operator=( CommandBufferInheritanceInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    CommandBufferInheritanceInfo & operator=( VkCommandBufferInheritanceInfo const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<CommandBufferInheritanceInfo const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 CommandBufferInheritanceInfo & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CommandBufferInheritanceInfo & setRenderPass( RenderPass renderPass_ ) VULKAN_HPP_NOEXCEPT
    {
      renderPass = renderPass_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CommandBufferInheritanceInfo & setSubpass( uint32_t subpass_ ) VULKAN_HPP_NOEXCEPT
    {
      subpass = subpass_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CommandBufferInheritanceInfo & setFramebuffer( Framebuffer framebuffer_ ) VULKAN_HPP_NOEXCEPT
    {
      framebuffer = framebuffer_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CommandBufferInheritanceInfo & setOcclusionQueryEnable( Bool32 occlusionQueryEnable_ ) VULKAN_HPP_NOEXCEPT
    {
      occlusionQueryEnable = occlusionQueryEnable_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CommandBufferInheritanceInfo & setQueryFlags( QueryControlFlags queryFlags_ ) VULKAN_HPP_NOEXCEPT
    {
      queryFlags = queryFlags_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CommandBufferInheritanceInfo & setPipelineStatistics( QueryPipelineStatisticFlags pipelineStatistics_ ) VULKAN_HPP_NOEXCEPT
    {
      pipelineStatistics = pipelineStatistics_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_SETTERS*/

    operator VkCommandBufferInheritanceInfo const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkCommandBufferInheritanceInfo *>( this );
    }

    operator VkCommandBufferInheritanceInfo &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkCommandBufferInheritanceInfo *>( this );
    }

    operator VkCommandBufferInheritanceInfo const *() const VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<const VkCommandBufferInheritanceInfo *>( this );
    }

    operator VkCommandBufferInheritanceInfo *() VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<VkCommandBufferInheritanceInfo *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<StructureType const &,
               const void * const &,
               RenderPass const &,
               uint32_t const &,
               Framebuffer const &,
               Bool32 const &,
               QueryControlFlags const &,
               QueryPipelineStatisticFlags const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, renderPass, subpass, framebuffer, occlusionQueryEnable, queryFlags, pipelineStatistics );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( CommandBufferInheritanceInfo const & ) const = default;
#else
    bool operator==( CommandBufferInheritanceInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( renderPass == rhs.renderPass ) && ( subpass == rhs.subpass ) &&
             ( framebuffer == rhs.framebuffer ) && ( occlusionQueryEnable == rhs.occlusionQueryEnable ) && ( queryFlags == rhs.queryFlags ) &&
             ( pipelineStatistics == rhs.pipelineStatistics );
#  endif
    }

    bool operator!=( CommandBufferInheritanceInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    StructureType               sType                = StructureType::eCommandBufferInheritanceInfo;
    const void *                pNext                = {};
    RenderPass                  renderPass           = {};
    uint32_t                    subpass              = {};
    Framebuffer                 framebuffer          = {};
    Bool32                      occlusionQueryEnable = {};
    QueryControlFlags           queryFlags           = {};
    QueryPipelineStatisticFlags pipelineStatistics   = {};
  };

  template <>
  struct CppType<StructureType, StructureType::eCommandBufferInheritanceInfo>
  {
    using Type = CommandBufferInheritanceInfo;
  };

  // wrapper struct for struct VkCommandBufferBeginInfo, see https://registry.khronos.org/vulkan/specs/latest/man/html/VkCommandBufferBeginInfo.html
  struct CommandBufferBeginInfo
  {
    using NativeType = VkCommandBufferBeginInfo;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eCommandBufferBeginInfo;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR CommandBufferBeginInfo( CommandBufferUsageFlags              flags_            = {},
                                                 const CommandBufferInheritanceInfo * pInheritanceInfo_ = {},
                                                 const void *                         pNext_            = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , flags{ flags_ }
      , pInheritanceInfo{ pInheritanceInfo_ }
    {
    }

    VULKAN_HPP_CONSTEXPR CommandBufferBeginInfo( CommandBufferBeginInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    CommandBufferBeginInfo( VkCommandBufferBeginInfo const & rhs ) VULKAN_HPP_NOEXCEPT
      : CommandBufferBeginInfo( *reinterpret_cast<CommandBufferBeginInfo const *>( &rhs ) )
    {
    }

    CommandBufferBeginInfo & operator=( CommandBufferBeginInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    CommandBufferBeginInfo & operator=( VkCommandBufferBeginInfo const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<CommandBufferBeginInfo const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 CommandBufferBeginInfo & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CommandBufferBeginInfo & setFlags( CommandBufferUsageFlags flags_ ) VULKAN_HPP_NOEXCEPT
    {
      flags = flags_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CommandBufferBeginInfo & setPInheritanceInfo( const CommandBufferInheritanceInfo * pInheritanceInfo_ ) VULKAN_HPP_NOEXCEPT
    {
      pInheritanceInfo = pInheritanceInfo_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_SETTERS*/

    operator VkCommandBufferBeginInfo const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkCommandBufferBeginInfo *>( this );
    }

    operator VkCommandBufferBeginInfo &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkCommandBufferBeginInfo *>( this );
    }

    operator VkCommandBufferBeginInfo const *() const VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<const VkCommandBufferBeginInfo *>( this );
    }

    operator VkCommandBufferBeginInfo *() VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<VkCommandBufferBeginInfo *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<StructureType const &, const void * const &, CommandBufferUsageFlags const &, const CommandBufferInheritanceInfo * const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, flags, pInheritanceInfo );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( CommandBufferBeginInfo const & ) const = default;
#else
    bool operator==( CommandBufferBeginInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( flags == rhs.flags ) && ( pInheritanceInfo == rhs.pInheritanceInfo );
#  endif
    }

    bool operator!=( CommandBufferBeginInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    StructureType                        sType            = StructureType::eCommandBufferBeginInfo;
    const void *                         pNext            = {};
    CommandBufferUsageFlags              flags            = {};
    const CommandBufferInheritanceInfo * pInheritanceInfo = {};
  };

  template <>
  struct CppType<StructureType, StructureType::eCommandBufferBeginInfo>
  {
    using Type = CommandBufferBeginInfo;
  };

  // wrapper struct for struct VkCommandBufferInheritanceConditionalRenderingInfoEXT, see
  // https://registry.khronos.org/vulkan/specs/latest/man/html/VkCommandBufferInheritanceConditionalRenderingInfoEXT.html
  struct CommandBufferInheritanceConditionalRenderingInfoEXT
  {
    using NativeType = VkCommandBufferInheritanceConditionalRenderingInfoEXT;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eCommandBufferInheritanceConditionalRenderingInfoEXT;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR CommandBufferInheritanceConditionalRenderingInfoEXT( Bool32       conditionalRenderingEnable_ = {},
                                                                              const void * pNext_                      = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , conditionalRenderingEnable{ conditionalRenderingEnable_ }
    {
    }

    VULKAN_HPP_CONSTEXPR
      CommandBufferInheritanceConditionalRenderingInfoEXT( CommandBufferInheritanceConditionalRenderingInfoEXT const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    CommandBufferInheritanceConditionalRenderingInfoEXT( VkCommandBufferInheritanceConditionalRenderingInfoEXT const & rhs ) VULKAN_HPP_NOEXCEPT
      : CommandBufferInheritanceConditionalRenderingInfoEXT( *reinterpret_cast<CommandBufferInheritanceConditionalRenderingInfoEXT const *>( &rhs ) )
    {
    }

    CommandBufferInheritanceConditionalRenderingInfoEXT &
      operator=( CommandBufferInheritanceConditionalRenderingInfoEXT const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    CommandBufferInheritanceConditionalRenderingInfoEXT & operator=( VkCommandBufferInheritanceConditionalRenderingInfoEXT const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<CommandBufferInheritanceConditionalRenderingInfoEXT const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 CommandBufferInheritanceConditionalRenderingInfoEXT & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CommandBufferInheritanceConditionalRenderingInfoEXT &
      setConditionalRenderingEnable( Bool32 conditionalRenderingEnable_ ) VULKAN_HPP_NOEXCEPT
    {
      conditionalRenderingEnable = conditionalRenderingEnable_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_SETTERS*/

    operator VkCommandBufferInheritanceConditionalRenderingInfoEXT const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkCommandBufferInheritanceConditionalRenderingInfoEXT *>( this );
    }

    operator VkCommandBufferInheritanceConditionalRenderingInfoEXT &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkCommandBufferInheritanceConditionalRenderingInfoEXT *>( this );
    }

    operator VkCommandBufferInheritanceConditionalRenderingInfoEXT const *() const VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<const VkCommandBufferInheritanceConditionalRenderingInfoEXT *>( this );
    }

    operator VkCommandBufferInheritanceConditionalRenderingInfoEXT *() VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<VkCommandBufferInheritanceConditionalRenderingInfoEXT *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<StructureType const &, const void * const &, Bool32 const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, conditionalRenderingEnable );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( CommandBufferInheritanceConditionalRenderingInfoEXT const & ) const = default;
#else
    bool operator==( CommandBufferInheritanceConditionalRenderingInfoEXT const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( conditionalRenderingEnable == rhs.conditionalRenderingEnable );
#  endif
    }

    bool operator!=( CommandBufferInheritanceConditionalRenderingInfoEXT const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    StructureType sType                      = StructureType::eCommandBufferInheritanceConditionalRenderingInfoEXT;
    const void *  pNext                      = {};
    Bool32        conditionalRenderingEnable = {};
  };

  template <>
  struct CppType<StructureType, StructureType::eCommandBufferInheritanceConditionalRenderingInfoEXT>
  {
    using Type = CommandBufferInheritanceConditionalRenderingInfoEXT;
  };

  // wrapper struct for struct VkCommandBufferInheritanceRenderPassTransformInfoQCOM, see
  // https://registry.khronos.org/vulkan/specs/latest/man/html/VkCommandBufferInheritanceRenderPassTransformInfoQCOM.html
  struct CommandBufferInheritanceRenderPassTransformInfoQCOM
  {
    using NativeType = VkCommandBufferInheritanceRenderPassTransformInfoQCOM;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eCommandBufferInheritanceRenderPassTransformInfoQCOM;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR CommandBufferInheritanceRenderPassTransformInfoQCOM( SurfaceTransformFlagBitsKHR transform_  = SurfaceTransformFlagBitsKHR::eIdentity,
                                                                              Rect2D                      renderArea_ = {},
                                                                              const void *                pNext_      = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , transform{ transform_ }
      , renderArea{ renderArea_ }
    {
    }

    VULKAN_HPP_CONSTEXPR
      CommandBufferInheritanceRenderPassTransformInfoQCOM( CommandBufferInheritanceRenderPassTransformInfoQCOM const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    CommandBufferInheritanceRenderPassTransformInfoQCOM( VkCommandBufferInheritanceRenderPassTransformInfoQCOM const & rhs ) VULKAN_HPP_NOEXCEPT
      : CommandBufferInheritanceRenderPassTransformInfoQCOM( *reinterpret_cast<CommandBufferInheritanceRenderPassTransformInfoQCOM const *>( &rhs ) )
    {
    }

    CommandBufferInheritanceRenderPassTransformInfoQCOM &
      operator=( CommandBufferInheritanceRenderPassTransformInfoQCOM const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    CommandBufferInheritanceRenderPassTransformInfoQCOM & operator=( VkCommandBufferInheritanceRenderPassTransformInfoQCOM const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<CommandBufferInheritanceRenderPassTransformInfoQCOM const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 CommandBufferInheritanceRenderPassTransformInfoQCOM & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CommandBufferInheritanceRenderPassTransformInfoQCOM & setTransform( SurfaceTransformFlagBitsKHR transform_ ) VULKAN_HPP_NOEXCEPT
    {
      transform = transform_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CommandBufferInheritanceRenderPassTransformInfoQCOM & setRenderArea( Rect2D const & renderArea_ ) VULKAN_HPP_NOEXCEPT
    {
      renderArea = renderArea_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_SETTERS*/

    operator VkCommandBufferInheritanceRenderPassTransformInfoQCOM const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkCommandBufferInheritanceRenderPassTransformInfoQCOM *>( this );
    }

    operator VkCommandBufferInheritanceRenderPassTransformInfoQCOM &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkCommandBufferInheritanceRenderPassTransformInfoQCOM *>( this );
    }

    operator VkCommandBufferInheritanceRenderPassTransformInfoQCOM const *() const VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<const VkCommandBufferInheritanceRenderPassTransformInfoQCOM *>( this );
    }

    operator VkCommandBufferInheritanceRenderPassTransformInfoQCOM *() VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<VkCommandBufferInheritanceRenderPassTransformInfoQCOM *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<StructureType const &, const void * const &, SurfaceTransformFlagBitsKHR const &, Rect2D const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, transform, renderArea );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( CommandBufferInheritanceRenderPassTransformInfoQCOM const & ) const = default;
#else
    bool operator==( CommandBufferInheritanceRenderPassTransformInfoQCOM const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( transform == rhs.transform ) && ( renderArea == rhs.renderArea );
#  endif
    }

    bool operator!=( CommandBufferInheritanceRenderPassTransformInfoQCOM const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    StructureType               sType      = StructureType::eCommandBufferInheritanceRenderPassTransformInfoQCOM;
    const void *                pNext      = {};
    SurfaceTransformFlagBitsKHR transform  = SurfaceTransformFlagBitsKHR::eIdentity;
    Rect2D                      renderArea = {};
  };

  template <>
  struct CppType<StructureType, StructureType::eCommandBufferInheritanceRenderPassTransformInfoQCOM>
  {
    using Type = CommandBufferInheritanceRenderPassTransformInfoQCOM;
  };

  // wrapper struct for struct VkCommandBufferInheritanceRenderingInfo, see
  // https://registry.khronos.org/vulkan/specs/latest/man/html/VkCommandBufferInheritanceRenderingInfo.html
  struct CommandBufferInheritanceRenderingInfo
  {
    using NativeType = VkCommandBufferInheritanceRenderingInfo;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eCommandBufferInheritanceRenderingInfo;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR CommandBufferInheritanceRenderingInfo( RenderingFlags      flags_                   = {},
                                                                uint32_t            viewMask_                = {},
                                                                uint32_t            colorAttachmentCount_    = {},
                                                                const Format *      pColorAttachmentFormats_ = {},
                                                                Format              depthAttachmentFormat_   = Format::eUndefined,
                                                                Format              stencilAttachmentFormat_ = Format::eUndefined,
                                                                SampleCountFlagBits rasterizationSamples_    = SampleCountFlagBits::e1,
                                                                const void *        pNext_                   = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , flags{ flags_ }
      , viewMask{ viewMask_ }
      , colorAttachmentCount{ colorAttachmentCount_ }
      , pColorAttachmentFormats{ pColorAttachmentFormats_ }
      , depthAttachmentFormat{ depthAttachmentFormat_ }
      , stencilAttachmentFormat{ stencilAttachmentFormat_ }
      , rasterizationSamples{ rasterizationSamples_ }
    {
    }

    VULKAN_HPP_CONSTEXPR CommandBufferInheritanceRenderingInfo( CommandBufferInheritanceRenderingInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    CommandBufferInheritanceRenderingInfo( VkCommandBufferInheritanceRenderingInfo const & rhs ) VULKAN_HPP_NOEXCEPT
      : CommandBufferInheritanceRenderingInfo( *reinterpret_cast<CommandBufferInheritanceRenderingInfo const *>( &rhs ) )
    {
    }

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    CommandBufferInheritanceRenderingInfo( RenderingFlags                                flags_,
                                           uint32_t                                      viewMask_,
                                           ArrayProxyNoTemporaries<const Format> const & colorAttachmentFormats_,
                                           Format                                        depthAttachmentFormat_   = Format::eUndefined,
                                           Format                                        stencilAttachmentFormat_ = Format::eUndefined,
                                           SampleCountFlagBits                           rasterizationSamples_    = SampleCountFlagBits::e1,
                                           const void *                                  pNext_                   = nullptr )
      : pNext( pNext_ )
      , flags( flags_ )
      , viewMask( viewMask_ )
      , colorAttachmentCount( static_cast<uint32_t>( colorAttachmentFormats_.size() ) )
      , pColorAttachmentFormats( colorAttachmentFormats_.data() )
      , depthAttachmentFormat( depthAttachmentFormat_ )
      , stencilAttachmentFormat( stencilAttachmentFormat_ )
      , rasterizationSamples( rasterizationSamples_ )
    {
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/

    CommandBufferInheritanceRenderingInfo & operator=( CommandBufferInheritanceRenderingInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    CommandBufferInheritanceRenderingInfo & operator=( VkCommandBufferInheritanceRenderingInfo const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<CommandBufferInheritanceRenderingInfo const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 CommandBufferInheritanceRenderingInfo & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CommandBufferInheritanceRenderingInfo & setFlags( RenderingFlags flags_ ) VULKAN_HPP_NOEXCEPT
    {
      flags = flags_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CommandBufferInheritanceRenderingInfo & setViewMask( uint32_t viewMask_ ) VULKAN_HPP_NOEXCEPT
    {
      viewMask = viewMask_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CommandBufferInheritanceRenderingInfo & setColorAttachmentCount( uint32_t colorAttachmentCount_ ) VULKAN_HPP_NOEXCEPT
    {
      colorAttachmentCount = colorAttachmentCount_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CommandBufferInheritanceRenderingInfo & setPColorAttachmentFormats( const Format * pColorAttachmentFormats_ ) VULKAN_HPP_NOEXCEPT
    {
      pColorAttachmentFormats = pColorAttachmentFormats_;
      return *this;
    }

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    CommandBufferInheritanceRenderingInfo &
      setColorAttachmentFormats( ArrayProxyNoTemporaries<const Format> const & colorAttachmentFormats_ ) VULKAN_HPP_NOEXCEPT
    {
      colorAttachmentCount    = static_cast<uint32_t>( colorAttachmentFormats_.size() );
      pColorAttachmentFormats = colorAttachmentFormats_.data();
      return *this;
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/

    VULKAN_HPP_CONSTEXPR_14 CommandBufferInheritanceRenderingInfo & setDepthAttachmentFormat( Format depthAttachmentFormat_ ) VULKAN_HPP_NOEXCEPT
    {
      depthAttachmentFormat = depthAttachmentFormat_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CommandBufferInheritanceRenderingInfo & setStencilAttachmentFormat( Format stencilAttachmentFormat_ ) VULKAN_HPP_NOEXCEPT
    {
      stencilAttachmentFormat = stencilAttachmentFormat_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CommandBufferInheritanceRenderingInfo & setRasterizationSamples( SampleCountFlagBits rasterizationSamples_ ) VULKAN_HPP_NOEXCEPT
    {
      rasterizationSamples = rasterizationSamples_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_SETTERS*/

    operator VkCommandBufferInheritanceRenderingInfo const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkCommandBufferInheritanceRenderingInfo *>( this );
    }

    operator VkCommandBufferInheritanceRenderingInfo &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkCommandBufferInheritanceRenderingInfo *>( this );
    }

    operator VkCommandBufferInheritanceRenderingInfo const *() const VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<const VkCommandBufferInheritanceRenderingInfo *>( this );
    }

    operator VkCommandBufferInheritanceRenderingInfo *() VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<VkCommandBufferInheritanceRenderingInfo *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<StructureType const &,
               const void * const &,
               RenderingFlags const &,
               uint32_t const &,
               uint32_t const &,
               const Format * const &,
               Format const &,
               Format const &,
               SampleCountFlagBits const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie(
        sType, pNext, flags, viewMask, colorAttachmentCount, pColorAttachmentFormats, depthAttachmentFormat, stencilAttachmentFormat, rasterizationSamples );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( CommandBufferInheritanceRenderingInfo const & ) const = default;
#else
    bool operator==( CommandBufferInheritanceRenderingInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( flags == rhs.flags ) && ( viewMask == rhs.viewMask ) &&
             ( colorAttachmentCount == rhs.colorAttachmentCount ) && ( pColorAttachmentFormats == rhs.pColorAttachmentFormats ) &&
             ( depthAttachmentFormat == rhs.depthAttachmentFormat ) && ( stencilAttachmentFormat == rhs.stencilAttachmentFormat ) &&
             ( rasterizationSamples == rhs.rasterizationSamples );
#  endif
    }

    bool operator!=( CommandBufferInheritanceRenderingInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    StructureType       sType                   = StructureType::eCommandBufferInheritanceRenderingInfo;
    const void *        pNext                   = {};
    RenderingFlags      flags                   = {};
    uint32_t            viewMask                = {};
    uint32_t            colorAttachmentCount    = {};
    const Format *      pColorAttachmentFormats = {};
    Format              depthAttachmentFormat   = Format::eUndefined;
    Format              stencilAttachmentFormat = Format::eUndefined;
    SampleCountFlagBits rasterizationSamples    = SampleCountFlagBits::e1;
  };

  template <>
  struct CppType<StructureType, StructureType::eCommandBufferInheritanceRenderingInfo>
  {
    using Type = CommandBufferInheritanceRenderingInfo;
  };

  using CommandBufferInheritanceRenderingInfoKHR = CommandBufferInheritanceRenderingInfo;

  // wrapper struct for struct VkViewport, see https://registry.khronos.org/vulkan/specs/latest/man/html/VkViewport.html
  struct Viewport
  {
    using NativeType = VkViewport;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR
      Viewport( float x_ = {}, float y_ = {}, float width_ = {}, float height_ = {}, float minDepth_ = {}, float maxDepth_ = {} ) VULKAN_HPP_NOEXCEPT
      : x{ x_ }
      , y{ y_ }
      , width{ width_ }
      , height{ height_ }
      , minDepth{ minDepth_ }
      , maxDepth{ maxDepth_ }
    {
    }

    VULKAN_HPP_CONSTEXPR Viewport( Viewport const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    Viewport( VkViewport const & rhs ) VULKAN_HPP_NOEXCEPT : Viewport( *reinterpret_cast<Viewport const *>( &rhs ) ) {}

    Viewport & operator=( Viewport const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    Viewport & operator=( VkViewport const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<Viewport const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 Viewport & setX( float x_ ) VULKAN_HPP_NOEXCEPT
    {
      x = x_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 Viewport & setY( float y_ ) VULKAN_HPP_NOEXCEPT
    {
      y = y_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 Viewport & setWidth( float width_ ) VULKAN_HPP_NOEXCEPT
    {
      width = width_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 Viewport & setHeight( float height_ ) VULKAN_HPP_NOEXCEPT
    {
      height = height_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 Viewport & setMinDepth( float minDepth_ ) VULKAN_HPP_NOEXCEPT
    {
      minDepth = minDepth_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 Viewport & setMaxDepth( float maxDepth_ ) VULKAN_HPP_NOEXCEPT
    {
      maxDepth = maxDepth_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_SETTERS*/

    operator VkViewport const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkViewport *>( this );
    }

    operator VkViewport &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkViewport *>( this );
    }

    operator VkViewport const *() const VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<const VkViewport *>( this );
    }

    operator VkViewport *() VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<VkViewport *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<float const &, float const &, float const &, float const &, float const &, float const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( x, y, width, height, minDepth, maxDepth );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( Viewport const & ) const = default;
#else
    bool operator==( Viewport const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( x == rhs.x ) && ( y == rhs.y ) && ( width == rhs.width ) && ( height == rhs.height ) && ( minDepth == rhs.minDepth ) &&
             ( maxDepth == rhs.maxDepth );
#  endif
    }

    bool operator!=( Viewport const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    float x        = {};
    float y        = {};
    float width    = {};
    float height   = {};
    float minDepth = {};
    float maxDepth = {};
  };

  // wrapper struct for struct VkCommandBufferInheritanceViewportScissorInfoNV, see
  // https://registry.khronos.org/vulkan/specs/latest/man/html/VkCommandBufferInheritanceViewportScissorInfoNV.html
  struct CommandBufferInheritanceViewportScissorInfoNV
  {
    using NativeType = VkCommandBufferInheritanceViewportScissorInfoNV;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eCommandBufferInheritanceViewportScissorInfoNV;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR CommandBufferInheritanceViewportScissorInfoNV( Bool32           viewportScissor2D_  = {},
                                                                        uint32_t         viewportDepthCount_ = {},
                                                                        const Viewport * pViewportDepths_    = {},
                                                                        const void *     pNext_              = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , viewportScissor2D{ viewportScissor2D_ }
      , viewportDepthCount{ viewportDepthCount_ }
      , pViewportDepths{ pViewportDepths_ }
    {
    }

    VULKAN_HPP_CONSTEXPR
      CommandBufferInheritanceViewportScissorInfoNV( CommandBufferInheritanceViewportScissorInfoNV const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    CommandBufferInheritanceViewportScissorInfoNV( VkCommandBufferInheritanceViewportScissorInfoNV const & rhs ) VULKAN_HPP_NOEXCEPT
      : CommandBufferInheritanceViewportScissorInfoNV( *reinterpret_cast<CommandBufferInheritanceViewportScissorInfoNV const *>( &rhs ) )
    {
    }

    CommandBufferInheritanceViewportScissorInfoNV & operator=( CommandBufferInheritanceViewportScissorInfoNV const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    CommandBufferInheritanceViewportScissorInfoNV & operator=( VkCommandBufferInheritanceViewportScissorInfoNV const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<CommandBufferInheritanceViewportScissorInfoNV const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 CommandBufferInheritanceViewportScissorInfoNV & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CommandBufferInheritanceViewportScissorInfoNV & setViewportScissor2D( Bool32 viewportScissor2D_ ) VULKAN_HPP_NOEXCEPT
    {
      viewportScissor2D = viewportScissor2D_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CommandBufferInheritanceViewportScissorInfoNV & setViewportDepthCount( uint32_t viewportDepthCount_ ) VULKAN_HPP_NOEXCEPT
    {
      viewportDepthCount = viewportDepthCount_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CommandBufferInheritanceViewportScissorInfoNV & setPViewportDepths( const Viewport * pViewportDepths_ ) VULKAN_HPP_NOEXCEPT
    {
      pViewportDepths = pViewportDepths_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_SETTERS*/

    operator VkCommandBufferInheritanceViewportScissorInfoNV const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkCommandBufferInheritanceViewportScissorInfoNV *>( this );
    }

    operator VkCommandBufferInheritanceViewportScissorInfoNV &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkCommandBufferInheritanceViewportScissorInfoNV *>( this );
    }

    operator VkCommandBufferInheritanceViewportScissorInfoNV const *() const VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<const VkCommandBufferInheritanceViewportScissorInfoNV *>( this );
    }

    operator VkCommandBufferInheritanceViewportScissorInfoNV *() VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<VkCommandBufferInheritanceViewportScissorInfoNV *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<StructureType const &, const void * const &, Bool32 const &, uint32_t const &, const Viewport * const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, viewportScissor2D, viewportDepthCount, pViewportDepths );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( CommandBufferInheritanceViewportScissorInfoNV const & ) const = default;
#else
    bool operator==( CommandBufferInheritanceViewportScissorInfoNV const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( viewportScissor2D == rhs.viewportScissor2D ) &&
             ( viewportDepthCount == rhs.viewportDepthCount ) && ( pViewportDepths == rhs.pViewportDepths );
#  endif
    }

    bool operator!=( CommandBufferInheritanceViewportScissorInfoNV const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    StructureType    sType              = StructureType::eCommandBufferInheritanceViewportScissorInfoNV;
    const void *     pNext              = {};
    Bool32           viewportScissor2D  = {};
    uint32_t         viewportDepthCount = {};
    const Viewport * pViewportDepths    = {};
  };

  template <>
  struct CppType<StructureType, StructureType::eCommandBufferInheritanceViewportScissorInfoNV>
  {
    using Type = CommandBufferInheritanceViewportScissorInfoNV;
  };

  // wrapper struct for struct VkCommandBufferSubmitInfo, see https://registry.khronos.org/vulkan/specs/latest/man/html/VkCommandBufferSubmitInfo.html
  struct CommandBufferSubmitInfo
  {
    using NativeType = VkCommandBufferSubmitInfo;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eCommandBufferSubmitInfo;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR
      CommandBufferSubmitInfo( CommandBuffer commandBuffer_ = {}, uint32_t deviceMask_ = {}, const void * pNext_ = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , commandBuffer{ commandBuffer_ }
      , deviceMask{ deviceMask_ }
    {
    }

    VULKAN_HPP_CONSTEXPR CommandBufferSubmitInfo( CommandBufferSubmitInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    CommandBufferSubmitInfo( VkCommandBufferSubmitInfo const & rhs ) VULKAN_HPP_NOEXCEPT
      : CommandBufferSubmitInfo( *reinterpret_cast<CommandBufferSubmitInfo const *>( &rhs ) )
    {
    }

    CommandBufferSubmitInfo & operator=( CommandBufferSubmitInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    CommandBufferSubmitInfo & operator=( VkCommandBufferSubmitInfo const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<CommandBufferSubmitInfo const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 CommandBufferSubmitInfo & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CommandBufferSubmitInfo & setCommandBuffer( CommandBuffer commandBuffer_ ) VULKAN_HPP_NOEXCEPT
    {
      commandBuffer = commandBuffer_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CommandBufferSubmitInfo & setDeviceMask( uint32_t deviceMask_ ) VULKAN_HPP_NOEXCEPT
    {
      deviceMask = deviceMask_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_SETTERS*/

    operator VkCommandBufferSubmitInfo const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkCommandBufferSubmitInfo *>( this );
    }

    operator VkCommandBufferSubmitInfo &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkCommandBufferSubmitInfo *>( this );
    }

    operator VkCommandBufferSubmitInfo const *() const VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<const VkCommandBufferSubmitInfo *>( this );
    }

    operator VkCommandBufferSubmitInfo *() VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<VkCommandBufferSubmitInfo *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<StructureType const &, const void * const &, CommandBuffer const &, uint32_t const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, commandBuffer, deviceMask );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( CommandBufferSubmitInfo const & ) const = default;
#else
    bool operator==( CommandBufferSubmitInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( commandBuffer == rhs.commandBuffer ) && ( deviceMask == rhs.deviceMask );
#  endif
    }

    bool operator!=( CommandBufferSubmitInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    StructureType sType         = StructureType::eCommandBufferSubmitInfo;
    const void *  pNext         = {};
    CommandBuffer commandBuffer = {};
    uint32_t      deviceMask    = {};
  };

  template <>
  struct CppType<StructureType, StructureType::eCommandBufferSubmitInfo>
  {
    using Type = CommandBufferSubmitInfo;
  };

  using CommandBufferSubmitInfoKHR = CommandBufferSubmitInfo;

  // wrapper struct for struct VkCommandPoolCreateInfo, see https://registry.khronos.org/vulkan/specs/latest/man/html/VkCommandPoolCreateInfo.html
  struct CommandPoolCreateInfo
  {
    using NativeType = VkCommandPoolCreateInfo;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eCommandPoolCreateInfo;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR
      CommandPoolCreateInfo( CommandPoolCreateFlags flags_ = {}, uint32_t queueFamilyIndex_ = {}, const void * pNext_ = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , flags{ flags_ }
      , queueFamilyIndex{ queueFamilyIndex_ }
    {
    }

    VULKAN_HPP_CONSTEXPR CommandPoolCreateInfo( CommandPoolCreateInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    CommandPoolCreateInfo( VkCommandPoolCreateInfo const & rhs ) VULKAN_HPP_NOEXCEPT
      : CommandPoolCreateInfo( *reinterpret_cast<CommandPoolCreateInfo const *>( &rhs ) )
    {
    }

    CommandPoolCreateInfo & operator=( CommandPoolCreateInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    CommandPoolCreateInfo & operator=( VkCommandPoolCreateInfo const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<CommandPoolCreateInfo const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 CommandPoolCreateInfo & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CommandPoolCreateInfo & setFlags( CommandPoolCreateFlags flags_ ) VULKAN_HPP_NOEXCEPT
    {
      flags = flags_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CommandPoolCreateInfo & setQueueFamilyIndex( uint32_t queueFamilyIndex_ ) VULKAN_HPP_NOEXCEPT
    {
      queueFamilyIndex = queueFamilyIndex_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_SETTERS*/

    operator VkCommandPoolCreateInfo const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkCommandPoolCreateInfo *>( this );
    }

    operator VkCommandPoolCreateInfo &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkCommandPoolCreateInfo *>( this );
    }

    operator VkCommandPoolCreateInfo const *() const VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<const VkCommandPoolCreateInfo *>( this );
    }

    operator VkCommandPoolCreateInfo *() VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<VkCommandPoolCreateInfo *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<StructureType const &, const void * const &, CommandPoolCreateFlags const &, uint32_t const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, flags, queueFamilyIndex );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( CommandPoolCreateInfo const & ) const = default;
#else
    bool operator==( CommandPoolCreateInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( flags == rhs.flags ) && ( queueFamilyIndex == rhs.queueFamilyIndex );
#  endif
    }

    bool operator!=( CommandPoolCreateInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    StructureType          sType            = StructureType::eCommandPoolCreateInfo;
    const void *           pNext            = {};
    CommandPoolCreateFlags flags            = {};
    uint32_t               queueFamilyIndex = {};
  };

  template <>
  struct CppType<StructureType, StructureType::eCommandPoolCreateInfo>
  {
    using Type = CommandPoolCreateInfo;
  };

  // wrapper struct for struct VkSpecializationMapEntry, see https://registry.khronos.org/vulkan/specs/latest/man/html/VkSpecializationMapEntry.html
  struct SpecializationMapEntry
  {
    using NativeType = VkSpecializationMapEntry;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR SpecializationMapEntry( uint32_t constantID_ = {}, uint32_t offset_ = {}, size_t size_ = {} ) VULKAN_HPP_NOEXCEPT
      : constantID{ constantID_ }
      , offset{ offset_ }
      , size{ size_ }
    {
    }

    VULKAN_HPP_CONSTEXPR SpecializationMapEntry( SpecializationMapEntry const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    SpecializationMapEntry( VkSpecializationMapEntry const & rhs ) VULKAN_HPP_NOEXCEPT
      : SpecializationMapEntry( *reinterpret_cast<SpecializationMapEntry const *>( &rhs ) )
    {
    }

    SpecializationMapEntry & operator=( SpecializationMapEntry const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    SpecializationMapEntry & operator=( VkSpecializationMapEntry const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<SpecializationMapEntry const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 SpecializationMapEntry & setConstantID( uint32_t constantID_ ) VULKAN_HPP_NOEXCEPT
    {
      constantID = constantID_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 SpecializationMapEntry & setOffset( uint32_t offset_ ) VULKAN_HPP_NOEXCEPT
    {
      offset = offset_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 SpecializationMapEntry & setSize( size_t size_ ) VULKAN_HPP_NOEXCEPT
    {
      size = size_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_SETTERS*/

    operator VkSpecializationMapEntry const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkSpecializationMapEntry *>( this );
    }

    operator VkSpecializationMapEntry &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkSpecializationMapEntry *>( this );
    }

    operator VkSpecializationMapEntry const *() const VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<const VkSpecializationMapEntry *>( this );
    }

    operator VkSpecializationMapEntry *() VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<VkSpecializationMapEntry *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<uint32_t const &, uint32_t const &, size_t const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( constantID, offset, size );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( SpecializationMapEntry const & ) const = default;
#else
    bool operator==( SpecializationMapEntry const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( constantID == rhs.constantID ) && ( offset == rhs.offset ) && ( size == rhs.size );
#  endif
    }

    bool operator!=( SpecializationMapEntry const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    uint32_t constantID = {};
    uint32_t offset     = {};
    size_t   size       = {};
  };

  // wrapper struct for struct VkSpecializationInfo, see https://registry.khronos.org/vulkan/specs/latest/man/html/VkSpecializationInfo.html
  struct SpecializationInfo
  {
    using NativeType = VkSpecializationInfo;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR SpecializationInfo( uint32_t                       mapEntryCount_ = {},
                                             const SpecializationMapEntry * pMapEntries_   = {},
                                             size_t                         dataSize_      = {},
                                             const void *                   pData_         = {} ) VULKAN_HPP_NOEXCEPT
      : mapEntryCount{ mapEntryCount_ }
      , pMapEntries{ pMapEntries_ }
      , dataSize{ dataSize_ }
      , pData{ pData_ }
    {
    }

    VULKAN_HPP_CONSTEXPR SpecializationInfo( SpecializationInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    SpecializationInfo( VkSpecializationInfo const & rhs ) VULKAN_HPP_NOEXCEPT : SpecializationInfo( *reinterpret_cast<SpecializationInfo const *>( &rhs ) ) {}

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    template <typename T>
    SpecializationInfo( ArrayProxyNoTemporaries<const SpecializationMapEntry> const & mapEntries_, ArrayProxyNoTemporaries<const T> const & data_ = {} )
      : mapEntryCount( static_cast<uint32_t>( mapEntries_.size() ) )
      , pMapEntries( mapEntries_.data() )
      , dataSize( data_.size() * sizeof( T ) )
      , pData( data_.data() )
    {
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/

    SpecializationInfo & operator=( SpecializationInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    SpecializationInfo & operator=( VkSpecializationInfo const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<SpecializationInfo const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 SpecializationInfo & setMapEntryCount( uint32_t mapEntryCount_ ) VULKAN_HPP_NOEXCEPT
    {
      mapEntryCount = mapEntryCount_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 SpecializationInfo & setPMapEntries( const SpecializationMapEntry * pMapEntries_ ) VULKAN_HPP_NOEXCEPT
    {
      pMapEntries = pMapEntries_;
      return *this;
    }

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    SpecializationInfo & setMapEntries( ArrayProxyNoTemporaries<const SpecializationMapEntry> const & mapEntries_ ) VULKAN_HPP_NOEXCEPT
    {
      mapEntryCount = static_cast<uint32_t>( mapEntries_.size() );
      pMapEntries   = mapEntries_.data();
      return *this;
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/

    VULKAN_HPP_CONSTEXPR_14 SpecializationInfo & setDataSize( size_t dataSize_ ) VULKAN_HPP_NOEXCEPT
    {
      dataSize = dataSize_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 SpecializationInfo & setPData( const void * pData_ ) VULKAN_HPP_NOEXCEPT
    {
      pData = pData_;
      return *this;
    }

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    template <typename T>
    SpecializationInfo & setData( ArrayProxyNoTemporaries<const T> const & data_ ) VULKAN_HPP_NOEXCEPT
    {
      dataSize = data_.size() * sizeof( T );
      pData    = data_.data();
      return *this;
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/
#endif   /*VULKAN_HPP_NO_SETTERS*/

    operator VkSpecializationInfo const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkSpecializationInfo *>( this );
    }

    operator VkSpecializationInfo &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkSpecializationInfo *>( this );
    }

    operator VkSpecializationInfo const *() const VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<const VkSpecializationInfo *>( this );
    }

    operator VkSpecializationInfo *() VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<VkSpecializationInfo *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<uint32_t const &, const SpecializationMapEntry * const &, size_t const &, const void * const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( mapEntryCount, pMapEntries, dataSize, pData );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( SpecializationInfo const & ) const = default;
#else
    bool operator==( SpecializationInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( mapEntryCount == rhs.mapEntryCount ) && ( pMapEntries == rhs.pMapEntries ) && ( dataSize == rhs.dataSize ) && ( pData == rhs.pData );
#  endif
    }

    bool operator!=( SpecializationInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    uint32_t                       mapEntryCount = {};
    const SpecializationMapEntry * pMapEntries   = {};
    size_t                         dataSize      = {};
    const void *                   pData         = {};
  };

  // wrapper struct for struct VkPipelineShaderStageCreateInfo, see
  // https://registry.khronos.org/vulkan/specs/latest/man/html/VkPipelineShaderStageCreateInfo.html
  struct PipelineShaderStageCreateInfo
  {
    using NativeType = VkPipelineShaderStageCreateInfo;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::ePipelineShaderStageCreateInfo;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR PipelineShaderStageCreateInfo( PipelineShaderStageCreateFlags flags_               = {},
                                                        ShaderStageFlagBits            stage_               = ShaderStageFlagBits::eVertex,
                                                        ShaderModule                   module_              = {},
                                                        const char *                   pName_               = {},
                                                        const SpecializationInfo *     pSpecializationInfo_ = {},
                                                        const void *                   pNext_               = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , flags{ flags_ }
      , stage{ stage_ }
      , module{ module_ }
      , pName{ pName_ }
      , pSpecializationInfo{ pSpecializationInfo_ }
    {
    }

    VULKAN_HPP_CONSTEXPR PipelineShaderStageCreateInfo( PipelineShaderStageCreateInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    PipelineShaderStageCreateInfo( VkPipelineShaderStageCreateInfo const & rhs ) VULKAN_HPP_NOEXCEPT
      : PipelineShaderStageCreateInfo( *reinterpret_cast<PipelineShaderStageCreateInfo const *>( &rhs ) )
    {
    }

    PipelineShaderStageCreateInfo & operator=( PipelineShaderStageCreateInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    PipelineShaderStageCreateInfo & operator=( VkPipelineShaderStageCreateInfo const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<PipelineShaderStageCreateInfo const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 PipelineShaderStageCreateInfo & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 PipelineShaderStageCreateInfo & setFlags( PipelineShaderStageCreateFlags flags_ ) VULKAN_HPP_NOEXCEPT
    {
      flags = flags_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 PipelineShaderStageCreateInfo & setStage( ShaderStageFlagBits stage_ ) VULKAN_HPP_NOEXCEPT
    {
      stage = stage_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 PipelineShaderStageCreateInfo & setModule( ShaderModule module_ ) VULKAN_HPP_NOEXCEPT
    {
      module = module_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 PipelineShaderStageCreateInfo & setPName( const char * pName_ ) VULKAN_HPP_NOEXCEPT
    {
      pName = pName_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 PipelineShaderStageCreateInfo & setPSpecializationInfo( const SpecializationInfo * pSpecializationInfo_ ) VULKAN_HPP_NOEXCEPT
    {
      pSpecializationInfo = pSpecializationInfo_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_SETTERS*/

    operator VkPipelineShaderStageCreateInfo const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkPipelineShaderStageCreateInfo *>( this );
    }

    operator VkPipelineShaderStageCreateInfo &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkPipelineShaderStageCreateInfo *>( this );
    }

    operator VkPipelineShaderStageCreateInfo const *() const VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<const VkPipelineShaderStageCreateInfo *>( this );
    }

    operator VkPipelineShaderStageCreateInfo *() VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<VkPipelineShaderStageCreateInfo *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<StructureType const &,
               const void * const &,
               PipelineShaderStageCreateFlags const &,
               ShaderStageFlagBits const &,
               ShaderModule const &,
               const char * const &,
               const SpecializationInfo * const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, flags, stage, module, pName, pSpecializationInfo );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    std::strong_ordering operator<=>( PipelineShaderStageCreateInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      if ( auto cmp = sType <=> rhs.sType; cmp != 0 )
        return cmp;
      if ( auto cmp = pNext <=> rhs.pNext; cmp != 0 )
        return cmp;
      if ( auto cmp = flags <=> rhs.flags; cmp != 0 )
        return cmp;
      if ( auto cmp = stage <=> rhs.stage; cmp != 0 )
        return cmp;
      if ( auto cmp = module <=> rhs.module; cmp != 0 )
        return cmp;
      if ( pName != rhs.pName )
        if ( auto cmp = strcmp( pName, rhs.pName ); cmp != 0 )
          return ( cmp < 0 ) ? std::strong_ordering::less : std::strong_ordering::greater;
      if ( auto cmp = pSpecializationInfo <=> rhs.pSpecializationInfo; cmp != 0 )
        return cmp;

      return std::strong_ordering::equivalent;
    }
#endif

    bool operator==( PipelineShaderStageCreateInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( flags == rhs.flags ) && ( stage == rhs.stage ) && ( module == rhs.module ) &&
             ( ( pName == rhs.pName ) || ( strcmp( pName, rhs.pName ) == 0 ) ) && ( pSpecializationInfo == rhs.pSpecializationInfo );
    }

    bool operator!=( PipelineShaderStageCreateInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }

  public:
    StructureType                  sType               = StructureType::ePipelineShaderStageCreateInfo;
    const void *                   pNext               = {};
    PipelineShaderStageCreateFlags flags               = {};
    ShaderStageFlagBits            stage               = ShaderStageFlagBits::eVertex;
    ShaderModule                   module              = {};
    const char *                   pName               = {};
    const SpecializationInfo *     pSpecializationInfo = {};
  };

  template <>
  struct CppType<StructureType, StructureType::ePipelineShaderStageCreateInfo>
  {
    using Type = PipelineShaderStageCreateInfo;
  };

  // wrapper struct for struct VkComputePipelineCreateInfo, see https://registry.khronos.org/vulkan/specs/latest/man/html/VkComputePipelineCreateInfo.html
  struct ComputePipelineCreateInfo
  {
    using NativeType = VkComputePipelineCreateInfo;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eComputePipelineCreateInfo;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR ComputePipelineCreateInfo( PipelineCreateFlags           flags_              = {},
                                                    PipelineShaderStageCreateInfo stage_              = {},
                                                    PipelineLayout                layout_             = {},
                                                    Pipeline                      basePipelineHandle_ = {},
                                                    int32_t                       basePipelineIndex_  = {},
                                                    const void *                  pNext_              = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , flags{ flags_ }
      , stage{ stage_ }
      , layout{ layout_ }
      , basePipelineHandle{ basePipelineHandle_ }
      , basePipelineIndex{ basePipelineIndex_ }
    {
    }

    VULKAN_HPP_CONSTEXPR ComputePipelineCreateInfo( ComputePipelineCreateInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    ComputePipelineCreateInfo( VkComputePipelineCreateInfo const & rhs ) VULKAN_HPP_NOEXCEPT
      : ComputePipelineCreateInfo( *reinterpret_cast<ComputePipelineCreateInfo const *>( &rhs ) )
    {
    }

    ComputePipelineCreateInfo & operator=( ComputePipelineCreateInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    ComputePipelineCreateInfo & operator=( VkComputePipelineCreateInfo const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<ComputePipelineCreateInfo const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 ComputePipelineCreateInfo & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ComputePipelineCreateInfo & setFlags( PipelineCreateFlags flags_ ) VULKAN_HPP_NOEXCEPT
    {
      flags = flags_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ComputePipelineCreateInfo & setStage( PipelineShaderStageCreateInfo const & stage_ ) VULKAN_HPP_NOEXCEPT
    {
      stage = stage_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ComputePipelineCreateInfo & setLayout( PipelineLayout layout_ ) VULKAN_HPP_NOEXCEPT
    {
      layout = layout_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ComputePipelineCreateInfo & setBasePipelineHandle( Pipeline basePipelineHandle_ ) VULKAN_HPP_NOEXCEPT
    {
      basePipelineHandle = basePipelineHandle_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ComputePipelineCreateInfo & setBasePipelineIndex( int32_t basePipelineIndex_ ) VULKAN_HPP_NOEXCEPT
    {
      basePipelineIndex = basePipelineIndex_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_SETTERS*/

    operator VkComputePipelineCreateInfo const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkComputePipelineCreateInfo *>( this );
    }

    operator VkComputePipelineCreateInfo &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkComputePipelineCreateInfo *>( this );
    }

    operator VkComputePipelineCreateInfo const *() const VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<const VkComputePipelineCreateInfo *>( this );
    }

    operator VkComputePipelineCreateInfo *() VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<VkComputePipelineCreateInfo *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<StructureType const &,
               const void * const &,
               PipelineCreateFlags const &,
               PipelineShaderStageCreateInfo const &,
               PipelineLayout const &,
               Pipeline const &,
               int32_t const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, flags, stage, layout, basePipelineHandle, basePipelineIndex );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( ComputePipelineCreateInfo const & ) const = default;
#else
    bool operator==( ComputePipelineCreateInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( flags == rhs.flags ) && ( stage == rhs.stage ) && ( layout == rhs.layout ) &&
             ( basePipelineHandle == rhs.basePipelineHandle ) && ( basePipelineIndex == rhs.basePipelineIndex );
#  endif
    }

    bool operator!=( ComputePipelineCreateInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    StructureType                 sType              = StructureType::eComputePipelineCreateInfo;
    const void *                  pNext              = {};
    PipelineCreateFlags           flags              = {};
    PipelineShaderStageCreateInfo stage              = {};
    PipelineLayout                layout             = {};
    Pipeline                      basePipelineHandle = {};
    int32_t                       basePipelineIndex  = {};
  };

  template <>
  struct CppType<StructureType, StructureType::eComputePipelineCreateInfo>
  {
    using Type = ComputePipelineCreateInfo;
  };

  // wrapper struct for struct VkComputePipelineIndirectBufferInfoNV, see
  // https://registry.khronos.org/vulkan/specs/latest/man/html/VkComputePipelineIndirectBufferInfoNV.html
  struct ComputePipelineIndirectBufferInfoNV
  {
    using NativeType = VkComputePipelineIndirectBufferInfoNV;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eComputePipelineIndirectBufferInfoNV;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR ComputePipelineIndirectBufferInfoNV( DeviceAddress deviceAddress_                      = {},
                                                              DeviceSize    size_                               = {},
                                                              DeviceAddress pipelineDeviceAddressCaptureReplay_ = {},
                                                              const void *  pNext_                              = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , deviceAddress{ deviceAddress_ }
      , size{ size_ }
      , pipelineDeviceAddressCaptureReplay{ pipelineDeviceAddressCaptureReplay_ }
    {
    }

    VULKAN_HPP_CONSTEXPR ComputePipelineIndirectBufferInfoNV( ComputePipelineIndirectBufferInfoNV const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    ComputePipelineIndirectBufferInfoNV( VkComputePipelineIndirectBufferInfoNV const & rhs ) VULKAN_HPP_NOEXCEPT
      : ComputePipelineIndirectBufferInfoNV( *reinterpret_cast<ComputePipelineIndirectBufferInfoNV const *>( &rhs ) )
    {
    }

    ComputePipelineIndirectBufferInfoNV & operator=( ComputePipelineIndirectBufferInfoNV const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    ComputePipelineIndirectBufferInfoNV & operator=( VkComputePipelineIndirectBufferInfoNV const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<ComputePipelineIndirectBufferInfoNV const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 ComputePipelineIndirectBufferInfoNV & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ComputePipelineIndirectBufferInfoNV & setDeviceAddress( DeviceAddress deviceAddress_ ) VULKAN_HPP_NOEXCEPT
    {
      deviceAddress = deviceAddress_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ComputePipelineIndirectBufferInfoNV & setSize( DeviceSize size_ ) VULKAN_HPP_NOEXCEPT
    {
      size = size_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ComputePipelineIndirectBufferInfoNV &
      setPipelineDeviceAddressCaptureReplay( DeviceAddress pipelineDeviceAddressCaptureReplay_ ) VULKAN_HPP_NOEXCEPT
    {
      pipelineDeviceAddressCaptureReplay = pipelineDeviceAddressCaptureReplay_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_SETTERS*/

    operator VkComputePipelineIndirectBufferInfoNV const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkComputePipelineIndirectBufferInfoNV *>( this );
    }

    operator VkComputePipelineIndirectBufferInfoNV &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkComputePipelineIndirectBufferInfoNV *>( this );
    }

    operator VkComputePipelineIndirectBufferInfoNV const *() const VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<const VkComputePipelineIndirectBufferInfoNV *>( this );
    }

    operator VkComputePipelineIndirectBufferInfoNV *() VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<VkComputePipelineIndirectBufferInfoNV *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<StructureType const &, const void * const &, DeviceAddress const &, DeviceSize const &, DeviceAddress const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, deviceAddress, size, pipelineDeviceAddressCaptureReplay );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( ComputePipelineIndirectBufferInfoNV const & ) const = default;
#else
    bool operator==( ComputePipelineIndirectBufferInfoNV const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( deviceAddress == rhs.deviceAddress ) && ( size == rhs.size ) &&
             ( pipelineDeviceAddressCaptureReplay == rhs.pipelineDeviceAddressCaptureReplay );
#  endif
    }

    bool operator!=( ComputePipelineIndirectBufferInfoNV const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    StructureType sType                              = StructureType::eComputePipelineIndirectBufferInfoNV;
    const void *  pNext                              = {};
    DeviceAddress deviceAddress                      = {};
    DeviceSize    size                               = {};
    DeviceAddress pipelineDeviceAddressCaptureReplay = {};
  };

  template <>
  struct CppType<StructureType, StructureType::eComputePipelineIndirectBufferInfoNV>
  {
    using Type = ComputePipelineIndirectBufferInfoNV;
  };

  // wrapper struct for struct VkConditionalRenderingBeginInfoEXT, see
  // https://registry.khronos.org/vulkan/specs/latest/man/html/VkConditionalRenderingBeginInfoEXT.html
  struct ConditionalRenderingBeginInfoEXT
  {
    using NativeType = VkConditionalRenderingBeginInfoEXT;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eConditionalRenderingBeginInfoEXT;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR ConditionalRenderingBeginInfoEXT( Buffer                       buffer_ = {},
                                                           DeviceSize                   offset_ = {},
                                                           ConditionalRenderingFlagsEXT flags_  = {},
                                                           const void *                 pNext_  = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , buffer{ buffer_ }
      , offset{ offset_ }
      , flags{ flags_ }
    {
    }

    VULKAN_HPP_CONSTEXPR ConditionalRenderingBeginInfoEXT( ConditionalRenderingBeginInfoEXT const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    ConditionalRenderingBeginInfoEXT( VkConditionalRenderingBeginInfoEXT const & rhs ) VULKAN_HPP_NOEXCEPT
      : ConditionalRenderingBeginInfoEXT( *reinterpret_cast<ConditionalRenderingBeginInfoEXT const *>( &rhs ) )
    {
    }

    ConditionalRenderingBeginInfoEXT & operator=( ConditionalRenderingBeginInfoEXT const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    ConditionalRenderingBeginInfoEXT & operator=( VkConditionalRenderingBeginInfoEXT const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<ConditionalRenderingBeginInfoEXT const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 ConditionalRenderingBeginInfoEXT & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ConditionalRenderingBeginInfoEXT & setBuffer( Buffer buffer_ ) VULKAN_HPP_NOEXCEPT
    {
      buffer = buffer_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ConditionalRenderingBeginInfoEXT & setOffset( DeviceSize offset_ ) VULKAN_HPP_NOEXCEPT
    {
      offset = offset_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ConditionalRenderingBeginInfoEXT & setFlags( ConditionalRenderingFlagsEXT flags_ ) VULKAN_HPP_NOEXCEPT
    {
      flags = flags_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_SETTERS*/

    operator VkConditionalRenderingBeginInfoEXT const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkConditionalRenderingBeginInfoEXT *>( this );
    }

    operator VkConditionalRenderingBeginInfoEXT &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkConditionalRenderingBeginInfoEXT *>( this );
    }

    operator VkConditionalRenderingBeginInfoEXT const *() const VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<const VkConditionalRenderingBeginInfoEXT *>( this );
    }

    operator VkConditionalRenderingBeginInfoEXT *() VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<VkConditionalRenderingBeginInfoEXT *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<StructureType const &, const void * const &, Buffer const &, DeviceSize const &, ConditionalRenderingFlagsEXT const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, buffer, offset, flags );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( ConditionalRenderingBeginInfoEXT const & ) const = default;
#else
    bool operator==( ConditionalRenderingBeginInfoEXT const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( buffer == rhs.buffer ) && ( offset == rhs.offset ) && ( flags == rhs.flags );
#  endif
    }

    bool operator!=( ConditionalRenderingBeginInfoEXT const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    StructureType                sType  = StructureType::eConditionalRenderingBeginInfoEXT;
    const void *                 pNext  = {};
    Buffer                       buffer = {};
    DeviceSize                   offset = {};
    ConditionalRenderingFlagsEXT flags  = {};
  };

  template <>
  struct CppType<StructureType, StructureType::eConditionalRenderingBeginInfoEXT>
  {
    using Type = ConditionalRenderingBeginInfoEXT;
  };

  // wrapper struct for struct VkConformanceVersion, see https://registry.khronos.org/vulkan/specs/latest/man/html/VkConformanceVersion.html
  struct ConformanceVersion
  {
    using NativeType = VkConformanceVersion;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR ConformanceVersion( uint8_t major_ = {}, uint8_t minor_ = {}, uint8_t subminor_ = {}, uint8_t patch_ = {} ) VULKAN_HPP_NOEXCEPT
      : major{ major_ }
      , minor{ minor_ }
      , subminor{ subminor_ }
      , patch{ patch_ }
    {
    }

    VULKAN_HPP_CONSTEXPR ConformanceVersion( ConformanceVersion const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    ConformanceVersion( VkConformanceVersion const & rhs ) VULKAN_HPP_NOEXCEPT : ConformanceVersion( *reinterpret_cast<ConformanceVersion const *>( &rhs ) ) {}

    ConformanceVersion & operator=( ConformanceVersion const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    ConformanceVersion & operator=( VkConformanceVersion const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<ConformanceVersion const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 ConformanceVersion & setMajor( uint8_t major_ ) VULKAN_HPP_NOEXCEPT
    {
      major = major_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ConformanceVersion & setMinor( uint8_t minor_ ) VULKAN_HPP_NOEXCEPT
    {
      minor = minor_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ConformanceVersion & setSubminor( uint8_t subminor_ ) VULKAN_HPP_NOEXCEPT
    {
      subminor = subminor_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ConformanceVersion & setPatch( uint8_t patch_ ) VULKAN_HPP_NOEXCEPT
    {
      patch = patch_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_SETTERS*/

    operator VkConformanceVersion const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkConformanceVersion *>( this );
    }

    operator VkConformanceVersion &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkConformanceVersion *>( this );
    }

    operator VkConformanceVersion const *() const VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<const VkConformanceVersion *>( this );
    }

    operator VkConformanceVersion *() VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<VkConformanceVersion *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<uint8_t const &, uint8_t const &, uint8_t const &, uint8_t const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( major, minor, subminor, patch );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( ConformanceVersion const & ) const = default;
#else
    bool operator==( ConformanceVersion const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( major == rhs.major ) && ( minor == rhs.minor ) && ( subminor == rhs.subminor ) && ( patch == rhs.patch );
#  endif
    }

    bool operator!=( ConformanceVersion const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    uint8_t major    = {};
    uint8_t minor    = {};
    uint8_t subminor = {};
    uint8_t patch    = {};
  };

  using ConformanceVersionKHR = ConformanceVersion;

  // wrapper struct for struct VkConvertCooperativeVectorMatrixInfoNV, see
  // https://registry.khronos.org/vulkan/specs/latest/man/html/VkConvertCooperativeVectorMatrixInfoNV.html
  struct ConvertCooperativeVectorMatrixInfoNV
  {
    using NativeType = VkConvertCooperativeVectorMatrixInfoNV;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eConvertCooperativeVectorMatrixInfoNV;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR_14 ConvertCooperativeVectorMatrixInfoNV( size_t                          srcSize_          = {},
                                                                  DeviceOrHostAddressConstKHR     srcData_          = {},
                                                                  size_t *                        pDstSize_         = {},
                                                                  DeviceOrHostAddressKHR          dstData_          = {},
                                                                  ComponentTypeKHR                srcComponentType_ = ComponentTypeKHR::eFloat16,
                                                                  ComponentTypeKHR                dstComponentType_ = ComponentTypeKHR::eFloat16,
                                                                  uint32_t                        numRows_          = {},
                                                                  uint32_t                        numColumns_       = {},
                                                                  CooperativeVectorMatrixLayoutNV srcLayout_ = CooperativeVectorMatrixLayoutNV::eRowMajor,
                                                                  size_t                          srcStride_ = {},
                                                                  CooperativeVectorMatrixLayoutNV dstLayout_ = CooperativeVectorMatrixLayoutNV::eRowMajor,
                                                                  size_t                          dstStride_ = {},
                                                                  const void *                    pNext_     = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , srcSize{ srcSize_ }
      , srcData{ srcData_ }
      , pDstSize{ pDstSize_ }
      , dstData{ dstData_ }
      , srcComponentType{ srcComponentType_ }
      , dstComponentType{ dstComponentType_ }
      , numRows{ numRows_ }
      , numColumns{ numColumns_ }
      , srcLayout{ srcLayout_ }
      , srcStride{ srcStride_ }
      , dstLayout{ dstLayout_ }
      , dstStride{ dstStride_ }
    {
    }

    VULKAN_HPP_CONSTEXPR_14 ConvertCooperativeVectorMatrixInfoNV( ConvertCooperativeVectorMatrixInfoNV const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    ConvertCooperativeVectorMatrixInfoNV( VkConvertCooperativeVectorMatrixInfoNV const & rhs ) VULKAN_HPP_NOEXCEPT
      : ConvertCooperativeVectorMatrixInfoNV( *reinterpret_cast<ConvertCooperativeVectorMatrixInfoNV const *>( &rhs ) )
    {
    }

    ConvertCooperativeVectorMatrixInfoNV & operator=( ConvertCooperativeVectorMatrixInfoNV const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    ConvertCooperativeVectorMatrixInfoNV & operator=( VkConvertCooperativeVectorMatrixInfoNV const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<ConvertCooperativeVectorMatrixInfoNV const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 ConvertCooperativeVectorMatrixInfoNV & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ConvertCooperativeVectorMatrixInfoNV & setSrcSize( size_t srcSize_ ) VULKAN_HPP_NOEXCEPT
    {
      srcSize = srcSize_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ConvertCooperativeVectorMatrixInfoNV & setSrcData( DeviceOrHostAddressConstKHR const & srcData_ ) VULKAN_HPP_NOEXCEPT
    {
      srcData = srcData_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ConvertCooperativeVectorMatrixInfoNV & setPDstSize( size_t * pDstSize_ ) VULKAN_HPP_NOEXCEPT
    {
      pDstSize = pDstSize_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ConvertCooperativeVectorMatrixInfoNV & setDstData( DeviceOrHostAddressKHR const & dstData_ ) VULKAN_HPP_NOEXCEPT
    {
      dstData = dstData_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ConvertCooperativeVectorMatrixInfoNV & setSrcComponentType( ComponentTypeKHR srcComponentType_ ) VULKAN_HPP_NOEXCEPT
    {
      srcComponentType = srcComponentType_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ConvertCooperativeVectorMatrixInfoNV & setDstComponentType( ComponentTypeKHR dstComponentType_ ) VULKAN_HPP_NOEXCEPT
    {
      dstComponentType = dstComponentType_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ConvertCooperativeVectorMatrixInfoNV & setNumRows( uint32_t numRows_ ) VULKAN_HPP_NOEXCEPT
    {
      numRows = numRows_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ConvertCooperativeVectorMatrixInfoNV & setNumColumns( uint32_t numColumns_ ) VULKAN_HPP_NOEXCEPT
    {
      numColumns = numColumns_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ConvertCooperativeVectorMatrixInfoNV & setSrcLayout( CooperativeVectorMatrixLayoutNV srcLayout_ ) VULKAN_HPP_NOEXCEPT
    {
      srcLayout = srcLayout_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ConvertCooperativeVectorMatrixInfoNV & setSrcStride( size_t srcStride_ ) VULKAN_HPP_NOEXCEPT
    {
      srcStride = srcStride_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ConvertCooperativeVectorMatrixInfoNV & setDstLayout( CooperativeVectorMatrixLayoutNV dstLayout_ ) VULKAN_HPP_NOEXCEPT
    {
      dstLayout = dstLayout_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ConvertCooperativeVectorMatrixInfoNV & setDstStride( size_t dstStride_ ) VULKAN_HPP_NOEXCEPT
    {
      dstStride = dstStride_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_SETTERS*/

    operator VkConvertCooperativeVectorMatrixInfoNV const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkConvertCooperativeVectorMatrixInfoNV *>( this );
    }

    operator VkConvertCooperativeVectorMatrixInfoNV &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkConvertCooperativeVectorMatrixInfoNV *>( this );
    }

    operator VkConvertCooperativeVectorMatrixInfoNV const *() const VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<const VkConvertCooperativeVectorMatrixInfoNV *>( this );
    }

    operator VkConvertCooperativeVectorMatrixInfoNV *() VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<VkConvertCooperativeVectorMatrixInfoNV *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<StructureType const &,
               const void * const &,
               size_t const &,
               DeviceOrHostAddressConstKHR const &,
               size_t * const &,
               DeviceOrHostAddressKHR const &,
               ComponentTypeKHR const &,
               ComponentTypeKHR const &,
               uint32_t const &,
               uint32_t const &,
               CooperativeVectorMatrixLayoutNV const &,
               size_t const &,
               CooperativeVectorMatrixLayoutNV const &,
               size_t const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType,
                       pNext,
                       srcSize,
                       srcData,
                       pDstSize,
                       dstData,
                       srcComponentType,
                       dstComponentType,
                       numRows,
                       numColumns,
                       srcLayout,
                       srcStride,
                       dstLayout,
                       dstStride );
    }
#endif

  public:
    StructureType                   sType            = StructureType::eConvertCooperativeVectorMatrixInfoNV;
    const void *                    pNext            = {};
    size_t                          srcSize          = {};
    DeviceOrHostAddressConstKHR     srcData          = {};
    size_t *                        pDstSize         = {};
    DeviceOrHostAddressKHR          dstData          = {};
    ComponentTypeKHR                srcComponentType = ComponentTypeKHR::eFloat16;
    ComponentTypeKHR                dstComponentType = ComponentTypeKHR::eFloat16;
    uint32_t                        numRows          = {};
    uint32_t                        numColumns       = {};
    CooperativeVectorMatrixLayoutNV srcLayout        = CooperativeVectorMatrixLayoutNV::eRowMajor;
    size_t                          srcStride        = {};
    CooperativeVectorMatrixLayoutNV dstLayout        = CooperativeVectorMatrixLayoutNV::eRowMajor;
    size_t                          dstStride        = {};
  };

  template <>
  struct CppType<StructureType, StructureType::eConvertCooperativeVectorMatrixInfoNV>
  {
    using Type = ConvertCooperativeVectorMatrixInfoNV;
  };

  // wrapper struct for struct VkCooperativeMatrixFlexibleDimensionsPropertiesNV, see
  // https://registry.khronos.org/vulkan/specs/latest/man/html/VkCooperativeMatrixFlexibleDimensionsPropertiesNV.html
  struct CooperativeMatrixFlexibleDimensionsPropertiesNV
  {
    using NativeType = VkCooperativeMatrixFlexibleDimensionsPropertiesNV;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eCooperativeMatrixFlexibleDimensionsPropertiesNV;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR CooperativeMatrixFlexibleDimensionsPropertiesNV( uint32_t         MGranularity_           = {},
                                                                          uint32_t         NGranularity_           = {},
                                                                          uint32_t         KGranularity_           = {},
                                                                          ComponentTypeKHR AType_                  = ComponentTypeKHR::eFloat16,
                                                                          ComponentTypeKHR BType_                  = ComponentTypeKHR::eFloat16,
                                                                          ComponentTypeKHR CType_                  = ComponentTypeKHR::eFloat16,
                                                                          ComponentTypeKHR ResultType_             = ComponentTypeKHR::eFloat16,
                                                                          Bool32           saturatingAccumulation_ = {},
                                                                          ScopeKHR         scope_                  = ScopeKHR::eDevice,
                                                                          uint32_t         workgroupInvocations_   = {},
                                                                          void *           pNext_                  = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , MGranularity{ MGranularity_ }
      , NGranularity{ NGranularity_ }
      , KGranularity{ KGranularity_ }
      , AType{ AType_ }
      , BType{ BType_ }
      , CType{ CType_ }
      , ResultType{ ResultType_ }
      , saturatingAccumulation{ saturatingAccumulation_ }
      , scope{ scope_ }
      , workgroupInvocations{ workgroupInvocations_ }
    {
    }

    VULKAN_HPP_CONSTEXPR
      CooperativeMatrixFlexibleDimensionsPropertiesNV( CooperativeMatrixFlexibleDimensionsPropertiesNV const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    CooperativeMatrixFlexibleDimensionsPropertiesNV( VkCooperativeMatrixFlexibleDimensionsPropertiesNV const & rhs ) VULKAN_HPP_NOEXCEPT
      : CooperativeMatrixFlexibleDimensionsPropertiesNV( *reinterpret_cast<CooperativeMatrixFlexibleDimensionsPropertiesNV const *>( &rhs ) )
    {
    }

    CooperativeMatrixFlexibleDimensionsPropertiesNV & operator=( CooperativeMatrixFlexibleDimensionsPropertiesNV const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    CooperativeMatrixFlexibleDimensionsPropertiesNV & operator=( VkCooperativeMatrixFlexibleDimensionsPropertiesNV const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<CooperativeMatrixFlexibleDimensionsPropertiesNV const *>( &rhs );
      return *this;
    }

    operator VkCooperativeMatrixFlexibleDimensionsPropertiesNV const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkCooperativeMatrixFlexibleDimensionsPropertiesNV *>( this );
    }

    operator VkCooperativeMatrixFlexibleDimensionsPropertiesNV &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkCooperativeMatrixFlexibleDimensionsPropertiesNV *>( this );
    }

    operator VkCooperativeMatrixFlexibleDimensionsPropertiesNV const *() const VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<const VkCooperativeMatrixFlexibleDimensionsPropertiesNV *>( this );
    }

    operator VkCooperativeMatrixFlexibleDimensionsPropertiesNV *() VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<VkCooperativeMatrixFlexibleDimensionsPropertiesNV *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<StructureType const &,
               void * const &,
               uint32_t const &,
               uint32_t const &,
               uint32_t const &,
               ComponentTypeKHR const &,
               ComponentTypeKHR const &,
               ComponentTypeKHR const &,
               ComponentTypeKHR const &,
               Bool32 const &,
               ScopeKHR const &,
               uint32_t const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie(
        sType, pNext, MGranularity, NGranularity, KGranularity, AType, BType, CType, ResultType, saturatingAccumulation, scope, workgroupInvocations );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( CooperativeMatrixFlexibleDimensionsPropertiesNV const & ) const = default;
#else
    bool operator==( CooperativeMatrixFlexibleDimensionsPropertiesNV const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( MGranularity == rhs.MGranularity ) && ( NGranularity == rhs.NGranularity ) &&
             ( KGranularity == rhs.KGranularity ) && ( AType == rhs.AType ) && ( BType == rhs.BType ) && ( CType == rhs.CType ) &&
             ( ResultType == rhs.ResultType ) && ( saturatingAccumulation == rhs.saturatingAccumulation ) && ( scope == rhs.scope ) &&
             ( workgroupInvocations == rhs.workgroupInvocations );
#  endif
    }

    bool operator!=( CooperativeMatrixFlexibleDimensionsPropertiesNV const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    StructureType    sType                  = StructureType::eCooperativeMatrixFlexibleDimensionsPropertiesNV;
    void *           pNext                  = {};
    uint32_t         MGranularity           = {};
    uint32_t         NGranularity           = {};
    uint32_t         KGranularity           = {};
    ComponentTypeKHR AType                  = ComponentTypeKHR::eFloat16;
    ComponentTypeKHR BType                  = ComponentTypeKHR::eFloat16;
    ComponentTypeKHR CType                  = ComponentTypeKHR::eFloat16;
    ComponentTypeKHR ResultType             = ComponentTypeKHR::eFloat16;
    Bool32           saturatingAccumulation = {};
    ScopeKHR         scope                  = ScopeKHR::eDevice;
    uint32_t         workgroupInvocations   = {};
  };

  template <>
  struct CppType<StructureType, StructureType::eCooperativeMatrixFlexibleDimensionsPropertiesNV>
  {
    using Type = CooperativeMatrixFlexibleDimensionsPropertiesNV;
  };

  // wrapper struct for struct VkCooperativeMatrixPropertiesKHR, see
  // https://registry.khronos.org/vulkan/specs/latest/man/html/VkCooperativeMatrixPropertiesKHR.html
  struct CooperativeMatrixPropertiesKHR
  {
    using NativeType = VkCooperativeMatrixPropertiesKHR;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eCooperativeMatrixPropertiesKHR;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR CooperativeMatrixPropertiesKHR( uint32_t         MSize_                  = {},
                                                         uint32_t         NSize_                  = {},
                                                         uint32_t         KSize_                  = {},
                                                         ComponentTypeKHR AType_                  = ComponentTypeKHR::eFloat16,
                                                         ComponentTypeKHR BType_                  = ComponentTypeKHR::eFloat16,
                                                         ComponentTypeKHR CType_                  = ComponentTypeKHR::eFloat16,
                                                         ComponentTypeKHR ResultType_             = ComponentTypeKHR::eFloat16,
                                                         Bool32           saturatingAccumulation_ = {},
                                                         ScopeKHR         scope_                  = ScopeKHR::eDevice,
                                                         void *           pNext_                  = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , MSize{ MSize_ }
      , NSize{ NSize_ }
      , KSize{ KSize_ }
      , AType{ AType_ }
      , BType{ BType_ }
      , CType{ CType_ }
      , ResultType{ ResultType_ }
      , saturatingAccumulation{ saturatingAccumulation_ }
      , scope{ scope_ }
    {
    }

    VULKAN_HPP_CONSTEXPR CooperativeMatrixPropertiesKHR( CooperativeMatrixPropertiesKHR const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    CooperativeMatrixPropertiesKHR( VkCooperativeMatrixPropertiesKHR const & rhs ) VULKAN_HPP_NOEXCEPT
      : CooperativeMatrixPropertiesKHR( *reinterpret_cast<CooperativeMatrixPropertiesKHR const *>( &rhs ) )
    {
    }

    CooperativeMatrixPropertiesKHR & operator=( CooperativeMatrixPropertiesKHR const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    CooperativeMatrixPropertiesKHR & operator=( VkCooperativeMatrixPropertiesKHR const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<CooperativeMatrixPropertiesKHR const *>( &rhs );
      return *this;
    }

    operator VkCooperativeMatrixPropertiesKHR const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkCooperativeMatrixPropertiesKHR *>( this );
    }

    operator VkCooperativeMatrixPropertiesKHR &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkCooperativeMatrixPropertiesKHR *>( this );
    }

    operator VkCooperativeMatrixPropertiesKHR const *() const VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<const VkCooperativeMatrixPropertiesKHR *>( this );
    }

    operator VkCooperativeMatrixPropertiesKHR *() VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<VkCooperativeMatrixPropertiesKHR *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<StructureType const &,
               void * const &,
               uint32_t const &,
               uint32_t const &,
               uint32_t const &,
               ComponentTypeKHR const &,
               ComponentTypeKHR const &,
               ComponentTypeKHR const &,
               ComponentTypeKHR const &,
               Bool32 const &,
               ScopeKHR const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, MSize, NSize, KSize, AType, BType, CType, ResultType, saturatingAccumulation, scope );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( CooperativeMatrixPropertiesKHR const & ) const = default;
#else
    bool operator==( CooperativeMatrixPropertiesKHR const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( MSize == rhs.MSize ) && ( NSize == rhs.NSize ) && ( KSize == rhs.KSize ) &&
             ( AType == rhs.AType ) && ( BType == rhs.BType ) && ( CType == rhs.CType ) && ( ResultType == rhs.ResultType ) &&
             ( saturatingAccumulation == rhs.saturatingAccumulation ) && ( scope == rhs.scope );
#  endif
    }

    bool operator!=( CooperativeMatrixPropertiesKHR const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    StructureType    sType                  = StructureType::eCooperativeMatrixPropertiesKHR;
    void *           pNext                  = {};
    uint32_t         MSize                  = {};
    uint32_t         NSize                  = {};
    uint32_t         KSize                  = {};
    ComponentTypeKHR AType                  = ComponentTypeKHR::eFloat16;
    ComponentTypeKHR BType                  = ComponentTypeKHR::eFloat16;
    ComponentTypeKHR CType                  = ComponentTypeKHR::eFloat16;
    ComponentTypeKHR ResultType             = ComponentTypeKHR::eFloat16;
    Bool32           saturatingAccumulation = {};
    ScopeKHR         scope                  = ScopeKHR::eDevice;
  };

  template <>
  struct CppType<StructureType, StructureType::eCooperativeMatrixPropertiesKHR>
  {
    using Type = CooperativeMatrixPropertiesKHR;
  };

  // wrapper struct for struct VkCooperativeMatrixPropertiesNV, see
  // https://registry.khronos.org/vulkan/specs/latest/man/html/VkCooperativeMatrixPropertiesNV.html
  struct CooperativeMatrixPropertiesNV
  {
    using NativeType = VkCooperativeMatrixPropertiesNV;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eCooperativeMatrixPropertiesNV;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR CooperativeMatrixPropertiesNV( uint32_t        MSize_ = {},
                                                        uint32_t        NSize_ = {},
                                                        uint32_t        KSize_ = {},
                                                        ComponentTypeNV AType_ = {},
                                                        ComponentTypeNV BType_ = {},
                                                        ComponentTypeNV CType_ = {},
                                                        ComponentTypeNV DType_ = {},
                                                        ScopeNV         scope_ = {},
                                                        void *          pNext_ = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , MSize{ MSize_ }
      , NSize{ NSize_ }
      , KSize{ KSize_ }
      , AType{ AType_ }
      , BType{ BType_ }
      , CType{ CType_ }
      , DType{ DType_ }
      , scope{ scope_ }
    {
    }

    VULKAN_HPP_CONSTEXPR CooperativeMatrixPropertiesNV( CooperativeMatrixPropertiesNV const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    CooperativeMatrixPropertiesNV( VkCooperativeMatrixPropertiesNV const & rhs ) VULKAN_HPP_NOEXCEPT
      : CooperativeMatrixPropertiesNV( *reinterpret_cast<CooperativeMatrixPropertiesNV const *>( &rhs ) )
    {
    }

    CooperativeMatrixPropertiesNV & operator=( CooperativeMatrixPropertiesNV const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    CooperativeMatrixPropertiesNV & operator=( VkCooperativeMatrixPropertiesNV const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<CooperativeMatrixPropertiesNV const *>( &rhs );
      return *this;
    }

    operator VkCooperativeMatrixPropertiesNV const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkCooperativeMatrixPropertiesNV *>( this );
    }

    operator VkCooperativeMatrixPropertiesNV &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkCooperativeMatrixPropertiesNV *>( this );
    }

    operator VkCooperativeMatrixPropertiesNV const *() const VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<const VkCooperativeMatrixPropertiesNV *>( this );
    }

    operator VkCooperativeMatrixPropertiesNV *() VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<VkCooperativeMatrixPropertiesNV *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<StructureType const &,
               void * const &,
               uint32_t const &,
               uint32_t const &,
               uint32_t const &,
               ComponentTypeNV const &,
               ComponentTypeNV const &,
               ComponentTypeNV const &,
               ComponentTypeNV const &,
               ScopeNV const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, MSize, NSize, KSize, AType, BType, CType, DType, scope );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( CooperativeMatrixPropertiesNV const & ) const = default;
#else
    bool operator==( CooperativeMatrixPropertiesNV const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( MSize == rhs.MSize ) && ( NSize == rhs.NSize ) && ( KSize == rhs.KSize ) &&
             ( AType == rhs.AType ) && ( BType == rhs.BType ) && ( CType == rhs.CType ) && ( DType == rhs.DType ) && ( scope == rhs.scope );
#  endif
    }

    bool operator!=( CooperativeMatrixPropertiesNV const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    StructureType   sType = StructureType::eCooperativeMatrixPropertiesNV;
    void *          pNext = {};
    uint32_t        MSize = {};
    uint32_t        NSize = {};
    uint32_t        KSize = {};
    ComponentTypeNV AType = {};
    ComponentTypeNV BType = {};
    ComponentTypeNV CType = {};
    ComponentTypeNV DType = {};
    ScopeNV         scope = {};
  };

  template <>
  struct CppType<StructureType, StructureType::eCooperativeMatrixPropertiesNV>
  {
    using Type = CooperativeMatrixPropertiesNV;
  };

  // wrapper struct for struct VkCooperativeVectorPropertiesNV, see
  // https://registry.khronos.org/vulkan/specs/latest/man/html/VkCooperativeVectorPropertiesNV.html
  struct CooperativeVectorPropertiesNV
  {
    using NativeType = VkCooperativeVectorPropertiesNV;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eCooperativeVectorPropertiesNV;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR CooperativeVectorPropertiesNV( ComponentTypeKHR inputType_            = ComponentTypeKHR::eFloat16,
                                                        ComponentTypeKHR inputInterpretation_  = ComponentTypeKHR::eFloat16,
                                                        ComponentTypeKHR matrixInterpretation_ = ComponentTypeKHR::eFloat16,
                                                        ComponentTypeKHR biasInterpretation_   = ComponentTypeKHR::eFloat16,
                                                        ComponentTypeKHR resultType_           = ComponentTypeKHR::eFloat16,
                                                        Bool32           transpose_            = {},
                                                        void *           pNext_                = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , inputType{ inputType_ }
      , inputInterpretation{ inputInterpretation_ }
      , matrixInterpretation{ matrixInterpretation_ }
      , biasInterpretation{ biasInterpretation_ }
      , resultType{ resultType_ }
      , transpose{ transpose_ }
    {
    }

    VULKAN_HPP_CONSTEXPR CooperativeVectorPropertiesNV( CooperativeVectorPropertiesNV const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    CooperativeVectorPropertiesNV( VkCooperativeVectorPropertiesNV const & rhs ) VULKAN_HPP_NOEXCEPT
      : CooperativeVectorPropertiesNV( *reinterpret_cast<CooperativeVectorPropertiesNV const *>( &rhs ) )
    {
    }

    CooperativeVectorPropertiesNV & operator=( CooperativeVectorPropertiesNV const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    CooperativeVectorPropertiesNV & operator=( VkCooperativeVectorPropertiesNV const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<CooperativeVectorPropertiesNV const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 CooperativeVectorPropertiesNV & setPNext( void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CooperativeVectorPropertiesNV & setInputType( ComponentTypeKHR inputType_ ) VULKAN_HPP_NOEXCEPT
    {
      inputType = inputType_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CooperativeVectorPropertiesNV & setInputInterpretation( ComponentTypeKHR inputInterpretation_ ) VULKAN_HPP_NOEXCEPT
    {
      inputInterpretation = inputInterpretation_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CooperativeVectorPropertiesNV & setMatrixInterpretation( ComponentTypeKHR matrixInterpretation_ ) VULKAN_HPP_NOEXCEPT
    {
      matrixInterpretation = matrixInterpretation_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CooperativeVectorPropertiesNV & setBiasInterpretation( ComponentTypeKHR biasInterpretation_ ) VULKAN_HPP_NOEXCEPT
    {
      biasInterpretation = biasInterpretation_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CooperativeVectorPropertiesNV & setResultType( ComponentTypeKHR resultType_ ) VULKAN_HPP_NOEXCEPT
    {
      resultType = resultType_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CooperativeVectorPropertiesNV & setTranspose( Bool32 transpose_ ) VULKAN_HPP_NOEXCEPT
    {
      transpose = transpose_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_SETTERS*/

    operator VkCooperativeVectorPropertiesNV const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkCooperativeVectorPropertiesNV *>( this );
    }

    operator VkCooperativeVectorPropertiesNV &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkCooperativeVectorPropertiesNV *>( this );
    }

    operator VkCooperativeVectorPropertiesNV const *() const VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<const VkCooperativeVectorPropertiesNV *>( this );
    }

    operator VkCooperativeVectorPropertiesNV *() VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<VkCooperativeVectorPropertiesNV *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<StructureType const &,
               void * const &,
               ComponentTypeKHR const &,
               ComponentTypeKHR const &,
               ComponentTypeKHR const &,
               ComponentTypeKHR const &,
               ComponentTypeKHR const &,
               Bool32 const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, inputType, inputInterpretation, matrixInterpretation, biasInterpretation, resultType, transpose );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( CooperativeVectorPropertiesNV const & ) const = default;
#else
    bool operator==( CooperativeVectorPropertiesNV const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( inputType == rhs.inputType ) && ( inputInterpretation == rhs.inputInterpretation ) &&
             ( matrixInterpretation == rhs.matrixInterpretation ) && ( biasInterpretation == rhs.biasInterpretation ) && ( resultType == rhs.resultType ) &&
             ( transpose == rhs.transpose );
#  endif
    }

    bool operator!=( CooperativeVectorPropertiesNV const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    StructureType    sType                = StructureType::eCooperativeVectorPropertiesNV;
    void *           pNext                = {};
    ComponentTypeKHR inputType            = ComponentTypeKHR::eFloat16;
    ComponentTypeKHR inputInterpretation  = ComponentTypeKHR::eFloat16;
    ComponentTypeKHR matrixInterpretation = ComponentTypeKHR::eFloat16;
    ComponentTypeKHR biasInterpretation   = ComponentTypeKHR::eFloat16;
    ComponentTypeKHR resultType           = ComponentTypeKHR::eFloat16;
    Bool32           transpose            = {};
  };

  template <>
  struct CppType<StructureType, StructureType::eCooperativeVectorPropertiesNV>
  {
    using Type = CooperativeVectorPropertiesNV;
  };

  // wrapper struct for struct VkCopyAccelerationStructureInfoKHR, see
  // https://registry.khronos.org/vulkan/specs/latest/man/html/VkCopyAccelerationStructureInfoKHR.html
  struct CopyAccelerationStructureInfoKHR
  {
    using NativeType = VkCopyAccelerationStructureInfoKHR;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eCopyAccelerationStructureInfoKHR;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR CopyAccelerationStructureInfoKHR( AccelerationStructureKHR         src_   = {},
                                                           AccelerationStructureKHR         dst_   = {},
                                                           CopyAccelerationStructureModeKHR mode_  = CopyAccelerationStructureModeKHR::eClone,
                                                           const void *                     pNext_ = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , src{ src_ }
      , dst{ dst_ }
      , mode{ mode_ }
    {
    }

    VULKAN_HPP_CONSTEXPR CopyAccelerationStructureInfoKHR( CopyAccelerationStructureInfoKHR const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    CopyAccelerationStructureInfoKHR( VkCopyAccelerationStructureInfoKHR const & rhs ) VULKAN_HPP_NOEXCEPT
      : CopyAccelerationStructureInfoKHR( *reinterpret_cast<CopyAccelerationStructureInfoKHR const *>( &rhs ) )
    {
    }

    CopyAccelerationStructureInfoKHR & operator=( CopyAccelerationStructureInfoKHR const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    CopyAccelerationStructureInfoKHR & operator=( VkCopyAccelerationStructureInfoKHR const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<CopyAccelerationStructureInfoKHR const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 CopyAccelerationStructureInfoKHR & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CopyAccelerationStructureInfoKHR & setSrc( AccelerationStructureKHR src_ ) VULKAN_HPP_NOEXCEPT
    {
      src = src_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CopyAccelerationStructureInfoKHR & setDst( AccelerationStructureKHR dst_ ) VULKAN_HPP_NOEXCEPT
    {
      dst = dst_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CopyAccelerationStructureInfoKHR & setMode( CopyAccelerationStructureModeKHR mode_ ) VULKAN_HPP_NOEXCEPT
    {
      mode = mode_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_SETTERS*/

    operator VkCopyAccelerationStructureInfoKHR const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkCopyAccelerationStructureInfoKHR *>( this );
    }

    operator VkCopyAccelerationStructureInfoKHR &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkCopyAccelerationStructureInfoKHR *>( this );
    }

    operator VkCopyAccelerationStructureInfoKHR const *() const VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<const VkCopyAccelerationStructureInfoKHR *>( this );
    }

    operator VkCopyAccelerationStructureInfoKHR *() VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<VkCopyAccelerationStructureInfoKHR *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<StructureType const &,
               const void * const &,
               AccelerationStructureKHR const &,
               AccelerationStructureKHR const &,
               CopyAccelerationStructureModeKHR const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, src, dst, mode );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( CopyAccelerationStructureInfoKHR const & ) const = default;
#else
    bool operator==( CopyAccelerationStructureInfoKHR const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( src == rhs.src ) && ( dst == rhs.dst ) && ( mode == rhs.mode );
#  endif
    }

    bool operator!=( CopyAccelerationStructureInfoKHR const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    StructureType                    sType = StructureType::eCopyAccelerationStructureInfoKHR;
    const void *                     pNext = {};
    AccelerationStructureKHR         src   = {};
    AccelerationStructureKHR         dst   = {};
    CopyAccelerationStructureModeKHR mode  = CopyAccelerationStructureModeKHR::eClone;
  };

  template <>
  struct CppType<StructureType, StructureType::eCopyAccelerationStructureInfoKHR>
  {
    using Type = CopyAccelerationStructureInfoKHR;
  };

  // wrapper struct for struct VkCopyAccelerationStructureToMemoryInfoKHR, see
  // https://registry.khronos.org/vulkan/specs/latest/man/html/VkCopyAccelerationStructureToMemoryInfoKHR.html
  struct CopyAccelerationStructureToMemoryInfoKHR
  {
    using NativeType = VkCopyAccelerationStructureToMemoryInfoKHR;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eCopyAccelerationStructureToMemoryInfoKHR;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR_14 CopyAccelerationStructureToMemoryInfoKHR( AccelerationStructureKHR         src_   = {},
                                                                      DeviceOrHostAddressKHR           dst_   = {},
                                                                      CopyAccelerationStructureModeKHR mode_  = CopyAccelerationStructureModeKHR::eClone,
                                                                      const void *                     pNext_ = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , src{ src_ }
      , dst{ dst_ }
      , mode{ mode_ }
    {
    }

    VULKAN_HPP_CONSTEXPR_14 CopyAccelerationStructureToMemoryInfoKHR( CopyAccelerationStructureToMemoryInfoKHR const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    CopyAccelerationStructureToMemoryInfoKHR( VkCopyAccelerationStructureToMemoryInfoKHR const & rhs ) VULKAN_HPP_NOEXCEPT
      : CopyAccelerationStructureToMemoryInfoKHR( *reinterpret_cast<CopyAccelerationStructureToMemoryInfoKHR const *>( &rhs ) )
    {
    }

    CopyAccelerationStructureToMemoryInfoKHR & operator=( CopyAccelerationStructureToMemoryInfoKHR const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    CopyAccelerationStructureToMemoryInfoKHR & operator=( VkCopyAccelerationStructureToMemoryInfoKHR const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<CopyAccelerationStructureToMemoryInfoKHR const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 CopyAccelerationStructureToMemoryInfoKHR & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CopyAccelerationStructureToMemoryInfoKHR & setSrc( AccelerationStructureKHR src_ ) VULKAN_HPP_NOEXCEPT
    {
      src = src_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CopyAccelerationStructureToMemoryInfoKHR & setDst( DeviceOrHostAddressKHR const & dst_ ) VULKAN_HPP_NOEXCEPT
    {
      dst = dst_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CopyAccelerationStructureToMemoryInfoKHR & setMode( CopyAccelerationStructureModeKHR mode_ ) VULKAN_HPP_NOEXCEPT
    {
      mode = mode_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_SETTERS*/

    operator VkCopyAccelerationStructureToMemoryInfoKHR const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkCopyAccelerationStructureToMemoryInfoKHR *>( this );
    }

    operator VkCopyAccelerationStructureToMemoryInfoKHR &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkCopyAccelerationStructureToMemoryInfoKHR *>( this );
    }

    operator VkCopyAccelerationStructureToMemoryInfoKHR const *() const VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<const VkCopyAccelerationStructureToMemoryInfoKHR *>( this );
    }

    operator VkCopyAccelerationStructureToMemoryInfoKHR *() VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<VkCopyAccelerationStructureToMemoryInfoKHR *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<StructureType const &,
               const void * const &,
               AccelerationStructureKHR const &,
               DeviceOrHostAddressKHR const &,
               CopyAccelerationStructureModeKHR const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, src, dst, mode );
    }
#endif

  public:
    StructureType                    sType = StructureType::eCopyAccelerationStructureToMemoryInfoKHR;
    const void *                     pNext = {};
    AccelerationStructureKHR         src   = {};
    DeviceOrHostAddressKHR           dst   = {};
    CopyAccelerationStructureModeKHR mode  = CopyAccelerationStructureModeKHR::eClone;
  };

  template <>
  struct CppType<StructureType, StructureType::eCopyAccelerationStructureToMemoryInfoKHR>
  {
    using Type = CopyAccelerationStructureToMemoryInfoKHR;
  };

  // wrapper struct for struct VkCopyBufferInfo2, see https://registry.khronos.org/vulkan/specs/latest/man/html/VkCopyBufferInfo2.html
  struct CopyBufferInfo2
  {
    using NativeType = VkCopyBufferInfo2;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eCopyBufferInfo2;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR CopyBufferInfo2( Buffer              srcBuffer_   = {},
                                          Buffer              dstBuffer_   = {},
                                          uint32_t            regionCount_ = {},
                                          const BufferCopy2 * pRegions_    = {},
                                          const void *        pNext_       = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , srcBuffer{ srcBuffer_ }
      , dstBuffer{ dstBuffer_ }
      , regionCount{ regionCount_ }
      , pRegions{ pRegions_ }
    {
    }

    VULKAN_HPP_CONSTEXPR CopyBufferInfo2( CopyBufferInfo2 const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    CopyBufferInfo2( VkCopyBufferInfo2 const & rhs ) VULKAN_HPP_NOEXCEPT : CopyBufferInfo2( *reinterpret_cast<CopyBufferInfo2 const *>( &rhs ) ) {}

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    CopyBufferInfo2( Buffer srcBuffer_, Buffer dstBuffer_, ArrayProxyNoTemporaries<const BufferCopy2> const & regions_, const void * pNext_ = nullptr )
      : pNext( pNext_ ), srcBuffer( srcBuffer_ ), dstBuffer( dstBuffer_ ), regionCount( static_cast<uint32_t>( regions_.size() ) ), pRegions( regions_.data() )
    {
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/

    CopyBufferInfo2 & operator=( CopyBufferInfo2 const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    CopyBufferInfo2 & operator=( VkCopyBufferInfo2 const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<CopyBufferInfo2 const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 CopyBufferInfo2 & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CopyBufferInfo2 & setSrcBuffer( Buffer srcBuffer_ ) VULKAN_HPP_NOEXCEPT
    {
      srcBuffer = srcBuffer_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CopyBufferInfo2 & setDstBuffer( Buffer dstBuffer_ ) VULKAN_HPP_NOEXCEPT
    {
      dstBuffer = dstBuffer_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CopyBufferInfo2 & setRegionCount( uint32_t regionCount_ ) VULKAN_HPP_NOEXCEPT
    {
      regionCount = regionCount_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CopyBufferInfo2 & setPRegions( const BufferCopy2 * pRegions_ ) VULKAN_HPP_NOEXCEPT
    {
      pRegions = pRegions_;
      return *this;
    }

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    CopyBufferInfo2 & setRegions( ArrayProxyNoTemporaries<const BufferCopy2> const & regions_ ) VULKAN_HPP_NOEXCEPT
    {
      regionCount = static_cast<uint32_t>( regions_.size() );
      pRegions    = regions_.data();
      return *this;
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/
#endif   /*VULKAN_HPP_NO_SETTERS*/

    operator VkCopyBufferInfo2 const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkCopyBufferInfo2 *>( this );
    }

    operator VkCopyBufferInfo2 &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkCopyBufferInfo2 *>( this );
    }

    operator VkCopyBufferInfo2 const *() const VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<const VkCopyBufferInfo2 *>( this );
    }

    operator VkCopyBufferInfo2 *() VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<VkCopyBufferInfo2 *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<StructureType const &, const void * const &, Buffer const &, Buffer const &, uint32_t const &, const BufferCopy2 * const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, srcBuffer, dstBuffer, regionCount, pRegions );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( CopyBufferInfo2 const & ) const = default;
#else
    bool operator==( CopyBufferInfo2 const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( srcBuffer == rhs.srcBuffer ) && ( dstBuffer == rhs.dstBuffer ) &&
             ( regionCount == rhs.regionCount ) && ( pRegions == rhs.pRegions );
#  endif
    }

    bool operator!=( CopyBufferInfo2 const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    StructureType       sType       = StructureType::eCopyBufferInfo2;
    const void *        pNext       = {};
    Buffer              srcBuffer   = {};
    Buffer              dstBuffer   = {};
    uint32_t            regionCount = {};
    const BufferCopy2 * pRegions    = {};
  };

  template <>
  struct CppType<StructureType, StructureType::eCopyBufferInfo2>
  {
    using Type = CopyBufferInfo2;
  };

  using CopyBufferInfo2KHR = CopyBufferInfo2;

  // wrapper struct for struct VkCopyBufferToImageInfo2, see https://registry.khronos.org/vulkan/specs/latest/man/html/VkCopyBufferToImageInfo2.html
  struct CopyBufferToImageInfo2
  {
    using NativeType = VkCopyBufferToImageInfo2;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eCopyBufferToImageInfo2;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR CopyBufferToImageInfo2( Buffer                   srcBuffer_      = {},
                                                 Image                    dstImage_       = {},
                                                 ImageLayout              dstImageLayout_ = ImageLayout::eUndefined,
                                                 uint32_t                 regionCount_    = {},
                                                 const BufferImageCopy2 * pRegions_       = {},
                                                 const void *             pNext_          = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , srcBuffer{ srcBuffer_ }
      , dstImage{ dstImage_ }
      , dstImageLayout{ dstImageLayout_ }
      , regionCount{ regionCount_ }
      , pRegions{ pRegions_ }
    {
    }

    VULKAN_HPP_CONSTEXPR CopyBufferToImageInfo2( CopyBufferToImageInfo2 const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    CopyBufferToImageInfo2( VkCopyBufferToImageInfo2 const & rhs ) VULKAN_HPP_NOEXCEPT
      : CopyBufferToImageInfo2( *reinterpret_cast<CopyBufferToImageInfo2 const *>( &rhs ) )
    {
    }

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    CopyBufferToImageInfo2( Buffer                                                  srcBuffer_,
                            Image                                                   dstImage_,
                            ImageLayout                                             dstImageLayout_,
                            ArrayProxyNoTemporaries<const BufferImageCopy2> const & regions_,
                            const void *                                            pNext_ = nullptr )
      : pNext( pNext_ )
      , srcBuffer( srcBuffer_ )
      , dstImage( dstImage_ )
      , dstImageLayout( dstImageLayout_ )
      , regionCount( static_cast<uint32_t>( regions_.size() ) )
      , pRegions( regions_.data() )
    {
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/

    CopyBufferToImageInfo2 & operator=( CopyBufferToImageInfo2 const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    CopyBufferToImageInfo2 & operator=( VkCopyBufferToImageInfo2 const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<CopyBufferToImageInfo2 const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 CopyBufferToImageInfo2 & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CopyBufferToImageInfo2 & setSrcBuffer( Buffer srcBuffer_ ) VULKAN_HPP_NOEXCEPT
    {
      srcBuffer = srcBuffer_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CopyBufferToImageInfo2 & setDstImage( Image dstImage_ ) VULKAN_HPP_NOEXCEPT
    {
      dstImage = dstImage_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CopyBufferToImageInfo2 & setDstImageLayout( ImageLayout dstImageLayout_ ) VULKAN_HPP_NOEXCEPT
    {
      dstImageLayout = dstImageLayout_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CopyBufferToImageInfo2 & setRegionCount( uint32_t regionCount_ ) VULKAN_HPP_NOEXCEPT
    {
      regionCount = regionCount_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CopyBufferToImageInfo2 & setPRegions( const BufferImageCopy2 * pRegions_ ) VULKAN_HPP_NOEXCEPT
    {
      pRegions = pRegions_;
      return *this;
    }

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    CopyBufferToImageInfo2 & setRegions( ArrayProxyNoTemporaries<const BufferImageCopy2> const & regions_ ) VULKAN_HPP_NOEXCEPT
    {
      regionCount = static_cast<uint32_t>( regions_.size() );
      pRegions    = regions_.data();
      return *this;
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/
#endif   /*VULKAN_HPP_NO_SETTERS*/

    operator VkCopyBufferToImageInfo2 const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkCopyBufferToImageInfo2 *>( this );
    }

    operator VkCopyBufferToImageInfo2 &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkCopyBufferToImageInfo2 *>( this );
    }

    operator VkCopyBufferToImageInfo2 const *() const VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<const VkCopyBufferToImageInfo2 *>( this );
    }

    operator VkCopyBufferToImageInfo2 *() VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<VkCopyBufferToImageInfo2 *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::
      tuple<StructureType const &, const void * const &, Buffer const &, Image const &, ImageLayout const &, uint32_t const &, const BufferImageCopy2 * const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, srcBuffer, dstImage, dstImageLayout, regionCount, pRegions );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( CopyBufferToImageInfo2 const & ) const = default;
#else
    bool operator==( CopyBufferToImageInfo2 const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( srcBuffer == rhs.srcBuffer ) && ( dstImage == rhs.dstImage ) &&
             ( dstImageLayout == rhs.dstImageLayout ) && ( regionCount == rhs.regionCount ) && ( pRegions == rhs.pRegions );
#  endif
    }

    bool operator!=( CopyBufferToImageInfo2 const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    StructureType            sType          = StructureType::eCopyBufferToImageInfo2;
    const void *             pNext          = {};
    Buffer                   srcBuffer      = {};
    Image                    dstImage       = {};
    ImageLayout              dstImageLayout = ImageLayout::eUndefined;
    uint32_t                 regionCount    = {};
    const BufferImageCopy2 * pRegions       = {};
  };

  template <>
  struct CppType<StructureType, StructureType::eCopyBufferToImageInfo2>
  {
    using Type = CopyBufferToImageInfo2;
  };

  using CopyBufferToImageInfo2KHR = CopyBufferToImageInfo2;

  // wrapper struct for struct VkCopyCommandTransformInfoQCOM, see https://registry.khronos.org/vulkan/specs/latest/man/html/VkCopyCommandTransformInfoQCOM.html
  struct CopyCommandTransformInfoQCOM
  {
    using NativeType = VkCopyCommandTransformInfoQCOM;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eCopyCommandTransformInfoQCOM;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR CopyCommandTransformInfoQCOM( SurfaceTransformFlagBitsKHR transform_ = SurfaceTransformFlagBitsKHR::eIdentity,
                                                       const void *                pNext_     = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , transform{ transform_ }
    {
    }

    VULKAN_HPP_CONSTEXPR CopyCommandTransformInfoQCOM( CopyCommandTransformInfoQCOM const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    CopyCommandTransformInfoQCOM( VkCopyCommandTransformInfoQCOM const & rhs ) VULKAN_HPP_NOEXCEPT
      : CopyCommandTransformInfoQCOM( *reinterpret_cast<CopyCommandTransformInfoQCOM const *>( &rhs ) )
    {
    }

    CopyCommandTransformInfoQCOM & operator=( CopyCommandTransformInfoQCOM const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    CopyCommandTransformInfoQCOM & operator=( VkCopyCommandTransformInfoQCOM const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<CopyCommandTransformInfoQCOM const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 CopyCommandTransformInfoQCOM & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CopyCommandTransformInfoQCOM & setTransform( SurfaceTransformFlagBitsKHR transform_ ) VULKAN_HPP_NOEXCEPT
    {
      transform = transform_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_SETTERS*/

    operator VkCopyCommandTransformInfoQCOM const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkCopyCommandTransformInfoQCOM *>( this );
    }

    operator VkCopyCommandTransformInfoQCOM &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkCopyCommandTransformInfoQCOM *>( this );
    }

    operator VkCopyCommandTransformInfoQCOM const *() const VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<const VkCopyCommandTransformInfoQCOM *>( this );
    }

    operator VkCopyCommandTransformInfoQCOM *() VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<VkCopyCommandTransformInfoQCOM *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<StructureType const &, const void * const &, SurfaceTransformFlagBitsKHR const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, transform );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( CopyCommandTransformInfoQCOM const & ) const = default;
#else
    bool operator==( CopyCommandTransformInfoQCOM const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( transform == rhs.transform );
#  endif
    }

    bool operator!=( CopyCommandTransformInfoQCOM const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    StructureType               sType     = StructureType::eCopyCommandTransformInfoQCOM;
    const void *                pNext     = {};
    SurfaceTransformFlagBitsKHR transform = SurfaceTransformFlagBitsKHR::eIdentity;
  };

  template <>
  struct CppType<StructureType, StructureType::eCopyCommandTransformInfoQCOM>
  {
    using Type = CopyCommandTransformInfoQCOM;
  };

  // wrapper struct for struct VkCopyDescriptorSet, see https://registry.khronos.org/vulkan/specs/latest/man/html/VkCopyDescriptorSet.html
  struct CopyDescriptorSet
  {
    using NativeType = VkCopyDescriptorSet;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eCopyDescriptorSet;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR CopyDescriptorSet( DescriptorSet srcSet_          = {},
                                            uint32_t      srcBinding_      = {},
                                            uint32_t      srcArrayElement_ = {},
                                            DescriptorSet dstSet_          = {},
                                            uint32_t      dstBinding_      = {},
                                            uint32_t      dstArrayElement_ = {},
                                            uint32_t      descriptorCount_ = {},
                                            const void *  pNext_           = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , srcSet{ srcSet_ }
      , srcBinding{ srcBinding_ }
      , srcArrayElement{ srcArrayElement_ }
      , dstSet{ dstSet_ }
      , dstBinding{ dstBinding_ }
      , dstArrayElement{ dstArrayElement_ }
      , descriptorCount{ descriptorCount_ }
    {
    }

    VULKAN_HPP_CONSTEXPR CopyDescriptorSet( CopyDescriptorSet const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    CopyDescriptorSet( VkCopyDescriptorSet const & rhs ) VULKAN_HPP_NOEXCEPT : CopyDescriptorSet( *reinterpret_cast<CopyDescriptorSet const *>( &rhs ) ) {}

    CopyDescriptorSet & operator=( CopyDescriptorSet const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    CopyDescriptorSet & operator=( VkCopyDescriptorSet const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<CopyDescriptorSet const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 CopyDescriptorSet & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CopyDescriptorSet & setSrcSet( DescriptorSet srcSet_ ) VULKAN_HPP_NOEXCEPT
    {
      srcSet = srcSet_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CopyDescriptorSet & setSrcBinding( uint32_t srcBinding_ ) VULKAN_HPP_NOEXCEPT
    {
      srcBinding = srcBinding_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CopyDescriptorSet & setSrcArrayElement( uint32_t srcArrayElement_ ) VULKAN_HPP_NOEXCEPT
    {
      srcArrayElement = srcArrayElement_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CopyDescriptorSet & setDstSet( DescriptorSet dstSet_ ) VULKAN_HPP_NOEXCEPT
    {
      dstSet = dstSet_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CopyDescriptorSet & setDstBinding( uint32_t dstBinding_ ) VULKAN_HPP_NOEXCEPT
    {
      dstBinding = dstBinding_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CopyDescriptorSet & setDstArrayElement( uint32_t dstArrayElement_ ) VULKAN_HPP_NOEXCEPT
    {
      dstArrayElement = dstArrayElement_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CopyDescriptorSet & setDescriptorCount( uint32_t descriptorCount_ ) VULKAN_HPP_NOEXCEPT
    {
      descriptorCount = descriptorCount_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_SETTERS*/

    operator VkCopyDescriptorSet const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkCopyDescriptorSet *>( this );
    }

    operator VkCopyDescriptorSet &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkCopyDescriptorSet *>( this );
    }

    operator VkCopyDescriptorSet const *() const VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<const VkCopyDescriptorSet *>( this );
    }

    operator VkCopyDescriptorSet *() VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<VkCopyDescriptorSet *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<StructureType const &,
               const void * const &,
               DescriptorSet const &,
               uint32_t const &,
               uint32_t const &,
               DescriptorSet const &,
               uint32_t const &,
               uint32_t const &,
               uint32_t const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, srcSet, srcBinding, srcArrayElement, dstSet, dstBinding, dstArrayElement, descriptorCount );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( CopyDescriptorSet const & ) const = default;
#else
    bool operator==( CopyDescriptorSet const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( srcSet == rhs.srcSet ) && ( srcBinding == rhs.srcBinding ) &&
             ( srcArrayElement == rhs.srcArrayElement ) && ( dstSet == rhs.dstSet ) && ( dstBinding == rhs.dstBinding ) &&
             ( dstArrayElement == rhs.dstArrayElement ) && ( descriptorCount == rhs.descriptorCount );
#  endif
    }

    bool operator!=( CopyDescriptorSet const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    StructureType sType           = StructureType::eCopyDescriptorSet;
    const void *  pNext           = {};
    DescriptorSet srcSet          = {};
    uint32_t      srcBinding      = {};
    uint32_t      srcArrayElement = {};
    DescriptorSet dstSet          = {};
    uint32_t      dstBinding      = {};
    uint32_t      dstArrayElement = {};
    uint32_t      descriptorCount = {};
  };

  template <>
  struct CppType<StructureType, StructureType::eCopyDescriptorSet>
  {
    using Type = CopyDescriptorSet;
  };

  // wrapper struct for struct VkImageCopy2, see https://registry.khronos.org/vulkan/specs/latest/man/html/VkImageCopy2.html
  struct ImageCopy2
  {
    using NativeType = VkImageCopy2;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eImageCopy2;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR ImageCopy2( ImageSubresourceLayers srcSubresource_ = {},
                                     Offset3D               srcOffset_      = {},
                                     ImageSubresourceLayers dstSubresource_ = {},
                                     Offset3D               dstOffset_      = {},
                                     Extent3D               extent_         = {},
                                     const void *           pNext_          = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , srcSubresource{ srcSubresource_ }
      , srcOffset{ srcOffset_ }
      , dstSubresource{ dstSubresource_ }
      , dstOffset{ dstOffset_ }
      , extent{ extent_ }
    {
    }

    VULKAN_HPP_CONSTEXPR ImageCopy2( ImageCopy2 const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    ImageCopy2( VkImageCopy2 const & rhs ) VULKAN_HPP_NOEXCEPT : ImageCopy2( *reinterpret_cast<ImageCopy2 const *>( &rhs ) ) {}

    ImageCopy2 & operator=( ImageCopy2 const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    ImageCopy2 & operator=( VkImageCopy2 const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<ImageCopy2 const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 ImageCopy2 & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ImageCopy2 & setSrcSubresource( ImageSubresourceLayers const & srcSubresource_ ) VULKAN_HPP_NOEXCEPT
    {
      srcSubresource = srcSubresource_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ImageCopy2 & setSrcOffset( Offset3D const & srcOffset_ ) VULKAN_HPP_NOEXCEPT
    {
      srcOffset = srcOffset_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ImageCopy2 & setDstSubresource( ImageSubresourceLayers const & dstSubresource_ ) VULKAN_HPP_NOEXCEPT
    {
      dstSubresource = dstSubresource_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ImageCopy2 & setDstOffset( Offset3D const & dstOffset_ ) VULKAN_HPP_NOEXCEPT
    {
      dstOffset = dstOffset_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ImageCopy2 & setExtent( Extent3D const & extent_ ) VULKAN_HPP_NOEXCEPT
    {
      extent = extent_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_SETTERS*/

    operator VkImageCopy2 const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkImageCopy2 *>( this );
    }

    operator VkImageCopy2 &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkImageCopy2 *>( this );
    }

    operator VkImageCopy2 const *() const VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<const VkImageCopy2 *>( this );
    }

    operator VkImageCopy2 *() VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<VkImageCopy2 *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<StructureType const &,
               const void * const &,
               ImageSubresourceLayers const &,
               Offset3D const &,
               ImageSubresourceLayers const &,
               Offset3D const &,
               Extent3D const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, srcSubresource, srcOffset, dstSubresource, dstOffset, extent );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( ImageCopy2 const & ) const = default;
#else
    bool operator==( ImageCopy2 const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( srcSubresource == rhs.srcSubresource ) && ( srcOffset == rhs.srcOffset ) &&
             ( dstSubresource == rhs.dstSubresource ) && ( dstOffset == rhs.dstOffset ) && ( extent == rhs.extent );
#  endif
    }

    bool operator!=( ImageCopy2 const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    StructureType          sType          = StructureType::eImageCopy2;
    const void *           pNext          = {};
    ImageSubresourceLayers srcSubresource = {};
    Offset3D               srcOffset      = {};
    ImageSubresourceLayers dstSubresource = {};
    Offset3D               dstOffset      = {};
    Extent3D               extent         = {};
  };

  template <>
  struct CppType<StructureType, StructureType::eImageCopy2>
  {
    using Type = ImageCopy2;
  };

  using ImageCopy2KHR = ImageCopy2;

  // wrapper struct for struct VkCopyImageInfo2, see https://registry.khronos.org/vulkan/specs/latest/man/html/VkCopyImageInfo2.html
  struct CopyImageInfo2
  {
    using NativeType = VkCopyImageInfo2;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eCopyImageInfo2;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR CopyImageInfo2( Image              srcImage_       = {},
                                         ImageLayout        srcImageLayout_ = ImageLayout::eUndefined,
                                         Image              dstImage_       = {},
                                         ImageLayout        dstImageLayout_ = ImageLayout::eUndefined,
                                         uint32_t           regionCount_    = {},
                                         const ImageCopy2 * pRegions_       = {},
                                         const void *       pNext_          = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , srcImage{ srcImage_ }
      , srcImageLayout{ srcImageLayout_ }
      , dstImage{ dstImage_ }
      , dstImageLayout{ dstImageLayout_ }
      , regionCount{ regionCount_ }
      , pRegions{ pRegions_ }
    {
    }

    VULKAN_HPP_CONSTEXPR CopyImageInfo2( CopyImageInfo2 const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    CopyImageInfo2( VkCopyImageInfo2 const & rhs ) VULKAN_HPP_NOEXCEPT : CopyImageInfo2( *reinterpret_cast<CopyImageInfo2 const *>( &rhs ) ) {}

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    CopyImageInfo2( Image                                             srcImage_,
                    ImageLayout                                       srcImageLayout_,
                    Image                                             dstImage_,
                    ImageLayout                                       dstImageLayout_,
                    ArrayProxyNoTemporaries<const ImageCopy2> const & regions_,
                    const void *                                      pNext_ = nullptr )
      : pNext( pNext_ )
      , srcImage( srcImage_ )
      , srcImageLayout( srcImageLayout_ )
      , dstImage( dstImage_ )
      , dstImageLayout( dstImageLayout_ )
      , regionCount( static_cast<uint32_t>( regions_.size() ) )
      , pRegions( regions_.data() )
    {
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/

    CopyImageInfo2 & operator=( CopyImageInfo2 const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    CopyImageInfo2 & operator=( VkCopyImageInfo2 const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<CopyImageInfo2 const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 CopyImageInfo2 & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CopyImageInfo2 & setSrcImage( Image srcImage_ ) VULKAN_HPP_NOEXCEPT
    {
      srcImage = srcImage_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CopyImageInfo2 & setSrcImageLayout( ImageLayout srcImageLayout_ ) VULKAN_HPP_NOEXCEPT
    {
      srcImageLayout = srcImageLayout_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CopyImageInfo2 & setDstImage( Image dstImage_ ) VULKAN_HPP_NOEXCEPT
    {
      dstImage = dstImage_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CopyImageInfo2 & setDstImageLayout( ImageLayout dstImageLayout_ ) VULKAN_HPP_NOEXCEPT
    {
      dstImageLayout = dstImageLayout_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CopyImageInfo2 & setRegionCount( uint32_t regionCount_ ) VULKAN_HPP_NOEXCEPT
    {
      regionCount = regionCount_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CopyImageInfo2 & setPRegions( const ImageCopy2 * pRegions_ ) VULKAN_HPP_NOEXCEPT
    {
      pRegions = pRegions_;
      return *this;
    }

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    CopyImageInfo2 & setRegions( ArrayProxyNoTemporaries<const ImageCopy2> const & regions_ ) VULKAN_HPP_NOEXCEPT
    {
      regionCount = static_cast<uint32_t>( regions_.size() );
      pRegions    = regions_.data();
      return *this;
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/
#endif   /*VULKAN_HPP_NO_SETTERS*/

    operator VkCopyImageInfo2 const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkCopyImageInfo2 *>( this );
    }

    operator VkCopyImageInfo2 &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkCopyImageInfo2 *>( this );
    }

    operator VkCopyImageInfo2 const *() const VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<const VkCopyImageInfo2 *>( this );
    }

    operator VkCopyImageInfo2 *() VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<VkCopyImageInfo2 *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<StructureType const &,
               const void * const &,
               Image const &,
               ImageLayout const &,
               Image const &,
               ImageLayout const &,
               uint32_t const &,
               const ImageCopy2 * const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, srcImage, srcImageLayout, dstImage, dstImageLayout, regionCount, pRegions );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( CopyImageInfo2 const & ) const = default;
#else
    bool operator==( CopyImageInfo2 const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( srcImage == rhs.srcImage ) && ( srcImageLayout == rhs.srcImageLayout ) &&
             ( dstImage == rhs.dstImage ) && ( dstImageLayout == rhs.dstImageLayout ) && ( regionCount == rhs.regionCount ) && ( pRegions == rhs.pRegions );
#  endif
    }

    bool operator!=( CopyImageInfo2 const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    StructureType      sType          = StructureType::eCopyImageInfo2;
    const void *       pNext          = {};
    Image              srcImage       = {};
    ImageLayout        srcImageLayout = ImageLayout::eUndefined;
    Image              dstImage       = {};
    ImageLayout        dstImageLayout = ImageLayout::eUndefined;
    uint32_t           regionCount    = {};
    const ImageCopy2 * pRegions       = {};
  };

  template <>
  struct CppType<StructureType, StructureType::eCopyImageInfo2>
  {
    using Type = CopyImageInfo2;
  };

  using CopyImageInfo2KHR = CopyImageInfo2;

  // wrapper struct for struct VkCopyImageToBufferInfo2, see https://registry.khronos.org/vulkan/specs/latest/man/html/VkCopyImageToBufferInfo2.html
  struct CopyImageToBufferInfo2
  {
    using NativeType = VkCopyImageToBufferInfo2;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eCopyImageToBufferInfo2;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR CopyImageToBufferInfo2( Image                    srcImage_       = {},
                                                 ImageLayout              srcImageLayout_ = ImageLayout::eUndefined,
                                                 Buffer                   dstBuffer_      = {},
                                                 uint32_t                 regionCount_    = {},
                                                 const BufferImageCopy2 * pRegions_       = {},
                                                 const void *             pNext_          = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , srcImage{ srcImage_ }
      , srcImageLayout{ srcImageLayout_ }
      , dstBuffer{ dstBuffer_ }
      , regionCount{ regionCount_ }
      , pRegions{ pRegions_ }
    {
    }

    VULKAN_HPP_CONSTEXPR CopyImageToBufferInfo2( CopyImageToBufferInfo2 const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    CopyImageToBufferInfo2( VkCopyImageToBufferInfo2 const & rhs ) VULKAN_HPP_NOEXCEPT
      : CopyImageToBufferInfo2( *reinterpret_cast<CopyImageToBufferInfo2 const *>( &rhs ) )
    {
    }

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    CopyImageToBufferInfo2( Image                                                   srcImage_,
                            ImageLayout                                             srcImageLayout_,
                            Buffer                                                  dstBuffer_,
                            ArrayProxyNoTemporaries<const BufferImageCopy2> const & regions_,
                            const void *                                            pNext_ = nullptr )
      : pNext( pNext_ )
      , srcImage( srcImage_ )
      , srcImageLayout( srcImageLayout_ )
      , dstBuffer( dstBuffer_ )
      , regionCount( static_cast<uint32_t>( regions_.size() ) )
      , pRegions( regions_.data() )
    {
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/

    CopyImageToBufferInfo2 & operator=( CopyImageToBufferInfo2 const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    CopyImageToBufferInfo2 & operator=( VkCopyImageToBufferInfo2 const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<CopyImageToBufferInfo2 const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 CopyImageToBufferInfo2 & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CopyImageToBufferInfo2 & setSrcImage( Image srcImage_ ) VULKAN_HPP_NOEXCEPT
    {
      srcImage = srcImage_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CopyImageToBufferInfo2 & setSrcImageLayout( ImageLayout srcImageLayout_ ) VULKAN_HPP_NOEXCEPT
    {
      srcImageLayout = srcImageLayout_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CopyImageToBufferInfo2 & setDstBuffer( Buffer dstBuffer_ ) VULKAN_HPP_NOEXCEPT
    {
      dstBuffer = dstBuffer_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CopyImageToBufferInfo2 & setRegionCount( uint32_t regionCount_ ) VULKAN_HPP_NOEXCEPT
    {
      regionCount = regionCount_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CopyImageToBufferInfo2 & setPRegions( const BufferImageCopy2 * pRegions_ ) VULKAN_HPP_NOEXCEPT
    {
      pRegions = pRegions_;
      return *this;
    }

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    CopyImageToBufferInfo2 & setRegions( ArrayProxyNoTemporaries<const BufferImageCopy2> const & regions_ ) VULKAN_HPP_NOEXCEPT
    {
      regionCount = static_cast<uint32_t>( regions_.size() );
      pRegions    = regions_.data();
      return *this;
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/
#endif   /*VULKAN_HPP_NO_SETTERS*/

    operator VkCopyImageToBufferInfo2 const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkCopyImageToBufferInfo2 *>( this );
    }

    operator VkCopyImageToBufferInfo2 &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkCopyImageToBufferInfo2 *>( this );
    }

    operator VkCopyImageToBufferInfo2 const *() const VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<const VkCopyImageToBufferInfo2 *>( this );
    }

    operator VkCopyImageToBufferInfo2 *() VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<VkCopyImageToBufferInfo2 *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::
      tuple<StructureType const &, const void * const &, Image const &, ImageLayout const &, Buffer const &, uint32_t const &, const BufferImageCopy2 * const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, srcImage, srcImageLayout, dstBuffer, regionCount, pRegions );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( CopyImageToBufferInfo2 const & ) const = default;
#else
    bool operator==( CopyImageToBufferInfo2 const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( srcImage == rhs.srcImage ) && ( srcImageLayout == rhs.srcImageLayout ) &&
             ( dstBuffer == rhs.dstBuffer ) && ( regionCount == rhs.regionCount ) && ( pRegions == rhs.pRegions );
#  endif
    }

    bool operator!=( CopyImageToBufferInfo2 const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    StructureType            sType          = StructureType::eCopyImageToBufferInfo2;
    const void *             pNext          = {};
    Image                    srcImage       = {};
    ImageLayout              srcImageLayout = ImageLayout::eUndefined;
    Buffer                   dstBuffer      = {};
    uint32_t                 regionCount    = {};
    const BufferImageCopy2 * pRegions       = {};
  };

  template <>
  struct CppType<StructureType, StructureType::eCopyImageToBufferInfo2>
  {
    using Type = CopyImageToBufferInfo2;
  };

  using CopyImageToBufferInfo2KHR = CopyImageToBufferInfo2;

  // wrapper struct for struct VkCopyImageToImageInfo, see https://registry.khronos.org/vulkan/specs/latest/man/html/VkCopyImageToImageInfo.html
  struct CopyImageToImageInfo
  {
    using NativeType = VkCopyImageToImageInfo;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eCopyImageToImageInfo;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR CopyImageToImageInfo( HostImageCopyFlags flags_          = {},
                                               Image              srcImage_       = {},
                                               ImageLayout        srcImageLayout_ = ImageLayout::eUndefined,
                                               Image              dstImage_       = {},
                                               ImageLayout        dstImageLayout_ = ImageLayout::eUndefined,
                                               uint32_t           regionCount_    = {},
                                               const ImageCopy2 * pRegions_       = {},
                                               const void *       pNext_          = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , flags{ flags_ }
      , srcImage{ srcImage_ }
      , srcImageLayout{ srcImageLayout_ }
      , dstImage{ dstImage_ }
      , dstImageLayout{ dstImageLayout_ }
      , regionCount{ regionCount_ }
      , pRegions{ pRegions_ }
    {
    }

    VULKAN_HPP_CONSTEXPR CopyImageToImageInfo( CopyImageToImageInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    CopyImageToImageInfo( VkCopyImageToImageInfo const & rhs ) VULKAN_HPP_NOEXCEPT
      : CopyImageToImageInfo( *reinterpret_cast<CopyImageToImageInfo const *>( &rhs ) )
    {
    }

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    CopyImageToImageInfo( HostImageCopyFlags                                flags_,
                          Image                                             srcImage_,
                          ImageLayout                                       srcImageLayout_,
                          Image                                             dstImage_,
                          ImageLayout                                       dstImageLayout_,
                          ArrayProxyNoTemporaries<const ImageCopy2> const & regions_,
                          const void *                                      pNext_ = nullptr )
      : pNext( pNext_ )
      , flags( flags_ )
      , srcImage( srcImage_ )
      , srcImageLayout( srcImageLayout_ )
      , dstImage( dstImage_ )
      , dstImageLayout( dstImageLayout_ )
      , regionCount( static_cast<uint32_t>( regions_.size() ) )
      , pRegions( regions_.data() )
    {
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/

    CopyImageToImageInfo & operator=( CopyImageToImageInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    CopyImageToImageInfo & operator=( VkCopyImageToImageInfo const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<CopyImageToImageInfo const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 CopyImageToImageInfo & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CopyImageToImageInfo & setFlags( HostImageCopyFlags flags_ ) VULKAN_HPP_NOEXCEPT
    {
      flags = flags_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CopyImageToImageInfo & setSrcImage( Image srcImage_ ) VULKAN_HPP_NOEXCEPT
    {
      srcImage = srcImage_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CopyImageToImageInfo & setSrcImageLayout( ImageLayout srcImageLayout_ ) VULKAN_HPP_NOEXCEPT
    {
      srcImageLayout = srcImageLayout_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CopyImageToImageInfo & setDstImage( Image dstImage_ ) VULKAN_HPP_NOEXCEPT
    {
      dstImage = dstImage_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CopyImageToImageInfo & setDstImageLayout( ImageLayout dstImageLayout_ ) VULKAN_HPP_NOEXCEPT
    {
      dstImageLayout = dstImageLayout_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CopyImageToImageInfo & setRegionCount( uint32_t regionCount_ ) VULKAN_HPP_NOEXCEPT
    {
      regionCount = regionCount_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CopyImageToImageInfo & setPRegions( const ImageCopy2 * pRegions_ ) VULKAN_HPP_NOEXCEPT
    {
      pRegions = pRegions_;
      return *this;
    }

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    CopyImageToImageInfo & setRegions( ArrayProxyNoTemporaries<const ImageCopy2> const & regions_ ) VULKAN_HPP_NOEXCEPT
    {
      regionCount = static_cast<uint32_t>( regions_.size() );
      pRegions    = regions_.data();
      return *this;
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/
#endif   /*VULKAN_HPP_NO_SETTERS*/

    operator VkCopyImageToImageInfo const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkCopyImageToImageInfo *>( this );
    }

    operator VkCopyImageToImageInfo &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkCopyImageToImageInfo *>( this );
    }

    operator VkCopyImageToImageInfo const *() const VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<const VkCopyImageToImageInfo *>( this );
    }

    operator VkCopyImageToImageInfo *() VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<VkCopyImageToImageInfo *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<StructureType const &,
               const void * const &,
               HostImageCopyFlags const &,
               Image const &,
               ImageLayout const &,
               Image const &,
               ImageLayout const &,
               uint32_t const &,
               const ImageCopy2 * const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, flags, srcImage, srcImageLayout, dstImage, dstImageLayout, regionCount, pRegions );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( CopyImageToImageInfo const & ) const = default;
#else
    bool operator==( CopyImageToImageInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( flags == rhs.flags ) && ( srcImage == rhs.srcImage ) &&
             ( srcImageLayout == rhs.srcImageLayout ) && ( dstImage == rhs.dstImage ) && ( dstImageLayout == rhs.dstImageLayout ) &&
             ( regionCount == rhs.regionCount ) && ( pRegions == rhs.pRegions );
#  endif
    }

    bool operator!=( CopyImageToImageInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    StructureType      sType          = StructureType::eCopyImageToImageInfo;
    const void *       pNext          = {};
    HostImageCopyFlags flags          = {};
    Image              srcImage       = {};
    ImageLayout        srcImageLayout = ImageLayout::eUndefined;
    Image              dstImage       = {};
    ImageLayout        dstImageLayout = ImageLayout::eUndefined;
    uint32_t           regionCount    = {};
    const ImageCopy2 * pRegions       = {};
  };

  template <>
  struct CppType<StructureType, StructureType::eCopyImageToImageInfo>
  {
    using Type = CopyImageToImageInfo;
  };

  using CopyImageToImageInfoEXT = CopyImageToImageInfo;

  // wrapper struct for struct VkImageToMemoryCopy, see https://registry.khronos.org/vulkan/specs/latest/man/html/VkImageToMemoryCopy.html
  struct ImageToMemoryCopy
  {
    using NativeType = VkImageToMemoryCopy;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eImageToMemoryCopy;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR ImageToMemoryCopy( void *                 pHostPointer_      = {},
                                            uint32_t               memoryRowLength_   = {},
                                            uint32_t               memoryImageHeight_ = {},
                                            ImageSubresourceLayers imageSubresource_  = {},
                                            Offset3D               imageOffset_       = {},
                                            Extent3D               imageExtent_       = {},
                                            const void *           pNext_             = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , pHostPointer{ pHostPointer_ }
      , memoryRowLength{ memoryRowLength_ }
      , memoryImageHeight{ memoryImageHeight_ }
      , imageSubresource{ imageSubresource_ }
      , imageOffset{ imageOffset_ }
      , imageExtent{ imageExtent_ }
    {
    }

    VULKAN_HPP_CONSTEXPR ImageToMemoryCopy( ImageToMemoryCopy const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    ImageToMemoryCopy( VkImageToMemoryCopy const & rhs ) VULKAN_HPP_NOEXCEPT : ImageToMemoryCopy( *reinterpret_cast<ImageToMemoryCopy const *>( &rhs ) ) {}

    ImageToMemoryCopy & operator=( ImageToMemoryCopy const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    ImageToMemoryCopy & operator=( VkImageToMemoryCopy const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<ImageToMemoryCopy const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 ImageToMemoryCopy & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ImageToMemoryCopy & setPHostPointer( void * pHostPointer_ ) VULKAN_HPP_NOEXCEPT
    {
      pHostPointer = pHostPointer_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ImageToMemoryCopy & setMemoryRowLength( uint32_t memoryRowLength_ ) VULKAN_HPP_NOEXCEPT
    {
      memoryRowLength = memoryRowLength_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ImageToMemoryCopy & setMemoryImageHeight( uint32_t memoryImageHeight_ ) VULKAN_HPP_NOEXCEPT
    {
      memoryImageHeight = memoryImageHeight_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ImageToMemoryCopy & setImageSubresource( ImageSubresourceLayers const & imageSubresource_ ) VULKAN_HPP_NOEXCEPT
    {
      imageSubresource = imageSubresource_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ImageToMemoryCopy & setImageOffset( Offset3D const & imageOffset_ ) VULKAN_HPP_NOEXCEPT
    {
      imageOffset = imageOffset_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 ImageToMemoryCopy & setImageExtent( Extent3D const & imageExtent_ ) VULKAN_HPP_NOEXCEPT
    {
      imageExtent = imageExtent_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_SETTERS*/

    operator VkImageToMemoryCopy const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkImageToMemoryCopy *>( this );
    }

    operator VkImageToMemoryCopy &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkImageToMemoryCopy *>( this );
    }

    operator VkImageToMemoryCopy const *() const VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<const VkImageToMemoryCopy *>( this );
    }

    operator VkImageToMemoryCopy *() VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<VkImageToMemoryCopy *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<StructureType const &,
               const void * const &,
               void * const &,
               uint32_t const &,
               uint32_t const &,
               ImageSubresourceLayers const &,
               Offset3D const &,
               Extent3D const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, pHostPointer, memoryRowLength, memoryImageHeight, imageSubresource, imageOffset, imageExtent );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( ImageToMemoryCopy const & ) const = default;
#else
    bool operator==( ImageToMemoryCopy const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( pHostPointer == rhs.pHostPointer ) && ( memoryRowLength == rhs.memoryRowLength ) &&
             ( memoryImageHeight == rhs.memoryImageHeight ) && ( imageSubresource == rhs.imageSubresource ) && ( imageOffset == rhs.imageOffset ) &&
             ( imageExtent == rhs.imageExtent );
#  endif
    }

    bool operator!=( ImageToMemoryCopy const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    StructureType          sType             = StructureType::eImageToMemoryCopy;
    const void *           pNext             = {};
    void *                 pHostPointer      = {};
    uint32_t               memoryRowLength   = {};
    uint32_t               memoryImageHeight = {};
    ImageSubresourceLayers imageSubresource  = {};
    Offset3D               imageOffset       = {};
    Extent3D               imageExtent       = {};
  };

  template <>
  struct CppType<StructureType, StructureType::eImageToMemoryCopy>
  {
    using Type = ImageToMemoryCopy;
  };

  using ImageToMemoryCopyEXT = ImageToMemoryCopy;

  // wrapper struct for struct VkCopyImageToMemoryInfo, see https://registry.khronos.org/vulkan/specs/latest/man/html/VkCopyImageToMemoryInfo.html
  struct CopyImageToMemoryInfo
  {
    using NativeType = VkCopyImageToMemoryInfo;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eCopyImageToMemoryInfo;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR CopyImageToMemoryInfo( HostImageCopyFlags        flags_          = {},
                                                Image                     srcImage_       = {},
                                                ImageLayout               srcImageLayout_ = ImageLayout::eUndefined,
                                                uint32_t                  regionCount_    = {},
                                                const ImageToMemoryCopy * pRegions_       = {},
                                                const void *              pNext_          = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , flags{ flags_ }
      , srcImage{ srcImage_ }
      , srcImageLayout{ srcImageLayout_ }
      , regionCount{ regionCount_ }
      , pRegions{ pRegions_ }
    {
    }

    VULKAN_HPP_CONSTEXPR CopyImageToMemoryInfo( CopyImageToMemoryInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    CopyImageToMemoryInfo( VkCopyImageToMemoryInfo const & rhs ) VULKAN_HPP_NOEXCEPT
      : CopyImageToMemoryInfo( *reinterpret_cast<CopyImageToMemoryInfo const *>( &rhs ) )
    {
    }

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    CopyImageToMemoryInfo( HostImageCopyFlags                                       flags_,
                           Image                                                    srcImage_,
                           ImageLayout                                              srcImageLayout_,
                           ArrayProxyNoTemporaries<const ImageToMemoryCopy> const & regions_,
                           const void *                                             pNext_ = nullptr )
      : pNext( pNext_ )
      , flags( flags_ )
      , srcImage( srcImage_ )
      , srcImageLayout( srcImageLayout_ )
      , regionCount( static_cast<uint32_t>( regions_.size() ) )
      , pRegions( regions_.data() )
    {
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/

    CopyImageToMemoryInfo & operator=( CopyImageToMemoryInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    CopyImageToMemoryInfo & operator=( VkCopyImageToMemoryInfo const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<CopyImageToMemoryInfo const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 CopyImageToMemoryInfo & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CopyImageToMemoryInfo & setFlags( HostImageCopyFlags flags_ ) VULKAN_HPP_NOEXCEPT
    {
      flags = flags_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CopyImageToMemoryInfo & setSrcImage( Image srcImage_ ) VULKAN_HPP_NOEXCEPT
    {
      srcImage = srcImage_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CopyImageToMemoryInfo & setSrcImageLayout( ImageLayout srcImageLayout_ ) VULKAN_HPP_NOEXCEPT
    {
      srcImageLayout = srcImageLayout_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CopyImageToMemoryInfo & setRegionCount( uint32_t regionCount_ ) VULKAN_HPP_NOEXCEPT
    {
      regionCount = regionCount_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CopyImageToMemoryInfo & setPRegions( const ImageToMemoryCopy * pRegions_ ) VULKAN_HPP_NOEXCEPT
    {
      pRegions = pRegions_;
      return *this;
    }

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    CopyImageToMemoryInfo & setRegions( ArrayProxyNoTemporaries<const ImageToMemoryCopy> const & regions_ ) VULKAN_HPP_NOEXCEPT
    {
      regionCount = static_cast<uint32_t>( regions_.size() );
      pRegions    = regions_.data();
      return *this;
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/
#endif   /*VULKAN_HPP_NO_SETTERS*/

    operator VkCopyImageToMemoryInfo const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkCopyImageToMemoryInfo *>( this );
    }

    operator VkCopyImageToMemoryInfo &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkCopyImageToMemoryInfo *>( this );
    }

    operator VkCopyImageToMemoryInfo const *() const VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<const VkCopyImageToMemoryInfo *>( this );
    }

    operator VkCopyImageToMemoryInfo *() VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<VkCopyImageToMemoryInfo *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<StructureType const &,
               const void * const &,
               HostImageCopyFlags const &,
               Image const &,
               ImageLayout const &,
               uint32_t const &,
               const ImageToMemoryCopy * const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, flags, srcImage, srcImageLayout, regionCount, pRegions );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( CopyImageToMemoryInfo const & ) const = default;
#else
    bool operator==( CopyImageToMemoryInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( flags == rhs.flags ) && ( srcImage == rhs.srcImage ) &&
             ( srcImageLayout == rhs.srcImageLayout ) && ( regionCount == rhs.regionCount ) && ( pRegions == rhs.pRegions );
#  endif
    }

    bool operator!=( CopyImageToMemoryInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    StructureType             sType          = StructureType::eCopyImageToMemoryInfo;
    const void *              pNext          = {};
    HostImageCopyFlags        flags          = {};
    Image                     srcImage       = {};
    ImageLayout               srcImageLayout = ImageLayout::eUndefined;
    uint32_t                  regionCount    = {};
    const ImageToMemoryCopy * pRegions       = {};
  };

  template <>
  struct CppType<StructureType, StructureType::eCopyImageToMemoryInfo>
  {
    using Type = CopyImageToMemoryInfo;
  };

  using CopyImageToMemoryInfoEXT = CopyImageToMemoryInfo;

  // wrapper struct for struct VkCopyMemoryIndirectCommandNV, see https://registry.khronos.org/vulkan/specs/latest/man/html/VkCopyMemoryIndirectCommandNV.html
  struct CopyMemoryIndirectCommandNV
  {
    using NativeType = VkCopyMemoryIndirectCommandNV;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR
      CopyMemoryIndirectCommandNV( DeviceAddress srcAddress_ = {}, DeviceAddress dstAddress_ = {}, DeviceSize size_ = {} ) VULKAN_HPP_NOEXCEPT
      : srcAddress{ srcAddress_ }
      , dstAddress{ dstAddress_ }
      , size{ size_ }
    {
    }

    VULKAN_HPP_CONSTEXPR CopyMemoryIndirectCommandNV( CopyMemoryIndirectCommandNV const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    CopyMemoryIndirectCommandNV( VkCopyMemoryIndirectCommandNV const & rhs ) VULKAN_HPP_NOEXCEPT
      : CopyMemoryIndirectCommandNV( *reinterpret_cast<CopyMemoryIndirectCommandNV const *>( &rhs ) )
    {
    }

    CopyMemoryIndirectCommandNV & operator=( CopyMemoryIndirectCommandNV const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    CopyMemoryIndirectCommandNV & operator=( VkCopyMemoryIndirectCommandNV const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<CopyMemoryIndirectCommandNV const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 CopyMemoryIndirectCommandNV & setSrcAddress( DeviceAddress srcAddress_ ) VULKAN_HPP_NOEXCEPT
    {
      srcAddress = srcAddress_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CopyMemoryIndirectCommandNV & setDstAddress( DeviceAddress dstAddress_ ) VULKAN_HPP_NOEXCEPT
    {
      dstAddress = dstAddress_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CopyMemoryIndirectCommandNV & setSize( DeviceSize size_ ) VULKAN_HPP_NOEXCEPT
    {
      size = size_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_SETTERS*/

    operator VkCopyMemoryIndirectCommandNV const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkCopyMemoryIndirectCommandNV *>( this );
    }

    operator VkCopyMemoryIndirectCommandNV &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkCopyMemoryIndirectCommandNV *>( this );
    }

    operator VkCopyMemoryIndirectCommandNV const *() const VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<const VkCopyMemoryIndirectCommandNV *>( this );
    }

    operator VkCopyMemoryIndirectCommandNV *() VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<VkCopyMemoryIndirectCommandNV *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<DeviceAddress const &, DeviceAddress const &, DeviceSize const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( srcAddress, dstAddress, size );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( CopyMemoryIndirectCommandNV const & ) const = default;
#else
    bool operator==( CopyMemoryIndirectCommandNV const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( srcAddress == rhs.srcAddress ) && ( dstAddress == rhs.dstAddress ) && ( size == rhs.size );
#  endif
    }

    bool operator!=( CopyMemoryIndirectCommandNV const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    DeviceAddress srcAddress = {};
    DeviceAddress dstAddress = {};
    DeviceSize    size       = {};
  };

  // wrapper struct for struct VkCopyMemoryToAccelerationStructureInfoKHR, see
  // https://registry.khronos.org/vulkan/specs/latest/man/html/VkCopyMemoryToAccelerationStructureInfoKHR.html
  struct CopyMemoryToAccelerationStructureInfoKHR
  {
    using NativeType = VkCopyMemoryToAccelerationStructureInfoKHR;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eCopyMemoryToAccelerationStructureInfoKHR;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR_14 CopyMemoryToAccelerationStructureInfoKHR( DeviceOrHostAddressConstKHR      src_   = {},
                                                                      AccelerationStructureKHR         dst_   = {},
                                                                      CopyAccelerationStructureModeKHR mode_  = CopyAccelerationStructureModeKHR::eClone,
                                                                      const void *                     pNext_ = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , src{ src_ }
      , dst{ dst_ }
      , mode{ mode_ }
    {
    }

    VULKAN_HPP_CONSTEXPR_14 CopyMemoryToAccelerationStructureInfoKHR( CopyMemoryToAccelerationStructureInfoKHR const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    CopyMemoryToAccelerationStructureInfoKHR( VkCopyMemoryToAccelerationStructureInfoKHR const & rhs ) VULKAN_HPP_NOEXCEPT
      : CopyMemoryToAccelerationStructureInfoKHR( *reinterpret_cast<CopyMemoryToAccelerationStructureInfoKHR const *>( &rhs ) )
    {
    }

    CopyMemoryToAccelerationStructureInfoKHR & operator=( CopyMemoryToAccelerationStructureInfoKHR const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    CopyMemoryToAccelerationStructureInfoKHR & operator=( VkCopyMemoryToAccelerationStructureInfoKHR const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<CopyMemoryToAccelerationStructureInfoKHR const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 CopyMemoryToAccelerationStructureInfoKHR & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CopyMemoryToAccelerationStructureInfoKHR & setSrc( DeviceOrHostAddressConstKHR const & src_ ) VULKAN_HPP_NOEXCEPT
    {
      src = src_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CopyMemoryToAccelerationStructureInfoKHR & setDst( AccelerationStructureKHR dst_ ) VULKAN_HPP_NOEXCEPT
    {
      dst = dst_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CopyMemoryToAccelerationStructureInfoKHR & setMode( CopyAccelerationStructureModeKHR mode_ ) VULKAN_HPP_NOEXCEPT
    {
      mode = mode_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_SETTERS*/

    operator VkCopyMemoryToAccelerationStructureInfoKHR const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkCopyMemoryToAccelerationStructureInfoKHR *>( this );
    }

    operator VkCopyMemoryToAccelerationStructureInfoKHR &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkCopyMemoryToAccelerationStructureInfoKHR *>( this );
    }

    operator VkCopyMemoryToAccelerationStructureInfoKHR const *() const VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<const VkCopyMemoryToAccelerationStructureInfoKHR *>( this );
    }

    operator VkCopyMemoryToAccelerationStructureInfoKHR *() VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<VkCopyMemoryToAccelerationStructureInfoKHR *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<StructureType const &,
               const void * const &,
               DeviceOrHostAddressConstKHR const &,
               AccelerationStructureKHR const &,
               CopyAccelerationStructureModeKHR const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, src, dst, mode );
    }
#endif

  public:
    StructureType                    sType = StructureType::eCopyMemoryToAccelerationStructureInfoKHR;
    const void *                     pNext = {};
    DeviceOrHostAddressConstKHR      src   = {};
    AccelerationStructureKHR         dst   = {};
    CopyAccelerationStructureModeKHR mode  = CopyAccelerationStructureModeKHR::eClone;
  };

  template <>
  struct CppType<StructureType, StructureType::eCopyMemoryToAccelerationStructureInfoKHR>
  {
    using Type = CopyMemoryToAccelerationStructureInfoKHR;
  };

  // wrapper struct for struct VkCopyMemoryToImageIndirectCommandNV, see
  // https://registry.khronos.org/vulkan/specs/latest/man/html/VkCopyMemoryToImageIndirectCommandNV.html
  struct CopyMemoryToImageIndirectCommandNV
  {
    using NativeType = VkCopyMemoryToImageIndirectCommandNV;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR CopyMemoryToImageIndirectCommandNV( DeviceAddress          srcAddress_        = {},
                                                             uint32_t               bufferRowLength_   = {},
                                                             uint32_t               bufferImageHeight_ = {},
                                                             ImageSubresourceLayers imageSubresource_  = {},
                                                             Offset3D               imageOffset_       = {},
                                                             Extent3D               imageExtent_       = {} ) VULKAN_HPP_NOEXCEPT
      : srcAddress{ srcAddress_ }
      , bufferRowLength{ bufferRowLength_ }
      , bufferImageHeight{ bufferImageHeight_ }
      , imageSubresource{ imageSubresource_ }
      , imageOffset{ imageOffset_ }
      , imageExtent{ imageExtent_ }
    {
    }

    VULKAN_HPP_CONSTEXPR CopyMemoryToImageIndirectCommandNV( CopyMemoryToImageIndirectCommandNV const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    CopyMemoryToImageIndirectCommandNV( VkCopyMemoryToImageIndirectCommandNV const & rhs ) VULKAN_HPP_NOEXCEPT
      : CopyMemoryToImageIndirectCommandNV( *reinterpret_cast<CopyMemoryToImageIndirectCommandNV const *>( &rhs ) )
    {
    }

    CopyMemoryToImageIndirectCommandNV & operator=( CopyMemoryToImageIndirectCommandNV const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    CopyMemoryToImageIndirectCommandNV & operator=( VkCopyMemoryToImageIndirectCommandNV const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<CopyMemoryToImageIndirectCommandNV const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 CopyMemoryToImageIndirectCommandNV & setSrcAddress( DeviceAddress srcAddress_ ) VULKAN_HPP_NOEXCEPT
    {
      srcAddress = srcAddress_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CopyMemoryToImageIndirectCommandNV & setBufferRowLength( uint32_t bufferRowLength_ ) VULKAN_HPP_NOEXCEPT
    {
      bufferRowLength = bufferRowLength_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CopyMemoryToImageIndirectCommandNV & setBufferImageHeight( uint32_t bufferImageHeight_ ) VULKAN_HPP_NOEXCEPT
    {
      bufferImageHeight = bufferImageHeight_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CopyMemoryToImageIndirectCommandNV & setImageSubresource( ImageSubresourceLayers const & imageSubresource_ ) VULKAN_HPP_NOEXCEPT
    {
      imageSubresource = imageSubresource_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CopyMemoryToImageIndirectCommandNV & setImageOffset( Offset3D const & imageOffset_ ) VULKAN_HPP_NOEXCEPT
    {
      imageOffset = imageOffset_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CopyMemoryToImageIndirectCommandNV & setImageExtent( Extent3D const & imageExtent_ ) VULKAN_HPP_NOEXCEPT
    {
      imageExtent = imageExtent_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_SETTERS*/

    operator VkCopyMemoryToImageIndirectCommandNV const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkCopyMemoryToImageIndirectCommandNV *>( this );
    }

    operator VkCopyMemoryToImageIndirectCommandNV &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkCopyMemoryToImageIndirectCommandNV *>( this );
    }

    operator VkCopyMemoryToImageIndirectCommandNV const *() const VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<const VkCopyMemoryToImageIndirectCommandNV *>( this );
    }

    operator VkCopyMemoryToImageIndirectCommandNV *() VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<VkCopyMemoryToImageIndirectCommandNV *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<DeviceAddress const &, uint32_t const &, uint32_t const &, ImageSubresourceLayers const &, Offset3D const &, Extent3D const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( srcAddress, bufferRowLength, bufferImageHeight, imageSubresource, imageOffset, imageExtent );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( CopyMemoryToImageIndirectCommandNV const & ) const = default;
#else
    bool operator==( CopyMemoryToImageIndirectCommandNV const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( srcAddress == rhs.srcAddress ) && ( bufferRowLength == rhs.bufferRowLength ) && ( bufferImageHeight == rhs.bufferImageHeight ) &&
             ( imageSubresource == rhs.imageSubresource ) && ( imageOffset == rhs.imageOffset ) && ( imageExtent == rhs.imageExtent );
#  endif
    }

    bool operator!=( CopyMemoryToImageIndirectCommandNV const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    DeviceAddress          srcAddress        = {};
    uint32_t               bufferRowLength   = {};
    uint32_t               bufferImageHeight = {};
    ImageSubresourceLayers imageSubresource  = {};
    Offset3D               imageOffset       = {};
    Extent3D               imageExtent       = {};
  };

  // wrapper struct for struct VkMemoryToImageCopy, see https://registry.khronos.org/vulkan/specs/latest/man/html/VkMemoryToImageCopy.html
  struct MemoryToImageCopy
  {
    using NativeType = VkMemoryToImageCopy;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eMemoryToImageCopy;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR MemoryToImageCopy( const void *           pHostPointer_      = {},
                                            uint32_t               memoryRowLength_   = {},
                                            uint32_t               memoryImageHeight_ = {},
                                            ImageSubresourceLayers imageSubresource_  = {},
                                            Offset3D               imageOffset_       = {},
                                            Extent3D               imageExtent_       = {},
                                            const void *           pNext_             = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , pHostPointer{ pHostPointer_ }
      , memoryRowLength{ memoryRowLength_ }
      , memoryImageHeight{ memoryImageHeight_ }
      , imageSubresource{ imageSubresource_ }
      , imageOffset{ imageOffset_ }
      , imageExtent{ imageExtent_ }
    {
    }

    VULKAN_HPP_CONSTEXPR MemoryToImageCopy( MemoryToImageCopy const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    MemoryToImageCopy( VkMemoryToImageCopy const & rhs ) VULKAN_HPP_NOEXCEPT : MemoryToImageCopy( *reinterpret_cast<MemoryToImageCopy const *>( &rhs ) ) {}

    MemoryToImageCopy & operator=( MemoryToImageCopy const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    MemoryToImageCopy & operator=( VkMemoryToImageCopy const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<MemoryToImageCopy const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 MemoryToImageCopy & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 MemoryToImageCopy & setPHostPointer( const void * pHostPointer_ ) VULKAN_HPP_NOEXCEPT
    {
      pHostPointer = pHostPointer_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 MemoryToImageCopy & setMemoryRowLength( uint32_t memoryRowLength_ ) VULKAN_HPP_NOEXCEPT
    {
      memoryRowLength = memoryRowLength_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 MemoryToImageCopy & setMemoryImageHeight( uint32_t memoryImageHeight_ ) VULKAN_HPP_NOEXCEPT
    {
      memoryImageHeight = memoryImageHeight_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 MemoryToImageCopy & setImageSubresource( ImageSubresourceLayers const & imageSubresource_ ) VULKAN_HPP_NOEXCEPT
    {
      imageSubresource = imageSubresource_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 MemoryToImageCopy & setImageOffset( Offset3D const & imageOffset_ ) VULKAN_HPP_NOEXCEPT
    {
      imageOffset = imageOffset_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 MemoryToImageCopy & setImageExtent( Extent3D const & imageExtent_ ) VULKAN_HPP_NOEXCEPT
    {
      imageExtent = imageExtent_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_SETTERS*/

    operator VkMemoryToImageCopy const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkMemoryToImageCopy *>( this );
    }

    operator VkMemoryToImageCopy &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkMemoryToImageCopy *>( this );
    }

    operator VkMemoryToImageCopy const *() const VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<const VkMemoryToImageCopy *>( this );
    }

    operator VkMemoryToImageCopy *() VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<VkMemoryToImageCopy *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<StructureType const &,
               const void * const &,
               const void * const &,
               uint32_t const &,
               uint32_t const &,
               ImageSubresourceLayers const &,
               Offset3D const &,
               Extent3D const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, pHostPointer, memoryRowLength, memoryImageHeight, imageSubresource, imageOffset, imageExtent );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( MemoryToImageCopy const & ) const = default;
#else
    bool operator==( MemoryToImageCopy const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( pHostPointer == rhs.pHostPointer ) && ( memoryRowLength == rhs.memoryRowLength ) &&
             ( memoryImageHeight == rhs.memoryImageHeight ) && ( imageSubresource == rhs.imageSubresource ) && ( imageOffset == rhs.imageOffset ) &&
             ( imageExtent == rhs.imageExtent );
#  endif
    }

    bool operator!=( MemoryToImageCopy const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    StructureType          sType             = StructureType::eMemoryToImageCopy;
    const void *           pNext             = {};
    const void *           pHostPointer      = {};
    uint32_t               memoryRowLength   = {};
    uint32_t               memoryImageHeight = {};
    ImageSubresourceLayers imageSubresource  = {};
    Offset3D               imageOffset       = {};
    Extent3D               imageExtent       = {};
  };

  template <>
  struct CppType<StructureType, StructureType::eMemoryToImageCopy>
  {
    using Type = MemoryToImageCopy;
  };

  using MemoryToImageCopyEXT = MemoryToImageCopy;

  // wrapper struct for struct VkCopyMemoryToImageInfo, see https://registry.khronos.org/vulkan/specs/latest/man/html/VkCopyMemoryToImageInfo.html
  struct CopyMemoryToImageInfo
  {
    using NativeType = VkCopyMemoryToImageInfo;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eCopyMemoryToImageInfo;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR CopyMemoryToImageInfo( HostImageCopyFlags        flags_          = {},
                                                Image                     dstImage_       = {},
                                                ImageLayout               dstImageLayout_ = ImageLayout::eUndefined,
                                                uint32_t                  regionCount_    = {},
                                                const MemoryToImageCopy * pRegions_       = {},
                                                const void *              pNext_          = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , flags{ flags_ }
      , dstImage{ dstImage_ }
      , dstImageLayout{ dstImageLayout_ }
      , regionCount{ regionCount_ }
      , pRegions{ pRegions_ }
    {
    }

    VULKAN_HPP_CONSTEXPR CopyMemoryToImageInfo( CopyMemoryToImageInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    CopyMemoryToImageInfo( VkCopyMemoryToImageInfo const & rhs ) VULKAN_HPP_NOEXCEPT
      : CopyMemoryToImageInfo( *reinterpret_cast<CopyMemoryToImageInfo const *>( &rhs ) )
    {
    }

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    CopyMemoryToImageInfo( HostImageCopyFlags                                       flags_,
                           Image                                                    dstImage_,
                           ImageLayout                                              dstImageLayout_,
                           ArrayProxyNoTemporaries<const MemoryToImageCopy> const & regions_,
                           const void *                                             pNext_ = nullptr )
      : pNext( pNext_ )
      , flags( flags_ )
      , dstImage( dstImage_ )
      , dstImageLayout( dstImageLayout_ )
      , regionCount( static_cast<uint32_t>( regions_.size() ) )
      , pRegions( regions_.data() )
    {
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/

    CopyMemoryToImageInfo & operator=( CopyMemoryToImageInfo const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    CopyMemoryToImageInfo & operator=( VkCopyMemoryToImageInfo const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<CopyMemoryToImageInfo const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 CopyMemoryToImageInfo & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CopyMemoryToImageInfo & setFlags( HostImageCopyFlags flags_ ) VULKAN_HPP_NOEXCEPT
    {
      flags = flags_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CopyMemoryToImageInfo & setDstImage( Image dstImage_ ) VULKAN_HPP_NOEXCEPT
    {
      dstImage = dstImage_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CopyMemoryToImageInfo & setDstImageLayout( ImageLayout dstImageLayout_ ) VULKAN_HPP_NOEXCEPT
    {
      dstImageLayout = dstImageLayout_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CopyMemoryToImageInfo & setRegionCount( uint32_t regionCount_ ) VULKAN_HPP_NOEXCEPT
    {
      regionCount = regionCount_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CopyMemoryToImageInfo & setPRegions( const MemoryToImageCopy * pRegions_ ) VULKAN_HPP_NOEXCEPT
    {
      pRegions = pRegions_;
      return *this;
    }

#  if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
    CopyMemoryToImageInfo & setRegions( ArrayProxyNoTemporaries<const MemoryToImageCopy> const & regions_ ) VULKAN_HPP_NOEXCEPT
    {
      regionCount = static_cast<uint32_t>( regions_.size() );
      pRegions    = regions_.data();
      return *this;
    }
#  endif /*VULKAN_HPP_DISABLE_ENHANCED_MODE*/
#endif   /*VULKAN_HPP_NO_SETTERS*/

    operator VkCopyMemoryToImageInfo const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkCopyMemoryToImageInfo *>( this );
    }

    operator VkCopyMemoryToImageInfo &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkCopyMemoryToImageInfo *>( this );
    }

    operator VkCopyMemoryToImageInfo const *() const VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<const VkCopyMemoryToImageInfo *>( this );
    }

    operator VkCopyMemoryToImageInfo *() VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<VkCopyMemoryToImageInfo *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<StructureType const &,
               const void * const &,
               HostImageCopyFlags const &,
               Image const &,
               ImageLayout const &,
               uint32_t const &,
               const MemoryToImageCopy * const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, flags, dstImage, dstImageLayout, regionCount, pRegions );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( CopyMemoryToImageInfo const & ) const = default;
#else
    bool operator==( CopyMemoryToImageInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( flags == rhs.flags ) && ( dstImage == rhs.dstImage ) &&
             ( dstImageLayout == rhs.dstImageLayout ) && ( regionCount == rhs.regionCount ) && ( pRegions == rhs.pRegions );
#  endif
    }

    bool operator!=( CopyMemoryToImageInfo const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    StructureType             sType          = StructureType::eCopyMemoryToImageInfo;
    const void *              pNext          = {};
    HostImageCopyFlags        flags          = {};
    Image                     dstImage       = {};
    ImageLayout               dstImageLayout = ImageLayout::eUndefined;
    uint32_t                  regionCount    = {};
    const MemoryToImageCopy * pRegions       = {};
  };

  template <>
  struct CppType<StructureType, StructureType::eCopyMemoryToImageInfo>
  {
    using Type = CopyMemoryToImageInfo;
  };

  using CopyMemoryToImageInfoEXT = CopyMemoryToImageInfo;

  // wrapper struct for struct VkCopyMemoryToMicromapInfoEXT, see https://registry.khronos.org/vulkan/specs/latest/man/html/VkCopyMemoryToMicromapInfoEXT.html
  struct CopyMemoryToMicromapInfoEXT
  {
    using NativeType = VkCopyMemoryToMicromapInfoEXT;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eCopyMemoryToMicromapInfoEXT;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR_14 CopyMemoryToMicromapInfoEXT( DeviceOrHostAddressConstKHR src_   = {},
                                                         MicromapEXT                 dst_   = {},
                                                         CopyMicromapModeEXT         mode_  = CopyMicromapModeEXT::eClone,
                                                         const void *                pNext_ = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , src{ src_ }
      , dst{ dst_ }
      , mode{ mode_ }
    {
    }

    VULKAN_HPP_CONSTEXPR_14 CopyMemoryToMicromapInfoEXT( CopyMemoryToMicromapInfoEXT const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    CopyMemoryToMicromapInfoEXT( VkCopyMemoryToMicromapInfoEXT const & rhs ) VULKAN_HPP_NOEXCEPT
      : CopyMemoryToMicromapInfoEXT( *reinterpret_cast<CopyMemoryToMicromapInfoEXT const *>( &rhs ) )
    {
    }

    CopyMemoryToMicromapInfoEXT & operator=( CopyMemoryToMicromapInfoEXT const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    CopyMemoryToMicromapInfoEXT & operator=( VkCopyMemoryToMicromapInfoEXT const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<CopyMemoryToMicromapInfoEXT const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 CopyMemoryToMicromapInfoEXT & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CopyMemoryToMicromapInfoEXT & setSrc( DeviceOrHostAddressConstKHR const & src_ ) VULKAN_HPP_NOEXCEPT
    {
      src = src_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CopyMemoryToMicromapInfoEXT & setDst( MicromapEXT dst_ ) VULKAN_HPP_NOEXCEPT
    {
      dst = dst_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CopyMemoryToMicromapInfoEXT & setMode( CopyMicromapModeEXT mode_ ) VULKAN_HPP_NOEXCEPT
    {
      mode = mode_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_SETTERS*/

    operator VkCopyMemoryToMicromapInfoEXT const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkCopyMemoryToMicromapInfoEXT *>( this );
    }

    operator VkCopyMemoryToMicromapInfoEXT &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkCopyMemoryToMicromapInfoEXT *>( this );
    }

    operator VkCopyMemoryToMicromapInfoEXT const *() const VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<const VkCopyMemoryToMicromapInfoEXT *>( this );
    }

    operator VkCopyMemoryToMicromapInfoEXT *() VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<VkCopyMemoryToMicromapInfoEXT *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<StructureType const &, const void * const &, DeviceOrHostAddressConstKHR const &, MicromapEXT const &, CopyMicromapModeEXT const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, src, dst, mode );
    }
#endif

  public:
    StructureType               sType = StructureType::eCopyMemoryToMicromapInfoEXT;
    const void *                pNext = {};
    DeviceOrHostAddressConstKHR src   = {};
    MicromapEXT                 dst   = {};
    CopyMicromapModeEXT         mode  = CopyMicromapModeEXT::eClone;
  };

  template <>
  struct CppType<StructureType, StructureType::eCopyMemoryToMicromapInfoEXT>
  {
    using Type = CopyMemoryToMicromapInfoEXT;
  };

  // wrapper struct for struct VkCopyMicromapInfoEXT, see https://registry.khronos.org/vulkan/specs/latest/man/html/VkCopyMicromapInfoEXT.html
  struct CopyMicromapInfoEXT
  {
    using NativeType = VkCopyMicromapInfoEXT;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eCopyMicromapInfoEXT;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR CopyMicromapInfoEXT( MicromapEXT         src_   = {},
                                              MicromapEXT         dst_   = {},
                                              CopyMicromapModeEXT mode_  = CopyMicromapModeEXT::eClone,
                                              const void *        pNext_ = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , src{ src_ }
      , dst{ dst_ }
      , mode{ mode_ }
    {
    }

    VULKAN_HPP_CONSTEXPR CopyMicromapInfoEXT( CopyMicromapInfoEXT const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    CopyMicromapInfoEXT( VkCopyMicromapInfoEXT const & rhs ) VULKAN_HPP_NOEXCEPT : CopyMicromapInfoEXT( *reinterpret_cast<CopyMicromapInfoEXT const *>( &rhs ) )
    {
    }

    CopyMicromapInfoEXT & operator=( CopyMicromapInfoEXT const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    CopyMicromapInfoEXT & operator=( VkCopyMicromapInfoEXT const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<CopyMicromapInfoEXT const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 CopyMicromapInfoEXT & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CopyMicromapInfoEXT & setSrc( MicromapEXT src_ ) VULKAN_HPP_NOEXCEPT
    {
      src = src_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CopyMicromapInfoEXT & setDst( MicromapEXT dst_ ) VULKAN_HPP_NOEXCEPT
    {
      dst = dst_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CopyMicromapInfoEXT & setMode( CopyMicromapModeEXT mode_ ) VULKAN_HPP_NOEXCEPT
    {
      mode = mode_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_SETTERS*/

    operator VkCopyMicromapInfoEXT const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkCopyMicromapInfoEXT *>( this );
    }

    operator VkCopyMicromapInfoEXT &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkCopyMicromapInfoEXT *>( this );
    }

    operator VkCopyMicromapInfoEXT const *() const VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<const VkCopyMicromapInfoEXT *>( this );
    }

    operator VkCopyMicromapInfoEXT *() VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<VkCopyMicromapInfoEXT *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<StructureType const &, const void * const &, MicromapEXT const &, MicromapEXT const &, CopyMicromapModeEXT const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, src, dst, mode );
    }
#endif

#if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    auto operator<=>( CopyMicromapInfoEXT const & ) const = default;
#else
    bool operator==( CopyMicromapInfoEXT const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
#  if defined( VULKAN_HPP_USE_REFLECT )
      return this->reflect() == rhs.reflect();
#  else
      return ( sType == rhs.sType ) && ( pNext == rhs.pNext ) && ( src == rhs.src ) && ( dst == rhs.dst ) && ( mode == rhs.mode );
#  endif
    }

    bool operator!=( CopyMicromapInfoEXT const & rhs ) const VULKAN_HPP_NOEXCEPT
    {
      return !operator==( rhs );
    }
#endif

  public:
    StructureType       sType = StructureType::eCopyMicromapInfoEXT;
    const void *        pNext = {};
    MicromapEXT         src   = {};
    MicromapEXT         dst   = {};
    CopyMicromapModeEXT mode  = CopyMicromapModeEXT::eClone;
  };

  template <>
  struct CppType<StructureType, StructureType::eCopyMicromapInfoEXT>
  {
    using Type = CopyMicromapInfoEXT;
  };

  // wrapper struct for struct VkCopyMicromapToMemoryInfoEXT, see https://registry.khronos.org/vulkan/specs/latest/man/html/VkCopyMicromapToMemoryInfoEXT.html
  struct CopyMicromapToMemoryInfoEXT
  {
    using NativeType = VkCopyMicromapToMemoryInfoEXT;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eCopyMicromapToMemoryInfoEXT;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR_14 CopyMicromapToMemoryInfoEXT( MicromapEXT            src_   = {},
                                                         DeviceOrHostAddressKHR dst_   = {},
                                                         CopyMicromapModeEXT    mode_  = CopyMicromapModeEXT::eClone,
                                                         const void *           pNext_ = nullptr ) VULKAN_HPP_NOEXCEPT
      : pNext{ pNext_ }
      , src{ src_ }
      , dst{ dst_ }
      , mode{ mode_ }
    {
    }

    VULKAN_HPP_CONSTEXPR_14 CopyMicromapToMemoryInfoEXT( CopyMicromapToMemoryInfoEXT const & rhs ) VULKAN_HPP_NOEXCEPT = default;

    CopyMicromapToMemoryInfoEXT( VkCopyMicromapToMemoryInfoEXT const & rhs ) VULKAN_HPP_NOEXCEPT
      : CopyMicromapToMemoryInfoEXT( *reinterpret_cast<CopyMicromapToMemoryInfoEXT const *>( &rhs ) )
    {
    }

    CopyMicromapToMemoryInfoEXT & operator=( CopyMicromapToMemoryInfoEXT const & rhs ) VULKAN_HPP_NOEXCEPT = default;
#endif /*VULKAN_HPP_NO_CONSTRUCTORS*/

    CopyMicromapToMemoryInfoEXT & operator=( VkCopyMicromapToMemoryInfoEXT const & rhs ) VULKAN_HPP_NOEXCEPT
    {
      *this = *reinterpret_cast<CopyMicromapToMemoryInfoEXT const *>( &rhs );
      return *this;
    }

#if !defined( VULKAN_HPP_NO_SETTERS ) && !defined( VULKAN_HPP_NO_STRUCT_SETTERS )
    VULKAN_HPP_CONSTEXPR_14 CopyMicromapToMemoryInfoEXT & setPNext( const void * pNext_ ) VULKAN_HPP_NOEXCEPT
    {
      pNext = pNext_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CopyMicromapToMemoryInfoEXT & setSrc( MicromapEXT src_ ) VULKAN_HPP_NOEXCEPT
    {
      src = src_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CopyMicromapToMemoryInfoEXT & setDst( DeviceOrHostAddressKHR const & dst_ ) VULKAN_HPP_NOEXCEPT
    {
      dst = dst_;
      return *this;
    }

    VULKAN_HPP_CONSTEXPR_14 CopyMicromapToMemoryInfoEXT & setMode( CopyMicromapModeEXT mode_ ) VULKAN_HPP_NOEXCEPT
    {
      mode = mode_;
      return *this;
    }
#endif /*VULKAN_HPP_NO_SETTERS*/

    operator VkCopyMicromapToMemoryInfoEXT const &() const VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<const VkCopyMicromapToMemoryInfoEXT *>( this );
    }

    operator VkCopyMicromapToMemoryInfoEXT &() VULKAN_HPP_NOEXCEPT
    {
      return *reinterpret_cast<VkCopyMicromapToMemoryInfoEXT *>( this );
    }

    operator VkCopyMicromapToMemoryInfoEXT const *() const VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<const VkCopyMicromapToMemoryInfoEXT *>( this );
    }

    operator VkCopyMicromapToMemoryInfoEXT *() VULKAN_HPP_NOEXCEPT
    {
      return reinterpret_cast<VkCopyMicromapToMemoryInfoEXT *>( this );
    }

#if defined( VULKAN_HPP_USE_REFLECT )
#  if 14 <= VULKAN_HPP_CPP_VERSION
    auto
#  else
    std::tuple<StructureType const &, const void * const &, MicromapEXT const &, DeviceOrHostAddressKHR const &, CopyMicromapModeEXT const &>
#  endif
      reflect() const VULKAN_HPP_NOEXCEPT
    {
      return std::tie( sType, pNext, src, dst, mode );
    }
#endif

  public:
    StructureType          sType = StructureType::eCopyMicromapToMemoryInfoEXT;
    const void *           pNext = {};
    MicromapEXT            src   = {};
    DeviceOrHostAddressKHR dst   = {};
    CopyMicromapModeEXT    mode  = CopyMicromapModeEXT::eClone;
  };

  template <>
  struct CppType<StructureType, StructureType::eCopyMicromapToMemoryInfoEXT>
  {
    using Type = CopyMicromapToMemoryInfoEXT;
  };

  // wrapper struct for struct VkTensorCopyARM, see https://registry.khronos.org/vulkan/specs/latest/man/html/VkTensorCopyARM.html
  struct TensorCopyARM
  {
    using NativeType = VkTensorCopyARM;

    static const bool                                  allowDuplicate = false;
    static VULKAN_HPP_CONST_OR_CONSTEXPR StructureType structureType  = StructureType::eTensorCopyARM;

#if !defined( VULKAN_HPP_NO_CONSTRUCTORS ) && !defined( VULKAN_HPP_NO_STRUCT_CONSTRUCTORS )
    VULKAN_HPP_CONSTEXPR TensorCopyARM( uint32_t         dimensionCount_ = {},
                                        const uint64_t * pSrcOffset_     = {},
                                        const uint64_t * pDst