'\"
'\" Generated from file 'decimal\&.man' by tcllib/doctools with format 'nroff'
'\" Copyright (c) 2011 Mark Alston <mark at beernut dot com>
'\"
.TH "math::decimal" n 1\&.0\&.5 tcllib "Tcl Decimal Arithmetic Library"
.\" The -*- nroff -*- definitions below are for supplemental macros used
.\" in Tcl/Tk manual entries.
.\"
.\" .AP type name in/out ?indent?
.\"	Start paragraph describing an argument to a library procedure.
.\"	type is type of argument (int, etc.), in/out is either "in", "out",
.\"	or "in/out" to describe whether procedure reads or modifies arg,
.\"	and indent is equivalent to second arg of .IP (shouldn't ever be
.\"	needed;  use .AS below instead)
.\"
.\" .AS ?type? ?name?
.\"	Give maximum sizes of arguments for setting tab stops.  Type and
.\"	name are examples of largest possible arguments that will be passed
.\"	to .AP later.  If args are omitted, default tab stops are used.
.\"
.\" .BS
.\"	Start box enclosure.  From here until next .BE, everything will be
.\"	enclosed in one large box.
.\"
.\" .BE
.\"	End of box enclosure.
.\"
.\" .CS
.\"	Begin code excerpt.
.\"
.\" .CE
.\"	End code excerpt.
.\"
.\" .VS ?version? ?br?
.\"	Begin vertical sidebar, for use in marking newly-changed parts
.\"	of man pages.  The first argument is ignored and used for recording
.\"	the version when the .VS was added, so that the sidebars can be
.\"	found and removed when they reach a certain age.  If another argument
.\"	is present, then a line break is forced before starting the sidebar.
.\"
.\" .VE
.\"	End of vertical sidebar.
.\"
.\" .DS
.\"	Begin an indented unfilled display.
.\"
.\" .DE
.\"	End of indented unfilled display.
.\"
.\" .SO ?manpage?
.\"	Start of list of standard options for a Tk widget. The manpage
.\"	argument defines where to look up the standard options; if
.\"	omitted, defaults to "options". The options follow on successive
.\"	lines, in three columns separated by tabs.
.\"
.\" .SE
.\"	End of list of standard options for a Tk widget.
.\"
.\" .OP cmdName dbName dbClass
.\"	Start of description of a specific option.  cmdName gives the
.\"	option's name as specified in the class command, dbName gives
.\"	the option's name in the option database, and dbClass gives
.\"	the option's class in the option database.
.\"
.\" .UL arg1 arg2
.\"	Print arg1 underlined, then print arg2 normally.
.\"
.\" .QW arg1 ?arg2?
.\"	Print arg1 in quotes, then arg2 normally (for trailing punctuation).
.\"
.\" .PQ arg1 ?arg2?
.\"	Print an open parenthesis, arg1 in quotes, then arg2 normally
.\"	(for trailing punctuation) and then a closing parenthesis.
.\"
.\"	# Set up traps and other miscellaneous stuff for Tcl/Tk man pages.
.if t .wh -1.3i ^B
.nr ^l \n(.l
.ad b
.\"	# Start an argument description
.de AP
.ie !"\\$4"" .TP \\$4
.el \{\
.   ie !"\\$2"" .TP \\n()Cu
.   el          .TP 15
.\}
.ta \\n()Au \\n()Bu
.ie !"\\$3"" \{\
\&\\$1 \\fI\\$2\\fP (\\$3)
.\".b
.\}
.el \{\
.br
.ie !"\\$2"" \{\
\&\\$1	\\fI\\$2\\fP
.\}
.el \{\
\&\\fI\\$1\\fP
.\}
.\}
..
.\"	# define tabbing values for .AP
.de AS
.nr )A 10n
.if !"\\$1"" .nr )A \\w'\\$1'u+3n
.nr )B \\n()Au+15n
.\"
.if !"\\$2"" .nr )B \\w'\\$2'u+\\n()Au+3n
.nr )C \\n()Bu+\\w'(in/out)'u+2n
..
.AS Tcl_Interp Tcl_CreateInterp in/out
.\"	# BS - start boxed text
.\"	# ^y = starting y location
.\"	# ^b = 1
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
.\"	# BE - end boxed text (draw box now)
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
.\"	Draw four-sided box normally, but don't draw top of
.\"	box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
.\"	# VS - start vertical sidebar
.\"	# ^Y = starting y location
.\"	# ^v = 1 (for troff;  for nroff this doesn't matter)
.de VS
.if !"\\$2"" .br
.mk ^Y
.ie n 'mc \s12\(br\s0
.el .nr ^v 1u
..
.\"	# VE - end of vertical sidebar
.de VE
.ie n 'mc
.el \{\
.ev 2
.nf
.ti 0
.mk ^t
\h'|\\n(^lu+3n'\L'|\\n(^Yu-1v\(bv'\v'\\n(^tu+1v-\\n(^Yu'\h'-|\\n(^lu+3n'
.sp -1
.fi
.ev
.\}
.nr ^v 0
..
.\"	# Special macro to handle page bottom:  finish off current
.\"	# box/sidebar if in box/sidebar mode, then invoked standard
.\"	# page bottom macro.
.de ^B
.ev 2
'ti 0
'nf
.mk ^t
.if \\n(^b \{\
.\"	Draw three-sided box if this is the box's first page,
.\"	draw two sides but no top otherwise.
.ie !\\n(^b-1 \h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.el \h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.\}
.if \\n(^v \{\
.nr ^x \\n(^tu+1v-\\n(^Yu
\kx\h'-\\nxu'\h'|\\n(^lu+3n'\ky\L'-\\n(^xu'\v'\\n(^xu'\h'|0u'\c
.\}
.bp
'fi
.ev
.if \\n(^b \{\
.mk ^y
.nr ^b 2
.\}
.if \\n(^v \{\
.mk ^Y
.\}
..
.\"	# DS - begin display
.de DS
.RS
.nf
.sp
..
.\"	# DE - end display
.de DE
.fi
.RE
.sp
..
.\"	# SO - start of list of standard options
.de SO
'ie '\\$1'' .ds So \\fBoptions\\fR
'el .ds So \\fB\\$1\\fR
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 5.5c 11c
.ft B
..
.\"	# SE - end of list of standard options
.de SE
.fi
.ft R
.LP
See the \\*(So manual entry for details on the standard options.
..
.\"	# OP - start of full description for a single option
.de OP
.LP
.nf
.ta 4c
Command-Line Name:	\\fB\\$1\\fR
Database Name:	\\fB\\$2\\fR
Database Class:	\\fB\\$3\\fR
.fi
.IP
..
.\"	# CS - begin code excerpt
.de CS
.RS
.nf
.ta .25i .5i .75i 1i
..
.\"	# CE - end code excerpt
.de CE
.fi
.RE
..
.\"	# UL - underline word
.de UL
\\$1\l'|0\(ul'\\$2
..
.\"	# QW - apply quotation marks to word
.de QW
.ie '\\*(lq'"' ``\\$1''\\$2
.\"" fix emacs highlighting
.el \\*(lq\\$1\\*(rq\\$2
..
.\"	# PQ - apply parens and quotation marks to word
.de PQ
.ie '\\*(lq'"' (``\\$1''\\$2)\\$3
.\"" fix emacs highlighting
.el (\\*(lq\\$1\\*(rq\\$2)\\$3
..
.\"	# QR - quoted range
.de QR
.ie '\\*(lq'"' ``\\$1''\\-``\\$2''\\$3
.\"" fix emacs highlighting
.el \\*(lq\\$1\\*(rq\\-\\*(lq\\$2\\*(rq\\$3
..
.\"	# MT - "empty" string
.de MT
.QW ""
..
.BS
.SH NAME
math::decimal \- General decimal arithmetic
.SH SYNOPSIS
package require \fBTcl ?8\&.5 9?\fR
.sp
package require \fBmath::decimal 1\&.0\&.3\fR
.sp
\fB::math::decimal::fromstr\fR \fIstring\fR
.sp
\fB::math::decimal::tostr\fR \fIdecimal\fR
.sp
\fB::math::decimal::setVariable\fR \fIvariable\fR \fIsetting\fR
.sp
\fB::math::decimal::add\fR \fIa\fR \fIb\fR
.sp
\fB::math::decimal::+\fR \fIa\fR \fIb\fR
.sp
\fB::math::decimal::subtract\fR \fIa\fR \fIb\fR
.sp
\fB::math::decimal::-\fR \fIa\fR \fIb\fR
.sp
\fB::math::decimal::multiply\fR \fIa\fR \fIb\fR
.sp
\fB::math::decimal::*\fR \fIa\fR \fIb\fR
.sp
\fB::math::decimal::divide\fR \fIa\fR \fIb\fR
.sp
\fB::math::decimal::/\fR \fIa\fR \fIb\fR
.sp
\fB::math::decimal::divideint\fR \fIa\fR \fIb\fR
.sp
\fB::math::decimal::remainder\fR \fIa\fR \fIb\fR
.sp
\fB::math::decimal::abs\fR \fIdecimal\fR
.sp
\fB::math::decimal::compare\fR \fIa\fR \fIb\fR
.sp
\fB::math::decimal::max\fR \fIa\fR \fIb\fR
.sp
\fB::math::decimal::maxmag\fR \fIa\fR \fIb\fR
.sp
\fB::math::decimal::min\fR \fIa\fR \fIb\fR
.sp
\fB::math::decimal::minmag\fR \fIa\fR \fIb\fR
.sp
\fB::math::decimal::plus\fR \fIa\fR
.sp
\fB::math::decimal::minus\fR \fIa\fR
.sp
\fB::math::decimal::copynegate\fR \fIa\fR
.sp
\fB::math::decimal::copysign\fR \fIa\fR \fIb\fR
.sp
\fB::math::decimal::is-signed\fR \fIdecimal\fR
.sp
\fB::math::decimal::is-zero\fR \fIdecimal\fR
.sp
\fB::math::decimal::is-NaN\fR \fIdecimal\fR
.sp
\fB::math::decimal::is-infinite\fR \fIdecimal\fR
.sp
\fB::math::decimal::is-finite\fR \fIdecimal\fR
.sp
\fB::math::decimal::fma\fR \fIa\fR \fIb\fR \fIc\fR
.sp
\fB::math::decimal::round_half_even\fR \fIdecimal\fR \fIdigits\fR
.sp
\fB::math::decimal::round_half_up\fR \fIdecimal\fR \fIdigits\fR
.sp
\fB::math::decimal::round_half_down\fR \fIdecimal\fR \fIdigits\fR
.sp
\fB::math::decimal::round_down\fR \fIdecimal\fR \fIdigits\fR
.sp
\fB::math::decimal::round_up\fR \fIdecimal\fR \fIdigits\fR
.sp
\fB::math::decimal::round_floor\fR \fIdecimal\fR \fIdigits\fR
.sp
\fB::math::decimal::round_ceiling\fR \fIdecimal\fR \fIdigits\fR
.sp
\fB::math::decimal::round_05up\fR \fIdecimal\fR \fIdigits\fR
.sp
.BE
.SH DESCRIPTION
.PP
The decimal package provides decimal arithmetic support for both limited
precision floating point and arbitrary precision floating point\&.
Additionally, integer arithmetic is supported\&.
.PP
More information and the specifications on which this package depends can be
found on the general decimal arithmetic page at http://speleotrove\&.com/decimal
This package provides for:
.IP \(bu
A new data type decimal which is represented as a list containing sign,
mantissa and exponent\&.
.IP \(bu
Arithmetic operations on those decimal numbers such as addition, subtraction,
multiplication, etc\&.\&.\&.
.PP
.PP
Numbers are converted to decimal format using the operation ::math::decimal::fromstr\&.
.PP
Numbers are converted back to string format using the operation
::math::decimal::tostr\&.
.PP
.SH EXAMPLES
This section shows some simple examples\&. Since the purpose of this library
is to perform decimal math operations, examples may be the simplest way
to learn how to work with it and to see the difference between using this
package and sticking with expr\&. Consult the API section of
this man page for information about individual procedures\&.
.PP
.CS


    package require math::decimal

    # Various operations on two numbers\&.
    # We first convert them to decimal format\&.
    set a [::math::decimal::fromstr 8\&.2]
    set b [::math::decimal::fromstr \&.2]

    # Then we perform our operations\&. Here we add
    set c [::math::decimal::+ $a $b]

    # Finally we convert back to string format for presentation to the user\&.
    puts [::math::decimal::tostr $c] ; # => will output 8\&.4

    # Other examples
    #
    # Subtraction
    set c [::math::decimal::- $a $b]
    puts [::math::decimal::tostr $c] ; # => will output 8\&.0

    # Why bother using this instead of simply expr?
    puts [expr {8\&.2 + \&.2}] ; # => will output 8\&.399999999999999
    puts [expr {8\&.2 - \&.2}] ; # => will output 7\&.999999999999999
    # See http://speleotrove\&.com/decimal to learn more about why this happens\&.

.CE
.SH API
.TP
\fB::math::decimal::fromstr\fR \fIstring\fR
Convert \fIstring\fR into a decimal\&.
.TP
\fB::math::decimal::tostr\fR \fIdecimal\fR
Convert \fIdecimal\fR into a string representing the number in base 10\&.
.TP
\fB::math::decimal::setVariable\fR \fIvariable\fR \fIsetting\fR
Sets the \fIvariable\fR to \fIsetting\fR\&. Valid variables are:
.RS
.IP \(bu
\fIrounding\fR - Method of rounding to use during rescale\&. Valid
methods are round_half_even, round_half_up, round_half_down,
round_down, round_up, round_floor, round_ceiling\&.
.IP \(bu
\fIprecision\fR - Maximum number of digits allowed in mantissa\&.
.IP \(bu
\fIextended\fR - Set to 1 for extended mode\&. 0 for simplified mode\&.
.IP \(bu
\fImaxExponent\fR - Maximum value for the exponent\&. Defaults to 999\&.
.IP \(bu
\fIminExponent\fR - Minimum value for the exponent\&. Default to -998\&.
.RE
.TP
\fB::math::decimal::add\fR \fIa\fR \fIb\fR
.TP
\fB::math::decimal::+\fR \fIa\fR \fIb\fR
Return the sum of the two decimals \fIa\fR and \fIb\fR\&.
.TP
\fB::math::decimal::subtract\fR \fIa\fR \fIb\fR
.TP
\fB::math::decimal::-\fR \fIa\fR \fIb\fR
Return the differnece of the two decimals \fIa\fR and \fIb\fR\&.
.TP
\fB::math::decimal::multiply\fR \fIa\fR \fIb\fR
.TP
\fB::math::decimal::*\fR \fIa\fR \fIb\fR
Return the product of the two decimals \fIa\fR and \fIb\fR\&.
.TP
\fB::math::decimal::divide\fR \fIa\fR \fIb\fR
.TP
\fB::math::decimal::/\fR \fIa\fR \fIb\fR
Return the quotient of the division between the two
decimals \fIa\fR and \fIb\fR\&.
.TP
\fB::math::decimal::divideint\fR \fIa\fR \fIb\fR
Return a the integer portion of the quotient of the division between
decimals \fIa\fR and \fIb\fR
.TP
\fB::math::decimal::remainder\fR \fIa\fR \fIb\fR
Return the remainder of the division between the two
decimals \fIa\fR and \fIb\fR\&.
.TP
\fB::math::decimal::abs\fR \fIdecimal\fR
Return the absolute value of the decimal\&.
.TP
\fB::math::decimal::compare\fR \fIa\fR \fIb\fR
Compare the two decimals a and b, returning \fI0\fR if \fIa == b\fR,
\fI1\fR if \fIa > b\fR, and \fI-1\fR if \fIa < b\fR\&.
.TP
\fB::math::decimal::max\fR \fIa\fR \fIb\fR
Compare the two decimals a and b, and return \fIa\fR if \fIa >= b\fR, and \fIb\fR if \fIa < b\fR\&.
.TP
\fB::math::decimal::maxmag\fR \fIa\fR \fIb\fR
Compare the two decimals a and b while ignoring their signs, and return \fIa\fR if \fIabs(a) >= abs(b)\fR, and \fIb\fR if \fIabs(a) < abs(b)\fR\&.
.TP
\fB::math::decimal::min\fR \fIa\fR \fIb\fR
Compare the two decimals a and b, and return \fIa\fR if \fIa <= b\fR, and \fIb\fR if \fIa > b\fR\&.
.TP
\fB::math::decimal::minmag\fR \fIa\fR \fIb\fR
Compare the two decimals a and b while ignoring their signs, and return \fIa\fR if \fIabs(a) <= abs(b)\fR, and \fIb\fR if \fIabs(a) > abs(b)\fR\&.
.TP
\fB::math::decimal::plus\fR \fIa\fR
Return the result from \fI::math::decimal::+ 0 $a\fR\&.
.TP
\fB::math::decimal::minus\fR \fIa\fR
Return the result from \fI::math::decimal::- 0 $a\fR\&.
.TP
\fB::math::decimal::copynegate\fR \fIa\fR
Returns \fIa\fR with the sign flipped\&.
.TP
\fB::math::decimal::copysign\fR \fIa\fR \fIb\fR
Returns \fIa\fR with the sign set to the sign of the \fIb\fR\&.
.TP
\fB::math::decimal::is-signed\fR \fIdecimal\fR
Return the sign of the decimal\&.
The procedure returns 0 if the number is positive, 1 if it's negative\&.
.TP
\fB::math::decimal::is-zero\fR \fIdecimal\fR
Return true if \fIdecimal\fR value is zero, otherwise false is returned\&.
.TP
\fB::math::decimal::is-NaN\fR \fIdecimal\fR
Return true if \fIdecimal\fR value is NaN (not a number), otherwise false is returned\&.
.TP
\fB::math::decimal::is-infinite\fR \fIdecimal\fR
Return true if \fIdecimal\fR value is Infinite, otherwise false is returned\&.
.TP
\fB::math::decimal::is-finite\fR \fIdecimal\fR
Return true if \fIdecimal\fR value is finite, otherwise false is returned\&.
.TP
\fB::math::decimal::fma\fR \fIa\fR \fIb\fR \fIc\fR
Return the result from first multiplying \fIa\fR by \fIb\fR and then adding \fIc\fR\&. Rescaling only occurs after completion of all operations\&. In this way the result may vary from that returned by performing the operations individually\&.
.TP
\fB::math::decimal::round_half_even\fR \fIdecimal\fR \fIdigits\fR
Rounds \fIdecimal\fR to \fIdigits\fR number of decimal points with the following rules: Round to the nearest\&. If equidistant, round so the final digit is even\&.
.TP
\fB::math::decimal::round_half_up\fR \fIdecimal\fR \fIdigits\fR
Rounds \fIdecimal\fR to \fIdigits\fR number of decimal points with the following rules: Round to the nearest\&. If equidistant, round up\&.
.TP
\fB::math::decimal::round_half_down\fR \fIdecimal\fR \fIdigits\fR
Rounds \fIdecimal\fR to \fIdigits\fR number of decimal points with the following rules: Round to the nearest\&. If equidistant, round down\&.
.TP
\fB::math::decimal::round_down\fR \fIdecimal\fR \fIdigits\fR
Rounds \fIdecimal\fR to \fIdigits\fR number of decimal points with the following rules: Round toward 0\&.  (Truncate)
.TP
\fB::math::decimal::round_up\fR \fIdecimal\fR \fIdigits\fR
Rounds \fIdecimal\fR to \fIdigits\fR number of decimal points with the following rules: Round away from 0
.TP
\fB::math::decimal::round_floor\fR \fIdecimal\fR \fIdigits\fR
Rounds \fIdecimal\fR to \fIdigits\fR number of decimal points with the following rules: Round toward -Infinity\&.
.TP
\fB::math::decimal::round_ceiling\fR \fIdecimal\fR \fIdigits\fR
Rounds \fIdecimal\fR to \fIdigits\fR number of decimal points with the following rules: Round toward Infinity
.TP
\fB::math::decimal::round_05up\fR \fIdecimal\fR \fIdigits\fR
Rounds \fIdecimal\fR to \fIdigits\fR number of decimal points with the following rules: Round zero or five away from 0\&. The same as round-up, except that rounding up only occurs if the digit to be rounded up is 0 or 5, and after overflow
the result is the same as for round-down\&.
.PP
.PP
.SH "BUGS, IDEAS, FEEDBACK"
This document, and the package it describes, will undoubtedly contain
bugs and other problems\&.
Please report such in the category \fIdecimal\fR of the
\fITcllib Trackers\fR [http://core\&.tcl\&.tk/tcllib/reportlist]\&.
Please also report any ideas for enhancements you may have for either
package and/or documentation\&.
.PP
When proposing code changes, please provide \fIunified diffs\fR,
i\&.e the output of \fBdiff -u\fR\&.
.PP
Note further that \fIattachments\fR are strongly preferred over
inlined patches\&. Attachments can be made by going to the \fBEdit\fR
form of the ticket immediately after its creation, and then using the
left-most button in the secondary navigation bar\&.
.SH KEYWORDS
decimal, math, tcl
.SH CATEGORY
Mathematics
.SH COPYRIGHT
.nf
Copyright (c) 2011 Mark Alston <mark at beernut dot com>

.fi
