/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.server;

import com.sun.net.httpserver.Headers;
import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.StatusCode;
import io.opentelemetry.context.Scope;
import io.opentelemetry.semconv.trace.attributes.SemanticAttributes;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeoutException;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.languagetool.ErrorRateTooHighException;
import org.languagetool.server.ApiV2;
import org.languagetool.server.AuthException;
import org.languagetool.server.BadRequestException;
import org.languagetool.server.ErrorRequestLimiter;
import org.languagetool.server.HTTPServerConfig;
import org.languagetool.server.PathNotFoundException;
import org.languagetool.server.RequestCounter;
import org.languagetool.server.RequestLimiter;
import org.languagetool.server.Server;
import org.languagetool.server.ServerMetricsCollector;
import org.languagetool.server.ServerTools;
import org.languagetool.server.TextChecker;
import org.languagetool.server.TextTooLongException;
import org.languagetool.server.TooManyRequestsException;
import org.languagetool.server.UnavailableException;
import org.languagetool.server.UserLimits;
import org.languagetool.server.V2TextChecker;
import org.languagetool.tools.LoggingTools;
import org.languagetool.tools.StringTools;
import org.languagetool.tools.TelemetryProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

class LanguageToolHttpHandler
implements HttpHandler {
    private static final Logger logger = LoggerFactory.getLogger(LanguageToolHttpHandler.class);
    static final String API_DOC_URL = "https://languagetool.org/http-api/swagger-ui/#/default";
    static final String REQUEST_LIMIT_ACCESS_TOKEN_HEADER = "X-Request-Limit-Access-Token";
    private static final String ENCODING = "utf-8";
    private final Set<String> allowedIps;
    private final RequestLimiter requestLimiter;
    private final ErrorRequestLimiter errorRequestLimiter;
    private final BlockingQueue<Runnable> workQueue;
    private final Server httpServer;
    private final TextChecker textCheckerV2;
    private final HTTPServerConfig config;
    private final RequestCounter reqCounter = new RequestCounter();
    private static final Pattern QUERY_PARAM_SPLIT = Pattern.compile("&");

    LanguageToolHttpHandler(HTTPServerConfig config, Set<String> allowedIps, boolean internal, RequestLimiter requestLimiter, ErrorRequestLimiter errorLimiter, BlockingQueue<Runnable> workQueue, Server httpServer) {
        this.config = config;
        this.allowedIps = allowedIps;
        this.requestLimiter = requestLimiter;
        this.errorRequestLimiter = errorLimiter;
        this.workQueue = workQueue;
        this.httpServer = httpServer;
        this.textCheckerV2 = new V2TextChecker(config, internal, workQueue, this.reqCounter);
    }

    void shutdown() {
        this.textCheckerV2.shutdownNow();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void handle(HttpExchange httpExchange) throws IOException {
        long startTime = System.currentTimeMillis();
        String remoteAddress = null;
        Map<String, String> parameters = new HashMap<String, String>();
        int reqId = this.reqCounter.incrementRequestCount();
        ServerMetricsCollector.getInstance().logRequest();
        boolean incrementHandleCount = false;
        String requestId = LanguageToolHttpHandler.getRequestId(httpExchange);
        MDC.MDCCloseable mdcRequestID = MDC.putCloseable((String)"rID", (String)requestId);
        Attributes attributes = Attributes.builder().put(SemanticAttributes.HTTP_METHOD, (Object)httpExchange.getRequestMethod()).put(SemanticAttributes.HTTP_ROUTE, (Object)httpExchange.getRequestURI().getRawPath()).put("http.path_group", httpExchange.getRequestURI().getRawPath()).put("request.id", requestId).build();
        Span globalSpan = TelemetryProvider.INSTANCE.createSpan("handle-http-request", attributes);
        try (Scope scope = globalSpan.makeCurrent();){
            String errorMessage;
            String pathWithoutVersion;
            URI requestedUri = httpExchange.getRequestURI();
            String path = requestedUri.getRawPath();
            logger.info("Handling {} {}", (Object)httpExchange.getRequestMethod(), (Object)path);
            if (this.config.getServerURL() != null && !(path = this.config.getServerURL().relativize(new URI(requestedUri.getPath())).getRawPath()).startsWith("/")) {
                path = "/" + path;
            }
            if (path.startsWith("/v2/stop") && this.config.isStoppable()) {
                logger.warn("Stopping server by external command");
                this.httpServer.stop();
                return;
            }
            if (path.startsWith("/v2/") && (pathWithoutVersion = path.substring("/v2/".length())).equals("healthcheck")) {
                String message = "Healthcheck failed: There are currently too many parallel requests.";
                if (!this.workQueueFull(httpExchange, parameters, message) && !this.textCheckerQueueFull(httpExchange, message)) {
                    String ok = "OK";
                    httpExchange.getResponseHeaders().set("Content-Type", "text/plain");
                    httpExchange.sendResponseHeaders(200, ok.getBytes(ENCODING).length);
                    httpExchange.getResponseBody().write(ok.getBytes(ENCODING));
                    ServerMetricsCollector.getInstance().logResponse(200);
                    return;
                }
                ServerMetricsCollector.getInstance().logFailedHealthcheck();
                return;
            }
            String referrer = httpExchange.getRequestHeaders().getFirst("Referer");
            String origin = httpExchange.getRequestHeaders().getFirst("Origin");
            for (String ref : this.config.getBlockedReferrers()) {
                errorMessage = null;
                if (ref != null && !ref.isEmpty()) {
                    if (referrer != null && ServerTools.siteMatches(referrer, ref)) {
                        errorMessage = "Error: Access with referrer " + referrer + " denied.";
                    } else if (origin != null && ServerTools.siteMatches(origin, ref)) {
                        errorMessage = "Error: Access with origin " + origin + " denied.";
                    }
                }
                if (errorMessage == null) continue;
                this.sendError(httpExchange, 403, errorMessage);
                this.logError(errorMessage, 403, parameters, httpExchange);
                ServerMetricsCollector.getInstance().logResponse(403);
                return;
            }
            String origAddress = httpExchange.getRemoteAddress().getAddress().getHostAddress();
            String realAddressOrNull = this.getRealRemoteAddressOrNull(httpExchange);
            remoteAddress = realAddressOrNull != null ? realAddressOrNull : origAddress;
            this.reqCounter.incrementHandleCount(remoteAddress, reqId);
            incrementHandleCount = true;
            parameters = this.getRequestQuery(httpExchange, requestedUri);
            if (this.requestLimiter != null && this.limitPath(path) && !this.allowSkipRequestLimit(httpExchange.getRequestHeaders())) {
                try {
                    UserLimits userLimits = ServerTools.getUserLimits(parameters, this.config);
                    this.requestLimiter.checkAccess(remoteAddress, parameters, httpExchange.getRequestHeaders(), userLimits);
                }
                catch (TooManyRequestsException e) {
                    String errorMessage2 = "Error: Access from " + remoteAddress + " denied: " + e.getMessage();
                    int code = 429;
                    this.sendError(httpExchange, code, errorMessage2);
                    this.logError(errorMessage2, code, parameters, httpExchange, false);
                    if (scope != null) {
                        if (var13_13 != null) {
                            try {
                                scope.close();
                            }
                            catch (Throwable throwable) {
                                var13_13.addSuppressed(throwable);
                            }
                        } else {
                            scope.close();
                        }
                    }
                    logger.info("Handled request in {}ms; sending code {}", (Object)(System.currentTimeMillis() - startTime), (Object)httpExchange.getResponseCode());
                    httpExchange.close();
                    mdcRequestID.close();
                    globalSpan.setAttribute(SemanticAttributes.HTTP_STATUS_CODE, httpExchange.getResponseCode());
                    globalSpan.end();
                    if (!incrementHandleCount) return;
                    this.reqCounter.decrementHandleCount(reqId);
                    return;
                }
            }
            if (this.errorRequestLimiter != null && !this.allowSkipRequestLimit(httpExchange.getRequestHeaders()) && !this.errorRequestLimiter.wouldAccessBeOkay(remoteAddress, parameters, httpExchange.getRequestHeaders())) {
                String textSizeMessage = this.getTextOrDataSizeMessage(parameters);
                String errorMessage3 = "Error: Access from " + remoteAddress + " denied - too many recent timeouts. " + textSizeMessage + " Allowed maximum timeouts: " + this.errorRequestLimiter.getRequestLimit() + " per " + this.errorRequestLimiter.getRequestLimitPeriodInSeconds() + " seconds";
                int code = 429;
                this.sendError(httpExchange, code, errorMessage3);
                this.logError(errorMessage3, code, parameters, httpExchange);
                return;
            }
            if (this.workQueueFull(httpExchange, parameters, "Error: There are currently too many parallel requests. Please try again later.")) {
                ServerMetricsCollector.getInstance().logRequestError(ServerMetricsCollector.RequestErrorType.QUEUE_FULL);
                return;
            }
            if (this.allowedIps == null || this.allowedIps.contains(origAddress)) {
                if (path.startsWith("/v2/")) {
                    ApiV2 apiV2 = new ApiV2(this.textCheckerV2, this.config.getAllowOriginUrl());
                    String pathWithoutVersion2 = path.substring("/v2/".length());
                    Map<String, String> finalParameters = parameters;
                    String finalRemoteAddress = remoteAddress;
                    TelemetryProvider.INSTANCE.createSpan("/v2", Attributes.empty(), () -> apiV2.handleRequest(pathWithoutVersion2, httpExchange, finalParameters, this.errorRequestLimiter, finalRemoteAddress, this.config));
                    return;
                }
                if (path.endsWith("/Languages")) {
                    throw new BadRequestException("You're using an old version of our API that's not supported anymore. Please see https://languagetool.org/http-api/swagger-ui/#/default");
                }
                if (path.equals("/")) {
                    throw new BadRequestException("Missing arguments for LanguageTool API. Please see https://languagetool.org/http-api/swagger-ui/#/default");
                }
                if (path.contains("/v2/")) {
                    throw new BadRequestException("You have '/v2/' in your path, but not at the root. Try an URL like 'http://server/v2/...' ");
                }
                if (!path.equals("/favicon.ico")) throw new BadRequestException("This is the LanguageTool API. You have not specified any parameters. Please see https://languagetool.org/http-api/swagger-ui/#/default");
                this.sendError(httpExchange, 404, "Not found");
                return;
            }
            errorMessage = "Error: Access from " + StringTools.escapeXML((String)origAddress) + " denied";
            this.sendError(httpExchange, 403, errorMessage);
            throw new RuntimeException(errorMessage);
        }
        catch (Exception e) {
            String response;
            int errorCode;
            boolean textLoggingAllowed = false;
            boolean logStacktrace = true;
            Throwable rootCause = ExceptionUtils.getRootCause((Throwable)e);
            if (e instanceof TextTooLongException || rootCause instanceof TextTooLongException) {
                errorCode = 413;
                response = e.getMessage();
                logStacktrace = false;
            } else if (e instanceof ErrorRateTooHighException || rootCause instanceof ErrorRateTooHighException) {
                errorCode = 400;
                response = ExceptionUtils.getRootCause((Throwable)e).getMessage();
                logStacktrace = false;
            } else if (this.hasCause(e, AuthException.class)) {
                errorCode = 403;
                response = AuthException.class.getName() + ": " + e.getMessage();
                logStacktrace = false;
            } else if (e instanceof BadRequestException || rootCause instanceof BadRequestException) {
                errorCode = 400;
                response = e.getMessage();
            } else if (e instanceof PathNotFoundException || rootCause instanceof PathNotFoundException) {
                errorCode = 404;
                response = e.getMessage();
            } else if (e instanceof TimeoutException || rootCause instanceof TimeoutException) {
                errorCode = 500;
                response = e.getMessage().contains("Checking took longer than") ? e.getMessage() : "Checking took longer than " + (float)this.config.getMaxCheckTimeMillisAnonymous() / 1000.0f + " seconds, which is this server's limit. Please make sure you have selected the proper language or consider submitting a shorter text.";
            } else if (e instanceof UnavailableException) {
                errorCode = 503;
                response = e.getMessage();
            } else {
                response = "Internal Error: " + e.getMessage();
                errorCode = 500;
                textLoggingAllowed = true;
            }
            long endTime = System.currentTimeMillis();
            this.logError(remoteAddress, e, errorCode, httpExchange, parameters, textLoggingAllowed, logStacktrace, endTime - startTime);
            this.sendError(httpExchange, errorCode, "Error: " + response);
            globalSpan.recordException((Throwable)e);
            globalSpan.setStatus(StatusCode.ERROR);
            return;
        }
        finally {
            logger.info("Handled request in {}ms; sending code {}", (Object)(System.currentTimeMillis() - startTime), (Object)httpExchange.getResponseCode());
            httpExchange.close();
            mdcRequestID.close();
            globalSpan.setAttribute(SemanticAttributes.HTTP_STATUS_CODE, httpExchange.getResponseCode());
            globalSpan.end();
            if (incrementHandleCount) {
                this.reqCounter.decrementHandleCount(reqId);
            }
        }
    }

    private boolean allowSkipRequestLimit(Headers requestHeaders) {
        if (this.config.getRequestLimitAccessToken() == null) {
            return false;
        }
        if (!requestHeaders.containsKey(REQUEST_LIMIT_ACCESS_TOKEN_HEADER)) {
            return false;
        }
        return this.config.getRequestLimitAccessToken().equals(requestHeaders.getFirst(REQUEST_LIMIT_ACCESS_TOKEN_HEADER));
    }

    private boolean limitPath(String path) {
        return !path.endsWith("admin/refreshUser");
    }

    @NotNull
    static String getRequestId(HttpExchange httpExchange) {
        String requestId = httpExchange.getRequestHeaders().getFirst("X-Request-ID");
        if (requestId == null) {
            requestId = "-";
        }
        return requestId;
    }

    private boolean hasCause(Exception e, Class<AuthException> clazz) {
        for (Throwable throwable : ExceptionUtils.getThrowableList((Throwable)e)) {
            if (!throwable.getClass().equals(clazz)) continue;
            return true;
        }
        return false;
    }

    private boolean workQueueFull(HttpExchange httpExchange, Map<String, String> parameters, String response) throws IOException {
        if (this.config.getMaxWorkQueueSize() != 0 && this.workQueue.size() > this.config.getMaxWorkQueueSize()) {
            String message = response + " queue size: " + this.workQueue.size() + ", maximum size: " + this.config.getMaxWorkQueueSize();
            this.logError(message, 503, parameters, httpExchange);
            this.sendError(httpExchange, 503, "Error: " + response);
            return true;
        }
        return false;
    }

    private boolean textCheckerQueueFull(HttpExchange httpExchange, String response) throws IOException {
        if (this.textCheckerV2.checkerQueueAlmostFull()) {
            this.sendError(httpExchange, 503, "Error: " + response);
            return true;
        }
        return false;
    }

    @NotNull
    private String getTextOrDataSizeMessage(Map<String, String> parameters) {
        String text = parameters.get("text");
        if (text != null) {
            return "Text size: " + text.length() + ".";
        }
        String data = parameters.get("data");
        if (data != null) {
            return "Data size: " + data.length() + ".";
        }
        return "";
    }

    private void logError(String errorMessage, int code, Map<String, String> params, HttpExchange httpExchange) {
        this.logError(errorMessage, code, params, httpExchange, true);
    }

    private void logError(String errorMessage, int code, Map<String, String> params, HttpExchange httpExchange, boolean logToDb) {
        String message = errorMessage + ", sending code " + code + " - useragent: " + params.get("useragent") + " - HTTP UserAgent: " + ServerTools.getHttpUserAgent(httpExchange) + ", r:" + this.reqCounter.getRequestCount();
        if (params.get("username") != null) {
            message = message + ", user: " + params.get("username");
        }
        if (params.get("apiKey") != null) {
            message = message + ", apiKey: " + params.get("apiKey");
        }
        message = message + ", referrer: " + ServerTools.getHttpReferrer(httpExchange);
        message = message + ", language: " + params.get("language");
        message = message + ", " + this.getTextOrDataSizeMessage(params);
        logger.error(message);
    }

    private void logError(String remoteAddress, Exception e, int errorCode, HttpExchange httpExchange, Map<String, String> params, boolean textLoggingAllowed, boolean logStacktrace, long runtimeMillis) {
        String message = ServerTools.getLoggingInfo(remoteAddress, e, errorCode, httpExchange, params, runtimeMillis, this.reqCounter);
        String text = params.get("text");
        if (text != null) {
            message = message + "text length: " + text.length() + ", ";
        }
        try {
            message = message + "m: " + ServerTools.getMode(params) + ", ";
        }
        catch (BadRequestException ex) {
            message = message + "m: invalid, ";
        }
        try {
            message = message + "l: " + ServerTools.getLevel(params) + ", ";
        }
        catch (BadRequestException ex) {
            message = message + "l: invalid, ";
        }
        if (params.containsKey("instanceId")) {
            message = message + "iID: " + params.get("instanceId") + ", ";
        }
        if (logStacktrace) {
            message = message + "Stacktrace follows:";
            String stackTrace = ExceptionUtils.getStackTrace((Throwable)e);
            message = message + ServerTools.cleanUserTextFromMessage(stackTrace, params);
        } else {
            message = message + "(no stacktrace logged)";
        }
        if (errorCode < 500) {
            logger.info(LoggingTools.BAD_REQUEST, message);
        } else if (e.getMessage() != null && e.getMessage().contains("took longer than")) {
            logger.warn(LoggingTools.REQUEST, message);
        } else {
            logger.error(LoggingTools.REQUEST, message);
        }
        if (!(e instanceof TextTooLongException) && !(e instanceof TooManyRequestsException) && !(ExceptionUtils.getRootCause((Throwable)e) instanceof ErrorRateTooHighException) && !(e.getCause() instanceof TimeoutException) && this.config.isVerbose() && text != null && textLoggingAllowed) {
            ServerTools.print("Exception was caused by this text (" + text.length() + " chars, showing up to 500):\n" + StringUtils.abbreviate((String)text, (int)500), System.err);
        }
    }

    @Nullable
    private String getRealRemoteAddressOrNull(HttpExchange httpExchange) {
        Object forwardedIpsStr;
        if (this.config.getTrustXForwardForHeader() && (forwardedIpsStr = httpExchange.getRequestHeaders().get("X-forwarded-for")) != null && forwardedIpsStr.size() > 0) {
            return (String)forwardedIpsStr.get(0);
        }
        return null;
    }

    private void sendError(HttpExchange httpExchange, int httpReturnCode, String response) throws IOException {
        ServerTools.setAllowOrigin(httpExchange, this.config.getAllowOriginUrl());
        httpExchange.sendResponseHeaders(httpReturnCode, response.getBytes(ENCODING).length);
        httpExchange.getResponseBody().write(response.getBytes(ENCODING));
        ServerMetricsCollector.getInstance().logResponse(httpReturnCode);
    }

    private Map<String, String> getRequestQuery(HttpExchange httpExchange, URI requestedUri) throws IOException {
        HashMap<String, String> params = new HashMap<String, String>();
        if ("post".equalsIgnoreCase(httpExchange.getRequestMethod())) {
            try (InputStreamReader isr = new InputStreamReader(httpExchange.getRequestBody(), ENCODING);){
                params.putAll(this.parseQuery(this.readerToString(isr, this.config.getMaxTextHardLength()), httpExchange));
                params.putAll(this.parseQuery(requestedUri.getRawQuery(), httpExchange));
                HashMap<String, String> hashMap = params;
                return hashMap;
            }
        }
        return this.parseQuery(requestedUri.getRawQuery(), httpExchange);
    }

    private String readerToString(Reader reader, int maxTextLength) throws IOException {
        int readBytes;
        StringBuilder sb = new StringBuilder();
        char[] chars = new char[4000];
        while ((readBytes = reader.read(chars, 0, 4000)) > 0) {
            int generousMaxLength = maxTextLength * 10;
            if (generousMaxLength < 0) {
                generousMaxLength = Integer.MAX_VALUE;
            }
            if (sb.length() > 0 && sb.length() > generousMaxLength) {
                throw new TextTooLongException("Your text's length exceeds this server's hard limit of " + generousMaxLength + " characters.");
            }
            sb.append(new String(chars, 0, readBytes));
        }
        return sb.toString();
    }

    private Map<String, String> parseQuery(String query, HttpExchange httpExchange) throws UnsupportedEncodingException {
        HashMap<String, String> parameters = new HashMap<String, String>();
        if (query != null) {
            parameters.putAll(this.getParameterMap(query, httpExchange));
        }
        return parameters;
    }

    private Map<String, String> getParameterMap(String query, HttpExchange httpExchange) throws UnsupportedEncodingException {
        String[] pairs = QUERY_PARAM_SPLIT.split(query);
        HashMap<String, String> parameters = new HashMap<String, String>();
        for (String pair : pairs) {
            int delimPos = pair.indexOf(61);
            if (delimPos == -1) continue;
            String param = pair.substring(0, delimPos);
            String key = URLDecoder.decode(param, ENCODING);
            try {
                String value = URLDecoder.decode(pair.substring(delimPos + 1), ENCODING);
                parameters.put(key, value);
            }
            catch (IllegalArgumentException e) {
                throw new BadRequestException("Could not decode query. Query length: " + query.length() + " Request method: " + httpExchange.getRequestMethod());
            }
        }
        return parameters;
    }
}

