/*
 * Decompiled with CFR 0.152.
 */
package com.hankcs.hanlp.suggest.scorer;

import com.hankcs.hanlp.suggest.scorer.IScorer;
import com.hankcs.hanlp.suggest.scorer.ISentenceKey;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;

public abstract class BaseScorer<T extends ISentenceKey>
implements IScorer {
    protected Map<T, Set<String>> storage = new TreeMap<T, Set<String>>();
    public double boost = 1.0;

    public BaseScorer setBoost(double boost) {
        this.boost = boost;
        return this;
    }

    @Override
    public void addSentence(String sentence) {
        T key = this.generateKey(sentence);
        if (key == null) {
            return;
        }
        Set<String> set = this.storage.get(key);
        if (set == null) {
            set = new TreeSet<String>();
            this.storage.put(key, set);
        }
        set.add(sentence);
    }

    protected abstract T generateKey(String var1);

    @Override
    public Map<String, Double> computeScore(String outerSentence) {
        TreeMap<String, Double> result = new TreeMap<String, Double>(Collections.reverseOrder());
        ISentenceKey keyOuter = this.generateKey(outerSentence);
        if (keyOuter == null) {
            return result;
        }
        for (Map.Entry<T, Set<String>> entry : this.storage.entrySet()) {
            ISentenceKey key = (ISentenceKey)entry.getKey();
            Double score = keyOuter.similarity((ISentenceKey)key);
            for (String sentence : entry.getValue()) {
                result.put(sentence, score);
            }
        }
        return result;
    }

    @Override
    public void removeAllSentences() {
        this.storage.clear();
    }
}

