/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io.remotecontrol;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.swing.AbstractAction;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import org.openstreetmap.josm.command.ChangePropertyCommand;
import org.openstreetmap.josm.data.UndoRedoHandler;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.gui.util.TableHelper;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.TextTagParser;

public class AddTagsDialog
extends ExtendedDialog {
    private final JTable propertyTable;
    private final transient Collection<? extends OsmPrimitive> sel;
    private final int[] count;
    private final String sender;
    private static final Set<String> trustedSenders = new HashSet<String>();

    public AddTagsDialog(String[][] tags, String senderName, Collection<? extends OsmPrimitive> primitives) {
        super((Component)MainApplication.getMainFrame(), I18n.tr("Add tags to selected objects", new Object[0]), new String[]{I18n.tr("Add selected tags", new Object[0]), I18n.tr("Add all tags", new Object[0]), I18n.tr("Cancel", new Object[0])}, false, true);
        this.setToolTipTexts(I18n.tr("Add checked tags to selected objects", new Object[0]), I18n.tr("Shift+Enter: Add all tags to selected objects", new Object[0]), "");
        this.sender = senderName;
        PropertyTableModel tm = new PropertyTableModel(tags.length);
        this.sel = primitives;
        this.count = new int[tags.length];
        for (int i = 0; i < tags.length; ++i) {
            this.count[i] = 0;
            String key = tags[i][0];
            String value = tags[i][1];
            boolean b = Boolean.TRUE;
            ExistingValues old = new ExistingValues(key);
            for (OsmPrimitive osmPrimitive : this.sel) {
                String oldValue = osmPrimitive.get(key);
                if (oldValue == null) continue;
                old.addValue(oldValue);
                if (oldValue.equals(value)) continue;
                b = Boolean.FALSE;
                int n = i;
                this.count[n] = this.count[n] + 1;
            }
            tm.setValueAt(b, i, 0);
            tm.setValueAt(tags[i][0], i, 1);
            tm.setValueAt(tags[i][1].isEmpty() ? new DeleteTagMarker(this.count[i]) : tags[i][1], i, 2);
            tm.setValueAt(old, i, 3);
        }
        this.propertyTable = new JTable(tm){

            @Override
            public Component prepareRenderer(TableCellRenderer renderer, int row, int column) {
                Component c = super.prepareRenderer(renderer, row, column);
                if (AddTagsDialog.this.count[row] > 0) {
                    c.setFont(c.getFont().deriveFont(2));
                    c.setForeground(new Color(100, 100, 100));
                } else {
                    c.setFont(c.getFont().deriveFont(0));
                    c.setForeground(new Color(0, 0, 0));
                }
                return c;
            }

            @Override
            public TableCellEditor getCellEditor(int row, int column) {
                Object value = this.getValueAt(row, column);
                if (value instanceof DeleteTagMarker) {
                    return null;
                }
                if (value instanceof ExistingValues) {
                    return null;
                }
                return this.getDefaultEditor(value.getClass());
            }

            @Override
            public String getToolTipText(MouseEvent event) {
                int r = this.rowAtPoint(event.getPoint());
                int c = this.columnAtPoint(event.getPoint());
                if (r < 0 || c < 0) {
                    return this.getToolTipText();
                }
                Object o = this.getValueAt(r, c);
                if (c == 1 || c == 2) {
                    return o.toString();
                }
                if (c == 3) {
                    return ((ExistingValues)o).getToolTip();
                }
                return I18n.tr("Enable the checkbox to accept the value", new Object[0]);
            }
        };
        TableHelper.setFont(this.propertyTable, this.getClass());
        this.propertyTable.setAutoCreateRowSorter(true);
        this.propertyTable.setAutoResizeMode(3);
        this.propertyTable.getColumnModel().getColumn(0).setMaxWidth(15);
        TableHelper.adjustColumnWidth(this.propertyTable, 1, 150);
        TableHelper.adjustColumnWidth(this.propertyTable, 2, 400);
        TableHelper.adjustColumnWidth(this.propertyTable, 3, 300);
        this.propertyTable.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        this.propertyTable.getInputMap().put(KeyStroke.getKeyStroke(10, 64), "shiftenter");
        this.propertyTable.getActionMap().put("shiftenter", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AddTagsDialog.this.buttonAction(1, e);
            }
        });
        JPanel tablePanel = new JPanel(new GridBagLayout());
        tablePanel.add((Component)this.propertyTable.getTableHeader(), GBC.eol().fill(2));
        tablePanel.add((Component)this.propertyTable, GBC.eol().fill(1));
        if (!this.sender.isEmpty() && !trustedSenders.contains(this.sender)) {
            final JCheckBox c = new JCheckBox();
            c.setAction(new AbstractAction(I18n.tr("Accept all tags from {0} for this session", this.sender)){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (c.isSelected()) {
                        trustedSenders.add(AddTagsDialog.this.sender);
                    } else {
                        trustedSenders.remove(AddTagsDialog.this.sender);
                    }
                }
            });
            tablePanel.add((Component)c, GBC.eol().insets(20, 10, 0, 0));
        }
        this.setContent(tablePanel);
        this.setDefaultButton(2);
    }

    @Override
    protected void buttonAction(int buttonIndex, ActionEvent evt) {
        if (buttonIndex != 2 && MainApplication.getLayerManager().getEditDataSet() != null) {
            TableModel tm = this.propertyTable.getModel();
            for (int i = 0; i < tm.getRowCount(); ++i) {
                if (buttonIndex != 1 && !Boolean.TRUE.equals(tm.getValueAt(i, 0))) continue;
                String key = (String)tm.getValueAt(i, 1);
                Object value = tm.getValueAt(i, 2);
                UndoRedoHandler.getInstance().add(new ChangePropertyCommand(this.sel, key, value instanceof String ? (String)value : ""));
            }
        }
        if (buttonIndex == 2) {
            trustedSenders.remove(this.sender);
        }
        this.setVisible(false);
    }

    public static void addTags(Map<String, String> args, String sender, Collection<? extends OsmPrimitive> primitives) {
        if (args.containsKey("addtags")) {
            GuiHelper.executeByMainWorkerInEDT(() -> {
                /*
                 * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                 * 
                 * java.lang.UnsupportedOperationException
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:87)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.CastExpression.applyExpressionRewriter(CastExpression.java:128)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
                 *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredAssignment.rewriteExpressions(StructuredAssignment.java:146)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                 *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1050)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                 *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                 *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                 *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                 *     at org.benf.cfr.reader.Main.main(Main.java:54)
                 */
                throw new IllegalStateException("Decompilation failed");
            });
        }
    }

    public static Map<String, String> parseUrlTagsToKeyValues(String urlSection) {
        Map<String, String> tags = TextTagParser.readTagsByRegexp(urlSection, "\\|", "(.*?)=(.*?)", false);
        return tags == null ? Collections.emptyMap() : tags;
    }

    public static void addTags(String[][] keyValue, String sender, Collection<? extends OsmPrimitive> primitives) {
        if (trustedSenders.contains(sender)) {
            if (MainApplication.getLayerManager().getEditDataSet() != null) {
                for (String[] row : keyValue) {
                    UndoRedoHandler.getInstance().add(new ChangePropertyCommand(primitives, row[0], row[1]));
                }
            }
        } else {
            new AddTagsDialog(keyValue, sender, primitives).showDialog();
        }
    }

    private static /* synthetic */ String[][] lambda$addTags$1(int x$0) {
        return new String[x$0][];
    }

    static final class PropertyTableModel
    extends DefaultTableModel {
        private final Class<?>[] types = new Class[]{Boolean.class, String.class, Object.class, ExistingValues.class};

        PropertyTableModel(int rowCount) {
            super(new String[]{I18n.tr("Assume", new Object[0]), I18n.tr("Key", new Object[0]), I18n.tr("Value", new Object[0]), I18n.tr("Existing values", new Object[0])}, rowCount);
        }

        @Override
        public Class<?> getColumnClass(int c) {
            return this.types[c];
        }
    }

    static class ExistingValues {
        private final String tag;
        private final Map<String, Integer> valueCount;

        ExistingValues(String tag) {
            this.tag = tag;
            this.valueCount = new HashMap<String, Integer>();
        }

        int addValue(String val) {
            Integer c = this.valueCount.get(val);
            int r = c == null ? 1 : c + 1;
            this.valueCount.put(val, r);
            return r;
        }

        public String toString() {
            return String.join((CharSequence)", ", this.valueCount.keySet());
        }

        private String getToolTip() {
            return this.valueCount.entrySet().stream().map(e -> "<b>" + String.valueOf(e.getValue()) + " x </b>" + (String)e.getKey() + "<br/>").collect(Collectors.joining("", "<html>" + I18n.tr("Old values of", new Object[0]) + " <b>" + this.tag + "</b><br/>", "</html>"));
        }
    }

    static class DeleteTagMarker {
        private final int num;

        DeleteTagMarker(int num) {
            this.num = num;
        }

        public String toString() {
            return I18n.tr("<delete from {0} objects>", this.num);
        }
    }
}

