/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.tools;

import java.awt.Dimension;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.Utils;

public final class ImageWarp {
    private ImageWarp() {
    }

    public static BufferedImage warp(BufferedImage srcImg, Dimension targetDim, PointTransform invTransform, Interpolation interpolation) {
        BufferedImage imgTarget = new BufferedImage(targetDim.width, targetDim.height, 2);
        Rectangle2D.Double srcRect = new Rectangle2D.Double(0.0, 0.0, srcImg.getWidth(), srcImg.getHeight());
        int[] pixel = new int[1];
        Object sharedArray = ImageWarp.getSharedArray(srcImg);
        for (int j = 0; j < imgTarget.getHeight(); ++j) {
            for (int i = 0; i < imgTarget.getWidth(); ++i) {
                int rgba;
                Point2D srcCoord = invTransform.transform(i, j);
                if (!srcRect.contains(srcCoord)) continue;
                switch (interpolation.ordinal()) {
                    case 0: {
                        rgba = ImageWarp.getColor((int)Math.round(srcCoord.getX()), (int)Math.round(srcCoord.getY()), srcImg, sharedArray);
                        break;
                    }
                    case 1: {
                        int x0 = (int)Math.floor(srcCoord.getX());
                        double dx = srcCoord.getX() - (double)x0;
                        int y0 = (int)Math.floor(srcCoord.getY());
                        double dy = srcCoord.getY() - (double)y0;
                        int c00 = ImageWarp.getColor(x0, y0, srcImg, sharedArray);
                        int c01 = ImageWarp.getColor(x0, y0 + 1, srcImg, sharedArray);
                        int c10 = ImageWarp.getColor(x0 + 1, y0, srcImg, sharedArray);
                        int c11 = ImageWarp.getColor(x0 + 1, y0 + 1, srcImg, sharedArray);
                        rgba = 0;
                        for (int ch = 0; ch <= 3; ++ch) {
                            int shift = 8 * ch;
                            int chVal = (int)Math.round(((double)(c00 >> shift & 0xFF) * (1.0 - dx) + (double)(c10 >> shift & 0xFF) * dx) * (1.0 - dy) + ((double)(c01 >> shift & 0xFF) * (1.0 - dx) + (double)(c11 >> shift & 0xFF) * dx) * dy);
                            rgba |= chVal << shift;
                        }
                        break;
                    }
                    default: {
                        throw new AssertionError((Object)Objects.toString((Object)interpolation));
                    }
                }
                imgTarget.getRaster().setDataElements(i, j, imgTarget.getColorModel().getDataElements(rgba, pixel));
            }
        }
        return imgTarget;
    }

    private static Object getSharedArray(BufferedImage srcImg) {
        int numBands = srcImg.getRaster().getNumBands();
        switch (srcImg.getRaster().getDataBuffer().getDataType()) {
            case 0: {
                return new byte[numBands];
            }
            case 3: {
                return new int[numBands];
            }
        }
        return null;
    }

    private static int getColor(int x, int y, BufferedImage img, Object sharedArray) {
        int rx = Utils.clamp(x, 0, img.getWidth() - 1);
        int ry = Utils.clamp(y, 0, img.getHeight() - 1);
        if (sharedArray == null) {
            return img.getRGB(rx, ry);
        }
        return img.getColorModel().getRGB(img.getRaster().getDataElements(rx, ry, sharedArray));
    }

    @FunctionalInterface
    public static interface PointTransform {
        public Point2D transform(double var1, double var3);
    }

    public static enum Interpolation {
        NEAREST_NEIGHBOR,
        BILINEAR;

    }

    public static class GridTransform
    implements PointTransform {
        private final double stride;
        private final PointTransform trfm;
        private final Map<Integer, Map<Integer, Point2D>> cache;
        private final boolean consistencyTest;
        private final Set<Integer> deletedRows;

        public GridTransform(PointTransform trfm, double stride) {
            this.trfm = trfm;
            this.stride = stride;
            this.cache = new HashMap<Integer, Map<Integer, Point2D>>();
            this.consistencyTest = Logging.isDebugEnabled();
            this.deletedRows = this.consistencyTest ? new HashSet<Integer>() : null;
        }

        @Override
        public Point2D transform(double x, double y) {
            int xIdx = (int)Math.floor(x / this.stride);
            int yIdx = (int)Math.floor(y / this.stride);
            double dx = x / this.stride - (double)xIdx;
            double dy = y / this.stride - (double)yIdx;
            Point2D value00 = this.getValue(xIdx, yIdx);
            Point2D value01 = this.getValue(xIdx, yIdx + 1);
            Point2D value10 = this.getValue(xIdx + 1, yIdx);
            Point2D value11 = this.getValue(xIdx + 1, yIdx + 1);
            double valueX = (value00.getX() * (1.0 - dx) + value10.getX() * dx) * (1.0 - dy) + (value01.getX() * (1.0 - dx) + value11.getX() * dx) * dy;
            double valueY = (value00.getY() * (1.0 - dx) + value10.getY() * dx) * (1.0 - dy) + (value01.getY() * (1.0 - dx) + value11.getY() * dx) * dy;
            return new Point2D.Double(valueX, valueY);
        }

        private Point2D getValue(int xIdx, int yIdx) {
            Map<Integer, Point2D> rowMap = this.getRow(yIdx);
            Point2D current = rowMap.get(xIdx);
            if (current == null) {
                current = this.trfm.transform((double)xIdx * this.stride, (double)yIdx * this.stride);
                rowMap.put(xIdx, current);
            }
            return current;
        }

        private Map<Integer, Point2D> getRow(int yIdx) {
            this.cleanUp(yIdx - 3);
            Map<Integer, Point2D> row = this.cache.get(yIdx);
            if (row == null) {
                row = new HashMap<Integer, Point2D>(256);
                this.cache.put(yIdx, row);
                if (this.consistencyTest) {
                    if (this.deletedRows.contains(yIdx)) {
                        throw new AssertionError();
                    }
                    if (this.cache.size() > 3) {
                        throw new AssertionError();
                    }
                }
            }
            return row;
        }

        private void cleanUp(int yIdx) {
            Map<Integer, Point2D> del = this.cache.remove(yIdx);
            if (this.consistencyTest && del != null) {
                if (this.deletedRows.contains(yIdx)) {
                    throw new AssertionError();
                }
                this.deletedRows.add(yIdx);
            }
        }
    }
}

