/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.projection.proj;

import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.projection.CustomProjection;
import org.openstreetmap.josm.data.projection.Ellipsoid;
import org.openstreetmap.josm.data.projection.ProjectionConfigurationException;
import org.openstreetmap.josm.data.projection.proj.AbstractProj;
import org.openstreetmap.josm.data.projection.proj.ProjParameters;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Utils;

public class LambertConformalConic
extends AbstractProj {
    protected Ellipsoid ellps;
    private Parameters params;
    protected double n;
    protected double f;
    protected double r0;
    protected static final double epsilon = 1.0E-12;

    @Override
    public void initialize(ProjParameters params) throws ProjectionConfigurationException {
        super.initialize(params);
        this.ellps = params.ellps;
        if (params.lat0 == null) {
            throw new ProjectionConfigurationException(I18n.tr("Parameter ''{0}'' required.", CustomProjection.Param.lat_0.key));
        }
        if (params.lat1 != null && params.lat2 != null) {
            this.params = new Parameters2SP(params.lat0, params.lat1, params.lat2);
            this.initialize2SP(Utils.toRadians(params.lat0), Utils.toRadians(params.lat1), Utils.toRadians(params.lat2));
        } else {
            this.params = new Parameters1SP(params.lat0);
            this.initialize1SP(Utils.toRadians(params.lat0));
        }
    }

    private void initialize2SP(double lat0, double lat1, double lat2) {
        double cosphi1 = Math.cos(lat1);
        double sinphi1 = Math.sin(lat1);
        double cosphi2 = Math.cos(lat2);
        double sinphi2 = Math.sin(lat2);
        double m1 = this.msfn(sinphi1, cosphi1);
        double m2 = this.msfn(sinphi2, cosphi2);
        double t0 = this.tsfn(lat0, Math.sin(lat0));
        double t1 = this.tsfn(lat1, sinphi1);
        double t2 = this.tsfn(lat2, sinphi2);
        this.n = Math.log(m1 / m2) / Math.log(t1 / t2);
        this.f = m1 * Math.pow(t1, -this.n) / this.n;
        this.r0 = this.f * Math.pow(t0, this.n);
    }

    private void initialize1SP(double lat0) {
        double m0 = this.msfn(Math.sin(lat0), Math.cos(lat0));
        double t0 = this.tsfn(lat0, Math.sin(lat0));
        this.n = Math.sin(lat0);
        this.f = m0 * Math.pow(t0, -this.n) / this.n;
        this.r0 = this.f * Math.pow(t0, this.n);
    }

    @Override
    public String getName() {
        return I18n.tr("Lambert Conformal Conic", new Object[0]);
    }

    @Override
    public String getProj4Id() {
        return "lcc";
    }

    @Override
    public double[] project(double phi, double lambda) {
        double sinphi = Math.sin(phi);
        double l = 0.5 * Math.log((1.0 + sinphi) / (1.0 - sinphi)) - this.e / 2.0 * Math.log((1.0 + this.e * sinphi) / (1.0 - this.e * sinphi));
        double r = this.f * Math.exp(-this.n * l);
        double gamma = this.n * lambda;
        double x = r * Math.sin(gamma);
        double y = this.r0 - r * Math.cos(gamma);
        return new double[]{x, y};
    }

    @Override
    public double[] invproject(double east, double north) {
        double r = Math.sqrt(Math.pow(east, 2.0) + Math.pow(north - this.r0, 2.0));
        double gamma = Math.atan(east / (this.r0 - north));
        double lambda = gamma / this.n;
        double latIso = -1.0 / this.n * Math.log(Math.abs(r / this.f));
        double phi = this.ellps.latitude(latIso, this.e, 1.0E-12);
        return new double[]{phi, lambda};
    }

    public final Parameters getParameters() {
        return this.params;
    }

    @Override
    public Bounds getAlgorithmBounds() {
        double lat;
        if (this.params instanceof Parameters2SP) {
            Parameters2SP p2p = (Parameters2SP)this.params;
            lat = (p2p.standardParallel1 + p2p.standardParallel2) / 2.0;
        } else {
            lat = this.params.latitudeOrigin;
        }
        double minlat = Math.max(lat - 60.0, -89.0);
        double maxlat = Math.min(lat + 60.0, 89.0);
        return new Bounds(minlat, -85.0, maxlat, 85.0, false);
    }

    public static class Parameters2SP
    extends Parameters {
        public final double standardParallel1;
        public final double standardParallel2;

        public Parameters2SP(double latitudeOrigin, double standardParallel1, double standardParallel2) {
            super(latitudeOrigin);
            this.standardParallel1 = standardParallel1;
            this.standardParallel2 = standardParallel2;
        }
    }

    public static class Parameters {
        public final double latitudeOrigin;

        protected Parameters(double latitudeOrigin) {
            this.latitudeOrigin = latitudeOrigin;
        }
    }

    public static class Parameters1SP
    extends Parameters {
        public Parameters1SP(double latitudeOrigin) {
            super(latitudeOrigin);
        }
    }
}

