/*
  This file is part of TALER
  Copyright (C) 2019, 2021, 2025 Taler Systems SA

  TALER is free software; you can redistribute it and/or modify it under the
  terms of the GNU Affero General Public License as published by the Free Software
  Foundation; either version 3, or (at your option) any later version.

  TALER is distributed in the hope that it will be useful, but WITHOUT ANY
  WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
  A PARTICULAR PURPOSE.  See the GNU Affero General Public License for more details.

  You should have received a copy of the GNU Affero General Public License along with
  TALER; see the file COPYING.  If not, see <http://www.gnu.org/licenses/>
*/
/**
 * @file taler-merchant-httpd_terms.h
 * @brief Handle /terms requests to return the terms of service
 * @author Christian Grothoff
 */
#ifndef TALER_MERCHANT_HTTPD_GET_TERMS_H
#define TALER_MERCHANT_HTTPD_GET_TERMS_H

#include "taler-merchant-httpd.h"

/**
 * Handle a "/terms" request.
 *
 * @param rh this struct
 * @param connection the MHD connection to handle
 * @param[in,out] hc context with further information about the request
 * @return MHD result code
 */
MHD_RESULT
TMH_handler_terms (const struct TMH_RequestHandler *rh,
                   struct MHD_Connection *connection,
                   struct TMH_HandlerContext *rc);


/**
 * Handle a "/privacy" request.
 *
 * @param rc request context
 * @param args array of additional options (must be empty for this function)
 * @return MHD result code
 */
MHD_RESULT
TMH_handler_privacy (const struct TMH_RequestHandler *rh,
                     struct MHD_Connection *connection,
                     struct TMH_HandlerContext *rc);


/**
 * Load our terms of service as per configuration.
 *
 * @param cfg configuration to process
 */
void
TMH_load_terms (const struct GNUNET_CONFIGURATION_Handle *cfg);


#endif
