/*
  This file is part of TALER
  (C) 2025 Taler Systems SA

  TALER is free software; you can redistribute it and/or modify it under the
  terms of the GNU Affero General Public License as published by the Free Software
  Foundation; either version 3, or (at your option) any later version.

  TALER is distributed in the hope that it will be useful, but WITHOUT ANY
  WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
  A PARTICULAR PURPOSE.  See the GNU General Public License for more details.

  You should have received a copy of the GNU General Public License along with
  TALER; see the file COPYING.  If not, see <http://www.gnu.org/licenses/>
*/
/**
 * @file taler-merchant-httpd_private-delete-units-ID.c
 * @brief implement DELETE /private/units/$UNIT
 * @author Bohdan Potuzhnyi
 */
#include "platform.h"
#include "taler-merchant-httpd_private-delete-units-ID.h"


MHD_RESULT
TMH_private_delete_units_ID (const struct TMH_RequestHandler *rh,
                             struct MHD_Connection *connection,
                             struct TMH_HandlerContext *hc)
{
  enum GNUNET_DB_QueryStatus qs;
  bool no_instance = false;
  bool no_unit = false;
  bool builtin_conflict = false;

  GNUNET_assert (NULL != hc->infix);
  qs = TMH_db->delete_unit (TMH_db->cls,
                            hc->instance->settings.id,
                            hc->infix,
                            &no_instance,
                            &no_unit,
                            &builtin_conflict);
  switch (qs)
  {
  case GNUNET_DB_STATUS_SUCCESS_ONE_RESULT:
    break;
  case GNUNET_DB_STATUS_SOFT_ERROR:
    GNUNET_break (0);
    return TALER_MHD_reply_with_error (connection,
                                       MHD_HTTP_INTERNAL_SERVER_ERROR,
                                       TALER_EC_GENERIC_DB_SOFT_FAILURE,
                                       "delete_unit");
  case GNUNET_DB_STATUS_HARD_ERROR:
  default:
    GNUNET_break (0);
    return TALER_MHD_reply_with_error (connection,
                                       MHD_HTTP_INTERNAL_SERVER_ERROR,
                                       TALER_EC_GENERIC_DB_STORE_FAILED,
                                       "delete_unit");
  }
  if (no_instance)
    return TALER_MHD_reply_with_error (connection,
                                       MHD_HTTP_NOT_FOUND,
                                       TALER_EC_MERCHANT_GENERIC_INSTANCE_UNKNOWN,
                                       hc->instance->settings.id);
  if (no_unit)
    return TALER_MHD_reply_with_error (connection,
                                       MHD_HTTP_NOT_FOUND,
                                       TALER_EC_MERCHANT_GENERIC_UNIT_UNKNOWN,
                                       hc->infix);
  if (builtin_conflict)
    return TALER_MHD_reply_with_error (connection,
                                       MHD_HTTP_CONFLICT,
                                       TALER_EC_MERCHANT_GENERIC_UNIT_BUILTIN,
                                       hc->infix);
  return TALER_MHD_reply_static (connection,
                                 MHD_HTTP_NO_CONTENT,
                                 NULL,
                                 NULL,
                                 0);
}


/* end of taler-merchant-httpd_private-delete-units-ID.c */
