#!/bin/bash
set -eu

function step {
    echo -e "\n$@" >&2
}

ITEMS="libeufin-bank libeufin-nexus libeufin-ebisync"

step "Install libeufin"
dpkg -i ../libeufin*.deb

step "Install libeufin again"
dpkg -i ../libeufin*.deb

step "Start postgres cluster"
sudo -u postgres pg_ctlcluster 17 main start

for BIN in $ITEMS; do
    step "$BIN version:"
    $BIN --version
done

for USER in $ITEMS; do
    step "$USER user:"
    id $USER
done

step "Run dbconfig"
libeufin-dbconfig -r -c testbench/conf/mini.conf
libeufin-ebisync-dbconfig -r -c testbench/conf/mini.conf

for USER in $ITEMS; do
    step "Check $USER db access"
    sudo -u $USER psql -d libeufincheck -c "SELECT 1;" &> /dev/null
done

step "Check man pages"
for BIN in $ITEMS; do
    man $BIN > /dev/null
    man $BIN.conf > /dev/null
done

step "Remove libeufin"
dpkg --remove libeufin*

step "Reinstall libeufin"
dpkg -i ../libeufin*.deb

step "Purge libeufin:"
dpkg --purge libeufin*

step "Reinstall libeufin"
dpkg -i ../libeufin*.deb