/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.ExpressionVisitor;
import net.sf.saxon.expr.UnaryExpression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMajor;
import net.sf.saxon.expr.instruct.UserFunction;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.ValueRepresentation;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.SequenceExtent;
import net.sf.saxon.value.Value;

public final class TailCallLoop
extends UnaryExpression {
    UserFunction containingFunction;

    public TailCallLoop(UserFunction function) {
        super(function.getBody());
        this.containingFunction = function;
    }

    public UserFunction getContainingFunction() {
        return this.containingFunction;
    }

    public Expression typeCheck(ExpressionVisitor visitor, ItemType contextItemType) throws XPathException {
        this.operand = visitor.typeCheck(this.operand, contextItemType);
        return this;
    }

    public int getImplementationMethod() {
        return this.operand.getImplementationMethod();
    }

    public Expression copy() {
        throw new UnsupportedOperationException("TailCallLoop.copy()");
    }

    public SequenceIterator iterate(XPathContext context) throws XPathException {
        UserFunction fn;
        XPathContextMajor cm = (XPathContextMajor)context;
        do {
            SequenceIterator iter = this.operand.iterate(cm);
            ValueRepresentation extent = SequenceExtent.makeSequenceExtent(iter);
            fn = cm.getTailCallFunction();
            if (fn != null) continue;
            return Value.asIterator(extent);
        } while (fn == this.containingFunction);
        return Value.asIterator(this.tailCallDifferentFunction(fn, cm));
    }

    public Item evaluateItem(XPathContext context) throws XPathException {
        UserFunction fn;
        XPathContextMajor cm = (XPathContextMajor)context;
        do {
            Item item = this.operand.evaluateItem(context);
            fn = cm.getTailCallFunction();
            if (fn != null) continue;
            return item;
        } while (fn == this.containingFunction);
        return Value.asItem(this.tailCallDifferentFunction(fn, cm));
    }

    public void process(XPathContext context) throws XPathException {
        UserFunction fn;
        XPathContextMajor cm = (XPathContextMajor)context;
        do {
            this.operand.process(context);
            fn = cm.getTailCallFunction();
            if (fn != null) continue;
            return;
        } while (fn == this.containingFunction);
        Value.asValue(this.tailCallDifferentFunction(fn, cm)).process(cm);
    }

    private ValueRepresentation tailCallDifferentFunction(UserFunction fn, XPathContextMajor cm) throws XPathException {
        cm.resetStackFrameMap(fn.getStackFrameMap(), fn.getNumberOfArguments());
        try {
            return ExpressionTool.evaluate(fn.getBody(), fn.getEvaluationMode(), cm, 1);
        }
        catch (XPathException err) {
            err.maybeSetLocation(this);
            err.maybeSetContext(cm);
            throw err;
        }
    }

    public ItemType getItemType(TypeHierarchy th) {
        return this.operand.getItemType(th);
    }

    public String getExpressionName() {
        return "tailCallLoop";
    }
}

