import { ActionMeta, GroupBase } from "react-select";
import React, { FocusEventHandler, KeyboardEventHandler, RefObject } from "react";
import { StateManagerProps } from "react-select/dist/declarations/src/useStateManager";
import Select from "react-select/base";
type TValue = {
    value: string;
    label: string;
};
export type TCreatableSelectProps<Multiple> = Omit<StateManagerProps, "onChange"> & {
    creatable?: boolean;
    onChange?: (newValue: Multiple extends true ? TValue[] : TValue, actionMeta: ActionMeta<unknown>) => void;
    onBlur?: FocusEventHandler;
    onKeyDown?: KeyboardEventHandler;
    multiple: Multiple;
    completed?: boolean;
    options?: StateManagerProps<TValue>["options"];
    value?: TValue;
    className?: string;
    inputRef?: RefObject<Select<unknown, boolean, GroupBase<unknown>>>;
};
export declare function CreatableSelect<Multiple extends boolean>({ onBlur, onChange, onKeyDown, multiple, value, options, className, components, ...props }: React.PropsWithChildren<TCreatableSelectProps<Multiple>>): import("react/jsx-runtime").JSX.Element;
export {};
//# sourceMappingURL=CreatableSelect.d.ts.map