import { useEffect } from 'react';

// eslint-disable-next-line import/no-extraneous-dependencies

import { attachClosestEdge } from '@atlaskit/pragmatic-drag-and-drop-hitbox/closest-edge';
import { dropTargetForElements } from '@atlaskit/pragmatic-drag-and-drop/element/adapter';
import { rbdInvariant } from '../drag-drop-context/rbd-invariant';
import { isDraggableData } from '../draggable/data';
export function useDropTargetForDraggable(_ref) {
  var elementRef = _ref.elementRef,
    data = _ref.data,
    direction = _ref.direction,
    contextId = _ref.contextId,
    isDropDisabled = _ref.isDropDisabled,
    type = _ref.type;
  useEffect(function () {
    var element = elementRef.current;
    rbdInvariant(element instanceof HTMLElement);
    return dropTargetForElements({
      element: element,
      getIsSticky: function getIsSticky() {
        return true;
      },
      canDrop: function canDrop(_ref2) {
        var source = _ref2.source;
        if (!isDraggableData(source.data)) {
          // not dragging something from the migration layer
          // we should not allow dropping
          return false;
        }
        if (isDropDisabled) {
          return false;
        }
        return source.data.type === type && source.data.contextId === contextId;
      },
      getData: function getData(_ref3) {
        var input = _ref3.input;
        return attachClosestEdge(data, {
          element: element,
          input: input,
          allowedEdges: direction === 'vertical' ? ['top', 'bottom'] : ['left', 'right']
        });
      }
    });
  }, [data, direction, contextId, isDropDisabled, type, elementRef]);
}