/*========================== begin_copyright_notice ============================

Copyright (C) 2017-2021 Intel Corporation

SPDX-License-Identifier: MIT

============================= end_copyright_notice ===========================*/

/*
 * !!! DO NOT EDIT THIS FILE !!!
 *
 * This file was automagically crafted by GED's model parser.
 */

#include "ged.h"
#include "ged_decoding_tables.h"
#include "ged_enumerations_internal.h"
#include "ged_enum_tables.h"
#include "ged_enum_interpreters.h"
#include "common/ged_enum_types_internal.h"
#include "common/ged_string_utils.h"
#include "xcoder/ged_ins.h"
#include "xcoder/ged_interpreters.h"
#include "ged_collectors_tables.h"
#include "ged_model_none.h"
#include "ged_model_7.h"
#include "ged_model_7_5.h"
#include "ged_model_8.h"
#include "ged_model_8_1.h"
#include "ged_model_9.h"
#include "ged_model_10.h"
#include "ged_model_11.h"
#include "ged_model_tgl.h"
#include "ged_model_xe_hp.h"
#include "ged_model_xe_hpg.h"
#include "ged_model_xe_hpc_a.h"
#include "ged_model_xe_hpc.h"
#include "ged_model_xe_lpg_md.h"
#include "ged_model_xe2.h"
#include "ged_model_xe3.h"
#include "ged_model_xe3p_cri.h"

#ifdef GED_OBSCURE_MODEL_NAMES
#define GED_MODEL_NAME_STRING(name) ""

#else // GED_OBSCURE_MODEL_NAMES
#define GED_MODEL_NAME_STRING(name) name
#endif // GED_OBSCURE_MODEL_NAMES

#ifndef GED_MODELS_ARRAY_HIDDEN
ModelData ModelsArray[17] =
{
    { GED_MODEL_NS_NONE::Opcodes, GED_MODEL_NAME_STRING("none"), 160, (const ged_field_enum_table_t)OpcodeTable0, 0, NULL, 3, EnumInterpretersTable0, 0, NULL }, // 0
    { GED_MODEL_NS_7::Opcodes, GED_MODEL_NAME_STRING("7"), 160, (const ged_field_enum_table_t)OpcodeTable10, 29, PositionInterpreterTable0, 3, EnumInterpretersTable1, 0, NULL }, // 1
    { GED_MODEL_NS_7_5::Opcodes, GED_MODEL_NAME_STRING("7.5"), 160, (const ged_field_enum_table_t)OpcodeTable11, 30, PositionInterpreterTable1, 3, EnumInterpretersTable1, 0, NULL }, // 2
    { GED_MODEL_NS_8::Opcodes, GED_MODEL_NAME_STRING("8"), 160, (const ged_field_enum_table_t)OpcodeTable12, 33, PositionInterpreterTable2, 3, EnumInterpretersTable2, 0, NULL }, // 3
    { GED_MODEL_NS_8_1::Opcodes, GED_MODEL_NAME_STRING("8.1"), 160, (const ged_field_enum_table_t)OpcodeTable12, 33, PositionInterpreterTable2, 3, EnumInterpretersTable2, 0, NULL }, // 4
    { GED_MODEL_NS_9::Opcodes, GED_MODEL_NAME_STRING("9"), 160, (const ged_field_enum_table_t)OpcodeTable1, 35, PositionInterpreterTable3, 3, EnumInterpretersTable2, 0, NULL }, // 5
    { GED_MODEL_NS_10::Opcodes, GED_MODEL_NAME_STRING("10"), 160, (const ged_field_enum_table_t)OpcodeTable1, 35, PositionInterpreterTable4, 3, EnumInterpretersTable2, 0, NULL }, // 6
    { GED_MODEL_NS_11::Opcodes, GED_MODEL_NAME_STRING("11"), 160, (const ged_field_enum_table_t)OpcodeTable2, 35, PositionInterpreterTable5, 3, EnumInterpretersTable3, 0, NULL }, // 7
    { GED_MODEL_NS_TGL::Opcodes, GED_MODEL_NAME_STRING("tgl"), 160, (const ged_field_enum_table_t)OpcodeTable3, 36, PositionInterpreterTable6, 3, EnumInterpretersTable4, 0, NULL }, // 8
    { GED_MODEL_NS_XE_HP::Opcodes, GED_MODEL_NAME_STRING("xe.hp"), 160, (const ged_field_enum_table_t)OpcodeTable4, 35, PositionInterpreterTable7, 3, EnumInterpretersTable5, 0, NULL }, // 9
    { GED_MODEL_NS_XE_HPG::Opcodes, GED_MODEL_NAME_STRING("xe.hpg"), 160, (const ged_field_enum_table_t)OpcodeTable4, 45, PositionInterpreterTable8, 3, EnumInterpretersTable5, 0, NULL }, // 10
    { GED_MODEL_NS_XE_HPC_A::Opcodes, GED_MODEL_NAME_STRING("xe.hpc.a"), 160, (const ged_field_enum_table_t)OpcodeTable5, 45, PositionInterpreterTable9, 3, EnumInterpretersTable6, 0, NULL }, // 11
    { GED_MODEL_NS_XE_HPC::Opcodes, GED_MODEL_NAME_STRING("xe.hpc"), 160, (const ged_field_enum_table_t)OpcodeTable6, 45, PositionInterpreterTable9, 3, EnumInterpretersTable7, 0, NULL }, // 12
    { GED_MODEL_NS_XE_LPG_MD::Opcodes, GED_MODEL_NAME_STRING("xe.lpg.md"), 160, (const ged_field_enum_table_t)OpcodeTable7, 45, PositionInterpreterTable8, 3, EnumInterpretersTable5, 0, NULL }, // 13
    { GED_MODEL_NS_XE2::Opcodes, GED_MODEL_NAME_STRING("xe2"), 160, (const ged_field_enum_table_t)OpcodeTable6, 51, PositionInterpreterTable10, 3, EnumInterpretersTable7, 0, NULL }, // 14
    { GED_MODEL_NS_XE3::Opcodes, GED_MODEL_NAME_STRING("xe3"), 160, (const ged_field_enum_table_t)OpcodeTable8, 50, PositionInterpreterTable11, 3, EnumInterpretersTable0, 0, NULL }, // 15
    { GED_MODEL_NS_XE3P_CRI::Opcodes, GED_MODEL_NAME_STRING("xe3p.cri"), 160, (const ged_field_enum_table_t)OpcodeTable9, 2, PositionInterpreterTable12, 3, EnumInterpretersTable0, 0, NULL } // 16
}; // ModelsArray[]
#endif // GED_MODELS_ARRAY_HIDDEN
const unsigned int numOfSupportedModels = 17;

#ifndef GED_MODELS_ARRAY_NAMES_HIDDEN
const char* modelNames[17] = { GED_MODEL_NAME_STRING("none"), GED_MODEL_NAME_STRING("7"), GED_MODEL_NAME_STRING("7_5"), GED_MODEL_NAME_STRING("8"), GED_MODEL_NAME_STRING("8_1"), GED_MODEL_NAME_STRING("9"), GED_MODEL_NAME_STRING("10"), GED_MODEL_NAME_STRING("11"), GED_MODEL_NAME_STRING("tgl"), GED_MODEL_NAME_STRING("xe_hp"), GED_MODEL_NAME_STRING("xe_hpg"), GED_MODEL_NAME_STRING("xe_hpc_a"), GED_MODEL_NAME_STRING("xe_hpc"), GED_MODEL_NAME_STRING("xe_lpg_md"), GED_MODEL_NAME_STRING("xe2"), GED_MODEL_NAME_STRING("xe3"), GED_MODEL_NAME_STRING("xe3p_cri") };
#endif // GED_MODELS_ARRAY_NAMES_HIDDEN

#ifndef GED_MODELS_ARRAY_FUNCTION_HIDDEN

/*!
 * Get the GED_MODEL Id for the given model name.
 *
 * @param[in]       name   Name of the model to find.
 * @param[out]      model  Will hold the given model's Id if the model is found, otherwise unchanged.
 *
 * @return      TRUE if the given model name is valid, FALSE otherwise.
 */
bool GetModelByName(const string& name, /* GED_MODEL */ unsigned int& model)
{
    if (GED_MODEL_NAME_STRING("none") == name) model = GED_MODEL_NONE;
    else if (GED_MODEL_NAME_STRING("7") == name) model = GED_MODEL_7;
    else if (GED_MODEL_NAME_STRING("7_5") == name) model = GED_MODEL_7_5;
    else if (GED_MODEL_NAME_STRING("8") == name) model = GED_MODEL_8;
    else if (GED_MODEL_NAME_STRING("8_1") == name) model = GED_MODEL_8_1;
    else if (GED_MODEL_NAME_STRING("9") == name) model = GED_MODEL_9;
    else if (GED_MODEL_NAME_STRING("10") == name) model = GED_MODEL_10;
    else if (GED_MODEL_NAME_STRING("11") == name) model = GED_MODEL_11;
    else if (GED_MODEL_NAME_STRING("tgl") == name) model = GED_MODEL_TGL;
    else if (GED_MODEL_NAME_STRING("xe_hp") == name) model = GED_MODEL_XE_HP;
    else if (GED_MODEL_NAME_STRING("xe_hpg") == name) model = GED_MODEL_XE_HPG;
    else if (GED_MODEL_NAME_STRING("xe_hpc_a") == name) model = GED_MODEL_XE_HPC_A;
    else if (GED_MODEL_NAME_STRING("xe_hpc") == name) model = GED_MODEL_XE_HPC;
    else if (GED_MODEL_NAME_STRING("xe_lpg_md") == name) model = GED_MODEL_XE_LPG_MD;
    else if (GED_MODEL_NAME_STRING("xe2") == name) model = GED_MODEL_XE2;
    else if (GED_MODEL_NAME_STRING("xe3") == name) model = GED_MODEL_XE3;
    else if (GED_MODEL_NAME_STRING("xe3p_cri") == name) model = GED_MODEL_XE3P_CRI;
    else return false;
    return true;
}
#endif // GED_MODELS_ARRAY_FUNCTION_HIDDEN
const char* GED_GetModelVersionString(GED_MODEL model)
{
#ifndef GED_MODELS_ARRAY_HIDDEN
    unsigned int rawModel = static_cast<unsigned int>(model);
    if (rawModel < numOfSupportedModels)
        return ModelsArray[rawModel].modelVersion;
#endif
    return "";
}
const char* GED_GetReturnValueString(GED_RETURN_VALUE returnValue)
{
    unsigned int rawReturnValue = static_cast<unsigned int>(returnValue);
    if (rawReturnValue < GED_RETURN_VALUE_SIZE)
        return gedReturnValueStrings[returnValue];
    return "";
}
const char* GED_GetReturnValuePad(GED_RETURN_VALUE returnValue)
{
    unsigned int rawReturnValue = static_cast<unsigned int>(returnValue);
    if (rawReturnValue < GED_RETURN_VALUE_SIZE)
        return gedReturnValuePadding[returnValue];
    return "";
}
GED_RETURN_VALUE GED_InitEmptyIns(const GED_MODEL modelId, ged_ins_t* ins, GED_OPCODE opcode)
{
    return reinterpret_cast<GEDIns*>(ins)->Init(modelId, opcode);

}
GED_RETURN_VALUE GED_DecodeIns(const GED_MODEL modelId, const unsigned char* rawBytes, const uint32_t size, ged_ins_t* ins)
{
    return reinterpret_cast<GEDIns*>(ins)->Decode(modelId, rawBytes, size);
}
GED_RETURN_VALUE GED_EncodeIns(ged_ins_t* ins, const GED_INS_TYPE insType, unsigned char* rawBytes)
{
    return reinterpret_cast<GEDIns*>(ins)->Encode(insType, rawBytes);
}
uint32_t GED_InsSize(const ged_ins_t* ins)
{
    return reinterpret_cast<const GEDIns*>(ins)->GetInstructionSize();
}
bool GED_InsModified(const ged_ins_t* ins)
{
    return reinterpret_cast<const GEDIns*>(ins)->IsModified();
}

#if GED_VALIDATION_API
GED_RETURN_VALUE GED_CountCompactEncodings(ged_ins_t* ins, unsigned int& count)
{
    return reinterpret_cast<GEDIns*>(ins)->CountCompacted(count);
}
GED_RETURN_VALUE GED_GetCompactEncodings(ged_ins_t* ins, const unsigned int size, unsigned char* compactBytesArray)
{
    return reinterpret_cast<GEDIns*>(ins)->RetrieveAllCompactedFormats(size, compactBytesArray);
}
GED_RETURN_VALUE GED_PrintFieldBitLocation(const ged_ins_t* ins, const GED_INS_FIELD field)
{
    return reinterpret_cast<const GEDIns*>(ins)->PrintFieldBitLocation(field);
}
#endif // GED_VALIDATION_API
GED_RETURN_VALUE GED_QueryFieldBitLocation(const ged_ins_t* ins, const GED_INS_FIELD field, uint32_t * fragments, uint32_t * length)
{
    return reinterpret_cast<const GEDIns*>(ins)->QueryFieldBitLocation(field, fragments, length);
}
uint32_t GED_FieldSize(const ged_ins_t* ins, const GED_INS_FIELD field)
{
    return reinterpret_cast<const GEDIns*>(ins)->GetFieldSize(field);
}
GED_OPCODE GED_GetOpcode(const ged_ins_t* ins)
{
    return (GED_OPCODE)(reinterpret_cast<const GEDIns*>(ins)->GetOpcode());
}
const char* GED_GetMnemonic(const ged_ins_t* ins)
{
#ifndef GED_OPCODE_HIDDEN
    return GED_GetOpcodeString((GED_OPCODE)(reinterpret_cast<const GEDIns*>(ins)->GetOpcode()));
#else
    return "";
#endif
}
GED_RETURN_VALUE GED_SetOpcode(ged_ins_t* ins, const GED_OPCODE opcode)
{
    return reinterpret_cast<GEDIns*>(ins)->SetOpcode(opcode);
}
bool GED_IsCompact(const ged_ins_t* ins)
{
    return reinterpret_cast<const GEDIns*>(ins)->IsCompact();
}
GED_MODEL GED_GetModel(const ged_ins_t* ins)
{
    return (GED_MODEL)(reinterpret_cast<const GEDIns*>(ins)->GetCurrentModel());
}
uint32_t GED_Get___SrcImm(ged_ins_t* ins, GED_RETURN_VALUE* result)
{
    GED_RETURN_VALUE localResult = GED_RETURN_VALUE_INVALID_FIELD;
    if (NULL == result) result = &localResult;
    return reinterpret_cast<GEDIns*>(ins)->GetUnsignedField(GED_INS_FIELD____SrcImm, *result);
}
GED_RETURN_VALUE GED_Set___SrcImm(ged_ins_t* ins, const uint32_t value)
{
    return reinterpret_cast<GEDIns*>(ins)->SetUnsignedField(GED_INS_FIELD____SrcImm, value);
}
uint32_t GED_GetNumOfSourceOperands(ged_ins_t* ins, GED_RETURN_VALUE* result)
{
    GED_RETURN_VALUE localResult = GED_RETURN_VALUE_INVALID_FIELD;
    if (NULL == result) result = &localResult;
    return reinterpret_cast<GEDIns*>(ins)->GetUnsignedField(GED_INS_FIELD_NumOfSourceOperands, *result);
}
uint32_t GED_GetHasDestinationOperand(ged_ins_t* ins, GED_RETURN_VALUE* result)
{
    GED_RETURN_VALUE localResult = GED_RETURN_VALUE_INVALID_FIELD;
    if (NULL == result) result = &localResult;
    return reinterpret_cast<GEDIns*>(ins)->GetUnsignedField(GED_INS_FIELD_HasDestinationOperand, *result);
}
GED_ACCESS_MODE GED_GetAccessMode(ged_ins_t* ins, GED_RETURN_VALUE* result)
{
    GED_RETURN_VALUE localResult = GED_RETURN_VALUE_INVALID_FIELD;
    if (NULL == result) result = &localResult;
    const uint32_t value = reinterpret_cast<GEDIns*>(ins)->GetUnsignedField(GED_INS_FIELD_AccessMode, *result);
    return (GED_RETURN_VALUE_SUCCESS == *result) ? (GED_ACCESS_MODE)value : GED_ACCESS_MODE_INVALID;
}
GED_RETURN_VALUE GED_SetAccessMode(ged_ins_t* ins, const GED_ACCESS_MODE value)
{
    return reinterpret_cast<GEDIns*>(ins)->SetUnsignedField(GED_INS_FIELD_AccessMode, (const uint32_t)value);
}
GED_MASK_CTRL GED_GetMaskCtrl(ged_ins_t* ins, GED_RETURN_VALUE* result)
{
    GED_RETURN_VALUE localResult = GED_RETURN_VALUE_INVALID_FIELD;
    if (NULL == result) result = &localResult;
    const uint32_t value = reinterpret_cast<GEDIns*>(ins)->GetUnsignedField(GED_INS_FIELD_MaskCtrl, *result);
    return (GED_RETURN_VALUE_SUCCESS == *result) ? (GED_MASK_CTRL)value : GED_MASK_CTRL_INVALID;
}
GED_RETURN_VALUE GED_SetMaskCtrl(ged_ins_t* ins, const GED_MASK_CTRL value)
{
    return reinterpret_cast<GEDIns*>(ins)->SetUnsignedField(GED_INS_FIELD_MaskCtrl, (const uint32_t)value);
}
GED_DEP_CTRL GED_GetDepCtrl(ged_ins_t* ins, GED_RETURN_VALUE* result)
{
    GED_RETURN_VALUE localResult = GED_RETURN_VALUE_INVALID_FIELD;
    if (NULL == result) result = &localResult;
    const uint32_t value = reinterpret_cast<GEDIns*>(ins)->GetUnsignedField(GED_INS_FIELD_DepCtrl, *result);
    return (GED_RETURN_VALUE_SUCCESS == *result) ? (GED_DEP_CTRL)value : GED_DEP_CTRL_INVALID;
}
GED_RETURN_VALUE GED_SetDepCtrl(ged_ins_t* ins, const GED_DEP_CTRL value)
{
    return reinterpret_cast<GEDIns*>(ins)->SetUnsignedField(GED_INS_FIELD_DepCtrl, (const uint32_t)value);
}
GED_EXEC_MASK_OFFSET_CTRL GED_GetExecMaskOffsetCtrl(ged_ins_t* ins, GED_RETURN_VALUE* result)
{
    GED_RETURN_VALUE localResult = GED_RETURN_VALUE_INVALID_FIELD;
    if (NULL == result) result = &localResult;
    const uint32_t value = reinterpret_cast<GEDIns*>(ins)->GetUnsignedField(GED_INS_FIELD_ExecMaskOffsetCtrl, *result);
    return (GED_RETURN_VALUE_SUCCESS == *result) ? (GED_EXEC_MASK_OFFSET_CTRL)value : GED_EXEC_MASK_OFFSET_CTRL_INVALID;
}
GED_RETURN_VALUE GED_SetExecMaskOffsetCtrl(ged_ins_t* ins, const GED_EXEC_MASK_OFFSET_CTRL value)
{
    return reinterpret_cast<GEDIns*>(ins)->SetUnsignedField(GED_INS_FIELD_ExecMaskOffsetCtrl, (const uint32_t)value);
}
GED_CHANNEL_OFFSET GED_GetChannelOffset(ged_ins_t* ins, GED_RETURN_VALUE* result)
{
    GED_RETURN_VALUE localResult = GED_RETURN_VALUE_INVALID_FIELD;
    if (NULL == result) result = &localResult;
    const uint32_t value = reinterpret_cast<GEDIns*>(ins)->GetUnsignedField(GED_INS_FIELD_ChannelOffset, *result);
    return (GED_RETURN_VALUE_SUCCESS == *result) ? (GED_CHANNEL_OFFSET)value : GED_CHANNEL_OFFSET_INVALID;
}
GED_RETURN_VALUE GED_SetChannelOffset(ged_ins_t* ins, const GED_CHANNEL_OFFSET value)
{
    return reinterpret_cast<GEDIns*>(ins)->SetUnsignedField(GED_INS_FIELD_ChannelOffset, (const uint32_t)value);
}
GED_THREAD_CTRL GED_GetThreadCtrl(ged_ins_t* ins, GED_RETURN_VALUE* result)
{
    GED_RETURN_VALUE localResult = GED_RETURN_VALUE_INVALID_FIELD;
    if (NULL == result) result = &localResult;
    const uint32_t value = reinterpret_cast<GEDIns*>(ins)->GetUnsignedField(GED_INS_FIELD_ThreadCtrl, *result);
    return (GED_RETURN_VALUE_SUCCESS == *result) ? (GED_THREAD_CTRL)value : GED_THREAD_CTRL_INVALID;
}
GED_RETURN_VALUE GED_SetThreadCtrl(ged_ins_t* ins, const GED_THREAD_CTRL value)
{
    return reinterpret_cast<GEDIns*>(ins)->SetUnsignedField(GED_INS_FIELD_ThreadCtrl, (const uint32_t)value);
}
GED_PRED_CTRL GED_GetPredCtrl(ged_ins_t* ins, GED_RETURN_VALUE* result)
{
    GED_RETURN_VALUE localResult = GED_RETURN_VALUE_INVALID_FIELD;
    if (NULL == result) result = &localResult;
    const uint32_t value = reinterpret_cast<GEDIns*>(ins)->GetUnsignedField(GED_INS_FIELD_PredCtrl, *result);
    return (GED_RETURN_VALUE_SUCCESS == *result) ? (GED_PRED_CTRL)value : GED_PRED_CTRL_INVALID;
}
GED_RETURN_VALUE GED_SetPredCtrl(ged_ins_t* ins, const GED_PRED_CTRL value)
{
    return reinterpret_cast<GEDIns*>(ins)->SetUnsignedField(GED_INS_FIELD_PredCtrl, (const uint32_t)value);
}
GED_PRED_INV GED_GetPredInv(ged_ins_t* ins, GED_RETURN_VALUE* result)
{
    GED_RETURN_VALUE localResult = GED_RETURN_VALUE_INVALID_FIELD;
    if (NULL == result) result = &localResult;
    const uint32_t value = reinterpret_cast<GEDIns*>(ins)->GetUnsignedField(GED_INS_FIELD_PredInv, *result);
    return (GED_RETURN_VALUE_SUCCESS == *result) ? (GED_PRED_INV)value : GED_PRED_INV_INVALID;
}
GED_RETURN_VALUE GED_SetPredInv(ged_ins_t* ins, const GED_PRED_INV value)
{
    return reinterpret_cast<GEDIns*>(ins)->SetUnsignedField(GED_INS_FIELD_PredInv, (const uint32_t)value);
}
uint32_t GED_GetExecSize(ged_ins_t* ins, GED_RETURN_VALUE* result)
{
    GED_RETURN_VALUE localResult = GED_RETURN_VALUE_INVALID_FIELD;
    if (NULL == result) result = &localResult;
    return reinterpret_cast<GEDIns*>(ins)->GetUnsignedField(GED_INS_FIELD_ExecSize, *result);
}
GED_RETURN_VALUE GED_SetExecSize(ged_ins_t* ins, const uint32_t value)
{
    return reinterpret_cast<GEDIns*>(ins)->SetUnsignedField(GED_INS_FIELD_ExecSize, value);
}
GED_COND_MODIFIER GED_GetCondModifier(ged_ins_t* ins, GED_RETURN_VALUE* result)
{
    GED_RETURN_VALUE localResult = GED_RETURN_VALUE_INVALID_FIELD;
    if (NULL == result) result = &localResult;
    const uint32_t value = reinterpret_cast<GEDIns*>(ins)->GetUnsignedField(GED_INS_FIELD_CondModifier, *result);
    return (GED_RETURN_VALUE_SUCCESS == *result) ? (GED_COND_MODIFIER)value : GED_COND_MODIFIER_INVALID;
}
GED_RETURN_VALUE GED_SetCondModifier(ged_ins_t* ins, const GED_COND_MODIFIER value)
{
    return reinterpret_cast<GEDIns*>(ins)->SetUnsignedField(GED_INS_FIELD_CondModifier, (const uint32_t)value);
}
GED_ACC_WR_CTRL GED_GetAccWrCtrl(ged_ins_t* ins, GED_RETURN_VALUE* result)
{
    GED_RETURN_VALUE localResult = GED_RETURN_VALUE_INVALID_FIELD;
    if (NULL == result) result = &localResult;
    const uint32_t value = reinterpret_cast<GEDIns*>(ins)->GetUnsignedField(GED_INS_FIELD_AccWrCtrl, *result);
    return (GED_RETURN_VALUE_SUCCESS == *result) ? (GED_ACC_WR_CTRL)value : GED_ACC_WR_CTRL_INVALID;
}
GED_RETURN_VALUE GED_SetAccWrCtrl(ged_ins_t* ins, const GED_ACC_WR_CTRL value)
{
    return reinterpret_cast<GEDIns*>(ins)->SetUnsignedField(GED_INS_FIELD_AccWrCtrl, (const uint32_t)value);
}
GED_DEBUG_CTRL GED_GetDebugCtrl(ged_ins_t* ins, GED_RETURN_VALUE* result)
{
    GED_RETURN_VALUE localResult = GED_RETURN_VALUE_INVALID_FIELD;
    if (NULL == result) result = &localResult;
    const uint32_t value = reinterpret_cast<GEDIns*>(ins)->GetUnsignedField(GED_INS_FIELD_DebugCtrl, *result);
    return (GED_RETURN_VALUE_SUCCESS == *result) ? (GED_DEBUG_CTRL)value : GED_DEBUG_CTRL_INVALID;
}
GED_RETURN_VALUE GED_SetDebugCtrl(ged_ins_t* ins, const GED_DEBUG_CTRL value)
{
    return reinterpret_cast<GEDIns*>(ins)->SetUnsignedField(GED_INS_FIELD_DebugCtrl, (const uint32_t)value);
}
GED_SATURATE GED_GetSaturate(ged_ins_t* ins, GED_RETURN_VALUE* result)
{
    GED_RETURN_VALUE localResult = GED_RETURN_VALUE_INVALID_FIELD;
    if (NULL == result) result = &localResult;
    const uint32_t value = reinterpret_cast<GEDIns*>(ins)->GetUnsignedField(GED_INS_FIELD_Saturate, *result);
    return (GED_RETURN_VALUE_SUCCESS == *result) ? (GED_SATURATE)value : GED_SATURATE_INVALID;
}
GED_RETURN_VALUE GED_SetSaturate(ged_ins_t* ins, const GED_SATURATE value)
{
    return reinterpret_cast<GEDIns*>(ins)->SetUnsignedField(GED_INS_FIELD_Saturate, (const uint32_t)value);
}
GED_REG_FILE GED_GetDstRegFile(ged_ins_t* ins, GED_RETURN_VALUE* result)
{
    GED_RETURN_VALUE localResult = GED_RETURN_VALUE_INVALID_FIELD;
    if (NULL == result) result = &localResult;
    const uint32_t value = reinterpret_cast<GEDIns*>(ins)->GetUnsignedField(GED_INS_FIELD_DstRegFile, *result);
    return (GED_RETURN_VALUE_SUCCESS == *result) ? (GED_REG_FILE)value : GED_REG_FILE_INVALID;
}
GED_RETURN_VALUE GED_SetDstRegFile(ged_ins_t* ins, const GED_REG_FILE value)
{
    return reinterpret_cast<GEDIns*>(ins)->SetUnsignedField(GED_INS_FIELD_DstRegFile, (const uint32_t)value);
}
GED_DATA_TYPE GED_GetDstDataType(ged_ins_t* ins, GED_RETURN_VALUE* result)
{
    GED_RETURN_VALUE localResult = GED_RETURN_VALUE_INVALID_FIELD;
    if (NULL == result) result = &localResult;
    const uint32_t value = reinterpret_cast<GEDIns*>(ins)->GetUnsignedField(GED_INS_FIELD_DstDataType, *result);
    return (GED_RETURN_VALUE_SUCCESS == *result) ? (GED_DATA_TYPE)value : GED_DATA_TYPE_INVALID;
}
GED_RETURN_VALUE GED_SetDstDataType(ged_ins_t* ins, const GED_DATA_TYPE value)
{
    return reinterpret_cast<GEDIns*>(ins)->SetUnsignedField(GED_INS_FIELD_DstDataType, (const uint32_t)value);
}
GED_REG_FILE GED_GetSrc0RegFile(ged_ins_t* ins, GED_RETURN_VALUE* result)
{
    GED_RETURN_VALUE localResult = GED_RETURN_VALUE_INVALID_FIELD;
    if (NULL == result) result = &localResult;
    const uint32_t value = reinterpret_cast<GEDIns*>(ins)->GetUnsignedField(GED_INS_FIELD_Src0RegFile, *result);
    return (GED_RETURN_VALUE_SUCCESS == *result) ? (GED_REG_FILE)value : GED_REG_FILE_INVALID;
}
GED_RETURN_VALUE GED_SetSrc0RegFile(ged_ins_t* ins, const GED_REG_FILE value)
{
    return reinterpret_cast<GEDIns*>(ins)->SetUnsignedField(GED_INS_FIELD_Src0RegFile, (const uint32_t)value);
}
GED_DATA_TYPE GED_GetSrc0DataType(ged_ins_t* ins, GED_RETURN_VALUE* result)
{
    GED_RETURN_VALUE localResult = GED_RETURN_VALUE_INVALID_FIELD;
    if (NULL == result) result = &localResult;
    const uint32_t value = reinterpret_cast<GEDIns*>(ins)->GetUnsignedField(GED_INS_FIELD_Src0DataType, *result);
    return (GED_RETURN_VALUE_SUCCESS == *result) ? (GED_DATA_TYPE)value : GED_DATA_TYPE_INVALID;
}
GED_RETURN_VALUE GED_SetSrc0DataType(ged_ins_t* ins, const GED_DATA_TYPE value)
{
    return reinterpret_cast<GEDIns*>(ins)->SetUnsignedField(GED_INS_FIELD_Src0DataType, (const uint32_t)value);
}
GED_REG_FILE GED_GetSrc1RegFile(ged_ins_t* ins, GED_RETURN_VALUE* result)
{
    GED_RETURN_VALUE localResult = GED_RETURN_VALUE_INVALID_FIELD;
    if (NULL == result) result = &localResult;
    const uint32_t value = reinterpret_cast<GEDIns*>(ins)->GetUnsignedField(GED_INS_FIELD_Src1RegFile, *result);
    return (GED_RETURN_VALUE_SUCCESS == *result) ? (GED_REG_FILE)value : GED_REG_FILE_INVALID;
}
GED_RETURN_VALUE GED_SetSrc1RegFile(ged_ins_t* ins, const GED_REG_FILE value)
{
    return reinterpret_cast<GEDIns*>(ins)->SetUnsignedField(GED_INS_FIELD_Src1RegFile, (const uint32_t)value);
}
GED_DATA_TYPE GED_GetSrc1DataType(ged_ins_t* ins, GED_RETURN_VALUE* result)
{
    GED_RETURN_VALUE localResult = GED_RETURN_VALUE_INVALID_FIELD;
    if (NULL == result) result = &localResult;
    const uint32_t value = reinterpret_cast<GEDIns*>(ins)->GetUnsignedField(GED_INS_FIELD_Src1DataType, *result);
    return (GED_RETURN_VALUE_SUCCESS == *result) ? (GED_DATA_TYPE)value : GED_DATA_TYPE_INVALID;
}
GED_RETURN_VALUE GED_SetSrc1DataType(ged_ins_t* ins, const GED_DATA_TYPE value)
{
    return reinterpret_cast<GEDIns*>(ins)->SetUnsignedField(GED_INS_FIELD_Src1DataType, (const uint32_t)value);
}
GED_DST_CHAN_EN GED_GetDstChanEn(ged_ins_t* ins, GED_RETURN_VALUE* result)
{
    GED_RETURN_VALUE localResult = GED_RETURN_VALUE_INVALID_FIELD;
    if (NULL == result) result = &localResult;
    const uint32_t value = reinterpret_cast<GEDIns*>(ins)->GetUnsignedField(GED_INS_FIELD_DstChanEn, *result);
    return (GED_RETURN_VALUE_SUCCESS == *result) ? (GED_DST_CHAN_EN)value : GED_DST_CHAN_EN_INVALID;
}
GED_RETURN_VALUE GED_SetDstChanEn(ged_ins_t* ins, const GED_DST_CHAN_EN value)
{
    return reinterpret_cast<GEDIns*>(ins)->SetUnsignedField(GED_INS_FIELD_DstChanEn, (const uint32_t)value);
}
uint32_t GED_GetDstSubRegNum(ged_ins_t* ins, GED_RETURN_VALUE* result)
{
    GED_RETURN_VALUE localResult = GED_RETURN_VALUE_INVALID_FIELD;
    if (NULL == result) result = &localResult;
    return reinterpret_cast<GEDIns*>(ins)->GetUnsignedField(GED_INS_FIELD_DstSubRegNum, *result);
}
GED_RETURN_VALUE GED_SetDstSubRegNum(ged_ins_t* ins, const uint32_t value)
{
    return reinterpret_cast<GEDIns*>(ins)->SetUnsignedField(GED_INS_FIELD_DstSubRegNum, value);
}
int32_t GED_GetDstAddrImm(ged_ins_t* ins, GED_RETURN_VALUE* result)
{
    GED_RETURN_VALUE localResult = GED_RETURN_VALUE_INVALID_FIELD;
    if (NULL == result) result = &localResult;
    return reinterpret_cast<GEDIns*>(ins)->GetSignedField(GED_INS_FIELD_DstAddrImm, *result)._dw;
}
GED_RETURN_VALUE GED_SetDstAddrImm(ged_ins_t* ins, const int32_t value)
{
    return reinterpret_cast<GEDIns*>(ins)->SetSignedField(GED_INS_FIELD_DstAddrImm, value);
}
uint32_t GED_GetDstRegNum(ged_ins_t* ins, GED_RETURN_VALUE* result)
{
    GED_RETURN_VALUE localResult = GED_RETURN_VALUE_INVALID_FIELD;
    if (NULL == result) result = &localResult;
    return reinterpret_cast<GEDIns*>(ins)->GetUnsignedField(GED_INS_FIELD_DstRegNum, *result);
}
GED_RETURN_VALUE GED_SetDstRegNum(ged_ins_t* ins, const uint32_t value)
{
    return reinterpret_cast<GEDIns*>(ins)->SetUnsignedField(GED_INS_FIELD_DstRegNum, value);
}
uint32_t GED_GetDstAddrSubRegNum(ged_ins_t* ins, GED_RETURN_VALUE* result)
{
    GED_RETURN_VALUE localResult = GED_RETURN_VALUE_INVALID_FIELD;
    if (NULL == result) result = &localResult;
    return reinterpret_cast<GEDIns*>(ins)->GetUnsignedField(GED_INS_FIELD_DstAddrSubRegNum, *result);
}
GED_RETURN_VALUE GED_SetDstAddrSubRegNum(ged_ins_t* ins, const uint32_t value)
{
    return reinterpret_cast<GEDIns*>(ins)->SetUnsignedField(GED_INS_FIELD_DstAddrSubRegNum, value);
}
uint32_t GED_GetDstHorzStride(ged_ins_t* ins, GED_RETURN_VALUE* result)
{
    GED_RETURN_VALUE localResult = GED_RETURN_VALUE_INVALID_FIELD;
    if (NULL == result) result = &localResult;
    return reinterpret_cast<GEDIns*>(ins)->GetUnsignedField(GED_INS_FIELD_DstHorzStride, *result);
}
GED_RETURN_VALUE GED_SetDstHorzStride(ged_ins_t* ins, const uint32_t value)
{
    return reinterpret_cast<GEDIns*>(ins)->SetUnsignedField(GED_INS_FIELD_DstHorzStride, value);
}
GED_ADDR_MODE GED_GetDstAddrMode(ged_ins_t* ins, GED_RETURN_VALUE* result)
{
    GED_RETURN_VALUE localResult = GED_RETURN_VALUE_INVALID_FIELD;
    if (NULL == result) result = &localResult;
    const uint32_t value = reinterpret_cast<GEDIns*>(ins)->GetUnsignedField(GED_INS_FIELD_DstAddrMode, *result);
    return (GED_RETURN_VALUE_SUCCESS == *result) ? (GED_ADDR_MODE)value : GED_ADDR_MODE_INVALID;
}
GED_RETURN_VALUE GED_SetDstAddrMode(ged_ins_t* ins, const GED_ADDR_MODE value)
{
    return reinterpret_cast<GEDIns*>(ins)->SetUnsignedField(GED_INS_FIELD_DstAddrMode, (const uint32_t)value);
}
uint32_t GED_GetSrc0ChanSel(ged_ins_t* ins, GED_RETURN_VALUE* result)
{
    GED_RETURN_VALUE localResult = GED_RETURN_VALUE_INVALID_FIELD;
    if (NULL == result) result = &localResult;
    return reinterpret_cast<GEDIns*>(ins)->GetUnsignedField(GED_INS_FIELD_Src0ChanSel, *result);
}
GED_RETURN_VALUE GED_SetSrc0ChanSel(ged_ins_t* ins, const uint32_t value)
{
    return reinterpret_cast<GEDIns*>(ins)->SetUnsignedField(GED_INS_FIELD_Src0ChanSel, value);
}
uint32_t GED_GetSrc0SubRegNum(ged_ins_t* ins, GED_RETURN_VALUE* result)
{
    GED_RETURN_VALUE localResult = GED_RETURN_VALUE_INVALID_FIELD;
    if (NULL == result) result = &localResult;
    return reinterpret_cast<GEDIns*>(ins)->GetUnsignedField(GED_INS_FIELD_Src0SubRegNum, *result);
}
GED_RETURN_VALUE GED_SetSrc0SubRegNum(ged_ins_t* ins, const uint32_t value)
{
    return reinterpret_cast<GEDIns*>(ins)->SetUnsignedField(GED_INS_FIELD_Src0SubRegNum, value);
}
int32_t GED_GetSrc0AddrImm(ged_ins_t* ins, GED_RETURN_VALUE* result)
{
    GED_RETURN_VALUE localResult = GED_RETURN_VALUE_INVALID_FIELD;
    if (NULL == result) result = &localResult;
    return reinterpret_cast<GEDIns*>(ins)->GetSignedField(GED_INS_FIELD_Src0AddrImm, *result)._dw;
}
GED_RETURN_VALUE GED_SetSrc0AddrImm(ged_ins_t* ins, const int32_t value)
{
    return reinterpret_cast<GEDIns*>(ins)->SetSignedField(GED_INS_FIELD_Src0AddrImm, value);
}
uint32_t GED_GetSrc0RegNum(ged_ins_t* ins, GED_RETURN_VALUE* result)
{
    GED_RETURN_VALUE localResult = GED_RETURN_VALUE_INVALID_FIELD;
    if (NULL == result) result = &localResult;
    return reinterpret_cast<GEDIns*>(ins)->GetUnsignedField(GED_INS_FIELD_Src0RegNum, *result);
}
GED_RETURN_VALUE GED_SetSrc0RegNum(ged_ins_t* ins, const uint32_t value)
{
    return reinterpret_cast<GEDIns*>(ins)->SetUnsignedField(GED_INS_FIELD_Src0RegNum, value);
}
uint32_t GED_GetSrc0AddrSubRegNum(ged_ins_t* ins, GED_RETURN_VALUE* result)
{
    GED_RETURN_VALUE localResult = GED_RETURN_VALUE_INVALID_FIELD;
    if (NULL == result) result = &localResult;
    return reinterpret_cast<GEDIns*>(ins)->GetUnsignedField(GED_INS_FIELD_Src0AddrSubRegNum, *result);
}
GED_RETURN_VALUE GED_SetSrc0AddrSubRegNum(ged_ins_t* ins, const uint32_t value)
{
    return reinterpret_cast<GEDIns*>(ins)->SetUnsignedField(GED_INS_FIELD_Src0AddrSubRegNum, value);
}
GED_SRC_MOD GED_GetSrc0SrcMod(ged_ins_t* ins, GED_RETURN_VALUE* result)
{
    GED_RETURN_VALUE localResult = GED_RETURN_VALUE_INVALID_FIELD;
    if (NULL == result) result = &localResult;
    const uint32_t value = reinterpret_cast<GEDIns*>(ins)->GetUnsignedField(GED_INS_FIELD_Src0SrcMod, *result);
    return (GED_RETURN_VALUE_SUCCESS == *result) ? (GED_SRC_MOD)value : GED_SRC_MOD_INVALID;
}
GED_RETURN_VALUE GED_SetSrc0SrcMod(ged_ins_t* ins, const GED_SRC_MOD value)
{
    return reinterpret_cast<GEDIns*>(ins)->SetUnsignedField(GED_INS_FIELD_Src0SrcMod, (const uint32_t)value);
}
GED_ADDR_MODE GED_GetSrc0AddrMode(ged_ins_t* ins, GED_RETURN_VALUE* result)
{
    GED_RETURN_VALUE localResult = GED_RETURN_VALUE_INVALID_FIELD;
    if (NULL == result) result = &localResult;
    const uint32_t value = reinterpret_cast<GEDIns*>(ins)->GetUnsignedField(GED_INS_FIELD_Src0AddrMode, *result);
    return (GED_RETURN_VALUE_SUCCESS == *result) ? (GED_ADDR_MODE)value : GED_ADDR_MODE_INVALID;
}
GED_RETURN_VALUE GED_SetSrc0AddrMode(ged_ins_t* ins, const GED_ADDR_MODE value)
{
    return reinterpret_cast<GEDIns*>(ins)->SetUnsignedField(GED_INS_FIELD_Src0AddrMode, (const uint32_t)value);
}
uint32_t GED_GetSrc0HorzStride(ged_ins_t* ins, GED_RETURN_VALUE* result)
{
    GED_RETURN_VALUE localResult = GED_RETURN_VALUE_INVALID_FIELD;
    if (NULL == result) result = &localResult;
    return reinterpret_cast<GEDIns*>(ins)->GetUnsignedField(GED_INS_FIELD_Src0HorzStride, *result);
}
GED_RETURN_VALUE GED_SetSrc0HorzStride(ged_ins_t* ins, const uint32_t value)
{
    return reinterpret_cast<GEDIns*>(ins)->SetUnsignedField(GED_INS_FIELD_Src0HorzStride, value);
}
uint32_t GED_GetSrc0Width(ged_ins_t* ins, GED_RETURN_VALUE* result)
{
    GED_RETURN_VALUE localResult = GED_RETURN_VALUE_INVALID_FIELD;
    if (NULL == result) result = &localResult;
    return reinterpret_cast<GEDIns*>(ins)->GetUnsignedField(GED_INS_FIELD_Src0Width, *result);
}
GED_RETURN_VALUE GED_SetSrc0Width(ged_ins_t* ins, const uint32_t value)
{
    return reinterpret_cast<GEDIns*>(ins)->SetUnsignedField(GED_INS_FIELD_Src0Width, value);
}
uint32_t GED_GetSrc0VertStride(ged_ins_t* ins, GED_RETURN_VALUE* result)
{
    GED_RETURN_VALUE localResult = GED_RETURN_VALUE_INVALID_FIELD;
    if (NULL == result) result = &localResult;
    return reinterpret_cast<GEDIns*>(ins)->GetUnsignedField(GED_INS_FIELD_Src0VertStride, *result);
}
GED_RETURN_VALUE GED_SetSrc0VertStride(ged_ins_t* ins, const uint32_t value)
{
    return reinterpret_cast<GEDIns*>(ins)->SetUnsignedField(GED_INS_FIELD_Src0VertStride, value);
}
uint32_t GED_GetFlagSubRegNum(ged_ins_t* ins, GED_RETURN_VALUE* result)
{
    GED_RETURN_VALUE localResult = GED_RETURN_VALUE_INVALID_FIELD;
    if (NULL == result) result = &localResult;
    return reinterpret_cast<GEDIns*>(ins)->GetUnsignedField(GED_INS_FIELD_FlagSubRegNum, *result);
}
GED_RETURN_VALUE GED_SetFlagSubRegNum(ged_ins_t* ins, const uint32_t value)
{
    return reinterpret_cast<GEDIns*>(ins)->SetUnsignedField(GED_INS_FIELD_FlagSubRegNum, value);
}
uint32_t GED_GetFlagRegNum(ged_ins_t* ins, GED_RETURN_VALUE* result)
{
    GED_RETURN_VALUE localResult = GED_RETURN_VALUE_INVALID_FIELD;
    if (NULL == result) result = &localResult;
    return reinterpret_cast<GEDIns*>(ins)->GetUnsignedField(GED_INS_FIELD_FlagRegNum, *result);
}
GED_RETURN_VALUE GED_SetFlagRegNum(ged_ins_t* ins, const uint32_t value)
{
    return reinterpret_cast<GEDIns*>(ins)->SetUnsignedField(GED_INS_FIELD_FlagRegNum, value);
}
uint32_t GED_GetSrc1ChanSel(ged_ins_t* ins, GED_RETURN_VALUE* result)
{
    GED_RETURN_VALUE localResult = GED_RETURN_VALUE_INVALID_FIELD;
    if (NULL == result) result = &localResult;
    return reinterpret_cast<GEDIns*>(ins)->GetUnsignedField(GED_INS_FIELD_Src1ChanSel, *result);
}
GED_RETURN_VALUE GED_SetSrc1ChanSel(ged_ins_t* ins, const uint32_t value)
{
    return reinterpret_cast<GEDIns*>(ins)->SetUnsignedField(GED_INS_FIELD_Src1ChanSel, value);
}
uint32_t GED_GetSrc1SubRegNum(ged_ins_t* ins, GED_RETURN_VALUE* result)
{
    GED_RETURN_VALUE localResult = GED_RETURN_VALUE_INVALID_FIELD;
    if (NULL == result) result = &localResult;
    return reinterpret_cast<GEDIns*>(ins)->GetUnsignedField(GED_INS_FIELD_Src1SubRegNum, *result);
}
GED_RETURN_VALUE GED_SetSrc1SubRegNum(ged_ins_t* ins, const uint32_t value)
{
    return reinterpret_cast<GEDIns*>(ins)->SetUnsignedField(GED_INS_FIELD_Src1SubRegNum, value);
}
int32_t GED_GetSrc1AddrImm(ged_ins_t* ins, GED_RETURN_VALUE* result)
{
    GED_RETURN_VALUE localResult = GED_RETURN_VALUE_INVALID_FIELD;
    if (NULL == result) result = &localResult;
    return reinterpret_cast<GEDIns*>(ins)->GetSignedField(GED_INS_FIELD_Src1AddrImm, *result)._dw;
}
GED_RETURN_VALUE GED_SetSrc1AddrImm(ged_ins_t* ins, const int32_t value)
{
    return reinterpret_cast<GEDIns*>(ins)->SetSignedField(GED_INS_FIELD_Src1AddrImm, value);
}
uint32_t GED_GetSrc1RegNum(ged_ins_t* ins, GED_RETURN_VALUE* result)
{
    GED_RETURN_VALUE localResult = GED_RETURN_VALUE_INVALID_FIELD;
    if (NULL == result) result = &localResult;
    return reinterpret_cast<GEDIns*>(ins)->GetUnsignedField(GED_INS_FIELD_Src1RegNum, *result);
}
GED_RETURN_VALUE GED_SetSrc1RegNum(ged_ins_t* ins, const uint32_t value)
{
    return reinterpret_cast<GEDIns*>(ins)->SetUnsignedField(GED_INS_FIELD_Src1RegNum, value);
}
uint32_t GED_GetSrc1AddrSubRegNum(ged_ins_t* ins, GED_RETURN_VALUE* result)
{
    GED_RETURN_VALUE localResult = GED_RETURN_VALUE_INVALID_FIELD;
    if (NULL == result) result = &localResult;
    return reinterpret_cast<GEDIns*>(ins)->GetUnsignedField(GED_INS_FIELD_Src1AddrSubRegNum, *result);
}
GED_RETURN_VALUE GED_SetSrc1AddrSubRegNum(ged_ins_t* ins, const uint32_t value)
{
    return reinterpret_cast<GEDIns*>(ins)->SetUnsignedField(GED_INS_FIELD_Src1AddrSubRegNum, value);
}
GED_SRC_MOD GED_GetSrc1SrcMod(ged_ins_t* ins, GED_RETURN_VALUE* result)
{
    GED_RETURN_VALUE localResult = GED_RETURN_VALUE_INVALID_FIELD;
    if (NULL == result) result = &localResult;
    const uint32_t value = reinterpret_cast<GEDIns*>(ins)->GetUnsignedField(GED_INS_FIELD_Src1SrcMod, *result);
    return (GED_RETURN_VALUE_SUCCESS == *result) ? (GED_SRC_MOD)value : GED_SRC_MOD_INVALID;
}
GED_RETURN_VALUE GED_SetSrc1SrcMod(ged_ins_t* ins, const GED_SRC_MOD value)
{
    return reinterpret_cast<GEDIns*>(ins)->SetUnsignedField(GED_INS_FIELD_Src1SrcMod, (const uint32_t)value);
}
GED_ADDR_MODE GED_GetSrc1AddrMode(ged_ins_t* ins, GED_RETURN_VALUE* result)
{
    GED_RETURN_VALUE localResult = GED_RETURN_VALUE_INVALID_FIELD;
    if (NULL == result) result = &localResult;
    const uint32_t value = reinterpret_cast<GEDIns*>(ins)->GetUnsignedField(GED_INS_FIELD_Src1AddrMode, *result);
    return (GED_RETURN_VALUE_SUCCESS == *result) ? (GED_ADDR_MODE)value : GED_ADDR_MODE_INVALID;
}
GED_RETURN_VALUE GED_SetSrc1AddrMode(ged_ins_t* ins, const GED_ADDR_MODE value)
{
    return reinterpret_cast<GEDIns*>(ins)->SetUnsignedField(GED_INS_FIELD_Src1AddrMode, (const uint32_t)value);
}
uint32_t GED_GetSrc1HorzStride(ged_ins_t* ins, GED_RETURN_VALUE* result)
{
    GED_RETURN_VALUE localResult = GED_RETURN_VALUE_INVALID_FIELD;
    if (NULL == result) result = &localResult;
    return reinterpret_cast<GEDIns*>(ins)->GetUnsignedField(GED_INS_FIELD_Src1HorzStride, *result);
}
GED_RETURN_VALUE GED_SetSrc1HorzStride(ged_ins_t* ins, const uint32_t value)
{
    return reinterpret_cast<GEDIns*>(ins)->SetUnsignedField(GED_INS_FIELD_Src1HorzStride, value);
}
uint32_t GED_GetSrc1Width(ged_ins_t* ins, GED_RETURN_VALUE* result)
{
    GED_RETURN_VALUE localResult = GED_RETURN_VALUE_INVALID_FIELD;
    if (NULL == result) result = &localResult;
    return reinterpret_cast<GEDIns*>(ins)->GetUnsignedField(GED_INS_FIELD_Src1Width, *result);
}
GED_RETURN_VALUE GED_SetSrc1Width(ged_ins_t* ins, const uint32_t value)
{
    return reinterpret_cast<GEDIns*>(ins)->SetUnsignedField(GED_INS_FIELD_Src1Width, value);
}
uint32_t GED_GetSrc1VertStride(ged_ins_t* ins, GED_RETURN_VALUE* result)
{
    GED_RETURN_VALUE localResult = GED_RETURN_VALUE_INVALID_FIELD;
    if (NULL == result) result = &localResult;
    return reinterpret_cast<GEDIns*>(ins)->GetUnsignedField(GED_INS_FIELD_Src1VertStride, *result);
}
GED_RETURN_VALUE GED_SetSrc1VertStride(ged_ins_t* ins, const uint32_t value)
{
    return reinterpret_cast<GEDIns*>(ins)->SetUnsignedField(GED_INS_FIELD_Src1VertStride, value);
}
uint64_t GED_GetImm(ged_ins_t* ins, GED_RETURN_VALUE* result)
{
    GED_RETURN_VALUE localResult = GED_RETURN_VALUE_INVALID_FIELD;
    if (NULL == result) result = &localResult;
    return reinterpret_cast<GEDIns*>(ins)->GetUnsigned64Field(GED_INS_FIELD_Imm, *result);
}
GED_RETURN_VALUE GED_SetImm(ged_ins_t* ins, const uint64_t value)
{
    return reinterpret_cast<GEDIns*>(ins)->SetUnsigned64Field(GED_INS_FIELD_Imm, value);
}
GED_SRC_MOD GED_GetSrc2SrcMod(ged_ins_t* ins, GED_RETURN_VALUE* result)
{
    GED_RETURN_VALUE localResult = GED_RETURN_VALUE_INVALID_FIELD;
    if (NULL == result) result = &localResult;
    const uint32_t value = reinterpret_cast<GEDIns*>(ins)->GetUnsignedField(GED_INS_FIELD_Src2SrcMod, *result);
    return (GED_RETURN_VALUE_SUCCESS == *result) ? (GED_SRC_MOD)value : GED_SRC_MOD_INVALID;
}
GED_RETURN_VALUE GED_SetSrc2SrcMod(ged_ins_t* ins, const GED_SRC_MOD value)
{
    return reinterpret_cast<GEDIns*>(ins)->SetUnsignedField(GED_INS_FIELD_Src2SrcMod, (const uint32_t)value);
}
GED_DATA_TYPE GED_GetSrcDataType(ged_ins_t* ins, GED_RETURN_VALUE* result)
{
    GED_RETURN_VALUE localResult = GED_RETURN_VALUE_INVALID_FIELD;
    if (NULL == result) result = &localResult;
    const uint32_t value = reinterpret_cast<GEDIns*>(ins)->GetUnsignedField(GED_INS_FIELD_SrcDataType, *result);
    return (GED_RETURN_VALUE_SUCCESS == *result) ? (GED_DATA_TYPE)value : GED_DATA_TYPE_INVALID;
}
GED_RETURN_VALUE GED_SetSrcDataType(ged_ins_t* ins, const GED_DATA_TYPE value)
{
    return reinterpret_cast<GEDIns*>(ins)->SetUnsignedField(GED_INS_FIELD_SrcDataType, (const uint32_t)value);
}
GED_REP_CTRL GED_GetSrc0RepCtrl(ged_ins_t* ins, GED_RETURN_VALUE* result)
{
    GED_RETURN_VALUE localResult = GED_RETURN_VALUE_INVALID_FIELD;
    if (NULL == result) result = &localResult;
    const uint32_t value = reinterpret_cast<GEDIns*>(ins)->GetUnsignedField(GED_INS_FIELD_Src0RepCtrl, *result);
    return (GED_RETURN_VALUE_SUCCESS == *result) ? (GED_REP_CTRL)value : GED_REP_CTRL_INVALID;
}
GED_RETURN_VALUE GED_SetSrc0RepCtrl(ged_ins_t* ins, const GED_REP_CTRL value)
{
    return reinterpret_cast<GEDIns*>(ins)->SetUnsignedField(GED_INS_FIELD_Src0RepCtrl, (const uint32_t)value);
}
GED_REP_CTRL GED_GetSrc1RepCtrl(ged_ins_t* ins, GED_RETURN_VALUE* result)
{
    GED_RETURN_VALUE localResult = GED_RETURN_VALUE_INVALID_FIELD;
    if (NULL == result) result = &localResult;
    const uint32_t value = reinterpret_cast<GEDIns*>(ins)->GetUnsignedField(GED_INS_FIELD_Src1RepCtrl, *result);
    return (GED_RETURN_VALUE_SUCCESS == *result) ? (GED_REP_CTRL)value : GED_REP_CTRL_INVALID;
}
GED_RETURN_VALUE GED_SetSrc1RepCtrl(ged_ins_t* ins, const GED_REP_CTRL value)
{
    return reinterpret_cast<GEDIns*>(ins)->SetUnsignedField(GED_INS_FIELD_Src1RepCtrl, (const uint32_t)value);
}
GED_REP_CTRL GED_GetSrc2RepCtrl(ged_ins_t* ins, GED_RETURN_VALUE* result)
{
    GED_RETURN_VALUE localResult = GED_RETURN_VALUE_INVALID_FIELD;
    if (NULL == result) result = &localResult;
    const uint32_t value = reinterpret_cast<GEDIns*>(ins)->GetUnsignedField(GED_INS_FIELD_Src2RepCtrl, *result);
    return (GED_RETURN_VALUE_SUCCESS == *result) ? (GED_REP_CTRL)value : GED_REP_CTRL_INVALID;
}
GED_RETURN_VALUE GED_SetSrc2RepCtrl(ged_ins_t* ins, const GED_REP_CTRL value)
{
    return reinterpret_cast<GEDIns*>(ins)->SetUnsignedField(GED_INS_FIELD_Src2RepCtrl, (const uint32_t)value);
}
uint32_t GED_GetSrc2ChanSel(ged_ins_t* ins, GED_RETURN_VALUE* result)
{
    GED_RETURN_VALUE localResult = GED_RETURN_VALUE_INVALID_FIELD;
    if (NULL == result) result = &localResult;
    return reinterpret_cast<GEDIns*>(ins)->GetUnsignedField(GED_INS_FIELD_Src2ChanSel, *result);
}
GED_RETURN_VALUE GED_SetSrc2ChanSel(ged_ins_t* ins, const uint32_t value)
{
    return reinterpret_cast<GEDIns*>(ins)->SetUnsignedField(GED_INS_FIELD_Src2ChanSel, value);
}
uint32_t GED_GetSrc2SubRegNum(ged_ins_t* ins, GED_RETURN_VALUE* result)
{
    GED_RETURN_VALUE localResult = GED_RETURN_VALUE_INVALID_FIELD;
    if (NULL == result) result = &localResult;
    return reinterpret_cast<GEDIns*>(ins)->GetUnsignedField(GED_INS_FIELD_Src2SubRegNum, *result);
}
GED_RETURN_VALUE GED_SetSrc2SubRegNum(ged_ins_t* ins, const uint32_t value)
{
    return reinterpret_cast<GEDIns*>(ins)->SetUnsignedField(GED_INS_FIELD_Src2SubRegNum, value);
}
uint32_t GED_GetSrc2RegNum(ged_ins_t* ins, GED_RETURN_VALUE* result)
{
    GED_RETURN_VALUE localResult = GED_RETURN_VALUE_INVALID_FIELD;
    if (NULL == result) result = &localResult;
    return reinterpret_cast<GEDIns*>(ins)->GetUnsignedField(GED_INS_FIELD_Src2RegNum, *result);
}
GED_RETURN_VALUE GED_SetSrc2RegNum(ged_ins_t* ins, const uint32_t value)
{
    return reinterpret_cast<GEDIns*>(ins)->SetUnsignedField(GED_INS_FIELD_Src2RegNum, value);
}
GED_REG_FILE GED_GetSrc2RegFile(ged_ins_t* ins, GED_RETURN_VALUE* result)
{
    GED_RETURN_VALUE localResult = GED_RETURN_VALUE_INVALID_FIELD;
    if (NULL == result) result = &localResult;
    const uint32_t value = reinterpret_cast<GEDIns*>(ins)->GetUnsignedField(GED_INS_FIELD_Src2RegFile, *result);
    return (GED_RETURN_VALUE_SUCCESS == *result) ? (GED_REG_FILE)value : GED_REG_FILE_INVALID;
}
GED_RETURN_VALUE GED_SetSrc2RegFile(ged_ins_t* ins, const GED_REG_FILE value)
{
    return reinterpret_cast<GEDIns*>(ins)->SetUnsignedField(GED_INS_FIELD_Src2RegFile, (const uint32_t)value);
}
GED_ADDR_MODE GED_GetSrc2AddrMode(ged_ins_t* ins, GED_RETURN_VALUE* result)
{
    GED_RETURN_VALUE localResult = GED_RETURN_VALUE_INVALID_FIELD;
    if (NULL == result) result = &localResult;
    const uint32_t value = reinterpret_cast<GEDIns*>(ins)->GetUnsignedField(GED_INS_FIELD_Src2AddrMode, *result);
    return (GED_RETURN_VALUE_SUCCESS == *result) ? (GED_ADDR_MODE)value : GED_ADDR_MODE_INVALID;
}
GED_RETURN_VALUE GED_SetSrc2AddrMode(ged_ins_t* ins, const GED_ADDR_MODE value)
{
    return reinterpret_cast<GEDIns*>(ins)->SetUnsignedField(GED_INS_FIELD_Src2AddrMode, (const uint32_t)value);
}
uint32_t GED_GetSrc2VertStride(ged_ins_t* ins, GED_RETURN_VALUE* result)
{
    GED_RETURN_VALUE localResult = GED_RETURN_VALUE_INVALID_FIELD;
    if (NULL == result) result = &localResult;
    return reinterpret_cast<GEDIns*>(ins)->GetUnsignedField(GED_INS_FIELD_Src2VertStride, *result);
}
GED_RETURN_VALUE GED_SetSrc2VertStride(ged_ins_t* ins, const uint32_t value)
{
    return reinterpret_cast<GEDIns*>(ins)->SetUnsignedField(GED_INS_FIELD_Src2VertStride, value);
}
GED_SFID GED_GetSFID(ged_ins_t* ins, GED_RETURN_VALUE* result)
{
    GED_RETURN_VALUE localResult = GED_RETURN_VALUE_INVALID_FIELD;
    if (NULL == result) result = &localResult;
    const uint32_t value = reinterpret_cast<GEDIns*>(ins)->GetUnsignedField(GED_INS_FIELD_SFID, *result);
    return (GED_RETURN_VALUE_SUCCESS == *result) ? (GED_SFID)value : GED_SFID_INVALID;
}
GED_RETURN_VALUE GED_SetSFID(ged_ins_t* ins, const GED_SFID value)
{
    return reinterpret_cast<GEDIns*>(ins)->SetUnsignedField(GED_INS_FIELD_SFID, (const uint32_t)value);
}
GED_REG_FILE GED_GetDescRegFile(ged_ins_t* ins, GED_RETURN_VALUE* result)
{
    GED_RETURN_VALUE localResult = GED_RETURN_VALUE_INVALID_FIELD;
    if (NULL == result) result = &localResult;
    const uint32_t value = reinterpret_cast<GEDIns*>(ins)->GetUnsignedField(GED_INS_FIELD_DescRegFile, *result);
    return (GED_RETURN_VALUE_SUCCESS == *result) ? (GED_REG_FILE)value : GED_REG_FILE_INVALID;
}
GED_RETURN_VALUE GED_SetDescRegFile(ged_ins_t* ins, const GED_REG_FILE value)
{
    return reinterpret_cast<GEDIns*>(ins)->SetUnsignedField(GED_INS_FIELD_DescRegFile, (const uint32_t)value);
}
GED_DATA_TYPE GED_GetDescDataType(ged_ins_t* ins, GED_RETURN_VALUE* result)
{
    GED_RETURN_VALUE localResult = GED_RETURN_VALUE_INVALID_FIELD;
    if (NULL == result) result = &localResult;
    const uint32_t value = reinterpret_cast<GEDIns*>(ins)->GetUnsignedField(GED_INS_FIELD_DescDataType, *result);
    return (GED_RETURN_VALUE_SUCCESS == *result) ? (GED_DATA_TYPE)value : GED_DATA_TYPE_INVALID;
}
GED_RETURN_VALUE GED_SetDescDataType(ged_ins_t* ins, const GED_DATA_TYPE value)
{
    return reinterpret_cast<GEDIns*>(ins)->SetUnsignedField(GED_INS_FIELD_DescDataType, (const uint32_t)value);
}
uint32_t GED_GetDescAddrSubRegNum(ged_ins_t* ins, GED_RETURN_VALUE* result)
{
    GED_RETURN_VALUE localResult = GED_RETURN_VALUE_INVALID_FIELD;
    if (NULL == result) result = &localResult;
    return reinterpret_cast<GEDIns*>(ins)->GetUnsignedField(GED_INS_FIELD_DescAddrSubRegNum, *result);
}
GED_RETURN_VALUE GED_SetDescAddrSubRegNum(ged_ins_t* ins, const uint32_t value)
{
    return reinterpret_cast<GEDIns*>(ins)->SetUnsignedField(GED_INS_FIELD_DescAddrSubRegNum, value);
}
uint32_t GED_GetDescRegNum(ged_ins_t* ins, GED_RETURN_VALUE* result)
{
    GED_RETURN_VALUE localResult = GED_RETURN_VALUE_INVALID_FIELD;
    if (NULL == result) result = &localResult;
    return reinterpret_cast<GEDIns*>(ins)->GetUnsignedField(GED_INS_FIELD_DescRegNum, *result);
}
GED_RETURN_VALUE GED_SetDescRegNum(ged_ins_t* ins, const uint32_t value)
{
    return reinterpret_cast<GEDIns*>(ins)->SetUnsignedField(GED_INS_FIELD_DescRegNum, value);
}
uint32_t GED_GetDescHorzStride(ged_ins_t* ins, GED_RETURN_VALUE* result)
{
    GED_RETURN_VALUE localResult = GED_RETURN_VALUE_INVALID_FIELD;
    if (NULL == result) result = &localResult;
    return reinterpret_cast<GEDIns*>(ins)->GetUnsignedField(GED_INS_FIELD_DescHorzStride, *result);
}
GED_RETURN_VALUE GED_SetDescHorzStride(ged_ins_t* ins, const uint32_t value)
{
    return reinterpret_cast<GEDIns*>(ins)->SetUnsignedField(GED_INS_FIELD_DescHorzStride, value);
}
uint32_t GED_GetDescWidth(ged_ins_t* ins, GED_RETURN_VALUE* result)
{
    GED_RETURN_VALUE localResult = GED_RETURN_VALUE_INVALID_FIELD;
    if (NULL == result) result = &localResult;
    return reinterpret_cast<GEDIns*>(ins)->GetUnsignedField(GED_INS_FIELD_DescWidth, *result);
}
GED_RETURN_VALUE GED_SetDescWidth(ged_ins_t* ins, const uint32_t value)
{
    return reinterpret_cast<GEDIns*>(ins)->SetUnsignedField(GED_INS_FIELD_DescWidth, value);
}
uint32_t GED_GetDescVertStride(ged_ins_t* ins, GED_RETURN_VALUE* result)
{
    GED_RETURN_VALUE localResult = GED_RETURN_VALUE_INVALID_FIELD;
    if (NULL == result) result = &localResult;
    return reinterpret_cast<GEDIns*>(ins)->GetUnsignedField(GED_INS_FIELD_DescVertStride, *result);
}
GED_RETURN_VALUE GED_SetDescVertStride(ged_ins_t* ins, const uint32_t value)
{
    return reinterpret_cast<GEDIns*>(ins)->SetUnsignedField(GED_INS_FIELD_DescVertStride, value);
}
uint32_t GED_GetMsgDesc(ged_ins_t* ins, GED_RETURN_VALUE* result)
{
    GED_RETURN_VALUE localResult = GED_RETURN_VALUE_INVALID_FIELD;
    if (NULL == result) result = &localResult;
    return reinterpret_cast<GEDIns*>(ins)->GetUnsignedField(GED_INS_FIELD_MsgDesc, *result);
}
GED_RETURN_VALUE GED_SetMsgDesc(ged_ins_t* ins, const uint32_t value)
{
    return reinterpret_cast<GEDIns*>(ins)->SetUnsignedField(GED_INS_FIELD_MsgDesc, value);
}
uint32_t GED_GetExMsgDescImm(ged_ins_t* ins, GED_RETURN_VALUE* result)
{
    GED_RETURN_VALUE localResult = GED_RETURN_VALUE_INVALID_FIELD;
    if (NULL == result) result = &localResult;
    return reinterpret_cast<GEDIns*>(ins)->GetUnsignedField(GED_INS_FIELD_ExMsgDescImm, *result);
}
GED_RETURN_VALUE GED_SetExMsgDescImm(ged_ins_t* ins, const uint32_t value)
{
    return reinterpret_cast<GEDIns*>(ins)->SetUnsignedField(GED_INS_FIELD_ExMsgDescImm, value);
}
GED_EOT GED_GetEOT(ged_ins_t* ins, GED_RETURN_VALUE* result)
{
    GED_RETURN_VALUE localResult = GED_RETURN_VALUE_INVALID_FIELD;
    if (NULL == result) result = &localResult;
    const uint32_t value = reinterpret_cast<GEDIns*>(ins)->GetUnsignedField(GED_INS_FIELD_EOT, *result);
    return (GED_RETURN_VALUE_SUCCESS == *result) ? (GED_EOT)value : GED_EOT_INVALID;
}
GED_RETURN_VALUE GED_SetEOT(ged_ins_t* ins, const GED_EOT value)
{
    return reinterpret_cast<GEDIns*>(ins)->SetUnsignedField(GED_INS_FIELD_EOT, (const uint32_t)value);
}
GED_MATH_FC GED_GetMathFC(ged_ins_t* ins, GED_RETURN_VALUE* result)
{
    GED_RETURN_VALUE localResult = GED_RETURN_VALUE_INVALID_FIELD;
    if (NULL == result) result = &localResult;
    const uint32_t value = reinterpret_cast<GEDIns*>(ins)->GetUnsignedField(GED_INS_FIELD_MathFC, *result);
    return (GED_RETURN_VALUE_SUCCESS == *result) ? (GED_MATH_FC)value : GED_MATH_FC_INVALID;
}
GED_RETURN_VALUE GED_SetMathFC(ged_ins_t* ins, const GED_MATH_FC value)
{
    return reinterpret_cast<GEDIns*>(ins)->SetUnsignedField(GED_INS_FIELD_MathFC, (const uint32_t)value);
}
int32_t GED_GetJIP(ged_ins_t* ins, GED_RETURN_VALUE* result)
{
    GED_RETURN_VALUE localResult = GED_RETURN_VALUE_INVALID_FIELD;
    if (NULL == result) result = &localResult;
    return reinterpret_cast<GEDIns*>(ins)->GetSignedField(GED_INS_FIELD_JIP, *result)._dw;
}
GED_RETURN_VALUE GED_SetJIP(ged_ins_t* ins, const int32_t value)
{
    return reinterpret_cast<GEDIns*>(ins)->SetSignedField(GED_INS_FIELD_JIP, value);
}
int32_t GED_GetUIP(ged_ins_t* ins, GED_RETURN_VALUE* result)
{
    GED_RETURN_VALUE localResult = GED_RETURN_VALUE_INVALID_FIELD;
    if (NULL == result) result = &localResult;
    return reinterpret_cast<GEDIns*>(ins)->GetSignedField(GED_INS_FIELD_UIP, *result)._dw;
}
GED_RETURN_VALUE GED_SetUIP(ged_ins_t* ins, const int32_t value)
{
    return reinterpret_cast<GEDIns*>(ins)->SetSignedField(GED_INS_FIELD_UIP, value);
}
uint32_t GED_GetControlIndex(ged_ins_t* ins, GED_RETURN_VALUE* result)
{
    GED_RETURN_VALUE localResult = GED_RETURN_VALUE_INVALID_FIELD;
    if (NULL == result) result = &localResult;
    return reinterpret_cast<GEDIns*>(ins)->GetUnsignedField(GED_INS_FIELD_ControlIndex, *result);
}
GED_RETURN_VALUE GED_SetControlIndex(ged_ins_t* ins, const uint32_t value)
{
    return reinterpret_cast<GEDIns*>(ins)->SetUnsignedField(GED_INS_FIELD_ControlIndex, value);
}
uint32_t GED_GetDataTypeIndex(ged_ins_t* ins, GED_RETURN_VALUE* result)
{
    GED_RETURN_VALUE localResult = GED_RETURN_VALUE_INVALID_FIELD;
    if (NULL == result) result = &localResult;
    return reinterpret_cast<GEDIns*>(ins)->GetUnsignedField(GED_INS_FIELD_DataTypeIndex, *result);
}
GED_RETURN_VALUE GED_SetDataTypeIndex(ged_ins_t* ins, const uint32_t value)
{
    return reinterpret_cast<GEDIns*>(ins)->SetUnsignedField(GED_INS_FIELD_DataTypeIndex, value);
}
uint32_t GED_GetSubRegIndex(ged_ins_t* ins, GED_RETURN_VALUE* result)
{
    GED_RETURN_VALUE localResult = GED_RETURN_VALUE_INVALID_FIELD;
    if (NULL == result) result = &localResult;
    return reinterpret_cast<GEDIns*>(ins)->GetUnsignedField(GED_INS_FIELD_SubRegIndex, *result);
}
GED_RETURN_VALUE GED_SetSubRegIndex(ged_ins_t* ins, const uint32_t value)
{
    return reinterpret_cast<GEDIns*>(ins)->SetUnsignedField(GED_INS_FIELD_SubRegIndex, value);
}
uint32_t GED_GetSrc0Index(ged_ins_t* ins, GED_RETURN_VALUE* result)
{
    GED_RETURN_VALUE localResult = GED_RETURN_VALUE_INVALID_FIELD;
    if (NULL == result) result = &localResult;
    return reinterpret_cast<GEDIns*>(ins)->GetUnsignedField(GED_INS_FIELD_Src0Index, *result);
}
GED_RETURN_VALUE GED_SetSrc0Index(ged_ins_t* ins, const uint32_t value)
{
    return reinterpret_cast<GEDIns*>(ins)->SetUnsignedField(GED_INS_FIELD_Src0Index, value);
}
uint32_t GED_GetSrc1Index(ged_ins_t* ins, GED_RETURN_VALUE* result)
{
    GED_RETURN_VALUE localResult = GED_RETURN_VALUE_INVALID_FIELD;
    if (NULL == result) result = &localResult;
    return reinterpret_cast<GEDIns*>(ins)->GetUnsignedField(GED_INS_FIELD_Src1Index, *result);
}
GED_RETURN_VALUE GED_SetSrc1Index(ged_ins_t* ins, const uint32_t value)
{
    return reinterpret_cast<GEDIns*>(ins)->SetUnsignedField(GED_INS_FIELD_Src1Index, value);
}
uint32_t GED_GetDescIndex(ged_ins_t* ins, GED_RETURN_VALUE* result)
{
    GED_RETURN_VALUE localResult = GED_RETURN_VALUE_INVALID_FIELD;
    if (NULL == result) result = &localResult;
    return reinterpret_cast<GEDIns*>(ins)->GetUnsignedField(GED_INS_FIELD_DescIndex, *result);
}
GED_RETURN_VALUE GED_SetDescIndex(ged_ins_t* ins, const uint32_t value)
{
    return reinterpret_cast<GEDIns*>(ins)->SetUnsignedField(GED_INS_FIELD_DescIndex, value);
}
GED_REG_FILE GED_GetExDescRegFile(ged_ins_t* ins, GED_RETURN_VALUE* result)
{
    GED_RETURN_VALUE localResult = GED_RETURN_VALUE_INVALID_FIELD;
    if (NULL == result) result = &localResult;
    const uint32_t value = reinterpret_cast<GEDIns*>(ins)->GetUnsignedField(GED_INS_FIELD_ExDescRegFile, *result);
    return (GED_RETURN_VALUE_SUCCESS == *result) ? (GED_REG_FILE)value : GED_REG_FILE_INVALID;
}
GED_RETURN_VALUE GED_SetExDescRegFile(ged_ins_t* ins, const GED_REG_FILE value)
{
    return reinterpret_cast<GEDIns*>(ins)->SetUnsignedField(GED_INS_FIELD_ExDescRegFile, (const uint32_t)value);
}
GED_MATH_MACRO_EXT GED_GetDstMathMacroExt(ged_ins_t* ins, GED_RETURN_VALUE* result)
{
    GED_RETURN_VALUE localResult = GED_RETURN_VALUE_INVALID_FIELD;
    if (NULL == result) result = &localResult;
    const uint32_t value = reinterpret_cast<GEDIns*>(ins)->GetUnsignedField(GED_INS_FIELD_DstMathMacroExt, *result);
    return (GED_RETURN_VALUE_SUCCESS == *result) ? (GED_MATH_MACRO_EXT)value : GED_MATH_MACRO_EXT_INVALID;
}
GED_RETURN_VALUE GED_SetDstMathMacroExt(ged_ins_t* ins, const GED_MATH_MACRO_EXT value)
{
    return reinterpret_cast<GEDIns*>(ins)->SetUnsignedField(GED_INS_FIELD_DstMathMacroExt, (const uint32_t)value);
}
GED_MATH_MACRO_EXT GED_GetSrc0MathMacroExt(ged_ins_t* ins, GED_RETURN_VALUE* result)
{
    GED_RETURN_VALUE localResult = GED_RETURN_VALUE_INVALID_FIELD;
    if (NULL == result) result = &localResult;
    const uint32_t value = reinterpret_cast<GEDIns*>(ins)->GetUnsignedField(GED_INS_FIELD_Src0MathMacroExt, *result);
    return (GED_RETURN_VALUE_SUCCESS == *result) ? (GED_MATH_MACRO_EXT)value : GED_MATH_MACRO_EXT_INVALID;
}
GED_RETURN_VALUE GED_SetSrc0MathMacroExt(ged_ins_t* ins, const GED_MATH_MACRO_EXT value)
{
    return reinterpret_cast<GEDIns*>(ins)->SetUnsignedField(GED_INS_FIELD_Src0MathMacroExt, (const uint32_t)value);
}
GED_MATH_MACRO_EXT GED_GetSrc1MathMacroExt(ged_ins_t* ins, GED_RETURN_VALUE* result)
{
    GED_RETURN_VALUE localResult = GED_RETURN_VALUE_INVALID_FIELD;
    if (NULL == result) result = &localResult;
    const uint32_t value = reinterpret_cast<GEDIns*>(ins)->GetUnsignedField(GED_INS_FIELD_Src1MathMacroExt, *result);
    return (GED_RETURN_VALUE_SUCCESS == *result) ? (GED_MATH_MACRO_EXT)value : GED_MATH_MACRO_EXT_INVALID;
}
GED_RETURN_VALUE GED_SetSrc1MathMacroExt(ged_ins_t* ins, const GED_MATH_MACRO_EXT value)
{
    return reinterpret_cast<GEDIns*>(ins)->SetUnsignedField(GED_INS_FIELD_Src1MathMacroExt, (const uint32_t)value);
}
GED_MATH_MACRO_EXT GED_GetSrc2MathMacroExt(ged_ins_t* ins, GED_RETURN_VALUE* result)
{
    GED_RETURN_VALUE localResult = GED_RETURN_VALUE_INVALID_FIELD;
    if (NULL == result) result = &localResult;
    const uint32_t value = reinterpret_cast<GEDIns*>(ins)->GetUnsignedField(GED_INS_FIELD_Src2MathMacroExt, *result);
    return (GED_RETURN_VALUE_SUCCESS == *result) ? (GED_MATH_MACRO_EXT)value : GED_MATH_MACRO_EXT_INVALID;
}
GED_RETURN_VALUE GED_SetSrc2MathMacroExt(ged_ins_t* ins, const GED_MATH_MACRO_EXT value)
{
    return reinterpret_cast<GEDIns*>(ins)->SetUnsignedField(GED_INS_FIELD_Src2MathMacroExt, (const uint32_t)value);
}
GED_BRANCH_CTRL GED_GetBranchCtrl(ged_ins_t* ins, GED_RETURN_VALUE* result)
{
    GED_RETURN_VALUE localResult = GED_RETURN_VALUE_INVALID_FIELD;
    if (NULL == result) result = &localResult;
    const uint32_t value = reinterpret_cast<GEDIns*>(ins)->GetUnsignedField(GED_INS_FIELD_BranchCtrl, *result);
    return (GED_RETURN_VALUE_SUCCESS == *result) ? (GED_BRANCH_CTRL)value : GED_BRANCH_CTRL_INVALID;
}
GED_RETURN_VALUE GED_SetBranchCtrl(ged_ins_t* ins, const GED_BRANCH_CTRL value)
{
    return reinterpret_cast<GEDIns*>(ins)->SetUnsignedField(GED_INS_FIELD_BranchCtrl, (const uint32_t)value);
}
uint32_t GED_GetSourceIndex(ged_ins_t* ins, GED_RETURN_VALUE* result)
{
    GED_RETURN_VALUE localResult = GED_RETURN_VALUE_INVALID_FIELD;
    if (NULL == result) result = &localResult;
    return reinterpret_cast<GEDIns*>(ins)->GetUnsignedField(GED_INS_FIELD_SourceIndex, *result);
}
GED_RETURN_VALUE GED_SetSourceIndex(ged_ins_t* ins, const uint32_t value)
{
    return reinterpret_cast<GEDIns*>(ins)->SetUnsignedField(GED_INS_FIELD_SourceIndex, value);
}
GED_DATA_TYPE GED_GetSrc2DataType(ged_ins_t* ins, GED_RETURN_VALUE* result)
{
    GED_RETURN_VALUE localResult = GED_RETURN_VALUE_INVALID_FIELD;
    if (NULL == result) result = &localResult;
    const uint32_t value = reinterpret_cast<GEDIns*>(ins)->GetUnsignedField(GED_INS_FIELD_Src2DataType, *result);
    return (GED_RETURN_VALUE_SUCCESS == *result) ? (GED_DATA_TYPE)value : GED_DATA_TYPE_INVALID;
}
GED_RETURN_VALUE GED_SetSrc2DataType(ged_ins_t* ins, const GED_DATA_TYPE value)
{
    return reinterpret_cast<GEDIns*>(ins)->SetUnsignedField(GED_INS_FIELD_Src2DataType, (const uint32_t)value);
}
GED_NO_SRC_DEP_SET GED_GetNoSrcDepSet(ged_ins_t* ins, GED_RETURN_VALUE* result)
{
    GED_RETURN_VALUE localResult = GED_RETURN_VALUE_INVALID_FIELD;
    if (NULL == result) result = &localResult;
    const uint32_t value = reinterpret_cast<GEDIns*>(ins)->GetUnsignedField(GED_INS_FIELD_NoSrcDepSet, *result);
    return (GED_RETURN_VALUE_SUCCESS == *result) ? (GED_NO_SRC_DEP_SET)value : GED_NO_SRC_DEP_SET_INVALID;
}
GED_RETURN_VALUE GED_SetNoSrcDepSet(ged_ins_t* ins, const GED_NO_SRC_DEP_SET value)
{
    return reinterpret_cast<GEDIns*>(ins)->SetUnsignedField(GED_INS_FIELD_NoSrcDepSet, (const uint32_t)value);
}
uint32_t GED_GetExFuncCtrl(ged_ins_t* ins, GED_RETURN_VALUE* result)
{
    GED_RETURN_VALUE localResult = GED_RETURN_VALUE_INVALID_FIELD;
    if (NULL == result) result = &localResult;
    return reinterpret_cast<GEDIns*>(ins)->GetUnsignedField(GED_INS_FIELD_ExFuncCtrl, *result);
}
GED_RETURN_VALUE GED_SetExFuncCtrl(ged_ins_t* ins, const uint32_t value)
{
    return reinterpret_cast<GEDIns*>(ins)->SetUnsignedField(GED_INS_FIELD_ExFuncCtrl, value);
}
uint32_t GED_GetExMsgLength(ged_ins_t* ins, GED_RETURN_VALUE* result)
{
    GED_RETURN_VALUE localResult = GED_RETURN_VALUE_INVALID_FIELD;
    if (NULL == result) result = &localResult;
    return reinterpret_cast<GEDIns*>(ins)->GetUnsignedField(GED_INS_FIELD_ExMsgLength, *result);
}
GED_RETURN_VALUE GED_SetExMsgLength(ged_ins_t* ins, const uint32_t value)
{
    return reinterpret_cast<GEDIns*>(ins)->SetUnsignedField(GED_INS_FIELD_ExMsgLength, value);
}
uint32_t GED_GetExDescAddrSubRegNum(ged_ins_t* ins, GED_RETURN_VALUE* result)
{
    GED_RETURN_VALUE localResult = GED_RETURN_VALUE_INVALID_FIELD;
    if (NULL == result) result = &localResult;
    return reinterpret_cast<GEDIns*>(ins)->GetUnsignedField(GED_INS_FIELD_ExDescAddrSubRegNum, *result);
}
GED_RETURN_VALUE GED_SetExDescAddrSubRegNum(ged_ins_t* ins, const uint32_t value)
{
    return reinterpret_cast<GEDIns*>(ins)->SetUnsignedField(GED_INS_FIELD_ExDescAddrSubRegNum, value);
}
uint32_t GED_GetExDescRegNum(ged_ins_t* ins, GED_RETURN_VALUE* result)
{
    GED_RETURN_VALUE localResult = GED_RETURN_VALUE_INVALID_FIELD;
    if (NULL == result) result = &localResult;
    return reinterpret_cast<GEDIns*>(ins)->GetUnsignedField(GED_INS_FIELD_ExDescRegNum, *result);
}
GED_RETURN_VALUE GED_SetExDescRegNum(ged_ins_t* ins, const uint32_t value)
{
    return reinterpret_cast<GEDIns*>(ins)->SetUnsignedField(GED_INS_FIELD_ExDescRegNum, value);
}
uint32_t GED_GetMsgDescCategory(ged_ins_t* ins, GED_RETURN_VALUE* result)
{
    GED_RETURN_VALUE localResult = GED_RETURN_VALUE_INVALID_FIELD;
    if (NULL == result) result = &localResult;
    return reinterpret_cast<GEDIns*>(ins)->GetUnsignedField(GED_INS_FIELD_MsgDescCategory, *result);
}
GED_RETURN_VALUE GED_SetMsgDescCategory(ged_ins_t* ins, const uint32_t value)
{
    return reinterpret_cast<GEDIns*>(ins)->SetUnsignedField(GED_INS_FIELD_MsgDescCategory, value);
}
uint32_t GED_GetMsgDescScratchAddrOffset(ged_ins_t* ins, GED_RETURN_VALUE* result)
{
    GED_RETURN_VALUE localResult = GED_RETURN_VALUE_INVALID_FIELD;
    if (NULL == result) result = &localResult;
    return reinterpret_cast<GEDIns*>(ins)->GetUnsignedField(GED_INS_FIELD_MsgDescScratchAddrOffset, *result);
}
GED_RETURN_VALUE GED_SetMsgDescScratchAddrOffset(ged_ins_t* ins, const uint32_t value)
{
    return reinterpret_cast<GEDIns*>(ins)->SetUnsignedField(GED_INS_FIELD_MsgDescScratchAddrOffset, value);
}
uint32_t GED_GetMsgDescScratchBlockSize(ged_ins_t* ins, GED_RETURN_VALUE* result)
{
    GED_RETURN_VALUE localResult = GED_RETURN_VALUE_INVALID_FIELD;
    if (NULL == result) result = &localResult;
    return reinterpret_cast<GEDIns*>(ins)->GetUnsignedField(GED_INS_FIELD_MsgDescScratchBlockSize, *result);
}
GED_RETURN_VALUE GED_SetMsgDescScratchBlockSize(ged_ins_t* ins, const uint32_t value)
{
    return reinterpret_cast<GEDIns*>(ins)->SetUnsignedField(GED_INS_FIELD_MsgDescScratchBlockSize, value);
}
uint32_t GED_GetMsgDescScratchInvalidateAfterRead(ged_ins_t* ins, GED_RETURN_VALUE* result)
{
    GED_RETURN_VALUE localResult = GED_RETURN_VALUE_INVALID_FIELD;
    if (NULL == result) result = &localResult;
    return reinterpret_cast<GEDIns*>(ins)->GetUnsignedField(GED_INS_FIELD_MsgDescScratchInvalidateAfterRead, *result);
}
GED_RETURN_VALUE GED_SetMsgDescScratchInvalidateAfterRead(ged_ins_t* ins, const uint32_t value)
{
    return reinterpret_cast<GEDIns*>(ins)->SetUnsignedField(GED_INS_FIELD_MsgDescScratchInvalidateAfterRead, value);
}
GED_CHANNEL_MODE GED_GetMsgDescScratchChannelMode(ged_ins_t* ins, GED_RETURN_VALUE* result)
{
    GED_RETURN_VALUE localResult = GED_RETURN_VALUE_INVALID_FIELD;
    if (NULL == result) result = &localResult;
    const uint32_t value = reinterpret_cast<GEDIns*>(ins)->GetUnsignedField(GED_INS_FIELD_MsgDescScratchChannelMode, *result);
    return (GED_RETURN_VALUE_SUCCESS == *result) ? (GED_CHANNEL_MODE)value : GED_CHANNEL_MODE_INVALID;
}
GED_RETURN_VALUE GED_SetMsgDescScratchChannelMode(ged_ins_t* ins, const GED_CHANNEL_MODE value)
{
    return reinterpret_cast<GEDIns*>(ins)->SetUnsignedField(GED_INS_FIELD_MsgDescScratchChannelMode, (const uint32_t)value);
}
GED_MESSAGE_TYPE GED_GetMsgDescScratchMessageType(ged_ins_t* ins, GED_RETURN_VALUE* result)
{
    GED_RETURN_VALUE localResult = GED_RETURN_VALUE_INVALID_FIELD;
    if (NULL == result) result = &localResult;
    const uint32_t value = reinterpret_cast<GEDIns*>(ins)->GetUnsignedField(GED_INS_FIELD_MsgDescScratchMessageType, *result);
    return (GED_RETURN_VALUE_SUCCESS == *result) ? (GED_MESSAGE_TYPE)value : GED_MESSAGE_TYPE_INVALID;
}
GED_RETURN_VALUE GED_SetMsgDescScratchMessageType(ged_ins_t* ins, const GED_MESSAGE_TYPE value)
{
    return reinterpret_cast<GEDIns*>(ins)->SetUnsignedField(GED_INS_FIELD_MsgDescScratchMessageType, (const uint32_t)value);
}
GED_EXECUTION_DATA_TYPE GED_GetExecutionDataType(ged_ins_t* ins, GED_RETURN_VALUE* result)
{
    GED_RETURN_VALUE localResult = GED_RETURN_VALUE_INVALID_FIELD;
    if (NULL == result) result = &localResult;
    const uint32_t value = reinterpret_cast<GEDIns*>(ins)->GetUnsignedField(GED_INS_FIELD_ExecutionDataType, *result);
    return (GED_RETURN_VALUE_SUCCESS == *result) ? (GED_EXECUTION_DATA_TYPE)value : GED_EXECUTION_DATA_TYPE_INVALID;
}
GED_RETURN_VALUE GED_SetExecutionDataType(ged_ins_t* ins, const GED_EXECUTION_DATA_TYPE value)
{
    return reinterpret_cast<GEDIns*>(ins)->SetUnsignedField(GED_INS_FIELD_ExecutionDataType, (const uint32_t)value);
}
uint64_t GED_GetSrc0TernaryImm(ged_ins_t* ins, GED_RETURN_VALUE* result)
{
    GED_RETURN_VALUE localResult = GED_RETURN_VALUE_INVALID_FIELD;
    if (NULL == result) result = &localResult;
    return reinterpret_cast<GEDIns*>(ins)->GetUnsigned64Field(GED_INS_FIELD_Src0TernaryImm, *result);
}
GED_RETURN_VALUE GED_SetSrc0TernaryImm(ged_ins_t* ins, const uint64_t value)
{
    return reinterpret_cast<GEDIns*>(ins)->SetUnsigned64Field(GED_INS_FIELD_Src0TernaryImm, value);
}
uint64_t GED_GetSrc2TernaryImm(ged_ins_t* ins, GED_RETURN_VALUE* result)
{
    GED_RETURN_VALUE localResult = GED_RETURN_VALUE_INVALID_FIELD;
    if (NULL == result) result = &localResult;
    return reinterpret_cast<GEDIns*>(ins)->GetUnsigned64Field(GED_INS_FIELD_Src2TernaryImm, *result);
}
GED_RETURN_VALUE GED_SetSrc2TernaryImm(ged_ins_t* ins, const uint64_t value)
{
    return reinterpret_cast<GEDIns*>(ins)->SetUnsigned64Field(GED_INS_FIELD_Src2TernaryImm, value);
}
uint32_t GED_GetSrc2HorzStride(ged_ins_t* ins, GED_RETURN_VALUE* result)
{
    GED_RETURN_VALUE localResult = GED_RETURN_VALUE_INVALID_FIELD;
    if (NULL == result) result = &localResult;
    return reinterpret_cast<GEDIns*>(ins)->GetUnsignedField(GED_INS_FIELD_Src2HorzStride, *result);
}
GED_RETURN_VALUE GED_SetSrc2HorzStride(ged_ins_t* ins, const uint32_t value)
{
    return reinterpret_cast<GEDIns*>(ins)->SetUnsignedField(GED_INS_FIELD_Src2HorzStride, value);
}
uint32_t GED_GetSWSB(ged_ins_t* ins, GED_RETURN_VALUE* result)
{
    GED_RETURN_VALUE localResult = GED_RETURN_VALUE_INVALID_FIELD;
    if (NULL == result) result = &localResult;
    return reinterpret_cast<GEDIns*>(ins)->GetUnsignedField(GED_INS_FIELD_SWSB, *result);
}
GED_RETURN_VALUE GED_SetSWSB(ged_ins_t* ins, const uint32_t value)
{
    return reinterpret_cast<GEDIns*>(ins)->SetUnsignedField(GED_INS_FIELD_SWSB, value);
}
uint32_t GED_GetSrc1IsImm(ged_ins_t* ins, GED_RETURN_VALUE* result)
{
    GED_RETURN_VALUE localResult = GED_RETURN_VALUE_INVALID_FIELD;
    if (NULL == result) result = &localResult;
    return reinterpret_cast<GEDIns*>(ins)->GetUnsignedField(GED_INS_FIELD_Src1IsImm, *result);
}
GED_RETURN_VALUE GED_SetSrc1IsImm(ged_ins_t* ins, const uint32_t value)
{
    return reinterpret_cast<GEDIns*>(ins)->SetUnsignedField(GED_INS_FIELD_Src1IsImm, value);
}
uint32_t GED_GetSrc0IsImm(ged_ins_t* ins, GED_RETURN_VALUE* result)
{
    GED_RETURN_VALUE localResult = GED_RETURN_VALUE_INVALID_FIELD;
    if (NULL == result) result = &localResult;
    return reinterpret_cast<GEDIns*>(ins)->GetUnsignedField(GED_INS_FIELD_Src0IsImm, *result);
}
GED_RETURN_VALUE GED_SetSrc0IsImm(ged_ins_t* ins, const uint32_t value)
{
    return reinterpret_cast<GEDIns*>(ins)->SetUnsignedField(GED_INS_FIELD_Src0IsImm, value);
}
uint32_t GED_GetSrc0SubRegNumByte(ged_ins_t* ins, GED_RETURN_VALUE* result)
{
    GED_RETURN_VALUE localResult = GED_RETURN_VALUE_INVALID_FIELD;
    if (NULL == result) result = &localResult;
    return reinterpret_cast<GEDIns*>(ins)->GetUnsignedField(GED_INS_FIELD_Src0SubRegNumByte, *result);
}
GED_RETURN_VALUE GED_SetSrc0SubRegNumByte(ged_ins_t* ins, const uint32_t value)
{
    return reinterpret_cast<GEDIns*>(ins)->SetUnsignedField(GED_INS_FIELD_Src0SubRegNumByte, value);
}
GED_SYNC_FC GED_GetSyncFC(ged_ins_t* ins, GED_RETURN_VALUE* result)
{
    GED_RETURN_VALUE localResult = GED_RETURN_VALUE_INVALID_FIELD;
    if (NULL == result) result = &localResult;
    const uint32_t value = reinterpret_cast<GEDIns*>(ins)->GetUnsignedField(GED_INS_FIELD_SyncFC, *result);
    return (GED_RETURN_VALUE_SUCCESS == *result) ? (GED_SYNC_FC)value : GED_SYNC_FC_INVALID;
}
GED_RETURN_VALUE GED_SetSyncFC(ged_ins_t* ins, const GED_SYNC_FC value)
{
    return reinterpret_cast<GEDIns*>(ins)->SetUnsignedField(GED_INS_FIELD_SyncFC, (const uint32_t)value);
}
GED_FUSION_CTRL GED_GetFusionCtrl(ged_ins_t* ins, GED_RETURN_VALUE* result)
{
    GED_RETURN_VALUE localResult = GED_RETURN_VALUE_INVALID_FIELD;
    if (NULL == result) result = &localResult;
    const uint32_t value = reinterpret_cast<GEDIns*>(ins)->GetUnsignedField(GED_INS_FIELD_FusionCtrl, *result);
    return (GED_RETURN_VALUE_SUCCESS == *result) ? (GED_FUSION_CTRL)value : GED_FUSION_CTRL_INVALID;
}
GED_RETURN_VALUE GED_SetFusionCtrl(ged_ins_t* ins, const GED_FUSION_CTRL value)
{
    return reinterpret_cast<GEDIns*>(ins)->SetUnsignedField(GED_INS_FIELD_FusionCtrl, (const uint32_t)value);
}
uint32_t GED_GetDataTypeIndexNoDep(ged_ins_t* ins, GED_RETURN_VALUE* result)
{
    GED_RETURN_VALUE localResult = GED_RETURN_VALUE_INVALID_FIELD;
    if (NULL == result) result = &localResult;
    return reinterpret_cast<GEDIns*>(ins)->GetUnsignedField(GED_INS_FIELD_DataTypeIndexNoDep, *result);
}
GED_RETURN_VALUE GED_SetDataTypeIndexNoDep(ged_ins_t* ins, const uint32_t value)
{
    return reinterpret_cast<GEDIns*>(ins)->SetUnsignedField(GED_INS_FIELD_DataTypeIndexNoDep, value);
}
uint32_t GED_GetCompactedImm(ged_ins_t* ins, GED_RETURN_VALUE* result)
{
    GED_RETURN_VALUE localResult = GED_RETURN_VALUE_INVALID_FIELD;
    if (NULL == result) result = &localResult;
    return reinterpret_cast<GEDIns*>(ins)->GetUnsignedField(GED_INS_FIELD_CompactedImm, *result);
}
GED_RETURN_VALUE GED_SetCompactedImm(ged_ins_t* ins, const uint32_t value)
{
    return reinterpret_cast<GEDIns*>(ins)->SetUnsignedField(GED_INS_FIELD_CompactedImm, value);
}
uint32_t GED_GetRepeatCount(ged_ins_t* ins, GED_RETURN_VALUE* result)
{
    GED_RETURN_VALUE localResult = GED_RETURN_VALUE_INVALID_FIELD;
    if (NULL == result) result = &localResult;
    return reinterpret_cast<GEDIns*>(ins)->GetUnsignedField(GED_INS_FIELD_RepeatCount, *result);
}
GED_RETURN_VALUE GED_SetRepeatCount(ged_ins_t* ins, const uint32_t value)
{
    return reinterpret_cast<GEDIns*>(ins)->SetUnsignedField(GED_INS_FIELD_RepeatCount, value);
}
uint32_t GED_GetSystolicDepth(ged_ins_t* ins, GED_RETURN_VALUE* result)
{
    GED_RETURN_VALUE localResult = GED_RETURN_VALUE_INVALID_FIELD;
    if (NULL == result) result = &localResult;
    return reinterpret_cast<GEDIns*>(ins)->GetUnsignedField(GED_INS_FIELD_SystolicDepth, *result);
}
GED_RETURN_VALUE GED_SetSystolicDepth(ged_ins_t* ins, const uint32_t value)
{
    return reinterpret_cast<GEDIns*>(ins)->SetUnsignedField(GED_INS_FIELD_SystolicDepth, value);
}
GED_PRECISION GED_GetSrc2Precision(ged_ins_t* ins, GED_RETURN_VALUE* result)
{
    GED_RETURN_VALUE localResult = GED_RETURN_VALUE_INVALID_FIELD;
    if (NULL == result) result = &localResult;
    const uint32_t value = reinterpret_cast<GEDIns*>(ins)->GetUnsignedField(GED_INS_FIELD_Src2Precision, *result);
    return (GED_RETURN_VALUE_SUCCESS == *result) ? (GED_PRECISION)value : GED_PRECISION_INVALID;
}
GED_RETURN_VALUE GED_SetSrc2Precision(ged_ins_t* ins, const GED_PRECISION value)
{
    return reinterpret_cast<GEDIns*>(ins)->SetUnsignedField(GED_INS_FIELD_Src2Precision, (const uint32_t)value);
}
GED_SUB_BYTE_PRECISION GED_GetSrc2SubBytePrecision(ged_ins_t* ins, GED_RETURN_VALUE* result)
{
    GED_RETURN_VALUE localResult = GED_RETURN_VALUE_INVALID_FIELD;
    if (NULL == result) result = &localResult;
    const uint32_t value = reinterpret_cast<GEDIns*>(ins)->GetUnsignedField(GED_INS_FIELD_Src2SubBytePrecision, *result);
    return (GED_RETURN_VALUE_SUCCESS == *result) ? (GED_SUB_BYTE_PRECISION)value : GED_SUB_BYTE_PRECISION_INVALID;
}
GED_RETURN_VALUE GED_SetSrc2SubBytePrecision(ged_ins_t* ins, const GED_SUB_BYTE_PRECISION value)
{
    return reinterpret_cast<GEDIns*>(ins)->SetUnsignedField(GED_INS_FIELD_Src2SubBytePrecision, (const uint32_t)value);
}
GED_PRECISION GED_GetSrc1Precision(ged_ins_t* ins, GED_RETURN_VALUE* result)
{
    GED_RETURN_VALUE localResult = GED_RETURN_VALUE_INVALID_FIELD;
    if (NULL == result) result = &localResult;
    const uint32_t value = reinterpret_cast<GEDIns*>(ins)->GetUnsignedField(GED_INS_FIELD_Src1Precision, *result);
    return (GED_RETURN_VALUE_SUCCESS == *result) ? (GED_PRECISION)value : GED_PRECISION_INVALID;
}
GED_RETURN_VALUE GED_SetSrc1Precision(ged_ins_t* ins, const GED_PRECISION value)
{
    return reinterpret_cast<GEDIns*>(ins)->SetUnsignedField(GED_INS_FIELD_Src1Precision, (const uint32_t)value);
}
GED_SUB_BYTE_PRECISION GED_GetSrc1SubBytePrecision(ged_ins_t* ins, GED_RETURN_VALUE* result)
{
    GED_RETURN_VALUE localResult = GED_RETURN_VALUE_INVALID_FIELD;
    if (NULL == result) result = &localResult;
    const uint32_t value = reinterpret_cast<GEDIns*>(ins)->GetUnsignedField(GED_INS_FIELD_Src1SubBytePrecision, *result);
    return (GED_RETURN_VALUE_SUCCESS == *result) ? (GED_SUB_BYTE_PRECISION)value : GED_SUB_BYTE_PRECISION_INVALID;
}
GED_RETURN_VALUE GED_SetSrc1SubBytePrecision(ged_ins_t* ins, const GED_SUB_BYTE_PRECISION value)
{
    return reinterpret_cast<GEDIns*>(ins)->SetUnsignedField(GED_INS_FIELD_Src1SubBytePrecision, (const uint32_t)value);
}
uint32_t GED_GetBfnFC(ged_ins_t* ins, GED_RETURN_VALUE* result)
{
    GED_RETURN_VALUE localResult = GED_RETURN_VALUE_INVALID_FIELD;
    if (NULL == result) result = &localResult;
    return reinterpret_cast<GEDIns*>(ins)->GetUnsignedField(GED_INS_FIELD_BfnFC, *result);
}
GED_RETURN_VALUE GED_SetBfnFC(ged_ins_t* ins, const uint32_t value)
{
    return reinterpret_cast<GEDIns*>(ins)->SetUnsignedField(GED_INS_FIELD_BfnFC, value);
}
uint32_t GED_GetExBSO(ged_ins_t* ins, GED_RETURN_VALUE* result)
{
    GED_RETURN_VALUE localResult = GED_RETURN_VALUE_INVALID_FIELD;
    if (NULL == result) result = &localResult;
    return reinterpret_cast<GEDIns*>(ins)->GetUnsignedField(GED_INS_FIELD_ExBSO, *result);
}
GED_RETURN_VALUE GED_SetExBSO(ged_ins_t* ins, const uint32_t value)
{
    return reinterpret_cast<GEDIns*>(ins)->SetUnsignedField(GED_INS_FIELD_ExBSO, value);
}
uint32_t GED_GetCPS(ged_ins_t* ins, GED_RETURN_VALUE* result)
{
    GED_RETURN_VALUE localResult = GED_RETURN_VALUE_INVALID_FIELD;
    if (NULL == result) result = &localResult;
    return reinterpret_cast<GEDIns*>(ins)->GetUnsignedField(GED_INS_FIELD_CPS, *result);
}
GED_RETURN_VALUE GED_SetCPS(ged_ins_t* ins, const uint32_t value)
{
    return reinterpret_cast<GEDIns*>(ins)->SetUnsignedField(GED_INS_FIELD_CPS, value);
}
uint32_t GED_GetSrc1Length(ged_ins_t* ins, GED_RETURN_VALUE* result)
{
    GED_RETURN_VALUE localResult = GED_RETURN_VALUE_INVALID_FIELD;
    if (NULL == result) result = &localResult;
    return reinterpret_cast<GEDIns*>(ins)->GetUnsignedField(GED_INS_FIELD_Src1Length, *result);
}
GED_RETURN_VALUE GED_SetSrc1Length(ged_ins_t* ins, const uint32_t value)
{
    return reinterpret_cast<GEDIns*>(ins)->SetUnsignedField(GED_INS_FIELD_Src1Length, value);
}
uint32_t GED_GetSrc2IsImm(ged_ins_t* ins, GED_RETURN_VALUE* result)
{
    GED_RETURN_VALUE localResult = GED_RETURN_VALUE_INVALID_FIELD;
    if (NULL == result) result = &localResult;
    return reinterpret_cast<GEDIns*>(ins)->GetUnsignedField(GED_INS_FIELD_Src2IsImm, *result);
}
GED_RETURN_VALUE GED_SetSrc2IsImm(ged_ins_t* ins, const uint32_t value)
{
    return reinterpret_cast<GEDIns*>(ins)->SetUnsignedField(GED_INS_FIELD_Src2IsImm, value);
}
GED_REG_FILE GED_GetMetaRegFile(ged_ins_t* ins, GED_RETURN_VALUE* result)
{
    GED_RETURN_VALUE localResult = GED_RETURN_VALUE_INVALID_FIELD;
    if (NULL == result) result = &localResult;
    const uint32_t value = reinterpret_cast<GEDIns*>(ins)->GetUnsignedField(GED_INS_FIELD_MetaRegFile, *result);
    return (GED_RETURN_VALUE_SUCCESS == *result) ? (GED_REG_FILE)value : GED_REG_FILE_INVALID;
}
GED_RETURN_VALUE GED_SetMetaRegFile(ged_ins_t* ins, const GED_REG_FILE value)
{
    return reinterpret_cast<GEDIns*>(ins)->SetUnsignedField(GED_INS_FIELD_MetaRegFile, (const uint32_t)value);
}
uint32_t GED_GetMetaSubRegNum(ged_ins_t* ins, GED_RETURN_VALUE* result)
{
    GED_RETURN_VALUE localResult = GED_RETURN_VALUE_INVALID_FIELD;
    if (NULL == result) result = &localResult;
    return reinterpret_cast<GEDIns*>(ins)->GetUnsignedField(GED_INS_FIELD_MetaSubRegNum, *result);
}
GED_RETURN_VALUE GED_SetMetaSubRegNum(ged_ins_t* ins, const uint32_t value)
{
    return reinterpret_cast<GEDIns*>(ins)->SetUnsignedField(GED_INS_FIELD_MetaSubRegNum, value);
}
uint32_t GED_GetMetaRegNum(ged_ins_t* ins, GED_RETURN_VALUE* result)
{
    GED_RETURN_VALUE localResult = GED_RETURN_VALUE_INVALID_FIELD;
    if (NULL == result) result = &localResult;
    return reinterpret_cast<GEDIns*>(ins)->GetUnsignedField(GED_INS_FIELD_MetaRegNum, *result);
}
GED_RETURN_VALUE GED_SetMetaRegNum(ged_ins_t* ins, const uint32_t value)
{
    return reinterpret_cast<GEDIns*>(ins)->SetUnsignedField(GED_INS_FIELD_MetaRegNum, value);
}
uint32_t GED_GetDstRegNum8(ged_ins_t* ins, GED_RETURN_VALUE* result)
{
    GED_RETURN_VALUE localResult = GED_RETURN_VALUE_INVALID_FIELD;
    if (NULL == result) result = &localResult;
    return reinterpret_cast<GEDIns*>(ins)->GetUnsignedField(GED_INS_FIELD_DstRegNum8, *result);
}
GED_RETURN_VALUE GED_SetDstRegNum8(ged_ins_t* ins, const uint32_t value)
{
    return reinterpret_cast<GEDIns*>(ins)->SetUnsignedField(GED_INS_FIELD_DstRegNum8, value);
}
uint32_t GED_GetSrc0RegNum8(ged_ins_t* ins, GED_RETURN_VALUE* result)
{
    GED_RETURN_VALUE localResult = GED_RETURN_VALUE_INVALID_FIELD;
    if (NULL == result) result = &localResult;
    return reinterpret_cast<GEDIns*>(ins)->GetUnsignedField(GED_INS_FIELD_Src0RegNum8, *result);
}
GED_RETURN_VALUE GED_SetSrc0RegNum8(ged_ins_t* ins, const uint32_t value)
{
    return reinterpret_cast<GEDIns*>(ins)->SetUnsignedField(GED_INS_FIELD_Src0RegNum8, value);
}
GED_LFSR_FC GED_GetLfsrFC(ged_ins_t* ins, GED_RETURN_VALUE* result)
{
    GED_RETURN_VALUE localResult = GED_RETURN_VALUE_INVALID_FIELD;
    if (NULL == result) result = &localResult;
    const uint32_t value = reinterpret_cast<GEDIns*>(ins)->GetUnsignedField(GED_INS_FIELD_LfsrFC, *result);
    return (GED_RETURN_VALUE_SUCCESS == *result) ? (GED_LFSR_FC)value : GED_LFSR_FC_INVALID;
}
GED_RETURN_VALUE GED_SetLfsrFC(ged_ins_t* ins, const GED_LFSR_FC value)
{
    return reinterpret_cast<GEDIns*>(ins)->SetUnsignedField(GED_INS_FIELD_LfsrFC, (const uint32_t)value);
}
GED_SHUFFLE_FC GED_GetShuffleFC(ged_ins_t* ins, GED_RETURN_VALUE* result)
{
    GED_RETURN_VALUE localResult = GED_RETURN_VALUE_INVALID_FIELD;
    if (NULL == result) result = &localResult;
    const uint32_t value = reinterpret_cast<GEDIns*>(ins)->GetUnsignedField(GED_INS_FIELD_ShuffleFC, *result);
    return (GED_RETURN_VALUE_SUCCESS == *result) ? (GED_SHUFFLE_FC)value : GED_SHUFFLE_FC_INVALID;
}
GED_RETURN_VALUE GED_SetShuffleFC(ged_ins_t* ins, const GED_SHUFFLE_FC value)
{
    return reinterpret_cast<GEDIns*>(ins)->SetUnsignedField(GED_INS_FIELD_ShuffleFC, (const uint32_t)value);
}
uint32_t GED_GetSrc1RegNum8(ged_ins_t* ins, GED_RETURN_VALUE* result)
{
    GED_RETURN_VALUE localResult = GED_RETURN_VALUE_INVALID_FIELD;
    if (NULL == result) result = &localResult;
    return reinterpret_cast<GEDIns*>(ins)->GetUnsignedField(GED_INS_FIELD_Src1RegNum8, *result);
}
GED_RETURN_VALUE GED_SetSrc1RegNum8(ged_ins_t* ins, const uint32_t value)
{
    return reinterpret_cast<GEDIns*>(ins)->SetUnsignedField(GED_INS_FIELD_Src1RegNum8, value);
}
uint32_t GED_GetSrc1ScalarReg(ged_ins_t* ins, GED_RETURN_VALUE* result)
{
    GED_RETURN_VALUE localResult = GED_RETURN_VALUE_INVALID_FIELD;
    if (NULL == result) result = &localResult;
    return reinterpret_cast<GEDIns*>(ins)->GetUnsignedField(GED_INS_FIELD_Src1ScalarReg, *result);
}
GED_RETURN_VALUE GED_SetSrc1ScalarReg(ged_ins_t* ins, const uint32_t value)
{
    return reinterpret_cast<GEDIns*>(ins)->SetUnsignedField(GED_INS_FIELD_Src1ScalarReg, value);
}
uint32_t GED_GetSrc2RegNum8(ged_ins_t* ins, GED_RETURN_VALUE* result)
{
    GED_RETURN_VALUE localResult = GED_RETURN_VALUE_INVALID_FIELD;
    if (NULL == result) result = &localResult;
    return reinterpret_cast<GEDIns*>(ins)->GetUnsignedField(GED_INS_FIELD_Src2RegNum8, *result);
}
GED_RETURN_VALUE GED_SetSrc2RegNum8(ged_ins_t* ins, const uint32_t value)
{
    return reinterpret_cast<GEDIns*>(ins)->SetUnsignedField(GED_INS_FIELD_Src2RegNum8, value);
}
uint32_t GED_GetFwdCtrl(ged_ins_t* ins, GED_RETURN_VALUE* result)
{
    GED_RETURN_VALUE localResult = GED_RETURN_VALUE_INVALID_FIELD;
    if (NULL == result) result = &localResult;
    return reinterpret_cast<GEDIns*>(ins)->GetUnsignedField(GED_INS_FIELD_FwdCtrl, *result);
}
GED_RETURN_VALUE GED_SetFwdCtrl(ged_ins_t* ins, const uint32_t value)
{
    return reinterpret_cast<GEDIns*>(ins)->SetUnsignedField(GED_INS_FIELD_FwdCtrl, value);
}
GED_DNSCL_MODE GED_GetDnsclMode(ged_ins_t* ins, GED_RETURN_VALUE* result)
{
    GED_RETURN_VALUE localResult = GED_RETURN_VALUE_INVALID_FIELD;
    if (NULL == result) result = &localResult;
    const uint32_t value = reinterpret_cast<GEDIns*>(ins)->GetUnsignedField(GED_INS_FIELD_DnsclMode, *result);
    return (GED_RETURN_VALUE_SUCCESS == *result) ? (GED_DNSCL_MODE)value : GED_DNSCL_MODE_INVALID;
}
GED_RETURN_VALUE GED_SetDnsclMode(ged_ins_t* ins, const GED_DNSCL_MODE value)
{
    return reinterpret_cast<GEDIns*>(ins)->SetUnsignedField(GED_INS_FIELD_DnsclMode, (const uint32_t)value);
}
GED_ROUNDING_MODE GED_GetRoundingMode(ged_ins_t* ins, GED_RETURN_VALUE* result)
{
    GED_RETURN_VALUE localResult = GED_RETURN_VALUE_INVALID_FIELD;
    if (NULL == result) result = &localResult;
    const uint32_t value = reinterpret_cast<GEDIns*>(ins)->GetUnsignedField(GED_INS_FIELD_RoundingMode, *result);
    return (GED_RETURN_VALUE_SUCCESS == *result) ? (GED_ROUNDING_MODE)value : GED_ROUNDING_MODE_INVALID;
}
GED_RETURN_VALUE GED_SetRoundingMode(ged_ins_t* ins, const GED_ROUNDING_MODE value)
{
    return reinterpret_cast<GEDIns*>(ins)->SetUnsignedField(GED_INS_FIELD_RoundingMode, (const uint32_t)value);
}
GED_CONV_SRC_DATATYPE GED_GetConvSrcDataType(ged_ins_t* ins, GED_RETURN_VALUE* result)
{
    GED_RETURN_VALUE localResult = GED_RETURN_VALUE_INVALID_FIELD;
    if (NULL == result) result = &localResult;
    const uint32_t value = reinterpret_cast<GEDIns*>(ins)->GetUnsignedField(GED_INS_FIELD_ConvSrcDataType, *result);
    return (GED_RETURN_VALUE_SUCCESS == *result) ? (GED_CONV_SRC_DATATYPE)value : GED_CONV_SRC_DATATYPE_INVALID;
}
GED_RETURN_VALUE GED_SetConvSrcDataType(ged_ins_t* ins, const GED_CONV_SRC_DATATYPE value)
{
    return reinterpret_cast<GEDIns*>(ins)->SetUnsignedField(GED_INS_FIELD_ConvSrcDataType, (const uint32_t)value);
}
GED_CONV_DST_DATATYPE GED_GetConvDstDataType(ged_ins_t* ins, GED_RETURN_VALUE* result)
{
    GED_RETURN_VALUE localResult = GED_RETURN_VALUE_INVALID_FIELD;
    if (NULL == result) result = &localResult;
    const uint32_t value = reinterpret_cast<GEDIns*>(ins)->GetUnsignedField(GED_INS_FIELD_ConvDstDataType, *result);
    return (GED_RETURN_VALUE_SUCCESS == *result) ? (GED_CONV_DST_DATATYPE)value : GED_CONV_DST_DATATYPE_INVALID;
}
GED_RETURN_VALUE GED_SetConvDstDataType(ged_ins_t* ins, const GED_CONV_DST_DATATYPE value)
{
    return reinterpret_cast<GEDIns*>(ins)->SetUnsignedField(GED_INS_FIELD_ConvDstDataType, (const uint32_t)value);
}
uint32_t GED_GetSendSwitchCtrl(ged_ins_t* ins, GED_RETURN_VALUE* result)
{
    GED_RETURN_VALUE localResult = GED_RETURN_VALUE_INVALID_FIELD;
    if (NULL == result) result = &localResult;
    return reinterpret_cast<GEDIns*>(ins)->GetUnsignedField(GED_INS_FIELD_SendSwitchCtrl, *result);
}
GED_RETURN_VALUE GED_SetSendSwitchCtrl(ged_ins_t* ins, const uint32_t value)
{
    return reinterpret_cast<GEDIns*>(ins)->SetUnsignedField(GED_INS_FIELD_SendSwitchCtrl, value);
}
uint32_t GED_GetIndMsgDesc0IsPresent(ged_ins_t* ins, GED_RETURN_VALUE* result)
{
    GED_RETURN_VALUE localResult = GED_RETURN_VALUE_INVALID_FIELD;
    if (NULL == result) result = &localResult;
    return reinterpret_cast<GEDIns*>(ins)->GetUnsignedField(GED_INS_FIELD_IndMsgDesc0IsPresent, *result);
}
GED_RETURN_VALUE GED_SetIndMsgDesc0IsPresent(ged_ins_t* ins, const uint32_t value)
{
    return reinterpret_cast<GEDIns*>(ins)->SetUnsignedField(GED_INS_FIELD_IndMsgDesc0IsPresent, value);
}
uint32_t GED_GetIndMsgDesc1IsPresent(ged_ins_t* ins, GED_RETURN_VALUE* result)
{
    GED_RETURN_VALUE localResult = GED_RETURN_VALUE_INVALID_FIELD;
    if (NULL == result) result = &localResult;
    return reinterpret_cast<GEDIns*>(ins)->GetUnsignedField(GED_INS_FIELD_IndMsgDesc1IsPresent, *result);
}
GED_RETURN_VALUE GED_SetIndMsgDesc1IsPresent(ged_ins_t* ins, const uint32_t value)
{
    return reinterpret_cast<GEDIns*>(ins)->SetUnsignedField(GED_INS_FIELD_IndMsgDesc1IsPresent, value);
}
uint64_t GED_GetMsgDesc64(ged_ins_t* ins, GED_RETURN_VALUE* result)
{
    GED_RETURN_VALUE localResult = GED_RETURN_VALUE_INVALID_FIELD;
    if (NULL == result) result = &localResult;
    return reinterpret_cast<GEDIns*>(ins)->GetUnsigned64Field(GED_INS_FIELD_MsgDesc64, *result);
}
GED_RETURN_VALUE GED_SetMsgDesc64(ged_ins_t* ins, const uint64_t value)
{
    return reinterpret_cast<GEDIns*>(ins)->SetUnsigned64Field(GED_INS_FIELD_MsgDesc64, value);
}
uint32_t GED_GetIndMsgDesc1Addr(ged_ins_t* ins, GED_RETURN_VALUE* result)
{
    GED_RETURN_VALUE localResult = GED_RETURN_VALUE_INVALID_FIELD;
    if (NULL == result) result = &localResult;
    return reinterpret_cast<GEDIns*>(ins)->GetUnsignedField(GED_INS_FIELD_IndMsgDesc1Addr, *result);
}
GED_RETURN_VALUE GED_SetIndMsgDesc1Addr(ged_ins_t* ins, const uint32_t value)
{
    return reinterpret_cast<GEDIns*>(ins)->SetUnsignedField(GED_INS_FIELD_IndMsgDesc1Addr, value);
}
uint32_t GED_GetIndMsgDesc0Addr(ged_ins_t* ins, GED_RETURN_VALUE* result)
{
    GED_RETURN_VALUE localResult = GED_RETURN_VALUE_INVALID_FIELD;
    if (NULL == result) result = &localResult;
    return reinterpret_cast<GEDIns*>(ins)->GetUnsignedField(GED_INS_FIELD_IndMsgDesc0Addr, *result);
}
GED_RETURN_VALUE GED_SetIndMsgDesc0Addr(ged_ins_t* ins, const uint32_t value)
{
    return reinterpret_cast<GEDIns*>(ins)->SetUnsignedField(GED_INS_FIELD_IndMsgDesc0Addr, value);
}
uint32_t GED_GetSrc0Length(ged_ins_t* ins, GED_RETURN_VALUE* result)
{
    GED_RETURN_VALUE localResult = GED_RETURN_VALUE_INVALID_FIELD;
    if (NULL == result) result = &localResult;
    return reinterpret_cast<GEDIns*>(ins)->GetUnsignedField(GED_INS_FIELD_Src0Length, *result);
}
GED_RETURN_VALUE GED_SetSrc0Length(ged_ins_t* ins, const uint32_t value)
{
    return reinterpret_cast<GEDIns*>(ins)->SetUnsignedField(GED_INS_FIELD_Src0Length, value);
}
GED_REG_FILE GED_GetSrc4RegFile(ged_ins_t* ins, GED_RETURN_VALUE* result)
{
    GED_RETURN_VALUE localResult = GED_RETURN_VALUE_INVALID_FIELD;
    if (NULL == result) result = &localResult;
    const uint32_t value = reinterpret_cast<GEDIns*>(ins)->GetUnsignedField(GED_INS_FIELD_Src4RegFile, *result);
    return (GED_RETURN_VALUE_SUCCESS == *result) ? (GED_REG_FILE)value : GED_REG_FILE_INVALID;
}
GED_RETURN_VALUE GED_SetSrc4RegFile(ged_ins_t* ins, const GED_REG_FILE value)
{
    return reinterpret_cast<GEDIns*>(ins)->SetUnsignedField(GED_INS_FIELD_Src4RegFile, (const uint32_t)value);
}
GED_REG_FILE GED_GetSrc3RegFile(ged_ins_t* ins, GED_RETURN_VALUE* result)
{
    GED_RETURN_VALUE localResult = GED_RETURN_VALUE_INVALID_FIELD;
    if (NULL == result) result = &localResult;
    const uint32_t value = reinterpret_cast<GEDIns*>(ins)->GetUnsignedField(GED_INS_FIELD_Src3RegFile, *result);
    return (GED_RETURN_VALUE_SUCCESS == *result) ? (GED_REG_FILE)value : GED_REG_FILE_INVALID;
}
GED_RETURN_VALUE GED_SetSrc3RegFile(ged_ins_t* ins, const GED_REG_FILE value)
{
    return reinterpret_cast<GEDIns*>(ins)->SetUnsignedField(GED_INS_FIELD_Src3RegFile, (const uint32_t)value);
}
uint32_t GED_GetSrc4RegNum(ged_ins_t* ins, GED_RETURN_VALUE* result)
{
    GED_RETURN_VALUE localResult = GED_RETURN_VALUE_INVALID_FIELD;
    if (NULL == result) result = &localResult;
    return reinterpret_cast<GEDIns*>(ins)->GetUnsignedField(GED_INS_FIELD_Src4RegNum, *result);
}
GED_RETURN_VALUE GED_SetSrc4RegNum(ged_ins_t* ins, const uint32_t value)
{
    return reinterpret_cast<GEDIns*>(ins)->SetUnsignedField(GED_INS_FIELD_Src4RegNum, value);
}
uint32_t GED_GetSrc3RegNum(ged_ins_t* ins, GED_RETURN_VALUE* result)
{
    GED_RETURN_VALUE localResult = GED_RETURN_VALUE_INVALID_FIELD;
    if (NULL == result) result = &localResult;
    return reinterpret_cast<GEDIns*>(ins)->GetUnsignedField(GED_INS_FIELD_Src3RegNum, *result);
}
GED_RETURN_VALUE GED_SetSrc3RegNum(ged_ins_t* ins, const uint32_t value)
{
    return reinterpret_cast<GEDIns*>(ins)->SetUnsignedField(GED_INS_FIELD_Src3RegNum, value);
}
uint32_t GED_GetSystolicDepthBlkScl(ged_ins_t* ins, GED_RETURN_VALUE* result)
{
    GED_RETURN_VALUE localResult = GED_RETURN_VALUE_INVALID_FIELD;
    if (NULL == result) result = &localResult;
    return reinterpret_cast<GEDIns*>(ins)->GetUnsignedField(GED_INS_FIELD_SystolicDepthBlkScl, *result);
}
GED_RETURN_VALUE GED_SetSystolicDepthBlkScl(ged_ins_t* ins, const uint32_t value)
{
    return reinterpret_cast<GEDIns*>(ins)->SetUnsignedField(GED_INS_FIELD_SystolicDepthBlkScl, value);
}
uint32_t GED_GetSrc4SubRegNum(ged_ins_t* ins, GED_RETURN_VALUE* result)
{
    GED_RETURN_VALUE localResult = GED_RETURN_VALUE_INVALID_FIELD;
    if (NULL == result) result = &localResult;
    return reinterpret_cast<GEDIns*>(ins)->GetUnsignedField(GED_INS_FIELD_Src4SubRegNum, *result);
}
GED_RETURN_VALUE GED_SetSrc4SubRegNum(ged_ins_t* ins, const uint32_t value)
{
    return reinterpret_cast<GEDIns*>(ins)->SetUnsignedField(GED_INS_FIELD_Src4SubRegNum, value);
}
uint32_t GED_GetSrc3SubRegNum(ged_ins_t* ins, GED_RETURN_VALUE* result)
{
    GED_RETURN_VALUE localResult = GED_RETURN_VALUE_INVALID_FIELD;
    if (NULL == result) result = &localResult;
    return reinterpret_cast<GEDIns*>(ins)->GetUnsignedField(GED_INS_FIELD_Src3SubRegNum, *result);
}
GED_RETURN_VALUE GED_SetSrc3SubRegNum(ged_ins_t* ins, const uint32_t value)
{
    return reinterpret_cast<GEDIns*>(ins)->SetUnsignedField(GED_INS_FIELD_Src3SubRegNum, value);
}
uint32_t GED_GetSrc3RegNum8(ged_ins_t* ins, GED_RETURN_VALUE* result)
{
    GED_RETURN_VALUE localResult = GED_RETURN_VALUE_INVALID_FIELD;
    if (NULL == result) result = &localResult;
    return reinterpret_cast<GEDIns*>(ins)->GetUnsignedField(GED_INS_FIELD_Src3RegNum8, *result);
}
GED_RETURN_VALUE GED_SetSrc3RegNum8(ged_ins_t* ins, const uint32_t value)
{
    return reinterpret_cast<GEDIns*>(ins)->SetUnsignedField(GED_INS_FIELD_Src3RegNum8, value);
}
uint32_t GED_GetSrc4RegNum8(ged_ins_t* ins, GED_RETURN_VALUE* result)
{
    GED_RETURN_VALUE localResult = GED_RETURN_VALUE_INVALID_FIELD;
    if (NULL == result) result = &localResult;
    return reinterpret_cast<GEDIns*>(ins)->GetUnsignedField(GED_INS_FIELD_Src4RegNum8, *result);
}
GED_RETURN_VALUE GED_SetSrc4RegNum8(ged_ins_t* ins, const uint32_t value)
{
    return reinterpret_cast<GEDIns*>(ins)->SetUnsignedField(GED_INS_FIELD_Src4RegNum8, value);
}
uint32_t GED_GetIndexedIndMsgDescAddr(ged_ins_t* ins, GED_RETURN_VALUE* result, const uint8_t index)
{
    if (0 == index) return GED_GetIndMsgDesc0Addr(ins, result);
    if (1 == index) return GED_GetIndMsgDesc1Addr(ins, result);
    if (NULL != result) *result = GED_RETURN_VALUE_INVALID_OPERAND;
    return (uint32_t)-1;
}
GED_RETURN_VALUE GED_SetIndexedIndMsgDescAddr(ged_ins_t* ins, const uint32_t value, const uint8_t index)
{
    if (0 == index) return GED_SetIndMsgDesc0Addr(ins, value);
    if (1 == index) return GED_SetIndMsgDesc1Addr(ins, value);
    return GED_RETURN_VALUE_INVALID_OPERAND;
}
int32_t GED_GetIndexedSrcAddrImm(ged_ins_t* ins, GED_RETURN_VALUE* result, const uint8_t index)
{
    if (0 == index) return GED_GetSrc0AddrImm(ins, result);
    if (1 == index) return GED_GetSrc1AddrImm(ins, result);
    if (NULL != result) *result = GED_RETURN_VALUE_INVALID_OPERAND;
    return (int32_t)-1;
}
GED_RETURN_VALUE GED_SetIndexedSrcAddrImm(ged_ins_t* ins, const int32_t value, const uint8_t index)
{
    if (0 == index) return GED_SetSrc0AddrImm(ins, value);
    if (1 == index) return GED_SetSrc1AddrImm(ins, value);
    return GED_RETURN_VALUE_INVALID_OPERAND;
}
GED_ADDR_MODE GED_GetIndexedSrcAddrMode(ged_ins_t* ins, GED_RETURN_VALUE* result, const uint8_t index)
{
    if (0 == index) return GED_GetSrc0AddrMode(ins, result);
    if (1 == index) return GED_GetSrc1AddrMode(ins, result);
    if (2 == index) return GED_GetSrc2AddrMode(ins, result);
    if (NULL != result) *result = GED_RETURN_VALUE_INVALID_OPERAND;
    return GED_ADDR_MODE_INVALID;
}
GED_RETURN_VALUE GED_SetIndexedSrcAddrMode(ged_ins_t* ins, const GED_ADDR_MODE value, const uint8_t index)
{
    if (0 == index) return GED_SetSrc0AddrMode(ins, value);
    if (1 == index) return GED_SetSrc1AddrMode(ins, value);
    if (2 == index) return GED_SetSrc2AddrMode(ins, value);
    return GED_RETURN_VALUE_INVALID_OPERAND;
}
uint32_t GED_GetIndexedSrcAddrSubRegNum(ged_ins_t* ins, GED_RETURN_VALUE* result, const uint8_t index)
{
    if (0 == index) return GED_GetSrc0AddrSubRegNum(ins, result);
    if (1 == index) return GED_GetSrc1AddrSubRegNum(ins, result);
    if (NULL != result) *result = GED_RETURN_VALUE_INVALID_OPERAND;
    return (uint32_t)-1;
}
GED_RETURN_VALUE GED_SetIndexedSrcAddrSubRegNum(ged_ins_t* ins, const uint32_t value, const uint8_t index)
{
    if (0 == index) return GED_SetSrc0AddrSubRegNum(ins, value);
    if (1 == index) return GED_SetSrc1AddrSubRegNum(ins, value);
    return GED_RETURN_VALUE_INVALID_OPERAND;
}
uint32_t GED_GetIndexedSrcChanSel(ged_ins_t* ins, GED_RETURN_VALUE* result, const uint8_t index)
{
    if (0 == index) return GED_GetSrc0ChanSel(ins, result);
    if (1 == index) return GED_GetSrc1ChanSel(ins, result);
    if (2 == index) return GED_GetSrc2ChanSel(ins, result);
    if (NULL != result) *result = GED_RETURN_VALUE_INVALID_OPERAND;
    return (uint32_t)-1;
}
GED_RETURN_VALUE GED_SetIndexedSrcChanSel(ged_ins_t* ins, const uint32_t value, const uint8_t index)
{
    if (0 == index) return GED_SetSrc0ChanSel(ins, value);
    if (1 == index) return GED_SetSrc1ChanSel(ins, value);
    if (2 == index) return GED_SetSrc2ChanSel(ins, value);
    return GED_RETURN_VALUE_INVALID_OPERAND;
}
GED_DATA_TYPE GED_GetIndexedSrcDataType(ged_ins_t* ins, GED_RETURN_VALUE* result, const uint8_t index)
{
    if (0 == index) return GED_GetSrc0DataType(ins, result);
    if (1 == index) return GED_GetSrc1DataType(ins, result);
    if (2 == index) return GED_GetSrc2DataType(ins, result);
    if (NULL != result) *result = GED_RETURN_VALUE_INVALID_OPERAND;
    return GED_DATA_TYPE_INVALID;
}
GED_RETURN_VALUE GED_SetIndexedSrcDataType(ged_ins_t* ins, const GED_DATA_TYPE value, const uint8_t index)
{
    if (0 == index) return GED_SetSrc0DataType(ins, value);
    if (1 == index) return GED_SetSrc1DataType(ins, value);
    if (2 == index) return GED_SetSrc2DataType(ins, value);
    return GED_RETURN_VALUE_INVALID_OPERAND;
}
uint32_t GED_GetIndexedSrcHorzStride(ged_ins_t* ins, GED_RETURN_VALUE* result, const uint8_t index)
{
    if (0 == index) return GED_GetSrc0HorzStride(ins, result);
    if (1 == index) return GED_GetSrc1HorzStride(ins, result);
    if (2 == index) return GED_GetSrc2HorzStride(ins, result);
    if (NULL != result) *result = GED_RETURN_VALUE_INVALID_OPERAND;
    return (uint32_t)-1;
}
GED_RETURN_VALUE GED_SetIndexedSrcHorzStride(ged_ins_t* ins, const uint32_t value, const uint8_t index)
{
    if (0 == index) return GED_SetSrc0HorzStride(ins, value);
    if (1 == index) return GED_SetSrc1HorzStride(ins, value);
    if (2 == index) return GED_SetSrc2HorzStride(ins, value);
    return GED_RETURN_VALUE_INVALID_OPERAND;
}
uint32_t GED_GetIndexedSrcIndex(ged_ins_t* ins, GED_RETURN_VALUE* result, const uint8_t index)
{
    if (0 == index) return GED_GetSrc0Index(ins, result);
    if (1 == index) return GED_GetSrc1Index(ins, result);
    if (NULL != result) *result = GED_RETURN_VALUE_INVALID_OPERAND;
    return (uint32_t)-1;
}
GED_RETURN_VALUE GED_SetIndexedSrcIndex(ged_ins_t* ins, const uint32_t value, const uint8_t index)
{
    if (0 == index) return GED_SetSrc0Index(ins, value);
    if (1 == index) return GED_SetSrc1Index(ins, value);
    return GED_RETURN_VALUE_INVALID_OPERAND;
}
uint32_t GED_GetIndexedSrcIsImm(ged_ins_t* ins, GED_RETURN_VALUE* result, const uint8_t index)
{
    if (0 == index) return GED_GetSrc0IsImm(ins, result);
    if (1 == index) return GED_GetSrc1IsImm(ins, result);
    if (2 == index) return GED_GetSrc2IsImm(ins, result);
    if (NULL != result) *result = GED_RETURN_VALUE_INVALID_OPERAND;
    return (uint32_t)-1;
}
GED_RETURN_VALUE GED_SetIndexedSrcIsImm(ged_ins_t* ins, const uint32_t value, const uint8_t index)
{
    if (0 == index) return GED_SetSrc0IsImm(ins, value);
    if (1 == index) return GED_SetSrc1IsImm(ins, value);
    if (2 == index) return GED_SetSrc2IsImm(ins, value);
    return GED_RETURN_VALUE_INVALID_OPERAND;
}
uint32_t GED_GetIndexedIndMsgDescIsPresent(ged_ins_t* ins, GED_RETURN_VALUE* result, const uint8_t index)
{
    if (0 == index) return GED_GetIndMsgDesc0IsPresent(ins, result);
    if (1 == index) return GED_GetIndMsgDesc1IsPresent(ins, result);
    if (NULL != result) *result = GED_RETURN_VALUE_INVALID_OPERAND;
    return (uint32_t)-1;
}
GED_RETURN_VALUE GED_SetIndexedIndMsgDescIsPresent(ged_ins_t* ins, const uint32_t value, const uint8_t index)
{
    if (0 == index) return GED_SetIndMsgDesc0IsPresent(ins, value);
    if (1 == index) return GED_SetIndMsgDesc1IsPresent(ins, value);
    return GED_RETURN_VALUE_INVALID_OPERAND;
}
GED_MATH_MACRO_EXT GED_GetIndexedSrcMathMacroExt(ged_ins_t* ins, GED_RETURN_VALUE* result, const uint8_t index)
{
    if (0 == index) return GED_GetSrc0MathMacroExt(ins, result);
    if (1 == index) return GED_GetSrc1MathMacroExt(ins, result);
    if (2 == index) return GED_GetSrc2MathMacroExt(ins, result);
    if (NULL != result) *result = GED_RETURN_VALUE_INVALID_OPERAND;
    return GED_MATH_MACRO_EXT_INVALID;
}
GED_RETURN_VALUE GED_SetIndexedSrcMathMacroExt(ged_ins_t* ins, const GED_MATH_MACRO_EXT value, const uint8_t index)
{
    if (0 == index) return GED_SetSrc0MathMacroExt(ins, value);
    if (1 == index) return GED_SetSrc1MathMacroExt(ins, value);
    if (2 == index) return GED_SetSrc2MathMacroExt(ins, value);
    return GED_RETURN_VALUE_INVALID_OPERAND;
}
GED_REG_FILE GED_GetIndexedSrcRegFile(ged_ins_t* ins, GED_RETURN_VALUE* result, const uint8_t index)
{
    if (0 == index) return GED_GetSrc0RegFile(ins, result);
    if (1 == index) return GED_GetSrc1RegFile(ins, result);
    if (2 == index) return GED_GetSrc2RegFile(ins, result);
    if (3 == index) return GED_GetSrc3RegFile(ins, result);
    if (4 == index) return GED_GetSrc4RegFile(ins, result);
    if (NULL != result) *result = GED_RETURN_VALUE_INVALID_OPERAND;
    return GED_REG_FILE_INVALID;
}
GED_RETURN_VALUE GED_SetIndexedSrcRegFile(ged_ins_t* ins, const GED_REG_FILE value, const uint8_t index)
{
    if (0 == index) return GED_SetSrc0RegFile(ins, value);
    if (1 == index) return GED_SetSrc1RegFile(ins, value);
    if (2 == index) return GED_SetSrc2RegFile(ins, value);
    if (3 == index) return GED_SetSrc3RegFile(ins, value);
    if (4 == index) return GED_SetSrc4RegFile(ins, value);
    return GED_RETURN_VALUE_INVALID_OPERAND;
}
uint32_t GED_GetIndexedSrcRegNum(ged_ins_t* ins, GED_RETURN_VALUE* result, const uint8_t index)
{
    if (0 == index) return GED_GetSrc0RegNum(ins, result);
    if (1 == index) return GED_GetSrc1RegNum(ins, result);
    if (2 == index) return GED_GetSrc2RegNum(ins, result);
    if (3 == index) return GED_GetSrc3RegNum(ins, result);
    if (4 == index) return GED_GetSrc4RegNum(ins, result);
    if (NULL != result) *result = GED_RETURN_VALUE_INVALID_OPERAND;
    return (uint32_t)-1;
}
GED_RETURN_VALUE GED_SetIndexedSrcRegNum(ged_ins_t* ins, const uint32_t value, const uint8_t index)
{
    if (0 == index) return GED_SetSrc0RegNum(ins, value);
    if (1 == index) return GED_SetSrc1RegNum(ins, value);
    if (2 == index) return GED_SetSrc2RegNum(ins, value);
    if (3 == index) return GED_SetSrc3RegNum(ins, value);
    if (4 == index) return GED_SetSrc4RegNum(ins, value);
    return GED_RETURN_VALUE_INVALID_OPERAND;
}
GED_REP_CTRL GED_GetIndexedSrcRepCtrl(ged_ins_t* ins, GED_RETURN_VALUE* result, const uint8_t index)
{
    if (0 == index) return GED_GetSrc0RepCtrl(ins, result);
    if (1 == index) return GED_GetSrc1RepCtrl(ins, result);
    if (2 == index) return GED_GetSrc2RepCtrl(ins, result);
    if (NULL != result) *result = GED_RETURN_VALUE_INVALID_OPERAND;
    return GED_REP_CTRL_INVALID;
}
GED_RETURN_VALUE GED_SetIndexedSrcRepCtrl(ged_ins_t* ins, const GED_REP_CTRL value, const uint8_t index)
{
    if (0 == index) return GED_SetSrc0RepCtrl(ins, value);
    if (1 == index) return GED_SetSrc1RepCtrl(ins, value);
    if (2 == index) return GED_SetSrc2RepCtrl(ins, value);
    return GED_RETURN_VALUE_INVALID_OPERAND;
}
GED_SRC_MOD GED_GetIndexedSrcSrcMod(ged_ins_t* ins, GED_RETURN_VALUE* result, const uint8_t index)
{
    if (0 == index) return GED_GetSrc0SrcMod(ins, result);
    if (1 == index) return GED_GetSrc1SrcMod(ins, result);
    if (2 == index) return GED_GetSrc2SrcMod(ins, result);
    if (NULL != result) *result = GED_RETURN_VALUE_INVALID_OPERAND;
    return GED_SRC_MOD_INVALID;
}
GED_RETURN_VALUE GED_SetIndexedSrcSrcMod(ged_ins_t* ins, const GED_SRC_MOD value, const uint8_t index)
{
    if (0 == index) return GED_SetSrc0SrcMod(ins, value);
    if (1 == index) return GED_SetSrc1SrcMod(ins, value);
    if (2 == index) return GED_SetSrc2SrcMod(ins, value);
    return GED_RETURN_VALUE_INVALID_OPERAND;
}
uint32_t GED_GetIndexedSrcSubRegNum(ged_ins_t* ins, GED_RETURN_VALUE* result, const uint8_t index)
{
    if (0 == index) return GED_GetSrc0SubRegNum(ins, result);
    if (1 == index) return GED_GetSrc1SubRegNum(ins, result);
    if (2 == index) return GED_GetSrc2SubRegNum(ins, result);
    if (3 == index) return GED_GetSrc3SubRegNum(ins, result);
    if (4 == index) return GED_GetSrc4SubRegNum(ins, result);
    if (NULL != result) *result = GED_RETURN_VALUE_INVALID_OPERAND;
    return (uint32_t)-1;
}
GED_RETURN_VALUE GED_SetIndexedSrcSubRegNum(ged_ins_t* ins, const uint32_t value, const uint8_t index)
{
    if (0 == index) return GED_SetSrc0SubRegNum(ins, value);
    if (1 == index) return GED_SetSrc1SubRegNum(ins, value);
    if (2 == index) return GED_SetSrc2SubRegNum(ins, value);
    if (3 == index) return GED_SetSrc3SubRegNum(ins, value);
    if (4 == index) return GED_SetSrc4SubRegNum(ins, value);
    return GED_RETURN_VALUE_INVALID_OPERAND;
}
uint32_t GED_GetIndexedSrcSubRegNumByte(ged_ins_t* ins, GED_RETURN_VALUE* result, const uint8_t index)
{
    if (0 == index) return GED_GetSrc0SubRegNumByte(ins, result);
    if (NULL != result) *result = GED_RETURN_VALUE_INVALID_OPERAND;
    return (uint32_t)-1;
}
GED_RETURN_VALUE GED_SetIndexedSrcSubRegNumByte(ged_ins_t* ins, const uint32_t value, const uint8_t index)
{
    if (0 == index) return GED_SetSrc0SubRegNumByte(ins, value);
    return GED_RETURN_VALUE_INVALID_OPERAND;
}
uint32_t GED_GetIndexedSrcVertStride(ged_ins_t* ins, GED_RETURN_VALUE* result, const uint8_t index)
{
    if (0 == index) return GED_GetSrc0VertStride(ins, result);
    if (1 == index) return GED_GetSrc1VertStride(ins, result);
    if (2 == index) return GED_GetSrc2VertStride(ins, result);
    if (NULL != result) *result = GED_RETURN_VALUE_INVALID_OPERAND;
    return (uint32_t)-1;
}
GED_RETURN_VALUE GED_SetIndexedSrcVertStride(ged_ins_t* ins, const uint32_t value, const uint8_t index)
{
    if (0 == index) return GED_SetSrc0VertStride(ins, value);
    if (1 == index) return GED_SetSrc1VertStride(ins, value);
    if (2 == index) return GED_SetSrc2VertStride(ins, value);
    return GED_RETURN_VALUE_INVALID_OPERAND;
}
uint32_t GED_GetIndexedSrcWidth(ged_ins_t* ins, GED_RETURN_VALUE* result, const uint8_t index)
{
    if (0 == index) return GED_GetSrc0Width(ins, result);
    if (1 == index) return GED_GetSrc1Width(ins, result);
    if (NULL != result) *result = GED_RETURN_VALUE_INVALID_OPERAND;
    return (uint32_t)-1;
}
GED_RETURN_VALUE GED_SetIndexedSrcWidth(ged_ins_t* ins, const uint32_t value, const uint8_t index)
{
    if (0 == index) return GED_SetSrc0Width(ins, value);
    if (1 == index) return GED_SetSrc1Width(ins, value);
    return GED_RETURN_VALUE_INVALID_OPERAND;
}
GED_ARCH_REG GED_GetArchReg(const uint32_t regNum, const GED_MODEL modelId, GED_RETURN_VALUE* result)
{
    GED_RETURN_VALUE localResult = GED_RETURN_VALUE_INVALID_FIELD;
    if (NULL == result) result = &localResult;
    const uint32_t value = GEDInterpreter::InterpretPosition(regNum, GED_PSEUDO_FIELD_ArchReg, modelId, *result);
    return (GED_RETURN_VALUE_SUCCESS == *result) ? (GED_ARCH_REG)value : GED_ARCH_REG_INVALID;
}
GED_RETURN_VALUE GED_SetArchReg(uint32_t* regNum, const GED_MODEL modelId, const GED_ARCH_REG archReg)
{
    return GEDInterpreter::SetInterpretedPosition(*regNum, GED_PSEUDO_FIELD_ArchReg, modelId, archReg);
}
uint32_t GED_GetArchRegNum(const uint32_t regNum, const GED_MODEL modelId, GED_RETURN_VALUE* result)
{
    GED_RETURN_VALUE localResult = GED_RETURN_VALUE_INVALID_FIELD;
    if (NULL == result) result = &localResult;
    return GEDInterpreter::InterpretPosition(regNum, GED_PSEUDO_FIELD_ArchRegNum, modelId, *result);
}
GED_RETURN_VALUE GED_SetArchRegNum(uint32_t* regNum, const GED_MODEL modelId, const uint32_t archRegNum)
{
    return GEDInterpreter::SetInterpretedPosition(*regNum, GED_PSEUDO_FIELD_ArchRegNum, modelId, archRegNum);
}
GED_SWIZZLE GED_GetSwizzleX(const uint32_t chanSel, const GED_MODEL modelId, GED_RETURN_VALUE* result)
{
    GED_RETURN_VALUE localResult = GED_RETURN_VALUE_INVALID_FIELD;
    if (NULL == result) result = &localResult;
    const uint32_t value = GEDInterpreter::InterpretPosition(chanSel, GED_PSEUDO_FIELD_SwizzleX, modelId, *result);
    return (GED_RETURN_VALUE_SUCCESS == *result) ? (GED_SWIZZLE)value : GED_SWIZZLE_INVALID;
}
GED_RETURN_VALUE GED_SetSwizzleX(uint32_t* chanSel, const GED_MODEL modelId, const GED_SWIZZLE swizzle)
{
    return GEDInterpreter::SetInterpretedPosition(*chanSel, GED_PSEUDO_FIELD_SwizzleX, modelId, swizzle);
}
GED_SWIZZLE GED_GetSwizzleY(const uint32_t chanSel, const GED_MODEL modelId, GED_RETURN_VALUE* result)
{
    GED_RETURN_VALUE localResult = GED_RETURN_VALUE_INVALID_FIELD;
    if (NULL == result) result = &localResult;
    const uint32_t value = GEDInterpreter::InterpretPosition(chanSel, GED_PSEUDO_FIELD_SwizzleY, modelId, *result);
    return (GED_RETURN_VALUE_SUCCESS == *result) ? (GED_SWIZZLE)value : GED_SWIZZLE_INVALID;
}
GED_RETURN_VALUE GED_SetSwizzleY(uint32_t* chanSel, const GED_MODEL modelId, const GED_SWIZZLE swizzle)
{
    return GEDInterpreter::SetInterpretedPosition(*chanSel, GED_PSEUDO_FIELD_SwizzleY, modelId, swizzle);
}
GED_SWIZZLE GED_GetSwizzleZ(const uint32_t chanSel, const GED_MODEL modelId, GED_RETURN_VALUE* result)
{
    GED_RETURN_VALUE localResult = GED_RETURN_VALUE_INVALID_FIELD;
    if (NULL == result) result = &localResult;
    const uint32_t value = GEDInterpreter::InterpretPosition(chanSel, GED_PSEUDO_FIELD_SwizzleZ, modelId, *result);
    return (GED_RETURN_VALUE_SUCCESS == *result) ? (GED_SWIZZLE)value : GED_SWIZZLE_INVALID;
}
GED_RETURN_VALUE GED_SetSwizzleZ(uint32_t* chanSel, const GED_MODEL modelId, const GED_SWIZZLE swizzle)
{
    return GEDInterpreter::SetInterpretedPosition(*chanSel, GED_PSEUDO_FIELD_SwizzleZ, modelId, swizzle);
}
GED_SWIZZLE GED_GetSwizzleW(const uint32_t chanSel, const GED_MODEL modelId, GED_RETURN_VALUE* result)
{
    GED_RETURN_VALUE localResult = GED_RETURN_VALUE_INVALID_FIELD;
    if (NULL == result) result = &localResult;
    const uint32_t value = GEDInterpreter::InterpretPosition(chanSel, GED_PSEUDO_FIELD_SwizzleW, modelId, *result);
    return (GED_RETURN_VALUE_SUCCESS == *result) ? (GED_SWIZZLE)value : GED_SWIZZLE_INVALID;
}
GED_RETURN_VALUE GED_SetSwizzleW(uint32_t* chanSel, const GED_MODEL modelId, const GED_SWIZZLE swizzle)
{
    return GEDInterpreter::SetInterpretedPosition(*chanSel, GED_PSEUDO_FIELD_SwizzleW, modelId, swizzle);
}
uint32_t GED_GetMessageLength(const uint32_t msgDesc, const GED_MODEL modelId, GED_RETURN_VALUE* result)
{
    GED_RETURN_VALUE localResult = GED_RETURN_VALUE_INVALID_FIELD;
    if (NULL == result) result = &localResult;
    return GEDInterpreter::InterpretPosition(msgDesc, GED_PSEUDO_FIELD_MessageLength, modelId, *result);
}
GED_RETURN_VALUE GED_SetMessageLength(uint32_t* msgDesc, const GED_MODEL modelId, const uint32_t length)
{
    return GEDInterpreter::SetInterpretedPosition(*msgDesc, GED_PSEUDO_FIELD_MessageLength, modelId, length);
}
uint32_t GED_GetResponseLength(const uint32_t msgDesc, const GED_MODEL modelId, GED_RETURN_VALUE* result)
{
    GED_RETURN_VALUE localResult = GED_RETURN_VALUE_INVALID_FIELD;
    if (NULL == result) result = &localResult;
    return GEDInterpreter::InterpretPosition(msgDesc, GED_PSEUDO_FIELD_ResponseLength, modelId, *result);
}
GED_RETURN_VALUE GED_SetResponseLength(uint32_t* msgDesc, const GED_MODEL modelId, const uint32_t length)
{
    return GEDInterpreter::SetInterpretedPosition(*msgDesc, GED_PSEUDO_FIELD_ResponseLength, modelId, length);
}
GED_HEADER_PRESENT GED_GetHeaderPresent(const uint32_t msgDesc, const GED_MODEL modelId, GED_RETURN_VALUE* result)
{
    GED_RETURN_VALUE localResult = GED_RETURN_VALUE_INVALID_FIELD;
    if (NULL == result) result = &localResult;
    const uint32_t value = GEDInterpreter::InterpretPosition(msgDesc, GED_PSEUDO_FIELD_HeaderPresent, modelId, *result);
    return (GED_RETURN_VALUE_SUCCESS == *result) ? (GED_HEADER_PRESENT)value : GED_HEADER_PRESENT_INVALID;
}
GED_RETURN_VALUE GED_SetHeaderPresent(uint32_t* msgDesc, const GED_MODEL modelId, const GED_HEADER_PRESENT headerPresent)
{
    return GEDInterpreter::SetInterpretedPosition(*msgDesc, GED_PSEUDO_FIELD_HeaderPresent, modelId, headerPresent);
}
GED_MESSAGE_TYPE GED_GetMessageTypeDP_SAMPLER(const uint32_t msgDesc, const GED_MODEL modelId, GED_RETURN_VALUE* result)
{
    GED_RETURN_VALUE localResult = GED_RETURN_VALUE_INVALID_FIELD;
    if (NULL == result) result = &localResult;
    const uint32_t value = GEDInterpreter::InterpretPosition(msgDesc, GED_PSEUDO_FIELD_MessageTypeDP_SAMPLER, modelId, *result);
    return (GED_RETURN_VALUE_SUCCESS == *result) ? (GED_MESSAGE_TYPE)value : GED_MESSAGE_TYPE_INVALID;
}
GED_RETURN_VALUE GED_SetMessageTypeDP_SAMPLER(uint32_t* msgDesc, const GED_MODEL modelId, const GED_MESSAGE_TYPE messageType)
{
    return GEDInterpreter::SetInterpretedPosition(*msgDesc, GED_PSEUDO_FIELD_MessageTypeDP_SAMPLER, modelId, messageType);
}
GED_MESSAGE_TYPE GED_GetMessageTypeDP_RC(const uint32_t msgDesc, const GED_MODEL modelId, GED_RETURN_VALUE* result)
{
    GED_RETURN_VALUE localResult = GED_RETURN_VALUE_INVALID_FIELD;
    if (NULL == result) result = &localResult;
    const uint32_t value = GEDInterpreter::InterpretPosition(msgDesc, GED_PSEUDO_FIELD_MessageTypeDP_RC, modelId, *result);
    return (GED_RETURN_VALUE_SUCCESS == *result) ? (GED_MESSAGE_TYPE)value : GED_MESSAGE_TYPE_INVALID;
}
GED_RETURN_VALUE GED_SetMessageTypeDP_RC(uint32_t* msgDesc, const GED_MODEL modelId, const GED_MESSAGE_TYPE messageType)
{
    return GEDInterpreter::SetInterpretedPosition(*msgDesc, GED_PSEUDO_FIELD_MessageTypeDP_RC, modelId, messageType);
}
GED_MESSAGE_TYPE GED_GetMessageTypeDP_CC(const uint32_t msgDesc, const GED_MODEL modelId, GED_RETURN_VALUE* result)
{
    GED_RETURN_VALUE localResult = GED_RETURN_VALUE_INVALID_FIELD;
    if (NULL == result) result = &localResult;
    const uint32_t value = GEDInterpreter::InterpretPosition(msgDesc, GED_PSEUDO_FIELD_MessageTypeDP_CC, modelId, *result);
    return (GED_RETURN_VALUE_SUCCESS == *result) ? (GED_MESSAGE_TYPE)value : GED_MESSAGE_TYPE_INVALID;
}
GED_RETURN_VALUE GED_SetMessageTypeDP_CC(uint32_t* msgDesc, const GED_MODEL modelId, const GED_MESSAGE_TYPE messageType)
{
    return GEDInterpreter::SetInterpretedPosition(*msgDesc, GED_PSEUDO_FIELD_MessageTypeDP_CC, modelId, messageType);
}
GED_MESSAGE_TYPE GED_GetMessageTypeDP_DC0(const uint32_t msgDesc, const GED_MODEL modelId, GED_RETURN_VALUE* result)
{
    GED_RETURN_VALUE localResult = GED_RETURN_VALUE_INVALID_FIELD;
    if (NULL == result) result = &localResult;
    const uint32_t value = GEDInterpreter::InterpretPosition(msgDesc, GED_PSEUDO_FIELD_MessageTypeDP_DC0, modelId, *result);
    return (GED_RETURN_VALUE_SUCCESS == *result) ? (GED_MESSAGE_TYPE)value : GED_MESSAGE_TYPE_INVALID;
}
GED_RETURN_VALUE GED_SetMessageTypeDP_DC0(uint32_t* msgDesc, const GED_MODEL modelId, const GED_MESSAGE_TYPE messageType)
{
    return GEDInterpreter::SetInterpretedPosition(*msgDesc, GED_PSEUDO_FIELD_MessageTypeDP_DC0, modelId, messageType);
}
GED_SLOT_GROUP GED_GetTypedSurfaceSlotGroup(const uint32_t msgDesc, const GED_MODEL modelId, GED_RETURN_VALUE* result)
{
    GED_RETURN_VALUE localResult = GED_RETURN_VALUE_INVALID_FIELD;
    if (NULL == result) result = &localResult;
    const uint32_t value = GEDInterpreter::InterpretPosition(msgDesc, GED_PSEUDO_FIELD_TypedSurfaceSlotGroup, modelId, *result);
    return (GED_RETURN_VALUE_SUCCESS == *result) ? (GED_SLOT_GROUP)value : GED_SLOT_GROUP_INVALID;
}
GED_RETURN_VALUE GED_SetTypedSurfaceSlotGroup(uint32_t* msgDesc, const GED_MODEL modelId, const GED_SLOT_GROUP slotGroup)
{
    return GEDInterpreter::SetInterpretedPosition(*msgDesc, GED_PSEUDO_FIELD_TypedSurfaceSlotGroup, modelId, slotGroup);
}
GED_SLOT_GROUP GED_GetTypedAtomicSlotGroup(const uint32_t msgDesc, const GED_MODEL modelId, GED_RETURN_VALUE* result)
{
    GED_RETURN_VALUE localResult = GED_RETURN_VALUE_INVALID_FIELD;
    if (NULL == result) result = &localResult;
    const uint32_t value = GEDInterpreter::InterpretPosition(msgDesc, GED_PSEUDO_FIELD_TypedAtomicSlotGroup, modelId, *result);
    return (GED_RETURN_VALUE_SUCCESS == *result) ? (GED_SLOT_GROUP)value : GED_SLOT_GROUP_INVALID;
}
GED_RETURN_VALUE GED_SetTypedAtomicSlotGroup(uint32_t* msgDesc, const GED_MODEL modelId, const GED_SLOT_GROUP slotGroup)
{
    return GEDInterpreter::SetInterpretedPosition(*msgDesc, GED_PSEUDO_FIELD_TypedAtomicSlotGroup, modelId, slotGroup);
}
GED_SIMDMODE GED_GetUntypedSurfaceSIMDMode(const uint32_t msgDesc, const GED_MODEL modelId, GED_RETURN_VALUE* result)
{
    GED_RETURN_VALUE localResult = GED_RETURN_VALUE_INVALID_FIELD;
    if (NULL == result) result = &localResult;
    const uint32_t value = GEDInterpreter::InterpretPosition(msgDesc, GED_PSEUDO_FIELD_UntypedSurfaceSIMDMode, modelId, *result);
    return (GED_RETURN_VALUE_SUCCESS == *result) ? (GED_SIMDMODE)value : GED_SIMDMODE_INVALID;
}
GED_RETURN_VALUE GED_SetUntypedSurfaceSIMDMode(uint32_t* msgDesc, const GED_MODEL modelId, const GED_SIMDMODE simdMode)
{
    return GEDInterpreter::SetInterpretedPosition(*msgDesc, GED_PSEUDO_FIELD_UntypedSurfaceSIMDMode, modelId, simdMode);
}
GED_SIMDMODE GED_GetUntypedAtomicSIMDMode(const uint32_t msgDesc, const GED_MODEL modelId, GED_RETURN_VALUE* result)
{
    GED_RETURN_VALUE localResult = GED_RETURN_VALUE_INVALID_FIELD;
    if (NULL == result) result = &localResult;
    const uint32_t value = GEDInterpreter::InterpretPosition(msgDesc, GED_PSEUDO_FIELD_UntypedAtomicSIMDMode, modelId, *result);
    return (GED_RETURN_VALUE_SUCCESS == *result) ? (GED_SIMDMODE)value : GED_SIMDMODE_INVALID;
}
GED_RETURN_VALUE GED_SetUntypedAtomicSIMDMode(uint32_t* msgDesc, const GED_MODEL modelId, const GED_SIMDMODE simdMode)
{
    return GEDInterpreter::SetInterpretedPosition(*msgDesc, GED_PSEUDO_FIELD_UntypedAtomicSIMDMode, modelId, simdMode);
}
uint32_t GED_GetInvalidateAfterRead(const uint32_t msgDesc, const GED_MODEL modelId, GED_RETURN_VALUE* result)
{
    GED_RETURN_VALUE localResult = GED_RETURN_VALUE_INVALID_FIELD;
    if (NULL == result) result = &localResult;
    return GEDInterpreter::InterpretPosition(msgDesc, GED_PSEUDO_FIELD_InvalidateAfterRead, modelId, *result);
}
GED_RETURN_VALUE GED_SetInvalidateAfterRead(uint32_t* msgDesc, const GED_MODEL modelId, const uint32_t invalidateAfterReadEnable)
{
    return GEDInterpreter::SetInterpretedPosition(*msgDesc, GED_PSEUDO_FIELD_InvalidateAfterRead, modelId, invalidateAfterReadEnable);
}
GED_BLOCK_SIZE GED_GetBlockSize(const uint32_t msgDesc, const GED_MODEL modelId, GED_RETURN_VALUE* result)
{
    GED_RETURN_VALUE localResult = GED_RETURN_VALUE_INVALID_FIELD;
    if (NULL == result) result = &localResult;
    const uint32_t value = GEDInterpreter::InterpretPosition(msgDesc, GED_PSEUDO_FIELD_BlockSize, modelId, *result);
    return (GED_RETURN_VALUE_SUCCESS == *result) ? (GED_BLOCK_SIZE)value : GED_BLOCK_SIZE_INVALID;
}
GED_RETURN_VALUE GED_SetBlockSize(uint32_t* msgDesc, const GED_MODEL modelId, const GED_BLOCK_SIZE blockSize)
{
    return GEDInterpreter::SetInterpretedPosition(*msgDesc, GED_PSEUDO_FIELD_BlockSize, modelId, blockSize);
}
GED_CHANNEL_MASK GED_GetRedChannel(const uint32_t msgDesc, const GED_MODEL modelId, GED_RETURN_VALUE* result)
{
    GED_RETURN_VALUE localResult = GED_RETURN_VALUE_INVALID_FIELD;
    if (NULL == result) result = &localResult;
    const uint32_t value = GEDInterpreter::InterpretPosition(msgDesc, GED_PSEUDO_FIELD_RedChannel, modelId, *result);
    return (GED_RETURN_VALUE_SUCCESS == *result) ? (GED_CHANNEL_MASK)value : GED_CHANNEL_MASK_INVALID;
}
GED_RETURN_VALUE GED_SetRedChannel(uint32_t* msgDesc, const GED_MODEL modelId, const GED_CHANNEL_MASK channel)
{
    return GEDInterpreter::SetInterpretedPosition(*msgDesc, GED_PSEUDO_FIELD_RedChannel, modelId, channel);
}
GED_CHANNEL_MASK GED_GetGreenChannel(const uint32_t msgDesc, const GED_MODEL modelId, GED_RETURN_VALUE* result)
{
    GED_RETURN_VALUE localResult = GED_RETURN_VALUE_INVALID_FIELD;
    if (NULL == result) result = &localResult;
    const uint32_t value = GEDInterpreter::InterpretPosition(msgDesc, GED_PSEUDO_FIELD_GreenChannel, modelId, *result);
    return (GED_RETURN_VALUE_SUCCESS == *result) ? (GED_CHANNEL_MASK)value : GED_CHANNEL_MASK_INVALID;
}
GED_RETURN_VALUE GED_SetGreenChannel(uint32_t* msgDesc, const GED_MODEL modelId, const GED_CHANNEL_MASK channel)
{
    return GEDInterpreter::SetInterpretedPosition(*msgDesc, GED_PSEUDO_FIELD_GreenChannel, modelId, channel);
}
GED_CHANNEL_MASK GED_GetBlueChannel(const uint32_t msgDesc, const GED_MODEL modelId, GED_RETURN_VALUE* result)
{
    GED_RETURN_VALUE localResult = GED_RETURN_VALUE_INVALID_FIELD;
    if (NULL == result) result = &localResult;
    const uint32_t value = GEDInterpreter::InterpretPosition(msgDesc, GED_PSEUDO_FIELD_BlueChannel, modelId, *result);
    return (GED_RETURN_VALUE_SUCCESS == *result) ? (GED_CHANNEL_MASK)value : GED_CHANNEL_MASK_INVALID;
}
GED_RETURN_VALUE GED_SetBlueChannel(uint32_t* msgDesc, const GED_MODEL modelId, const GED_CHANNEL_MASK channel)
{
    return GEDInterpreter::SetInterpretedPosition(*msgDesc, GED_PSEUDO_FIELD_BlueChannel, modelId, channel);
}
GED_CHANNEL_MASK GED_GetAlphaChannel(const uint32_t msgDesc, const GED_MODEL modelId, GED_RETURN_VALUE* result)
{
    GED_RETURN_VALUE localResult = GED_RETURN_VALUE_INVALID_FIELD;
    if (NULL == result) result = &localResult;
    const uint32_t value = GEDInterpreter::InterpretPosition(msgDesc, GED_PSEUDO_FIELD_AlphaChannel, modelId, *result);
    return (GED_RETURN_VALUE_SUCCESS == *result) ? (GED_CHANNEL_MASK)value : GED_CHANNEL_MASK_INVALID;
}
GED_RETURN_VALUE GED_SetAlphaChannel(uint32_t* msgDesc, const GED_MODEL modelId, const GED_CHANNEL_MASK channel)
{
    return GEDInterpreter::SetInterpretedPosition(*msgDesc, GED_PSEUDO_FIELD_AlphaChannel, modelId, channel);
}
GED_RETURN_DATA_CONTROL GED_GetReturnDataControl(const uint32_t msgDesc, const GED_MODEL modelId, GED_RETURN_VALUE* result)
{
    GED_RETURN_VALUE localResult = GED_RETURN_VALUE_INVALID_FIELD;
    if (NULL == result) result = &localResult;
    const uint32_t value = GEDInterpreter::InterpretPosition(msgDesc, GED_PSEUDO_FIELD_ReturnDataControl, modelId, *result);
    return (GED_RETURN_VALUE_SUCCESS == *result) ? (GED_RETURN_DATA_CONTROL)value : GED_RETURN_DATA_CONTROL_INVALID;
}
GED_RETURN_VALUE GED_SetReturnDataControl(uint32_t* msgDesc, const GED_MODEL modelId, const GED_RETURN_DATA_CONTROL returnDataControl)
{
    return GEDInterpreter::SetInterpretedPosition(*msgDesc, GED_PSEUDO_FIELD_ReturnDataControl, modelId, returnDataControl);
}
GED_ATOMIC_OPERATION_TYPE GED_GetAtomicOperationType(const uint32_t msgDesc, const GED_MODEL modelId, GED_RETURN_VALUE* result)
{
    GED_RETURN_VALUE localResult = GED_RETURN_VALUE_INVALID_FIELD;
    if (NULL == result) result = &localResult;
    const uint32_t value = GEDInterpreter::InterpretPosition(msgDesc, GED_PSEUDO_FIELD_AtomicOperationType, modelId, *result);
    return (GED_RETURN_VALUE_SUCCESS == *result) ? (GED_ATOMIC_OPERATION_TYPE)value : GED_ATOMIC_OPERATION_TYPE_INVALID;
}
GED_RETURN_VALUE GED_SetAtomicOperationType(uint32_t* msgDesc, const GED_MODEL modelId, const GED_ATOMIC_OPERATION_TYPE operationType)
{
    return GEDInterpreter::SetInterpretedPosition(*msgDesc, GED_PSEUDO_FIELD_AtomicOperationType, modelId, operationType);
}
GED_ATOMIC_OPERATION_TYPE GED_GetAtomicCounterOperationType(const uint32_t msgDesc, const GED_MODEL modelId, GED_RETURN_VALUE* result)
{
    GED_RETURN_VALUE localResult = GED_RETURN_VALUE_INVALID_FIELD;
    if (NULL == result) result = &localResult;
    const uint32_t value = GEDInterpreter::InterpretPosition(msgDesc, GED_PSEUDO_FIELD_AtomicCounterOperationType, modelId, *result);
    return (GED_RETURN_VALUE_SUCCESS == *result) ? (GED_ATOMIC_OPERATION_TYPE)value : GED_ATOMIC_OPERATION_TYPE_INVALID;
}
GED_RETURN_VALUE GED_SetAtomicCounterOperationType(uint32_t* msgDesc, const GED_MODEL modelId, const GED_ATOMIC_OPERATION_TYPE
                                                   operationType)
{
    return GEDInterpreter::SetInterpretedPosition(*msgDesc, GED_PSEUDO_FIELD_AtomicCounterOperationType, modelId, operationType);
}
GED_SUB_FUNC_ID GED_GetSubFuncID(const uint32_t msgDesc, const GED_MODEL modelId, GED_RETURN_VALUE* result)
{
    GED_RETURN_VALUE localResult = GED_RETURN_VALUE_INVALID_FIELD;
    if (NULL == result) result = &localResult;
    const uint32_t value = GEDInterpreter::InterpretPosition(msgDesc, GED_PSEUDO_FIELD_SubFuncID, modelId, *result);
    return (GED_RETURN_VALUE_SUCCESS == *result) ? (GED_SUB_FUNC_ID)value : GED_SUB_FUNC_ID_INVALID;
}
GED_RETURN_VALUE GED_SetSubFuncID(uint32_t* msgDesc, const GED_MODEL modelId, const GED_SUB_FUNC_ID subFuncID)
{
    return GEDInterpreter::SetInterpretedPosition(*msgDesc, GED_PSEUDO_FIELD_SubFuncID, modelId, subFuncID);
}
uint32_t GED_GetBindingTableIndex(const uint32_t msgDesc, const GED_MODEL modelId, GED_RETURN_VALUE* result)
{
    GED_RETURN_VALUE localResult = GED_RETURN_VALUE_INVALID_FIELD;
    if (NULL == result) result = &localResult;
    return GEDInterpreter::InterpretPosition(msgDesc, GED_PSEUDO_FIELD_BindingTableIndex, modelId, *result);
}
GED_RETURN_VALUE GED_SetBindingTableIndex(uint32_t* msgDesc, const GED_MODEL modelId, const uint32_t bti)
{
    return GEDInterpreter::SetInterpretedPosition(*msgDesc, GED_PSEUDO_FIELD_BindingTableIndex, modelId, bti);
}
uint32_t GED_GetFuncControl(const uint32_t msgDesc, const GED_MODEL modelId, GED_RETURN_VALUE* result)
{
    GED_RETURN_VALUE localResult = GED_RETURN_VALUE_INVALID_FIELD;
    if (NULL == result) result = &localResult;
    return GEDInterpreter::InterpretPosition(msgDesc, GED_PSEUDO_FIELD_FuncControl, modelId, *result);
}
GED_RETURN_VALUE GED_SetFuncControl(uint32_t* msgDesc, const GED_MODEL modelId, const uint32_t fc)
{
    return GEDInterpreter::SetInterpretedPosition(*msgDesc, GED_PSEUDO_FIELD_FuncControl, modelId, fc);
}
GED_MESSAGE_TYPE GED_GetMessageTypeDP_DC1(const uint32_t msgDesc, const GED_MODEL modelId, GED_RETURN_VALUE* result)
{
    GED_RETURN_VALUE localResult = GED_RETURN_VALUE_INVALID_FIELD;
    if (NULL == result) result = &localResult;
    const uint32_t value = GEDInterpreter::InterpretPosition(msgDesc, GED_PSEUDO_FIELD_MessageTypeDP_DC1, modelId, *result);
    return (GED_RETURN_VALUE_SUCCESS == *result) ? (GED_MESSAGE_TYPE)value : GED_MESSAGE_TYPE_INVALID;
}
GED_RETURN_VALUE GED_SetMessageTypeDP_DC1(uint32_t* msgDesc, const GED_MODEL modelId, const GED_MESSAGE_TYPE messageType)
{
    return GEDInterpreter::SetInterpretedPosition(*msgDesc, GED_PSEUDO_FIELD_MessageTypeDP_DC1, modelId, messageType);
}
uint32_t GED_GetMessageTypeDP0Category(const uint32_t msgDesc, const GED_MODEL modelId, GED_RETURN_VALUE* result)
{
    GED_RETURN_VALUE localResult = GED_RETURN_VALUE_INVALID_FIELD;
    if (NULL == result) result = &localResult;
    return GEDInterpreter::InterpretPosition(msgDesc, GED_PSEUDO_FIELD_MessageTypeDP0Category, modelId, *result);
}
GED_RETURN_VALUE GED_SetMessageTypeDP0Category(uint32_t* msgDesc, const GED_MODEL modelId, const uint32_t category)
{
    return GEDInterpreter::SetInterpretedPosition(*msgDesc, GED_PSEUDO_FIELD_MessageTypeDP0Category, modelId, category);
}
GED_MESSAGE_TYPE GED_GetMessageTypeDP_DC0Legacy(const uint32_t msgDesc, const GED_MODEL modelId, GED_RETURN_VALUE* result)
{
    GED_RETURN_VALUE localResult = GED_RETURN_VALUE_INVALID_FIELD;
    if (NULL == result) result = &localResult;
    const uint32_t value = GEDInterpreter::InterpretPosition(msgDesc, GED_PSEUDO_FIELD_MessageTypeDP_DC0Legacy, modelId, *result);
    return (GED_RETURN_VALUE_SUCCESS == *result) ? (GED_MESSAGE_TYPE)value : GED_MESSAGE_TYPE_INVALID;
}
GED_RETURN_VALUE GED_SetMessageTypeDP_DC0Legacy(uint32_t* msgDesc, const GED_MODEL modelId, const GED_MESSAGE_TYPE messageType)
{
    return GEDInterpreter::SetInterpretedPosition(*msgDesc, GED_PSEUDO_FIELD_MessageTypeDP_DC0Legacy, modelId, messageType);
}
GED_MESSAGE_TYPE GED_GetMessageTypeDP_DC0ScratchBlock(const uint32_t msgDesc, const GED_MODEL modelId, GED_RETURN_VALUE* result)
{
    GED_RETURN_VALUE localResult = GED_RETURN_VALUE_INVALID_FIELD;
    if (NULL == result) result = &localResult;
    const uint32_t value = GEDInterpreter::InterpretPosition(msgDesc, GED_PSEUDO_FIELD_MessageTypeDP_DC0ScratchBlock, modelId, *result);
    return (GED_RETURN_VALUE_SUCCESS == *result) ? (GED_MESSAGE_TYPE)value : GED_MESSAGE_TYPE_INVALID;
}
GED_RETURN_VALUE GED_SetMessageTypeDP_DC0ScratchBlock(uint32_t* msgDesc, const GED_MODEL modelId, const GED_MESSAGE_TYPE messageType)
{
    return GEDInterpreter::SetInterpretedPosition(*msgDesc, GED_PSEUDO_FIELD_MessageTypeDP_DC0ScratchBlock, modelId, messageType);
}
GED_MESSAGE_TYPE GED_GetMessageTypeDP_DC2(const uint32_t msgDesc, const GED_MODEL modelId, GED_RETURN_VALUE* result)
{
    GED_RETURN_VALUE localResult = GED_RETURN_VALUE_INVALID_FIELD;
    if (NULL == result) result = &localResult;
    const uint32_t value = GEDInterpreter::InterpretPosition(msgDesc, GED_PSEUDO_FIELD_MessageTypeDP_DC2, modelId, *result);
    return (GED_RETURN_VALUE_SUCCESS == *result) ? (GED_MESSAGE_TYPE)value : GED_MESSAGE_TYPE_INVALID;
}
GED_RETURN_VALUE GED_SetMessageTypeDP_DC2(uint32_t* msgDesc, const GED_MODEL modelId, const GED_MESSAGE_TYPE messageType)
{
    return GEDInterpreter::SetInterpretedPosition(*msgDesc, GED_PSEUDO_FIELD_MessageTypeDP_DC2, modelId, messageType);
}
GED_MESSAGE_TYPE GED_GetMessageTypeDP_DCRO(const uint32_t msgDesc, const GED_MODEL modelId, GED_RETURN_VALUE* result)
{
    GED_RETURN_VALUE localResult = GED_RETURN_VALUE_INVALID_FIELD;
    if (NULL == result) result = &localResult;
    const uint32_t value = GEDInterpreter::InterpretPosition(msgDesc, GED_PSEUDO_FIELD_MessageTypeDP_DCRO, modelId, *result);
    return (GED_RETURN_VALUE_SUCCESS == *result) ? (GED_MESSAGE_TYPE)value : GED_MESSAGE_TYPE_INVALID;
}
GED_RETURN_VALUE GED_SetMessageTypeDP_DCRO(uint32_t* msgDesc, const GED_MODEL modelId, const GED_MESSAGE_TYPE messageType)
{
    return GEDInterpreter::SetInterpretedPosition(*msgDesc, GED_PSEUDO_FIELD_MessageTypeDP_DCRO, modelId, messageType);
}
uint32_t GED_GetExMessageLength(const uint32_t exMsgDesc, const GED_MODEL modelId, GED_RETURN_VALUE* result)
{
    GED_RETURN_VALUE localResult = GED_RETURN_VALUE_INVALID_FIELD;
    if (NULL == result) result = &localResult;
    return GEDInterpreter::InterpretPosition(exMsgDesc, GED_PSEUDO_FIELD_ExMessageLength, modelId, *result);
}
GED_RETURN_VALUE GED_SetExMessageLength(uint32_t* exMsgDesc, const GED_MODEL modelId, const uint32_t length)
{
    return GEDInterpreter::SetInterpretedPosition(*exMsgDesc, GED_PSEUDO_FIELD_ExMessageLength, modelId, length);
}
GED_DP_OPCODE GED_GetDPOpcode(const uint32_t msgDesc, const GED_MODEL modelId, GED_RETURN_VALUE* result)
{
    GED_RETURN_VALUE localResult = GED_RETURN_VALUE_INVALID_FIELD;
    if (NULL == result) result = &localResult;
    const uint32_t value = GEDInterpreter::InterpretPosition(msgDesc, GED_PSEUDO_FIELD_DPOpcode, modelId, *result);
    return (GED_RETURN_VALUE_SUCCESS == *result) ? (GED_DP_OPCODE)value : GED_DP_OPCODE_INVALID;
}
GED_RETURN_VALUE GED_SetDPOpcode(uint32_t* msgDesc, const GED_MODEL modelId, const GED_DP_OPCODE opcode)
{
    return GEDInterpreter::SetInterpretedPosition(*msgDesc, GED_PSEUDO_FIELD_DPOpcode, modelId, opcode);
}
GED_DP_ADDR_SURFACE_TYPE GED_GetDPAddrSurfaceType(const uint32_t msgDesc, const GED_MODEL modelId, GED_RETURN_VALUE* result)
{
    GED_RETURN_VALUE localResult = GED_RETURN_VALUE_INVALID_FIELD;
    if (NULL == result) result = &localResult;
    const uint32_t value = GEDInterpreter::InterpretPosition(msgDesc, GED_PSEUDO_FIELD_DPAddrSurfaceType, modelId, *result);
    return (GED_RETURN_VALUE_SUCCESS == *result) ? (GED_DP_ADDR_SURFACE_TYPE)value : GED_DP_ADDR_SURFACE_TYPE_INVALID;
}
GED_RETURN_VALUE GED_SetDPAddrSurfaceType(uint32_t* msgDesc, const GED_MODEL modelId, const GED_DP_ADDR_SURFACE_TYPE AddrType)
{
    return GEDInterpreter::SetInterpretedPosition(*msgDesc, GED_PSEUDO_FIELD_DPAddrSurfaceType, modelId, AddrType);
}
GED_DP_VECT_SIZE GED_GetDPVectSize(const uint32_t msgDesc, const GED_MODEL modelId, GED_RETURN_VALUE* result)
{
    GED_RETURN_VALUE localResult = GED_RETURN_VALUE_INVALID_FIELD;
    if (NULL == result) result = &localResult;
    const uint32_t value = GEDInterpreter::InterpretPosition(msgDesc, GED_PSEUDO_FIELD_DPVectSize, modelId, *result);
    return (GED_RETURN_VALUE_SUCCESS == *result) ? (GED_DP_VECT_SIZE)value : GED_DP_VECT_SIZE_INVALID;
}
GED_RETURN_VALUE GED_SetDPVectSize(uint32_t* msgDesc, const GED_MODEL modelId, const GED_DP_VECT_SIZE VectSize)
{
    return GEDInterpreter::SetInterpretedPosition(*msgDesc, GED_PSEUDO_FIELD_DPVectSize, modelId, VectSize);
}
GED_DP_FLUSH_TYPE GED_GetDPFlushType(const uint32_t msgDesc, const GED_MODEL modelId, GED_RETURN_VALUE* result)
{
    GED_RETURN_VALUE localResult = GED_RETURN_VALUE_INVALID_FIELD;
    if (NULL == result) result = &localResult;
    const uint32_t value = GEDInterpreter::InterpretPosition(msgDesc, GED_PSEUDO_FIELD_DPFlushType, modelId, *result);
    return (GED_RETURN_VALUE_SUCCESS == *result) ? (GED_DP_FLUSH_TYPE)value : GED_DP_FLUSH_TYPE_INVALID;
}
GED_RETURN_VALUE GED_SetDPFlushType(uint32_t* msgDesc, const GED_MODEL modelId, const GED_DP_FLUSH_TYPE FlushType)
{
    return GEDInterpreter::SetInterpretedPosition(*msgDesc, GED_PSEUDO_FIELD_DPFlushType, modelId, FlushType);
}
GED_DP_TRANSPOSE GED_GetDPTranspose(const uint32_t msgDesc, const GED_MODEL modelId, GED_RETURN_VALUE* result)
{
    GED_RETURN_VALUE localResult = GED_RETURN_VALUE_INVALID_FIELD;
    if (NULL == result) result = &localResult;
    const uint32_t value = GEDInterpreter::InterpretPosition(msgDesc, GED_PSEUDO_FIELD_DPTranspose, modelId, *result);
    return (GED_RETURN_VALUE_SUCCESS == *result) ? (GED_DP_TRANSPOSE)value : GED_DP_TRANSPOSE_INVALID;
}
GED_RETURN_VALUE GED_SetDPTranspose(uint32_t* msgDesc, const GED_MODEL modelId, const GED_DP_TRANSPOSE Transpose)
{
    return GEDInterpreter::SetInterpretedPosition(*msgDesc, GED_PSEUDO_FIELD_DPTranspose, modelId, Transpose);
}
uint32_t GED_GetDPFlushRange(const uint32_t msgDesc, const GED_MODEL modelId, GED_RETURN_VALUE* result)
{
    GED_RETURN_VALUE localResult = GED_RETURN_VALUE_INVALID_FIELD;
    if (NULL == result) result = &localResult;
    return GEDInterpreter::InterpretPosition(msgDesc, GED_PSEUDO_FIELD_DPFlushRange, modelId, *result);
}
GED_RETURN_VALUE GED_SetDPFlushRange(uint32_t* msgDesc, const GED_MODEL modelId, const uint32_t range)
{
    return GEDInterpreter::SetInterpretedPosition(*msgDesc, GED_PSEUDO_FIELD_DPFlushRange, modelId, range);
}
GED_DP_DATA_SIZE GED_GetDPDataSize(const uint32_t msgDesc, const GED_MODEL modelId, GED_RETURN_VALUE* result)
{
    GED_RETURN_VALUE localResult = GED_RETURN_VALUE_INVALID_FIELD;
    if (NULL == result) result = &localResult;
    const uint32_t value = GEDInterpreter::InterpretPosition(msgDesc, GED_PSEUDO_FIELD_DPDataSize, modelId, *result);
    return (GED_RETURN_VALUE_SUCCESS == *result) ? (GED_DP_DATA_SIZE)value : GED_DP_DATA_SIZE_INVALID;
}
GED_RETURN_VALUE GED_SetDPDataSize(uint32_t* msgDesc, const GED_MODEL modelId, const GED_DP_DATA_SIZE DataSize)
{
    return GEDInterpreter::SetInterpretedPosition(*msgDesc, GED_PSEUDO_FIELD_DPDataSize, modelId, DataSize);
}
GED_DP_FENCE_SCOPE GED_GetDPFenceScope(const uint32_t msgDesc, const GED_MODEL modelId, GED_RETURN_VALUE* result)
{
    GED_RETURN_VALUE localResult = GED_RETURN_VALUE_INVALID_FIELD;
    if (NULL == result) result = &localResult;
    const uint32_t value = GEDInterpreter::InterpretPosition(msgDesc, GED_PSEUDO_FIELD_DPFenceScope, modelId, *result);
    return (GED_RETURN_VALUE_SUCCESS == *result) ? (GED_DP_FENCE_SCOPE)value : GED_DP_FENCE_SCOPE_INVALID;
}
GED_RETURN_VALUE GED_SetDPFenceScope(uint32_t* msgDesc, const GED_MODEL modelId, const GED_DP_FENCE_SCOPE FenceScope)
{
    return GEDInterpreter::SetInterpretedPosition(*msgDesc, GED_PSEUDO_FIELD_DPFenceScope, modelId, FenceScope);
}
GED_DP_ADDR_SIZE GED_GetDPAddrSize(const uint32_t msgDesc, const GED_MODEL modelId, GED_RETURN_VALUE* result)
{
    GED_RETURN_VALUE localResult = GED_RETURN_VALUE_INVALID_FIELD;
    if (NULL == result) result = &localResult;
    const uint32_t value = GEDInterpreter::InterpretPosition(msgDesc, GED_PSEUDO_FIELD_DPAddrSize, modelId, *result);
    return (GED_RETURN_VALUE_SUCCESS == *result) ? (GED_DP_ADDR_SIZE)value : GED_DP_ADDR_SIZE_INVALID;
}
GED_RETURN_VALUE GED_SetDPAddrSize(uint32_t* msgDesc, const GED_MODEL modelId, const GED_DP_ADDR_SIZE AddrSize)
{
    return GEDInterpreter::SetInterpretedPosition(*msgDesc, GED_PSEUDO_FIELD_DPAddrSize, modelId, AddrSize);
}
GED_DPCACHE_STORE GED_GetDPCacheStore(const uint32_t msgDesc, const GED_MODEL modelId, GED_RETURN_VALUE* result)
{
    GED_RETURN_VALUE localResult = GED_RETURN_VALUE_INVALID_FIELD;
    if (NULL == result) result = &localResult;
    const uint32_t value = GEDInterpreter::InterpretPosition(msgDesc, GED_PSEUDO_FIELD_DPCacheStore, modelId, *result);
    return (GED_RETURN_VALUE_SUCCESS == *result) ? (GED_DPCACHE_STORE)value : GED_DPCACHE_STORE_INVALID;
}
GED_RETURN_VALUE GED_SetDPCacheStore(uint32_t* msgDesc, const GED_MODEL modelId, const GED_DPCACHE_STORE CacheStore)
{
    return GEDInterpreter::SetInterpretedPosition(*msgDesc, GED_PSEUDO_FIELD_DPCacheStore, modelId, CacheStore);
}
GED_DPCACHE_LOAD GED_GetDPCacheLoad(const uint32_t msgDesc, const GED_MODEL modelId, GED_RETURN_VALUE* result)
{
    GED_RETURN_VALUE localResult = GED_RETURN_VALUE_INVALID_FIELD;
    if (NULL == result) result = &localResult;
    const uint32_t value = GEDInterpreter::InterpretPosition(msgDesc, GED_PSEUDO_FIELD_DPCacheLoad, modelId, *result);
    return (GED_RETURN_VALUE_SUCCESS == *result) ? (GED_DPCACHE_LOAD)value : GED_DPCACHE_LOAD_INVALID;
}
GED_RETURN_VALUE GED_SetDPCacheLoad(uint32_t* msgDesc, const GED_MODEL modelId, const GED_DPCACHE_LOAD CacheLoad)
{
    return GEDInterpreter::SetInterpretedPosition(*msgDesc, GED_PSEUDO_FIELD_DPCacheLoad, modelId, CacheLoad);
}
GED_DPADDR_REG_SIZE GED_GetDPAddrRegSize(const uint32_t msgDesc, const GED_MODEL modelId, GED_RETURN_VALUE* result)
{
    GED_RETURN_VALUE localResult = GED_RETURN_VALUE_INVALID_FIELD;
    if (NULL == result) result = &localResult;
    const uint32_t value = GEDInterpreter::InterpretPosition(msgDesc, GED_PSEUDO_FIELD_DPAddrRegSize, modelId, *result);
    return (GED_RETURN_VALUE_SUCCESS == *result) ? (GED_DPADDR_REG_SIZE)value : GED_DPADDR_REG_SIZE_INVALID;
}
GED_RETURN_VALUE GED_SetDPAddrRegSize(uint32_t* msgDesc, const GED_MODEL modelId, const GED_DPADDR_REG_SIZE AddrRegSize)
{
    return GEDInterpreter::SetInterpretedPosition(*msgDesc, GED_PSEUDO_FIELD_DPAddrRegSize, modelId, AddrRegSize);
}
GED_DPONE_ADDR_REG GED_GetDPOneAddrReg(const uint32_t msgDesc, const GED_MODEL modelId, GED_RETURN_VALUE* result)
{
    GED_RETURN_VALUE localResult = GED_RETURN_VALUE_INVALID_FIELD;
    if (NULL == result) result = &localResult;
    const uint32_t value = GEDInterpreter::InterpretPosition(msgDesc, GED_PSEUDO_FIELD_DPOneAddrReg, modelId, *result);
    return (GED_RETURN_VALUE_SUCCESS == *result) ? (GED_DPONE_ADDR_REG)value : GED_DPONE_ADDR_REG_INVALID;
}
GED_RETURN_VALUE GED_SetDPOneAddrReg(uint32_t* msgDesc, const GED_MODEL modelId, const GED_DPONE_ADDR_REG OneAddrReg)
{
    return GEDInterpreter::SetInterpretedPosition(*msgDesc, GED_PSEUDO_FIELD_DPOneAddrReg, modelId, OneAddrReg);
}
GED_DPCMASK GED_GetDPCmask(const uint32_t msgDesc, const GED_MODEL modelId, GED_RETURN_VALUE* result)
{
    GED_RETURN_VALUE localResult = GED_RETURN_VALUE_INVALID_FIELD;
    if (NULL == result) result = &localResult;
    const uint32_t value = GEDInterpreter::InterpretPosition(msgDesc, GED_PSEUDO_FIELD_DPCmask, modelId, *result);
    return (GED_RETURN_VALUE_SUCCESS == *result) ? (GED_DPCMASK)value : GED_DPCMASK_INVALID;
}
GED_RETURN_VALUE GED_SetDPCmask(uint32_t* msgDesc, const GED_MODEL modelId, const GED_DPCMASK Cmask)
{
    return GEDInterpreter::SetInterpretedPosition(*msgDesc, GED_PSEUDO_FIELD_DPCmask, modelId, Cmask);
}
GED_MESSAGE_TYPE GED_GetMessageTypeDP_CONST(const uint32_t msgDesc, const GED_MODEL modelId, GED_RETURN_VALUE* result)
{
    GED_RETURN_VALUE localResult = GED_RETURN_VALUE_INVALID_FIELD;
    if (NULL == result) result = &localResult;
    const uint32_t value = GEDInterpreter::InterpretPosition(msgDesc, GED_PSEUDO_FIELD_MessageTypeDP_CONST, modelId, *result);
    return (GED_RETURN_VALUE_SUCCESS == *result) ? (GED_MESSAGE_TYPE)value : GED_MESSAGE_TYPE_INVALID;
}
GED_RETURN_VALUE GED_SetMessageTypeDP_CONST(uint32_t* msgDesc, const GED_MODEL modelId, const GED_MESSAGE_TYPE messageType)
{
    return GEDInterpreter::SetInterpretedPosition(*msgDesc, GED_PSEUDO_FIELD_MessageTypeDP_CONST, modelId, messageType);
}

#if GED_EXPERIMENTAL
GED_RETURN_VALUE GED_SetRawBits(ged_ins_t* ins, uint8_t low, uint8_t high, const uint64_t value)
{
    return reinterpret_cast<GEDIns*>(ins)->SetRawBits(low, high, value);
}
#endif // GED_EXPERIMENTAL

#ifndef GED_ACCESS_MODE_HIDDEN
const char* GED_GetAccessModeString(GED_ACCESS_MODE AccessModeValue)
{
    return AccessModeEnumeration[AccessModeValue];

}
#endif // GED_ACCESS_MODE_HIDDEN

#ifndef GED_ACC_WR_CTRL_HIDDEN
const char* GED_GetAccWrCtrlString(GED_ACC_WR_CTRL AccWrCtrlValue)
{
    return AccWrCtrlEnumeration[AccWrCtrlValue];

}
#endif // GED_ACC_WR_CTRL_HIDDEN

#ifndef GED_ADDR_MODE_HIDDEN
const char* GED_GetAddrModeString(GED_ADDR_MODE AddrModeValue)
{
    return AddrModeEnumeration[AddrModeValue];

}
#endif // GED_ADDR_MODE_HIDDEN

#ifndef GED_ARCH_REG_HIDDEN
const char* GED_GetArchRegString(GED_ARCH_REG ArchRegValue)
{
    return ArchRegEnumeration[ArchRegValue];

}
#endif // GED_ARCH_REG_HIDDEN

#ifndef GED_ATOMIC_OPERATION_TYPE_HIDDEN
const char* GED_GetAtomicOperationTypeString(GED_ATOMIC_OPERATION_TYPE AtomicOperationTypeValue)
{
    return AtomicOperationTypeEnumeration[AtomicOperationTypeValue];

}
#endif // GED_ATOMIC_OPERATION_TYPE_HIDDEN

#ifndef GED_BLOCK_SIZE_HIDDEN
const char* GED_GetBlockSizeString(GED_BLOCK_SIZE BlockSizeValue)
{
    return BlockSizeEnumeration[BlockSizeValue];

}
#endif // GED_BLOCK_SIZE_HIDDEN

#ifndef GED_BRANCH_CTRL_HIDDEN
const char* GED_GetBranchCtrlString(GED_BRANCH_CTRL BranchCtrlValue)
{
    return BranchCtrlEnumeration[BranchCtrlValue];

}
#endif // GED_BRANCH_CTRL_HIDDEN

#ifndef GED_CHANNEL_MASK_HIDDEN
const char* GED_GetChannelMaskString(GED_CHANNEL_MASK ChannelMaskValue)
{
    return ChannelMaskEnumeration[ChannelMaskValue];

}
#endif // GED_CHANNEL_MASK_HIDDEN

#ifndef GED_CHANNEL_MODE_HIDDEN
const char* GED_GetChannelModeString(GED_CHANNEL_MODE ChannelModeValue)
{
    return ChannelModeEnumeration[ChannelModeValue];

}
#endif // GED_CHANNEL_MODE_HIDDEN

#ifndef GED_CHANNEL_OFFSET_HIDDEN
const char* GED_GetChannelOffsetString(GED_CHANNEL_OFFSET ChannelOffsetValue)
{
    return ChannelOffsetEnumeration[ChannelOffsetValue];

}
#endif // GED_CHANNEL_OFFSET_HIDDEN

#ifndef GED_COND_MODIFIER_HIDDEN
const char* GED_GetCondModifierString(GED_COND_MODIFIER CondModifierValue)
{
    return CondModifierEnumeration[CondModifierValue];

}
#endif // GED_COND_MODIFIER_HIDDEN

#ifndef GED_CONV_DST_DATATYPE_HIDDEN
const char* GED_GetConvDstDatatypeString(GED_CONV_DST_DATATYPE ConvDstDatatypeValue)
{
    return ConvDstDatatypeEnumeration[ConvDstDatatypeValue];

}
#endif // GED_CONV_DST_DATATYPE_HIDDEN

#ifndef GED_CONV_SRC_DATATYPE_HIDDEN
const char* GED_GetConvSrcDatatypeString(GED_CONV_SRC_DATATYPE ConvSrcDatatypeValue)
{
    return ConvSrcDatatypeEnumeration[ConvSrcDatatypeValue];

}
#endif // GED_CONV_SRC_DATATYPE_HIDDEN

#ifndef GED_DATA_TYPE_HIDDEN
const char* GED_GetDataTypeString(GED_DATA_TYPE DataTypeValue)
{
    return DataTypeEnumeration[DataTypeValue];

}
#endif // GED_DATA_TYPE_HIDDEN

#ifndef GED_DEBUG_CTRL_HIDDEN
const char* GED_GetDebugCtrlString(GED_DEBUG_CTRL DebugCtrlValue)
{
    return DebugCtrlEnumeration[DebugCtrlValue];

}
#endif // GED_DEBUG_CTRL_HIDDEN

#ifndef GED_DEP_CTRL_HIDDEN
const char* GED_GetDepCtrlString(GED_DEP_CTRL DepCtrlValue)
{
    return DepCtrlEnumeration[DepCtrlValue];

}
#endif // GED_DEP_CTRL_HIDDEN

#ifndef GED_DNSCL_MODE_HIDDEN
const char* GED_GetDnsclModeString(GED_DNSCL_MODE DnsclModeValue)
{
    return DnsclModeEnumeration[DnsclModeValue];

}
#endif // GED_DNSCL_MODE_HIDDEN

#ifndef GED_DPADDR_REG_SIZE_HIDDEN
const char* GED_GetDPAddrRegSizeString(GED_DPADDR_REG_SIZE DPAddrRegSizeValue)
{
    return DPAddrRegSizeEnumeration[DPAddrRegSizeValue];

}
#endif // GED_DPADDR_REG_SIZE_HIDDEN

#ifndef GED_DP_ADDR_SIZE_HIDDEN
const char* GED_GetDpAddrSizeString(GED_DP_ADDR_SIZE DpAddrSizeValue)
{
    return DpAddrSizeEnumeration[DpAddrSizeValue];

}
#endif // GED_DP_ADDR_SIZE_HIDDEN

#ifndef GED_DP_ADDR_SURFACE_TYPE_HIDDEN
const char* GED_GetDpAddrSurfaceTypeString(GED_DP_ADDR_SURFACE_TYPE DpAddrSurfaceTypeValue)
{
    return DpAddrSurfaceTypeEnumeration[DpAddrSurfaceTypeValue];

}
#endif // GED_DP_ADDR_SURFACE_TYPE_HIDDEN

#ifndef GED_DPCACHE_LOAD_HIDDEN
const char* GED_GetDPCacheLoadString(GED_DPCACHE_LOAD DPCacheLoadValue)
{
    return DPCacheLoadEnumeration[DPCacheLoadValue];

}
#endif // GED_DPCACHE_LOAD_HIDDEN

#ifndef GED_DPCACHE_STORE_HIDDEN
const char* GED_GetDPCacheStoreString(GED_DPCACHE_STORE DPCacheStoreValue)
{
    return DPCacheStoreEnumeration[DPCacheStoreValue];

}
#endif // GED_DPCACHE_STORE_HIDDEN

#ifndef GED_DPCMASK_HIDDEN
const char* GED_GetDPCmaskString(GED_DPCMASK DPCmaskValue)
{
    return DPCmaskEnumeration[DPCmaskValue];

}
#endif // GED_DPCMASK_HIDDEN

#ifndef GED_DP_DATA_SIZE_HIDDEN
const char* GED_GetDpDataSizeString(GED_DP_DATA_SIZE DpDataSizeValue)
{
    return DpDataSizeEnumeration[DpDataSizeValue];

}
#endif // GED_DP_DATA_SIZE_HIDDEN

#ifndef GED_DP_FENCE_SCOPE_HIDDEN
const char* GED_GetDpFenceScopeString(GED_DP_FENCE_SCOPE DpFenceScopeValue)
{
    return DpFenceScopeEnumeration[DpFenceScopeValue];

}
#endif // GED_DP_FENCE_SCOPE_HIDDEN

#ifndef GED_DP_FLUSH_TYPE_HIDDEN
const char* GED_GetDpFlushTypeString(GED_DP_FLUSH_TYPE DpFlushTypeValue)
{
    return DpFlushTypeEnumeration[DpFlushTypeValue];

}
#endif // GED_DP_FLUSH_TYPE_HIDDEN

#ifndef GED_DPONE_ADDR_REG_HIDDEN
const char* GED_GetDPOneAddrRegString(GED_DPONE_ADDR_REG DPOneAddrRegValue)
{
    return DPOneAddrRegEnumeration[DPOneAddrRegValue];

}
#endif // GED_DPONE_ADDR_REG_HIDDEN

#ifndef GED_DP_OPCODE_HIDDEN
const char* GED_GetDpOpcodeString(GED_DP_OPCODE DpOpcodeValue)
{
    return DpOpcodeEnumeration[DpOpcodeValue];

}
#endif // GED_DP_OPCODE_HIDDEN

#ifndef GED_DP_TRANSPOSE_HIDDEN
const char* GED_GetDpTransposeString(GED_DP_TRANSPOSE DpTransposeValue)
{
    return DpTransposeEnumeration[DpTransposeValue];

}
#endif // GED_DP_TRANSPOSE_HIDDEN

#ifndef GED_DP_VECT_SIZE_HIDDEN
const char* GED_GetDpVectSizeString(GED_DP_VECT_SIZE DpVectSizeValue)
{
    return DpVectSizeEnumeration[DpVectSizeValue];

}
#endif // GED_DP_VECT_SIZE_HIDDEN

#ifndef GED_DST_CHAN_EN_HIDDEN
const char* GED_GetDstChanEnString(GED_DST_CHAN_EN DstChanEnValue)
{
    return DstChanEnEnumeration[DstChanEnValue];

}
#endif // GED_DST_CHAN_EN_HIDDEN

#ifndef GED_EOT_HIDDEN
const char* GED_GetEOTString(GED_EOT EOTValue)
{
    return EOTEnumeration[EOTValue];

}
#endif // GED_EOT_HIDDEN

#ifndef GED_EXEC_MASK_OFFSET_CTRL_HIDDEN
const char* GED_GetExecMaskOffsetCtrlString(GED_EXEC_MASK_OFFSET_CTRL ExecMaskOffsetCtrlValue)
{
    return ExecMaskOffsetCtrlEnumeration[ExecMaskOffsetCtrlValue];

}
#endif // GED_EXEC_MASK_OFFSET_CTRL_HIDDEN

#ifndef GED_EXECUTION_DATA_TYPE_HIDDEN
const char* GED_GetExecutionDataTypeString(GED_EXECUTION_DATA_TYPE ExecutionDataTypeValue)
{
    return ExecutionDataTypeEnumeration[ExecutionDataTypeValue];

}
#endif // GED_EXECUTION_DATA_TYPE_HIDDEN

#ifndef GED_FUSION_CTRL_HIDDEN
const char* GED_GetFusionCtrlString(GED_FUSION_CTRL FusionCtrlValue)
{
    return FusionCtrlEnumeration[FusionCtrlValue];

}
#endif // GED_FUSION_CTRL_HIDDEN

#ifndef GED_HEADER_PRESENT_HIDDEN
const char* GED_GetHeaderPresentString(GED_HEADER_PRESENT HeaderPresentValue)
{
    return HeaderPresentEnumeration[HeaderPresentValue];

}
#endif // GED_HEADER_PRESENT_HIDDEN

#ifndef GED_IS_IMM_HIDDEN
const char* GED_GetIsImmString(GED_IS_IMM IsImmValue)
{
    return IsImmEnumeration[IsImmValue];

}
#endif // GED_IS_IMM_HIDDEN

#ifndef GED_LFSR_FC_HIDDEN
const char* GED_GetLfsrFCString(GED_LFSR_FC LfsrFCValue)
{
    return LfsrFCEnumeration[LfsrFCValue];

}
#endif // GED_LFSR_FC_HIDDEN

#ifndef GED_MASK_CTRL_HIDDEN
const char* GED_GetMaskCtrlString(GED_MASK_CTRL MaskCtrlValue)
{
    return MaskCtrlEnumeration[MaskCtrlValue];

}
#endif // GED_MASK_CTRL_HIDDEN

#ifndef GED_MATH_FC_HIDDEN
const char* GED_GetMathFCString(GED_MATH_FC MathFCValue)
{
    return MathFCEnumeration[MathFCValue];

}
#endif // GED_MATH_FC_HIDDEN

#ifndef GED_MATH_MACRO_EXT_HIDDEN
const char* GED_GetMathMacroExtString(GED_MATH_MACRO_EXT MathMacroExtValue)
{
    return MathMacroExtEnumeration[MathMacroExtValue];

}
#endif // GED_MATH_MACRO_EXT_HIDDEN

#ifndef GED_MESSAGE_TYPE_HIDDEN
const char* GED_GetMessageTypeString(GED_MESSAGE_TYPE MessageTypeValue)
{
    return MessageTypeEnumeration[MessageTypeValue];

}
#endif // GED_MESSAGE_TYPE_HIDDEN

#ifndef GED_NO_SRC_DEP_SET_HIDDEN
const char* GED_GetNoSrcDepSetString(GED_NO_SRC_DEP_SET NoSrcDepSetValue)
{
    return NoSrcDepSetEnumeration[NoSrcDepSetValue];

}
#endif // GED_NO_SRC_DEP_SET_HIDDEN

#ifndef GED_OPCODE_HIDDEN
const char* GED_GetOpcodeString(GED_OPCODE OpcodeValue)
{
    return OpcodeEnumeration[OpcodeValue];

}
#endif // GED_OPCODE_HIDDEN

#ifndef GED_PRECISION_HIDDEN
const char* GED_GetPrecisionString(GED_PRECISION PrecisionValue)
{
    return PrecisionEnumeration[PrecisionValue];

}
#endif // GED_PRECISION_HIDDEN

#ifndef GED_PRED_CTRL_HIDDEN
const char* GED_GetPredCtrlString(GED_PRED_CTRL PredCtrlValue)
{
    return PredCtrlEnumeration[PredCtrlValue];

}
#endif // GED_PRED_CTRL_HIDDEN

#ifndef GED_PRED_INV_HIDDEN
const char* GED_GetPredInvString(GED_PRED_INV PredInvValue)
{
    return PredInvEnumeration[PredInvValue];

}
#endif // GED_PRED_INV_HIDDEN

#ifndef GED_REG_FILE_HIDDEN
const char* GED_GetRegFileString(GED_REG_FILE RegFileValue)
{
    return RegFileEnumeration[RegFileValue];

}
#endif // GED_REG_FILE_HIDDEN

#ifndef GED_REP_CTRL_HIDDEN
const char* GED_GetRepCtrlString(GED_REP_CTRL RepCtrlValue)
{
    return RepCtrlEnumeration[RepCtrlValue];

}
#endif // GED_REP_CTRL_HIDDEN

#ifndef GED_RETURN_DATA_CONTROL_HIDDEN
const char* GED_GetReturnDataControlString(GED_RETURN_DATA_CONTROL ReturnDataControlValue)
{
    return ReturnDataControlEnumeration[ReturnDataControlValue];

}
#endif // GED_RETURN_DATA_CONTROL_HIDDEN

#ifndef GED_ROUNDING_MODE_HIDDEN
const char* GED_GetRoundingModeString(GED_ROUNDING_MODE RoundingModeValue)
{
    return RoundingModeEnumeration[RoundingModeValue];

}
#endif // GED_ROUNDING_MODE_HIDDEN

#ifndef GED_SATURATE_HIDDEN
const char* GED_GetSaturateString(GED_SATURATE SaturateValue)
{
    return SaturateEnumeration[SaturateValue];

}
#endif // GED_SATURATE_HIDDEN

#ifndef GED_SFID_HIDDEN
const char* GED_GetSFIDString(GED_SFID SFIDValue)
{
    return SFIDEnumeration[SFIDValue];

}
#endif // GED_SFID_HIDDEN

#ifndef GED_SHUFFLE_FC_HIDDEN
const char* GED_GetShuffleFCString(GED_SHUFFLE_FC ShuffleFCValue)
{
    return ShuffleFCEnumeration[ShuffleFCValue];

}
#endif // GED_SHUFFLE_FC_HIDDEN

#ifndef GED_SIMDMODE_HIDDEN
const char* GED_GetSIMDModeString(GED_SIMDMODE SIMDModeValue)
{
    return SIMDModeEnumeration[SIMDModeValue];

}
#endif // GED_SIMDMODE_HIDDEN

#ifndef GED_SLOT_GROUP_HIDDEN
const char* GED_GetSlotGroupString(GED_SLOT_GROUP SlotGroupValue)
{
    return SlotGroupEnumeration[SlotGroupValue];

}
#endif // GED_SLOT_GROUP_HIDDEN

#ifndef GED_SRC_MOD_HIDDEN
const char* GED_GetSrcModString(GED_SRC_MOD SrcModValue)
{
    return SrcModEnumeration[SrcModValue];

}
#endif // GED_SRC_MOD_HIDDEN

#ifndef GED_SUB_BYTE_PRECISION_HIDDEN
const char* GED_GetSubBytePrecisionString(GED_SUB_BYTE_PRECISION SubBytePrecisionValue)
{
    return SubBytePrecisionEnumeration[SubBytePrecisionValue];

}
#endif // GED_SUB_BYTE_PRECISION_HIDDEN

#ifndef GED_SUB_FUNC_ID_HIDDEN
const char* GED_GetSubFuncIDString(GED_SUB_FUNC_ID SubFuncIDValue)
{
    return SubFuncIDEnumeration[SubFuncIDValue];

}
#endif // GED_SUB_FUNC_ID_HIDDEN

#ifndef GED_SWIZZLE_HIDDEN
const char* GED_GetSwizzleString(GED_SWIZZLE SwizzleValue)
{
    return SwizzleEnumeration[SwizzleValue];

}
#endif // GED_SWIZZLE_HIDDEN

#ifndef GED_SYNC_FC_HIDDEN
const char* GED_GetSyncFCString(GED_SYNC_FC SyncFCValue)
{
    return SyncFCEnumeration[SyncFCValue];

}
#endif // GED_SYNC_FC_HIDDEN

#ifndef GED_THREAD_CTRL_HIDDEN
const char* GED_GetThreadCtrlString(GED_THREAD_CTRL ThreadCtrlValue)
{
    return ThreadCtrlEnumeration[ThreadCtrlValue];

}
#endif // GED_THREAD_CTRL_HIDDEN
uint32_t GED_GetOperandWidth(const GED_DATA_TYPE datatype, const GED_MODEL modelId, GED_RETURN_VALUE* result)
{
    GED_RETURN_VALUE localResult = GED_RETURN_VALUE_INVALID_FIELD;
    if (NULL == result) result = &localResult;
    if ((uint32_t)GED_DATA_TYPE_INVALID <= (uint32_t)datatype)
    {
        *result = GED_RETURN_VALUE_INVALID_VALUE;
        return datatype;
    }
    return GEDInterpreter::ReinterpretEnum(datatype, 0, modelId, *result);
}
uint32_t GED_GetOperandNumericType(const GED_DATA_TYPE datatype, const GED_MODEL modelId, GED_RETURN_VALUE* result)
{
    GED_RETURN_VALUE localResult = GED_RETURN_VALUE_INVALID_FIELD;
    if (NULL == result) result = &localResult;
    if ((uint32_t)GED_DATA_TYPE_INVALID <= (uint32_t)datatype)
    {
        *result = GED_RETURN_VALUE_INVALID_VALUE;
        return datatype;
    }
    return GEDInterpreter::ReinterpretEnum(datatype, 1, modelId, *result);
}
uint32_t GED_GetNibCtrl(const GED_EXEC_MASK_OFFSET_CTRL execmaskoffsetctrl, const GED_MODEL modelId, GED_RETURN_VALUE* result)
{
    GED_RETURN_VALUE localResult = GED_RETURN_VALUE_INVALID_FIELD;
    if (NULL == result) result = &localResult;
    if ((uint32_t)GED_EXEC_MASK_OFFSET_CTRL_INVALID <= (uint32_t)execmaskoffsetctrl)
    {
        *result = GED_RETURN_VALUE_INVALID_VALUE;
        return execmaskoffsetctrl;
    }
    return GEDInterpreter::ReinterpretEnum(execmaskoffsetctrl, 2, modelId, *result);
}
